-- MySQL dump 10.13  Distrib 8.0.29, for Linux (x86_64)
--
-- Host: localhost    Database: condor
-- ------------------------------------------------------
-- Server version	8.0.29-0ubuntu0.20.04.3

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `comments` mediumtext,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `patientID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastAccessed` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Work_Patient` (`patientID`,`ownerID`),
  CONSTRAINT `fk_Act_Patient` FOREIGN KEY (`patientID`) REFERENCES `condor_patient_local`.`Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES (662,'0c1ed331-8df6-482e-8dd1-508d9b190c49','27/09/21','2021-09-27 12:10:27','',1,1,'fee63978-1be9-4cfc-a80c-44dc3616eb33','','',NULL,'2021-09-27 13:56:34','2021-09-27 13:56:51','2021-09-27 11:56:51','2021-09-27 13:56:51'),(662,'100a15d0-4590-4544-9331-365a087a5b57','bouchm','2020-04-29 14:25:45','',1,5,'406a8572-4b0f-480a-ad2e-daf5530143b6','','',NULL,'2020-04-29 14:25:45','2020-04-29 14:50:38','2020-04-29 12:50:38','2020-04-29 14:50:36'),(662,'129a6c33-3cca-43ab-b97a-56d0e82a546f','02/11/22','2022-11-02 12:11:46','',1,3,'fee63978-1be9-4cfc-a80c-44dc3616eb33','','',NULL,'2022-11-02 18:39:29','2022-11-02 18:39:35','2022-11-02 17:39:35','2022-11-02 13:56:17'),(662,'1716bd86-ee5e-4929-9e79-3beba5199c80','10/06/22','2022-06-10 19:55:01','',1,1,'4b9236e1-8988-4a19-97af-cd44133ee27b','','',NULL,'2022-06-10 19:55:01','2022-06-27 21:27:05','2022-06-27 19:27:05','2022-06-10 19:55:01'),(662,'1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e','empreinte','2022-09-19 10:52:05','',1,1,'3d722760-3820-40e4-81e1-60e722c0cb01','','',NULL,'2022-09-19 14:31:38','2022-09-19 15:19:18','2022-09-19 13:19:18','2022-09-19 15:19:17'),(662,'1ce80886-d3f3-42d8-872a-a2eba69d0005','mand','2020-04-15 06:59:48','',1,2,'1af643c4-44fe-4ccb-b545-dbc90b47633b','','','2020-04-16 10:41:22','2020-04-16 07:18:40','2020-04-16 10:41:22','2020-04-16 08:41:22','2020-04-16 10:40:40'),(662,'2a050d02-7424-4099-b1d0-2d7da678e690','14/12/22','2022-11-04 13:31:18','',1,5,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','','',NULL,'2022-12-14 17:38:25','2022-12-14 17:39:33','2022-12-14 16:39:33','2022-12-14 17:39:33'),(662,'2c78d514-95bd-4529-b0a1-babfb83849b1','11/01/2023','2023-01-11 12:11:32','',1,7,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','','',NULL,'2023-01-11 13:02:10','2023-01-11 13:45:25','2023-01-11 12:45:25','2023-01-11 13:45:24'),(662,'2e7abd17-bdd5-4ead-9751-b6d90fb9e0ea','empreinte','2021-04-25 11:19:29','',1,1,'507b1d43-2b21-4296-a969-0a1223d5706d','','',NULL,'2021-04-25 11:19:29','2021-06-08 19:42:50','2021-06-08 17:42:50','2021-04-25 11:28:19'),(662,'3d2141bb-462c-4334-b177-d17d136574ae','22/11/21','2021-11-22 12:11:00','',1,1,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','','',NULL,'2021-11-22 12:11:00','2021-11-22 12:51:18','2021-11-22 11:51:18','2021-11-22 12:51:17'),(662,'3eede325-0afb-43f5-9277-e22c18f8f927','06/08/22','2022-08-06 13:43:31','',1,2,'5587321c-4405-49dc-90d5-8810cc776c6d','','',NULL,'2022-08-06 13:43:31','2022-08-06 13:59:26','2022-08-06 11:59:26','2022-08-06 13:59:25'),(662,'47a8d99f-668b-4bb6-b3bf-7bff221d397f','16/04/20','2020-04-16 10:42:09','',1,3,'1af643c4-44fe-4ccb-b545-dbc90b47633b','','','2020-04-16 10:43:17','2020-04-16 10:42:09','2020-04-16 10:43:17','2020-04-16 08:43:17','2020-04-16 10:42:21'),(662,'586a7c87-5d8a-440f-a654-c452dc908844','21/03/23','2023-03-21 12:06:40','',1,4,'fee63978-1be9-4cfc-a80c-44dc3616eb33','','',NULL,'2023-03-21 12:33:01','2023-03-21 12:33:02','2023-03-21 11:33:02','2023-03-21 12:28:13'),(662,'647287de-fb34-4f94-83ef-40f59da2edb3','','2020-04-17 07:55:09','',1,1,'d485e5a2-11e0-4863-b612-22d245d07d04','','','2020-04-17 07:55:14','2020-04-17 07:55:09','2020-04-17 07:55:14','2020-04-17 05:55:14','2020-04-17 07:55:09'),(662,'64834083-3320-4687-9710-c2be0d9c7198','ATM','2020-04-30 19:09:00','',1,1,'b8f0b748-12f3-4798-9d93-1a7a89f0e0e1','','',NULL,'2020-05-04 12:02:55','2020-05-04 12:02:56','2020-05-04 10:02:56','2020-05-04 12:01:03'),(662,'72b7a457-e38f-4535-8eba-6c98b43e5e55','08/06/21','2021-06-08 19:43:08','',1,2,'f15cb858-4f0b-44ec-a017-5e662039ba19','','',NULL,'2021-06-08 20:40:48','2021-06-08 20:57:52','2021-06-08 18:57:52','2021-06-08 20:57:52'),(662,'72c58d79-1141-4c63-b343-909886db5520','2 vb','2020-04-27 16:14:03','',1,4,'406a8572-4b0f-480a-ad2e-daf5530143b6','','','2020-04-27 16:49:47','2020-04-27 16:14:03','2020-04-27 16:49:47','2020-04-27 14:49:47','2020-04-27 16:48:57'),(662,'73abb1bd-08d2-44e7-866f-eeb3e4b59703','','2020-04-06 09:37:03','',1,1,'3c7b9483-14ba-422a-b943-e347249b6653','','','2020-04-06 11:11:19','2020-04-06 09:37:03','2020-04-06 11:11:19','2020-04-06 09:11:19','2020-04-06 09:37:03'),(662,'76dcd1f0-f6c7-480f-b07b-441679345d70','16/02/21','2021-02-16 10:48:19','',1,1,'615ede1a-dba9-4251-9e9e-6cbbd3041fdc','','',NULL,'2021-02-16 10:48:19','2021-02-16 13:05:30','2021-02-16 12:05:30','2021-02-16 13:05:30'),(662,'7813c59a-91e7-4c2c-8027-bcc3c35c797c','BATAILLE 1','2020-04-06 11:13:09','',1,1,'406a8572-4b0f-480a-ad2e-daf5530143b6','','',NULL,'2020-04-13 07:57:25','2020-04-13 07:57:26','2020-04-13 05:57:26','2020-04-08 08:51:36'),(662,'7841125a-11dd-4b66-9179-cd371ea2f0f7','11/01/22','2022-01-11 12:05:43','',1,1,'e27b6130-520e-4c5b-8e6b-5e82a8c5a273','','',NULL,'2022-01-11 12:05:43','2022-01-11 12:41:55','2022-01-11 11:41:55','2022-01-11 12:41:54'),(662,'78fbbe11-e1a5-4c10-b6e3-4f00df178dc6','max','2020-04-14 11:34:34','',1,1,'1af643c4-44fe-4ccb-b545-dbc90b47633b','','','2020-04-16 07:18:36','2020-04-16 07:18:21','2020-04-16 07:18:36','2020-04-16 05:18:36','2020-04-16 07:16:43'),(662,'7e359a5f-1756-4ec7-8657-3e5940ae489d','12/10/21','2021-10-12 12:13:29','',1,1,'5587321c-4405-49dc-90d5-8810cc776c6d','','',NULL,'2021-10-12 14:26:37','2021-10-12 14:26:57','2021-10-12 12:26:57','2021-10-12 14:26:57'),(662,'7f8fbc5c-3db7-4ee3-adcd-e76fc6f390b8','','2020-04-08 12:31:53','',1,1,'35970bab-04c1-443b-9e5c-c6a127ec7a47','','','2020-04-09 09:12:22','2020-04-08 12:31:53',NULL,'2020-04-09 07:12:22','2020-04-08 12:31:53'),(662,'801b987d-e335-4276-8bc6-1fa57b553716','2','2020-04-11 07:23:51','',1,2,'2b4f07b1-1d58-42a2-9e72-3461efd5a2d9','','',NULL,'2020-07-13 19:50:35','2020-07-13 19:51:13','2020-07-13 17:51:13','2020-07-13 19:51:13'),(662,'83306c87-ca0d-4ed2-b376-4227f586001f','1','2020-12-21 18:19:59','',1,1,'5cd08749-129b-49e3-85b9-abee157177a4','','',NULL,'2020-12-29 11:49:58','2020-12-29 11:57:41','2020-12-29 10:57:41','2020-12-29 11:41:50'),(662,'848b25bd-90a8-4105-871d-f9326fe94c7b','21/12/22','2022-12-21 11:45:05','',1,6,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','','',NULL,'2022-12-21 11:45:05','2022-12-21 12:15:15','2022-12-21 11:15:15','2022-12-21 12:15:13'),(662,'87965ef8-01eb-4830-8e8b-8b99ece62cf1','27/06/22','2022-06-27 20:27:17','',1,2,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','','',NULL,'2022-06-27 21:27:12','2022-06-27 21:28:37','2022-06-27 19:28:37','2022-06-27 21:28:36'),(662,'8f3d7d42-f6ad-4e48-8951-08222c212e7e','04/11/22','2022-11-04 12:12:28','',1,4,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','','',NULL,'2022-12-21 11:14:42','2022-12-21 11:14:55','2022-12-21 10:14:55','2022-11-04 13:30:46'),(662,'8f87b136-cb98-4706-b7d4-51059e1afa06','11/03/22','2022-03-11 09:55:04','',1,1,'665b40ce-9690-4944-b007-4a96c1f5d57d','','',NULL,'2022-03-11 11:19:13','2022-03-11 11:19:15','2022-03-11 10:19:15','2022-03-11 11:16:26'),(662,'934f20d2-7444-4367-89e2-61c3bf4bee57','1','2020-04-10 07:27:56','',1,1,'2b4f07b1-1d58-42a2-9e72-3461efd5a2d9','','',NULL,'2020-07-13 19:48:56','2020-07-13 19:49:37','2020-07-13 17:49:37','2020-07-13 19:49:36'),(662,'949fe730-88fa-4ec2-852e-dd0772ee3ee0','28/06/22','2022-06-28 20:03:39','',1,2,'fee63978-1be9-4cfc-a80c-44dc3616eb33','','',NULL,'2022-06-28 20:03:39','2022-06-28 20:40:19','2022-06-28 18:40:19','2022-06-28 20:40:18'),(662,'a6ab7edf-6040-4f1a-b898-a1120a854927','16/04/20','2020-04-16 10:43:49','',1,4,'1af643c4-44fe-4ccb-b545-dbc90b47633b','','',NULL,'2020-04-16 11:32:34','2020-04-16 11:35:45','2020-04-16 09:35:45','2020-04-16 11:35:43'),(662,'a7b0f1ae-ce37-4faf-9b3c-e5fab6996549','bouhm','2020-05-21 07:47:54','',1,6,'406a8572-4b0f-480a-ad2e-daf5530143b6','','',NULL,'2020-05-21 07:47:54','2020-05-21 08:13:18','2020-05-21 06:13:18','2020-05-21 08:13:15'),(662,'acce421f-f39c-414a-a216-6f01af8c33c4','','2022-06-10 20:22:14','',1,1,'53c591be-aea6-491f-bc06-740bd7d9f780','','','2022-06-10 20:22:21','2022-06-10 20:22:14',NULL,'2022-06-10 18:22:21','2022-06-10 20:22:14'),(662,'adf717e5-dc3f-47f0-9f8a-d13e0438f5cd','','2021-03-19 10:23:31','',1,1,'9977cfd4-497a-4153-ade7-6e67fc8f1938','','','2021-04-25 11:18:14','2021-03-19 10:23:31',NULL,'2021-04-25 09:18:14','2021-03-19 10:23:31'),(662,'b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c','29/12/20','2020-12-29 10:41:55','',1,4,'5cd08749-129b-49e3-85b9-abee157177a4','','',NULL,'2020-12-30 07:12:44','2020-12-30 07:12:45','2020-12-30 06:12:45','2020-12-29 12:09:26'),(662,'b498bdf4-2e5b-497a-8bfe-b65edabac3bc','23/11/21','2021-11-23 11:57:21','',1,1,'ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07','','',NULL,'2021-11-23 12:15:57','2021-11-23 12:24:10','2021-11-23 11:24:10','2021-11-23 12:24:09'),(662,'bb2e4d25-46eb-48d2-80af-41639e464a04','1','2020-04-10 07:52:35','',1,1,'5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda','','',NULL,'2020-04-17 07:55:22','2020-04-17 11:21:05','2020-04-17 09:21:05','2020-04-17 11:21:05'),(662,'bc967a6b-ad1a-4a59-aab8-92332e4217b0','13/07/20','2020-07-13 19:10:04','',1,3,'2b4f07b1-1d58-42a2-9e72-3461efd5a2d9','','',NULL,'2020-07-13 19:51:52','2020-07-13 19:51:52','2020-07-13 17:51:52','2020-07-13 19:47:48'),(662,'c42cadf5-5f0e-439e-9aab-087940794316','29/12/20','2020-12-29 08:32:55','',1,2,'5cd08749-129b-49e3-85b9-abee157177a4','','','2020-12-29 08:36:41','2020-12-29 08:36:23',NULL,'2020-12-29 07:36:41','2020-12-29 08:34:38'),(662,'c47ee4d9-c646-4836-8152-fc2ded70b4fe','01/02/21','2021-02-01 20:10:34','',1,1,'f15cb858-4f0b-44ec-a017-5e662039ba19','','',NULL,'2021-02-01 20:29:20','2021-02-01 21:24:09','2021-02-01 20:24:09','2021-02-01 21:24:09'),(662,'c584a5e1-b7d4-4486-abbc-954717a6fe55','empreintes','2020-09-09 19:35:42','',1,1,'555b020e-3e4a-4263-bf03-9f8db80cc843','','','2020-09-09 19:48:13','2020-09-09 19:35:42','2020-09-09 19:43:59','2020-09-09 17:48:13','2020-09-09 19:43:59'),(662,'c59a2f65-79fe-44cd-8377-e39aa0a44171','18/04/20','2020-04-18 08:57:39','',1,1,'d41de280-8cf3-4e57-893e-cc7a010bc864','','',NULL,'2020-04-18 08:57:39','2020-04-18 09:38:00','2020-04-18 07:38:00','2020-04-18 09:37:59'),(662,'c61cdb9c-543c-4809-952c-b65656e1f96f','empreinte','2020-07-08 18:05:41','',1,1,'94ac368a-c8ad-482d-91b4-26c8db10596d','','',NULL,'2020-07-08 18:05:41','2020-07-13 19:07:32','2020-07-13 17:07:32','2020-07-08 19:59:48'),(662,'c983b946-e304-49a8-99c8-24eaca67b9ce','11/04/23','2023-04-11 19:34:32','',1,8,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','','',NULL,'2023-04-11 20:56:09',NULL,'2023-04-11 18:56:09','2023-04-11 20:49:14'),(662,'cb9d8495-b4dd-423f-a624-7cff70e4db55','BATAILLE 2','2020-04-06 12:22:59','',1,2,'406a8572-4b0f-480a-ad2e-daf5530143b6','','','2020-04-14 11:25:03','2020-04-13 07:58:19','2020-04-14 11:25:03','2020-04-14 09:25:03','2020-04-14 11:24:28'),(662,'d458682a-423b-43fe-a4b0-97d586104341','09/04/20','2020-04-09 09:16:47','',1,1,'f61dd82a-2e03-48b9-8ab4-0840b811de63','','','2020-04-10 09:22:06','2020-04-09 09:16:47','2020-04-09 11:05:44','2020-04-10 07:22:06','2020-04-09 11:05:43'),(662,'e43c8099-0862-42c3-9ad2-1efef27b83ba','14/09/22','2022-09-14 12:00:27','',1,3,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','','',NULL,'2022-09-14 12:00:27','2022-09-14 12:24:54','2022-09-14 10:24:54','2022-09-14 12:24:53'),(662,'ec084612-67a2-4430-ae15-7fe0edeaca64','3','2020-04-12 07:20:52','',1,3,'406a8572-4b0f-480a-ad2e-daf5530143b6','','','2020-04-27 16:49:26','2020-04-14 11:25:05','2020-04-27 16:49:26','2020-04-27 14:49:26','2020-04-27 16:12:55'),(662,'f474819e-9470-4612-8275-2ceb25b5522f','SMILERS','2021-02-27 09:56:53','',1,1,'03ec19f1-9f11-4710-a0cd-c5d7739e40d7','','',NULL,'2021-02-27 09:56:53','2021-02-27 10:59:19','2021-02-27 09:59:19','2021-02-27 10:59:19'),(662,'f60bef39-641f-45a5-835c-4e84590668e4','A','2020-12-29 08:43:21','',1,3,'5cd08749-129b-49e3-85b9-abee157177a4','','',NULL,'2020-12-29 08:43:21','2020-12-29 11:57:41','2020-12-29 10:57:41','2020-12-29 08:48:30');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `line_0` varchar(255) DEFAULT NULL,
  `line_1` varchar(255) DEFAULT NULL,
  `line_2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('00000001-0000-0000-0000-000000000001','Labege','','',NULL,'Labege','','31670','France',NULL,NULL,'2022-06-27 19:16:28'),('00000002-0000-0000-0000-000000000001','137 rue garance','','',NULL,'LABEGE','','31670','France',NULL,NULL,'2022-06-27 19:16:28'),('00000003-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labège','','31670','France',NULL,NULL,'2022-06-27 19:16:28'),('00000005-0000-0000-0000-000000000001','','','',NULL,'HOENHEIM','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000006-0000-0000-0000-000000000001','','','',NULL,'Marseille','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000007-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000008-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000009-0000-0000-0000-000000000001','','','',NULL,'Villiers Sur Marne','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000059-0000-0000-0000-000000000001','','','',NULL,'LE TEIL','','','France',NULL,NULL,'2022-06-27 19:16:28'),('00000155-0000-0000-0000-000000000001','','','',NULL,'ECOUFLANT','','','France',NULL,NULL,'2022-06-27 19:16:28'),('00000172-0000-0000-0000-000000000001','4 Chemin Couralis','','',NULL,'LAROIN','','64110','France',NULL,NULL,'2022-06-27 19:16:28'),('00000193-0000-0000-0000-000000000001','','','',NULL,'VIRIAT ','','','France',NULL,NULL,'2022-06-27 19:16:28'),('00000224-0000-0000-0000-000000000001','','','',NULL,'CUGNAUX','','','France',NULL,NULL,'2022-06-27 19:16:28'),('00000317-0000-0000-0000-000000000001','','','',NULL,'LONGWY','','','France',NULL,NULL,'2022-06-27 19:16:28'),('00000339-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France',NULL,NULL,'2022-06-27 19:16:28'),('00000355-0000-0000-0000-000000000001','','','',NULL,'Parma','','','Italia',NULL,NULL,'2022-06-27 19:16:28'),('00000662-0000-0000-0000-000000000001','48 route d\'Eaunes','','',NULL,'MURET','','31600','France',NULL,NULL,'2022-03-31 17:40:19'),('00000663-0000-0000-0000-000000000001','','','',NULL,'Bruguieres ','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000689-0000-0000-0000-000000000001','','','',NULL,'CHAMBERY','','','France',NULL,NULL,'2022-03-31 17:40:19'),('74f9692b-a496-48ca-9002-1aa1e9b3b2e6','','','',NULL,'MURET','','','',NULL,NULL,'2022-09-19 13:16:49');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `credentialsID` char(36) DEFAULT NULL,
  `personInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `phoneInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `addressInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `officeID` char(36) DEFAULT NULL,
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `firstConnection` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `UNIQ_4068FE723D139428` (`personInfoID`),
  UNIQUE KEY `UNIQ_4068FE72627FFEF6` (`phoneInfoID`),
  UNIQUE KEY `UNIQ_4068FE72A680FCCC` (`addressInfoID`),
  KEY `fk_Assistant_Professional` (`ownerID`),
  KEY `fk_Assistant_Office` (`officeID`,`ownerID`),
  KEY `fk_Assistant_Credentials_idx` (`credentialsID`,`id`),
  KEY `fk_Assistant_PersonInfo_idx` (`personInfoID`),
  KEY `fk_Assistant_PhoneInfo_idx` (`phoneInfoID`),
  KEY `fk_Assistant_AddressInfo_idx` (`addressInfoID`),
  CONSTRAINT `fk_Assistant_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`),
  CONSTRAINT `fk_Assistant_Credentials` FOREIGN KEY (`credentialsID`) REFERENCES `Credentials` (`id`),
  CONSTRAINT `fk_Assistant_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`),
  CONSTRAINT `fk_Assistant_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Assistant_AFTER_DELETE` AFTER DELETE ON `Assistant` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo  WHERE ownerID = OLD.ownerID AND id = OLD.personInfoID;
	DELETE FROM AddressInfo WHERE ownerID = OLD.ownerID AND id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   WHERE ownerID = OLD.ownerID AND id = OLD.phoneInfoID;
	DELETE FROM Credentials WHERE ownerID = OLD.ownerID AND id = OLD.credentialsID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_circle_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_CircleOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_CircleOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_CircleOrderFile_CircleOrder` (`orderID`,`ownerID`),
  KEY `fk_CircleOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_CircleOrderFile_CircleOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `CircleOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CircleOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorFile`
--

DROP TABLE IF EXISTS `CondorFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `path` text NOT NULL,
  `type` varchar(250) NOT NULL,
  `tag` varchar(250) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `originalName` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT NULL,
  `originalID` char(36) NOT NULL,
  `version` mediumint NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `metadata` text,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_CondorFile_version` (`ownerID`,`originalID`,`version`),
  KEY `fk_CondorFile_Professional` (`ownerID`),
  KEY `fk_CondorFile_CondorFile` (`originalID`,`ownerID`),
  CONSTRAINT `fk_CondorFile_CondorFile` FOREIGN KEY (`originalID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CondorFile_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorFile`
--

LOCK TABLES `CondorFile` WRITE;
/*!40000 ALTER TABLE `CondorFile` DISABLE KEYS */;
INSERT INTO `CondorFile` VALUES (662,'03c11f7d-c2ac-42f2-8983-927ccff14074','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_a90158f7-0d39-4b9d-984b-57de06099c65/21_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_SNAPS_','2021-11-22 11:28:59','2021-11-22 12:25:53','21_w1_o1_maxillaire_snapshot_1.png','2021-11-22 12:28:59','SYNCED','2d1d8d21-ec2c-485d-98af-375a4d8263d6',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'04758fa4-84c5-4d84-a8c3-6b431275e3cd','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_919caf8c-919a-49cc-bf39-68486f2f5991/6_w1_o2_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_FRSC_919caf8c-919a-49cc-bf39-68486f2f5991_SNAPS_','2020-12-29 10:57:35','2020-04-17 11:19:52','6_w1_o2_mordu_anterieur_snapshot_0.png','2020-12-29 11:57:35','SYNCED','04758fa4-84c5-4d84-a8c3-6b431275e3cd',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.6.1.2.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}'),(662,'048d66fa-42fe-4d07-8e9c-1a8a30ce1fb4','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_57e7671e-1671-4ee9-96a0-650a56963aa8/16_w1_o1_mordu_anterieur_scan_file_0.ply','PLY','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_FRSC_57e7671e-1671-4ee9-96a0-650a56963aa8_PLY_','2021-02-27 09:59:47','2021-02-27 10:58:59','16_w1_o1_mordu_anterieur_scan_file_0.ply','2021-02-27 10:59:47','SYNCED','048d66fa-42fe-4d07-8e9c-1a8a30ce1fb4',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.16.1.1.1\",\"modelMatrix\":\"0.759878,0.0402714,0.654032,0,0.0273178,1.00051,-0.0364692,0,-0.65159,0.0088182,0.755605,0,12.4166,-4.86003,-30.4056,1\",\"title\":\"Mordu anterieur PLY\"}'),(662,'04955796-a392-49c6-b40d-fba48ef36844','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_ZIP_','2022-06-27 19:33:35','2022-06-27 20:56:02','21_w2_o1_mandibule_scan_file_2.zip','2022-06-27 21:33:35','SYNCED','1f29b918-27fd-422b-b4dd-da18687d0871',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"modelMatrix\":\"-0.937572,-0.337894,0.0823816,0,0.347791,-0.91089,0.222083,0,5.10791e-09,0.236871,0.971541,0,8.50708,12.7259,-21.225,1\",\"title\":\"Mandibule ZIP\"}'),(662,'0518a0de-5961-461c-b3cf-2ee702ed7107','','PLY','PATIENT_94ac368a-c8ad-482d-91b4-26c8db10596d_ACT_c61cdb9c-543c-4809-952c-b65656e1f96f_SESS_53a17fdc-5de8-45aa-a9cb-ebea4886f6ff_TOSC_6445b6e3-0c4a-44d3-84e8-7f315911b8ee_PLY_','2020-12-15 14:15:23','2020-07-08 19:54:05','',NULL,'CREATED','0518a0de-5961-461c-b3cf-2ee702ed7107',0,'2020-07-08 19:59:48','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.11.1.1.2\",\"modelMatrix\":\"0.93271,-0.345352,0.103846,0,0.360627,0.893202,-0.268583,0,-7.74521e-9,0.28796,0.957642,0,-10.9791,-23.8504,-21.6868,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'06da4522-e34d-40fd-b96f-ca51c40618cc','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_scan_file_5.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_ZIP_','2023-01-11 12:47:43','2023-01-11 12:58:29','21_w7_o1_mandibule_scan_file_5.zip','2023-01-11 13:47:43','SYNCED','097b9793-f270-498e-9cfe-cf6bc2963744',5,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"modelMatrix\":\"0.945306,0.320976,-0.0580515,0,-0.326184,0.930215,-0.168238,0,-4.4664e-09,0.177972,0.984036,0,-19.5184,-20.4309,-20.5509,1\",\"title\":\"Mandibule ZIP\"}'),(662,'06e08af9-0736-40b6-93e5-bdffccb8ea44','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_snapshot_4.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_SNAPS_','2022-06-28 18:40:57','2022-06-28 20:39:39','19_w2_o1_maxillaire_snapshot_4.png','2022-06-28 20:40:57','SYNCED','d40f4bba-69b0-4cc6-b541-e69c16b2b3d5',4,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'07615b33-5390-4fe1-9fbb-9ec7cbd64d40','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_793e84ce-b088-458d-82f5-33fab1f5e7de/23_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_TOSC_793e84ce-b088-458d-82f5-33fab1f5e7de_ZIP_','2022-01-11 11:25:44','2022-01-11 12:23:20','23_w1_o1_maxillaire_scan_file_1.zip','2022-01-11 12:25:44','SYNCED','b03f52b8-54fa-4f11-9899-22d57d5b6ebc',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"modelMatrix\":\"-0.991214,-0.131706,0.0122187,0,0.132271,-0.986975,0.091564,0,1.89443e-11,0.0923757,0.995724,0,20.0589,-14.9599,-19.872,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'0890ccd8-08ca-4b8f-8bea-3e38e4c1e0a0','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_2bf301a3-b61c-4ddd-b6a2-4924c804d5f8/6_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_LESC_2bf301a3-b61c-4ddd-b6a2-4924c804d5f8_PLY_','2020-12-29 10:57:36','2020-04-10 11:51:26','6_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','2020-12-29 11:57:36','SYNCED','0890ccd8-08ca-4b8f-8bea-3e38e4c1e0a0',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.6.1.1.3\",\"modelMatrix\":\"-0.993229,-0.0971881,-0.0599364,0,0.108709,-0.966401,-0.232048,0,-0.0414211,-0.237961,0.970874,0,-7.33842,7.95332,-24.3761,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}'),(662,'09549052-25f2-4ebe-8844-ee815b650573','','JSON','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_PROST_fce8aef9-22f3-446a-bd23-7f6a283417dc_JSON_','2020-04-29 12:25:18','2020-04-12 08:28:40','','2020-04-29 14:25:18','SYNCED','09549052-25f2-4ebe-8844-ee815b650573',0,'2020-04-29 14:25:18','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.2.3.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre JSON\"}'),(662,'097b9793-f270-498e-9cfe-cf6bc2963744','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_ZIP_','2023-01-11 11:22:56','2023-01-11 12:21:45','21_w7_o1_mandibule_scan_file_0.zip','2023-01-11 12:22:56','SYNCED','097b9793-f270-498e-9cfe-cf6bc2963744',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"modelMatrix\":\"0.998737,-0.0493703,0.00928815,0,0.0502364,0.981519,-0.184655,0,-8.30368e-10,0.184889,0.982759,0,-24.228,-12.6955,-21.6513,1\",\"title\":\"Mandibule ZIP\"}'),(662,'0a02b656-9179-4cbd-ae14-079f4f933517','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_a6d52fce-2e61-4375-bf6d-a36f9b3eb72f/20_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_LESC_a6d52fce-2e61-4375-bf6d-a36f9b3eb72f_ZIP_','2021-10-12 12:35:19','2021-10-12 12:42:39','20_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2021-10-12 14:35:19','SYNCED','0a02b656-9179-4cbd-ae14-079f4f933517',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.20.1.1.1\",\"modelMatrix\":\"-0.977596,0.0140003,0.205991,0,-0.0046974,-0.995393,0.111045,0,0.210767,0.0965222,0.972336,0,6.11013,-4.18404,-18.0488,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(662,'0a6907bf-e8ec-4b7b-9dd9-8f5cf9bf83d8','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/smilersorder_bc0a9e7a-61d4-416f-99e7-00ae8838c1af/21_w1_smilers_file_0.json','JSON','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_PROST_bc0a9e7a-61d4-416f-99e7-00ae8838c1af_JSON_','2021-11-22 11:51:22','2021-11-22 12:51:17','21_w1_smilers_file_0.json','2021-11-22 12:51:22','SYNCED','0a6907bf-e8ec-4b7b-9dd9-8f5cf9bf83d8',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'0abfe6c8-8321-4681-9ffd-944418ed370c','','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7_SNAPS_','2020-12-29 10:57:35','2020-04-15 07:39:22','','2020-12-29 11:57:35','SYNCED','0abfe6c8-8321-4681-9ffd-944418ed370c',0,'2020-12-29 11:57:35','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}'),(662,'0b4e8e31-bd54-4394-8ebc-2c2d30d84197','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_d9ec0349-f28e-41d6-822f-e76c8c001da9/16_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_TOSC_d9ec0349-f28e-41d6-822f-e76c8c001da9_PLY_','2021-02-27 09:23:43','2021-02-27 10:22:30','16_w1_o1_maxillaire_scan_file_0.ply','2021-02-27 10:23:43','SYNCED','0b4e8e31-bd54-4394-8ebc-2c2d30d84197',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.16.1.1.1\",\"modelMatrix\":\"-0.986529,0.151424,-0.0618949,0,-0.163586,-0.913188,0.373267,0,-2.59407e-9,0.378363,0.925657,0,6.69957,-22.8624,-18.3363,1\",\"title\":\"Maxillaire PLY\"}'),(662,'0cac8ddd-0fbb-4d05-98b1-9dbfe53318c8','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_SNAPS_','2023-01-11 11:30:33','2023-01-11 12:25:55','21_w7_o1_mandibule_snapshot_1.png','2023-01-11 12:30:33','SYNCED','252b180c-565f-4f14-af48-a16cebbead9e',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'0cbb67d8-7a5d-43de-a85a-8ad3ddf2e2cb','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_8f3d7d42-f6ad-4e48-8951-08222c212e7e/occlusion_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2/scan_2a466f6b-3960-4b1b-bb27-def76229cccc/21_w4_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_BOSC_2a466f6b-3960-4b1b-bb27-def76229cccc_SNAPS_','2022-11-04 11:40:10','2022-11-04 12:27:19','21_w4_o1_mandibule_snapshot_0.png','2022-11-04 12:40:10','SYNCED','0cbb67d8-7a5d-43de-a85a-8ad3ddf2e2cb',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.4.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'0e855e55-dc7f-4eaf-91bd-933232cae95e','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_00f07cdc-1834-4ae1-a9fa-47699828c094/20_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_RISC_00f07cdc-1834-4ae1-a9fa-47699828c094_ZIP_','2021-10-12 12:34:20','2021-10-12 12:40:26','20_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2021-10-12 14:34:20','SYNCED','0e855e55-dc7f-4eaf-91bd-933232cae95e',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.20.1.1.1\",\"modelMatrix\":\"0.977044,0.023574,0.212257,0,-0.0393808,0.997586,0.0676487,0,-0.209382,-0.0658891,0.974905,0,3.82768,-0.972126,-16.0009,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(662,'0f7ff11f-44bc-45a5-bfc7-a7ac0da258f5','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_437ef945-eb42-4841-9b20-34804bd5cfd6/14_w2_o1_mandibule_scan_file_1.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_BOSC_437ef945-eb42-4841-9b20-34804bd5cfd6_PLY_','2021-06-08 18:47:40','2021-06-08 20:46:38','14_w2_o1_mandibule_scan_file_1.ply','2021-06-08 20:47:40','SYNCED','ff42f199-4210-43da-bfae-3dc172610fff',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.14.2.1.2\",\"modelMatrix\":\"-0.381739,0.817021,-0.432148,0,-0.92427,-0.337443,0.178484,0,-6.90106e-11,0.467556,0.883963,0,3.91985,-9.2919,-16.9777,1\",\"title\":\"Mandibule PLY\"}'),(662,'0fd33c57-ea90-4557-bed0-d59a4b5f2c80','','PDF','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_PROST_083f4c03-5580-45f2-9229-c3b06c40bbe2_PDF_','2020-04-17 05:54:31','2020-04-15 08:27:54','','2020-04-17 07:54:31','SYNCED','0fd33c57-ea90-4557-bed0-d59a4b5f2c80',0,'2020-04-17 07:54:31','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"ODF 1.7.2.1 ODF\",\"title\":\"Odf PDF\"}'),(662,'102a1df9-b0fe-46c3-b1b6-edddfb8c021b','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_ae899af8-7040-48c9-a9b2-6ebc255ac7c9/15_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_TOSC_ae899af8-7040-48c9-a9b2-6ebc255ac7c9_SNAPS_','2021-02-16 11:19:23','2021-02-16 12:19:19','15_w1_o1_maxillaire_snapshot_0.png','2021-02-16 12:19:23','SYNCED','102a1df9-b0fe-46c3-b1b6-edddfb8c021b',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.15.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'110bfb15-3589-48ab-bb80-e339d042b64d','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_e43c8099-0862-42c3-9ad2-1efef27b83ba/occlusion_09f15124-6bba-4565-bfe4-efb3c6c3a17d/scan_3a315f7b-8cf2-4d0c-bf92-fecb623fe530/21_w3_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_e43c8099-0862-42c3-9ad2-1efef27b83ba_SESS_09f15124-6bba-4565-bfe4-efb3c6c3a17d_TOSC_3a315f7b-8cf2-4d0c-bf92-fecb623fe530_ZIP_','2022-09-14 10:21:28','2022-09-14 12:19:53','21_w3_o1_maxillaire_scan_file_0.zip','2022-09-14 12:21:28','SYNCED','110bfb15-3589-48ab-bb80-e339d042b64d',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.3.1.1\",\"modelMatrix\":\"0.7863,0.612786,-0.0789043,0,-0.617845,0.779862,-0.100417,0,-2.25538e-09,0.127709,0.991812,0,-23.6196,-16.0226,-21.1675,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'11798976-f244-45ce-883c-778a6a2a0bc3','','JSON','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_PROST_083f4c03-5580-45f2-9229-c3b06c40bbe2_JSON_','2020-04-17 05:54:32','2020-04-15 08:27:54','','2020-04-17 07:54:32','SYNCED','11798976-f244-45ce-883c-778a6a2a0bc3',0,'2020-04-17 07:54:32','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"ODF 1.7.2.1 ODF\",\"title\":\"Odf JSON\"}'),(662,'118f4b39-1c4d-49d5-9470-979ae78a94eb','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_a26f0d58-ca46-4921-a9e1-9c39b7f89783/13_w4_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_TOSC_a26f0d58-ca46-4921-a9e1-9c39b7f89783_SNAPS_','2020-12-30 06:12:47','2020-12-29 11:05:41','13_w4_o1_maxillaire_snapshot_1.png','2020-12-30 07:12:47','SYNCED','24c23cdd-d323-4623-8a9d-2d3e14f3b937',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.13.4.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'11dc5cec-d45b-455d-8577-dcf502967a94','','SNAPS','PATIENT_f61dd82a-2e03-48b9-8ab4-0840b811de63_ACT_d458682a-423b-43fe-a4b0-97d586104341_SESS_4af4bd2d-76e3-4905-99fd-191c4cc669fa_TOSC_f2b8c151-b863-4411-b17a-b987ca58ee6f_SNAPS_','2020-12-29 10:57:35','2020-04-09 10:56:37','','2020-12-29 11:57:35','SYNCED','11dc5cec-d45b-455d-8577-dcf502967a94',0,'2020-12-29 11:57:35','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.4.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'127e55bb-48e6-421e-ab6a-05b0763a843e','','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_PLY_','2020-12-29 10:57:36','2020-04-15 07:13:11','','2020-12-29 11:57:36','SYNCED','127e55bb-48e6-421e-ab6a-05b0763a843e',0,'2020-12-29 11:57:36','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule Occlusion 1.7.2.2\",\"modelMatrix\":\"0.562893,-0.81608,0.131019,0,0.82653,0.555776,-0.0892277,0,-4.59721e-11,0.158516,0.987356,0,6.06834,14.8211,-40.9787,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'13991d0c-102a-4df8-aaad-f5f422edc6be','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_98e7c216-5bb9-4127-9497-834796980370/22_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_TOSC_98e7c216-5bb9-4127-9497-834796980370_ZIP_','2021-11-23 11:10:37','2021-11-23 12:08:22','22_w1_o1_maxillaire_scan_file_0.zip','2021-11-23 12:10:37','SYNCED','13991d0c-102a-4df8-aaad-f5f422edc6be',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.22.1.1.1\",\"modelMatrix\":\"-0.984254,0.164681,-0.0642138,0,-0.176758,-0.917007,0.357567,0,1.66597e-9,0.363287,0.931677,0,24.4804,-16.7011,-23.2991,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'13fa1125-c9d0-498d-bc50-68dc9f4f1beb','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_be9a4ba5-715b-4547-a31d-66621ec7b17f/14_w2_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_TOSC_be9a4ba5-715b-4547-a31d-66621ec7b17f_SNAPS_','2021-06-08 18:11:23','2021-06-08 20:11:20','14_w2_o1_maxillaire_snapshot_0.png','2021-06-08 20:11:23','SYNCED','13fa1125-c9d0-498d-bc50-68dc9f4f1beb',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'14360249-ed21-4853-8b15-1d0883516209','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_8f3d7d42-f6ad-4e48-8951-08222c212e7e/smilersorder_d151be06-8a97-48d0-9abe-2095c6c410c7/21_w4_smilers_file_0.json','JSON','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_PROST_d151be06-8a97-48d0-9abe-2095c6c410c7_JSON_','2022-11-04 11:39:04','2022-11-04 12:37:20','21_w4_smilers_file_0.json','2022-11-04 12:39:04','SYNCED','14360249-ed21-4853-8b15-1d0883516209',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'144ce692-0397-4de4-aa07-e50e85b5a553','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/occlusion_f2e73640-aebd-4bb1-9b02-c0504556ac5a/scan_e7efed59-e33c-4194-94c1-3507350dcfb5/5_w3_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_SESS_f2e73640-aebd-4bb1-9b02-c0504556ac5a_TOSC_e7efed59-e33c-4194-94c1-3507350dcfb5_SNAPS_','2020-12-29 10:57:36','2020-07-13 19:39:11','5_w3_o1_maxillaire_snapshot_2.png','2020-12-29 11:57:36','SYNCED','b94c36ee-0e86-44b0-a152-b92997bdab17',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.5.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'14c0bac1-16fe-41ce-863b-85ffd35f41e9','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_848b25bd-90a8-4105-871d-f9326fe94c7b/occlusion_ba7da56a-5a10-4378-a887-8e98aa892a3c/scan_b002027b-930d-4b96-a687-453aeea5659e/21_w6_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_848b25bd-90a8-4105-871d-f9326fe94c7b_SESS_ba7da56a-5a10-4378-a887-8e98aa892a3c_TOSC_b002027b-930d-4b96-a687-453aeea5659e_SNAPS_','2022-12-21 11:14:34','2022-12-21 12:09:24','21_w6_o1_maxillaire_snapshot_0.png','2022-12-21 12:14:34','SYNCED','14c0bac1-16fe-41ce-863b-85ffd35f41e9',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.6.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'156e5ba4-51dd-4631-932f-c91d8a7edef9','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_snapshot_5.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_SNAPS_','2021-02-01 19:52:06','2021-02-01 20:52:02','14_w1_o1_maxillaire_snapshot_5.png','2021-02-01 20:52:06','SYNCED','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb',5,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'160153e9-3248-4a6b-b0ff-a10c2c1acfc9','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_SNAPS_','2022-06-27 19:29:07','2022-06-27 20:48:28','21_w2_o1_mandibule_snapshot_0.png','2022-06-27 21:29:07','SYNCED','160153e9-3248-4a6b-b0ff-a10c2c1acfc9',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule SNAPSHOT\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'169331da-dbab-454e-828b-67287bb2feb7','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b5005e42-2d4d-41b0-91d5-667275f3a9cc/10_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_RISC_b5005e42-2d4d-41b0-91d5-667275f3a9cc_SNAPS_','2020-12-29 10:57:37','2020-04-30 20:00:05','10_w1_o1_mordu_posterieur_droit_snapshot_0.png','2020-12-29 11:57:37','SYNCED','169331da-dbab-454e-828b-67287bb2feb7',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.10.1.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(662,'1712177a-2d33-429e-81ed-e58b3ec65c4d','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_c1232582-95fc-48dc-a9ee-826c0cbad106/22_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_RISC_c1232582-95fc-48dc-a9ee-826c0cbad106_SNAPS_','2021-11-23 11:19:11','2021-11-23 12:18:01','22_w1_o1_mordu_posterieur_droit_snapshot_0.png','2021-11-23 12:19:11','SYNCED','1712177a-2d33-429e-81ed-e58b3ec65c4d',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'176a7141-81b2-436e-bbb3-00ec6028c71b','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_8f3d7d42-f6ad-4e48-8951-08222c212e7e/occlusion_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2/scan_2a466f6b-3960-4b1b-bb27-def76229cccc/21_w4_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_BOSC_2a466f6b-3960-4b1b-bb27-def76229cccc_ZIP_','2022-11-04 11:39:02','2022-11-04 12:27:21','21_w4_o1_mandibule_scan_file_0.zip','2022-11-04 12:39:02','SYNCED','176a7141-81b2-436e-bbb3-00ec6028c71b',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.4.1.1\",\"modelMatrix\":\"-0.618598,0.77386,-0.135934,0,-0.785708,-0.609269,0.107022,0,-1.06395e-08,0.173008,0.98492,0,16.5648,-9.9754,-16.8903,1\",\"title\":\"Mandibule ZIP\"}'),(662,'185c4f85-4987-4fa1-9ca4-3c6b9e0373b7','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_26a765d3-8b92-4861-984a-bd9c8040209b/25_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_BOSC_26a765d3-8b92-4861-984a-bd9c8040209b_ZIP_','2022-03-11 09:32:39','2022-03-11 10:31:25','25_w1_o1_mandibule_scan_file_1.zip','2022-03-11 10:32:39','SYNCED','be04859c-f9ff-4a11-96c0-99dd77c8c98f',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"modelMatrix\":\"-0.0602949,0.978867,-0.195407,0,-0.998181,-0.0591282,0.0118035,0,4.93874e-10,0.195763,0.980651,0,13.6002,-10.7847,-19.7425,1\",\"title\":\"Mandibule ZIP\"}'),(662,'18d03d74-c9b0-446f-b896-0a9cda8f18ed','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/smilersorder_802bd1e1-3362-4d30-9362-8bdbbb6482d2/15_w1_smilers_file_0.json','JSON','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_PROST_802bd1e1-3362-4d30-9362-8bdbbb6482d2_JSON_','2021-02-16 12:05:37','2021-02-16 13:05:30','15_w1_smilers_file_0.json','2021-02-16 13:05:37','SYNCED','18d03d74-c9b0-446f-b896-0a9cda8f18ed',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'1920fbbf-3535-420d-92a8-85d1ffb87094','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/406a8572-4b0f-480a-ad2e-daf5530143b6/session_100a15d0-4590-4544-9331-365a087a5b57/occlusion_348477f7-c7a9-4bb3-8b28-3da592902286/scan_12f64013-f8aa-44bb-91e8-38c23737152b/2_w5_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_100a15d0-4590-4544-9331-365a087a5b57_SESS_348477f7-c7a9-4bb3-8b28-3da592902286_TOSC_12f64013-f8aa-44bb-91e8-38c23737152b_PLY_','2020-12-29 10:57:37','2020-04-29 14:50:36','2_w5_o1_maxillaire_scan_file_0.ply','2020-12-29 11:57:37','SYNCED','1920fbbf-3535-420d-92a8-85d1ffb87094',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.2.5.1.1\",\"modelMatrix\":\"0.998398,-0.0537142,0.01778,0,0.0565804,0.947822,-0.31374,0,8.28453e-10,0.314244,0.949342,0,-18.4283,-39.02,-23.5398,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'1ab759da-dceb-48e2-83be-326054416d3c','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/3d722760-3820-40e4-81e1-60e722c0cb01/session_1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e/order_7a0fe58a-64da-4011-982b-3db6bd950242/28_w1_autre_prost_file_1ab759da-dceb-48e2-83be-326054416d3c_0.pdf','PDF','PATIENT_3d722760-3820-40e4-81e1-60e722c0cb01_ACT_1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e_PROST_7a0fe58a-64da-4011-982b-3db6bd950242_PDF_','2022-09-19 13:19:18','2022-09-19 15:19:17','28_w1_autre_prost_file_1ab759da-dceb-48e2-83be-326054416d3c_0.pdf','2022-09-19 15:19:18','SYNCED','1ab759da-dceb-48e2-83be-326054416d3c',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"COMMANDE 1.28.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(662,'1b9e7359-42f9-45c8-9ddf-605c192e8a57','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_801b987d-e335-4276-8bc6-1fa57b553716/occlusion_1a616ac1-2ca3-4d23-ae5e-349558c26c37/scan_7fad3bba-f2b2-41ce-849b-756d995c0414/5_w2_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_801b987d-e335-4276-8bc6-1fa57b553716_SESS_1a616ac1-2ca3-4d23-ae5e-349558c26c37_TOSC_7fad3bba-f2b2-41ce-849b-756d995c0414_SNAPS_','2020-12-29 10:57:38','2020-04-11 07:49:58','5_w2_o1_maxillaire_snapshot_0.png','2020-12-29 11:57:38','SYNCED','1b9e7359-42f9-45c8-9ddf-605c192e8a57',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.5.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'1cc559c6-7d48-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1cc559c6-7d48-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_78636467-a73b-4270-8bc5-35a2664dec9d_BOSC_7f9aec2d-6246-4413-842d-78d2e0bddb1e_SNAPS_','2020-12-29 10:57:38','2020-04-12 07:48:40','1cc559c6-7d48-11ea-947d-226cec7cb58a.png','2020-12-29 11:57:38','SYNCED','1cc559c6-7d48-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.2.3.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'1cc71f0a-7d48-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1cc71f0a-7d48-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_78636467-a73b-4270-8bc5-35a2664dec9d_BOSC_7f9aec2d-6246-4413-842d-78d2e0bddb1e_PLY_','2020-12-29 10:57:38','2020-04-12 07:48:40','1cc71f0a-7d48-11ea-947d-226cec7cb58a.ply','2020-12-29 11:57:38','SYNCED','1cc71f0a-7d48-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.2.3.1.1\",\"modelMatrix\":\"0.752992,0.641783,-0.145319,0,-0.65803,0.7344,-0.166291,0,-1.17478e-9,0.22084,0.97531,0,-15.7633,9.54111,-26.582,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'1cf0bff8-7d48-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1cf0bff8-7d48-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_78636467-a73b-4270-8bc5-35a2664dec9d_BOSC_7f9aec2d-6246-4413-842d-78d2e0bddb1e_SNAPS_','2020-12-29 10:57:39','2020-04-12 07:48:40','1cf0bff8-7d48-11ea-947d-226cec7cb58a.png','2020-12-29 11:57:39','SYNCED','1cf0bff8-7d48-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.2.3.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'1cf2d4d9-7d48-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1cf2d4d9-7d48-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_78636467-a73b-4270-8bc5-35a2664dec9d_BOSC_7f9aec2d-6246-4413-842d-78d2e0bddb1e_PLY_','2020-12-29 10:57:39','2020-04-12 07:48:40','1cf2d4d9-7d48-11ea-947d-226cec7cb58a.ply','2020-12-29 11:57:39','SYNCED','1cf2d4d9-7d48-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.2.3.1.1\",\"modelMatrix\":\"0.752992,0.641783,-0.145319,0,-0.65803,0.7344,-0.166291,0,-1.17478e-9,0.22084,0.97531,0,-15.7633,9.54111,-26.582,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'1d1e9e19-7d48-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1d1e9e19-7d48-11ea-947d-226cec7cb58a.json','JSON','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_PROST_fce8aef9-22f3-446a-bd23-7f6a283417dc_JSON_','2020-04-13 05:32:15','2020-04-12 08:28:40','1d1e9e19-7d48-11ea-947d-226cec7cb58a.json','2020-04-13 07:32:15','SYNCED','1d1e9e19-7d48-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.2.3.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre JSON\"}'),(662,'1d20464f-7d48-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1d20464f-7d48-11ea-947d-226cec7cb58a.pdf','PDF','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_PROST_fce8aef9-22f3-446a-bd23-7f6a283417dc_PDF_','2020-04-13 05:32:15','2020-04-12 08:28:40','1d20464f-7d48-11ea-947d-226cec7cb58a.pdf','2020-04-13 07:32:15','SYNCED','1d20464f-7d48-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.2.3.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}'),(662,'1dcff310-7757-4ec2-a021-00ae9e80d224','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_3eede325-0afb-43f5-9277-e22c18f8f927/smilersorder_06c913e1-07d1-4a41-90a1-07f408f59737/20_w2_smilers_file_0.json','JSON','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_3eede325-0afb-43f5-9277-e22c18f8f927_PROST_06c913e1-07d1-4a41-90a1-07f408f59737_JSON_','2022-08-06 11:59:26','2022-08-06 13:59:26','20_w2_smilers_file_0.json','2022-08-06 13:59:26','SYNCED','1dcff310-7757-4ec2-a021-00ae9e80d224',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'1e115805-b191-4113-972e-a4489d95599a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_d4c7f3c5-155d-41ef-8665-852e89c5e017/16_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_RISC_d4c7f3c5-155d-41ef-8665-852e89c5e017_SNAPS_','2021-02-27 09:48:14','2021-02-27 10:48:13','16_w1_o1_mordu_posterieur_droit_snapshot_0.png','2021-02-27 10:48:14','SYNCED','1e115805-b191-4113-972e-a4489d95599a',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.16.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'1e3c210c-a983-4276-916c-6c49b0e64e1d','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_87a0a17a-c973-40c2-9d84-2392b0d62afb/10_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_TOSC_87a0a17a-c973-40c2-9d84-2392b0d62afb_SNAPS_','2020-12-29 10:57:40','2020-04-30 19:37:47','10_w1_o1_maxillaire_snapshot_1.png','2020-12-29 11:57:40','SYNCED','477bef20-19c4-472b-89d8-912285f5e534',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.10.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'1e41852a-1d94-44eb-90f9-b06c401ee8b7','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_ed495283-b756-4052-ba8b-5fe9f9b1f8be/19_w3_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_TOSC_ed495283-b756-4052-ba8b-5fe9f9b1f8be_ZIP_','2022-11-02 17:43:20','2022-11-02 12:30:09','19_w3_o1_maxillaire_scan_file_1.zip','2022-11-02 18:43:20','SYNCED','53ebdc66-a057-4dc0-8a89-3e9bc7e5d11d',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.3.1.1\",\"modelMatrix\":\"0.997618,-0.0632367,0.0275495,0,0.0689772,0.914593,-0.398449,0,-2.86851e-09,0.3994,0.916777,0,-21.303,5.53173,-20.191,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'1e553911-8121-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1e553911-8121-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_848b25bd-90a8-4105-871d-f9326fe94c7b_SESS_ba7da56a-5a10-4378-a887-8e98aa892a3c_TOSC_b002027b-930d-4b96-a687-453aeea5659e_ZIP_','2022-12-21 11:17:41','2022-12-21 12:14:32','1e553911-8121-11ed-a752-9ec33d03e6dd.zip','2022-12-21 12:17:41','SYNCED','1e553911-8121-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.21.6.1.1\",\"modelMatrix\":\"-0.98152,0.181469,-0.0607201,0,-0.191358,-0.930797,0.311448,0,-2.35099e-09,0.317312,0.948321,0,15.3508,-15.1772,-24.8569,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'1e57cf4d-8121-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1e57cf4d-8121-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_848b25bd-90a8-4105-871d-f9326fe94c7b_SESS_ba7da56a-5a10-4378-a887-8e98aa892a3c_TOSC_b002027b-930d-4b96-a687-453aeea5659e_SNAPS_','2022-12-21 11:17:49','2022-12-21 12:14:30','1e57cf4d-8121-11ed-a752-9ec33d03e6dd.png','2022-12-21 12:17:49','SYNCED','1e57cf4d-8121-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.21.6.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'1e81852e-fdc6-4523-9e33-47494d60d953','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_a93c6a8f-0c96-47ae-bc72-75a725946a5a/10_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_FRSC_a93c6a8f-0c96-47ae-bc72-75a725946a5a_SNAPS_','2020-12-29 10:57:40','2020-04-30 20:08:26','10_w1_o1_mordu_anterieur_snapshot_0.png','2020-12-29 11:57:40','SYNCED','1e81852e-fdc6-4523-9e33-47494d60d953',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.10.1.1.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}'),(662,'1e84d5d4-6768-4dde-a7cf-ca40a6d4261e','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_19627cd9-e6e6-4c6f-9a62-46d708ca49bc/16_w1_o1_mandibule_scan_file_0.ply','PLY','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_BOSC_19627cd9-e6e6-4c6f-9a62-46d708ca49bc_PLY_','2021-02-27 09:44:40','2021-02-27 10:43:29','16_w1_o1_mandibule_scan_file_0.ply','2021-02-27 10:44:40','SYNCED','1e84d5d4-6768-4dde-a7cf-ca40a6d4261e',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.16.1.1.1\",\"modelMatrix\":\"-0.991646,-0.117448,0.053323,0,0.128986,-0.902943,0.409947,0,-2.46916e-9,0.413401,0.910549,0,13.5221,0.587114,-23.5741,1\",\"title\":\"Mandibule PLY\"}'),(662,'1f02ce0a-9100-460e-987f-c2b91eda5ac1','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_934f20d2-7444-4367-89e2-61c3bf4bee57/occlusion_ada38401-e257-4f32-8319-c7a394ce4463/scan_375f8fb7-d198-4281-9948-bba81b98e824/5_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_934f20d2-7444-4367-89e2-61c3bf4bee57_SESS_ada38401-e257-4f32-8319-c7a394ce4463_TOSC_375f8fb7-d198-4281-9948-bba81b98e824_SNAPS_','2020-12-29 10:57:41','2020-04-10 07:44:49','5_w1_o1_maxillaire_snapshot_0.png','2020-12-29 11:57:41','SYNCED','1f02ce0a-9100-460e-987f-c2b91eda5ac1',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.5.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'1f154183-a975-4dfa-b4eb-fea963eb0d6c','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_f0b63e95-26e8-4213-a935-ca2c37ab36ba/23_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_BOSC_f0b63e95-26e8-4213-a935-ca2c37ab36ba_SNAPS_','2022-01-11 11:35:43','2022-01-11 12:31:09','23_w1_o1_mandibule_snapshot_0.png','2022-01-11 12:35:43','SYNCED','1f154183-a975-4dfa-b4eb-fea963eb0d6c',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'1f29b918-27fd-422b-b4dd-da18687d0871','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_ZIP_','2022-06-27 19:30:11','2022-06-27 20:48:30','21_w2_o1_mandibule_scan_file_0.zip','2022-06-27 21:30:11','SYNCED','1f29b918-27fd-422b-b4dd-da18687d0871',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"modelMatrix\":\"-0.986862,-0.158046,0.0335479,0,0.161567,-0.965353,0.204912,0,1.94036e-09,0.207641,0.978205,0,11.2897,10.9357,-20.1333,1\",\"title\":\"Mandibule ZIP\"}'),(662,'1f608503-4867-4253-a143-dd200e0ebe0a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_d52d9ce0-7fed-491c-a385-929e22fb07d5/10_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PLY','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_LESC_d52d9ce0-7fed-491c-a385-929e22fb07d5_PLY_','2020-12-29 10:57:41','2020-04-30 20:05:04','10_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','2020-12-29 11:57:41','SYNCED','1f608503-4867-4253-a143-dd200e0ebe0a',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.10.1.1.1\",\"modelMatrix\":\"-0.946697,-0.190841,0.259987,0,0.159057,-0.974311,-0.155988,0,0.280262,-0.120492,0.953019,0,-6.4606,0.717943,-18.6733,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}'),(662,'1f629ca9-f822-4a93-aecc-1e8473c82dd5','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/order_03969eb4-0bb5-4cae-92e8-5cf65689757e/10_w1_autre_prost_file_0.pdf','PDF','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_PROST_03969eb4-0bb5-4cae-92e8-5cf65689757e_PDF_','2020-05-01 06:23:31','2020-05-01 08:23:30','10_w1_autre_prost_file_0.pdf','2020-05-01 08:23:31','SYNCED','1f629ca9-f822-4a93-aecc-1e8473c82dd5',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.10.1.2 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}'),(662,'1f92b4ea-73e7-423b-8d75-46b280f139d9','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_437ef945-eb42-4841-9b20-34804bd5cfd6/14_w2_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_BOSC_437ef945-eb42-4841-9b20-34804bd5cfd6_SNAPS_','2021-06-08 18:38:12','2021-06-08 20:38:08','14_w2_o1_mandibule_snapshot_0.png','2021-06-08 20:38:12','SYNCED','1f92b4ea-73e7-423b-8d75-46b280f139d9',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.14.2.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'1fe4acd9-cda1-4289-bd11-70fec38115e5','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_44b8a221-3707-430b-bc84-cacca7bf7d8a/14_w2_o1_mordu_posterieur_gauche_scan_file_0.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_LESC_44b8a221-3707-430b-bc84-cacca7bf7d8a_PLY_','2021-06-08 18:52:17','2021-06-08 20:51:49','14_w2_o1_mordu_posterieur_gauche_scan_file_0.ply','2021-06-08 20:52:17','SYNCED','1fe4acd9-cda1-4289-bd11-70fec38115e5',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.14.2.1.1\",\"modelMatrix\":\"-0.941444,-0.248278,0.234058,0,0.235207,-0.968666,-0.0644604,0,0.241612,-0.0086103,0.970092,0,-7.55676,1.35799,-18.282,1\",\"title\":\"Mordu posterieur gauche PLY\"}'),(662,'20195b26-5345-4f9f-bbd5-4e2ac9fd972d','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_881d38cc-cf89-4329-8456-b90f8c997725/20_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_FRSC_881d38cc-cf89-4329-8456-b90f8c997725_SNAPS_','2021-10-12 12:35:19','2021-10-12 12:44:16','20_w1_o1_mordu_anterieur_snapshot_0.png','2021-10-12 14:35:19','SYNCED','20195b26-5345-4f9f-bbd5-4e2ac9fd972d',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.20.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'20926382-91ae-11ed-a752-9ec33d03e6dd','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/20926382-91ae-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_ZIP_','2023-01-11 12:47:43','2023-01-11 12:58:29','20926382-91ae-11ed-a752-9ec33d03e6dd.zip','2023-01-11 13:47:43','SYNCED','20926382-91ae-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"modelMatrix\":\"0.945306,0.320976,-0.0580515,0,-0.326184,0.930215,-0.168238,0,-4.4664e-09,0.177972,0.984036,0,-19.5184,-20.4309,-20.5509,1\",\"title\":\"Mandibule ZIP\"}'),(662,'209476bb-91ae-11ed-a752-9ec33d03e6dd','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/209476bb-91ae-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_SNAPS_','2023-01-11 12:42:18','2023-01-11 12:58:26','209476bb-91ae-11ed-a752-9ec33d03e6dd.png','2023-01-11 13:42:18','SYNCED','209476bb-91ae-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'2129ad39-4745-4e82-a5b8-dcf7933c6ae7','','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_d3a42d3d-3d98-457b-bb64-4119091b03f9_PLY_','2020-12-29 10:57:36','2020-04-15 07:37:21','','2020-12-29 11:57:36','SYNCED','2129ad39-4745-4e82-a5b8-dcf7933c6ae7',0,'2020-12-29 11:57:36','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.1\",\"modelMatrix\":\"0.996436,-0.0417849,0.0747689,0,0.0270536,0.952167,0.302573,0,-0.0805792,-0.302841,0.950213,0,-13.0357,5.641,-33.0669,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(662,'214a04d1-1997-4654-8226-87b79966583e','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_79548cb6-a61f-44cb-b6f7-cab7698f7465/14_w1_o1_mordu_posterieur_droit_snapshot_1.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_RISC_79548cb6-a61f-44cb-b6f7-cab7698f7465_SNAPS_','2021-02-01 20:15:43','2021-02-01 21:15:42','14_w1_o1_mordu_posterieur_droit_snapshot_1.png','2021-02-01 21:15:43','SYNCED','5c991e5c-3b6f-409c-839c-1ed086c26caf',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.14.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'222a29ad-e959-403d-b53b-f17d1e53bc93','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_scan_file_3.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_ZIP_','2022-06-28 18:35:56','2022-06-28 20:34:09','19_w2_o1_maxillaire_scan_file_3.zip','2022-06-28 20:35:56','SYNCED','a1bc9da2-af83-43c3-8210-759800158585',3,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"modelMatrix\":\"-0.949742,0.301409,-0.0845116,0,-0.313033,-0.914475,0.256409,0,5.32806e-10,0.269977,0.962867,0,9.73869,-14.5525,-27.4476,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'229d55f2-d907-49a9-ae4c-c2359e8ce810','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_ecd2beec-0c29-40e2-ab95-64009c33fa40/13_w4_o1_mordu_posterieur_droit_scan_file_0.ply','PLY','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_RISC_ecd2beec-0c29-40e2-ab95-64009c33fa40_PLY_','2020-12-29 11:12:38','2020-12-29 11:30:30','13_w4_o1_mordu_posterieur_droit_scan_file_0.ply','2020-12-29 12:12:38','SYNCED','229d55f2-d907-49a9-ae4c-c2359e8ce810',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.13.4.1.1\",\"modelMatrix\":\"0.898262,-0.0473058,0.435366,0,0.0416943,0.998418,-0.00872949,0,-0.437779,0.0343256,0.900219,0,1.69242,5.98523,-22.1624,1\",\"title\":\"Mordu posterieur droit PLY\"}'),(662,'22b17811-0494-42ee-a82c-e9e5fe8e4ae4','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/order_b1c50855-9551-467e-94d9-915a6218ec1b/5_w3_gouttiere_prost_file_0.pdf','PDF','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_PROST_b1c50855-9551-467e-94d9-915a6218ec1b_PDF_','2020-07-13 17:47:50','2020-07-13 19:47:48','5_w3_gouttiere_prost_file_0.pdf','2020-07-13 19:47:50','SYNCED','22b17811-0494-42ee-a82c-e9e5fe8e4ae4',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"GOUTTIÈRE 1.5.3.1 GOUTTIÈRE\",\"title\":\"Gouttiere PDF\"}'),(662,'23066de9-fbda-436c-bd8b-dacb5721c390','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_e6c99474-f6f6-447f-bcaa-d4c791811e18/14_w1_o1_mandibule_scan_file_0.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_BOSC_e6c99474-f6f6-447f-bcaa-d4c791811e18_PLY_','2021-02-01 20:10:28','2021-02-01 21:09:31','14_w1_o1_mandibule_scan_file_0.ply','2021-02-01 21:10:28','SYNCED','23066de9-fbda-436c-bd8b-dacb5721c390',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.14.1.1.2\",\"modelMatrix\":\"-0.518382,0.847389,-0.114947,0,-0.855149,-0.513677,0.0696797,0,-3.29347e-9,0.134418,0.990925,0,9.65563,-5.82988,-22.2463,1\",\"title\":\"Mandibule PLY\"}'),(662,'23251874-b8f3-48b3-b209-0b434edd5db0','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_a26f0d58-ca46-4921-a9e1-9c39b7f89783/13_w4_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_TOSC_a26f0d58-ca46-4921-a9e1-9c39b7f89783_PLY_','2020-12-29 11:04:22','2020-12-29 11:00:28','13_w4_o1_maxillaire_scan_file_0.ply','2020-12-29 12:04:22','SYNCED','23251874-b8f3-48b3-b209-0b434edd5db0',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire PLY\",\"modelMatrix\":\"-0.750188,0.653787,-0.0989001,0,-0.661225,-0.741749,0.112206,0,-7.67185e-9,0.149571,0.988751,0,10.4824,-1.97924,-22.9424,1\",\"title\":\"Maxillaire PLY\"}'),(662,'2367f698-7e4f-4e60-b31f-752903f8cd34','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_802e2d49-5b37-47b7-b8e9-4fb4bff1f62f/25_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_TOSC_802e2d49-5b37-47b7-b8e9-4fb4bff1f62f_SNAPS_','2022-03-11 10:17:45','2022-03-11 11:13:45','25_w1_o1_maxillaire_snapshot_0.png','2022-03-11 11:17:45','SYNCED','2367f698-7e4f-4e60-b31f-752903f8cd34',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.25.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'245640ab-9c9d-4467-bd40-a48ae0ff49d0','','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_0c8af1cb-8054-4a35-9cfe-449c19dbe59b_SNAPS_','2020-12-29 10:57:36','2020-04-16 07:10:44','','2020-12-29 11:57:36','SYNCED','245640ab-9c9d-4467-bd40-a48ae0ff49d0',0,'2020-12-29 11:57:36','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.2\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}'),(662,'24c23cdd-d323-4623-8a9d-2d3e14f3b937','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_a26f0d58-ca46-4921-a9e1-9c39b7f89783/13_w4_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_TOSC_a26f0d58-ca46-4921-a9e1-9c39b7f89783_SNAPS_','2020-12-30 06:12:47','2020-12-29 11:00:28','13_w4_o1_maxillaire_snapshot_0.png','2020-12-30 07:12:47','SYNCED','24c23cdd-d323-4623-8a9d-2d3e14f3b937',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'252b180c-565f-4f14-af48-a16cebbead9e','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_SNAPS_','2023-01-11 11:25:59','2023-01-11 12:21:43','21_w7_o1_mandibule_snapshot_0.png','2023-01-11 12:25:59','SYNCED','252b180c-565f-4f14-af48-a16cebbead9e',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'2554e0bc-d621-46e3-90e6-f7d7f2085b98','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_de216c91-485b-4dac-9e7c-b89075739521/6_w1_o1_mandibule_scan_file_0.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_BOSC_de216c91-485b-4dac-9e7c-b89075739521_PLY_','2020-12-29 10:57:42','2020-04-10 11:13:08','6_w1_o1_mandibule_scan_file_0.ply','2020-12-29 11:57:42','SYNCED','2554e0bc-d621-46e3-90e6-f7d7f2085b98',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.6.1.1.1\",\"modelMatrix\":\"-0.37781,-0.890063,0.255044,0,0.925883,-0.363193,0.104072,0,5.24379e-10,0.275461,0.961312,0,-11.6328,2.9902,-23.8552,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'25d2e57a-b759-4ab8-a633-7725e7375d70','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_ef79558a-21cf-4117-a0b7-ba0adf40f7dc/19_w1_o1_mordu_anterieur_scan_file_0.ply','PLY','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_FRSC_ef79558a-21cf-4117-a0b7-ba0adf40f7dc_PLY_','2021-09-27 12:00:41','2021-09-27 12:49:22','19_w1_o1_mordu_anterieur_scan_file_0.ply','2021-09-27 14:00:41','SYNCED','25d2e57a-b759-4ab8-a633-7725e7375d70',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.19.1.1.1\",\"modelMatrix\":\"0.84619,0.0571101,0.515766,0,-0.00658361,0.991989,-0.141669,0,-0.533379,0.115223,0.845157,0,-3.68638,-6.26512,-27.8081,1\",\"title\":\"Mordu anterieur PLY\"}'),(662,'2607735b-f648-4b52-882f-e91b883da1be','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_99a6d55d-de66-49eb-a717-49cb2587fbef/19_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_RISC_99a6d55d-de66-49eb-a717-49cb2587fbef_SNAPS_','2021-09-27 11:57:53','2021-09-27 12:45:21','19_w1_o1_mordu_posterieur_droit_snapshot_0.png','2021-09-27 13:57:53','SYNCED','2607735b-f648-4b52-882f-e91b883da1be',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.19.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'2632ca9d-afe6-4104-a347-d590758abfc0','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_de216c91-485b-4dac-9e7c-b89075739521/6_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_BOSC_de216c91-485b-4dac-9e7c-b89075739521_SNAPS_','2020-12-29 10:57:42','2020-04-10 11:13:08','6_w1_o1_mandibule_snapshot_0.png','2020-12-29 11:57:42','SYNCED','2632ca9d-afe6-4104-a347-d590758abfc0',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.6.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'26c13801-12d8-430d-ae6c-429cbe801e77','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_snapshot_3.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_SNAPS_','2021-02-01 19:41:22','2021-02-01 20:41:18','14_w1_o1_maxillaire_snapshot_3.png','2021-02-01 20:41:22','SYNCED','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb',3,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'27755e68-98ae-4662-a39e-c3ea4ba3cdd4','','PDF','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_PROST_118a8411-96d0-412f-a2fd-6e990b04bf34_PDF_','2020-04-17 05:54:32','2020-04-15 08:51:44','','2020-04-17 07:54:32','SYNCED','27755e68-98ae-4662-a39e-c3ea4ba3cdd4',0,'2020-04-17 07:54:32','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"ODF 1.7.2.2 ODF\",\"title\":\"Odf PDF\"}'),(662,'29be6b15-58e7-42cd-824d-34b15f20be76','','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_BOSC_34f5d93d-6a1f-4f94-ab20-4105c2cce30a_PLY_','2021-09-27 11:56:22','2021-06-08 20:30:59','','2021-09-27 13:56:22','SYNCED','29be6b15-58e7-42cd-824d-34b15f20be76',0,'2021-09-27 13:56:22','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.14.2.1.1\",\"modelMatrix\":\"-0.315513,0.844692,-0.432375,0,-0.948921,-0.280857,0.143763,0,-6.33774e-10,0.455649,0.89016,0,3.51554,-8.30009,-16.7888,1\",\"title\":\"Mandibule PLY\"}'),(662,'29d00f37-e846-46c5-bfea-08ec3e95b455','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/computedocclusion_a18ca6df-d765-4c6a-be28-13amigraoccl/6_w1_o2_maxillaire_occlusion_occ_file_0.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_OCC_a18ca6df-d765-4c6a-be28-13amigraoccl_TOPLY__PLY_','2020-12-29 10:57:43','2020-04-17 11:21:05','6_w1_o2_maxillaire_occlusion_occ_file_0.ply','2020-12-29 11:57:43','SYNCED','29d00f37-e846-46c5-bfea-08ec3e95b455',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire Occlusion 1.6.1.2.1\",\"referenceScanID\":\"1.6.1.2.1\",\"title\":\"Maxillaire Occlusion PLY\"}'),(662,'2a17666e-f40f-403e-88af-a4cfaf6332ec','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_d9ec0349-f28e-41d6-822f-e76c8c001da9/16_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_TOSC_d9ec0349-f28e-41d6-822f-e76c8c001da9_SNAPS_','2021-02-27 09:22:34','2021-02-27 10:22:30','16_w1_o1_maxillaire_snapshot_0.png','2021-02-27 10:22:34','SYNCED','2a17666e-f40f-403e-88af-a4cfaf6332ec',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.16.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'2a2002a5-6321-4c63-938e-7276412e6a28','','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_PLY_','2020-12-29 10:57:37','2020-04-15 07:19:54','','2020-12-29 11:57:37','SYNCED','127e55bb-48e6-421e-ab6a-05b0763a843e',1,'2020-12-29 11:57:37','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.7.2.2.1\",\"modelMatrix\":\"0.798862,-0.59756,0.0688607,0,0.601515,0.79361,-0.0914527,0,-4.38586e-9,0.114479,0.993426,0,-2.73294,17.6652,-41.351,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'2aa2008a-2609-41f7-99c6-d3b7a4560466','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/406a8572-4b0f-480a-ad2e-daf5530143b6/session_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549/occlusion_254f3fc9-4782-4658-bb34-f2ca1c9b6382/scan_e5fd24c7-49a8-4dbc-9356-3b96970d2515/2_w6_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549_SESS_254f3fc9-4782-4658-bb34-f2ca1c9b6382_TOSC_e5fd24c7-49a8-4dbc-9356-3b96970d2515_SNAPS_','2020-12-29 10:57:43','2020-05-21 08:00:21','2_w6_o1_maxillaire_snapshot_0.png','2020-12-29 11:57:43','SYNCED','2aa2008a-2609-41f7-99c6-d3b7a4560466',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.2.6.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'2b6d557d-ea43-42a5-bd7d-859d5a90f1a6','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_4a2eec76-a5f3-44f0-b389-4734998fa2d3/13_w4_o1_mandibule_scan_file_0.ply','PLY','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_BOSC_4a2eec76-a5f3-44f0-b389-4734998fa2d3_PLY_','2020-12-29 11:12:00','2020-12-29 11:20:13','13_w4_o1_mandibule_scan_file_0.ply','2020-12-29 12:12:00','SYNCED','2b6d557d-ea43-42a5-bd7d-859d5a90f1a6',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule PLY\",\"modelMatrix\":\"-0.96542,-0.259936,0.019913,0,0.260698,-0.9626,0.073742,0,-2.70615e-10,0.0763833,0.997078,0,9.74495,12.7263,-20.8261,1\",\"title\":\"Mandibule PLY\"}'),(662,'2cff0ba7-eee7-4c7f-99af-34c690eb3868','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_3eede325-0afb-43f5-9277-e22c18f8f927/occlusion_f72f6016-0f75-4789-9924-1bc9aa64c2f1/scan_254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff/20_w2_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_3eede325-0afb-43f5-9277-e22c18f8f927_SESS_f72f6016-0f75-4789-9924-1bc9aa64c2f1_BOSC_254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff_ZIP_','2022-08-06 11:58:03','2022-08-06 13:56:38','20_w2_o1_mandibule_scan_file_0.zip','2022-08-06 13:58:03','SYNCED','2cff0ba7-eee7-4c7f-99af-34c690eb3868',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.20.2.1.1\",\"modelMatrix\":\"0.909705,0.387142,-0.150193,0,-0.415255,0.848117,-0.329031,0,9.51155e-09,0.36169,0.932299,0,-8.74595,-28.9367,-15.18,1\",\"title\":\"Mandibule ZIP\"}'),(662,'2d1d8d21-ec2c-485d-98af-375a4d8263d6','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_a90158f7-0d39-4b9d-984b-57de06099c65/21_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_SNAPS_','2021-11-22 11:25:57','2021-11-22 12:21:50','21_w1_o1_maxillaire_snapshot_0.png','2021-11-22 12:25:57','SYNCED','2d1d8d21-ec2c-485d-98af-375a4d8263d6',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'2ec9cc68-72e4-4237-9254-2374d936f630','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_470d4798-40ea-4ce5-a574-22fcf013d82d/7_w4_o1_mordu_posterieur_droit_scan_file_0.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_RISC_470d4798-40ea-4ce5-a574-22fcf013d82d_PLY_','2020-12-29 10:57:43','2020-04-16 11:17:28','7_w4_o1_mordu_posterieur_droit_scan_file_0.ply','2020-12-29 11:57:43','SYNCED','2ec9cc68-72e4-4237-9254-2374d936f630',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.7.4.1.1\",\"modelMatrix\":\"0.949504,-0.049291,0.270682,0,-0.0206689,0.968059,0.244397,0,-0.316154,-0.246141,0.932125,0,-12.5432,4.45695,-30.6874,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(662,'2fe7a2a7-6a20-4d12-ba81-6c46af5e0703','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_be9a4ba5-715b-4547-a31d-66621ec7b17f/14_w2_o1_maxillaire_scan_file_1.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_TOSC_be9a4ba5-715b-4547-a31d-66621ec7b17f_PLY_','2021-06-08 18:17:44','2021-06-08 20:16:28','14_w2_o1_maxillaire_scan_file_1.ply','2021-06-08 20:17:44','SYNCED','5498794c-1fcc-48dd-b50e-b57ca5d157ab',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.2.1.1\",\"modelMatrix\":\"0.983577,0.180375,-0.006406,0,-0.180488,0.982957,-0.0349097,0,6.65026e-11,0.0354926,0.99937,0,-10.8448,5.00032,-24.3455,1\",\"title\":\"Maxillaire PLY\"}'),(662,'307db8a0-4cc4-49dc-9aca-9a7072712805','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_snapshot_3.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_SNAPS_','2023-01-11 12:42:17','2023-01-11 12:37:39','21_w7_o1_mandibule_snapshot_3.png','2023-01-11 13:42:17','SYNCED','252b180c-565f-4f14-af48-a16cebbead9e',3,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'30e96914-828b-4376-9eeb-077529a3422d','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/computedocclusion_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd/25_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_OCC_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd_TOPLY__ZIP_','2022-06-27 19:29:05','2022-03-11 11:16:26','25_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-06-27 21:29:05','SYNCED','30e96914-828b-4376-9eeb-077529a3422d',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.25.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.25.1.1.1\",\"title\":\"Maxillaire 1.25.1.1.1 Occlusion 1\"}'),(662,'31421697-5459-439e-919b-169d051646f5','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/31421697-5459-439e-919b-169d051646f5.ply','PLY','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_c9d37315-5f17-421c-8afb-302fa9b0bebe_BOSC_6fafe104-bdc1-41a6-9977-b1bbb351a329_PLY_','2020-12-29 10:57:37','2020-04-07 06:42:41','31421697-5459-439e-919b-169d051646f5.ply','2020-12-29 11:57:37','SYNCED','3e41d066-f22f-4b6c-bc5b-438bc17b2d84',1,'2020-12-29 11:57:37','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.2.2.1.1\",\"modelMatrix\":\"0.998917,-0.046407,0.00327279,0,0.0465222,0.996442,-0.0702729,0,2.41777e-10,0.070349,0.997522,0,-15.4826,-27.7313,-45.5726,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'31b407a6-51a1-4581-a381-00a2955c6d4d','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_a90158f7-0d39-4b9d-984b-57de06099c65/21_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_ZIP_','2021-11-22 11:28:21','2021-11-22 12:25:56','21_w1_o1_maxillaire_scan_file_1.zip','2021-11-22 12:28:21','SYNCED','8396da09-c9ea-476d-ab69-648f06ec6534',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"modelMatrix\":\"0.807465,0.588049,-0.0468876,0,-0.589915,0.804911,-0.0641789,0,-7.03104e-10,0.079482,0.996836,0,-19.0887,-4.61348,-20.8885,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'330dc645-80dc-4734-bc6a-ba2a87b5f495','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_50e1896b-8565-4257-9a61-2a685fff8165/19_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_BOSC_50e1896b-8565-4257-9a61-2a685fff8165_SNAPS_','2021-09-27 12:02:04','2021-09-27 12:43:41','19_w1_o1_mandibule_snapshot_1.png','2021-09-27 14:02:04','SYNCED','d455a946-5407-4abb-8fdb-711fb0adfe7c',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.19.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'33d86713-43cb-4b91-9426-39eba69968e0','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_848b25bd-90a8-4105-871d-f9326fe94c7b/smilersorder_0014546a-ad2d-4f74-9a83-8a7a0cf1af7a/21_w6_smilers_file_0.json','JSON','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_848b25bd-90a8-4105-871d-f9326fe94c7b_PROST_0014546a-ad2d-4f74-9a83-8a7a0cf1af7a_JSON_','2022-12-21 11:17:42','2022-12-21 12:15:13','21_w6_smilers_file_0.json','2022-12-21 12:17:42','SYNCED','33d86713-43cb-4b91-9426-39eba69968e0',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'35704ab9-18dc-4d80-81f3-5f50e93033c6','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5/6_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_TOSC_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5_SNAPS_','2020-12-29 10:57:44','2020-04-17 10:58:56','6_w1_o2_maxillaire_snapshot_0.png','2020-12-29 11:57:44','SYNCED','35704ab9-18dc-4d80-81f3-5f50e93033c6',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.6.1.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'35adf938-8070-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/35adf938-8070-11ea-947d-226cec7cb58a.json','JSON','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_PROST_50b326be-6726-493a-a2ce-6f1153dc9927_JSON_','2020-04-17 05:56:50','2020-04-17 07:56:49','35adf938-8070-11ea-947d-226cec7cb58a.json','2020-04-17 07:56:50','SYNCED','35adf938-8070-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.6.1.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre JSON\"}'),(662,'35b24728-8070-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/35b24728-8070-11ea-947d-226cec7cb58a.m','MATRX','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_BOMA__MATRX_','2020-12-29 10:57:44','2020-04-10 11:52:17','35b24728-8070-11ea-947d-226cec7cb58a.m','2020-12-29 11:57:44','SYNCED','35b24728-8070-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.6.1.1\",\"title\":\"Matrice Transfo. Mandibule MATRIX\"}'),(662,'35b42350-8070-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/35b42350-8070-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_BOPLY__PLY_','2020-12-29 10:57:44','2020-04-10 11:52:17','35b42350-8070-11ea-947d-226cec7cb58a.ply','2020-12-29 11:57:44','SYNCED','35b42350-8070-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule Occlusion 1.6.1.1.1\",\"referenceScanID\":\"1.6.1.1.1\",\"title\":\"Mandibule Occlusion PLY\"}'),(662,'35b5d98f-8070-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/35b5d98f-8070-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_SNAPO__SNAPS_','2020-12-29 10:57:45','2020-04-10 11:52:17','35b5d98f-8070-11ea-947d-226cec7cb58a.png','2020-12-29 11:57:45','SYNCED','35b5d98f-8070-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Snapshot 1.6.1.1\",\"title\":\"Snapshot SNAPSHOT\"}'),(662,'35b772cc-8070-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/35b772cc-8070-11ea-947d-226cec7cb58a.m','MATRX','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_TOMA__MATRX_','2020-12-29 10:57:45','2020-04-10 11:52:17','35b772cc-8070-11ea-947d-226cec7cb58a.m','2020-12-29 11:57:45','SYNCED','35b772cc-8070-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.6.1.1\",\"title\":\"Matrice Transfo. Maxillaire MATRIX\"}'),(662,'35b92b48-8070-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/35b92b48-8070-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_TOPLY__PLY_','2020-12-29 10:57:46','2020-04-10 11:52:17','35b92b48-8070-11ea-947d-226cec7cb58a.ply','2020-12-29 11:57:46','SYNCED','35b92b48-8070-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire Occlusion 1.6.1.1.1\",\"referenceScanID\":\"1.6.1.1.1\",\"title\":\"Maxillaire Occlusion PLY\"}'),(662,'35bad668-8070-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/35bad668-8070-11ea-947d-226cec7cb58a.pdf','PDF','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_PROST_50b326be-6726-493a-a2ce-6f1153dc9927_PDF_','2020-04-17 05:56:50','2020-04-17 07:56:49','35bad668-8070-11ea-947d-226cec7cb58a.pdf','2020-04-17 07:56:50','SYNCED','35bad668-8070-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.6.1.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}'),(662,'364852fb-413f-4160-99e2-dfbc1733ad1a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_d1ad6baa-b3e6-4e10-bd69-140c7abc8f4e/6_w1_o1_mordu_anterieur_scan_file_0.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_FRSC_d1ad6baa-b3e6-4e10-bd69-140c7abc8f4e_PLY_','2020-12-29 10:57:46','2020-04-10 11:49:59','6_w1_o1_mordu_anterieur_scan_file_0.ply','2020-12-29 11:57:46','SYNCED','364852fb-413f-4160-99e2-dfbc1733ad1a',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.6.1.1.1\",\"modelMatrix\":\"0.929175,-0.0763218,0.365789,0,0.119438,0.973751,-0.180215,0,-0.351164,0.216695,0.913103,0,9.0576,-4.92457,-30.9488,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}'),(662,'372c807f-a172-495b-9111-e2a86808505c','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_87a0a17a-c973-40c2-9d84-2392b0d62afb/10_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_TOSC_87a0a17a-c973-40c2-9d84-2392b0d62afb_PLY_','2020-12-29 10:57:47','2020-04-30 19:25:29','10_w1_o1_maxillaire_scan_file_0.ply','2020-12-29 11:57:47','SYNCED','372c807f-a172-495b-9111-e2a86808505c',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.10.1.1.1\",\"modelMatrix\":\"0.985264,-0.169747,0.0209871,0,0.171039,0.977819,-0.120895,0,1.34619e-9,0.122703,0.992443,0,-22.8348,-1.6456,-24.8597,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'386b43f6-0c1a-484d-9092-8962d1eb3835','','SNAPS','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_c9d37315-5f17-421c-8afb-302fa9b0bebe_BOSC_6fafe104-bdc1-41a6-9977-b1bbb351a329_SNAPS_','2020-12-29 10:57:37','2020-04-06 12:33:56','','2020-12-29 11:57:37','SYNCED','386b43f6-0c1a-484d-9092-8962d1eb3835',0,'2020-12-29 11:57:37','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule Occlusion 1.2.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'38709a56-7ee2-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/38709a56-7ee2-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7_SNAPS_','2020-12-29 10:57:47','2020-04-15 07:39:22','38709a56-7ee2-11ea-947d-226cec7cb58a.png','2020-12-29 11:57:47','SYNCED','38709a56-7ee2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}'),(662,'38724456-7ee2-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/38724456-7ee2-11ea-947d-226cec7cb58a.pdf','PDF','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_PROST_083f4c03-5580-45f2-9229-c3b06c40bbe2_PDF_','2020-04-15 06:27:55','2020-04-15 08:27:54','38724456-7ee2-11ea-947d-226cec7cb58a.pdf','2020-04-15 08:27:55','SYNCED','38724456-7ee2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"ODF 1.7.2.1 ODF\",\"title\":\"Odf PDF\"}'),(662,'3873da60-7ee2-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/3873da60-7ee2-11ea-947d-226cec7cb58a.json','JSON','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_PROST_083f4c03-5580-45f2-9229-c3b06c40bbe2_JSON_','2020-04-15 06:27:55','2020-04-15 08:27:54','3873da60-7ee2-11ea-947d-226cec7cb58a.json','2020-04-15 08:27:55','SYNCED','3873da60-7ee2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"ODF 1.7.2.1 ODF\",\"title\":\"Odf JSON\"}'),(662,'38756f28-7ee2-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/38756f28-7ee2-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_d3a42d3d-3d98-457b-bb64-4119091b03f9_PLY_','2020-12-29 10:57:48','2020-04-15 07:37:21','38756f28-7ee2-11ea-947d-226cec7cb58a.ply','2020-12-29 11:57:48','SYNCED','38756f28-7ee2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.1\",\"modelMatrix\":\"0.996436,-0.0417849,0.0747689,0,0.0270536,0.952167,0.302573,0,-0.0805792,-0.302841,0.950213,0,-13.0357,5.641,-33.0669,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(662,'387709c6-7ee2-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/387709c6-7ee2-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_PLY_','2020-12-29 10:57:49','2020-04-15 07:19:54','387709c6-7ee2-11ea-947d-226cec7cb58a.ply','2020-12-29 11:57:49','SYNCED','387709c6-7ee2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.7.2.2.1\",\"modelMatrix\":\"0.798862,-0.59756,0.0688607,0,0.601515,0.79361,-0.0914527,0,-4.38586e-9,0.114479,0.993426,0,-2.73294,17.6652,-41.351,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'3878b044-7ee2-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/3878b044-7ee2-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_SNAPS_','2020-12-29 10:57:49','2020-04-15 07:35:08','3878b044-7ee2-11ea-947d-226cec7cb58a.png','2020-12-29 11:57:49','SYNCED','3878b044-7ee2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.7.2.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'387a5afb-7ee2-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/387a5afb-7ee2-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_SNAPS_','2020-12-29 10:57:50','2020-04-15 07:19:54','387a5afb-7ee2-11ea-947d-226cec7cb58a.png','2020-12-29 11:57:50','SYNCED','387a5afb-7ee2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.7.2.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'387be67d-7ee2-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/387be67d-7ee2-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_PLY_','2020-12-29 10:57:51','2020-04-15 07:35:08','387be67d-7ee2-11ea-947d-226cec7cb58a.ply','2020-12-29 11:57:51','SYNCED','387be67d-7ee2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.7.2.2.1\",\"modelMatrix\":\"0.665193,0.645471,-0.375347,0,-0.746672,0.575036,-0.334388,0,2.20888e-8,0.502693,0.864465,0,-12.1421,-33.8974,-48.3616,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'387eea3c-7ee2-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/387eea3c-7ee2-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_ca33a9ff-b86a-4e97-8674-1bd7adc92759_SNAPS_','2020-12-29 10:57:51','2020-04-15 07:43:36','387eea3c-7ee2-11ea-947d-226cec7cb58a.png','2020-12-29 11:57:51','SYNCED','387eea3c-7ee2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}'),(662,'388324cf-7ee2-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/388324cf-7ee2-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_ca33a9ff-b86a-4e97-8674-1bd7adc92759_PLY_','2020-12-29 10:57:52','2020-04-15 07:43:36','388324cf-7ee2-11ea-947d-226cec7cb58a.ply','2020-12-29 11:57:52','SYNCED','388324cf-7ee2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.1\",\"modelMatrix\":\"0.716923,0.0202956,0.693353,0,-0.0337042,0.999997,-0.0100568,0,-0.69663,0.000757645,0.720556,0,12.2181,4.16901,-40.9229,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}'),(662,'3884bf44-7ee2-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/3884bf44-7ee2-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7_PLY_','2020-12-29 10:57:52','2020-04-15 07:39:22','3884bf44-7ee2-11ea-947d-226cec7cb58a.ply','2020-12-29 11:57:52','SYNCED','3884bf44-7ee2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.1\",\"modelMatrix\":\"-0.999903,-0.00806038,0.0111619,0,0.0083222,-0.994448,-0.103366,0,0.0112516,-0.104947,0.994583,0,16.7147,8.54514,-27.4379,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}'),(662,'3886abd6-7ee2-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/3886abd6-7ee2-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_d3a42d3d-3d98-457b-bb64-4119091b03f9_SNAPS_','2020-12-29 10:57:52','2020-04-15 07:37:21','3886abd6-7ee2-11ea-947d-226cec7cb58a.png','2020-12-29 11:57:52','SYNCED','3886abd6-7ee2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(662,'38ff0511-8c8a-4f8b-a2a4-13c26e804b9d','','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_c6bba495-6d1a-4da8-bb1f-852a1b1e5924_PLY_','2020-12-29 10:57:37','2020-04-16 07:07:50','','2020-12-29 11:57:37','SYNCED','38ff0511-8c8a-4f8b-a2a4-13c26e804b9d',0,'2020-12-29 11:57:37','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.2\",\"modelMatrix\":\"-0.999653,-0.0333276,-0.0042182,0,0.0270346,-0.970849,-0.23484,0,0.00244308,-0.237468,0.972029,0,1.83306,6.25688,-28.1939,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}'),(662,'3a74c5df-7c06-40b5-9e98-eeeb48d5c650','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/computedocclusion_a18ca6df-d765-4c6a-be28-13amigraoccl/6_w1_o2_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_OCC_a18ca6df-d765-4c6a-be28-13amigraoccl_BOMA__MATRX_','2020-12-29 10:57:53','2020-04-17 11:21:05','6_w1_o2_mandibule_matrix_occ_file_0.m','2020-12-29 11:57:53','SYNCED','3a74c5df-7c06-40b5-9e98-eeeb48d5c650',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.6.1.2\",\"title\":\"Matrice Transfo. Mandibule MATRIX\"}'),(662,'3a8a47b1-96a0-4e8f-a7fa-d5c2f74f3677','','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_SNAPS_','2020-12-29 10:57:38','2020-04-15 07:35:08','','2020-12-29 11:57:38','SYNCED','7935777d-a278-4364-9439-322233eba142',1,'2020-12-29 11:57:38','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.7.2.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'3aa92b1f-240d-45e1-a722-e8da98368f3a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_ZIP_','2021-11-22 11:31:52','2021-11-22 12:30:44','21_w1_o1_mandibule_scan_file_0.zip','2021-11-22 12:31:52','SYNCED','3aa92b1f-240d-45e1-a722-e8da98368f3a',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"modelMatrix\":\"0.960232,0.261348,-0.0982449,0,-0.279204,0.898822,-0.337882,0,2.72772e-9,0.351875,0.936047,0,6.31415,-5.24631,-21.8923,1\",\"title\":\"Mandibule ZIP\"}'),(662,'3b5b5fb9-a2cd-4386-9406-17bd2384e1ae','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_42b09cf6-e30d-4d35-a17d-d8e8b4564638/20_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_TOSC_42b09cf6-e30d-4d35-a17d-d8e8b4564638_ZIP_','2021-10-12 12:37:44','2021-10-12 12:33:04','20_w1_o1_maxillaire_scan_file_0.zip','2021-10-12 14:37:44','SYNCED','3b5b5fb9-a2cd-4386-9406-17bd2384e1ae',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.20.1.1.1\",\"modelMatrix\":\"0.248108,0.928852,-0.275093,0,-0.968732,0.237894,-0.0704559,0,-9.18486e-10,0.283972,0.958832,0,-6.47131,-21.9142,-22.0048,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'3b6f0d95-5183-43aa-8816-815a96e7e143','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_c983b946-e304-49a8-99c8-24eaca67b9ce/occlusion_9e007066-06fd-4fa1-a49a-f1165de95f83/scan_76ece440-81ad-42c8-ab91-f99fa29e2a83/21_w8_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_c983b946-e304-49a8-99c8-24eaca67b9ce_SESS_9e007066-06fd-4fa1-a49a-f1165de95f83_TOSC_76ece440-81ad-42c8-ab91-f99fa29e2a83_ZIP_','2023-04-11 18:49:14','2023-04-11 20:49:14','21_w8_o1_maxillaire_scan_file_1.zip',NULL,'CREATED','ae0e9352-37bf-4a60-8c33-459deae4ddb5',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.8.1.1\",\"modelMatrix\":\"0.818642,0.55047,-0.163732,0,-0.574305,0.784667,-0.233391,0,-1.3908e-08,0.285096,0.958499,0,-17.5299,-5.99357,-22.031,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'3c573ce9-f6b2-4667-9726-f5aed56d3325','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_934f20d2-7444-4367-89e2-61c3bf4bee57/order_eb120496-ad30-4640-856b-fbdd1139c529/5_w1_odf_prost_file_0.pdf','PDF','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_934f20d2-7444-4367-89e2-61c3bf4bee57_PROST_eb120496-ad30-4640-856b-fbdd1139c529_PDF_','2020-04-10 07:20:49','2020-04-10 09:20:47','5_w1_odf_prost_file_0.pdf','2020-04-10 09:20:49','SYNCED','3c573ce9-f6b2-4667-9726-f5aed56d3325',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"ODF 1.5.1.3 ODF\",\"title\":\"Odf PDF\"}'),(662,'3d2bee32-9787-46dd-b6a9-cba9de226dfb','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_SNAPS_','2020-12-29 10:57:53','2020-04-30 19:51:54','10_w1_o1_mandibule_snapshot_1.png','2020-12-29 11:57:53','SYNCED','f3f82ebd-8318-469e-9bdd-ff76223b9c1c',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.10.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'3d775751-11c5-4dcb-bf34-a85c2baf0191','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_4a2eec76-a5f3-44f0-b389-4734998fa2d3/13_w4_o1_mandibule_scan_file_1.ply','PLY','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_BOSC_4a2eec76-a5f3-44f0-b389-4734998fa2d3_PLY_','2020-12-29 11:13:35','2020-12-29 11:24:49','13_w4_o1_mandibule_scan_file_1.ply','2020-12-29 12:13:35','SYNCED','2b6d557d-ea43-42a5-bd7d-859d5a90f1a6',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.13.4.1.1\",\"modelMatrix\":\"-0.927385,0.371641,-0.0428907,0,-0.374108,-0.92127,0.106323,0,-4.21377e-10,0.114648,0.993406,0,17.4534,2.88749,-20.5368,1\",\"title\":\"Mandibule PLY\"}'),(662,'3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_SNAPS_','2021-02-01 19:21:01','2021-02-01 20:20:58','14_w1_o1_maxillaire_snapshot_0.png','2021-02-01 20:21:01','SYNCED','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'3dc10c2a-bbf8-496d-bcfb-198ad6609e7b','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_55058b25-acc2-43c3-b9d2-b8bb64bfcbb9/9_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PLY','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_RISC_55058b25-acc2-43c3-b9d2-b8bb64bfcbb9_PLY_','2020-12-29 10:57:54','2020-04-18 09:33:54','9_w1_o1_mordu_posterieur_droit_scan_file_0.ply','2020-12-29 11:57:54','SYNCED','3dc10c2a-bbf8-496d-bcfb-198ad6609e7b',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.9.1.1.1\",\"modelMatrix\":\"0.9697,-0.169154,0.177375,0,0.140935,0.97496,0.170056,0,-0.199574,-0.144436,0.969352,0,-10.321,0.513719,-39.3692,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(662,'3ddb3953-cee7-44fd-b8e2-76afee946647','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_snapshot_3.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_SNAPS_','2021-11-22 11:51:23','2021-11-22 12:41:03','21_w1_o1_mandibule_snapshot_3.png','2021-11-22 12:51:23','SYNCED','5dfbe9b8-c587-4311-b392-743be40fdd10',3,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'3e41d066-f22f-4b6c-bc5b-438bc17b2d84','','PLY','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_c9d37315-5f17-421c-8afb-302fa9b0bebe_BOSC_6fafe104-bdc1-41a6-9977-b1bbb351a329_PLY_','2020-12-29 10:57:38','2020-04-06 12:33:56','','2020-12-29 11:57:38','SYNCED','3e41d066-f22f-4b6c-bc5b-438bc17b2d84',0,'2020-12-29 11:57:38','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule Occlusion 1.2.2.1\",\"modelMatrix\":\"0.400065,-0.911137,0.0988782,0,0.916487,0.39773,-0.0431623,0,5.34897e-10,0.107888,0.994163,0,-28.4581,-3.18447,-47.2893,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'3efa61b2-db0f-47ba-a009-383d9c565444','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/order_50b326be-6726-493a-a2ce-6f1153dc9927/6_w1_autre_prost_file_0.json','JSON','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_PROST_50b326be-6726-493a-a2ce-6f1153dc9927_JSON_','2020-04-17 05:56:50','2020-04-17 07:56:49','6_w1_autre_prost_file_0.json','2020-04-17 07:56:50','SYNCED','3efa61b2-db0f-47ba-a009-383d9c565444',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.6.1.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre JSON\"}'),(662,'3f126af5-ce2b-4e13-8fc8-9811ab5d462c','','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_SNAPS_','2020-12-29 10:57:38','2020-04-15 07:19:54','','2020-12-29 11:57:38','SYNCED','98a2c194-b406-4930-b901-3f1b520fc329',1,'2020-12-29 11:57:38','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.7.2.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'3f34dab9-eda8-40de-be81-a094dee55a47','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_e6e5d8c5-2d8c-48d0-9708-e3256202d385/15_w1_o1_mandibule_scan_file_1.ply','PLY','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_BOSC_e6e5d8c5-2d8c-48d0-9708-e3256202d385_PLY_','2021-02-16 11:49:11','2021-02-16 12:48:00','15_w1_o1_mandibule_scan_file_1.ply','2021-02-16 12:49:11','SYNCED','6e9feeb8-6d42-4237-b134-51d979397898',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.15.1.1.1\",\"modelMatrix\":\"-0.93029,0.344241,-0.126722,0,-0.366825,-0.873016,0.321375,0,1.11868e-10,0.345457,0.938435,0,10.3349,-0.483709,-14.2397,1\",\"title\":\"Mandibule PLY\"}'),(662,'3f3f465f-157f-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/3f3f465f-157f-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_3eede325-0afb-43f5-9277-e22c18f8f927_SESS_f72f6016-0f75-4789-9924-1bc9aa64c2f1_BOSC_254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff_ZIP_','2022-08-06 11:58:03','2022-08-06 13:56:38','3f3f465f-157f-11ed-a752-9ec33d03e6dd.zip','2022-08-06 13:58:03','SYNCED','3f3f465f-157f-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.20.2.1.1\",\"modelMatrix\":\"0.909705,0.387142,-0.150193,0,-0.415255,0.848117,-0.329031,0,9.51155e-09,0.36169,0.932299,0,-8.74595,-28.9367,-15.18,1\",\"title\":\"Mandibule ZIP\"}'),(662,'3f421d14-157f-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/3f421d14-157f-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_3eede325-0afb-43f5-9277-e22c18f8f927_SESS_f72f6016-0f75-4789-9924-1bc9aa64c2f1_BOSC_254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff_SNAPS_','2022-08-06 11:58:03','2022-08-06 13:56:36','3f421d14-157f-11ed-a752-9ec33d03e6dd.png','2022-08-06 13:58:03','SYNCED','3f421d14-157f-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.20.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'3f556561-f5e6-4964-b058-136e53ecaa20','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/smilersorder_97b0ec8c-0f87-4226-bd8d-caffe14e5dd7/19_w3_smilers_file_0.json','JSON','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_PROST_97b0ec8c-0f87-4226-bd8d-caffe14e5dd7_JSON_','2022-11-02 17:40:35','2022-11-02 13:56:17','19_w3_smilers_file_0.json','2022-11-02 18:40:35','SYNCED','3f556561-f5e6-4964-b058-136e53ecaa20',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'3f9ce1c8-3470-43c5-8e52-0294b7082120','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_18365744-4019-43e1-933f-9fa52db1a30d/14_w2_o1_mordu_anterieur_scan_file_0.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_FRSC_18365744-4019-43e1-933f-9fa52db1a30d_PLY_','2021-06-08 18:57:42','2021-06-08 20:56:53','14_w2_o1_mordu_anterieur_scan_file_0.ply','2021-06-08 20:57:42','SYNCED','3f9ce1c8-3470-43c5-8e52-0294b7082120',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.14.2.1.1\",\"modelMatrix\":\"0.818033,-0.00455161,0.571846,0,0.124413,0.969323,-0.221421,0,-0.562015,0.247702,0.790218,0,4.13126,-6.94909,-27.5385,1\",\"title\":\"Mordu anterieur PLY\"}'),(662,'3ff0f96a-5e61-4469-a401-383ca0d260ac','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_3d3ae697-dc08-4ce2-8b32-4f79891607c2/21_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_FRSC_3d3ae697-dc08-4ce2-8b32-4f79891607c2_SNAPS_','2021-11-22 11:51:22','2021-11-22 12:49:42','21_w1_o1_mordu_anterieur_snapshot_0.png','2021-11-22 12:51:22','SYNCED','3ff0f96a-5e61-4469-a401-383ca0d260ac',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.21.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'40bc13d8-af5e-436f-825b-372a9ad37b03','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_f766f1dd-53ad-45fc-8f7b-a61d47dfe500/16_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PLY','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_LESC_f766f1dd-53ad-45fc-8f7b-a61d47dfe500_PLY_','2021-02-27 09:53:48','2021-02-27 10:52:46','16_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','2021-02-27 10:53:48','SYNCED','40bc13d8-af5e-436f-825b-372a9ad37b03',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.16.1.1.1\",\"modelMatrix\":\"-0.848269,-0.0934247,0.521312,0,0.2652,-0.889836,0.34217,0,0.461243,0.449468,0.781819,0,-4.04483,-9.96195,-25.9001,1\",\"title\":\"Mordu posterieur gauche PLY\"}'),(662,'40c9dd9e-b85c-4ed6-a37e-81b5b8e9124d','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_e9134dab-33d6-42e4-8779-ab502b18266c/7_w4_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_TOSC_e9134dab-33d6-42e4-8779-ab502b18266c_PLY_','2020-12-29 10:57:54','2020-04-16 10:54:36','7_w4_o1_maxillaire_scan_file_0.ply','2020-12-29 11:57:54','SYNCED','40c9dd9e-b85c-4ed6-a37e-81b5b8e9124d',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.7.4.1.1\",\"modelMatrix\":\"0.991392,0.126509,-0.0337273,0,-0.130927,0.957933,-0.255386,0,1.47727e-9,0.257603,0.966251,0,-10.2666,-17.593,-25.4967,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'41f1c7ba-1d8c-47b9-8ed9-11f004bb7681','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/3d722760-3820-40e4-81e1-60e722c0cb01/session_1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e/occlusion_20b31e3a-565c-49b0-b2ff-0dae86b25c76/scan_3e1d8e57-feae-45d6-80f0-9d0be041ff7a/28_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_3d722760-3820-40e4-81e1-60e722c0cb01_ACT_1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e_SESS_20b31e3a-565c-49b0-b2ff-0dae86b25c76_TOSC_3e1d8e57-feae-45d6-80f0-9d0be041ff7a_ZIP_','2022-09-19 09:55:15','2022-09-19 11:48:35','28_w1_o1_maxillaire_scan_file_0.zip','2022-09-19 11:55:15','SYNCED','41f1c7ba-1d8c-47b9-8ed9-11f004bb7681',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.28.1.1.1\",\"modelMatrix\":\"0.474246,0.405495,-0.78145,0,-0.880392,0.21843,-0.420948,0,2.39322e-08,0.887616,0.460584,0,-13.5016,-38.9817,-5.28171,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'4210a84b-05e7-47b1-9d77-62e41dc0e731','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_99102b35-9ad0-4017-b70e-fa08e5c36102/19_w3_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_RISC_99102b35-9ad0-4017-b70e-fa08e5c36102_SNAPS_','2022-11-02 14:09:58','2022-11-02 12:34:10','19_w3_o1_mordu_posterieur_droit_snapshot_0.png','2022-11-02 15:09:58','SYNCED','4210a84b-05e7-47b1-9d77-62e41dc0e731',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.19.3.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'42d780c5-37b5-433e-890f-3c005cb69701','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/occlusion_f2e73640-aebd-4bb1-9b02-c0504556ac5a/scan_e7efed59-e33c-4194-94c1-3507350dcfb5/5_w3_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_SESS_f2e73640-aebd-4bb1-9b02-c0504556ac5a_TOSC_e7efed59-e33c-4194-94c1-3507350dcfb5_PLY_','2020-12-29 10:57:54','2020-07-13 19:18:53','5_w3_o1_maxillaire_scan_file_0.ply','2020-12-29 11:57:54','SYNCED','42d780c5-37b5-433e-890f-3c005cb69701',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.5.3.1.1\",\"modelMatrix\":\"-0.890132,-0.441513,0.112835,0,0.455703,-0.862414,0.220401,0,1.25595e-9,0.247605,0.968861,0,15.4523,-7.52574,-24.5518,1\",\"title\":\"Maxillaire PLY\"}'),(662,'430388c7-9e1e-4f20-b931-839cea08cfe1','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_c99bbff9-5630-49d7-9300-4dabfa5e74c8/15_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_RISC_c99bbff9-5630-49d7-9300-4dabfa5e74c8_SNAPS_','2021-02-16 11:53:07','2021-02-16 12:53:05','15_w1_o1_mordu_posterieur_droit_snapshot_0.png','2021-02-16 12:53:07','SYNCED','430388c7-9e1e-4f20-b931-839cea08cfe1',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.15.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'43236ddb-b178-4cc2-bc90-90f78d3f3694','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_10c9626c-901e-4a0e-8f05-62042bf69c04/7_w4_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_BOSC_10c9626c-901e-4a0e-8f05-62042bf69c04_SNAPS_','2020-12-29 10:57:55','2020-04-16 11:14:29','7_w4_o1_mandibule_snapshot_0.png','2020-12-29 11:57:55','SYNCED','43236ddb-b178-4cc2-bc90-90f78d3f3694',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.7.4.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'436f05c6-b083-492e-bd94-ce39d9a91136','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_801b987d-e335-4276-8bc6-1fa57b553716/occlusion_1a616ac1-2ca3-4d23-ae5e-349558c26c37/scan_7fad3bba-f2b2-41ce-849b-756d995c0414/5_w2_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_801b987d-e335-4276-8bc6-1fa57b553716_SESS_1a616ac1-2ca3-4d23-ae5e-349558c26c37_TOSC_7fad3bba-f2b2-41ce-849b-756d995c0414_PLY_','2020-12-29 10:57:55','2020-04-11 07:49:58','5_w2_o1_maxillaire_scan_file_0.ply','2020-12-29 11:57:55','SYNCED','436f05c6-b083-492e-bd94-ce39d9a91136',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.5.2.1.1\",\"modelMatrix\":\"-0.882441,0.381231,-0.275609,0,-0.470423,-0.715131,0.517,0,1.77231e-9,0.585875,0.810401,0,-8.72731,-27.9562,-11.891,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'449406e4-68d2-4fa1-9032-2e72795a7ec2','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_e9134dab-33d6-42e4-8779-ab502b18266c/7_w4_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_TOSC_e9134dab-33d6-42e4-8779-ab502b18266c_SNAPS_','2020-12-29 10:57:55','2020-04-16 10:54:36','7_w4_o1_maxillaire_snapshot_0.png','2020-12-29 11:57:55','SYNCED','449406e4-68d2-4fa1-9032-2e72795a7ec2',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.7.4.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'4582b122-e1ac-4901-8817-e05e3192fc42','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_cd4cde89-86e9-4257-92b6-869e9aa8d1f6/7_w4_o1_mordu_anterieur_scan_file_0.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_FRSC_cd4cde89-86e9-4257-92b6-869e9aa8d1f6_PLY_','2020-12-29 10:57:56','2020-04-16 11:35:43','7_w4_o1_mordu_anterieur_scan_file_0.ply','2020-12-29 11:57:56','SYNCED','4582b122-e1ac-4901-8817-e05e3192fc42',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.7.4.1.1\",\"modelMatrix\":\"0.808151,-0.0132398,0.595057,0,0.158105,0.942098,-0.249001,0,-0.570111,0.340119,0.764367,0,3.24729,-9.01808,-30.8629,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}'),(662,'458fd645-9952-46e8-a68c-ff2ee3cf1d94','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/smilersorder_a5b8e66e-54fa-4915-91c4-4ae875c9f3ba/13_w4_smilers_file_0.json','JSON','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_PROST_a5b8e66e-54fa-4915-91c4-4ae875c9f3ba_JSON_','2020-12-29 11:01:44','2020-12-29 12:01:43','13_w4_smilers_file_0.json','2020-12-29 12:01:44','SYNCED','458fd645-9952-46e8-a68c-ff2ee3cf1d94',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'45a66afe-8bb2-49b4-b3fc-982c845cf2f2','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_c00beb59-a67d-4566-801a-0081588c2a04/21_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_RISC_c00beb59-a67d-4566-801a-0081588c2a04_ZIP_','2021-11-22 11:46:27','2021-11-22 12:45:00','21_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2021-11-22 12:46:27','SYNCED','45a66afe-8bb2-49b4-b3fc-982c845cf2f2',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.21.1.1.1\",\"modelMatrix\":\"0.99877,0.016182,0.0457803,0,-0.0192084,0.999424,-0.0289803,0,-0.0459172,0.0302338,0.998533,0,13.1616,-3.71206,-20.732,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(662,'45a97d29-279f-4720-856d-2ef701665f93','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_e8ff012c-af85-450f-ba33-bd61c15846e9/22_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_BOSC_e8ff012c-af85-450f-ba33-bd61c15846e9_ZIP_','2021-11-23 11:17:44','2021-11-23 12:14:25','22_w1_o1_mandibule_scan_file_0.zip','2021-11-23 12:17:44','SYNCED','45a97d29-279f-4720-856d-2ef701665f93',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"modelMatrix\":\"0.297612,0.931799,-0.207792,0,-0.954687,0.290477,-0.0647764,0,1.12315e-11,0.217654,0.976026,0,11.0234,-21.5208,-16.5828,1\",\"title\":\"Mandibule ZIP\"}'),(662,'472a6b31-d305-463f-a0b2-2abeb6fa2c3e','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_802e2d49-5b37-47b7-b8e9-4fb4bff1f62f/25_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_TOSC_802e2d49-5b37-47b7-b8e9-4fb4bff1f62f_ZIP_','2022-03-11 10:17:02','2022-03-11 11:13:47','25_w1_o1_maxillaire_scan_file_0.zip','2022-03-11 11:17:02','SYNCED','472a6b31-d305-463f-a0b2-2abeb6fa2c3e',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.25.1.1.1\",\"modelMatrix\":\"0.0832976,0.961401,-0.262239,0,-0.996525,0.0803617,-0.0219201,0,-1.95466e-09,0.263154,0.964754,0,14.2701,-23.5702,-21.6079,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'4743873a-96f6-412f-91c5-a4b27c7d6847','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_snapshot_3.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_SNAPS_','2022-06-27 19:32:31','2022-06-27 20:58:56','21_w2_o1_mandibule_snapshot_3.png','2022-06-27 21:32:31','SYNCED','160153e9-3248-4a6b-b0ff-a10c2c1acfc9',3,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'477bef20-19c4-472b-89d8-912285f5e534','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_87a0a17a-c973-40c2-9d84-2392b0d62afb/10_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_TOSC_87a0a17a-c973-40c2-9d84-2392b0d62afb_SNAPS_','2020-12-29 10:57:57','2020-04-30 19:25:29','10_w1_o1_maxillaire_snapshot_0.png','2020-12-29 11:57:57','SYNCED','477bef20-19c4-472b-89d8-912285f5e534',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.10.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'4782af06-5171-4020-833c-143c6a151469','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_c983b946-e304-49a8-99c8-24eaca67b9ce/occlusion_9e007066-06fd-4fa1-a49a-f1165de95f83/scan_76ece440-81ad-42c8-ab91-f99fa29e2a83/21_w8_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_c983b946-e304-49a8-99c8-24eaca67b9ce_SESS_9e007066-06fd-4fa1-a49a-f1165de95f83_TOSC_76ece440-81ad-42c8-ab91-f99fa29e2a83_SNAPS_','2023-04-11 18:49:11','2023-04-11 20:49:11','21_w8_o1_maxillaire_snapshot_1.png',NULL,'CREATED','a952743c-a21c-4952-8c29-3ac0e894560a',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.8.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'48632fc1-3269-4a7f-bdaa-980e30af0358','','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_PLY_','2020-12-29 10:57:38','2020-04-15 07:35:08','','2020-12-29 11:57:38','SYNCED','e54a3aaa-1b5e-4e05-b9aa-30359687e6de',1,'2020-12-29 11:57:38','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.7.2.2.1\",\"modelMatrix\":\"0.665193,0.645471,-0.375347,0,-0.746672,0.575036,-0.334388,0,2.20888e-8,0.502693,0.864465,0,-12.1421,-33.8974,-48.3616,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'49635be4-dbea-497c-82e1-206399739c31','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_50e1896b-8565-4257-9a61-2a685fff8165/19_w1_o1_mandibule_scan_file_1.ply','PLY','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_BOSC_50e1896b-8565-4257-9a61-2a685fff8165_PLY_','2021-09-27 11:59:57','2021-09-27 12:43:41','19_w1_o1_mandibule_scan_file_1.ply','2021-09-27 13:59:57','SYNCED','ac2e051b-dd4c-4fc1-be89-d406c5ab9a69',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.19.1.1.1\",\"modelMatrix\":\"0.258681,-0.958527,0.119627,0,0.965963,0.25669,-0.0320357,0,1.9715e-9,0.123842,0.992302,0,-20.8805,2.28408,-23.0637,1\",\"title\":\"Mandibule PLY\"}'),(662,'49c43140-7062-4b44-a49e-83c262304d61','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_scan_file_2.ply','PLY','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_PLY_','2020-12-29 10:57:57','2020-04-30 19:54:51','10_w1_o1_mandibule_scan_file_2.ply','2020-12-29 11:57:57','SYNCED','6008312e-ba22-4c98-a696-7500991d7069',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.10.1.1.2\",\"modelMatrix\":\"-0.989861,-0.136915,0.037811,0,0.14204,-0.954145,0.263501,0,-1.96253e-9,0.2662,0.963918,0,19.8396,4.83983,-21.5585,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'4a35756e-57f1-4f26-a7da-64af3396fbad','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_e43c8099-0862-42c3-9ad2-1efef27b83ba/occlusion_09f15124-6bba-4565-bfe4-efb3c6c3a17d/scan_3a315f7b-8cf2-4d0c-bf92-fecb623fe530/21_w3_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_e43c8099-0862-42c3-9ad2-1efef27b83ba_SESS_09f15124-6bba-4565-bfe4-efb3c6c3a17d_TOSC_3a315f7b-8cf2-4d0c-bf92-fecb623fe530_SNAPS_','2022-09-14 10:25:33','2022-09-14 12:23:53','21_w3_o1_maxillaire_snapshot_1.png','2022-09-14 12:25:33','SYNCED','6bc59c6e-9179-4d61-91a6-7cfb0da22a7a',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'4a84b07a-6e20-4dea-85d3-199cb3adf0f5','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_e8ff012c-af85-450f-ba33-bd61c15846e9/22_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_BOSC_e8ff012c-af85-450f-ba33-bd61c15846e9_SNAPS_','2021-11-23 11:15:49','2021-11-23 12:14:24','22_w1_o1_mandibule_snapshot_0.png','2021-11-23 12:15:49','SYNCED','4a84b07a-6e20-4dea-85d3-199cb3adf0f5',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'4acfe34d-f60d-43a0-bed4-9a53302e03f0','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_2d566d37-f38f-4b79-ac8f-48009ae22310/6_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_TOSC_2d566d37-f38f-4b79-ac8f-48009ae22310_SNAPS_','2020-12-29 10:57:57','2020-04-10 11:37:04','6_w1_o1_maxillaire_snapshot_0.png','2020-12-29 11:57:57','SYNCED','4acfe34d-f60d-43a0-bed4-9a53302e03f0',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'4b136eb3-b01e-4166-a154-4539e20f9fea','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_4a2eec76-a5f3-44f0-b389-4734998fa2d3/13_w4_o1_mandibule_scan_file_2.ply','PLY','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_BOSC_4a2eec76-a5f3-44f0-b389-4734998fa2d3_PLY_','2020-12-29 11:14:29','2020-12-29 11:28:31','13_w4_o1_mandibule_scan_file_2.ply','2020-12-29 12:14:29','SYNCED','2b6d557d-ea43-42a5-bd7d-859d5a90f1a6',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.13.4.1.1\",\"modelMatrix\":\"-0.820938,0.563368,-0.0931513,0,-0.571017,-0.809941,0.133921,0,-6.12112e-9,0.163132,0.986604,0,19.1304,-2.19336,-20.055,1\",\"title\":\"Mandibule PLY\"}'),(662,'4b5c8093-db62-4195-8bba-5349a152c006','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/computedocclusion_bdf42f40-5a7a-435b-a5e0-eb3migraoccl/6_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_OCC_bdf42f40-5a7a-435b-a5e0-eb3migraoccl_BOMA__MATRX_','2020-12-29 10:57:58','2020-04-10 11:52:17','6_w1_o1_mandibule_matrix_occ_file_0.m','2020-12-29 11:57:58','SYNCED','4b5c8093-db62-4195-8bba-5349a152c006',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.6.1.1\",\"title\":\"Matrice Transfo. Mandibule MATRIX\"}'),(662,'4b797e84-44dc-4df1-9b19-d421afa9bb08','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_876f775b-e8a0-4b7f-bea0-0c93a7041d17/13_w4_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_LESC_876f775b-e8a0-4b7f-bea0-0c93a7041d17_SNAPS_','2021-06-08 17:43:31','2020-12-29 11:33:10','13_w4_o1_mordu_posterieur_gauche_snapshot_0.png','2021-06-08 19:43:31','SYNCED','4b797e84-44dc-4df1-9b19-d421afa9bb08',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.13.4.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'4df1d6c0-6d77-4547-ae20-f797167f57b2','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_scan_file_6.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_PLY_','2021-02-01 19:58:07','2021-02-01 20:56:49','14_w1_o1_maxillaire_scan_file_6.ply','2021-02-01 20:58:07','SYNCED','e720e2f6-8dce-43f4-a5d6-bf8c09037947',6,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.972671,0.219774,-0.0749072,0,-0.232189,-0.920663,0.313796,0,-1.00838e-8,0.322613,0.946531,0,3.12521,-22.9729,-20.4758,1\",\"title\":\"Maxillaire PLY\"}'),(662,'4e355e83-f72e-471f-a217-6dc5ae2fd8aa','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_0d792709-57f3-49e1-963c-d2dc35a59d12/16_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PLY','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_LESC_0d792709-57f3-49e1-963c-d2dc35a59d12_PLY_','2021-02-27 09:56:13','2021-02-27 10:55:29','16_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','2021-02-27 10:56:13','SYNCED','4e355e83-f72e-471f-a217-6dc5ae2fd8aa',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.16.1.1.1\",\"modelMatrix\":\"-0.858745,-0.116475,0.502467,0,0.27595,-0.892272,0.327566,0,0.434036,0.438434,0.800166,0,-3.20598,-9.41496,-26.1205,1\",\"title\":\"Mordu posterieur gauche PLY\"}'),(662,'4ec9ee9c-a56b-483d-ba09-9dc992d7e79c','','SNAPS','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_2ed4960a-e6fa-46de-a306-32385df3346c_BOSC_45b21304-1129-40a2-b60e-d72a2bf96e72_SNAPS_','2020-12-29 10:57:39','2020-04-12 08:05:48','','2020-12-29 11:57:39','SYNCED','7d1b5372-e89a-471e-8230-71dba1f47677',1,'2020-12-29 11:57:39','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.2.3.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'4f638684-087b-42a0-916a-a8adc0c1eeea','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_42b09cf6-e30d-4d35-a17d-d8e8b4564638/20_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_TOSC_42b09cf6-e30d-4d35-a17d-d8e8b4564638_ZIP_','2021-10-12 12:40:06','2021-10-12 12:37:46','20_w1_o1_maxillaire_scan_file_1.zip','2021-10-12 14:40:06','SYNCED','3b5b5fb9-a2cd-4386-9406-17bd2384e1ae',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.20.1.1.1\",\"modelMatrix\":\"0.322976,0.912912,-0.249555,0,-0.946407,0.311546,-0.0851648,0,4.13598e-9,0.263687,0.964608,0,-7.27814,-21.2146,-22.2509,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'506aaec6-4b3a-4a00-9e18-ddc95eb010f4','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_9716867f-e0a3-478a-a498-1e84ae803044/21_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_LESC_9716867f-e0a3-478a-a498-1e84ae803044_ZIP_','2021-11-22 11:47:53','2021-11-22 12:45:44','21_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2021-11-22 12:47:53','SYNCED','506aaec6-4b3a-4a00-9e18-ddc95eb010f4',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"modelMatrix\":\"-0.979327,-0.19794,-0.0323168,0,0.199218,-0.909497,-0.368149,0,0.0360368,-0.365565,0.929242,0,-7.63668,9.57847,-19.1431,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(662,'517e0273-72a1-4e4d-8815-d303a233a31d','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_e9134dab-33d6-42e4-8779-ab502b18266c/7_w4_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_TOSC_e9134dab-33d6-42e4-8779-ab502b18266c_SNAPS_','2020-12-29 10:57:58','2020-04-16 11:05:55','7_w4_o1_maxillaire_snapshot_2.png','2020-12-29 11:57:58','SYNCED','449406e4-68d2-4fa1-9032-2e72795a7ec2',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.7.4.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'51c81dd7-f872-4092-9a17-d9b3821ed7c8','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b5005e42-2d4d-41b0-91d5-667275f3a9cc/10_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PLY','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_RISC_b5005e42-2d4d-41b0-91d5-667275f3a9cc_PLY_','2020-12-29 10:57:59','2020-04-30 20:00:05','10_w1_o1_mordu_posterieur_droit_scan_file_0.ply','2020-12-29 11:57:59','SYNCED','51c81dd7-f872-4092-9a17-d9b3821ed7c8',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.10.1.1.1\",\"modelMatrix\":\"0.970166,-0.0451177,0.236343,0,0.0599288,0.995192,-0.0709438,0,-0.234978,0.087108,0.969085,0,-4.85849,-3.4382,-21.1955,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(662,'51f476ba-752c-4dbb-8096-f63ffa200322','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/computedocclusion_a18ca6df-d765-4c6a-be28-13amigraoccl/6_w1_o2_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_OCC_a18ca6df-d765-4c6a-be28-13amigraoccl_TOMA__MATRX_','2020-12-29 10:57:59','2020-04-17 11:21:05','6_w1_o2_maxillaire_matrix_occ_file_0.m','2020-12-29 11:57:59','SYNCED','51f476ba-752c-4dbb-8096-f63ffa200322',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.6.1.2\",\"title\":\"Matrice Transfo. Maxillaire MATRIX\"}'),(662,'520242d1-a563-40d8-b43b-1c26fd0f28ff','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_586a7c87-5d8a-440f-a654-c452dc908844/occlusion_d70cc224-5e0d-4b47-9270-d8e23a25b566/scan_0e5656e0-946b-41b2-935b-ea820746e5a9/19_w4_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_586a7c87-5d8a-440f-a654-c452dc908844_SESS_d70cc224-5e0d-4b47-9270-d8e23a25b566_TOSC_0e5656e0-946b-41b2-935b-ea820746e5a9_SNAPS_','2023-03-21 11:30:55','2023-03-21 12:27:26','19_w4_o1_maxillaire_snapshot_1.png','2023-03-21 12:30:55','SYNCED','bad6504a-4f54-4dc9-83e3-02475160f717',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.4.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'520d0710-d923-46c1-a1dd-f05370a3a5ea','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_79548cb6-a61f-44cb-b6f7-cab7698f7465/14_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_RISC_79548cb6-a61f-44cb-b6f7-cab7698f7465_PLY_','2021-02-01 20:13:01','2021-02-01 21:12:36','14_w1_o1_mordu_posterieur_droit_scan_file_0.ply','2021-02-01 21:13:01','SYNCED','520d0710-d923-46c1-a1dd-f05370a3a5ea',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.14.1.1.1\",\"modelMatrix\":\"0.998532,-0.0354503,-0.0422502,0,0.0245382,0.980179,-0.193733,0,0.048334,0.194944,0.980148,0,10.0643,-4.18965,-19.1418,1\",\"title\":\"Mordu posterieur droit PLY\"}'),(662,'536f2d6d-667c-4e47-bf9c-c77be612a54a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/406a8572-4b0f-480a-ad2e-daf5530143b6/session_100a15d0-4590-4544-9331-365a087a5b57/occlusion_348477f7-c7a9-4bb3-8b28-3da592902286/scan_12f64013-f8aa-44bb-91e8-38c23737152b/2_w5_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_100a15d0-4590-4544-9331-365a087a5b57_SESS_348477f7-c7a9-4bb3-8b28-3da592902286_TOSC_12f64013-f8aa-44bb-91e8-38c23737152b_SNAPS_','2020-12-29 10:58:00','2020-04-29 14:50:36','2_w5_o1_maxillaire_snapshot_0.png','2020-12-29 11:58:00','SYNCED','536f2d6d-667c-4e47-bf9c-c77be612a54a',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.2.5.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'53ebdc66-a057-4dc0-8a89-3e9bc7e5d11d','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_ed495283-b756-4052-ba8b-5fe9f9b1f8be/19_w3_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_TOSC_ed495283-b756-4052-ba8b-5fe9f9b1f8be_ZIP_','2022-11-02 17:40:34','2022-11-02 12:26:50','19_w3_o1_maxillaire_scan_file_0.zip','2022-11-02 18:40:34','SYNCED','53ebdc66-a057-4dc0-8a89-3e9bc7e5d11d',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.3.1.1\",\"modelMatrix\":\"0.999961,0.00799696,-0.00365457,0,-0.00879246,0.90949,-0.415632,0,-1.43557e-10,0.415648,0.909525,0,-23.2937,3.70277,-19.5102,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'5498794c-1fcc-48dd-b50e-b57ca5d157ab','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_be9a4ba5-715b-4547-a31d-66621ec7b17f/14_w2_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_TOSC_be9a4ba5-715b-4547-a31d-66621ec7b17f_PLY_','2021-06-08 18:13:45','2021-06-08 20:11:20','14_w2_o1_maxillaire_scan_file_0.ply','2021-06-08 20:13:45','SYNCED','5498794c-1fcc-48dd-b50e-b57ca5d157ab',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.2.1.1\",\"modelMatrix\":\"0.745896,0.665976,-0.010717,0,-0.666062,0.7458,-0.0120016,0,-8.36857e-11,0.0160902,0.99987,0,-12.7515,-0.602183,-24.4728,1\",\"title\":\"Maxillaire PLY\"}'),(662,'55cd923a-d543-4e42-8f4a-de07877d1b09','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_a6d52fce-2e61-4375-bf6d-a36f9b3eb72f/20_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_LESC_a6d52fce-2e61-4375-bf6d-a36f9b3eb72f_SNAPS_','2021-10-12 12:30:37','2021-10-12 12:42:38','20_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2021-10-12 14:30:37','SYNCED','55cd923a-d543-4e42-8f4a-de07877d1b09',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.20.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'569cf3b9-ec78-4231-a836-d4fe2c1273c0','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_437ef945-eb42-4841-9b20-34804bd5cfd6/14_w2_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_BOSC_437ef945-eb42-4841-9b20-34804bd5cfd6_SNAPS_','2021-06-08 18:46:44','2021-06-08 20:46:38','14_w2_o1_mandibule_snapshot_1.png','2021-06-08 20:46:44','SYNCED','1f92b4ea-73e7-423b-8d75-46b280f139d9',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.14.2.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'587c45f4-d25d-4cad-8934-761b77e11986','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_c00beb59-a67d-4566-801a-0081588c2a04/21_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_RISC_c00beb59-a67d-4566-801a-0081588c2a04_SNAPS_','2021-11-22 11:49:44','2021-11-22 12:44:59','21_w1_o1_mordu_posterieur_droit_snapshot_0.png','2021-11-22 12:49:44','SYNCED','587c45f4-d25d-4cad-8934-761b77e11986',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.21.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'58f5907e-16f5-4910-b9e6-81046fdd76df','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5/6_w1_o2_maxillaire_scan_file_0.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_TOSC_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5_PLY_','2020-12-29 10:58:00','2020-04-17 10:58:56','6_w1_o2_maxillaire_scan_file_0.ply','2020-12-29 11:58:00','SYNCED','58f5907e-16f5-4910-b9e6-81046fdd76df',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.6.1.2.1\",\"modelMatrix\":\"-0.709561,0.699017,-0.0888712,0,-0.704644,-0.703895,0.0894914,0,-3.09832e-9,0.126122,0.992015,0,3.11906,-19.7171,-26.8926,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'59ebc4a1-1711-4a3b-ac06-f55565453d6a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_SNAPS_','2021-02-01 19:35:32','2021-02-01 20:35:28','14_w1_o1_maxillaire_snapshot_2.png','2021-02-01 20:35:32','SYNCED','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'59f86cb7-d0b5-456d-bb86-a5a83efb559d','','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_76f39717-6f88-4e19-800c-f827a697a4d6_SNAPS_','2020-12-29 10:57:39','2020-04-16 07:05:20','','2020-12-29 11:57:39','SYNCED','59f86cb7-d0b5-456d-bb86-a5a83efb559d',0,'2020-12-29 11:57:39','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule Occlusion 1.7.2.2\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(662,'5b5466a1-e0a0-4b4b-8dd8-e9f815b047c0','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_7a39120e-2f79-4c3e-af4d-af72e8ca8062/15_w1_o1_mordu_posterieur_gauche_snapshot_1.png','SNAPS','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_LESC_7a39120e-2f79-4c3e-af4d-af72e8ca8062_SNAPS_','2021-02-16 12:00:24','2021-02-16 13:00:22','15_w1_o1_mordu_posterieur_gauche_snapshot_1.png','2021-02-16 13:00:24','SYNCED','9fa4fa76-ae1b-496c-bc61-9c8652c7f3d6',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.15.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'5ba33ea9-efd2-4c3f-b859-372b495c2e78','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_scan_file_2.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_PLY_','2021-02-01 19:36:37','2021-02-01 20:35:28','14_w1_o1_maxillaire_scan_file_2.ply','2021-02-01 20:36:37','SYNCED','e720e2f6-8dce-43f4-a5d6-bf8c09037947',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.999994,-0.00324516,0.000993101,0,0.00339371,-0.95622,0.292628,0,-1.80461e-11,0.29263,0.956226,0,6.1197,-20.7159,-21.6008,1\",\"title\":\"Maxillaire PLY\"}'),(662,'5bdd9b13-0942-46d1-92ac-4b22472007ae','','PLY','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_TOSC_fbfa4372-1faf-4a14-9f4e-70b7b375da7d_PLY_','2020-12-29 10:57:39','2020-04-18 09:18:30','','2020-12-29 11:57:39','SYNCED','5bdd9b13-0942-46d1-92ac-4b22472007ae',0,'2020-12-29 11:57:39','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule Occlusion 1.9.1.1\",\"modelMatrix\":\"0.222517,0.971298,-0.0840585,0,-0.974929,0.221688,-0.0191854,0,-1.29821e-9,0.0862201,0.996276,0,-1.81183,-1.13461,-10.0849,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'5c2ae31f-cf6e-42c8-9d38-6f41e1e8db02','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_d675acff-ab7f-4d65-b55c-558379a8b3d0/23_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_LESC_d675acff-ab7f-4d65-b55c-558379a8b3d0_ZIP_','2022-01-11 11:42:18','2022-01-11 12:39:02','23_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-01-11 12:42:18','SYNCED','5c2ae31f-cf6e-42c8-9d38-6f41e1e8db02',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.23.1.1.1\",\"modelMatrix\":\"-0.920954,-0.163259,0.356869,0,0.137547,-0.986573,-0.0612914,0,0.364705,-0.0162589,0.932237,0,3.48454,4.97084,-20.3055,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(662,'5c922725-b41b-4e38-a244-6a9a320d291e','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/computedocclusion_bdf42f40-5a7a-435b-a5e0-eb3migraoccl/6_w1_o1_mandibule_occlusion_occ_file_0.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_OCC_bdf42f40-5a7a-435b-a5e0-eb3migraoccl_BOPLY__PLY_','2020-12-29 10:58:00','2020-04-10 11:52:17','6_w1_o1_mandibule_occlusion_occ_file_0.ply','2020-12-29 11:58:00','SYNCED','5c922725-b41b-4e38-a244-6a9a320d291e',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule Occlusion 1.6.1.1.1\",\"referenceScanID\":\"1.6.1.1.1\",\"title\":\"Mandibule Occlusion PLY\"}'),(662,'5c991e5c-3b6f-409c-839c-1ed086c26caf','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_79548cb6-a61f-44cb-b6f7-cab7698f7465/14_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_RISC_79548cb6-a61f-44cb-b6f7-cab7698f7465_SNAPS_','2021-02-01 20:12:37','2021-02-01 21:12:36','14_w1_o1_mordu_posterieur_droit_snapshot_0.png','2021-02-01 21:12:37','SYNCED','5c991e5c-3b6f-409c-839c-1ed086c26caf',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.14.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'5d47b05f-f650-11ec-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/5d47b05f-f650-11ec-a752-9ec33d03e6dd.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_ZIP_','2022-06-27 19:35:47','2022-06-27 21:02:22','5d47b05f-f650-11ec-a752-9ec33d03e6dd.zip','2022-06-27 21:35:47','SYNCED','5d47b05f-f650-11ec-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"modelMatrix\":\"-0.976298,-0.210823,0.0489521,0,0.216432,-0.950998,0.220817,0,-2.3765e-10,0.226178,0.974086,0,10.9881,11.8679,-20.8564,1\",\"title\":\"Mandibule ZIP\"}'),(662,'5d497163-f650-11ec-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/5d497163-f650-11ec-a752-9ec33d03e6dd.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_SNAPS_','2022-06-27 19:33:35','2022-06-27 21:02:19','5d497163-f650-11ec-a752-9ec33d03e6dd.png','2022-06-27 21:33:35','SYNCED','5d497163-f650-11ec-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'5dfbe9b8-c587-4311-b392-743be40fdd10','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_SNAPS_','2021-11-22 11:47:34','2021-11-22 12:30:44','21_w1_o1_mandibule_snapshot_0.png','2021-11-22 12:47:34','SYNCED','5dfbe9b8-c587-4311-b392-743be40fdd10',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'5e1416aa-d0a4-4f50-98c6-8e1f1e6d994d','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_919caf8c-919a-49cc-bf39-68486f2f5991/6_w1_o2_mordu_anterieur_scan_file_0.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_FRSC_919caf8c-919a-49cc-bf39-68486f2f5991_PLY_','2020-12-29 10:58:01','2020-04-17 11:19:52','6_w1_o2_mordu_anterieur_scan_file_0.ply','2020-12-29 11:58:01','SYNCED','5e1416aa-d0a4-4f50-98c6-8e1f1e6d994d',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.6.1.2.1\",\"modelMatrix\":\"0.803599,0.0994624,0.586898,0,0.1055,0.957479,-0.233274,0,-0.586133,0.275977,0.776954,0,9.98439,-10.4134,-31.4327,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}'),(662,'5f33a727-5198-4fcf-af3d-ae94e86da222','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_ZIP_','2022-06-27 19:32:30','2022-06-27 20:53:20','21_w2_o1_mandibule_scan_file_1.zip','2022-06-27 21:32:30','SYNCED','1f29b918-27fd-422b-b4dd-da18687d0871',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"modelMatrix\":\"-0.916906,-0.389784,0.0857374,0,0.399102,-0.895499,0.196975,0,-4.7885e-09,0.214826,0.976652,0,7.49013,13.7993,-21.0213,1\",\"title\":\"Mandibule ZIP\"}'),(662,'5f516c96-8333-49f5-8c71-3a7e8878488c','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_9716867f-e0a3-478a-a498-1e84ae803044/21_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_LESC_9716867f-e0a3-478a-a498-1e84ae803044_ZIP_','2021-11-22 11:50:37','2021-11-22 12:47:34','21_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','2021-11-22 12:50:37','SYNCED','506aaec6-4b3a-4a00-9e18-ddc95eb010f4',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"modelMatrix\":\"-0.947449,-0.317073,-0.0557049,0,0.311962,-0.870195,-0.378767,0,0.070887,-0.377135,0.923815,0,-13.1535,4.28606,-27.5789,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(662,'5fe946a4-d7b1-4c37-a75f-cda8a073daf9','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_a26f0d58-ca46-4921-a9e1-9c39b7f89783/13_w4_o1_maxillaire_scan_file_1.ply','PLY','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_TOSC_a26f0d58-ca46-4921-a9e1-9c39b7f89783_PLY_','2020-12-29 11:07:40','2020-12-29 11:05:41','13_w4_o1_maxillaire_scan_file_1.ply','2020-12-29 12:07:40','SYNCED','23251874-b8f3-48b3-b209-0b434edd5db0',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.13.4.1.1\",\"modelMatrix\":\"-0.89024,0.444444,-0.0997069,0,-0.455491,-0.86865,0.194873,0,1.75316e-9,0.2189,0.975747,0,10.9035,-11.3815,-23.882,1\",\"title\":\"Maxillaire PLY\"}'),(662,'6008312e-ba22-4c98-a696-7500991d7069','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_scan_file_0.ply','PLY','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_PLY_','2020-12-29 10:58:01','2020-04-30 19:47:40','10_w1_o1_mandibule_scan_file_0.ply','2020-12-29 11:58:01','SYNCED','6008312e-ba22-4c98-a696-7500991d7069',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.10.1.1.2\",\"modelMatrix\":\"-0.991072,-0.129381,0.0321926,0,0.133326,-0.961748,0.239303,0,-1.16605e-10,0.241458,0.970411,0,20.8935,7.05365,-21.3854,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'6026647a-901e-4a90-bd11-8ec6d1883285','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_57e7671e-1671-4ee9-96a0-650a56963aa8/16_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_FRSC_57e7671e-1671-4ee9-96a0-650a56963aa8_SNAPS_','2021-02-27 09:59:00','2021-02-27 10:58:59','16_w1_o1_mordu_anterieur_snapshot_0.png','2021-02-27 10:59:00','SYNCED','6026647a-901e-4a90-bd11-8ec6d1883285',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.16.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'60418949-4776-4ecc-898e-ee8453d29ba9','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_26a765d3-8b92-4861-984a-bd9c8040209b/25_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_BOSC_26a765d3-8b92-4861-984a-bd9c8040209b_SNAPS_','2022-03-11 09:32:40','2022-03-11 10:31:23','25_w1_o1_mandibule_snapshot_1.png','2022-03-11 10:32:40','SYNCED','7f09064b-ad1e-4cc1-9d0b-40bde9e22dff',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'60447943-1739-4e3f-aced-0eb015c274a2','','PDF','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_PROST_fb151d98-0604-45ed-8599-26fa11975b19_PDF_','2020-04-15 04:59:18','2020-04-13 07:59:28','','2020-04-15 06:59:18','SYNCED','60447943-1739-4e3f-aced-0eb015c274a2',0,'2020-04-15 06:59:18','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"ODF 1.2.2.2 ODF\",\"title\":\"Odf PDF\"}'),(662,'60a7c19d-824d-4fdf-a109-f3df643a3f1a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_snapshot_3.png','SNAPS','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_SNAPS_','2020-12-29 10:58:02','2020-04-30 19:57:58','10_w1_o1_mandibule_snapshot_3.png','2020-12-29 11:58:02','SYNCED','f3f82ebd-8318-469e-9bdd-ff76223b9c1c',3,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.10.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'60b6e24d-83ab-4528-953e-a72aae732f49','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_SNAPS_','2021-02-01 19:35:32','2021-02-01 20:28:14','14_w1_o1_maxillaire_snapshot_1.png','2021-02-01 20:35:32','SYNCED','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'621b6179-82c4-4d83-a1ec-4b5eb2545a81','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_57cfef6d-c27e-45fa-81d7-e63b4f8c4429/6_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_RISC_57cfef6d-c27e-45fa-81d7-e63b4f8c4429_PLY_','2020-12-29 10:58:02','2020-04-10 11:41:52','6_w1_o1_mordu_posterieur_droit_scan_file_0.ply','2020-12-29 11:58:02','SYNCED','621b6179-82c4-4d83-a1ec-4b5eb2545a81',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.6.1.1.1\",\"modelMatrix\":\"0.967684,-0.0911958,0.233449,0,0.119228,0.989884,-0.0860305,0,-0.222268,0.108839,0.968556,0,1.09016,-1.33091,-18.513,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(662,'632a870c-a45a-412b-b369-ac5a4d47afe1','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/smilersorder_1995f588-2757-42b8-8f51-c2e41e0ebe8f/22_w1_smilers_file_0.json','JSON','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_PROST_1995f588-2757-42b8-8f51-c2e41e0ebe8f_JSON_','2021-11-23 11:24:17','2021-11-23 12:24:09','22_w1_smilers_file_0.json','2021-11-23 12:24:17','SYNCED','632a870c-a45a-412b-b369-ac5a4d47afe1',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'632bdd11-c86e-438a-af78-cfcc9f793d03','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_be9a4ba5-715b-4547-a31d-66621ec7b17f/14_w2_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_TOSC_be9a4ba5-715b-4547-a31d-66621ec7b17f_SNAPS_','2021-06-08 18:19:59','2021-06-08 20:19:55','14_w2_o1_maxillaire_snapshot_2.png','2021-06-08 20:19:59','SYNCED','13fa1125-c9d0-498d-bc50-68dc9f4f1beb',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'6420c2d7-bcdf-4e2e-9ee7-e90e3b7b7045','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_a90158f7-0d39-4b9d-984b-57de06099c65/21_w1_o1_maxillaire_scan_file_2.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_ZIP_','2021-11-22 11:31:19','2021-11-22 12:28:58','21_w1_o1_maxillaire_scan_file_2.zip','2021-11-22 12:31:19','SYNCED','8396da09-c9ea-476d-ab69-648f06ec6534',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"modelMatrix\":\"0.637136,0.767927,-0.0659177,0,-0.770751,0.634802,-0.0544904,0,4.04895e-9,0.0855239,0.996336,0,-16.373,-8.74215,-20.4029,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'648cf438-b183-47f5-a0f7-c8a3e2e416c8','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a/14_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_LESC_7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a_SNAPS_','2021-02-01 20:19:47','2021-02-01 21:19:45','14_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2021-02-01 21:19:47','SYNCED','648cf438-b183-47f5-a0f7-c8a3e2e416c8',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.14.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'6558fea4-267a-4a73-8416-579630e68249','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2a050d02-7424-4099-b1d0-2d7da678e690/occlusion_a5bc2d6f-0248-466f-a10b-08f5391fd12f/scan_d2cd260d-4191-4884-80e3-7ced9fa0f8ce/21_w5_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2a050d02-7424-4099-b1d0-2d7da678e690_SESS_a5bc2d6f-0248-466f-a10b-08f5391fd12f_TOSC_d2cd260d-4191-4884-80e3-7ced9fa0f8ce_ZIP_','2022-12-14 14:02:16','2022-11-04 13:42:02','21_w5_o1_maxillaire_scan_file_0.zip','2022-12-14 15:02:16','SYNCED','6558fea4-267a-4a73-8416-579630e68249',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.5.1.2\",\"modelMatrix\":\"0.831457,0.551906,-0.0638702,0,-0.55559,0.825944,-0.0955836,0,2.47096e-09,0.114959,0.99337,0,-27.5141,-15.8126,-25.61,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'6578f0f2-99f0-4b42-b32d-3bfc8a7b4697','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_e9134dab-33d6-42e4-8779-ab502b18266c/7_w4_o1_maxillaire_scan_file_1.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_TOSC_e9134dab-33d6-42e4-8779-ab502b18266c_PLY_','2020-12-29 10:58:02','2020-04-16 11:01:03','7_w4_o1_maxillaire_scan_file_1.ply','2020-12-29 11:58:02','SYNCED','40c9dd9e-b85c-4ed6-a37e-81b5b8e9124d',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.7.4.1.1\",\"modelMatrix\":\"0.819541,0.559981,-0.121547,0,-0.57302,0.800892,-0.173838,0,-7.97328e-9,0.212116,0.977244,0,-6.25362,-22.098,-27.5473,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'65867250-5b1d-4a93-b4d9-d00468a4d2fa','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_ZIP_','2021-11-22 11:43:18','2021-11-22 12:38:44','21_w1_o1_mandibule_scan_file_2.zip','2021-11-22 12:43:18','SYNCED','3aa92b1f-240d-45e1-a722-e8da98368f3a',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"modelMatrix\":\"-0.99017,-0.134891,0.0369673,0,0.139865,-0.954959,0.261709,0,1.04452e-9,0.264307,0.964438,0,19.475,8.78369,-21.2441,1\",\"title\":\"Mandibule ZIP\"}'),(662,'664cb06d-0960-4f9e-9c04-b9080d0ba7c2','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_13e9c4af-5ddc-4a12-ae1b-2b802c735c3f/9_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_FRSC_13e9c4af-5ddc-4a12-ae1b-2b802c735c3f_SNAPS_','2020-12-29 10:58:03','2020-04-18 09:37:59','9_w1_o1_mordu_anterieur_snapshot_0.png','2020-12-29 11:58:03','SYNCED','664cb06d-0960-4f9e-9c04-b9080d0ba7c2',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.9.1.1.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}'),(662,'67590a8b-fee2-4fa0-bc4c-133c68953810','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/smilersorder_23e375bd-b901-4423-96cd-1e2b8ffc55cd/13_w4_smilers_file_0.json','JSON','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_PROST_23e375bd-b901-4423-96cd-1e2b8ffc55cd_JSON_','2020-12-29 11:10:33','2020-12-29 12:09:26','13_w4_smilers_file_0.json','2020-12-29 12:10:33','SYNCED','67590a8b-fee2-4fa0-bc4c-133c68953810',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'675a601d-d389-403d-858d-555ff6166630','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/computedocclusion_bdf42f40-5a7a-435b-a5e0-eb3migraoccl/6_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_OCC_bdf42f40-5a7a-435b-a5e0-eb3migraoccl_SNAPO__SNAPS_','2020-12-29 10:58:03','2020-04-10 11:52:17','6_w1_o1_snapshot_occ_file_0.png','2020-12-29 11:58:03','SYNCED','675a601d-d389-403d-858d-555ff6166630',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Snapshot 1.6.1.1\",\"title\":\"Snapshot SNAPSHOT\"}'),(662,'6771d7ca-3bca-47bd-a554-166ba1db633b','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_scan_file_3.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_ZIP_','2023-01-11 12:44:37','2023-01-11 12:37:42','21_w7_o1_mandibule_scan_file_3.zip','2023-01-11 13:44:37','SYNCED','097b9793-f270-498e-9cfe-cf6bc2963744',3,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"modelMatrix\":\"0.999992,0.00405771,-0.0006493,0,-0.00410933,0.98743,-0.158005,0,-4.66471e-11,0.158006,0.987438,0,-23.6056,-12.6921,-21.8912,1\",\"title\":\"Mandibule ZIP\"}'),(662,'68061e27-8872-4682-9ba9-a57f6a95d8d3','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_19627cd9-e6e6-4c6f-9a62-46d708ca49bc/16_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_BOSC_19627cd9-e6e6-4c6f-9a62-46d708ca49bc_SNAPS_','2021-02-27 09:43:35','2021-02-27 10:43:29','16_w1_o1_mandibule_snapshot_0.png','2021-02-27 10:43:35','SYNCED','68061e27-8872-4682-9ba9-a57f6a95d8d3',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.16.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'687b8177-c7c5-42f4-8937-a0b8e331f674','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_37ff1278-3dd1-470a-8159-e763f6626f5d/6_w1_o2_mandibule_snapshot_1.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_BOSC_37ff1278-3dd1-470a-8159-e763f6626f5d_SNAPS_','2020-12-29 10:58:04','2020-04-17 11:12:10','6_w1_o2_mandibule_snapshot_1.png','2020-12-29 11:58:04','SYNCED','f297816f-db2c-4167-bd60-28d3e93bb7c9',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.6.1.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'689b438f-3633-4981-b669-5e49a97a5c95','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_848b25bd-90a8-4105-871d-f9326fe94c7b/occlusion_ba7da56a-5a10-4378-a887-8e98aa892a3c/scan_b002027b-930d-4b96-a687-453aeea5659e/21_w6_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_848b25bd-90a8-4105-871d-f9326fe94c7b_SESS_ba7da56a-5a10-4378-a887-8e98aa892a3c_TOSC_b002027b-930d-4b96-a687-453aeea5659e_ZIP_','2022-12-21 11:17:41','2022-12-21 12:14:32','21_w6_o1_maxillaire_scan_file_1.zip','2022-12-21 12:17:41','SYNCED','fad00b24-cf95-4da0-aa56-8c7af1870289',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.6.1.1\",\"modelMatrix\":\"-0.98152,0.181469,-0.0607201,0,-0.191358,-0.930797,0.311448,0,-2.35099e-09,0.317312,0.948321,0,15.3508,-15.1772,-24.8569,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'6918be85-b74b-4069-b2b3-914477ca77ad','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_f0b63e95-26e8-4213-a935-ca2c37ab36ba/23_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_BOSC_f0b63e95-26e8-4213-a935-ca2c37ab36ba_ZIP_','2022-01-11 11:37:40','2022-01-11 12:35:42','23_w1_o1_mandibule_scan_file_1.zip','2022-01-11 12:37:40','SYNCED','d2ffe250-09d3-47fd-af00-7d6cc98742d8',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"modelMatrix\":\"-0.841721,0.469057,-0.267377,0,-0.539912,-0.731259,0.41684,0,-1.10031e-8,0.495224,0.868765,0,14.7201,-8.7337,-18.0275,1\",\"title\":\"Mandibule ZIP\"}'),(662,'6ad36229-9d4a-4773-85c5-492f1965bc80','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_453abb20-3827-4f8b-b57f-c656c72ebf11/20_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_BOSC_453abb20-3827-4f8b-b57f-c656c72ebf11_SNAPS_','2021-10-12 12:37:44','2021-10-12 12:22:48','20_w1_o1_mandibule_snapshot_0.png','2021-10-12 14:37:44','SYNCED','6ad36229-9d4a-4773-85c5-492f1965bc80',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule SNAPSHOT\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'6b4f036d-deed-43fa-b8c0-889e20bb7692','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/computedocclusion_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd/25_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_OCC_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd_BOPLY__ZIP_','2022-06-27 19:31:23','2022-03-11 11:16:26','25_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-06-27 21:31:23','SYNCED','6b4f036d-deed-43fa-b8c0-889e20bb7692',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.25.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.25.1.1.1\",\"title\":\"Mandibule 1.25.1.1.1 Occlusion 1\"}'),(662,'6bc59c6e-9179-4d61-91a6-7cfb0da22a7a','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_e43c8099-0862-42c3-9ad2-1efef27b83ba/occlusion_09f15124-6bba-4565-bfe4-efb3c6c3a17d/scan_3a315f7b-8cf2-4d0c-bf92-fecb623fe530/21_w3_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_e43c8099-0862-42c3-9ad2-1efef27b83ba_SESS_09f15124-6bba-4565-bfe4-efb3c6c3a17d_TOSC_3a315f7b-8cf2-4d0c-bf92-fecb623fe530_SNAPS_','2022-09-14 10:23:58','2022-09-14 12:19:51','21_w3_o1_maxillaire_snapshot_0.png','2022-09-14 12:23:58','SYNCED','6bc59c6e-9179-4d61-91a6-7cfb0da22a7a',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'6bd04ecb-23d6-4510-a353-c2b68dba5457','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_0a606279-3c91-4220-b876-e620d1bf52f6/9_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_BOSC_0a606279-3c91-4220-b876-e620d1bf52f6_SNAPS_','2020-12-29 10:58:04','2020-04-18 09:32:12','9_w1_o1_mandibule_snapshot_0.png','2020-12-29 11:58:04','SYNCED','6bd04ecb-23d6-4510-a353-c2b68dba5457',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.9.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'6e406955-1a72-4b3a-8063-b460b758c328','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_13e9c4af-5ddc-4a12-ae1b-2b802c735c3f/9_w1_o1_mordu_anterieur_scan_file_0.ply','PLY','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_FRSC_13e9c4af-5ddc-4a12-ae1b-2b802c735c3f_PLY_','2020-12-29 10:58:04','2020-04-18 09:37:59','9_w1_o1_mordu_anterieur_scan_file_0.ply','2020-12-29 11:58:04','SYNCED','6e406955-1a72-4b3a-8063-b460b758c328',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.9.1.1.1\",\"modelMatrix\":\"0.837632,0.229018,0.500227,0,-0.0839393,0.934442,-0.320111,0,-0.541135,0.278075,0.805595,0,1.32498,-11.4951,-31.7428,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}'),(662,'6e7d5030-f9a6-4e4d-baf7-7a0f3c335bfc','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_ccd3f4f6-f303-4b20-b967-d41121f2e36b/14_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_FRSC_ccd3f4f6-f303-4b20-b967-d41121f2e36b_SNAPS_','2021-02-01 20:22:34','2021-02-01 21:22:33','14_w1_o1_mordu_anterieur_snapshot_0.png','2021-02-01 21:22:34','SYNCED','6e7d5030-f9a6-4e4d-baf7-7a0f3c335bfc',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.14.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'6e9feeb8-6d42-4237-b134-51d979397898','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_e6e5d8c5-2d8c-48d0-9708-e3256202d385/15_w1_o1_mandibule_scan_file_0.ply','PLY','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_BOSC_e6e5d8c5-2d8c-48d0-9708-e3256202d385_PLY_','2021-02-16 11:41:51','2021-02-16 12:40:32','15_w1_o1_mandibule_scan_file_0.ply','2021-02-16 12:41:51','SYNCED','6e9feeb8-6d42-4237-b134-51d979397898',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.15.1.1.1\",\"modelMatrix\":\"-0.941155,0.320097,-0.10847,0,-0.337976,-0.891367,0.302054,0,-5.37293e-9,0.32094,0.947099,0,10.178,0.290729,-14.518,1\",\"title\":\"Mandibule PLY\"}'),(662,'6ea3e979-830a-4dd4-81e2-3d30db702b9c','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_8f3d7d42-f6ad-4e48-8951-08222c212e7e/occlusion_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2/scan_2a466f6b-3960-4b1b-bb27-def76229cccc/21_w4_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_BOSC_2a466f6b-3960-4b1b-bb27-def76229cccc_ZIP_','2022-11-04 11:40:10','2022-11-04 12:31:51','21_w4_o1_mandibule_scan_file_1.zip','2022-11-04 12:40:10','SYNCED','176a7141-81b2-436e-bbb3-00ec6028c71b',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.4.1.1\",\"modelMatrix\":\"-0.869846,0.486339,-0.0827174,0,-0.493324,-0.857531,0.14585,0,-1.01608e-11,0.167674,0.985843,0,18.5559,-1.85864,-18.3689,1\",\"title\":\"Mandibule ZIP\"}'),(662,'6eeaf574-0aa0-4bc8-95c8-5d198f212e39','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_scan_file_5.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_PLY_','2021-02-01 19:53:25','2021-02-01 20:52:02','14_w1_o1_maxillaire_scan_file_5.ply','2021-02-01 20:53:25','SYNCED','e720e2f6-8dce-43f4-a5d6-bf8c09037947',5,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.957476,0.269833,-0.102129,0,-0.288514,-0.895482,0.338929,0,4.52228e-9,0.353982,0.935252,0,2.72857,-24.1516,-19.567,1\",\"title\":\"Maxillaire PLY\"}'),(662,'6f2ff317-b1e7-4c11-b0dd-c5b359491513','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_57cfef6d-c27e-45fa-81d7-e63b4f8c4429/6_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_RISC_57cfef6d-c27e-45fa-81d7-e63b4f8c4429_SNAPS_','2020-12-29 10:58:04','2020-04-10 11:41:52','6_w1_o1_mordu_posterieur_droit_snapshot_0.png','2020-12-29 11:58:04','SYNCED','6f2ff317-b1e7-4c11-b0dd-c5b359491513',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.6.1.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(662,'6f481e07-43c0-494b-8d4f-279772780eec','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_e9aaa539-6e84-47bc-9c50-2c8797de82a4/19_w3_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_LESC_e9aaa539-6e84-47bc-9c50-2c8797de82a4_ZIP_','2022-11-02 14:09:57','2022-11-02 12:34:58','19_w3_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-11-02 15:09:57','SYNCED','6f481e07-43c0-494b-8d4f-279772780eec',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.19.3.1.1\",\"modelMatrix\":\"-0.983417,-0.121012,0.138821,0,0.133349,-0.98274,0.127701,0,0.12304,0.140097,0.982062,0,-8.04084,2.09214,-18.4869,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(662,'6fa55f91-2e1f-436b-b276-b2726e9125b4','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_5a4f6b62-6381-4a1e-bbef-61746f2722d3/23_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_FRSC_5a4f6b62-6381-4a1e-bbef-61746f2722d3_ZIP_','2022-01-11 11:43:25','2022-01-11 12:41:15','23_w1_o1_mordu_anterieur_scan_file_0.zip','2022-01-11 12:43:25','SYNCED','6fa55f91-2e1f-436b-b276-b2726e9125b4',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"modelMatrix\":\"0.84365,0.210589,0.497423,0,-0.180758,0.976383,-0.0219815,0,-0.506998,-0.0651306,0.867814,0,7.25809,0.136189,-25.0684,1\",\"title\":\"Mordu anterieur ZIP\"}'),(662,'6fe553ac-625b-4942-ad10-01bbe5250717','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_snapshot_5.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_SNAPS_','2023-01-11 12:42:18','2023-01-11 12:58:26','21_w7_o1_mandibule_snapshot_5.png','2023-01-11 13:42:18','SYNCED','252b180c-565f-4f14-af48-a16cebbead9e',5,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'729f8772-5a1d-40db-b918-270cc340ba8e','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_e9134dab-33d6-42e4-8779-ab502b18266c/7_w4_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_TOSC_e9134dab-33d6-42e4-8779-ab502b18266c_SNAPS_','2020-12-29 10:58:05','2020-04-16 11:01:03','7_w4_o1_maxillaire_snapshot_1.png','2020-12-29 11:58:05','SYNCED','449406e4-68d2-4fa1-9032-2e72795a7ec2',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.7.4.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'72c86a01-5d0c-47ea-8964-b3832ab6a43f','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_8a4f0a25-fae8-4564-8f4a-63f4168b2915/7_w4_o1_mordu_posterieur_gauche_scan_file_0.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_LESC_8a4f0a25-fae8-4564-8f4a-63f4168b2915_PLY_','2020-12-29 10:58:05','2020-04-16 11:20:50','7_w4_o1_mordu_posterieur_gauche_scan_file_0.ply','2020-12-29 11:58:05','SYNCED','72c86a01-5d0c-47ea-8964-b3832ab6a43f',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.7.4.1.1\",\"modelMatrix\":\"-0.992023,-0.120871,0.0498108,0,0.101981,-0.962967,-0.242479,0,0.0742317,-0.241114,0.968899,0,4.47227,3.75609,-28.3252,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}'),(662,'72efe2fd-185f-4a0a-9205-c14ee08fd1bd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/computedocclusion_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd/25_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_OCC_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd_TOMA__MATRX_','2022-03-11 10:19:11','2022-03-11 11:16:26','25_w1_o1_maxillaire_matrix_occ_file_0.m','2022-03-11 11:19:11','SYNCED','72efe2fd-185f-4a0a-9205-c14ee08fd1bd',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.25.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.25.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.25.1.1.1 Occlusion 1\"}'),(662,'73466738-f8a5-4b0e-a6af-9c63c2e802e6','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_d7c4d383-83f9-4275-bbcc-567a47d4a450/19_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_LESC_d7c4d383-83f9-4275-bbcc-567a47d4a450_SNAPS_','2021-09-27 12:00:42','2021-09-27 12:46:45','19_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2021-09-27 14:00:42','SYNCED','73466738-f8a5-4b0e-a6af-9c63c2e802e6',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.19.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'75fe196b-5c35-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/75fe196b-5c35-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_BOSC_2a466f6b-3960-4b1b-bb27-def76229cccc_ZIP_','2022-11-04 11:40:10','2022-11-04 12:31:51','75fe196b-5c35-11ed-a752-9ec33d03e6dd.zip','2022-11-04 12:40:10','SYNCED','75fe196b-5c35-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.21.4.1.1\",\"modelMatrix\":\"-0.869846,0.486339,-0.0827174,0,-0.493324,-0.857531,0.14585,0,-1.01608e-11,0.167674,0.985843,0,18.5559,-1.85864,-18.3689,1\",\"title\":\"Mandibule ZIP\"}'),(662,'760044a3-5c35-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/760044a3-5c35-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_FRSC_b24d4ab4-dba3-4be5-8ba3-7eee381f40ec_SNAPS_','2022-11-04 11:39:03','2022-11-04 12:34:43','760044a3-5c35-11ed-a752-9ec33d03e6dd.png','2022-11-04 12:39:03','SYNCED','760044a3-5c35-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 1.21.4.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'7601ed6f-5c35-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/7601ed6f-5c35-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_FRSC_b24d4ab4-dba3-4be5-8ba3-7eee381f40ec_ZIP_','2022-11-04 11:37:57','2022-11-04 12:34:44','7601ed6f-5c35-11ed-a752-9ec33d03e6dd.zip','2022-11-04 12:37:57','SYNCED','7601ed6f-5c35-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 1.21.4.1.1\",\"modelMatrix\":\"0.851612,-0.0875762,0.519248,0,0.0198226,0.992855,0.0821935,0,-0.523851,-0.0914267,0.851687,0,-1.52728,6.0236,-29.6291,1\",\"title\":\"Mordu anterieur ZIP\"}'),(662,'76038e2c-5c35-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/76038e2c-5c35-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_BOSC_2a466f6b-3960-4b1b-bb27-def76229cccc_SNAPS_','2022-11-04 11:40:10','2022-11-04 12:31:49','76038e2c-5c35-11ed-a752-9ec33d03e6dd.png','2022-11-04 12:40:10','SYNCED','76038e2c-5c35-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.21.4.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'78194fe5-5ac7-4c4a-ba44-b374602235d5','','SNAPS','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549_SESS_254f3fc9-4782-4658-bb34-f2ca1c9b6382_BOSC_4caeed6a-b015-4556-8794-2c3a00fea341_SNAPS_','2020-12-29 10:57:40','2020-05-21 08:03:19','','2020-12-29 11:57:40','SYNCED','78194fe5-5ac7-4c4a-ba44-b374602235d5',0,'2020-12-29 11:57:40','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.2.6.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'78aec42f-0ec9-4ca8-b05e-324d3b955b86','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_d4c7f3c5-155d-41ef-8665-852e89c5e017/16_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PLY','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_RISC_d4c7f3c5-155d-41ef-8665-852e89c5e017_PLY_','2021-02-27 09:49:03','2021-02-27 10:48:13','16_w1_o1_mordu_posterieur_droit_scan_file_0.ply','2021-02-27 10:49:03','SYNCED','78aec42f-0ec9-4ca8-b05e-324d3b955b86',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.16.1.1.1\",\"modelMatrix\":\"0.986563,-0.164722,-0.0244541,0,0.163417,0.974992,0.143113,0,-0.00273904,-0.149274,0.989419,0,-4.97646,-0.624993,-20.3173,1\",\"title\":\"Mordu posterieur droit PLY\"}'),(662,'78fdec7c-2a35-41bb-8492-82f1c776d061','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_snapshot_3.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_SNAPS_','2022-06-28 18:39:43','2022-06-28 20:34:07','19_w2_o1_maxillaire_snapshot_3.png','2022-06-28 20:39:43','SYNCED','d40f4bba-69b0-4cc6-b541-e69c16b2b3d5',3,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'791a0795-78ad-4b6e-a31b-bdc257f06704','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_00f07cdc-1834-4ae1-a9fa-47699828c094/20_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_RISC_00f07cdc-1834-4ae1-a9fa-47699828c094_SNAPS_','2021-10-12 12:30:37','2021-10-12 12:40:25','20_w1_o1_mordu_posterieur_droit_snapshot_0.png','2021-10-12 14:30:37','SYNCED','791a0795-78ad-4b6e-a31b-bdc257f06704',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.20.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'7935777d-a278-4364-9439-322233eba142','','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_SNAPS_','2020-12-29 10:57:40','2020-04-15 07:29:30','','2020-12-29 11:57:40','SYNCED','7935777d-a278-4364-9439-322233eba142',0,'2020-12-29 11:57:40','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule Occlusion 1.7.2.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'79ba2d1d-77b5-4b68-a71f-efb6c2b2b49d','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_8a4f0a25-fae8-4564-8f4a-63f4168b2915/7_w4_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_LESC_8a4f0a25-fae8-4564-8f4a-63f4168b2915_SNAPS_','2020-12-29 10:58:05','2020-04-16 11:20:50','7_w4_o1_mordu_posterieur_gauche_snapshot_0.png','2020-12-29 11:58:05','SYNCED','79ba2d1d-77b5-4b68-a71f-efb6c2b2b49d',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.7.4.1.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}'),(662,'79cf9af7-3005-4b44-854c-ba038cba5f4b','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_10c9626c-901e-4a0e-8f05-62042bf69c04/7_w4_o1_mandibule_scan_file_0.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_BOSC_10c9626c-901e-4a0e-8f05-62042bf69c04_PLY_','2020-12-29 10:58:06','2020-04-16 11:14:29','7_w4_o1_mandibule_scan_file_0.ply','2020-12-29 11:58:06','SYNCED','79cf9af7-3005-4b44-854c-ba038cba5f4b',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.7.4.1.1\",\"modelMatrix\":\"-0.347109,0.935335,-0.0682968,0,-0.937825,-0.346188,0.0252781,0,-3.27669e-10,0.0728247,0.997345,0,16.5074,-4.63486,-25.5661,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'79d52980-5104-4ca5-9286-27c93d8a0261','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_scan_file_4.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_PLY_','2021-02-01 19:47:27','2021-02-01 20:46:11','14_w1_o1_maxillaire_scan_file_4.ply','2021-02-01 20:47:27','SYNCED','e720e2f6-8dce-43f4-a5d6-bf8c09037947',4,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.986605,0.156151,-0.0471856,0,-0.163125,-0.944428,0.285387,0,3.69232e-10,0.289261,0.95725,0,4.81018,-21.3265,-21.1512,1\",\"title\":\"Maxillaire PLY\"}'),(662,'7a4d7123-69ae-4260-adf1-9661ad22cb0f','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_a90158f7-0d39-4b9d-984b-57de06099c65/21_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_SNAPS_','2021-11-22 11:31:31','2021-11-22 12:28:55','21_w1_o1_maxillaire_snapshot_2.png','2021-11-22 12:31:31','SYNCED','2d1d8d21-ec2c-485d-98af-375a4d8263d6',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'7b9836aa-2cf6-485a-b0d3-39d73de4bc8b','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_453abb20-3827-4f8b-b57f-c656c72ebf11/20_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_BOSC_453abb20-3827-4f8b-b57f-c656c72ebf11_SNAPS_','2021-10-12 12:40:06','2021-10-12 12:26:33','20_w1_o1_mandibule_snapshot_1.png','2021-10-12 14:40:06','SYNCED','6ad36229-9d4a-4773-85c5-492f1965bc80',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.20.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'7cace217-66b4-4147-97f5-c8c1a7dfe1cd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_5a59f382-4b59-4867-8640-021d20bdcd59/19_w3_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_FRSC_5a59f382-4b59-4867-8640-021d20bdcd59_SNAPS_','2022-11-02 14:09:59','2022-11-02 12:36:21','19_w3_o1_mordu_anterieur_snapshot_0.png','2022-11-02 15:09:59','SYNCED','7cace217-66b4-4147-97f5-c8c1a7dfe1cd',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.19.3.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'7cd8a534-43de-41bd-9f1a-216a2bfc251d','','JSON','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_PROST_fb151d98-0604-45ed-8599-26fa11975b19_JSON_','2020-04-15 04:59:18','2020-04-13 07:59:28','','2020-04-15 06:59:18','SYNCED','7cd8a534-43de-41bd-9f1a-216a2bfc251d',0,'2020-04-15 06:59:18','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"ODF 1.2.2.2 ODF\",\"title\":\"Odf JSON\"}'),(662,'7d1b5372-e89a-471e-8230-71dba1f47677','','SNAPS','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_2ed4960a-e6fa-46de-a306-32385df3346c_BOSC_45b21304-1129-40a2-b60e-d72a2bf96e72_SNAPS_','2020-12-29 10:57:40','2020-04-12 07:51:14','','2020-12-29 11:57:40','SYNCED','7d1b5372-e89a-471e-8230-71dba1f47677',0,'2020-12-29 11:57:40','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule Occlusion 1.2.3.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'7df036ea-5778-484f-b08f-26823b06d4e2','','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_78fbbe11-e1a5-4c10-b6e3-4f00df178dc6_SESS_f7b71416-57aa-4d3d-a2e5-0e6c1519f6e8_TOSC_5a5e6904-4736-4443-bbd0-be73066af8c3_SNAPS_','2020-12-29 10:57:40','2020-04-14 12:10:33','','2020-12-29 11:57:40','SYNCED','7df036ea-5778-484f-b08f-26823b06d4e2',0,'2020-12-29 11:57:40','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.7.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'7ee48377-0cc2-4cf4-8d72-837e258ca29f','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_scan_file_2.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_ZIP_','2022-06-28 18:28:52','2022-06-28 20:27:42','19_w2_o1_maxillaire_scan_file_2.zip','2022-06-28 20:28:52','SYNCED','a1bc9da2-af83-43c3-8210-759800158585',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"modelMatrix\":\"-0.952153,0.293973,-0.0835736,0,-0.305622,-0.915862,0.260371,0,1.23643e-08,0.273455,0.961885,0,9.90796,-14.6588,-27.5009,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'7f09064b-ad1e-4cc1-9d0b-40bde9e22dff','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_26a765d3-8b92-4861-984a-bd9c8040209b/25_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_BOSC_26a765d3-8b92-4861-984a-bd9c8040209b_SNAPS_','2022-03-11 09:31:26','2022-03-11 10:26:59','25_w1_o1_mandibule_snapshot_0.png','2022-03-11 10:31:26','SYNCED','7f09064b-ad1e-4cc1-9d0b-40bde9e22dff',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'7f4bb473-7bb6-4ba8-a767-c1e722ce5c1b','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_e9134dab-33d6-42e4-8779-ab502b18266c/7_w4_o1_maxillaire_scan_file_2.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_TOSC_e9134dab-33d6-42e4-8779-ab502b18266c_PLY_','2020-12-29 10:58:06','2020-04-16 11:05:55','7_w4_o1_maxillaire_scan_file_2.ply','2020-12-29 11:58:06','SYNCED','40c9dd9e-b85c-4ed6-a37e-81b5b8e9124d',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.7.4.1.1\",\"modelMatrix\":\"0.903402,0.420292,-0.0849745,0,-0.428796,0.885485,-0.179027,0,2.8877e-9,0.19817,0.980168,0,-9.11848,-20.5173,-28.0428,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'7fbf5bd8-6de6-46b1-bd50-c2480472006d','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_ed495283-b756-4052-ba8b-5fe9f9b1f8be/19_w3_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_TOSC_ed495283-b756-4052-ba8b-5fe9f9b1f8be_SNAPS_','2022-11-02 12:55:41','2022-11-02 12:26:48','19_w3_o1_maxillaire_snapshot_0.png','2022-11-02 13:55:41','SYNCED','7fbf5bd8-6de6-46b1-bd50-c2480472006d',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'80e2978d-ccbf-46b3-90aa-49fde4694d47','','SNAPS','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_TOSC_fbfa4372-1faf-4a14-9f4e-70b7b375da7d_SNAPS_','2020-12-29 10:57:41','2020-04-18 09:19:43','','2020-12-29 11:57:41','SYNCED','9946c86d-7b6b-4bd2-8dae-8b982fbd7cfc',1,'2020-12-29 11:57:41','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.9.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'818647ce-e09a-4e46-8ad9-2029a89b0d0f','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_7a39120e-2f79-4c3e-af4d-af72e8ca8062/15_w1_o1_mordu_posterieur_gauche_scan_file_1.ply','PLY','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_LESC_7a39120e-2f79-4c3e-af4d-af72e8ca8062_PLY_','2021-02-16 12:01:13','2021-02-16 13:00:22','15_w1_o1_mordu_posterieur_gauche_scan_file_1.ply','2021-02-16 13:01:13','SYNCED','c14c7ae3-1390-4203-93ce-6ba836086c35',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.15.1.1.1\",\"modelMatrix\":\"-0.894751,0.0195259,0.435756,0,0.137292,-0.919419,0.369524,0,0.425737,0.393608,0.82082,0,0.624099,-11.8831,-21.6542,1\",\"title\":\"Mordu posterieur gauche PLY\"}'),(662,'81bbb529-1a14-4e29-b842-b84cbac8d014','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_793e84ce-b088-458d-82f5-33fab1f5e7de/23_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_TOSC_793e84ce-b088-458d-82f5-33fab1f5e7de_SNAPS_','2022-01-11 11:23:21','2022-01-11 12:16:28','23_w1_o1_maxillaire_snapshot_0.png','2022-01-11 12:23:21','SYNCED','81bbb529-1a14-4e29-b842-b84cbac8d014',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'81e806ef-052e-4347-928a-d06d1d3a299b','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_scan_file_3.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_ZIP_','2022-06-27 19:34:42','2022-06-27 20:58:59','21_w2_o1_mandibule_scan_file_3.zip','2022-06-27 21:34:42','SYNCED','1f29b918-27fd-422b-b4dd-da18687d0871',3,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"modelMatrix\":\"-0.922045,-0.375022,0.0958724,0,0.387082,-0.893316,0.228372,0,-6.769e-09,0.247679,0.968842,0,7.94719,13.1252,-21.4687,1\",\"title\":\"Mandibule ZIP\"}'),(662,'8248bc2e-a7bc-4a4e-9fc9-f2326990454c','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_SNAPS_','2021-11-22 11:49:45','2021-11-22 12:31:30','21_w1_o1_mandibule_snapshot_1.png','2021-11-22 12:49:45','SYNCED','5dfbe9b8-c587-4311-b392-743be40fdd10',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'82997513-4864-4e01-8853-7053a2892d95','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_e6c99474-f6f6-447f-bcaa-d4c791811e18/14_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_BOSC_e6c99474-f6f6-447f-bcaa-d4c791811e18_SNAPS_','2021-02-01 20:09:34','2021-02-01 21:09:31','14_w1_o1_mandibule_snapshot_0.png','2021-02-01 21:09:34','SYNCED','82997513-4864-4e01-8853-7053a2892d95',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.14.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'83547739-e794-48fb-befb-bed604c04b8f','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/computedocclusion_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd/25_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_OCC_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd_SNAPO__SNAPS_','2022-06-27 19:32:30','2022-03-11 11:16:26','25_w1_o1_snapshot_occ_file_0.png','2022-06-27 21:32:30','SYNCED','83547739-e794-48fb-befb-bed604c04b8f',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(662,'8369f19c-559c-4a43-8a44-d476973e5f8f','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_470d4798-40ea-4ce5-a574-22fcf013d82d/7_w4_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_RISC_470d4798-40ea-4ce5-a574-22fcf013d82d_SNAPS_','2020-12-29 10:58:07','2020-04-16 11:17:28','7_w4_o1_mordu_posterieur_droit_snapshot_0.png','2020-12-29 11:58:07','SYNCED','8369f19c-559c-4a43-8a44-d476973e5f8f',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.7.4.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(662,'8396da09-c9ea-476d-ab69-648f06ec6534','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_a90158f7-0d39-4b9d-984b-57de06099c65/21_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_ZIP_','2021-11-22 11:24:03','2021-11-22 12:21:52','21_w1_o1_maxillaire_scan_file_0.zip','2021-11-22 12:24:03','SYNCED','8396da09-c9ea-476d-ab69-648f06ec6534',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"modelMatrix\":\"0.898596,0.438246,-0.021589,0,-0.438778,0.897507,-0.0442131,0,-1.83541e-9,0.0492025,0.998789,0,-18.1719,-0.152005,-20.9375,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'83beb369-fc09-4267-aae8-82692ddb557d','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/smilersorder_326b48e4-9182-4dc4-9e91-44104a1a8ff1/20_w1_smilers_file_0.json','JSON','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_PROST_326b48e4-9182-4dc4-9e91-44104a1a8ff1_JSON_','2021-10-12 12:31:29','2021-10-12 14:26:57','20_w1_smilers_file_0.json','2021-10-12 14:31:29','SYNCED','83beb369-fc09-4267-aae8-82692ddb557d',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'83dce64b-81ec-4022-b7e5-8a738bbab39f','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_37ff1278-3dd1-470a-8159-e763f6626f5d/6_w1_o2_mandibule_scan_file_0.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_BOSC_37ff1278-3dd1-470a-8159-e763f6626f5d_PLY_','2020-12-29 10:58:07','2020-04-17 11:09:28','6_w1_o2_mandibule_scan_file_0.ply','2020-12-29 11:58:07','SYNCED','83dce64b-81ec-4022-b7e5-8a738bbab39f',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.6.1.2.1\",\"modelMatrix\":\"-0.993772,-0.101479,0.0460255,0,0.111428,-0.905037,0.410478,0,1.09577e-9,0.41305,0.910708,0,7.14214,1.18332,-21.7576,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'83eddd4d-fe65-43b9-a14f-3293e715be11','','SNAPS','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_72c58d79-1141-4c63-b343-909886db5520_SESS_8d012545-b857-4595-a69d-1a2b1c750e13_TOSC_527c942e-3aa0-4028-b02a-8b3f137657be_SNAPS_','2020-12-29 10:57:41','2020-04-27 16:19:06','','2020-12-29 11:57:41','SYNCED','83eddd4d-fe65-43b9-a14f-3293e715be11',0,'2020-12-29 11:57:41','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.2.4.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'8426a670-f967-440b-bcde-e3796c4a5da6','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_snapshot_4.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_SNAPS_','2023-01-11 12:42:18','2023-01-11 12:52:36','21_w7_o1_mandibule_snapshot_4.png','2023-01-11 13:42:18','SYNCED','252b180c-565f-4f14-af48-a16cebbead9e',4,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'844bd645-d75e-4e35-9525-178a102fe49a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/smilersorder_fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a/13_w4_smilers_file_0.json','JSON','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_PROST_fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a_JSON_','2020-12-29 11:02:56','2020-12-29 12:02:05','13_w4_smilers_file_0.json','2020-12-29 12:02:56','SYNCED','844bd645-d75e-4e35-9525-178a102fe49a',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'84c96eac-549e-4c1d-a701-896474d66a31','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_019e5bd1-9330-4e70-8035-2fda343b0231/19_w1_o1_maxillaire_scan_file_1.ply','PLY','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_TOSC_019e5bd1-9330-4e70-8035-2fda343b0231_PLY_','2021-09-27 12:02:01','2021-09-27 12:26:06','19_w1_o1_maxillaire_scan_file_1.ply','2021-09-27 14:02:01','SYNCED','b328d68a-733b-46ed-9a1a-20aefc9f9b17',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"modelMatrix\":\"-0.899911,0.426922,-0.0888736,0,-0.436074,-0.881023,0.183405,0,5.95796e-9,0.203804,0.979012,0,12.9304,-14.3828,-20.7725,1\",\"title\":\"Maxillaire PLY\"}'),(662,'850a1a2e-2e87-4cda-8ec5-a2dcd149731d','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_8f3d7d42-f6ad-4e48-8951-08222c212e7e/occlusion_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2/scan_b24d4ab4-dba3-4be5-8ba3-7eee381f40ec/21_w4_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_FRSC_b24d4ab4-dba3-4be5-8ba3-7eee381f40ec_SNAPS_','2022-11-04 11:39:03','2022-11-04 12:34:43','21_w4_o1_mordu_anterieur_snapshot_0.png','2022-11-04 12:39:03','SYNCED','850a1a2e-2e87-4cda-8ec5-a2dcd149731d',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.21.4.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'85dade24-9cc8-4e62-afe5-2da409796449','','PLY','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_TOSC_fbfa4372-1faf-4a14-9f4e-70b7b375da7d_PLY_','2020-12-29 10:57:41','2020-04-18 09:19:43','','2020-12-29 11:57:41','SYNCED','5bdd9b13-0942-46d1-92ac-4b22472007ae',1,'2020-12-29 11:57:41','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.9.1.1.1\",\"modelMatrix\":\"0.0384415,0.981792,-0.18603,0,-0.999261,0.0377694,-0.00715657,0,3.061e-10,0.186168,0.982518,0,-1.61933,-2.53699,-9.84203,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'8633595a-6eb0-4dfd-885e-9648bf6c088f','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/order_03969eb4-0bb5-4cae-92e8-5cf65689757e/10_w1_autre_prost_file_0.json','JSON','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_PROST_03969eb4-0bb5-4cae-92e8-5cf65689757e_JSON_','2020-05-01 06:23:30','2020-05-01 08:23:30','10_w1_autre_prost_file_0.json','2020-05-01 08:23:30','SYNCED','8633595a-6eb0-4dfd-885e-9648bf6c088f',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.10.1.2 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre JSON\"}'),(662,'88b2c3fc-981f-4818-aa0f-2cbbbc6a3b31','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_SNAPS_','2020-12-29 10:58:08','2020-04-30 19:54:51','10_w1_o1_mandibule_snapshot_2.png','2020-12-29 11:58:08','SYNCED','f3f82ebd-8318-469e-9bdd-ff76223b9c1c',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.10.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'8c67a058-8449-431b-8bbd-2b4b584d36e3','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/smilersorder_e3644629-0e9d-4455-b760-495a260e47fe/16_w1_smilers_file_0.json','JSON','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_PROST_e3644629-0e9d-4455-b760-495a260e47fe_JSON_','2021-02-27 09:59:48','2021-02-27 10:59:19','16_w1_smilers_file_0.json','2021-02-27 10:59:48','SYNCED','8c67a058-8449-431b-8bbd-2b4b584d36e3',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'8c7b4f48-e4a4-416e-acec-bb98128e5a62','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/smilersorder_6115b844-b299-4810-9483-4074715ac8c2/13_w4_smilers_file_0.json','JSON','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_PROST_6115b844-b299-4810-9483-4074715ac8c2_JSON_','2020-12-29 11:08:40','2020-12-29 12:06:52','13_w4_smilers_file_0.json','2020-12-29 12:08:40','SYNCED','8c7b4f48-e4a4-416e-acec-bb98128e5a62',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'8ccfb1b3-7ee5-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ccfb1b3-7ee5-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7_SNAPS_','2020-12-29 10:58:08','2020-04-15 07:39:22','8ccfb1b3-7ee5-11ea-947d-226cec7cb58a.png','2020-12-29 11:58:08','SYNCED','8ccfb1b3-7ee5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}'),(662,'8cd19241-7ee5-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cd19241-7ee5-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_d3a42d3d-3d98-457b-bb64-4119091b03f9_PLY_','2020-12-29 10:58:08','2020-04-15 07:37:21','8cd19241-7ee5-11ea-947d-226cec7cb58a.ply','2020-12-29 11:58:08','SYNCED','8cd19241-7ee5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.1\",\"modelMatrix\":\"0.996436,-0.0417849,0.0747689,0,0.0270536,0.952167,0.302573,0,-0.0805792,-0.302841,0.950213,0,-13.0357,5.641,-33.0669,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(662,'8cd31395-7ee5-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cd31395-7ee5-11ea-947d-226cec7cb58a.pdf','PDF','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_PROST_118a8411-96d0-412f-a2fd-6e990b04bf34_PDF_','2020-04-15 06:51:45','2020-04-15 08:51:44','8cd31395-7ee5-11ea-947d-226cec7cb58a.pdf','2020-04-15 08:51:45','SYNCED','8cd31395-7ee5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"ODF 1.7.2.2 ODF\",\"title\":\"Odf PDF\"}'),(662,'8cd499d6-7ee5-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cd499d6-7ee5-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_PLY_','2020-12-29 10:58:09','2020-04-15 07:19:54','8cd499d6-7ee5-11ea-947d-226cec7cb58a.ply','2020-12-29 11:58:09','SYNCED','8cd499d6-7ee5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.7.2.2.1\",\"modelMatrix\":\"0.798862,-0.59756,0.0688607,0,0.601515,0.79361,-0.0914527,0,-4.38586e-9,0.114479,0.993426,0,-2.73294,17.6652,-41.351,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'8cd690e5-7ee5-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cd690e5-7ee5-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_SNAPS_','2020-12-29 10:58:09','2020-04-15 07:35:08','8cd690e5-7ee5-11ea-947d-226cec7cb58a.png','2020-12-29 11:58:09','SYNCED','8cd690e5-7ee5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.7.2.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'8cd829cd-7ee5-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cd829cd-7ee5-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_SNAPS_','2020-12-29 10:58:10','2020-04-15 07:19:54','8cd829cd-7ee5-11ea-947d-226cec7cb58a.png','2020-12-29 11:58:10','SYNCED','8cd829cd-7ee5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.7.2.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'8cda0313-7ee5-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cda0313-7ee5-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_PLY_','2020-12-29 10:58:10','2020-04-15 07:35:08','8cda0313-7ee5-11ea-947d-226cec7cb58a.ply','2020-12-29 11:58:10','SYNCED','8cda0313-7ee5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.7.2.2.1\",\"modelMatrix\":\"0.665193,0.645471,-0.375347,0,-0.746672,0.575036,-0.334388,0,2.20888e-8,0.502693,0.864465,0,-12.1421,-33.8974,-48.3616,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'8cdbafa2-7ee5-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cdbafa2-7ee5-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_ca33a9ff-b86a-4e97-8674-1bd7adc92759_SNAPS_','2020-12-29 10:58:10','2020-04-15 07:43:36','8cdbafa2-7ee5-11ea-947d-226cec7cb58a.png','2020-12-29 11:58:10','SYNCED','8cdbafa2-7ee5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}'),(662,'8cdd4be9-7ee5-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cdd4be9-7ee5-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_ca33a9ff-b86a-4e97-8674-1bd7adc92759_PLY_','2020-12-29 10:58:11','2020-04-15 07:43:36','8cdd4be9-7ee5-11ea-947d-226cec7cb58a.ply','2020-12-29 11:58:11','SYNCED','8cdd4be9-7ee5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.1\",\"modelMatrix\":\"0.716923,0.0202956,0.693353,0,-0.0337042,0.999997,-0.0100568,0,-0.69663,0.000757645,0.720556,0,12.2181,4.16901,-40.9229,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}'),(662,'8cdf1358-7ee5-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cdf1358-7ee5-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7_PLY_','2020-12-29 10:58:12','2020-04-15 07:39:22','8cdf1358-7ee5-11ea-947d-226cec7cb58a.ply','2020-12-29 11:58:12','SYNCED','8cdf1358-7ee5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.1\",\"modelMatrix\":\"-0.999903,-0.00806038,0.0111619,0,0.0083222,-0.994448,-0.103366,0,0.0112516,-0.104947,0.994583,0,16.7147,8.54514,-27.4379,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}'),(662,'8ce0b716-7ee5-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ce0b716-7ee5-11ea-947d-226cec7cb58a.json','JSON','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_PROST_118a8411-96d0-412f-a2fd-6e990b04bf34_JSON_','2020-04-15 06:51:45','2020-04-15 08:51:44','8ce0b716-7ee5-11ea-947d-226cec7cb58a.json','2020-04-15 08:51:45','SYNCED','8ce0b716-7ee5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"ODF 1.7.2.2 ODF\",\"title\":\"Odf JSON\"}'),(662,'8ce28649-7ee5-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ce28649-7ee5-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_d3a42d3d-3d98-457b-bb64-4119091b03f9_SNAPS_','2020-12-29 10:58:12','2020-04-15 07:37:21','8ce28649-7ee5-11ea-947d-226cec7cb58a.png','2020-12-29 11:58:12','SYNCED','8ce28649-7ee5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(662,'8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_a93c6a8f-0c96-47ae-bc72-75a725946a5a/10_w1_o1_mordu_anterieur_scan_file_0.ply','PLY','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_FRSC_a93c6a8f-0c96-47ae-bc72-75a725946a5a_PLY_','2020-12-29 10:58:12','2020-04-30 20:08:26','10_w1_o1_mordu_anterieur_scan_file_0.ply','2020-12-29 11:58:12','SYNCED','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.10.1.1.1\",\"modelMatrix\":\"0.823669,-0.0469585,0.555588,0,0.0882294,0.995963,-0.0501525,0,-0.560319,0.0775828,0.83011,0,5.64793,3.00105,-25.0468,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}'),(662,'8ea06518-4b8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ea06518-4b8a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_SNAPS_','2021-11-22 11:51:23','2021-11-22 12:41:03','8ea06518-4b8a-11ec-9377-226cec7cb58a.png','2021-11-22 12:51:23','SYNCED','8ea06518-4b8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'8ea38ac2-4b8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ea38ac2-4b8a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_FRSC_3d3ae697-dc08-4ce2-8b32-4f79891607c2_SNAPS_','2021-11-22 11:51:22','2021-11-22 12:49:42','8ea38ac2-4b8a-11ec-9377-226cec7cb58a.png','2021-11-22 12:51:22','SYNCED','8ea38ac2-4b8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 1.21.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'8ea64d2c-4b8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ea64d2c-4b8a-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_RISC_c00beb59-a67d-4566-801a-0081588c2a04_ZIP_','2021-11-22 11:46:27','2021-11-22 12:45:00','8ea64d2c-4b8a-11ec-9377-226cec7cb58a.zip','2021-11-22 12:46:27','SYNCED','8ea64d2c-4b8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 1.21.1.1.1\",\"modelMatrix\":\"0.99877,0.016182,0.0457803,0,-0.0192084,0.999424,-0.0289803,0,-0.0459172,0.0302338,0.998533,0,13.1616,-3.71206,-20.732,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(662,'8ea9bac9-4b8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ea9bac9-4b8a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_RISC_c00beb59-a67d-4566-801a-0081588c2a04_SNAPS_','2021-11-22 11:49:44','2021-11-22 12:44:59','8ea9bac9-4b8a-11ec-9377-226cec7cb58a.png','2021-11-22 12:49:44','SYNCED','8ea9bac9-4b8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 1.21.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'8eaccb00-4b8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8eaccb00-4b8a-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_LESC_9716867f-e0a3-478a-a498-1e84ae803044_ZIP_','2021-11-22 11:50:37','2021-11-22 12:47:34','8eaccb00-4b8a-11ec-9377-226cec7cb58a.zip','2021-11-22 12:50:37','SYNCED','8eaccb00-4b8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"modelMatrix\":\"-0.947449,-0.317073,-0.0557049,0,0.311962,-0.870195,-0.378767,0,0.070887,-0.377135,0.923815,0,-13.1535,4.28606,-27.5789,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(662,'8eb12471-4b8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8eb12471-4b8a-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_ZIP_','2021-11-22 11:31:19','2021-11-22 12:28:58','8eb12471-4b8a-11ec-9377-226cec7cb58a.zip','2021-11-22 12:31:19','SYNCED','8eb12471-4b8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"modelMatrix\":\"0.637136,0.767927,-0.0659177,0,-0.770751,0.634802,-0.0544904,0,4.04895e-9,0.0855239,0.996336,0,-16.373,-8.74215,-20.4029,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'8eb7bfec-4b8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8eb7bfec-4b8a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_SNAPS_','2021-11-22 11:31:31','2021-11-22 12:28:55','8eb7bfec-4b8a-11ec-9377-226cec7cb58a.png','2021-11-22 12:31:31','SYNCED','8eb7bfec-4b8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'8ebeca38-4b8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ebeca38-4b8a-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_ZIP_','2021-11-22 11:45:30','2021-11-22 12:41:06','8ebeca38-4b8a-11ec-9377-226cec7cb58a.zip','2021-11-22 12:45:30','SYNCED','8ebeca38-4b8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"modelMatrix\":\"-0.991383,-0.127699,0.029203,0,0.130996,-0.966434,0.22101,0,-2.82267e-9,0.222931,0.974834,0,20.0716,9.99111,-20.7432,1\",\"title\":\"Mandibule ZIP\"}'),(662,'8ec375cf-4b8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ec375cf-4b8a-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_FRSC_3d3ae697-dc08-4ce2-8b32-4f79891607c2_ZIP_','2021-11-22 11:51:22','2021-11-22 12:49:43','8ec375cf-4b8a-11ec-9377-226cec7cb58a.zip','2021-11-22 12:51:22','SYNCED','8ec375cf-4b8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 1.21.1.1.1\",\"modelMatrix\":\"0.856881,0.0586008,0.514973,0,-0.0462075,0.997315,0.0174852,0,-0.514443,-0.0544124,0.857029,0,-1.9678,-1.04274,-24.7967,1\",\"title\":\"Mordu anterieur ZIP\"}'),(662,'8ec747f5-4b8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ec747f5-4b8a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_LESC_9716867f-e0a3-478a-a498-1e84ae803044_SNAPS_','2021-11-22 11:51:23','2021-11-22 12:47:33','8ec747f5-4b8a-11ec-9377-226cec7cb58a.png','2021-11-22 12:51:23','SYNCED','8ec747f5-4b8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'8efdb9b3-fe9f-4a5f-9abb-7f53985624a7','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_16cf8664-2af0-446a-ac6d-ef0e40edb71d/9_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_LESC_16cf8664-2af0-446a-ac6d-ef0e40edb71d_SNAPS_','2020-12-29 10:58:13','2020-04-18 09:35:44','9_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2020-12-29 11:58:13','SYNCED','8efdb9b3-fe9f-4a5f-9abb-7f53985624a7',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.9.1.1.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}'),(662,'8f73cc76-d204-47ee-bcfc-5610371e2032','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_41b8d05c-738b-4161-9f86-27222b61ad66/14_w2_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_RISC_41b8d05c-738b-4161-9f86-27222b61ad66_SNAPS_','2021-06-08 18:48:53','2021-06-08 20:48:52','14_w2_o1_mordu_posterieur_droit_snapshot_0.png','2021-06-08 20:48:53','SYNCED','8f73cc76-d204-47ee-bcfc-5610371e2032',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.14.2.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'8fd1dd53-2969-4c23-9998-f92a590629ae','','SNAPS','PATIENT_94ac368a-c8ad-482d-91b4-26c8db10596d_ACT_c61cdb9c-543c-4809-952c-b65656e1f96f_SESS_53a17fdc-5de8-45aa-a9cb-ebea4886f6ff_TOSC_6445b6e3-0c4a-44d3-84e8-7f315911b8ee_SNAPS_','2020-12-15 14:15:23','2020-07-08 19:54:05','',NULL,'CREATED','8fd1dd53-2969-4c23-9998-f92a590629ae',0,'2020-07-08 19:59:48','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.11.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'90d34496-4e10-41d5-b77c-75826f81327e','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_848b25bd-90a8-4105-871d-f9326fe94c7b/occlusion_ba7da56a-5a10-4378-a887-8e98aa892a3c/scan_b002027b-930d-4b96-a687-453aeea5659e/21_w6_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_848b25bd-90a8-4105-871d-f9326fe94c7b_SESS_ba7da56a-5a10-4378-a887-8e98aa892a3c_TOSC_b002027b-930d-4b96-a687-453aeea5659e_SNAPS_','2022-12-21 11:17:49','2022-12-21 12:14:30','21_w6_o1_maxillaire_snapshot_1.png','2022-12-21 12:17:49','SYNCED','14c0bac1-16fe-41ce-863b-85ffd35f41e9',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.6.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'9186d766-694f-4445-926a-80ace9fd1660','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_55058b25-acc2-43c3-b9d2-b8bb64bfcbb9/9_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_RISC_55058b25-acc2-43c3-b9d2-b8bb64bfcbb9_SNAPS_','2020-12-29 10:58:13','2020-04-18 09:33:54','9_w1_o1_mordu_posterieur_droit_snapshot_0.png','2020-12-29 11:58:13','SYNCED','9186d766-694f-4445-926a-80ace9fd1660',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.9.1.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(662,'9210c2bb-cc5b-4ccf-a432-8adf915d5673','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_6ce24fb2-7744-476b-a643-7e304d3ac013/23_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_RISC_6ce24fb2-7744-476b-a643-7e304d3ac013_SNAPS_','2022-01-11 11:42:19','2022-01-11 12:37:27','23_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-01-11 12:42:19','SYNCED','9210c2bb-cc5b-4ccf-a432-8adf915d5673',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.23.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'92288f55-8447-4e52-a1c2-2de9d12cad77','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_44b8a221-3707-430b-bc84-cacca7bf7d8a/14_w2_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_LESC_44b8a221-3707-430b-bc84-cacca7bf7d8a_SNAPS_','2021-06-08 18:51:50','2021-06-08 20:51:49','14_w2_o1_mordu_posterieur_gauche_snapshot_0.png','2021-06-08 20:51:50','SYNCED','92288f55-8447-4e52-a1c2-2de9d12cad77',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.14.2.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'9319bd6a-6e7d-4505-8090-e4e10e3caec0','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_d52d9ce0-7fed-491c-a385-929e22fb07d5/10_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_LESC_d52d9ce0-7fed-491c-a385-929e22fb07d5_SNAPS_','2020-12-29 10:58:14','2020-04-30 20:05:04','10_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2020-12-29 11:58:14','SYNCED','9319bd6a-6e7d-4505-8090-e4e10e3caec0',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.10.1.1.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}'),(662,'931bf3dd-fe07-4981-8ede-599f357c3c60','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/computedocclusion_a18ca6df-d765-4c6a-be28-13amigraoccl/6_w1_o2_mandibule_occlusion_occ_file_0.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_OCC_a18ca6df-d765-4c6a-be28-13amigraoccl_BOPLY__PLY_','2020-12-29 10:58:14','2020-04-17 11:21:05','6_w1_o2_mandibule_occlusion_occ_file_0.ply','2020-12-29 11:58:14','SYNCED','931bf3dd-fe07-4981-8ede-599f357c3c60',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule Occlusion 1.6.1.2.1\",\"referenceScanID\":\"1.6.1.2.1\",\"title\":\"Mandibule Occlusion PLY\"}'),(662,'933a6e93-9da3-4626-98e1-48aa28a06daa','','PLY','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_2b934532-4b04-4025-8e7f-894c9c01b184_BOSC_0b6ec729-5c4e-4869-9d67-6377923ed207_PLY_','2020-12-29 10:57:42','2020-04-07 07:26:12','','2020-12-29 11:57:42','SYNCED','933a6e93-9da3-4626-98e1-48aa28a06daa',0,'2020-12-29 11:57:42','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.2.2.3.1\",\"modelMatrix\":\"0.951587,0.289796,-0.102471,0,-0.307379,0.897153,-0.31723,0,4.98457e-10,0.333369,0.942796,0,1.62001,-0.765988,-48.5403,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'9429af5d-f1d9-425d-ba09-d7d1907096ac','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_2d566d37-f38f-4b79-ac8f-48009ae22310/6_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_TOSC_2d566d37-f38f-4b79-ac8f-48009ae22310_PLY_','2020-12-29 10:58:14','2020-04-10 11:37:04','6_w1_o1_maxillaire_scan_file_0.ply','2020-12-29 11:58:14','SYNCED','9429af5d-f1d9-425d-ba09-d7d1907096ac',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"modelMatrix\":\"-0.854329,0.507958,-0.109998,0,-0.519732,-0.834976,0.180814,0,-6.21247e-9,0.211644,0.977347,0,1.97723,-16.173,-24.2697,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'94c77f29-2b59-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/94c77f29-2b59-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_LESC_a6d52fce-2e61-4375-bf6d-a36f9b3eb72f_ZIP_','2021-10-12 12:35:19','2021-10-12 12:42:39','94c77f29-2b59-11ec-9377-226cec7cb58a.zip','2021-10-12 14:35:19','SYNCED','94c77f29-2b59-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 1.20.1.1.1\",\"modelMatrix\":\"-0.977596,0.0140003,0.205991,0,-0.0046974,-0.995393,0.111045,0,0.210767,0.0965222,0.972336,0,6.11013,-4.18404,-18.0488,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(662,'94cb30f9-2b59-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/94cb30f9-2b59-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_RISC_00f07cdc-1834-4ae1-a9fa-47699828c094_ZIP_','2021-10-12 12:34:20','2021-10-12 12:40:26','94cb30f9-2b59-11ec-9377-226cec7cb58a.zip','2021-10-12 14:34:20','SYNCED','94cb30f9-2b59-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 1.20.1.1.1\",\"modelMatrix\":\"0.977044,0.023574,0.212257,0,-0.0393808,0.997586,0.0676487,0,-0.209382,-0.0658891,0.974905,0,3.82768,-0.972126,-16.0009,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(662,'94ce93c7-2b59-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/94ce93c7-2b59-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_FRSC_881d38cc-cf89-4329-8456-b90f8c997725_SNAPS_','2021-10-12 12:35:19','2021-10-12 12:44:16','94ce93c7-2b59-11ec-9377-226cec7cb58a.png','2021-10-12 14:35:19','SYNCED','94ce93c7-2b59-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 1.20.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'94dbef5a-271e-457d-ba7b-ace1dbe05081','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_d04345c3-df70-4e2a-b197-cc37138e6700/25_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_FRSC_d04345c3-df70-4e2a-b197-cc37138e6700_ZIP_','2022-03-11 10:17:44','2022-03-11 11:15:50','25_w1_o1_mordu_anterieur_scan_file_0.zip','2022-03-11 11:17:44','SYNCED','94dbef5a-271e-457d-ba7b-ace1dbe05081',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.25.1.1.1\",\"modelMatrix\":\"0.90456,0.0244497,0.402976,0,-0.0988614,0.985826,0.138036,0,-0.415543,-0.166161,0.905105,0,-2.22653,5.62446,-26.7955,1\",\"title\":\"Mordu anterieur ZIP\"}'),(662,'94e9a15c-2b59-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/94e9a15c-2b59-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_TOSC_42b09cf6-e30d-4d35-a17d-d8e8b4564638_ZIP_','2021-10-12 12:40:06','2021-10-12 12:37:46','94e9a15c-2b59-11ec-9377-226cec7cb58a.zip','2021-10-12 14:40:06','SYNCED','94e9a15c-2b59-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.20.1.1.1\",\"modelMatrix\":\"0.322976,0.912912,-0.249555,0,-0.946407,0.311546,-0.0851648,0,4.13598e-9,0.263687,0.964608,0,-7.27814,-21.2146,-22.2509,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'94eeedbf-2b59-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/94eeedbf-2b59-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_LESC_a6d52fce-2e61-4375-bf6d-a36f9b3eb72f_SNAPS_','2021-10-12 12:30:37','2021-10-12 12:42:38','94eeedbf-2b59-11ec-9377-226cec7cb58a.png','2021-10-12 14:30:37','SYNCED','94eeedbf-2b59-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 1.20.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'94fc41f3-2b59-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/94fc41f3-2b59-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_RISC_00f07cdc-1834-4ae1-a9fa-47699828c094_SNAPS_','2021-10-12 12:30:37','2021-10-12 12:40:25','94fc41f3-2b59-11ec-9377-226cec7cb58a.png','2021-10-12 14:30:37','SYNCED','94fc41f3-2b59-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 1.20.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'94ffa87d-2b59-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/94ffa87d-2b59-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_BOSC_453abb20-3827-4f8b-b57f-c656c72ebf11_SNAPS_','2021-10-12 12:40:06','2021-10-12 12:26:33','94ffa87d-2b59-11ec-9377-226cec7cb58a.png','2021-10-12 14:40:06','SYNCED','94ffa87d-2b59-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.20.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'9511cb22-2b59-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/9511cb22-2b59-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_FRSC_881d38cc-cf89-4329-8456-b90f8c997725_ZIP_','2021-10-12 12:31:28','2021-10-12 12:44:17','9511cb22-2b59-11ec-9377-226cec7cb58a.zip','2021-10-12 14:31:28','SYNCED','9511cb22-2b59-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 1.20.1.1.1\",\"modelMatrix\":\"0.7186,-0.0747595,0.698393,0,0.0913484,0.998565,-0.0222422,0,-0.689689,0.026612,0.717523,0,6.32349,-0.987183,-29.4038,1\",\"title\":\"Mordu anterieur ZIP\"}'),(662,'9514c875-2b59-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/9514c875-2b59-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_BOSC_453abb20-3827-4f8b-b57f-c656c72ebf11_ZIP_','2021-10-12 12:33:36','2021-10-12 12:26:35','9514c875-2b59-11ec-9377-226cec7cb58a.zip','2021-10-12 14:33:36','SYNCED','9514c875-2b59-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.20.1.1.1\",\"modelMatrix\":\"0.993602,-0.104869,0.0419241,0,0.112939,0.922608,-0.368835,0,-7.12355e-11,0.37121,0.928549,0,-21.8303,-22.816,-15.4889,1\",\"title\":\"Mandibule ZIP\"}'),(662,'95181c09-2b59-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/95181c09-2b59-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_TOSC_42b09cf6-e30d-4d35-a17d-d8e8b4564638_SNAPS_','2021-10-12 12:33:37','2021-10-12 12:37:44','95181c09-2b59-11ec-9377-226cec7cb58a.png','2021-10-12 14:33:37','SYNCED','95181c09-2b59-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.20.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'9533b2b7-5385-4d5f-8858-b01c1c030817','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/order_6ff5b097-d5bb-4902-981f-b53e6fa85604/10_w1_autre_prost_file_0.pdf','PDF','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_PROST_6ff5b097-d5bb-4902-981f-b53e6fa85604_PDF_','2020-04-30 18:27:48','2020-04-30 20:27:47','10_w1_autre_prost_file_0.pdf','2020-04-30 20:27:48','SYNCED','9533b2b7-5385-4d5f-8858-b01c1c030817',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.10.1.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}'),(662,'95ab2e1b-4b91-4bb5-965e-8086f8805dc7','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/order_63706c26-d501-4c56-bdc2-ab2c76f6d988/10_w1_autre_prost_file_0.pdf','PDF','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_PROST_63706c26-d501-4c56-bdc2-ab2c76f6d988_PDF_','2020-05-01 06:31:27','2020-05-01 08:31:26','10_w1_autre_prost_file_0.pdf','2020-05-01 08:31:27','SYNCED','95ab2e1b-4b91-4bb5-965e-8086f8805dc7',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.10.1.3 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}'),(662,'95cc936b-2c0c-4fdd-8d11-8780095dabca','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/computedocclusion_bdf42f40-5a7a-435b-a5e0-eb3migraoccl/6_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_OCC_bdf42f40-5a7a-435b-a5e0-eb3migraoccl_TOMA__MATRX_','2020-12-29 10:58:14','2020-04-10 11:52:17','6_w1_o1_maxillaire_matrix_occ_file_0.m','2020-12-29 11:58:14','SYNCED','95cc936b-2c0c-4fdd-8d11-8780095dabca',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.6.1.1\",\"title\":\"Matrice Transfo. Maxillaire MATRIX\"}'),(662,'9617b0df-e829-47cd-8110-fabb587a690d','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_881d38cc-cf89-4329-8456-b90f8c997725/20_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_FRSC_881d38cc-cf89-4329-8456-b90f8c997725_ZIP_','2021-10-12 12:31:28','2021-10-12 12:44:17','20_w1_o1_mordu_anterieur_scan_file_0.zip','2021-10-12 14:31:28','SYNCED','9617b0df-e829-47cd-8110-fabb587a690d',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.20.1.1.1\",\"modelMatrix\":\"0.7186,-0.0747595,0.698393,0,0.0913484,0.998565,-0.0222422,0,-0.689689,0.026612,0.717523,0,6.32349,-0.987183,-29.4038,1\",\"title\":\"Mordu anterieur ZIP\"}'),(662,'963a8acf-cdb2-41d5-b187-9a7c885ac2a0','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_1e8824f7-3c76-4fe0-bd8c-f865f725dab2/22_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_FRSC_1e8824f7-3c76-4fe0-bd8c-f865f725dab2_ZIP_','2021-11-23 11:24:16','2021-11-23 12:23:17','22_w1_o1_mordu_anterieur_scan_file_0.zip','2021-11-23 12:24:16','SYNCED','963a8acf-cdb2-41d5-b187-9a7c885ac2a0',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.22.1.1.1\",\"modelMatrix\":\"0.725913,-0.0652903,0.681352,0,-0.0436065,0.981927,0.168419,0,-0.687258,-0.181082,0.712365,0,10.2372,3.44717,-27.8986,1\",\"title\":\"Mordu anterieur ZIP\"}'),(662,'96c2eb83-88a2-4de9-b439-f00924861267','','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_76f39717-6f88-4e19-800c-f827a697a4d6_SNAPS_','2020-12-29 10:57:42','2020-04-16 07:21:49','','2020-12-29 11:57:42','SYNCED','59f86cb7-d0b5-456d-bb86-a5a83efb559d',1,'2020-12-29 11:57:42','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.2\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(662,'97939bfa-2cd3-4695-a8de-c1359ed5322d','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_ZIP_','2021-11-22 11:39:13','2021-11-22 12:31:31','21_w1_o1_mandibule_scan_file_1.zip','2021-11-22 12:39:13','SYNCED','3aa92b1f-240d-45e1-a722-e8da98368f3a',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"modelMatrix\":\"0.987343,0.148109,-0.0567189,0,-0.158598,0.922045,-0.3531,0,-6.4352e-9,0.357626,0.933865,0,6.81045,-6.30601,-21.6536,1\",\"title\":\"Mandibule ZIP\"}'),(662,'97fdea91-3417-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/97fdea91-3417-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_e43c8099-0862-42c3-9ad2-1efef27b83ba_SESS_09f15124-6bba-4565-bfe4-efb3c6c3a17d_TOSC_3a315f7b-8cf2-4d0c-bf92-fecb623fe530_SNAPS_','2022-09-14 10:25:33','2022-09-14 12:23:53','97fdea91-3417-11ed-a752-9ec33d03e6dd.png','2022-09-14 12:25:33','SYNCED','97fdea91-3417-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.21.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'97ff66d6-3417-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/97ff66d6-3417-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_e43c8099-0862-42c3-9ad2-1efef27b83ba_SESS_09f15124-6bba-4565-bfe4-efb3c6c3a17d_TOSC_3a315f7b-8cf2-4d0c-bf92-fecb623fe530_ZIP_','2022-09-14 10:25:31','2022-09-14 12:23:55','97ff66d6-3417-11ed-a752-9ec33d03e6dd.zip','2022-09-14 12:25:31','SYNCED','97ff66d6-3417-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.21.3.1.1\",\"modelMatrix\":\"0.804251,0.588743,-0.0810022,0,-0.594289,0.796746,-0.10962,0,9.77465e-10,0.136301,0.990668,0,-23.7315,-16.3663,-21.3795,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'98a2c194-b406-4930-b901-3f1b520fc329','','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_SNAPS_','2020-12-29 10:57:42','2020-04-15 07:13:11','','2020-12-29 11:57:42','SYNCED','98a2c194-b406-4930-b901-3f1b520fc329',0,'2020-12-29 11:57:42','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule Occlusion 1.7.2.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'98c10ee7-5736-4c52-8f1e-248cda79d235','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_79548cb6-a61f-44cb-b6f7-cab7698f7465/14_w1_o1_mordu_posterieur_droit_scan_file_1.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_RISC_79548cb6-a61f-44cb-b6f7-cab7698f7465_PLY_','2021-02-01 20:16:16','2021-02-01 21:15:42','14_w1_o1_mordu_posterieur_droit_scan_file_1.ply','2021-02-01 21:16:16','SYNCED','520d0710-d923-46c1-a1dd-f05370a3a5ea',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.14.1.1.1\",\"modelMatrix\":\"0.99813,-0.0235655,0.0527488,0,0.0384935,0.985506,-0.157052,0,-0.0479116,0.168417,0.986232,0,6.32685,-2.3003,-17.7869,1\",\"title\":\"Mordu posterieur droit PLY\"}'),(662,'9946c86d-7b6b-4bd2-8dae-8b982fbd7cfc','','SNAPS','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_TOSC_fbfa4372-1faf-4a14-9f4e-70b7b375da7d_SNAPS_','2020-12-29 10:57:42','2020-04-18 09:18:30','','2020-12-29 11:57:42','SYNCED','9946c86d-7b6b-4bd2-8dae-8b982fbd7cfc',0,'2020-12-29 11:57:42','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule Occlusion 1.9.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'99642a2a-dd48-414b-a8ef-1621aa6040ca','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_934f20d2-7444-4367-89e2-61c3bf4bee57/order_eb120496-ad30-4640-856b-fbdd1139c529/5_w1_odf_prost_file_0.json','JSON','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_934f20d2-7444-4367-89e2-61c3bf4bee57_PROST_eb120496-ad30-4640-856b-fbdd1139c529_JSON_','2020-04-10 07:20:48','2020-04-10 09:20:47','5_w1_odf_prost_file_0.json','2020-04-10 09:20:48','SYNCED','99642a2a-dd48-414b-a8ef-1621aa6040ca',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"ODF 1.5.1.3 ODF\",\"title\":\"Odf JSON\"}'),(662,'9a62fabe-8dd2-441c-b9f8-7ad80abd136a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/order_6ff5b097-d5bb-4902-981f-b53e6fa85604/10_w1_autre_prost_file_0.json','JSON','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_PROST_6ff5b097-d5bb-4902-981f-b53e6fa85604_JSON_','2020-04-30 18:27:48','2020-04-30 20:27:47','10_w1_autre_prost_file_0.json','2020-04-30 20:27:48','SYNCED','9a62fabe-8dd2-441c-b9f8-7ad80abd136a',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.10.1.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre JSON\"}'),(662,'9b87eb98-b2ac-4d29-83ea-5125f3d83710','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_98e7c216-5bb9-4127-9497-834796980370/22_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_TOSC_98e7c216-5bb9-4127-9497-834796980370_SNAPS_','2021-11-23 11:14:26','2021-11-23 12:08:21','22_w1_o1_maxillaire_snapshot_0.png','2021-11-23 12:14:26','SYNCED','9b87eb98-b2ac-4d29-83ea-5125f3d83710',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.22.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'9c755cdf-e1f1-49e0-9dcf-708a856d1b81','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_16cf8664-2af0-446a-ac6d-ef0e40edb71d/9_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PLY','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_LESC_16cf8664-2af0-446a-ac6d-ef0e40edb71d_PLY_','2020-12-29 10:58:15','2020-04-18 09:35:44','9_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','2020-12-29 11:58:15','SYNCED','9c755cdf-e1f1-49e0-9dcf-708a856d1b81',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.9.1.1.1\",\"modelMatrix\":\"-0.998681,-0.0207537,0.0468898,0,0.0210913,-0.997412,0.067392,0,0.0469286,0.0689054,0.996625,0,5.92553,-7.23372,-30.3577,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}'),(662,'9cd5b1c8-ef15-449d-97a1-bdf6947abe78','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/9cd5b1c8-ef15-449d-97a1-bdf6947abe78.png','SNAPS','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_c9d37315-5f17-421c-8afb-302fa9b0bebe_BOSC_6fafe104-bdc1-41a6-9977-b1bbb351a329_SNAPS_','2020-12-29 10:57:43','2020-04-07 06:42:41','9cd5b1c8-ef15-449d-97a1-bdf6947abe78.png','2020-12-29 11:57:43','SYNCED','386b43f6-0c1a-484d-9092-8962d1eb3835',1,'2020-12-29 11:57:43','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.2.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'9d114e81-9c84-452b-9722-47ddb78d35e5','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/occlusion_f2e73640-aebd-4bb1-9b02-c0504556ac5a/scan_e7efed59-e33c-4194-94c1-3507350dcfb5/5_w3_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_SESS_f2e73640-aebd-4bb1-9b02-c0504556ac5a_TOSC_e7efed59-e33c-4194-94c1-3507350dcfb5_SNAPS_','2020-12-29 10:58:15','2020-07-13 19:32:07','5_w3_o1_maxillaire_snapshot_1.png','2020-12-29 11:58:15','SYNCED','b94c36ee-0e86-44b0-a152-b92997bdab17',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.5.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'9d5d6282-185b-45e3-8902-11f6f83c2991','','SNAPS','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_78636467-a73b-4270-8bc5-35a2664dec9d_BOSC_7f9aec2d-6246-4413-842d-78d2e0bddb1e_SNAPS_','2020-12-29 10:57:43','2020-04-12 07:48:40','','2020-12-29 11:57:43','SYNCED','9d5d6282-185b-45e3-8902-11f6f83c2991',0,'2020-12-29 11:57:43','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.2.3.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'9d65d7e8-dc55-4823-9aae-6c5190aae7da','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/406a8572-4b0f-480a-ad2e-daf5530143b6/session_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549/occlusion_254f3fc9-4782-4658-bb34-f2ca1c9b6382/scan_e5fd24c7-49a8-4dbc-9356-3b96970d2515/2_w6_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549_SESS_254f3fc9-4782-4658-bb34-f2ca1c9b6382_TOSC_e5fd24c7-49a8-4dbc-9356-3b96970d2515_PLY_','2020-12-29 10:58:15','2020-05-21 08:00:21','2_w6_o1_maxillaire_scan_file_0.ply','2020-12-29 11:58:15','SYNCED','9d65d7e8-dc55-4823-9aae-6c5190aae7da',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.2.6.1.1\",\"modelMatrix\":\"-0.902375,0.403092,-0.152434,0,-0.430952,-0.844039,0.319184,0,6.90148e-9,0.353715,0.935353,0,17.7056,-10.8652,-31.3865,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'9ef05483-96de-4739-93ea-9e10a387566a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/smilersorder_6e963009-b46f-494d-a5d4-b162c5918103/14_w2_smilers_file_0.json','JSON','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_PROST_6e963009-b46f-494d-a5d4-b162c5918103_JSON_','2021-06-08 18:58:23','2021-06-08 20:57:52','14_w2_smilers_file_0.json','2021-06-08 20:58:23','SYNCED','9ef05483-96de-4739-93ea-9e10a387566a',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'9f8fd3b2-3378-4bb1-997f-292d365a2a77','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/smilersorder_fc4bdff0-7d08-4454-8d7e-962c91470073/23_w1_smilers_file_0.json','JSON','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_PROST_fc4bdff0-7d08-4454-8d7e-962c91470073_JSON_','2022-01-11 11:43:25','2022-01-11 12:41:54','23_w1_smilers_file_0.json','2022-01-11 12:43:25','SYNCED','9f8fd3b2-3378-4bb1-997f-292d365a2a77',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'9fa4fa76-ae1b-496c-bc61-9c8652c7f3d6','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_7a39120e-2f79-4c3e-af4d-af72e8ca8062/15_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_LESC_7a39120e-2f79-4c3e-af4d-af72e8ca8062_SNAPS_','2021-02-16 11:57:05','2021-02-16 12:57:03','15_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2021-02-16 12:57:05','SYNCED','9fa4fa76-ae1b-496c-bc61-9c8652c7f3d6',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.15.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'a017e06b-1e5e-408c-9423-28e5f5e8e405','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_a26f0d58-ca46-4921-a9e1-9c39b7f89783/13_w4_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_TOSC_a26f0d58-ca46-4921-a9e1-9c39b7f89783_SNAPS_','2020-12-30 06:12:48','2020-12-29 11:13:13','13_w4_o1_maxillaire_snapshot_2.png','2020-12-30 07:12:48','SYNCED','24c23cdd-d323-4623-8a9d-2d3e14f3b937',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.13.4.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'a06c28ec-9f81-44b6-b11e-a5e06d983e4a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/406a8572-4b0f-480a-ad2e-daf5530143b6/session_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549/occlusion_254f3fc9-4782-4658-bb34-f2ca1c9b6382/scan_107f2922-62ee-42d9-8e35-69d71587db0b/2_w6_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549_SESS_254f3fc9-4782-4658-bb34-f2ca1c9b6382_BOSC_107f2922-62ee-42d9-8e35-69d71587db0b_SNAPS_','2020-12-29 10:58:16','2020-05-21 08:13:15','2_w6_o1_mandibule_snapshot_0.png','2020-12-29 11:58:16','SYNCED','a06c28ec-9f81-44b6-b11e-a5e06d983e4a',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.2.6.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'a196ba15-5ebd-46d8-b6fa-0325918797ac','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_41b8d05c-738b-4161-9f86-27222b61ad66/14_w2_o1_mordu_posterieur_droit_scan_file_0.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_RISC_41b8d05c-738b-4161-9f86-27222b61ad66_PLY_','2021-06-08 18:49:16','2021-06-08 20:48:52','14_w2_o1_mordu_posterieur_droit_scan_file_0.ply','2021-06-08 20:49:16','SYNCED','a196ba15-5ebd-46d8-b6fa-0325918797ac',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.14.2.1.1\",\"modelMatrix\":\"0.963334,-0.197211,0.185499,0,0.215878,0.966781,-0.127615,0,-0.159544,0.16278,0.974333,0,12.3445,-6.93427,-15.1056,1\",\"title\":\"Mordu posterieur droit PLY\"}'),(662,'a1bc9da2-af83-43c3-8210-759800158585','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_ZIP_','2022-06-28 18:21:58','2022-06-28 20:20:24','19_w2_o1_maxillaire_scan_file_0.zip','2022-06-28 20:21:58','SYNCED','a1bc9da2-af83-43c3-8210-759800158585',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"modelMatrix\":\"-0.971523,0.228207,-0.0637541,0,-0.236945,-0.935695,0.261405,0,-3.89171e-10,0.269067,0.963122,0,10.1318,-13.6766,-27.7474,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'a2156f23-da3f-4a2a-97f3-76ea6c877521','','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_ca33a9ff-b86a-4e97-8674-1bd7adc92759_SNAPS_','2020-12-29 10:57:43','2020-04-15 07:43:36','','2020-12-29 11:57:43','SYNCED','a2156f23-da3f-4a2a-97f3-76ea6c877521',0,'2020-12-29 11:57:43','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}'),(662,'a3243928-a351-4ca9-b9b0-be959eab0b25','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_4a2eec76-a5f3-44f0-b389-4734998fa2d3/13_w4_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_BOSC_4a2eec76-a5f3-44f0-b389-4734998fa2d3_SNAPS_','2021-06-08 17:45:18','2020-12-29 11:24:49','13_w4_o1_mandibule_snapshot_1.png','2021-06-08 19:45:18','SYNCED','e8f06fb1-375a-41c0-9a27-d0ee2593900c',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.13.4.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'a3ae3378-e8e9-495e-9dc6-8a3be2a9a968','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_793e84ce-b088-458d-82f5-33fab1f5e7de/23_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_TOSC_793e84ce-b088-458d-82f5-33fab1f5e7de_SNAPS_','2022-01-11 11:31:12','2022-01-11 12:23:17','23_w1_o1_maxillaire_snapshot_1.png','2022-01-11 12:31:12','SYNCED','81bbb529-1a14-4e29-b842-b84cbac8d014',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'a3d56e52-a954-4894-b840-be0425c42658','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_0f18aace-5cf2-4d46-b56f-f8dc123e1f91/22_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_LESC_0f18aace-5cf2-4d46-b56f-f8dc123e1f91_ZIP_','2021-11-23 11:22:30','2021-11-23 12:21:30','22_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2021-11-23 12:22:30','SYNCED','a3d56e52-a954-4894-b840-be0425c42658',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.22.1.1.2\",\"modelMatrix\":\"-0.987423,-0.1162,0.110526,0,0.107197,-0.992212,-0.0556946,0,0.116253,-0.0450283,0.992314,0,-8.57688,0.410708,-18.9216,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(662,'a41e073f-d40b-4f4f-924e-2afd61ac4f8c','','PLY','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_2ed4960a-e6fa-46de-a306-32385df3346c_BOSC_45b21304-1129-40a2-b60e-d72a2bf96e72_PLY_','2020-12-29 10:57:43','2020-04-12 07:51:14','','2020-12-29 11:57:43','SYNCED','a41e073f-d40b-4f4f-924e-2afd61ac4f8c',0,'2020-12-29 11:57:43','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule Occlusion 1.2.3.2\",\"modelMatrix\":\"0.681905,-0.663539,0.307768,0,0.73144,0.618603,-0.286925,0,3.97899e-9,0.420769,0.907168,0,8.44157,-16.5785,-24.6748,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'a483fb03-0adb-4387-9099-c9c2567855e7','','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_ca33a9ff-b86a-4e97-8674-1bd7adc92759_PLY_','2020-12-29 10:57:44','2020-04-15 07:43:36','','2020-12-29 11:57:44','SYNCED','a483fb03-0adb-4387-9099-c9c2567855e7',0,'2020-12-29 11:57:44','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.1\",\"modelMatrix\":\"0.716923,0.0202956,0.693353,0,-0.0337042,0.999997,-0.0100568,0,-0.69663,0.000757645,0.720556,0,12.2181,4.16901,-40.9229,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}'),(662,'a4f0f4fa-9346-4a75-a1dd-e95c83dc5e6b','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_scan_file_4.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_ZIP_','2022-06-28 18:40:56','2022-06-28 20:39:41','19_w2_o1_maxillaire_scan_file_4.zip','2022-06-28 20:40:56','SYNCED','a1bc9da2-af83-43c3-8210-759800158585',4,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"modelMatrix\":\"-0.913445,0.391574,-0.110853,0,-0.406963,-0.878905,0.248813,0,-2.04414e-09,0.27239,0.962187,0,9.22638,-15.1189,-27.0834,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'a54c4788-74a1-482e-bbc8-b46aeb6ca424','','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_0c8af1cb-8054-4a35-9cfe-449c19dbe59b_PLY_','2020-12-29 10:57:44','2020-04-16 07:10:44','','2020-12-29 11:57:44','SYNCED','a54c4788-74a1-482e-bbc8-b46aeb6ca424',0,'2020-12-29 11:57:44','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.2\",\"modelMatrix\":\"0.861884,0.00906517,0.502349,0,0.0701613,0.983085,-0.141231,0,-0.50252,0.185157,0.8534,0,-0.835727,-2.50445,-37.3935,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}'),(662,'a5903ca6-45db-41cc-a262-19592ff5f2e4','','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7_PLY_','2020-12-29 10:57:44','2020-04-15 07:39:22','','2020-12-29 11:57:44','SYNCED','a5903ca6-45db-41cc-a262-19592ff5f2e4',0,'2020-12-29 11:57:44','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.1\",\"modelMatrix\":\"-0.999903,-0.00806038,0.0111619,0,0.0083222,-0.994448,-0.103366,0,0.0112516,-0.104947,0.994583,0,16.7147,8.54514,-27.4379,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}'),(662,'a60e34f6-4db6-4236-9d5a-1741dd2ed622','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_42b09cf6-e30d-4d35-a17d-d8e8b4564638/20_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_TOSC_42b09cf6-e30d-4d35-a17d-d8e8b4564638_SNAPS_','2021-10-12 12:30:37','2021-10-12 12:33:03','20_w1_o1_maxillaire_snapshot_0.png','2021-10-12 14:30:37','SYNCED','a60e34f6-4db6-4236-9d5a-1741dd2ed622',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'a6c49c5b-a994-457c-80d2-6cd69b636979','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_scan_file_4.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_ZIP_','2022-06-27 19:35:47','2022-06-27 21:02:22','21_w2_o1_mandibule_scan_file_4.zip','2022-06-27 21:35:47','SYNCED','1f29b918-27fd-422b-b4dd-da18687d0871',4,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"modelMatrix\":\"-0.976298,-0.210823,0.0489521,0,0.216432,-0.950998,0.220817,0,-2.3765e-10,0.226178,0.974086,0,10.9881,11.8679,-20.8564,1\",\"title\":\"Mandibule ZIP\"}'),(662,'a721d64e-b79a-4f11-9504-ff9a5bcae5d4','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/computedocclusion_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd/25_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_OCC_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd_BOMA__MATRX_','2022-06-27 19:29:07','2022-03-11 11:16:26','25_w1_o1_mandibule_matrix_occ_file_0.m','2022-06-27 21:29:07','SYNCED','a721d64e-b79a-4f11-9504-ff9a5bcae5d4',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.25.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.25.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.25.1.1.1 Occlusion 1\"}'),(662,'a7593039-4dcb-45a6-891b-98f0c4c5c835','','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_76f39717-6f88-4e19-800c-f827a697a4d6_PLY_','2020-12-29 10:57:44','2020-04-16 07:05:20','','2020-12-29 11:57:44','SYNCED','a7593039-4dcb-45a6-891b-98f0c4c5c835',0,'2020-12-29 11:57:44','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule Occlusion 1.7.2.2\",\"modelMatrix\":\"0.987807,-0.119242,0.0940675,0,0.0902673,0.894617,0.433219,0,-0.129248,-0.431163,0.896574,0,-8.30435,20.916,-28.957,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(662,'a76fbd10-38f6-45b2-bcd6-4235bebb7cc8','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2a050d02-7424-4099-b1d0-2d7da678e690/occlusion_a5bc2d6f-0248-466f-a10b-08f5391fd12f/scan_d2cd260d-4191-4884-80e3-7ced9fa0f8ce/21_w5_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2a050d02-7424-4099-b1d0-2d7da678e690_SESS_a5bc2d6f-0248-466f-a10b-08f5391fd12f_TOSC_d2cd260d-4191-4884-80e3-7ced9fa0f8ce_SNAPS_','2022-12-14 14:06:01','2022-11-04 13:42:01','21_w5_o1_maxillaire_snapshot_0.png','2022-12-14 15:06:01','SYNCED','a76fbd10-38f6-45b2-bcd6-4235bebb7cc8',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.5.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'a8de488b-e4b1-4234-b30c-cb7d68338c86','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_ZIP_','2023-01-11 11:27:03','2023-01-11 12:25:57','21_w7_o1_mandibule_scan_file_1.zip','2023-01-11 12:27:03','SYNCED','097b9793-f270-498e-9cfe-cf6bc2963744',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"modelMatrix\":\"0.963295,-0.264852,0.0437776,0,0.268446,0.950399,-0.157092,0,4.83621e-10,0.163078,0.986613,0,-23.7054,-4.481,-22.7414,1\",\"title\":\"Mandibule ZIP\"}'),(662,'a952743c-a21c-4952-8c29-3ac0e894560a','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_c983b946-e304-49a8-99c8-24eaca67b9ce/occlusion_9e007066-06fd-4fa1-a49a-f1165de95f83/scan_76ece440-81ad-42c8-ab91-f99fa29e2a83/21_w8_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_c983b946-e304-49a8-99c8-24eaca67b9ce_SESS_9e007066-06fd-4fa1-a49a-f1165de95f83_TOSC_76ece440-81ad-42c8-ab91-f99fa29e2a83_SNAPS_','2023-04-11 18:44:25','2023-04-11 20:44:25','21_w8_o1_maxillaire_snapshot_0.png',NULL,'CREATED','a952743c-a21c-4952-8c29-3ac0e894560a',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'a97b41cc-c47f-42ff-aed9-3b6ec8803714','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_ef79558a-21cf-4117-a0b7-ba0adf40f7dc/19_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_FRSC_ef79558a-21cf-4117-a0b7-ba0adf40f7dc_SNAPS_','2021-09-27 11:57:34','2021-09-27 12:49:22','19_w1_o1_mordu_anterieur_snapshot_0.png','2021-09-27 13:57:34','SYNCED','a97b41cc-c47f-42ff-aed9-3b6ec8803714',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.19.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'ab2de538-1cbb-481f-a82e-899f47da34b7','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_586a7c87-5d8a-440f-a654-c452dc908844/occlusion_d70cc224-5e0d-4b47-9270-d8e23a25b566/scan_0e5656e0-946b-41b2-935b-ea820746e5a9/19_w4_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_586a7c87-5d8a-440f-a654-c452dc908844_SESS_d70cc224-5e0d-4b47-9270-d8e23a25b566_TOSC_0e5656e0-946b-41b2-935b-ea820746e5a9_ZIP_','2023-03-21 11:30:54','2023-03-21 12:27:29','19_w4_o1_maxillaire_scan_file_1.zip','2023-03-21 12:30:54','SYNCED','dab48b34-de4a-4877-be2f-a21e13908dff',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.4.1.1\",\"modelMatrix\":\"-0.635437,0.697716,-0.330774,0,-0.772152,-0.57418,0.272209,0,5.70047e-10,0.42838,0.903599,0,7.99987,-37.8812,-17.5689,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'ab47d04c-6ad7-430c-ae85-9231a2efc7b9','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_be9a4ba5-715b-4547-a31d-66621ec7b17f/14_w2_o1_maxillaire_scan_file_2.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_TOSC_be9a4ba5-715b-4547-a31d-66621ec7b17f_PLY_','2021-06-08 18:21:07','2021-06-08 20:19:55','14_w2_o1_maxillaire_scan_file_2.ply','2021-06-08 20:21:07','SYNCED','5498794c-1fcc-48dd-b50e-b57ca5d157ab',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.2.1.1\",\"modelMatrix\":\"0.85642,0.513914,-0.0493714,0,-0.51628,0.852495,-0.0818987,0,1.43126e-9,0.0956291,0.995417,0,-12.3191,-0.719613,-24.1087,1\",\"title\":\"Maxillaire PLY\"}'),(662,'ac0adbda-ae71-490a-947a-f9bfe33db7e8','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_a26f0d58-ca46-4921-a9e1-9c39b7f89783/13_w4_o1_maxillaire_scan_file_2.ply','PLY','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_TOSC_a26f0d58-ca46-4921-a9e1-9c39b7f89783_PLY_','2020-12-29 11:10:32','2020-12-29 11:13:13','13_w4_o1_maxillaire_scan_file_2.ply','2020-12-29 12:10:32','SYNCED','23251874-b8f3-48b3-b209-0b434edd5db0',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.13.4.1.1\",\"modelMatrix\":\"-0.919068,0.381547,-0.0986675,0,-0.394098,-0.889798,0.2301,0,-5.85267e-10,0.250363,0.968152,0,8.93558,-12.3446,-23.835,1\",\"title\":\"Maxillaire PLY\"}'),(662,'ac2e051b-dd4c-4fc1-be89-d406c5ab9a69','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_50e1896b-8565-4257-9a61-2a685fff8165/19_w1_o1_mandibule_scan_file_0.ply','PLY','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_BOSC_50e1896b-8565-4257-9a61-2a685fff8165_PLY_','2021-09-27 11:57:34','2021-09-27 12:37:45','19_w1_o1_mandibule_scan_file_0.ply','2021-09-27 13:57:34','SYNCED','ac2e051b-dd4c-4fc1-be89-d406c5ab9a69',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule PLY\",\"modelMatrix\":\"-0.887508,-0.460253,0.0222794,0,0.460792,-0.88647,0.0429112,0,5.65161e-10,0.0483502,0.99883,0,0.904253,19.5081,-23.603,1\",\"title\":\"Mandibule PLY\"}'),(662,'ae0e9352-37bf-4a60-8c33-459deae4ddb5','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_c983b946-e304-49a8-99c8-24eaca67b9ce/occlusion_9e007066-06fd-4fa1-a49a-f1165de95f83/scan_76ece440-81ad-42c8-ab91-f99fa29e2a83/21_w8_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_c983b946-e304-49a8-99c8-24eaca67b9ce_SESS_9e007066-06fd-4fa1-a49a-f1165de95f83_TOSC_76ece440-81ad-42c8-ab91-f99fa29e2a83_ZIP_','2023-04-11 18:44:27','2023-04-11 20:44:27','21_w8_o1_maxillaire_scan_file_0.zip',NULL,'CREATED','ae0e9352-37bf-4a60-8c33-459deae4ddb5',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.8.1.1\",\"modelMatrix\":\"0.845476,0.511004,-0.155065,0,-0.534013,0.809047,-0.245507,0,1.45766e-08,0.290377,0.956912,0,-18.6921,-5.51179,-22.04,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'af631cfa-13bc-4662-b2af-845b9dc8652b','','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_76f39717-6f88-4e19-800c-f827a697a4d6_PLY_','2020-12-29 10:57:44','2020-04-16 07:21:49','','2020-12-29 11:57:44','SYNCED','a7593039-4dcb-45a6-891b-98f0c4c5c835',1,'2020-12-29 11:57:44','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.2\",\"modelMatrix\":\"0.980716,-0.152567,0.119179,0,0.0907904,0.853265,0.508003,0,-0.174303,-0.498996,0.853257,0,-10.7174,24.6254,-28.5612,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(662,'afb6acdc-fdfd-416b-a94d-62c0ccaf4043','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/order_63706c26-d501-4c56-bdc2-ab2c76f6d988/10_w1_autre_prost_file_0.json','JSON','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_PROST_63706c26-d501-4c56-bdc2-ab2c76f6d988_JSON_','2020-05-01 06:31:27','2020-05-01 08:31:26','10_w1_autre_prost_file_0.json','2020-05-01 08:31:27','SYNCED','afb6acdc-fdfd-416b-a94d-62c0ccaf4043',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.10.1.3 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre JSON\"}'),(662,'affc6c02-1fc4-49c7-9730-6f5e1f2e9f8e','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_44ccf5f6-834d-4090-88dc-399b19fed47e/15_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_FRSC_44ccf5f6-834d-4090-88dc-399b19fed47e_SNAPS_','2021-02-16 12:05:10','2021-02-16 13:05:08','15_w1_o1_mordu_anterieur_snapshot_0.png','2021-02-16 13:05:10','SYNCED','affc6c02-1fc4-49c7-9730-6f5e1f2e9f8e',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.15.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'b01eb471-5baa-4958-b2c6-736eab81754a','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_d675acff-ab7f-4d65-b55c-558379a8b3d0/23_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_LESC_d675acff-ab7f-4d65-b55c-558379a8b3d0_SNAPS_','2022-01-11 11:43:25','2022-01-11 12:39:01','23_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-01-11 12:43:25','SYNCED','b01eb471-5baa-4958-b2c6-736eab81754a',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.23.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'b03f52b8-54fa-4f11-9899-22d57d5b6ebc','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_793e84ce-b088-458d-82f5-33fab1f5e7de/23_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_TOSC_793e84ce-b088-458d-82f5-33fab1f5e7de_ZIP_','2022-01-11 11:18:59','2022-01-11 12:16:30','23_w1_o1_maxillaire_scan_file_0.zip','2022-01-11 12:18:59','SYNCED','b03f52b8-54fa-4f11-9899-22d57d5b6ebc',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"modelMatrix\":\"-0.953812,-0.298383,0.0347982,0,0.300405,-0.947391,0.110487,0,2.52777e-9,0.115838,0.993268,0,21.6348,-11.7028,-20.1752,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'b181e5ae-02f0-4845-a5ba-d30139f8d8a1','','PLY','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549_SESS_254f3fc9-4782-4658-bb34-f2ca1c9b6382_BOSC_4caeed6a-b015-4556-8794-2c3a00fea341_PLY_','2020-12-29 10:57:45','2020-05-21 08:03:19','','2020-12-29 11:57:45','SYNCED','b181e5ae-02f0-4845-a5ba-d30139f8d8a1',0,'2020-12-29 11:57:45','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.2.6.1.1\",\"modelMatrix\":\"0.998987,-0.0441045,0.00891383,0,0.0449963,0.979189,-0.197901,0,-7.82441e-10,0.198102,0.980182,0,5.58069,-5.15897,-36.8754,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'b19b3b70-d194-4a56-8a06-dc3cf2fb8e6a','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_d04345c3-df70-4e2a-b197-cc37138e6700/25_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_FRSC_d04345c3-df70-4e2a-b197-cc37138e6700_SNAPS_','2022-03-11 10:17:45','2022-03-11 11:15:49','25_w1_o1_mordu_anterieur_snapshot_0.png','2022-03-11 11:17:45','SYNCED','b19b3b70-d194-4a56-8a06-dc3cf2fb8e6a',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.25.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'b25a25e2-610a-466d-a4d8-7518a09b9a78','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/computedocclusion_bdf42f40-5a7a-435b-a5e0-eb3migraoccl/6_w1_o1_maxillaire_occlusion_occ_file_0.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_OCC_bdf42f40-5a7a-435b-a5e0-eb3migraoccl_TOPLY__PLY_','2020-12-29 10:58:16','2020-04-10 11:52:17','6_w1_o1_maxillaire_occlusion_occ_file_0.ply','2020-12-29 11:58:16','SYNCED','b25a25e2-610a-466d-a4d8-7518a09b9a78',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire Occlusion 1.6.1.1.1\",\"referenceScanID\":\"1.6.1.1.1\",\"title\":\"Maxillaire Occlusion PLY\"}'),(662,'b2cc5b60-1704-4150-aead-5e59b3575b06','','JSON','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_PROST_118a8411-96d0-412f-a2fd-6e990b04bf34_JSON_','2020-04-17 05:54:35','2020-04-15 08:51:44','','2020-04-17 07:54:35','SYNCED','b2cc5b60-1704-4150-aead-5e59b3575b06',0,'2020-04-17 07:54:35','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"ODF 1.7.2.2 ODF\",\"title\":\"Odf JSON\"}'),(662,'b328d68a-733b-46ed-9a1a-20aefc9f9b17','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_019e5bd1-9330-4e70-8035-2fda343b0231/19_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_TOSC_019e5bd1-9330-4e70-8035-2fda343b0231_PLY_','2021-09-27 11:59:09','2021-09-27 12:22:21','19_w1_o1_maxillaire_scan_file_0.ply','2021-09-27 13:59:09','SYNCED','b328d68a-733b-46ed-9a1a-20aefc9f9b17',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire PLY\",\"modelMatrix\":\"-0.546245,0.828408,-0.123919,0,-0.837625,-0.540234,0.0808121,0,4.41513e-9,0.147941,0.988996,0,5.73056,-17.7586,-20.5485,1\",\"title\":\"Maxillaire PLY\"}'),(662,'b50704aa-49f1-4444-8df4-4ec2e9e99b38','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2a050d02-7424-4099-b1d0-2d7da678e690/occlusion_a5bc2d6f-0248-466f-a10b-08f5391fd12f/scan_d2cd260d-4191-4884-80e3-7ced9fa0f8ce/21_w5_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2a050d02-7424-4099-b1d0-2d7da678e690_SESS_a5bc2d6f-0248-466f-a10b-08f5391fd12f_TOSC_d2cd260d-4191-4884-80e3-7ced9fa0f8ce_ZIP_','2022-12-14 14:06:00','2022-11-04 13:46:23','21_w5_o1_maxillaire_scan_file_1.zip','2022-12-14 15:06:00','SYNCED','6558fea4-267a-4a73-8416-579630e68249',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.5.1.2\",\"modelMatrix\":\"0.821161,0.567307,-0.0621114,0,-0.570697,0.816283,-0.0893705,0,-4.83e-10,0.108834,0.99406,0,-27.6919,-16.2166,-25.6025,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'b51adc6b-e313-4ada-a607-3b0cd408c55b','','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_BOSC_e99b1c89-977c-4836-9719-ad6d9a6f6aae_SNAPS_','2021-02-16 09:45:56','2021-02-01 21:04:33','','2021-02-16 10:45:56','SYNCED','b51adc6b-e313-4ada-a607-3b0cd408c55b',0,'2021-02-16 10:45:56','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.14.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'b58b7bd8-eb47-4d54-9228-ce3a9e6486fd','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/computedocclusion_a18ca6df-d765-4c6a-be28-13amigraoccl/6_w1_o2_snapshot_occ_file_0.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_OCC_a18ca6df-d765-4c6a-be28-13amigraoccl_SNAPO__SNAPS_','2020-12-29 10:58:17','2020-04-17 11:21:05','6_w1_o2_snapshot_occ_file_0.png','2020-12-29 11:58:17','SYNCED','b58b7bd8-eb47-4d54-9228-ce3a9e6486fd',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Snapshot 1.6.1.2\",\"title\":\"Snapshot SNAPSHOT\"}'),(662,'b61e5533-433b-40e2-a91d-c157692b02c0','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_019e5bd1-9330-4e70-8035-2fda343b0231/19_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_TOSC_019e5bd1-9330-4e70-8035-2fda343b0231_SNAPS_','2021-09-27 11:57:34','2021-09-27 12:22:21','19_w1_o1_maxillaire_snapshot_0.png','2021-09-27 13:57:34','SYNCED','b61e5533-433b-40e2-a91d-c157692b02c0',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'b6432038-01b6-4f88-8506-0a2a5906d721','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_SNAPS_','2021-11-22 11:51:22','2021-11-22 12:38:42','21_w1_o1_mandibule_snapshot_2.png','2021-11-22 12:51:22','SYNCED','5dfbe9b8-c587-4311-b392-743be40fdd10',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'b6b42cf7-31c1-49e1-b1d1-c607c7ba299b','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_8f3d7d42-f6ad-4e48-8951-08222c212e7e/occlusion_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2/scan_b24d4ab4-dba3-4be5-8ba3-7eee381f40ec/21_w4_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_FRSC_b24d4ab4-dba3-4be5-8ba3-7eee381f40ec_ZIP_','2022-11-04 11:37:57','2022-11-04 12:34:44','21_w4_o1_mordu_anterieur_scan_file_0.zip','2022-11-04 12:37:57','SYNCED','b6b42cf7-31c1-49e1-b1d1-c607c7ba299b',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.21.4.1.1\",\"modelMatrix\":\"0.851612,-0.0875762,0.519248,0,0.0198226,0.992855,0.0821935,0,-0.523851,-0.0914267,0.851687,0,-1.52728,6.0236,-29.6291,1\",\"title\":\"Mordu anterieur ZIP\"}'),(662,'b6f09e06-083f-4c19-ae6f-63af10340898','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_b289ff52-6765-45a7-b1e2-fe7161ba809f/9_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_TOSC_b289ff52-6765-45a7-b1e2-fe7161ba809f_PLY_','2020-12-29 10:58:17','2020-04-18 09:26:03','9_w1_o1_maxillaire_scan_file_0.ply','2020-12-29 11:58:17','SYNCED','b6f09e06-083f-4c19-ae6f-63af10340898',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.9.1.1.2\",\"modelMatrix\":\"-0.653538,0.751011,-0.0941833,0,-0.756894,-0.648458,0.0813222,0,-2.55223e-9,0.124434,0.992228,0,-12.3055,-22.9777,-35.5141,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'b75b602f-a893-4dd9-8bbf-6b4b00421c4a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_44ccf5f6-834d-4090-88dc-399b19fed47e/15_w1_o1_mordu_anterieur_scan_file_0.ply','PLY','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_FRSC_44ccf5f6-834d-4090-88dc-399b19fed47e_PLY_','2021-02-16 12:05:37','2021-02-16 13:05:08','15_w1_o1_mordu_anterieur_scan_file_0.ply','2021-02-16 13:05:37','SYNCED','b75b602f-a893-4dd9-8bbf-6b4b00421c4a',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.15.1.1.1\",\"modelMatrix\":\"0.799,0.00329587,0.59269,0,0.103938,0.98246,-0.151533,0,-0.592407,0.186535,0.791122,0,9.17633,-7.75173,-25.8679,1\",\"title\":\"Mordu anterieur PLY\"}'),(662,'b7e23c05-dca2-450c-8296-062f60712c4b','','PLY','PATIENT_f61dd82a-2e03-48b9-8ab4-0840b811de63_ACT_d458682a-423b-43fe-a4b0-97d586104341_SESS_4af4bd2d-76e3-4905-99fd-191c4cc669fa_TOSC_f2b8c151-b863-4411-b17a-b987ca58ee6f_PLY_','2020-12-29 10:57:45','2020-04-09 10:56:37','','2020-12-29 11:57:45','SYNCED','b7e23c05-dca2-450c-8296-062f60712c4b',0,'2020-12-29 11:57:45','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.4.1.1.1\",\"modelMatrix\":\"-0.134659,0.929533,-0.34327,0,-0.990892,-0.126321,0.0466494,0,-2.43563e-9,0.346426,0.938077,0,19.7387,-10.2152,-39.8572,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'b9175f0f-b250-4ae3-b56c-51f5a10c10db','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_534cca35-8182-4f61-aa57-03bad8172eac/13_w4_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_FRSC_534cca35-8182-4f61-aa57-03bad8172eac_SNAPS_','2021-06-08 17:43:30','2020-12-29 11:35:15','13_w4_o1_mordu_anterieur_snapshot_0.png','2021-06-08 19:43:30','SYNCED','b9175f0f-b250-4ae3-b56c-51f5a10c10db',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur SNAPSHOT\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'b94c36ee-0e86-44b0-a152-b92997bdab17','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/occlusion_f2e73640-aebd-4bb1-9b02-c0504556ac5a/scan_e7efed59-e33c-4194-94c1-3507350dcfb5/5_w3_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_SESS_f2e73640-aebd-4bb1-9b02-c0504556ac5a_TOSC_e7efed59-e33c-4194-94c1-3507350dcfb5_SNAPS_','2020-12-29 10:58:18','2020-07-13 19:18:53','5_w3_o1_maxillaire_snapshot_0.png','2020-12-29 11:58:18','SYNCED','b94c36ee-0e86-44b0-a152-b92997bdab17',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.5.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'b9c83531-72e1-44a5-8e95-fc1d4c502741','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/smilersorder_2a5500be-4ce4-4028-839b-141af843989f/19_w1_smilers_file_0.json','JSON','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_PROST_2a5500be-4ce4-4028-839b-141af843989f_JSON_','2021-09-27 12:02:03','2021-09-27 13:56:51','19_w1_smilers_file_0.json','2021-09-27 14:02:03','SYNCED','b9c83531-72e1-44a5-8e95-fc1d4c502741',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'b9d391dc-72d3-11ec-9377-226cec7cb58a','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9d391dc-72d3-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_TOSC_793e84ce-b088-458d-82f5-33fab1f5e7de_ZIP_','2022-01-11 11:25:44','2022-01-11 12:23:20','b9d391dc-72d3-11ec-9377-226cec7cb58a.zip','2022-01-11 12:25:44','SYNCED','b9d391dc-72d3-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"modelMatrix\":\"-0.991214,-0.131706,0.0122187,0,0.132271,-0.986975,0.091564,0,1.89443e-11,0.0923757,0.995724,0,20.0589,-14.9599,-19.872,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'b9d5de8c-72d3-11ec-9377-226cec7cb58a','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9d5de8c-72d3-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_LESC_d675acff-ab7f-4d65-b55c-558379a8b3d0_ZIP_','2022-01-11 11:42:18','2022-01-11 12:39:02','b9d5de8c-72d3-11ec-9377-226cec7cb58a.zip','2022-01-11 12:42:18','SYNCED','b9d5de8c-72d3-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 1.23.1.1.1\",\"modelMatrix\":\"-0.920954,-0.163259,0.356869,0,0.137547,-0.986573,-0.0612914,0,0.364705,-0.0162589,0.932237,0,3.48454,4.97084,-20.3055,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(662,'b9d854a5-72d3-11ec-9377-226cec7cb58a','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9d854a5-72d3-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_BOSC_f0b63e95-26e8-4213-a935-ca2c37ab36ba_ZIP_','2022-01-11 11:37:40','2022-01-11 12:35:42','b9d854a5-72d3-11ec-9377-226cec7cb58a.zip','2022-01-11 12:37:40','SYNCED','b9d854a5-72d3-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"modelMatrix\":\"-0.841721,0.469057,-0.267377,0,-0.539912,-0.731259,0.41684,0,-1.10031e-8,0.495224,0.868765,0,14.7201,-8.7337,-18.0275,1\",\"title\":\"Mandibule ZIP\"}'),(662,'b9da69b7-72d3-11ec-9377-226cec7cb58a','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9da69b7-72d3-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_FRSC_5a4f6b62-6381-4a1e-bbef-61746f2722d3_ZIP_','2022-01-11 11:43:25','2022-01-11 12:41:15','b9da69b7-72d3-11ec-9377-226cec7cb58a.zip','2022-01-11 12:43:25','SYNCED','b9da69b7-72d3-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"modelMatrix\":\"0.84365,0.210589,0.497423,0,-0.180758,0.976383,-0.0219815,0,-0.506998,-0.0651306,0.867814,0,7.25809,0.136189,-25.0684,1\",\"title\":\"Mordu anterieur ZIP\"}'),(662,'b9dc2b5e-72d3-11ec-9377-226cec7cb58a','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9dc2b5e-72d3-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_RISC_6ce24fb2-7744-476b-a643-7e304d3ac013_SNAPS_','2022-01-11 11:42:19','2022-01-11 12:37:27','b9dc2b5e-72d3-11ec-9377-226cec7cb58a.png','2022-01-11 12:42:19','SYNCED','b9dc2b5e-72d3-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 1.23.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'b9de0e95-72d3-11ec-9377-226cec7cb58a','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9de0e95-72d3-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_TOSC_793e84ce-b088-458d-82f5-33fab1f5e7de_SNAPS_','2022-01-11 11:31:12','2022-01-11 12:23:17','b9de0e95-72d3-11ec-9377-226cec7cb58a.png','2022-01-11 12:31:12','SYNCED','b9de0e95-72d3-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'b9e0e714-72d3-11ec-9377-226cec7cb58a','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9e0e714-72d3-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_LESC_d675acff-ab7f-4d65-b55c-558379a8b3d0_SNAPS_','2022-01-11 11:43:25','2022-01-11 12:39:01','b9e0e714-72d3-11ec-9377-226cec7cb58a.png','2022-01-11 12:43:25','SYNCED','b9e0e714-72d3-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 1.23.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'b9e39911-72d3-11ec-9377-226cec7cb58a','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9e39911-72d3-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_RISC_6ce24fb2-7744-476b-a643-7e304d3ac013_ZIP_','2022-01-11 11:39:49','2022-01-11 12:37:28','b9e39911-72d3-11ec-9377-226cec7cb58a.zip','2022-01-11 12:39:49','SYNCED','b9e39911-72d3-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 1.23.1.1.1\",\"modelMatrix\":\"0.966505,-0.0822368,0.245802,0,0.0419504,0.990708,0.125232,0,-0.253409,-0.108826,0.961197,0,7.85892,3.99641,-19.3154,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(662,'b9e5d1e0-72d3-11ec-9377-226cec7cb58a','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9e5d1e0-72d3-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_BOSC_f0b63e95-26e8-4213-a935-ca2c37ab36ba_SNAPS_','2022-01-11 11:39:02','2022-01-11 12:35:39','b9e5d1e0-72d3-11ec-9377-226cec7cb58a.png','2022-01-11 12:39:02','SYNCED','b9e5d1e0-72d3-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'b9e83025-72d3-11ec-9377-226cec7cb58a','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9e83025-72d3-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_FRSC_5a4f6b62-6381-4a1e-bbef-61746f2722d3_SNAPS_','2022-01-11 11:43:26','2022-01-11 12:41:14','b9e83025-72d3-11ec-9377-226cec7cb58a.png','2022-01-11 12:43:26','SYNCED','b9e83025-72d3-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'ba881d4e-efc8-45fe-90c8-248f552f9196','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_534cca35-8182-4f61-aa57-03bad8172eac/13_w4_o1_mordu_anterieur_scan_file_0.ply','PLY','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_FRSC_534cca35-8182-4f61-aa57-03bad8172eac_PLY_','2020-12-29 11:05:55','2020-12-29 11:35:15','13_w4_o1_mordu_anterieur_scan_file_0.ply','2020-12-29 12:05:55','SYNCED','ba881d4e-efc8-45fe-90c8-248f552f9196',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur PLY\",\"modelMatrix\":\"0.574059,0.0227079,0.817806,0,0.165534,0.968138,-0.156835,0,-0.8024,0.251034,0.553742,0,15.1214,-11.3775,-31.1289,1\",\"title\":\"Mordu anterieur PLY\"}'),(662,'bad6504a-4f54-4dc9-83e3-02475160f717','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_586a7c87-5d8a-440f-a654-c452dc908844/occlusion_d70cc224-5e0d-4b47-9270-d8e23a25b566/scan_0e5656e0-946b-41b2-935b-ea820746e5a9/19_w4_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_586a7c87-5d8a-440f-a654-c452dc908844_SESS_d70cc224-5e0d-4b47-9270-d8e23a25b566_TOSC_0e5656e0-946b-41b2-935b-ea820746e5a9_SNAPS_','2023-03-21 11:27:30','2023-03-21 12:21:48','19_w4_o1_maxillaire_snapshot_0.png','2023-03-21 12:27:30','SYNCED','bad6504a-4f54-4dc9-83e3-02475160f717',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.4.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'bafe042a-2298-470c-8d08-071e0f4e388e','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_e43c8099-0862-42c3-9ad2-1efef27b83ba/occlusion_09f15124-6bba-4565-bfe4-efb3c6c3a17d/scan_3a315f7b-8cf2-4d0c-bf92-fecb623fe530/21_w3_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_e43c8099-0862-42c3-9ad2-1efef27b83ba_SESS_09f15124-6bba-4565-bfe4-efb3c6c3a17d_TOSC_3a315f7b-8cf2-4d0c-bf92-fecb623fe530_ZIP_','2022-09-14 10:25:31','2022-09-14 12:23:55','21_w3_o1_maxillaire_scan_file_1.zip','2022-09-14 12:25:31','SYNCED','110bfb15-3589-48ab-bb80-e339d042b64d',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.3.1.1\",\"modelMatrix\":\"0.804251,0.588743,-0.0810022,0,-0.594289,0.796746,-0.10962,0,9.77465e-10,0.136301,0.990668,0,-23.7315,-16.3663,-21.3795,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'bb2755e4-36de-4604-9ee9-d2711661ea1d','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_934f20d2-7444-4367-89e2-61c3bf4bee57/occlusion_ada38401-e257-4f32-8319-c7a394ce4463/scan_375f8fb7-d198-4281-9948-bba81b98e824/5_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_934f20d2-7444-4367-89e2-61c3bf4bee57_SESS_ada38401-e257-4f32-8319-c7a394ce4463_TOSC_375f8fb7-d198-4281-9948-bba81b98e824_PLY_','2020-12-29 10:58:18','2020-04-10 07:44:49','5_w1_o1_maxillaire_scan_file_0.ply','2020-12-29 11:58:18','SYNCED','bb2755e4-36de-4604-9ee9-d2711661ea1d',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.5.1.1.1\",\"modelMatrix\":\"-0.41714,0.872868,-0.253172,0,-0.908842,-0.400629,0.116201,0,-1.83889e-9,0.278565,0.960417,0,12.2781,-19.5045,-13.578,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'bc10348b-1c26-48ee-bc8f-6fa5ac933a14','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_scan_file_3.ply','PLY','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_PLY_','2020-12-29 10:58:18','2020-04-30 19:57:58','10_w1_o1_mandibule_scan_file_3.ply','2020-12-29 11:58:18','SYNCED','6008312e-ba22-4c98-a696-7500991d7069',3,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.10.1.1.2\",\"modelMatrix\":\"-0.956255,-0.280294,0.0837418,0,0.292536,-0.916237,0.273739,0,-9.38627e-11,0.286261,0.958152,0,18.7257,7.55089,-22.8578,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'bcb2c331-8297-48c9-9ba7-66e21108faf8','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_SNAPS_','2022-06-27 19:31:24','2022-06-27 20:55:59','21_w2_o1_mandibule_snapshot_2.png','2022-06-27 21:31:24','SYNCED','160153e9-3248-4a6b-b0ff-a10c2c1acfc9',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'be04859c-f9ff-4a11-96c0-99dd77c8c98f','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_26a765d3-8b92-4861-984a-bd9c8040209b/25_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_BOSC_26a765d3-8b92-4861-984a-bd9c8040209b_ZIP_','2022-03-11 09:28:10','2022-03-11 10:27:01','25_w1_o1_mandibule_scan_file_0.zip','2022-03-11 10:28:10','SYNCED','be04859c-f9ff-4a11-96c0-99dd77c8c98f',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"modelMatrix\":\"0.159059,0.963402,-0.215769,0,-0.987269,0.155214,-0.0347625,0,2.24982e-09,0.218551,0.975826,0,4.02306,-13.4981,-17.988,1\",\"title\":\"Mandibule ZIP\"}'),(662,'bfbd4222-08f2-4237-9b3e-e482e6111a20','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_37ff1278-3dd1-470a-8159-e763f6626f5d/6_w1_o2_mandibule_scan_file_1.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_BOSC_37ff1278-3dd1-470a-8159-e763f6626f5d_PLY_','2020-12-29 10:58:19','2020-04-17 11:12:10','6_w1_o2_mandibule_scan_file_1.ply','2020-12-29 11:58:19','SYNCED','83dce64b-81ec-4022-b7e5-8a738bbab39f',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.6.1.2.1\",\"modelMatrix\":\"-0.998147,-0.0551013,0.0258045,0,0.0608443,-0.903934,0.423322,0,6.8637e-10,0.424108,0.905612,0,7.9408,0.976609,-21.7447,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'c063b377-02e8-4830-bf3f-414b4e6325ca','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_e9aaa539-6e84-47bc-9c50-2c8797de82a4/19_w3_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_LESC_e9aaa539-6e84-47bc-9c50-2c8797de82a4_SNAPS_','2022-11-02 12:55:42','2022-11-02 12:34:58','19_w3_o1_mordu_posterieur_gauche_snapshot_0.png','2022-11-02 13:55:42','SYNCED','c063b377-02e8-4830-bf3f-414b4e6325ca',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.19.3.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'c0a56411-85d4-412b-84cc-45a71dee710a','','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_BOSC_34f5d93d-6a1f-4f94-ab20-4105c2cce30a_SNAPS_','2021-09-27 11:56:23','2021-06-08 20:30:59','','2021-09-27 13:56:23','SYNCED','c0a56411-85d4-412b-84cc-45a71dee710a',0,'2021-09-27 13:56:22','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.14.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'c0c1a357-1f5c-443a-ac07-9cc3a45a7853','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/occlusion_f2e73640-aebd-4bb1-9b02-c0504556ac5a/scan_e7efed59-e33c-4194-94c1-3507350dcfb5/5_w3_o1_maxillaire_scan_file_1.ply','PLY','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_SESS_f2e73640-aebd-4bb1-9b02-c0504556ac5a_TOSC_e7efed59-e33c-4194-94c1-3507350dcfb5_PLY_','2020-12-29 10:58:19','2020-07-13 19:32:07','5_w3_o1_maxillaire_scan_file_1.ply','2020-12-29 11:58:19','SYNCED','42d780c5-37b5-433e-890f-3c005cb69701',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.5.3.1.1\",\"modelMatrix\":\"-0.916377,-0.389552,0.092209,0,0.400316,-0.891736,0.211079,0,-7.53626e-10,0.23034,0.97311,0,9.09543,-8.03835,-24.7107,1\",\"title\":\"Maxillaire PLY\"}'),(662,'c14c7ae3-1390-4203-93ce-6ba836086c35','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_7a39120e-2f79-4c3e-af4d-af72e8ca8062/15_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PLY','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_LESC_7a39120e-2f79-4c3e-af4d-af72e8ca8062_PLY_','2021-02-16 11:57:45','2021-02-16 12:57:03','15_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','2021-02-16 12:57:45','SYNCED','c14c7ae3-1390-4203-93ce-6ba836086c35',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.15.1.1.1\",\"modelMatrix\":\"-0.869109,0.0327334,0.490122,0,0.187716,-0.888168,0.417206,0,0.457865,0.458605,0.765337,0,-0.754163,-13.2867,-19.8251,1\",\"title\":\"Mordu posterieur gauche PLY\"}'),(662,'c19a9e26-b162-4808-8d10-9d6a38e24e98','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_c1232582-95fc-48dc-a9ee-826c0cbad106/22_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_RISC_c1232582-95fc-48dc-a9ee-826c0cbad106_ZIP_','2021-11-23 11:19:02','2021-11-23 12:18:02','22_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2021-11-23 12:19:02','SYNCED','c19a9e26-b162-4808-8d10-9d6a38e24e98',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.1\",\"modelMatrix\":\"0.999595,-0.0218982,0.0166849,0,0.0161573,0.944762,0.325391,0,-0.0234339,-0.327034,0.945435,0,10.0522,9.09217,-24.9856,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(662,'c2475b5d-1f8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c2475b5d-1f8a-11ec-9377-226cec7cb58a.ply','PLY','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_FRSC_ef79558a-21cf-4117-a0b7-ba0adf40f7dc_PLY_','2021-09-27 12:00:41','2021-09-27 12:49:22','c2475b5d-1f8a-11ec-9377-226cec7cb58a.ply','2021-09-27 14:00:41','SYNCED','c2475b5d-1f8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 1.19.1.1.1\",\"modelMatrix\":\"0.84619,0.0571101,0.515766,0,-0.00658361,0.991989,-0.141669,0,-0.533379,0.115223,0.845157,0,-3.68638,-6.26512,-27.8081,1\",\"title\":\"Mordu anterieur PLY\"}'),(662,'c24a06b2-1f8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c24a06b2-1f8a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_RISC_99a6d55d-de66-49eb-a717-49cb2587fbef_SNAPS_','2021-09-27 11:57:53','2021-09-27 12:45:21','c24a06b2-1f8a-11ec-9377-226cec7cb58a.png','2021-09-27 13:57:53','SYNCED','c24a06b2-1f8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 1.19.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'c24da80c-1f8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c24da80c-1f8a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_BOSC_50e1896b-8565-4257-9a61-2a685fff8165_SNAPS_','2021-09-27 12:02:04','2021-09-27 12:43:41','c24da80c-1f8a-11ec-9377-226cec7cb58a.png','2021-09-27 14:02:04','SYNCED','c24da80c-1f8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.19.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'c2503be7-1f8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c2503be7-1f8a-11ec-9377-226cec7cb58a.ply','PLY','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_BOSC_50e1896b-8565-4257-9a61-2a685fff8165_PLY_','2021-09-27 11:59:57','2021-09-27 12:43:41','c2503be7-1f8a-11ec-9377-226cec7cb58a.ply','2021-09-27 13:59:57','SYNCED','c2503be7-1f8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.19.1.1.1\",\"modelMatrix\":\"0.258681,-0.958527,0.119627,0,0.965963,0.25669,-0.0320357,0,1.9715e-9,0.123842,0.992302,0,-20.8805,2.28408,-23.0637,1\",\"title\":\"Mandibule PLY\"}'),(662,'c25432d6-1f8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c25432d6-1f8a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_LESC_d7c4d383-83f9-4275-bbcc-567a47d4a450_SNAPS_','2021-09-27 12:00:42','2021-09-27 12:46:45','c25432d6-1f8a-11ec-9377-226cec7cb58a.png','2021-09-27 14:00:42','SYNCED','c25432d6-1f8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 1.19.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'c2574ae3-1f8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c2574ae3-1f8a-11ec-9377-226cec7cb58a.ply','PLY','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_TOSC_019e5bd1-9330-4e70-8035-2fda343b0231_PLY_','2021-09-27 12:02:01','2021-09-27 12:26:06','c2574ae3-1f8a-11ec-9377-226cec7cb58a.ply','2021-09-27 14:02:01','SYNCED','c2574ae3-1f8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"modelMatrix\":\"-0.899911,0.426922,-0.0888736,0,-0.436074,-0.881023,0.183405,0,5.95796e-9,0.203804,0.979012,0,12.9304,-14.3828,-20.7725,1\",\"title\":\"Maxillaire PLY\"}'),(662,'c25a1819-1f8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c25a1819-1f8a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_FRSC_ef79558a-21cf-4117-a0b7-ba0adf40f7dc_SNAPS_','2021-09-27 11:57:34','2021-09-27 12:49:22','c25a1819-1f8a-11ec-9377-226cec7cb58a.png','2021-09-27 13:57:34','SYNCED','c25a1819-1f8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 1.19.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'c25cb650-1f8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c25cb650-1f8a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_TOSC_019e5bd1-9330-4e70-8035-2fda343b0231_SNAPS_','2021-09-27 11:59:57','2021-09-27 12:26:06','c25cb650-1f8a-11ec-9377-226cec7cb58a.png','2021-09-27 13:59:57','SYNCED','c25cb650-1f8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'c25f3035-1f8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c25f3035-1f8a-11ec-9377-226cec7cb58a.ply','PLY','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_LESC_d7c4d383-83f9-4275-bbcc-567a47d4a450_PLY_','2021-09-27 11:57:52','2021-09-27 12:46:45','c25f3035-1f8a-11ec-9377-226cec7cb58a.ply','2021-09-27 13:57:52','SYNCED','c25f3035-1f8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 1.19.1.1.1\",\"modelMatrix\":\"-0.976818,-0.173343,0.122598,0,0.179187,-0.982871,0.0414572,0,0.117191,0.0625849,0.991598,0,10.7409,1.26499,-20.9619,1\",\"title\":\"Mordu posterieur gauche PLY\"}'),(662,'c2617b6f-1f8a-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c2617b6f-1f8a-11ec-9377-226cec7cb58a.ply','PLY','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_RISC_99a6d55d-de66-49eb-a717-49cb2587fbef_PLY_','2021-09-27 11:56:46','2021-09-27 12:45:21','c2617b6f-1f8a-11ec-9377-226cec7cb58a.ply','2021-09-27 13:56:46','SYNCED','c2617b6f-1f8a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 1.19.1.1.1\",\"modelMatrix\":\"0.976921,-0.211633,0.0384051,0,0.194578,0.946537,0.256535,0,-0.0881502,-0.243475,0.965774,0,0.602866,9.96784,-20.2879,1\",\"title\":\"Mordu posterieur droit PLY\"}'),(662,'c444e909-d341-4283-88a4-d2ec58f55e8a','','PLY','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_72c58d79-1141-4c63-b343-909886db5520_SESS_8d012545-b857-4595-a69d-1a2b1c750e13_TOSC_527c942e-3aa0-4028-b02a-8b3f137657be_PLY_','2020-12-29 10:57:45','2020-04-27 16:19:06','','2020-12-29 11:57:45','SYNCED','c444e909-d341-4283-88a4-d2ec58f55e8a',0,'2020-12-29 11:57:45','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.2.4.1.1\",\"modelMatrix\":\"-0.999956,-0.00913465,0.00222633,0,0.00940205,-0.971517,0.236782,0,-3.94949e-11,0.236792,0.97156,0,-26.8946,-7.79802,-38.0736,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'c44f8f8f-6ba9-4ae3-85ba-cffa8f6b3e13','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_SNAPS_','2022-06-28 18:27:43','2022-06-28 20:24:10','19_w2_o1_maxillaire_snapshot_1.png','2022-06-28 20:27:43','SYNCED','d40f4bba-69b0-4cc6-b541-e69c16b2b3d5',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'c7871ca0-e84a-4880-b74b-ef641334860e','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_f60bef39-641f-45a5-835c-4e84590668e4/occlusion_bb711dc3-11c1-44a8-96df-a5fb875eade5/scan_eece5ace-2081-4f39-859f-68495bd82499/13_w3_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_f60bef39-641f-45a5-835c-4e84590668e4_SESS_bb711dc3-11c1-44a8-96df-a5fb875eade5_TOSC_eece5ace-2081-4f39-859f-68495bd82499_PLY_','2021-06-08 17:45:16','2020-12-29 08:48:30','13_w3_o1_maxillaire_scan_file_0.ply','2021-06-08 19:45:16','SYNCED','c7871ca0-e84a-4880-b74b-ef641334860e',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.13.3.1.1\",\"modelMatrix\":\"0.677729,0.733645,-0.0494808,0,-0.735312,0.676193,-0.0456059,0,1.00789e-9,0.0672922,0.997733,0,-3.21678,29.3121,-17.9244,1\",\"title\":\"Maxillaire PLY\"}'),(662,'c8503263-9efa-47b8-8764-2bb09be6a1cb','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_scan_file_3.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_ZIP_','2021-11-22 11:45:30','2021-11-22 12:41:06','21_w1_o1_mandibule_scan_file_3.zip','2021-11-22 12:45:30','SYNCED','3aa92b1f-240d-45e1-a722-e8da98368f3a',3,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"modelMatrix\":\"-0.991383,-0.127699,0.029203,0,0.130996,-0.966434,0.22101,0,-2.82267e-9,0.222931,0.974834,0,20.0716,9.99111,-20.7432,1\",\"title\":\"Mandibule ZIP\"}'),(662,'c9051630-ef52-45e0-bf72-eef2676192c8','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_8f3d7d42-f6ad-4e48-8951-08222c212e7e/occlusion_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2/scan_2a466f6b-3960-4b1b-bb27-def76229cccc/21_w4_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_BOSC_2a466f6b-3960-4b1b-bb27-def76229cccc_SNAPS_','2022-11-04 11:40:10','2022-11-04 12:31:49','21_w4_o1_mandibule_snapshot_1.png','2022-11-04 12:40:10','SYNCED','0cbb67d8-7a5d-43de-a85a-8ad3ddf2e2cb',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.4.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'c96624b7-bb0a-400c-b02e-bdfd89bdac9e','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_b289ff52-6765-45a7-b1e2-fe7161ba809f/9_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_TOSC_b289ff52-6765-45a7-b1e2-fe7161ba809f_SNAPS_','2020-12-29 10:58:20','2020-04-18 09:26:03','9_w1_o1_maxillaire_snapshot_0.png','2020-12-29 11:58:20','SYNCED','c96624b7-bb0a-400c-b02e-bdfd89bdac9e',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.9.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'ca0a9826-3f91-4aaf-984b-889d4cff43a5','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_9716867f-e0a3-478a-a498-1e84ae803044/21_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_LESC_9716867f-e0a3-478a-a498-1e84ae803044_SNAPS_','2021-11-22 11:51:22','2021-11-22 12:45:44','21_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2021-11-22 12:51:22','SYNCED','ca0a9826-3f91-4aaf-984b-889d4cff43a5',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'ca42217b-f484-48a1-bff2-3b72dc4f7f2f','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_f766f1dd-53ad-45fc-8f7b-a61d47dfe500/16_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_LESC_f766f1dd-53ad-45fc-8f7b-a61d47dfe500_SNAPS_','2021-02-27 09:52:48','2021-02-27 10:52:46','16_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2021-02-27 10:52:48','SYNCED','ca42217b-f484-48a1-bff2-3b72dc4f7f2f',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.16.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'ca78a19d-bcad-4ceb-b844-f2badf2ebc09','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_scan_file_1.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_PLY_','2021-02-01 19:30:25','2021-02-01 20:28:14','14_w1_o1_maxillaire_scan_file_1.ply','2021-02-01 20:30:25','SYNCED','e720e2f6-8dce-43f4-a5d6-bf8c09037947',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.999973,-0.0069625,0.00254487,0,0.00741301,-0.939201,0.343289,0,-1.7763e-10,0.343298,0.939226,0,5.24999,-21.177,-20.3298,1\",\"title\":\"Maxillaire PLY\"}'),(662,'cb85cf03-baff-4dcf-bc65-cf1a9c7b9e84','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_snapshot_4.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_SNAPS_','2021-02-01 19:46:15','2021-02-01 20:46:11','14_w1_o1_maxillaire_snapshot_4.png','2021-02-01 20:46:15','SYNCED','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb',4,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'cc3c0e89-9cd8-4432-9607-044314bb9633','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_cd4cde89-86e9-4257-92b6-869e9aa8d1f6/7_w4_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_FRSC_cd4cde89-86e9-4257-92b6-869e9aa8d1f6_SNAPS_','2020-12-29 10:58:20','2020-04-16 11:35:43','7_w4_o1_mordu_anterieur_snapshot_0.png','2020-12-29 11:58:20','SYNCED','cc3c0e89-9cd8-4432-9607-044314bb9633',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.7.4.1.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}'),(662,'cc4a874a-55b6-43ea-a757-cbad99deb1cf','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_e43c8099-0862-42c3-9ad2-1efef27b83ba/smilersorder_4dd9cb8a-22ca-48ed-943c-f8227a82fd43/21_w3_smilers_file_0.json','JSON','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_e43c8099-0862-42c3-9ad2-1efef27b83ba_PROST_4dd9cb8a-22ca-48ed-943c-f8227a82fd43_JSON_','2022-09-14 10:25:32','2022-09-14 12:24:53','21_w3_smilers_file_0.json','2022-09-14 12:25:32','SYNCED','cc4a874a-55b6-43ea-a757-cbad99deb1cf',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'cce7b291-ae52-44af-bd7e-fe49b16c09c7','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_65315958-b964-4f7e-a111-9c7695d8092b/6_w1_o2_mordu_posterieur_droit_scan_file_0.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_RISC_65315958-b964-4f7e-a111-9c7695d8092b_PLY_','2020-12-29 10:58:21','2020-04-17 11:14:14','6_w1_o2_mordu_posterieur_droit_scan_file_0.ply','2020-12-29 11:58:21','SYNCED','cce7b291-ae52-44af-bd7e-fe49b16c09c7',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.6.1.2.1\",\"modelMatrix\":\"0.907571,-0.0262625,0.416813,0,-0.0451124,0.987321,0.148865,0,-0.417488,-0.156638,0.896735,0,1.58524,4.50253,-20.5933,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(662,'ce7041b4-86ce-4167-b150-b49d4f0008a6','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_6ce24fb2-7744-476b-a643-7e304d3ac013/23_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_RISC_6ce24fb2-7744-476b-a643-7e304d3ac013_ZIP_','2022-01-11 11:39:49','2022-01-11 12:37:28','23_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-01-11 12:39:49','SYNCED','ce7041b4-86ce-4167-b150-b49d4f0008a6',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.23.1.1.1\",\"modelMatrix\":\"0.966505,-0.0822368,0.245802,0,0.0419504,0.990708,0.125232,0,-0.253409,-0.108826,0.961197,0,7.85892,3.99641,-19.3154,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(662,'cf189c0a-4444-4e39-9766-e4e47582f98c','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_2bf301a3-b61c-4ddd-b6a2-4924c804d5f8/6_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_LESC_2bf301a3-b61c-4ddd-b6a2-4924c804d5f8_SNAPS_','2020-12-29 10:58:21','2020-04-10 11:51:26','6_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2020-12-29 11:58:21','SYNCED','cf189c0a-4444-4e39-9766-e4e47582f98c',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.6.1.1.3\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}'),(662,'cfce77ff-b3ac-4f31-ba2d-7ffffd711fef','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_f60bef39-641f-45a5-835c-4e84590668e4/occlusion_bb711dc3-11c1-44a8-96df-a5fb875eade5/scan_eece5ace-2081-4f39-859f-68495bd82499/13_w3_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_f60bef39-641f-45a5-835c-4e84590668e4_SESS_bb711dc3-11c1-44a8-96df-a5fb875eade5_TOSC_eece5ace-2081-4f39-859f-68495bd82499_SNAPS_','2021-06-08 17:43:24','2020-12-29 08:48:30','13_w3_o1_maxillaire_snapshot_0.png','2021-06-08 19:43:24','SYNCED','cfce77ff-b3ac-4f31-ba2d-7ffffd711fef',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.13.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'d0155fb7-667e-4f4e-be6a-1eacb81ecb13','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_e6e5d8c5-2d8c-48d0-9708-e3256202d385/15_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_BOSC_e6e5d8c5-2d8c-48d0-9708-e3256202d385_SNAPS_','2021-02-16 11:40:35','2021-02-16 12:40:32','15_w1_o1_mandibule_snapshot_0.png','2021-02-16 12:40:35','SYNCED','d0155fb7-667e-4f4e-be6a-1eacb81ecb13',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.15.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'d1e9dead-d755-4b41-9105-4b6355694989','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_18365744-4019-43e1-933f-9fa52db1a30d/14_w2_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_FRSC_18365744-4019-43e1-933f-9fa52db1a30d_SNAPS_','2021-06-08 18:56:55','2021-06-08 20:56:53','14_w2_o1_mordu_anterieur_snapshot_0.png','2021-06-08 20:56:55','SYNCED','d1e9dead-d755-4b41-9105-4b6355694989',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.14.2.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'d2a7b476-1ed0-4870-8219-9863d50e401c','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_scan_file_4.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_ZIP_','2023-01-11 12:45:48','2023-01-11 12:52:39','21_w7_o1_mandibule_scan_file_4.zip','2023-01-11 13:45:48','SYNCED','097b9793-f270-498e-9cfe-cf6bc2963744',4,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"modelMatrix\":\"0.982862,0.182458,-0.0262986,0,-0.184344,0.972809,-0.140216,0,-3.46081e-09,0.142661,0.989772,0,-21.336,-16.0061,-21.4679,1\",\"title\":\"Mandibule ZIP\"}'),(662,'d2cb8acf-0a31-40f9-932c-a089f44c1a4b','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_ZIP_','2023-01-11 12:43:22','2023-01-11 12:34:06','21_w7_o1_mandibule_scan_file_2.zip','2023-01-11 13:43:22','SYNCED','097b9793-f270-498e-9cfe-cf6bc2963744',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"modelMatrix\":\"0.996915,-0.0774397,0.0127846,0,0.0784879,0.983601,-0.162383,0,-5.56742e-10,0.162886,0.986645,0,-24.0989,-9.70303,-22.4041,1\",\"title\":\"Mandibule ZIP\"}'),(662,'d2ffe250-09d3-47fd-af00-7d6cc98742d8','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_f0b63e95-26e8-4213-a935-ca2c37ab36ba/23_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_BOSC_f0b63e95-26e8-4213-a935-ca2c37ab36ba_ZIP_','2022-01-11 11:33:14','2022-01-11 12:31:11','23_w1_o1_mandibule_scan_file_0.zip','2022-01-11 12:33:14','SYNCED','d2ffe250-09d3-47fd-af00-7d6cc98742d8',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"modelMatrix\":\"-0.909786,0.3568,-0.212092,0,-0.415077,-0.78205,0.464874,0,-7.94157e-9,0.510971,0.859598,0,13.5709,-9.02815,-18.5425,1\",\"title\":\"Mandibule ZIP\"}'),(662,'d3e47b22-64d4-4936-a2f6-a2a11b01fdf2','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_ccd3f4f6-f303-4b20-b967-d41121f2e36b/14_w1_o1_mordu_anterieur_scan_file_0.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_FRSC_ccd3f4f6-f303-4b20-b967-d41121f2e36b_PLY_','2021-02-01 20:23:07','2021-02-01 21:22:33','14_w1_o1_mordu_anterieur_scan_file_0.ply','2021-02-01 21:23:07','SYNCED','d3e47b22-64d4-4936-a2f6-a2a11b01fdf2',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.14.1.1.1\",\"modelMatrix\":\"0.800279,0.121062,0.587925,0,0.017273,0.972761,-0.210082,0,-0.599407,0.199022,0.78148,0,1.77421,-7.79839,-28.7594,1\",\"title\":\"Mordu anterieur PLY\"}'),(662,'d40f4bba-69b0-4cc6-b541-e69c16b2b3d5','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_SNAPS_','2022-06-28 18:24:14','2022-06-28 20:20:22','19_w2_o1_maxillaire_snapshot_0.png','2022-06-28 20:24:14','SYNCED','d40f4bba-69b0-4cc6-b541-e69c16b2b3d5',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'d455a946-5407-4abb-8fdb-711fb0adfe7c','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_50e1896b-8565-4257-9a61-2a685fff8165/19_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_BOSC_50e1896b-8565-4257-9a61-2a685fff8165_SNAPS_','2021-09-27 12:02:02','2021-09-27 12:37:45','19_w1_o1_mandibule_snapshot_0.png','2021-09-27 14:02:02','SYNCED','d455a946-5407-4abb-8fdb-711fb0adfe7c',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule SNAPSHOT\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'d47ef10b-7c9f-4fd9-8617-329e21bbfa35','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_876f775b-e8a0-4b7f-bea0-0c93a7041d17/13_w4_o1_mordu_posterieur_gauche_scan_file_0.ply','PLY','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_LESC_876f775b-e8a0-4b7f-bea0-0c93a7041d17_PLY_','2020-12-29 11:02:56','2020-12-29 11:33:10','13_w4_o1_mordu_posterieur_gauche_scan_file_0.ply','2020-12-29 12:02:56','SYNCED','d47ef10b-7c9f-4fd9-8617-329e21bbfa35',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.13.4.1.1\",\"modelMatrix\":\"-0.989849,0.00288431,0.139374,0,0.0124051,-0.999231,0.0385922,0,0.141934,0.0402796,0.989493,0,1.43521,3.27328,-19.9916,1\",\"title\":\"Mordu posterieur gauche PLY\"}'),(662,'d5ddb4c9-b9d4-4dbd-91ab-8ba108c565e0','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_f0b63e95-26e8-4213-a935-ca2c37ab36ba/23_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_BOSC_f0b63e95-26e8-4213-a935-ca2c37ab36ba_SNAPS_','2022-01-11 11:39:02','2022-01-11 12:35:39','23_w1_o1_mandibule_snapshot_1.png','2022-01-11 12:39:02','SYNCED','1f154183-a975-4dfa-b4eb-fea963eb0d6c',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'d5df3022-2abe-4d54-a53d-63cb7ad80b02','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_019e5bd1-9330-4e70-8035-2fda343b0231/19_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_TOSC_019e5bd1-9330-4e70-8035-2fda343b0231_SNAPS_','2021-09-27 11:59:57','2021-09-27 12:26:06','19_w1_o1_maxillaire_snapshot_1.png','2021-09-27 13:59:57','SYNCED','b61e5533-433b-40e2-a91d-c157692b02c0',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'d7178627-cef8-4d56-87be-5ce753175b9f','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_c99bbff9-5630-49d7-9300-4dabfa5e74c8/15_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PLY','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_RISC_c99bbff9-5630-49d7-9300-4dabfa5e74c8_PLY_','2021-02-16 11:53:49','2021-02-16 12:53:05','15_w1_o1_mordu_posterieur_droit_scan_file_0.ply','2021-02-16 12:53:49','SYNCED','d7178627-cef8-4d56-87be-5ce753175b9f',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.15.1.1.1\",\"modelMatrix\":\"0.987337,-0.119112,0.109788,0,0.0884693,0.965911,0.235065,0,-0.131706,-0.229995,0.965796,0,7.31577,5.21565,-24.3729,1\",\"title\":\"Mordu posterieur droit PLY\"}'),(662,'d7875c8c-cb63-4940-9761-68ef1c238665','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_4a2eec76-a5f3-44f0-b389-4734998fa2d3/13_w4_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_BOSC_4a2eec76-a5f3-44f0-b389-4734998fa2d3_SNAPS_','2021-06-08 17:45:18','2020-12-29 11:28:31','13_w4_o1_mandibule_snapshot_2.png','2021-06-08 19:45:18','SYNCED','e8f06fb1-375a-41c0-9a27-d0ee2593900c',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.13.4.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'d82bb8e8-709c-4148-9290-d8b05ce3f7e6','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_99102b35-9ad0-4017-b70e-fa08e5c36102/19_w3_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_RISC_99102b35-9ad0-4017-b70e-fa08e5c36102_ZIP_','2022-11-02 12:56:25','2022-11-02 12:34:10','19_w3_o1_mordu_posterieur_droit_scan_file_0.zip','2022-11-02 13:56:25','SYNCED','d82bb8e8-709c-4148-9290-d8b05ce3f7e6',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.19.3.1.1\",\"modelMatrix\":\"0.990577,0.063814,0.120048,0,-0.0634761,0.997187,-0.0428834,0,-0.121464,0.0398795,0.991852,0,-6.34989,1.53472,-18.1401,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(662,'dab48b34-de4a-4877-be2f-a21e13908dff','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_586a7c87-5d8a-440f-a654-c452dc908844/occlusion_d70cc224-5e0d-4b47-9270-d8e23a25b566/scan_0e5656e0-946b-41b2-935b-ea820746e5a9/19_w4_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_586a7c87-5d8a-440f-a654-c452dc908844_SESS_d70cc224-5e0d-4b47-9270-d8e23a25b566_TOSC_0e5656e0-946b-41b2-935b-ea820746e5a9_ZIP_','2023-03-21 11:25:37','2023-03-21 12:21:50','19_w4_o1_maxillaire_scan_file_0.zip','2023-03-21 12:25:37','SYNCED','dab48b34-de4a-4877-be2f-a21e13908dff',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.4.1.1\",\"modelMatrix\":\"-0.621447,0.718186,-0.31307,0,-0.783456,-0.569674,0.248331,0,-8.99901e-09,0.399601,0.916689,0,10.6751,-34.2765,-17.4579,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'dc97d683-1aa5-4aba-bf5c-a43b36478d90','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_5a59f382-4b59-4867-8640-021d20bdcd59/19_w3_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_FRSC_5a59f382-4b59-4867-8640-021d20bdcd59_ZIP_','2022-11-02 14:03:24','2022-11-02 12:36:21','19_w3_o1_mordu_anterieur_scan_file_0.zip','2022-11-02 15:03:24','SYNCED','dc97d683-1aa5-4aba-bf5c-a43b36478d90',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.19.3.1.1\",\"modelMatrix\":\"0.78556,0.0689669,0.617195,0,-0.0519632,0.992749,0.0772647,0,-0.622253,-0.130203,0.783238,0,16.0725,3.3683,-20.068,1\",\"title\":\"Mordu anterieur ZIP\"}'),(662,'dd19221a-2e2b-4f03-9062-62bb291352d2','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/3d722760-3820-40e4-81e1-60e722c0cb01/session_1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e/occlusion_20b31e3a-565c-49b0-b2ff-0dae86b25c76/scan_3e1d8e57-feae-45d6-80f0-9d0be041ff7a/28_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_3d722760-3820-40e4-81e1-60e722c0cb01_ACT_1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e_SESS_20b31e3a-565c-49b0-b2ff-0dae86b25c76_TOSC_3e1d8e57-feae-45d6-80f0-9d0be041ff7a_SNAPS_','2022-09-19 09:55:16','2022-09-19 11:48:30','28_w1_o1_maxillaire_snapshot_0.png','2022-09-19 11:55:16','SYNCED','dd19221a-2e2b-4f03-9062-62bb291352d2',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.28.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'dd1d9407-c7db-11ed-9ced-0050569a5229','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/dd1d9407-c7db-11ed-9ced-0050569a5229.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_586a7c87-5d8a-440f-a654-c452dc908844_SESS_d70cc224-5e0d-4b47-9270-d8e23a25b566_TOSC_0e5656e0-946b-41b2-935b-ea820746e5a9_SNAPS_','2023-03-21 11:30:55','2023-03-21 12:27:26','dd1d9407-c7db-11ed-9ced-0050569a5229.png','2023-03-21 12:30:55','SYNCED','dd1d9407-c7db-11ed-9ced-0050569a5229',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.19.4.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'dd202b6b-c7db-11ed-9ced-0050569a5229','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/dd202b6b-c7db-11ed-9ced-0050569a5229.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_586a7c87-5d8a-440f-a654-c452dc908844_SESS_d70cc224-5e0d-4b47-9270-d8e23a25b566_TOSC_0e5656e0-946b-41b2-935b-ea820746e5a9_ZIP_','2023-03-21 11:30:54','2023-03-21 12:27:29','dd202b6b-c7db-11ed-9ced-0050569a5229.zip','2023-03-21 12:30:54','SYNCED','dd202b6b-c7db-11ed-9ced-0050569a5229',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.19.4.1.1\",\"modelMatrix\":\"-0.635437,0.697716,-0.330774,0,-0.772152,-0.57418,0.272209,0,5.70047e-10,0.42838,0.903599,0,7.99987,-37.8812,-17.5689,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'dd29f41a-cbb1-45d7-8979-1d16d4db487c','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_453abb20-3827-4f8b-b57f-c656c72ebf11/20_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_BOSC_453abb20-3827-4f8b-b57f-c656c72ebf11_ZIP_','2021-10-12 12:33:36','2021-10-12 12:26:35','20_w1_o1_mandibule_scan_file_1.zip','2021-10-12 14:33:36','SYNCED','ede17ed3-0dee-42d5-86a9-2728608363fe',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.20.1.1.1\",\"modelMatrix\":\"0.993602,-0.104869,0.0419241,0,0.112939,0.922608,-0.368835,0,-7.12355e-11,0.37121,0.928549,0,-21.8303,-22.816,-15.4889,1\",\"title\":\"Mandibule ZIP\"}'),(662,'dd45b218-e893-4bfa-a2dc-cfdb060bbcbc','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_SNAPS_','2023-01-11 12:42:17','2023-01-11 12:34:03','21_w7_o1_mandibule_snapshot_2.png','2023-01-11 13:42:17','SYNCED','252b180c-565f-4f14-af48-a16cebbead9e',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'de0c426e-a321-49cc-9a15-8f590e95c146','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_d1ad6baa-b3e6-4e10-bd69-140c7abc8f4e/6_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_FRSC_d1ad6baa-b3e6-4e10-bd69-140c7abc8f4e_SNAPS_','2020-12-29 10:58:21','2020-04-10 11:49:59','6_w1_o1_mordu_anterieur_snapshot_0.png','2020-12-29 11:58:21','SYNCED','de0c426e-a321-49cc-9a15-8f590e95c146',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.6.1.1.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}'),(662,'de0cdea6-9c25-4adc-b642-788b56270d11','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5/6_w1_o2_maxillaire_snapshot_1.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_TOSC_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5_SNAPS_','2020-12-29 10:58:22','2020-04-17 11:04:13','6_w1_o2_maxillaire_snapshot_1.png','2020-12-29 11:58:22','SYNCED','35704ab9-18dc-4d80-81f3-5f50e93033c6',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.6.1.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(662,'def017c4-f711-11ec-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/def017c4-f711-11ec-a752-9ec33d03e6dd.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_SNAPS_','2022-06-28 18:40:57','2022-06-28 20:39:39','def017c4-f711-11ec-a752-9ec33d03e6dd.png','2022-06-28 20:40:57','SYNCED','def017c4-f711-11ec-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'def1623b-f711-11ec-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/def1623b-f711-11ec-a752-9ec33d03e6dd.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_ZIP_','2022-06-28 18:40:56','2022-06-28 20:39:41','def1623b-f711-11ec-a752-9ec33d03e6dd.zip','2022-06-28 20:40:56','SYNCED','def1623b-f711-11ec-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"modelMatrix\":\"-0.913445,0.391574,-0.110853,0,-0.406963,-0.878905,0.248813,0,-2.04414e-09,0.27239,0.962187,0,9.22638,-15.1189,-27.0834,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'e0880d3b-5ad5-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e0880d3b-5ad5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_TOSC_ed495283-b756-4052-ba8b-5fe9f9b1f8be_ZIP_','2022-11-02 17:43:20','2022-11-02 12:30:09','e0880d3b-5ad5-11ed-a752-9ec33d03e6dd.zip','2022-11-02 18:43:20','SYNCED','e0880d3b-5ad5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.19.3.1.1\",\"modelMatrix\":\"0.997618,-0.0632367,0.0275495,0,0.0689772,0.914593,-0.398449,0,-2.86851e-09,0.3994,0.916777,0,-21.303,5.53173,-20.191,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'e0898270-5ad5-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e0898270-5ad5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_RISC_99102b35-9ad0-4017-b70e-fa08e5c36102_SNAPS_','2022-11-02 14:09:58','2022-11-02 12:34:10','e0898270-5ad5-11ed-a752-9ec33d03e6dd.png','2022-11-02 15:09:58','SYNCED','e0898270-5ad5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 1.19.3.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'e08b1d8c-5ad5-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e08b1d8c-5ad5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_LESC_e9aaa539-6e84-47bc-9c50-2c8797de82a4_ZIP_','2022-11-02 14:09:57','2022-11-02 12:34:58','e08b1d8c-5ad5-11ed-a752-9ec33d03e6dd.zip','2022-11-02 15:09:57','SYNCED','e08b1d8c-5ad5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 1.19.3.1.1\",\"modelMatrix\":\"-0.983417,-0.121012,0.138821,0,0.133349,-0.98274,0.127701,0,0.12304,0.140097,0.982062,0,-8.04084,2.09214,-18.4869,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(662,'e08c98f8-5ad5-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e08c98f8-5ad5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_FRSC_5a59f382-4b59-4867-8640-021d20bdcd59_SNAPS_','2022-11-02 14:09:59','2022-11-02 12:36:21','e08c98f8-5ad5-11ed-a752-9ec33d03e6dd.png','2022-11-02 15:09:59','SYNCED','e08c98f8-5ad5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 1.19.3.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'e08dfb34-5ad5-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e08dfb34-5ad5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_LESC_e9aaa539-6e84-47bc-9c50-2c8797de82a4_SNAPS_','2022-11-02 12:55:42','2022-11-02 12:34:58','e08dfb34-5ad5-11ed-a752-9ec33d03e6dd.png','2022-11-02 13:55:42','SYNCED','e08dfb34-5ad5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 1.19.3.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'e08f638b-5ad5-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e08f638b-5ad5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_RISC_99102b35-9ad0-4017-b70e-fa08e5c36102_ZIP_','2022-11-02 12:56:25','2022-11-02 12:34:10','e08f638b-5ad5-11ed-a752-9ec33d03e6dd.zip','2022-11-02 13:56:25','SYNCED','e08f638b-5ad5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 1.19.3.1.1\",\"modelMatrix\":\"0.990577,0.063814,0.120048,0,-0.0634761,0.997187,-0.0428834,0,-0.121464,0.0398795,0.991852,0,-6.34989,1.53472,-18.1401,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(662,'e0909d5b-5ad5-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e0909d5b-5ad5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_FRSC_5a59f382-4b59-4867-8640-021d20bdcd59_ZIP_','2022-11-02 14:03:24','2022-11-02 12:36:21','e0909d5b-5ad5-11ed-a752-9ec33d03e6dd.zip','2022-11-02 15:03:24','SYNCED','e0909d5b-5ad5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 1.19.3.1.1\",\"modelMatrix\":\"0.78556,0.0689669,0.617195,0,-0.0519632,0.992749,0.0772647,0,-0.622253,-0.130203,0.783238,0,16.0725,3.3683,-20.068,1\",\"title\":\"Mordu anterieur ZIP\"}'),(662,'e0920e08-5ad5-11ed-a752-9ec33d03e6dd','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e0920e08-5ad5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_TOSC_ed495283-b756-4052-ba8b-5fe9f9b1f8be_SNAPS_','2022-11-02 14:09:58','2022-11-02 12:30:06','e0920e08-5ad5-11ed-a752-9ec33d03e6dd.png','2022-11-02 15:09:58','SYNCED','e0920e08-5ad5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.19.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'e0c2841d-b460-4eda-9548-18bb8a59d908','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2a050d02-7424-4099-b1d0-2d7da678e690/occlusion_a5bc2d6f-0248-466f-a10b-08f5391fd12f/scan_d2cd260d-4191-4884-80e3-7ced9fa0f8ce/21_w5_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2a050d02-7424-4099-b1d0-2d7da678e690_SESS_a5bc2d6f-0248-466f-a10b-08f5391fd12f_TOSC_d2cd260d-4191-4884-80e3-7ced9fa0f8ce_SNAPS_','2022-12-14 14:06:01','2022-11-04 13:46:21','21_w5_o1_maxillaire_snapshot_1.png','2022-12-14 15:06:01','SYNCED','a76fbd10-38f6-45b2-bcd6-4235bebb7cc8',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.5.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'e1692a67-2979-4399-b4dc-65a1c7e9c4b8','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_ae899af8-7040-48c9-a9b2-6ebc255ac7c9/15_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_TOSC_ae899af8-7040-48c9-a9b2-6ebc255ac7c9_PLY_','2021-02-16 11:20:41','2021-02-16 12:19:19','15_w1_o1_maxillaire_scan_file_0.ply','2021-02-16 12:20:41','SYNCED','e1692a67-2979-4399-b4dc-65a1c7e9c4b8',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.15.1.1.1\",\"modelMatrix\":\"-0.725898,-0.666889,0.168318,0,0.687803,-0.703826,0.177641,0,-2.52568e-9,0.244719,0.969594,0,16.8234,-0.758748,-27.4469,1\",\"title\":\"Maxillaire PLY\"}'),(662,'e18ed074-c432-415e-b63e-3b73dcb95e72','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/order_50b326be-6726-493a-a2ce-6f1153dc9927/6_w1_autre_prost_file_0.pdf','PDF','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_PROST_50b326be-6726-493a-a2ce-6f1153dc9927_PDF_','2020-04-17 05:56:50','2020-04-17 07:56:49','6_w1_autre_prost_file_0.pdf','2020-04-17 07:56:50','SYNCED','e18ed074-c432-415e-b63e-3b73dcb95e72',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.6.1.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}'),(662,'e22ce6e5-78b3-470f-8eac-fc2668ff13bc','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_3eede325-0afb-43f5-9277-e22c18f8f927/occlusion_f72f6016-0f75-4789-9924-1bc9aa64c2f1/scan_254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff/20_w2_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_3eede325-0afb-43f5-9277-e22c18f8f927_SESS_f72f6016-0f75-4789-9924-1bc9aa64c2f1_BOSC_254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff_SNAPS_','2022-08-06 11:58:03','2022-08-06 13:56:36','20_w2_o1_mandibule_snapshot_0.png','2022-08-06 13:58:03','SYNCED','e22ce6e5-78b3-470f-8eac-fc2668ff13bc',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.20.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'e22d8b26-814a-456b-850f-82860b769634','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_d36d186b-d0da-4aea-af1a-4613f67b2fa0/6_w1_o2_mordu_posterieur_gauche_scan_file_0.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_LESC_d36d186b-d0da-4aea-af1a-4613f67b2fa0_PLY_','2020-12-29 10:58:23','2020-04-17 11:17:41','6_w1_o2_mordu_posterieur_gauche_scan_file_0.ply','2020-12-29 11:58:23','SYNCED','e22d8b26-814a-456b-850f-82860b769634',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.6.1.2.1\",\"modelMatrix\":\"-0.976498,-0.184814,0.106105,0,0.17864,-0.979328,-0.095944,0,0.120669,-0.0826865,0.989745,0,-6.4813,-0.817089,-19.9051,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}'),(662,'e2e61121-2865-452b-a685-13a4ecd0974b','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_snapshot_6.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_SNAPS_','2021-02-01 19:56:54','2021-02-01 20:56:49','14_w1_o1_maxillaire_snapshot_6.png','2021-02-01 20:56:54','SYNCED','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb',6,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'e31677ad-6acd-445e-8577-f3c741a13dc2','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_0f18aace-5cf2-4d46-b56f-f8dc123e1f91/22_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_LESC_0f18aace-5cf2-4d46-b56f-f8dc123e1f91_SNAPS_','2021-11-23 11:23:20','2021-11-23 12:21:30','22_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2021-11-23 12:23:20','SYNCED','e31677ad-6acd-445e-8577-f3c741a13dc2',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.22.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'e3171b5f-22cc-46f8-af75-7031b77dcec3','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/smilersorder_ddf3aa86-53ab-4afd-90b7-ff5de6dbb17e/21_w7_smilers_file_0.json','JSON','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_PROST_ddf3aa86-53ab-4afd-90b7-ff5de6dbb17e_JSON_','2023-01-11 12:45:48','2023-01-11 13:45:24','21_w7_smilers_file_0.json','2023-01-11 13:45:48','SYNCED','e3171b5f-22cc-46f8-af75-7031b77dcec3',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'e3dcb444-172f-4ae1-a2bc-7ff3b7c8eb26','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a/14_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_LESC_7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a_PLY_','2021-02-01 20:20:17','2021-02-01 21:19:45','14_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','2021-02-01 21:20:17','SYNCED','e3dcb444-172f-4ae1-a2bc-7ff3b7c8eb26',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.14.1.1.1\",\"modelMatrix\":\"-0.985289,-0.131765,0.118009,0,0.131279,-0.988844,0.0497781,0,0.109691,0.0700508,0.991776,0,-5.9124,-3.58406,-17.0319,1\",\"title\":\"Mordu posterieur gauche PLY\"}'),(662,'e54a3aaa-1b5e-4e05-b9aa-30359687e6de','','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_PLY_','2020-12-29 10:57:45','2020-04-15 07:29:30','','2020-12-29 11:57:45','SYNCED','e54a3aaa-1b5e-4e05-b9aa-30359687e6de',0,'2020-12-29 11:57:45','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule Occlusion 1.7.2.2\",\"modelMatrix\":\"0.678937,0.648365,-0.344482,0,-0.734197,0.599565,-0.318554,0,1.26562e-8,0.469196,0.883094,0,-12.3592,-32.095,-49.6187,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'e695a41c-b645-425c-85e6-65b449ddbb04','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_534cca35-8182-4f61-aa57-03bad8172eac/13_w4_o1_mordu_anterieur_scan_file_1.ply','PLY','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_FRSC_534cca35-8182-4f61-aa57-03bad8172eac_PLY_','2020-12-29 11:08:39','2020-12-29 11:37:09','13_w4_o1_mordu_anterieur_scan_file_1.ply','2020-12-29 12:08:39','SYNCED','ba881d4e-efc8-45fe-90c8-248f552f9196',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.13.4.1.1\",\"modelMatrix\":\"0.73505,0.0413959,0.670351,0,0.0805396,0.979844,-0.202859,0,-0.673691,0.199099,0.714379,0,8.76336,-10.2617,-32.2954,1\",\"title\":\"Mordu anterieur PLY\"}'),(662,'e705cb75-4d59-41fc-8f62-f0a888025842','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/smilersorder_5dd87306-77a2-44aa-9d31-280dd9c9a0df/21_w2_smilers_file_0.json','JSON','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_PROST_5dd87306-77a2-44aa-9d31-280dd9c9a0df_JSON_','2022-06-27 19:29:07','2022-06-27 21:28:36','21_w2_smilers_file_0.json','2022-06-27 21:29:07','SYNCED','e705cb75-4d59-41fc-8f62-f0a888025842',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'e720e2f6-8dce-43f4-a5d6-bf8c09037947','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_PLY_','2021-02-01 19:21:58','2021-02-01 20:20:58','14_w1_o1_maxillaire_scan_file_0.ply','2021-02-01 20:21:58','SYNCED','e720e2f6-8dce-43f4-a5d6-bf8c09037947',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.941249,-0.322812,0.0992107,0,0.337713,-0.899717,0.276513,0,2.03629e-9,0.293772,0.955875,0,6.80818,-15.7657,-21.6458,1\",\"title\":\"Maxillaire PLY\"}'),(662,'e8f06fb1-375a-41c0-9a27-d0ee2593900c','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_4a2eec76-a5f3-44f0-b389-4734998fa2d3/13_w4_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_BOSC_4a2eec76-a5f3-44f0-b389-4734998fa2d3_SNAPS_','2021-06-08 17:43:30','2020-12-29 11:20:13','13_w4_o1_mandibule_snapshot_0.png','2021-06-08 19:43:30','SYNCED','e8f06fb1-375a-41c0-9a27-d0ee2593900c',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule SNAPSHOT\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'e94bbc94-0540-4634-816e-4a842ced15fa','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/occlusion_f2e73640-aebd-4bb1-9b02-c0504556ac5a/scan_e7efed59-e33c-4194-94c1-3507350dcfb5/5_w3_o1_maxillaire_scan_file_2.ply','PLY','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_SESS_f2e73640-aebd-4bb1-9b02-c0504556ac5a_TOSC_e7efed59-e33c-4194-94c1-3507350dcfb5_PLY_','2020-12-29 10:58:23','2020-07-13 19:39:11','5_w3_o1_maxillaire_scan_file_2.ply','2020-12-29 11:58:23','SYNCED','42d780c5-37b5-433e-890f-3c005cb69701',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.5.3.1.1\",\"modelMatrix\":\"-0.833771,-0.538581,0.121476,0,0.552111,-0.813339,0.183447,0,1.70644e-10,0.220021,0.975495,0,10.0785,-7.67299,-25.1653,1\",\"title\":\"Maxillaire PLY\"}'),(662,'e969b9cf-a941-4745-a2cb-e1ed64d3332e','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_SNAPS_','2022-06-28 18:28:53','2022-06-28 20:27:39','19_w2_o1_maxillaire_snapshot_2.png','2022-06-28 20:28:53','SYNCED','d40f4bba-69b0-4cc6-b541-e69c16b2b3d5',2,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'eaabd852-7d4b-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/eaabd852-7d4b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_c9d37315-5f17-421c-8afb-302fa9b0bebe_BOSC_6fafe104-bdc1-41a6-9977-b1bbb351a329_PLY_','2020-12-29 10:58:23','2020-04-07 06:42:41','eaabd852-7d4b-11ea-947d-226cec7cb58a.ply','2020-12-29 11:58:23','SYNCED','eaabd852-7d4b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.2.2.1.1\",\"modelMatrix\":\"0.998917,-0.046407,0.00327279,0,0.0465222,0.996442,-0.0702729,0,2.41777e-10,0.070349,0.997522,0,-15.4826,-27.7313,-45.5726,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'eaadb843-7d4b-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/eaadb843-7d4b-11ea-947d-226cec7cb58a.pdf','PDF','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_PROST_fb151d98-0604-45ed-8599-26fa11975b19_PDF_','2020-04-13 05:59:29','2020-04-13 07:59:28','eaadb843-7d4b-11ea-947d-226cec7cb58a.pdf','2020-04-13 07:59:29','SYNCED','eaadb843-7d4b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"ODF 1.2.2.2 ODF\",\"title\":\"Odf PDF\"}'),(662,'eaaf475d-7d4b-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/eaaf475d-7d4b-11ea-947d-226cec7cb58a.json','JSON','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_PROST_fb151d98-0604-45ed-8599-26fa11975b19_JSON_','2020-04-13 05:59:29','2020-04-13 07:59:28','eaaf475d-7d4b-11ea-947d-226cec7cb58a.json','2020-04-13 07:59:29','SYNCED','eaaf475d-7d4b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"ODF 1.2.2.2 ODF\",\"title\":\"Odf JSON\"}'),(662,'eab0f62d-7d4b-11ea-947d-226cec7cb58a','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/eab0f62d-7d4b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_c9d37315-5f17-421c-8afb-302fa9b0bebe_BOSC_6fafe104-bdc1-41a6-9977-b1bbb351a329_SNAPS_','2020-12-29 10:58:24','2020-04-07 06:42:41','eab0f62d-7d4b-11ea-947d-226cec7cb58a.png','2020-12-29 11:58:24','SYNCED','eab0f62d-7d4b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.2.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'ebcf2fdf-8f60-4590-bf41-6c7e360d6441','','PDF','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_PROST_fce8aef9-22f3-446a-bd23-7f6a283417dc_PDF_','2020-04-29 12:25:19','2020-04-12 08:28:40','','2020-04-29 14:25:19','SYNCED','ebcf2fdf-8f60-4590-bf41-6c7e360d6441',0,'2020-04-29 14:25:19','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.2.3.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}'),(662,'ebf4cbaa-94a5-42c6-aad4-4f61d8ad16b8','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_1e8824f7-3c76-4fe0-bd8c-f865f725dab2/22_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_FRSC_1e8824f7-3c76-4fe0-bd8c-f865f725dab2_SNAPS_','2021-11-23 11:24:17','2021-11-23 12:23:17','22_w1_o1_mordu_anterieur_snapshot_0.png','2021-11-23 12:24:17','SYNCED','ebf4cbaa-94a5-42c6-aad4-4f61d8ad16b8',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.22.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'ed40ce9a-6d1f-4cfd-a3e2-f58cba946869','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_d7c4d383-83f9-4275-bbcc-567a47d4a450/19_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PLY','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_LESC_d7c4d383-83f9-4275-bbcc-567a47d4a450_PLY_','2021-09-27 11:57:52','2021-09-27 12:46:45','19_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','2021-09-27 13:57:52','SYNCED','ed40ce9a-6d1f-4cfd-a3e2-f58cba946869',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.19.1.1.1\",\"modelMatrix\":\"-0.976818,-0.173343,0.122598,0,0.179187,-0.982871,0.0414572,0,0.117191,0.0625849,0.991598,0,10.7409,1.26499,-20.9619,1\",\"title\":\"Mordu posterieur gauche PLY\"}'),(662,'ede17ed3-0dee-42d5-86a9-2728608363fe','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_453abb20-3827-4f8b-b57f-c656c72ebf11/20_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_BOSC_453abb20-3827-4f8b-b57f-c656c72ebf11_ZIP_','2021-10-12 12:30:37','2021-10-12 12:22:49','20_w1_o1_mandibule_scan_file_0.zip','2021-10-12 14:30:37','SYNCED','ede17ed3-0dee-42d5-86a9-2728608363fe',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.20.1.1.1\",\"modelMatrix\":\"0.997701,-0.0634158,0.0238806,0,0.0677632,0.933694,-0.351603,0,7.81016e-10,0.352413,0.935845,0,-21.1355,-22.8904,-15.5515,1\",\"title\":\"Mandibule ZIP\"}'),(662,'ee74d731-2b8a-426e-a645-bad9ae685308','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/406a8572-4b0f-480a-ad2e-daf5530143b6/session_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549/occlusion_254f3fc9-4782-4658-bb34-f2ca1c9b6382/scan_107f2922-62ee-42d9-8e35-69d71587db0b/2_w6_o1_mandibule_scan_file_0.ply','PLY','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549_SESS_254f3fc9-4782-4658-bb34-f2ca1c9b6382_BOSC_107f2922-62ee-42d9-8e35-69d71587db0b_PLY_','2021-03-19 09:24:45','2020-05-21 08:13:15','2_w6_o1_mandibule_scan_file_0.ply','2021-03-19 10:24:45','SYNCED','ee74d731-2b8a-426e-a645-bad9ae685308',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.2.6.1.2\",\"modelMatrix\":\"-0.23508,0.970841,-0.0469621,0,-0.971976,-0.234806,0.0113582,0,-1.81653e-10,0.0483161,0.998832,0,12.0001,-16.6608,-34.952,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'ee84cb79-dc2d-4d14-b3d4-6156697046e6','/var/.data/2023/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_586a7c87-5d8a-440f-a654-c452dc908844/smilersorder_888cf7fa-b086-4bbe-8352-4b347b1fbf70/19_w4_smilers_file_0.json','JSON','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_586a7c87-5d8a-440f-a654-c452dc908844_PROST_888cf7fa-b086-4bbe-8352-4b347b1fbf70_JSON_','2023-03-21 11:30:55','2023-03-21 12:28:13','19_w4_smilers_file_0.json','2023-03-21 12:30:55','SYNCED','ee84cb79-dc2d-4d14-b3d4-6156697046e6',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'eee409c6-39bb-43e6-9a2d-c17ecc88cf08','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_scan_file_1.ply','PLY','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_PLY_','2020-12-29 10:58:24','2020-04-30 19:51:54','10_w1_o1_mandibule_scan_file_1.ply','2020-12-29 11:58:24','SYNCED','6008312e-ba22-4c98-a696-7500991d7069',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.10.1.1.2\",\"modelMatrix\":\"-0.973472,-0.219251,0.0654214,0,0.228804,-0.932831,0.278343,0,-2.24986e-9,0.285928,0.958251,0,19.0474,6.13443,-22.4812,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'f06e433d-c712-4081-adba-9051f0c10c4e','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_5a4f6b62-6381-4a1e-bbef-61746f2722d3/23_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_FRSC_5a4f6b62-6381-4a1e-bbef-61746f2722d3_SNAPS_','2022-01-11 11:43:26','2022-01-11 12:41:14','23_w1_o1_mordu_anterieur_snapshot_0.png','2022-01-11 12:43:26','SYNCED','f06e433d-c712-4081-adba-9051f0c10c4e',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'f0df34cd-4382-481e-9fcb-ed767063a228','','PLY','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_78fbbe11-e1a5-4c10-b6e3-4f00df178dc6_SESS_f7b71416-57aa-4d3d-a2e5-0e6c1519f6e8_TOSC_5a5e6904-4736-4443-bbd0-be73066af8c3_PLY_','2020-12-29 10:57:46','2020-04-14 12:10:33','','2020-12-29 11:57:46','SYNCED','f0df34cd-4382-481e-9fcb-ed767063a228',0,'2020-12-29 11:57:46','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MAXILLAIRE 1.7.1.1.1\",\"modelMatrix\":\"0.688058,0.664151,-0.292369,0,-0.725655,0.62974,-0.277221,0,1.42262e-8,0.402904,0.915242,0,-16.8969,-29.4119,-29.5299,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'f0fe7a67-1ca7-4da6-b4e1-681dc8f0e6b1','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_SNAPS_','2022-06-27 19:29:08','2022-06-27 20:53:18','21_w2_o1_mandibule_snapshot_1.png','2022-06-27 21:29:08','SYNCED','160153e9-3248-4a6b-b0ff-a10c2c1acfc9',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'f16b178b-9a0f-4a7d-b4da-8d23ef7b4db3','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_0d792709-57f3-49e1-963c-d2dc35a59d12/16_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_LESC_0d792709-57f3-49e1-963c-d2dc35a59d12_SNAPS_','2021-02-27 09:55:31','2021-02-27 10:55:29','16_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2021-02-27 10:55:31','SYNCED','f16b178b-9a0f-4a7d-b4da-8d23ef7b4db3',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.16.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'f1ef3944-d73f-4a49-8e28-c4619cb61202','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_42b09cf6-e30d-4d35-a17d-d8e8b4564638/20_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_TOSC_42b09cf6-e30d-4d35-a17d-d8e8b4564638_SNAPS_','2021-10-12 12:33:37','2021-10-12 12:37:44','20_w1_o1_maxillaire_snapshot_1.png','2021-10-12 14:33:37','SYNCED','a60e34f6-4db6-4236-9d5a-1741dd2ed622',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.20.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'f24be2c4-4c4f-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f24be2c4-4c4f-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_TOSC_98e7c216-5bb9-4127-9497-834796980370_ZIP_','2021-11-23 11:10:37','2021-11-23 12:08:22','f24be2c4-4c4f-11ec-9377-226cec7cb58a.zip','2021-11-23 12:10:37','SYNCED','f24be2c4-4c4f-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.22.1.1.1\",\"modelMatrix\":\"-0.984254,0.164681,-0.0642138,0,-0.176758,-0.917007,0.357567,0,1.66597e-9,0.363287,0.931677,0,24.4804,-16.7011,-23.2991,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'f26a7348-4c4f-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f26a7348-4c4f-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_RISC_c1232582-95fc-48dc-a9ee-826c0cbad106_SNAPS_','2021-11-23 11:19:11','2021-11-23 12:18:01','f26a7348-4c4f-11ec-9377-226cec7cb58a.png','2021-11-23 12:19:11','SYNCED','f26a7348-4c4f-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'f26e9ce0-4c4f-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f26e9ce0-4c4f-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_BOSC_e8ff012c-af85-450f-ba33-bd61c15846e9_ZIP_','2021-11-23 11:17:44','2021-11-23 12:14:25','f26e9ce0-4c4f-11ec-9377-226cec7cb58a.zip','2021-11-23 12:17:44','SYNCED','f26e9ce0-4c4f-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"modelMatrix\":\"0.297612,0.931799,-0.207792,0,-0.954687,0.290477,-0.0647764,0,1.12315e-11,0.217654,0.976026,0,11.0234,-21.5208,-16.5828,1\",\"title\":\"Mandibule ZIP\"}'),(662,'f271870f-4c4f-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f271870f-4c4f-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_BOSC_e8ff012c-af85-450f-ba33-bd61c15846e9_SNAPS_','2021-11-23 11:15:49','2021-11-23 12:14:24','f271870f-4c4f-11ec-9377-226cec7cb58a.png','2021-11-23 12:15:49','SYNCED','f271870f-4c4f-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'f2745c07-4c4f-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f2745c07-4c4f-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_FRSC_1e8824f7-3c76-4fe0-bd8c-f865f725dab2_ZIP_','2021-11-23 11:24:16','2021-11-23 12:23:17','f2745c07-4c4f-11ec-9377-226cec7cb58a.zip','2021-11-23 12:24:16','SYNCED','f2745c07-4c4f-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 1.22.1.1.1\",\"modelMatrix\":\"0.725913,-0.0652903,0.681352,0,-0.0436065,0.981927,0.168419,0,-0.687258,-0.181082,0.712365,0,10.2372,3.44717,-27.8986,1\",\"title\":\"Mordu anterieur ZIP\"}'),(662,'f2781fff-4c4f-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f2781fff-4c4f-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_TOSC_98e7c216-5bb9-4127-9497-834796980370_SNAPS_','2021-11-23 11:14:26','2021-11-23 12:08:21','f2781fff-4c4f-11ec-9377-226cec7cb58a.png','2021-11-23 12:14:26','SYNCED','f2781fff-4c4f-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.22.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'f27b8845-4c4f-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f27b8845-4c4f-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_LESC_0f18aace-5cf2-4d46-b56f-f8dc123e1f91_ZIP_','2021-11-23 11:22:30','2021-11-23 12:21:30','f27b8845-4c4f-11ec-9377-226cec7cb58a.zip','2021-11-23 12:22:30','SYNCED','f27b8845-4c4f-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 1.22.1.1.2\",\"modelMatrix\":\"-0.987423,-0.1162,0.110526,0,0.107197,-0.992212,-0.0556946,0,0.116253,-0.0450283,0.992314,0,-8.57688,0.410708,-18.9216,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(662,'f27e89e8-4c4f-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f27e89e8-4c4f-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_RISC_c1232582-95fc-48dc-a9ee-826c0cbad106_ZIP_','2021-11-23 11:19:02','2021-11-23 12:18:02','f27e89e8-4c4f-11ec-9377-226cec7cb58a.zip','2021-11-23 12:19:02','SYNCED','f27e89e8-4c4f-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.1\",\"modelMatrix\":\"0.999595,-0.0218982,0.0166849,0,0.0161573,0.944762,0.325391,0,-0.0234339,-0.327034,0.945435,0,10.0522,9.09217,-24.9856,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(662,'f28192d9-4c4f-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f28192d9-4c4f-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_LESC_0f18aace-5cf2-4d46-b56f-f8dc123e1f91_SNAPS_','2021-11-23 11:23:20','2021-11-23 12:21:30','f28192d9-4c4f-11ec-9377-226cec7cb58a.png','2021-11-23 12:23:20','SYNCED','f28192d9-4c4f-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 1.22.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'f28655e5-4c4f-11ec-9377-226cec7cb58a','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f28655e5-4c4f-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_FRSC_1e8824f7-3c76-4fe0-bd8c-f865f725dab2_SNAPS_','2021-11-23 11:24:17','2021-11-23 12:23:17','f28655e5-4c4f-11ec-9377-226cec7cb58a.png','2021-11-23 12:24:17','SYNCED','f28655e5-4c4f-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 1.22.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(662,'f297816f-db2c-4167-bd60-28d3e93bb7c9','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_37ff1278-3dd1-470a-8159-e763f6626f5d/6_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_BOSC_37ff1278-3dd1-470a-8159-e763f6626f5d_SNAPS_','2020-12-29 10:58:25','2020-04-17 11:09:28','6_w1_o2_mandibule_snapshot_0.png','2020-12-29 11:58:25','SYNCED','f297816f-db2c-4167-bd60-28d3e93bb7c9',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.6.1.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'f2e3b9c2-4d8e-490a-8051-fed4332bc376','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_scan_file_3.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_PLY_','2021-02-01 19:42:30','2021-02-01 20:41:18','14_w1_o1_maxillaire_scan_file_3.ply','2021-02-01 20:42:30','SYNCED','e720e2f6-8dce-43f4-a5d6-bf8c09037947',3,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.993605,0.108329,-0.0318515,0,-0.112915,-0.953254,0.280281,0,-2.27643e-10,0.282085,0.959389,0,5.50927,-20.8387,-21.3776,1\",\"title\":\"Maxillaire PLY\"}'),(662,'f3030b14-8ec9-4a85-a2ac-04d14a2a6ab4','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_ecd2beec-0c29-40e2-ab95-64009c33fa40/13_w4_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_RISC_ecd2beec-0c29-40e2-ab95-64009c33fa40_SNAPS_','2021-06-08 17:43:29','2020-12-29 11:30:30','13_w4_o1_mordu_posterieur_droit_snapshot_0.png','2021-06-08 19:43:29','SYNCED','f3030b14-8ec9-4a85-a2ac-04d14a2a6ab4',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.13.4.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(662,'f35334e9-a7ce-43a7-845e-98ae1de51100','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/order_b1c50855-9551-467e-94d9-915a6218ec1b/5_w3_gouttiere_prost_file_0.json','JSON','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_PROST_b1c50855-9551-467e-94d9-915a6218ec1b_JSON_','2020-07-13 17:47:49','2020-07-13 19:47:48','5_w3_gouttiere_prost_file_0.json','2020-07-13 19:47:49','SYNCED','f35334e9-a7ce-43a7-845e-98ae1de51100',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"GOUTTIÈRE 1.5.3.1 GOUTTIÈRE\",\"title\":\"Gouttiere JSON\"}'),(662,'f3d5a2ce-9a80-4c06-a1b4-85bce5e716ea','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_ed495283-b756-4052-ba8b-5fe9f9b1f8be/19_w3_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_TOSC_ed495283-b756-4052-ba8b-5fe9f9b1f8be_SNAPS_','2022-11-02 14:09:58','2022-11-02 12:30:06','19_w3_o1_maxillaire_snapshot_1.png','2022-11-02 15:09:58','SYNCED','7fbf5bd8-6de6-46b1-bd50-c2480472006d',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'f3f82ebd-8318-469e-9bdd-ff76223b9c1c','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_SNAPS_','2020-12-29 10:58:25','2020-04-30 19:47:40','10_w1_o1_mandibule_snapshot_0.png','2020-12-29 11:58:25','SYNCED','f3f82ebd-8318-469e-9bdd-ff76223b9c1c',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.10.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'f500b4e0-bd2d-4992-901f-526fc78912cf','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_99a6d55d-de66-49eb-a717-49cb2587fbef/19_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PLY','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_RISC_99a6d55d-de66-49eb-a717-49cb2587fbef_PLY_','2021-09-27 11:56:46','2021-09-27 12:45:21','19_w1_o1_mordu_posterieur_droit_scan_file_0.ply','2021-09-27 13:56:46','SYNCED','f500b4e0-bd2d-4992-901f-526fc78912cf',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.19.1.1.1\",\"modelMatrix\":\"0.976921,-0.211633,0.0384051,0,0.194578,0.946537,0.256535,0,-0.0881502,-0.243475,0.965774,0,0.602866,9.96784,-20.2879,1\",\"title\":\"Mordu posterieur droit PLY\"}'),(662,'f574474f-dc28-462d-9251-b23591ca9bcb','','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_d3a42d3d-3d98-457b-bb64-4119091b03f9_SNAPS_','2020-12-29 10:57:46','2020-04-15 07:37:21','','2020-12-29 11:57:46','SYNCED','f574474f-dc28-462d-9251-b23591ca9bcb',0,'2020-12-29 11:57:46','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(662,'f6615787-bb2f-4f28-b265-517b66795996','','PLY','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_78636467-a73b-4270-8bc5-35a2664dec9d_BOSC_7f9aec2d-6246-4413-842d-78d2e0bddb1e_PLY_','2020-12-29 10:57:46','2020-04-12 07:48:40','','2020-12-29 11:57:46','SYNCED','f6615787-bb2f-4f28-b265-517b66795996',0,'2020-12-29 11:57:46','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.2.3.1.1\",\"modelMatrix\":\"0.752992,0.641783,-0.145319,0,-0.65803,0.7344,-0.166291,0,-1.17478e-9,0.22084,0.97531,0,-15.7633,9.54111,-26.582,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'f69344e1-d52d-49da-acc5-b714cb86225d','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_87a0a17a-c973-40c2-9d84-2392b0d62afb/10_w1_o1_maxillaire_scan_file_1.ply','PLY','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_TOSC_87a0a17a-c973-40c2-9d84-2392b0d62afb_PLY_','2020-12-29 10:58:25','2020-04-30 19:37:47','10_w1_o1_maxillaire_scan_file_1.ply','2020-12-29 11:58:25','SYNCED','372c807f-a172-495b-9111-e2a86808505c',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.10.1.1.1\",\"modelMatrix\":\"0.998986,0.0447079,-0.005222,0,-0.0450118,0.992241,-0.115896,0,1.60927e-10,0.116014,0.993248,0,-23.3678,-6.40166,-24.3302,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'f7cc8435-546b-4daa-9414-7a8a0728e9e6','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_ZIP_','2022-06-28 18:25:43','2022-06-28 20:24:13','19_w2_o1_maxillaire_scan_file_1.zip','2022-06-28 20:25:43','SYNCED','a1bc9da2-af83-43c3-8210-759800158585',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"modelMatrix\":\"-0.926293,0.359611,-0.112521,0,-0.376804,-0.884028,0.27661,0,4.89442e-09,0.29862,0.954372,0,9.35794,-15.8998,-26.896,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'f7e28eea-71d1-4771-8eaa-cbc7fd8fd17a','','SNAPS','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_c6bba495-6d1a-4da8-bb1f-852a1b1e5924_SNAPS_','2020-12-29 10:57:47','2020-04-16 07:07:50','','2020-12-29 11:57:47','SYNCED','f7e28eea-71d1-4771-8eaa-cbc7fd8fd17a',0,'2020-12-29 11:57:47','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.2\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}'),(662,'f867279f-0907-4a6e-84d2-9c1b54bb4caf','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_0a606279-3c91-4220-b876-e620d1bf52f6/9_w1_o1_mandibule_scan_file_0.ply','PLY','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_BOSC_0a606279-3c91-4220-b876-e620d1bf52f6_PLY_','2020-12-29 10:58:25','2020-04-18 09:32:12','9_w1_o1_mandibule_scan_file_0.ply','2020-12-29 11:58:25','SYNCED','f867279f-0907-4a6e-84d2-9c1b54bb4caf',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.9.1.1.1\",\"modelMatrix\":\"0.996683,0.0795741,-0.0170367,0,-0.0813774,0.974597,-0.208659,0,-1.93374e-10,0.209354,0.97784,0,11.216,15.8367,-24.1806,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'f880f49e-bb57-430d-8212-dcb8e015569f','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_3d3ae697-dc08-4ce2-8b32-4f79891607c2/21_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_FRSC_3d3ae697-dc08-4ce2-8b32-4f79891607c2_ZIP_','2021-11-22 11:51:22','2021-11-22 12:49:43','21_w1_o1_mordu_anterieur_scan_file_0.zip','2021-11-22 12:51:22','SYNCED','f880f49e-bb57-430d-8212-dcb8e015569f',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.21.1.1.1\",\"modelMatrix\":\"0.856881,0.0586008,0.514973,0,-0.0462075,0.997315,0.0174852,0,-0.514443,-0.0544124,0.857029,0,-1.9678,-1.04274,-24.7967,1\",\"title\":\"Mordu anterieur ZIP\"}'),(662,'f8d60891-9893-425b-9839-c04fdf0d0cd5','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_9716867f-e0a3-478a-a498-1e84ae803044/21_w1_o1_mordu_posterieur_gauche_snapshot_1.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_LESC_9716867f-e0a3-478a-a498-1e84ae803044_SNAPS_','2021-11-22 11:51:23','2021-11-22 12:47:33','21_w1_o1_mordu_posterieur_gauche_snapshot_1.png','2021-11-22 12:51:23','SYNCED','ca0a9826-3f91-4aaf-984b-889d4cff43a5',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(662,'f9419645-8fbf-4bf1-99ba-df5bd8485ab2','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_snapshot_4.png','SNAPS','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_SNAPS_','2022-06-27 19:33:35','2022-06-27 21:02:19','21_w2_o1_mandibule_snapshot_4.png','2022-06-27 21:33:35','SYNCED','160153e9-3248-4a6b-b0ff-a10c2c1acfc9',4,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'f967ed2c-cc61-428f-8d34-99152f99ce47','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_be9a4ba5-715b-4547-a31d-66621ec7b17f/14_w2_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_TOSC_be9a4ba5-715b-4547-a31d-66621ec7b17f_SNAPS_','2021-06-08 18:16:32','2021-06-08 20:16:28','14_w2_o1_maxillaire_snapshot_1.png','2021-06-08 20:16:32','SYNCED','13fa1125-c9d0-498d-bc50-68dc9f4f1beb',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.14.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(662,'fa6d3cbd-0af8-4f29-9631-237bb3c12829','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/smilersorder_b1ca2262-cd6f-4c35-984a-071491ef1682/19_w2_smilers_file_0.json','JSON','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_PROST_b1ca2262-cd6f-4c35-984a-071491ef1682_JSON_','2022-06-28 18:40:56','2022-06-28 20:40:18','19_w2_smilers_file_0.json','2022-06-28 20:40:56','SYNCED','fa6d3cbd-0af8-4f29-9631-237bb3c12829',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'faa7f2df-9772-4aef-b228-35b51fb8134d','','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_BOSC_e99b1c89-977c-4836-9719-ad6d9a6f6aae_PLY_','2021-02-16 09:45:56','2021-02-01 21:04:33','','2021-02-16 10:45:56','SYNCED','faa7f2df-9772-4aef-b228-35b51fb8134d',0,'2021-02-16 10:45:56','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.14.1.1.1\",\"modelMatrix\":\"-0.593133,0.801857,-0.0722353,0,-0.805104,-0.590741,0.0532169,0,-9.08667e-10,0.0897216,0.995967,0,7.82346,-3.37671,-22.4736,1\",\"title\":\"Mandibule PLY\"}'),(662,'fad00b24-cf95-4da0-aa56-8c7af1870289','/var/.data/2022/045f19a4-7d35-457a-85ae-94b33b89a0d2/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_848b25bd-90a8-4105-871d-f9326fe94c7b/occlusion_ba7da56a-5a10-4378-a887-8e98aa892a3c/scan_b002027b-930d-4b96-a687-453aeea5659e/21_w6_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_848b25bd-90a8-4105-871d-f9326fe94c7b_SESS_ba7da56a-5a10-4378-a887-8e98aa892a3c_TOSC_b002027b-930d-4b96-a687-453aeea5659e_ZIP_','2022-12-21 11:11:40','2022-12-21 12:09:25','21_w6_o1_maxillaire_scan_file_0.zip','2022-12-21 12:11:40','SYNCED','fad00b24-cf95-4da0-aa56-8c7af1870289',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.21.6.1.1\",\"modelMatrix\":\"-0.993498,0.107491,-0.0375098,0,-0.113848,-0.938026,0.327331,0,3.21676e-09,0.329473,0.944165,0,15.3118,-13.6134,-24.5266,1\",\"title\":\"Maxillaire ZIP\"}'),(662,'fb86258d-e165-4e8e-a22f-d60bf23a6d59','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_d36d186b-d0da-4aea-af1a-4613f67b2fa0/6_w1_o2_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_LESC_d36d186b-d0da-4aea-af1a-4613f67b2fa0_SNAPS_','2020-12-29 10:58:26','2020-04-17 11:17:41','6_w1_o2_mordu_posterieur_gauche_snapshot_0.png','2020-12-29 11:58:26','SYNCED','fb86258d-e165-4e8e-a22f-d60bf23a6d59',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur gauche 1.6.1.2.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}'),(662,'fd2b02c7-bcd5-4774-9809-1da5d2dd2ad0','','SNAPS','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_2b934532-4b04-4025-8e7f-894c9c01b184_BOSC_0b6ec729-5c4e-4869-9d67-6377923ed207_SNAPS_','2020-12-29 10:57:47','2020-04-07 07:26:12','','2020-12-29 11:57:47','SYNCED','fd2b02c7-bcd5-4774-9809-1da5d2dd2ad0',0,'2020-12-29 11:57:47','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.2.2.3.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(662,'fe5b0b87-b40b-40f8-a762-d9fc8f4a87a6','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_e6e5d8c5-2d8c-48d0-9708-e3256202d385/15_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_BOSC_e6e5d8c5-2d8c-48d0-9708-e3256202d385_SNAPS_','2021-02-16 11:48:06','2021-02-16 12:48:00','15_w1_o1_mandibule_snapshot_1.png','2021-02-16 12:48:06','SYNCED','d0155fb7-667e-4f4e-be6a-1eacb81ecb13',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.15.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(662,'fe6fbf6c-0ee6-4b36-8e65-ca271a0819f0','','PLY','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_2ed4960a-e6fa-46de-a306-32385df3346c_BOSC_45b21304-1129-40a2-b60e-d72a2bf96e72_PLY_','2020-12-29 10:57:47','2020-04-12 08:05:48','','2020-12-29 11:57:47','SYNCED','a41e073f-d40b-4f4f-924e-2afd61ac4f8c',1,'2020-12-29 11:57:47','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"MANDIBULE 1.2.3.2.1\",\"modelMatrix\":\"0.999942,0.00945957,-0.00509127,0,-0.0107426,0.880511,-0.473904,0,2.56906e-10,0.473931,0.880562,0,-6.69436,17.075,-28.4147,1\",\"title\":\"MANDIBULE PLY\"}'),(662,'ff1d5097-67d0-49a8-b7ee-d5cbee5bd5df','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_65315958-b964-4f7e-a111-9c7695d8092b/6_w1_o2_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_RISC_65315958-b964-4f7e-a111-9c7695d8092b_SNAPS_','2020-12-29 10:58:26','2020-04-17 11:14:14','6_w1_o2_mordu_posterieur_droit_snapshot_0.png','2020-12-29 11:58:26','SYNCED','ff1d5097-67d0-49a8-b7ee-d5cbee5bd5df',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu posterieur droit 1.6.1.2.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(662,'ff20b9a0-8d88-4bef-9570-fe21135dc7a5','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/smilersorder_510986a4-1523-4c17-84f5-900361edbf32/14_w1_smilers_file_0.json','JSON','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_PROST_510986a4-1523-4c17-84f5-900361edbf32_JSON_','2021-02-01 20:24:09','2021-02-01 21:24:09','14_w1_smilers_file_0.json','2021-02-01 21:24:09','SYNCED','ff20b9a0-8d88-4bef-9570-fe21135dc7a5',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{}'),(662,'ff42f199-4210-43da-bfae-3dc172610fff','/var/.data/2021/045f19a4-7d35-457a-85ae-94b33b89a0d2/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_437ef945-eb42-4841-9b20-34804bd5cfd6/14_w2_o1_mandibule_scan_file_0.ply','PLY','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_BOSC_437ef945-eb42-4841-9b20-34804bd5cfd6_PLY_','2021-06-08 18:41:18','2021-06-08 20:38:08','14_w2_o1_mandibule_scan_file_0.ply','2021-06-08 20:41:18','SYNCED','ff42f199-4210-43da-bfae-3dc172610fff',0,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mandibule 1.14.2.1.2\",\"modelMatrix\":\"-0.310914,0.867126,-0.389134,0,-0.950438,-0.28366,0.127296,0,-1.1002e-9,0.409426,0.912343,0,3.56376,-7.70516,-17.4893,1\",\"title\":\"Mandibule PLY\"}'),(662,'ff9a5767-77f0-4ea4-80de-642c5142026c','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5/6_w1_o2_maxillaire_scan_file_1.ply','PLY','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_TOSC_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5_PLY_','2020-12-29 10:58:27','2020-04-17 11:04:13','6_w1_o2_maxillaire_scan_file_1.ply','2020-12-29 11:58:27','SYNCED','58f5907e-16f5-4910-b9e6-81046fdd76df',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Maxillaire 1.6.1.2.1\",\"modelMatrix\":\"-0.489558,0.864252,-0.115762,0,-0.871971,-0.485224,0.0649935,0,1.46347e-9,0.13276,0.991148,0,-1.52736,-20.4441,-26.9671,1\",\"title\":\"MAXILLAIRE PLY\"}'),(662,'ffd40c66-bdac-4ae5-8460-6b5fe127d9e0','/var/.data/2020/045f19a4-7d35-457a-85ae-94b33b89a0d2/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_534cca35-8182-4f61-aa57-03bad8172eac/13_w4_o1_mordu_anterieur_snapshot_1.png','SNAPS','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_FRSC_534cca35-8182-4f61-aa57-03bad8172eac_SNAPS_','2021-06-08 17:45:17','2020-12-29 11:37:09','13_w4_o1_mordu_anterieur_snapshot_1.png','2021-06-08 19:45:17','SYNCED','b9175f0f-b250-4ae3-b56c-51f5a10c10db',1,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','{\"displayTitle\":\"Mordu anterieur 1.13.4.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}');
/*!40000 ALTER TABLE `CondorFile` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `CondorFile_BEFORE_DELETE` BEFORE DELETE ON `CondorFile` FOR EACH ROW BEGIN
  UPDATE Session SET mandibuleOcclusionPlyID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionPlyID = OLD.id;

  UPDATE Session SET mandibuleOcclusionStlID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionStlID = OLD.id;

  UPDATE Session SET maxillaireOcclusionPlyID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionPlyID = OLD.id;

  UPDATE Session SET maxillaireOcclusionStlID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionStlID = OLD.id;

  UPDATE Session SET mandibuleOcclusionPointContactID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionPointContactID = OLD.id;

  UPDATE Session SET maxillaireOcclusionPointContactID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionPointContactID = OLD.id;

  UPDATE Session SET matrixTransformationMandibuleID = NULL
  WHERE ownerID = OLD.ownerID AND matrixTransformationMandibuleID = OLD.id;

  UPDATE Session SET matrixTransformationMaxillaireID = NULL
  WHERE ownerID = OLD.ownerID AND matrixTransformationMaxillaireID = OLD.id;

  UPDATE Session SET snapshotID = NULL
  WHERE ownerID = OLD.ownerID AND snapshotID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Config` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `fullRetrieve` tinyint(1) DEFAULT '0',
  `syncEnabled` tinyint(1) DEFAULT '1',
  `showOcclusionScan` tinyint(1) DEFAULT '1',
  `showOpenStlWarning` tinyint(1) DEFAULT '1',
  `showMarginLinesWarning` tinyint(1) DEFAULT '1',
  `showDeleteConfirmation` tinyint(1) DEFAULT '1',
  `showSyncInfo` tinyint(1) DEFAULT '1',
  `downloadAtFullRetrieve` tinyint(1) DEFAULT '1',
  `lagSound` tinyint(1) DEFAULT '0',
  `lostSound` tinyint(1) DEFAULT '0',
  `emailNotifications` tinyint(1) DEFAULT '1',
  `logout` mediumint DEFAULT '10',
  `language` varchar(2) DEFAULT NULL,
  `flipMaxillaryH` tinyint(1) DEFAULT '0',
  `flipMaxillaryV` tinyint(1) DEFAULT '0',
  `flipMandibleH` tinyint(1) DEFAULT '0',
  `flipMandibleV` tinyint(1) DEFAULT '0',
  `showFlipPopupMaxillary` tinyint(1) DEFAULT '1',
  `showFlipPopupMandible` tinyint(1) DEFAULT '1',
  `enableUserSharing` tinyint(1) DEFAULT '1',
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `diagnosticMode` tinyint(1) DEFAULT '0',
  `repairMode` tinyint(1) DEFAULT '0',
  `lostTrackingRectangle` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Config_Professional` (`ownerID`),
  CONSTRAINT `fk_Config_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-19 14:24:12','2019-12-19 13:24:12','2019-12-19 14:24:12',0,0,1),(2,1,0,1,1,1,1,1,1,1,0,0,1,999,'fr',0,0,0,0,1,1,0,'2020-01-07 14:47:16','2020-01-07 13:47:16','2020-01-07 14:47:16',0,0,1),(3,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-09-17 15:34:06',0,0,1),(5,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:04:44',0,0,1),(6,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:05:21',0,0,1),(7,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:06:14',0,0,1),(8,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:06:33',0,0,1),(9,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:07:02',0,0,1),(59,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-17 14:12:08',0,0,1),(155,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-31 12:21:56',0,0,1),(172,1,0,1,1,1,1,1,1,1,0,0,1,999,'fr',0,0,0,0,1,1,0,'2020-01-21 18:29:28','2020-01-21 17:29:28','2020-01-21 18:29:27',0,0,1),(193,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-09-02 18:53:02',0,0,1),(224,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-09-09 15:29:44',0,0,1),(317,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-10-07 14:44:35',0,0,1),(339,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-10-11 20:04:31',0,0,1),(355,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-10-19 13:58:38',0,0,1),(662,1,0,1,1,1,1,1,1,0,0,1,1,900,'fr',0,0,0,0,1,1,0,'2020-04-30 20:24:47','2020-04-30 18:24:47','2020-04-30 20:24:47',0,0,1),(663,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-04-08 08:55:11','2020-04-08 06:55:11','2020-04-08 08:55:11',0,0,1),(689,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-06-02 12:32:01','2020-06-02 10:32:01','2020-06-02 12:32:01',0,0,1),(1081,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-09-19 14:34:53','2022-09-19 12:34:53','2022-09-19 14:34:53',0,0,1);
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Contact` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `comments` text,
  `professionalID` mediumint unsigned NOT NULL,
  `officeID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `status` enum('invitationSent','invitationReceived','accepted','rejected') DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `unique_contact_pro` (`ownerID`,`professionalID`),
  KEY `fk_Contact_Professionnal` (`ownerID`),
  KEY `fk_Contact_RefersTo` (`professionalID`),
  KEY `fk_Contact_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Contact_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Contact_Professionnal` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Contact_RefersTo` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES (662,'08ea1d0b-73cb-4462-acdd-d58c09bde03a','',662,NULL,NULL,'2023-03-21 12:33:49','2023-03-21 11:33:49','2020-04-06 09:36:52','accepted'),(662,'0c639fb7-3c3a-493f-ac8c-2bd4fb7c8ede','',1081,NULL,NULL,'2022-09-19 15:16:49','2022-09-19 13:16:49','2022-09-19 14:34:53','invitationSent'),(2,'1418b81b-952d-4c95-a6be-d74e9dce3146','',5,NULL,NULL,'2019-08-12 11:04:05','2019-08-12 09:04:05','2019-07-08 15:47:14','accepted'),(662,'25312481-3ad2-4523-ae5f-0b5303fca7f1','',689,NULL,NULL,'2020-12-30 07:12:31','2020-12-30 06:12:31','2020-12-30 07:12:31','accepted'),(2,'28f7e34e-d2d9-411c-8ab3-d5ade71bf7cf','',6,NULL,NULL,'2019-07-26 06:43:50','2019-07-26 04:43:50','2019-07-08 15:47:14','accepted'),(662,'2f722c41-58c2-4478-b02d-c48fd0fa5d6c','',9,NULL,NULL,'2020-04-06 09:36:53','2020-04-06 07:36:53','2020-04-06 09:36:53','accepted'),(2,'31ecedea-a5d4-4c31-91a1-431f8ab24ce7','',7,NULL,NULL,'2019-07-22 17:07:13','2019-07-22 15:07:13','2019-07-10 08:55:28','accepted'),(2,'46be3f53-48f5-43f2-8612-6bde541a8563','',3,NULL,NULL,'2019-09-17 15:34:04','2019-09-17 13:34:04','2019-07-03 09:49:55','accepted'),(2,'58cd65c8-f596-48dc-a3e8-edf285a261d0','',355,NULL,NULL,'2019-10-23 12:56:54','2019-10-23 10:56:54','2019-10-23 12:30:07','invitationSent'),(662,'70af36cd-7b25-483d-a13d-311fcb081aea','',8,NULL,NULL,'2020-04-06 09:36:53','2020-04-06 07:36:53','2020-04-06 09:36:53','accepted'),(662,'7266b8b5-fa50-44b6-aafc-875a2432ec00','',7,NULL,NULL,'2020-04-06 09:36:53','2020-04-06 07:36:53','2020-04-06 09:36:53','accepted'),(2,'845121ab-bd3d-460f-8459-afc674d99362','',8,NULL,NULL,'2019-07-22 19:36:25','2019-07-22 17:36:25','2019-07-08 15:47:14','accepted'),(662,'86ff285b-3d22-4bde-a3bd-201d6972c514','',6,NULL,NULL,'2020-04-06 09:36:53','2020-04-06 07:36:53','2020-04-06 09:36:53','accepted'),(2,'93ad4d00-b810-418e-ab4f-5f38046486cd','',1,NULL,NULL,'2020-01-22 17:08:26','2020-01-22 16:08:26','2019-11-25 11:21:43','accepted'),(2,'9648ff49-e522-44ba-9b8f-93895ee57d2b','',224,NULL,NULL,'2019-09-09 15:53:45','2019-09-09 13:53:45','2019-09-09 15:53:45','accepted'),(2,'99c73d5d-e50b-4a8e-a4b4-60fd2150b020','',317,NULL,NULL,'2019-12-09 11:58:51','2019-12-09 10:58:51','2019-12-09 11:58:51','accepted'),(2,'a6c317c0-5772-4c0a-9fa8-0cef815f4fad','',193,NULL,NULL,'2019-09-30 10:43:33','2019-09-30 08:43:33','2019-09-30 10:43:33','accepted'),(662,'b07c194e-1421-4e3a-bffb-a6509be6f7e4','',5,NULL,NULL,'2021-04-21 14:26:49','2021-04-21 12:26:49','2020-04-06 09:36:53','accepted'),(2,'b26a32ea-ad6e-4f46-ae5d-f2f4a2af39ad','',155,NULL,NULL,'2019-08-27 15:24:41','2019-08-27 13:24:41','2019-08-27 15:24:41','accepted'),(2,'c571c887-8c1f-4576-a747-36c26c3f6338','',172,NULL,NULL,'2020-01-22 17:49:56','2020-01-22 16:49:56','2019-12-17 15:10:34','accepted'),(2,'d07578fc-3c54-49d7-a3eb-b581d2107f68','',2,NULL,NULL,'2020-01-22 15:33:10','2020-01-22 14:33:10','2019-07-01 08:54:35','accepted'),(662,'e65a3983-26d3-437e-9f3a-9ec54fa23fbe','',663,NULL,NULL,'2020-07-15 23:03:47','2020-07-15 21:03:47','2020-04-10 09:16:28','accepted'),(2,'e72f7319-b4e1-4049-aa99-f124db5c5af8','',9,NULL,NULL,'2019-08-20 17:18:44','2019-08-20 15:18:44','2019-07-08 15:47:14','accepted'),(2,'f4ec0f13-701b-4afa-bdc6-8759982358c2','',339,NULL,NULL,'2019-10-15 10:41:49','2019-10-15 08:41:49','2019-10-15 10:41:49','accepted'),(2,'fb3b468c-a371-4911-b472-a2869911ccef','',59,NULL,NULL,'2019-09-05 17:29:34','2019-09-05 15:29:34','2019-09-05 17:20:56','accepted');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ContactNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `contactID` char(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('received','received_to_accepted','received_to_rejected','sent_to_accepted','sent_to_rejected','activation_timeout') NOT NULL DEFAULT 'received',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ContactNotification_Professional` (`ownerID`),
  KEY `fk_ContactNotification_Contact` (`contactID`,`ownerID`),
  CONSTRAINT `fk_ContactNotification_Contact` FOREIGN KEY (`contactID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_ContactNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
INSERT INTO `ContactNotification` VALUES (662,'7894234c-8756-40e0-aefc-a23645fa004c','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','Michael Maylin','sent_to_accepted',0,'2020-04-10 09:16:28',NULL,'2020-04-10 09:17:21','2020-04-10 09:17:21','2020-04-10 07:17:21');
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Credentials` (
  `id` char(36) NOT NULL DEFAULT '',
  `login` varchar(64) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_Login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES ('00000002-0000-0000-0000-000000000001','sophie.m','944f83211d57ccc35f56487a20808104fd1c61ea84a6e818659c8edc5e10aca0',NULL,'2022-06-27 19:16:26'),('00000662-0000-0000-0000-000000000001','phb','617fbb6cd3fa99524528df431a7e9dee0a14caa8a5718008c0f2852635f9e992',NULL,'2023-03-21 11:32:48');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Discussion` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `selfImplied` tinyint(1) NOT NULL DEFAULT '0',
  `officeID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Discussion_Professional` (`ownerID`),
  KEY `fk_Discussion_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Discussion_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Discussion_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
INSERT INTO `Discussion` VALUES (662,'2b95263d-2fff-42df-8b92-6a30e3bdc543',0,NULL,NULL,'2022-09-19 15:19:18','2022-09-19 13:19:18','2022-09-19 15:19:17'),(1081,'2b95263d-2fff-42df-8b92-6a30e3bdc543',0,NULL,NULL,NULL,'2022-09-19 13:19:17','2022-09-19 15:19:17'),(1,'3bb3ca53-cf49-4698-9658-df729e5c5f9e',0,NULL,NULL,NULL,'2020-01-23 08:02:16','2020-01-23 09:02:16'),(2,'3bb3ca53-cf49-4698-9658-df729e5c5f9e',0,NULL,NULL,'2019-12-19 14:24:07','2019-12-19 13:24:07','2019-11-25 11:23:31'),(2,'521142fd-7283-4541-aa70-733ace90c112',0,NULL,NULL,'2019-09-04 15:44:49','2019-09-04 13:44:49','2019-09-04 15:44:10'),(3,'521142fd-7283-4541-aa70-733ace90c112',0,NULL,NULL,NULL,'2020-01-23 08:02:16','2020-01-23 09:02:16'),(2,'5cde9543-ba84-400d-ae2b-8c834d912266',0,NULL,NULL,'2020-01-21 18:25:17','2020-01-21 17:25:17','2019-12-17 15:11:56'),(172,'5cde9543-ba84-400d-ae2b-8c834d912266',0,NULL,NULL,NULL,'2020-01-23 08:02:16','2020-01-23 09:02:16'),(2,'6885f3a8-c779-49e9-87ed-5d4c70e2ca06',0,NULL,NULL,'2019-09-30 17:16:23','2019-09-30 15:16:23','2019-09-30 11:17:48'),(193,'6885f3a8-c779-49e9-87ed-5d4c70e2ca06',0,NULL,NULL,NULL,'2020-01-23 08:02:16','2020-01-23 09:02:16'),(2,'a16198e0-da2f-45fe-97fb-93531b35cedb',1,NULL,NULL,'2020-01-22 15:33:40','2020-01-22 14:33:40','2019-07-01 17:37:26'),(2,'a18a6dc8-e71f-45cb-a7ad-b53500079bd4',0,NULL,NULL,'2019-09-12 16:13:26','2019-09-12 14:13:26','2019-09-09 16:10:00'),(224,'a18a6dc8-e71f-45cb-a7ad-b53500079bd4',0,NULL,NULL,NULL,'2020-01-23 08:02:16','2020-01-23 09:02:16'),(662,'ac9d94b7-3541-4923-a2a8-fe429c22fbab',0,NULL,NULL,'2020-07-13 19:47:50','2020-07-13 17:47:50','2020-04-10 09:20:47'),(663,'ac9d94b7-3541-4923-a2a8-fe429c22fbab',0,NULL,NULL,NULL,'2020-04-10 07:20:48','2020-04-10 09:20:48'),(2,'be6e41b9-9ce8-4980-9ce7-be4b4450d1b3',0,NULL,NULL,'2019-09-05 17:31:16','2019-09-05 15:31:16','2019-09-05 17:30:24'),(59,'be6e41b9-9ce8-4980-9ce7-be4b4450d1b3',0,NULL,NULL,NULL,'2020-01-23 08:02:16','2020-01-23 09:02:16'),(662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa',1,NULL,NULL,'2023-03-21 12:31:05','2023-03-21 11:31:05','2020-04-12 08:17:04'),(2,'fe55386a-3ec2-4d00-bb80-02e0aec5e82f',0,NULL,NULL,'2019-09-03 10:19:11','2019-09-03 08:19:11','2019-08-27 15:25:58'),(155,'fe55386a-3ec2-4d00-bb80-02e0aec5e82f',0,NULL,NULL,NULL,'2020-01-23 08:02:16','2020-01-23 09:02:16');
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Licence`
--

DROP TABLE IF EXISTS `Licence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Licence` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(45) DEFAULT NULL,
  `installKey` varchar(45) DEFAULT NULL,
  `activationDate` datetime DEFAULT NULL,
  `professionalID` mediumint unsigned NOT NULL,
  `cameraReference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`professionalID`),
  KEY `fk_Licence_Professional` (`professionalID`),
  CONSTRAINT `fk_Licence_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Licence`
--

LOCK TABLES `Licence` WRITE;
/*!40000 ALTER TABLE `Licence` DISABLE KEYS */;
/*!40000 ALTER TABLE `Licence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `MessageStatus` (
  `ownerID` mediumint unsigned NOT NULL,
  `sentMessageID` char(36) NOT NULL,
  `contactID` char(36) NOT NULL,
  `status` enum('undelivered','delivered','transmitted') NOT NULL DEFAULT 'undelivered',
  `bcc` tinyint(1) NOT NULL DEFAULT '0',
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`sentMessageID`,`contactID`),
  KEY `fk_MessageStatus_SentMessage` (`sentMessageID`,`ownerID`),
  KEY `fk_MessageStatus_Contact` (`contactID`,`ownerID`),
  CONSTRAINT `fk_MessageStatus_Contact` FOREIGN KEY (`contactID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_MessageStatus_SentMessage` FOREIGN KEY (`sentMessageID`, `ownerID`) REFERENCES `SentMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
INSERT INTO `MessageStatus` VALUES (662,'0044629b-c48a-4f47-95b1-f178384b2b25','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2022-11-02 17:43:36'),(662,'0fc3bc59-0e74-46f1-9d1b-4edee6fffcc3','08ea1d0b-73cb-4462-acdd-d58c09bde03a','delivered',0,'2022-06-27 19:35:56'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','transmitted',0,'2020-04-30 18:44:40'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2021-09-27 12:02:21'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2021-10-12 12:40:31'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','delivered',0,'2020-05-01 06:23:31'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','delivered',0,'2020-05-01 06:31:27'),(662,'465925b7-af46-4fc1-9b89-8f9ef2a8753b','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','transmitted',0,'2020-04-10 07:27:05'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2020-04-15 06:51:48'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','08ea1d0b-73cb-4462-acdd-d58c09bde03a','delivered',0,'2021-11-22 11:51:41'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','transmitted',0,'2020-04-30 18:44:40'),(662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2020-04-17 05:56:52'),(662,'76a19cfc-ee2e-426f-b476-ac85c20f660d','08ea1d0b-73cb-4462-acdd-d58c09bde03a','delivered',0,'2020-04-13 05:32:16'),(662,'7fb08821-81d8-4569-9f19-ef8022fea368','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2022-08-06 11:59:41'),(662,'8aa64af3-968d-45f4-b276-c5dbd500e07a','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','delivered',0,'2020-07-13 17:47:50'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2021-11-23 11:24:44'),(662,'928854eb-377d-4b8b-8ea6-eeb3057a66b9','0c639fb7-3c3a-493f-ac8c-2bd4fb7c8ede','undelivered',0,'2022-09-19 13:19:17'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2020-04-15 06:27:59'),(662,'93c345d1-454a-42fa-bfa7-8d68827d23f5','08ea1d0b-73cb-4462-acdd-d58c09bde03a','delivered',0,'2023-03-21 11:31:05'),(662,'9c5638bd-fe4f-41c6-a7a7-5c3c908a9555','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2020-04-13 05:32:16'),(662,'9c8474e3-ae2e-4f02-af12-ee8d56ae6406','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2022-06-28 18:41:11'),(662,'b43015be-893c-4d0c-8657-1cd6c0eadc67','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2020-04-13 05:32:17'),(662,'b77a9c9d-2d03-4860-b7b9-86e311c509ed','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2022-09-14 10:25:51'),(662,'bac96ac3-3fbd-4776-96d5-a1fcf7139710','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2023-01-11 12:47:52'),(662,'c13ba56c-2431-4f83-a199-a713f2029337','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2022-12-21 11:18:10'),(662,'d3010d97-e435-4fa5-9054-e4add927b37f','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2022-11-04 11:40:23'),(662,'de057ea0-5a8b-4969-8ceb-44a19644bb0d','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2020-04-13 05:59:31'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','08ea1d0b-73cb-4462-acdd-d58c09bde03a','transmitted',0,'2022-01-11 11:43:43');
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Occlusion` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `sessionID` char(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'HEMI_ARCADE_POSTERIEUR_DROIT',
  `deletedAt` datetime DEFAULT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `topScanID` char(36) DEFAULT NULL,
  `bottomScanID` char(36) DEFAULT NULL,
  `anteriorBiteScanID` char(36) DEFAULT NULL,
  `rightBiteScanID` char(36) DEFAULT NULL,
  `leftBiteScanID` char(36) DEFAULT NULL,
  `snapshotID` char(36) DEFAULT NULL,
  `mandibuleOcclusionPlyID` char(36) DEFAULT NULL,
  `maxillaireOcclusionPlyID` char(36) DEFAULT NULL,
  `matrixTransformationMandibuleID` char(36) DEFAULT NULL,
  `matrixTransformationMaxillaireID` char(36) DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Occlusion_Session` (`sessionID`,`ownerID`),
  KEY `fk_Occlusion_topScan` (`topScanID`,`ownerID`),
  KEY `fk_Occlusion_bottomScan` (`bottomScanID`,`ownerID`),
  KEY `fk_Occlusion_anteriorBiteScanID` (`anteriorBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_rightBiteScanID` (`rightBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_leftBiteScanID` (`leftBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_snapshot` (`snapshotID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_mandibulePly` (`mandibuleOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMandibule` (`matrixTransformationMandibuleID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_maxillairePly` (`maxillaireOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` (`matrixTransformationMaxillaireID`,`ownerID`),
  CONSTRAINT `fk_Occlusion_anteriorBiteScanID` FOREIGN KEY (`anteriorBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_bottomScan` FOREIGN KEY (`bottomScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_mandibulePly` FOREIGN KEY (`mandibuleOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_matrixTransformationMandibule` FOREIGN KEY (`matrixTransformationMandibuleID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` FOREIGN KEY (`matrixTransformationMaxillaireID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_maxillairePly` FOREIGN KEY (`maxillaireOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_snapshot` FOREIGN KEY (`snapshotID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_leftBiteScanID` FOREIGN KEY (`leftBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_rightBiteScanID` FOREIGN KEY (`rightBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_Session` FOREIGN KEY (`sessionID`, `ownerID`) REFERENCES `Session` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_topScan` FOREIGN KEY (`topScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
INSERT INTO `Occlusion` VALUES (662,'a18ca6df-d765-4c6a-be28-13amigraoccl','a18ca6df-d765-4c6a-be28-13abd1c350af','UNKNOWN',NULL,'2021-03-19 10:22:24','2021-09-27 13:56:27','2020-11-23 21:19:36','2021-09-27 11:56:27','cb1d5d31-89cd-4ab4-bada-dc6b2235cac5','37ff1278-3dd1-470a-8159-e763f6626f5d',NULL,NULL,NULL,'b58b7bd8-eb47-4d54-9228-ce3a9e6486fd','931bf3dd-fe07-4981-8ede-599f357c3c60','29d00f37-e846-46c5-bfea-08ec3e95b455','3a74c5df-7c06-40b5-9e98-eeeb48d5c650','51f476ba-752c-4dbb-8096-f63ffa200322',1,1),(662,'bdf42f40-5a7a-435b-a5e0-eb3migraoccl','bdf42f40-5a7a-435b-a5e0-eb33efefbc97','UNKNOWN',NULL,'2021-03-19 10:22:21','2021-09-27 13:56:26','2020-11-23 21:19:36','2021-09-27 11:56:26','2d566d37-f38f-4b79-ac8f-48009ae22310','de216c91-485b-4dac-9e7c-b89075739521',NULL,NULL,NULL,'675a601d-d389-403d-858d-555ff6166630','5c922725-b41b-4e38-a244-6a9a320d291e','b25a25e2-610a-466d-a4d8-7518a09b9a78','4b5c8093-db62-4195-8bba-5349a152c006','95cc936b-2c0c-4fdd-8d11-8780095dabca',1,1),(662,'c4999e75-8b1c-4a31-8e80-9b9cba9b57fd','5f895907-3eed-4aa7-995a-f7e1c9661a0a','HEMI_ARCADE_ANTERIEUR',NULL,'2022-03-11 11:16:20','2022-06-27 21:32:30','2022-03-11 11:16:26','2022-06-27 19:32:30','802e2d49-5b37-47b7-b8e9-4fb4bff1f62f','26a765d3-8b92-4861-984a-bd9c8040209b','d04345c3-df70-4e2a-b197-cc37138e6700',NULL,NULL,'83547739-e794-48fb-befb-bed604c04b8f','6b4f036d-deed-43fa-b8c0-889e20bb7692','30e96914-828b-4376-9eeb-077529a3422d','a721d64e-b79a-4f11-9504-ff9a5bcae5d4','72efe2fd-185f-4a0a-9205-c14ee08fd1bd',1,1);
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `OcclusionFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `fileID` char(36) NOT NULL,
  `occlusionID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `occlusionType` enum('OCCLUSION_RESULT','MANDIBULE_PLY','MAXILLAIRE_PLY','LEFT_BITE','RIGHT_BITE','ANTERIOR_BITE','SCREENSHOT','LIFI','MANDIBULE_MATRIX','MAXILLAIRE_MATRIX') DEFAULT 'OCCLUSION_RESULT',
  PRIMARY KEY (`fileID`,`occlusionID`,`ownerID`),
  KEY `fk_OcclusionFile_CondorFile` (`fileID`,`ownerID`),
  KEY `fk_OcclusionFile_Occlusion` (`occlusionID`,`ownerID`),
  CONSTRAINT `fk_OcclusionFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_OcclusionFile_Occlusion` FOREIGN KEY (`occlusionID`, `ownerID`) REFERENCES `Occlusion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
INSERT INTO `OcclusionFile` VALUES (662,'29d00f37-e846-46c5-bfea-08ec3e95b455','a18ca6df-d765-4c6a-be28-13amigraoccl','2020-12-15 14:15:23','OCCLUSION_RESULT'),(662,'30e96914-828b-4376-9eeb-077529a3422d','c4999e75-8b1c-4a31-8e80-9b9cba9b57fd','2022-03-11 10:16:26','OCCLUSION_RESULT'),(662,'3a74c5df-7c06-40b5-9e98-eeeb48d5c650','a18ca6df-d765-4c6a-be28-13amigraoccl','2020-12-15 14:15:23','OCCLUSION_RESULT'),(662,'4b5c8093-db62-4195-8bba-5349a152c006','bdf42f40-5a7a-435b-a5e0-eb3migraoccl','2020-12-15 14:15:23','OCCLUSION_RESULT'),(662,'51f476ba-752c-4dbb-8096-f63ffa200322','a18ca6df-d765-4c6a-be28-13amigraoccl','2020-12-15 14:15:23','OCCLUSION_RESULT'),(662,'5c922725-b41b-4e38-a244-6a9a320d291e','bdf42f40-5a7a-435b-a5e0-eb3migraoccl','2020-12-15 14:15:23','OCCLUSION_RESULT'),(662,'675a601d-d389-403d-858d-555ff6166630','bdf42f40-5a7a-435b-a5e0-eb3migraoccl','2020-12-15 14:15:23','OCCLUSION_RESULT'),(662,'6b4f036d-deed-43fa-b8c0-889e20bb7692','c4999e75-8b1c-4a31-8e80-9b9cba9b57fd','2022-03-11 10:16:26','OCCLUSION_RESULT'),(662,'72efe2fd-185f-4a0a-9205-c14ee08fd1bd','c4999e75-8b1c-4a31-8e80-9b9cba9b57fd','2022-03-11 10:16:26','OCCLUSION_RESULT'),(662,'83547739-e794-48fb-befb-bed604c04b8f','c4999e75-8b1c-4a31-8e80-9b9cba9b57fd','2022-03-11 10:16:26','OCCLUSION_RESULT'),(662,'931bf3dd-fe07-4981-8ede-599f357c3c60','a18ca6df-d765-4c6a-be28-13amigraoccl','2020-12-15 14:15:23','OCCLUSION_RESULT'),(662,'95cc936b-2c0c-4fdd-8d11-8780095dabca','bdf42f40-5a7a-435b-a5e0-eb3migraoccl','2020-12-15 14:15:23','OCCLUSION_RESULT'),(662,'a721d64e-b79a-4f11-9504-ff9a5bcae5d4','c4999e75-8b1c-4a31-8e80-9b9cba9b57fd','2022-03-11 10:16:26','OCCLUSION_RESULT'),(662,'b25a25e2-610a-466d-a4d8-7518a09b9a78','bdf42f40-5a7a-435b-a5e0-eb3migraoccl','2020-12-15 14:15:23','OCCLUSION_RESULT'),(662,'b58b7bd8-eb47-4d54-9228-ce3a9e6486fd','a18ca6df-d765-4c6a-be28-13amigraoccl','2020-12-15 14:15:23','OCCLUSION_RESULT');
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Office` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text,
  `country` varchar(75) DEFAULT NULL,
  `reassignedTo` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Office_Professional_idx` (`ownerID`),
  KEY `fk_Office_Office_reassignedTo` (`reassignedTo`,`ownerID`),
  CONSTRAINT `fk_Office_Office_reassignedTo` FOREIGN KEY (`reassignedTo`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Office_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
INSERT INTO `Office` VALUES (3,'07a4901a-a73e-414b-bafe-ff42d883049b','542138759','Condor','','Labège','31670','137 rue Garance','France',NULL,NULL,'2019-07-01 14:13:31','2019-07-01 12:13:31','2019-07-01 14:13:31'),(7,'12faf4c9-95d6-4c4f-b641-481c29111d9a','0664864059','DENTAL CUB','','MERIGNAC','33700','10 av jean mazaryck,','France',NULL,NULL,'2019-07-09 11:35:13','2019-07-09 09:35:13','2019-07-09 11:35:13'),(224,'179ab10a-4b77-4b31-a7c1-386f7e9d1cef','0660850205','Cabinet (default)','','LABEGE','','RUE GARANCE','France',NULL,NULL,'2019-09-09 15:36:36','2019-09-09 13:36:36','2019-09-09 15:36:36'),(1081,'2b013106-e8d3-47fc-acc7-88af8cd33ced','0673917531','','','MURET','','','France',NULL,NULL,'2022-09-19 15:16:49','2022-09-19 13:16:49','2022-09-19 14:34:53'),(355,'3d7661f6-e77c-493d-9c2d-45d83cac165e','+390521221362','GIANLUCA DALLATANA','www.uniontech.it','Parma','43122','Rocco Bormioli, 5/A','Italia',NULL,NULL,'2019-10-23 12:56:54','2019-10-23 10:56:54','2019-10-23 12:56:54'),(9,'544e3fb2-5e62-472f-b606-7185054c1396','0149698526','Laboratoire LDA','www.laboratoirelda.com','Villiers Sur Marne','94350','1 rue de la fraternité','France',NULL,NULL,'2019-07-02 11:36:03','2019-07-02 09:36:03','2019-07-02 11:36:03'),(662,'55f46aac-286b-487d-9bd0-18edca00c470','0561569557','BATAILLE Philippe','','MURET','31600','48 route d\'Eaunes','France',NULL,NULL,'2020-04-06 09:36:52','2020-04-06 07:36:52','2020-04-06 09:36:52'),(172,'5d22dd41-4a03-4813-a2a3-86598c1101c0','0559830648','SELARL du Dr Franck LE BOURHIS','','LAROIN','64110','4 Chemin Couralis','France',NULL,NULL,'2019-08-19 17:44:04','2019-08-19 15:44:04','2019-01-21 17:43:09'),(339,'5e42d964-fa5c-4aac-b7ee-0cf0d98d7666','0659598581','Cabinet (default)','','Paris','','','France',NULL,NULL,'2019-10-15 10:41:09','2019-10-15 08:41:09','2019-10-11 20:04:31'),(155,'60100516-06c3-4737-a33b-8fba3b71bd66','0241437031','LEMOUEL SAS','www.laboratoire-lemouel.fr','ECOUFLANT','49000','22 BOULEVARD DE L INDUSTRIE, ZI ECOUFLANT','France',NULL,NULL,'2019-08-27 14:26:48','2019-08-27 12:26:48','2019-08-27 14:26:48'),(317,'8c4a7314-8b79-4f22-aeba-b48e799bb261','0382254814','Cabinet (default)','','LONGWY','','','France',NULL,NULL,'2019-12-09 11:58:34','2019-12-09 10:58:34','2019-10-07 14:44:35'),(6,'a1984274-1ad9-41d4-b536-d4407f8fca00','0491776127','Cabinet (default)','','Marseille','','','France',NULL,NULL,'2019-07-07 06:24:25','2019-07-07 04:24:25','2019-07-02 11:05:21'),(59,'ac14fa6c-ded0-4127-8d99-c18fee62921e','0475490647','Cabinet (default)','','LE TEIL','','','France',NULL,NULL,'2019-09-05 17:19:00','2019-09-05 15:19:00','2019-07-17 14:12:08'),(689,'b9db0008-e73d-4e5a-ac76-2c93df3250ae','04 79 26 15 66','Cabinet (default)','','CHAMBERY','73000','1 Place de la Libération','France',NULL,NULL,'2020-11-03 08:32:27','2020-11-03 07:32:27','2020-11-03 08:32:27'),(1,'bf407538-bec8-49af-b04a-68926a6b1a6e','123322332','Labege','','Labege','31670','Labege','France',NULL,NULL,'2019-06-28 18:00:23','2019-06-28 16:00:23','2019-06-28 18:00:23'),(8,'c54ab53e-cc43-42dd-a0f6-824b6dc657ad','0664143389','LABEL DENT','','MERIGNAC','','10 AV JAN MASARYK','France',NULL,NULL,'2019-07-22 16:59:15','2019-07-22 14:59:15','2019-07-22 16:59:15'),(193,'dc905db3-c0a3-44b2-a0f3-f3c08fdd6bb7','0663713747','Cabinet (default)','','VIRIAT ','','','France',NULL,NULL,'2019-09-05 21:11:53','2019-09-05 19:11:53','2019-09-02 18:53:02'),(663,'e3435e0c-2009-491c-a29a-a7e0848b2dda','0624725921','Laboratoire maylin ','','Bruguieres','31150','23 rue de la plaine','France',NULL,NULL,'2020-04-09 15:10:42','2020-04-09 13:10:42','2020-04-09 15:10:42'),(5,'e563f7db-c71c-416d-a74d-2b979f6eade2','0388334408','LABORATOIRE DENTAL BIOTECH','https://laboratoire-labeldent.fr/','WOLFISHEIM','67202','5 impasse Joffre','France',NULL,NULL,'2021-04-21 14:26:48','2021-04-21 12:26:48','2021-04-21 14:26:48'),(2,'f841d3b8-276b-4ad1-859c-ba7e25ffe059','056139839','condor','','LABEGE','31670','137 rue garance','France',NULL,NULL,'2019-07-01 08:54:35','2019-07-01 06:54:35','2019-07-01 08:54:35');
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Office_BEFORE_DELETE` BEFORE DELETE ON `Office` FOR EACH ROW BEGIN		
  UPDATE Assistant SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Contact SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Discussion SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Patient SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `sex` enum('M','F') DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `salutation` varchar(45) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `picturePath` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('00000001-0000-0000-0000-000000000001','labege','julien','si@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-06-27 19:16:27'),('00000002-0000-0000-0000-000000000001','Sophie','MOURIGAL','sophie.mourigal@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-06-27 19:16:27'),('00000003-0000-0000-0000-000000000001','Thomas','Besson','thomas.besson@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-06-27 19:16:27'),('00000005-0000-0000-0000-000000000001','Dental Biotech Strasbourg','Laboratoire','cfao@dentalbiotech.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000006-0000-0000-0000-000000000001','Gilles','Philip','laboratoirephilip@yahoo.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000007-0000-0000-0000-000000000001','DENTAL CUB','LABORATOIRE','cfao@dentalcub.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000008-0000-0000-0000-000000000001','LABEL DENT','LABORATOIRE','label.dent@orange.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000009-0000-0000-0000-000000000001','Laboratoire','LDA','cfao@laboratoirelda.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000059-0000-0000-0000-000000000001','RIEUX  ','LABORATOIRE','laboratoire-rieux@orange.fr','',NULL,'','','',NULL,NULL,'2022-06-27 19:16:27'),('00000155-0000-0000-0000-000000000001','LEMOUEL','LABORATOIRE','lemouel@aol.com','',NULL,'','','',NULL,NULL,'2022-06-27 19:16:27'),('00000172-0000-0000-0000-000000000001','Franck','Dr LE BOURHIS','francklebourhis@gmail.com','',NULL,'','','',NULL,NULL,'2022-06-27 19:16:27'),('00000193-0000-0000-0000-000000000001','ADT Prothèses Dentaires','Laboratoire ','taponard.sebastien@yahoo.fr','',NULL,'','','',NULL,NULL,'2022-06-27 19:16:27'),('00000224-0000-0000-0000-000000000001','Muriel','LIMONDIN','muriel.limondin@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-06-27 19:16:27'),('00000317-0000-0000-0000-000000000001','Herblot & Moreau','Laboratoire ','contact@ldhm.fr','',NULL,'','','',NULL,NULL,'2022-06-27 19:16:27'),('00000339-0000-0000-0000-000000000001','Léopold','Lanne','prod@3dcelo.com','',NULL,'','','',NULL,NULL,'2022-06-27 19:16:27'),('00000355-0000-0000-0000-000000000001','GIANLUCA','DALLATANA','gianluca@uniontech.it','',NULL,'','','',NULL,NULL,'2022-06-27 19:16:27'),('00000662-0000-0000-0000-000000000001','Philippe','BATAILLE','cabinetdestomatologie31@orange.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000663-0000-0000-0000-000000000001','Michael','Maylin','laboratoire.maylin@yahoo.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000689-0000-0000-0000-000000000001','BY AXE ORTHO','SMILERS LAB','axe-ortho@outlook.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('aacb2e20-4041-4658-8525-2f30dcbc9706','Coralie','BATAILLE','coralieb31@orange.fr','',NULL,'','','',NULL,NULL,'2022-09-19 13:16:49');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `mainPhone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('00000001-0000-0000-0000-000000000001','123322332','','',NULL,NULL,'2022-06-27 19:16:27'),('00000002-0000-0000-0000-000000000001','056139839','','',NULL,NULL,'2022-06-27 19:16:27'),('00000003-0000-0000-0000-000000000001','542138759','','',NULL,NULL,'2022-06-27 19:16:27'),('00000005-0000-0000-0000-000000000001','0388334408','','',NULL,NULL,'2022-03-31 17:40:19'),('00000006-0000-0000-0000-000000000001','0491776127','','',NULL,NULL,'2022-03-31 17:40:19'),('00000007-0000-0000-0000-000000000001','0664864059','','',NULL,NULL,'2022-03-31 17:40:19'),('00000008-0000-0000-0000-000000000001','0664143389','','',NULL,NULL,'2022-03-31 17:40:19'),('00000009-0000-0000-0000-000000000001','0149698526','','',NULL,NULL,'2022-03-31 17:40:19'),('00000059-0000-0000-0000-000000000001','0475490647','','',NULL,NULL,'2022-06-27 19:16:27'),('00000155-0000-0000-0000-000000000001','0241437031','','',NULL,NULL,'2022-06-27 19:16:27'),('00000172-0000-0000-0000-000000000001','0559830648','','',NULL,NULL,'2022-06-27 19:16:27'),('00000193-0000-0000-0000-000000000001','0663713747','','',NULL,NULL,'2022-06-27 19:16:27'),('00000224-0000-0000-0000-000000000001','0660850205','','',NULL,NULL,'2022-06-27 19:16:27'),('00000317-0000-0000-0000-000000000001','0382254814','','',NULL,NULL,'2022-06-27 19:16:27'),('00000339-0000-0000-0000-000000000001','0659598581','','',NULL,NULL,'2022-06-27 19:16:27'),('00000355-0000-0000-0000-000000000001','+390521221362','','',NULL,NULL,'2022-06-27 19:16:27'),('00000662-0000-0000-0000-000000000001','0561569557','','',NULL,NULL,'2022-03-31 17:40:19'),('00000663-0000-0000-0000-000000000001','0624725921','','',NULL,NULL,'2022-03-31 17:40:19'),('00000689-0000-0000-0000-000000000001','04 79 26 15 66','','',NULL,NULL,'2022-03-31 17:40:19'),('2e722761-91aa-4131-8304-268be5a0ae90','0673917531','','',NULL,NULL,'2022-09-19 13:16:49');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `id` mediumint unsigned NOT NULL,
  `UUID` char(36) NOT NULL,
  `credentialsID` char(36) DEFAULT NULL,
  `comments` text,
  `personInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `phoneInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `addressInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `configID` mediumint unsigned DEFAULT NULL,
  `syncInfoID` mediumint unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `type` enum('Undefined','Prothesist','Dentist','Demo','Other') NOT NULL DEFAULT 'Undefined',
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `lastConnectionChecked` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `limitedContactID` char(36) DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT '1',
  `statusGalaxy` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_AB84A8523D139428` (`personInfoID`),
  UNIQUE KEY `UNIQ_AB84A852627FFEF6` (`phoneInfoID`),
  UNIQUE KEY `UNIQ_AB84A852A680FCCC` (`addressInfoID`),
  KEY `fk_Professional_Credentials` (`credentialsID`,`id`),
  KEY `fk_Professional_PersonInfo` (`personInfoID`,`id`),
  KEY `fk_Professional_PhoneInfo` (`phoneInfoID`,`id`),
  KEY `fk_Professional_AddressInfo` (`addressInfoID`,`id`),
  KEY `fk_Professional_Config` (`configID`,`id`),
  KEY `fk_Professional_SyncInfo` (`syncInfoID`,`id`),
  CONSTRAINT `fk_Professional_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`),
  CONSTRAINT `fk_Professional_Config` FOREIGN KEY (`configID`, `id`) REFERENCES `Config` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Professional_Credentials` FOREIGN KEY (`credentialsID`) REFERENCES `Credentials` (`id`),
  CONSTRAINT `fk_Professional_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`),
  CONSTRAINT `fk_Professional_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`),
  CONSTRAINT `fk_Professional_SyncInfo` FOREIGN KEY (`syncInfoID`, `id`) REFERENCES `SyncInfo` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES (1,'11644397-36f2-491f-aabf-b61c5414e0a5',NULL,'','00000001-0000-0000-0000-000000000001','00000001-0000-0000-0000-000000000001','00000001-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2020-01-22 17:08:26',NULL,NULL,'2022-06-27 19:16:28',NULL,'2019-12-19 14:57:22',1,0),(2,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','00000002-0000-0000-0000-000000000001','','00000002-0000-0000-0000-000000000001','00000002-0000-0000-0000-000000000001','00000002-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2020-01-23 09:02:15',NULL,'2020-01-23 08:02:14','2022-06-27 19:16:28',NULL,'2020-01-23 09:02:14',1,0),(3,'7655b09e-027b-49c5-9b6c-832c6e41cee8',NULL,'','00000003-0000-0000-0000-000000000001','00000003-0000-0000-0000-000000000001','00000003-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2019-09-17 15:34:04',NULL,NULL,'2022-06-27 19:16:28',NULL,'2019-09-17 15:34:03',1,0),(5,'35997e6a-79be-404d-8b2c-46fa78f0f219',NULL,'','00000005-0000-0000-0000-000000000001','00000005-0000-0000-0000-000000000001','00000005-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2020-02-21 15:56:57',1,0),(6,'372fe703-e954-4df2-a079-51315f137deb',NULL,'','00000006-0000-0000-0000-000000000001','00000006-0000-0000-0000-000000000001','00000006-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-02 11:05:21',1,0),(7,'14d1a5e5-e2aa-42ab-9b88-6ff9da357d9b',NULL,'','00000007-0000-0000-0000-000000000001','00000007-0000-0000-0000-000000000001','00000007-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-22 17:07:13',1,0),(8,'48539f38-473c-4be5-b635-3fb0fd42b27e',NULL,'','00000008-0000-0000-0000-000000000001','00000008-0000-0000-0000-000000000001','00000008-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-22 19:36:25',1,0),(9,'1dab4f0e-ae37-4417-a649-d2a1322d368a',NULL,'','00000009-0000-0000-0000-000000000001','00000009-0000-0000-0000-000000000001','00000009-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-11 10:05:09',1,0),(59,'023166d9-f822-4bb1-96cb-6fa7d892bf0b',NULL,'','00000059-0000-0000-0000-000000000001','00000059-0000-0000-0000-000000000001','00000059-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2019-09-05 17:29:34',NULL,NULL,'2022-06-27 19:16:28',NULL,'2019-07-17 14:12:08',1,0),(155,'1bf8fcdd-496d-4839-ba78-f2b29eda6b93',NULL,'','00000155-0000-0000-0000-000000000001','00000155-0000-0000-0000-000000000001','00000155-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2019-08-27 14:27:01',NULL,NULL,'2022-06-27 19:16:28',NULL,'2019-08-27 14:27:01',1,0),(172,'36701f7c-94a7-4ef6-a635-25b6dc5e0f86',NULL,'','00000172-0000-0000-0000-000000000001','00000172-0000-0000-0000-000000000001','00000172-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2020-01-22 17:49:56',NULL,NULL,'2022-06-27 19:16:28',NULL,'2020-01-22 17:49:55',1,0),(193,'eba81f34-ad3a-4498-b307-4af657800052',NULL,'','00000193-0000-0000-0000-000000000001','00000193-0000-0000-0000-000000000001','00000193-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2019-09-25 11:58:51',NULL,NULL,'2022-06-27 19:16:28',NULL,'2019-09-02 18:53:02',1,0),(224,'765081bc-b5ad-428e-bfa7-7edfee9d51a1',NULL,'','00000224-0000-0000-0000-000000000001','00000224-0000-0000-0000-000000000001','00000224-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2019-09-09 15:36:10',NULL,NULL,'2022-06-27 19:16:28',NULL,'2019-09-09 15:29:44',1,0),(317,'5fceb3e9-78c3-4c50-b1e1-6c0da17eb225',NULL,'','00000317-0000-0000-0000-000000000001','00000317-0000-0000-0000-000000000001','00000317-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2019-12-09 11:58:44',NULL,NULL,'2022-06-27 19:16:28',NULL,'2019-10-07 14:44:35',1,0),(339,'4d0904f5-35be-427c-8aa8-ded12c7970cb',NULL,'','00000339-0000-0000-0000-000000000001','00000339-0000-0000-0000-000000000001','00000339-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2019-10-15 10:41:17',NULL,NULL,'2022-06-27 19:16:28',NULL,'2019-10-11 20:04:31',1,0),(355,'e8b64997-f348-44d2-82fc-581fc0df922d',NULL,'','00000355-0000-0000-0000-000000000001','00000355-0000-0000-0000-000000000001','00000355-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2019-10-23 12:56:25',NULL,NULL,'2022-06-27 19:16:28',NULL,'2019-10-23 12:56:25',1,0),(662,'045f19a4-7d35-457a-85ae-94b33b89a0d2','00000662-0000-0000-0000-000000000001','','00000662-0000-0000-0000-000000000001','00000662-0000-0000-0000-000000000001','00000662-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2023-03-21 12:33:49','2023-04-11 18:00:22',NULL,'2023-04-11 18:00:22',NULL,'2023-04-11 20:00:22',1,0),(663,'62a0cd5b-b912-47da-9e1d-68364c1eaf71',NULL,'','00000663-0000-0000-0000-000000000001','00000663-0000-0000-0000-000000000001','00000663-0000-0000-0000-000000000001',1,1,'','Prothesist',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2020-04-09 15:10:00',1,0),(689,'464a0019-6c2e-403e-b0a5-f1b453741d76',NULL,'','00000689-0000-0000-0000-000000000001','00000689-0000-0000-0000-000000000001','00000689-0000-0000-0000-000000000001',1,1,'','Prothesist',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2020-11-03 08:29:54',1,0),(1081,'bc46fc6a-ab20-4d4f-becb-ce8c04b6ca22',NULL,'','aacb2e20-4041-4658-8525-2f30dcbc9706','2e722761-91aa-4131-8304-268be5a0ae90','74f9692b-a496-48ca-9002-1aa1e9b3b2e6',1,1,'','Dentist',NULL,'2022-09-19 15:16:49',NULL,NULL,'2022-09-19 13:16:49',NULL,'2022-09-19 14:34:53',1,0);
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalEnvInfos`
--

DROP TABLE IF EXISTS `ProfessionalEnvInfos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalEnvInfos` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `professionalID` mediumint unsigned NOT NULL DEFAULT '0' COMMENT 'Le professionnel propriétaire des informations',
  `accessCode` varchar(45) DEFAULT NULL,
  `status` enum('created','confirmed','blocked') NOT NULL DEFAULT 'created',
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `preventDuplicateProfessionalEnvInfos` (`professionalID`),
  KEY `fk_ProfessionalEnvInfos_RefersTo_idx` (`professionalID`),
  CONSTRAINT `FK_A15010B8C37A46A` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalEnvInfos`
--

LOCK TABLES `ProfessionalEnvInfos` WRITE;
/*!40000 ALTER TABLE `ProfessionalEnvInfos` DISABLE KEYS */;
INSERT INTO `ProfessionalEnvInfos` VALUES ('2bdc2301-2b73-4720-b523-703aaecb194a',339,NULL,'confirmed','2022-06-27 19:16:28'),('4d566611-1656-40d9-98f9-3d78f058f954',155,NULL,'confirmed','2022-06-27 19:16:28'),('5b3d8f31-ba3e-4253-839c-f5a79d8c32c7',224,NULL,'confirmed','2022-06-27 19:16:28'),('630e78f9-33b3-4ebc-a500-97935acbff3e',1,NULL,'confirmed','2022-06-27 19:16:28'),('6aa04a7f-349b-41cf-abf5-278c27eb50f2',5,NULL,'confirmed','2022-06-27 19:16:28'),('743bd098-b649-4025-92fd-1da8716ade1e',663,NULL,'confirmed','2022-06-27 19:16:28'),('902e77af-a5e2-4c7e-ba7b-d65b3e27b3ae',9,NULL,'confirmed','2022-06-27 19:16:28'),('9b4378ad-8999-47d2-a81a-45f7c107f342',689,NULL,'confirmed','2022-06-27 19:16:28'),('a265609e-fbe7-4e57-b26d-c9adfcaa924d',662,NULL,'confirmed','2022-06-27 19:16:28'),('ade048cd-390c-4527-b74a-0001d0965c9d',1081,NULL,'confirmed','2022-09-19 13:16:59'),('b7b8a671-190b-4b77-9060-89e6665d6220',2,NULL,'confirmed','2022-06-27 19:16:28'),('bb43faef-b4e4-4a3b-b92b-97a5d7906ee2',317,NULL,'confirmed','2022-06-27 19:16:28'),('c5b82dd0-93e6-44a9-84e5-5a10069e12e5',172,NULL,'confirmed','2022-06-27 19:16:28'),('cfd51861-0a67-47ad-aee6-eae0772f934a',355,NULL,'confirmed','2022-06-27 19:16:28'),('d037fef6-8a2a-4e51-b98d-b5efef308a23',3,NULL,'confirmed','2022-06-27 19:16:28'),('d2703124-7e61-434a-912f-e47afb433ae3',193,NULL,'confirmed','2022-06-27 19:16:28'),('e09d6bd1-793c-4a9f-ab42-1abb19f43191',59,NULL,'confirmed','2022-06-27 19:16:28'),('e2db300c-47ac-404f-944e-d639581a35d9',6,NULL,'confirmed','2022-06-27 19:16:28'),('f282b4a5-afb3-499c-8c85-509183bda100',8,NULL,'confirmed','2022-06-27 19:16:28'),('f339f151-dced-4504-957f-7cb0d8aac542',7,NULL,'confirmed','2022-06-27 19:16:28');
/*!40000 ALTER TABLE `ProfessionalEnvInfos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalPatient` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `patientID` char(36) DEFAULT NULL,
  `officeID` char(36) DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`id`),
  KEY `unique_Patient_Pro` (`ownerID`,`patientID`),
  CONSTRAINT `fk_Patient_Pro` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
INSERT INTO `ProfessionalPatient` VALUES (1,662,'1af643c4-44fe-4ccb-b545-dbc90b47633b','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(2,662,'2b4f07b1-1d58-42a2-9e72-3461efd5a2d9','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(3,662,'35970bab-04c1-443b-9e5c-c6a127ec7a47','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(4,662,'3c7b9483-14ba-422a-b943-e347249b6653','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(5,662,'406a8572-4b0f-480a-ad2e-daf5530143b6','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(6,662,'555b020e-3e4a-4263-bf03-9f8db80cc843','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(7,662,'5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(8,662,'94ac368a-c8ad-482d-91b4-26c8db10596d','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(9,662,'b8f0b748-12f3-4798-9d93-1a7a89f0e0e1','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(10,662,'d41de280-8cf3-4e57-893e-cc7a010bc864','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(11,662,'d485e5a2-11e0-4863-b612-22d245d07d04','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(12,662,'f61dd82a-2e03-48b9-8ab4-0840b811de63','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(13,662,'5cd08749-129b-49e3-85b9-abee157177a4','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(14,662,'f15cb858-4f0b-44ec-a017-5e662039ba19','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(15,662,'615ede1a-dba9-4251-9e9e-6cbbd3041fdc','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(16,662,'03ec19f1-9f11-4710-a0cd-c5d7739e40d7','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(17,662,'9977cfd4-497a-4153-ade7-6e67fc8f1938','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(18,662,'507b1d43-2b21-4296-a969-0a1223d5706d','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(19,662,'fee63978-1be9-4cfc-a80c-44dc3616eb33','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'ADULT'),(20,662,'5587321c-4405-49dc-90d5-8810cc776c6d','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(21,662,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'ADULT'),(22,662,'ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(23,662,'e27b6130-520e-4c5b-8e6b-5e82a8c5a273','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(24,662,'1ff3b081-8f07-4144-87ef-af0810d5c312','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(25,662,'665b40ce-9690-4944-b007-4a96c1f5d57d','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(26,662,'4b9236e1-8988-4a19-97af-cd44133ee27b','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(27,662,'53c591be-aea6-491f-bc06-740bd7d9f780','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(28,662,'3d722760-3820-40e4-81e1-60e722c0cb01','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE');
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `currentDeliveryDate` datetime DEFAULT NULL,
  `previousDeliveryDate` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','sent','date_validated','date_edited','validated','cancelled') NOT NULL DEFAULT 'sent',
  `unread` tinyint(1) DEFAULT '0',
  `createdAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `actID` char(36) NOT NULL,
  `localDisplayID` mediumint unsigned DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `idx_Order_Work` (`ownerID`),
  KEY `fk_Order_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_Order_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
INSERT INTO `ProstheticOrder` VALUES (662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','2020-05-09 12:00:00',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','AUTRE FICHE PROTHÉTIQUE',NULL,'sent',0,'2020-05-01 08:19:50','2020-05-01 08:23:32','2020-05-01 06:23:32','2020-05-01 08:23:30','64834083-3320-4687-9710-c2be0d9c7198',2,1),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','2020-04-16 00:00:01',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','ODF',NULL,'sent',0,'2020-04-15 08:27:24','2020-04-15 08:27:56','2020-04-15 06:27:56','2020-04-15 08:27:54','1ce80886-d3f3-42d8-872a-a2eba69d0005',1,1),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','2020-04-16 00:00:01',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','ODF',NULL,'sent',0,'2020-04-15 08:51:12','2020-04-15 08:51:46','2020-04-15 06:51:46','2020-04-15 08:51:44','1ce80886-d3f3-42d8-872a-a2eba69d0005',2,1),(662,'50b326be-6726-493a-a2ce-6f1153dc9927','2020-04-18 00:00:01',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','AUTRE FICHE PROTHÉTIQUE',NULL,'sent',0,'2020-04-17 07:56:10','2020-04-17 07:56:51','2020-04-17 05:56:51','2020-04-17 07:56:49','bb2e4d25-46eb-48d2-80af-41639e464a04',1,1),(662,'5d81ea77-9474-4056-9631-6c7167b6f3eb','2020-12-29 11:43:30',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','GOUTTIÈRE','2020-12-29 12:05:52','not_sent',0,'2020-12-29 11:43:30',NULL,'2020-12-29 11:05:52','2020-12-29 11:43:30','b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c',1,1),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','2020-05-09 12:00:00',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','AUTRE FICHE PROTHÉTIQUE',NULL,'date_validated',0,'2020-05-01 08:26:01','2020-05-02 21:58:19','2020-05-02 19:58:19','2020-05-02 21:58:19','64834083-3320-4687-9710-c2be0d9c7198',3,1),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','2020-05-09 12:00:00',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','AUTRE FICHE PROTHÉTIQUE',NULL,'sent',0,'2020-04-30 20:26:09','2020-04-30 20:27:49','2020-04-30 18:27:49','2020-04-30 20:27:47','64834083-3320-4687-9710-c2be0d9c7198',1,1),(662,'7a0fe58a-64da-4011-982b-3db6bd950242','2022-09-20 00:00:00',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','COMMANDE',NULL,'sent',1,'2022-09-19 15:18:37',NULL,'2022-09-19 13:19:17','2022-09-19 15:19:17','1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e',1,1),(662,'7a51b084-d261-4bda-a936-18d73b32440e','2020-04-10 09:18:38',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','AMOVIBLE SUR IMPLANT','2020-04-10 09:18:47','not_sent',0,'2020-04-10 09:18:38',NULL,'2020-04-10 07:18:47','2020-04-10 09:18:38','934f20d2-7444-4367-89e2-61c3bf4bee57',2,1),(662,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98','2020-04-13 07:58:36',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','AUTRE FICHE PROTHÉTIQUE','2020-04-13 07:58:44','not_sent',0,'2020-04-13 07:58:36',NULL,'2020-04-13 05:58:44','2020-04-13 07:58:36','cb9d8495-b4dd-423f-a624-7cff70e4db55',1,1),(662,'b1c50855-9551-467e-94d9-915a6218ec1b','2020-07-27 12:00:00',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','GOUTTIÈRE',NULL,'date_validated',0,'2020-07-13 19:42:35','2020-07-15 23:04:22','2020-07-15 21:04:22','2020-07-15 23:04:22','bc967a6b-ad1a-4a59-aab8-92332e4217b0',1,1),(662,'d75864c1-5365-47a3-9907-f9bee7a8fe94','2020-04-10 09:18:12',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','AMOVIBLE','2020-04-10 09:21:02','not_sent',0,'2020-04-10 09:18:12',NULL,'2020-04-10 07:21:02','2020-04-10 09:18:23','934f20d2-7444-4367-89e2-61c3bf4bee57',1,1),(662,'eb120496-ad30-4640-856b-fbdd1139c529','2020-04-11 00:00:01',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','ODF',NULL,'date_validated',0,'2020-04-10 09:19:11','2020-04-10 09:29:08','2020-04-10 07:29:08','2020-04-10 09:29:08','934f20d2-7444-4367-89e2-61c3bf4bee57',3,1),(662,'fb151d98-0604-45ed-8599-26fa11975b19','2020-04-14 00:00:01',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','ODF',NULL,'sent',0,'2020-04-13 07:58:48','2020-04-13 07:59:30','2020-04-13 05:59:30','2020-04-13 07:59:28','cb9d8495-b4dd-423f-a624-7cff70e4db55',2,1),(662,'fce8aef9-22f3-446a-bd23-7f6a283417dc','2020-04-13 00:00:01',NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','AUTRE FICHE PROTHÉTIQUE',NULL,'date_validated',0,'2020-04-12 08:27:54','2020-04-13 07:39:16','2020-04-13 05:39:16','2020-04-13 07:39:16','ec084612-67a2-4430-ae15-7fe0edeaca64',1,1);
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_ProstheticOrderFile_ProstheticOrder` (`orderID`,`ownerID`),
  KEY `fk_ProstheticOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ProstheticOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticOrderFile_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
INSERT INTO `ProstheticOrderFile` VALUES (662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','169331da-dbab-454e-828b-67287bb2feb7','2020-05-01 06:23:30'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','1e3c210c-a983-4276-916c-6c49b0e64e1d','2020-05-01 06:23:30'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','1e81852e-fdc6-4523-9e33-47494d60d953','2020-05-01 06:23:30'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','1f608503-4867-4253-a143-dd200e0ebe0a','2020-05-01 06:23:30'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','1f629ca9-f822-4a93-aecc-1e8473c82dd5','2020-05-01 06:23:30'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','51c81dd7-f872-4092-9a17-d9b3821ed7c8','2020-05-01 06:23:30'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','60a7c19d-824d-4fdf-a109-f3df643a3f1a','2020-05-01 06:23:30'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','8633595a-6eb0-4dfd-885e-9648bf6c088f','2020-05-01 06:23:30'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1','2020-05-01 06:23:30'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','bc10348b-1c26-48ee-bc8f-6fa5ac933a14','2020-05-01 06:23:30'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','f69344e1-d52d-49da-acc5-b714cb86225d','2020-05-01 06:23:30'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','0abfe6c8-8321-4681-9ffd-944418ed370c','2020-04-15 06:27:54'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','0fd33c57-ea90-4557-bed0-d59a4b5f2c80','2020-04-15 06:27:54'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','11798976-f244-45ce-883c-778a6a2a0bc3','2020-04-15 06:27:54'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','2129ad39-4745-4e82-a5b8-dcf7933c6ae7','2020-04-15 06:27:54'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','2a2002a5-6321-4c63-938e-7276412e6a28','2020-04-15 06:27:54'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','3a8a47b1-96a0-4e8f-a7fa-d5c2f74f3677','2020-04-15 06:27:54'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','3f126af5-ce2b-4e13-8fc8-9811ab5d462c','2020-04-15 06:27:54'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','48632fc1-3269-4a7f-bdaa-980e30af0358','2020-04-15 06:27:54'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','a2156f23-da3f-4a2a-97f3-76ea6c877521','2020-04-15 06:27:54'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','a483fb03-0adb-4387-9099-c9c2567855e7','2020-04-15 06:27:54'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','a5903ca6-45db-41cc-a262-19592ff5f2e4','2020-04-15 06:27:54'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','f574474f-dc28-462d-9251-b23591ca9bcb','2020-04-15 06:27:54'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','0abfe6c8-8321-4681-9ffd-944418ed370c','2020-04-15 06:51:44'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','2129ad39-4745-4e82-a5b8-dcf7933c6ae7','2020-04-15 06:51:44'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','27755e68-98ae-4662-a39e-c3ea4ba3cdd4','2020-04-15 06:51:44'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','2a2002a5-6321-4c63-938e-7276412e6a28','2020-04-15 06:51:44'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','3a8a47b1-96a0-4e8f-a7fa-d5c2f74f3677','2020-04-15 06:51:44'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','3f126af5-ce2b-4e13-8fc8-9811ab5d462c','2020-04-15 06:51:44'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','48632fc1-3269-4a7f-bdaa-980e30af0358','2020-04-15 06:51:44'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','a2156f23-da3f-4a2a-97f3-76ea6c877521','2020-04-15 06:51:44'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','a483fb03-0adb-4387-9099-c9c2567855e7','2020-04-15 06:51:44'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','a5903ca6-45db-41cc-a262-19592ff5f2e4','2020-04-15 06:51:44'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','b2cc5b60-1704-4150-aead-5e59b3575b06','2020-04-15 06:51:44'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','f574474f-dc28-462d-9251-b23591ca9bcb','2020-04-15 06:51:44'),(662,'50b326be-6726-493a-a2ce-6f1153dc9927','3efa61b2-db0f-47ba-a009-383d9c565444','2020-04-17 05:56:49'),(662,'50b326be-6726-493a-a2ce-6f1153dc9927','4b5c8093-db62-4195-8bba-5349a152c006','2020-04-17 05:56:49'),(662,'50b326be-6726-493a-a2ce-6f1153dc9927','5c922725-b41b-4e38-a244-6a9a320d291e','2020-04-17 05:56:49'),(662,'50b326be-6726-493a-a2ce-6f1153dc9927','675a601d-d389-403d-858d-555ff6166630','2020-04-17 05:56:49'),(662,'50b326be-6726-493a-a2ce-6f1153dc9927','95cc936b-2c0c-4fdd-8d11-8780095dabca','2020-04-17 05:56:49'),(662,'50b326be-6726-493a-a2ce-6f1153dc9927','b25a25e2-610a-466d-a4d8-7518a09b9a78','2020-04-17 05:56:49'),(662,'50b326be-6726-493a-a2ce-6f1153dc9927','e18ed074-c432-415e-b63e-3b73dcb95e72','2020-04-17 05:56:49'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','169331da-dbab-454e-828b-67287bb2feb7','2020-05-01 06:31:26'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','1e3c210c-a983-4276-916c-6c49b0e64e1d','2020-05-01 06:31:26'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','1e81852e-fdc6-4523-9e33-47494d60d953','2020-05-01 06:31:26'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','1f608503-4867-4253-a143-dd200e0ebe0a','2020-05-01 06:31:26'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','51c81dd7-f872-4092-9a17-d9b3821ed7c8','2020-05-01 06:31:26'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','60a7c19d-824d-4fdf-a109-f3df643a3f1a','2020-05-01 06:31:26'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1','2020-05-01 06:31:26'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','9319bd6a-6e7d-4505-8090-e4e10e3caec0','2020-05-01 06:31:26'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','95ab2e1b-4b91-4bb5-965e-8086f8805dc7','2020-05-01 06:31:26'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','afb6acdc-fdfd-416b-a94d-62c0ccaf4043','2020-05-01 06:31:26'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','bc10348b-1c26-48ee-bc8f-6fa5ac933a14','2020-05-01 06:31:26'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','f69344e1-d52d-49da-acc5-b714cb86225d','2020-05-01 06:31:26'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','169331da-dbab-454e-828b-67287bb2feb7','2020-04-30 18:27:47'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','1e3c210c-a983-4276-916c-6c49b0e64e1d','2020-04-30 18:27:47'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','1e81852e-fdc6-4523-9e33-47494d60d953','2020-04-30 18:27:47'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','1f608503-4867-4253-a143-dd200e0ebe0a','2020-04-30 18:27:47'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','51c81dd7-f872-4092-9a17-d9b3821ed7c8','2020-04-30 18:27:47'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','60a7c19d-824d-4fdf-a109-f3df643a3f1a','2020-04-30 18:27:47'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1','2020-04-30 18:27:47'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','9319bd6a-6e7d-4505-8090-e4e10e3caec0','2020-04-30 18:27:47'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','9533b2b7-5385-4d5f-8858-b01c1c030817','2020-04-30 18:27:47'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','9a62fabe-8dd2-441c-b9f8-7ad80abd136a','2020-04-30 18:27:47'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','bc10348b-1c26-48ee-bc8f-6fa5ac933a14','2020-04-30 18:27:47'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','f69344e1-d52d-49da-acc5-b714cb86225d','2020-04-30 18:27:47'),(662,'7a0fe58a-64da-4011-982b-3db6bd950242','1ab759da-dceb-48e2-83be-326054416d3c','2022-09-19 13:19:17'),(662,'7a0fe58a-64da-4011-982b-3db6bd950242','41f1c7ba-1d8c-47b9-8ed9-11f004bb7681','2022-09-19 13:19:17'),(662,'b1c50855-9551-467e-94d9-915a6218ec1b','144ce692-0397-4de4-aa07-e50e85b5a553','2020-07-13 17:47:49'),(662,'b1c50855-9551-467e-94d9-915a6218ec1b','22b17811-0494-42ee-a82c-e9e5fe8e4ae4','2020-07-13 17:47:48'),(662,'b1c50855-9551-467e-94d9-915a6218ec1b','e94bbc94-0540-4634-816e-4a842ced15fa','2020-07-13 17:47:49'),(662,'b1c50855-9551-467e-94d9-915a6218ec1b','f35334e9-a7ce-43a7-845e-98ae1de51100','2020-07-13 17:47:48'),(662,'eb120496-ad30-4640-856b-fbdd1139c529','1f02ce0a-9100-460e-987f-c2b91eda5ac1','2020-04-10 07:20:48'),(662,'eb120496-ad30-4640-856b-fbdd1139c529','3c573ce9-f6b2-4667-9726-f5aed56d3325','2020-04-10 07:20:47'),(662,'eb120496-ad30-4640-856b-fbdd1139c529','99642a2a-dd48-414b-a8ef-1621aa6040ca','2020-04-10 07:20:47'),(662,'eb120496-ad30-4640-856b-fbdd1139c529','bb2755e4-36de-4604-9ee9-d2711661ea1d','2020-04-10 07:20:48'),(662,'fb151d98-0604-45ed-8599-26fa11975b19','31421697-5459-439e-919b-169d051646f5','2020-04-13 05:59:28'),(662,'fb151d98-0604-45ed-8599-26fa11975b19','60447943-1739-4e3f-aced-0eb015c274a2','2020-04-13 05:59:28'),(662,'fb151d98-0604-45ed-8599-26fa11975b19','7cd8a534-43de-41bd-9f1a-216a2bfc251d','2020-04-13 05:59:28'),(662,'fb151d98-0604-45ed-8599-26fa11975b19','9cd5b1c8-ef15-449d-97a1-bdf6947abe78','2020-04-13 05:59:28'),(662,'fce8aef9-22f3-446a-bd23-7f6a283417dc','09549052-25f2-4ebe-8844-ee815b650573','2020-04-12 06:28:40'),(662,'fce8aef9-22f3-446a-bd23-7f6a283417dc','ebcf2fdf-8f60-4590-bf41-6c7e360d6441','2020-04-12 06:28:40');
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `recipientID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`recipientID`),
  KEY `fk_ProstheticOrderRecipient_ProstheticOrder` (`orderID`,`ownerID`),
  KEY `fk_ProstheticOrderRecipient_Contact` (`recipientID`,`ownerID`),
  CONSTRAINT `fk_ProstheticOrderRecipient_Contact` FOREIGN KEY (`recipientID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticOrderRecipient_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
INSERT INTO `ProstheticOrderRecipient` VALUES (662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','2020-05-01 06:23:30'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','08ea1d0b-73cb-4462-acdd-d58c09bde03a','2020-04-15 06:27:54'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','08ea1d0b-73cb-4462-acdd-d58c09bde03a','2020-04-15 06:51:44'),(662,'50b326be-6726-493a-a2ce-6f1153dc9927','08ea1d0b-73cb-4462-acdd-d58c09bde03a','2020-04-17 05:56:49'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','2020-05-01 06:31:26'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','2020-04-30 18:27:47'),(662,'7a0fe58a-64da-4011-982b-3db6bd950242','0c639fb7-3c3a-493f-ac8c-2bd4fb7c8ede','2023-04-11 18:59:41'),(662,'b1c50855-9551-467e-94d9-915a6218ec1b','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','2020-07-13 17:47:48'),(662,'eb120496-ad30-4640-856b-fbdd1139c529','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','2020-04-10 07:20:47'),(662,'fb151d98-0604-45ed-8599-26fa11975b19','08ea1d0b-73cb-4462-acdd-d58c09bde03a','2020-04-13 05:59:28'),(662,'fce8aef9-22f3-446a-bd23-7f6a283417dc','08ea1d0b-73cb-4462-acdd-d58c09bde03a','2020-04-12 06:28:40');
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticSheet` (
  `id` char(36) NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileID` char(36) DEFAULT NULL,
  `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ProstheticSheet_ProstheticOrder` (`orderID`),
  KEY `fk_ProstheticSheet_CondorFile` (`pdfFileID`),
  CONSTRAINT `fk_ProstheticSheet_CondorFile` FOREIGN KEY (`pdfFileID`) REFERENCES `CondorFile` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticSheet_ProstheticOrder` FOREIGN KEY (`orderID`) REFERENCES `ProstheticOrder` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
INSERT INTO `ProstheticSheet` VALUES ('03969eb4-0bb5-4cae-92e8-5cf65689757e',662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','{\"comment\":\"\",\"language\":\"fr_FR\",\"sheetTitle\":\"AUTRE FICHE DE PROTHESE\",\"type\":12}','1f629ca9-f822-4a93-aecc-1e8473c82dd5','2020-05-01 08:19:50',NULL,'2021-09-27 13:56:36','2020-05-01 08:23:30','2021-09-27 11:56:36'),('083f4c03-5580-45f2-9229-c3b06c40bbe2',662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','{\"sheetTitle\":\"ODF\",\"comment\":\"test\",\"language\":\"fr_FR\",\"type\":11}','0fd33c57-ea90-4557-bed0-d59a4b5f2c80','2020-04-15 08:27:24',NULL,'2020-04-15 08:27:56','2020-04-15 08:27:54','2021-09-27 11:01:34'),('118a8411-96d0-412f-a2fd-6e990b04bf34',662,'118a8411-96d0-412f-a2fd-6e990b04bf34','{\"sheetTitle\":\"ODF\",\"comment\":\"test 2\",\"language\":\"fr_FR\",\"type\":11}','27755e68-98ae-4662-a39e-c3ea4ba3cdd4','2020-04-15 08:51:12',NULL,'2020-04-15 08:51:46','2020-04-15 08:51:44','2021-09-27 11:01:34'),('50b326be-6726-493a-a2ce-6f1153dc9927',662,'50b326be-6726-493a-a2ce-6f1153dc9927','{\"sheetTitle\":\"AUTRE FICHE PROTHÉTIQUE\",\"comment\":\"test\",\"language\":\"fr_FR\",\"type\":12}','e18ed074-c432-415e-b63e-3b73dcb95e72','2020-04-17 07:56:10',NULL,'2021-09-27 13:56:28','2020-04-17 07:56:49','2021-09-27 11:56:28'),('5d81ea77-9474-4056-9631-6c7167b6f3eb',662,'5d81ea77-9474-4056-9631-6c7167b6f3eb','{\"sheetTitle\":\"GOUTTIÈRE\",\"comment\":\"\",\"language\":\"fr_FR\",\"subType\":0,\"type\":10}',NULL,'2020-12-29 11:43:30','2020-12-29 12:05:52',NULL,'2020-12-29 11:43:30','2020-12-29 11:05:52'),('63706c26-d501-4c56-bdc2-ab2c76f6d988',662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','{\"sheetTitle\":\"AUTRE FICHE PROTHÉTIQUE\",\"comment\":\"ATM\\n\",\"language\":\"fr_FR\",\"type\":12}','95ab2e1b-4b91-4bb5-965e-8086f8805dc7','2020-05-01 08:26:01',NULL,'2021-09-27 13:56:33','2020-05-02 21:58:19','2021-09-27 11:56:33'),('6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',662,'7a0fe58a-64da-4011-982b-3db6bd950242','{\"comment\":\"Aucun\",\"language\":\"fr_FR\",\"sheetTitle\":\"AUTRE FICHE DE PROTHESE\",\"type\":12}','1ab759da-dceb-48e2-83be-326054416d3c','2022-09-19 15:18:45',NULL,NULL,'2022-09-19 15:18:45','2022-09-19 13:19:17'),('6ff5b097-d5bb-4902-981f-b53e6fa85604',662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','{\"comment\":\"\",\"language\":\"fr_FR\",\"sheetTitle\":\"AUTRE FICHE DE PROTHESE\",\"type\":12}','9533b2b7-5385-4d5f-8858-b01c1c030817','2020-04-30 20:26:09',NULL,'2021-09-27 13:56:32','2020-04-30 20:27:47','2021-09-27 11:56:32'),('7a51b084-d261-4bda-a936-18d73b32440e',662,'7a51b084-d261-4bda-a936-18d73b32440e','{\"sheetTitle\":\"AMOVIBLE SUR IMPLANT\",\"amovibleProstheticStep\":0,\"comment\":\"\",\"generalTintElement\":\"\",\"language\":\"fr_FR\",\"subElements\":[{\"chassisMaterial\":0,\"comment\":\"\",\"prostheticMaterial\":0,\"refImplant\":\"\",\"removableArcade\":0,\"selectedTeeth\":[],\"specificTintSubElement\":\"\"}],\"type\":8}',NULL,'2020-04-10 09:18:38','2020-04-10 09:18:47',NULL,'2020-04-10 09:18:38','2020-04-10 07:18:47'),('9c995fb9-8c4e-4ea3-8f7b-5798259bca98',662,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98','{\"sheetTitle\":\"AUTRE FICHE PROTHÉTIQUE\",\"comment\":\"\",\"language\":\"fr_FR\",\"type\":12}',NULL,'2020-04-13 07:58:36','2020-04-13 07:58:44',NULL,'2020-04-13 07:58:36','2020-04-13 05:58:44'),('b1c50855-9551-467e-94d9-915a6218ec1b',662,'b1c50855-9551-467e-94d9-915a6218ec1b','{\"comment\":\"\",\"language\":\"fr_FR\",\"sheetTitle\":\"AUTRE FICHE DE PROTHESE\",\"type\":12}','22b17811-0494-42ee-a82c-e9e5fe8e4ae4','2020-07-13 19:42:35',NULL,'2021-09-27 13:56:24','2020-07-15 23:04:22','2021-09-27 11:56:24'),('d75864c1-5365-47a3-9907-f9bee7a8fe94',662,'d75864c1-5365-47a3-9907-f9bee7a8fe94','{\"sheetTitle\":\"AMOVIBLE\",\"amovibleProstheticStep\":0,\"chassisMaterial\":0,\"comment\":\"\",\"crochet\":0,\"generalTintElement\":\"\",\"language\":\"fr_FR\",\"prostheticMaterial\":0,\"removableArcade\":0,\"selectedTeeth\":[],\"subType\":2,\"type\":7}',NULL,'2020-04-10 09:18:12','2020-04-10 09:21:02',NULL,'2020-04-10 09:18:23','2020-04-10 07:21:02'),('eb120496-ad30-4640-856b-fbdd1139c529',662,'eb120496-ad30-4640-856b-fbdd1139c529','{\"sheetTitle\":\"ODF\",\"comment\":\"Test\",\"language\":\"fr_FR\",\"type\":11}','3c573ce9-f6b2-4667-9726-f5aed56d3325','2020-04-10 09:19:11',NULL,'2021-09-27 13:56:25','2020-04-10 09:29:08','2021-09-27 11:56:25'),('fb151d98-0604-45ed-8599-26fa11975b19',662,'fb151d98-0604-45ed-8599-26fa11975b19','{\"sheetTitle\":\"ODF\",\"comment\":\"Test 2\",\"language\":\"fr_FR\",\"type\":11}','60447943-1739-4e3f-aced-0eb015c274a2','2020-04-13 07:58:48',NULL,'2020-04-13 07:59:30','2020-04-13 07:59:28','2021-09-27 11:01:34'),('fce8aef9-22f3-446a-bd23-7f6a283417dc',662,'fce8aef9-22f3-446a-bd23-7f6a283417dc','{\"sheetTitle\":\"AUTRE FICHE PROTHÉTIQUE\",\"comment\":\"Test\",\"language\":\"fr_FR\",\"type\":12}','ebcf2fdf-8f60-4590-bf41-6c7e360d6441','2020-04-12 08:27:54',NULL,'2020-04-13 07:39:16','2020-04-13 07:39:16','2021-09-27 11:01:34');
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerID` mediumint unsigned NOT NULL,
  `receivedMessageID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`fileID`,`receivedMessageID`),
  KEY `fk_ReceivedAttachment_ReceivedMessage` (`receivedMessageID`,`ownerID`),
  KEY `fk_ReceivedAttachment_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ReceivedAttachment_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ReceivedAttachment_ReceivedMessage` FOREIGN KEY (`receivedMessageID`, `ownerID`) REFERENCES `ReceivedMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
INSERT INTO `ReceivedAttachment` VALUES (662,'1cc1a348-7d48-11ea-947d-226cec7cb58a','1cc559c6-7d48-11ea-947d-226cec7cb58a','2020-04-13 05:32:16'),(662,'1cc1a348-7d48-11ea-947d-226cec7cb58a','1cc71f0a-7d48-11ea-947d-226cec7cb58a','2020-04-13 05:32:16'),(662,'1ced8cbe-7d48-11ea-947d-226cec7cb58a','1cf0bff8-7d48-11ea-947d-226cec7cb58a','2020-04-13 05:32:16'),(662,'1ced8cbe-7d48-11ea-947d-226cec7cb58a','1cf2d4d9-7d48-11ea-947d-226cec7cb58a','2020-04-13 05:32:16'),(662,'1d1ad35b-7d48-11ea-947d-226cec7cb58a','1d1e9e19-7d48-11ea-947d-226cec7cb58a','2020-04-13 05:32:18'),(662,'1d1ad35b-7d48-11ea-947d-226cec7cb58a','1d20464f-7d48-11ea-947d-226cec7cb58a','2020-04-13 05:32:18'),(662,'1e334837-8121-11ed-a752-9ec33d03e6dd','1e553911-8121-11ed-a752-9ec33d03e6dd','2022-12-21 11:18:11'),(662,'1e334837-8121-11ed-a752-9ec33d03e6dd','1e57cf4d-8121-11ed-a752-9ec33d03e6dd','2022-12-21 11:18:11'),(662,'208fe542-91ae-11ed-a752-9ec33d03e6dd','20926382-91ae-11ed-a752-9ec33d03e6dd','2023-01-11 12:47:52'),(662,'208fe542-91ae-11ed-a752-9ec33d03e6dd','209476bb-91ae-11ed-a752-9ec33d03e6dd','2023-01-11 12:47:52'),(662,'35a9ff3d-8070-11ea-947d-226cec7cb58a','35adf938-8070-11ea-947d-226cec7cb58a','2020-04-17 05:56:52'),(662,'35a9ff3d-8070-11ea-947d-226cec7cb58a','35b24728-8070-11ea-947d-226cec7cb58a','2020-04-17 05:56:52'),(662,'35a9ff3d-8070-11ea-947d-226cec7cb58a','35b42350-8070-11ea-947d-226cec7cb58a','2020-04-17 05:56:52'),(662,'35a9ff3d-8070-11ea-947d-226cec7cb58a','35b5d98f-8070-11ea-947d-226cec7cb58a','2020-04-17 05:56:52'),(662,'35a9ff3d-8070-11ea-947d-226cec7cb58a','35b772cc-8070-11ea-947d-226cec7cb58a','2020-04-17 05:56:52'),(662,'35a9ff3d-8070-11ea-947d-226cec7cb58a','35b92b48-8070-11ea-947d-226cec7cb58a','2020-04-17 05:56:52'),(662,'35a9ff3d-8070-11ea-947d-226cec7cb58a','35bad668-8070-11ea-947d-226cec7cb58a','2020-04-17 05:56:52'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','38709a56-7ee2-11ea-947d-226cec7cb58a','2020-04-15 06:27:59'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','38724456-7ee2-11ea-947d-226cec7cb58a','2020-04-15 06:27:59'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','3873da60-7ee2-11ea-947d-226cec7cb58a','2020-04-15 06:27:59'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','38756f28-7ee2-11ea-947d-226cec7cb58a','2020-04-15 06:27:59'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','387709c6-7ee2-11ea-947d-226cec7cb58a','2020-04-15 06:27:59'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','3878b044-7ee2-11ea-947d-226cec7cb58a','2020-04-15 06:27:59'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','387a5afb-7ee2-11ea-947d-226cec7cb58a','2020-04-15 06:27:59'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','387be67d-7ee2-11ea-947d-226cec7cb58a','2020-04-15 06:27:59'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','387eea3c-7ee2-11ea-947d-226cec7cb58a','2020-04-15 06:27:59'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','388324cf-7ee2-11ea-947d-226cec7cb58a','2020-04-15 06:27:59'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','3884bf44-7ee2-11ea-947d-226cec7cb58a','2020-04-15 06:27:59'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','3886abd6-7ee2-11ea-947d-226cec7cb58a','2020-04-15 06:27:59'),(662,'3f38add5-157f-11ed-a752-9ec33d03e6dd','3f3f465f-157f-11ed-a752-9ec33d03e6dd','2022-08-06 11:59:41'),(662,'3f38add5-157f-11ed-a752-9ec33d03e6dd','3f421d14-157f-11ed-a752-9ec33d03e6dd','2022-08-06 11:59:41'),(662,'5d45f086-f650-11ec-a752-9ec33d03e6dd','5d47b05f-f650-11ec-a752-9ec33d03e6dd','2022-06-27 19:35:56'),(662,'5d45f086-f650-11ec-a752-9ec33d03e6dd','5d497163-f650-11ec-a752-9ec33d03e6dd','2022-06-27 19:35:56'),(662,'75fb40f5-5c35-11ed-a752-9ec33d03e6dd','75fe196b-5c35-11ed-a752-9ec33d03e6dd','2022-11-04 11:40:23'),(662,'75fb40f5-5c35-11ed-a752-9ec33d03e6dd','760044a3-5c35-11ed-a752-9ec33d03e6dd','2022-11-04 11:40:23'),(662,'75fb40f5-5c35-11ed-a752-9ec33d03e6dd','7601ed6f-5c35-11ed-a752-9ec33d03e6dd','2022-11-04 11:40:23'),(662,'75fb40f5-5c35-11ed-a752-9ec33d03e6dd','76038e2c-5c35-11ed-a752-9ec33d03e6dd','2022-11-04 11:40:23'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8ccfb1b3-7ee5-11ea-947d-226cec7cb58a','2020-04-15 06:51:48'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cd19241-7ee5-11ea-947d-226cec7cb58a','2020-04-15 06:51:48'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cd31395-7ee5-11ea-947d-226cec7cb58a','2020-04-15 06:51:48'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cd499d6-7ee5-11ea-947d-226cec7cb58a','2020-04-15 06:51:48'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cd690e5-7ee5-11ea-947d-226cec7cb58a','2020-04-15 06:51:48'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cd829cd-7ee5-11ea-947d-226cec7cb58a','2020-04-15 06:51:48'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cda0313-7ee5-11ea-947d-226cec7cb58a','2020-04-15 06:51:48'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cdbafa2-7ee5-11ea-947d-226cec7cb58a','2020-04-15 06:51:48'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cdd4be9-7ee5-11ea-947d-226cec7cb58a','2020-04-15 06:51:48'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cdf1358-7ee5-11ea-947d-226cec7cb58a','2020-04-15 06:51:48'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8ce0b716-7ee5-11ea-947d-226cec7cb58a','2020-04-15 06:51:48'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8ce28649-7ee5-11ea-947d-226cec7cb58a','2020-04-15 06:51:48'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8ea06518-4b8a-11ec-9377-226cec7cb58a','2021-11-22 11:51:41'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8ea38ac2-4b8a-11ec-9377-226cec7cb58a','2021-11-22 11:51:41'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8ea64d2c-4b8a-11ec-9377-226cec7cb58a','2021-11-22 11:51:41'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8ea9bac9-4b8a-11ec-9377-226cec7cb58a','2021-11-22 11:51:41'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8eaccb00-4b8a-11ec-9377-226cec7cb58a','2021-11-22 11:51:41'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8eb12471-4b8a-11ec-9377-226cec7cb58a','2021-11-22 11:51:41'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8eb7bfec-4b8a-11ec-9377-226cec7cb58a','2021-11-22 11:51:41'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8ebeca38-4b8a-11ec-9377-226cec7cb58a','2021-11-22 11:51:41'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8ec375cf-4b8a-11ec-9377-226cec7cb58a','2021-11-22 11:51:43'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8ec747f5-4b8a-11ec-9377-226cec7cb58a','2021-11-22 11:51:43'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','94c77f29-2b59-11ec-9377-226cec7cb58a','2021-10-12 12:40:32'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','94cb30f9-2b59-11ec-9377-226cec7cb58a','2021-10-12 12:40:32'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','94ce93c7-2b59-11ec-9377-226cec7cb58a','2021-10-12 12:40:32'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','94e9a15c-2b59-11ec-9377-226cec7cb58a','2021-10-12 12:40:32'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','94eeedbf-2b59-11ec-9377-226cec7cb58a','2021-10-12 12:40:32'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','94fc41f3-2b59-11ec-9377-226cec7cb58a','2021-10-12 12:40:32'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','94ffa87d-2b59-11ec-9377-226cec7cb58a','2021-10-12 12:40:32'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','9511cb22-2b59-11ec-9377-226cec7cb58a','2021-10-12 12:40:32'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','9514c875-2b59-11ec-9377-226cec7cb58a','2021-10-12 12:40:32'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','95181c09-2b59-11ec-9377-226cec7cb58a','2021-10-12 12:40:32'),(662,'97fbb232-3417-11ed-a752-9ec33d03e6dd','97fdea91-3417-11ed-a752-9ec33d03e6dd','2022-09-14 10:25:51'),(662,'97fbb232-3417-11ed-a752-9ec33d03e6dd','97ff66d6-3417-11ed-a752-9ec33d03e6dd','2022-09-14 10:25:51'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9d391dc-72d3-11ec-9377-226cec7cb58a','2022-01-11 11:43:43'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9d5de8c-72d3-11ec-9377-226cec7cb58a','2022-01-11 11:43:43'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9d854a5-72d3-11ec-9377-226cec7cb58a','2022-01-11 11:43:43'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9da69b7-72d3-11ec-9377-226cec7cb58a','2022-01-11 11:43:43'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9dc2b5e-72d3-11ec-9377-226cec7cb58a','2022-01-11 11:43:43'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9de0e95-72d3-11ec-9377-226cec7cb58a','2022-01-11 11:43:43'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9e0e714-72d3-11ec-9377-226cec7cb58a','2022-01-11 11:43:43'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9e39911-72d3-11ec-9377-226cec7cb58a','2022-01-11 11:43:43'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9e5d1e0-72d3-11ec-9377-226cec7cb58a','2022-01-11 11:43:43'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9e83025-72d3-11ec-9377-226cec7cb58a','2022-01-11 11:43:43'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c2475b5d-1f8a-11ec-9377-226cec7cb58a','2021-09-27 12:02:23'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c24a06b2-1f8a-11ec-9377-226cec7cb58a','2021-09-27 12:02:23'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c24da80c-1f8a-11ec-9377-226cec7cb58a','2021-09-27 12:02:23'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c2503be7-1f8a-11ec-9377-226cec7cb58a','2021-09-27 12:02:23'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c25432d6-1f8a-11ec-9377-226cec7cb58a','2021-09-27 12:02:23'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c2574ae3-1f8a-11ec-9377-226cec7cb58a','2021-09-27 12:02:23'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c25a1819-1f8a-11ec-9377-226cec7cb58a','2021-09-27 12:02:23'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c25cb650-1f8a-11ec-9377-226cec7cb58a','2021-09-27 12:02:23'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c25f3035-1f8a-11ec-9377-226cec7cb58a','2021-09-27 12:02:23'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c2617b6f-1f8a-11ec-9377-226cec7cb58a','2021-09-27 12:02:23'),(662,'dd1a3f6f-c7db-11ed-9ced-0050569a5229','dd1d9407-c7db-11ed-9ced-0050569a5229','2023-03-21 11:31:05'),(662,'dd1a3f6f-c7db-11ed-9ced-0050569a5229','dd202b6b-c7db-11ed-9ced-0050569a5229','2023-03-21 11:31:05'),(662,'deed6e05-f711-11ec-a752-9ec33d03e6dd','def017c4-f711-11ec-a752-9ec33d03e6dd','2022-06-28 18:41:11'),(662,'deed6e05-f711-11ec-a752-9ec33d03e6dd','def1623b-f711-11ec-a752-9ec33d03e6dd','2022-06-28 18:41:11'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e0880d3b-5ad5-11ed-a752-9ec33d03e6dd','2022-11-02 17:43:36'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e0898270-5ad5-11ed-a752-9ec33d03e6dd','2022-11-02 17:43:36'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e08b1d8c-5ad5-11ed-a752-9ec33d03e6dd','2022-11-02 17:43:36'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e08c98f8-5ad5-11ed-a752-9ec33d03e6dd','2022-11-02 17:43:36'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e08dfb34-5ad5-11ed-a752-9ec33d03e6dd','2022-11-02 17:43:36'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e08f638b-5ad5-11ed-a752-9ec33d03e6dd','2022-11-02 17:43:36'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e0909d5b-5ad5-11ed-a752-9ec33d03e6dd','2022-11-02 17:43:36'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e0920e08-5ad5-11ed-a752-9ec33d03e6dd','2022-11-02 17:43:36'),(662,'eaa8869e-7d4b-11ea-947d-226cec7cb58a','eaabd852-7d4b-11ea-947d-226cec7cb58a','2020-04-13 05:59:31'),(662,'eaa8869e-7d4b-11ea-947d-226cec7cb58a','eaadb843-7d4b-11ea-947d-226cec7cb58a','2020-04-13 05:59:31'),(662,'eaa8869e-7d4b-11ea-947d-226cec7cb58a','eaaf475d-7d4b-11ea-947d-226cec7cb58a','2020-04-13 05:59:31'),(662,'eaa8869e-7d4b-11ea-947d-226cec7cb58a','eab0f62d-7d4b-11ea-947d-226cec7cb58a','2020-04-13 05:59:31'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f24be2c4-4c4f-11ec-9377-226cec7cb58a','2021-11-23 11:24:45'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f26a7348-4c4f-11ec-9377-226cec7cb58a','2021-11-23 11:24:45'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f26e9ce0-4c4f-11ec-9377-226cec7cb58a','2021-11-23 11:24:45'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f271870f-4c4f-11ec-9377-226cec7cb58a','2021-11-23 11:24:45'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f2745c07-4c4f-11ec-9377-226cec7cb58a','2021-11-23 11:24:45'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f2781fff-4c4f-11ec-9377-226cec7cb58a','2021-11-23 11:24:45'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f27b8845-4c4f-11ec-9377-226cec7cb58a','2021-11-23 11:24:45'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f27e89e8-4c4f-11ec-9377-226cec7cb58a','2021-11-23 11:24:45'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f28192d9-4c4f-11ec-9377-226cec7cb58a','2021-11-23 11:24:45'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f28655e5-4c4f-11ec-9377-226cec7cb58a','2021-11-23 11:24:45');
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedMessage` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT '0',
  `messageSubject` varchar(45) NOT NULL,
  `body` text,
  `fromID` mediumint unsigned NOT NULL,
  `originMessageID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `discussionID` char(36) NOT NULL,
  `readStatus` enum('Read','Unread') DEFAULT 'Unread',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ReceivedMessage_Discussion` (`discussionID`,`ownerID`),
  CONSTRAINT `fk_ReceivedMessage_Discussion` FOREIGN KEY (`discussionID`, `ownerID`) REFERENCES `Discussion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
INSERT INTO `ReceivedMessage` VALUES (662,'1cc1a348-7d48-11ea-947d-226cec7cb58a','2020-04-12 08:29:35',1,'#','#',662,NULL,NULL,'2020-04-13 07:33:58','2020-04-13 05:33:58','2020-04-13 07:33:57','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'1ced8cbe-7d48-11ea-947d-226cec7cb58a','2020-04-12 08:17:05',1,'#','Test',662,NULL,NULL,'2020-04-13 07:33:57','2020-04-13 05:33:57','2020-04-13 07:33:57','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'1d1ad35b-7d48-11ea-947d-226cec7cb58a','2020-04-12 08:28:42',1,'#','Commande n° 1.2.3.1',662,NULL,NULL,'2020-04-13 07:33:57','2020-04-13 05:33:57','2020-04-13 07:33:57','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'1e334837-8121-11ed-a752-9ec33d03e6dd','2022-12-21 12:18:09',1,'#','SMILERS n° 1.21.6.S1',662,NULL,NULL,'2023-03-21 12:07:01','2023-03-21 11:07:01','2023-03-21 12:07:01','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'208fe542-91ae-11ed-a752-9ec33d03e6dd','2023-01-11 13:47:50',1,'#','SMILERS n° 1.21.7.S1',662,NULL,NULL,'2023-03-21 12:07:01','2023-03-21 11:07:01','2023-03-21 12:07:01','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'35a9ff3d-8070-11ea-947d-226cec7cb58a','2020-04-17 07:56:50',1,'#','Commande n° 1.6.1.1',662,NULL,NULL,'2020-04-17 11:23:37','2020-04-17 09:23:37','2020-04-17 11:23:37','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','2020-04-15 08:27:55',1,'#','Commande n° 1.7.2.1',662,NULL,NULL,'2020-04-15 08:28:22','2020-04-15 06:28:22','2020-04-15 08:28:21','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'3f38add5-157f-11ed-a752-9ec33d03e6dd','2022-08-06 13:59:37',1,'#','SMILERS n° 1.20.2.S1',662,NULL,NULL,'2022-09-19 14:36:13','2022-09-19 12:36:13','2022-09-19 14:36:12','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'5d45f086-f650-11ec-a752-9ec33d03e6dd','2022-06-27 21:35:57',1,'#','SMILERS n° 1.21.2.S1',662,NULL,NULL,'2022-09-19 14:36:13','2022-09-19 12:36:13','2022-09-19 14:36:12','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'75fb40f5-5c35-11ed-a752-9ec33d03e6dd','2022-11-04 12:40:19',1,'#','SMILERS n° 1.21.4.S1',662,NULL,NULL,'2022-12-14 14:59:47','2022-12-14 13:59:47','2022-11-04 13:49:15','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','2020-04-15 08:51:45',1,'#','Commande n° 1.7.2.2',662,NULL,NULL,'2020-04-15 08:52:44','2020-04-15 06:52:44','2020-04-15 08:52:44','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','2021-11-22 12:51:41',1,'#','SMILERS n° 1.21.1.S1',662,NULL,NULL,'2021-11-23 11:57:30','2021-11-23 10:57:30','2021-11-23 11:57:30','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','2021-10-12 14:40:29',1,'#','SMILERS n° 1.20.1.S1',662,NULL,NULL,'2021-10-12 14:40:32','2021-10-12 12:40:32','2021-10-12 14:40:32','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'97fbb232-3417-11ed-a752-9ec33d03e6dd','2022-09-14 12:25:45',1,'#','SMILERS n° 1.21.3.S1',662,NULL,NULL,'2022-09-19 14:36:12','2022-09-19 12:36:12','2022-09-19 14:36:12','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','2022-01-11 12:43:42',1,'#','SMILERS n° 1.23.1.S1',662,NULL,NULL,'2022-06-27 21:27:09','2022-06-27 19:27:09','2022-06-10 19:55:18','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','2021-09-27 14:02:16',1,'#','SMILERS n° 1.19.1.S1',662,NULL,NULL,'2021-10-12 14:27:28','2021-10-12 12:27:28','2021-10-12 14:27:28','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'dd1a3f6f-c7db-11ed-9ced-0050569a5229','2023-03-21 12:31:05',1,'#','SMILERS n° 1.19.4.S1',662,NULL,NULL,'2023-03-21 12:31:05','2023-04-11 18:56:27','2023-04-11 20:56:27','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'deed6e05-f711-11ec-a752-9ec33d03e6dd','2022-06-28 20:41:06',1,'#','SMILERS n° 1.19.2.S1',662,NULL,NULL,'2022-09-19 14:36:13','2022-09-19 12:36:13','2022-09-19 14:36:12','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','2022-11-02 18:43:35',1,'#','SMILERS n° 1.19.3.S1',662,NULL,NULL,'2022-11-02 18:43:57','2022-11-02 17:43:57','2022-11-02 18:43:56','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'eaa8869e-7d4b-11ea-947d-226cec7cb58a','2020-04-13 07:59:29',1,'#','Commande n° 1.2.2.2',662,NULL,NULL,'2020-04-13 07:59:31','2020-04-13 05:59:31','2020-04-13 07:59:31','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','2021-11-23 12:24:38',1,'#','SMILERS n° 1.22.1.S1',662,NULL,NULL,'2022-06-27 21:27:09','2022-06-27 19:27:09','2022-06-10 19:55:18','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','Read');
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Scan` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `scanType` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') DEFAULT 'MAXILLAIRE',
  `comments` mediumtext,
  `cameraX` decimal(10,0) DEFAULT NULL,
  `cameraY` decimal(10,0) DEFAULT NULL,
  `cameraZ` decimal(10,0) DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `validated` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('in_progress','none') NOT NULL DEFAULT 'in_progress',
  `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `sessionID` char(36) DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Scan_Work` (`ownerID`),
  KEY `fk_Scan_Session` (`sessionID`,`ownerID`),
  CONSTRAINT `fk_Scan_Session` FOREIGN KEY (`sessionID`, `ownerID`) REFERENCES `Session` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
INSERT INTO `Scan` VALUES (662,'005e76e3-5a05-4d7a-b0cf-6c2c7adcc1a9','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-06 11:40:52','2020-04-06 11:41:19',NULL,'2020-12-15 14:15:36','2020-04-06 11:40:52','296c061e-734b-4936-8af7-1f80653eff11',5,1),(662,'00f07cdc-1834-4ae1-a9fa-47699828c094','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-10-12 12:38:33',NULL,'2021-10-12 14:34:20','2021-10-12 12:34:20','2021-10-12 12:40:26','b29b47d4-35f8-427d-9cd7-a393e48be2cf',1,1),(662,'0198b882-42bb-4c93-b173-3f7c572c22b5','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-06 11:18:45','2020-04-06 11:29:27',NULL,'2020-12-15 14:15:36','2020-04-06 11:18:45','296c061e-734b-4936-8af7-1f80653eff11',1,1),(662,'019e5bd1-9330-4e70-8035-2fda343b0231','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-09-27 12:10:35',NULL,'2021-09-27 14:02:02','2021-09-27 12:02:02','2021-09-27 12:26:09','6c6bb813-840d-454a-ab1d-9232434a4500',1,1),(662,'066779ab-556d-4237-bd2a-be49882d249c','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2020-12-29 08:34:35','2020-12-29 08:34:38',NULL,'2020-12-29 07:34:38','2020-12-29 08:34:35','88170486-b19f-4c31-a435-e67fd24917e9',2,1),(662,'085eb227-c20a-4e2d-8f5e-3267070c23a2','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2020-12-21 18:20:19','2020-12-21 18:20:42',NULL,'2020-12-21 17:20:42','2020-12-21 18:20:19','becee89b-0c0c-4888-bd78-43480d883b03',1,1),(662,'0a4e2bba-8cdb-4c4c-8a8d-a6f2b7de0f40','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-10 11:42:02','2020-04-10 11:47:08',NULL,'2020-12-15 14:15:36','2020-04-10 11:42:02','bdf42f40-5a7a-435b-a5e0-eb33efefbc97',1,1),(662,'0a606279-3c91-4220-b876-e620d1bf52f6','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-18 09:32:13',NULL,'2021-06-08 19:43:37','2021-06-08 17:43:37','2020-04-18 09:32:13','daf632b1-2c49-42c8-8899-0a0b2448bc3a',1,1),(662,'0b6ec729-5c4e-4869-9d67-6377923ed207','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-07 07:26:14','2020-04-14 12:10:38','2020-04-07 07:27:30','2020-12-15 14:15:36','2020-04-07 07:26:14','2b934532-4b04-4025-8e7f-894c9c01b184',1,1),(662,'0c8af1cb-8054-4a35-9cfe-449c19dbe59b','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-16 07:10:45','2020-04-16 11:39:43','2020-04-16 07:11:35','2020-12-15 14:15:36','2020-04-16 07:10:45','bef02815-bbf7-4520-882b-2396474f4bb3',2,1),(662,'0d792709-57f3-49e1-963c-d2dc35a59d12','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-27 10:53:23',NULL,'2021-02-27 10:59:00','2021-02-27 09:59:00','2021-02-27 10:55:30','484ae4d8-329f-49b5-8d83-312a8a92ff22',1,1),(662,'0e5656e0-946b-41b2-935b-ea820746e5a9','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2023-03-21 12:12:00',NULL,'2023-03-21 12:30:59','2023-03-21 11:30:59','2023-03-21 12:27:29','d70cc224-5e0d-4b47-9270-d8e23a25b566',1,1),(662,'0f18aace-5cf2-4d46-b56f-f8dc123e1f91','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-11-23 12:19:47',NULL,'2021-11-23 12:23:20','2021-11-23 11:23:20','2021-11-23 12:21:30','31210683-bc06-4b84-83d9-ce60f32308e4',2,1),(662,'107f2922-62ee-42d9-8e35-69d71587db0b','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-05-21 08:13:17',NULL,'2021-03-19 10:24:46','2021-03-19 09:24:46','2020-05-21 08:13:17','254f3fc9-4782-4658-bb34-f2ca1c9b6382',2,1),(662,'10c9626c-901e-4a0e-8f05-62042bf69c04','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-16 11:14:30',NULL,'2021-03-19 10:22:16','2021-03-19 09:22:16','2020-04-16 11:14:30','e06b73d5-45f7-4906-ba73-560d66ac56af',1,1),(662,'12f64013-f8aa-44bb-91e8-38c23737152b','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-29 14:50:37',NULL,'2021-03-19 10:22:24','2021-03-19 09:22:24','2020-04-29 14:50:37','348477f7-c7a9-4bb3-8b28-3da592902286',1,1),(662,'13e9c4af-5ddc-4a12-ae1b-2b802c735c3f','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-18 09:37:59',NULL,'2021-06-08 19:43:35','2021-06-08 17:43:35','2020-04-18 09:37:59','daf632b1-2c49-42c8-8899-0a0b2448bc3a',1,1),(662,'16cf8664-2af0-446a-ac6d-ef0e40edb71d','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-18 09:35:44',NULL,'2021-06-08 19:43:36','2021-06-08 17:43:36','2020-04-18 09:35:44','daf632b1-2c49-42c8-8899-0a0b2448bc3a',1,1),(662,'18365744-4019-43e1-933f-9fa52db1a30d','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-06-08 20:51:55',NULL,'2021-06-08 20:57:43','2021-06-08 18:57:43','2021-06-08 20:56:54','16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c',1,1),(662,'19627cd9-e6e6-4c6f-9a62-46d708ca49bc','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-27 10:27:21',NULL,'2021-02-27 10:48:14','2021-02-27 09:48:14','2021-02-27 10:43:31','484ae4d8-329f-49b5-8d83-312a8a92ff22',1,1),(662,'1bb0385c-ad64-4ddb-af9d-970d6d0e6217','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-30 19:38:11','2020-04-30 19:40:01',NULL,'2020-12-15 14:15:36','2020-04-30 19:38:11','d402edb5-8449-46a8-862f-a1cd1ee21cf6',1,1),(662,'1c636d2a-ce13-48c7-976b-fa1f3cae798f','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-06 11:41:34','2021-03-19 10:22:13','2021-03-19 10:22:13','2021-03-19 09:22:13','2020-04-06 11:41:34','296c061e-734b-4936-8af7-1f80653eff11',6,1),(662,'1c6adc05-0655-4ad6-bcc9-27b0ef578ded','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-06-28 20:03:47',NULL,'2022-06-28 20:40:57','2022-06-28 18:40:57','2022-06-28 20:39:41','ed8b4bd5-0a61-4563-b6a4-6ec124bc388d',1,1),(662,'1e8824f7-3c76-4fe0-bd8c-f865f725dab2','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-11-23 12:21:40',NULL,'2021-11-23 12:24:17','2021-11-23 11:24:17','2021-11-23 12:23:17','31210683-bc06-4b84-83d9-ce60f32308e4',1,1),(662,'209f3c55-7380-4efa-8e6c-dfe8c99792a6','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2023-01-11 12:12:57',NULL,'2023-01-11 13:47:44','2023-01-11 12:47:44','2023-01-11 12:58:29','983c39b6-656b-4bf2-bf43-da1625adb861',1,1),(662,'254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-08-06 13:47:10',NULL,'2022-08-06 13:58:03','2022-08-06 11:58:03','2022-08-06 13:56:38','f72f6016-0f75-4789-9924-1bc9aa64c2f1',1,1),(662,'26a765d3-8b92-4861-984a-bd9c8040209b','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-03-11 10:14:03',NULL,'2022-03-11 10:32:40','2022-03-11 09:32:40','2022-03-11 10:31:25','5f895907-3eed-4aa7-995a-f7e1c9661a0a',1,1),(662,'2a466f6b-3960-4b1b-bb27-def76229cccc','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-11-04 12:14:24',NULL,'2022-11-04 12:40:15','2022-11-04 11:40:15','2022-11-04 12:31:51','5bd97219-8b9e-46f5-ab9b-87ded07aa8a2',1,1),(662,'2ab117e1-acf7-41d0-8ec8-d7f769012bf5','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-04-25 11:19:36','2021-04-25 11:28:19',NULL,'2021-04-25 09:28:19','2021-04-25 11:19:36','96e43a62-294d-4726-8ccf-ea4ec6e66267',1,1),(662,'2bf301a3-b61c-4ddd-b6a2-4924c804d5f8','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-10 11:51:27',NULL,'2021-03-19 10:22:19','2021-03-19 09:22:19','2020-04-10 11:51:27','bdf42f40-5a7a-435b-a5e0-eb33efefbc97',3,1),(662,'2d566d37-f38f-4b79-ac8f-48009ae22310','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-10 11:37:06',NULL,'2021-03-19 10:22:20','2021-03-19 09:22:20','2020-04-10 11:37:06','bdf42f40-5a7a-435b-a5e0-eb33efefbc97',1,1),(662,'2e1e941f-909d-4203-8cb9-80d5f146fca1','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-07 07:05:43','2020-04-07 07:05:47',NULL,'2020-12-15 14:15:36','2020-04-07 07:05:43','c9d37315-5f17-421c-8afb-302fa9b0bebe',3,1),(662,'34f5d93d-6a1f-4f94-ab20-4105c2cce30a','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-06-08 20:20:25','2021-06-08 20:41:12','2021-06-08 20:41:12','2021-06-08 18:41:12','2021-06-08 20:31:01','16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c',1,1),(662,'375f8fb7-d198-4281-9948-bba81b98e824','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-10 07:44:51',NULL,'2021-03-19 10:22:30','2021-03-19 09:22:30','2020-04-10 07:44:51','ada38401-e257-4f32-8319-c7a394ce4463',1,1),(662,'37ff1278-3dd1-470a-8159-e763f6626f5d','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-17 11:12:11',NULL,'2021-03-19 10:22:22','2021-03-19 09:22:22','2020-04-17 11:12:11','a18ca6df-d765-4c6a-be28-13abd1c350af',1,1),(662,'380086c3-2ecb-4345-b6d0-f476fb97c3f9','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-06 11:32:40','2020-04-06 11:35:12',NULL,'2020-12-15 14:15:36','2020-04-06 11:32:40','296c061e-734b-4936-8af7-1f80653eff11',4,1),(662,'3a315f7b-8cf2-4d0c-bf92-fecb623fe530','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-09-14 12:11:22',NULL,'2022-09-14 12:25:38','2022-09-14 10:25:38','2022-09-14 12:23:55','09f15124-6bba-4565-bfe4-efb3c6c3a17d',1,1),(662,'3d3ae697-dc08-4ce2-8b32-4f79891607c2','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-11-22 12:47:39',NULL,'2021-11-22 12:51:37','2021-11-22 11:51:37','2021-11-22 12:49:43','52372fba-991e-4b09-abce-2195e775fd19',1,1),(662,'3e1d8e57-feae-45d6-80f0-9d0be041ff7a','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-09-19 10:52:16',NULL,'2022-09-19 11:55:17','2022-09-19 09:55:17','2022-09-19 11:48:35','20b31e3a-565c-49b0-b2ff-0dae86b25c76',1,1),(662,'41b8d05c-738b-4161-9f86-27222b61ad66','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-06-08 20:47:04',NULL,'2021-06-08 20:49:16','2021-06-08 18:49:16','2021-06-08 20:48:52','16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c',1,1),(662,'42b09cf6-e30d-4d35-a17d-d8e8b4564638','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-10-12 12:26:42',NULL,'2021-10-12 14:40:06','2021-10-12 12:40:06','2021-10-12 12:37:46','b29b47d4-35f8-427d-9cd7-a393e48be2cf',1,1),(662,'437ef945-eb42-4841-9b20-34804bd5cfd6','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-06-08 20:31:23',NULL,'2021-06-08 20:48:54','2021-06-08 18:48:54','2021-06-08 20:46:42','16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c',2,1),(662,'4447c001-b4b0-486d-bbde-a9eae11f083f','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-10 11:47:36','2020-04-10 11:47:44',NULL,'2020-12-15 14:15:36','2020-04-10 11:47:36','bdf42f40-5a7a-435b-a5e0-eb33efefbc97',2,1),(662,'44b8a221-3707-430b-bc84-cacca7bf7d8a','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-06-08 20:49:32',NULL,'2021-06-08 20:56:55','2021-06-08 18:56:55','2021-06-08 20:51:49','16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c',1,1),(662,'44ccf5f6-834d-4090-88dc-399b19fed47e','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-16 13:00:27',NULL,'2021-02-16 13:05:37','2021-02-16 12:05:37','2021-02-16 13:05:09','c6fffa68-cc65-471a-a58e-135ebe4d0772',1,1),(662,'453abb20-3827-4f8b-b57f-c656c72ebf11','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-10-12 12:15:50',NULL,'2021-10-12 14:40:26','2021-10-12 12:40:26','2021-10-12 12:26:35','b29b47d4-35f8-427d-9cd7-a393e48be2cf',1,1),(662,'45b21304-1129-40a2-b60e-d72a2bf96e72','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-12 08:05:51','2020-09-09 19:48:14','2020-04-13 07:34:24','2020-12-15 14:15:36','2020-04-12 08:05:51','2ed4960a-e6fa-46de-a306-32385df3346c',1,1),(662,'470d4798-40ea-4ce5-a574-22fcf013d82d','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-16 11:17:29',NULL,'2021-03-19 10:22:17','2021-03-19 09:22:17','2020-04-16 11:17:29','e06b73d5-45f7-4906-ba73-560d66ac56af',1,1),(662,'4a2eec76-a5f3-44f0-b389-4734998fa2d3','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2020-12-29 11:13:49',NULL,'2021-06-08 19:45:19','2021-06-08 17:45:19','2020-12-29 11:28:33','b87f1382-55d4-4e52-b63a-6f387df18b16',1,1),(662,'4c0a0af6-4d22-42cf-a5ab-c6eb058dec60','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-07 07:11:31','2020-04-07 07:11:35',NULL,'2020-12-15 14:15:36','2020-04-07 07:11:31','c9d37315-5f17-421c-8afb-302fa9b0bebe',8,1),(662,'4caeed6a-b015-4556-8794-2c3a00fea341','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-05-21 08:03:20','2021-03-19 10:22:13','2021-03-19 10:22:13','2021-03-19 09:22:13','2020-05-21 08:03:20','254f3fc9-4782-4658-bb34-f2ca1c9b6382',1,1),(662,'50e1896b-8565-4257-9a61-2a685fff8165','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-09-27 12:26:20',NULL,'2021-09-27 14:02:12','2021-09-27 12:02:12','2021-09-27 12:43:43','6c6bb813-840d-454a-ab1d-9232434a4500',1,1),(662,'527c942e-3aa0-4028-b02a-8b3f137657be','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-27 16:19:07','2020-04-27 16:48:49','2020-04-27 16:48:49','2020-12-15 14:15:36','2020-04-27 16:19:07','8d012545-b857-4595-a69d-1a2b1c750e13',1,1),(662,'534cca35-8182-4f61-aa57-03bad8172eac','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2020-12-29 11:33:17',NULL,'2021-06-08 19:45:18','2021-06-08 17:45:18','2020-12-29 11:37:09','b87f1382-55d4-4e52-b63a-6f387df18b16',1,1),(662,'55058b25-acc2-43c3-b9d2-b8bb64bfcbb9','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-18 09:33:55',NULL,'2021-06-08 19:43:37','2021-06-08 17:43:37','2020-04-18 09:33:55','daf632b1-2c49-42c8-8899-0a0b2448bc3a',1,1),(662,'57cfef6d-c27e-45fa-81d7-e63b4f8c4429','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-10 11:41:52',NULL,'2021-03-19 10:22:19','2021-03-19 09:22:19','2020-04-10 11:41:52','bdf42f40-5a7a-435b-a5e0-eb33efefbc97',1,1),(662,'57e7671e-1671-4ee9-96a0-650a56963aa8','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-27 10:55:32',NULL,'2021-02-27 10:59:48','2021-02-27 09:59:48','2021-02-27 10:59:00','484ae4d8-329f-49b5-8d83-312a8a92ff22',1,1),(662,'5a4f6b62-6381-4a1e-bbef-61746f2722d3','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-01-11 12:39:06',NULL,'2022-01-11 12:43:37','2022-01-11 11:43:37','2022-01-11 12:41:15','12115366-8eb9-470b-a097-5d28bb5fdf38',1,1),(662,'5a59f382-4b59-4867-8640-021d20bdcd59','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-11-02 12:35:04',NULL,'2022-11-02 15:09:59','2022-11-02 14:09:59','2022-11-02 12:36:21','b5b4db66-f433-46fb-b794-d632b8fe8e1d',1,1),(662,'5a5e6904-4736-4443-bbd0-be73066af8c3','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-14 12:10:37','2020-04-16 11:39:43','2020-04-15 07:01:18','2020-12-15 14:15:36','2020-04-14 12:10:37','f7b71416-57aa-4d3d-a2e5-0e6c1519f6e8',1,1),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-01 20:11:38',NULL,'2021-02-01 21:04:35','2021-02-01 20:04:35','2021-02-01 20:56:52','1ec1f707-d702-496a-b2f0-e55b08c06dcb',1,1),(662,'6445b6e3-0c4a-44d3-84e8-7f315911b8ee','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-07-08 19:54:07','2020-07-08 19:59:48',NULL,'2020-12-15 14:15:36','2020-07-08 19:54:07','53a17fdc-5de8-45aa-a9cb-ebea4886f6ff',2,1),(662,'65315958-b964-4f7e-a111-9c7695d8092b','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-17 11:14:15',NULL,'2021-03-19 10:22:23','2021-03-19 09:22:23','2020-04-17 11:14:15','a18ca6df-d765-4c6a-be28-13abd1c350af',1,1),(662,'68be6188-9e82-4de8-af30-5a19b2224813','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-07 07:11:24','2020-04-07 07:11:29',NULL,'2020-12-15 14:15:36','2020-04-07 07:11:24','c9d37315-5f17-421c-8afb-302fa9b0bebe',7,1),(662,'6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-15 07:39:22','2020-04-16 07:02:39','2020-04-16 07:02:39','2020-12-15 14:15:36','2020-04-15 07:39:22','bef02815-bbf7-4520-882b-2396474f4bb3',1,1),(662,'6ce24fb2-7744-476b-a643-7e304d3ac013','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-01-11 12:35:51',NULL,'2022-01-11 12:42:19','2022-01-11 11:42:19','2022-01-11 12:37:28','12115366-8eb9-470b-a097-5d28bb5fdf38',1,1),(662,'6fafe104-bdc1-41a6-9977-b1bbb351a329','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-07 06:42:43','2020-04-14 12:10:38','2020-04-07 06:44:04','2020-12-15 14:15:36','2020-04-07 06:42:43','c9d37315-5f17-421c-8afb-302fa9b0bebe',1,1),(662,'76ece440-81ad-42c8-ab91-f99fa29e2a83','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2023-04-11 20:33:25',NULL,NULL,'2023-04-11 18:49:14','2023-04-11 20:49:14','9e007066-06fd-4fa1-a49a-f1165de95f83',1,1),(662,'76f39717-6f88-4e19-800c-f827a697a4d6','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-16 07:21:50','2020-04-16 11:39:43','2020-04-16 07:22:38','2020-12-15 14:15:36','2020-04-16 07:21:50','bef02815-bbf7-4520-882b-2396474f4bb3',2,1),(662,'778a761c-339e-4143-a807-735b174d9714','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-15 07:35:10','2020-04-16 11:39:43','2020-04-15 07:37:23','2020-12-15 14:15:36','2020-04-15 07:35:10','bef02815-bbf7-4520-882b-2396474f4bb3',1,1),(662,'793e84ce-b088-458d-82f5-33fab1f5e7de','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-01-11 12:07:16',NULL,'2022-01-11 12:31:13','2022-01-11 11:31:13','2022-01-11 12:23:20','12115366-8eb9-470b-a097-5d28bb5fdf38',1,1),(662,'79548cb6-a61f-44cb-b6f7-cab7698f7465','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-01 21:09:48',NULL,'2021-02-01 21:19:46','2021-02-01 20:19:46','2021-02-01 21:15:43','1ec1f707-d702-496a-b2f0-e55b08c06dcb',1,1),(662,'7a39120e-2f79-4c3e-af4d-af72e8ca8062','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-16 12:53:10',NULL,'2021-02-16 13:05:09','2021-02-16 12:05:09','2021-02-16 13:00:23','c6fffa68-cc65-471a-a58e-135ebe4d0772',1,1),(662,'7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-01 21:15:51',NULL,'2021-02-01 21:22:34','2021-02-01 20:22:34','2021-02-01 21:19:46','1ec1f707-d702-496a-b2f0-e55b08c06dcb',1,1),(662,'7f9aec2d-6246-4413-842d-78d2e0bddb1e','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-12 07:48:43','2020-09-09 19:48:14','2020-04-12 08:05:53','2020-12-15 14:15:36','2020-04-12 07:48:43','78636467-a73b-4270-8bc5-35a2664dec9d',1,1),(662,'7fad3bba-f2b2-41ce-849b-756d995c0414','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-11 07:50:01',NULL,'2021-03-19 10:22:31','2021-03-19 09:22:31','2020-04-11 07:50:01','1a616ac1-2ca3-4d23-ae5e-349558c26c37',1,1),(662,'802e2d49-5b37-47b7-b8e9-4fb4bff1f62f','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-03-11 10:45:22',NULL,'2022-03-11 11:17:45','2022-03-11 10:17:45','2022-03-11 11:13:47','5f895907-3eed-4aa7-995a-f7e1c9661a0a',1,1),(662,'83a48470-7c96-4c50-a665-60e895c2708c','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-11-23 12:18:10','2021-11-23 12:19:10',NULL,'2021-11-23 11:19:10','2021-11-23 12:18:10','31210683-bc06-4b84-83d9-ce60f32308e4',1,1),(662,'84f6bd13-de48-43a0-9b1a-5d9c62048a82','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-09-09 19:35:53','2020-09-09 19:43:59',NULL,'2020-12-15 14:15:36','2020-09-09 19:35:53','86af9a1e-ac57-479e-b67e-5429fbdf4230',1,1),(662,'876f775b-e8a0-4b7f-bea0-0c93a7041d17','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2020-12-29 11:30:34',NULL,'2021-06-08 19:43:35','2021-06-08 17:43:35','2020-12-29 11:33:11','b87f1382-55d4-4e52-b63a-6f387df18b16',1,1),(662,'87a0a17a-c973-40c2-9d84-2392b0d62afb','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-30 19:37:49',NULL,'2021-09-27 13:56:30','2021-09-27 11:56:30','2020-04-30 19:37:49','d402edb5-8449-46a8-862f-a1cd1ee21cf6',1,1),(662,'881d38cc-cf89-4329-8456-b90f8c997725','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-10-12 12:42:48',NULL,'2021-10-12 14:35:19','2021-10-12 12:35:19','2021-10-12 12:44:17','b29b47d4-35f8-427d-9cd7-a393e48be2cf',1,1),(662,'89d67cc7-cbc8-46c7-a451-75d445a9af91','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-11 08:43:43','2020-04-11 09:01:22',NULL,'2020-12-15 14:15:36','2020-04-11 08:43:43','c17a41dd-a1dc-4b45-8bc4-cdaf9f8a6853',1,1),(662,'8a4f0a25-fae8-4564-8f4a-63f4168b2915','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-16 11:20:50',NULL,'2021-03-19 10:22:17','2021-03-19 09:22:17','2020-04-16 11:20:50','e06b73d5-45f7-4906-ba73-560d66ac56af',1,1),(662,'8cfba4c1-10f6-4525-a96d-8ea257cabbed','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-11 09:26:06','2020-04-11 10:15:29',NULL,'2020-12-15 14:15:36','2020-04-11 09:26:06','c17a41dd-a1dc-4b45-8bc4-cdaf9f8a6853',2,1),(662,'8ebe4133-539c-4684-9bfe-8633ad859097','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-11-04 13:31:22','2022-11-04 13:33:21',NULL,'2022-11-04 12:33:21','2022-11-04 13:31:22','a5bc2d6f-0248-466f-a10b-08f5391fd12f',1,1),(662,'919caf8c-919a-49cc-bf39-68486f2f5991','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-17 11:19:52',NULL,'2021-03-19 10:22:23','2021-03-19 09:22:23','2020-04-17 11:19:52','a18ca6df-d765-4c6a-be28-13abd1c350af',1,1),(662,'9716867f-e0a3-478a-a498-1e84ae803044','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-11-22 12:45:07',NULL,'2021-11-22 12:51:37','2021-11-22 11:51:37','2021-11-22 12:47:34','52372fba-991e-4b09-abce-2195e775fd19',1,1),(662,'98da8603-40b1-4492-92be-85b42b506cf9','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2020-12-29 08:33:15','2020-12-29 08:34:04',NULL,'2020-12-29 07:34:04','2020-12-29 08:33:15','88170486-b19f-4c31-a435-e67fd24917e9',1,1),(662,'98e7c216-5bb9-4127-9497-834796980370','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-11-23 12:01:35',NULL,'2021-11-23 12:14:26','2021-11-23 11:14:26','2021-11-23 12:08:22','31210683-bc06-4b84-83d9-ce60f32308e4',1,1),(662,'99102b35-9ad0-4017-b70e-fa08e5c36102','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-11-02 12:33:01',NULL,'2022-11-02 15:09:59','2022-11-02 14:09:59','2022-11-02 12:34:10','b5b4db66-f433-46fb-b794-d632b8fe8e1d',1,1),(662,'99a6d55d-de66-49eb-a717-49cb2587fbef','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-09-27 12:43:59',NULL,'2021-09-27 13:57:53','2021-09-27 11:57:53','2021-09-27 12:45:21','6c6bb813-840d-454a-ab1d-9232434a4500',1,1),(662,'a26f0d58-ca46-4921-a9e1-9c39b7f89783','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2020-12-29 10:54:22',NULL,'2020-12-30 07:12:48','2020-12-30 06:12:48','2020-12-29 11:13:14','b87f1382-55d4-4e52-b63a-6f387df18b16',1,1),(662,'a6d52fce-2e61-4375-bf6d-a36f9b3eb72f','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-10-12 12:40:31',NULL,'2021-10-12 14:35:19','2021-10-12 12:35:19','2021-10-12 12:42:39','b29b47d4-35f8-427d-9cd7-a393e48be2cf',1,1),(662,'a6db2dce-0918-4800-9732-7014e565533f','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-07 07:05:52','2020-04-07 07:05:58',NULL,'2020-12-15 14:15:36','2020-04-07 07:05:52','c9d37315-5f17-421c-8afb-302fa9b0bebe',4,1),(662,'a81e23d9-b3eb-48dd-8b7d-7b781fe29163','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-06 11:30:10','2020-04-06 11:30:41',NULL,'2020-12-15 14:15:36','2020-04-06 11:30:10','296c061e-734b-4936-8af7-1f80653eff11',3,1),(662,'a90158f7-0d39-4b9d-984b-57de06099c65','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-11-22 12:11:06',NULL,'2021-11-22 12:31:31','2021-11-22 11:31:31','2021-11-22 12:28:58','52372fba-991e-4b09-abce-2195e775fd19',1,1),(662,'a93c6a8f-0c96-47ae-bc72-75a725946a5a','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-30 20:08:27',NULL,'2021-09-27 13:56:31','2021-09-27 11:56:31','2020-04-30 20:08:27','d402edb5-8449-46a8-862f-a1cd1ee21cf6',1,1),(662,'ae5d20f8-815e-44c9-8e8e-a1894419791d','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-08 08:50:36','2020-04-08 08:51:36',NULL,'2020-12-15 14:15:36','2020-04-08 08:50:36','3d8aaee3-2fbd-43cd-8404-58e3f043e115',1,1),(662,'ae899af8-7040-48c9-a9b2-6ebc255ac7c9','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-16 12:05:06',NULL,'2021-02-16 12:40:35','2021-02-16 11:40:35','2021-02-16 12:19:21','c6fffa68-cc65-471a-a58e-135ebe4d0772',1,1),(662,'b002027b-930d-4b96-a687-453aeea5659e','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-12-21 12:01:15',NULL,'2022-12-21 12:18:01','2022-12-21 11:18:01','2022-12-21 12:14:32','ba7da56a-5a10-4378-a887-8e98aa892a3c',1,1),(662,'b24d4ab4-dba3-4be5-8ba3-7eee381f40ec','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-11-04 12:32:48',NULL,'2022-11-04 12:39:03','2022-11-04 11:39:03','2022-11-04 12:34:44','5bd97219-8b9e-46f5-ab9b-87ded07aa8a2',1,1),(662,'b289ff52-6765-45a7-b1e2-fe7161ba809f','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-18 09:26:04',NULL,'2021-06-08 19:43:35','2021-06-08 17:43:35','2020-04-18 09:26:04','daf632b1-2c49-42c8-8899-0a0b2448bc3a',2,1),(662,'b5005e42-2d4d-41b0-91d5-667275f3a9cc','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-30 20:00:05',NULL,'2021-09-27 13:56:32','2021-09-27 11:56:32','2020-04-30 20:00:05','d402edb5-8449-46a8-862f-a1cd1ee21cf6',1,1),(662,'b7931623-9b21-4440-a950-16565249bf9a','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-30 19:58:00',NULL,'2021-09-27 13:56:31','2021-09-27 11:56:31','2020-04-30 19:58:00','d402edb5-8449-46a8-862f-a1cd1ee21cf6',2,1),(662,'bd51414b-f96e-4903-a2e2-44fb3189decd','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-06-27 20:35:29',NULL,'2022-06-27 21:35:48','2022-06-27 19:35:48','2022-06-27 21:02:22','dce9ce0f-0933-4c98-af84-59e2b6395f8f',1,1),(662,'be9a4ba5-715b-4547-a31d-66621ec7b17f','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-06-08 19:57:28',NULL,'2021-06-08 20:31:03','2021-06-08 18:31:03','2021-06-08 20:19:58','16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c',1,1),(662,'c00beb59-a67d-4566-801a-0081588c2a04','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-11-22 12:43:48',NULL,'2021-11-22 12:49:45','2021-11-22 11:49:45','2021-11-22 12:45:00','52372fba-991e-4b09-abce-2195e775fd19',1,1),(662,'c1232582-95fc-48dc-a9ee-826c0cbad106','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-11-23 12:16:09',NULL,'2021-11-23 12:19:11','2021-11-23 11:19:11','2021-11-23 12:18:02','31210683-bc06-4b84-83d9-ce60f32308e4',1,1),(662,'c6bba495-6d1a-4da8-bb1f-852a1b1e5924','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-16 07:07:51','2020-04-16 11:39:43','2020-04-16 07:10:45','2020-12-15 14:15:36','2020-04-16 07:07:51','bef02815-bbf7-4520-882b-2396474f4bb3',2,1),(662,'c99bbff9-5630-49d7-9300-4dabfa5e74c8','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-16 12:48:12',NULL,'2021-02-16 12:57:05','2021-02-16 11:57:05','2021-02-16 12:53:06','c6fffa68-cc65-471a-a58e-135ebe4d0772',1,1),(662,'ca33a9ff-b86a-4e97-8674-1bd7adc92759','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-15 07:43:37','2020-04-16 07:02:51','2020-04-16 07:02:51','2020-12-15 14:15:36','2020-04-15 07:43:37','bef02815-bbf7-4520-882b-2396474f4bb3',1,1),(662,'cb1d5d31-89cd-4ab4-bada-dc6b2235cac5','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-17 11:04:14',NULL,'2021-03-19 10:22:22','2021-03-19 09:22:22','2020-04-17 11:04:14','a18ca6df-d765-4c6a-be28-13abd1c350af',1,1),(662,'ccd3f4f6-f303-4b20-b967-d41121f2e36b','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-01 21:19:50',NULL,'2021-02-01 21:23:07','2021-02-01 20:23:07','2021-02-01 21:22:34','1ec1f707-d702-496a-b2f0-e55b08c06dcb',1,1),(662,'cd4cde89-86e9-4257-92b6-869e9aa8d1f6','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-16 11:35:44',NULL,'2021-03-19 10:22:18','2021-03-19 09:22:18','2020-04-16 11:35:44','e06b73d5-45f7-4906-ba73-560d66ac56af',1,1),(662,'ce9c2874-6b23-435d-8371-00e8de8a835b','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2023-01-11 12:41:48','2023-01-11 12:41:52',NULL,'2023-01-11 11:41:52','2023-01-11 12:41:48','983c39b6-656b-4bf2-bf43-da1625adb861',2,1),(662,'d04345c3-df70-4e2a-b197-cc37138e6700','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-03-11 11:14:05',NULL,'2022-03-11 11:17:45','2022-03-11 10:17:45','2022-03-11 11:15:50','5f895907-3eed-4aa7-995a-f7e1c9661a0a',1,1),(662,'d1ad6baa-b3e6-4e10-bd69-140c7abc8f4e','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-10 11:49:59',NULL,'2021-03-19 10:22:18','2021-03-19 09:22:18','2020-04-10 11:49:59','bdf42f40-5a7a-435b-a5e0-eb33efefbc97',1,1),(662,'d2372948-816f-4d58-a2bf-288bc0e7b539','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-15 07:19:58','2020-04-16 11:39:43','2020-04-15 07:29:32','2020-12-15 14:15:36','2020-04-15 07:19:58','bef02815-bbf7-4520-882b-2396474f4bb3',1,1),(662,'d2c2a39a-6597-4bf0-ad99-7534d9696320','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-11-23 12:09:38','2021-11-23 12:09:44',NULL,'2021-11-23 11:09:44','2021-11-23 12:09:38','31210683-bc06-4b84-83d9-ce60f32308e4',2,1),(662,'d2cd260d-4191-4884-80e3-7ced9fa0f8ce','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-11-04 13:33:29',NULL,'2022-12-14 15:06:02','2022-12-14 14:06:02','2022-11-04 13:46:23','a5bc2d6f-0248-466f-a10b-08f5391fd12f',2,1),(662,'d36d186b-d0da-4aea-af1a-4613f67b2fa0','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-17 11:17:42',NULL,'2021-03-19 10:22:22','2021-03-19 09:22:22','2020-04-17 11:17:42','a18ca6df-d765-4c6a-be28-13abd1c350af',1,1),(662,'d3a42d3d-3d98-457b-bb64-4119091b03f9','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-15 07:37:21','2020-04-16 07:02:20','2020-04-16 07:02:20','2020-12-15 14:15:36','2020-04-15 07:37:21','bef02815-bbf7-4520-882b-2396474f4bb3',1,1),(662,'d4c7f3c5-155d-41ef-8665-852e89c5e017','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-27 10:43:57',NULL,'2021-02-27 10:52:47','2021-02-27 09:52:47','2021-02-27 10:48:13','484ae4d8-329f-49b5-8d83-312a8a92ff22',1,1),(662,'d52d9ce0-7fed-491c-a385-929e22fb07d5','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-30 20:05:04',NULL,'2021-09-27 13:56:29','2021-09-27 11:56:29','2020-04-30 20:05:04','d402edb5-8449-46a8-862f-a1cd1ee21cf6',1,1),(662,'d5bd2f05-2874-4b0b-abaa-e6dbef3854b8','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-06 11:29:32','2020-04-06 11:29:45',NULL,'2020-12-15 14:15:36','2020-04-06 11:29:32','296c061e-734b-4936-8af7-1f80653eff11',2,1),(662,'d675acff-ab7f-4d65-b55c-558379a8b3d0','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-01-11 12:37:31',NULL,'2022-01-11 12:43:38','2022-01-11 11:43:38','2022-01-11 12:39:02','12115366-8eb9-470b-a097-5d28bb5fdf38',1,1),(662,'d7c4d383-83f9-4275-bbcc-567a47d4a450','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-09-27 12:45:24',NULL,'2021-09-27 14:00:42','2021-09-27 12:00:42','2021-09-27 12:46:45','6c6bb813-840d-454a-ab1d-9232434a4500',1,1),(662,'d9e4705b-ee94-487e-8ebd-6ebbbc7fbd38','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-06 11:13:18','2020-04-06 11:17:46',NULL,'2020-12-15 14:15:36','2020-04-06 11:13:18','296c061e-734b-4936-8af7-1f80653eff11',1,1),(662,'d9ec0349-f28e-41d6-822f-e76c8c001da9','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-27 10:07:51',NULL,'2021-02-27 10:23:44','2021-02-27 09:23:44','2021-02-27 10:22:32','484ae4d8-329f-49b5-8d83-312a8a92ff22',1,1),(662,'db8db471-34d4-4eab-b8bf-677fc98cde60','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-06 11:18:31','2020-04-06 11:18:40',NULL,'2020-12-15 14:15:36','2020-04-06 11:18:31','296c061e-734b-4936-8af7-1f80653eff11',2,1),(662,'de216c91-485b-4dac-9e7c-b89075739521','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-10 11:13:09',NULL,'2021-03-19 10:22:19','2021-03-19 09:22:19','2020-04-10 11:13:09','bdf42f40-5a7a-435b-a5e0-eb33efefbc97',1,1),(662,'e25b4a1f-bcd7-4165-997c-34c38a8a567f','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-07 07:06:36','2020-04-07 07:06:44',NULL,'2020-12-15 14:15:36','2020-04-07 07:06:36','c9d37315-5f17-421c-8afb-302fa9b0bebe',5,1),(662,'e5fd24c7-49a8-4dbc-9356-3b96970d2515','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-05-21 08:00:24',NULL,'2021-03-19 10:22:25','2021-03-19 09:22:25','2020-05-21 08:00:24','254f3fc9-4782-4658-bb34-f2ca1c9b6382',1,1),(662,'e6c99474-f6f6-447f-bcaa-d4c791811e18','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-01 21:04:48',NULL,'2021-02-01 21:12:37','2021-02-01 20:12:37','2021-02-01 21:09:33','1ec1f707-d702-496a-b2f0-e55b08c06dcb',2,1),(662,'e6e5d8c5-2d8c-48d0-9708-e3256202d385','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-16 12:19:51',NULL,'2021-02-16 12:53:07','2021-02-16 11:53:07','2021-02-16 12:48:04','c6fffa68-cc65-471a-a58e-135ebe4d0772',1,1),(662,'e7efed59-e33c-4194-94c1-3507350dcfb5','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-07-13 19:39:12',NULL,'2021-03-19 10:22:30','2021-03-19 09:22:30','2020-07-13 19:39:12','f2e73640-aebd-4bb1-9b02-c0504556ac5a',1,1),(662,'e8ff012c-af85-450f-ba33-bd61c15846e9','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-11-23 12:09:50',NULL,'2021-11-23 12:18:03','2021-11-23 11:18:03','2021-11-23 12:14:25','31210683-bc06-4b84-83d9-ce60f32308e4',1,1),(662,'e9134dab-33d6-42e4-8779-ab502b18266c','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-16 11:05:58',NULL,'2021-03-19 10:22:16','2021-03-19 09:22:16','2020-04-16 11:05:58','e06b73d5-45f7-4906-ba73-560d66ac56af',1,1),(662,'e99b1c89-977c-4836-9719-ad6d9a6f6aae','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-01 20:57:09','2021-02-01 21:23:38','2021-02-01 21:23:38','2021-02-01 20:23:38','2021-02-01 21:04:34','1ec1f707-d702-496a-b2f0-e55b08c06dcb',1,1),(662,'e9aaa539-6e84-47bc-9c50-2c8797de82a4','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-11-02 12:34:17',NULL,'2022-11-02 15:09:57','2022-11-02 14:09:57','2022-11-02 12:34:58','b5b4db66-f433-46fb-b794-d632b8fe8e1d',1,1),(662,'eca23073-2ad8-4f4f-95cb-36be4ed4b064','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-07 07:06:47','2020-04-07 07:06:52',NULL,'2020-12-15 14:15:36','2020-04-07 07:06:47','c9d37315-5f17-421c-8afb-302fa9b0bebe',6,1),(662,'ecd2beec-0c29-40e2-ab95-64009c33fa40','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2020-12-29 11:28:43',NULL,'2021-06-08 19:43:35','2021-06-08 17:43:35','2020-12-29 11:30:30','b87f1382-55d4-4e52-b63a-6f387df18b16',1,1),(662,'ed495283-b756-4052-ba8b-5fe9f9b1f8be','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-11-02 12:11:51',NULL,'2022-11-02 18:43:21','2022-11-02 17:43:21','2022-11-02 12:30:09','b5b4db66-f433-46fb-b794-d632b8fe8e1d',1,1),(662,'eece5ace-2081-4f39-859f-68495bd82499','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2020-12-29 08:43:27',NULL,'2021-06-08 19:45:17','2021-06-08 17:45:17','2020-12-29 08:48:31','bb711dc3-11c1-44a8-96df-a5fb875eade5',1,1),(662,'ef79558a-21cf-4117-a0b7-ba0adf40f7dc','MORDU_ANTERIEUR','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-09-27 12:46:55',NULL,'2021-09-27 14:00:42','2021-09-27 12:00:42','2021-09-27 12:49:23','6c6bb813-840d-454a-ab1d-9232434a4500',1,1),(662,'f0b63e95-26e8-4213-a935-ca2c37ab36ba','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2022-01-11 12:23:26',NULL,'2022-01-11 12:39:03','2022-01-11 11:39:03','2022-01-11 12:35:42','12115366-8eb9-470b-a097-5d28bb5fdf38',1,1),(662,'f2b8c151-b863-4411-b17a-b987ca58ee6f','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-09 10:56:43','2020-04-10 09:22:06','2020-04-09 10:58:47','2020-12-15 14:15:36','2020-04-09 10:56:43','4af4bd2d-76e3-4905-99fd-191c4cc669fa',1,1),(662,'f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-11-22 12:29:17',NULL,'2021-11-22 12:51:37','2021-11-22 11:51:37','2021-11-22 12:41:06','52372fba-991e-4b09-abce-2195e775fd19',1,1),(662,'f66e82ce-4142-4af6-af28-6234363afd4c','MANDIBULE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-07 07:05:08','2020-04-07 07:05:14',NULL,'2020-12-15 14:15:36','2020-04-07 07:05:08','c9d37315-5f17-421c-8afb-302fa9b0bebe',2,1),(662,'f766f1dd-53ad-45fc-8f7b-a61d47dfe500','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'none','2021-02-27 10:48:25',NULL,'2021-02-27 10:55:31','2021-02-27 09:55:31','2021-02-27 10:52:47','484ae4d8-329f-49b5-8d83-312a8a92ff22',1,1),(662,'fbfa4372-1faf-4a14-9f4e-70b7b375da7d','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-04-18 09:19:43','2021-03-19 10:22:13','2021-03-19 10:22:13','2021-03-19 09:22:13','2020-04-18 09:19:43','daf632b1-2c49-42c8-8899-0a0b2448bc3a',1,1),(662,'ffc31e24-32ca-4c9e-a392-25252e853fcf','MAXILLAIRE','',NULL,NULL,NULL,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'in_progress','2020-07-08 19:38:20','2020-07-08 19:43:23',NULL,'2020-12-15 14:15:36','2020-07-08 19:38:20','53a17fdc-5de8-45aa-a9cb-ebea4886f6ff',1,1);
/*!40000 ALTER TABLE `Scan` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Scan_AFTER_UPDATE` AFTER UPDATE ON `Scan` FOR EACH ROW BEGIN
    IF NEW.deletedAt IS NOT NULL THEN
      UPDATE Occlusion SET topScanID = NULL
	  WHERE topScanID = new.id;

	  UPDATE Occlusion SET bottomScanID = NULL
	  WHERE bottomScanID = new.id;

	  UPDATE Occlusion SET leftBiteScanID = NULL
	  WHERE leftBiteScanID = new.id;

	  UPDATE Occlusion SET rightBiteScanID = NULL
	  WHERE rightBiteScanID = new.id;

	  UPDATE Occlusion SET anteriorBiteScanID = NULL
	  WHERE anteriorBiteScanID = new.id;
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Scan_BEFORE_DELETE` BEFORE DELETE ON `Scan` FOR EACH ROW BEGIN
  UPDATE Occlusion SET topScanID = NULL
  WHERE topScanID = OLD.id;

  UPDATE Occlusion SET bottomScanID = NULL
  WHERE bottomScanID = OLD.id;

  UPDATE Occlusion SET leftBiteScanID = NULL
  WHERE leftBiteScanID = OLD.id;

  UPDATE Occlusion SET rightBiteScanID = NULL
  WHERE rightBiteScanID = OLD.id;

  UPDATE Occlusion SET anteriorBiteScanID = NULL
  WHERE anteriorBiteScanID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `ScanFile`
--

DROP TABLE IF EXISTS `ScanFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ScanFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `fileID` char(36) NOT NULL,
  `scanID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`fileID`,`scanID`,`ownerID`),
  KEY `fk_ScanFile_Scan` (`scanID`,`ownerID`),
  KEY `fk_ScanFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ScanFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ScanFile_Scan` FOREIGN KEY (`scanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ScanFile`
--

LOCK TABLES `ScanFile` WRITE;
/*!40000 ALTER TABLE `ScanFile` DISABLE KEYS */;
INSERT INTO `ScanFile` VALUES (662,'03c11f7d-c2ac-42f2-8983-927ccff14074','a90158f7-0d39-4b9d-984b-57de06099c65','2021-11-22 11:25:53'),(662,'04758fa4-84c5-4d84-a8c3-6b431275e3cd','919caf8c-919a-49cc-bf39-68486f2f5991','2020-04-17 09:19:52'),(662,'048d66fa-42fe-4d07-8e9c-1a8a30ce1fb4','57e7671e-1671-4ee9-96a0-650a56963aa8','2021-02-27 09:58:59'),(662,'04955796-a392-49c6-b40d-fba48ef36844','bd51414b-f96e-4903-a2e2-44fb3189decd','2022-06-27 18:55:59'),(662,'0518a0de-5961-461c-b3cf-2ee702ed7107','6445b6e3-0c4a-44d3-84e8-7f315911b8ee','2020-07-08 17:54:05'),(662,'06da4522-e34d-40fd-b96f-ca51c40618cc','209f3c55-7380-4efa-8e6c-dfe8c99792a6','2023-01-11 11:58:26'),(662,'06e08af9-0736-40b6-93e5-bdffccb8ea44','1c6adc05-0655-4ad6-bcc9-27b0ef578ded','2022-06-28 18:39:39'),(662,'07615b33-5390-4fe1-9fbb-9ec7cbd64d40','793e84ce-b088-458d-82f5-33fab1f5e7de','2022-01-11 11:23:17'),(662,'0890ccd8-08ca-4b8f-8bea-3e38e4c1e0a0','2bf301a3-b61c-4ddd-b6a2-4924c804d5f8','2020-04-10 09:51:26'),(662,'097b9793-f270-498e-9cfe-cf6bc2963744','209f3c55-7380-4efa-8e6c-dfe8c99792a6','2023-01-11 11:21:43'),(662,'0a02b656-9179-4cbd-ae14-079f4f933517','a6d52fce-2e61-4375-bf6d-a36f9b3eb72f','2021-10-12 10:42:38'),(662,'0abfe6c8-8321-4681-9ffd-944418ed370c','6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7','2020-04-15 05:39:22'),(662,'0b4e8e31-bd54-4394-8ebc-2c2d30d84197','d9ec0349-f28e-41d6-822f-e76c8c001da9','2021-02-27 09:22:30'),(662,'0cac8ddd-0fbb-4d05-98b1-9dbfe53318c8','209f3c55-7380-4efa-8e6c-dfe8c99792a6','2023-01-11 11:25:55'),(662,'0cbb67d8-7a5d-43de-a85a-8ad3ddf2e2cb','2a466f6b-3960-4b1b-bb27-def76229cccc','2022-11-04 11:27:19'),(662,'0e855e55-dc7f-4eaf-91bd-933232cae95e','00f07cdc-1834-4ae1-a9fa-47699828c094','2021-10-12 10:40:25'),(662,'0f7ff11f-44bc-45a5-bfc7-a7ac0da258f5','437ef945-eb42-4841-9b20-34804bd5cfd6','2021-06-08 18:46:38'),(662,'102a1df9-b0fe-46c3-b1b6-edddfb8c021b','ae899af8-7040-48c9-a9b2-6ebc255ac7c9','2021-02-16 11:19:19'),(662,'110bfb15-3589-48ab-bb80-e339d042b64d','3a315f7b-8cf2-4d0c-bf92-fecb623fe530','2022-09-14 10:19:51'),(662,'118f4b39-1c4d-49d5-9470-979ae78a94eb','a26f0d58-ca46-4921-a9e1-9c39b7f89783','2020-12-29 10:05:41'),(662,'11dc5cec-d45b-455d-8577-dcf502967a94','f2b8c151-b863-4411-b17a-b987ca58ee6f','2020-04-09 08:56:37'),(662,'127e55bb-48e6-421e-ab6a-05b0763a843e','d2372948-816f-4d58-a2bf-288bc0e7b539','2020-04-15 05:13:11'),(662,'13991d0c-102a-4df8-aaad-f5f422edc6be','98e7c216-5bb9-4127-9497-834796980370','2021-11-23 11:08:21'),(662,'13fa1125-c9d0-498d-bc50-68dc9f4f1beb','be9a4ba5-715b-4547-a31d-66621ec7b17f','2021-06-08 18:11:20'),(662,'144ce692-0397-4de4-aa07-e50e85b5a553','e7efed59-e33c-4194-94c1-3507350dcfb5','2020-07-13 17:39:11'),(662,'14c0bac1-16fe-41ce-863b-85ffd35f41e9','b002027b-930d-4b96-a687-453aeea5659e','2022-12-21 11:09:24'),(662,'156e5ba4-51dd-4631-932f-c91d8a7edef9','643b3b5a-e991-4dbf-95c8-2fd609f83a8b','2021-02-01 19:52:02'),(662,'160153e9-3248-4a6b-b0ff-a10c2c1acfc9','bd51414b-f96e-4903-a2e2-44fb3189decd','2022-06-27 18:48:28'),(662,'169331da-dbab-454e-828b-67287bb2feb7','b5005e42-2d4d-41b0-91d5-667275f3a9cc','2020-04-30 18:00:05'),(662,'1712177a-2d33-429e-81ed-e58b3ec65c4d','c1232582-95fc-48dc-a9ee-826c0cbad106','2021-11-23 11:18:01'),(662,'176a7141-81b2-436e-bbb3-00ec6028c71b','2a466f6b-3960-4b1b-bb27-def76229cccc','2022-11-04 11:27:19'),(662,'185c4f85-4987-4fa1-9ca4-3c6b9e0373b7','26a765d3-8b92-4861-984a-bd9c8040209b','2022-03-11 09:31:23'),(662,'1920fbbf-3535-420d-92a8-85d1ffb87094','12f64013-f8aa-44bb-91e8-38c23737152b','2020-04-29 12:50:36'),(662,'1b9e7359-42f9-45c8-9ddf-605c192e8a57','7fad3bba-f2b2-41ce-849b-756d995c0414','2020-04-11 05:49:58'),(662,'1e115805-b191-4113-972e-a4489d95599a','d4c7f3c5-155d-41ef-8665-852e89c5e017','2021-02-27 09:48:13'),(662,'1e3c210c-a983-4276-916c-6c49b0e64e1d','87a0a17a-c973-40c2-9d84-2392b0d62afb','2020-04-30 17:37:47'),(662,'1e41852a-1d94-44eb-90f9-b06c401ee8b7','ed495283-b756-4052-ba8b-5fe9f9b1f8be','2022-11-02 11:30:06'),(662,'1e81852e-fdc6-4523-9e33-47494d60d953','a93c6a8f-0c96-47ae-bc72-75a725946a5a','2020-04-30 18:08:26'),(662,'1e84d5d4-6768-4dde-a7cf-ca40a6d4261e','19627cd9-e6e6-4c6f-9a62-46d708ca49bc','2021-02-27 09:43:29'),(662,'1f02ce0a-9100-460e-987f-c2b91eda5ac1','375f8fb7-d198-4281-9948-bba81b98e824','2020-04-10 05:44:49'),(662,'1f154183-a975-4dfa-b4eb-fea963eb0d6c','f0b63e95-26e8-4213-a935-ca2c37ab36ba','2022-01-11 11:31:09'),(662,'1f29b918-27fd-422b-b4dd-da18687d0871','bd51414b-f96e-4903-a2e2-44fb3189decd','2022-06-27 18:48:28'),(662,'1f608503-4867-4253-a143-dd200e0ebe0a','d52d9ce0-7fed-491c-a385-929e22fb07d5','2020-04-30 18:05:04'),(662,'1f92b4ea-73e7-423b-8d75-46b280f139d9','437ef945-eb42-4841-9b20-34804bd5cfd6','2021-06-08 18:38:08'),(662,'1fe4acd9-cda1-4289-bd11-70fec38115e5','44b8a221-3707-430b-bc84-cacca7bf7d8a','2021-06-08 18:51:49'),(662,'20195b26-5345-4f9f-bbd5-4e2ac9fd972d','881d38cc-cf89-4329-8456-b90f8c997725','2021-10-12 10:44:16'),(662,'2129ad39-4745-4e82-a5b8-dcf7933c6ae7','d3a42d3d-3d98-457b-bb64-4119091b03f9','2020-04-15 05:37:21'),(662,'214a04d1-1997-4654-8226-87b79966583e','79548cb6-a61f-44cb-b6f7-cab7698f7465','2021-02-01 20:15:42'),(662,'222a29ad-e959-403d-b53b-f17d1e53bc93','1c6adc05-0655-4ad6-bcc9-27b0ef578ded','2022-06-28 18:34:07'),(662,'229d55f2-d907-49a9-ae4c-c2359e8ce810','ecd2beec-0c29-40e2-ab95-64009c33fa40','2020-12-29 10:30:30'),(662,'23066de9-fbda-436c-bd8b-dacb5721c390','e6c99474-f6f6-447f-bcaa-d4c791811e18','2021-02-01 20:09:31'),(662,'23251874-b8f3-48b3-b209-0b434edd5db0','a26f0d58-ca46-4921-a9e1-9c39b7f89783','2020-12-29 10:00:28'),(662,'2367f698-7e4f-4e60-b31f-752903f8cd34','802e2d49-5b37-47b7-b8e9-4fb4bff1f62f','2022-03-11 10:13:45'),(662,'245640ab-9c9d-4467-bd40-a48ae0ff49d0','0c8af1cb-8054-4a35-9cfe-449c19dbe59b','2020-04-16 05:10:44'),(662,'24c23cdd-d323-4623-8a9d-2d3e14f3b937','a26f0d58-ca46-4921-a9e1-9c39b7f89783','2020-12-29 10:00:28'),(662,'252b180c-565f-4f14-af48-a16cebbead9e','209f3c55-7380-4efa-8e6c-dfe8c99792a6','2023-01-11 11:21:43'),(662,'2554e0bc-d621-46e3-90e6-f7d7f2085b98','de216c91-485b-4dac-9e7c-b89075739521','2020-04-10 09:13:08'),(662,'25d2e57a-b759-4ab8-a633-7725e7375d70','ef79558a-21cf-4117-a0b7-ba0adf40f7dc','2021-09-27 10:49:22'),(662,'2607735b-f648-4b52-882f-e91b883da1be','99a6d55d-de66-49eb-a717-49cb2587fbef','2021-09-27 10:45:21'),(662,'2632ca9d-afe6-4104-a347-d590758abfc0','de216c91-485b-4dac-9e7c-b89075739521','2020-04-10 09:13:08'),(662,'26c13801-12d8-430d-ae6c-429cbe801e77','643b3b5a-e991-4dbf-95c8-2fd609f83a8b','2021-02-01 19:41:18'),(662,'29be6b15-58e7-42cd-824d-34b15f20be76','34f5d93d-6a1f-4f94-ab20-4105c2cce30a','2021-06-08 18:30:59'),(662,'2a17666e-f40f-403e-88af-a4cfaf6332ec','d9ec0349-f28e-41d6-822f-e76c8c001da9','2021-02-27 09:22:30'),(662,'2a2002a5-6321-4c63-938e-7276412e6a28','d2372948-816f-4d58-a2bf-288bc0e7b539','2020-04-15 05:19:54'),(662,'2aa2008a-2609-41f7-99c6-d3b7a4560466','e5fd24c7-49a8-4dbc-9356-3b96970d2515','2020-05-21 06:00:21'),(662,'2b6d557d-ea43-42a5-bd7d-859d5a90f1a6','4a2eec76-a5f3-44f0-b389-4734998fa2d3','2020-12-29 10:20:13'),(662,'2cff0ba7-eee7-4c7f-99af-34c690eb3868','254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff','2022-08-06 11:56:36'),(662,'2d1d8d21-ec2c-485d-98af-375a4d8263d6','a90158f7-0d39-4b9d-984b-57de06099c65','2021-11-22 11:21:50'),(662,'2ec9cc68-72e4-4237-9254-2374d936f630','470d4798-40ea-4ce5-a574-22fcf013d82d','2020-04-16 09:17:28'),(662,'2fe7a2a7-6a20-4d12-ba81-6c46af5e0703','be9a4ba5-715b-4547-a31d-66621ec7b17f','2021-06-08 18:16:28'),(662,'307db8a0-4cc4-49dc-9aca-9a7072712805','209f3c55-7380-4efa-8e6c-dfe8c99792a6','2023-01-11 11:37:39'),(662,'31421697-5459-439e-919b-169d051646f5','6fafe104-bdc1-41a6-9977-b1bbb351a329','2020-04-07 04:42:41'),(662,'31b407a6-51a1-4581-a381-00a2955c6d4d','a90158f7-0d39-4b9d-984b-57de06099c65','2021-11-22 11:25:53'),(662,'330dc645-80dc-4734-bc6a-ba2a87b5f495','50e1896b-8565-4257-9a61-2a685fff8165','2021-09-27 10:43:41'),(662,'35704ab9-18dc-4d80-81f3-5f50e93033c6','cb1d5d31-89cd-4ab4-bada-dc6b2235cac5','2020-04-17 08:58:56'),(662,'364852fb-413f-4160-99e2-dfbc1733ad1a','d1ad6baa-b3e6-4e10-bd69-140c7abc8f4e','2020-04-10 09:49:59'),(662,'372c807f-a172-495b-9111-e2a86808505c','87a0a17a-c973-40c2-9d84-2392b0d62afb','2020-04-30 17:25:29'),(662,'386b43f6-0c1a-484d-9092-8962d1eb3835','6fafe104-bdc1-41a6-9977-b1bbb351a329','2020-04-06 10:33:56'),(662,'38ff0511-8c8a-4f8b-a2a4-13c26e804b9d','c6bba495-6d1a-4da8-bb1f-852a1b1e5924','2020-04-16 05:07:50'),(662,'3a8a47b1-96a0-4e8f-a7fa-d5c2f74f3677','778a761c-339e-4143-a807-735b174d9714','2020-04-15 05:35:08'),(662,'3aa92b1f-240d-45e1-a722-e8da98368f3a','f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','2021-11-22 11:30:44'),(662,'3b5b5fb9-a2cd-4386-9406-17bd2384e1ae','42b09cf6-e30d-4d35-a17d-d8e8b4564638','2021-10-12 10:33:03'),(662,'3b6f0d95-5183-43aa-8816-815a96e7e143','76ece440-81ad-42c8-ab91-f99fa29e2a83','2023-04-11 18:49:11'),(662,'3d2bee32-9787-46dd-b6a9-cba9de226dfb','b7931623-9b21-4440-a950-16565249bf9a','2020-04-30 17:51:54'),(662,'3d775751-11c5-4dcb-bf34-a85c2baf0191','4a2eec76-a5f3-44f0-b389-4734998fa2d3','2020-12-29 10:24:49'),(662,'3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb','643b3b5a-e991-4dbf-95c8-2fd609f83a8b','2021-02-01 19:20:58'),(662,'3dc10c2a-bbf8-496d-bcfb-198ad6609e7b','55058b25-acc2-43c3-b9d2-b8bb64bfcbb9','2020-04-18 07:33:54'),(662,'3ddb3953-cee7-44fd-b8e2-76afee946647','f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','2021-11-22 11:41:03'),(662,'3e41d066-f22f-4b6c-bc5b-438bc17b2d84','6fafe104-bdc1-41a6-9977-b1bbb351a329','2020-04-06 10:33:56'),(662,'3f126af5-ce2b-4e13-8fc8-9811ab5d462c','d2372948-816f-4d58-a2bf-288bc0e7b539','2020-04-15 05:19:54'),(662,'3f34dab9-eda8-40de-be81-a094dee55a47','e6e5d8c5-2d8c-48d0-9708-e3256202d385','2021-02-16 11:48:00'),(662,'3f9ce1c8-3470-43c5-8e52-0294b7082120','18365744-4019-43e1-933f-9fa52db1a30d','2021-06-08 18:56:53'),(662,'3ff0f96a-5e61-4469-a401-383ca0d260ac','3d3ae697-dc08-4ce2-8b32-4f79891607c2','2021-11-22 11:49:42'),(662,'40bc13d8-af5e-436f-825b-372a9ad37b03','f766f1dd-53ad-45fc-8f7b-a61d47dfe500','2021-02-27 09:52:46'),(662,'40c9dd9e-b85c-4ed6-a37e-81b5b8e9124d','e9134dab-33d6-42e4-8779-ab502b18266c','2020-04-16 08:54:36'),(662,'41f1c7ba-1d8c-47b9-8ed9-11f004bb7681','3e1d8e57-feae-45d6-80f0-9d0be041ff7a','2022-09-19 09:48:30'),(662,'4210a84b-05e7-47b1-9d77-62e41dc0e731','99102b35-9ad0-4017-b70e-fa08e5c36102','2022-11-02 11:34:10'),(662,'42d780c5-37b5-433e-890f-3c005cb69701','e7efed59-e33c-4194-94c1-3507350dcfb5','2020-07-13 17:18:53'),(662,'430388c7-9e1e-4f20-b931-839cea08cfe1','c99bbff9-5630-49d7-9300-4dabfa5e74c8','2021-02-16 11:53:05'),(662,'43236ddb-b178-4cc2-bc90-90f78d3f3694','10c9626c-901e-4a0e-8f05-62042bf69c04','2020-04-16 09:14:29'),(662,'436f05c6-b083-492e-bd94-ce39d9a91136','7fad3bba-f2b2-41ce-849b-756d995c0414','2020-04-11 05:49:58'),(662,'449406e4-68d2-4fa1-9032-2e72795a7ec2','e9134dab-33d6-42e4-8779-ab502b18266c','2020-04-16 08:54:36'),(662,'4582b122-e1ac-4901-8817-e05e3192fc42','cd4cde89-86e9-4257-92b6-869e9aa8d1f6','2020-04-16 09:35:43'),(662,'45a66afe-8bb2-49b4-b3fc-982c845cf2f2','c00beb59-a67d-4566-801a-0081588c2a04','2021-11-22 11:44:59'),(662,'45a97d29-279f-4720-856d-2ef701665f93','e8ff012c-af85-450f-ba33-bd61c15846e9','2021-11-23 11:14:24'),(662,'472a6b31-d305-463f-a0b2-2abeb6fa2c3e','802e2d49-5b37-47b7-b8e9-4fb4bff1f62f','2022-03-11 10:13:45'),(662,'4743873a-96f6-412f-91c5-a4b27c7d6847','bd51414b-f96e-4903-a2e2-44fb3189decd','2022-06-27 18:58:56'),(662,'477bef20-19c4-472b-89d8-912285f5e534','87a0a17a-c973-40c2-9d84-2392b0d62afb','2020-04-30 17:25:29'),(662,'4782af06-5171-4020-833c-143c6a151469','76ece440-81ad-42c8-ab91-f99fa29e2a83','2023-04-11 18:49:11'),(662,'48632fc1-3269-4a7f-bdaa-980e30af0358','778a761c-339e-4143-a807-735b174d9714','2020-04-15 05:35:08'),(662,'49635be4-dbea-497c-82e1-206399739c31','50e1896b-8565-4257-9a61-2a685fff8165','2021-09-27 10:43:41'),(662,'49c43140-7062-4b44-a49e-83c262304d61','b7931623-9b21-4440-a950-16565249bf9a','2020-04-30 17:54:51'),(662,'4a35756e-57f1-4f26-a7da-64af3396fbad','3a315f7b-8cf2-4d0c-bf92-fecb623fe530','2022-09-14 10:23:53'),(662,'4a84b07a-6e20-4dea-85d3-199cb3adf0f5','e8ff012c-af85-450f-ba33-bd61c15846e9','2021-11-23 11:14:24'),(662,'4acfe34d-f60d-43a0-bed4-9a53302e03f0','2d566d37-f38f-4b79-ac8f-48009ae22310','2020-04-10 09:37:04'),(662,'4b136eb3-b01e-4166-a154-4539e20f9fea','4a2eec76-a5f3-44f0-b389-4734998fa2d3','2020-12-29 10:28:31'),(662,'4b797e84-44dc-4df1-9b19-d421afa9bb08','876f775b-e8a0-4b7f-bea0-0c93a7041d17','2020-12-29 10:33:10'),(662,'4df1d6c0-6d77-4547-ae20-f797167f57b2','643b3b5a-e991-4dbf-95c8-2fd609f83a8b','2021-02-01 19:56:49'),(662,'4e355e83-f72e-471f-a217-6dc5ae2fd8aa','0d792709-57f3-49e1-963c-d2dc35a59d12','2021-02-27 09:55:29'),(662,'4ec9ee9c-a56b-483d-ba09-9dc992d7e79c','45b21304-1129-40a2-b60e-d72a2bf96e72','2020-04-12 06:05:48'),(662,'4f638684-087b-42a0-916a-a8adc0c1eeea','42b09cf6-e30d-4d35-a17d-d8e8b4564638','2021-10-12 10:37:44'),(662,'506aaec6-4b3a-4a00-9e18-ddc95eb010f4','9716867f-e0a3-478a-a498-1e84ae803044','2021-11-22 11:45:44'),(662,'517e0273-72a1-4e4d-8815-d303a233a31d','e9134dab-33d6-42e4-8779-ab502b18266c','2020-04-16 09:05:55'),(662,'51c81dd7-f872-4092-9a17-d9b3821ed7c8','b5005e42-2d4d-41b0-91d5-667275f3a9cc','2020-04-30 18:00:05'),(662,'520242d1-a563-40d8-b43b-1c26fd0f28ff','0e5656e0-946b-41b2-935b-ea820746e5a9','2023-03-21 11:27:26'),(662,'520d0710-d923-46c1-a1dd-f05370a3a5ea','79548cb6-a61f-44cb-b6f7-cab7698f7465','2021-02-01 20:12:36'),(662,'536f2d6d-667c-4e47-bf9c-c77be612a54a','12f64013-f8aa-44bb-91e8-38c23737152b','2020-04-29 12:50:36'),(662,'53ebdc66-a057-4dc0-8a89-3e9bc7e5d11d','ed495283-b756-4052-ba8b-5fe9f9b1f8be','2022-11-02 11:26:48'),(662,'5498794c-1fcc-48dd-b50e-b57ca5d157ab','be9a4ba5-715b-4547-a31d-66621ec7b17f','2021-06-08 18:11:20'),(662,'55cd923a-d543-4e42-8f4a-de07877d1b09','a6d52fce-2e61-4375-bf6d-a36f9b3eb72f','2021-10-12 10:42:38'),(662,'569cf3b9-ec78-4231-a836-d4fe2c1273c0','437ef945-eb42-4841-9b20-34804bd5cfd6','2021-06-08 18:46:38'),(662,'587c45f4-d25d-4cad-8934-761b77e11986','c00beb59-a67d-4566-801a-0081588c2a04','2021-11-22 11:44:59'),(662,'58f5907e-16f5-4910-b9e6-81046fdd76df','cb1d5d31-89cd-4ab4-bada-dc6b2235cac5','2020-04-17 08:58:56'),(662,'59ebc4a1-1711-4a3b-ac06-f55565453d6a','643b3b5a-e991-4dbf-95c8-2fd609f83a8b','2021-02-01 19:35:28'),(662,'59f86cb7-d0b5-456d-bb86-a5a83efb559d','76f39717-6f88-4e19-800c-f827a697a4d6','2020-04-16 05:05:20'),(662,'5b5466a1-e0a0-4b4b-8dd8-e9f815b047c0','7a39120e-2f79-4c3e-af4d-af72e8ca8062','2021-02-16 12:00:22'),(662,'5ba33ea9-efd2-4c3f-b859-372b495c2e78','643b3b5a-e991-4dbf-95c8-2fd609f83a8b','2021-02-01 19:35:28'),(662,'5bdd9b13-0942-46d1-92ac-4b22472007ae','fbfa4372-1faf-4a14-9f4e-70b7b375da7d','2020-04-18 07:18:30'),(662,'5c2ae31f-cf6e-42c8-9d38-6f41e1e8db02','d675acff-ab7f-4d65-b55c-558379a8b3d0','2022-01-11 11:39:01'),(662,'5c991e5c-3b6f-409c-839c-1ed086c26caf','79548cb6-a61f-44cb-b6f7-cab7698f7465','2021-02-01 20:12:36'),(662,'5dfbe9b8-c587-4311-b392-743be40fdd10','f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','2021-11-22 11:30:44'),(662,'5e1416aa-d0a4-4f50-98c6-8e1f1e6d994d','919caf8c-919a-49cc-bf39-68486f2f5991','2020-04-17 09:19:52'),(662,'5f33a727-5198-4fcf-af3d-ae94e86da222','bd51414b-f96e-4903-a2e2-44fb3189decd','2022-06-27 18:53:18'),(662,'5f516c96-8333-49f5-8c71-3a7e8878488c','9716867f-e0a3-478a-a498-1e84ae803044','2021-11-22 11:47:33'),(662,'5fe946a4-d7b1-4c37-a75f-cda8a073daf9','a26f0d58-ca46-4921-a9e1-9c39b7f89783','2020-12-29 10:05:41'),(662,'6008312e-ba22-4c98-a696-7500991d7069','b7931623-9b21-4440-a950-16565249bf9a','2020-04-30 17:47:40'),(662,'6026647a-901e-4a90-bd11-8ec6d1883285','57e7671e-1671-4ee9-96a0-650a56963aa8','2021-02-27 09:58:59'),(662,'60418949-4776-4ecc-898e-ee8453d29ba9','26a765d3-8b92-4861-984a-bd9c8040209b','2022-03-11 09:31:23'),(662,'60a7c19d-824d-4fdf-a109-f3df643a3f1a','b7931623-9b21-4440-a950-16565249bf9a','2020-04-30 17:57:58'),(662,'60b6e24d-83ab-4528-953e-a72aae732f49','643b3b5a-e991-4dbf-95c8-2fd609f83a8b','2021-02-01 19:28:14'),(662,'621b6179-82c4-4d83-a1ec-4b5eb2545a81','57cfef6d-c27e-45fa-81d7-e63b4f8c4429','2020-04-10 09:41:52'),(662,'632bdd11-c86e-438a-af78-cfcc9f793d03','be9a4ba5-715b-4547-a31d-66621ec7b17f','2021-06-08 18:19:55'),(662,'6420c2d7-bcdf-4e2e-9ee7-e90e3b7b7045','a90158f7-0d39-4b9d-984b-57de06099c65','2021-11-22 11:28:55'),(662,'648cf438-b183-47f5-a0f7-c8a3e2e416c8','7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a','2021-02-01 20:19:45'),(662,'6558fea4-267a-4a73-8416-579630e68249','d2cd260d-4191-4884-80e3-7ced9fa0f8ce','2022-11-04 12:42:01'),(662,'6578f0f2-99f0-4b42-b32d-3bfc8a7b4697','e9134dab-33d6-42e4-8779-ab502b18266c','2020-04-16 09:01:03'),(662,'65867250-5b1d-4a93-b4d9-d00468a4d2fa','f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','2021-11-22 11:38:42'),(662,'664cb06d-0960-4f9e-9c04-b9080d0ba7c2','13e9c4af-5ddc-4a12-ae1b-2b802c735c3f','2020-04-18 07:37:59'),(662,'6771d7ca-3bca-47bd-a554-166ba1db633b','209f3c55-7380-4efa-8e6c-dfe8c99792a6','2023-01-11 11:37:39'),(662,'68061e27-8872-4682-9ba9-a57f6a95d8d3','19627cd9-e6e6-4c6f-9a62-46d708ca49bc','2021-02-27 09:43:29'),(662,'687b8177-c7c5-42f4-8937-a0b8e331f674','37ff1278-3dd1-470a-8159-e763f6626f5d','2020-04-17 09:12:10'),(662,'689b438f-3633-4981-b669-5e49a97a5c95','b002027b-930d-4b96-a687-453aeea5659e','2022-12-21 11:14:30'),(662,'6918be85-b74b-4069-b2b3-914477ca77ad','f0b63e95-26e8-4213-a935-ca2c37ab36ba','2022-01-11 11:35:39'),(662,'6ad36229-9d4a-4773-85c5-492f1965bc80','453abb20-3827-4f8b-b57f-c656c72ebf11','2021-10-12 10:22:48'),(662,'6bc59c6e-9179-4d61-91a6-7cfb0da22a7a','3a315f7b-8cf2-4d0c-bf92-fecb623fe530','2022-09-14 10:19:51'),(662,'6bd04ecb-23d6-4510-a353-c2b68dba5457','0a606279-3c91-4220-b876-e620d1bf52f6','2020-04-18 07:32:12'),(662,'6e406955-1a72-4b3a-8063-b460b758c328','13e9c4af-5ddc-4a12-ae1b-2b802c735c3f','2020-04-18 07:37:59'),(662,'6e7d5030-f9a6-4e4d-baf7-7a0f3c335bfc','ccd3f4f6-f303-4b20-b967-d41121f2e36b','2021-02-01 20:22:33'),(662,'6e9feeb8-6d42-4237-b134-51d979397898','e6e5d8c5-2d8c-48d0-9708-e3256202d385','2021-02-16 11:40:32'),(662,'6ea3e979-830a-4dd4-81e2-3d30db702b9c','2a466f6b-3960-4b1b-bb27-def76229cccc','2022-11-04 11:31:49'),(662,'6eeaf574-0aa0-4bc8-95c8-5d198f212e39','643b3b5a-e991-4dbf-95c8-2fd609f83a8b','2021-02-01 19:52:02'),(662,'6f2ff317-b1e7-4c11-b0dd-c5b359491513','57cfef6d-c27e-45fa-81d7-e63b4f8c4429','2020-04-10 09:41:52'),(662,'6f481e07-43c0-494b-8d4f-279772780eec','e9aaa539-6e84-47bc-9c50-2c8797de82a4','2022-11-02 11:34:58'),(662,'6fa55f91-2e1f-436b-b276-b2726e9125b4','5a4f6b62-6381-4a1e-bbef-61746f2722d3','2022-01-11 11:41:14'),(662,'6fe553ac-625b-4942-ad10-01bbe5250717','209f3c55-7380-4efa-8e6c-dfe8c99792a6','2023-01-11 11:58:26'),(662,'729f8772-5a1d-40db-b918-270cc340ba8e','e9134dab-33d6-42e4-8779-ab502b18266c','2020-04-16 09:01:03'),(662,'72c86a01-5d0c-47ea-8964-b3832ab6a43f','8a4f0a25-fae8-4564-8f4a-63f4168b2915','2020-04-16 09:20:50'),(662,'73466738-f8a5-4b0e-a6af-9c63c2e802e6','d7c4d383-83f9-4275-bbcc-567a47d4a450','2021-09-27 10:46:45'),(662,'78194fe5-5ac7-4c4a-ba44-b374602235d5','4caeed6a-b015-4556-8794-2c3a00fea341','2020-05-21 06:03:19'),(662,'78aec42f-0ec9-4ca8-b05e-324d3b955b86','d4c7f3c5-155d-41ef-8665-852e89c5e017','2021-02-27 09:48:13'),(662,'78fdec7c-2a35-41bb-8492-82f1c776d061','1c6adc05-0655-4ad6-bcc9-27b0ef578ded','2022-06-28 18:34:07'),(662,'791a0795-78ad-4b6e-a31b-bdc257f06704','00f07cdc-1834-4ae1-a9fa-47699828c094','2021-10-12 10:40:25'),(662,'7935777d-a278-4364-9439-322233eba142','778a761c-339e-4143-a807-735b174d9714','2020-04-15 05:29:30'),(662,'79ba2d1d-77b5-4b68-a71f-efb6c2b2b49d','8a4f0a25-fae8-4564-8f4a-63f4168b2915','2020-04-16 09:20:50'),(662,'79cf9af7-3005-4b44-854c-ba038cba5f4b','10c9626c-901e-4a0e-8f05-62042bf69c04','2020-04-16 09:14:29'),(662,'79d52980-5104-4ca5-9286-27c93d8a0261','643b3b5a-e991-4dbf-95c8-2fd609f83a8b','2021-02-01 19:46:11'),(662,'7a4d7123-69ae-4260-adf1-9661ad22cb0f','a90158f7-0d39-4b9d-984b-57de06099c65','2021-11-22 11:28:55'),(662,'7b9836aa-2cf6-485a-b0d3-39d73de4bc8b','453abb20-3827-4f8b-b57f-c656c72ebf11','2021-10-12 10:26:33'),(662,'7cace217-66b4-4147-97f5-c8c1a7dfe1cd','5a59f382-4b59-4867-8640-021d20bdcd59','2022-11-02 11:36:21'),(662,'7d1b5372-e89a-471e-8230-71dba1f47677','45b21304-1129-40a2-b60e-d72a2bf96e72','2020-04-12 05:51:14'),(662,'7df036ea-5778-484f-b08f-26823b06d4e2','5a5e6904-4736-4443-bbd0-be73066af8c3','2020-04-14 10:10:33'),(662,'7ee48377-0cc2-4cf4-8d72-837e258ca29f','1c6adc05-0655-4ad6-bcc9-27b0ef578ded','2022-06-28 18:27:39'),(662,'7f09064b-ad1e-4cc1-9d0b-40bde9e22dff','26a765d3-8b92-4861-984a-bd9c8040209b','2022-03-11 09:26:59'),(662,'7f4bb473-7bb6-4ba8-a767-c1e722ce5c1b','e9134dab-33d6-42e4-8779-ab502b18266c','2020-04-16 09:05:55'),(662,'7fbf5bd8-6de6-46b1-bd50-c2480472006d','ed495283-b756-4052-ba8b-5fe9f9b1f8be','2022-11-02 11:26:48'),(662,'80e2978d-ccbf-46b3-90aa-49fde4694d47','fbfa4372-1faf-4a14-9f4e-70b7b375da7d','2020-04-18 07:19:43'),(662,'818647ce-e09a-4e46-8ad9-2029a89b0d0f','7a39120e-2f79-4c3e-af4d-af72e8ca8062','2021-02-16 12:00:22'),(662,'81bbb529-1a14-4e29-b842-b84cbac8d014','793e84ce-b088-458d-82f5-33fab1f5e7de','2022-01-11 11:16:28'),(662,'81e806ef-052e-4347-928a-d06d1d3a299b','bd51414b-f96e-4903-a2e2-44fb3189decd','2022-06-27 18:58:56'),(662,'8248bc2e-a7bc-4a4e-9fc9-f2326990454c','f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','2021-11-22 11:31:30'),(662,'82997513-4864-4e01-8853-7053a2892d95','e6c99474-f6f6-447f-bcaa-d4c791811e18','2021-02-01 20:09:31'),(662,'8369f19c-559c-4a43-8a44-d476973e5f8f','470d4798-40ea-4ce5-a574-22fcf013d82d','2020-04-16 09:17:28'),(662,'8396da09-c9ea-476d-ab69-648f06ec6534','a90158f7-0d39-4b9d-984b-57de06099c65','2021-11-22 11:21:50'),(662,'83dce64b-81ec-4022-b7e5-8a738bbab39f','37ff1278-3dd1-470a-8159-e763f6626f5d','2020-04-17 09:09:28'),(662,'83eddd4d-fe65-43b9-a14f-3293e715be11','527c942e-3aa0-4028-b02a-8b3f137657be','2020-04-27 14:19:06'),(662,'8426a670-f967-440b-bcde-e3796c4a5da6','209f3c55-7380-4efa-8e6c-dfe8c99792a6','2023-01-11 11:52:36'),(662,'84c96eac-549e-4c1d-a701-896474d66a31','019e5bd1-9330-4e70-8035-2fda343b0231','2021-09-27 10:26:06'),(662,'850a1a2e-2e87-4cda-8ec5-a2dcd149731d','b24d4ab4-dba3-4be5-8ba3-7eee381f40ec','2022-11-04 11:34:43'),(662,'85dade24-9cc8-4e62-afe5-2da409796449','fbfa4372-1faf-4a14-9f4e-70b7b375da7d','2020-04-18 07:19:43'),(662,'88b2c3fc-981f-4818-aa0f-2cbbbc6a3b31','b7931623-9b21-4440-a950-16565249bf9a','2020-04-30 17:54:51'),(662,'8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1','a93c6a8f-0c96-47ae-bc72-75a725946a5a','2020-04-30 18:08:26'),(662,'8efdb9b3-fe9f-4a5f-9abb-7f53985624a7','16cf8664-2af0-446a-ac6d-ef0e40edb71d','2020-04-18 07:35:44'),(662,'8f73cc76-d204-47ee-bcfc-5610371e2032','41b8d05c-738b-4161-9f86-27222b61ad66','2021-06-08 18:48:52'),(662,'8fd1dd53-2969-4c23-9998-f92a590629ae','6445b6e3-0c4a-44d3-84e8-7f315911b8ee','2020-07-08 17:54:05'),(662,'90d34496-4e10-41d5-b77c-75826f81327e','b002027b-930d-4b96-a687-453aeea5659e','2022-12-21 11:14:30'),(662,'9186d766-694f-4445-926a-80ace9fd1660','55058b25-acc2-43c3-b9d2-b8bb64bfcbb9','2020-04-18 07:33:54'),(662,'9210c2bb-cc5b-4ccf-a432-8adf915d5673','6ce24fb2-7744-476b-a643-7e304d3ac013','2022-01-11 11:37:27'),(662,'92288f55-8447-4e52-a1c2-2de9d12cad77','44b8a221-3707-430b-bc84-cacca7bf7d8a','2021-06-08 18:51:49'),(662,'9319bd6a-6e7d-4505-8090-e4e10e3caec0','d52d9ce0-7fed-491c-a385-929e22fb07d5','2020-04-30 18:05:04'),(662,'933a6e93-9da3-4626-98e1-48aa28a06daa','0b6ec729-5c4e-4869-9d67-6377923ed207','2020-04-07 05:26:12'),(662,'9429af5d-f1d9-425d-ba09-d7d1907096ac','2d566d37-f38f-4b79-ac8f-48009ae22310','2020-04-10 09:37:04'),(662,'94dbef5a-271e-457d-ba7b-ace1dbe05081','d04345c3-df70-4e2a-b197-cc37138e6700','2022-03-11 10:15:49'),(662,'9617b0df-e829-47cd-8110-fabb587a690d','881d38cc-cf89-4329-8456-b90f8c997725','2021-10-12 10:44:16'),(662,'963a8acf-cdb2-41d5-b187-9a7c885ac2a0','1e8824f7-3c76-4fe0-bd8c-f865f725dab2','2021-11-23 11:23:17'),(662,'96c2eb83-88a2-4de9-b439-f00924861267','76f39717-6f88-4e19-800c-f827a697a4d6','2020-04-16 05:21:49'),(662,'97939bfa-2cd3-4695-a8de-c1359ed5322d','f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','2021-11-22 11:31:30'),(662,'98a2c194-b406-4930-b901-3f1b520fc329','d2372948-816f-4d58-a2bf-288bc0e7b539','2020-04-15 05:13:11'),(662,'98c10ee7-5736-4c52-8f1e-248cda79d235','79548cb6-a61f-44cb-b6f7-cab7698f7465','2021-02-01 20:15:42'),(662,'9946c86d-7b6b-4bd2-8dae-8b982fbd7cfc','fbfa4372-1faf-4a14-9f4e-70b7b375da7d','2020-04-18 07:18:30'),(662,'9b87eb98-b2ac-4d29-83ea-5125f3d83710','98e7c216-5bb9-4127-9497-834796980370','2021-11-23 11:08:21'),(662,'9c755cdf-e1f1-49e0-9dcf-708a856d1b81','16cf8664-2af0-446a-ac6d-ef0e40edb71d','2020-04-18 07:35:44'),(662,'9cd5b1c8-ef15-449d-97a1-bdf6947abe78','6fafe104-bdc1-41a6-9977-b1bbb351a329','2020-04-07 04:42:41'),(662,'9d114e81-9c84-452b-9722-47ddb78d35e5','e7efed59-e33c-4194-94c1-3507350dcfb5','2020-07-13 17:32:07'),(662,'9d5d6282-185b-45e3-8902-11f6f83c2991','7f9aec2d-6246-4413-842d-78d2e0bddb1e','2020-04-12 05:48:40'),(662,'9d65d7e8-dc55-4823-9aae-6c5190aae7da','e5fd24c7-49a8-4dbc-9356-3b96970d2515','2020-05-21 06:00:21'),(662,'9fa4fa76-ae1b-496c-bc61-9c8652c7f3d6','7a39120e-2f79-4c3e-af4d-af72e8ca8062','2021-02-16 11:57:03'),(662,'a017e06b-1e5e-408c-9423-28e5f5e8e405','a26f0d58-ca46-4921-a9e1-9c39b7f89783','2020-12-29 10:13:13'),(662,'a06c28ec-9f81-44b6-b11e-a5e06d983e4a','107f2922-62ee-42d9-8e35-69d71587db0b','2020-05-21 06:13:15'),(662,'a196ba15-5ebd-46d8-b6fa-0325918797ac','41b8d05c-738b-4161-9f86-27222b61ad66','2021-06-08 18:48:52'),(662,'a1bc9da2-af83-43c3-8210-759800158585','1c6adc05-0655-4ad6-bcc9-27b0ef578ded','2022-06-28 18:20:22'),(662,'a2156f23-da3f-4a2a-97f3-76ea6c877521','ca33a9ff-b86a-4e97-8674-1bd7adc92759','2020-04-15 05:43:36'),(662,'a3243928-a351-4ca9-b9b0-be959eab0b25','4a2eec76-a5f3-44f0-b389-4734998fa2d3','2020-12-29 10:24:49'),(662,'a3ae3378-e8e9-495e-9dc6-8a3be2a9a968','793e84ce-b088-458d-82f5-33fab1f5e7de','2022-01-11 11:23:17'),(662,'a3d56e52-a954-4894-b840-be0425c42658','0f18aace-5cf2-4d46-b56f-f8dc123e1f91','2021-11-23 11:21:30'),(662,'a41e073f-d40b-4f4f-924e-2afd61ac4f8c','45b21304-1129-40a2-b60e-d72a2bf96e72','2020-04-12 05:51:14'),(662,'a483fb03-0adb-4387-9099-c9c2567855e7','ca33a9ff-b86a-4e97-8674-1bd7adc92759','2020-04-15 05:43:36'),(662,'a4f0f4fa-9346-4a75-a1dd-e95c83dc5e6b','1c6adc05-0655-4ad6-bcc9-27b0ef578ded','2022-06-28 18:39:39'),(662,'a54c4788-74a1-482e-bbc8-b46aeb6ca424','0c8af1cb-8054-4a35-9cfe-449c19dbe59b','2020-04-16 05:10:44'),(662,'a5903ca6-45db-41cc-a262-19592ff5f2e4','6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7','2020-04-15 05:39:22'),(662,'a60e34f6-4db6-4236-9d5a-1741dd2ed622','42b09cf6-e30d-4d35-a17d-d8e8b4564638','2021-10-12 10:33:03'),(662,'a6c49c5b-a994-457c-80d2-6cd69b636979','bd51414b-f96e-4903-a2e2-44fb3189decd','2022-06-27 19:02:19'),(662,'a7593039-4dcb-45a6-891b-98f0c4c5c835','76f39717-6f88-4e19-800c-f827a697a4d6','2020-04-16 05:05:20'),(662,'a76fbd10-38f6-45b2-bcd6-4235bebb7cc8','d2cd260d-4191-4884-80e3-7ced9fa0f8ce','2022-11-04 12:42:01'),(662,'a8de488b-e4b1-4234-b30c-cb7d68338c86','209f3c55-7380-4efa-8e6c-dfe8c99792a6','2023-01-11 11:25:55'),(662,'a952743c-a21c-4952-8c29-3ac0e894560a','76ece440-81ad-42c8-ab91-f99fa29e2a83','2023-04-11 18:44:25'),(662,'a97b41cc-c47f-42ff-aed9-3b6ec8803714','ef79558a-21cf-4117-a0b7-ba0adf40f7dc','2021-09-27 10:49:22'),(662,'ab2de538-1cbb-481f-a82e-899f47da34b7','0e5656e0-946b-41b2-935b-ea820746e5a9','2023-03-21 11:27:26'),(662,'ab47d04c-6ad7-430c-ae85-9231a2efc7b9','be9a4ba5-715b-4547-a31d-66621ec7b17f','2021-06-08 18:19:55'),(662,'ac0adbda-ae71-490a-947a-f9bfe33db7e8','a26f0d58-ca46-4921-a9e1-9c39b7f89783','2020-12-29 10:13:13'),(662,'ac2e051b-dd4c-4fc1-be89-d406c5ab9a69','50e1896b-8565-4257-9a61-2a685fff8165','2021-09-27 10:37:45'),(662,'ae0e9352-37bf-4a60-8c33-459deae4ddb5','76ece440-81ad-42c8-ab91-f99fa29e2a83','2023-04-11 18:44:25'),(662,'af631cfa-13bc-4662-b2af-845b9dc8652b','76f39717-6f88-4e19-800c-f827a697a4d6','2020-04-16 05:21:49'),(662,'affc6c02-1fc4-49c7-9730-6f5e1f2e9f8e','44ccf5f6-834d-4090-88dc-399b19fed47e','2021-02-16 12:05:08'),(662,'b01eb471-5baa-4958-b2c6-736eab81754a','d675acff-ab7f-4d65-b55c-558379a8b3d0','2022-01-11 11:39:01'),(662,'b03f52b8-54fa-4f11-9899-22d57d5b6ebc','793e84ce-b088-458d-82f5-33fab1f5e7de','2022-01-11 11:16:28'),(662,'b181e5ae-02f0-4845-a5ba-d30139f8d8a1','4caeed6a-b015-4556-8794-2c3a00fea341','2020-05-21 06:03:19'),(662,'b19b3b70-d194-4a56-8a06-dc3cf2fb8e6a','d04345c3-df70-4e2a-b197-cc37138e6700','2022-03-11 10:15:49'),(662,'b328d68a-733b-46ed-9a1a-20aefc9f9b17','019e5bd1-9330-4e70-8035-2fda343b0231','2021-09-27 10:22:21'),(662,'b50704aa-49f1-4444-8df4-4ec2e9e99b38','d2cd260d-4191-4884-80e3-7ced9fa0f8ce','2022-11-04 12:46:21'),(662,'b51adc6b-e313-4ada-a607-3b0cd408c55b','e99b1c89-977c-4836-9719-ad6d9a6f6aae','2021-02-01 20:04:33'),(662,'b61e5533-433b-40e2-a91d-c157692b02c0','019e5bd1-9330-4e70-8035-2fda343b0231','2021-09-27 10:22:21'),(662,'b6432038-01b6-4f88-8506-0a2a5906d721','f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','2021-11-22 11:38:42'),(662,'b6b42cf7-31c1-49e1-b1d1-c607c7ba299b','b24d4ab4-dba3-4be5-8ba3-7eee381f40ec','2022-11-04 11:34:43'),(662,'b6f09e06-083f-4c19-ae6f-63af10340898','b289ff52-6765-45a7-b1e2-fe7161ba809f','2020-04-18 07:26:03'),(662,'b75b602f-a893-4dd9-8bbf-6b4b00421c4a','44ccf5f6-834d-4090-88dc-399b19fed47e','2021-02-16 12:05:08'),(662,'b7e23c05-dca2-450c-8296-062f60712c4b','f2b8c151-b863-4411-b17a-b987ca58ee6f','2020-04-09 08:56:37'),(662,'b9175f0f-b250-4ae3-b56c-51f5a10c10db','534cca35-8182-4f61-aa57-03bad8172eac','2020-12-29 10:35:15'),(662,'b94c36ee-0e86-44b0-a152-b92997bdab17','e7efed59-e33c-4194-94c1-3507350dcfb5','2020-07-13 17:18:53'),(662,'ba881d4e-efc8-45fe-90c8-248f552f9196','534cca35-8182-4f61-aa57-03bad8172eac','2020-12-29 10:35:15'),(662,'bad6504a-4f54-4dc9-83e3-02475160f717','0e5656e0-946b-41b2-935b-ea820746e5a9','2023-03-21 11:21:48'),(662,'bafe042a-2298-470c-8d08-071e0f4e388e','3a315f7b-8cf2-4d0c-bf92-fecb623fe530','2022-09-14 10:23:53'),(662,'bb2755e4-36de-4604-9ee9-d2711661ea1d','375f8fb7-d198-4281-9948-bba81b98e824','2020-04-10 05:44:49'),(662,'bc10348b-1c26-48ee-bc8f-6fa5ac933a14','b7931623-9b21-4440-a950-16565249bf9a','2020-04-30 17:57:58'),(662,'bcb2c331-8297-48c9-9ba7-66e21108faf8','bd51414b-f96e-4903-a2e2-44fb3189decd','2022-06-27 18:55:59'),(662,'be04859c-f9ff-4a11-96c0-99dd77c8c98f','26a765d3-8b92-4861-984a-bd9c8040209b','2022-03-11 09:26:59'),(662,'bfbd4222-08f2-4237-9b3e-e482e6111a20','37ff1278-3dd1-470a-8159-e763f6626f5d','2020-04-17 09:12:10'),(662,'c063b377-02e8-4830-bf3f-414b4e6325ca','e9aaa539-6e84-47bc-9c50-2c8797de82a4','2022-11-02 11:34:58'),(662,'c0a56411-85d4-412b-84cc-45a71dee710a','34f5d93d-6a1f-4f94-ab20-4105c2cce30a','2021-06-08 18:30:59'),(662,'c0c1a357-1f5c-443a-ac07-9cc3a45a7853','e7efed59-e33c-4194-94c1-3507350dcfb5','2020-07-13 17:32:07'),(662,'c14c7ae3-1390-4203-93ce-6ba836086c35','7a39120e-2f79-4c3e-af4d-af72e8ca8062','2021-02-16 11:57:03'),(662,'c19a9e26-b162-4808-8d10-9d6a38e24e98','c1232582-95fc-48dc-a9ee-826c0cbad106','2021-11-23 11:18:01'),(662,'c444e909-d341-4283-88a4-d2ec58f55e8a','527c942e-3aa0-4028-b02a-8b3f137657be','2020-04-27 14:19:06'),(662,'c44f8f8f-6ba9-4ae3-85ba-cffa8f6b3e13','1c6adc05-0655-4ad6-bcc9-27b0ef578ded','2022-06-28 18:24:10'),(662,'c7871ca0-e84a-4880-b74b-ef641334860e','eece5ace-2081-4f39-859f-68495bd82499','2020-12-29 07:48:30'),(662,'c8503263-9efa-47b8-8764-2bb09be6a1cb','f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','2021-11-22 11:41:03'),(662,'c9051630-ef52-45e0-bf72-eef2676192c8','2a466f6b-3960-4b1b-bb27-def76229cccc','2022-11-04 11:31:49'),(662,'c96624b7-bb0a-400c-b02e-bdfd89bdac9e','b289ff52-6765-45a7-b1e2-fe7161ba809f','2020-04-18 07:26:03'),(662,'ca0a9826-3f91-4aaf-984b-889d4cff43a5','9716867f-e0a3-478a-a498-1e84ae803044','2021-11-22 11:45:44'),(662,'ca42217b-f484-48a1-bff2-3b72dc4f7f2f','f766f1dd-53ad-45fc-8f7b-a61d47dfe500','2021-02-27 09:52:46'),(662,'ca78a19d-bcad-4ceb-b844-f2badf2ebc09','643b3b5a-e991-4dbf-95c8-2fd609f83a8b','2021-02-01 19:28:14'),(662,'cb85cf03-baff-4dcf-bc65-cf1a9c7b9e84','643b3b5a-e991-4dbf-95c8-2fd609f83a8b','2021-02-01 19:46:11'),(662,'cc3c0e89-9cd8-4432-9607-044314bb9633','cd4cde89-86e9-4257-92b6-869e9aa8d1f6','2020-04-16 09:35:43'),(662,'cce7b291-ae52-44af-bd7e-fe49b16c09c7','65315958-b964-4f7e-a111-9c7695d8092b','2020-04-17 09:14:14'),(662,'ce7041b4-86ce-4167-b150-b49d4f0008a6','6ce24fb2-7744-476b-a643-7e304d3ac013','2022-01-11 11:37:27'),(662,'cf189c0a-4444-4e39-9766-e4e47582f98c','2bf301a3-b61c-4ddd-b6a2-4924c804d5f8','2020-04-10 09:51:26'),(662,'cfce77ff-b3ac-4f31-ba2d-7ffffd711fef','eece5ace-2081-4f39-859f-68495bd82499','2020-12-29 07:48:30'),(662,'d0155fb7-667e-4f4e-be6a-1eacb81ecb13','e6e5d8c5-2d8c-48d0-9708-e3256202d385','2021-02-16 11:40:32'),(662,'d1e9dead-d755-4b41-9105-4b6355694989','18365744-4019-43e1-933f-9fa52db1a30d','2021-06-08 18:56:53'),(662,'d2a7b476-1ed0-4870-8219-9863d50e401c','209f3c55-7380-4efa-8e6c-dfe8c99792a6','2023-01-11 11:52:36'),(662,'d2cb8acf-0a31-40f9-932c-a089f44c1a4b','209f3c55-7380-4efa-8e6c-dfe8c99792a6','2023-01-11 11:34:03'),(662,'d2ffe250-09d3-47fd-af00-7d6cc98742d8','f0b63e95-26e8-4213-a935-ca2c37ab36ba','2022-01-11 11:31:09'),(662,'d3e47b22-64d4-4936-a2f6-a2a11b01fdf2','ccd3f4f6-f303-4b20-b967-d41121f2e36b','2021-02-01 20:22:33'),(662,'d40f4bba-69b0-4cc6-b541-e69c16b2b3d5','1c6adc05-0655-4ad6-bcc9-27b0ef578ded','2022-06-28 18:20:22'),(662,'d455a946-5407-4abb-8fdb-711fb0adfe7c','50e1896b-8565-4257-9a61-2a685fff8165','2021-09-27 10:37:45'),(662,'d47ef10b-7c9f-4fd9-8617-329e21bbfa35','876f775b-e8a0-4b7f-bea0-0c93a7041d17','2020-12-29 10:33:10'),(662,'d5ddb4c9-b9d4-4dbd-91ab-8ba108c565e0','f0b63e95-26e8-4213-a935-ca2c37ab36ba','2022-01-11 11:35:39'),(662,'d5df3022-2abe-4d54-a53d-63cb7ad80b02','019e5bd1-9330-4e70-8035-2fda343b0231','2021-09-27 10:26:06'),(662,'d7178627-cef8-4d56-87be-5ce753175b9f','c99bbff9-5630-49d7-9300-4dabfa5e74c8','2021-02-16 11:53:05'),(662,'d7875c8c-cb63-4940-9761-68ef1c238665','4a2eec76-a5f3-44f0-b389-4734998fa2d3','2020-12-29 10:28:31'),(662,'d82bb8e8-709c-4148-9290-d8b05ce3f7e6','99102b35-9ad0-4017-b70e-fa08e5c36102','2022-11-02 11:34:10'),(662,'dab48b34-de4a-4877-be2f-a21e13908dff','0e5656e0-946b-41b2-935b-ea820746e5a9','2023-03-21 11:21:48'),(662,'dc97d683-1aa5-4aba-bf5c-a43b36478d90','5a59f382-4b59-4867-8640-021d20bdcd59','2022-11-02 11:36:21'),(662,'dd19221a-2e2b-4f03-9062-62bb291352d2','3e1d8e57-feae-45d6-80f0-9d0be041ff7a','2022-09-19 09:48:30'),(662,'dd29f41a-cbb1-45d7-8979-1d16d4db487c','453abb20-3827-4f8b-b57f-c656c72ebf11','2021-10-12 10:26:33'),(662,'dd45b218-e893-4bfa-a2dc-cfdb060bbcbc','209f3c55-7380-4efa-8e6c-dfe8c99792a6','2023-01-11 11:34:03'),(662,'de0c426e-a321-49cc-9a15-8f590e95c146','d1ad6baa-b3e6-4e10-bd69-140c7abc8f4e','2020-04-10 09:49:59'),(662,'de0cdea6-9c25-4adc-b642-788b56270d11','cb1d5d31-89cd-4ab4-bada-dc6b2235cac5','2020-04-17 09:04:13'),(662,'e0c2841d-b460-4eda-9548-18bb8a59d908','d2cd260d-4191-4884-80e3-7ced9fa0f8ce','2022-11-04 12:46:21'),(662,'e1692a67-2979-4399-b4dc-65a1c7e9c4b8','ae899af8-7040-48c9-a9b2-6ebc255ac7c9','2021-02-16 11:19:19'),(662,'e22ce6e5-78b3-470f-8eac-fc2668ff13bc','254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff','2022-08-06 11:56:36'),(662,'e22d8b26-814a-456b-850f-82860b769634','d36d186b-d0da-4aea-af1a-4613f67b2fa0','2020-04-17 09:17:41'),(662,'e2e61121-2865-452b-a685-13a4ecd0974b','643b3b5a-e991-4dbf-95c8-2fd609f83a8b','2021-02-01 19:56:49'),(662,'e31677ad-6acd-445e-8577-f3c741a13dc2','0f18aace-5cf2-4d46-b56f-f8dc123e1f91','2021-11-23 11:21:30'),(662,'e3dcb444-172f-4ae1-a2bc-7ff3b7c8eb26','7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a','2021-02-01 20:19:45'),(662,'e54a3aaa-1b5e-4e05-b9aa-30359687e6de','778a761c-339e-4143-a807-735b174d9714','2020-04-15 05:29:30'),(662,'e695a41c-b645-425c-85e6-65b449ddbb04','534cca35-8182-4f61-aa57-03bad8172eac','2020-12-29 10:37:09'),(662,'e720e2f6-8dce-43f4-a5d6-bf8c09037947','643b3b5a-e991-4dbf-95c8-2fd609f83a8b','2021-02-01 19:20:58'),(662,'e8f06fb1-375a-41c0-9a27-d0ee2593900c','4a2eec76-a5f3-44f0-b389-4734998fa2d3','2020-12-29 10:20:13'),(662,'e94bbc94-0540-4634-816e-4a842ced15fa','e7efed59-e33c-4194-94c1-3507350dcfb5','2020-07-13 17:39:11'),(662,'e969b9cf-a941-4745-a2cb-e1ed64d3332e','1c6adc05-0655-4ad6-bcc9-27b0ef578ded','2022-06-28 18:27:39'),(662,'ebf4cbaa-94a5-42c6-aad4-4f61d8ad16b8','1e8824f7-3c76-4fe0-bd8c-f865f725dab2','2021-11-23 11:23:17'),(662,'ed40ce9a-6d1f-4cfd-a3e2-f58cba946869','d7c4d383-83f9-4275-bbcc-567a47d4a450','2021-09-27 10:46:45'),(662,'ede17ed3-0dee-42d5-86a9-2728608363fe','453abb20-3827-4f8b-b57f-c656c72ebf11','2021-10-12 10:22:48'),(662,'ee74d731-2b8a-426e-a645-bad9ae685308','107f2922-62ee-42d9-8e35-69d71587db0b','2020-05-21 06:13:15'),(662,'eee409c6-39bb-43e6-9a2d-c17ecc88cf08','b7931623-9b21-4440-a950-16565249bf9a','2020-04-30 17:51:54'),(662,'f06e433d-c712-4081-adba-9051f0c10c4e','5a4f6b62-6381-4a1e-bbef-61746f2722d3','2022-01-11 11:41:14'),(662,'f0df34cd-4382-481e-9fcb-ed767063a228','5a5e6904-4736-4443-bbd0-be73066af8c3','2020-04-14 10:10:33'),(662,'f0fe7a67-1ca7-4da6-b4e1-681dc8f0e6b1','bd51414b-f96e-4903-a2e2-44fb3189decd','2022-06-27 18:53:18'),(662,'f16b178b-9a0f-4a7d-b4da-8d23ef7b4db3','0d792709-57f3-49e1-963c-d2dc35a59d12','2021-02-27 09:55:29'),(662,'f1ef3944-d73f-4a49-8e28-c4619cb61202','42b09cf6-e30d-4d35-a17d-d8e8b4564638','2021-10-12 10:37:44'),(662,'f297816f-db2c-4167-bd60-28d3e93bb7c9','37ff1278-3dd1-470a-8159-e763f6626f5d','2020-04-17 09:09:28'),(662,'f2e3b9c2-4d8e-490a-8051-fed4332bc376','643b3b5a-e991-4dbf-95c8-2fd609f83a8b','2021-02-01 19:41:18'),(662,'f3030b14-8ec9-4a85-a2ac-04d14a2a6ab4','ecd2beec-0c29-40e2-ab95-64009c33fa40','2020-12-29 10:30:30'),(662,'f3d5a2ce-9a80-4c06-a1b4-85bce5e716ea','ed495283-b756-4052-ba8b-5fe9f9b1f8be','2022-11-02 11:30:06'),(662,'f3f82ebd-8318-469e-9bdd-ff76223b9c1c','b7931623-9b21-4440-a950-16565249bf9a','2020-04-30 17:47:40'),(662,'f500b4e0-bd2d-4992-901f-526fc78912cf','99a6d55d-de66-49eb-a717-49cb2587fbef','2021-09-27 10:45:21'),(662,'f574474f-dc28-462d-9251-b23591ca9bcb','d3a42d3d-3d98-457b-bb64-4119091b03f9','2020-04-15 05:37:21'),(662,'f6615787-bb2f-4f28-b265-517b66795996','7f9aec2d-6246-4413-842d-78d2e0bddb1e','2020-04-12 05:48:40'),(662,'f69344e1-d52d-49da-acc5-b714cb86225d','87a0a17a-c973-40c2-9d84-2392b0d62afb','2020-04-30 17:37:47'),(662,'f7cc8435-546b-4daa-9414-7a8a0728e9e6','1c6adc05-0655-4ad6-bcc9-27b0ef578ded','2022-06-28 18:24:11'),(662,'f7e28eea-71d1-4771-8eaa-cbc7fd8fd17a','c6bba495-6d1a-4da8-bb1f-852a1b1e5924','2020-04-16 05:07:50'),(662,'f867279f-0907-4a6e-84d2-9c1b54bb4caf','0a606279-3c91-4220-b876-e620d1bf52f6','2020-04-18 07:32:12'),(662,'f880f49e-bb57-430d-8212-dcb8e015569f','3d3ae697-dc08-4ce2-8b32-4f79891607c2','2021-11-22 11:49:42'),(662,'f8d60891-9893-425b-9839-c04fdf0d0cd5','9716867f-e0a3-478a-a498-1e84ae803044','2021-11-22 11:47:33'),(662,'f9419645-8fbf-4bf1-99ba-df5bd8485ab2','bd51414b-f96e-4903-a2e2-44fb3189decd','2022-06-27 19:02:19'),(662,'f967ed2c-cc61-428f-8d34-99152f99ce47','be9a4ba5-715b-4547-a31d-66621ec7b17f','2021-06-08 18:16:28'),(662,'faa7f2df-9772-4aef-b228-35b51fb8134d','e99b1c89-977c-4836-9719-ad6d9a6f6aae','2021-02-01 20:04:33'),(662,'fad00b24-cf95-4da0-aa56-8c7af1870289','b002027b-930d-4b96-a687-453aeea5659e','2022-12-21 11:09:24'),(662,'fb86258d-e165-4e8e-a22f-d60bf23a6d59','d36d186b-d0da-4aea-af1a-4613f67b2fa0','2020-04-17 09:17:41'),(662,'fd2b02c7-bcd5-4774-9809-1da5d2dd2ad0','0b6ec729-5c4e-4869-9d67-6377923ed207','2020-04-07 05:26:12'),(662,'fe5b0b87-b40b-40f8-a762-d9fc8f4a87a6','e6e5d8c5-2d8c-48d0-9708-e3256202d385','2021-02-16 11:48:00'),(662,'fe6fbf6c-0ee6-4b36-8e65-ca271a0819f0','45b21304-1129-40a2-b60e-d72a2bf96e72','2020-04-12 06:05:48'),(662,'ff1d5097-67d0-49a8-b7ee-d5cbee5bd5df','65315958-b964-4f7e-a111-9c7695d8092b','2020-04-17 09:14:14'),(662,'ff42f199-4210-43da-bfae-3dc172610fff','437ef945-eb42-4841-9b20-34804bd5cfd6','2021-06-08 18:38:08'),(662,'ff9a5767-77f0-4ea4-80de-642c5142026c','cb1d5d31-89cd-4ab4-bada-dc6b2235cac5','2020-04-17 09:04:13'),(662,'ffd40c66-bdac-4ae5-8460-6b5fe127d9e0','534cca35-8182-4f61-aa57-03bad8172eac','2020-12-29 10:37:09');
/*!40000 ALTER TABLE `ScanFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentAttachment`
--

DROP TABLE IF EXISTS `SentAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentAttachment` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `sentMessageID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`sentMessageID`,`fileID`),
  KEY `fk_SentAttachment_SentMessage` (`sentMessageID`,`ownerID`),
  KEY `fk_SentAttachment_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_SentAttachment_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SentAttachment_SentMessage` FOREIGN KEY (`sentMessageID`, `ownerID`) REFERENCES `SentMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentAttachment`
--

LOCK TABLES `SentAttachment` WRITE;
/*!40000 ALTER TABLE `SentAttachment` DISABLE KEYS */;
INSERT INTO `SentAttachment` VALUES (662,'0044629b-c48a-4f47-95b1-f178384b2b25','1e41852a-1d94-44eb-90f9-b06c401ee8b7','2022-11-02 17:43:34'),(662,'0044629b-c48a-4f47-95b1-f178384b2b25','4210a84b-05e7-47b1-9d77-62e41dc0e731','2022-11-02 17:43:34'),(662,'0044629b-c48a-4f47-95b1-f178384b2b25','6f481e07-43c0-494b-8d4f-279772780eec','2022-11-02 17:43:34'),(662,'0044629b-c48a-4f47-95b1-f178384b2b25','7cace217-66b4-4147-97f5-c8c1a7dfe1cd','2022-11-02 17:43:34'),(662,'0044629b-c48a-4f47-95b1-f178384b2b25','c063b377-02e8-4830-bf3f-414b4e6325ca','2022-11-02 17:43:34'),(662,'0044629b-c48a-4f47-95b1-f178384b2b25','d82bb8e8-709c-4148-9290-d8b05ce3f7e6','2022-11-02 17:43:34'),(662,'0044629b-c48a-4f47-95b1-f178384b2b25','dc97d683-1aa5-4aba-bf5c-a43b36478d90','2022-11-02 17:43:34'),(662,'0044629b-c48a-4f47-95b1-f178384b2b25','f3d5a2ce-9a80-4c06-a1b4-85bce5e716ea','2022-11-02 17:43:34'),(662,'0fc3bc59-0e74-46f1-9d1b-4edee6fffcc3','a6c49c5b-a994-457c-80d2-6cd69b636979','2022-06-27 19:35:56'),(662,'0fc3bc59-0e74-46f1-9d1b-4edee6fffcc3','f9419645-8fbf-4bf1-99ba-df5bd8485ab2','2022-06-27 19:35:56'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','169331da-dbab-454e-828b-67287bb2feb7','2020-04-30 18:26:55'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','1e3c210c-a983-4276-916c-6c49b0e64e1d','2020-04-30 18:26:55'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','1e81852e-fdc6-4523-9e33-47494d60d953','2020-04-30 18:26:55'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','1f608503-4867-4253-a143-dd200e0ebe0a','2020-04-30 18:26:55'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','51c81dd7-f872-4092-9a17-d9b3821ed7c8','2020-04-30 18:26:55'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','60a7c19d-824d-4fdf-a109-f3df643a3f1a','2020-04-30 18:26:55'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1','2020-04-30 18:26:55'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','9319bd6a-6e7d-4505-8090-e4e10e3caec0','2020-04-30 18:26:55'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','bc10348b-1c26-48ee-bc8f-6fa5ac933a14','2020-04-30 18:26:55'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','f69344e1-d52d-49da-acc5-b714cb86225d','2020-04-30 18:26:55'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','25d2e57a-b759-4ab8-a633-7725e7375d70','2021-09-27 12:02:15'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','2607735b-f648-4b52-882f-e91b883da1be','2021-09-27 12:02:15'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','330dc645-80dc-4734-bc6a-ba2a87b5f495','2021-09-27 12:02:15'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','49635be4-dbea-497c-82e1-206399739c31','2021-09-27 12:02:15'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','73466738-f8a5-4b0e-a6af-9c63c2e802e6','2021-09-27 12:02:15'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','84c96eac-549e-4c1d-a701-896474d66a31','2021-09-27 12:02:15'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','a97b41cc-c47f-42ff-aed9-3b6ec8803714','2021-09-27 12:02:15'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','d5df3022-2abe-4d54-a53d-63cb7ad80b02','2021-09-27 12:02:15'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','ed40ce9a-6d1f-4cfd-a3e2-f58cba946869','2021-09-27 12:02:15'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','f500b4e0-bd2d-4992-901f-526fc78912cf','2021-09-27 12:02:15'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','0a02b656-9179-4cbd-ae14-079f4f933517','2021-10-12 12:40:28'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','0e855e55-dc7f-4eaf-91bd-933232cae95e','2021-10-12 12:40:28'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','20195b26-5345-4f9f-bbd5-4e2ac9fd972d','2021-10-12 12:40:28'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','4f638684-087b-42a0-916a-a8adc0c1eeea','2021-10-12 12:40:28'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','55cd923a-d543-4e42-8f4a-de07877d1b09','2021-10-12 12:40:28'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','791a0795-78ad-4b6e-a31b-bdc257f06704','2021-10-12 12:40:28'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','7b9836aa-2cf6-485a-b0d3-39d73de4bc8b','2021-10-12 12:40:28'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','9617b0df-e829-47cd-8110-fabb587a690d','2021-10-12 12:40:28'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','dd29f41a-cbb1-45d7-8979-1d16d4db487c','2021-10-12 12:40:28'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','f1ef3944-d73f-4a49-8e28-c4619cb61202','2021-10-12 12:40:28'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','169331da-dbab-454e-828b-67287bb2feb7','2020-05-01 06:23:30'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','1e3c210c-a983-4276-916c-6c49b0e64e1d','2020-05-01 06:23:30'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','1e81852e-fdc6-4523-9e33-47494d60d953','2020-05-01 06:23:30'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','1f608503-4867-4253-a143-dd200e0ebe0a','2020-05-01 06:23:30'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','1f629ca9-f822-4a93-aecc-1e8473c82dd5','2020-05-01 06:23:30'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','51c81dd7-f872-4092-9a17-d9b3821ed7c8','2020-05-01 06:23:30'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','60a7c19d-824d-4fdf-a109-f3df643a3f1a','2020-05-01 06:23:30'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','8633595a-6eb0-4dfd-885e-9648bf6c088f','2020-05-01 06:23:30'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1','2020-05-01 06:23:30'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','bc10348b-1c26-48ee-bc8f-6fa5ac933a14','2020-05-01 06:23:30'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','f69344e1-d52d-49da-acc5-b714cb86225d','2020-05-01 06:23:30'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','169331da-dbab-454e-828b-67287bb2feb7','2020-05-01 06:31:26'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','1e3c210c-a983-4276-916c-6c49b0e64e1d','2020-05-01 06:31:26'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','1e81852e-fdc6-4523-9e33-47494d60d953','2020-05-01 06:31:26'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','1f608503-4867-4253-a143-dd200e0ebe0a','2020-05-01 06:31:26'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','51c81dd7-f872-4092-9a17-d9b3821ed7c8','2020-05-01 06:31:26'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','60a7c19d-824d-4fdf-a109-f3df643a3f1a','2020-05-01 06:31:26'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1','2020-05-01 06:31:26'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','9319bd6a-6e7d-4505-8090-e4e10e3caec0','2020-05-01 06:31:26'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','95ab2e1b-4b91-4bb5-965e-8086f8805dc7','2020-05-01 06:31:26'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','afb6acdc-fdfd-416b-a94d-62c0ccaf4043','2020-05-01 06:31:26'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','bc10348b-1c26-48ee-bc8f-6fa5ac933a14','2020-05-01 06:31:26'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','f69344e1-d52d-49da-acc5-b714cb86225d','2020-05-01 06:31:26'),(662,'465925b7-af46-4fc1-9b89-8f9ef2a8753b','1f02ce0a-9100-460e-987f-c2b91eda5ac1','2020-04-10 07:20:48'),(662,'465925b7-af46-4fc1-9b89-8f9ef2a8753b','3c573ce9-f6b2-4667-9726-f5aed56d3325','2020-04-10 07:20:48'),(662,'465925b7-af46-4fc1-9b89-8f9ef2a8753b','99642a2a-dd48-414b-a8ef-1621aa6040ca','2020-04-10 07:20:48'),(662,'465925b7-af46-4fc1-9b89-8f9ef2a8753b','bb2755e4-36de-4604-9ee9-d2711661ea1d','2020-04-10 07:20:48'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','0abfe6c8-8321-4681-9ffd-944418ed370c','2020-04-15 06:51:44'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','2129ad39-4745-4e82-a5b8-dcf7933c6ae7','2020-04-15 06:51:44'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','27755e68-98ae-4662-a39e-c3ea4ba3cdd4','2020-04-15 06:51:44'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','2a2002a5-6321-4c63-938e-7276412e6a28','2020-04-15 06:51:44'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','3a8a47b1-96a0-4e8f-a7fa-d5c2f74f3677','2020-04-15 06:51:44'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','3f126af5-ce2b-4e13-8fc8-9811ab5d462c','2020-04-15 06:51:44'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','48632fc1-3269-4a7f-bdaa-980e30af0358','2020-04-15 06:51:44'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','a2156f23-da3f-4a2a-97f3-76ea6c877521','2020-04-15 06:51:44'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','a483fb03-0adb-4387-9099-c9c2567855e7','2020-04-15 06:51:44'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','a5903ca6-45db-41cc-a262-19592ff5f2e4','2020-04-15 06:51:44'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','b2cc5b60-1704-4150-aead-5e59b3575b06','2020-04-15 06:51:44'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','f574474f-dc28-462d-9251-b23591ca9bcb','2020-04-15 06:51:44'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','3ddb3953-cee7-44fd-b8e2-76afee946647','2021-11-22 11:51:40'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','3ff0f96a-5e61-4469-a401-383ca0d260ac','2021-11-22 11:51:40'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','45a66afe-8bb2-49b4-b3fc-982c845cf2f2','2021-11-22 11:51:40'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','587c45f4-d25d-4cad-8934-761b77e11986','2021-11-22 11:51:40'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','5f516c96-8333-49f5-8c71-3a7e8878488c','2021-11-22 11:51:40'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','6420c2d7-bcdf-4e2e-9ee7-e90e3b7b7045','2021-11-22 11:51:40'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','7a4d7123-69ae-4260-adf1-9661ad22cb0f','2021-11-22 11:51:40'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','c8503263-9efa-47b8-8764-2bb09be6a1cb','2021-11-22 11:51:40'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','f880f49e-bb57-430d-8212-dcb8e015569f','2021-11-22 11:51:40'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','f8d60891-9893-425b-9839-c04fdf0d0cd5','2021-11-22 11:51:40'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','169331da-dbab-454e-828b-67287bb2feb7','2020-04-30 18:27:47'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','1e3c210c-a983-4276-916c-6c49b0e64e1d','2020-04-30 18:27:47'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','1e81852e-fdc6-4523-9e33-47494d60d953','2020-04-30 18:27:47'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','1f608503-4867-4253-a143-dd200e0ebe0a','2020-04-30 18:27:47'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','51c81dd7-f872-4092-9a17-d9b3821ed7c8','2020-04-30 18:27:47'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','60a7c19d-824d-4fdf-a109-f3df643a3f1a','2020-04-30 18:27:47'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1','2020-04-30 18:27:47'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','9319bd6a-6e7d-4505-8090-e4e10e3caec0','2020-04-30 18:27:47'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','9533b2b7-5385-4d5f-8858-b01c1c030817','2020-04-30 18:27:47'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','9a62fabe-8dd2-441c-b9f8-7ad80abd136a','2020-04-30 18:27:47'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','bc10348b-1c26-48ee-bc8f-6fa5ac933a14','2020-04-30 18:27:47'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','f69344e1-d52d-49da-acc5-b714cb86225d','2020-04-30 18:27:47'),(662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','3efa61b2-db0f-47ba-a009-383d9c565444','2020-04-17 05:56:49'),(662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','4b5c8093-db62-4195-8bba-5349a152c006','2020-04-17 05:56:49'),(662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','5c922725-b41b-4e38-a244-6a9a320d291e','2020-04-17 05:56:49'),(662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','675a601d-d389-403d-858d-555ff6166630','2020-04-17 05:56:49'),(662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','95cc936b-2c0c-4fdd-8d11-8780095dabca','2020-04-17 05:56:49'),(662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','b25a25e2-610a-466d-a4d8-7518a09b9a78','2020-04-17 05:56:49'),(662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','e18ed074-c432-415e-b63e-3b73dcb95e72','2020-04-17 05:56:49'),(662,'76a19cfc-ee2e-426f-b476-ac85c20f660d','9d5d6282-185b-45e3-8902-11f6f83c2991','2020-04-12 06:17:04'),(662,'76a19cfc-ee2e-426f-b476-ac85c20f660d','f6615787-bb2f-4f28-b265-517b66795996','2020-04-12 06:17:04'),(662,'7fb08821-81d8-4569-9f19-ef8022fea368','2cff0ba7-eee7-4c7f-99af-34c690eb3868','2022-08-06 11:59:36'),(662,'7fb08821-81d8-4569-9f19-ef8022fea368','e22ce6e5-78b3-470f-8eac-fc2668ff13bc','2022-08-06 11:59:36'),(662,'8aa64af3-968d-45f4-b276-c5dbd500e07a','144ce692-0397-4de4-aa07-e50e85b5a553','2020-07-13 17:47:49'),(662,'8aa64af3-968d-45f4-b276-c5dbd500e07a','22b17811-0494-42ee-a82c-e9e5fe8e4ae4','2020-07-13 17:47:49'),(662,'8aa64af3-968d-45f4-b276-c5dbd500e07a','e94bbc94-0540-4634-816e-4a842ced15fa','2020-07-13 17:47:49'),(662,'8aa64af3-968d-45f4-b276-c5dbd500e07a','f35334e9-a7ce-43a7-845e-98ae1de51100','2020-07-13 17:47:49'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','13991d0c-102a-4df8-aaad-f5f422edc6be','2021-11-23 11:24:37'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','1712177a-2d33-429e-81ed-e58b3ec65c4d','2021-11-23 11:24:37'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','45a97d29-279f-4720-856d-2ef701665f93','2021-11-23 11:24:37'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','4a84b07a-6e20-4dea-85d3-199cb3adf0f5','2021-11-23 11:24:37'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','963a8acf-cdb2-41d5-b187-9a7c885ac2a0','2021-11-23 11:24:37'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','9b87eb98-b2ac-4d29-83ea-5125f3d83710','2021-11-23 11:24:37'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','a3d56e52-a954-4894-b840-be0425c42658','2021-11-23 11:24:37'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','c19a9e26-b162-4808-8d10-9d6a38e24e98','2021-11-23 11:24:37'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','e31677ad-6acd-445e-8577-f3c741a13dc2','2021-11-23 11:24:37'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','ebf4cbaa-94a5-42c6-aad4-4f61d8ad16b8','2021-11-23 11:24:37'),(662,'928854eb-377d-4b8b-8ea6-eeb3057a66b9','1ab759da-dceb-48e2-83be-326054416d3c','2022-09-19 13:19:17'),(662,'928854eb-377d-4b8b-8ea6-eeb3057a66b9','41f1c7ba-1d8c-47b9-8ed9-11f004bb7681','2022-09-19 13:19:17'),(662,'928854eb-377d-4b8b-8ea6-eeb3057a66b9','dd19221a-2e2b-4f03-9062-62bb291352d2','2022-09-19 13:19:17'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','0abfe6c8-8321-4681-9ffd-944418ed370c','2020-04-15 06:27:54'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','0fd33c57-ea90-4557-bed0-d59a4b5f2c80','2020-04-15 06:27:54'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','11798976-f244-45ce-883c-778a6a2a0bc3','2020-04-15 06:27:54'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','2129ad39-4745-4e82-a5b8-dcf7933c6ae7','2020-04-15 06:27:54'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','2a2002a5-6321-4c63-938e-7276412e6a28','2020-04-15 06:27:54'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','3a8a47b1-96a0-4e8f-a7fa-d5c2f74f3677','2020-04-15 06:27:54'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','3f126af5-ce2b-4e13-8fc8-9811ab5d462c','2020-04-15 06:27:54'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','48632fc1-3269-4a7f-bdaa-980e30af0358','2020-04-15 06:27:54'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','a2156f23-da3f-4a2a-97f3-76ea6c877521','2020-04-15 06:27:54'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','a483fb03-0adb-4387-9099-c9c2567855e7','2020-04-15 06:27:54'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','a5903ca6-45db-41cc-a262-19592ff5f2e4','2020-04-15 06:27:54'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','f574474f-dc28-462d-9251-b23591ca9bcb','2020-04-15 06:27:54'),(662,'93c345d1-454a-42fa-bfa7-8d68827d23f5','520242d1-a563-40d8-b43b-1c26fd0f28ff','2023-03-21 11:31:04'),(662,'93c345d1-454a-42fa-bfa7-8d68827d23f5','ab2de538-1cbb-481f-a82e-899f47da34b7','2023-03-21 11:31:04'),(662,'9c5638bd-fe4f-41c6-a7a7-5c3c908a9555','9d5d6282-185b-45e3-8902-11f6f83c2991','2020-04-12 06:29:34'),(662,'9c5638bd-fe4f-41c6-a7a7-5c3c908a9555','f6615787-bb2f-4f28-b265-517b66795996','2020-04-12 06:29:34'),(662,'9c8474e3-ae2e-4f02-af12-ee8d56ae6406','06e08af9-0736-40b6-93e5-bdffccb8ea44','2022-06-28 18:41:05'),(662,'9c8474e3-ae2e-4f02-af12-ee8d56ae6406','a4f0f4fa-9346-4a75-a1dd-e95c83dc5e6b','2022-06-28 18:41:05'),(662,'b43015be-893c-4d0c-8657-1cd6c0eadc67','09549052-25f2-4ebe-8844-ee815b650573','2020-04-12 06:28:41'),(662,'b43015be-893c-4d0c-8657-1cd6c0eadc67','ebcf2fdf-8f60-4590-bf41-6c7e360d6441','2020-04-12 06:28:41'),(662,'b77a9c9d-2d03-4860-b7b9-86e311c509ed','4a35756e-57f1-4f26-a7da-64af3396fbad','2022-09-14 10:25:44'),(662,'b77a9c9d-2d03-4860-b7b9-86e311c509ed','bafe042a-2298-470c-8d08-071e0f4e388e','2022-09-14 10:25:44'),(662,'bac96ac3-3fbd-4776-96d5-a1fcf7139710','06da4522-e34d-40fd-b96f-ca51c40618cc','2023-01-11 12:47:49'),(662,'bac96ac3-3fbd-4776-96d5-a1fcf7139710','6fe553ac-625b-4942-ad10-01bbe5250717','2023-01-11 12:47:49'),(662,'c13ba56c-2431-4f83-a199-a713f2029337','689b438f-3633-4981-b669-5e49a97a5c95','2022-12-21 11:18:08'),(662,'c13ba56c-2431-4f83-a199-a713f2029337','90d34496-4e10-41d5-b77c-75826f81327e','2022-12-21 11:18:08'),(662,'d3010d97-e435-4fa5-9054-e4add927b37f','6ea3e979-830a-4dd4-81e2-3d30db702b9c','2022-11-04 11:40:18'),(662,'d3010d97-e435-4fa5-9054-e4add927b37f','850a1a2e-2e87-4cda-8ec5-a2dcd149731d','2022-11-04 11:40:18'),(662,'d3010d97-e435-4fa5-9054-e4add927b37f','b6b42cf7-31c1-49e1-b1d1-c607c7ba299b','2022-11-04 11:40:18'),(662,'d3010d97-e435-4fa5-9054-e4add927b37f','c9051630-ef52-45e0-bf72-eef2676192c8','2022-11-04 11:40:18'),(662,'de057ea0-5a8b-4969-8ceb-44a19644bb0d','31421697-5459-439e-919b-169d051646f5','2020-04-13 05:59:28'),(662,'de057ea0-5a8b-4969-8ceb-44a19644bb0d','60447943-1739-4e3f-aced-0eb015c274a2','2020-04-13 05:59:28'),(662,'de057ea0-5a8b-4969-8ceb-44a19644bb0d','7cd8a534-43de-41bd-9f1a-216a2bfc251d','2020-04-13 05:59:28'),(662,'de057ea0-5a8b-4969-8ceb-44a19644bb0d','9cd5b1c8-ef15-449d-97a1-bdf6947abe78','2020-04-13 05:59:28'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','07615b33-5390-4fe1-9fbb-9ec7cbd64d40','2022-01-11 11:43:41'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','5c2ae31f-cf6e-42c8-9d38-6f41e1e8db02','2022-01-11 11:43:41'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','6918be85-b74b-4069-b2b3-914477ca77ad','2022-01-11 11:43:41'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','6fa55f91-2e1f-436b-b276-b2726e9125b4','2022-01-11 11:43:41'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','9210c2bb-cc5b-4ccf-a432-8adf915d5673','2022-01-11 11:43:41'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','a3ae3378-e8e9-495e-9dc6-8a3be2a9a968','2022-01-11 11:43:41'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','b01eb471-5baa-4958-b2c6-736eab81754a','2022-01-11 11:43:41'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','ce7041b4-86ce-4167-b150-b49d4f0008a6','2022-01-11 11:43:41'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','d5ddb4c9-b9d4-4dbd-91ab-8ba108c565e0','2022-01-11 11:43:41'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','f06e433d-c712-4081-adba-9051f0c10c4e','2022-01-11 11:43:41');
/*!40000 ALTER TABLE `SentAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentMessage`
--

DROP TABLE IF EXISTS `SentMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentMessage` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `subject` varchar(45) NOT NULL,
  `body` text,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `discussionID` char(36) NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SentMessage_Discussion` (`discussionID`,`ownerID`),
  CONSTRAINT `fk_SentMessage_Discussion` FOREIGN KEY (`discussionID`, `ownerID`) REFERENCES `Discussion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentMessage`
--

LOCK TABLES `SentMessage` WRITE;
/*!40000 ALTER TABLE `SentMessage` DISABLE KEYS */;
INSERT INTO `SentMessage` VALUES (662,'0044629b-c48a-4f47-95b1-f178384b2b25','2022-11-02 18:43:34','#','SMILERS n° 1.19.3.S1',NULL,'2022-11-02 18:43:35','2022-11-02 17:43:35','2022-11-02 18:43:34','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'0fc3bc59-0e74-46f1-9d1b-4edee6fffcc3','2022-06-27 21:35:56','#','SMILERS n° 1.21.2.S1',NULL,'2022-06-27 21:35:56','2022-06-27 19:35:56','2022-06-27 21:35:56','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','2020-04-30 20:26:55','#','#',NULL,'2020-04-30 20:44:40','2020-04-30 18:44:40','2020-04-30 20:26:55','ac9d94b7-3541-4923-a2a8-fe429c22fbab'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','2021-09-27 14:02:15','#','SMILERS n° 1.19.1.S1',NULL,'2021-09-27 14:02:21','2021-09-27 12:02:21','2021-09-27 14:02:15','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','2021-10-12 14:40:28','#','SMILERS n° 1.20.1.S1',NULL,'2021-10-12 14:40:28','2021-10-12 12:40:28','2021-10-12 14:40:28','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','2020-05-01 08:23:30','#','Commande n° 1.10.1.2',NULL,'2020-05-01 08:23:31','2020-05-01 06:23:31','2020-05-01 08:23:30','ac9d94b7-3541-4923-a2a8-fe429c22fbab'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','2020-05-01 08:31:26','#','Commande n° 1.10.1.3',NULL,'2020-05-01 08:31:27','2020-05-01 06:31:27','2020-05-01 08:31:26','ac9d94b7-3541-4923-a2a8-fe429c22fbab'),(662,'465925b7-af46-4fc1-9b89-8f9ef2a8753b','2020-04-10 09:20:48','#','Commande n° 1.5.1.3',NULL,'2020-04-10 09:27:05','2020-04-10 07:27:05','2020-04-10 09:20:48','ac9d94b7-3541-4923-a2a8-fe429c22fbab'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','2020-04-15 08:51:44','#','Commande n° 1.7.2.2',NULL,'2020-04-15 08:51:46','2020-04-15 06:51:46','2020-04-15 08:51:44','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','2021-11-22 12:51:40','#','SMILERS n° 1.21.1.S1',NULL,'2021-11-22 12:51:41','2021-11-22 11:51:41','2021-11-22 12:51:40','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','2020-04-30 20:27:47','#','Commande n° 1.10.1.1',NULL,'2020-04-30 20:44:40','2020-04-30 18:44:40','2020-04-30 20:27:47','ac9d94b7-3541-4923-a2a8-fe429c22fbab'),(662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','2020-04-17 07:56:49','#','Commande n° 1.6.1.1',NULL,'2020-04-17 07:56:51','2020-04-17 05:56:51','2020-04-17 07:56:49','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'76a19cfc-ee2e-426f-b476-ac85c20f660d','2020-04-12 08:17:04','#','Test',NULL,'2020-04-13 07:32:16','2020-04-13 05:32:16','2020-04-12 08:17:04','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'7fb08821-81d8-4569-9f19-ef8022fea368','2022-08-06 13:59:36','#','SMILERS n° 1.20.2.S1',NULL,'2022-08-06 13:59:41','2022-08-06 11:59:41','2022-08-06 13:59:36','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'8aa64af3-968d-45f4-b276-c5dbd500e07a','2020-07-13 19:47:49','#','Commande n° 1.5.3.1',NULL,'2020-07-13 19:47:50','2020-07-13 17:47:50','2020-07-13 19:47:49','ac9d94b7-3541-4923-a2a8-fe429c22fbab'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','2021-11-23 12:24:37','#','SMILERS n° 1.22.1.S1',NULL,'2021-11-23 12:24:44','2021-11-23 11:24:44','2021-11-23 12:24:37','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'928854eb-377d-4b8b-8ea6-eeb3057a66b9','2022-09-19 15:19:17','#','Commande n° 1.28.1.1',NULL,NULL,'2022-09-19 13:19:17','2022-09-19 15:19:17','2b95263d-2fff-42df-8b92-6a30e3bdc543'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','2020-04-15 08:27:54','#','Commande n° 1.7.2.1',NULL,'2020-04-15 08:27:55','2020-04-15 06:27:55','2020-04-15 08:27:54','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'93c345d1-454a-42fa-bfa7-8d68827d23f5','2023-03-21 12:31:04','#','SMILERS n° 1.19.4.S1',NULL,'2023-03-21 12:31:05','2023-03-21 11:31:05','2023-03-21 12:31:04','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'9c5638bd-fe4f-41c6-a7a7-5c3c908a9555','2020-04-12 08:29:34','#','#',NULL,'2020-04-13 07:32:16','2020-04-13 05:32:16','2020-04-12 08:29:34','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'9c8474e3-ae2e-4f02-af12-ee8d56ae6406','2022-06-28 20:41:05','#','SMILERS n° 1.19.2.S1',NULL,'2022-06-28 20:41:11','2022-06-28 18:41:11','2022-06-28 20:41:05','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'b43015be-893c-4d0c-8657-1cd6c0eadc67','2020-04-12 08:28:41','#','Commande n° 1.2.3.1',NULL,'2020-04-13 07:32:17','2020-04-13 05:32:17','2020-04-12 08:28:41','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'b77a9c9d-2d03-4860-b7b9-86e311c509ed','2022-09-14 12:25:44','#','SMILERS n° 1.21.3.S1',NULL,'2022-09-14 12:25:51','2022-09-14 10:25:51','2022-09-14 12:25:44','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'bac96ac3-3fbd-4776-96d5-a1fcf7139710','2023-01-11 13:47:49','#','SMILERS n° 1.21.7.S1',NULL,'2023-01-11 13:47:52','2023-01-11 12:47:52','2023-01-11 13:47:49','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'c13ba56c-2431-4f83-a199-a713f2029337','2022-12-21 12:18:08','#','SMILERS n° 1.21.6.S1',NULL,'2022-12-21 12:18:10','2022-12-21 11:18:10','2022-12-21 12:18:08','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'d3010d97-e435-4fa5-9054-e4add927b37f','2022-11-04 12:40:18','#','SMILERS n° 1.21.4.S1',NULL,'2022-11-04 12:40:20','2022-11-04 11:40:20','2022-11-04 12:40:18','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'de057ea0-5a8b-4969-8ceb-44a19644bb0d','2020-04-13 07:59:28','#','Commande n° 1.2.2.2',NULL,'2020-04-13 07:59:31','2020-04-13 05:59:31','2020-04-13 07:59:28','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','2022-01-11 12:43:41','#','SMILERS n° 1.23.1.S1',NULL,'2022-01-11 12:43:43','2022-01-11 11:43:43','2022-01-11 12:43:41','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa');
/*!40000 ALTER TABLE `SentMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentOrderNotification`
--

DROP TABLE IF EXISTS `SentOrderNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentOrderNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `orderID` char(36) DEFAULT NULL,
  `recipientID` char(36) DEFAULT NULL,
  `rescueData` text,
  `deliveryDate` datetime DEFAULT NULL,
  `event` enum('edited','validated','cancelled') NOT NULL DEFAULT 'edited',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SentOrderNotification_Professional` (`ownerID`),
  KEY `fk_SentOrderNotification_Contact` (`recipientID`,`ownerID`),
  KEY `fk_SentOrderNotification_ProstheticOrder` (`orderID`,`ownerID`),
  CONSTRAINT `fk_SentOrderNotification_Contact` FOREIGN KEY (`recipientID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_SentOrderNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SentOrderNotification_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentOrderNotification`
--

LOCK TABLES `SentOrderNotification` WRITE;
/*!40000 ALTER TABLE `SentOrderNotification` DISABLE KEYS */;
INSERT INTO `SentOrderNotification` VALUES (662,'686c25a2-2a5b-4d43-a61f-c19e145c6e63','63706c26-d501-4c56-bdc2-ab2c76f6d988','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','{\"recipientDisplayName\":\"Michael Maylin\",\"patientDisplayID\":\"1.10\",\"orderTitle\":\"AUTRE FICHE PROTH\\u00c9TIQUE\",\"sheetType\":\"OTHER\"}','2020-05-09 12:00:00','validated',0,'2020-05-02 21:58:19',NULL,'2020-05-02 21:58:19','2020-07-08 19:44:03','2020-07-08 17:44:03'),(662,'84483bc1-ebfc-4b69-b772-670a1a24ceda','b1c50855-9551-467e-94d9-915a6218ec1b','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','{\"recipientDisplayName\":\"Michael Maylin\",\"patientDisplayID\":\"1.5\",\"orderTitle\":\"GOUTTI\\u00c8RE\",\"sheetType\":\"GOUTTIERE\"}','2020-07-27 12:00:00','validated',0,'2020-07-15 23:04:22',NULL,'2020-09-09 19:44:24','2020-09-09 19:44:24','2020-09-09 17:44:24'),(662,'f507cf26-e77b-403d-a779-ec8aa5a6f114','eb120496-ad30-4640-856b-fbdd1139c529','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','{\"recipientDisplayName\":\"Michael Maylin\",\"patientDisplayID\":\"1.5\",\"orderTitle\":\"ODF\",\"sheetType\":\"ODF\"}','2020-04-11 00:00:01','validated',0,'2020-04-10 09:29:08',NULL,'2020-04-12 07:51:30','2020-04-12 07:51:29','2020-04-12 05:51:30');
/*!40000 ALTER TABLE `SentOrderNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Session`
--

DROP TABLE IF EXISTS `Session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Session` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `comments` mediumtext,
  `actID` char(36) NOT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `mandibuleOcclusionPlyID` char(36) DEFAULT NULL,
  `maxillaireOcclusionPlyID` char(36) DEFAULT NULL,
  `matrixTransformationMandibuleID` char(36) DEFAULT NULL,
  `matrixTransformationMaxillaireID` char(36) DEFAULT NULL,
  `snapshotID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Occlusion_Work` (`actID`,`ownerID`),
  KEY `fk_Session_CondorFile_mandibulePly` (`mandibuleOcclusionPlyID`,`ownerID`),
  KEY `fk_Session_CondorFile_matrixTransformationMandibule` (`matrixTransformationMandibuleID`,`ownerID`),
  KEY `fk_Session_CondorFile_maxillairePly` (`maxillaireOcclusionPlyID`,`ownerID`),
  KEY `fk_Session_CondorFile_matrixTransformationMaxillaire` (`matrixTransformationMaxillaireID`,`ownerID`),
  KEY `fk_Session_CondorFile_maxillairePointContact` (`ownerID`),
  KEY `fk_Session_CondorFile_snapshot` (`snapshotID`,`ownerID`),
  CONSTRAINT `fk_Session_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_mandibulePly` FOREIGN KEY (`mandibuleOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_matrixTransformationMandibule` FOREIGN KEY (`matrixTransformationMandibuleID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_matrixTransformationMaxillaire` FOREIGN KEY (`matrixTransformationMaxillaireID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_maxillairePly` FOREIGN KEY (`maxillaireOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_snapshot` FOREIGN KEY (`snapshotID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Session`
--

LOCK TABLES `Session` WRITE;
/*!40000 ALTER TABLE `Session` DISABLE KEYS */;
INSERT INTO `Session` VALUES (662,'02bb64b6-8c8d-4a83-8015-e492bca9eef9','Sous dossier 2','72c58d79-1141-4c63-b343-909886db5520',1,2,NULL,NULL,NULL,NULL,NULL,'2020-09-09 19:48:13','2020-04-27 16:48:57','2020-09-09 17:48:13','2020-04-27 16:48:57','2020-04-27 16:48:57'),(662,'05d9d2c1-1f20-4354-a592-64635302fe66','Sous dossier 5','2a050d02-7424-4099-b1d0-2d7da678e690',1,5,NULL,NULL,NULL,NULL,NULL,NULL,'2022-12-14 17:39:21','2022-12-14 16:39:21','2022-12-14 17:39:20','2022-12-14 17:39:20'),(662,'06abdb47-7e29-4e95-9502-9d46516a1b3e','Sous dossier 2','87965ef8-01eb-4830-8e8b-8b99ece62cf1',1,2,NULL,NULL,NULL,NULL,NULL,NULL,'2022-06-27 21:27:19','2022-06-27 19:27:19','2022-06-27 21:27:18','2022-06-27 21:27:18'),(662,'09f15124-6bba-4565-bfe4-efb3c6c3a17d','Sous dossier 1','e43c8099-0862-42c3-9ad2-1efef27b83ba',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-14 12:23:57','2022-09-14 10:23:57','2022-09-14 12:23:55','2022-09-14 12:00:27'),(662,'0c7a1791-2e32-4203-90d5-5b8c008be303','Sous dossier 2','47a8d99f-668b-4bb6-b3bf-7bff221d397f',1,2,NULL,NULL,NULL,NULL,NULL,'2020-04-16 11:39:43','2020-04-16 10:42:19','2020-04-16 09:39:43','2020-04-16 10:42:18','2020-04-16 10:42:18'),(662,'0e9f7103-7fec-4143-b69a-773b4bf0d88e','Sous dossier 5','ec084612-67a2-4430-ae15-7fe0edeaca64',1,5,NULL,NULL,NULL,NULL,NULL,'2020-09-09 19:48:13','2020-04-14 11:25:15','2020-09-09 17:48:13','2020-04-14 11:25:14','2020-04-14 11:25:14'),(662,'10ddc224-efea-4e4a-8b51-1a76343500fb','Sous dossier 4','ec084612-67a2-4430-ae15-7fe0edeaca64',1,4,NULL,NULL,NULL,NULL,NULL,'2020-09-09 19:48:13','2020-04-13 07:32:15','2020-09-09 17:48:13','2020-04-12 08:26:54','2020-04-12 08:26:54'),(662,'12115366-8eb9-470b-a097-5d28bb5fdf38','Sous dossier 1','7841125a-11dd-4b66-9179-cd371ea2f0f7',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-01-11 12:41:17','2022-01-11 11:41:17','2022-01-11 12:41:15','2022-01-11 12:05:43'),(662,'138fb819-9955-48f9-b4d4-5cd401004cf3','Sous dossier 4','64834083-3320-4687-9710-c2be0d9c7198',1,4,NULL,NULL,NULL,NULL,NULL,NULL,'2020-04-30 20:26:01','2020-04-30 18:26:01','2020-04-30 20:26:01','2020-04-30 20:26:01'),(662,'16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c','Sous dossier 1','72b7a457-e38f-4535-8eba-6c98b43e5e55',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2021-06-08 20:56:55','2021-06-08 18:56:55','2021-06-08 20:56:54','2021-06-08 19:43:08'),(662,'1a616ac1-2ca3-4d23-ae5e-349558c26c37','Sous dossier 1','801b987d-e335-4276-8bc6-1fa57b553716',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-13 19:51:38','2020-07-13 17:51:38','2020-07-13 19:51:37','2020-04-11 07:23:51'),(662,'1ec1f707-d702-496a-b2f0-e55b08c06dcb','Sous dossier 1','c47ee4d9-c646-4836-8152-fc2ded70b4fe',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2021-02-01 21:23:42','2021-02-01 20:23:42','2021-02-01 21:23:41','2021-02-01 20:10:34'),(662,'20a5abad-ea33-4348-bb3a-69c66c38759b','Sous dossier 1','acce421f-f39c-414a-a216-6f01af8c33c4',1,1,NULL,NULL,NULL,NULL,NULL,'2022-06-27 21:12:46',NULL,'2022-06-27 19:12:46','2022-06-10 20:22:14','2022-06-10 20:22:14'),(662,'20b31e3a-565c-49b0-b2ff-0dae86b25c76','Sous dossier 1','1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 11:48:38','2022-09-19 09:48:38','2022-09-19 11:48:35','2022-09-19 10:52:05'),(662,'24774ba0-9e7c-4a7b-acdb-bb756c33e9af','Sous dossier 4','801b987d-e335-4276-8bc6-1fa57b553716',1,4,NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-13 19:50:52','2020-07-13 17:50:52','2020-07-13 19:50:51','2020-07-13 19:50:51'),(662,'24a336d6-8f49-456f-8160-b0e6ecc31cbd','Sous dossier 2','b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c',1,2,NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-29 11:57:42','2020-12-29 10:57:42','2020-12-29 11:48:10','2020-12-29 11:48:10'),(662,'254f3fc9-4782-4658-bb34-f2ca1c9b6382','Sous dossier 1','a7b0f1ae-ce37-4faf-9b3c-e5fab6996549',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-13 19:07:32','2020-07-13 17:07:32','2020-05-21 08:13:17','2020-05-21 07:47:54'),(662,'296c061e-734b-4936-8af7-1f80653eff11','Sous dossier 1','7813c59a-91e7-4c2c-8027-bcc3c35c797c',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-04-08 08:50:10','2020-04-08 06:50:10','2020-04-08 08:50:09','2020-04-06 11:13:09'),(662,'2ac47a50-77d4-4d5e-8baf-71e2882b89bc','Sous dossier 4','2a050d02-7424-4099-b1d0-2d7da678e690',1,4,NULL,NULL,NULL,NULL,NULL,NULL,'2022-12-14 17:39:03','2022-12-14 16:39:03','2022-12-14 17:39:01','2022-12-14 17:39:01'),(662,'2b934532-4b04-4025-8e7f-894c9c01b184','Sous dossier 3','cb9d8495-b4dd-423f-a624-7cff70e4db55',1,3,NULL,NULL,NULL,NULL,NULL,'2020-04-14 12:10:38','2020-04-07 10:19:43','2020-04-14 10:10:38','2020-04-07 10:19:43','2020-04-07 07:10:59'),(662,'2ed4960a-e6fa-46de-a306-32385df3346c','Sous dossier 2','ec084612-67a2-4430-ae15-7fe0edeaca64',1,2,NULL,NULL,NULL,NULL,NULL,'2020-09-09 19:48:13','2020-04-14 11:25:42','2020-09-09 17:48:13','2020-04-14 11:25:42','2020-04-12 07:50:13'),(662,'31210683-bc06-4b84-83d9-ce60f32308e4','Sous dossier 1','b498bdf4-2e5b-497a-8bfe-b65edabac3bc',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2021-11-23 12:23:20','2021-11-23 11:23:20','2021-11-23 12:23:17','2021-11-23 11:57:21'),(662,'348477f7-c7a9-4bb3-8b28-3da592902286','Sous dossier 1','100a15d0-4590-4544-9331-365a087a5b57',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-04-29 14:51:47','2020-04-29 12:51:47','2020-04-29 14:50:37','2020-04-29 14:25:45'),(662,'37da7c96-1d18-41f2-aa42-58d6c1c09fa8','Sous dossier 4','1ce80886-d3f3-42d8-872a-a2eba69d0005',1,4,NULL,NULL,NULL,NULL,NULL,'2020-04-16 11:39:43','2020-04-16 10:40:41','2020-04-16 09:39:43','2020-04-16 10:40:40','2020-04-16 10:40:40'),(662,'3d8aaee3-2fbd-43cd-8404-58e3f043e115','Sous dossier 3','7813c59a-91e7-4c2c-8027-bcc3c35c797c',1,3,NULL,NULL,NULL,NULL,NULL,NULL,'2020-04-08 08:51:36','2020-04-08 06:51:36','2020-04-08 08:51:36','2020-04-08 08:50:18'),(662,'3dc7ad32-46c5-4609-9e85-6caf219fd0e4','Sous dossier 3','2a050d02-7424-4099-b1d0-2d7da678e690',1,3,NULL,NULL,NULL,NULL,NULL,NULL,'2022-12-14 15:05:03','2022-12-14 14:05:03','2022-12-14 15:05:01','2022-12-14 15:05:01'),(662,'3f054759-67f1-4946-baff-769847612456','Sous dossier 7','2a050d02-7424-4099-b1d0-2d7da678e690',1,7,NULL,NULL,NULL,NULL,NULL,NULL,'2022-12-14 17:39:33','2022-12-14 16:39:33','2022-12-14 17:39:32','2022-12-14 17:39:32'),(662,'45c9a361-1434-40a0-be6c-21b8daa71eb4','Sous dossier 3','64834083-3320-4687-9710-c2be0d9c7198',1,3,NULL,NULL,NULL,NULL,NULL,NULL,'2020-04-30 20:26:00','2020-04-30 18:26:00','2020-04-30 20:26:00','2020-04-30 20:26:00'),(662,'470b4b2e-2db4-4a3d-8ea0-949ea7220994','Sous dossier 2','cb9d8495-b4dd-423f-a624-7cff70e4db55',1,2,NULL,NULL,NULL,NULL,NULL,'2020-04-07 07:11:56','2020-04-07 07:11:56','2020-04-07 05:11:56','2020-04-07 07:05:32','2020-04-07 07:05:32'),(662,'484ae4d8-329f-49b5-8d83-312a8a92ff22','Sous dossier 1','f474819e-9470-4612-8275-2ceb25b5522f',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2021-02-27 10:59:00','2021-02-27 09:59:00','2021-02-27 10:59:00','2021-02-27 09:56:53'),(662,'4af4bd2d-76e3-4905-99fd-191c4cc669fa','Sous dossier 1','d458682a-423b-43fe-a4b0-97d586104341',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-10 09:22:06','2020-04-09 11:05:51','2020-04-10 07:22:06','2020-04-09 11:05:50','2020-04-09 09:16:47'),(662,'4b27d300-e0f9-4687-9c78-cf06a8ed4fd5','Sous dossier 3','47a8d99f-668b-4bb6-b3bf-7bff221d397f',1,3,NULL,NULL,NULL,NULL,NULL,'2020-04-16 11:39:43','2020-04-16 10:42:22','2020-04-16 09:39:43','2020-04-16 10:42:21','2020-04-16 10:42:21'),(662,'4e3d8e8e-3904-46c2-af39-ee76eb907fdf','Sous dossier 3','8f3d7d42-f6ad-4e48-8951-08222c212e7e',1,3,NULL,NULL,NULL,NULL,NULL,NULL,'2022-12-14 14:59:44','2022-12-14 13:59:44','2022-11-04 13:30:41','2022-11-04 13:30:41'),(662,'4e5ca0c8-d316-48f6-9ca8-3570b053c100','Sous dossier 4','8f3d7d42-f6ad-4e48-8951-08222c212e7e',1,4,NULL,NULL,NULL,NULL,NULL,NULL,'2022-12-14 14:59:45','2022-12-14 13:59:45','2022-11-04 13:30:46','2022-11-04 13:30:46'),(662,'52372fba-991e-4b09-abce-2195e775fd19','Sous dossier 1','3d2141bb-462c-4334-b177-d17d136574ae',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2021-11-22 12:49:45','2021-11-22 11:49:45','2021-11-22 12:49:43','2021-11-22 12:11:00'),(662,'53a17fdc-5de8-45aa-a9cb-ebea4886f6ff','Sous dossier 1','c61cdb9c-543c-4809-952c-b65656e1f96f',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-13 19:07:32','2020-07-13 17:07:32','2020-07-08 19:59:48','2020-07-08 18:05:41'),(662,'5780d440-00be-4c16-85e3-e49c262c4329','Sous dossier 2','934f20d2-7444-4367-89e2-61c3bf4bee57',1,2,NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-13 19:49:36','2020-07-13 17:49:36','2020-07-13 19:49:36','2020-07-13 19:49:36'),(662,'5bd97219-8b9e-46f5-ab9b-87ded07aa8a2','Sous dossier 1','8f3d7d42-f6ad-4e48-8951-08222c212e7e',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-04 12:37:12','2022-11-04 11:37:12','2022-11-04 12:34:44','2022-11-04 12:12:28'),(662,'5f895907-3eed-4aa7-995a-f7e1c9661a0a','Sous dossier 1','8f87b136-cb98-4706-b7d4-51059e1afa06',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-03-11 11:16:28','2022-03-11 10:16:28','2022-03-11 11:16:26','2022-03-11 09:55:04'),(662,'6c6bb813-840d-454a-ab1d-9232434a4500','Sous dossier 1','0c1ed331-8df6-482e-8dd1-508d9b190c49',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 13:56:28','2021-09-27 11:56:28','2021-09-27 12:50:13','2021-09-27 12:10:27'),(662,'78636467-a73b-4270-8bc5-35a2664dec9d','Sous dossier 1','ec084612-67a2-4430-ae15-7fe0edeaca64',1,1,NULL,NULL,NULL,NULL,NULL,'2020-09-09 19:48:13','2020-04-14 11:25:36','2020-09-09 17:48:13','2020-04-14 11:25:35','2020-04-12 07:20:52'),(662,'7c0ac6ee-9ee9-4b2e-982d-7e55a2e8b52a','Sous dossier 3','1ce80886-d3f3-42d8-872a-a2eba69d0005',1,3,NULL,NULL,NULL,NULL,NULL,'2020-04-16 11:39:43','2020-04-15 07:13:14','2020-04-16 09:39:43','2020-04-15 07:13:13','2020-04-15 07:13:13'),(662,'844c8213-74c4-4586-a8b8-1a0166bbd2f2','Sous dossier 2','78fbbe11-e1a5-4c10-b6e3-4f00df178dc6',1,2,NULL,NULL,NULL,NULL,NULL,'2020-04-16 11:39:43','2020-04-16 07:16:44','2020-04-16 09:39:43','2020-04-16 07:16:43','2020-04-16 07:16:43'),(662,'86af9a1e-ac57-479e-b67e-5429fbdf4230','Sous dossier 1','c584a5e1-b7d4-4486-abbc-954717a6fe55',1,1,NULL,NULL,NULL,NULL,NULL,'2020-09-09 19:48:13','2020-09-09 19:44:00','2020-09-09 17:48:14','2020-09-09 19:43:59','2020-09-09 19:35:42'),(662,'86e2a9c2-c972-477a-9078-284c53a1371f','Sous dossier 2','2c78d514-95bd-4529-b0a1-babfb83849b1',1,2,NULL,NULL,NULL,NULL,NULL,'2023-01-11 12:46:56',NULL,'2023-01-11 11:46:56','2023-01-11 12:43:10','2023-01-11 12:43:10'),(662,'87507617-fa26-4710-be71-46af136406a7','Sous dossier 3','b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c',1,3,NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-29 11:57:42','2020-12-29 10:57:42','2020-12-29 11:50:26','2020-12-29 11:50:26'),(662,'88170486-b19f-4c31-a435-e67fd24917e9','Sous dossier 1','c42cadf5-5f0e-439e-9aab-087940794316',1,1,NULL,NULL,NULL,NULL,NULL,'2020-12-30 07:52:28',NULL,'2020-12-30 06:52:28','2020-12-29 08:34:38','2020-12-29 08:32:55'),(662,'8d012545-b857-4595-a69d-1a2b1c750e13','Sous dossier 1','72c58d79-1141-4c63-b343-909886db5520',1,1,NULL,NULL,NULL,NULL,NULL,'2020-09-09 19:48:13','2020-04-27 16:48:50','2020-09-09 17:48:13','2020-04-27 16:48:49','2020-04-27 16:14:03'),(662,'8f1f6878-100c-4a92-9c6a-ff59dc6f939d','Sous dossier 2','64834083-3320-4687-9710-c2be0d9c7198',1,2,NULL,NULL,NULL,NULL,NULL,NULL,'2020-04-30 20:24:56','2020-04-30 18:24:56','2020-04-30 20:24:56','2020-04-30 20:24:56'),(662,'93eafd8d-603b-44ec-9e98-f87abc4e3bd8','Sous dossier 3','2c78d514-95bd-4529-b0a1-babfb83849b1',1,3,NULL,NULL,NULL,NULL,NULL,NULL,'2023-01-11 13:42:17','2023-01-11 12:42:17','2023-01-11 12:59:12','2023-01-11 12:59:12'),(662,'949aa0c7-aadb-440d-bb4c-c18dbb342fe6','Sous dossier 3','934f20d2-7444-4367-89e2-61c3bf4bee57',1,3,NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-13 19:49:37','2020-07-13 17:49:37','2020-07-13 19:49:36','2020-07-13 19:49:36'),(662,'96e43a62-294d-4726-8ccf-ea4ec6e66267','Sous dossier 1','2e7abd17-bdd5-4ead-9751-b6d90fb9e0ea',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2021-06-08 19:43:34','2021-06-08 17:43:34','2021-04-25 11:28:19','2021-04-25 11:19:29'),(662,'983c39b6-656b-4bf2-bf43-da1625adb861','Sous dossier 1','2c78d514-95bd-4529-b0a1-babfb83849b1',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2023-01-11 13:42:17','2023-01-11 12:42:17','2023-01-11 12:58:29','2023-01-11 12:11:32'),(662,'990c202c-5ab6-480a-85f6-63e46eba8c67','Sous dossier 3','ec084612-67a2-4430-ae15-7fe0edeaca64',1,3,NULL,NULL,NULL,NULL,NULL,'2020-09-09 19:48:13','2020-04-12 08:10:12','2020-09-09 17:48:13','2020-04-12 08:07:55','2020-04-12 08:07:55'),(662,'9e007066-06fd-4fa1-a49a-f1165de95f83','Sous dossier 1','c983b946-e304-49a8-99c8-24eaca67b9ce',1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 18:49:14','2023-04-11 20:49:14','2023-04-11 19:34:32'),(662,'9e543e2b-2acf-48cd-8b05-91154a50192e','Sous dossier 1','73abb1bd-08d2-44e7-866f-eeb3e4b59703',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-06 11:35:53','2020-04-06 09:37:05','2020-04-06 09:35:53','2020-04-06 09:37:03','2020-04-06 09:37:03'),(662,'a18ca6df-d765-4c6a-be28-13abd1c350af','Sous dossier 2','bb2e4d25-46eb-48d2-80af-41639e464a04',1,2,'931bf3dd-fe07-4981-8ede-599f357c3c60','29d00f37-e846-46c5-bfea-08ec3e95b455','3a74c5df-7c06-40b5-9e98-eeeb48d5c650','51f476ba-752c-4dbb-8096-f63ffa200322','b58b7bd8-eb47-4d54-9228-ce3a9e6486fd',NULL,'2020-04-17 11:23:06','2020-04-17 09:23:06','2020-04-17 11:21:05','2020-04-17 10:50:07'),(662,'a5b53be0-2545-4313-88b5-fccc26f75f7d','Sous dossier 8','2a050d02-7424-4099-b1d0-2d7da678e690',1,8,NULL,NULL,NULL,NULL,NULL,NULL,'2022-12-14 17:39:34','2022-12-14 16:39:34','2022-12-14 17:39:33','2022-12-14 17:39:33'),(662,'a5bc2d6f-0248-466f-a10b-08f5391fd12f','Sous dossier 1','2a050d02-7424-4099-b1d0-2d7da678e690',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-12-14 14:59:54','2022-12-14 13:59:54','2022-11-04 13:46:23','2022-11-04 13:31:18'),(662,'a647b404-de82-4017-b5d6-c98df78e9640','Sous dossier 6','ec084612-67a2-4430-ae15-7fe0edeaca64',1,6,NULL,NULL,NULL,NULL,NULL,'2020-09-09 19:48:13','2020-04-14 11:26:30','2020-09-09 17:48:13','2020-04-14 11:26:30','2020-04-14 11:26:30'),(662,'ada38401-e257-4f32-8319-c7a394ce4463','Sous dossier 1','934f20d2-7444-4367-89e2-61c3bf4bee57',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-13 19:48:57','2020-07-13 17:48:57','2020-07-13 19:48:57','2020-04-10 07:27:56'),(662,'b29b47d4-35f8-427d-9cd7-a393e48be2cf','Sous dossier 1','7e359a5f-1756-4ec7-8657-3e5940ae489d',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2021-10-12 14:26:31','2021-10-12 12:26:31','2021-10-12 12:44:17','2021-10-12 12:13:29'),(662,'b5b4db66-f433-46fb-b794-d632b8fe8e1d','Sous dossier 1','129a6c33-3cca-43ab-b97a-56d0e82a546f',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-02 13:55:41','2022-11-02 12:55:41','2022-11-02 12:36:21','2022-11-02 12:11:46'),(662,'b87f1382-55d4-4e52-b63a-6f387df18b16','Sous dossier 1','b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-30 07:12:47','2020-12-30 06:12:47','2020-12-30 07:12:46','2020-12-29 10:41:55'),(662,'ba7da56a-5a10-4378-a887-8e98aa892a3c','Sous dossier 1','848b25bd-90a8-4105-871d-f9326fe94c7b',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-12-21 12:14:36','2022-12-21 11:14:36','2022-12-21 12:14:32','2022-12-21 11:45:05'),(662,'bb711dc3-11c1-44a8-96df-a5fb875eade5','Sous dossier 1','f60bef39-641f-45a5-835c-4e84590668e4',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-29 11:57:43','2020-12-29 10:57:43','2020-12-29 08:48:53','2020-12-29 08:43:21'),(662,'bb93f779-b9ac-49e3-b8d2-1de80d351081','Sous dossier 6','2a050d02-7424-4099-b1d0-2d7da678e690',1,6,NULL,NULL,NULL,NULL,NULL,NULL,'2022-12-14 17:39:30','2022-12-14 16:39:30','2022-12-14 17:39:25','2022-12-14 17:39:25'),(662,'bc9ac093-048f-4390-9ef4-2e651b3cefeb','Sous dossier 2','2a050d02-7424-4099-b1d0-2d7da678e690',1,2,NULL,NULL,NULL,NULL,NULL,NULL,'2022-12-14 14:59:53','2022-12-14 13:59:53','2022-11-04 16:18:20','2022-11-04 16:18:20'),(662,'bdf42f40-5a7a-435b-a5e0-eb33efefbc97','Sous dossier 1','bb2e4d25-46eb-48d2-80af-41639e464a04',1,1,'5c922725-b41b-4e38-a244-6a9a320d291e','b25a25e2-610a-466d-a4d8-7518a09b9a78','4b5c8093-db62-4195-8bba-5349a152c006','95cc936b-2c0c-4fdd-8d11-8780095dabca','675a601d-d389-403d-858d-555ff6166630',NULL,'2020-04-17 07:55:26','2020-04-17 05:55:26','2020-04-17 07:55:26','2020-04-10 07:52:35'),(662,'becee89b-0c0c-4888-bd78-43480d883b03','Sous dossier 1','83306c87-ca0d-4ed2-b376-4227f586001f',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-29 11:57:44','2020-12-29 10:57:44','2020-12-21 18:19:59','2020-12-21 18:19:59'),(662,'bef02815-bbf7-4520-882b-2396474f4bb3','Sous dossier 2','1ce80886-d3f3-42d8-872a-a2eba69d0005',1,2,NULL,NULL,NULL,NULL,NULL,'2020-04-16 11:39:43','2020-04-16 10:40:46','2020-04-16 09:39:43','2020-04-16 10:40:45','2020-04-15 06:59:53'),(662,'c17a41dd-a1dc-4b45-8bc4-cdaf9f8a6853','Sous dossier 2','801b987d-e335-4276-8bc6-1fa57b553716',1,2,NULL,NULL,NULL,NULL,NULL,NULL,'2020-04-11 10:15:30','2020-04-11 08:15:30','2020-04-11 10:15:29','2020-04-11 08:43:29'),(662,'c4b27870-75ff-4ef2-93ab-393cd5837ed3','Sous dossier 1','adf717e5-dc3f-47f0-9f8a-d13e0438f5cd',1,1,NULL,NULL,NULL,NULL,NULL,'2021-06-08 21:07:30',NULL,'2021-06-08 19:07:30','2021-03-19 10:23:31','2021-03-19 10:23:31'),(662,'c68cb967-9ffa-4a4d-ad01-fe12edf11b36','Sous dossier 2','c42cadf5-5f0e-439e-9aab-087940794316',1,2,NULL,NULL,NULL,NULL,NULL,'2020-12-30 07:52:28',NULL,'2020-12-30 06:52:28','2020-12-29 08:34:29','2020-12-29 08:34:29'),(662,'c6fffa68-cc65-471a-a58e-135ebe4d0772','Sous dossier 1','76dcd1f0-f6c7-480f-b07b-441679345d70',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2021-02-16 13:05:10','2021-02-16 12:05:10','2021-02-16 13:05:09','2021-02-16 10:48:19'),(662,'c9d37315-5f17-421c-8afb-302fa9b0bebe','Sous dossier 1','cb9d8495-b4dd-423f-a624-7cff70e4db55',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-14 12:10:38','2020-04-13 07:58:20','2020-04-14 10:10:38','2020-04-13 07:58:19','2020-04-06 12:22:59'),(662,'ca0b761f-76f8-412a-85e4-b91ec62f9ded','Sous dossier 1','647287de-fb34-4f94-83ef-40f59da2edb3',1,1,NULL,NULL,NULL,NULL,NULL,'2020-09-09 19:48:14','2020-04-17 07:55:10','2020-09-09 17:48:14','2020-04-17 07:55:09','2020-04-17 07:55:09'),(662,'cd63d5a9-bc90-411d-8bf3-f3f492cddf36','Sous dossier 1','1716bd86-ee5e-4929-9e79-3beba5199c80',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-06-27 21:27:06','2022-06-27 19:27:06','2022-06-10 19:55:01','2022-06-10 19:55:01'),(662,'ce2ea9d2-a701-4f31-a83d-aaab5b7b6895','Sous dossier 5','801b987d-e335-4276-8bc6-1fa57b553716',1,5,NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-13 19:51:04','2020-07-13 17:51:04','2020-07-13 19:51:04','2020-07-13 19:51:04'),(662,'d057169e-3160-48a5-a239-2d74b9ded8c6','Sous dossier 2','7813c59a-91e7-4c2c-8027-bcc3c35c797c',1,2,NULL,NULL,NULL,NULL,NULL,NULL,'2020-04-08 08:49:31','2020-04-08 06:49:31','2020-04-08 08:49:30','2020-04-08 08:49:30'),(662,'d38b11ef-8ce0-42fe-8739-7f1a8c61e862','Sous dossier 1','7f8fbc5c-3db7-4ee3-adcd-e76fc6f390b8',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-09 11:07:42',NULL,'2020-04-09 09:07:42','2020-04-08 12:31:53','2020-04-08 12:31:53'),(662,'d402edb5-8449-46a8-862f-a1cd1ee21cf6','Sous dossier 1','64834083-3320-4687-9710-c2be0d9c7198',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-04 12:02:58','2020-05-04 10:02:58','2020-05-04 12:02:57','2020-04-30 19:09:00'),(662,'d70cc224-5e0d-4b47-9270-d8e23a25b566','Sous dossier 1','586a7c87-5d8a-440f-a654-c452dc908844',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-21 12:27:31','2023-03-21 11:27:31','2023-03-21 12:27:29','2023-03-21 12:06:40'),(662,'daf632b1-2c49-42c8-8899-0a0b2448bc3a','Sous dossier 1','c59a2f65-79fe-44cd-8377-e39aa0a44171',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-04-18 09:39:17','2020-04-18 07:39:17','2020-04-18 09:39:12','2020-04-18 08:57:39'),(662,'dce9ce0f-0933-4c98-af84-59e2b6395f8f','Sous dossier 1','87965ef8-01eb-4830-8e8b-8b99ece62cf1',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-06-27 21:27:08','2022-06-27 19:27:08','2022-06-27 21:02:22','2022-06-27 20:27:17'),(662,'dde78398-923b-407f-a04f-d7062b72c788','Sous dossier 1','1ce80886-d3f3-42d8-872a-a2eba69d0005',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-16 11:39:43','2020-04-15 06:59:51','2020-04-16 09:39:43','2020-04-15 06:59:48','2020-04-15 06:59:48'),(662,'e06b73d5-45f7-4906-ba73-560d66ac56af','Sous dossier 1','a6ab7edf-6040-4f1a-b898-a1120a854927',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-04-16 11:39:25','2020-04-16 09:39:25','2020-04-16 11:39:24','2020-04-16 10:43:49'),(662,'e5a14b69-613a-4be3-a5e8-9e99eeedae26','Sous dossier 2','8f3d7d42-f6ad-4e48-8951-08222c212e7e',1,2,NULL,NULL,NULL,NULL,NULL,NULL,'2022-12-14 14:59:42','2022-12-14 13:59:42','2022-11-04 13:30:38','2022-11-04 13:30:38'),(662,'ecdac05b-a55a-4b8a-9452-075fcd73eb50','Sous dossier 6','801b987d-e335-4276-8bc6-1fa57b553716',1,6,NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-13 19:51:13','2020-07-13 17:51:13','2020-07-13 19:51:13','2020-07-13 19:51:13'),(662,'ed8b4bd5-0a61-4563-b6a4-6ec124bc388d','Sous dossier 1','949fe730-88fa-4ec2-852e-dd0772ee3ee0',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-06-28 20:39:45','2022-06-28 18:39:45','2022-06-28 20:39:41','2022-06-28 20:03:39'),(662,'f2e73640-aebd-4bb1-9b02-c0504556ac5a','Sous dossier 1','bc967a6b-ad1a-4a59-aab8-92332e4217b0',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-13 19:51:52','2020-07-13 17:51:52','2020-07-13 19:51:52','2020-07-13 19:10:04'),(662,'f31eb3e4-3910-400c-aa4c-5340aa0ac4c5','Sous dossier 3','801b987d-e335-4276-8bc6-1fa57b553716',1,3,NULL,NULL,NULL,NULL,NULL,NULL,'2020-04-11 09:02:08','2020-04-11 07:02:08','2020-04-11 09:02:07','2020-04-11 09:02:07'),(662,'f502edbf-c31f-430b-8550-5888e894e4b4','Sous dossier 1','47a8d99f-668b-4bb6-b3bf-7bff221d397f',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-16 11:39:43','2020-04-16 10:42:10','2020-04-16 09:39:43','2020-04-16 10:42:09','2020-04-16 10:42:09'),(662,'f72f6016-0f75-4789-9924-1bc9aa64c2f1','Sous dossier 1','3eede325-0afb-43f5-9277-e22c18f8f927',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-06 13:56:40','2022-08-06 11:56:40','2022-08-06 13:56:38','2022-08-06 13:43:31'),(662,'f7b71416-57aa-4d3d-a2e5-0e6c1519f6e8','Sous dossier 1','78fbbe11-e1a5-4c10-b6e3-4f00df178dc6',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-16 11:39:43','2020-04-16 07:16:49','2020-04-16 09:39:43','2020-04-16 07:16:48','2020-04-14 11:34:34'),(662,'fd5f5d3b-c6e8-429a-bc31-3b24a7c2bba9','Sous dossier 2','d458682a-423b-43fe-a4b0-97d586104341',1,2,NULL,NULL,NULL,NULL,NULL,'2020-04-10 09:22:06','2020-04-09 11:05:44','2020-04-10 07:22:06','2020-04-09 11:05:43','2020-04-09 11:05:43'),(662,'fe8d1101-8c36-4d12-83c2-62848cf6c520','Sous dossier 2','83306c87-ca0d-4ed2-b376-4227f586001f',1,2,NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-29 11:57:43','2020-12-29 10:57:43','2020-12-29 11:41:50','2020-12-29 11:41:50');
/*!40000 ALTER TABLE `Session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SharedOffices`
--

DROP TABLE IF EXISTS `SharedOffices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SharedOffices` (
  `ownerID` mediumint unsigned NOT NULL,
  `office1ID` char(36) NOT NULL,
  `office2ID` char(36) NOT NULL,
  `sharedDataType` enum('ALL','CONTACTS') NOT NULL DEFAULT 'CONTACTS',
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`office1ID`,`office2ID`,`ownerID`),
  KEY `fk_SharedOffices_Office_1` (`office1ID`,`ownerID`),
  KEY `fk_SharedOffices_Office_2` (`office2ID`,`ownerID`),
  CONSTRAINT `fk_SharedOffices_Office_1` FOREIGN KEY (`office1ID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SharedOffices_Office_2` FOREIGN KEY (`office2ID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SharedOffices`
--

LOCK TABLES `SharedOffices` WRITE;
/*!40000 ALTER TABLE `SharedOffices` DISABLE KEYS */;
/*!40000 ALTER TABLE `SharedOffices` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `SharedOffices_BEFORE_INSERT` BEFORE INSERT ON `SharedOffices` FOR EACH ROW BEGIN
    IF EXISTS (
		SELECT 1 FROM SharedOffices WHERE
		(office1ID=NEW.office2ID AND office2ID=NEW.office1ID)
		OR
		(office1ID=NEW.office1ID AND office2ID=NEW.office2ID)
	) THEN
        SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = 'Try to insert an existing pair of keys';
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `SmilersOrder`
--

DROP TABLE IF EXISTS `SmilersOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_smilers_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `tag` varchar(250) DEFAULT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SmilersOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_SmilersOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrder`
--

LOCK TABLES `SmilersOrder` WRITE;
/*!40000 ALTER TABLE `SmilersOrder` DISABLE KEYS */;
INSERT INTO `SmilersOrder` VALUES (662,'0014546a-ad2d-4f74-9a83-8a7a0cf1af7a','848b25bd-90a8-4105-871d-f9326fe94c7b','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2022-12-21 12:15:13','2022-12-21 12:18:00','2022-12-21 12:15:13','2022-12-21 11:18:00','{\"caseId\":\"1.21.6.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19900713\",\"patientFirstName\":\"Anaïs\",\"patientLastName\":\"LACOMBE\"}','{\"Maxillaire 1.21.6.1.1\":\"689b438f-3633-4981-b669-5e49a97a5c95\"}',NULL,1,1),(662,'06c913e1-07d1-4a41-90a1-07f408f59737','3eede325-0afb-43f5-9277-e22c18f8f927','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2022-08-06 13:59:25','2022-08-06 13:59:32','2022-08-06 13:59:25','2022-08-06 11:59:32','{\"caseId\":\"1.20.2.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19541203\",\"patientFirstName\":\"Michèle\",\"patientLastName\":\"ESPOSITO\"}','{\"Mandibule 1.20.2.1.1\":\"2cff0ba7-eee7-4c7f-99af-34c690eb3868\"}',NULL,1,1),(662,'1995f588-2757-42b8-8f51-c2e41e0ebe8f','b498bdf4-2e5b-497a-8bfe-b65edabac3bc','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2021-11-23 12:24:09','2021-11-23 12:24:34','2021-11-23 12:24:09','2021-11-23 11:24:34','{\"caseId\":\"1.22.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19640223\",\"patientFirstName\":\"Nathalie\",\"patientLastName\":\"DAUGREILH\"}','{\"Mandibule 1.22.1.1.1\":\"45a97d29-279f-4720-856d-2ef701665f93\",\"Maxillaire 1.22.1.1.1\":\"13991d0c-102a-4df8-aaad-f5f422edc6be\",\"Mordu anterieur 1.22.1.1.1\":\"963a8acf-cdb2-41d5-b187-9a7c885ac2a0\",\"Mordu posterieur droit 1.22.1.1.1\":\"c19a9e26-b162-4808-8d10-9d6a38e24e98\",\"Mordu posterieur gauche 1.22.1.1.2\":\"a3d56e52-a954-4894-b840-be0425c42658\"}',NULL,1,1),(662,'23e375bd-b901-4423-96cd-1e2b8ffc55cd','b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2020-12-29 12:09:26','2020-12-29 12:14:59','2020-12-29 12:09:26','2020-12-29 11:14:59','{\"caseId\":\"1.13.4.S4\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19990727\",\"patientFirstName\":\"Ninon\",\"patientLastName\":\"MARTY\"}','{\"Mandibule 1.13.4.1.1\":\"4b136eb3-b01e-4166-a154-4539e20f9fea\",\"Maxillaire 1.13.4.1.1\":\"ac0adbda-ae71-490a-947a-f9bfe33db7e8\",\"Mordu anterieur\":\"534cca35-8182-4f61-aa57-03bad8172eac\",\"Mordu posterieur droit\":\"ecd2beec-0c29-40e2-ab95-64009c33fa40\",\"Mordu posterieur gauche\":\"876f775b-e8a0-4b7f-bea0-0c93a7041d17\"}',NULL,4,1),(662,'2a5500be-4ce4-4028-839b-141af843989f','0c1ed331-8df6-482e-8dd1-508d9b190c49','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2021-09-27 13:56:51','2021-09-27 14:02:12','2021-09-27 13:56:51','2021-09-27 12:02:12','{\"caseId\":\"1.19.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19620202\",\"patientFirstName\":\"Gisèle\",\"patientLastName\":\"AVERSENQ\"}','{\"Mandibule 1.19.1.1.1\":\"49635be4-dbea-497c-82e1-206399739c31\",\"Maxillaire 1.19.1.1.1\":\"84c96eac-549e-4c1d-a701-896474d66a31\",\"Mordu anterieur 1.19.1.1.1\":\"25d2e57a-b759-4ab8-a633-7725e7375d70\",\"Mordu posterieur droit 1.19.1.1.1\":\"f500b4e0-bd2d-4992-901f-526fc78912cf\",\"Mordu posterieur gauche 1.19.1.1.1\":\"ed40ce9a-6d1f-4cfd-a3e2-f58cba946869\"}',NULL,1,1),(662,'326b48e4-9182-4dc4-9e91-44104a1a8ff1','7e359a5f-1756-4ec7-8657-3e5940ae489d','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2021-10-12 14:26:57','2021-10-12 14:40:25','2021-10-12 14:26:57','2021-10-12 12:40:25','{\"caseId\":\"1.20.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19541203\",\"patientFirstName\":\"Michèle\",\"patientLastName\":\"ESPOSITO\"}','{\"Mandibule 1.20.1.1.1\":\"dd29f41a-cbb1-45d7-8979-1d16d4db487c\",\"Maxillaire 1.20.1.1.1\":\"4f638684-087b-42a0-916a-a8adc0c1eeea\",\"Mordu anterieur 1.20.1.1.1\":\"9617b0df-e829-47cd-8110-fabb587a690d\",\"Mordu posterieur droit 1.20.1.1.1\":\"0e855e55-dc7f-4eaf-91bd-933232cae95e\",\"Mordu posterieur gauche 1.20.1.1.1\":\"0a02b656-9179-4cbd-ae14-079f4f933517\"}',NULL,1,1),(662,'4dd9cb8a-22ca-48ed-943c-f8227a82fd43','e43c8099-0862-42c3-9ad2-1efef27b83ba','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2022-09-14 12:24:53','2022-09-14 12:25:38','2022-09-14 12:24:53','2022-09-14 10:25:38','{\"caseId\":\"1.21.3.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19900713\",\"patientFirstName\":\"Anaïs\",\"patientLastName\":\"LACOMBE\"}','{\"Maxillaire 1.21.3.1.1\":\"bafe042a-2298-470c-8d08-071e0f4e388e\"}',NULL,1,1),(662,'510986a4-1523-4c17-84f5-900361edbf32','c47ee4d9-c646-4836-8152-fc2ded70b4fe','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2021-02-01 21:24:09','2021-02-01 21:24:24','2021-02-01 21:24:09','2021-02-01 20:24:24','{\"caseId\":\"1.14.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19990721\",\"patientFirstName\":\"Benjamin\",\"patientLastName\":\"RIVES\"}','{\"Mandibule 1.14.1.1.2\":\"23066de9-fbda-436c-bd8b-dacb5721c390\",\"Maxillaire 1.14.1.1.1\":\"4df1d6c0-6d77-4547-ae20-f797167f57b2\",\"Mordu anterieur\":\"ccd3f4f6-f303-4b20-b967-d41121f2e36b\",\"Mordu posterieur droit\":\"79548cb6-a61f-44cb-b6f7-cab7698f7465\",\"Mordu posterieur gauche\":\"7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a\"}',NULL,1,1),(662,'5dd87306-77a2-44aa-9d31-280dd9c9a0df','87965ef8-01eb-4830-8e8b-8b99ece62cf1','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2022-06-27 21:28:36','2022-06-27 21:35:51','2022-06-27 21:28:36','2022-06-27 19:35:51','{\"caseId\":\"1.21.2.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19900713\",\"patientFirstName\":\"Anaïs\",\"patientLastName\":\"LACOMBE\"}','{\"Mandibule 1.21.2.1.1\":\"a6c49c5b-a994-457c-80d2-6cd69b636979\"}',NULL,1,1),(662,'6115b844-b299-4810-9483-4074715ac8c2','b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2020-12-29 12:06:52','2020-12-29 12:15:15','2020-12-29 12:06:52','2020-12-29 11:15:15','{\"caseId\":\"1.13.4.S3\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19990727\",\"patientFirstName\":\"Ninon\",\"patientLastName\":\"MARTY\"}','{\"Mandibule 1.13.4.1.1\":\"4b136eb3-b01e-4166-a154-4539e20f9fea\",\"Maxillaire 1.13.4.1.1\":\"ac0adbda-ae71-490a-947a-f9bfe33db7e8\",\"Mordu anterieur\":\"534cca35-8182-4f61-aa57-03bad8172eac\",\"Mordu posterieur droit\":\"ecd2beec-0c29-40e2-ab95-64009c33fa40\",\"Mordu posterieur gauche\":\"876f775b-e8a0-4b7f-bea0-0c93a7041d17\"}',NULL,3,1),(662,'6e963009-b46f-494d-a5d4-b162c5918103','72b7a457-e38f-4535-8eba-6c98b43e5e55','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2021-06-08 20:57:52','2021-06-08 20:58:38','2021-06-08 20:57:52','2021-06-08 18:58:38','{\"caseId\":\"1.14.2.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19990721\",\"patientFirstName\":\"Benjamin\",\"patientLastName\":\"RIVES\"}','{\"Mandibule 1.14.2.1.2\":\"0f7ff11f-44bc-45a5-bfc7-a7ac0da258f5\",\"Maxillaire 1.14.2.1.1\":\"ab47d04c-6ad7-430c-ae85-9231a2efc7b9\",\"Mordu anterieur\":\"18365744-4019-43e1-933f-9fa52db1a30d\",\"Mordu posterieur droit\":\"41b8d05c-738b-4161-9f86-27222b61ad66\",\"Mordu posterieur gauche\":\"44b8a221-3707-430b-bc84-cacca7bf7d8a\"}',NULL,1,1),(662,'802bd1e1-3362-4d30-9362-8bdbbb6482d2','76dcd1f0-f6c7-480f-b07b-441679345d70','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2021-02-16 13:05:30','2021-02-16 13:05:52','2021-02-16 13:05:30','2021-02-16 12:05:52','{\"caseId\":\"1.15.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19910902\",\"patientFirstName\":\"Quitterie\",\"patientLastName\":\"DOUENCE\"}','{\"Mandibule 1.15.1.1.1\":\"3f34dab9-eda8-40de-be81-a094dee55a47\",\"Maxillaire 1.15.1.1.1\":\"e1692a67-2979-4399-b4dc-65a1c7e9c4b8\",\"Mordu anterieur\":\"44ccf5f6-834d-4090-88dc-399b19fed47e\",\"Mordu posterieur droit\":\"c99bbff9-5630-49d7-9300-4dabfa5e74c8\",\"Mordu posterieur gauche\":\"7a39120e-2f79-4c3e-af4d-af72e8ca8062\"}',NULL,1,1),(662,'888cf7fa-b086-4bbe-8352-4b347b1fbf70','586a7c87-5d8a-440f-a654-c452dc908844','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2023-03-21 12:28:13','2023-03-21 12:30:59','2023-03-21 12:28:13','2023-03-21 11:30:59','{\"caseId\":\"1.19.4.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19620202\",\"patientFirstName\":\"Gisèle\",\"patientLastName\":\"AVERSENQ\"}','{\"Maxillaire 1.19.4.1.1\":\"ab2de538-1cbb-481f-a82e-899f47da34b7\"}',NULL,1,1),(662,'97b0ec8c-0f87-4226-bd8d-caffe14e5dd7','129a6c33-3cca-43ab-b97a-56d0e82a546f','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2022-11-02 13:56:17','2022-11-02 18:43:29','2022-11-02 13:56:17','2022-11-02 17:43:29','{\"caseId\":\"1.19.3.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19620202\",\"patientFirstName\":\"Gisèle\",\"patientLastName\":\"AVERSENQ\"}','{\"Maxillaire 1.19.3.1.1\":\"1e41852a-1d94-44eb-90f9-b06c401ee8b7\",\"Mordu anterieur 1.19.3.1.1\":\"dc97d683-1aa5-4aba-bf5c-a43b36478d90\",\"Mordu posterieur droit 1.19.3.1.1\":\"d82bb8e8-709c-4148-9290-d8b05ce3f7e6\",\"Mordu posterieur gauche 1.19.3.1.1\":\"6f481e07-43c0-494b-8d4f-279772780eec\"}',NULL,1,1),(662,'a5b8e66e-54fa-4915-91c4-4ae875c9f3ba','b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2020-12-29 12:01:43','2020-12-29 12:14:44','2020-12-29 12:01:43','2020-12-29 11:14:44','{\"caseId\":\"1.13.4.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19990727\",\"patientFirstName\":\"Ninon\",\"patientLastName\":\"MARTY\"}','{\"Mandibule 1.13.4.1.1\":\"4b136eb3-b01e-4166-a154-4539e20f9fea\",\"Maxillaire 1.13.4.1.1\":\"ac0adbda-ae71-490a-947a-f9bfe33db7e8\",\"Mordu anterieur\":\"534cca35-8182-4f61-aa57-03bad8172eac\",\"Mordu posterieur droit\":\"ecd2beec-0c29-40e2-ab95-64009c33fa40\",\"Mordu posterieur gauche\":\"876f775b-e8a0-4b7f-bea0-0c93a7041d17\"}',NULL,1,1),(662,'b1ca2262-cd6f-4c35-984a-071491ef1682','949fe730-88fa-4ec2-852e-dd0772ee3ee0','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2022-06-28 20:40:18','2022-06-28 20:41:00','2022-06-28 20:40:18','2022-06-28 18:41:00','{\"caseId\":\"1.19.2.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19620202\",\"patientFirstName\":\"Gisèle\",\"patientLastName\":\"AVERSENQ\"}','{\"Maxillaire 1.19.2.1.1\":\"a4f0f4fa-9346-4a75-a1dd-e95c83dc5e6b\"}',NULL,1,1),(662,'bc0a9e7a-61d4-416f-99e7-00ae8838c1af','3d2141bb-462c-4334-b177-d17d136574ae','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2021-11-22 12:51:17','2021-11-22 12:51:37','2021-11-22 12:51:17','2021-11-22 11:51:37','{\"caseId\":\"1.21.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19900713\",\"patientFirstName\":\"Anaïs\",\"patientLastName\":\"LACOMBE\"}','{\"Mandibule 1.21.1.1.1\":\"c8503263-9efa-47b8-8764-2bb09be6a1cb\",\"Maxillaire 1.21.1.1.1\":\"6420c2d7-bcdf-4e2e-9ee7-e90e3b7b7045\",\"Mordu anterieur 1.21.1.1.1\":\"f880f49e-bb57-430d-8212-dcb8e015569f\",\"Mordu posterieur droit 1.21.1.1.1\":\"45a66afe-8bb2-49b4-b3fc-982c845cf2f2\",\"Mordu posterieur gauche 1.21.1.1.1\":\"5f516c96-8333-49f5-8c71-3a7e8878488c\"}',NULL,1,1),(662,'d151be06-8a97-48d0-9abe-2095c6c410c7','8f3d7d42-f6ad-4e48-8951-08222c212e7e','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2022-11-04 12:37:20','2022-11-04 12:40:15','2022-11-04 12:37:20','2022-11-04 11:40:15','{\"caseId\":\"1.21.4.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19900713\",\"patientFirstName\":\"Anaïs\",\"patientLastName\":\"LACOMBE\"}','{\"Mandibule 1.21.4.1.1\":\"6ea3e979-830a-4dd4-81e2-3d30db702b9c\",\"Mordu anterieur 1.21.4.1.1\":\"b6b42cf7-31c1-49e1-b1d1-c607c7ba299b\"}',NULL,1,1),(662,'ddf3aa86-53ab-4afd-90b7-ff5de6dbb17e','2c78d514-95bd-4529-b0a1-babfb83849b1','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2023-01-11 13:45:24','2023-01-11 13:47:48','2023-01-11 13:45:24','2023-01-11 12:47:48','{\"caseId\":\"1.21.7.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19900713\",\"patientFirstName\":\"Anaïs\",\"patientLastName\":\"LACOMBE\"}','{\"Mandibule 1.21.7.1.1\":\"06da4522-e34d-40fd-b96f-ca51c40618cc\"}',NULL,1,1),(662,'e3644629-0e9d-4455-b760-495a260e47fe','f474819e-9470-4612-8275-2ceb25b5522f','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2021-02-27 10:59:19','2021-02-27 11:00:04','2021-02-27 10:59:19','2021-02-27 10:00:04','{\"caseId\":\"1.16.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"20070116\",\"patientFirstName\":\"Yohan\",\"patientLastName\":\"LE PARC\"}','{\"Mandibule 1.16.1.1.1\":\"1e84d5d4-6768-4dde-a7cf-ca40a6d4261e\",\"Maxillaire 1.16.1.1.1\":\"0b4e8e31-bd54-4394-8ebc-2c2d30d84197\",\"Mordu anterieur\":\"57e7671e-1671-4ee9-96a0-650a56963aa8\",\"Mordu posterieur droit\":\"d4c7f3c5-155d-41ef-8665-852e89c5e017\",\"Mordu posterieur gauche\":\"0d792709-57f3-49e1-963c-d2dc35a59d12\"}',NULL,1,1),(662,'fc4bdff0-7d08-4454-8d7e-962c91470073','7841125a-11dd-4b66-9179-cd371ea2f0f7','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2022-01-11 12:41:54','2022-01-11 12:43:37','2022-01-11 12:41:54','2022-01-11 11:43:37','{\"caseId\":\"1.23.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19771212\",\"patientFirstName\":\"Carla\",\"patientLastName\":\"GARCIA\"}','{\"Mandibule 1.23.1.1.1\":\"6918be85-b74b-4069-b2b3-914477ca77ad\",\"Maxillaire 1.23.1.1.1\":\"07615b33-5390-4fe1-9fbb-9ec7cbd64d40\",\"Mordu anterieur 1.23.1.1.1\":\"6fa55f91-2e1f-436b-b276-b2726e9125b4\",\"Mordu posterieur droit 1.23.1.1.1\":\"ce7041b4-86ce-4167-b150-b49d4f0008a6\",\"Mordu posterieur gauche 1.23.1.1.1\":\"5c2ae31f-cf6e-42c8-9d38-6f41e1e8db02\"}',NULL,1,1),(662,'fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a','b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','SMILERS ORDER',NULL,'sent','2020-12-29 12:02:05','2020-12-29 12:15:30','2020-12-29 12:02:05','2020-12-29 11:15:30','{\"caseId\":\"1.13.4.S2\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19990727\",\"patientFirstName\":\"Ninon\",\"patientLastName\":\"MARTY\"}','{\"Mandibule 1.13.4.1.1\":\"4b136eb3-b01e-4166-a154-4539e20f9fea\",\"Maxillaire 1.13.4.1.1\":\"ac0adbda-ae71-490a-947a-f9bfe33db7e8\",\"Mordu anterieur\":\"534cca35-8182-4f61-aa57-03bad8172eac\",\"Mordu posterieur droit\":\"ecd2beec-0c29-40e2-ab95-64009c33fa40\",\"Mordu posterieur gauche\":\"876f775b-e8a0-4b7f-bea0-0c93a7041d17\"}',NULL,2,1);
/*!40000 ALTER TABLE `SmilersOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrderFile`
--

DROP TABLE IF EXISTS `SmilersOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_SmilersOrderFile_SmilersOrder` (`orderID`,`ownerID`),
  KEY `fk_SmilersOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_SmilersOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SmilersOrderFile_SmilersOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `SmilersOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrderFile`
--

LOCK TABLES `SmilersOrderFile` WRITE;
/*!40000 ALTER TABLE `SmilersOrderFile` DISABLE KEYS */;
INSERT INTO `SmilersOrderFile` VALUES (662,'0014546a-ad2d-4f74-9a83-8a7a0cf1af7a','33d86713-43cb-4b91-9426-39eba69968e0','2022-12-21 11:15:13'),(662,'0014546a-ad2d-4f74-9a83-8a7a0cf1af7a','689b438f-3633-4981-b669-5e49a97a5c95','2022-12-21 11:15:13'),(662,'06c913e1-07d1-4a41-90a1-07f408f59737','1dcff310-7757-4ec2-a021-00ae9e80d224','2022-08-06 11:59:26'),(662,'06c913e1-07d1-4a41-90a1-07f408f59737','2cff0ba7-eee7-4c7f-99af-34c690eb3868','2022-08-06 11:59:25'),(662,'1995f588-2757-42b8-8f51-c2e41e0ebe8f','13991d0c-102a-4df8-aaad-f5f422edc6be','2021-11-23 11:24:09'),(662,'1995f588-2757-42b8-8f51-c2e41e0ebe8f','45a97d29-279f-4720-856d-2ef701665f93','2021-11-23 11:24:09'),(662,'1995f588-2757-42b8-8f51-c2e41e0ebe8f','632a870c-a45a-412b-b369-ac5a4d47afe1','2021-11-23 11:24:09'),(662,'1995f588-2757-42b8-8f51-c2e41e0ebe8f','963a8acf-cdb2-41d5-b187-9a7c885ac2a0','2021-11-23 11:24:09'),(662,'1995f588-2757-42b8-8f51-c2e41e0ebe8f','a3d56e52-a954-4894-b840-be0425c42658','2021-11-23 11:24:09'),(662,'1995f588-2757-42b8-8f51-c2e41e0ebe8f','c19a9e26-b162-4808-8d10-9d6a38e24e98','2021-11-23 11:24:09'),(662,'23e375bd-b901-4423-96cd-1e2b8ffc55cd','229d55f2-d907-49a9-ae4c-c2359e8ce810','2020-12-29 11:09:26'),(662,'23e375bd-b901-4423-96cd-1e2b8ffc55cd','4b136eb3-b01e-4166-a154-4539e20f9fea','2020-12-29 11:09:26'),(662,'23e375bd-b901-4423-96cd-1e2b8ffc55cd','67590a8b-fee2-4fa0-bc4c-133c68953810','2020-12-29 11:09:26'),(662,'23e375bd-b901-4423-96cd-1e2b8ffc55cd','ac0adbda-ae71-490a-947a-f9bfe33db7e8','2020-12-29 11:09:26'),(662,'23e375bd-b901-4423-96cd-1e2b8ffc55cd','d47ef10b-7c9f-4fd9-8617-329e21bbfa35','2020-12-29 11:09:26'),(662,'23e375bd-b901-4423-96cd-1e2b8ffc55cd','e695a41c-b645-425c-85e6-65b449ddbb04','2020-12-29 11:09:26'),(662,'2a5500be-4ce4-4028-839b-141af843989f','25d2e57a-b759-4ab8-a633-7725e7375d70','2021-09-27 11:56:51'),(662,'2a5500be-4ce4-4028-839b-141af843989f','49635be4-dbea-497c-82e1-206399739c31','2021-09-27 11:56:51'),(662,'2a5500be-4ce4-4028-839b-141af843989f','84c96eac-549e-4c1d-a701-896474d66a31','2021-09-27 11:56:51'),(662,'2a5500be-4ce4-4028-839b-141af843989f','b9c83531-72e1-44a5-8e95-fc1d4c502741','2021-09-27 11:56:51'),(662,'2a5500be-4ce4-4028-839b-141af843989f','ed40ce9a-6d1f-4cfd-a3e2-f58cba946869','2021-09-27 11:56:51'),(662,'2a5500be-4ce4-4028-839b-141af843989f','f500b4e0-bd2d-4992-901f-526fc78912cf','2021-09-27 11:56:51'),(662,'326b48e4-9182-4dc4-9e91-44104a1a8ff1','0a02b656-9179-4cbd-ae14-079f4f933517','2021-10-12 12:26:57'),(662,'326b48e4-9182-4dc4-9e91-44104a1a8ff1','0e855e55-dc7f-4eaf-91bd-933232cae95e','2021-10-12 12:26:57'),(662,'326b48e4-9182-4dc4-9e91-44104a1a8ff1','4f638684-087b-42a0-916a-a8adc0c1eeea','2021-10-12 12:26:57'),(662,'326b48e4-9182-4dc4-9e91-44104a1a8ff1','83beb369-fc09-4267-aae8-82692ddb557d','2021-10-12 12:26:57'),(662,'326b48e4-9182-4dc4-9e91-44104a1a8ff1','9617b0df-e829-47cd-8110-fabb587a690d','2021-10-12 12:26:57'),(662,'326b48e4-9182-4dc4-9e91-44104a1a8ff1','dd29f41a-cbb1-45d7-8979-1d16d4db487c','2021-10-12 12:26:57'),(662,'4dd9cb8a-22ca-48ed-943c-f8227a82fd43','bafe042a-2298-470c-8d08-071e0f4e388e','2022-09-14 10:24:53'),(662,'4dd9cb8a-22ca-48ed-943c-f8227a82fd43','cc4a874a-55b6-43ea-a757-cbad99deb1cf','2022-09-14 10:24:53'),(662,'510986a4-1523-4c17-84f5-900361edbf32','23066de9-fbda-436c-bd8b-dacb5721c390','2021-02-01 20:24:09'),(662,'510986a4-1523-4c17-84f5-900361edbf32','4df1d6c0-6d77-4547-ae20-f797167f57b2','2021-02-01 20:24:09'),(662,'510986a4-1523-4c17-84f5-900361edbf32','98c10ee7-5736-4c52-8f1e-248cda79d235','2021-02-01 20:24:09'),(662,'510986a4-1523-4c17-84f5-900361edbf32','d3e47b22-64d4-4936-a2f6-a2a11b01fdf2','2021-02-01 20:24:09'),(662,'510986a4-1523-4c17-84f5-900361edbf32','e3dcb444-172f-4ae1-a2bc-7ff3b7c8eb26','2021-02-01 20:24:09'),(662,'510986a4-1523-4c17-84f5-900361edbf32','ff20b9a0-8d88-4bef-9570-fe21135dc7a5','2021-02-01 20:24:09'),(662,'5dd87306-77a2-44aa-9d31-280dd9c9a0df','a6c49c5b-a994-457c-80d2-6cd69b636979','2022-06-27 19:28:36'),(662,'5dd87306-77a2-44aa-9d31-280dd9c9a0df','e705cb75-4d59-41fc-8f62-f0a888025842','2022-06-27 19:28:36'),(662,'6115b844-b299-4810-9483-4074715ac8c2','229d55f2-d907-49a9-ae4c-c2359e8ce810','2020-12-29 11:06:52'),(662,'6115b844-b299-4810-9483-4074715ac8c2','4b136eb3-b01e-4166-a154-4539e20f9fea','2020-12-29 11:06:52'),(662,'6115b844-b299-4810-9483-4074715ac8c2','8c7b4f48-e4a4-416e-acec-bb98128e5a62','2020-12-29 11:06:52'),(662,'6115b844-b299-4810-9483-4074715ac8c2','ac0adbda-ae71-490a-947a-f9bfe33db7e8','2020-12-29 11:06:52'),(662,'6115b844-b299-4810-9483-4074715ac8c2','d47ef10b-7c9f-4fd9-8617-329e21bbfa35','2020-12-29 11:06:52'),(662,'6115b844-b299-4810-9483-4074715ac8c2','e695a41c-b645-425c-85e6-65b449ddbb04','2020-12-29 11:06:52'),(662,'6e963009-b46f-494d-a5d4-b162c5918103','0f7ff11f-44bc-45a5-bfc7-a7ac0da258f5','2021-06-08 18:57:52'),(662,'6e963009-b46f-494d-a5d4-b162c5918103','1fe4acd9-cda1-4289-bd11-70fec38115e5','2021-06-08 18:57:52'),(662,'6e963009-b46f-494d-a5d4-b162c5918103','3f9ce1c8-3470-43c5-8e52-0294b7082120','2021-06-08 18:57:52'),(662,'6e963009-b46f-494d-a5d4-b162c5918103','9ef05483-96de-4739-93ea-9e10a387566a','2021-06-08 18:57:52'),(662,'6e963009-b46f-494d-a5d4-b162c5918103','a196ba15-5ebd-46d8-b6fa-0325918797ac','2021-06-08 18:57:52'),(662,'6e963009-b46f-494d-a5d4-b162c5918103','ab47d04c-6ad7-430c-ae85-9231a2efc7b9','2021-06-08 18:57:52'),(662,'802bd1e1-3362-4d30-9362-8bdbbb6482d2','18d03d74-c9b0-446f-b896-0a9cda8f18ed','2021-02-16 12:05:30'),(662,'802bd1e1-3362-4d30-9362-8bdbbb6482d2','3f34dab9-eda8-40de-be81-a094dee55a47','2021-02-16 12:05:30'),(662,'802bd1e1-3362-4d30-9362-8bdbbb6482d2','818647ce-e09a-4e46-8ad9-2029a89b0d0f','2021-02-16 12:05:30'),(662,'802bd1e1-3362-4d30-9362-8bdbbb6482d2','b75b602f-a893-4dd9-8bbf-6b4b00421c4a','2021-02-16 12:05:30'),(662,'802bd1e1-3362-4d30-9362-8bdbbb6482d2','d7178627-cef8-4d56-87be-5ce753175b9f','2021-02-16 12:05:30'),(662,'802bd1e1-3362-4d30-9362-8bdbbb6482d2','e1692a67-2979-4399-b4dc-65a1c7e9c4b8','2021-02-16 12:05:30'),(662,'888cf7fa-b086-4bbe-8352-4b347b1fbf70','ab2de538-1cbb-481f-a82e-899f47da34b7','2023-03-21 11:28:13'),(662,'888cf7fa-b086-4bbe-8352-4b347b1fbf70','ee84cb79-dc2d-4d14-b3d4-6156697046e6','2023-03-21 11:28:13'),(662,'97b0ec8c-0f87-4226-bd8d-caffe14e5dd7','1e41852a-1d94-44eb-90f9-b06c401ee8b7','2022-11-02 12:56:17'),(662,'97b0ec8c-0f87-4226-bd8d-caffe14e5dd7','3f556561-f5e6-4964-b058-136e53ecaa20','2022-11-02 12:56:17'),(662,'97b0ec8c-0f87-4226-bd8d-caffe14e5dd7','6f481e07-43c0-494b-8d4f-279772780eec','2022-11-02 12:56:17'),(662,'97b0ec8c-0f87-4226-bd8d-caffe14e5dd7','d82bb8e8-709c-4148-9290-d8b05ce3f7e6','2022-11-02 12:56:17'),(662,'97b0ec8c-0f87-4226-bd8d-caffe14e5dd7','dc97d683-1aa5-4aba-bf5c-a43b36478d90','2022-11-02 12:56:17'),(662,'a5b8e66e-54fa-4915-91c4-4ae875c9f3ba','229d55f2-d907-49a9-ae4c-c2359e8ce810','2020-12-29 11:01:43'),(662,'a5b8e66e-54fa-4915-91c4-4ae875c9f3ba','458fd645-9952-46e8-a68c-ff2ee3cf1d94','2020-12-29 11:01:43'),(662,'a5b8e66e-54fa-4915-91c4-4ae875c9f3ba','4b136eb3-b01e-4166-a154-4539e20f9fea','2020-12-29 11:01:43'),(662,'a5b8e66e-54fa-4915-91c4-4ae875c9f3ba','ac0adbda-ae71-490a-947a-f9bfe33db7e8','2020-12-29 11:01:43'),(662,'a5b8e66e-54fa-4915-91c4-4ae875c9f3ba','d47ef10b-7c9f-4fd9-8617-329e21bbfa35','2020-12-29 11:01:43'),(662,'a5b8e66e-54fa-4915-91c4-4ae875c9f3ba','e695a41c-b645-425c-85e6-65b449ddbb04','2020-12-29 11:01:43'),(662,'b1ca2262-cd6f-4c35-984a-071491ef1682','a4f0f4fa-9346-4a75-a1dd-e95c83dc5e6b','2022-06-28 18:40:18'),(662,'b1ca2262-cd6f-4c35-984a-071491ef1682','fa6d3cbd-0af8-4f29-9631-237bb3c12829','2022-06-28 18:40:18'),(662,'bc0a9e7a-61d4-416f-99e7-00ae8838c1af','0a6907bf-e8ec-4b7b-9dd9-8f5cf9bf83d8','2021-11-22 11:51:17'),(662,'bc0a9e7a-61d4-416f-99e7-00ae8838c1af','45a66afe-8bb2-49b4-b3fc-982c845cf2f2','2021-11-22 11:51:17'),(662,'bc0a9e7a-61d4-416f-99e7-00ae8838c1af','5f516c96-8333-49f5-8c71-3a7e8878488c','2021-11-22 11:51:17'),(662,'bc0a9e7a-61d4-416f-99e7-00ae8838c1af','6420c2d7-bcdf-4e2e-9ee7-e90e3b7b7045','2021-11-22 11:51:17'),(662,'bc0a9e7a-61d4-416f-99e7-00ae8838c1af','c8503263-9efa-47b8-8764-2bb09be6a1cb','2021-11-22 11:51:17'),(662,'bc0a9e7a-61d4-416f-99e7-00ae8838c1af','f880f49e-bb57-430d-8212-dcb8e015569f','2021-11-22 11:51:17'),(662,'d151be06-8a97-48d0-9abe-2095c6c410c7','14360249-ed21-4853-8b15-1d0883516209','2022-11-04 11:37:20'),(662,'d151be06-8a97-48d0-9abe-2095c6c410c7','6ea3e979-830a-4dd4-81e2-3d30db702b9c','2022-11-04 11:37:20'),(662,'d151be06-8a97-48d0-9abe-2095c6c410c7','b6b42cf7-31c1-49e1-b1d1-c607c7ba299b','2022-11-04 11:37:20'),(662,'ddf3aa86-53ab-4afd-90b7-ff5de6dbb17e','06da4522-e34d-40fd-b96f-ca51c40618cc','2023-01-11 12:45:24'),(662,'ddf3aa86-53ab-4afd-90b7-ff5de6dbb17e','e3171b5f-22cc-46f8-af75-7031b77dcec3','2023-01-11 12:45:24'),(662,'e3644629-0e9d-4455-b760-495a260e47fe','048d66fa-42fe-4d07-8e9c-1a8a30ce1fb4','2021-02-27 09:59:19'),(662,'e3644629-0e9d-4455-b760-495a260e47fe','0b4e8e31-bd54-4394-8ebc-2c2d30d84197','2021-02-27 09:59:19'),(662,'e3644629-0e9d-4455-b760-495a260e47fe','1e84d5d4-6768-4dde-a7cf-ca40a6d4261e','2021-02-27 09:59:19'),(662,'e3644629-0e9d-4455-b760-495a260e47fe','4e355e83-f72e-471f-a217-6dc5ae2fd8aa','2021-02-27 09:59:19'),(662,'e3644629-0e9d-4455-b760-495a260e47fe','78aec42f-0ec9-4ca8-b05e-324d3b955b86','2021-02-27 09:59:19'),(662,'e3644629-0e9d-4455-b760-495a260e47fe','8c67a058-8449-431b-8bbd-2b4b584d36e3','2021-02-27 09:59:19'),(662,'fc4bdff0-7d08-4454-8d7e-962c91470073','07615b33-5390-4fe1-9fbb-9ec7cbd64d40','2022-01-11 11:41:54'),(662,'fc4bdff0-7d08-4454-8d7e-962c91470073','5c2ae31f-cf6e-42c8-9d38-6f41e1e8db02','2022-01-11 11:41:54'),(662,'fc4bdff0-7d08-4454-8d7e-962c91470073','6918be85-b74b-4069-b2b3-914477ca77ad','2022-01-11 11:41:54'),(662,'fc4bdff0-7d08-4454-8d7e-962c91470073','6fa55f91-2e1f-436b-b276-b2726e9125b4','2022-01-11 11:41:54'),(662,'fc4bdff0-7d08-4454-8d7e-962c91470073','9f8fd3b2-3378-4bb1-997f-292d365a2a77','2022-01-11 11:41:54'),(662,'fc4bdff0-7d08-4454-8d7e-962c91470073','ce7041b4-86ce-4167-b150-b49d4f0008a6','2022-01-11 11:41:54'),(662,'fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a','229d55f2-d907-49a9-ae4c-c2359e8ce810','2020-12-29 11:02:05'),(662,'fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a','4b136eb3-b01e-4166-a154-4539e20f9fea','2020-12-29 11:02:05'),(662,'fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a','844bd645-d75e-4e35-9525-178a102fe49a','2020-12-29 11:02:05'),(662,'fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a','ac0adbda-ae71-490a-947a-f9bfe33db7e8','2020-12-29 11:02:05'),(662,'fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a','d47ef10b-7c9f-4fd9-8617-329e21bbfa35','2020-12-29 11:02:05'),(662,'fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a','e695a41c-b645-425c-85e6-65b449ddbb04','2020-12-29 11:02:05');
/*!40000 ALTER TABLE `SmilersOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SyncInfo`
--

DROP TABLE IF EXISTS `SyncInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SyncInfo` (
  `id` mediumint unsigned NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `patientsLastRetrieved` datetime DEFAULT NULL,
  `actsLastRetrieved` datetime DEFAULT NULL,
  `sessionsLastRetrieved` datetime DEFAULT NULL,
  `scansLastRetrieved` datetime DEFAULT NULL,
  `ordersLastRetrieved` datetime DEFAULT NULL,
  `assistantsLastRetrieved` datetime DEFAULT NULL,
  `contactsLastRetrieved` datetime DEFAULT NULL,
  `discussionsLastRetrieved` datetime DEFAULT NULL,
  `messagesLastRetrieved` datetime DEFAULT NULL,
  `notificationsLastRetrieved` datetime DEFAULT NULL,
  `occlusionsLastRetrieved` datetime DEFAULT NULL,
  `circleordersLastRetrieved` datetime DEFAULT NULL,
  `smilersordersLastRetrieved` datetime DEFAULT NULL,
  `prostheticSheetsLastRetrieved` datetime DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `idx_SyncInfo_Professional` (`ownerID`),
  CONSTRAINT `fk_SyncInfo_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SyncInfo`
--

LOCK TABLES `SyncInfo` WRITE;
/*!40000 ALTER TABLE `SyncInfo` DISABLE KEYS */;
INSERT INTO `SyncInfo` VALUES (1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,59,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,155,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,172,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,193,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,224,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,662,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,663,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,689,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,1081,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `SyncInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SystemNotification`
--

DROP TABLE IF EXISTS `SystemNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SystemNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `event` enum('no_connection_for_x_days') NOT NULL DEFAULT 'no_connection_for_x_days',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SystemNotification_Professional` (`ownerID`),
  CONSTRAINT `fk_SystemNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SystemNotification`
--

LOCK TABLES `SystemNotification` WRITE;
/*!40000 ALTER TABLE `SystemNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SystemNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Token`
--

DROP TABLE IF EXISTS `Token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Token` (
  `id` char(36) NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `created` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `token` char(200) NOT NULL,
  `credentialsId` char(36) CHARACTER SET utf8mb3 COLLATE utf8_general_ci DEFAULT '',
  `context` varchar(40) DEFAULT NULL,
  `device` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_Token` (`token`),
  KEY `IDX_9EF68E3F818B3C83` (`credentialsId`),
  CONSTRAINT `fk_Token_Credentials` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Token`
--

LOCK TABLES `Token` WRITE;
/*!40000 ALTER TABLE `Token` DISABLE KEYS */;
INSERT INTO `Token` VALUES ('0adc3097-9098-41b5-bb77-426ccb4f4039',662,NULL,'2023-03-21 11:32:48','ed23a57aeb2c64227421f94a3674e6fe54424874','00000662-0000-0000-0000-000000000001',NULL,NULL),('58a9e4e4-5a8b-40d0-952b-97a278077d42',2,NULL,'2022-06-27 19:16:26','0a7778dd1ccffbb17517648f767cbdb242965e81','00000002-0000-0000-0000-000000000001',NULL,NULL);
/*!40000 ALTER TABLE `Token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ToothInfo`
--

DROP TABLE IF EXISTS `ToothInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ToothInfo` (
  `ownerID` mediumint unsigned NOT NULL,
  `toothNumber` tinyint unsigned NOT NULL,
  `prostheticSheetID` char(36) NOT NULL,
  `toothColor` tinytext,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`toothNumber`,`prostheticSheetID`),
  KEY `idx_ToothInfo_Order` (`ownerID`),
  KEY `fk_ToothInfo_ProstheticSheet` (`prostheticSheetID`),
  CONSTRAINT `fk_ToothInfo_ProstheticSheet` FOREIGN KEY (`prostheticSheetID`) REFERENCES `ProstheticSheet` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ToothInfo`
--

LOCK TABLES `ToothInfo` WRITE;
/*!40000 ALTER TABLE `ToothInfo` DISABLE KEYS */;
INSERT INTO `ToothInfo` VALUES (662,11,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,11,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,11,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,11,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,11,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,11,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,11,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,11,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,11,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,11,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,11,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,11,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,11,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,11,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,11,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,12,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,12,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,12,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,12,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,12,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,12,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,12,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,12,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,12,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,12,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,12,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,12,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,12,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,12,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,12,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,13,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,13,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,13,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,13,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,13,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,13,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,13,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,13,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,13,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,13,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,13,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,13,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,13,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,13,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,13,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,14,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,14,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,14,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,14,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,14,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,14,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,14,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,14,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,14,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,14,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,14,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,14,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,14,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,14,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,14,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,15,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,15,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,15,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,15,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,15,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,15,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,15,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,15,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,15,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,15,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,15,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,15,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,15,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,15,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,15,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,16,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,16,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,16,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,16,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,16,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,16,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,16,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,16,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,16,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,16,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,16,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,16,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,16,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,16,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,16,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,17,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,17,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,17,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,17,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,17,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,17,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,17,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,17,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,17,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,17,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,17,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,17,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,17,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,17,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,17,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,18,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,18,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,18,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,18,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,18,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,18,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,18,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,18,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,18,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,18,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,18,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,18,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,18,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,18,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,18,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,21,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,21,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,21,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,21,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,21,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,21,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,21,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,21,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,21,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,21,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,21,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,21,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,21,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,21,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,21,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,22,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,22,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,22,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,22,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,22,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,22,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,22,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,22,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,22,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,22,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,22,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,22,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,22,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,22,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,22,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,23,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,23,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,23,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,23,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,23,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,23,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,23,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,23,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,23,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,23,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,23,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,23,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,23,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,23,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,23,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,24,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,24,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,24,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,24,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,24,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,24,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,24,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,24,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,24,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,24,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,24,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,24,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,24,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,24,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,24,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,25,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,25,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,25,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,25,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,25,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,25,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,25,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,25,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,25,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,25,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,25,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,25,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,25,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,25,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,25,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,26,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,26,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,26,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,26,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,26,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,26,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,26,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,26,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,26,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,26,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,26,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,26,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,26,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,26,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,26,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,27,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,27,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,27,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,27,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,27,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,27,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,27,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,27,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,27,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,27,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,27,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,27,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,27,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,27,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,27,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,28,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,28,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,28,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,28,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,28,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,28,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,28,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,28,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,28,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,28,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,28,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,28,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,28,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,28,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,28,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,31,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,31,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,31,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,31,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,31,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,31,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,31,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,31,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,31,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,31,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,31,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,31,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,31,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,31,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,31,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,32,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,32,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,32,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,32,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,32,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,32,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,32,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,32,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,32,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,32,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,32,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,32,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,32,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,32,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,32,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,33,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,33,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,33,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,33,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,33,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,33,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,33,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,33,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,33,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,33,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,33,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,33,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,33,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,33,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,33,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,34,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,34,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,34,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,34,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,34,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,34,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,34,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,34,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,34,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,34,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,34,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,34,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,34,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,34,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,34,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,35,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,35,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,35,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,35,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,35,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,35,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,35,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,35,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,35,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,35,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,35,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,35,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,35,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,35,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,35,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,36,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,36,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,36,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,36,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,36,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,36,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,36,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,36,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,36,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,36,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,36,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,36,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,36,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,36,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,36,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,37,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,37,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,37,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,37,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,37,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,37,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,37,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,37,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,37,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,37,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,37,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,37,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,37,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,37,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,37,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,38,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,38,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,38,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,38,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,38,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,38,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,38,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,38,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,38,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,38,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,38,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,38,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,38,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,38,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,38,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,41,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,41,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,41,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,41,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,41,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,41,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,41,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,41,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,41,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,41,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,41,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,41,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,41,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,41,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,41,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,42,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,42,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,42,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,42,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,42,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,42,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,42,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,42,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,42,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,42,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,42,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,42,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,42,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,42,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,42,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,43,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,43,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,43,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,43,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,43,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,43,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,43,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,43,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,43,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,43,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,43,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,43,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,43,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,43,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,43,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,44,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,44,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,44,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,44,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,44,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,44,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,44,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,44,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,44,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,44,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,44,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,44,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,44,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,44,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,44,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,45,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,45,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,45,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,45,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,45,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,45,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,45,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,45,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,45,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,45,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,45,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,45,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,45,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,45,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,45,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,46,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,46,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,46,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,46,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,46,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,46,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,46,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,46,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,46,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,46,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,46,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,46,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,46,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,46,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,46,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,47,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,47,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,47,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,47,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,47,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,47,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,47,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,47,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,47,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,47,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,47,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,47,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,47,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,47,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,47,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34'),(662,48,'03969eb4-0bb5-4cae-92e8-5cf65689757e',NULL,'2021-09-27 11:01:34'),(662,48,'083f4c03-5580-45f2-9229-c3b06c40bbe2',NULL,'2021-09-27 11:01:34'),(662,48,'118a8411-96d0-412f-a2fd-6e990b04bf34',NULL,'2021-09-27 11:01:34'),(662,48,'50b326be-6726-493a-a2ce-6f1153dc9927',NULL,'2021-09-27 11:01:34'),(662,48,'5d81ea77-9474-4056-9631-6c7167b6f3eb',NULL,'2021-09-27 11:01:34'),(662,48,'63706c26-d501-4c56-bdc2-ab2c76f6d988',NULL,'2021-09-27 11:01:34'),(662,48,'6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',NULL,'2022-09-19 13:19:17'),(662,48,'6ff5b097-d5bb-4902-981f-b53e6fa85604',NULL,'2021-09-27 11:01:34'),(662,48,'7a51b084-d261-4bda-a936-18d73b32440e',NULL,'2021-09-27 11:01:34'),(662,48,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98',NULL,'2021-09-27 11:01:34'),(662,48,'b1c50855-9551-467e-94d9-915a6218ec1b',NULL,'2021-09-27 11:01:34'),(662,48,'d75864c1-5365-47a3-9907-f9bee7a8fe94',NULL,'2021-09-27 11:01:34'),(662,48,'eb120496-ad30-4640-856b-fbdd1139c529',NULL,'2021-09-27 11:01:34'),(662,48,'fb151d98-0604-45ed-8599-26fa11975b19',NULL,'2021-09-27 11:01:34'),(662,48,'fce8aef9-22f3-446a-bd23-7f6a283417dc',NULL,'2021-09-27 11:01:34');
/*!40000 ALTER TABLE `ToothInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version_major` int NOT NULL DEFAULT '0',
  `version_minor` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `migration_file` varchar(1024) DEFAULT NULL,
  `commit` varchar(255) DEFAULT NULL,
  `version_core` varchar(255) DEFAULT NULL,
  `version_IHM` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,15,'v1.15','','','1.9.0','2.0.4'),(2,1,18,'v1.18','migration_fileconstraint_local','','1.9.0','2.0.4'),(3,1,19,'v1.19','migration_fileconstraint_local','','1.9.0','2.0.4'),(4,1,20,'v1.20','migration_globalDisplayID_local','','1.9','2.0.4'),(5,1,21,'v1.21','migration_config_show_open_stl_warning_local','','1.9','2.0.4'),(6,1,22,'v1.22','migration_resetcontact_local','','1.9','2.0.4'),(7,1,23,'v1.23','migration_token_context_device_local','','1.9','2.0.4'),(8,1,24,'v1.24','migration_config_lag_and_lost_sound_local','','1.9','2.0.4'),(9,1,25,'v1.25','migration_fix_unset_scan_creator_local','','1.9.0','2.0.4'),(10,1,26,'v1.26','migration_fix_wrong_original_files_local','','1.9.0','2.0.4'),(11,1,27,'v1.27','migration_occlusion_display_id_local','','1.9','2.0.4'),(12,1,28,'v1.28','migration_selfdiscussions_local','','1.9','2.0.4'),(13,1,29,'v1.29','migration_config_show_delete_confirmation_local','','1.9','2.0.4'),(14,1,30,'v1.30','migration_config_email_notifications_local','','1.9','2.0.4'),(15,1,31,'v1.31','migration_config_last_synced_local','','1.9','2.0.4'),(16,1,32,'v1.32','migration_lastmodified_local','','1.9','2.0.4'),(17,1,33,'v1.33','migration_config_add_fields_flip_local','','1.9','2.0.4'),(18,1,34,'v1.34','migration_unread_local','','1.9','2.0.4'),(19,1,35,'v1.35','migration_work_last_accessed_local','','1.9','2.0.4'),(20,1,36,'v1.36','migration_config_show_sync_info_local','','1.9','2.0.4'),(21,1,37,'v1.37','migration_config_clean_deprecated_fields_local','','1.9','2.0.4'),(22,1,38,'v1.38','migration_act_refonte_local','','1.9','2.0.4'),(23,1,39,'v1.39','migration_fix_duplicate_screenshot_path_local','','1.9','2.0.4'),(24,1,40,'v1.40','migration_rework_local','','1.9.0','2.0.4'),(25,1,41,'v1.41','migration_sync_info_local','','1.9.0','1.1-3'),(26,1,42,'v1.42','migration_config_popup_flip','','1.9','2.0.4'),(27,1,43,'v1.43','migration_mark_contacts_invisible_local','','1.9','3.2.1'),(28,1,44,'v1.44','migration_config_show_margin_lines_warning_local','','1.9','2.0.4'),(29,1,45,'v1.45','migration_contact_invitation_local','','1.9','2.3.0'),(30,1,46,'v1.46','migration_received_order_local','','1.9','3.3.0'),(31,1,47,'v1.47','migration_merge_discussions_local','','1.9','3.3.1'),(32,1,48,'v1.48','migration_office_rename_email_local','','1.9','3.3.1'),(33,1,49,'v1.49','migration_contact_cannot_reject_self_local','','1.9','3.3.1'),(34,1,50,'v1.50','migration_discussion_deletedat_not_null_local','','1.9','3.3.1'),(35,1,51,'v1.51','migration_reset_condor_file_trigger_local','','1.9','3.3.1'),(36,1,52,'v1.52','migration_system_notification_local','','1.9','2.3.0'),(37,1,53,'v1.53','migration_add_last_connection_checked_professional_local','','1.9','3.4.0'),(38,1,54,'v1.54','migration_endless_scans_local','','1.9','3.4.0'),(39,1,55,'v1.55','migration_rename_act_session_local','','1.9','3.4.0'),(40,1,56,'v1.56','migration_sessionId_local','','1.9','3.4.0'),(41,1,57,'v1.57','migration_session_created_at_local','','1.9','3.4.0'),(42,1,58,'v1.58','migration_order_display_id_local','','1.9','3.4.0'),(43,1,59,'v1.59','migration_pin_patient_local','','1.9','1.0.0'),(44,1,60,'v1.60','migration_enable_upload_local','','3.4.0','1.0.1'),(45,1,61,'v1.61','migration_remove_occlusion_contact_local','','3.4.1','1.1.0'),(46,1,62,'v1.62','migration_scanid_local','','3.4.1','1.1.0'),(47,1,63,'v1.63','migration_circleorder_local','','3.4.1','1.1.0'),(48,1,64,'v1.64','migration_smilersorder_local','','4.1.0','2.1.0'),(49,1,65,'v1.65','migration_demo_professional','','4.1.0','2.1.0'),(50,1,66,'v1.66','migration_tracking_rectangle','','4.1.0','2.1.1'),(51,1,67,'v1.67','migration_fix_status_circle_smilers','','4.1.0','2.1.1'),(52,1,68,'v1.68','migration_remove_scansID_session_local','','4.2.0','2.1.1'),(53,1,69,'v1.69','migration_externalize_occlusion_local','','4.2.0','2.1.1'),(54,1,70,'v1.70','migration_scan_occlusion_trigger_local','','4.2.0','2.1.1'),(55,1,71,'v1.71','migration_add_date_created_scan_local','','4.2.0','2.1.1'),(56,1,72,'v1.72','migration_scan_status_local','','4.2.0','2.1.1'),(57,1,73,'v1.73','migration_remove_patient_personnal_data_local','','4.2.0','2.1.1'),(58,1,74,'v1.74','migration_fix_xxxinfo_local','','4.3.0','2.2.3'),(59,1,75,'v1.75','migration_add_displayid_occlusion_local','','4.3.0','2.3.3'),(60,1,76,'v1.76','migration_add_table_ProstheticSheet_local','','4.4.0','2.3.4'),(61,1,77,'v1.77','migration_status_smilers_circle_local','','4.2.0','2.4.0'),(62,1,78,'v1.78','migration_condor_local_1.78_patient_theme','','4.4.0','2.4.0'),(63,1,79,'v1.79','migration_condor_local_1.79_fix_order_recipient','','4.5.0','2.4.4'),(64,1,80,'v1.80','migration_condor_local_1.80_fix_order','','4.5.0','2.4.4'),(65,1,81,'v1.81','migration_condor_local_1.81_fix_theme_null','','4.5.0','2.4.4'),(66,1,82,'v1.82','migration_condor_local_1.82_fix_wow_data','','5.0.0','3.0.1'),(67,1,83,'v1.83','migration_condor_local_1.83_remove_ownerid','','5.0.0','3.0.1'),(68,1,84,'v1.84','migration_condor_local_1.84_generate_professional_env_infos','','5.0.0','3.0.1'),(69,1,85,'v1.85','migration_condor_local_1.85_add_updatedat_professional_env_infos','','5.0.0','3.0.1'),(70,1,86,'v1.86','migration_condor_local_1.86_update_token','','5.0.0','3.0.1'),(71,1,87,'v1.87','migration_condor_local_1.87_add_galaxy_status','','5.0.0','3.0.1'),(72,1,88,'v1.88','migration_condor_local_1.88_fix_order_recipient','','5.0.0','3.1.2'),(73,1,89,'v1.89','migration_condor_local_1.89_fix_personinfo','','5.1.0','4.0.0'),(74,1,90,'v1.90','migration_condor_local_1.90_fix_syncinfo','','5.1.0','4.0.0');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'condor'
--
/*!50003 DROP FUNCTION IF EXISTS `generateid` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `generateid`(maxchars int) RETURNS char(36) CHARSET utf8mb3
BEGIN

  DECLARE AllChars char(16);
  DECLARE currentStr CHAR(36);
  DECLARE p1 int;
  
  SET AllChars = 'abcdef0123456789'; 
  SET currentStr = '';
  SET p1 = 0;

  charLoop: LOOP
  
    IF p1 < maxchars THEN
	  SET currentStr = CONCAT(currentStr, substring(AllChars, (RAND()*15)+1, 1));
	  SET p1 = p1 + 1;
      
      ITERATE charLoop;
    END IF;
    
    LEAVE charLoop;
    
  END LOOP charLoop;
  
  RETURN currentStr;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `uuid_v4` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `uuid_v4`() RETURNS char(36) CHARSET utf8mb4
    NO SQL
BEGIN
    
    SET @h1 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h2 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h3 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h6 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h7 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h8 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');

    
    SET @h4 = CONCAT('4', LPAD(HEX(FLOOR(RAND() * 0x0fff)), 3, '0'));

    
    SET @h5 = CONCAT(HEX(FLOOR(RAND() * 4 + 8)),
                LPAD(HEX(FLOOR(RAND() * 0x0fff)), 3, '0'));

    
    RETURN LOWER(CONCAT(
        @h1, @h2, '-', @h3, '-', @h4, '-', @h5, '-', @h6, @h7, @h8
    ));
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `drop_fk_if_exists` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `drop_fk_if_exists`(in theTable varchar(128), in theFKName varchar(128) )
BEGIN
 IF((SELECT COUNT(*) AS fk_exists
     FROM information_schema.table_constraints
     WHERE TABLE_SCHEMA = DATABASE() AND table_name = theTable AND constraint_name = theFKName AND constraint_type = 'FOREIGN KEY') > 0)
 THEN
   SET @s = CONCAT('ALTER TABLE ', theTable, ' DROP FOREIGN KEY ' , theFKName);
   PREPARE stmt FROM @s;
   EXECUTE stmt;
 END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `drop_index_if_exists` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `drop_index_if_exists`(in theTable varchar(128), in theIndexName varchar(128) )
BEGIN
 IF((SELECT COUNT(*) AS index_exists
     FROM information_schema.statistics
     WHERE TABLE_SCHEMA = DATABASE() and table_name = theTable AND index_name = theIndexName) > 0)
 THEN
   SET @s = CONCAT('DROP INDEX ' , theIndexName , ' ON ' , theTable);
   PREPARE stmt FROM @s;
   EXECUTE stmt;
 END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `fixOrderFrom176` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `fixOrderFrom176`()
    NO SQL
BEGIN
    SET @script_ok = (SELECT COUNT(*) FROM __db_version__ WHERE version_major = '1' AND version_minor = '76');

	IF (@script_ok = 0) THEN
        SET @count_bad_date = (SELECT COUNT(*) FROM ProstheticOrder WHERE createdAt IS NULL);
        IF (@count_bad_date > 0) THEN
            CALL `script176`();
        ELSE
            SET @count_bad_toothinfo = (SELECT COUNT(*) FROM ToothInfo WHERE prostheticSheetID = '');
            IF (@count_bad_toothinfo > 0) THEN
                DELETE FROM ToothInfo WHERE prostheticSheetID = '';

                ALTER TABLE ToothInfo ADD PRIMARY KEY (ownerID, toothNumber, prostheticSheetID);
                ALTER TABLE ToothInfo DROP COLUMN orderID;

                INSERT INTO `__db_version__`(`version_major`, `version_minor`, `title`, `commit`, `migration_file`, `version_core`, `version_IHM`) VALUES
                    (1, 76, 'v1.76', '', 'migration_condor_local_1.76_add_table_ProstheticSheet_from_180', '4.4.0', '2.3.4');
            END IF;
        END IF;
    END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `FixOrderRecipient` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `FixOrderRecipient`()
    NO SQL
BEGIN
    DECLARE CurOrderOwnerID MEDIUMINT(8) UNSIGNED;
    DECLARE CurOrderUuid CHAR(36);
    DECLARE CurOrderId VARCHAR(255);

    DECLARE NbRecipient INT(8);
    DECLARE DID CHAR(36);
    DECLARE RecipientOwnerId MEDIUMINT(8) UNSIGNED;
    DECLARE RecipientContactId CHAR(36);

    DECLARE exit_loop BOOLEAN DEFAULT FALSE;

    DECLARE CUR CURSOR FOR
        SELECT ownerId, uuid, id
        FROM DebugOrderData
        WHERE id IS NOT NULL;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

    OPEN CUR;
    read_loop: LOOP
        FETCH CUR INTO CurOrderOwnerID, CurOrderUuid, CurOrderId;

        
        
        IF exit_loop THEN
            CLOSE CUR;
            LEAVE read_loop;
        END IF;

        SET NbRecipient = (SELECT COUNT(*) FROM ProstheticOrderRecipient WHERE orderID = CurOrderUuid);

        IF NbRecipient = 0 THEN
            SET DID = (SELECT discussionID FROM SentMessage WHERE LOCATE(CurOrderId, body) > 0);

            IF DID IS NOT NULL THEN
                SET RecipientOwnerId = (SELECT ownerID FROM Discussion WHERE id = DID AND ownerID != CurOrderOwnerID);

                IF RecipientOwnerId IS NOT NULL THEN
                    SET RecipientContactId = (SELECT id FROM Contact WHERE ownerID = CurOrderOwnerID AND professionalID = RecipientOwnerId);

                    IF RecipientContactId IS NOT NULL THEN
                        INSERT INTO ProstheticOrderRecipient VALUES (CurOrderOwnerID, CurOrderUuid , RecipientContactId, NOW());
                    END IF;
                END IF;
            END IF;
        END IF;
    END LOOP;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `getUsedScansForOcclusion` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `getUsedScansForOcclusion`()
    NO SQL
BLOCK1: BEGIN

  DECLARE CurFileID CHAR(36);
  DECLARE CurFileMetadata TEXT;
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurFileTag TEXT;
  
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  DECLARE read_sessionid TEXT;

  DECLARE CUR CURSOR FOR
          SELECT CondorFile.id, CondorFile.metadata, CondorFile.ownerID, CondorFile.tag
          FROM CondorFile WHERE tag LIKE '%_OCC_%' AND metadata LIKE '%"referenceScanID":"%' AND deletedAt IS NULL;
          
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

	  FETCH CUR INTO CurFileID, CurFileMetadata, CurOwnerID, CurFileTag;

		IF exit_loop THEN
			CLOSE CUR;
			LEAVE read_loop;
		END IF;
		
    
		SET @refScanDelimiter = SUBSTRING_INDEX(CurFileMetadata, '"referenceScanID":"', -1); 
		SET @refScanID = SUBSTRING_INDEX(@refScanDelimiter, ':', 1);
        
		SET @actDelemiter = SUBSTRING_INDEX(CurFileTag, '_ACT_', -1); 
        SET @curActID = SUBSTRING_INDEX(@actDelemiter, '_', 1);
		SET @sessionDelemiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1); 
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelemiter, '_', 1);
        
        
        
		IF @curActID is NOT NULL AND @curSessionID is NOT NULL THEN
        
			SET @actOwnerID = (SELECT ownerID FROM Act WHERE id = @curActID);
			SET @sessionOwnerID = (SELECT ownerID FROM Session WHERE id = @curSessionID);
            
            
            IF @actOwnerID = CurOwnerID AND @sessionOwnerID = CurOwnerID THEN
            
				SET @scanNo = SUBSTRING_INDEX(@refScanID,'.',-1);
				SET @scanType = '';
				SET @findTopScan = CurFileTag LIKE '%_TOPLY_%';
				SET @findBottomScan = CurFileTag LIKE '%_BOPLY_%';
				
				IF @findTopScan > 0 THEN
					SET @scanType = 'MAXILLAIRE';
				ELSEIF @findBottomScan > 0 THEN
					SET @scanType = 'MANDIBULE';
				ELSE 
					ITERATE read_loop;
				END IF;
                 
                SET @scanID = (SELECT id FROM Scan WHERE ownerID = CurOwnerID AND sessionID = @curSessionID AND displayID = @scanNo AND scanType = @scanType AND deletedAt IS NULL );
				SET @occlusionID =  SUBSTRING_INDEX(SUBSTRING_INDEX(CurFileTag, '_OCC_', -1), '_', 1); 
				
				IF @occlusionID IS NULL THEN 
					ITERATE read_loop;
				END IF;
	
				IF @findTopScan > 0 THEN
					UPDATE Occlusion SET topScanID = @scanID WHERE id = @occlusionID;
				ELSEIF @findBottomScan > 0 THEN
					UPDATE Occlusion SET bottomScanID = @scanID WHERE id = @occlusionID;
				END IF; 
                
            END IF;
		
        END IF;
         
  END LOOP;

END BLOCK1 ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `migrateLifiOcclusionFiles` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `migrateLifiOcclusionFiles`()
    NO SQL
BEGIN

  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurFilePath TEXT;
  DECLARE CurFileID CHAR(36);
  DECLARE CurFileTag VARCHAR(250);
  DECLARE CurFileType VARCHAR(250);
  DECLARE CurFileMetadata TEXT;
  
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;
  
  DECLARE read_sessionid TEXT;

  
  DECLARE CUR CURSOR FOR
          SELECT CondorFile.ownerID, CondorFile.id, CondorFile.tag, CondorFile.path, CondorFile.type, CondorFile.metadata
          FROM CondorFile
	  WHERE type LIKE '%LIFI%' AND metadata LIKE '%"isOcclusionMarginLine":true%' AND id NOT IN (SELECT fileID FROM ReceivedAttachment);

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;
  
  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurFileID, CurFileTag, CurFilePath, CurFileType, CurFileMetadata;

	
	
	IF exit_loop THEN
		CLOSE CUR;
		LEAVE read_loop;
	END IF;
		
	SET @sessionDelimiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1);
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelimiter, '_', 1);
        
	SELECT ownerID, id INTO @occlusionOwnerID, @occlusionID FROM Occlusion WHERE sessionID = @curSessionID;
      
	
        
	IF @occlusionID IS NOT NULL AND @occlusionOwnerID = CurOwnerID THEN

		SET @pleft = SUBSTRING_INDEX(CurFileTag, @curSessionID, 1);
		SET @newTag = CONCAT(@pleft, @curSessionID, '_OCC_', @occlusionID, '_', CurFileType, 'O_', CurFileType, '_');
            
		SET @filename = SUBSTRING_INDEX(CurFilePath, '/', -1);
		SET @scanPath = SUBSTRING_INDEX(CurFilePath, '/', -2);
		SET @sessionPath = SUBSTRING_INDEX(CurFilePath, @scanPath, 1);
		SET @newFilePath = CONCAT(@sessionPath, 'computedocclusion_', @occlusionID, '/', @filename);

		UPDATE CondorFile SET tag = @newTag, path = @newFilePath WHERE id = CurFileID;
             
		
		INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
		VALUES (CurOwnerID, CurFileID, @occlusionID, CURRENT_TIMESTAMP);

		
		SET @scanID = (SELECT scanID FROM ScanFile WHERE fileID = CurFileID);

		IF @scanID IS NOT NULL THEN
			SET @scanType = (SELECT scanType FROM Scan WHERE id = @scanID);

			IF @scanType is not NULL THEN
				SET @currentMetadata = SUBSTRING_INDEX(CurFileMetadata, '}', 1);
				SET @lifiScanType = CONCAT('"lifi_scan_type":"', @scanType, '"');
				SET @newMetadata = CONCAT(@currentMetadata, ',', @lifiScanType, '}');

				UPDATE CondorFile SET metadata = @newMetadata WHERE id = CurFileID;
			END IF;

		END IF;

            
            DELETE FROM ScanFile WHERE fileID = CurFileID;

	END IF;

  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `migrateOcclusions` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `migrateOcclusions`()
    NO SQL
BEGIN
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurSessionID CHAR(36);
  DECLARE CurMandibuleOcclusionPlyID CHAR(36);
  DECLARE CurMaxillaireOcclusionPlyID CHAR(36);
  DECLARE CurMatrixTransformationMandibuleID CHAR(36);
  DECLARE CurMatrixTransformationMaxillaireID CHAR(36);
  DECLARE CurSnapshotID CHAR(36);
  
  
  DECLARE TopScanID CHAR(36);
  DECLARE BottomScanID CHAR(36);
  DECLARE CheckIntegrity BOOLEAN DEFAULT FALSE;

  DECLARE NewOcclusionID CHAR(36);
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  
  DECLARE CUR CURSOR FOR
          SELECT Session.ownerID, Session.id, Session.mandibuleOcclusionPlyID, Session.maxillaireOcclusionPlyID,
					Session.matrixTransformationMandibuleID, Session.matrixTransformationMaxillaireID, Session.snapshotID
          FROM Session WHERE deletedAt IS NULL AND mandibuleOcclusionPlyID IS NOT NULL AND maxillaireOcclusionPlyID IS NOT NULL AND
					matrixTransformationMandibuleID IS NOT NULL AND matrixTransformationMaxillaireID IS NOT NULL AND snapshotID IS NOT NULL;
          
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurSessionID, CurMandibuleOcclusionPlyID, CurMaxillaireOcclusionPlyID,
					CurMatrixTransformationMandibuleID, CurMatrixTransformationMaxillaireID, CurSnapshotID;

    
    
    IF exit_loop THEN
	CLOSE CUR;
	LEAVE read_loop;
    END IF;

	SET TopScanID = (SELECT scanID from ScanFile WHERE fileID = CurMaxillaireOcclusionPlyID);
    SET BottomScanID = (SELECT scanID from ScanFile WHERE fileID = CurMandibuleOcclusionPlyID);

    
	
	

	
	
    
    SET NewOcclusionID = concat(left(CurSessionID, length(CurSessionID) - 9), 'migraoccl');
	
	INSERT INTO Occlusion(ownerID, id, sessionID, occlusionType, deletedAt, createdAt, lastSynced, lastModified, lastUpdated, topScanID, bottomScanID, 
							anteriorBiteScanID, rightBiteScanID, leftBiteScanID, snapshotID, mandibuleOcclusionPlyID, maxillaireOcclusionPlyID, matrixTransformationMandibuleID, 
							matrixTransformationMaxillaireID)
							VALUES (CurOwnerID, NewOcclusionID, CurSessionID, NULL, NULL, CURRENT_TIMESTAMP, NULL, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, TopScanID, BottomScanID,
							NULL, NULL, NULL, CurSnapshotID, CurMandibuleOcclusionPlyID, CurMaxillaireOcclusionPlyID, CurMatrixTransformationMandibuleID,
							CurMatrixTransformationMaxillaireID);
	
	
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMandibuleOcclusionPlyID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMaxillaireOcclusionPlyID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMatrixTransformationMandibuleID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMatrixTransformationMaxillaireID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurSnapshotID, NewOcclusionID, CURRENT_TIMESTAMP);          
    


  END LOOP;
  
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `script176` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `script176`()
    NO SQL
BEGIN
    
    DROP TABLE IF EXISTS `ProstheticSheet`;
    CREATE TABLE `ProstheticSheet` (
        `id` char(36) NOT NULL,
        `ownerID` mediumint(8) unsigned NOT NULL,
        `orderID` char(36) NOT NULL,
        `json` TEXT NOT NULL,
        `pdfFileID` char(36) DEFAULT NULL,
        `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        `deletedAt` datetime DEFAULT NULL,
        `lastSynced` datetime DEFAULT NULL,
        `lastModified` datetime NOT NULL,
        `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`,`ownerID`),
        CONSTRAINT `fk_ProstheticSheet_ProstheticOrder` FOREIGN KEY (`orderID`) REFERENCES `ProstheticOrder` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
        CONSTRAINT `fk_ProstheticSheet_CondorFile` FOREIGN KEY (`pdfFileID`) REFERENCES `CondorFile` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

    
    UPDATE ProstheticOrder SET createdAt = lastUpdated WHERE createdAt IS NULL;

    
    INSERT INTO ProstheticSheet (id, ownerID, orderID, json, dateCreated, deletedAt, lastSynced, lastModified, lastUpdated)
    SELECT
        PO.id as id,
        PO.ownerID,
        PO.id as orderID,
        CONCAT('{"sheetTitle":"', PO.title, '",', RIGHT(PO.json, LENGTH(PO.json)-1)), 
        PO.createdAt as dateCreated,
        PO.deletedAt,
        PO.lastSynced,
        PO.lastModified,
        PO.lastUpdated
    FROM ProstheticOrder AS PO;

    CREATE TEMPORARY TABLE PDF_ID_TMP
    SELECT POF1.orderID, POF1.fileID, CF1.version, T.maxVersion
    FROM ProstheticOrderFile AS POF1
    INNER JOIN CondorFile AS CF1 ON POF1.fileID = CF1.id
    INNER JOIN (
        SELECT POF2.orderID, MAX(CF2.version) AS maxVersion
        FROM ProstheticOrderFile AS POF2
        INNER JOIN CondorFile AS CF2 ON POF2.fileID = CF2.id
        WHERE CF2.type = 'PDF'
        GROUP BY POF2.orderID
    ) T ON POF1.orderID = T.orderID
    WHERE CF1.type = 'PDF' AND CF1.version = T.maxVersion;

    UPDATE ProstheticSheet AS PS
    INNER JOIN PDF_ID_TMP AS PDF ON PDF.orderID = PS.orderID
    SET PS.pdfFileID = PDF.fileID;

    DROP TEMPORARY TABLE PDF_ID_TMP;

    
    
    

    ALTER TABLE SyncInfo ADD prostheticSheetsLastRetrieved DATETIME NULL AFTER smilersordersLastRetrieved;

    ALTER TABLE ProstheticOrder DROP COLUMN json;

    ALTER TABLE ToothInfo ADD prostheticSheetID char(36) NOT NULL AFTER toothNumber;

    UPDATE ToothInfo AS TI
    INNER JOIN ProstheticSheet AS PS on TI.orderID = PS.orderID
    SET TI.prostheticSheetID = PS.id;

    
    
    

    
    ALTER TABLE ToothInfo DROP FOREIGN KEY fk_ToothInfo_Order;

    
    ALTER TABLE ToothInfo ADD CONSTRAINT `fk_ToothInfo_ProstheticSheet` FOREIGN KEY (`prostheticSheetID`) REFERENCES `ProstheticSheet` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

    ALTER TABLE ToothInfo DROP PRIMARY KEY;
    ALTER TABLE ToothInfo ADD PRIMARY KEY (ownerID, toothNumber, prostheticSheetID);

    ALTER TABLE ToothInfo DROP COLUMN orderID;

    
    
    

    INSERT INTO `__db_version__`(`version_major`, `version_minor`, `title`, `commit`, `migration_file`, `version_core`, `version_IHM`) VALUES
    (1, 76, 'v1.76', '', 'migration_condor_local_1.76_add_table_ProstheticSheet_from_180', '4.4.0', '2.3.4');

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `updateOcclusionsCondorFilesTag` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `updateOcclusionsCondorFilesTag`()
    NO SQL
BEGIN

  DECLARE CurFilePath TEXT;
  DECLARE CurFileID CHAR(36);
  DECLARE CurFileTag VARCHAR(250);
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;
  
  DECLARE read_sessionid TEXT;

  
  DECLARE CUR CURSOR FOR
          SELECT CondorFile.id, CondorFile.tag, CondorFile.path
          FROM CondorFile 
	  WHERE tag REGEXP '_TOMA_|_BOMA_|_TOPLY_|_BOPLY_|_SNAPO_' AND id NOT IN (SELECT fileID FROM ReceivedAttachment);

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurFileID, CurFileTag, CurFilePath;

	
	
	IF exit_loop THEN
		CLOSE CUR;
		LEAVE read_loop;
	END IF;
		
        SET @sessionDelimiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1); 
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelimiter, '_', 1);
        
        
	Set @occlusionID = (SELECT id FROM Occlusion WHERE sessionID = @curSessionID AND deletedAt IS NULL);
      
	IF @occlusionID is not NULL THEN

		SET @pleft = SUBSTRING_INDEX(CurFileTag, @curSessionID, 1); 
		SET @pright = SUBSTRING_INDEX(CurFileTag, @curSessionID, -1); 
		SET @newTag = CONCAT(@pleft, @curSessionID, '_OCC_', @occlusionID, @pright);

		SET @filename = SUBSTRING_INDEX(CurFilePath, '/', -1);
		SET @sessionPath = SUBSTRING_INDEX(CurFilePath, @filename, 1);
		SET @newFilePath = CONCAT(@sessionPath, 'computedocclusion_', @occlusionID, '/', @filename);

		UPDATE CondorFile SET tag = @newTag, path = @newFilePath WHERE id = CurFileID;
        END IF;
        
  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `updateScanDisplayID` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `updateScanDisplayID`()
    NO SQL
BEGIN
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurID CHAR(36);
  DECLARE CurSessionID CHAR(36);
  DECLARE CurLastSync DATETIME;

  DECLARE CurScanType
  ENUM('MAXILLAIRE', 'MANDIBULE', 'MORDU_ANTERIEUR', 'MORDU_POSTERIEUR_GAUCHE', 'MORDU_POSTERIEUR_DROIT');

  DECLARE CurNbSyncScan INT;
  DECLARE CurMaxDisplayID INT;

  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  DECLARE CUR CURSOR FOR
          SELECT Scan.ownerID, Scan.id, Scan.sessionID, Scan.scanType, Scan.lastSynced
          FROM Scan;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurID, CurSessionID, CurScanType, CurLastSync;

    
    
    IF exit_loop THEN
	CLOSE CUR;
	LEAVE read_loop;
    END IF;

    IF CurLastSync IS NULL THEN

	SET CurNbSyncScan = (SELECT COUNT(*)
				FROM Scan
				WHERE ownerID = CurOwnerID AND sessionID = CurSessionID AND scanType = CurScanType AND lastSynced IS NOT NULL);


	SET CurMaxDisplayID = (SELECT MAX(displayID)
				FROM Scan
				WHERE ownerID = CurOwnerID AND sessionID = CurSessionID AND scanType = CurScanType);

    	IF CurMaxDisplayID IS NULL OR CurMaxDisplayID = 0 THEN
		
        	SET CurMaxDisplayID = CurNbSyncScan;
    	END IF;

    	UPDATE Scan
    	SET displayID = (CurMaxDisplayID + 1)
    	WHERE ownerID = CurOwnerID AND id = CurID;

    END IF;

  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-06-13 14:54:20
