-- MySQL dump 10.13  Distrib 8.0.27, for Linux (x86_64)
--
-- Host: localhost    Database: condor_client_local
-- ------------------------------------------------------
-- Server version	8.0.27-0ubuntu0.20.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Camera`
--

DROP TABLE IF EXISTS `Camera`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Camera` (
  `reference` char(13) NOT NULL,
  PRIMARY KEY (`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Camera`
--

LOCK TABLES `Camera` WRITE;
/*!40000 ALTER TABLE `Camera` DISABLE KEYS */;
INSERT INTO `Camera` VALUES ('1536010CR1603'),('1536010CR1615'),('1550010CR2183'),('1550010CR2407'),('1918020WO0318'),('1918020WO0344'),('1928021WO0705'),('1928021WO0830'),('1928021WO0831'),('2005021WO0843'),('2005021WO0882'),('2005021WO0969'),('2005021WO1091'),('2005021WO1239'),('2005021WO1253'),('2005021WO1278'),('2005021WO1359'),('2005021WO1420'),('2041022WO1559'),('2041022WO1562'),('2049022WO1716'),('2049022WO1897');
/*!40000 ALTER TABLE `Camera` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CameraAccess`
--

DROP TABLE IF EXISTS `CameraAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CameraAccess` (
  `professionalID` mediumint unsigned NOT NULL,
  `computerMac` char(17) NOT NULL,
  `cameraReference` char(13) NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`professionalID`,`computerMac`,`cameraReference`),
  KEY `fk_CameraAccess_Professional_idx` (`professionalID`),
  KEY `fk_CameraAccess_Computer_idx` (`computerMac`),
  KEY `fk_CameraAccess_Camera_idx` (`cameraReference`),
  CONSTRAINT `fk_CameraAccess_Camera` FOREIGN KEY (`cameraReference`) REFERENCES `Camera` (`reference`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CameraAccess_Computer` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CameraAccess_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CameraAccess`
--

LOCK TABLES `CameraAccess` WRITE;
/*!40000 ALTER TABLE `CameraAccess` DISABLE KEYS */;
INSERT INTO `CameraAccess` VALUES (43,'00:d8:61:84:ce:16','1550010CR2407','2021-01-13 09:26:11','2021-01-13 08:26:11'),(43,'00:d8:61:84:ce:16','1918020WO0318','2021-09-29 10:02:30','2021-09-29 08:02:30'),(43,'00:d8:61:84:ce:16','1928021WO0831','2020-12-04 16:05:02','2020-12-04 15:05:02'),(43,'00:d8:61:84:ce:16','2005021WO1239','2021-01-07 11:48:53','2021-01-07 10:48:53'),(43,'00:d8:61:84:ce:16','2041022WO1559','2021-03-25 16:42:38','2021-03-25 15:42:38'),(43,'00:d8:61:84:ce:16','2041022WO1562','2021-03-25 16:49:30','2021-03-25 15:49:30'),(43,'00:d8:61:84:ce:16','2049022WO1716','2021-09-22 17:03:15','2021-09-22 15:03:15'),(50,'00:d8:61:84:ce:16','1536010CR1603','2021-08-04 13:58:59','2021-08-04 11:58:59'),(50,'00:d8:61:84:ce:16','1536010CR1615','2021-08-04 11:18:03','2021-08-04 09:18:03'),(50,'00:d8:61:84:ce:16','1550010CR2183','2021-08-04 13:31:59','2021-08-04 11:31:59'),(50,'00:d8:61:84:ce:16','1550010CR2407','2020-09-16 10:44:09','2020-09-16 08:44:09'),(50,'00:d8:61:84:ce:16','1918020WO0318','2021-09-29 12:10:33','2021-09-29 10:10:33'),(50,'00:d8:61:84:ce:16','1918020WO0344','2021-12-02 10:53:45','2021-12-02 09:53:45'),(50,'00:d8:61:84:ce:16','1928021WO0705','2020-09-30 15:53:07','2020-09-30 13:53:07'),(50,'00:d8:61:84:ce:16','1928021WO0830','2020-09-17 16:22:16','2020-09-17 14:22:16'),(50,'00:d8:61:84:ce:16','1928021WO0831','2020-10-09 12:06:26','2020-10-09 10:06:26'),(50,'00:d8:61:84:ce:16','2005021WO0843','2020-10-21 09:31:50','2020-10-21 07:31:50'),(50,'00:d8:61:84:ce:16','2005021WO0882','2020-10-21 14:37:41','2020-10-21 12:37:41'),(50,'00:d8:61:84:ce:16','2005021WO0969','2020-10-16 16:13:59','2020-10-16 14:13:59'),(50,'00:d8:61:84:ce:16','2005021WO1091','2020-10-19 10:52:15','2020-10-19 08:52:15'),(50,'00:d8:61:84:ce:16','2005021WO1239','2020-10-09 12:06:25','2020-10-09 10:06:25'),(50,'00:d8:61:84:ce:16','2005021WO1253','2020-10-16 15:41:22','2020-10-16 13:41:22'),(50,'00:d8:61:84:ce:16','2005021WO1278','2020-10-21 15:21:17','2020-10-21 13:21:17'),(50,'00:d8:61:84:ce:16','2005021WO1359','2021-07-29 16:50:04','2021-07-29 14:50:04'),(50,'00:d8:61:84:ce:16','2005021WO1420','2020-09-30 14:41:19','2020-09-30 12:41:19'),(50,'00:d8:61:84:ce:16','2041022WO1559','2021-03-23 11:43:57','2021-03-23 10:43:57'),(50,'00:d8:61:84:ce:16','2041022WO1562','2021-03-25 10:57:17','2021-03-25 09:57:17'),(50,'00:d8:61:84:ce:16','2049022WO1716','2021-09-22 16:32:28','2021-09-22 14:32:28'),(50,'00:d8:61:84:ce:16','2049022WO1897','2021-07-27 11:10:46','2021-07-27 09:10:46');
/*!40000 ALTER TABLE `CameraAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Computer`
--

DROP TABLE IF EXISTS `Computer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Computer` (
  `mac` char(17) NOT NULL,
  `condorVersionID` varchar(16) DEFAULT NULL,
  `graphicsCard` varchar(50) DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastSynced` datetime DEFAULT NULL,
  PRIMARY KEY (`mac`),
  KEY `fk_Computer_CondorVersion_idx` (`condorVersionID`),
  CONSTRAINT `fk_Computer_CondorVersion` FOREIGN KEY (`condorVersionID`) REFERENCES `CondorVersion` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Computer`
--

LOCK TABLES `Computer` WRITE;
/*!40000 ALTER TABLE `Computer` DISABLE KEYS */;
INSERT INTO `Computer` VALUES ('00:d8:61:84:ce:16','v2.5.5','NVIDIA GeForce RTX 2070 with Max-Q Design','2021-12-17 11:26:05','2021-12-17 12:26:05');
/*!40000 ALTER TABLE `Computer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorVersion`
--

DROP TABLE IF EXISTS `CondorVersion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorVersion` (
  `id` varchar(16) NOT NULL,
  `db_version` varchar(10) DEFAULT NULL,
  `ihm_version` varchar(10) DEFAULT NULL,
  `core_version` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorVersion`
--

LOCK TABLES `CondorVersion` WRITE;
/*!40000 ALTER TABLE `CondorVersion` DISABLE KEYS */;
INSERT INTO `CondorVersion` VALUES ('v0.1.1',NULL,NULL,NULL),('v0.1.2',NULL,NULL,NULL),('v2.2.2',NULL,NULL,NULL),('v2.3.3',NULL,NULL,NULL),('v2.4.4',NULL,NULL,NULL),('v2.5.5',NULL,NULL,NULL);
/*!40000 ALTER TABLE `CondorVersion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `License`
--

DROP TABLE IF EXISTS `License`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `License` (
  `number` char(23) NOT NULL,
  `professionalID` mediumint unsigned DEFAULT NULL,
  `enabled` enum('NONE','SOFTWARE','WEB','ALL') NOT NULL DEFAULT 'ALL',
  `licenseType` enum('PROD','DEMO') NOT NULL DEFAULT 'PROD',
  PRIMARY KEY (`number`),
  UNIQUE KEY `uq_professional` (`professionalID`),
  KEY `fk_License_Professional_idx` (`professionalID`),
  CONSTRAINT `fk_License_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `License`
--

LOCK TABLES `License` WRITE;
/*!40000 ALTER TABLE `License` DISABLE KEYS */;
INSERT INTO `License` VALUES ('C3FGQ3VXQUKQHZWW3IXKJHV',50,'ALL','PROD'),('N9LNXHQZQWPBGIVVZ2B2WVR',43,'ALL','PROD');
/*!40000 ALTER TABLE `License` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `LicenseAccess`
--

DROP TABLE IF EXISTS `LicenseAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LicenseAccess` (
  `professionalID` mediumint unsigned NOT NULL,
  `licenseNumber` char(23) NOT NULL,
  `computerMac` char(17) NOT NULL,
  `condorVersionID` varchar(16) NOT NULL,
  `globalID` mediumint unsigned DEFAULT NULL,
  `status` enum('VALID','REPAIR') NOT NULL DEFAULT 'VALID',
  `activationDate` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`professionalID`,`licenseNumber`,`computerMac`),
  KEY `fk_LicenseAccess_Computer_idx` (`computerMac`),
  KEY `fk_LicenseAccess_License_idx` (`licenseNumber`),
  KEY `fk_LicenseAccess_CondorVersion_idx` (`condorVersionID`),
  CONSTRAINT `fk_LicenseAccess_Computer` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_LicenseAccess_CondorVersion` FOREIGN KEY (`condorVersionID`) REFERENCES `CondorVersion` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_LicenseAccess_License` FOREIGN KEY (`licenseNumber`) REFERENCES `License` (`number`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_LicenseAccess_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LicenseAccess`
--

LOCK TABLES `LicenseAccess` WRITE;
/*!40000 ALTER TABLE `LicenseAccess` DISABLE KEYS */;
INSERT INTO `LicenseAccess` VALUES (43,'N9LNXHQZQWPBGIVVZ2B2WVR','00:d8:61:84:ce:16','v2.5.5',2,'VALID','2020-12-03 00:00:00','2022-01-03 11:40:02','2022-01-03 10:40:02'),(50,'C3FGQ3VXQUKQHZWW3IXKJHV','00:d8:61:84:ce:16','v2.5.5',1,'VALID','2020-09-16 00:00:00','2021-12-17 12:26:05','2021-12-17 11:26:05');
/*!40000 ALTER TABLE `LicenseAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `id` mediumint unsigned NOT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `country` varchar(75) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES (43,'sabine','caserta','0645636587','France'),(50,'sabine','caserta','645636587','France');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version_major` int NOT NULL DEFAULT '0',
  `version_minor` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `migration_file` varchar(1024) DEFAULT NULL,
  `commit` varchar(255) DEFAULT NULL,
  `version_core` varchar(255) DEFAULT NULL,
  `version_IHM` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_init_condorclient_local','','1.9','2.0.4'),(2,1,1,'v1.1','migration_camera_condorclient_local','','1.9','2.0.4'),(3,1,2,'v1.2','migration_graphicsCard_condorclient_local','','1.9','2.0.4'),(4,1,3,'v1.3','migration_officecountry_condorclient_local','','1.9.0','2.0.4'),(5,1,4,'v1.4','migration_licenseaccess_globalid_condorclient_local','','1.9','2.0.4'),(6,1,5,'v1.5','migration_remove_null_mac_computer_condorclient_local','','1.9','2.0.4'),(7,1,6,'v1.6','migration_license_enabled_condorclient_local','','1.9','2.0.4'),(8,1,7,'v1.7','migration_activation_history_condorclient_local','','1.9.0','2.0.4'),(9,1,8,'v1.8','migration_condor_version_condorclient_local','','1.9.0','2.0.4'),(10,1,9,'v1.9','migration_demo_professional','','4.1.0','2.1.1');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'condor_client_local'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-01-04 14:54:50
