-- MySQL dump 10.13  Distrib 8.0.30, for Linux (x86_64)
--
-- Host: localhost    Database: wow_application
-- ------------------------------------------------------
-- Server version	8.0.30-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `workflow` enum('FREE','WORKFLOW_1','WORKFLOW_2','WORKFLOW_3') NOT NULL DEFAULT 'FREE',
  `comments` text,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastAccessed` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `patientId` (`patientId`),
  CONSTRAINT `Act_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Act_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `wow_patient`.`Patient` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES ('00cdb0d1-c7e4-41bc-93a4-7c29a6f1cf58',664,'dfe1127e-d366-48f3-8672-183d37f8181f','Maxillary Rehabilitation',1,'FREE','',0,'2022-03-14 15:05:27.000',NULL,'2023-05-22 09:26:23.215','2022-03-14 16:23:59.000','2023-05-22 13:26:23.215','2023-05-22 09:26:23.231'),('04e0da18-656d-4d28-ad6d-e20cdfe5e2df',664,'6d99007d-a6df-43ae-87db-c160f6e66c0d','Cementable crown 30',2,'FREE','',0,'2022-10-19 19:30:04.000',NULL,'2022-11-09 15:43:23.000','2022-11-09 17:12:16.000','2022-11-09 22:12:16.000','2022-11-09 17:12:16.000'),('06c2562e-49fa-4926-ab49-41fe223d844d',664,'1a7a13ce-3a47-487b-8f16-db331e2672da','Crown Implant 12',1,'FREE','',0,'2022-07-28 14:58:17.000',NULL,'2022-11-07 14:03:46.000','2022-10-19 20:03:57.000','2022-11-07 19:03:50.000','2022-11-07 14:03:50.000'),('06eaeebb-cc8f-4526-b86c-b4f094b75dab',664,'965d3fb4-1cb6-4c76-b1b8-f02df7997006','',1,'FREE','',0,'2022-03-14 14:58:57.000','2022-03-14 14:59:10.000','2022-03-14 14:58:57.000','2022-03-14 14:58:57.000','2022-03-14 13:59:10.000','2022-03-14 14:59:10.000'),('07e45d8d-734b-11ee-b011-58a023cda0dc',664,'73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9','Mand Crowns Zirc Implants',10,'FREE','',0,'2023-10-25 11:27:38.000',NULL,'2023-10-30 09:26:09.000','2023-10-25 11:59:29.000','2024-10-31 14:02:22.568','2024-10-31 10:02:22.568'),('0a5a2b81-09c6-4fe0-874c-4b845c0229bc',664,'097506b2-3385-4e2b-a196-b427b2eb51b8','Denture',1,'FREE','',0,'2022-03-23 13:58:05.000',NULL,'2022-03-23 13:58:05.000','2022-03-23 14:38:43.000','2022-03-23 18:38:44.000','2022-03-23 14:38:44.000'),('0a963705-6c31-11ee-bc7f-58a023cda0dc',664,'bbc77872-6c30-11ee-bc7f-58a023cda0dc','Max and Mand Left',1,'FREE','',0,'2023-10-16 10:33:58.187',NULL,'2023-10-16 13:10:54.045','2023-10-16 13:05:08.603','2023-10-16 17:10:54.046','2023-10-16 13:10:54.062'),('112c5d39-de86-43ec-9ad6-7032d418646a',664,'36b92bb3-4eed-4383-bbf3-4b91cb0af09b','',1,'FREE','',0,'2021-04-09 19:20:15.000','2021-04-09 19:20:23.000','2021-04-09 19:20:15.000','2021-04-09 19:20:15.000','2021-04-09 23:20:23.000',NULL),('119ba34e-97cf-4c1f-bed9-20fa56366355',664,'4b4f3002-bba6-481f-a9fb-41ab2fedd61c','Maxillary Redo',3,'FREE','',0,'2021-10-27 19:43:45.000',NULL,'2022-06-27 22:10:54.000','2021-10-27 19:58:54.000','2022-06-28 02:10:56.000','2022-06-27 22:10:56.000'),('1aab3e57-f8a5-11ed-807f-58a023cda0dc',664,'dfe1127e-d366-48f3-8672-183d37f8181f','Case Other',3,'WORKFLOW_1','',0,'2023-05-22 09:32:31.907','2023-05-22 09:33:25.247','2023-05-22 09:32:32.009','2023-05-22 09:33:25.247','2023-05-22 13:33:25.248','2023-05-22 09:33:25.255'),('21c82035-4359-4880-96f0-c80e94ed36f8',664,'9bcfd1e2-10fc-4838-92c0-84057ad52bfe','Implant #11',1,'FREE','',0,'2022-08-17 18:16:02.000',NULL,'2022-08-17 18:28:23.000','2022-08-17 18:39:33.000','2022-08-17 22:39:34.000','2022-08-17 18:39:34.000'),('24491978-de7e-4fc0-bdca-4504a9581b89',664,'4b4f3002-bba6-481f-a9fb-41ab2fedd61c','Bone Reconstruction',1,'FREE','',0,'2021-03-02 17:03:07.000','2022-03-14 14:42:20.000','2021-10-05 02:50:46.000','2021-02-03 17:21:24.000','2022-03-14 13:42:20.000','2022-03-14 14:42:20.000'),('2477bdb7-4cc4-460c-abf7-139095bc04f8',664,'73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9','Maxilla with Pegs',9,'FREE','',0,'2022-03-30 12:08:42.000',NULL,'2023-10-18 09:33:04.000','2022-03-30 19:04:33.000','2024-10-31 14:02:22.560','2024-10-31 10:02:22.560'),('2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f',664,'ffbcef25-a535-4bb2-8b85-6107c1aaa2ed','Mand Hybrid',1,'FREE','',0,'2022-03-23 11:15:11.000',NULL,'2023-09-19 16:37:00.000','2022-08-22 15:06:34.000','2024-10-31 14:02:22.512','2024-10-31 10:02:22.512'),('341df9b2-9843-11ee-86e7-58a023cda0dc',664,'b4c6341b-9837-11ee-86e7-58a023cda0dc','Case Surgical Guide #7 and #8',4,'WORKFLOW_1','',0,'2023-12-11 11:34:49.967','2023-12-11 11:38:49.039','2023-12-11 11:38:35.678','2023-12-11 11:38:49.039','2023-12-11 16:38:49.041','2023-12-11 11:38:49.050'),('344acade-9e53-43df-a580-c61498c3b57a',664,'73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9','Model Pros assembly',4,'FREE','',0,'2021-05-03 19:00:53.000',NULL,'2023-10-18 09:31:53.252','2021-05-03 19:59:45.000','2023-10-18 13:31:53.252','2023-10-18 09:31:53.267'),('36d05387-51e6-4286-a074-7c7894c0622b',664,'73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9','Model Donovan',7,'FREE','',0,'2021-05-05 16:35:48.000',NULL,'2023-10-18 09:32:23.447','2021-05-05 17:45:53.000','2023-10-18 13:32:23.447','2023-10-18 09:32:23.462'),('399a5604-f330-487f-8e32-3a7a90ae6715',664,'b5cbee44-0703-46c2-986a-7a416eb4206c','Ant Maxilla',1,'FREE','',0,'2023-02-20 15:27:37.000',NULL,'2023-02-28 22:28:39.000','2023-02-20 15:59:17.000','2023-03-01 03:28:58.000','2023-02-28 22:28:58.000'),('3e0b2a44-983d-11ee-86e7-58a023cda0dc',664,'b4c6341b-9837-11ee-86e7-58a023cda0dc','Case Surgical Guide #7 and #8',2,'FREE','',0,'2023-12-11 10:52:09.000','2023-12-11 10:53:01.000','2023-12-11 10:52:36.000','2023-12-11 10:52:09.000','2024-10-31 14:02:22.601','2024-10-31 10:02:22.601'),('453ec882-572d-11ee-a378-58a023cda0dc',664,'ffbcef25-a535-4bb2-8b85-6107c1aaa2ed','Case Temporary Mandibular FD',3,'WORKFLOW_1','',0,'2023-09-19 16:44:04.195','2023-09-19 16:45:16.385','2023-09-19 16:44:10.538','2023-09-19 16:45:16.385','2023-09-19 20:45:16.386','2023-09-19 16:45:16.395'),('48975557-21ce-4d21-a4b8-334c890ddd9a',664,'509319d0-6cf3-4073-92e1-ff9307be4376','Maxillary Bone Defect',1,'FREE','',0,'2022-06-06 19:11:54.000',NULL,'2022-10-03 21:52:36.000','2022-10-03 22:06:22.000','2022-10-04 02:06:22.000','2022-10-03 22:06:22.000'),('49b3ccf6-630c-48b2-8480-8a005298959e',664,'f4f78058-cf3c-4c86-a252-bc92bd2d36b0','Anterior Maxilla Model ',1,'FREE','',0,'2021-03-02 17:03:07.000',NULL,'2021-07-23 16:33:49.000','2020-11-03 22:41:34.000','2022-03-14 13:58:26.000','2022-03-14 14:58:26.000'),('4fa51169-865e-4214-93fb-b93ba08fd9d3',664,'73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9','Model with Holes',5,'FREE','',0,'2021-05-03 20:00:17.000',NULL,'2021-05-04 02:10:02.000','2021-05-03 21:04:47.000','2022-03-14 13:59:02.000','2022-03-14 14:59:02.000'),('51374b44-d221-416c-8eb3-cf931ed89632',664,'6d99007d-a6df-43ae-87db-c160f6e66c0d','Crown Implant #30',1,'FREE','',0,'2022-06-22 15:25:13.000',NULL,'2022-10-19 19:32:24.000','2022-06-22 20:41:24.000','2022-10-19 23:32:24.000','2022-10-19 19:32:24.000'),('52ae5c92-f8a5-11ed-807f-58a023cda0dc',664,'dfe1127e-d366-48f3-8672-183d37f8181f','Case Other',4,'WORKFLOW_1','',0,'2023-05-22 09:34:05.000','2023-05-22 09:35:57.000','2023-05-22 09:35:50.000','2023-05-22 09:34:05.000','2024-10-31 14:02:22.472','2024-10-31 10:02:22.472'),('551dd857-1278-4318-8547-662cc20c3741',664,'2716836a-c818-4c38-90b6-b63ccb3a95ab','Implants Max and Mand',1,'FREE','',0,'2022-04-11 16:01:17.000',NULL,'2022-08-22 15:10:39.000','2022-04-14 15:19:53.000','2022-08-22 19:10:42.000','2022-08-22 15:10:42.000'),('5b122c87-c24b-4f13-9df8-3025089e3bc1',664,'4b4f3002-bba6-481f-a9fb-41ab2fedd61c','Anterior maxilla',2,'FREE','',0,'2021-03-02 17:03:07.000',NULL,'2021-10-05 02:51:00.000','2021-02-03 19:38:56.000','2022-03-14 13:58:48.000','2022-03-14 14:58:48.000'),('610634a3-6f25-4ce3-9363-ad383ec68df4',664,'e4dda259-b05b-4f33-92ac-ee4067d7dfa2','Maxilla Full Teeth',2,'FREE','',0,'2021-03-02 17:03:07.000',NULL,'2022-11-02 16:14:16.000','2022-11-02 16:16:26.000','2022-11-02 20:16:27.000','2022-11-02 16:16:27.000'),('6834852b-fe98-4445-9c5d-2b6bf3991183',664,'99b65fa1-1638-4d2a-8836-8f2697b96143','Anterior Maxilla',1,'FREE','',0,'2022-05-25 15:18:04.000',NULL,'2022-05-26 21:48:37.000','2022-05-26 22:11:06.000','2022-05-27 02:11:06.000','2022-05-26 22:11:06.000'),('6d34b8c0-a10f-4619-9c44-b0e54fef5053',664,'a4179770-0834-4466-a722-b14a0da36c73','',1,'FREE','',0,'2022-08-03 15:28:42.000','2022-08-03 15:28:45.000','2022-08-03 15:28:42.000','2022-08-03 15:28:45.000','2022-08-03 19:28:45.000',NULL),('6fc7c9c9-3191-4169-b15f-edf43fc51336',664,'d971e033-4a5c-4bd9-aab3-6238778f9eee','test',1,'FREE','',0,'2022-09-14 17:49:44.000',NULL,'2022-09-21 18:15:27.000','2022-09-21 18:22:57.000','2022-09-21 22:22:57.000','2022-09-21 18:22:57.000'),('705960fa-3ed4-4013-9cde-20022721d122',664,'73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9','Fulll Maxillary Arch',8,'FREE','',0,'2022-03-30 10:39:11.000',NULL,'2023-10-18 09:32:49.000','2022-03-30 17:18:21.000','2024-10-31 14:02:22.551','2024-10-31 10:02:22.551'),('721d0cdd-6536-11ef-b382-58a023cda0dc',664,'509319d0-6cf3-4073-92e1-ff9307be4376','Surgical Guide Ant Max',2,'FREE','',0,'2024-08-28 08:09:58.000',NULL,'2024-08-28 09:25:31.000','2024-08-28 09:25:31.000','2024-10-31 14:02:22.635','2024-10-31 10:02:22.635'),('765f3df2-2bc5-4851-8d74-c8af7e48c919',664,'ac1cc354-e34f-4afd-b66f-dadc541bcd93','Surgical Guide',1,'FREE','',0,'2021-04-28 18:03:49.000',NULL,'2021-07-23 16:36:01.000','2021-04-28 19:02:47.000','2022-03-14 13:58:51.000','2022-03-14 14:58:51.000'),('8e2d2b96-f8a4-11ed-807f-58a023cda0dc',664,'dfe1127e-d366-48f3-8672-183d37f8181f','Case Other',2,'WORKFLOW_1','',0,'2023-05-22 09:28:36.000','2023-05-22 09:30:08.000','2023-05-22 09:28:36.000','2023-05-22 09:28:36.000','2024-10-31 14:02:22.462','2024-10-31 10:02:22.462'),('8f44bea9-b7e9-45c8-a098-f3b18f9be730',664,'11ec40e4-4579-4185-9fcf-4e1aac06f554','Test Model',1,'FREE','',0,'2021-09-14 17:44:46.000',NULL,'2021-09-14 17:44:46.000','2021-09-14 18:00:52.000','2022-03-14 13:58:23.000','2022-03-14 14:58:23.000'),('955946be-5764-4c34-9e84-61682f4fdf78',664,'2716836a-c818-4c38-90b6-b63ccb3a95ab','UR/LR CRN',2,'FREE','',0,'2022-08-01 14:58:38.000',NULL,'2022-09-21 17:54:11.000','2022-08-22 15:34:43.000','2022-09-21 21:54:13.000','2022-09-21 17:54:13.000'),('96711d60-288c-439f-b464-597833d56519',664,'b2146fed-f67d-47a9-b610-c63d840d0a2d','Redo Mandible ',3,'FREE','',0,'2022-03-14 14:58:21.000',NULL,'2022-08-22 14:55:38.000','2022-08-22 14:56:54.000','2022-08-22 18:56:54.000','2022-08-22 14:56:54.000'),('a02a4d9f-ff1d-46db-95e8-7c2405b0b014',664,'9af78b83-8d91-4dc6-9499-3b8f6672cee3','Full Mouth',1,'FREE','',0,'2022-03-21 14:28:22.000',NULL,'2022-08-22 15:12:14.000','2021-09-13 21:31:32.000','2022-08-22 19:12:15.000','2022-08-22 15:12:15.000'),('a1538422-f8a5-11ed-807f-58a023cda0dc',664,'dfe1127e-d366-48f3-8672-183d37f8181f','Case Other',5,'WORKFLOW_1','',0,'2023-05-22 09:36:17.000',NULL,'2023-05-24 12:04:20.000','2023-05-22 09:36:17.000','2024-10-31 14:02:22.492','2024-10-31 10:02:22.492'),('a5ab0033-96ef-11ef-8234-58a023cda0dc',664,'bd9e7343-96c5-11ef-8234-58a023cda0dc','Case Diagnostic Wax up',1,'WORKFLOW_1','',0,'2024-10-30 14:49:09.257','2024-10-31 08:15:05.372','2024-10-31 08:14:57.576','2024-10-31 08:15:05.373','2024-10-31 12:15:05.374','2024-10-31 08:15:05.384'),('a72c11a4-05dc-4421-b252-fbfcecd2559e',664,'b2146fed-f67d-47a9-b610-c63d840d0a2d','Mandibular Right Molar 30',1,'FREE','',0,'2021-03-02 17:03:07.000',NULL,'2022-08-22 15:01:43.000','2022-08-22 15:01:56.000','2022-08-22 19:01:57.000','2022-08-22 15:01:57.000'),('acaef63e-48f8-4a62-9c7d-a3b85544301c',664,'2217798a-4832-4e0d-9259-f8a836365b51','Anterior Maxilla',1,'FREE','',0,'2021-03-02 17:03:07.000',NULL,'2020-06-11 21:44:26.000','2020-06-11 22:36:13.000','2022-03-14 13:58:54.000','2022-03-14 14:58:54.000'),('aea5d10f-977f-11ef-8187-58a023cda0dc',664,'aea25e6c-977f-11ef-8187-58a023cda0dc','Direct scan',1,'FREE','',1,'2024-10-31 08:00:11.851',NULL,NULL,'2024-10-31 08:00:11.853','2024-10-31 12:00:11.854',NULL),('b0c93ebd-1b07-4055-b4b0-aef8eccb977c',664,'872e90e0-190f-43c9-ac34-11936953fc74','Final Impressions',3,'FREE','',0,'2022-04-27 16:32:56.000',NULL,'2022-04-27 16:32:56.000','2022-04-27 16:32:56.000','2022-04-27 20:32:59.000','2022-04-27 16:32:59.000'),('b10403e9-f167-4100-b033-33c3c7fc7348',664,'73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9','Emergency',1,'FREE','',0,'2021-03-02 17:03:07.000','2023-10-18 09:21:26.052','2023-10-18 09:21:10.383','2023-10-18 09:21:26.053','2023-10-18 13:21:26.054','2023-10-18 09:21:26.064'),('b25ea321-53b4-414b-b4c4-e5adcac56ba8',664,'872e90e0-190f-43c9-ac34-11936953fc74','Max premolar',1,'FREE','',0,'2021-10-04 18:11:39.000',NULL,'2021-10-05 03:06:26.000','2021-10-05 03:11:34.000','2022-03-14 13:59:08.000','2022-03-14 14:59:08.000'),('b5dae369-a773-4095-aa54-7c8b75c939d8',664,'73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9','Maxillary Model',3,'FREE','',0,'2021-04-28 16:55:41.000',NULL,'2021-04-28 16:55:41.000','2021-04-28 17:12:17.000','2022-03-14 13:59:01.000','2022-03-14 14:59:01.000'),('b63ca765-4d68-4cf4-9707-4ad3a19f3236',664,'e33159c9-a713-4a37-ba98-9ec2e2e213e7','Impression ',1,'FREE','',0,'2022-11-14 17:09:34.000',NULL,'2022-11-14 18:05:01.000','2022-11-14 18:22:53.000','2022-11-14 23:22:53.000','2022-11-14 18:22:53.000'),('b6c36b1b-7784-4541-99a4-cc8d71760e48',664,'eddc3fb0-fe28-4640-9139-29e088374f38','Mandibular Partial Edent',1,'FREE','',0,'2021-03-02 17:03:07.000',NULL,'2021-07-23 16:37:56.000','2020-04-18 19:49:00.000','2022-03-14 13:58:41.000','2022-03-14 14:58:41.000'),('b75ed43d-6542-11ef-b382-58a023cda0dc',664,'509319d0-6cf3-4073-92e1-ff9307be4376','Case Ant Maxillary Surg Guide',3,'FREE','',0,'2024-08-28 09:37:49.046',NULL,'2024-08-28 09:37:49.132','2024-08-28 09:37:49.048','2024-08-28 13:37:49.132','2024-08-28 09:37:49.140'),('b94f8b6c-374d-4530-ac06-f527c0d26f61',664,'f9a5624b-304e-40b4-8a76-72a05c95332f','',1,'FREE','',0,'2022-07-18 16:33:34.000','2022-07-18 16:33:39.000','2022-07-18 16:33:34.000','2022-07-18 16:33:39.000','2022-07-18 20:33:39.000',NULL),('babd9189-73c6-4ebf-95c9-fc1de28820bf',664,'f67a1372-95d6-445a-856a-13c1610ee937','Mandibular Implant 31',1,'FREE','',0,'2021-03-02 17:03:07.000',NULL,'2022-08-22 14:53:10.000','2022-08-22 14:51:32.000','2022-08-22 18:53:12.000','2022-08-22 14:53:12.000'),('bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6',664,'635617fc-289b-470c-a4d4-678d7b5f275a','Impl Crown #3',1,'FREE','',0,'2022-09-07 16:09:00.000',NULL,'2022-11-28 16:21:39.000','2022-11-22 18:50:04.000','2022-11-28 21:21:51.000','2022-11-28 16:21:51.000'),('bf1582a4-9837-11ee-86e7-58a023cda0dc',664,'b4c6341b-9837-11ee-86e7-58a023cda0dc','Maxillar Anterior #7 and #8',1,'FREE','',0,'2023-12-11 10:12:49.000',NULL,'2023-12-12 08:42:29.000','2023-12-11 11:29:12.000','2024-10-31 14:02:22.618','2024-10-31 10:02:22.618'),('bfe6249f-88b3-4a27-8f4c-5494e863352f',664,'f67a1372-95d6-445a-856a-13c1610ee937','Rochon #31',2,'FREE','',0,'2021-03-02 17:03:07.000',NULL,'2022-08-22 14:53:00.000','2020-11-30 21:21:06.000','2022-08-22 18:53:07.000','2022-08-22 14:53:07.000'),('c11463eb-0064-4e37-b9df-df61294c1285',664,'1a8d2cad-438d-45eb-a3d8-ff1f536e5592','Denture Scan',1,'FREE','',0,'2021-06-21 17:55:47.000',NULL,'2021-07-23 16:32:40.000','2021-06-21 18:16:27.000','2022-03-14 13:58:38.000','2022-03-14 14:58:38.000'),('c49716f1-987e-4111-9ab9-4541a0378bb7',664,'7eac18e5-5ed2-4ed9-8b3e-eba1c562d708','Zibone Implant 31',1,'FREE','',0,'2022-03-21 14:36:24.000',NULL,'2022-08-22 15:08:01.000','2022-08-22 15:09:22.000','2022-08-22 19:09:22.000','2022-08-22 15:09:22.000'),('c6b2dd58-ecd5-402a-9167-ae99aef2b1c9',664,'366ffa87-059a-436a-9125-8827b3a2da1a','Implants #7 and #10',1,'FREE','',0,'2021-03-02 17:03:07.000',NULL,'2022-08-22 15:12:44.000','2021-03-02 17:03:10.000','2022-08-22 19:12:46.000','2022-08-22 15:12:46.000'),('c83bd076-29da-4e22-aae9-8e83dce14029',664,'fa67c8c9-4aad-41b8-83e6-2add079bf950','Imp Crown',1,'FREE','',0,'2022-09-07 14:48:29.000',NULL,'2022-09-21 20:07:58.000','2022-09-21 19:39:26.000','2022-09-22 00:07:59.000','2022-09-21 20:07:59.000'),('c90ddf83-1e94-4d7c-a61f-3f7bed3aad41',664,'872e90e0-190f-43c9-ac34-11936953fc74','Redo Maxilla',2,'FREE','',0,'2021-10-20 18:09:09.000',NULL,'2021-10-20 18:09:09.000','2021-10-20 19:26:34.000','2022-03-14 13:59:06.000','2022-03-14 14:59:06.000'),('c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d',664,'48a38618-e853-4bf0-aa6b-4c83fb8b6f13','Crown #14',1,'FREE','',0,'2022-06-22 16:34:39.000',NULL,'2022-07-18 16:27:29.000','2022-06-22 20:45:37.000','2022-07-28 20:01:47.000','2022-07-28 16:01:47.000'),('cc413c24-b371-4a75-9cfe-451a8d54e32e',664,'36e86f3f-4468-4cf2-9505-462288cae8b1','Tooth #9',1,'FREE','',0,'2022-06-20 19:22:06.000',NULL,'2022-06-20 19:22:06.000','2022-06-20 19:39:29.000','2022-06-20 23:39:29.000','2022-06-20 19:39:29.000'),('ce26f180-fc4c-444b-bdda-56104c53d7a2',664,'d71657f7-b9e8-45b9-865f-1c4c55c62017','Model',1,'FREE','',0,'2021-06-21 18:41:38.000',NULL,'2021-10-05 03:04:15.000','2021-06-21 18:50:32.000','2022-03-14 13:58:45.000','2022-03-14 14:58:45.000'),('cf5ebf08-fa37-11ed-8f6c-58a023cda0dc',664,'dfe1127e-d366-48f3-8672-183d37f8181f','Max Mand and Occlusion',6,'WORKFLOW_1','',0,'2023-05-24 09:35:12.000',NULL,'2023-05-24 12:05:32.000','2023-05-24 12:05:26.000','2024-10-31 14:02:22.502','2024-10-31 10:02:22.502'),('d3696b3d-0728-4822-b89d-631e2ab774a4',664,'b2146fed-f67d-47a9-b610-c63d840d0a2d','LaPrince #30',2,'FREE','',0,'2021-03-02 17:03:07.000',NULL,'2022-08-22 15:00:51.000','2022-08-22 15:01:01.000','2022-08-22 19:01:01.000','2022-08-22 15:01:01.000'),('d4b83bce-9462-11ee-8fd8-58a023cda0dc',664,'ae72aa8e-9461-11ee-8fd8-58a023cda0dc','SDS Implants Mandibular',1,'FREE','',0,'2023-12-06 13:11:09.000',NULL,'2023-12-06 14:12:08.000','2023-12-06 14:12:07.000','2024-10-31 14:02:22.579','2024-10-31 10:02:22.579'),('d592e356-eafe-46a1-8e61-9a886a79e1de',664,'4b4f3002-bba6-481f-a9fb-41ab2fedd61c','Anterior Maxilla #2',4,'FREE','',0,'2022-08-24 15:59:07.000',NULL,'2022-09-14 15:15:33.000','2022-09-07 19:49:46.000','2022-09-14 19:15:34.000','2022-09-14 15:15:34.000'),('d5cfdcbd-9c8b-4eca-8c0a-c03fd3424dda',664,'10c66c7c-9e2a-4201-bc3f-ee405f9ea2a2','Mandibular Posterior Defect',1,'FREE','',0,'2021-09-28 11:02:23.000',NULL,'2023-05-22 09:23:38.000','2021-09-27 14:35:27.000','2024-10-31 14:02:22.450','2024-10-31 10:02:22.450'),('d84b9ba5-9fa3-46d3-afd2-cfddd498ec29',664,'cede029c-15bc-44c2-9c9c-fac7f8983524','Mandibular Right Teeth',1,'FREE','',0,'2022-09-12 19:46:27.000',NULL,'2022-09-21 18:00:41.000','2022-09-12 20:46:07.000','2022-09-21 22:00:42.000','2022-09-21 18:00:42.000'),('db740293-ae2a-40ae-9142-4d94ed66bcd5',664,'73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9','New model',6,'FREE','',0,'2024-10-31 10:02:22.446',NULL,'2023-10-18 09:32:10.000','2021-05-05 16:34:13.000','2024-10-31 14:02:22.538','2024-10-31 10:02:22.538'),('df905f94-03ea-4868-82d7-960568f5cab7',664,'59179996-dc1e-4b4c-b9fd-92c78aa1dde0','Testing New Camera',1,'FREE','',0,'2022-07-18 16:36:37.000',NULL,'2022-07-18 16:49:37.000','2022-07-18 16:51:00.000','2022-07-28 20:01:41.000','2022-07-28 16:01:41.000'),('e1d214d2-2b62-484c-8ede-86b3f84573d3',664,'685697a1-0d50-4a06-8b3e-729cf9750f38','Practice',1,'FREE','',0,'2022-10-17 16:43:23.000',NULL,'2022-10-17 16:43:23.000','2022-10-17 17:13:59.000','2022-10-17 21:14:00.000','2022-10-17 17:14:00.000'),('e343b867-98f4-11ee-ae49-58a023cda0dc',664,'b4c6341b-9837-11ee-86e7-58a023cda0dc','Case Maxillary Surgical Guide-Duplicate Order',5,'FREE','',0,'2023-12-12 08:46:44.000',NULL,'2023-12-12 08:46:44.000','2023-12-12 08:46:44.000','2024-10-31 14:02:22.627','2024-10-31 10:02:22.627'),('e530f0de-323f-4c29-bb17-b5bfe0da3afd',664,'ebb7ec01-03db-43d2-bf9a-bc250f69d307','Maxilla Partial Edentulous',1,'FREE','',0,'2021-03-02 17:03:07.000',NULL,'2022-11-02 16:09:26.000','2022-11-02 16:11:40.000','2022-11-02 20:11:41.000','2022-11-02 16:11:41.000'),('ecbd4537-7341-11ee-b011-58a023cda0dc',664,'46c4cd1e-7338-11ee-b011-58a023cda0dc','Maxillary Central',1,'FREE','',0,'2023-10-25 10:22:27.696',NULL,'2023-10-30 09:43:21.467','2023-10-25 11:27:29.689','2023-10-30 13:43:21.468','2023-10-30 09:43:21.483'),('edc54ca0-9842-11ee-86e7-58a023cda0dc',664,'b4c6341b-9837-11ee-86e7-58a023cda0dc','Case Surgical Guide #7 and #8',3,'WORKFLOW_1','',0,'2023-12-11 11:32:51.945','2023-12-11 11:33:48.271','2023-12-11 11:33:37.983','2023-12-11 11:33:48.271','2023-12-11 16:33:48.272','2023-12-11 11:33:48.282'),('eecd8fd5-572c-11ee-a378-58a023cda0dc',664,'ffbcef25-a535-4bb2-8b85-6107c1aaa2ed','Mandibular Hybrid',2,'FREE','',0,'2023-09-19 16:41:39.000',NULL,'2023-09-25 13:36:57.000','2023-09-25 13:28:48.000','2024-10-31 14:02:22.522','2024-10-31 10:02:22.522'),('ef2b4fcf-f21c-418d-942a-c99ea96efbdb',664,'73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9','Twinguide Case Maxilla',2,'FREE','',0,'2021-04-21 14:54:16.000',NULL,'2023-10-18 09:31:59.158','2021-04-21 16:32:10.000','2023-10-18 13:31:59.158','2023-10-18 09:31:59.174'),('f09c328f-1a8b-4f63-8998-2f9b57cd3c76',664,'e648cc66-9340-456c-a379-50836d1b8a5b','Full Mouth Reconstruction',1,'FREE','',0,'2021-03-02 17:03:07.000',NULL,'2022-06-27 22:13:17.000','2021-01-21 18:30:41.000','2022-06-28 02:13:20.000','2022-06-27 22:13:20.000'),('f9cb9561-eacc-4b43-976b-dfa67a953a80',664,'17cc8b8c-6280-4e69-ad1e-731bdd9819e0','Ti Mesh Bone Graft',1,'FREE','',0,'2021-04-09 15:58:49.000',NULL,'2021-10-05 03:02:33.000','2021-10-05 03:03:47.000','2022-03-14 13:58:36.000','2022-03-14 14:58:36.000'),('fc32fcc1-f66c-42d5-93d9-1379911add0c',664,'eb3fb44e-7c5f-4ae3-a907-fdcec841501c','Implant Crn(Carol Burroughts)',1,'FREE','',0,'2022-10-31 11:39:49.000',NULL,'2023-05-22 09:37:50.000','2022-11-22 20:01:41.000','2024-10-31 14:02:22.482','2024-10-31 10:02:22.482'),('fdecd470-8623-4e7b-a2d5-227244ecd307',2,'3444c8f6-a93a-4fcf-85dd-517adb35a1ea','',1,'FREE','',0,'2022-02-28 13:59:36.000',NULL,'2022-02-28 13:59:36.000','2022-02-28 13:59:36.000','2022-02-28 12:59:38.000','2022-02-28 13:59:38.000');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `uuid` varchar(36) NOT NULL,
  `line0` varchar(255) DEFAULT NULL,
  `line1` varchar(255) DEFAULT NULL,
  `line2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(255) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('00000001-0000-0000-0000-000000000001','Labege','','',NULL,'Labege','','31670','France','2022-04-01 13:43:36.000',NULL),('00000002-0000-0000-0000-000000000001','137 rue garance','','',NULL,'LABEGE','','31670','France','2022-03-31 23:40:19.000','2024-10-31 10:02:38.995'),('00000002-0000-0000-0000-000000000002','','','',NULL,'','','','','2022-04-01 13:43:36.000',NULL),('00000003-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labège','','31670','France','2022-04-01 13:43:36.000',NULL),('00000005-0000-0000-0000-000000000001','','','',NULL,'HOENHEIM','','','France','2022-03-31 23:40:19.000','2024-08-29 10:22:31.527'),('00000006-0000-0000-0000-000000000001','','','',NULL,'Marseille','','','France','2022-03-31 23:40:19.000',NULL),('00000007-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France','2022-03-31 23:40:19.000',NULL),('00000008-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France','2022-03-31 23:40:19.000',NULL),('00000009-0000-0000-0000-000000000001','','','',NULL,'Villiers Sur Marne','','','France','2022-03-31 23:40:19.000',NULL),('00000028-0000-0000-0000-000000000001','','','',NULL,'lyon','','','France','2022-04-01 13:43:36.000',NULL),('00000033-0000-0000-0000-000000000001','','','',NULL,'','','','','2022-04-01 13:43:36.000',NULL),('00000059-0000-0000-0000-000000000001','','','',NULL,'LE TEIL','','','France','2022-04-01 13:43:36.000',NULL),('00000155-0000-0000-0000-000000000001','','','',NULL,'ECOUFLANT','','','France','2022-04-01 13:43:36.000',NULL),('00000172-0000-0000-0000-000000000001','4 Chemin Couralis','','',NULL,'LAROIN','','64110','France','2022-04-01 13:43:36.000',NULL),('00000177-0000-0000-0000-000000000001','AVDA. JUAN CARAMUEL,1','','',NULL,'LEGANES','','28916','España','2022-04-01 13:43:36.000',NULL),('00000193-0000-0000-0000-000000000001','','','',NULL,'VIRIAT ','','','France','2022-04-01 13:43:36.000',NULL),('00000224-0000-0000-0000-000000000001','','','',NULL,'CUGNAUX','','','France','2022-04-01 13:43:36.000',NULL),('00000317-0000-0000-0000-000000000001','','','',NULL,'LONGWY','','','France','2022-04-01 13:43:36.000',NULL),('00000339-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France','2022-04-01 13:43:36.000',NULL),('00000355-0000-0000-0000-000000000001','','','',NULL,'Parma','','','Italia','2022-04-01 13:43:36.000',NULL),('00000375-0000-0000-0000-000000000001','95, Avenue de la Marne','','',NULL,'Epinay sur Seine','','93800','France','2022-04-01 13:43:36.000',NULL),('00000377-0000-0000-0000-000000000001','51 rue moncey','','',NULL,'LYON','','69003','France','2022-04-01 13:43:36.000',NULL),('00000421-0000-0000-0000-000000000001','','','',NULL,'PARIS 17','','','France','2022-04-01 13:43:36.000',NULL),('00000568-0000-0000-0000-000000000001','','','',NULL,'Tlse','','','France','2022-04-01 13:43:36.000',NULL),('00000652-0000-0000-0000-000000000001','','','',NULL,'','','','','2022-04-01 13:43:36.000',NULL),('00000664-0000-0000-0000-000000000001','801 Wayne Avenue, Suite G200','','',NULL,'Silver Spring','','20910','United States','2022-03-31 23:40:19.000',NULL),('00000681-0000-0000-0000-000000000001','','','',NULL,'Chamalières ','','','France','2022-04-01 13:43:36.000',NULL),('00000689-0000-0000-0000-000000000001','','','',NULL,'CHAMBERY','','','France','2022-03-31 23:40:19.000','2024-08-28 10:04:51.486'),('00000787-0000-0000-0000-000000000001','','','',NULL,'Jacksonville','','','United States','2022-03-31 23:40:19.000',NULL),('00000788-0000-0000-0000-000000000001','','','',NULL,'Tampa','','','United States','2022-03-31 23:40:19.000',NULL),('00000805-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labege','','31670','France','2022-04-01 13:43:36.000',NULL),('00000838-0000-0000-0000-000000000001','','','',NULL,'','','','','2022-04-01 13:43:36.000',NULL),('00000840-0000-0000-0000-000000000001','','','',NULL,'','','','','2022-04-01 13:43:36.000',NULL),('00000850-0000-0000-0000-000000000001','52 RUE DU BOURNO','','',NULL,'BOEGE','','74420','France','2022-04-01 13:43:36.000',NULL),('00000899-0000-0000-0000-000000000001','VIA E.TAZZOLI','','',NULL,'CASERTA','','81100','Italia','2022-04-01 13:43:36.000',NULL),('00000916-0000-0000-0000-000000000001','','','',NULL,'','','','','2022-04-01 13:43:36.000',NULL),('00000917-0000-0000-0000-000000000001','','','',NULL,'','','','','2022-04-01 13:43:36.000',NULL),('00000918-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France','2022-04-01 13:43:36.000',NULL),('00000941-0000-0000-0000-000000000001','','','',NULL,'','','','','2022-04-01 13:43:36.000',NULL),('00001032-0000-0000-0000-000000000001','','','',NULL,'Gaithersburg','','','','2022-09-21 22:13:41.000','2024-10-31 10:02:39.011'),('00001033-0000-0000-0000-000000000001','','','',NULL,'Dulles','','','United States','2022-03-31 23:40:19.000','2023-09-25 13:26:58.058'),('18d48506-dfa1-46eb-b70d-83da71547ade','','','',NULL,'TAMPA','','','','2022-11-02 20:04:06.000',NULL),('34083901-2d3f-4d24-a689-cb451104f44b','','','','','Las Vegas','','','','2023-09-25 17:23:17.541','2024-10-31 10:02:38.972'),('361a9480-58ae-4114-bf9d-61f59181a5c8','','','','','','','','','2024-08-28 15:20:19.538','2024-08-28 11:20:57.794'),('4f878a64-f50a-4014-b427-31c8244e096d','','','',NULL,'COLUMBIA','','','','2022-05-25 23:54:28.000',NULL),('6d37a68e-32f5-4902-aa27-37b25557a9a1','','','','','Matthews','','','','2024-08-29 14:12:16.111','2024-10-31 10:02:39.040'),('a04e717a-c195-47a4-b784-92d7430c35df','','','','','','','','','2024-08-29 14:02:02.035','2024-10-31 10:02:39.027'),('b6ad31a0-192f-4d88-bad8-7a9ee485d0ac','','','',NULL,'','','','','2022-05-26 00:05:28.000',NULL),('cd6b8123-ac5f-47cb-8dfd-035610ced7e1','','','',NULL,'Bellerose ','','','','2022-06-22 23:30:30.000','2023-09-25 13:33:13.408'),('d8e8f33a-8624-43a8-9846-67724036be4e','','','',NULL,'Matthews','','','','2022-05-27 00:31:53.000',NULL),('e1bedf90-0f9c-481a-af97-1f418d6350d1','','','',NULL,'','','','','2022-06-23 00:39:43.000',NULL),('f8a74fd1-a596-4b92-823a-ccfa8f1b1922','','','',NULL,'','','','','2022-11-02 19:44:42.000',NULL);
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `credentialsId` (`credentialsId`),
  KEY `personInfoId` (`personInfoId`),
  KEY `phoneInfoId` (`phoneInfoId`),
  KEY `addressInfoId` (`addressInfoId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Assistant_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_2` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_3` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_4` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_5` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_6` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
INSERT INTO `Assistant` VALUES ('09231625-6551-11ef-89ff-58a023cda0dc',664,'73c6f8d1-da6d-4a89-976c-ab63b9216f68','3ae7142e-bb51-4c7c-b830-af6c73039fbb','1fe433e6-d926-4f66-98ae-2a7f1404ac1f','361a9480-58ae-4114-bf9d-61f59181a5c8','59496d67-82f7-4828-86cd-392d0852da35','READ_ONLY','READ_ONLY','READ_ONLY','RrbKnXK9','2024-08-28 11:20:57.777','2024-08-28 11:20:57.777','2024-08-28 15:20:57.777','2024-08-28 11:20:57.794'),('bcac8cde-de3b-48b3-b7a6-168887b95185',664,'6f52033d-f241-414d-b3b3-90268ba4059b','2181cf33-b54f-4edd-a9c6-435d7178d7cc','34dbcc6e-4ea9-407a-ab49-4c0b11ed9034','b6ad31a0-192f-4d88-bad8-7a9ee485d0ac','59496d67-82f7-4828-86cd-392d0852da35','READ_WRITE','READ_WRITE','READ_WRITE','kwKg4dQ8','2023-02-20 18:02:16.000','2022-05-25 20:05:28.000','2023-02-20 23:02:16.000','2023-02-20 18:02:16.000'),('f89574d0-a4d6-47da-bf72-2c4663e408f0',2,NULL,'00000002-0000-0000-0000-000000000002','00000002-0000-0000-0000-000000000002','00000002-0000-0000-0000-000000000002','f841d3b8-276b-4ad1-859c-ba7e25ffe059','READ_WRITE','READ_ONLY','NOTHING','',NULL,'2020-12-09 19:29:03.000','2022-04-01 13:43:38.000','2020-12-09 19:29:03.000');
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_CIRCLE_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `CircleOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CircleOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `CircleOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `CircleOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Config` (
  `id` mediumint unsigned NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `fullRetrieve` tinyint(1) DEFAULT '0',
  `syncEnabled` tinyint(1) DEFAULT '1',
  `showOcclusionScan` tinyint(1) DEFAULT '1',
  `showOpenStlWarning` tinyint(1) DEFAULT '1',
  `showMarginLinesWarning` tinyint(1) DEFAULT '1',
  `showDeleteConfirmation` tinyint(1) DEFAULT '1',
  `showSyncInfo` tinyint(1) DEFAULT '1',
  `downloadAtFullRetrieve` tinyint(1) DEFAULT '1',
  `lagSound` tinyint(1) DEFAULT '0',
  `lostSound` tinyint(1) DEFAULT '0',
  `emailNotifications` tinyint(1) DEFAULT '1',
  `logout` mediumint DEFAULT '10',
  `language` varchar(2) DEFAULT NULL,
  `diagnosticMode` tinyint(1) DEFAULT '0',
  `repairMode` tinyint(1) DEFAULT '0',
  `flipMaxillaryH` tinyint(1) DEFAULT '0',
  `flipMaxillaryV` tinyint(1) DEFAULT '0',
  `flipMandibleH` tinyint(1) DEFAULT '0',
  `flipMandibleV` tinyint(1) DEFAULT '0',
  `showFlipPopupMaxillary` tinyint(1) DEFAULT '1',
  `showFlipPopupMandible` tinyint(1) DEFAULT '1',
  `enableUserSharing` tinyint(1) DEFAULT '0',
  `lostTrackingRectangle` tinyint(1) DEFAULT '1',
  `showAllPatients` tinyint(1) DEFAULT '0',
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2022-02-01 19:05:29.000','2022-02-01 19:05:30.000','2022-02-01 18:05:30.000'),(1,2,0,1,1,1,1,1,1,1,0,0,1,999,'FR',0,0,0,0,0,0,1,1,0,1,1,'2023-03-15 09:18:48.000','2024-10-31 10:02:38.995','2023-09-19 20:34:38.749'),(1,3,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2021-12-10 14:54:16.000','2021-12-10 14:54:16.000','2021-12-10 13:54:16.000'),(1,5,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-02 11:04:44.000','2024-08-29 10:22:31.527','2019-12-16 03:02:47.000'),(1,6,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-02 11:05:21.000','2019-12-15 22:02:47.000','2019-12-16 03:02:47.000'),(1,7,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-02 11:06:14.000','2019-12-15 22:02:47.000','2019-12-16 03:02:47.000'),(1,8,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-02 11:06:33.000','2019-12-15 22:02:47.000','2019-12-16 03:02:47.000'),(1,9,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-02 11:07:02.000','2019-12-15 22:02:47.000','2019-12-16 03:02:47.000'),(1,28,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-15 10:57:02.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,33,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-15 14:34:40.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,59,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-17 14:12:08.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,155,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-31 12:21:56.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,172,0,1,1,1,1,1,1,1,0,0,1,999,'fr',0,0,0,0,0,0,1,1,0,1,0,'2020-06-03 18:59:46.000','2020-06-03 19:03:54.000','2020-06-03 17:03:54.000'),(1,177,0,1,1,1,1,1,1,1,0,0,1,990,'fr',0,0,0,0,0,0,1,1,0,1,0,'2021-03-05 17:04:59.000','2021-03-05 17:04:59.000','2021-03-05 16:04:59.000'),(1,193,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-09-02 18:53:02.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,224,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-09-09 15:29:44.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,317,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-10-07 14:44:35.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,339,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-10-11 20:04:31.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,355,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-10-19 13:58:38.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,375,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2020-01-02 14:50:31.000','2020-01-02 14:50:32.000','2020-01-02 13:50:32.000'),(1,377,0,1,1,1,1,1,1,1,0,1,1,999,'fr',0,0,0,0,0,0,1,1,0,1,0,'2020-01-17 09:59:06.000','2020-01-17 09:59:06.000','2020-01-17 08:59:06.000'),(1,421,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-11-25 11:28:35.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,568,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2020-02-04 15:19:02.000','2020-02-04 15:19:02.000','2020-02-04 14:19:02.000'),(1,652,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2020-03-12 14:49:16.000','2020-03-12 14:49:16.000','2020-03-12 13:49:16.000'),(1,664,1,1,1,1,1,1,1,0,0,1,1,60,'US',0,0,0,0,0,0,1,1,0,1,1,'2022-06-22 17:47:58.000','2024-10-30 14:52:27.199','2024-10-30 18:52:27.188'),(1,681,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2020-05-29 09:10:28.000','2020-05-29 09:10:28.000','2020-05-29 07:10:28.000'),(1,689,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2020-06-02 12:32:01.000','2024-08-28 10:04:51.486','2020-06-02 16:32:01.000'),(1,787,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2020-11-03 15:01:23.000','2020-11-03 15:01:23.000','2020-11-03 20:01:23.000'),(1,788,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2020-11-03 21:14:48.000','2020-11-03 21:14:48.000','2020-11-04 02:14:48.000'),(1,805,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2020-12-09 11:04:54.000','2020-12-09 11:04:54.000','2020-12-09 10:04:54.000'),(1,838,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2021-01-22 14:37:07.000','2021-01-22 14:37:07.000','2021-01-22 13:37:07.000'),(1,840,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2021-01-22 16:28:38.000','2021-01-22 16:28:38.000','2021-01-22 15:28:38.000'),(1,850,0,1,1,1,1,1,1,1,0,0,1,999,'fr',0,0,0,0,0,0,1,1,0,1,0,'2022-02-16 14:06:28.000','2022-02-16 14:06:29.000','2022-02-16 13:06:29.000'),(1,899,0,1,1,1,1,1,1,1,0,0,1,15,'fr',0,0,0,0,0,0,1,1,0,1,0,'2022-02-01 14:03:04.000','2022-02-01 14:03:05.000','2022-02-01 13:03:05.000'),(1,916,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2021-04-28 14:05:53.000','2021-04-28 14:05:53.000','2021-04-28 12:05:53.000'),(1,917,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2021-04-28 14:53:31.000','2021-04-28 14:53:31.000','2021-04-28 12:53:31.000'),(1,918,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2021-04-29 16:03:23.000','2021-04-29 16:03:23.000','2021-04-29 14:03:23.000'),(1,941,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2021-06-07 14:52:03.000','2021-06-07 14:52:03.000','2021-06-07 12:52:03.000'),(1,1032,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2022-03-21 15:58:37.000','2024-10-31 10:02:39.011','2022-03-21 19:58:37.000'),(1,1033,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2022-03-21 18:57:02.000','2023-09-25 13:26:58.058','2022-03-21 22:57:02.000'),(1,1050,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2022-05-25 19:45:56.000','2022-05-25 19:45:56.000','2022-05-25 23:45:56.000'),(1,1051,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2022-05-26 20:28:20.000','2022-05-26 20:28:20.000','2022-05-27 00:28:20.000'),(1,1056,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2022-06-22 17:28:57.000','2023-09-25 13:33:13.408','2022-06-22 21:28:57.000'),(1,1057,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2022-06-22 20:39:43.000','2022-06-22 20:39:43.000','2022-06-23 00:39:43.000'),(1,1101,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2022-11-02 15:44:42.000','2022-11-02 15:44:42.000','2022-11-02 19:44:42.000'),(1,1102,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2022-11-02 15:55:41.000','2022-11-02 15:55:41.000','2022-11-02 19:55:41.000'),(1,1166,0,1,1,1,1,1,1,1,0,0,1,10,'FR',0,0,0,0,0,0,1,1,0,1,0,'2023-09-25 13:19:51.000','2024-10-31 10:02:38.972','2023-09-25 17:19:51.526'),(1,1210,0,1,1,1,1,1,1,1,0,0,1,10,'FR',0,0,0,0,0,0,1,1,0,1,0,'2024-08-28 09:58:48.000','2024-10-31 10:02:39.040','2024-08-28 13:58:49.190'),(1,1211,0,1,1,1,1,1,1,1,0,0,1,10,'FR',0,0,0,0,0,0,1,1,0,1,0,'2024-08-29 10:02:00.000','2024-10-31 10:02:39.027','2024-08-29 14:02:02.035');
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Contact` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `professionalId` mediumint unsigned NOT NULL COMMENT 'Le professionnel contact',
  `officeId` varchar(36) DEFAULT NULL,
  `status` enum('INVITATIONSENT','INVITATIONRECEIVED','ACCEPTED','REJECTED') NOT NULL DEFAULT 'INVITATIONSENT',
  `comments` text,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `uniqueContactPro` (`ownerId`,`professionalId`),
  KEY `professionalId` (`professionalId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Contact_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_2` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES ('09445c09-6813-4c02-a2d8-597e200f19d6',2,918,NULL,'REJECTED','',NULL,'2021-04-29 16:19:15.000','2021-04-30 10:00:26.000','2021-04-30 12:00:26.000'),('0e0b1351-781a-475e-981a-4c061dcc3f54',664,1057,NULL,'REJECTED','',NULL,'2022-09-21 18:10:04.000','2022-09-21 22:10:04.000','2022-09-21 18:10:04.000'),('13b7bc85-543d-4b72-98de-8a1c59d6d91b',2,177,NULL,'REJECTED','',NULL,'2021-09-22 10:20:35.000','2021-11-12 13:01:56.000','2021-11-12 14:01:56.000'),('1418b81b-952d-4c95-a6be-d74e9dce3146',2,5,NULL,'ACCEPTED','',NULL,'2019-07-08 15:47:14.000','2021-04-21 12:26:48.000','2021-04-21 14:26:48.000'),('18c49cef-2ff6-4b6f-97d0-924a701fd009',664,6,NULL,'REJECTED','',NULL,'2022-05-25 19:38:25.000','2022-05-25 23:38:25.000','2022-05-25 19:38:25.000'),('1e3e6e1b-ec29-44ee-a407-1526d6e66955',664,664,NULL,'ACCEPTED','',NULL,'2020-04-09 01:29:01.000','2023-03-01 03:36:06.000','2023-02-28 22:36:06.000'),('1fb6381c-3eb3-4354-b9f4-2560f4cf10a3',664,787,NULL,'ACCEPTED','',NULL,'2020-11-03 17:32:58.000','2020-11-03 22:33:44.000','2020-11-03 17:33:44.000'),('237d0137-20bd-4cf7-8fc7-a730386e706e',664,5,NULL,'REJECTED','',NULL,'2024-08-29 10:22:31.507','2024-08-29 14:22:31.510','2024-08-29 10:22:31.527'),('24f6b3ed-92f7-4ac3-90af-eca51269434c',2,838,NULL,'REJECTED','',NULL,'2021-04-29 16:19:16.000','2021-04-29 14:19:16.000','2021-04-29 16:19:16.000'),('27738253-c98b-484b-bef6-ccf9ca5966b5',664,9,NULL,'REJECTED','',NULL,'2022-05-25 19:38:33.000','2022-05-25 23:38:33.000','2022-05-25 19:38:33.000'),('28f7e34e-d2d9-411c-8ab3-d5ade71bf7cf',2,6,NULL,'ACCEPTED','',NULL,'2019-07-08 15:47:14.000','2019-07-26 04:43:50.000','2019-07-26 06:43:50.000'),('2e81aef5-1f9f-4961-ac42-12a07a248174',2,899,NULL,'INVITATIONSENT','',NULL,'2021-10-12 14:15:29.000','2022-02-25 19:16:38.000','2022-02-25 20:16:38.000'),('31ecedea-a5d4-4c31-91a1-431f8ab24ce7',2,7,NULL,'ACCEPTED','',NULL,'2019-07-10 08:55:28.000','2019-07-22 15:07:13.000','2019-07-22 17:07:13.000'),('3f1e8647-e9a2-47dd-912c-d07a3ec2395e',2,689,NULL,'ACCEPTED','',NULL,'2020-11-03 11:22:16.000','2020-11-03 10:22:16.000','2020-11-03 11:22:16.000'),('46be3f53-48f5-43f2-8612-6bde541a8563',2,3,NULL,'ACCEPTED','',NULL,'2019-07-03 09:49:55.000','2022-02-03 13:21:52.000','2022-02-03 14:21:52.000'),('584dad71-0252-4c8a-a9b4-bc17eae4eb58',664,788,NULL,'ACCEPTED','',NULL,'2020-11-03 22:34:48.000','2020-12-01 22:40:18.000','2020-12-01 17:40:18.000'),('58cd65c8-f596-48dc-a3e8-edf285a261d0',2,355,NULL,'ACCEPTED','',NULL,'2020-02-12 11:06:25.000','2020-07-10 08:30:44.000','2020-07-10 10:30:44.000'),('5a6cbc1d-3301-430e-a148-dacf698e04c1',2,917,NULL,'REJECTED','',NULL,'2021-04-29 16:00:34.000','2021-04-29 14:00:34.000','2021-04-29 16:00:34.000'),('6da705c7-2e8e-476b-af63-a98ce37120b7',664,1166,NULL,'ACCEPTED','',NULL,'2023-09-25 13:31:22.000','2023-09-25 17:31:23.598','2023-09-25 13:31:23.598'),('7072c8ee-9f1e-4c66-b352-fdcadde0179f',2,681,NULL,'INVITATIONSENT','',NULL,'2021-01-22 14:02:31.000','2021-01-22 13:02:32.000','2021-01-22 14:02:32.000'),('70dd62c9-f43b-4878-a303-d6ef02077da6',2,28,NULL,'ACCEPTED','',NULL,'2021-03-18 16:09:12.000','2021-07-19 18:03:49.000','2021-07-19 20:03:49.000'),('781d7d07-d47a-46d9-8826-8262a2853b2b',664,1211,NULL,'REJECTED','',NULL,'2024-08-29 10:09:38.378','2024-08-29 14:09:38.381','2024-08-29 10:09:38.399'),('8000f305-381a-4744-b4e2-ed0a952a5071',664,8,NULL,'REJECTED','',NULL,'2022-05-25 19:38:49.000','2022-05-25 23:38:49.000','2022-05-25 19:38:49.000'),('845121ab-bd3d-460f-8459-afc674d99362',2,8,NULL,'ACCEPTED','',NULL,'2019-07-08 15:47:14.000','2019-07-22 17:36:25.000','2019-07-22 19:36:25.000'),('8cbeba91-0f78-43e6-9ac8-00c828dc7b11',2,375,NULL,'ACCEPTED','',NULL,'2020-02-04 14:48:36.000','2022-02-11 13:19:00.000','2022-02-11 14:19:00.000'),('9262c6b3-3ca9-458c-967e-e6fb690d95bb',664,1050,NULL,'ACCEPTED','',NULL,'2022-05-25 20:07:15.000','2022-05-26 00:11:37.000','2022-05-25 20:11:37.000'),('93ad4d00-b810-418e-ab4f-5f38046486cd',2,1,NULL,'ACCEPTED','',NULL,'2019-11-25 11:21:43.000','2022-02-02 14:55:31.000','2022-02-02 15:55:31.000'),('9648ff49-e522-44ba-9b8f-93895ee57d2b',2,224,NULL,'ACCEPTED','',NULL,'2019-09-09 15:53:45.000','2019-09-09 13:53:45.000','2019-09-09 15:53:45.000'),('99c73d5d-e50b-4a8e-a4b4-60fd2150b020',2,317,NULL,'ACCEPTED','',NULL,'2019-12-09 11:58:51.000','2020-06-15 13:54:53.000','2020-06-15 15:54:53.000'),('a55f3306-73a9-4861-b3fe-1b6011c849be',2,941,NULL,'REJECTED','',NULL,'2021-06-07 14:56:56.000','2021-06-07 12:56:56.000','2021-06-07 14:56:56.000'),('a6c317c0-5772-4c0a-9fa8-0cef815f4fad',2,193,NULL,'ACCEPTED','',NULL,'2019-09-30 10:43:33.000','2019-09-30 08:43:33.000','2019-09-30 10:43:33.000'),('a88f9aab-189e-4afc-9061-d199ad98f624',2,805,NULL,'INVITATIONSENT','',NULL,'2021-04-28 14:39:57.000','2021-04-28 12:39:58.000','2021-04-28 14:39:58.000'),('a9f86ae2-32af-4481-85e9-dfb308b189d9',664,1102,NULL,'ACCEPTED','',NULL,'2022-11-02 16:04:45.000','2022-11-02 20:08:49.000','2022-11-02 16:08:49.000'),('b2600e32-7030-4e6b-a270-8b2cbccee7b7',664,2,NULL,'REJECTED','',NULL,'2023-07-06 09:02:13.000','2023-10-30 12:28:46.891','2023-10-30 08:28:46.891'),('b268deab-1616-4c93-8eb0-0d9d60d5a2cf',664,1056,NULL,'REJECTED','',NULL,'2023-09-25 13:33:13.385','2023-09-25 17:33:13.389','2023-09-25 13:33:13.408'),('b26a32ea-ad6e-4f46-ae5d-f2f4a2af39ad',2,155,NULL,'ACCEPTED','',NULL,'2019-08-27 15:24:41.000','2020-07-01 08:29:24.000','2020-07-01 10:29:24.000'),('b29c282c-29a0-4337-bcae-a9998bf3da31',2,916,NULL,'REJECTED','',NULL,'2021-04-28 14:07:50.000','2021-04-28 12:07:51.000','2021-04-28 14:07:51.000'),('b2c647f7-ab7d-41cd-8380-cd98bc0bb2bb',664,7,NULL,'REJECTED','',NULL,'2022-05-25 19:38:58.000','2022-05-25 23:38:58.000','2022-05-25 19:38:58.000'),('b4ad1a45-0211-4995-8543-ad852af15ce4',2,568,NULL,'INVITATIONSENT','',NULL,'2020-02-04 15:19:02.000','2020-02-04 14:20:30.000','2020-02-04 15:20:30.000'),('b6f285f2-0b59-4029-af8d-7e012de06045',2,33,NULL,'REJECTED','',NULL,'2021-04-29 16:00:33.000','2021-04-29 14:00:33.000','2021-04-29 16:00:33.000'),('be0d2da1-7bc2-4d9b-8280-6c727d2edfb6',2,840,NULL,'REJECTED','',NULL,'2021-04-28 14:07:58.000','2021-04-28 12:07:58.000','2021-04-28 14:07:58.000'),('bfdb65e9-9fc6-43e2-b1a6-4e7ac99fe0ec',664,1210,NULL,'ACCEPTED','',NULL,'2024-08-29 10:12:34.000','2024-08-29 14:14:28.115','2024-08-29 10:14:28.115'),('c1218792-ad28-4579-b60d-ea36735880b7',2,652,NULL,'REJECTED','',NULL,'2020-03-12 14:49:30.000','2020-03-12 13:49:30.000','2020-03-12 14:49:30.000'),('c221cdda-dad2-4ee8-99ec-d3097c841b68',2,850,NULL,'INVITATIONSENT','',NULL,'2021-03-04 12:12:18.000','2022-02-28 12:59:48.000','2022-02-28 13:59:48.000'),('c4e61cbc-8053-4d5b-8aef-9a5def3229ea',664,1033,NULL,'REJECTED','',NULL,'2023-09-25 13:26:58.041','2023-09-25 17:26:58.045','2023-09-25 13:26:58.058'),('c571c887-8c1f-4576-a747-36c26c3f6338',2,172,NULL,'ACCEPTED','',NULL,'2019-12-17 15:10:34.000','2022-02-02 17:54:18.000','2022-02-02 18:54:18.000'),('c71e6dfa-2748-4040-a760-4dfddbc16018',664,689,NULL,'REJECTED','',NULL,'2024-08-28 10:04:51.463','2024-08-28 14:04:51.467','2024-08-28 10:04:51.486'),('c81b77de-6fb5-449b-8f09-78f75eedcd8c',2,377,NULL,'REJECTED','',NULL,'2020-03-12 14:51:08.000','2020-03-12 13:51:08.000','2020-03-12 14:51:08.000'),('d07578fc-3c54-49d7-a3eb-b581d2107f68',2,2,NULL,'ACCEPTED','',NULL,'2019-07-01 08:54:35.000','2022-02-28 12:54:54.000','2022-02-28 13:54:54.000'),('e54862ac-483f-4776-967b-4f90b849a4a5',664,1051,NULL,'ACCEPTED','',NULL,'2022-05-26 21:00:27.000','2022-05-27 01:33:25.000','2022-05-26 21:33:25.000'),('e72f7319-b4e1-4049-aa99-f124db5c5af8',2,9,NULL,'ACCEPTED','',NULL,'2019-07-08 15:47:14.000','2020-01-24 13:39:37.000','2020-01-24 14:39:37.000'),('ec4237a8-5baf-46b4-9e49-ab1b68950d8a',664,1032,NULL,'ACCEPTED','',NULL,'2022-09-21 12:18:12.000','2024-08-28 12:07:31.208','2024-08-28 08:07:31.208'),('f2acf4cf-f150-4f67-848e-90f8683578cf',664,1101,NULL,'REJECTED','',NULL,'2022-11-02 15:54:29.000','2022-11-02 19:54:29.000','2022-11-02 15:54:29.000'),('f4ec0f13-701b-4afa-bdc6-8759982358c2',2,339,NULL,'ACCEPTED','',NULL,'2019-10-15 10:41:49.000','2019-10-15 08:41:49.000','2019-10-15 10:41:49.000'),('f590073f-6720-4045-807a-0a3b1ea8c91d',2,421,NULL,'ACCEPTED','',NULL,'2021-05-03 11:13:01.000','2021-05-03 10:01:37.000','2021-05-03 12:01:37.000'),('fb3b468c-a371-4911-b472-a2869911ccef',2,59,NULL,'ACCEPTED','',NULL,'2019-09-05 17:20:56.000','2019-09-05 15:29:34.000','2019-09-05 17:29:34.000');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ContactNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `contactId` varchar(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('RECEIVED','RECEIVED_TO_ACCEPTED','RECEIVED_TO_REJECTED','SENT_TO_ACCEPTED','SENT_TO_REJECTED','ACTIVATION_TIMEOUT') NOT NULL DEFAULT 'RECEIVED',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `ContactNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ContactNotification_ibfk_2` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
INSERT INTO `ContactNotification` VALUES ('132e7d07-56a1-40fe-8234-6fad29c24f81',664,'b2600e32-7030-4e6b-a270-8b2cbccee7b7','Sophie MOURIGAL','RECEIVED_TO_ACCEPTED',0,'2022-11-21 16:44:35.000',NULL,'2022-11-21 21:44:54.000','2022-11-21 16:44:54.000'),('21982d8c-fd35-4d7d-bb5c-8132c465f80b',664,'6da705c7-2e8e-476b-af63-a98ce37120b7','Digital Dental Fusion Laboratory','SENT_TO_ACCEPTED',0,'2023-09-25 13:31:22.000',NULL,'2023-09-25 17:35:10.511','2023-09-25 13:35:10.528'),('31656847-a17a-40e6-8fa5-eaa98948e1b3',664,'b268deab-1616-4c93-8eb0-0d9d60d5a2cf','Porcelain Studio Finesse','SENT_TO_ACCEPTED',0,'2022-06-22 19:31:57.000',NULL,'2022-06-23 00:37:25.000','2022-06-22 20:37:25.000'),('4298c8f5-5969-4fad-a016-7cea75916cf8',664,'bfdb65e9-9fc6-43e2-b1a6-4e7ac99fe0ec','Fitzgerald Dental Studio Laboratory','SENT_TO_ACCEPTED',0,'2024-08-29 10:12:34.000',NULL,'2024-08-29 14:21:22.860','2024-08-29 10:21:22.860'),('7274ecd0-d716-40c1-9389-9cb96c403cad',664,'c4e61cbc-8053-4d5b-8aef-9a5def3229ea','Iva Taylor','SENT_TO_ACCEPTED',0,'2022-09-02 18:30:08.000',NULL,'2022-09-07 23:39:40.000','2022-09-07 19:39:40.000'),('88249384-10c3-4959-93fb-e5aa598c7e03',664,'e54862ac-483f-4776-967b-4f90b849a4a5','Drake Dental Lab Drake','SENT_TO_ACCEPTED',0,'2022-05-26 21:00:27.000',NULL,'2022-05-27 01:48:58.000','2022-05-26 21:48:58.000'),('d59efb37-8421-4b0a-8ee6-2423a2e08d07',664,'9262c6b3-3ca9-458c-967e-e6fb690d95bb','Jong Park','SENT_TO_ACCEPTED',0,'2022-05-25 20:07:15.000',NULL,'2022-05-26 00:08:41.000','2022-05-25 20:08:41.000'),('e2abb875-6c78-4da2-a5e0-35cccb7c738c',664,'c4e61cbc-8053-4d5b-8aef-9a5def3229ea','Iva Taylor','SENT_TO_ACCEPTED',0,'2022-03-24 13:28:36.000','2022-05-25 20:03:45.000','2022-05-26 00:03:45.000','2022-05-25 20:03:45.000'),('e5d1e5ca-80c9-4bc4-a81d-4e0bff1c175d',664,'a9f86ae2-32af-4481-85e9-dfb308b189d9','Richard Chun','SENT_TO_ACCEPTED',0,'2022-11-02 16:04:45.000',NULL,'2022-11-02 20:58:46.000','2022-11-02 16:58:46.000'),('f2e244a3-30f6-454f-8faa-0ede90a2e6e7',664,'ec4237a8-5baf-46b4-9e49-ab1b68950d8a','Sun Hong','SENT_TO_ACCEPTED',0,'2022-09-21 18:18:12.000',NULL,'2022-09-21 22:18:31.000','2022-09-21 18:18:31.000');
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Credentials` (
  `uuid` varchar(36) NOT NULL,
  `login` varchar(255) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES ('00000002-0000-0000-0000-000000000001','prod.sav','944f83211d57ccc35f56487a20808104fd1c61ea84a6e818659c8edc5e10aca0','2023-05-22 13:05:20.138','2024-10-31 10:02:38.995'),('00000664-0000-0000-0000-000000000001','IOSCANNING','3bae38414b92340174b50ff1040ca4d20e9b596214226c10eb9b91129491111e','2023-12-06 18:01:25.219',NULL),('6f52033d-f241-414d-b3b3-90268ba4059b','aida.eskandarian@gmail.com','4a62d280a6a8b2d6f7fa7a7e879e592fa018116730bdf99c3e17740d8e58dde2','2022-05-26 00:05:28.000',NULL),('73c6f8d1-da6d-4a89-976c-ab63b9216f68','doctor@milesofsmilesdental.net','5c9def8f53a38ad8b5fee9af59c743a9ab1af77fd5954bd6d513269f97aae338','2024-08-28 15:20:19.537','2024-08-28 11:20:57.794'),('9ebe80bc-e77e-4adc-85bb-9aaed3d6ff06','DDF',NULL,'2023-09-25 17:23:17.535','2024-10-31 10:02:38.972'),('c2d5ca27-c8e5-496b-ae45-347bdf6ffb5b','ezpassdentallab',NULL,'2024-08-28 12:07:31.174','2024-10-31 10:02:39.011'),('fe2709bd-d5d3-4b96-a246-ccae9e8d8aeb','fitzgeralddental',NULL,'2024-08-29 14:12:16.106','2024-10-31 10:02:39.040');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Discussion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `selfImplied` tinyint(1) NOT NULL DEFAULT '0',
  `officeId` varchar(36) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`,`ownerId`),
  KEY `ownerId` (`ownerId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Discussion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Discussion_ibfk_2` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
INSERT INTO `Discussion` VALUES ('27dc446a-2d59-4215-b9d1-13214c428e23',664,0,NULL,NULL,'2022-03-24 16:46:12.000','2022-10-24 23:05:33.000','2022-10-24 19:05:33.000'),('27dc446a-2d59-4215-b9d1-13214c428e23',1033,0,NULL,NULL,'2022-03-24 16:46:12.000','2022-03-24 20:46:12.000',NULL),('3b14ba2b-8361-4394-9543-c5a35bcd0fa4',9,0,NULL,NULL,'2021-03-02 17:02:56.000','2021-03-02 22:02:56.000',NULL),('3b14ba2b-8361-4394-9543-c5a35bcd0fa4',664,0,NULL,NULL,'2020-07-01 18:18:09.000','2022-07-28 20:05:42.000','2022-07-28 16:05:42.000'),('3bb3ca53-cf49-4698-9658-df729e5c5f9e',1,0,NULL,NULL,'2022-02-28 13:59:37.000','2022-02-28 12:59:37.000',NULL),('3bb3ca53-cf49-4698-9658-df729e5c5f9e',2,0,NULL,NULL,'2019-11-25 11:23:31.000','2022-01-04 17:22:05.000','2022-01-04 18:22:05.000'),('403b01b3-47c2-471d-9968-fdbfebec0f2d',664,0,NULL,NULL,'2022-06-22 20:40:55.000','2022-10-19 23:36:11.000','2022-10-19 19:36:11.000'),('403b01b3-47c2-471d-9968-fdbfebec0f2d',1056,0,NULL,NULL,'2022-06-22 20:40:55.000','2022-06-23 00:40:55.000',NULL),('521142fd-7283-4541-aa70-733ace90c112',2,0,NULL,NULL,'2019-09-04 15:44:10.000','2021-05-14 11:25:24.000','2021-05-14 13:25:24.000'),('521142fd-7283-4541-aa70-733ace90c112',3,0,NULL,NULL,'2022-02-28 13:59:37.000','2022-02-28 12:59:37.000',NULL),('546a6fcf-8fa0-4587-a55e-ebaf85780bff',664,0,NULL,NULL,'2022-11-02 16:11:40.000','2022-11-21 03:50:48.000','2022-11-20 22:50:48.000'),('546a6fcf-8fa0-4587-a55e-ebaf85780bff',1102,0,NULL,NULL,'2022-11-02 16:11:40.000','2022-11-02 20:11:40.000',NULL),('5a3ba252-0d94-4fae-b6e1-d4756a110f83',664,0,NULL,NULL,'2022-05-26 22:09:04.000','2024-08-28 14:03:07.437','2024-08-28 10:03:07.437'),('5a3ba252-0d94-4fae-b6e1-d4756a110f83',1051,0,NULL,NULL,'2022-05-26 22:09:04.000','2022-05-27 02:09:04.000',NULL),('5cde9543-ba84-400d-ae2b-8c834d912266',2,0,NULL,NULL,'2019-12-17 15:11:56.000','2021-02-12 14:21:28.000','2021-02-12 15:21:28.000'),('5cde9543-ba84-400d-ae2b-8c834d912266',172,0,NULL,NULL,'2022-02-28 13:59:37.000','2022-02-28 12:59:37.000',NULL),('6885f3a8-c779-49e9-87ed-5d4c70e2ca06',2,0,NULL,NULL,'2019-09-30 11:17:48.000','2019-09-30 15:16:23.000','2019-09-30 17:16:23.000'),('6885f3a8-c779-49e9-87ed-5d4c70e2ca06',193,0,NULL,NULL,'2022-02-28 13:59:37.000','2022-02-28 12:59:37.000',NULL),('74df8c86-9348-43cd-bbaa-383903f28a54',664,1,NULL,NULL,'2021-01-28 15:46:20.000','2021-01-28 20:46:25.000','2021-01-28 15:46:25.000'),('7d1bfe62-befb-4b9e-bbcf-714a6e3ea07c',664,0,NULL,NULL,'2020-11-03 21:02:55.000','2020-11-04 02:13:53.000','2020-11-03 21:13:53.000'),('7d1bfe62-befb-4b9e-bbcf-714a6e3ea07c',787,0,NULL,NULL,'2021-03-02 17:02:56.000','2021-03-02 22:02:56.000',NULL),('83295ac0-5bca-11ee-9658-58a023cda0dc',664,0,NULL,NULL,'2023-09-25 13:39:43.711','2024-08-28 12:07:33.128','2024-08-28 08:07:33.128'),('83295ac0-5bca-11ee-9658-58a023cda0dc',1166,0,NULL,NULL,'2023-09-25 13:39:43.711','2023-09-25 17:39:43.711',NULL),('a16198e0-da2f-45fe-97fb-93531b35cedb',2,1,NULL,NULL,'2019-07-01 17:37:26.000','2022-02-25 08:36:06.000','2022-02-25 09:36:06.000'),('a18a6dc8-e71f-45cb-a7ad-b53500079bd4',2,0,NULL,NULL,'2019-09-09 16:10:00.000','2019-09-12 14:13:26.000','2019-09-12 16:13:26.000'),('a18a6dc8-e71f-45cb-a7ad-b53500079bd4',224,0,NULL,NULL,'2022-02-28 13:59:37.000','2022-02-28 12:59:37.000',NULL),('a5afaabe-d653-407f-94cd-6fc3768631f7',2,0,NULL,NULL,'2022-11-21 16:46:13.000','2022-11-21 21:46:13.000',NULL),('a5afaabe-d653-407f-94cd-6fc3768631f7',664,0,NULL,NULL,'2022-11-21 16:46:13.000','2022-11-21 21:47:52.000','2022-11-21 16:47:52.000'),('be6e41b9-9ce8-4980-9ce7-be4b4450d1b3',2,0,NULL,NULL,'2019-09-05 17:30:24.000','2019-09-05 15:31:16.000','2019-09-05 17:31:16.000'),('be6e41b9-9ce8-4980-9ce7-be4b4450d1b3',59,0,NULL,NULL,'2022-02-28 13:59:37.000','2022-02-28 12:59:37.000',NULL),('f228ac80-a2d3-40e2-8c56-c2c78b6872ed',664,0,NULL,NULL,'2022-09-21 18:16:46.000','2022-11-02 23:06:40.000','2022-11-02 19:06:40.000'),('f228ac80-a2d3-40e2-8c56-c2c78b6872ed',1032,0,NULL,NULL,'2022-09-21 18:16:46.000','2022-09-21 22:16:46.000',NULL),('fe55386a-3ec2-4d00-bb80-02e0aec5e82f',2,0,NULL,NULL,'2019-08-27 15:25:58.000','2019-09-03 08:19:11.000','2019-09-03 10:19:11.000'),('fe55386a-3ec2-4d00-bb80-02e0aec5e82f',155,0,NULL,NULL,'2022-02-28 13:59:37.000','2022-02-28 12:59:37.000',NULL),('fe95b75b-c01b-47fa-a6c9-1d4ff7942146',664,0,NULL,NULL,'2020-11-03 22:41:34.000','2022-03-24 20:48:33.000','2022-03-24 16:48:33.000'),('fe95b75b-c01b-47fa-a6c9-1d4ff7942146',788,0,NULL,NULL,'2021-03-02 17:02:56.000','2021-03-02 22:02:56.000',NULL);
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `File`
--

DROP TABLE IF EXISTS `File`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `File` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `path` text,
  `tag` text,
  `originalName` text NOT NULL,
  `originalId` varchar(36) NOT NULL,
  `metadata` text,
  `type` enum('BIN','JSON','PDF','PLY','STL','PNG','XYZ','ZIP') NOT NULL,
  `version` mediumint unsigned DEFAULT '0',
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT 'CREATED',
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `version` (`originalId`,`version`),
  CONSTRAINT `File_ibfk_1` FOREIGN KEY (`originalId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `File`
--

LOCK TABLES `File` WRITE;
/*!40000 ALTER TABLE `File` DISABLE KEYS */;
INSERT INTO `File` VALUES ('00687073-f108-4c8e-9cf4-e9202923866e',664,'','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_LESC_e64276ae-1a8c-45bd-adaa-f04086ada9e7_MODEL','33_w2_o1_mordu_posterieur_gauche_scan_file_0.zip','00687073-f108-4c8e-9cf4-e9202923866e','{\"displayTitle\":\"Posterior left bite 1.33.2.1.2\",\"modelMatrix\":\"-0.941316,0.143589,0.303979,0,-0.159365,-0.987151,-0.0238107,0,0.29754,-0.0701266,0.952382,0,0.802147,2.37814,-24.0388,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:05:20.000','2022-08-01 09:27:12.000','2024-10-31 14:02:31.816','2024-10-31 10:02:31.816'),('00af650a-5d5c-42b6-af45-b746624924b3',664,'/var/.data/2021/664/f4f78058-cf3c-4c86-a252-bc92bd2d36b0/session_49b3ccf6-630c-48b2-8480-8a005298959e/order_223975e3-130e-4b67-8ab4-69e9e3adbfc8/13_w1_couronne_prost_file_0.pdf','PATIENT_f4f78058-cf3c-4c86-a252-bc92bd2d36b0_ACT_49b3ccf6-630c-48b2-8480-8a005298959e_PROST_223975e3-130e-4b67-8ab4-69e9e3adbfc8_FORM','13_w1_couronne_prost_file_0.pdf','00af650a-5d5c-42b6-af45-b746624924b3','{\"displayTitle\":\"CROWN 1.13.1.1 CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-11-03 22:41:34.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.254'),('014c13a7-b107-4172-96fe-0e4f2cbfbf86',664,'/var/.data/2021/664/2217798a-4832-4e0d-9259-f8a836365b51/session_acaef63e-48f8-4a62-9c7d-a3b85544301c/occlusion_e7db4581-4a3d-448a-8e08-c12a27fa6201/scan_3d2db1ee-26fa-4508-8e14-b81d51746da7/9_w1_o1_maxillaire_scan_file_0.ply','PATIENT_2217798a-4832-4e0d-9259-f8a836365b51_ACT_acaef63e-48f8-4a62-9c7d-a3b85544301c_SESS_e7db4581-4a3d-448a-8e08-c12a27fa6201_TOSC_3d2db1ee-26fa-4508-8e14-b81d51746da7_MODEL','9_w1_o1_maxillaire_scan_file_0.ply','014c13a7-b107-4172-96fe-0e4f2cbfbf86','{\"displayTitle\":\"Occlusion Mandible 1.9.1.1\",\"modelMatrix\":\"-0.722075,0.67791,-0.138006,0,-0.691815,-0.707562,0.144042,0,-1.50097e-8,0.199484,0.979901,0,8.13396,-36.1453,-15.7157,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-06-11 22:29:39.000','2024-10-31 14:02:26.142','2024-10-31 10:02:26.142'),('01d9850c-07c1-4bce-bfc7-a103199fd817',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_96711d60-288c-439f-b464-597833d56519/occlusion_a98f038e-a19a-47ad-af09-a22810e9d19c/scan_86e16909-3b39-4591-8c03-0e4eba17f0ff/14_w3_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_96711d60-288c-439f-b464-597833d56519_SESS_a98f038e-a19a-47ad-af09-a22810e9d19c_RISC_86e16909-3b39-4591-8c03-0e4eba17f0ff_SNAPS','14_w3_o1_mordu_posterieur_droit_snapshot_0.png','01d9850c-07c1-4bce-bfc7-a103199fd817','{\"displayTitle\":\"Mordu posterieur droit 1.14.3.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-14 15:35:24.000','2024-10-31 14:02:32.510','2024-10-31 10:02:32.510'),('038a356c-cfd5-42a7-b2bc-6d94ebccde52',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368/32_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_LESC_8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368_SNAPS','32_w1_o1_mordu_posterieur_gauche_snapshot_0.png','038a356c-cfd5-42a7-b2bc-6d94ebccde52','{\"displayTitle\":\"Posterior left bite 1.32.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-23 16:39:42.000','2024-10-31 14:02:32.947','2024-10-31 10:02:32.947'),('0411f5bf-323b-47db-be56-fdf58a7dcaaa',664,'','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_LIFI','37_w2_o2_mandibule_ml_0_0.xyz','0411f5bf-323b-47db-be56-fdf58a7dcaaa','{\"displayTitle\":\"Margin line Mandible 1.37.2.2.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2023-05-22 09:05:21.000','2022-11-09 11:00:20.000','2024-10-31 14:02:35.965','2024-10-31 10:02:35.965'),('04156d5e-49b6-4518-b4b7-1f709a431367',664,'/var/.data/2021/664/366ffa87-059a-436a-9125-8827b3a2da1a/session_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9/occlusion_a59f40f9-2208-4d6a-b286-f64533d92e3c/scan_1d1515dc-8da4-4b0c-83dc-d1599e5f76cf/15_w1_o1_mandibule_snapshot_0.png','PATIENT_366ffa87-059a-436a-9125-8827b3a2da1a_ACT_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9_SESS_a59f40f9-2208-4d6a-b286-f64533d92e3c_BOSC_1d1515dc-8da4-4b0c-83dc-d1599e5f76cf_SNAPS','15_w1_o1_mandibule_snapshot_0.png','04156d5e-49b6-4518-b4b7-1f709a431367','{\"displayTitle\":\"Mandibule 1.15.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-01-18 21:35:58.000','2024-10-31 14:02:25.828','2024-10-31 10:02:25.828'),('041aa495-530d-4b35-9123-837a50cb5169',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/order_64b9506d-1475-4965-b3d3-054a5a076a37/44_w1_couronne_sur_implant_prost_file_041aa495-530d-4b35-9123-837a50cb5169_0.pdf','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_PROST_64b9506d-1475-4965-b3d3-054a5a076a37_FORM','44_w1_couronne_sur_implant_prost_file_041aa495-530d-4b35-9123-837a50cb5169_0.pdf','041aa495-530d-4b35-9123-837a50cb5169','{\"displayTitle\":\"ORDER 1.44.1.1 IMPLANT CROWN Taylor-Jolley\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'CREATED',0,NULL,'2022-09-07 19:39:23.000','2023-05-17 17:16:39.559',NULL),('043bef2f-4ab7-477e-8b7f-ea391cad0ec7',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_5500928e-446a-45d8-af99-faf7375b1d49/21_w1_o1_mandibule_scan_file_1.ply','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_BOSC_5500928e-446a-45d8-af99-faf7375b1d49_MODEL','21_w1_o1_mandibule_scan_file_1.ply','d9832be3-80d4-48f3-a493-2302821853bf','{\"displayTitle\":\"Mandible 1.21.1.1.1\",\"modelMatrix\":\"-0.482646,0.839744,-0.248762,0,-0.875815,-0.462768,0.137088,0,1.46051e-8,0.284034,0.958814,0,2.3496,-41.1674,-15.7282,1\",\"title\":\"Mandible PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-04-28 18:18:17.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.788'),('0447f95a-1a07-4b73-a2bf-c052637691d7',664,'','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_LIFI','37_w2_o2_mandibule_ml_0_0.xyz','0447f95a-1a07-4b73-a2bf-c052637691d7','{\"displayTitle\":\"Margin line Mandible 1.37.2.2.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2023-05-22 09:05:21.000','2022-11-09 10:58:49.000','2024-10-31 14:02:35.974','2024-10-31 10:02:35.974'),('045d5354-704b-45ba-bcdb-c155f28931f0',664,'','PATIENT_e33159c9-a713-4a37-ba98-9ec2e2e213e7_ACT_b63ca765-4d68-4cf4-9707-4ad3a19f3236_SESS_ae7f89c9-26ec-4cee-b377-d5145e6c6aae_TOSC_d5c1d30b-d8a4-4e8f-aae4-1e8dd2cb3dcb_MODEL','50_w1_o1_maxillaire_scan_file_0.zip','045d5354-704b-45ba-bcdb-c155f28931f0','{\"displayTitle\":\"Maxilla 1.50.1.1.1\",\"modelMatrix\":\"0.573483,0.738951,-0.353651,0,-0.819217,0.517293,-0.247569,0,4.79823e-09,0.431694,0.90202,0,-34.0181,-23.2947,-17.274,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:05:22.000','2022-11-14 11:17:38.000','2024-10-31 14:02:36.138','2024-10-31 10:02:36.138'),('049cbd64-e3ba-47ab-83cd-365a9e5b2ae5',664,'','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_RISC_6bf6cdd3-0c99-40b6-9e2b-5eaf7077f35f_SNAPS','33_w2_o1_mordu_posterieur_droit_snapshot_0.png','049cbd64-e3ba-47ab-83cd-365a9e5b2ae5','{\"displayTitle\":\"Posterior right bite 1.33.2.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:05:22.000','2022-08-01 09:23:54.000','2024-10-31 14:02:31.779','2024-10-31 10:02:31.779'),('04ae92b2-2a37-49d3-be24-6db207bc06c7',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_a283652c-095c-41a2-b62b-1cba87286c35/24_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_LESC_a283652c-095c-41a2-b62b-1cba87286c35_MODEL','24_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','04ae92b2-2a37-49d3-be24-6db207bc06c7','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.1\",\"modelMatrix\":\"-0.974202,0.00465595,0.224597,0,-0.0204647,-0.996324,-0.0826268,0,0.224776,-0.0856032,0.970943,0,9.2498,3.10871,-22.7594,1\",\"title\":\"Posterior left bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-13 21:29:12.000','2024-10-31 14:02:28.592','2024-10-31 10:02:28.592'),('04d5729b-24fa-4bd7-aae0-731968a61592',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/occlusion_d7b86e87-0261-4bc1-8529-76e0bdd29195/scan_6b9a0ce1-8ace-48c3-a9b9-efd9bd604d7f/18_w4_o1_mandibule_scan_file_0.zip','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_BOSC_6b9a0ce1-8ace-48c3-a9b9-efd9bd604d7f_MODEL','18_w4_o1_mandibule_scan_file_0.zip','04d5729b-24fa-4bd7-aae0-731968a61592','{\"displayTitle\":\"Mandible 1.18.4.1.1\",\"modelMatrix\":\"0.386684,0.897776,-0.210889,0,-0.922212,0.376438,-0.0884259,0,2.90279e-09,0.228677,0.973502,0,-22.9103,-16.2941,-20.5912,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-24 16:32:04.000','2023-05-22 13:09:23.067','2023-05-22 09:09:23.067'),('0522def8-f55f-4a8d-8758-a81209e06ef3',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_6630e34a-9b19-4727-9ef0-e1c95c341549/scan_5d0e6d2d-490c-4381-a794-dd7121de4a60/44_w1_o1_maxillaire_scan_file_0.zip','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_6630e34a-9b19-4727-9ef0-e1c95c341549_TOSC_5d0e6d2d-490c-4381-a794-dd7121de4a60_MODEL','44_w1_o1_maxillaire_scan_file_0.zip','0522def8-f55f-4a8d-8758-a81209e06ef3','{\"displayTitle\":\"Maxilla 1.44.1.1.1\",\"modelMatrix\":\"0.669228,0.739985,-0.0675005,0,-0.743057,0.666461,-0.0607937,0,-2.13057e-09,0.0908415,0.995865,0,-5.83772,-19.2199,-20.3091,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-07 15:02:02.000','2024-10-31 14:02:33.194','2024-10-31 10:02:33.194'),('052b521c-e4e5-43db-a857-367b074e72d3',664,'/var/.data/2021/664/17cc8b8c-6280-4e69-ad1e-731bdd9819e0/session_f9cb9561-eacc-4b43-976b-dfa67a953a80/occlusion_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910/scan_3ef1c403-4f23-4240-9474-8d8f45c283b5/19_w1_o1_mandibule_snapshot_0.png','PATIENT_17cc8b8c-6280-4e69-ad1e-731bdd9819e0_ACT_f9cb9561-eacc-4b43-976b-dfa67a953a80_SESS_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910_BOSC_3ef1c403-4f23-4240-9474-8d8f45c283b5_SNAPS','19_w1_o1_mandibule_snapshot_0.png','052b521c-e4e5-43db-a857-367b074e72d3','{\"displayTitle\":\"Mandibule 1.19.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-09 19:43:26.000','2024-10-31 14:02:25.713','2024-10-31 10:02:25.713'),('0552024a-43bc-40ca-ad79-d59a1e19891d',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_26288707-da63-4165-bfdb-8a6c299bcb2b/scan_962c1c5b-f5e5-4c64-9396-b2b298e42f54/33_w1_o2_maxillaire_snapshot_0.png','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_26288707-da63-4165-bfdb-8a6c299bcb2b_TOSC_962c1c5b-f5e5-4c64-9396-b2b298e42f54_SNAPS','33_w1_o2_maxillaire_snapshot_0.png','0552024a-43bc-40ca-ad79-d59a1e19891d','{\"displayTitle\":\"Maxilla 1.33.1.2.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-04-11 17:18:11.000','2024-10-31 14:02:29.105','2024-10-31 10:02:29.105'),('055bb022-85cd-4a55-9a46-10afca2d621d',664,'/var/.data/2022/664/635617fc-289b-470c-a4d4-678d7b5f275a/session_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6/occlusion_94dc9a16-b72c-4f6a-a520-ba83c28954c3/scan_5f528d31-6a1a-48e7-8ece-1a998befa669/45_w1_o1_mandibule_scan_file_0.zip','PATIENT_635617fc-289b-470c-a4d4-678d7b5f275a_ACT_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6_SESS_94dc9a16-b72c-4f6a-a520-ba83c28954c3_BOSC_5f528d31-6a1a-48e7-8ece-1a998befa669_MODEL','45_w1_o1_mandibule_scan_file_0.zip','055bb022-85cd-4a55-9a46-10afca2d621d','{\"displayTitle\":\"Mandible 1.45.1.1.1\",\"modelMatrix\":\"-0.886139,-0.435746,0.157746,0,0.46342,-0.833221,0.301637,0,-1.69625e-08,0.340395,0.940283,0,27.2492,2.01487,-23.4126,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-07 16:36:51.000','2024-10-31 14:02:33.327','2024-10-31 10:02:33.327'),('05a2d88e-2c85-462a-907f-7184b78eb8f5',664,'','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_BOSC_3eaba63c-ff17-453d-ab22-bc8e747a4ce5_SNAPS','35_w1_o1_mandibule_snapshot_0.png','05a2d88e-2c85-462a-907f-7184b78eb8f5','{\"displayTitle\":\"Mandible 1.35.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:05:24.000','2022-06-06 14:09:32.000','2024-10-31 14:02:29.448','2024-10-31 10:02:29.448'),('05a673f7-2845-4bda-810e-138d2f78652c',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/occlusion_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e/scan_3241a487-3527-47d6-93c9-bad3ce6f6d24/49_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_LESC_3241a487-3527-47d6-93c9-bad3ce6f6d24_MODEL','49_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','05a673f7-2845-4bda-810e-138d2f78652c','{\"displayTitle\":\"Posterior left bite 1.49.1.1.2\",\"modelMatrix\":\"-0.999774,0.0084295,0.0170336,0,-0.0113985,-0.991741,-0.125629,0,0.0181303,-0.128002,0.991936,0,6.92101,5.16363,-19.6451,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-10-31 17:18:57.000','2024-10-31 14:02:35.509','2024-10-31 10:02:35.509'),('06297eae-a625-4573-b1a0-fad402d6d398',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_bfe6249f-88b3-4a27-8f4c-5494e863352f/order_c155f94e-e0aa-488a-af25-8ada7a6a5b8a/10_w2_couronne_prost_file_0.png','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_bfe6249f-88b3-4a27-8f4c-5494e863352f_SESS_fcabdff7-f4aa-41a0-8d3a-67e664f1d43e_BOSC_7ba42cbf-4905-4681-956c-45d3f7e37b6f_SNAPS','10_w2_couronne_prost_file_0.png','06297eae-a625-4573-b1a0-fad402d6d398','{\"displayTitle\":\"Mandible 1.10.2.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-11-30 02:22:13.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.256'),('06bf9050-09ab-4cd9-82f1-c218c9a25dee',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_ede3aa5c-bbba-4cf2-8caa-b2d5f671b311/scan_b241654a-9ea1-48f7-8414-4891fdcbd880/44_w1_o2_mandibule_scan_file_0.zip','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_ede3aa5c-bbba-4cf2-8caa-b2d5f671b311_BOSC_b241654a-9ea1-48f7-8414-4891fdcbd880_MODEL','44_w1_o2_mandibule_scan_file_0.zip','06bf9050-09ab-4cd9-82f1-c218c9a25dee','{\"displayTitle\":\"Mandible 1.44.1.2.1\",\"modelMatrix\":\"0.870933,0.468581,-0.148011,0,-0.491401,0.830488,-0.262327,0,-1.56576e-08,0.301202,0.953561,0,-16.4295,-21.2649,-18.5584,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-21 19:25:38.000','2024-10-31 14:02:35.222','2024-10-31 10:02:35.222'),('0724c208-734f-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/scan_cd1443ce-734e-11ee-b011-58a023cda0dc/0724c208-734f-11ee-b011-58a023cda0dc.zip','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_LESC_cd1443ce-734e-11ee-b011-58a023cda0dc_MODEL','0724c208-734f-11ee-b011-58a023cda0dc.zip','0724c208-734f-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Left bite 1.7.10.1.2\",\"modelMatrix\":\"-0.916654,-0.114864,0.380012,0,0.194456,-0.958685,0.206226,0,0.349395,0.260516,0.901748,0,5.99239,-2.29293,-22.2564,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-10-25 12:00:01.000','2023-10-30 13:28:06.440','2023-10-30 09:28:06.440'),('0724d1c1-734f-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/scan_cd1443ce-734e-11ee-b011-58a023cda0dc/0724d1c1-734f-11ee-b011-58a023cda0dc.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_LESC_cd1443ce-734e-11ee-b011-58a023cda0dc_SNAPS','0724d1c1-734f-11ee-b011-58a023cda0dc.png','0724d1c1-734f-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Left bite 1.7.10.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-10-25 12:00:01.000','2023-10-30 13:28:06.457','2023-10-30 09:28:06.457'),('07527793-5c05-4fbc-92d9-298ccb3489d3',664,'','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_BOSC_5478f37b-d39e-46d1-a026-906c02d9c928_MODEL','','4baca937-885c-4f87-88b2-c1c5ac9e24e5','{\"displayTitle\":\"Mandible 1.30.1.1.1\",\"modelMatrix\":\"-0.837108,-0.527056,0.1465,0,0.547037,-0.806531,0.224183,0,-5.67081e-09,0.267806,0.963473,0,6.4778,-0.393129,-20.0216,1\",\"title\":\"Mandible ZIP\"}','ZIP',1,'SYNCED',0,'2022-03-23 13:55:50.000','2022-03-21 15:26:37.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.809'),('076521ec-f003-4853-aec3-594a997cc51b',664,'/var/.data/2022/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_00cdb0d1-c7e4-41bc-93a4-7c29a6f1cf58/occlusion_324dac1a-95fa-44d5-b054-88f048931106/scan_4fee66f9-724e-4496-aae8-922ee35cabf6/29_w1_o1_mandibule_snapshot_0.png','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_00cdb0d1-c7e4-41bc-93a4-7c29a6f1cf58_SESS_324dac1a-95fa-44d5-b054-88f048931106_BOSC_4fee66f9-724e-4496-aae8-922ee35cabf6_SNAPS','29_w1_o1_mandibule_snapshot_0.png','076521ec-f003-4853-aec3-594a997cc51b','{\"displayTitle\":\"Mandible 1.29.1.1.4\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-14 16:02:28.000','2024-10-31 14:02:28.717','2024-10-31 10:02:28.717'),('079f92c4-4b00-409c-80e0-a0e0d55c599f',664,'','PATIENT_11ec40e4-4579-4185-9fcf-4e1aac06f554_ACT_8f44bea9-b7e9-45c8-a098-f3b18f9be730_SESS_7348646e-cf7a-460b-aba9-d56ad656689e_TOSC_d3d5ecdb-7933-478d-8f71-7bc13b2a4a05_MODEL','','f40bab24-99ba-4240-a790-2cb8e6b01f50','{\"displayTitle\":\"Maxilla 1.25.1.1.2\",\"modelMatrix\":\"0.472664,0.869304,-0.144568,0,-0.881243,0.46626,-0.0775408,0,-2.06962e-9,0.164051,0.986452,0,-22.5465,-11.4851,-19.0711,1\",\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":10,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":3,\"title\":\"Maxilla PLY\"}','PLY',2,'SYNCED',0,'2022-03-14 14:42:20.000','2021-09-14 17:58:32.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.286'),('088dc1b3-7eb5-464b-a7c2-b50922838a77',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/order_bd06bb45-1ca4-4e1a-bd3b-f5da30b77316/41_w1_couronne_sur_implant_prost_file_088dc1b3-7eb5-464b-a7c2-b50922838a77_0.pdf','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_PROST_bd06bb45-1ca4-4e1a-bd3b-f5da30b77316_FORM','41_w1_couronne_sur_implant_prost_file_088dc1b3-7eb5-464b-a7c2-b50922838a77_0.pdf','088dc1b3-7eb5-464b-a7c2-b50922838a77','{\"displayTitle\":\"ORDER 1.41.1.2 IMPLANT CROWN Karen Lindsay\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-08-03 16:33:07.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.256'),('0967d80d-992e-4d4b-ae94-bd981fca4791',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_92704e83-dce3-4695-baad-1df750f09cd7/37_w2_o2_mandibule_ml_0_0.xyz','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_LIFI','37_w2_o2_mandibule_ml_0_0.xyz','0967d80d-992e-4d4b-ae94-bd981fca4791','{\"displayTitle\":\"Margin line Mandible 1.37.2.2.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2022-11-09 17:02:24.000','2024-10-31 14:02:35.984','2024-10-31 10:02:35.984'),('09c6909f-b484-4ce8-866d-734aef82c225',664,'/var/.data/2022/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_d3696b3d-0728-4822-b89d-631e2ab774a4/occlusion_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6/scan_1fad60ca-f3ea-48a3-b845-fcd52ee435b5/14_w2_o1_mandibule_screenshot_09c6909f-b484-4ce8-866d-734aef82c225_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_d3696b3d-0728-4822-b89d-631e2ab774a4_SESS_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6_BOSC_1fad60ca-f3ea-48a3-b845-fcd52ee435b5_SCREENS','14_w2_o1_mandibule_screenshot_09c6909f-b484-4ce8-866d-734aef82c225_0.png','09c6909f-b484-4ce8-866d-734aef82c225','{\"displayTitle\":\"Screenshot 1.14.2.1.1 Mandible 2\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Mandible 2\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:01:26.000','2024-10-31 14:02:32.713','2024-10-31 10:02:32.713'),('09e45aca-9e2d-422a-8ede-017b9008e6fa',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_26288707-da63-4165-bfdb-8a6c299bcb2b/scan_962c1c5b-f5e5-4c64-9396-b2b298e42f54/33_w1_o2_maxillaire_scan_file_0.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_26288707-da63-4165-bfdb-8a6c299bcb2b_TOSC_962c1c5b-f5e5-4c64-9396-b2b298e42f54_MODEL','33_w1_o2_maxillaire_scan_file_0.zip','09e45aca-9e2d-422a-8ede-017b9008e6fa','{\"displayTitle\":\"Maxilla 1.33.1.2.1\",\"modelMatrix\":\"0.965619,-0.254728,0.0518982,0,0.259961,0.946181,-0.192775,0,2.79557e-09,0.199638,0.97987,0,-10.9355,1.33745,-20.9769,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-04-11 17:18:12.000','2024-10-31 14:02:29.114','2024-10-31 10:02:29.114'),('0a4f0eb8-9b72-4c8c-a19e-7bc735b02be1',664,'/var/.data/2021/664/e648cc66-9340-456c-a379-50836d1b8a5b/session_f09c328f-1a8b-4f63-8998-2f9b57cd3c76/occlusion_2c19cd55-a36e-4dc7-8954-ea8a8eeacd16/scan_27ffc744-9a52-49aa-a247-2801d6cd8ff9/16_w1_o1_mordu_anterieur_scan_file_0.ply','PATIENT_e648cc66-9340-456c-a379-50836d1b8a5b_ACT_f09c328f-1a8b-4f63-8998-2f9b57cd3c76_SESS_2c19cd55-a36e-4dc7-8954-ea8a8eeacd16_FRSC_27ffc744-9a52-49aa-a247-2801d6cd8ff9_MODEL','16_w1_o1_mordu_anterieur_scan_file_0.ply','0a4f0eb8-9b72-4c8c-a19e-7bc735b02be1','{\"displayTitle\":\"Mordu anterieur 1.16.1.1.1\",\"modelMatrix\":\"-0.99405,0.118549,-0.0846756,0,-0.049232,-0.918882,-0.37685,0,-0.10307,-0.377997,0.922508,0,-1.70604,12.4178,-19.1927,1\",\"title\":\"Anterior bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-01-18 18:02:07.000','2024-10-31 14:02:26.177','2024-10-31 10:02:26.177'),('0b75b5b3-6359-43a9-93d0-98e60dab0ddf',664,'/var/.data/2022/664/097506b2-3385-4e2b-a196-b427b2eb51b8/session_0a5a2b81-09c6-4fe0-874c-4b845c0229bc/occlusion_e78fa40a-0a61-4104-adb2-0cfd70d69414/scan_abe712db-ef5c-4b31-86ea-c51697f1242e/31_w1_o1_mandibule_scan_file_0.zip','PATIENT_097506b2-3385-4e2b-a196-b427b2eb51b8_ACT_0a5a2b81-09c6-4fe0-874c-4b845c0229bc_SESS_e78fa40a-0a61-4104-adb2-0cfd70d69414_BOSC_abe712db-ef5c-4b31-86ea-c51697f1242e_MODEL','31_w1_o1_mandibule_scan_file_0.zip','0b75b5b3-6359-43a9-93d0-98e60dab0ddf','{\"displayTitle\":\"Mandible 1.31.1.1.1\",\"modelMatrix\":\"0.263383,0.897547,-0.353608,0,-0.964691,0.245051,-0.0965434,0,-8.90735e-09,0.366551,0.930398,0,-23.6695,-26.7537,-18.0684,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-23 14:37:02.000','2024-10-31 14:02:28.861','2024-10-31 10:02:28.861'),('0b7d3aba-fa3b-11ed-8f6c-58a023cda0dc',664,'/var/.data/2023/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc/occlusion_cf61271a-fa37-11ed-8f6c-58a023cda0dc/scan_40fd847e-fa3a-11ed-8f6c-58a023cda0dc/0b7d3aba-fa3b-11ed-8f6c-58a023cda0dc.zip','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc_SESS_cf61271a-fa37-11ed-8f6c-58a023cda0dc_BOSC_40fd847e-fa3a-11ed-8f6c-58a023cda0dc_MODEL','0b7d3aba-fa3b-11ed-8f6c-58a023cda0dc.zip','0b7d3aba-fa3b-11ed-8f6c-58a023cda0dc','{\"displayTitle\":\"Mandible 1.29.6.1.1\",\"modelMatrix\":\"0.26255,-0.958001,0.115332,0,0.964918,0.260668,-0.0313813,0,1.06716e-09,0.119525,0.992831,0,-14.4375,16.5302,-20.5576,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-05-24 09:58:26.000','2024-10-31 14:02:36.353','2024-10-31 10:02:36.353'),('0b7d4a0a-fa3b-11ed-8f6c-58a023cda0dc',664,'/var/.data/2023/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc/occlusion_cf61271a-fa37-11ed-8f6c-58a023cda0dc/scan_40fd847e-fa3a-11ed-8f6c-58a023cda0dc/0b7d4a0a-fa3b-11ed-8f6c-58a023cda0dc.png','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc_SESS_cf61271a-fa37-11ed-8f6c-58a023cda0dc_BOSC_40fd847e-fa3a-11ed-8f6c-58a023cda0dc_SNAPS','0b7d4a0a-fa3b-11ed-8f6c-58a023cda0dc.png','0b7d4a0a-fa3b-11ed-8f6c-58a023cda0dc','{\"displayTitle\":\"Mandible 1.29.6.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-05-24 09:58:27.000','2024-10-31 14:02:36.363','2024-10-31 10:02:36.363'),('0b848954-7152-4e87-b60c-76f5ac669614',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_955946be-5764-4c34-9e84-61682f4fdf78/occlusion_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d/scan_722ff437-cef4-4d6b-861e-b52566d89c0d/33_w2_o1_mordu_anterieur_scan_file_0.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_FRSC_722ff437-cef4-4d6b-861e-b52566d89c0d_MODEL','33_w2_o1_mordu_anterieur_scan_file_0.zip','0b848954-7152-4e87-b60c-76f5ac669614','{\"displayTitle\":\"Anterior bite 1.33.2.1.1\",\"modelMatrix\":\"0.999769,-0.0182209,0.0223272,0,0.00235606,0.989049,0.142246,0,-0.0247029,-0.147065,0.989595,0,-7.99909,-0.221438,-19.218,1\",\"title\":\"Anterior bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-01 15:28:42.000','2024-10-31 14:02:31.798','2024-10-31 10:02:31.798'),('0b8f8838-0705-45dd-9f7f-647814f9be33',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/occlusion_d7b86e87-0261-4bc1-8529-76e0bdd29195/scan_d43bd9e0-44ee-49ed-aa89-8bcd9837b34a/18_w4_o1_mordu_anterieur_snapshot_0.png','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_FRSC_d43bd9e0-44ee-49ed-aa89-8bcd9837b34a_SNAPS','18_w4_o1_mordu_anterieur_snapshot_0.png','0b8f8838-0705-45dd-9f7f-647814f9be33','{\"displayTitle\":\"Anterior bite 1.18.4.1.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-24 16:41:48.000','2024-10-31 14:02:33.135','2024-10-31 10:02:33.135'),('0be7b65f-5bc4-4f76-a149-f40fdcefa07a',664,'/var/.data/2021/664/e648cc66-9340-456c-a379-50836d1b8a5b/session_f09c328f-1a8b-4f63-8998-2f9b57cd3c76/occlusion_2c19cd55-a36e-4dc7-8954-ea8a8eeacd16/scan_d4321e90-28f8-42a0-bde1-b9ddcf321fa8/16_w1_o1_maxillaire_scan_file_0.ply','PATIENT_e648cc66-9340-456c-a379-50836d1b8a5b_ACT_f09c328f-1a8b-4f63-8998-2f9b57cd3c76_SESS_2c19cd55-a36e-4dc7-8954-ea8a8eeacd16_TOSC_d4321e90-28f8-42a0-bde1-b9ddcf321fa8_MODEL','16_w1_o1_maxillaire_scan_file_0.ply','0be7b65f-5bc4-4f76-a149-f40fdcefa07a','{\"displayTitle\":\"Maxilla 1.16.1.1.1\",\"modelMatrix\":\"-0.447676,0.862582,-0.235666,0,-0.894196,-0.431848,0.117985,0,-8.54602e-9,0.263551,0.964646,0,21.4202,-17.0684,-19.4748,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-01-18 17:42:50.000','2024-10-31 14:02:26.200','2024-10-31 10:02:26.200'),('0bf7054d-6a4b-48e8-babb-234a4571adab',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/order_ce9127f7-b01e-4e28-b330-8f397f2a043e/33_w1_couronne_sur_implant_prost_file_0bf7054d-6a4b-48e8-babb-234a4571adab_1.pdf','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_PROST_ce9127f7-b01e-4e28-b330-8f397f2a043e_FORM','33_w1_couronne_sur_implant_prost_file_0bf7054d-6a4b-48e8-babb-234a4571adab_1.pdf','6103a761-4255-42c2-a7dd-e05a49a38969','{\"displayTitle\":\"ORDER 1.33.1.1 IMPLANT CROWN\",\"title\":\"Couronne sur Implant PDF\"}','PDF',1,'SYNCED',0,NULL,'2022-04-27 16:32:28.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.257'),('0c7afa56-2ad1-49d6-9a62-5f142ca9dffc',664,'','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_ef2b4fcf-f21c-418d-942a-c99ea96efbdb_SESS_7d36e059-dbc3-46b0-931a-bdf8fdc805c6_BOSC_7bbce4b0-91f9-47fe-9ce5-53e0f491b245_MODEL','7_w2_o1_mandibule_scan_file_0.ply','0c7afa56-2ad1-49d6-9a62-5f142ca9dffc','{\"displayTitle\":\"Mandible 1.7.2.1.2\",\"modelMatrix\":\"0.0650029,0.901427,-0.428023,0,-0.997885,0.0587196,-0.0278817,0,-2.12332e-9,0.42893,0.903338,0,-14.9389,-12.2431,-7.03397,1\",\"title\":\"Mandible PLY\"}','PLY',0,'SYNCED',0,'2023-05-22 09:05:28.000','2021-04-21 10:14:59.000','2024-10-31 14:02:25.524','2024-10-31 10:02:25.524'),('0cc0a4e2-b944-4f97-b8fd-4141a51c8b36',664,'/var/.data/2021/664/f4f78058-cf3c-4c86-a252-bc92bd2d36b0/session_49b3ccf6-630c-48b2-8480-8a005298959e/occlusion_eee3d6a4-c7be-49a9-9278-7bd1d7e7f773/scan_4d1480f1-6a51-4555-bec5-61f967de64cd/13_w1_o1_maxillaire_scan_file_0.ply','PATIENT_f4f78058-cf3c-4c86-a252-bc92bd2d36b0_ACT_49b3ccf6-630c-48b2-8480-8a005298959e_SESS_eee3d6a4-c7be-49a9-9278-7bd1d7e7f773_TOSC_4d1480f1-6a51-4555-bec5-61f967de64cd_MODEL','13_w1_o1_maxillaire_scan_file_0.ply','0cc0a4e2-b944-4f97-b8fd-4141a51c8b36','{\"displayTitle\":\"Maxillaire 1.13.1.1.1\",\"modelMatrix\":\"-0.137185,0.970239,-0.199541,0,-0.990545,-0.134372,0.0276352,0,-2.31346e-9,0.201445,0.9795,0,17.5019,-26.2404,-33.9388,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-09-02 15:23:59.000','2024-10-31 14:02:25.571','2024-10-31 10:02:25.571'),('0d4b8851-03cd-409c-8c1b-88b798f2148e',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_120f9fe3-b23d-49c7-89ab-f1becc102f6c/scan_b08eb59b-89c3-4239-8926-d8eb829e4257/33_w1_o1_mandibule_scan_file_0.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_120f9fe3-b23d-49c7-89ab-f1becc102f6c_BOSC_b08eb59b-89c3-4239-8926-d8eb829e4257_MODEL','33_w1_o1_mandibule_scan_file_0.zip','0d4b8851-03cd-409c-8c1b-88b798f2148e','{\"displayTitle\":\"Mandible 1.33.1.1.1\",\"modelMatrix\":\"0.989975,0.134314,-0.0436868,0,-0.14124,0.941429,-0.306207,0,-9.79169e-10,0.309308,0.950962,0,-20.5582,-3.97222,-22.0349,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-04-11 17:08:53.000','2024-10-31 14:02:29.191','2024-10-31 10:02:29.191'),('0e146d0f-278a-4e47-9f58-7f65720624e5',664,'/var/.data/2021/664/366ffa87-059a-436a-9125-8827b3a2da1a/session_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9/occlusion_a59f40f9-2208-4d6a-b286-f64533d92e3c/scan_c17d800a-58c0-4658-b29b-d8ee0cbd16bb/15_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_366ffa87-059a-436a-9125-8827b3a2da1a_ACT_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9_SESS_a59f40f9-2208-4d6a-b286-f64533d92e3c_FRSC_c17d800a-58c0-4658-b29b-d8ee0cbd16bb_SNAPS','15_w1_o1_mordu_anterieur_snapshot_0.png','0e146d0f-278a-4e47-9f58-7f65720624e5','{\"displayTitle\":\"Mordu anterieur 1.15.1.1.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-01-18 21:39:02.000','2024-10-31 14:02:25.849','2024-10-31 10:02:25.849'),('0e193ac6-c011-45df-8829-5c9742aad5b4',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/order_548a8b15-a19f-42cb-80ef-399c4e3a51ee/10_w1_couronne_prost_file_0.pdf','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_PROST_548a8b15-a19f-42cb-80ef-399c4e3a51ee_FORM','10_w1_couronne_prost_file_0.pdf','0e193ac6-c011-45df-8829-5c9742aad5b4','{\"displayTitle\":\"CROWN 1.10.1.5 CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-11-30 02:24:32.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.257'),('0ed482bd-7b1d-4b10-a2ee-e745bb925cc5',664,'','PATIENT_17cc8b8c-6280-4e69-ad1e-731bdd9819e0_ACT_f9cb9561-eacc-4b43-976b-dfa67a953a80_SESS_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910_LESC_210ee6b9-1960-43ea-a220-cfa20b762017_SNAPS','19_w1_o1_mordu_posterieur_gauche_snapshot_0.png','0ed482bd-7b1d-4b10-a2ee-e745bb925cc5','{\"displayTitle\":\"Posterior left bite 1.19.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:05:30.000','2021-04-09 13:49:59.000','2024-10-31 14:02:25.436','2024-10-31 10:02:25.436'),('0f3468b4-f1b8-411d-b79b-fb3966cbd43e',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_92704e83-dce3-4695-baad-1df750f09cd7/37_w2_o2_mandibule_snapshot_1.png','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_SNAPS','37_w2_o2_mandibule_snapshot_1.png','ac8e82cb-46bf-4b75-8996-3ccefa879974','{\"displayTitle\":\"Mandible 1.37.2.2.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-11-09 16:02:36.000','2024-10-31 14:02:36.000','2024-10-31 10:02:36.000'),('0f760deb-e643-4ca8-9cba-0f4c1b4da06b',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/occlusion_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e/scan_3241a487-3527-47d6-93c9-bad3ce6f6d24/49_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_LESC_3241a487-3527-47d6-93c9-bad3ce6f6d24_SNAPS','49_w1_o1_mordu_posterieur_gauche_snapshot_0.png','0f760deb-e643-4ca8-9cba-0f4c1b4da06b','{\"displayTitle\":\"Posterior left bite 1.49.1.1.2\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-10-31 17:18:57.000','2024-10-31 14:02:35.519','2024-10-31 10:02:35.519'),('0f7e3ea7-65fd-4870-9e54-f9ef2a24d8bf',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_92704e83-dce3-4695-baad-1df750f09cd7/37_w2_o2_mandibule_scan_file_1.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_MODEL','37_w2_o2_mandibule_scan_file_1.zip','cb794354-96b6-463a-a735-215a2367d35f','{\"displayTitle\":\"Mandible 1.37.2.2.1\",\"modelMatrix\":\"0.841802,0.477097,-0.252482,0,-0.539786,0.744038,-0.393749,0,-9.45422e-09,0.467745,0.883863,0,-11.1222,-12.9995,-20.7717,1\",\"title\":\"Mandible ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-11-09 15:58:25.000','2024-10-31 14:02:36.019','2024-10-31 10:02:36.019'),('0fda9c0b-19a1-4c9a-bed0-77729ac8643e',664,'/var/.data/2022/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_00cdb0d1-c7e4-41bc-93a4-7c29a6f1cf58/occlusion_324dac1a-95fa-44d5-b054-88f048931106/scan_c69cb914-4302-4945-ad80-085dba8ff126/29_w1_o1_maxillaire_snapshot_0.png','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_00cdb0d1-c7e4-41bc-93a4-7c29a6f1cf58_SESS_324dac1a-95fa-44d5-b054-88f048931106_TOSC_c69cb914-4302-4945-ad80-085dba8ff126_SNAPS','29_w1_o1_maxillaire_snapshot_0.png','0fda9c0b-19a1-4c9a-bed0-77729ac8643e','{\"displayTitle\":\"Maxilla 1.29.1.1.3\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-14 16:23:58.000','2024-10-31 14:02:28.737','2024-10-31 10:02:28.737'),('10d50154-eaad-4c7c-bcc0-5edad9315cc7',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_955946be-5764-4c34-9e84-61682f4fdf78/occlusion_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d/scan_bf2f2d20-77c1-4aff-a005-144b4bf2c7f3/33_w2_o1_maxillaire_snapshot_0.png','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_TOSC_bf2f2d20-77c1-4aff-a005-144b4bf2c7f3_SNAPS','33_w2_o1_maxillaire_snapshot_0.png','10d50154-eaad-4c7c-bcc0-5edad9315cc7','{\"displayTitle\":\"Maxilla 1.33.2.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-01 15:15:18.000','2024-10-31 14:02:31.742','2024-10-31 10:02:31.742'),('12a9e53c-f4b6-42ea-9478-c84407313e24',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_775311e4-a561-40c7-a2ce-76a0b1550be8/scan_627e4388-24f1-4c92-816e-89cfce055284/41_w1_o1_maxillaire_snapshot_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_775311e4-a561-40c7-a2ce-76a0b1550be8_TOSC_627e4388-24f1-4c92-816e-89cfce055284_SNAPS','41_w1_o1_maxillaire_snapshot_0.png','12a9e53c-f4b6-42ea-9478-c84407313e24','{\"displayTitle\":\"Maxilla 1.41.1.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-07-28 15:34:22.000','2024-10-31 14:02:32.137','2024-10-31 10:02:32.137'),('130024ea-36bf-439a-980c-e464701bd4fb',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_92704e83-dce3-4695-baad-1df750f09cd7/37_w2_o2_mandibule_mlmeta_0_0.bin','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_LIFIM','37_w2_o2_mandibule_mlmeta_0_0.bin','130024ea-36bf-439a-980c-e464701bd4fb','{\"displayTitle\":\"Margin line Mandible 1.37.2.2.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2022-11-09 17:02:24.000','2024-10-31 14:02:36.029','2024-10-31 10:02:36.029'),('1306dfc3-6859-4db6-a328-8cbcb42e86f8',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_120f9fe3-b23d-49c7-89ab-f1becc102f6c/scan_b08eb59b-89c3-4239-8926-d8eb829e4257/33_w1_o1_mandibule_snapshot_0.png','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_120f9fe3-b23d-49c7-89ab-f1becc102f6c_BOSC_b08eb59b-89c3-4239-8926-d8eb829e4257_SNAPS','33_w1_o1_mandibule_snapshot_0.png','1306dfc3-6859-4db6-a328-8cbcb42e86f8','{\"displayTitle\":\"Mandible 1.33.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-04-11 17:08:52.000','2024-10-31 14:02:29.199','2024-10-31 10:02:29.199'),('13097ab6-1a4d-4f75-985a-8e44b2c82e0b',664,'/var/.data/2021/664/d71657f7-b9e8-45b9-865f-1c4c55c62017/session_ce26f180-fc4c-444b-bdda-56104c53d7a2/occlusion_a03e7e47-63b0-4489-88e8-a77bb9aed5cd/scan_b0b45de7-f1c4-4f46-9c23-2126c2326f9b/23_w1_o1_maxillaire_scan_file_0.ply','PATIENT_d71657f7-b9e8-45b9-865f-1c4c55c62017_ACT_ce26f180-fc4c-444b-bdda-56104c53d7a2_SESS_a03e7e47-63b0-4489-88e8-a77bb9aed5cd_TOSC_b0b45de7-f1c4-4f46-9c23-2126c2326f9b_MODEL','23_w1_o1_maxillaire_scan_file_0.ply','13097ab6-1a4d-4f75-985a-8e44b2c82e0b','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"modelMatrix\":\"0.665572,0.704072,-0.247582,0,-0.746334,0.627883,-0.220791,0,-7.15513e-9,0.331731,0.943374,0,-1.89339,-36.8515,-15.3172,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-06-21 18:50:32.000','2024-10-31 14:02:25.868','2024-10-31 10:02:25.868'),('1327ec84-5062-4d24-bc87-76829fa164d9',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/occlusion_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e/scan_6d53d83a-50bf-4b07-a6c4-377e6be410b9/49_w1_o1_maxillaire_scan_file_0.zip','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_TOSC_6d53d83a-50bf-4b07-a6c4-377e6be410b9_MODEL','49_w1_o1_maxillaire_scan_file_0.zip','1327ec84-5062-4d24-bc87-76829fa164d9','{\"displayTitle\":\"Maxilla 1.49.1.1.2\",\"modelMatrix\":\"0.166282,0.850706,-0.498647,0,-0.986078,0.143455,-0.0840869,0,-7.24434e-09,0.505687,0.862717,0,-6.66853,-21.5055,-18.459,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-10-31 17:30:54.000','2024-10-31 14:02:36.236','2024-10-31 10:02:36.236'),('1338119f-9ce3-4264-ad6d-a8bbebdb19e6',664,'/var/.data/2022/664/685697a1-0d50-4a06-8b3e-729cf9750f38/session_e1d214d2-2b62-484c-8ede-86b3f84573d3/occlusion_8cd0c724-d3d0-4821-a88b-42b03ae4eb07/scan_101a958b-c6e0-45d2-be43-01921415b27e/48_w1_o1_mandibule_scan_file_1.zip','PATIENT_685697a1-0d50-4a06-8b3e-729cf9750f38_ACT_e1d214d2-2b62-484c-8ede-86b3f84573d3_SESS_8cd0c724-d3d0-4821-a88b-42b03ae4eb07_BOSC_101a958b-c6e0-45d2-be43-01921415b27e_MODEL','48_w1_o1_mandibule_scan_file_1.zip','1ca966ee-f717-4668-9ce5-c95a9a20eaff','{\"displayTitle\":\"Mandible 1.48.1.1.1\",\"modelMatrix\":\"0.822196,0.549747,-0.147551,0,-0.569204,0.794091,-0.213133,0,2.40563e-09,0.259224,0.965817,0,-10.7075,-36.7685,-16.3665,1\",\"title\":\"Mandible ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-10-17 17:11:52.000','2024-10-31 14:02:35.306','2024-10-31 10:02:35.306'),('1373889b-19cd-40f6-8f23-37b7f95bcb0e',664,'','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_db740293-ae2a-40ae-9142-4d94ed66bcd5_SESS_1256ab02-5172-4a92-a17d-f2fc402290ac_TOSC_c9d5be37-9f50-45c6-8384-f43f10073bb8_SNAPS','','1373889b-19cd-40f6-8f23-37b7f95bcb0e','{\"displayTitle\":\"Maxilla 1.7.6.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,'2022-03-14 14:42:20.000','2021-05-05 15:56:32.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.259'),('1468c4b0-ae65-4fd5-aa19-3097eda12337',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_775311e4-a561-40c7-a2ce-76a0b1550be8/scan_449b7a19-bb82-4d6f-82b8-8bec06fa85d9/41_w1_o1_mandibule_screenshot_1468c4b0-ae65-4fd5-aa19-3097eda12337_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_775311e4-a561-40c7-a2ce-76a0b1550be8_BOSC_449b7a19-bb82-4d6f-82b8-8bec06fa85d9_SCREENS','41_w1_o1_mandibule_screenshot_1468c4b0-ae65-4fd5-aa19-3097eda12337_0.png','1468c4b0-ae65-4fd5-aa19-3097eda12337','{\"displayTitle\":\"Screenshot 1.41.1.1.1 Mandible 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Mandible 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-03 17:28:15.000','2024-10-31 14:02:32.161','2024-10-31 10:02:32.161'),('14d352f5-8d3b-486a-91ed-aa2fa3f126fd',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_406263f6-a620-460e-a1e0-2d50ff84809c/32_w1_o1_maxillaire_snapshot_0.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_TOSC_406263f6-a620-460e-a1e0-2d50ff84809c_SNAPS','32_w1_o1_maxillaire_snapshot_0.png','14d352f5-8d3b-486a-91ed-aa2fa3f126fd','{\"displayTitle\":\"Maxilla 1.32.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-23 16:23:24.000','2024-10-31 14:02:32.809','2024-10-31 10:02:32.809'),('1513be81-d643-4691-8d62-03dba8adbfe0',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_ef2b4fcf-f21c-418d-942a-c99ea96efbdb/occlusion_7d36e059-dbc3-46b0-931a-bdf8fdc805c6/scan_d94301ea-1f19-432a-a87d-bacbf222ca15/7_w2_o1_mandibule_scan_file_0.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_ef2b4fcf-f21c-418d-942a-c99ea96efbdb_SESS_7d36e059-dbc3-46b0-931a-bdf8fdc805c6_BOSC_d94301ea-1f19-432a-a87d-bacbf222ca15_MODEL','7_w2_o1_mandibule_scan_file_0.ply','1513be81-d643-4691-8d62-03dba8adbfe0','{\"displayTitle\":\"Mandibule 1.7.2.1.3\",\"modelMatrix\":\"-0.72214,-0.650949,0.234051,0,0.691747,-0.679549,0.244335,0,-9.23072e-9,0.338348,0.941021,0,25.666,-3.35127,-20.1327,1\",\"title\":\"Mandible PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-21 16:23:44.000','2024-10-31 14:02:26.248','2024-10-31 10:02:26.248'),('1533f780-2e51-421e-b17a-c49b5947d8ca',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_c90ddf83-1e94-4d7c-a61f-3f7bed3aad41/occlusion_5dac735e-358c-49a1-aa52-0180d8d8ff7e/scan_7ce9b1b8-7c7b-4655-bd0d-90f37ced345e/27_w2_o1_maxillaire_scan_file_2.zip','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_c90ddf83-1e94-4d7c-a61f-3f7bed3aad41_SESS_5dac735e-358c-49a1-aa52-0180d8d8ff7e_TOSC_7ce9b1b8-7c7b-4655-bd0d-90f37ced345e_MODEL','27_w2_o1_maxillaire_scan_file_2.zip','4ee64a77-ca4c-444b-9d9f-1eaea738c404','{\"displayTitle\":\"Maxilla 1.27.2.1.1\",\"modelMatrix\":\"0.0402542,0.982076,-0.184136,0,-0.999189,0.0395647,-0.00741826,0,1.47114e-10,0.184286,0.982873,0,17.5111,-27.163,-17.4832,1\",\"title\":\"Maxilla ZIP\"}','ZIP',2,'SYNCED',0,NULL,'2021-10-20 18:19:44.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.797'),('15343a6d-e281-4739-bed5-c0bfe5f8f6c7',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/occlusion_d7b86e87-0261-4bc1-8529-76e0bdd29195/scan_6d0c8022-e8b8-4ffa-8b31-ee9c8a811bb3/18_w4_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_LESC_6d0c8022-e8b8-4ffa-8b31-ee9c8a811bb3_SNAPS','18_w4_o1_mordu_posterieur_gauche_snapshot_0.png','15343a6d-e281-4739-bed5-c0bfe5f8f6c7','{\"displayTitle\":\"Posterior left bite 1.18.4.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-24 16:37:47.000','2024-10-31 14:02:33.124','2024-10-31 10:02:33.124'),('1574fe39-cb97-4341-97dd-0d8a2c9caaee',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_a72c11a4-05dc-4421-b252-fbfcecd2559e/order_d23524b1-d35b-4946-a69e-a2e7ff1d121e/14_w1_couronne_prost_file_0.pdf','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_a72c11a4-05dc-4421-b252-fbfcecd2559e_PROST_d23524b1-d35b-4946-a69e-a2e7ff1d121e_FORM','14_w1_couronne_prost_file_0.pdf','1574fe39-cb97-4341-97dd-0d8a2c9caaee','{\"displayTitle\":\"CROWN 1.14.1.2 CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-09-15 15:01:42.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.259'),('164f6864-87e7-433f-b775-f53c972ba906',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_669f6bca-452c-4b2e-a49e-aa822628ed5f/24_w1_o1_maxillaire_scan_file_2.ply','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_TOSC_669f6bca-452c-4b2e-a49e-aa822628ed5f_MODEL','24_w1_o1_maxillaire_scan_file_2.ply','5ea87deb-c530-4c0d-9e39-e94f351d1354','{\"displayTitle\":\"Maxilla 1.24.1.1.1\",\"modelMatrix\":\"-0.999944,-0.00980338,0.00389464,0,0.0105487,-0.929296,0.369186,0,-2.71848e-10,0.369207,0.929347,0,18.3073,1.2474,-25.4183,1\",\"title\":\"Maxilla PLY\"}','PLY',2,'SYNCED',0,NULL,'2021-09-13 21:10:32.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.790'),('1665ba5c-8084-4a22-84ab-72ef74043c9c',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/order_a91f29b5-c999-4d0b-90cf-4ff0df6707c8/37_w2_couronne_prost_file_1665ba5c-8084-4a22-84ab-72ef74043c9c_1.pdf','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_PROST_a91f29b5-c999-4d0b-90cf-4ff0df6707c8_FORM','37_w2_couronne_prost_file_1665ba5c-8084-4a22-84ab-72ef74043c9c_1.pdf','d69f7757-7418-40a0-93ba-f0daeab65592','{\"displayTitle\":\"ORDER 1.37.2.5 Elisabeth Baxter REDO CROWN\",\"title\":\"Couronne PDF\"}','PDF',1,'SYNCED',0,NULL,'2022-11-14 17:08:07.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.259'),('16b6b32b-ed98-4875-8f41-54c3aeed9650',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_bfe6249f-88b3-4a27-8f4c-5494e863352f/order_c155f94e-e0aa-488a-af25-8ada7a6a5b8a/10_w2_couronne_prost_file_0.ply','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_bfe6249f-88b3-4a27-8f4c-5494e863352f_SESS_fcabdff7-f4aa-41a0-8d3a-67e664f1d43e_RISC_11607af9-1606-48a7-8ad1-cabbd6bc16b5_MODEL','10_w2_couronne_prost_file_0.ply','16b6b32b-ed98-4875-8f41-54c3aeed9650','{\"displayTitle\":\"Posterior right bite 1.10.2.1.1\",\"modelMatrix\":\"0.968367,0.185187,0.118852,0,-0.204632,0.982401,-0.00774985,0,-0.146698,-0.0373472,0.993577,0,-0.414346,-6.12417,-17.2765,1\",\"title\":\"Posterior right bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-11-30 02:22:13.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.260'),('17229463-b96c-43ca-849e-59667acaa1a9',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_36d05387-51e6-4286-a074-7c7894c0622b/occlusion_0ec93b21-a91f-4695-a966-e072a8fb68e3/scan_5212b119-1f64-4de6-82e2-b5b72ee0e22b/7_w7_o1_maxillaire_scan_file_4.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_36d05387-51e6-4286-a074-7c7894c0622b_SESS_0ec93b21-a91f-4695-a966-e072a8fb68e3_TOSC_5212b119-1f64-4de6-82e2-b5b72ee0e22b_MODEL','7_w7_o1_maxillaire_scan_file_4.ply','7eedc56a-9ad1-4a49-b277-341ffab589ce','{\"displayTitle\":\"Maxilla 1.7.7.1.1\",\"modelMatrix\":\"-0.325962,-0.015658,0.945253,0,0.945383,-0.00539877,0.325917,0,1.81389e-10,0.999863,0.0165626,0,7.70919,-51.4044,5.0148,1\",\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":10,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1,\"title\":\"Maxilla PLY\"}','PLY',4,'SYNCED',0,NULL,'2021-05-05 17:45:31.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.274'),('17c8eb02-aa8e-47df-a126-46a753bf415e',664,'/var/.data/2022/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_7d40798f-7207-4c33-aa42-10afc814de77/scan_c5b26299-5fb8-4823-8b1a-c620bba14794/10_w1_o1_maxillaire_screenshot_17c8eb02-aa8e-47df-a126-46a753bf415e_0.png','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_TOSC_c5b26299-5fb8-4823-8b1a-c620bba14794_SCREENS','10_w1_o1_maxillaire_screenshot_17c8eb02-aa8e-47df-a126-46a753bf415e_0.png','17c8eb02-aa8e-47df-a126-46a753bf415e','{\"displayTitle\":\"Screenshot 1.10.1.1.1 Maxilla 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxilla 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 14:53:57.000','2024-10-31 14:02:32.346','2024-10-31 10:02:32.346'),('17e8834e-7343-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/46c4cd1e-7338-11ee-b011-58a023cda0dc/session_ecbd4537-7341-11ee-b011-58a023cda0dc/occlusion_ecbe814b-7341-11ee-b011-58a023cda0dc/scan_cc0c8ac4-7342-11ee-b011-58a023cda0dc/17e8834e-7343-11ee-b011-58a023cda0dc.zip','PATIENT_46c4cd1e-7338-11ee-b011-58a023cda0dc_ACT_ecbd4537-7341-11ee-b011-58a023cda0dc_SESS_ecbe814b-7341-11ee-b011-58a023cda0dc_FRSC_cc0c8ac4-7342-11ee-b011-58a023cda0dc_MODEL','17e8834e-7343-11ee-b011-58a023cda0dc.zip','17e8834e-7343-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Anterior bite 1.54.1.1.1\",\"modelMatrix\":\"0.890354,-0.0142117,0.405546,0,0.0967297,0.98999,-0.111311,0,-0.449066,0.142472,0.909235,0,0.174696,-4.41691,-24.8078,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-10-25 11:27:52.000','2023-10-30 13:47:02.643','2023-10-30 09:47:02.643'),('17e89282-7343-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/46c4cd1e-7338-11ee-b011-58a023cda0dc/session_ecbd4537-7341-11ee-b011-58a023cda0dc/occlusion_ecbe814b-7341-11ee-b011-58a023cda0dc/scan_cc0c8ac4-7342-11ee-b011-58a023cda0dc/17e89282-7343-11ee-b011-58a023cda0dc.png','PATIENT_46c4cd1e-7338-11ee-b011-58a023cda0dc_ACT_ecbd4537-7341-11ee-b011-58a023cda0dc_SESS_ecbe814b-7341-11ee-b011-58a023cda0dc_FRSC_cc0c8ac4-7342-11ee-b011-58a023cda0dc_SNAPS','17e89282-7343-11ee-b011-58a023cda0dc.png','17e89282-7343-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Anterior bite 1.54.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-10-25 11:27:53.000','2023-10-30 13:47:02.660','2023-10-30 09:47:02.660'),('17ff75c9-f72d-423c-a5b9-633100c3b8e5',664,'','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_PROST_e2c9a4f6-7174-4966-b244-648673c0bd6f_FORM','','46f88ef2-6c3e-4840-af4b-0cc2847372fa','{\"displayTitle\":\"ORDER 1.37.2.2 Elisabeth BaxterCROWN\",\"title\":\"Couronne PDF\"}','PDF',1,'CREATED',0,'2022-11-02 19:23:41.000','2022-11-02 18:56:51.000','2023-05-17 17:16:39.559',NULL),('185a70e3-8267-474e-aa32-a05eb5784fc8',664,'/var/.data/2022/664/635617fc-289b-470c-a4d4-678d7b5f275a/session_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6/occlusion_94dc9a16-b72c-4f6a-a520-ba83c28954c3/scan_6f12cbab-9aee-4057-bc58-bb6f63974204/45_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_635617fc-289b-470c-a4d4-678d7b5f275a_ACT_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6_SESS_94dc9a16-b72c-4f6a-a520-ba83c28954c3_RISC_6f12cbab-9aee-4057-bc58-bb6f63974204_SNAPS','45_w1_o1_mordu_posterieur_droit_snapshot_0.png','185a70e3-8267-474e-aa32-a05eb5784fc8','{\"displayTitle\":\"Posterior right bite 1.45.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-07 16:39:42.000','2024-10-31 14:02:35.080','2024-10-31 10:02:35.080'),('188b2bd0-af23-438c-b1c2-d75a6ce28b1c',664,'/var/.data/2022/664/48a38618-e853-4bf0-aa6b-4c83fb8b6f13/session_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d/order_98f23fdc-6e7d-411a-a2b5-b74bf1ad5f3c/38_w1_couronne_prost_file_188b2bd0-af23-438c-b1c2-d75a6ce28b1c_0.pdf','PATIENT_48a38618-e853-4bf0-aa6b-4c83fb8b6f13_ACT_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d_PROST_98f23fdc-6e7d-411a-a2b5-b74bf1ad5f3c_FORM','38_w1_couronne_prost_file_188b2bd0-af23-438c-b1c2-d75a6ce28b1c_0.pdf','188b2bd0-af23-438c-b1c2-d75a6ce28b1c','{\"displayTitle\":\"ORDER 1.38.1.1 CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-06-22 20:45:37.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.260'),('18cada8e-d04a-4eb7-8754-1c78819104c6',664,'/var/.data/2021/664/17cc8b8c-6280-4e69-ad1e-731bdd9819e0/session_f9cb9561-eacc-4b43-976b-dfa67a953a80/occlusion_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910/scan_30be6697-331a-4e7d-8bba-b11fc9ec90b9/19_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_17cc8b8c-6280-4e69-ad1e-731bdd9819e0_ACT_f9cb9561-eacc-4b43-976b-dfa67a953a80_SESS_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910_RISC_30be6697-331a-4e7d-8bba-b11fc9ec90b9_MODEL','19_w1_o1_mordu_posterieur_droit_scan_file_0.ply','18cada8e-d04a-4eb7-8754-1c78819104c6','{\"displayTitle\":\"Mordu posterieur droit 1.19.1.1.1\",\"modelMatrix\":\"0.901083,0.0482389,0.430078,0,-0.0493763,0.998027,0.0259097,0,-0.431022,-0.0428887,0.902459,0,-3.24503,-1.71031,-22.7723,1\",\"title\":\"Posterior right bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-09 19:47:07.000','2024-10-31 14:02:25.753','2024-10-31 10:02:25.753'),('18f54255-3e96-4924-b5d7-59e7498363b8',664,'/var/.data/2021/664/2217798a-4832-4e0d-9259-f8a836365b51/session_acaef63e-48f8-4a62-9c7d-a3b85544301c/occlusion_e7db4581-4a3d-448a-8e08-c12a27fa6201/scan_3d2db1ee-26fa-4508-8e14-b81d51746da7/9_w1_o1_maxillaire_scan_file_1.ply','PATIENT_2217798a-4832-4e0d-9259-f8a836365b51_ACT_acaef63e-48f8-4a62-9c7d-a3b85544301c_SESS_e7db4581-4a3d-448a-8e08-c12a27fa6201_TOSC_3d2db1ee-26fa-4508-8e14-b81d51746da7_MODEL','9_w1_o1_maxillaire_scan_file_1.ply','014c13a7-b107-4172-96fe-0e4f2cbfbf86','{\"displayTitle\":\"Maxillaire 1.9.1.1.1\",\"modelMatrix\":\"-0.405884,0.887127,-0.21969,0,-0.913924,-0.393983,0.0975668,0,-2.26653e-9,0.240381,0.970679,0,-4.4202,-38.2416,-13.8035,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',1,'SYNCED',0,NULL,'2020-06-11 22:36:13.000','2024-10-31 14:02:26.150','2024-10-31 10:02:26.150'),('19447343-7012-4518-98de-fd28c421573a',664,'/var/.data/2021/664/2217798a-4832-4e0d-9259-f8a836365b51/session_acaef63e-48f8-4a62-9c7d-a3b85544301c/occlusion_e7db4581-4a3d-448a-8e08-c12a27fa6201/scan_3d2db1ee-26fa-4508-8e14-b81d51746da7/9_w1_o1_maxillaire_snapshot_1.png','PATIENT_2217798a-4832-4e0d-9259-f8a836365b51_ACT_acaef63e-48f8-4a62-9c7d-a3b85544301c_SESS_e7db4581-4a3d-448a-8e08-c12a27fa6201_TOSC_3d2db1ee-26fa-4508-8e14-b81d51746da7_SNAPS','9_w1_o1_maxillaire_snapshot_1.png','221a5570-efe6-429e-9776-53dba6f16e35','{\"displayTitle\":\"Maxillaire 1.9.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2020-06-11 22:36:13.000','2024-10-31 14:02:26.167','2024-10-31 10:02:26.167'),('19cb4f51-a238-48cd-87f4-4a467eff9b55',664,'/var/.data/2022/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_d3696b3d-0728-4822-b89d-631e2ab774a4/occlusion_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6/scan_ec2d4010-6686-4b96-af72-0ece2b145c0d/14_w2_o1_maxillaire_screenshot_19cb4f51-a238-48cd-87f4-4a467eff9b55_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_d3696b3d-0728-4822-b89d-631e2ab774a4_SESS_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6_TOSC_ec2d4010-6686-4b96-af72-0ece2b145c0d_SCREENS','14_w2_o1_maxillaire_screenshot_19cb4f51-a238-48cd-87f4-4a467eff9b55_0.png','19cb4f51-a238-48cd-87f4-4a467eff9b55','{\"displayTitle\":\"Screenshot 1.14.2.1.1 Maxilla 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxilla 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:01:24.000','2024-10-31 14:02:32.554','2024-10-31 10:02:32.554'),('19eba3d6-6c36-11ee-bc7f-58a023cda0dc',664,'/var/.data/2023/664/bbc77872-6c30-11ee-bc7f-58a023cda0dc/session_0a963705-6c31-11ee-bc7f-58a023cda0dc/occlusion_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc/scan_041ad44a-6c35-11ee-bc7f-58a023cda0dc/19eba3d6-6c36-11ee-bc7f-58a023cda0dc.zip','PATIENT_bbc77872-6c30-11ee-bc7f-58a023cda0dc_ACT_0a963705-6c31-11ee-bc7f-58a023cda0dc_SESS_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc_BOSC_041ad44a-6c35-11ee-bc7f-58a023cda0dc_MODEL','19eba3d6-6c36-11ee-bc7f-58a023cda0dc.zip','9122eeb5-6c35-11ee-bc7f-58a023cda0dc','{\"displayTitle\":\"Mandible 1.53.1.1.2\",\"modelMatrix\":\"0.746408,0.596139,-0.295792,0,-0.665488,0.668627,-0.331758,0,2.2026e-08,0.444473,0.895792,0,-25.0958,-13.8824,-19.4923,1\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2023-10-16 13:05:16.000','2023-10-16 17:12:49.301','2023-10-16 13:12:49.301'),('19ec321c-6c36-11ee-bc7f-58a023cda0dc',664,'/var/.data/2023/664/bbc77872-6c30-11ee-bc7f-58a023cda0dc/session_0a963705-6c31-11ee-bc7f-58a023cda0dc/occlusion_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc/scan_041ad44a-6c35-11ee-bc7f-58a023cda0dc/19ec321c-6c36-11ee-bc7f-58a023cda0dc.png','PATIENT_bbc77872-6c30-11ee-bc7f-58a023cda0dc_ACT_0a963705-6c31-11ee-bc7f-58a023cda0dc_SESS_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc_BOSC_041ad44a-6c35-11ee-bc7f-58a023cda0dc_SNAPS','19ec321c-6c36-11ee-bc7f-58a023cda0dc.png','9122ff07-6c35-11ee-bc7f-58a023cda0dc','{\"displayTitle\":\"Mandible 1.53.1.1.2 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-10-16 13:05:17.000','2023-10-16 17:12:49.319','2023-10-16 13:12:49.319'),('19fc4871-95bf-400b-a326-3494a92d5dba',664,'/var/.data/2022/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_00cdb0d1-c7e4-41bc-93a4-7c29a6f1cf58/occlusion_324dac1a-95fa-44d5-b054-88f048931106/scan_4fee66f9-724e-4496-aae8-922ee35cabf6/29_w1_o1_mandibule_scan_file_0.zip','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_00cdb0d1-c7e4-41bc-93a4-7c29a6f1cf58_SESS_324dac1a-95fa-44d5-b054-88f048931106_BOSC_4fee66f9-724e-4496-aae8-922ee35cabf6_MODEL','29_w1_o1_mandibule_scan_file_0.zip','19fc4871-95bf-400b-a326-3494a92d5dba','{\"displayTitle\":\"Mandible 1.29.1.1.4\",\"modelMatrix\":\"0.474886,0.834299,-0.280051,0,-0.880047,0.4502,-0.15112,0,-7.70295e-09,0.318223,0.948016,0,-27.8832,-8.30723,-19.9038,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-14 16:02:28.000','2024-10-31 14:02:28.726','2024-10-31 10:02:28.726'),('1a2dc7bc-4e9d-498a-a92c-47648f21638e',664,'','PATIENT_e33159c9-a713-4a37-ba98-9ec2e2e213e7_ACT_b63ca765-4d68-4cf4-9707-4ad3a19f3236_SESS_ae7f89c9-26ec-4cee-b377-d5145e6c6aae_TOSC_d5c1d30b-d8a4-4e8f-aae4-1e8dd2cb3dcb_SNAPS','50_w1_o1_maxillaire_snapshot_0.png','1a2dc7bc-4e9d-498a-a92c-47648f21638e','{\"displayTitle\":\"Maxilla 1.50.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:05:41.000','2022-11-14 11:17:37.000','2024-10-31 14:02:36.147','2024-10-31 10:02:36.147'),('1b1a8a57-1029-46b5-a7be-4571a989667f',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_51374b44-d221-416c-8eb3-cf931ed89632/occlusion_8b5d08e1-2513-416b-87f9-350cab840a3d/scan_3e328cc1-9830-466d-a33e-fbe74a2dbdae/37_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_51374b44-d221-416c-8eb3-cf931ed89632_SESS_8b5d08e1-2513-416b-87f9-350cab840a3d_LESC_3e328cc1-9830-466d-a33e-fbe74a2dbdae_SNAPS','37_w1_o1_mordu_posterieur_gauche_snapshot_0.png','1b1a8a57-1029-46b5-a7be-4571a989667f','{\"displayTitle\":\"Posterior left bite 1.37.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-22 15:48:08.000','2024-10-31 14:02:29.778','2024-10-31 10:02:29.778'),('1b9fcd61-76d3-43bc-9436-552fe11a8a71',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_21bbefd5-8dc0-4e41-91d8-718463ad469c/scan_44749597-6cc6-493d-a2aa-76486e3c8416/41_w1_o3_mandibule_snapshot_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_BOSC_44749597-6cc6-493d-a2aa-76486e3c8416_SNAPS','41_w1_o3_mandibule_snapshot_0.png','1b9fcd61-76d3-43bc-9436-552fe11a8a71','{\"displayTitle\":\"Mandible 1.41.1.3.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-03 16:02:30.000','2024-10-31 14:02:32.078','2024-10-31 10:02:32.078'),('1c213c23-3396-431a-93b8-19834923ceac',664,'','PATIENT_11ec40e4-4579-4185-9fcf-4e1aac06f554_ACT_8f44bea9-b7e9-45c8-a098-f3b18f9be730_SESS_7348646e-cf7a-460b-aba9-d56ad656689e_TOSC_d3d5ecdb-7933-478d-8f71-7bc13b2a4a05_SNAPS','25_w1_o1_maxillaire_snapshot_0.png','1c213c23-3396-431a-93b8-19834923ceac','{\"displayTitle\":\"Maxilla 1.25.1.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:05:42.000','2021-09-14 11:55:41.000','2024-10-31 14:02:25.499','2024-10-31 10:02:25.499'),('1ca966ee-f717-4668-9ce5-c95a9a20eaff',664,'/var/.data/2022/664/685697a1-0d50-4a06-8b3e-729cf9750f38/session_e1d214d2-2b62-484c-8ede-86b3f84573d3/occlusion_8cd0c724-d3d0-4821-a88b-42b03ae4eb07/scan_101a958b-c6e0-45d2-be43-01921415b27e/48_w1_o1_mandibule_scan_file_0.zip','PATIENT_685697a1-0d50-4a06-8b3e-729cf9750f38_ACT_e1d214d2-2b62-484c-8ede-86b3f84573d3_SESS_8cd0c724-d3d0-4821-a88b-42b03ae4eb07_BOSC_101a958b-c6e0-45d2-be43-01921415b27e_MODEL','48_w1_o1_mandibule_scan_file_0.zip','1ca966ee-f717-4668-9ce5-c95a9a20eaff','{\"displayTitle\":\"Mandible 1.48.1.1.1\",\"modelMatrix\":\"0.67898,0.703321,-0.210536,0,-0.734157,0.650462,-0.194713,0,-1.35051e-09,0.286772,0.957999,0,-3.74303,-39.2879,-14.6098,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-10-17 16:56:55.000','2024-10-31 14:02:35.297','2024-10-31 10:02:35.297'),('1d036ddb-23c4-41ee-b7b1-3df941a91192',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_120f9fe3-b23d-49c7-89ab-f1becc102f6c/scan_c3b55ffe-4305-4af0-829c-88fb2866ef2a/33_w1_o1_maxillaire_scan_file_0.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_120f9fe3-b23d-49c7-89ab-f1becc102f6c_TOSC_c3b55ffe-4305-4af0-829c-88fb2866ef2a_MODEL','33_w1_o1_maxillaire_scan_file_0.zip','1d036ddb-23c4-41ee-b7b1-3df941a91192','{\"displayTitle\":\"Maxilla 1.33.1.1.2\",\"modelMatrix\":\"-0.611544,0.758253,-0.225979,0,-0.79121,-0.586071,0.174664,0,-8.32104e-09,0.285612,0.958345,0,11.7649,-15.4993,-17.8697,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-04-11 17:03:19.000','2024-10-31 14:02:29.046','2024-10-31 10:02:29.046'),('1d1d42ef-8d24-471c-8afb-6c0256487d0c',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/order_c94feabc-c456-485b-b538-c3a58bce9798/18_w4_couronne_sur_implant_prost_file_1d1d42ef-8d24-471c-8afb-6c0256487d0c_1.pdf','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_PROST_c94feabc-c456-485b-b538-c3a58bce9798_FORM','18_w4_couronne_sur_implant_prost_file_1d1d42ef-8d24-471c-8afb-6c0256487d0c_1.pdf','c12d2c0a-871d-48e9-b3de-bc4c3e6cdc17','{\"displayTitle\":\"ORDER 1.18.4.2 IMPLANT CROWN BIYOUNG ANDRE\",\"title\":\"Couronne sur Implant PDF\"}','PDF',1,'SYNCED',0,NULL,'2022-09-12 18:33:12.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.262'),('1d98fd52-591a-40fc-8de1-36a02f534a6f',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_955946be-5764-4c34-9e84-61682f4fdf78/occlusion_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d/scan_714348f7-0720-4a1c-bebb-c0807d687feb/33_w2_o1_mandibule_snapshot_0.png','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_BOSC_714348f7-0720-4a1c-bebb-c0807d687feb_SNAPS','33_w2_o1_mandibule_snapshot_0.png','1d98fd52-591a-40fc-8de1-36a02f534a6f','{\"displayTitle\":\"Mandible 1.33.2.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-01 15:22:14.000','2024-10-31 14:02:31.760','2024-10-31 10:02:31.760'),('1d9c8ed2-a1f5-4432-9956-4822381e8a4b',664,'/var/.data/2022/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_705960fa-3ed4-4013-9cde-20022721d122/occlusion_9f4fa7cb-81a3-460e-b189-ba76eb8cee15/scan_c25edbb6-50b0-4c96-8756-63dca8532242/7_w8_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_705960fa-3ed4-4013-9cde-20022721d122_SESS_9f4fa7cb-81a3-460e-b189-ba76eb8cee15_RISC_c25edbb6-50b0-4c96-8756-63dca8532242_SNAPS','7_w8_o1_mordu_posterieur_droit_snapshot_0.png','1d9c8ed2-a1f5-4432-9956-4822381e8a4b','{\"displayTitle\":\"Posterior right bite 1.7.8.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-30 17:15:54.000','2024-10-31 14:02:28.966','2024-10-31 10:02:28.966'),('1e09f189-8cf5-4779-8b20-93354ae9b869',664,'/var/.data/2022/664/48a38618-e853-4bf0-aa6b-4c83fb8b6f13/session_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d/occlusion_540d878b-7415-4498-8c6c-01875eec35f8/scan_d68295a5-6905-4f30-bc58-3732946b2594/38_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_48a38618-e853-4bf0-aa6b-4c83fb8b6f13_ACT_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d_SESS_540d878b-7415-4498-8c6c-01875eec35f8_LESC_d68295a5-6905-4f30-bc58-3732946b2594_MODEL','38_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','1e09f189-8cf5-4779-8b20-93354ae9b869','{\"displayTitle\":\"Posterior left bite 1.38.1.1.1\",\"modelMatrix\":\"-0.994174,-0.0980622,0.050037,0,0.1017,-0.982129,0.160569,0,0.03591,0.160731,0.985766,0,8.36658,-4.98397,-17.0096,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-22 16:46:04.000','2024-10-31 14:02:29.831','2024-10-31 10:02:29.831'),('1e42d75c-0ebd-4920-8a72-fbe3b1044908',664,'','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_775311e4-a561-40c7-a2ce-76a0b1550be8_TOSC_a7098a82-daaf-4ad2-a4b6-803796e5351b_MODEL','','1e42d75c-0ebd-4920-8a72-fbe3b1044908','{\"displayTitle\":\"Maxilla 1.41.1.1.1\",\"modelMatrix\":\"0.563692,0.788977,-0.24447,0,-0.825985,0.538437,-0.166838,0,-7.458e-09,0.295974,0.955196,0,-10.4101,-19.7769,-17.3194,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'CREATED',0,'2022-07-28 15:30:03.000','2022-07-28 15:06:25.000','2023-05-17 17:16:39.559',NULL),('1eb51e86-e26b-4152-910f-ae2c5f7866a1',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/occlusion_cacc103c-8b88-4be5-a787-b6b92341e9eb/scan_d430aee6-4975-49d0-b4c3-b096e99e797e/34_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_SESS_cacc103c-8b88-4be5-a787-b6b92341e9eb_FRSC_d430aee6-4975-49d0-b4c3-b096e99e797e_SNAPS','34_w1_o1_mordu_anterieur_snapshot_0.png','1eb51e86-e26b-4152-910f-ae2c5f7866a1','{\"displayTitle\":\"Anterior bite 1.34.1.1.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-05-25 18:02:50.000','2024-10-31 14:02:29.326','2024-10-31 10:02:29.326'),('1f5190dd-0c64-4ab2-9707-5e552da58bd7',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_120f9fe3-b23d-49c7-89ab-f1becc102f6c/scan_a6440940-a668-4e8f-be35-82ce928f701e/33_w1_o1_mordu_posterieur_droit_snapshot_1.png','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_120f9fe3-b23d-49c7-89ab-f1becc102f6c_RISC_a6440940-a668-4e8f-be35-82ce928f701e_SNAPS','33_w1_o1_mordu_posterieur_droit_snapshot_1.png','4c449c81-cd1f-492e-b12f-03afe35bc557','{\"displayTitle\":\"Posterior right bite 1.33.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-04-11 17:13:42.000','2024-10-31 14:02:29.073','2024-10-31 10:02:29.073'),('1f5ccddd-9466-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/1f5ccddd-9466-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_MODEL','1f5ccddd-9466-11ee-8fd8-58a023cda0dc.zip','87a0d07a-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1\",\"modelMatrix\":\"0.843881,0.502692,-0.187524,0,-0.53653,0.790659,-0.294947,0,3.33011e-09,0.349512,0.936932,0,-21.678,-3.20968,-22.8257,1\",\"scanBodies\":[]}','ZIP',8,'SYNCED',0,NULL,'2023-12-06 13:34:42.881','2023-12-06 19:12:08.103','2023-12-11 10:12:11.279'),('2017979f-f521-45d1-992d-e51f8b190f71',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_7d87c990-cfc0-487a-bd48-674f0ba32da1/27_w1_o1_mandibule_scan_file_5.zip','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_BOSC_7d87c990-cfc0-487a-bd48-674f0ba32da1_MODEL','27_w1_o1_mandibule_scan_file_5.zip','3119c4df-3760-4f4f-9247-8c1f5f4d8d43','{\"displayTitle\":\"Mandibule 1.27.1.1.1\",\"modelMatrix\":\"0.94286,0.313256,-0.113511,0,-0.333188,0.886457,-0.321216,0,-6.96394e-9,0.340683,0.940178,0,-25.6432,1.21329,-18.5297,1\",\"title\":\"Mandible ZIP\"}','ZIP',5,'SYNCED',0,NULL,'2021-10-04 19:04:06.000','2024-10-31 14:02:26.831','2024-10-31 10:02:26.831'),('20936b0c-07dc-4bae-83c4-55c68539ae5c',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/occlusion_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e/scan_6d53d83a-50bf-4b07-a6c4-377e6be410b9/49_w1_o1_maxillaire_snapshot_0.png','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_TOSC_6d53d83a-50bf-4b07-a6c4-377e6be410b9_SNAPS','49_w1_o1_maxillaire_snapshot_0.png','20936b0c-07dc-4bae-83c4-55c68539ae5c','{\"displayTitle\":\"Maxilla 1.49.1.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-10-31 17:30:53.000','2024-10-31 14:02:36.243','2024-10-31 10:02:36.243'),('212de007-9a7d-46d7-88bb-dfd2fc9e1422',664,'/var/.data/2022/664/9bcfd1e2-10fc-4838-92c0-84057ad52bfe/session_21c82035-4359-4880-96f0-c80e94ed36f8/occlusion_b9c2b952-8d0a-4eac-ad77-2acda79cff8c/scan_4597ad8c-2f54-4ecd-827f-911125d72cc9/43_w1_o1_maxillaire_snapshot_0.png','PATIENT_9bcfd1e2-10fc-4838-92c0-84057ad52bfe_ACT_21c82035-4359-4880-96f0-c80e94ed36f8_SESS_b9c2b952-8d0a-4eac-ad77-2acda79cff8c_TOSC_4597ad8c-2f54-4ecd-827f-911125d72cc9_SNAPS','43_w1_o1_maxillaire_snapshot_0.png','212de007-9a7d-46d7-88bb-dfd2fc9e1422','{\"displayTitle\":\"Maxilla 1.43.1.1.3\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-17 18:39:32.000','2024-10-31 14:02:32.217','2024-10-31 10:02:32.217'),('2142e79a-5c20-4b84-ae6f-30da94d6f22f',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_26288707-da63-4165-bfdb-8a6c299bcb2b/scan_73765dbb-1926-4aed-8b7f-3202e1e68aa2/33_w1_o2_mandibule_snapshot_0.png','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_26288707-da63-4165-bfdb-8a6c299bcb2b_BOSC_73765dbb-1926-4aed-8b7f-3202e1e68aa2_SNAPS','33_w1_o2_mandibule_snapshot_0.png','2142e79a-5c20-4b84-ae6f-30da94d6f22f','{\"displayTitle\":\"Mandible 1.33.1.2.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-04-11 17:21:35.000','2024-10-31 14:02:29.126','2024-10-31 10:02:29.126'),('219a577b-6c2c-440a-ae7a-4bc501aa7a43',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368/32_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_LESC_8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368_MODEL','32_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','82a6efdf-566e-4983-8345-bb07a5434fce','{\"displayTitle\":\"Posterior left bite 1.32.1.1.1\",\"modelMatrix\":\"-0.944746,0.144778,0.305379,0,-0.16647,-0.971133,-0.146196,0,0.283953,-0.191962,0.940963,0,16.0105,-0.191379,-27.2682,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-03-23 16:42:18.000','2024-10-31 14:02:32.968','2024-10-31 10:02:32.968'),('221a5570-efe6-429e-9776-53dba6f16e35',664,'/var/.data/2021/664/2217798a-4832-4e0d-9259-f8a836365b51/session_acaef63e-48f8-4a62-9c7d-a3b85544301c/occlusion_e7db4581-4a3d-448a-8e08-c12a27fa6201/scan_3d2db1ee-26fa-4508-8e14-b81d51746da7/9_w1_o1_maxillaire_snapshot_0.png','PATIENT_2217798a-4832-4e0d-9259-f8a836365b51_ACT_acaef63e-48f8-4a62-9c7d-a3b85544301c_SESS_e7db4581-4a3d-448a-8e08-c12a27fa6201_TOSC_3d2db1ee-26fa-4508-8e14-b81d51746da7_SNAPS','9_w1_o1_maxillaire_snapshot_0.png','221a5570-efe6-429e-9776-53dba6f16e35','{\"displayTitle\":\"Occlusion Mandible 1.9.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-06-11 22:29:39.000','2024-10-31 14:02:26.159','2024-10-31 10:02:26.159'),('2262f65a-71dd-48bd-b8b8-698a6187dccc',664,'/var/.data/2022/664/cede029c-15bc-44c2-9c9c-fac7f8983524/session_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29/occlusion_4d46a627-5949-4b2a-b4d6-c391f159485b/scan_fe5df0bd-7cd7-42f8-ba75-4278d329b237/46_w1_o1_mandibule_snapshot_0.png','PATIENT_cede029c-15bc-44c2-9c9c-fac7f8983524_ACT_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29_SESS_4d46a627-5949-4b2a-b4d6-c391f159485b_BOSC_fe5df0bd-7cd7-42f8-ba75-4278d329b237_SNAPS','46_w1_o1_mandibule_snapshot_0.png','2262f65a-71dd-48bd-b8b8-698a6187dccc','{\"displayTitle\":\"Mandible 1.46.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-12 20:32:10.000','2024-10-31 14:02:35.132','2024-10-31 10:02:35.132'),('2271f9bf-12c8-4420-b9f4-ce7ac01d3567',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/occlusion_d7b86e87-0261-4bc1-8529-76e0bdd29195/scan_d43bd9e0-44ee-49ed-aa89-8bcd9837b34a/18_w4_o1_mordu_anterieur_scan_file_0.zip','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_FRSC_d43bd9e0-44ee-49ed-aa89-8bcd9837b34a_MODEL','18_w4_o1_mordu_anterieur_scan_file_0.zip','2271f9bf-12c8-4420-b9f4-ce7ac01d3567','{\"displayTitle\":\"Anterior bite 1.18.4.1.1\",\"modelMatrix\":\"0.874136,0.00998988,0.464941,0,0.0416732,0.995058,-0.0970287,0,-0.484496,0.0989366,0.880352,0,-2.91285,-3.60774,-32.1458,1\",\"title\":\"Anterior bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-24 16:41:49.000','2023-05-22 13:09:23.104','2023-05-22 09:09:23.104'),('22722603-2c83-4ed0-858c-6d2be0ae48a9',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_d3696b3d-0728-4822-b89d-631e2ab774a4/occlusion_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6/scan_1fad60ca-f3ea-48a3-b845-fcd52ee435b5/14_w2_o1_mandibule_snapshot_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_d3696b3d-0728-4822-b89d-631e2ab774a4_SESS_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6_BOSC_1fad60ca-f3ea-48a3-b845-fcd52ee435b5_SNAPS','14_w2_o1_mandibule_snapshot_0.png','22722603-2c83-4ed0-858c-6d2be0ae48a9','{\"displayTitle\":\"Mandibule 1.14.2.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-11-30 02:14:43.000','2024-10-31 14:02:32.724','2024-10-31 10:02:32.724'),('228b24fc-bc5e-4533-a442-ce3fb1eda0c7',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/order_16e355a3-b14e-430a-923b-9a23341e2aa3/49_w1_couronne_sur_implant_prost_file_228b24fc-bc5e-4533-a442-ce3fb1eda0c7_0.pdf','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_PROST_16e355a3-b14e-430a-923b-9a23341e2aa3_FORM','49_w1_couronne_sur_implant_prost_file_228b24fc-bc5e-4533-a442-ce3fb1eda0c7_0.pdf','228b24fc-bc5e-4533-a442-ce3fb1eda0c7','{\"displayTitle\":\"ORDER 1.49.1.2 IMPLANT CROWN ANT CROWN(Carol,Burroughts)\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'CREATED',0,'2022-11-22 18:42:35.000','2022-11-16 22:17:11.000','2023-05-17 17:16:39.559',NULL),('228f68b7-dfd6-4b5a-814c-5c7b969e2de7',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_7d87c990-cfc0-487a-bd48-674f0ba32da1/27_w1_o1_mandibule_scan_file_4.zip','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_BOSC_7d87c990-cfc0-487a-bd48-674f0ba32da1_MODEL','27_w1_o1_mandibule_scan_file_4.zip','3119c4df-3760-4f4f-9247-8c1f5f4d8d43','{\"displayTitle\":\"Mandible 1.27.1.1.1\",\"modelMatrix\":\"0.898543,0.410622,-0.154952,0,-0.438885,0.840678,-0.317237,0,1.20127e-8,0.353057,0.935602,0,-26.9978,-1.85321,-17.654,1\",\"title\":\"Mandible ZIP\"}','ZIP',4,'SYNCED',0,NULL,'2021-10-04 19:01:34.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.263'),('231fd3a6-6aa1-481c-84e8-fb456bdbae59',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_70b1bf4b-a08d-4b96-9200-6648114f1bcd/37_w2_o1_maxillaire_scan_file_0.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_TOSC_70b1bf4b-a08d-4b96-9200-6648114f1bcd_MODEL','37_w2_o1_maxillaire_scan_file_0.zip','231fd3a6-6aa1-481c-84e8-fb456bdbae59','{\"displayTitle\":\"Maxilla 1.37.2.1.1\",\"modelMatrix\":\"-0.269797,0.865903,-0.421214,0,-0.962917,-0.242615,0.118019,0,4.00652e-09,0.437436,0.89925,0,11.5719,-28.9186,-12.6981,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-10-19 19:30:04.000','2024-10-31 14:02:35.379','2024-10-31 10:02:35.379'),('23d0f00e-28e6-4e95-acb1-832d1d3440c2',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_775311e4-a561-40c7-a2ce-76a0b1550be8/scan_449b7a19-bb82-4d6f-82b8-8bec06fa85d9/41_w1_o1_mandibule_scan_file_0.zip','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_775311e4-a561-40c7-a2ce-76a0b1550be8_BOSC_449b7a19-bb82-4d6f-82b8-8bec06fa85d9_MODEL','41_w1_o1_mandibule_scan_file_0.zip','23d0f00e-28e6-4e95-acb1-832d1d3440c2','{\"displayTitle\":\"Mandible 1.41.1.1.1\",\"modelMatrix\":\"-0.977298,0.211712,-0.00813221,0,-0.211869,-0.976578,0.0375119,0,3.71418e-10,0.0383833,0.999263,0,18.2111,-6.323,-19.3809,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-07-28 15:08:57.000','2024-10-31 14:02:32.169','2024-10-31 10:02:32.169'),('240221f6-6e8b-47b5-a556-7958b41a92cf',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_26288707-da63-4165-bfdb-8a6c299bcb2b/scan_73765dbb-1926-4aed-8b7f-3202e1e68aa2/33_w1_o2_mandibule_scan_file_0.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_26288707-da63-4165-bfdb-8a6c299bcb2b_BOSC_73765dbb-1926-4aed-8b7f-3202e1e68aa2_MODEL','33_w1_o2_mandibule_scan_file_0.zip','240221f6-6e8b-47b5-a556-7958b41a92cf','{\"displayTitle\":\"Mandible 1.33.1.2.1\",\"modelMatrix\":\"0.993645,0.109282,-0.0269731,0,-0.112562,0.964694,-0.238107,0,1.32145e-10,0.23963,0.970864,0,-18.3193,-5.56791,-19.978,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-04-11 17:21:35.000','2024-10-31 14:02:29.135','2024-10-31 10:02:29.135'),('24899f86-5dcc-4bdc-b6e0-afcf01d853e6',664,'/var/.data/2022/664/48a38618-e853-4bf0-aa6b-4c83fb8b6f13/session_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d/occlusion_540d878b-7415-4498-8c6c-01875eec35f8/scan_d68295a5-6905-4f30-bc58-3732946b2594/38_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_48a38618-e853-4bf0-aa6b-4c83fb8b6f13_ACT_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d_SESS_540d878b-7415-4498-8c6c-01875eec35f8_LESC_d68295a5-6905-4f30-bc58-3732946b2594_SNAPS','38_w1_o1_mordu_posterieur_gauche_snapshot_0.png','24899f86-5dcc-4bdc-b6e0-afcf01d853e6','{\"displayTitle\":\"Posterior left bite 1.38.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-22 16:46:03.000','2024-10-31 14:02:29.841','2024-10-31 10:02:29.841'),('248f95a0-ad8d-40f1-bf9e-68ceaee0d7ba',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_6630e34a-9b19-4727-9ef0-e1c95c341549/scan_5d0e6d2d-490c-4381-a794-dd7121de4a60/44_w1_o1_maxillaire_scan_file_1.zip','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_6630e34a-9b19-4727-9ef0-e1c95c341549_TOSC_5d0e6d2d-490c-4381-a794-dd7121de4a60_MODEL','44_w1_o1_maxillaire_scan_file_1.zip','0522def8-f55f-4a8d-8758-a81209e06ef3','{\"displayTitle\":\"Maxilla 1.44.1.1.1\",\"modelMatrix\":\"0.67542,0.733978,-0.0712996,0,-0.737433,0.672256,-0.0653038,0,-3.60036e-09,0.0966862,0.995315,0,-5.22217,-17.8852,-20.4243,1\",\"title\":\"Maxilla ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-09-07 15:04:16.000','2024-10-31 14:02:33.203','2024-10-31 10:02:33.203'),('24d8debb-2e9c-4604-a943-eb78950b16e5',664,'','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_LIFIM','37_w2_o2_mandibule_mlmeta_0_0.bin','24d8debb-2e9c-4604-a943-eb78950b16e5','{\"displayTitle\":\"Margin line Mandible 1.37.2.2.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2023-05-22 09:05:51.000','2022-11-09 11:00:20.000','2024-10-31 14:02:36.037','2024-10-31 10:02:36.037'),('251d4d60-3227-4d38-a340-1f2d10787aa5',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_79842b46-a1df-43a9-812e-4322f1c79203/21_w1_o1_mordu_anterieur_snapshot_1.png','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_FRSC_79842b46-a1df-43a9-812e-4322f1c79203_SNAPS','21_w1_o1_mordu_anterieur_snapshot_1.png','4638f023-e672-4b5e-a3af-423e20a747d7','{\"displayTitle\":\"Mordu anterieur 1.21.1.1.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-04-28 19:02:47.000','2024-10-31 14:02:26.016','2024-10-31 10:02:26.016'),('25cf2022-f971-4fc1-8f62-e12d40279ada',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_eff3d296-ab91-4054-b8d3-6c78732ae1c8/21_w1_o1_maxillaire_snapshot_0.png','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_TOSC_eff3d296-ab91-4054-b8d3-6c78732ae1c8_SNAPS','21_w1_o1_maxillaire_snapshot_0.png','25cf2022-f971-4fc1-8f62-e12d40279ada','{\"displayTitle\":\"Maxillaire 1.21.1.1.4\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-28 18:51:56.000','2024-10-31 14:02:25.964','2024-10-31 10:02:25.964'),('262fff38-dd7b-4940-ac0a-a2a7e1645e65',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_48ff9245-20c5-4364-a092-18eafb8024d3/scan_663b4cd8-e704-4cb6-ab8f-80ec41ed1370/10_w1_o2_mandibule_scan_file_0.ply','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_48ff9245-20c5-4364-a092-18eafb8024d3_BOSC_663b4cd8-e704-4cb6-ab8f-80ec41ed1370_MODEL','10_w1_o2_mandibule_scan_file_0.ply','262fff38-dd7b-4940-ac0a-a2a7e1645e65','{\"displayTitle\":\"Mandibule 1.10.1.2.1\",\"modelMatrix\":\"0.87699,0.439756,-0.193654,0,-0.480508,0.802614,-0.353445,0,1.03459e-10,0.40302,0.915191,0,-12.7456,-13.363,-15.4725,1\",\"title\":\"Mandible PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-09-16 19:04:13.000','2024-10-31 14:02:25.696','2024-10-31 10:02:25.696'),('26383578-97b4-469c-83c8-1399e6fdf5c9',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_7d40798f-7207-4c33-aa42-10afc814de77/scan_c5b26299-5fb8-4823-8b1a-c620bba14794/10_w1_o1_maxillaire_scan_file_0.ply','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_TOSC_c5b26299-5fb8-4823-8b1a-c620bba14794_MODEL','10_w1_o1_maxillaire_scan_file_0.ply','26383578-97b4-469c-83c8-1399e6fdf5c9','{\"displayTitle\":\"Maxillaire 1.10.1.1.1\",\"modelMatrix\":\"0.0127066,0.999724,-0.0197775,0,-0.999919,0.0127042,-0.000251325,0,-2.13225e-11,0.019779,0.999804,0,3.31358,-19.0094,-22.8629,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-06-29 19:55:41.000','2024-10-31 14:02:32.354','2024-10-31 10:02:32.354'),('2638acc5-b813-46b6-9bd3-30e06d514d23',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/occlusion_e930782a-e2db-43e8-9ff1-9feb64e20e4e/scan_a8bc827c-e0a5-47f0-9a65-02d941ee82ab/35_w1_o1_mandibule_scan_file_0.zip','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_BOSC_a8bc827c-e0a5-47f0-9a65-02d941ee82ab_MODEL','35_w1_o1_mandibule_scan_file_0.zip','2638acc5-b813-46b6-9bd3-30e06d514d23','{\"displayTitle\":\"Mandible 1.35.1.1.3\",\"modelMatrix\":\"0.692504,0.607025,-0.389819,0,-0.721414,0.582699,-0.374198,0,7.4818e-10,0.540354,0.841438,0,-27.4423,-9.65133,-14.0335,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-06 20:31:57.000','2024-10-31 14:02:29.488','2024-10-31 10:02:29.488'),('2642f6d1-6c3f-4add-9a49-f8de19a8acfd',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_6630e34a-9b19-4727-9ef0-e1c95c341549/scan_5d0e6d2d-490c-4381-a794-dd7121de4a60/44_w1_o1_maxillaire_snapshot_1.png','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_6630e34a-9b19-4727-9ef0-e1c95c341549_TOSC_5d0e6d2d-490c-4381-a794-dd7121de4a60_SNAPS','44_w1_o1_maxillaire_snapshot_1.png','4ad4e90c-75f1-4e2d-b3b2-e8b08e1524ab','{\"displayTitle\":\"Maxilla 1.44.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-09-07 15:04:15.000','2024-10-31 14:02:33.219','2024-10-31 10:02:33.219'),('271baab4-a13d-4f91-aa4e-ab7bad6b3816',664,'/var/.data/2022/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_2477bdb7-4cc4-460c-abf7-139095bc04f8/occlusion_f3c53557-6667-45e0-9d95-e4f4366d4d71/scan_b1421e3f-63ee-4787-8b03-c065863774b0/7_w9_o1_maxillaire_scan_file_0.zip','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_2477bdb7-4cc4-460c-abf7-139095bc04f8_SESS_f3c53557-6667-45e0-9d95-e4f4366d4d71_TOSC_b1421e3f-63ee-4787-8b03-c065863774b0_MODEL','7_w9_o1_maxillaire_scan_file_0.zip','271baab4-a13d-4f91-aa4e-ab7bad6b3816','{\"displayTitle\":\"Maxilla 1.7.9.1.3\",\"modelMatrix\":\"-0.561517,-0.774028,0.292539,0,0.827465,-0.525255,0.198517,0,-2.74265e-09,0.353536,0.935421,0,8.7296,-3.17153,-28.6303,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-30 19:04:33.000','2024-10-31 14:02:29.026','2024-10-31 10:02:29.026'),('273de692-7728-11ee-867e-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/order_a0ba4ef3-7727-11ee-867e-58a023cda0dc/273de692-7728-11ee-867e-58a023cda0dc.pdf','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_PROST_a0ba4ef3-7727-11ee-867e-58a023cda0dc_FORM','273de692-7728-11ee-867e-58a023cda0dc.pdf','273de692-7728-11ee-867e-58a023cda0dc','{\"displayTitle\":\"Order 1.7.10.1 implant crown\",\"title\":\"implant crown\"}','PDF',0,'SYNCED',0,NULL,'2023-10-30 09:28:03.583','2023-10-30 13:28:04.160','2023-10-30 09:28:04.367'),('2777cbb2-ec32-407b-92c0-925bdb65bdfa',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/occlusion_cacc103c-8b88-4be5-a787-b6b92341e9eb/scan_bb241051-9343-4a9a-9282-a960e0748f3e/34_w1_o1_maxillaire_snapshot_1.png','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_SESS_cacc103c-8b88-4be5-a787-b6b92341e9eb_TOSC_bb241051-9343-4a9a-9282-a960e0748f3e_SNAPS','34_w1_o1_maxillaire_snapshot_1.png','acdd2be8-41d4-4309-8d50-7389512f9d6d','{\"displayTitle\":\"Maxilla 1.34.1.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-05-25 18:29:05.000','2024-10-31 14:02:29.359','2024-10-31 10:02:29.359'),('2785f1a8-12cb-4579-bcdc-70a1c7c2ce88',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_a4752db3-12a3-432e-825c-694c37118d39/37_w2_o2_mordu_posterieur_droit_scan_file_0.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_RISC_a4752db3-12a3-432e-825c-694c37118d39_MODEL','37_w2_o2_mordu_posterieur_droit_scan_file_0.zip','2785f1a8-12cb-4579-bcdc-70a1c7c2ce88','{\"displayTitle\":\"Posterior right bite 1.37.2.2.1\",\"modelMatrix\":\"0.996893,-0.067434,-0.00310481,0,0.0790395,0.991657,0.120166,0,-0.0119891,-0.110958,0.992808,0,-7.34863,1.95745,-20.4911,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-09 16:10:23.000','2024-10-31 14:02:35.873','2024-10-31 10:02:35.873'),('2788a102-696f-4ae3-93dd-88160e0c08a8',664,'','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_BOSC_a0b85a0a-ef77-4f7c-b376-d6e388afe9f0_LIFI','10_w1_o1_mandibule_ml_0_0.xyz','2788a102-696f-4ae3-93dd-88160e0c08a8','{\"displayTitle\":\"Margin line Mandible 1.10.1.1.1 No name 0\",\"name\":\"No name 0\",\"title\":\"Mandible LIFI\",\"toothNumber\":0}','XYZ',0,'SYNCED',0,'2023-05-22 09:05:54.000','2020-07-03 10:42:02.000','2024-10-31 14:02:32.277','2024-10-31 10:02:32.277'),('27bf3ac0-658b-4660-968f-78499f29209f',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_7d87c990-cfc0-487a-bd48-674f0ba32da1/27_w1_o1_mandibule_scan_file_1.zip','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_BOSC_7d87c990-cfc0-487a-bd48-674f0ba32da1_MODEL','27_w1_o1_mandibule_scan_file_1.zip','3119c4df-3760-4f4f-9247-8c1f5f4d8d43','{\"displayTitle\":\"Mandible 1.27.1.1.1\",\"modelMatrix\":\"0.898543,0.410622,-0.154952,0,-0.438885,0.840678,-0.317237,0,1.20127e-8,0.353057,0.935602,0,-26.9978,-1.85321,-17.654,1\",\"title\":\"Mandible ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2021-10-04 19:00:11.000','2024-10-31 14:02:26.839','2024-10-31 10:02:26.839'),('27d4cc77-014f-4f8c-afb9-e5d972cfdc6d',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_ef2b4fcf-f21c-418d-942a-c99ea96efbdb/occlusion_7d36e059-dbc3-46b0-931a-bdf8fdc805c6/scan_d94301ea-1f19-432a-a87d-bacbf222ca15/7_w2_o1_mandibule_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_ef2b4fcf-f21c-418d-942a-c99ea96efbdb_SESS_7d36e059-dbc3-46b0-931a-bdf8fdc805c6_BOSC_d94301ea-1f19-432a-a87d-bacbf222ca15_SNAPS','7_w2_o1_mandibule_snapshot_0.png','27d4cc77-014f-4f8c-afb9-e5d972cfdc6d','{\"displayTitle\":\"Mandibule 1.7.2.1.3\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-21 16:23:44.000','2024-10-31 14:02:26.255','2024-10-31 10:02:26.255'),('2881b5b1-e7a7-423b-9992-84d47ae87934',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_120f9fe3-b23d-49c7-89ab-f1becc102f6c/scan_b08eb59b-89c3-4239-8926-d8eb829e4257/33_w1_o1_mandibule_ml_0_0.xyz','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_120f9fe3-b23d-49c7-89ab-f1becc102f6c_BOSC_b08eb59b-89c3-4239-8926-d8eb829e4257_LIFI','33_w1_o1_mandibule_ml_0_0.xyz','2881b5b1-e7a7-423b-9992-84d47ae87934','{\"displayTitle\":\"Margin line Mandible 1.33.1.1.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2022-04-14 15:18:16.000','2024-10-31 14:02:29.208','2024-10-31 10:02:29.208'),('296f7328-8d99-48be-b336-a9bd0eb50498',664,'/var/.data/2021/664/f4f78058-cf3c-4c86-a252-bc92bd2d36b0/session_49b3ccf6-630c-48b2-8480-8a005298959e/occlusion_eee3d6a4-c7be-49a9-9278-7bd1d7e7f773/scan_4d1480f1-6a51-4555-bec5-61f967de64cd/13_w1_o1_maxillaire_snapshot_0.png','PATIENT_f4f78058-cf3c-4c86-a252-bc92bd2d36b0_ACT_49b3ccf6-630c-48b2-8480-8a005298959e_SESS_eee3d6a4-c7be-49a9-9278-7bd1d7e7f773_TOSC_4d1480f1-6a51-4555-bec5-61f967de64cd_SNAPS','13_w1_o1_maxillaire_snapshot_0.png','296f7328-8d99-48be-b336-a9bd0eb50498','{\"displayTitle\":\"Maxillaire 1.13.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-09-02 15:23:59.000','2024-10-31 14:02:25.580','2024-10-31 10:02:25.580'),('29aded90-0cc8-4df4-bbd6-05692b125871',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/occlusion_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e/scan_1d68ce03-d68e-49cb-9d0b-9b1f51edadbb/49_w1_o1_mandibule_scan_file_0.zip','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_BOSC_1d68ce03-d68e-49cb-9d0b-9b1f51edadbb_MODEL','49_w1_o1_mandibule_scan_file_0.zip','29aded90-0cc8-4df4-bbd6-05692b125871','{\"displayTitle\":\"Mandible 1.49.1.1.1\",\"modelMatrix\":\"0.979505,0.179942,-0.0905017,0,-0.201419,0.875061,-0.440112,0,-6.29476e-10,0.449321,0.89337,0,-6.38182,-13.1312,-17.5683,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-10-31 17:15:20.000','2024-10-31 14:02:35.447','2024-10-31 10:02:35.447'),('29d0bfad-fa3a-11ed-8f6c-58a023cda0dc',664,'/var/.data/2023/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc/occlusion_cf61271a-fa37-11ed-8f6c-58a023cda0dc/scan_0a8db60a-fa38-11ed-8f6c-58a023cda0dc/29d0bfad-fa3a-11ed-8f6c-58a023cda0dc.zip','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc_SESS_cf61271a-fa37-11ed-8f6c-58a023cda0dc_TOSC_0a8db60a-fa38-11ed-8f6c-58a023cda0dc_MODEL','29d0bfad-fa3a-11ed-8f6c-58a023cda0dc.zip','479d4813-fa39-11ed-8f6c-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.29.6.1.1\",\"modelMatrix\":\"-0.0499312,0.91437,-0.401789,0,-0.998753,-0.0457126,0.0200868,0,-1.46501e-09,0.402291,0.915512,0,22.5657,-25.9545,-12.2835,1\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2023-05-24 09:52:08.000','2024-10-31 14:02:36.291','2024-10-31 10:02:36.291'),('29d0ce9e-fa3a-11ed-8f6c-58a023cda0dc',664,'/var/.data/2023/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc/occlusion_cf61271a-fa37-11ed-8f6c-58a023cda0dc/scan_0a8db60a-fa38-11ed-8f6c-58a023cda0dc/29d0ce9e-fa3a-11ed-8f6c-58a023cda0dc.png','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc_SESS_cf61271a-fa37-11ed-8f6c-58a023cda0dc_TOSC_0a8db60a-fa38-11ed-8f6c-58a023cda0dc_SNAPS','29d0ce9e-fa3a-11ed-8f6c-58a023cda0dc.png','479d57d2-fa39-11ed-8f6c-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.29.6.1.1 Snapshot\"}','PNG',2,'SYNCED',0,NULL,'2023-05-24 09:52:08.000','2024-10-31 14:02:36.311','2024-10-31 10:02:36.311'),('2ac78cb1-7fe6-4891-913c-92a2ec801fb0',664,'/var/.data/2022/664/685697a1-0d50-4a06-8b3e-729cf9750f38/session_e1d214d2-2b62-484c-8ede-86b3f84573d3/occlusion_8cd0c724-d3d0-4821-a88b-42b03ae4eb07/scan_e0fe2abf-8a0e-43f6-a437-3901a1d00a73/48_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_685697a1-0d50-4a06-8b3e-729cf9750f38_ACT_e1d214d2-2b62-484c-8ede-86b3f84573d3_SESS_8cd0c724-d3d0-4821-a88b-42b03ae4eb07_LESC_e0fe2abf-8a0e-43f6-a437-3901a1d00a73_SNAPS','48_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2ac78cb1-7fe6-4891-913c-92a2ec801fb0','{\"displayTitle\":\"Posterior left bite 1.48.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-10-17 17:05:26.000','2024-10-31 14:02:35.278','2024-10-31 10:02:35.278'),('2aea6708-c584-4dd6-9f2b-3d381bae0dc7',664,'/var/.data/2022/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_a72c11a4-05dc-4421-b252-fbfcecd2559e/occlusion_bf823edb-92ee-4ee9-acd3-507d49bad781/scan_088e0b86-45b9-4da8-a5e2-291e2939c699/14_w1_o1_maxillaire_screenshot_2aea6708-c584-4dd6-9f2b-3d381bae0dc7_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_a72c11a4-05dc-4421-b252-fbfcecd2559e_SESS_bf823edb-92ee-4ee9-acd3-507d49bad781_TOSC_088e0b86-45b9-4da8-a5e2-291e2939c699_SCREENS','14_w1_o1_maxillaire_screenshot_2aea6708-c584-4dd6-9f2b-3d381bae0dc7_0.png','2aea6708-c584-4dd6-9f2b-3d381bae0dc7','{\"displayTitle\":\"Screenshot 1.14.1.1.1 Maxilla 2\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxilla 2\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:02:03.000','2024-10-31 14:02:32.655','2024-10-31 10:02:32.655'),('2b033f08-583a-4833-952b-bcb21bc30255',664,'','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_705960fa-3ed4-4013-9cde-20022721d122_SESS_9f4fa7cb-81a3-460e-b189-ba76eb8cee15_TOSC_abe20329-4dfe-4eda-815d-06af022b814e_SNAPS','7_w8_o1_maxillaire_snapshot_0.png','2b033f08-583a-4833-952b-bcb21bc30255','{\"displayTitle\":\"Maxilla 1.7.8.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:05:56.000','2022-03-30 11:02:18.000','2024-10-31 14:02:28.925','2024-10-31 10:02:28.925'),('2b226dbb-9839-11ee-86e7-58a023cda0dc',664,'/var/.data/2023/664/b4c6341b-9837-11ee-86e7-58a023cda0dc/session_bf1582a4-9837-11ee-86e7-58a023cda0dc/occlusion_bf16aee0-9837-11ee-86e7-58a023cda0dc/scan_c9a0bb36-9838-11ee-86e7-58a023cda0dc/2b226dbb-9839-11ee-86e7-58a023cda0dc.zip','PATIENT_b4c6341b-9837-11ee-86e7-58a023cda0dc_ACT_bf1582a4-9837-11ee-86e7-58a023cda0dc_SESS_bf16aee0-9837-11ee-86e7-58a023cda0dc_BOSC_c9a0bb36-9838-11ee-86e7-58a023cda0dc_MODEL','2b226dbb-9839-11ee-86e7-58a023cda0dc.zip','2b226dbb-9839-11ee-86e7-58a023cda0dc','{\"displayTitle\":\"Mandible 1.56.1.1.1\",\"modelMatrix\":\"0.921191,0.354071,-0.161372,0,-0.389111,0.838237,-0.382037,0,-9.21691e-09,0.414721,0.909949,0,-23.8996,-4.0214,-16.7737,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-12-11 10:40:49.000','2023-12-11 16:39:42.027','2023-12-11 11:39:42.027'),('2b227cd2-9839-11ee-86e7-58a023cda0dc',664,'/var/.data/2023/664/b4c6341b-9837-11ee-86e7-58a023cda0dc/session_bf1582a4-9837-11ee-86e7-58a023cda0dc/occlusion_bf16aee0-9837-11ee-86e7-58a023cda0dc/scan_c9a0bb36-9838-11ee-86e7-58a023cda0dc/2b227cd2-9839-11ee-86e7-58a023cda0dc.png','PATIENT_b4c6341b-9837-11ee-86e7-58a023cda0dc_ACT_bf1582a4-9837-11ee-86e7-58a023cda0dc_SESS_bf16aee0-9837-11ee-86e7-58a023cda0dc_BOSC_c9a0bb36-9838-11ee-86e7-58a023cda0dc_SNAPS','2b227cd2-9839-11ee-86e7-58a023cda0dc.png','2b227cd2-9839-11ee-86e7-58a023cda0dc','{\"displayTitle\":\"Mandible 1.56.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-12-11 10:40:50.000','2023-12-11 16:39:42.045','2023-12-11 11:39:42.045'),('2b56c6fd-ec90-43d4-9a05-5032faa796d7',664,'','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_TOSC_ded778b4-0eef-4984-8f57-77502f727676_SNAPS','41_w1_o3_maxillaire_snapshot_0.png','2b56c6fd-ec90-43d4-9a05-5032faa796d7','{\"displayTitle\":\"Maxilla 1.41.1.3.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:06:44.000','2022-08-03 09:53:25.000','2024-10-31 14:02:31.955','2024-10-31 10:02:31.955'),('2b6df65f-bc4e-4e8b-bfb9-2335bd73430a',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_456ba968-983a-4ece-9df6-11392894a534/37_w2_o2_maxillaire_scan_file_0.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_TOSC_456ba968-983a-4ece-9df6-11392894a534_MODEL','37_w2_o2_maxillaire_scan_file_0.zip','2b6df65f-bc4e-4e8b-bfb9-2335bd73430a','{\"displayTitle\":\"Maxilla 1.37.2.2.2\",\"modelMatrix\":\"-0.740071,0.61521,-0.271682,0,-0.672528,-0.676996,0.298968,0,4.77826e-10,0.403972,0.914771,0,8.72118,-14.828,-17.8014,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-09 16:08:18.000','2024-10-31 14:02:35.851','2024-10-31 10:02:35.851'),('2c38f262-932a-474f-83b0-317031fdf33e',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/occlusion_e930782a-e2db-43e8-9ff1-9feb64e20e4e/scan_4bfeec89-723b-47a0-90b4-0b3cbf540d5d/35_w1_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_RISC_4bfeec89-723b-47a0-90b4-0b3cbf540d5d_MODEL','35_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2c38f262-932a-474f-83b0-317031fdf33e','{\"displayTitle\":\"Posterior right bite 1.35.1.1.1\",\"modelMatrix\":\"0.996502,-0.0256403,0.0785845,0,0.0178127,0.996414,0.0816586,0,-0.0816648,-0.080651,0.993559,0,-8.10347,5.23817,-17.8826,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-06 20:37:34.000','2024-10-31 14:02:29.569','2024-10-31 10:02:29.569'),('2c6d1dc9-5356-4ee2-944f-ea885f0b032b',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/occlusion_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e/scan_1d68ce03-d68e-49cb-9d0b-9b1f51edadbb/49_w1_o1_mandibule_snapshot_0.png','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_BOSC_1d68ce03-d68e-49cb-9d0b-9b1f51edadbb_SNAPS','49_w1_o1_mandibule_snapshot_0.png','2c6d1dc9-5356-4ee2-944f-ea885f0b032b','{\"displayTitle\":\"Mandible 1.49.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-10-31 17:15:19.000','2024-10-31 14:02:35.459','2024-10-31 10:02:35.459'),('2d01fc23-e076-4307-82e2-551c85841427',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_92704e83-dce3-4695-baad-1df750f09cd7/37_w2_o2_mandibule_scan_file_2.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_MODEL','37_w2_o2_mandibule_scan_file_2.zip','cb794354-96b6-463a-a735-215a2367d35f','{\"displayTitle\":\"Mandible 1.37.2.2.1\",\"modelMatrix\":\"0.841802,0.477097,-0.252482,0,-0.539786,0.744038,-0.393749,0,-9.45422e-09,0.467745,0.883863,0,-11.1222,-12.9995,-20.7717,1\",\"title\":\"Mandible ZIP\"}','ZIP',2,'SYNCED',0,NULL,'2022-11-09 16:00:20.000','2024-10-31 14:02:36.049','2024-10-31 10:02:36.049'),('2e0798f7-31e5-46e0-a250-585c59e3ae58',664,'','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_ef2b4fcf-f21c-418d-942a-c99ea96efbdb_SESS_7d36e059-dbc3-46b0-931a-bdf8fdc805c6_BOSC_7bbce4b0-91f9-47fe-9ce5-53e0f491b245_SNAPS','7_w2_o1_mandibule_snapshot_0.png','2e0798f7-31e5-46e0-a250-585c59e3ae58','{\"displayTitle\":\"Mandible 1.7.2.1.2\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:05:57.000','2021-04-21 10:14:59.000','2024-10-31 14:02:25.531','2024-10-31 10:02:25.531'),('2e76bc0f-07df-4175-add2-e13f7adb84e5',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_6630e34a-9b19-4727-9ef0-e1c95c341549/scan_81f83061-69fa-4da2-b528-42ee27f15e7a/44_w1_o1_mandibule_scan_file_1.zip','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_6630e34a-9b19-4727-9ef0-e1c95c341549_BOSC_81f83061-69fa-4da2-b528-42ee27f15e7a_MODEL','44_w1_o1_mandibule_scan_file_1.zip','45493782-7cde-419b-baf2-f676f41925fa','{\"displayTitle\":\"Mandible 1.44.1.1.1\",\"modelMatrix\":\"0.870933,0.468581,-0.148011,0,-0.491401,0.830488,-0.262327,0,-1.56576e-08,0.301202,0.953561,0,-16.4295,-21.2649,-18.5584,1\",\"title\":\"Mandible ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-09-07 15:13:02.000','2024-10-31 14:02:33.240','2024-10-31 10:02:33.240'),('2f08ce27-2392-4c74-9c68-ed3fd9058690',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_a4752db3-12a3-432e-825c-694c37118d39/37_w2_o2_mordu_posterieur_droit_snapshot_0.png','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_RISC_a4752db3-12a3-432e-825c-694c37118d39_SNAPS','37_w2_o2_mordu_posterieur_droit_snapshot_0.png','2f08ce27-2392-4c74-9c68-ed3fd9058690','{\"displayTitle\":\"Posterior right bite 1.37.2.2.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-09 16:10:22.000','2024-10-31 14:02:35.887','2024-10-31 10:02:35.887'),('2f25d63d-8f7a-450f-88d0-b04235143181',664,'/var/.data/2022/664/685697a1-0d50-4a06-8b3e-729cf9750f38/session_e1d214d2-2b62-484c-8ede-86b3f84573d3/occlusion_8cd0c724-d3d0-4821-a88b-42b03ae4eb07/scan_101a958b-c6e0-45d2-be43-01921415b27e/48_w1_o1_mandibule_snapshot_1.png','PATIENT_685697a1-0d50-4a06-8b3e-729cf9750f38_ACT_e1d214d2-2b62-484c-8ede-86b3f84573d3_SESS_8cd0c724-d3d0-4821-a88b-42b03ae4eb07_BOSC_101a958b-c6e0-45d2-be43-01921415b27e_SNAPS','48_w1_o1_mandibule_snapshot_1.png','5b36e531-e913-4694-bd29-6c238ddae336','{\"displayTitle\":\"Mandible 1.48.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-10-17 17:11:51.000','2024-10-31 14:02:35.322','2024-10-31 10:02:35.322'),('2f53f156-ebc8-4731-8fd4-a827d477aba1',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20/37_w2_o1_mandibule_mlmeta_0_1.bin','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_BOSC_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20_LIFIM','37_w2_o1_mandibule_mlmeta_0_1.bin','ed062015-5ce9-4d64-a982-e1d9ccfc2c5f','{\"displayTitle\":\"Margin line Mandible 1.37.2.1.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2022-11-02 19:33:13.000','2024-10-31 14:02:35.674','2024-10-31 10:02:35.674'),('2fc8e7d5-c298-4652-9fba-2ae22795cca4',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_79842b46-a1df-43a9-812e-4322f1c79203/21_w1_o1_mordu_anterieur_scan_file_0.ply','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_FRSC_79842b46-a1df-43a9-812e-4322f1c79203_MODEL','21_w1_o1_mordu_anterieur_scan_file_0.ply','2fc8e7d5-c298-4652-9fba-2ae22795cca4','{\"displayTitle\":\"Anterior bite PLY\",\"modelMatrix\":\"0.840019,0.0155504,0.548667,0,0.0706291,0.98235,-0.160455,0,-0.538314,0.187374,0.820551,0,0.49852,-7.14706,-24.0697,1\",\"title\":\"Anterior bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-28 19:00:55.000','2024-10-31 14:02:26.024','2024-10-31 10:02:26.024'),('2fdfa670-821a-41f5-b716-5a88cf4da71a',664,'/var/.data/2022/664/7eac18e5-5ed2-4ed9-8b3e-eba1c562d708/session_c49716f1-987e-4111-9ab9-4541a0378bb7/occlusion_9a395a3e-4872-409e-922b-4bb58053d8a5/scan_d7e952db-9527-4a27-a3cb-76863aa4d0de/30_w1_o1_mandibule_scan_file_0.zip','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_BOSC_d7e952db-9527-4a27-a3cb-76863aa4d0de_MODEL','30_w1_o1_mandibule_scan_file_0.zip','2fdfa670-821a-41f5-b716-5a88cf4da71a','{\"displayTitle\":\"Mandible 1.30.1.1.3\",\"modelMatrix\":\"-0.910469,0.410262,-0.0522744,0,-0.413579,-0.903166,0.115079,0,9.90067e-10,0.126395,0.99198,0,14.1503,-10.1014,-20.6365,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-21 15:35:36.000','2024-10-31 14:02:33.022','2024-10-31 10:02:33.022'),('300cfa5b-0b9c-4107-97d1-6abc2c9bc707',664,'/var/.data/2022/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_7d40798f-7207-4c33-aa42-10afc814de77/scan_e7c95c67-ccda-41e6-a581-e41824f1239b/10_w1_o1_mordu_posterieur_droit_screenshot_300cfa5b-0b9c-4107-97d1-6abc2c9bc707_0.png','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_RISC_e7c95c67-ccda-41e6-a581-e41824f1239b_SCREENS','10_w1_o1_mordu_posterieur_droit_screenshot_300cfa5b-0b9c-4107-97d1-6abc2c9bc707_0.png','300cfa5b-0b9c-4107-97d1-6abc2c9bc707','{\"displayTitle\":\"Screenshot 1.10.1.1.1 Posterior right bite 2\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Posterior right bite 2\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 14:53:14.000','2024-10-31 14:02:32.239','2024-10-31 10:02:32.239'),('301b54e6-6f67-4e02-896f-5223d7ef0280',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_51374b44-d221-416c-8eb3-cf931ed89632/occlusion_8b5d08e1-2513-416b-87f9-350cab840a3d/scan_640e0a5a-3880-4e38-add1-3466fa8599c0/37_w1_o1_maxillaire_snapshot_0.png','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_51374b44-d221-416c-8eb3-cf931ed89632_SESS_8b5d08e1-2513-416b-87f9-350cab840a3d_TOSC_640e0a5a-3880-4e38-add1-3466fa8599c0_SNAPS','37_w1_o1_maxillaire_snapshot_0.png','301b54e6-6f67-4e02-896f-5223d7ef0280','{\"displayTitle\":\"Maxilla 1.37.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-22 15:46:49.000','2024-10-31 14:02:29.748','2024-10-31 10:02:29.748'),('30b6ba97-0b5b-4537-b214-3f4ade617b76',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/order_c379ba7c-4e26-473d-a1bd-f12853d9c1a4/34_w1_gouttiere_prost_file_30b6ba97-0b5b-4537-b214-3f4ade617b76_0.pdf','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_PROST_c379ba7c-4e26-473d-a1bd-f12853d9c1a4_FORM','34_w1_gouttiere_prost_file_30b6ba97-0b5b-4537-b214-3f4ade617b76_0.pdf','30b6ba97-0b5b-4537-b214-3f4ade617b76','{\"displayTitle\":\"ORDER 1.34.1.2 TRAY\",\"title\":\"Gouttiere PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-05-26 22:09:03.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.269'),('3119c4df-3760-4f4f-9247-8c1f5f4d8d43',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_7d87c990-cfc0-487a-bd48-674f0ba32da1/27_w1_o1_mandibule_scan_file_0.zip','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_BOSC_7d87c990-cfc0-487a-bd48-674f0ba32da1_MODEL','27_w1_o1_mandibule_scan_file_0.zip','3119c4df-3760-4f4f-9247-8c1f5f4d8d43','{\"displayTitle\":\"Mandible 1.27.1.1.1\",\"modelMatrix\":\"0.832524,0.519241,-0.193114,0,-0.553989,0.780305,-0.290207,0,3.5417e-9,0.348587,0.937276,0,-27.1371,-5.85666,-16.4885,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-04 18:57:34.000','2024-10-31 14:02:26.822','2024-10-31 10:02:26.822'),('325ce817-e744-4cd6-a84a-20a3e7c0e51f',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/occlusion_cacc103c-8b88-4be5-a787-b6b92341e9eb/scan_d430aee6-4975-49d0-b4c3-b096e99e797e/34_w1_o1_mordu_anterieur_scan_file_0.zip','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_SESS_cacc103c-8b88-4be5-a787-b6b92341e9eb_FRSC_d430aee6-4975-49d0-b4c3-b096e99e797e_MODEL','34_w1_o1_mordu_anterieur_scan_file_0.zip','325ce817-e744-4cd6-a84a-20a3e7c0e51f','{\"displayTitle\":\"Anterior bite 1.34.1.1.1\",\"modelMatrix\":\"0.858318,0.128715,0.496747,0,-0.112553,0.991681,-0.0378635,0,-0.500674,-0.0149036,0.867181,0,4.55322,0.207961,-19.1026,1\",\"title\":\"Anterior bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-05-25 18:02:50.000','2024-10-31 14:02:29.334','2024-10-31 10:02:29.334'),('32ef6002-3a1f-472f-ab27-d59782d15aad',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/order_f515018f-7aed-4466-a056-f2b9bf180db3/37_w2_couronne_prost_file_32ef6002-3a1f-472f-ab27-d59782d15aad_1.pdf','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_PROST_f515018f-7aed-4466-a056-f2b9bf180db3_FORM','37_w2_couronne_prost_file_32ef6002-3a1f-472f-ab27-d59782d15aad_1.pdf','8c6401d6-a141-46ea-b3db-852a74d9cde7','{\"displayTitle\":\"ORDER 1.37.2.1 Elizabeth Baxter CROWN\",\"title\":\"Couronne PDF\"}','PDF',1,'SYNCED',0,NULL,'2022-11-02 16:36:46.000','2023-05-17 17:16:39.559','2023-05-22 09:06:00.181'),('33910ab4-fa3c-11ed-8f6c-58a023cda0dc',664,'/var/.data/2023/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc/occlusion_cf61271a-fa37-11ed-8f6c-58a023cda0dc/scan_7a644c38-fa3b-11ed-8f6c-58a023cda0dc/33910ab4-fa3c-11ed-8f6c-58a023cda0dc.zip','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc_SESS_cf61271a-fa37-11ed-8f6c-58a023cda0dc_LESC_7a644c38-fa3b-11ed-8f6c-58a023cda0dc_MODEL','33910ab4-fa3c-11ed-8f6c-58a023cda0dc.zip','33910ab4-fa3c-11ed-8f6c-58a023cda0dc','{\"displayTitle\":\"Left bite 1.29.6.1.2\",\"modelMatrix\":\"-0.475951,0.233453,0.858177,0,-0.18401,-0.964138,0.0848035,0,0.862275,-0.146842,0.508477,0,-13.9233,-6.94553,-37.3082,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-05-24 10:08:04.000','2024-10-31 14:02:36.408','2024-10-31 10:02:36.408'),('33911b4a-fa3c-11ed-8f6c-58a023cda0dc',664,'/var/.data/2023/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc/occlusion_cf61271a-fa37-11ed-8f6c-58a023cda0dc/scan_7a644c38-fa3b-11ed-8f6c-58a023cda0dc/33911b4a-fa3c-11ed-8f6c-58a023cda0dc.png','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc_SESS_cf61271a-fa37-11ed-8f6c-58a023cda0dc_LESC_7a644c38-fa3b-11ed-8f6c-58a023cda0dc_SNAPS','33911b4a-fa3c-11ed-8f6c-58a023cda0dc.png','33911b4a-fa3c-11ed-8f6c-58a023cda0dc','{\"displayTitle\":\"Left bite 1.29.6.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-05-24 10:08:04.000','2024-10-31 14:02:36.417','2024-10-31 10:02:36.417'),('340a8526-0d08-4aa0-87ba-a804902b4809',664,'/var/.data/2021/664/e648cc66-9340-456c-a379-50836d1b8a5b/session_f09c328f-1a8b-4f63-8998-2f9b57cd3c76/occlusion_2c19cd55-a36e-4dc7-8954-ea8a8eeacd16/scan_d4321e90-28f8-42a0-bde1-b9ddcf321fa8/16_w1_o1_maxillaire_scan_file_3.ply','PATIENT_e648cc66-9340-456c-a379-50836d1b8a5b_ACT_f09c328f-1a8b-4f63-8998-2f9b57cd3c76_SESS_2c19cd55-a36e-4dc7-8954-ea8a8eeacd16_TOSC_d4321e90-28f8-42a0-bde1-b9ddcf321fa8_MODEL','16_w1_o1_maxillaire_scan_file_3.ply','0be7b65f-5bc4-4f76-a149-f40fdcefa07a','{\"displayTitle\":\"Maxillaire 1.16.1.1.1\",\"modelMatrix\":\"-0.447676,0.862582,-0.235666,0,-0.894196,-0.431848,0.117985,0,-8.54602e-9,0.263551,0.964646,0,21.4202,-17.0684,-19.4748,1\",\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":5,\"socleIsFullArch\":true,\"socleThickness\":1,\"socleType\":3,\"title\":\"Maxilla PLY\"}','PLY',3,'SYNCED',0,NULL,'2021-01-21 18:30:41.000','2024-10-31 14:02:26.211','2024-10-31 10:02:26.211'),('340f95df-931e-4973-aae5-2272d3824fd5',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/computedocclusion_54918a1f-bcc4-48fe-8e2c-4c14434e1683/24_w1_o1_snapshot_occ_file_0.png','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_OCC_54918a1f-bcc4-48fe-8e2c-4c14434e1683_SNAPO','24_w1_o1_snapshot_occ_file_0.png','340f95df-931e-4973-aae5-2272d3824fd5','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-13 21:31:31.000','2024-10-31 14:02:38.464','2024-10-31 10:02:38.464'),('3431dfbb-a66f-4773-8770-8b2e0ab220b8',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_120f9fe3-b23d-49c7-89ab-f1becc102f6c/scan_c3b55ffe-4305-4af0-829c-88fb2866ef2a/33_w1_o1_maxillaire_snapshot_0.png','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_120f9fe3-b23d-49c7-89ab-f1becc102f6c_TOSC_c3b55ffe-4305-4af0-829c-88fb2866ef2a_SNAPS','33_w1_o1_maxillaire_snapshot_0.png','3431dfbb-a66f-4773-8770-8b2e0ab220b8','{\"displayTitle\":\"Maxilla 1.33.1.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-04-11 17:03:19.000','2024-10-31 14:02:29.055','2024-10-31 10:02:29.055'),('3469c9f1-5269-4a05-bd73-33c7c9000367',664,'/var/.data/2021/664/f4f78058-cf3c-4c86-a252-bc92bd2d36b0/session_49b3ccf6-630c-48b2-8480-8a005298959e/occlusion_eee3d6a4-c7be-49a9-9278-7bd1d7e7f773/scan_4d1480f1-6a51-4555-bec5-61f967de64cd/13_w1_o1_maxillaire_screenshot_3469c9f1-5269-4a05-bd73-33c7c9000367_0.png','PATIENT_f4f78058-cf3c-4c86-a252-bc92bd2d36b0_ACT_49b3ccf6-630c-48b2-8480-8a005298959e_SESS_eee3d6a4-c7be-49a9-9278-7bd1d7e7f773_TOSC_4d1480f1-6a51-4555-bec5-61f967de64cd_SCREENS','13_w1_o1_maxillaire_screenshot_3469c9f1-5269-4a05-bd73-33c7c9000367_0.png','3469c9f1-5269-4a05-bd73-33c7c9000367','{\"displayTitle\":\"Screenshot 1.13.1.1.1 Maxilla 3\",\"scanFileId\":\"0cc0a4e2-b944-4f97-b8fd-4141a51c8b36\",\"scanFileType\":\"PLY\",\"scanPosition\":\"-0.525973,0.536154,0.66022,0,0.850207,0.35187,0.39158,0,-0.0223646,0.767285,-0.640917,0,0,0,0,1\",\"title\":\"Maxilla 3\"}','PNG',0,'SYNCED',0,NULL,'2020-09-02 15:26:47.000','2024-10-31 14:02:25.587','2024-10-31 10:02:25.587'),('3491d21a-ba4e-4c00-ac22-f8de5caf6202',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/order_c379ba7c-4e26-473d-a1bd-f12853d9c1a4/34_w1_gouttiere_prost_file_3491d21a-ba4e-4c00-ac22-f8de5caf6202_1.pdf','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_PROST_c379ba7c-4e26-473d-a1bd-f12853d9c1a4_FORM','34_w1_gouttiere_prost_file_3491d21a-ba4e-4c00-ac22-f8de5caf6202_1.pdf','30b6ba97-0b5b-4537-b214-3f4ade617b76','{\"displayTitle\":\"ORDER 1.34.1.2 TRAY\",\"title\":\"Gouttiere PDF\"}','PDF',1,'SYNCED',0,NULL,'2022-05-26 22:09:08.000','2023-05-17 17:16:39.559','2023-05-22 09:06:02.360'),('34e187aa-8459-44c6-afd6-5adfe7d4325a',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_4fa51169-865e-4214-93fb-b93ba08fd9d3/occlusion_a2816a91-70d4-492e-af69-b69e3c134704/scan_7f9b3767-26d0-40f2-b0dd-07da9d57ad85/7_w5_o1_maxillaire_scan_file_1.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_4fa51169-865e-4214-93fb-b93ba08fd9d3_SESS_a2816a91-70d4-492e-af69-b69e3c134704_TOSC_7f9b3767-26d0-40f2-b0dd-07da9d57ad85_MODEL','7_w5_o1_maxillaire_scan_file_1.ply','669d8672-cb26-496c-9001-2d39cb057249','{\"displayTitle\":\"Maxillaire 1.7.5.1.2\",\"modelMatrix\":\"0.900938,-0.0724082,-0.427864,0,-0.433948,-0.15033,-0.888307,0,-3.02174e-9,0.985981,-0.166859,0,-9.82263,-50.3159,14.3502,1\",\"title\":\"Maxilla PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-05-03 20:49:25.000','2024-10-31 14:02:26.440','2024-10-31 10:02:26.440'),('35183ff8-24e8-4f14-866b-db5b1bfbacb1',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_669f6bca-452c-4b2e-a49e-aa822628ed5f/24_w1_o1_maxillaire_scan_file_6.ply','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_TOSC_669f6bca-452c-4b2e-a49e-aa822628ed5f_MODEL','24_w1_o1_maxillaire_scan_file_6.ply','5ea87deb-c530-4c0d-9e39-e94f351d1354','{\"displayTitle\":\"Maxilla 1.24.1.1.1\",\"modelMatrix\":\"-0.999944,-0.00980338,0.00389464,0,0.0105487,-0.929296,0.369186,0,-2.71848e-10,0.369207,0.929347,0,18.3073,1.2474,-25.4183,1\",\"title\":\"Maxilla PLY\"}','PLY',6,'SYNCED',0,NULL,'2021-09-13 21:12:56.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.790'),('3559e869-8afd-4b40-9374-d2361cf0914a',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_bfe6249f-88b3-4a27-8f4c-5494e863352f/occlusion_fcabdff7-f4aa-41a0-8d3a-67e664f1d43e/scan_88f800e1-3e01-4d9c-984c-9f939ebee222/10_w2_o1_maxillaire_scan_file_0.ply','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_bfe6249f-88b3-4a27-8f4c-5494e863352f_SESS_fcabdff7-f4aa-41a0-8d3a-67e664f1d43e_TOSC_88f800e1-3e01-4d9c-984c-9f939ebee222_MODEL','10_w2_o1_maxillaire_scan_file_0.ply','3559e869-8afd-4b40-9374-d2361cf0914a','{\"displayTitle\":\"Maxillaire 1.10.2.1.1\",\"modelMatrix\":\"-0.96883,-0.243631,0.0448564,0,0.247726,-0.952815,0.175428,0,-4.82146e-10,0.181072,0.98347,0,13.2241,2.81941,-20.5768,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-11-30 02:22:13.000','2024-10-31 14:02:25.642','2024-10-31 10:02:25.642'),('358f428e-90db-4934-b2f1-3ca9caee9125',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/order_133bf366-2526-4d75-9242-6e7caee5aa64/18_w4_couronne_sur_implant_prost_file_358f428e-90db-4934-b2f1-3ca9caee9125_0.pdf','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_PROST_133bf366-2526-4d75-9242-6e7caee5aa64_FORM','18_w4_couronne_sur_implant_prost_file_358f428e-90db-4934-b2f1-3ca9caee9125_0.pdf','358f428e-90db-4934-b2f1-3ca9caee9125','{\"displayTitle\":\"ORDER 1.18.4.1 Biyoung Andre IMPLANT CROWN\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-08-24 20:12:18.000','2023-05-22 13:09:23.087','2023-05-22 09:09:23.087'),('360dc54f-88e0-4619-a751-4f91d1879e32',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_a4752db3-12a3-432e-825c-694c37118d39/37_w2_o2_mordu_posterieur_droit_scan_file_2.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_RISC_a4752db3-12a3-432e-825c-694c37118d39_MODEL','37_w2_o2_mordu_posterieur_droit_scan_file_2.zip','2785f1a8-12cb-4579-bcdc-70a1c7c2ce88','{\"displayTitle\":\"Posterior right bite 1.37.2.2.1\",\"modelMatrix\":\"0.986233,0.00219236,0.166027,0,0.00135225,0.996697,0.084701,0,-0.16626,-0.0830626,0.982482,0,-3.43499,1.56293,-20.9445,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',2,'SYNCED',0,NULL,'2022-11-09 16:13:46.000','2024-10-31 14:02:35.900','2024-10-31 10:02:35.900'),('3694c1ac-b60e-4b16-baf5-38e9c7ed4c4e',664,'/var/.data/2022/664/097506b2-3385-4e2b-a196-b427b2eb51b8/session_0a5a2b81-09c6-4fe0-874c-4b845c0229bc/occlusion_e78fa40a-0a61-4104-adb2-0cfd70d69414/scan_abe712db-ef5c-4b31-86ea-c51697f1242e/31_w1_o1_mandibule_snapshot_0.png','PATIENT_097506b2-3385-4e2b-a196-b427b2eb51b8_ACT_0a5a2b81-09c6-4fe0-874c-4b845c0229bc_SESS_e78fa40a-0a61-4104-adb2-0cfd70d69414_BOSC_abe712db-ef5c-4b31-86ea-c51697f1242e_SNAPS','31_w1_o1_mandibule_snapshot_0.png','3694c1ac-b60e-4b16-baf5-38e9c7ed4c4e','{\"displayTitle\":\"Mandible 1.31.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-23 14:37:02.000','2024-10-31 14:02:28.871','2024-10-31 10:02:28.871'),('36b6730b-4fd0-4262-8f5b-94b47eed92ad',664,'','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_TOSC_ec70dd1f-5648-4918-9bce-b3384aeae579_MODEL','18_w4_o1_maxillaire_scan_file_0.zip','36b6730b-4fd0-4262-8f5b-94b47eed92ad','{\"displayTitle\":\"Maxilla 1.18.4.1.2\",\"modelMatrix\":\"-0.62301,0.688545,-0.371166,0,-0.782214,-0.548405,0.295623,0,-1.91698e-08,0.474507,0.880252,0,29.4727,-17.7667,-18.4072,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:06:04.000','2022-08-24 10:52:47.000','2024-10-31 14:02:33.165','2024-10-31 10:02:33.165'),('36bd52fc-3960-496c-aef2-4b689b6c0fd3',664,'/var/.data/2022/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_96711d60-288c-439f-b464-597833d56519/occlusion_a98f038e-a19a-47ad-af09-a22810e9d19c/scan_300a55b7-e679-4993-b375-e0a3fe68f61d/14_w3_o1_mandibule_screenshot_36bd52fc-3960-496c-aef2-4b689b6c0fd3_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_96711d60-288c-439f-b464-597833d56519_SESS_a98f038e-a19a-47ad-af09-a22810e9d19c_BOSC_300a55b7-e679-4993-b375-e0a3fe68f61d_SCREENS','14_w3_o1_mandibule_screenshot_36bd52fc-3960-496c-aef2-4b689b6c0fd3_0.png','36bd52fc-3960-496c-aef2-4b689b6c0fd3','{\"displayTitle\":\"Screenshot 1.14.3.1.1 Mandible 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Mandible 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 14:56:18.000','2024-10-31 14:02:32.387','2024-10-31 10:02:32.387'),('36e74d3e-7662-45a5-8241-34501ec906e8',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_51374b44-d221-416c-8eb3-cf931ed89632/order_bf6a5903-e77c-47d1-aa54-6dbca17c1938/37_w1_couronne_prost_file_36e74d3e-7662-45a5-8241-34501ec906e8_0.pdf','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_51374b44-d221-416c-8eb3-cf931ed89632_PROST_bf6a5903-e77c-47d1-aa54-6dbca17c1938_FORM','37_w1_couronne_prost_file_36e74d3e-7662-45a5-8241-34501ec906e8_0.pdf','36e74d3e-7662-45a5-8241-34501ec906e8','{\"displayTitle\":\"ORDER 1.37.1.1 CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-06-22 20:40:55.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.270'),('3755b11e-0012-4854-85fa-011648f75dbb',664,'/var/.data/2022/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_a72c11a4-05dc-4421-b252-fbfcecd2559e/occlusion_bf823edb-92ee-4ee9-acd3-507d49bad781/scan_fdcb8fba-f16b-457a-8027-7f34eeace00b/14_w1_o1_mordu_posterieur_droit_screenshot_3755b11e-0012-4854-85fa-011648f75dbb_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_a72c11a4-05dc-4421-b252-fbfcecd2559e_SESS_bf823edb-92ee-4ee9-acd3-507d49bad781_RISC_fdcb8fba-f16b-457a-8027-7f34eeace00b_SCREENS','14_w1_o1_mordu_posterieur_droit_screenshot_3755b11e-0012-4854-85fa-011648f75dbb_0.png','3755b11e-0012-4854-85fa-011648f75dbb','{\"displayTitle\":\"Screenshot 1.14.1.1.1 Posterior right bite 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Posterior right bite 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:02:32.000','2024-10-31 14:02:32.773','2024-10-31 10:02:32.773'),('380de904-4892-40a0-b5af-04afb8b8c94e',664,'','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_db740293-ae2a-40ae-9142-4d94ed66bcd5_SESS_1256ab02-5172-4a92-a17d-f2fc402290ac_TOSC_93f13113-c282-4369-a96a-9a2f2f6383b2_MODEL','','380de904-4892-40a0-b5af-04afb8b8c94e','{\"displayTitle\":\"Maxilla 1.7.6.1.2\",\"modelMatrix\":\"0.950744,-0.309713,0.0128196,0,0.309978,0.94993,-0.0393194,0,-4.21224e-10,0.0413565,0.999144,0,0.469097,1.60246,-20.1552,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'CREATED',0,'2021-05-05 15:57:47.000','2021-05-05 15:57:43.000','2023-05-17 17:16:39.559',NULL),('38348fb1-51bb-4620-9df5-b9b65e2d1779',664,'/var/.data/2022/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_7d40798f-7207-4c33-aa42-10afc814de77/scan_a0b85a0a-ef77-4f7c-b376-d6e388afe9f0/10_w1_o1_mandibule_screenshot_38348fb1-51bb-4620-9df5-b9b65e2d1779_0.png','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_BOSC_a0b85a0a-ef77-4f7c-b376-d6e388afe9f0_SCREENS','10_w1_o1_mandibule_screenshot_38348fb1-51bb-4620-9df5-b9b65e2d1779_0.png','38348fb1-51bb-4620-9df5-b9b65e2d1779','{\"displayTitle\":\"Screenshot 1.10.1.1.1 Mandible 2\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Mandible 2\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 14:53:46.000','2024-10-31 14:02:32.283','2024-10-31 10:02:32.283'),('389a8857-6c47-11ee-bc7f-58a023cda0dc',664,'/var/.data/2023/664/bbc77872-6c30-11ee-bc7f-58a023cda0dc/session_0a963705-6c31-11ee-bc7f-58a023cda0dc/order_a70ea958-6c46-11ee-bc7f-58a023cda0dc/389a8857-6c47-11ee-bc7f-58a023cda0dc.pdf','PATIENT_bbc77872-6c30-11ee-bc7f-58a023cda0dc_ACT_0a963705-6c31-11ee-bc7f-58a023cda0dc_PROST_a70ea958-6c46-11ee-bc7f-58a023cda0dc_FORM','389a8857-6c47-11ee-bc7f-58a023cda0dc.pdf','389a8857-6c47-11ee-bc7f-58a023cda0dc','{\"displayTitle\":\"Order 1.53.1.1 Max and Mandible Surgical Guide\",\"title\":\"Max and Mandible Surgical Guide\"}','PDF',0,'SYNCED',0,NULL,'2023-10-16 13:12:45.000','2023-10-16 17:12:49.346','2023-10-16 13:12:49.346'),('392b7c86-cde1-4f5b-aebb-127d69a35de3',664,'','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_BOSC_5478f37b-d39e-46d1-a026-906c02d9c928_SNAPS','30_w1_o1_mandibule_snapshot_1.png','991b6bf3-db84-4e38-b3ca-2e1d37a170c0','{\"displayTitle\":\"Mandible 1.30.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',1,'SYNCED',0,'2023-05-22 09:07:42.000','2022-03-21 10:27:49.000','2024-10-31 14:02:28.764','2024-10-31 10:02:28.764'),('39d577ce-6560-4cdf-8d00-711c2b1598e9',664,'','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_BOSC_3eaba63c-ff17-453d-ab22-bc8e747a4ce5_MODEL','35_w1_o1_mandibule_scan_file_0.zip','39d577ce-6560-4cdf-8d00-711c2b1598e9','{\"displayTitle\":\"Mandible 1.35.1.1.1\",\"modelMatrix\":\"0.384335,0.910613,-0.151886,0,-0.923194,0.379098,-0.0632319,0,3.56449e-09,0.164523,0.986373,0,4.70351,-31.3095,-20.5528,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:06:06.000','2022-06-06 14:09:33.000','2024-10-31 14:02:29.468','2024-10-31 10:02:29.468'),('3a3b5737-833e-4b06-b2f1-93127aa3e05a',664,'','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_TOSC_4352d5ab-e3b9-4f1f-9fb2-e12036db1127_SNAPS','49_w1_o1_maxillaire_snapshot_0.png','3a3b5737-833e-4b06-b2f1-93127aa3e05a','{\"displayTitle\":\"Maxilla 1.49.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:06:06.000','2022-10-31 12:10:49.000','2024-10-31 14:02:35.624','2024-10-31 10:02:35.624'),('3a824a4d-1071-47df-83b6-85274c6103ec',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/order_719d069f-1c89-4cc2-a04d-982bb719d80a/44_w1_couronne_sur_implant_prost_file_3a824a4d-1071-47df-83b6-85274c6103ec_0.pdf','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_PROST_719d069f-1c89-4cc2-a04d-982bb719d80a_FORM','44_w1_couronne_sur_implant_prost_file_3a824a4d-1071-47df-83b6-85274c6103ec_0.pdf','3a824a4d-1071-47df-83b6-85274c6103ec','{\"displayTitle\":\"ORDER 1.44.1.3 IMPLANT CROWN[Taylor-jolley]\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'CREATED',0,NULL,'2022-09-21 19:39:26.000','2023-05-17 17:16:39.559',NULL),('3aa4aa7f-c1bf-46f5-b1b8-d05d04f54992',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_36d05387-51e6-4286-a074-7c7894c0622b/occlusion_0ec93b21-a91f-4695-a966-e072a8fb68e3/scan_5212b119-1f64-4de6-82e2-b5b72ee0e22b/7_w7_o1_maxillaire_scan_file_1.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_36d05387-51e6-4286-a074-7c7894c0622b_SESS_0ec93b21-a91f-4695-a966-e072a8fb68e3_TOSC_5212b119-1f64-4de6-82e2-b5b72ee0e22b_MODEL','7_w7_o1_maxillaire_scan_file_1.ply','7eedc56a-9ad1-4a49-b277-341ffab589ce','{\"displayTitle\":\"Maxilla 1.7.7.1.1\",\"modelMatrix\":\"-0.589971,-0.0671936,0.804624,0,0.807425,-0.0490971,0.587924,0,-1.15874e-9,0.996531,0.0832196,0,8.24331,-50.9031,5.73571,1\",\"title\":\"Maxilla PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-05-05 16:57:47.000','2024-10-31 14:02:26.593','2024-10-31 10:02:26.593'),('3af7d53f-e4c1-438d-b798-279238f381cd',664,'','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_RISC_ed845142-2dca-48e8-8ec9-cc1f6a86f8cb_SNAPS','49_w1_o1_mordu_posterieur_droit_snapshot_0.png','3af7d53f-e4c1-438d-b798-279238f381cd','{\"displayTitle\":\"Posterior right bite 1.49.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:06:06.000','2022-10-31 12:17:03.000','2024-10-31 14:02:35.538','2024-10-31 10:02:35.538'),('3c0b0988-7ac2-4e3d-ad84-4841bbd18966',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/occlusion_d7b86e87-0261-4bc1-8529-76e0bdd29195/scan_6b9a0ce1-8ace-48c3-a9b9-efd9bd604d7f/18_w4_o1_mandibule_snapshot_0.png','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_BOSC_6b9a0ce1-8ace-48c3-a9b9-efd9bd604d7f_SNAPS','18_w4_o1_mandibule_snapshot_0.png','3c0b0988-7ac2-4e3d-ad84-4841bbd18966','{\"displayTitle\":\"Mandible 1.18.4.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-24 16:32:04.000','2024-10-31 14:02:33.100','2024-10-31 10:02:33.100'),('3c359e74-b03a-4f21-a836-212e19d89fc2',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_775311e4-a561-40c7-a2ce-76a0b1550be8/scan_8ce97d97-ffb5-461c-928d-ea25e722645a/41_w1_o1_mordu_posterieur_gauche_screenshot_3c359e74-b03a-4f21-a836-212e19d89fc2_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_775311e4-a561-40c7-a2ce-76a0b1550be8_LESC_8ce97d97-ffb5-461c-928d-ea25e722645a_SCREENS','41_w1_o1_mordu_posterieur_gauche_screenshot_3c359e74-b03a-4f21-a836-212e19d89fc2_0.png','3c359e74-b03a-4f21-a836-212e19d89fc2','{\"displayTitle\":\"Screenshot 1.41.1.1.1 Posterior left bite 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Posterior left bite 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-03 17:29:28.000','2024-10-31 14:02:32.191','2024-10-31 10:02:32.191'),('3c9f280c-637f-4072-9bcd-c356e72cae38',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368/32_w1_o1_mordu_posterieur_gauche_screenshot_3c9f280c-637f-4072-9bcd-c356e72cae38_0.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_LESC_8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368_SCREENS','32_w1_o1_mordu_posterieur_gauche_screenshot_3c9f280c-637f-4072-9bcd-c356e72cae38_0.png','3c9f280c-637f-4072-9bcd-c356e72cae38','{\"displayTitle\":\"Screenshot 1.32.1.1.1 Posterior left bite 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Posterior left bite 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:06:34.000','2024-10-31 14:02:32.975','2024-10-31 10:02:32.975'),('3dce93ee-7ed1-4bc5-85ff-1fe06ad1d1ab',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_a72c11a4-05dc-4421-b252-fbfcecd2559e/occlusion_bf823edb-92ee-4ee9-acd3-507d49bad781/scan_98f6c3db-f007-4f0d-a724-a372751a6d75/14_w1_o1_mandibule_scan_file_0.ply','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_a72c11a4-05dc-4421-b252-fbfcecd2559e_SESS_bf823edb-92ee-4ee9-acd3-507d49bad781_BOSC_98f6c3db-f007-4f0d-a724-a372751a6d75_MODEL','14_w1_o1_mandibule_scan_file_0.ply','3dce93ee-7ed1-4bc5-85ff-1fe06ad1d1ab','{\"displayTitle\":\"Mandibule 1.14.1.1.1\",\"modelMatrix\":\"0.242148,0.950671,-0.193878,0,-0.97024,0.237264,-0.0483872,0,-2.85644e-10,0.199825,0.979832,0,5.91848,4.32499,-21.1614,1\",\"title\":\"Mandible PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-09-09 15:47:12.000','2024-10-31 14:02:32.596','2024-10-31 10:02:32.596'),('3de35365-8be7-4c5d-9d56-903f8e272986',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_416dd268-693a-4466-8380-8829fc1b5e3d/24_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_RISC_416dd268-693a-4466-8380-8829fc1b5e3d_MODEL','24_w1_o1_mordu_posterieur_droit_scan_file_0.ply','3de35365-8be7-4c5d-9d56-903f8e272986','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.1\",\"modelMatrix\":\"1.00754,0.0876217,0.592622,0,-0.119722,0.993987,-0.189246,0,-0.299955,0.0936394,0.855641,0,-19.1287,-4.18522,-42.3883,1\",\"title\":\"Posterior right bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-13 21:27:32.000','2024-10-31 14:02:28.630','2024-10-31 10:02:28.630'),('3dea442a-9d7f-44ce-9213-342d4c17e409',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_eff3d296-ab91-4054-b8d3-6c78732ae1c8/21_w1_o1_maxillaire_scan_file_0.ply','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_TOSC_eff3d296-ab91-4054-b8d3-6c78732ae1c8_MODEL','21_w1_o1_maxillaire_scan_file_0.ply','3dea442a-9d7f-44ce-9213-342d4c17e409','{\"displayTitle\":\"Maxillaire 1.21.1.1.4\",\"modelMatrix\":\"0.575031,0.793068,-0.200953,0,-0.818131,0.557415,-0.141242,0,-6.42769e-9,0.245625,0.969365,0,-5.47794,-41.5275,-14.839,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-28 18:51:56.000','2024-10-31 14:02:25.973','2024-10-31 10:02:25.973'),('3ec22db4-d2af-489a-b0fa-4d4e8a20600e',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_92704e83-dce3-4695-baad-1df750f09cd7/37_w2_o2_mandibule_ml_0_3.xyz','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_LIFI','37_w2_o2_mandibule_ml_0_3.xyz','0967d80d-992e-4d4b-ae94-bd981fca4791','{\"displayTitle\":\"Margin line Mandible 1.37.2.2.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',3,'SYNCED',0,NULL,'2022-11-09 17:07:29.000','2024-10-31 14:02:36.057','2024-10-31 10:02:36.057'),('3f1757fe-c85b-4daf-9505-622b6fa8df3f',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_93be3b1e-bcd5-443a-a7e3-4f5452c470a6/24_w1_o1_mandibule_snapshot_0.png','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_BOSC_93be3b1e-bcd5-443a-a7e3-4f5452c470a6_SNAPS','24_w1_o1_mandibule_snapshot_0.png','3f1757fe-c85b-4daf-9505-622b6fa8df3f','{\"displayTitle\":\"Mandibule 1.24.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-13 21:24:07.000','2024-10-31 14:02:28.698','2024-10-31 10:02:28.698'),('3f56431a-39e2-4537-933e-99ea66b80566',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_21bbefd5-8dc0-4e41-91d8-718463ad469c/scan_a003a669-7caa-4b04-a7fb-b5164b2bfcd3/41_w1_o3_mordu_posterieur_droit_screenshot_3f56431a-39e2-4537-933e-99ea66b80566_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_RISC_a003a669-7caa-4b04-a7fb-b5164b2bfcd3_SCREENS','41_w1_o3_mordu_posterieur_droit_screenshot_3f56431a-39e2-4537-933e-99ea66b80566_0.png','3f56431a-39e2-4537-933e-99ea66b80566','{\"displayTitle\":\"Screenshot 1.41.1.3.1 Posterior right bite 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Posterior right bite 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-03 17:32:26.000','2024-10-31 14:02:32.106','2024-10-31 10:02:32.106'),('40789477-ac02-407a-977c-e67e93de93e8',664,'/var/.data/2022/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_705960fa-3ed4-4013-9cde-20022721d122/occlusion_9f4fa7cb-81a3-460e-b189-ba76eb8cee15/scan_3afaae5b-fc7f-46be-b019-7206b27b05a8/7_w8_o1_maxillaire_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_705960fa-3ed4-4013-9cde-20022721d122_SESS_9f4fa7cb-81a3-460e-b189-ba76eb8cee15_TOSC_3afaae5b-fc7f-46be-b019-7206b27b05a8_SNAPS','7_w8_o1_maxillaire_snapshot_0.png','40789477-ac02-407a-977c-e67e93de93e8','{\"displayTitle\":\"Maxilla 1.7.8.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-30 17:13:11.000','2024-10-31 14:02:28.947','2024-10-31 10:02:28.947'),('40d7a1b0-734f-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/scan_0a1eb92c-734f-11ee-b011-58a023cda0dc/40d7a1b0-734f-11ee-b011-58a023cda0dc.zip','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_RISC_0a1eb92c-734f-11ee-b011-58a023cda0dc_MODEL','40d7a1b0-734f-11ee-b011-58a023cda0dc.zip','40d7a1b0-734f-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Right bite 1.7.10.1.1\",\"modelMatrix\":\"0.92029,-0.129635,0.371384,0,0.11505,0.991589,0.0284751,0,-0.374062,0.0111742,0.928094,0,-6.06876,-1.74317,-24.8886,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-10-25 11:59:48.000','2023-10-30 13:28:06.479','2023-10-30 09:28:06.479'),('40d7b163-734f-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/scan_0a1eb92c-734f-11ee-b011-58a023cda0dc/40d7b163-734f-11ee-b011-58a023cda0dc.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_RISC_0a1eb92c-734f-11ee-b011-58a023cda0dc_SNAPS','40d7b163-734f-11ee-b011-58a023cda0dc.png','40d7b163-734f-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Right bite 1.7.10.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-10-25 11:59:48.000','2023-10-30 13:28:06.495','2023-10-30 09:28:06.495'),('4157ac2e-557f-47f8-9c6c-3a50905de7ee',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_955946be-5764-4c34-9e84-61682f4fdf78/occlusion_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d/scan_5de08e77-210d-48b5-8004-9c536bb8530e/33_w2_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_RISC_5de08e77-210d-48b5-8004-9c536bb8530e_MODEL','33_w2_o1_mordu_posterieur_droit_scan_file_0.zip','4157ac2e-557f-47f8-9c6c-3a50905de7ee','{\"displayTitle\":\"Posterior right bite 1.33.2.1.4\",\"modelMatrix\":\"0.992149,-0.126068,-0.0146017,0,0.124017,0.99194,-0.0154539,0,0.0162203,0.0128644,0.999774,0,-18.5201,1.71975,-18.9563,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-01 15:35:40.000','2024-10-31 14:02:31.896','2024-10-31 10:02:31.896'),('41d41ad2-2fb1-471e-a6e0-38c61a0afcb9',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_ef2b4fcf-f21c-418d-942a-c99ea96efbdb/occlusion_7d36e059-dbc3-46b0-931a-bdf8fdc805c6/scan_821a2ca1-0234-413b-a35b-4cc6703ca75b/7_w2_o1_maxillaire_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_ef2b4fcf-f21c-418d-942a-c99ea96efbdb_SESS_7d36e059-dbc3-46b0-931a-bdf8fdc805c6_TOSC_821a2ca1-0234-413b-a35b-4cc6703ca75b_SNAPS','7_w2_o1_maxillaire_snapshot_0.png','41d41ad2-2fb1-471e-a6e0-38c61a0afcb9','{\"displayTitle\":\"Maxillaire 1.7.2.1.3\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-21 15:36:52.000','2024-10-31 14:02:26.284','2024-10-31 10:02:26.284'),('4227ee27-5a61-436a-ae69-cd486657a34d',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_775311e4-a561-40c7-a2ce-76a0b1550be8/scan_627e4388-24f1-4c92-816e-89cfce055284/41_w1_o1_maxillaire_scan_file_0.zip','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_775311e4-a561-40c7-a2ce-76a0b1550be8_TOSC_627e4388-24f1-4c92-816e-89cfce055284_MODEL','41_w1_o1_maxillaire_scan_file_0.zip','4227ee27-5a61-436a-ae69-cd486657a34d','{\"displayTitle\":\"Maxilla 1.41.1.1.2\",\"modelMatrix\":\"0.678389,0.716973,-0.160431,0,-0.734703,0.662019,-0.148134,0,-1.01179e-08,0.218361,0.975868,0,-14.8298,-17.2882,-17.7117,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-07-28 15:34:23.000','2024-10-31 14:02:32.144','2024-10-31 10:02:32.144'),('422c8790-59bb-44d4-8423-88d7c4e220d7',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_6630e34a-9b19-4727-9ef0-e1c95c341549/scan_81f83061-69fa-4da2-b528-42ee27f15e7a/44_w1_o1_mandibule_snapshot_1.png','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_6630e34a-9b19-4727-9ef0-e1c95c341549_BOSC_81f83061-69fa-4da2-b528-42ee27f15e7a_SNAPS','44_w1_o1_mandibule_snapshot_1.png','f55defb1-5a2c-4b14-91f1-64f2163f04ad','{\"displayTitle\":\"Mandible 1.44.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-09-07 15:13:01.000','2024-10-31 14:02:33.258','2024-10-31 10:02:33.258'),('42637d2d-50b1-4ef7-a0ae-40aef183b97e',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20/37_w2_o1_mandibule_ml_0_4.xyz','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_BOSC_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20_LIFI','37_w2_o1_mandibule_ml_0_4.xyz','f7956a29-1664-4e5a-9aad-2a53021be43e','{\"displayTitle\":\"Margin line Mandible 1.37.2.1.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',4,'SYNCED',0,NULL,'2022-11-02 19:35:04.000','2024-10-31 14:02:35.702','2024-10-31 10:02:35.702'),('427a4b23-481e-474e-af46-1b8e8deafb7d',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_36d05387-51e6-4286-a074-7c7894c0622b/occlusion_0ec93b21-a91f-4695-a966-e072a8fb68e3/scan_5212b119-1f64-4de6-82e2-b5b72ee0e22b/7_w7_o1_maxillaire_scan_file_5.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_36d05387-51e6-4286-a074-7c7894c0622b_SESS_0ec93b21-a91f-4695-a966-e072a8fb68e3_TOSC_5212b119-1f64-4de6-82e2-b5b72ee0e22b_MODEL','7_w7_o1_maxillaire_scan_file_5.ply','7eedc56a-9ad1-4a49-b277-341ffab589ce','{\"displayTitle\":\"Maxillaire 1.7.7.1.1\",\"modelMatrix\":\"-0.325962,-0.015658,0.945253,0,0.945383,-0.00539877,0.325917,0,1.81389e-10,0.999863,0.0165626,0,7.70919,-51.4044,5.0148,1\",\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":10,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":4,\"title\":\"Maxilla PLY\"}','PLY',5,'SYNCED',0,NULL,'2021-05-05 17:45:52.000','2024-10-31 14:02:26.609','2024-10-31 10:02:26.609'),('43625627-0f37-4d61-80ec-3a5cfe5409a4',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_96711d60-288c-439f-b464-597833d56519/occlusion_a98f038e-a19a-47ad-af09-a22810e9d19c/scan_300a55b7-e679-4993-b375-e0a3fe68f61d/14_w3_o1_mandibule_snapshot_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_96711d60-288c-439f-b464-597833d56519_SESS_a98f038e-a19a-47ad-af09-a22810e9d19c_BOSC_300a55b7-e679-4993-b375-e0a3fe68f61d_SNAPS','14_w3_o1_mandibule_snapshot_0.png','43625627-0f37-4d61-80ec-3a5cfe5409a4','{\"displayTitle\":\"Mandible 1.14.3.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-14 15:25:15.000','2024-10-31 14:02:32.398','2024-10-31 10:02:32.398'),('43ec56d4-c1b3-4a5d-a33a-61909d689853',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/occlusion_cacc103c-8b88-4be5-a787-b6b92341e9eb/scan_bb241051-9343-4a9a-9282-a960e0748f3e/34_w1_o1_maxillaire_scan_file_0.zip','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_SESS_cacc103c-8b88-4be5-a787-b6b92341e9eb_TOSC_bb241051-9343-4a9a-9282-a960e0748f3e_MODEL','34_w1_o1_maxillaire_scan_file_0.zip','43ec56d4-c1b3-4a5d-a33a-61909d689853','{\"displayTitle\":\"Maxilla 1.34.1.1.2\",\"modelMatrix\":\"-0.85771,0.50652,-0.0881541,0,-0.514134,-0.845008,0.147064,0,4.76739e-09,0.171461,0.985191,0,-7.92105,-4.71451,-21.194,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-05-25 18:24:16.000','2024-10-31 14:02:29.371','2024-10-31 10:02:29.371'),('4494a5b9-653f-11ef-b382-58a023cda0dc',664,'/var/.data/2024/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_721d0cdd-6536-11ef-b382-58a023cda0dc/occlusion_721e3ad7-6536-11ef-b382-58a023cda0dc/scan_4e055e11-653e-11ef-b382-58a023cda0dc/4494a5b9-653f-11ef-b382-58a023cda0dc.zip','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_721d0cdd-6536-11ef-b382-58a023cda0dc_SESS_721e3ad7-6536-11ef-b382-58a023cda0dc_TOSC_4e055e11-653e-11ef-b382-58a023cda0dc_MODEL','4494a5b9-653f-11ef-b382-58a023cda0dc.zip','f3679988-653e-11ef-b382-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.35.2.1.1\",\"modelMatrix\":\"-0.501295,0.805775,-0.315325,0,-0.865277,-0.466823,0.182683,0,-1.07093e-08,0.364421,0.931234,0,27.1577,-10.4767,-17.7733,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-08-28 09:25:46.000','2024-08-28 13:38:47.078','2024-08-28 09:38:47.078'),('4494b511-653f-11ef-b382-58a023cda0dc',664,'/var/.data/2024/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_721d0cdd-6536-11ef-b382-58a023cda0dc/occlusion_721e3ad7-6536-11ef-b382-58a023cda0dc/scan_4e055e11-653e-11ef-b382-58a023cda0dc/4494b511-653f-11ef-b382-58a023cda0dc.png','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_721d0cdd-6536-11ef-b382-58a023cda0dc_SESS_721e3ad7-6536-11ef-b382-58a023cda0dc_TOSC_4e055e11-653e-11ef-b382-58a023cda0dc_SNAPS','4494b511-653f-11ef-b382-58a023cda0dc.png','f367a9fe-653e-11ef-b382-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.35.2.1.1 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2024-08-28 09:25:48.000','2024-08-28 13:38:47.098','2024-08-28 09:38:47.098'),('45015dfe-9466-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/45015dfe-9466-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_MODEL','45015dfe-9466-11ee-8fd8-58a023cda0dc.zip','87a0d07a-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1\",\"modelMatrix\":\"0.843881,0.502692,-0.187524,0,-0.53653,0.790659,-0.294947,0,3.33011e-09,0.349512,0.936932,0,-21.678,-3.20968,-22.8257,1\",\"scanBodies\":[]}','ZIP',9,'SYNCED',0,NULL,'2023-12-06 13:35:46.035','2023-12-06 19:12:08.103','2023-12-11 10:12:13.835'),('45493782-7cde-419b-baf2-f676f41925fa',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_6630e34a-9b19-4727-9ef0-e1c95c341549/scan_81f83061-69fa-4da2-b528-42ee27f15e7a/44_w1_o1_mandibule_scan_file_0.zip','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_6630e34a-9b19-4727-9ef0-e1c95c341549_BOSC_81f83061-69fa-4da2-b528-42ee27f15e7a_MODEL','44_w1_o1_mandibule_scan_file_0.zip','45493782-7cde-419b-baf2-f676f41925fa','{\"displayTitle\":\"Mandible 1.44.1.1.1\",\"modelMatrix\":\"0.93578,0.340053,-0.0931658,0,-0.352585,0.90252,-0.247267,0,8.64888e-10,0.264237,0.964458,0,-18.6871,-17.9715,-19.8535,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-07 15:10:21.000','2024-10-31 14:02:33.231','2024-10-31 10:02:33.231'),('4569d449-c0a3-4229-9f9d-9d173955cbd7',664,'/var/.data/2022/664/7eac18e5-5ed2-4ed9-8b3e-eba1c562d708/session_c49716f1-987e-4111-9ab9-4541a0378bb7/order_a9d67f35-6b75-41ae-8fc0-04ebed5dcbc6/30_w1_couronne_sur_implant_prost_file_4569d449-c0a3-4229-9f9d-9d173955cbd7_0.pdf','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_PROST_a9d67f35-6b75-41ae-8fc0-04ebed5dcbc6_FORM','30_w1_couronne_sur_implant_prost_file_4569d449-c0a3-4229-9f9d-9d173955cbd7_0.pdf','4569d449-c0a3-4229-9f9d-9d173955cbd7','{\"displayTitle\":\"ORDER 1.30.1.1 IMPLANT CROWN\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-03-24 16:48:32.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.274'),('45a4307e-2197-4709-a4d8-2d47ed12d94b',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_7d87c990-cfc0-487a-bd48-674f0ba32da1/27_w1_o1_mandibule_snapshot_1.png','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_BOSC_7d87c990-cfc0-487a-bd48-674f0ba32da1_SNAPS','27_w1_o1_mandibule_snapshot_1.png','8f2ac274-c407-43a2-9887-6c9cc61f72a2','{\"displayTitle\":\"Mandible 1.27.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-10-04 19:00:10.000','2024-10-31 14:02:26.856','2024-10-31 10:02:26.856'),('45b66c38-3ad4-4b46-8ea7-d6d06c845a8f',664,'','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_TOSC_4881f615-e5ee-4e32-a293-eb41e56db31d_SNAPS','','45b66c38-3ad4-4b46-8ea7-d6d06c845a8f','{\"displayTitle\":\"Maxilla 1.21.1.1.3\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'CREATED',0,'2021-04-28 18:43:15.000','2021-04-28 18:42:58.000','2023-05-17 17:16:39.559',NULL),('4638f023-e672-4b5e-a3af-423e20a747d7',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_79842b46-a1df-43a9-812e-4322f1c79203/21_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_FRSC_79842b46-a1df-43a9-812e-4322f1c79203_SNAPS','21_w1_o1_mordu_anterieur_snapshot_0.png','4638f023-e672-4b5e-a3af-423e20a747d7','{\"displayTitle\":\"Anterior bite SNAPSHOT\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-28 19:00:55.000','2024-10-31 14:02:26.005','2024-10-31 10:02:26.005'),('46704090-e6d2-4d18-a318-987d159b07c5',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/occlusion_e930782a-e2db-43e8-9ff1-9feb64e20e4e/scan_4bfeec89-723b-47a0-90b4-0b3cbf540d5d/35_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_RISC_4bfeec89-723b-47a0-90b4-0b3cbf540d5d_SNAPS','35_w1_o1_mordu_posterieur_droit_snapshot_0.png','46704090-e6d2-4d18-a318-987d159b07c5','{\"displayTitle\":\"Posterior right bite 1.35.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-06 20:37:33.000','2024-10-31 14:02:29.584','2024-10-31 10:02:29.584'),('46f0433f-a2b0-4717-9b73-038d45591362',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_7d40798f-7207-4c33-aa42-10afc814de77/scan_e7c95c67-ccda-41e6-a581-e41824f1239b/10_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_RISC_e7c95c67-ccda-41e6-a581-e41824f1239b_SNAPS','10_w1_o1_mordu_posterieur_droit_snapshot_0.png','46f0433f-a2b0-4717-9b73-038d45591362','{\"displayTitle\":\"Mordu posterieur droit 1.10.1.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-06-29 20:13:49.000','2024-10-31 14:02:32.247','2024-10-31 10:02:32.247'),('46f88ef2-6c3e-4840-af4b-0cc2847372fa',664,'','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_PROST_e2c9a4f6-7174-4966-b244-648673c0bd6f_FORM','','46f88ef2-6c3e-4840-af4b-0cc2847372fa','{\"displayTitle\":\"ORDER 1.37.2.2 Elisabeth BaxterCROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,'2022-11-02 19:23:41.000','2022-11-02 18:56:46.000','2023-05-17 17:16:39.559','2022-11-02 19:23:41.000'),('46f8ac26-642f-40b5-a4f3-fbed00c6cc75',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_102e062c-07cd-49ca-b2d8-4050c1eb56ee/27_w1_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_RISC_102e062c-07cd-49ca-b2d8-4050c1eb56ee_MODEL','27_w1_o1_mordu_posterieur_droit_scan_file_0.zip','46f8ac26-642f-40b5-a4f3-fbed00c6cc75','{\"displayTitle\":\"Mordu posterieur droit 1.27.1.1.1\",\"modelMatrix\":\"0.990664,-0.114911,0.0901238,0,0.107345,0.991608,-0.0565015,0,-0.0849791,0.0608369,0.994345,0,-17.5282,0.782219,-17.3978,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-04 19:06:05.000','2024-10-31 14:02:28.568','2024-10-31 10:02:28.568'),('470c8a58-eeb8-459d-a26d-c4967dbea19f',664,'/var/.data/2021/664/17cc8b8c-6280-4e69-ad1e-731bdd9819e0/session_f9cb9561-eacc-4b43-976b-dfa67a953a80/occlusion_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910/scan_3ef1c403-4f23-4240-9474-8d8f45c283b5/19_w1_o1_mandibule_scan_file_0.ply','PATIENT_17cc8b8c-6280-4e69-ad1e-731bdd9819e0_ACT_f9cb9561-eacc-4b43-976b-dfa67a953a80_SESS_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910_BOSC_3ef1c403-4f23-4240-9474-8d8f45c283b5_MODEL','19_w1_o1_mandibule_scan_file_0.ply','470c8a58-eeb8-459d-a26d-c4967dbea19f','{\"displayTitle\":\"Mandibule 1.19.1.1.1\",\"modelMatrix\":\"-0.922844,-0.371001,0.103528,0,0.385175,-0.888884,0.248044,0,5.99015e-9,0.268782,0.963201,0,26.0391,-7.07884,-12.3943,1\",\"title\":\"Mandible PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-09 19:43:26.000','2024-10-31 14:02:25.722','2024-10-31 10:02:25.722'),('479d4813-fa39-11ed-8f6c-58a023cda0dc',664,'/var/.data/2023/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc/occlusion_cf61271a-fa37-11ed-8f6c-58a023cda0dc/scan_0a8db60a-fa38-11ed-8f6c-58a023cda0dc/479d4813-fa39-11ed-8f6c-58a023cda0dc.zip','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc_SESS_cf61271a-fa37-11ed-8f6c-58a023cda0dc_TOSC_0a8db60a-fa38-11ed-8f6c-58a023cda0dc_MODEL','479d4813-fa39-11ed-8f6c-58a023cda0dc.zip','479d4813-fa39-11ed-8f6c-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.29.6.1.1\",\"modelMatrix\":\"-0.400926,0.900993,-0.165739,0,-0.91611,-0.394311,0.0725341,0,-4.11765e-09,0.180916,0.983498,0,27.1575,-12.8599,-19.6232,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-05-24 09:45:48.000','2024-10-31 14:02:36.279','2024-10-31 10:02:36.279'),('479d57d2-fa39-11ed-8f6c-58a023cda0dc',664,'/var/.data/2023/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc/occlusion_cf61271a-fa37-11ed-8f6c-58a023cda0dc/scan_0a8db60a-fa38-11ed-8f6c-58a023cda0dc/479d57d2-fa39-11ed-8f6c-58a023cda0dc.png','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc_SESS_cf61271a-fa37-11ed-8f6c-58a023cda0dc_TOSC_0a8db60a-fa38-11ed-8f6c-58a023cda0dc_SNAPS','479d57d2-fa39-11ed-8f6c-58a023cda0dc.png','479d57d2-fa39-11ed-8f6c-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.29.6.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-05-24 09:45:48.000','2024-10-31 14:02:36.301','2024-10-31 10:02:36.301'),('4819eee1-2c73-4adc-b276-9c62c992e121',664,'/var/.data/2022/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_705960fa-3ed4-4013-9cde-20022721d122/occlusion_9f4fa7cb-81a3-460e-b189-ba76eb8cee15/scan_c865ffd7-f2b1-43ae-a10a-26300e29d86e/7_w8_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_705960fa-3ed4-4013-9cde-20022721d122_SESS_9f4fa7cb-81a3-460e-b189-ba76eb8cee15_LESC_c865ffd7-f2b1-43ae-a10a-26300e29d86e_MODEL','7_w8_o1_mordu_posterieur_gauche_scan_file_0.zip','4819eee1-2c73-4adc-b276-9c62c992e121','{\"displayTitle\":\"Posterior left bite 1.7.8.1.1\",\"modelMatrix\":\"-0.991683,-0.00241573,0.124473,0,-0.0165108,-0.999522,-0.0320859,0,0.128544,-0.0341328,0.991717,0,17.569,-2.47319,-20.4332,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-30 17:18:21.000','2024-10-31 14:02:28.985','2024-10-31 10:02:28.985'),('48a56426-32f0-4b76-97af-cbfbecc8ec01',664,'','PATIENT_11ec40e4-4579-4185-9fcf-4e1aac06f554_ACT_8f44bea9-b7e9-45c8-a098-f3b18f9be730_SESS_7348646e-cf7a-460b-aba9-d56ad656689e_TOSC_d3d5ecdb-7933-478d-8f71-7bc13b2a4a05_MODEL','','f40bab24-99ba-4240-a790-2cb8e6b01f50','{\"displayTitle\":\"Maxilla 1.25.1.1.2\",\"modelMatrix\":\"0.472664,0.869304,-0.144568,0,-0.881243,0.46626,-0.0775408,0,-2.06962e-9,0.164051,0.986452,0,-22.5465,-11.4851,-19.0711,1\",\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":10,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1,\"title\":\"Maxilla PLY\"}','PLY',1,'SYNCED',0,'2022-03-14 14:42:21.000','2021-09-14 17:57:53.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.286'),('48b32ef4-709e-463d-b524-33aba97c9150',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_775311e4-a561-40c7-a2ce-76a0b1550be8/scan_ffb4d4c8-4774-4512-bb36-ac65c37d00a5/41_w1_o1_mandibule_scan_file_0.zip','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_775311e4-a561-40c7-a2ce-76a0b1550be8_BOSC_ffb4d4c8-4774-4512-bb36-ac65c37d00a5_MODEL','41_w1_o1_mandibule_scan_file_0.zip','48b32ef4-709e-463d-b524-33aba97c9150','{\"displayTitle\":\"Mandible 1.41.1.1.2\",\"modelMatrix\":\"-0.977298,0.211712,-0.00813221,0,-0.211869,-0.976578,0.0375119,0,3.71418e-10,0.0383833,0.999263,0,18.2111,-6.323,-19.3809,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-01 14:34:57.000','2024-10-31 14:02:31.715','2024-10-31 10:02:31.715'),('48ce4b66-3e22-46f7-a16f-15d6b1e400d2',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_b5dae369-a773-4095-aa54-7c8b75c939d8/occlusion_a12bd271-974e-4fcf-8893-d88105690bce/scan_e1f9f752-dd61-4e2b-82d8-016edf9173cf/7_w3_o1_maxillaire_scan_file_4.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_b5dae369-a773-4095-aa54-7c8b75c939d8_SESS_a12bd271-974e-4fcf-8893-d88105690bce_TOSC_e1f9f752-dd61-4e2b-82d8-016edf9173cf_MODEL','7_w3_o1_maxillaire_scan_file_4.ply','b89bdf45-07f7-4aef-b272-f9b581b06b02','{\"displayTitle\":\"Maxillaire 1.7.3.1.1\",\"modelMatrix\":\"0.353491,0.735052,-0.57857,0,-0.935438,0.277767,-0.218635,0,2.08057e-8,0.618502,0.785783,0,4.33116,-47.3843,-20.4717,1\",\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":10,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":4,\"title\":\"Maxilla PLY\"}','PLY',4,'SYNCED',0,NULL,'2021-04-28 17:12:17.000','2024-10-31 14:02:26.506','2024-10-31 10:02:26.506'),('48fd4959-6ba3-4711-9f3d-495f885551aa',664,'','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_TOSC_ded778b4-0eef-4984-8f57-77502f727676_MODEL','41_w1_o3_maxillaire_scan_file_2.zip','ad632823-c0d2-40d5-86fc-095a10d5a99c','{\"displayTitle\":\"Maxilla 1.41.1.3.2\",\"modelMatrix\":\"-0.632139,0.771223,-0.0749393,0,-0.774855,-0.629176,0.0611367,0,-2.99488e-09,0.096714,0.995312,0,6.75042,-9.94061,-21.187,1\",\"title\":\"Maxilla ZIP\"}','ZIP',2,'SYNCED',0,'2023-05-22 09:08:14.000','2022-08-03 09:58:47.000','2024-10-31 14:02:31.947','2024-10-31 10:02:31.947'),('49565264-afb5-47cf-84f8-2cf6b2e3db70',664,'','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_TOSC_ec70dd1f-5648-4918-9bce-b3384aeae579_SNAPS','18_w4_o1_maxillaire_snapshot_0.png','49565264-afb5-47cf-84f8-2cf6b2e3db70','{\"displayTitle\":\"Maxilla 1.18.4.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:06:20.000','2022-08-24 10:52:46.000','2024-10-31 14:02:33.174','2024-10-31 10:02:33.174'),('49dd01c4-2e28-427b-85aa-ab8d7c4aa0e6',664,'','PATIENT_17cc8b8c-6280-4e69-ad1e-731bdd9819e0_ACT_f9cb9561-eacc-4b43-976b-dfa67a953a80_SESS_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910_FRSC_95b374af-2b93-47f7-86f5-f5e1ba6360b6_SNAPS','19_w1_o1_mordu_anterieur_snapshot_0.png','49dd01c4-2e28-427b-85aa-ab8d7c4aa0e6','{\"displayTitle\":\"Anterior bite 1.19.1.1.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:06:20.000','2021-04-09 13:52:41.000','2024-10-31 14:02:25.466','2024-10-31 10:02:25.466'),('4a198bf7-bf34-454b-b570-7cf6168b7a8f',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20/37_w2_o1_mandibule_ml_0_2.xyz','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_BOSC_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20_LIFI','37_w2_o1_mandibule_ml_0_2.xyz','f7956a29-1664-4e5a-9aad-2a53021be43e','{\"displayTitle\":\"Margin line Mandible 1.37.2.1.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',2,'SYNCED',0,NULL,'2022-11-02 19:33:51.000','2024-10-31 14:02:35.714','2024-10-31 10:02:35.714'),('4a4a6589-8149-4485-ab1f-6603d976f58e',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_d3696b3d-0728-4822-b89d-631e2ab774a4/occlusion_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6/scan_1fad60ca-f3ea-48a3-b845-fcd52ee435b5/14_w2_o1_mandibule_scan_file_0.ply','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_d3696b3d-0728-4822-b89d-631e2ab774a4_SESS_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6_BOSC_1fad60ca-f3ea-48a3-b845-fcd52ee435b5_MODEL','14_w2_o1_mandibule_scan_file_0.ply','4a4a6589-8149-4485-ab1f-6603d976f58e','{\"displayTitle\":\"Mandibule 1.14.2.1.1\",\"modelMatrix\":\"0.242148,0.950671,-0.193878,0,-0.97024,0.237264,-0.0483872,0,-2.85644e-10,0.199825,0.979832,0,5.91848,4.32499,-21.1614,1\",\"title\":\"Mandible PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-11-30 02:14:43.000','2024-10-31 14:02:32.741','2024-10-31 10:02:32.741'),('4a594b34-2546-4f10-938b-a533e451d2c4',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_a283652c-095c-41a2-b62b-1cba87286c35/24_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_LESC_a283652c-095c-41a2-b62b-1cba87286c35_SNAPS','24_w1_o1_mordu_posterieur_gauche_snapshot_0.png','4a594b34-2546-4f10-938b-a533e451d2c4','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-13 21:29:12.000','2024-10-31 14:02:28.600','2024-10-31 10:02:28.600'),('4a86d6f8-fbf5-4b40-89c8-3f159e5e0879',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/order_c8a9ae43-f4da-4f8b-b98a-5d4804c238bc/49_w1_couronne_sur_implant_prost_file_4a86d6f8-fbf5-4b40-89c8-3f159e5e0879_0.pdf','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_PROST_c8a9ae43-f4da-4f8b-b98a-5d4804c238bc_FORM','49_w1_couronne_sur_implant_prost_file_4a86d6f8-fbf5-4b40-89c8-3f159e5e0879_0.pdf','4a86d6f8-fbf5-4b40-89c8-3f159e5e0879','{\"displayTitle\":\"ORDER 1.49.1.1 IMPLANT CROWN(Carol,Burroughts)\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'CREATED',0,NULL,'2022-10-31 19:10:56.000','2023-05-17 17:16:39.559',NULL),('4aa1e72a-2214-4782-9601-a9c4431cf5ed',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_7d87c990-cfc0-487a-bd48-674f0ba32da1/27_w1_o1_mandibule_scan_file_3.zip','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_BOSC_7d87c990-cfc0-487a-bd48-674f0ba32da1_MODEL','27_w1_o1_mandibule_scan_file_3.zip','3119c4df-3760-4f4f-9247-8c1f5f4d8d43','{\"displayTitle\":\"Mandible 1.27.1.1.1\",\"modelMatrix\":\"0.898543,0.410622,-0.154952,0,-0.438885,0.840678,-0.317237,0,1.20127e-8,0.353057,0.935602,0,-26.9978,-1.85321,-17.654,1\",\"title\":\"Mandible ZIP\"}','ZIP',3,'SYNCED',0,NULL,'2021-10-04 19:01:08.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.263'),('4ad4e90c-75f1-4e2d-b3b2-e8b08e1524ab',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_6630e34a-9b19-4727-9ef0-e1c95c341549/scan_5d0e6d2d-490c-4381-a794-dd7121de4a60/44_w1_o1_maxillaire_snapshot_0.png','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_6630e34a-9b19-4727-9ef0-e1c95c341549_TOSC_5d0e6d2d-490c-4381-a794-dd7121de4a60_SNAPS','44_w1_o1_maxillaire_snapshot_0.png','4ad4e90c-75f1-4e2d-b3b2-e8b08e1524ab','{\"displayTitle\":\"Maxilla 1.44.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-07 15:02:02.000','2024-10-31 14:02:33.211','2024-10-31 10:02:33.211'),('4b9a00b9-9475-4a79-b3e4-27abb98450fb',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_7d40798f-7207-4c33-aa42-10afc814de77/scan_e7c95c67-ccda-41e6-a581-e41824f1239b/10_w1_o1_mordu_posterieur_droit_screenshot_4b9a00b9-9475-4a79-b3e4-27abb98450fb_0.png','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_RISC_e7c95c67-ccda-41e6-a581-e41824f1239b_SCREENS','10_w1_o1_mordu_posterieur_droit_screenshot_4b9a00b9-9475-4a79-b3e4-27abb98450fb_0.png','4b9a00b9-9475-4a79-b3e4-27abb98450fb','{\"displayTitle\":\"Screenshot 1.10.1.1.1 Posterior right bite 1\",\"scanFileId\":\"d81a9394-1d76-4e0d-bbe3-266fa262538c\",\"scanFileType\":\"PLY\",\"scanPosition\":\"0.779281,-0.420184,0.464937,0,-0.309691,-0.9032,-0.297189,0,0.544805,0.0876072,-0.833974,0,0,0,0,1\",\"title\":\"Posterior right bite 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 14:53:40.000','2024-10-31 14:02:32.256','2024-10-31 10:02:32.256'),('4baca937-885c-4f87-88b2-c1c5ac9e24e5',664,'','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_BOSC_5478f37b-d39e-46d1-a026-906c02d9c928_MODEL','30_w1_o1_mandibule_scan_file_0.zip','4baca937-885c-4f87-88b2-c1c5ac9e24e5','{\"displayTitle\":\"Mandible 1.30.1.1.1\",\"modelMatrix\":\"-0.837108,-0.527056,0.1465,0,0.547037,-0.806531,0.224183,0,-5.67081e-09,0.267806,0.963473,0,6.4778,-0.393129,-20.0216,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:09:19.000','2022-03-21 10:21:07.000','2024-10-31 14:02:28.775','2024-10-31 10:02:28.775'),('4c449c81-cd1f-492e-b12f-03afe35bc557',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_120f9fe3-b23d-49c7-89ab-f1becc102f6c/scan_a6440940-a668-4e8f-be35-82ce928f701e/33_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_120f9fe3-b23d-49c7-89ab-f1becc102f6c_RISC_a6440940-a668-4e8f-be35-82ce928f701e_SNAPS','33_w1_o1_mordu_posterieur_droit_snapshot_0.png','4c449c81-cd1f-492e-b12f-03afe35bc557','{\"displayTitle\":\"Posterior right bite 1.33.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-04-11 17:11:42.000','2024-10-31 14:02:29.065','2024-10-31 10:02:29.065'),('4c4dcb51-ef14-4ae6-9a4b-40d745bebdf7',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/occlusion_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e/scan_513ec45a-0f78-4206-8819-a95a65dd628e/49_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_LESC_513ec45a-0f78-4206-8819-a95a65dd628e_MODEL','49_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','4c4dcb51-ef14-4ae6-9a4b-40d745bebdf7','{\"displayTitle\":\"Posterior left bite 1.49.1.1.1\",\"modelMatrix\":\"-0.999774,0.0084295,0.0170336,0,-0.0113985,-0.991741,-0.125629,0,0.0181303,-0.128002,0.991936,0,6.92101,5.16363,-19.6451,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-10-31 17:18:35.000','2024-10-31 14:02:35.475','2024-10-31 10:02:35.475'),('4d04c526-a65f-4df6-8b9e-6fd50db8c7f5',664,'/var/.data/2021/664/ebb7ec01-03db-43d2-bf9a-bc250f69d307/session_e530f0de-323f-4c29-bb17-b5bfe0da3afd/occlusion_1f19aa7f-35eb-4878-b743-abbe8cf73f08/scan_f7ca22c1-70d3-4f9e-8ccd-3187aea91801/5_w1_o1_maxillaire_scan_file_0.ply','PATIENT_ebb7ec01-03db-43d2-bf9a-bc250f69d307_ACT_e530f0de-323f-4c29-bb17-b5bfe0da3afd_SESS_1f19aa7f-35eb-4878-b743-abbe8cf73f08_TOSC_f7ca22c1-70d3-4f9e-8ccd-3187aea91801_MODEL','5_w1_o1_maxillaire_scan_file_0.ply','4d04c526-a65f-4df6-8b9e-6fd50db8c7f5','{\"displayTitle\":\"Maxillaire 1.5.1.1.1\",\"modelMatrix\":\"-0.136676,0.918824,-0.370246,0,-0.990616,-0.126771,0.0510832,0,2.1212e-9,0.373753,0.927528,0,-13.5461,-35.1574,-15.8139,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-18 19:22:04.000','2024-10-31 14:02:25.886','2024-10-31 10:02:25.886'),('4d2adaf7-8bfc-4e39-9074-1b71491a3303',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_955946be-5764-4c34-9e84-61682f4fdf78/occlusion_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d/scan_bf2f2d20-77c1-4aff-a005-144b4bf2c7f3/33_w2_o1_maxillaire_scan_file_0.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_TOSC_bf2f2d20-77c1-4aff-a005-144b4bf2c7f3_MODEL','33_w2_o1_maxillaire_scan_file_0.zip','4d2adaf7-8bfc-4e39-9074-1b71491a3303','{\"displayTitle\":\"Maxilla 1.33.2.1.1\",\"modelMatrix\":\"-0.6037,0.77268,-0.196243,0,-0.797212,-0.585123,0.148608,0,8.42698e-09,0.246162,0.969229,0,17.0141,-5.53462,-19.0682,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-01 15:15:18.000','2024-10-31 14:02:31.751','2024-10-31 10:02:31.751'),('4d497b9c-1f90-4dc5-8a0b-ca47b80a1492',664,'/var/.data/2022/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_2477bdb7-4cc4-460c-abf7-139095bc04f8/occlusion_f3c53557-6667-45e0-9d95-e4f4366d4d71/scan_b1421e3f-63ee-4787-8b03-c065863774b0/7_w9_o1_maxillaire_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_2477bdb7-4cc4-460c-abf7-139095bc04f8_SESS_f3c53557-6667-45e0-9d95-e4f4366d4d71_TOSC_b1421e3f-63ee-4787-8b03-c065863774b0_SNAPS','7_w9_o1_maxillaire_snapshot_0.png','4d497b9c-1f90-4dc5-8a0b-ca47b80a1492','{\"displayTitle\":\"Maxilla 1.7.9.1.3\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-30 19:04:33.000','2024-10-31 14:02:29.035','2024-10-31 10:02:29.035'),('4d8982bd-2be0-44d1-b3dc-a68b3d43dca9',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_456ba968-983a-4ece-9df6-11392894a534/37_w2_o2_maxillaire_snapshot_0.png','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_TOSC_456ba968-983a-4ece-9df6-11392894a534_SNAPS','37_w2_o2_maxillaire_snapshot_0.png','4d8982bd-2be0-44d1-b3dc-a68b3d43dca9','{\"displayTitle\":\"Maxilla 1.37.2.2.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-09 16:08:18.000','2024-10-31 14:02:35.860','2024-10-31 10:02:35.860'),('4dbdd202-f89f-4e3b-b032-0f2780465410',664,'','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_PROST_e5931e17-9060-4f04-9eac-a9ebae07c42d_FORM','','4dbdd202-f89f-4e3b-b032-0f2780465410','{\"displayTitle\":\"ORDER 1.34.1.1 OTHER PROSTHETIC SHEET\",\"title\":\"Autre PDF\"}','PDF',0,'SYNCED',0,'2022-05-26 22:11:06.000','2022-05-25 19:48:21.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.277'),('4dd23da3-755d-4711-b5ae-c9d7d5b10fbb',664,'/var/.data/2022/664/e33159c9-a713-4a37-ba98-9ec2e2e213e7/session_b63ca765-4d68-4cf4-9707-4ad3a19f3236/occlusion_ae7f89c9-26ec-4cee-b377-d5145e6c6aae/scan_f7d86e35-41e6-4047-8f44-4a7b73bc2680/50_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_e33159c9-a713-4a37-ba98-9ec2e2e213e7_ACT_b63ca765-4d68-4cf4-9707-4ad3a19f3236_SESS_ae7f89c9-26ec-4cee-b377-d5145e6c6aae_RISC_f7d86e35-41e6-4047-8f44-4a7b73bc2680_SNAPS','50_w1_o1_mordu_posterieur_droit_snapshot_0.png','4dd23da3-755d-4711-b5ae-c9d7d5b10fbb','{\"displayTitle\":\"Posterior right bite 1.50.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-14 18:20:21.000','2024-10-31 14:02:36.198','2024-10-31 10:02:36.198'),('4e0207c3-761b-40df-9a9e-ec615454ca8d',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/order_ea343662-ea36-42db-b63d-dd61bc999ce0/32_w1_bridge_sur_implant_prost_file_4e0207c3-761b-40df-9a9e-ec615454ca8d_0.pdf','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_PROST_ea343662-ea36-42db-b63d-dd61bc999ce0_FORM','32_w1_bridge_sur_implant_prost_file_4e0207c3-761b-40df-9a9e-ec615454ca8d_0.pdf','4e0207c3-761b-40df-9a9e-ec615454ca8d','{\"displayTitle\":\"ORDER 1.32.1.1 IMPLANT BRIDGE\",\"title\":\"Bridge sur Implant PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-03-24 16:46:11.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.796'),('4e214ec5-202e-4dee-b925-5f6ed1074108',664,'','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_TOSC_6f9af98c-1ab4-4600-b23b-57aa4c4d1e85_SNAPS','','4e214ec5-202e-4dee-b925-5f6ed1074108','{\"displayTitle\":\"Maxilla 1.21.1.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'CREATED',0,'2021-04-28 18:43:25.000','2021-04-28 18:39:18.000','2023-05-17 17:16:39.559',NULL),('4ead05fa-43f6-4510-b941-4c90069dbe32',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_7d87c990-cfc0-487a-bd48-674f0ba32da1/27_w1_o1_mandibule_snapshot_2.png','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_BOSC_7d87c990-cfc0-487a-bd48-674f0ba32da1_SNAPS','27_w1_o1_mandibule_snapshot_2.png','8f2ac274-c407-43a2-9887-6c9cc61f72a2','{\"displayTitle\":\"Mandibule 1.27.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2021-10-04 19:04:04.000','2024-10-31 14:02:26.865','2024-10-31 10:02:26.865'),('4ee64a77-ca4c-444b-9d9f-1eaea738c404',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_c90ddf83-1e94-4d7c-a61f-3f7bed3aad41/occlusion_5dac735e-358c-49a1-aa52-0180d8d8ff7e/scan_7ce9b1b8-7c7b-4655-bd0d-90f37ced345e/27_w2_o1_maxillaire_scan_file_0.zip','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_c90ddf83-1e94-4d7c-a61f-3f7bed3aad41_SESS_5dac735e-358c-49a1-aa52-0180d8d8ff7e_TOSC_7ce9b1b8-7c7b-4655-bd0d-90f37ced345e_MODEL','27_w2_o1_maxillaire_scan_file_0.zip','4ee64a77-ca4c-444b-9d9f-1eaea738c404','{\"displayTitle\":\"Maxilla 1.27.2.1.1\",\"modelMatrix\":\"0.0402542,0.982076,-0.184136,0,-0.999189,0.0395647,-0.00741826,0,1.47114e-10,0.184286,0.982873,0,17.5111,-27.163,-17.4832,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-20 18:17:05.000','2024-10-31 14:02:26.770','2024-10-31 10:02:26.770'),('4f5c94d6-48d0-45b2-b5f1-40b18baf386e',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_92704e83-dce3-4695-baad-1df750f09cd7/37_w2_o2_mandibule_ml_0_2.xyz','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_LIFI','37_w2_o2_mandibule_ml_0_2.xyz','0967d80d-992e-4d4b-ae94-bd981fca4791','{\"displayTitle\":\"Margin line Mandible 1.37.2.2.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',2,'SYNCED',0,NULL,'2022-11-09 17:05:37.000','2024-10-31 14:02:36.069','2024-10-31 10:02:36.069'),('4f6b02df-1818-4f99-ae96-306c6d94e169',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_120f9fe3-b23d-49c7-89ab-f1becc102f6c/scan_b08eb59b-89c3-4239-8926-d8eb829e4257/33_w1_o1_mandibule_ml_1_0.xyz','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_120f9fe3-b23d-49c7-89ab-f1becc102f6c_BOSC_b08eb59b-89c3-4239-8926-d8eb829e4257_LIFI','33_w1_o1_mandibule_ml_1_0.xyz','4f6b02df-1818-4f99-ae96-306c6d94e169','{\"displayTitle\":\"Margin line Mandible 1.33.1.1.1 Margin line 1\",\"name\":\"Margin line 1\",\"title\":\"Mandible LIFI\",\"toothNumber\":1,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2022-04-14 15:18:48.000','2024-10-31 14:02:29.216','2024-10-31 10:02:29.216'),('4fe9c7bf-a124-42a0-a4cb-40c29d457a64',664,'/var/.data/2022/664/e4dda259-b05b-4f33-92ac-ee4067d7dfa2/session_610634a3-6f25-4ce3-9363-ad383ec68df4/order_331e8399-8fa1-408a-b55e-1adf0a2ef6c0/4_w2_couronne_prost_file_4fe9c7bf-a124-42a0-a4cb-40c29d457a64_0.pdf','PATIENT_e4dda259-b05b-4f33-92ac-ee4067d7dfa2_ACT_610634a3-6f25-4ce3-9363-ad383ec68df4_PROST_331e8399-8fa1-408a-b55e-1adf0a2ef6c0_FORM','4_w2_couronne_prost_file_4fe9c7bf-a124-42a0-a4cb-40c29d457a64_0.pdf','4fe9c7bf-a124-42a0-a4cb-40c29d457a64','{\"displayTitle\":\"ORDER 1.4.2.1 Noumbissi V. CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-11-02 16:16:26.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.775'),('50ba84da-fbb3-4a82-ad28-44193c241742',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/order_e811fdc8-4e79-4f7c-83bb-0fb3afe35b50/37_w2_couronne_prost_file_50ba84da-fbb3-4a82-ad28-44193c241742_0.pdf','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_PROST_e811fdc8-4e79-4f7c-83bb-0fb3afe35b50_FORM','37_w2_couronne_prost_file_50ba84da-fbb3-4a82-ad28-44193c241742_0.pdf','50ba84da-fbb3-4a82-ad28-44193c241742','{\"displayTitle\":\"ORDER 1.37.2.3 Elisabeth Baxter CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-11-02 19:26:22.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.278'),('50cb8a2b-fa3b-11ed-8f6c-58a023cda0dc',664,'/var/.data/2023/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc/occlusion_cf61271a-fa37-11ed-8f6c-58a023cda0dc/scan_1c8acfc2-fa3b-11ed-8f6c-58a023cda0dc/50cb8a2b-fa3b-11ed-8f6c-58a023cda0dc.zip','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc_SESS_cf61271a-fa37-11ed-8f6c-58a023cda0dc_LESC_1c8acfc2-fa3b-11ed-8f6c-58a023cda0dc_MODEL','50cb8a2b-fa3b-11ed-8f6c-58a023cda0dc.zip','50cb8a2b-fa3b-11ed-8f6c-58a023cda0dc','{\"displayTitle\":\"Left bite 1.29.6.1.1\",\"modelMatrix\":\"-0.945824,-0.0680471,0.316873,0,0.0565264,-0.996881,-0.0555489,0,0.31976,-0.0405343,0.946851,0,2.55435,5.35792,-19.7773,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,'2023-05-24 10:01:23.000','2023-05-24 10:00:21.000','2024-10-31 14:02:36.381','2024-10-31 10:02:36.381'),('50cb99a8-fa3b-11ed-8f6c-58a023cda0dc',664,'/var/.data/2023/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc/occlusion_cf61271a-fa37-11ed-8f6c-58a023cda0dc/scan_1c8acfc2-fa3b-11ed-8f6c-58a023cda0dc/50cb99a8-fa3b-11ed-8f6c-58a023cda0dc.png','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc_SESS_cf61271a-fa37-11ed-8f6c-58a023cda0dc_LESC_1c8acfc2-fa3b-11ed-8f6c-58a023cda0dc_SNAPS','50cb99a8-fa3b-11ed-8f6c-58a023cda0dc.png','50cb99a8-fa3b-11ed-8f6c-58a023cda0dc','{\"displayTitle\":\"Left bite 1.29.6.1.1 Snapshot\"}','PNG',0,'SYNCED',0,'2023-05-24 10:01:24.000','2023-05-24 10:00:22.000','2024-10-31 14:02:36.387','2024-10-31 10:02:36.387'),('51194a9a-7c48-4bc3-a1fe-6faf2241f59e',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/computedocclusion_54918a1f-bcc4-48fe-8e2c-4c14434e1683/24_w1_o1_maxillaire_occlusion_occ_file_0.ply','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_OCC_54918a1f-bcc4-48fe-8e2c-4c14434e1683_TOPLY','24_w1_o1_maxillaire_occlusion_occ_file_0.ply','51194a9a-7c48-4bc3-a1fe-6faf2241f59e','{\"displayTitle\":\"Occlusion Maxilla 1.24.1.1.1\",\"modelMatrix\":\"-0.658753,0.723297,-0.207089,0,-0.752359,-0.633306,0.181324,0,1.82945e-8,0.275253,0.961372,0,24.6353,-13.6739,-19.7993,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Occlusion Maxilla 1.24.1.1.1\",\"occlusionMatrix\":\"0.659274,0.75191,-0.000685468,0,0.750651,-0.658108,0.0588033,0,0.0437618,-0.0392829,-0.998284,0,-24.7802,-7.91603,17.6038,1\"}','PLY',0,'SYNCED',0,NULL,'2021-09-13 21:31:31.000','2024-10-31 14:02:38.473','2024-10-31 10:02:38.473'),('52059c48-e3a3-4bd6-8fcc-9746f5a7da5b',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/occlusion_e930782a-e2db-43e8-9ff1-9feb64e20e4e/scan_3b924f2a-18f4-4ed4-8e4e-efb6a1b36439/35_w1_o1_mordu_anterieur_scan_file_0.zip','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_FRSC_3b924f2a-18f4-4ed4-8e4e-efb6a1b36439_MODEL','35_w1_o1_mordu_anterieur_scan_file_0.zip','52059c48-e3a3-4bd6-8fcc-9746f5a7da5b','{\"displayTitle\":\"Anterior bite 1.35.1.1.1\",\"modelMatrix\":\"0.925443,3.73816e-05,0.386362,0,-0.031371,0.983381,0.140685,0,-0.379894,-0.189332,0.912235,0,-4.3743,4.78311,-23.7978,1\",\"title\":\"Anterior bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-06 20:41:46.000','2024-10-31 14:02:29.628','2024-10-31 10:02:29.628'),('526c1caf-5adb-42e3-917d-6ce859cd016f',664,'/var/.data/2021/664/17cc8b8c-6280-4e69-ad1e-731bdd9819e0/session_f9cb9561-eacc-4b43-976b-dfa67a953a80/occlusion_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910/scan_30be6697-331a-4e7d-8bba-b11fc9ec90b9/19_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_17cc8b8c-6280-4e69-ad1e-731bdd9819e0_ACT_f9cb9561-eacc-4b43-976b-dfa67a953a80_SESS_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910_RISC_30be6697-331a-4e7d-8bba-b11fc9ec90b9_SNAPS','19_w1_o1_mordu_posterieur_droit_snapshot_0.png','526c1caf-5adb-42e3-917d-6ce859cd016f','{\"displayTitle\":\"Mordu posterieur droit 1.19.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-09 19:47:07.000','2024-10-31 14:02:25.763','2024-10-31 10:02:25.763'),('52853284-be7b-44e5-aeae-65e139601fcd',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_ede3aa5c-bbba-4cf2-8caa-b2d5f671b311/scan_760aa563-6e6f-4ae3-98cc-e3d5350a517e/44_w1_o2_mordu_posterieur_gauche_snapshot_0.png','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_ede3aa5c-bbba-4cf2-8caa-b2d5f671b311_LESC_760aa563-6e6f-4ae3-98cc-e3d5350a517e_SNAPS','44_w1_o2_mordu_posterieur_gauche_snapshot_0.png','52853284-be7b-44e5-aeae-65e139601fcd','{\"displayTitle\":\"Posterior left bite 1.44.1.2.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-21 19:25:38.000','2024-10-31 14:02:35.205','2024-10-31 10:02:35.205'),('53261a1f-1472-46ca-86b2-d31b93df25ea',664,'/var/.data/2022/664/7eac18e5-5ed2-4ed9-8b3e-eba1c562d708/session_c49716f1-987e-4111-9ab9-4541a0378bb7/occlusion_9a395a3e-4872-409e-922b-4bb58053d8a5/scan_ec557b87-5cb1-4e74-9d71-d45c543b3847/30_w1_o1_maxillaire_screenshot_53261a1f-1472-46ca-86b2-d31b93df25ea_0.png','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_TOSC_ec557b87-5cb1-4e74-9d71-d45c543b3847_SCREENS','30_w1_o1_maxillaire_screenshot_53261a1f-1472-46ca-86b2-d31b93df25ea_0.png','53261a1f-1472-46ca-86b2-d31b93df25ea','{\"displayTitle\":\"Screenshot 1.30.1.1.1 Maxilla 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxilla 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:09:51.000','2024-10-31 14:02:32.996','2024-10-31 10:02:32.996'),('53edd693-5bc2-11ee-9658-58a023cda0dc',664,'/var/.data/2023/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_eecd8fd5-572c-11ee-a378-58a023cda0dc/occlusion_eed0dd8b-572c-11ee-a378-58a023cda0dc/scan_ddf6985f-5bc1-11ee-9658-58a023cda0dc/53edd693-5bc2-11ee-9658-58a023cda0dc.zip','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_eecd8fd5-572c-11ee-a378-58a023cda0dc_SESS_eed0dd8b-572c-11ee-a378-58a023cda0dc_LESC_ddf6985f-5bc1-11ee-9658-58a023cda0dc_MODEL','53edd693-5bc2-11ee-9658-58a023cda0dc.zip','53edd693-5bc2-11ee-9658-58a023cda0dc','{\"displayTitle\":\"Left bite 1.32.2.1.1\",\"modelMatrix\":\"-0.907385,0.0214629,0.416501,0,-0.00517121,-0.996992,0.0749543,0,0.420659,0.0766923,0.906052,0,13.4961,-0.904238,-29.3595,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-09-25 12:41:11.000','2023-09-25 17:39:47.333','2023-09-25 13:39:47.333'),('53ede708-5bc2-11ee-9658-58a023cda0dc',664,'/var/.data/2023/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_eecd8fd5-572c-11ee-a378-58a023cda0dc/occlusion_eed0dd8b-572c-11ee-a378-58a023cda0dc/scan_ddf6985f-5bc1-11ee-9658-58a023cda0dc/53ede708-5bc2-11ee-9658-58a023cda0dc.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_eecd8fd5-572c-11ee-a378-58a023cda0dc_SESS_eed0dd8b-572c-11ee-a378-58a023cda0dc_LESC_ddf6985f-5bc1-11ee-9658-58a023cda0dc_SNAPS','53ede708-5bc2-11ee-9658-58a023cda0dc.png','53ede708-5bc2-11ee-9658-58a023cda0dc','{\"displayTitle\":\"Left bite 1.32.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-09-25 12:41:12.000','2023-09-25 17:39:47.342','2023-09-25 13:39:47.342'),('54152a5f-9466-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/54152a5f-9466-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_MODEL','54152a5f-9466-11ee-8fd8-58a023cda0dc.zip','87a0d07a-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1\",\"modelMatrix\":\"0.843881,0.502692,-0.187524,0,-0.53653,0.790659,-0.294947,0,3.33011e-09,0.349512,0.936932,0,-21.678,-3.20968,-22.8257,1\",\"scanBodies\":[]}','ZIP',10,'SYNCED',0,NULL,'2023-12-06 13:36:11.331','2023-12-06 19:12:08.103','2023-12-11 10:12:16.208'),('549c1ac9-11ed-4258-8ed5-7586d8615985',664,'/var/.data/2022/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_705960fa-3ed4-4013-9cde-20022721d122/occlusion_9f4fa7cb-81a3-460e-b189-ba76eb8cee15/scan_c865ffd7-f2b1-43ae-a10a-26300e29d86e/7_w8_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_705960fa-3ed4-4013-9cde-20022721d122_SESS_9f4fa7cb-81a3-460e-b189-ba76eb8cee15_LESC_c865ffd7-f2b1-43ae-a10a-26300e29d86e_SNAPS','7_w8_o1_mordu_posterieur_gauche_snapshot_0.png','549c1ac9-11ed-4258-8ed5-7586d8615985','{\"displayTitle\":\"Posterior left bite 1.7.8.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-30 17:18:20.000','2024-10-31 14:02:28.996','2024-10-31 10:02:28.996'),('54d26704-a1f5-457f-afc0-a8a096ef5c15',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_669f6bca-452c-4b2e-a49e-aa822628ed5f/24_w1_o1_maxillaire_scan_file_5.ply','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_TOSC_669f6bca-452c-4b2e-a49e-aa822628ed5f_MODEL','24_w1_o1_maxillaire_scan_file_5.ply','5ea87deb-c530-4c0d-9e39-e94f351d1354','{\"displayTitle\":\"Maxilla 1.24.1.1.1\",\"modelMatrix\":\"-0.999944,-0.00980338,0.00389464,0,0.0105487,-0.929296,0.369186,0,-2.71848e-10,0.369207,0.929347,0,18.3073,1.2474,-25.4183,1\",\"title\":\"Maxilla PLY\"}','PLY',5,'SYNCED',0,NULL,'2021-09-13 21:12:04.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.790'),('54f8089a-b17b-4de2-bfb5-8cdee0a85eb7',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_92704e83-dce3-4695-baad-1df750f09cd7/37_w2_o2_mandibule_ml_0_1.xyz','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_LIFI','37_w2_o2_mandibule_ml_0_1.xyz','0967d80d-992e-4d4b-ae94-bd981fca4791','{\"displayTitle\":\"Margin line Mandible 1.37.2.2.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2022-11-09 17:04:53.000','2024-10-31 14:02:36.077','2024-10-31 10:02:36.077'),('55075a59-6d21-4912-89a2-984a7c646584',664,'','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_2477bdb7-4cc4-460c-abf7-139095bc04f8_SESS_f3c53557-6667-45e0-9d95-e4f4366d4d71_TOSC_82ecab0e-29eb-4e22-957f-3c065a082b56_MODEL','7_w9_o1_maxillaire_scan_file_0.zip','55075a59-6d21-4912-89a2-984a7c646584','{\"displayTitle\":\"Maxilla 1.7.9.1.2\",\"modelMatrix\":\"0.892423,-0.353348,0.280582,0,0.451199,0.698884,-0.554961,0,-7.02278e-09,0.621858,0.78313,0,-17.2246,-21.7959,-24.2696,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:06:27.000','2022-03-30 12:56:07.000','2024-10-31 14:02:29.005','2024-10-31 10:02:29.005'),('55150fc7-4024-45fc-9b2f-f474826b2d4d',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_955946be-5764-4c34-9e84-61682f4fdf78/occlusion_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d/scan_84918ef7-2b0c-4acf-a14e-df7fcaff4812/33_w2_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_LESC_84918ef7-2b0c-4acf-a14e-df7fcaff4812_SNAPS','33_w2_o1_mordu_posterieur_gauche_snapshot_0.png','55150fc7-4024-45fc-9b2f-f474826b2d4d','{\"displayTitle\":\"Posterior left bite 1.33.2.1.3\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-01 15:37:20.000','2024-10-31 14:02:31.857','2024-10-31 10:02:31.857'),('55567078-7342-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/46c4cd1e-7338-11ee-b011-58a023cda0dc/session_ecbd4537-7341-11ee-b011-58a023cda0dc/occlusion_ecbe814b-7341-11ee-b011-58a023cda0dc/scan_ee9462c8-7341-11ee-b011-58a023cda0dc/55567078-7342-11ee-b011-58a023cda0dc.zip','PATIENT_46c4cd1e-7338-11ee-b011-58a023cda0dc_ACT_ecbd4537-7341-11ee-b011-58a023cda0dc_SESS_ecbe814b-7341-11ee-b011-58a023cda0dc_TOSC_ee9462c8-7341-11ee-b011-58a023cda0dc_MODEL','55567078-7342-11ee-b011-58a023cda0dc.zip','55567078-7342-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.54.1.1.1\",\"modelMatrix\":\"-0.0457021,0.980768,-0.189752,0,-0.998955,-0.04487,0.00868115,0,3.65349e-10,0.189951,0.981794,0,-5.75553,-15.4329,-21.0875,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-10-25 11:27:59.000','2023-10-30 13:47:02.671','2023-10-30 09:47:02.671'),('55567fa8-7342-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/46c4cd1e-7338-11ee-b011-58a023cda0dc/session_ecbd4537-7341-11ee-b011-58a023cda0dc/occlusion_ecbe814b-7341-11ee-b011-58a023cda0dc/scan_ee9462c8-7341-11ee-b011-58a023cda0dc/55567fa8-7342-11ee-b011-58a023cda0dc.png','PATIENT_46c4cd1e-7338-11ee-b011-58a023cda0dc_ACT_ecbd4537-7341-11ee-b011-58a023cda0dc_SESS_ecbe814b-7341-11ee-b011-58a023cda0dc_TOSC_ee9462c8-7341-11ee-b011-58a023cda0dc_SNAPS','55567fa8-7342-11ee-b011-58a023cda0dc.png','55567fa8-7342-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.54.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-10-25 11:28:00.000','2023-10-30 13:47:02.683','2023-10-30 09:47:02.683'),('556b1fdf-a302-4a96-b59d-60ce08e64532',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_6f4cc2d8-2239-4982-a8b0-33dc6be535ae/21_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_LESC_6f4cc2d8-2239-4982-a8b0-33dc6be535ae_SNAPS','21_w1_o1_mordu_posterieur_gauche_snapshot_0.png','556b1fdf-a302-4a96-b59d-60ce08e64532','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-28 18:58:51.000','2024-10-31 14:02:25.983','2024-10-31 10:02:25.983'),('55b4752c-9281-4cf2-8a88-4ddbfa881539',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_96711d60-288c-439f-b464-597833d56519/occlusion_a98f038e-a19a-47ad-af09-a22810e9d19c/scan_790f3bda-297c-41ad-812c-c6f5b135e445/14_w3_o1_maxillaire_scan_file_0.ply','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_96711d60-288c-439f-b464-597833d56519_SESS_a98f038e-a19a-47ad-af09-a22810e9d19c_TOSC_790f3bda-297c-41ad-812c-c6f5b135e445_MODEL','14_w3_o1_maxillaire_scan_file_0.ply','55b4752c-9281-4cf2-8a88-4ddbfa881539','{\"displayTitle\":\"Maxillaire 1.14.3.1.1\",\"modelMatrix\":\"-0.810865,0.557549,-0.17787,0,-0.585234,-0.772506,0.246446,0,9.50447e-9,0.30393,0.952694,0,12.8634,-15.3156,-19.4756,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-14 15:32:13.000','2024-10-31 14:02:32.458','2024-10-31 10:02:32.458'),('579610fb-1842-4dc6-8b36-ab5b5f876866',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_db740293-ae2a-40ae-9142-4d94ed66bcd5/occlusion_1256ab02-5172-4a92-a17d-f2fc402290ac/scan_b6033058-40f5-4202-bc4b-bfe024d70e70/7_w6_o1_maxillaire_scan_file_0.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_db740293-ae2a-40ae-9142-4d94ed66bcd5_SESS_1256ab02-5172-4a92-a17d-f2fc402290ac_TOSC_b6033058-40f5-4202-bc4b-bfe024d70e70_MODEL','7_w6_o1_maxillaire_scan_file_0.ply','579610fb-1842-4dc6-8b36-ab5b5f876866','{\"displayTitle\":\"Maxilla 1.7.6.1.4\",\"modelMatrix\":\"-0.975964,0.11593,-0.184539,0,-0.217932,-0.519168,0.82642,0,2.52062e-9,0.846773,0.531954,0,8.67413,-36.9726,-11.0486,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-05-05 16:23:13.000','2024-10-31 14:02:26.344','2024-10-31 10:02:26.344'),('5842bacb-24f3-4473-8d2f-ca5548e651cf',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/occlusion_e930782a-e2db-43e8-9ff1-9feb64e20e4e/scan_3b924f2a-18f4-4ed4-8e4e-efb6a1b36439/35_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_FRSC_3b924f2a-18f4-4ed4-8e4e-efb6a1b36439_SNAPS','35_w1_o1_mordu_anterieur_snapshot_0.png','5842bacb-24f3-4473-8d2f-ca5548e651cf','{\"displayTitle\":\"Anterior bite 1.35.1.1.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-06 20:41:45.000','2024-10-31 14:02:29.645','2024-10-31 10:02:29.645'),('5895fa2b-1f6a-44ac-8137-84d879d48bff',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_a72c11a4-05dc-4421-b252-fbfcecd2559e/occlusion_bf823edb-92ee-4ee9-acd3-507d49bad781/scan_088e0b86-45b9-4da8-a5e2-291e2939c699/14_w1_o1_maxillaire_scan_file_0.ply','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_a72c11a4-05dc-4421-b252-fbfcecd2559e_SESS_bf823edb-92ee-4ee9-acd3-507d49bad781_TOSC_088e0b86-45b9-4da8-a5e2-291e2939c699_MODEL','14_w1_o1_maxillaire_scan_file_0.ply','5895fa2b-1f6a-44ac-8137-84d879d48bff','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.52442,0.771292,-0.360682,0,-0.85146,-0.475044,0.222147,0,1.06884e-8,0.423605,0.905847,0,9.11931,-26.446,-10.9214,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-09-09 15:30:55.000','2024-10-31 14:02:32.671','2024-10-31 10:02:32.671'),('58ee5bee-0fd9-4bba-89cb-cf99f01eb438',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_92704e83-dce3-4695-baad-1df750f09cd7/37_w2_o2_mandibule_mlmeta_0_3.bin','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_LIFIM','37_w2_o2_mandibule_mlmeta_0_3.bin','130024ea-36bf-439a-980c-e464701bd4fb','{\"displayTitle\":\"Margin line Mandible 1.37.2.2.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',3,'SYNCED',0,NULL,'2022-11-09 17:07:29.000','2024-10-31 14:02:36.087','2024-10-31 10:02:36.087'),('5b12fd9e-03c6-4145-8366-7a8646402a7c',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_775311e4-a561-40c7-a2ce-76a0b1550be8/scan_8ce97d97-ffb5-461c-928d-ea25e722645a/41_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_775311e4-a561-40c7-a2ce-76a0b1550be8_LESC_8ce97d97-ffb5-461c-928d-ea25e722645a_MODEL','41_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','5b12fd9e-03c6-4145-8366-7a8646402a7c','{\"displayTitle\":\"Posterior left bite 1.41.1.1.1\",\"modelMatrix\":\"-0.931863,-0.0207082,0.362611,0,0.0579258,-0.991287,0.108292,0,0.35826,0.130506,0.925647,0,11.8752,-3.81516,-23.688,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-07-28 15:36:49.000','2024-10-31 14:02:32.199','2024-10-31 10:02:32.199'),('5b36e531-e913-4694-bd29-6c238ddae336',664,'/var/.data/2022/664/685697a1-0d50-4a06-8b3e-729cf9750f38/session_e1d214d2-2b62-484c-8ede-86b3f84573d3/occlusion_8cd0c724-d3d0-4821-a88b-42b03ae4eb07/scan_101a958b-c6e0-45d2-be43-01921415b27e/48_w1_o1_mandibule_snapshot_0.png','PATIENT_685697a1-0d50-4a06-8b3e-729cf9750f38_ACT_e1d214d2-2b62-484c-8ede-86b3f84573d3_SESS_8cd0c724-d3d0-4821-a88b-42b03ae4eb07_BOSC_101a958b-c6e0-45d2-be43-01921415b27e_SNAPS','48_w1_o1_mandibule_snapshot_0.png','5b36e531-e913-4694-bd29-6c238ddae336','{\"displayTitle\":\"Mandible 1.48.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-10-17 16:56:54.000','2024-10-31 14:02:35.316','2024-10-31 10:02:35.316'),('5bcef502-db73-4612-9311-f192c76e91fa',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_955946be-5764-4c34-9e84-61682f4fdf78/occlusion_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d/scan_5de08e77-210d-48b5-8004-9c536bb8530e/33_w2_o1_mordu_posterieur_droit_snapshot_1.png','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_RISC_5de08e77-210d-48b5-8004-9c536bb8530e_SNAPS','33_w2_o1_mordu_posterieur_droit_snapshot_1.png','b055178c-4263-48b5-b3f5-7d43da512f2f','{\"displayTitle\":\"Posterior right bite 1.33.2.1.4\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-08-01 15:50:52.000','2024-10-31 14:02:31.887','2024-10-31 10:02:31.887'),('5c07f751-3020-45a0-bf20-21a6ed8a6aea',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/occlusion_cacc103c-8b88-4be5-a787-b6b92341e9eb/scan_912aed9d-90da-48c3-b2d2-60c29e2eb2a2/34_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_SESS_cacc103c-8b88-4be5-a787-b6b92341e9eb_RISC_912aed9d-90da-48c3-b2d2-60c29e2eb2a2_SNAPS','34_w1_o1_mordu_posterieur_droit_snapshot_0.png','5c07f751-3020-45a0-bf20-21a6ed8a6aea','{\"displayTitle\":\"Posterior right bite 1.34.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-05-25 17:59:41.000','2024-10-31 14:02:29.285','2024-10-31 10:02:29.285'),('5c40acb9-f5bf-4d61-88d0-9d2dd66c3554',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/occlusion_cacc103c-8b88-4be5-a787-b6b92341e9eb/scan_ef34ef6f-c00c-49e4-85b3-2c0aed9adcc0/34_w1_o1_mandibule_scan_file_0.zip','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_SESS_cacc103c-8b88-4be5-a787-b6b92341e9eb_BOSC_ef34ef6f-c00c-49e4-85b3-2c0aed9adcc0_MODEL','34_w1_o1_mandibule_scan_file_0.zip','5c40acb9-f5bf-4d61-88d0-9d2dd66c3554','{\"displayTitle\":\"Mandible 1.34.1.1.1\",\"modelMatrix\":\"-0.499399,0.854797,-0.141147,0,-0.866372,-0.492727,0.0813606,0,-1.78546e-09,0.162917,0.98664,0,4.38877,1.71755,-20.1103,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-05-25 17:55:06.000','2024-10-31 14:02:29.265','2024-10-31 10:02:29.265'),('5d0397fc-6540-11ef-b382-58a023cda0dc',664,'/var/.data/2024/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_721d0cdd-6536-11ef-b382-58a023cda0dc/occlusion_721e3ad7-6536-11ef-b382-58a023cda0dc/scan_0f570c2a-6540-11ef-b382-58a023cda0dc/5d0397fc-6540-11ef-b382-58a023cda0dc.zip','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_721d0cdd-6536-11ef-b382-58a023cda0dc_SESS_721e3ad7-6536-11ef-b382-58a023cda0dc_FRSC_0f570c2a-6540-11ef-b382-58a023cda0dc_MODEL','5d0397fc-6540-11ef-b382-58a023cda0dc.zip','5d0397fc-6540-11ef-b382-58a023cda0dc','{\"displayTitle\":\"Anterior bite 1.35.2.1.1\",\"modelMatrix\":\"0.972445,-0.0717863,0.218962,0,0.0644453,0.994417,0.0769893,0,-0.224382,-0.0801587,0.972842,0,-5.81552,4.25127,-24.7887,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-08-28 09:25:34.000','2024-08-28 13:38:47.106','2024-08-28 09:38:47.106'),('5d03a767-6540-11ef-b382-58a023cda0dc',664,'/var/.data/2024/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_721d0cdd-6536-11ef-b382-58a023cda0dc/occlusion_721e3ad7-6536-11ef-b382-58a023cda0dc/scan_0f570c2a-6540-11ef-b382-58a023cda0dc/5d03a767-6540-11ef-b382-58a023cda0dc.png','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_721d0cdd-6536-11ef-b382-58a023cda0dc_SESS_721e3ad7-6536-11ef-b382-58a023cda0dc_FRSC_0f570c2a-6540-11ef-b382-58a023cda0dc_SNAPS','5d03a767-6540-11ef-b382-58a023cda0dc.png','5d03a767-6540-11ef-b382-58a023cda0dc','{\"displayTitle\":\"Anterior bite 1.35.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-08-28 09:25:34.000','2024-08-28 13:38:47.121','2024-08-28 09:38:47.121'),('5d5f4518-2d25-4373-8c05-e40c2e52e93d',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_96711d60-288c-439f-b464-597833d56519/occlusion_a98f038e-a19a-47ad-af09-a22810e9d19c/scan_300a55b7-e679-4993-b375-e0a3fe68f61d/14_w3_o1_mandibule_scan_file_1.ply','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_96711d60-288c-439f-b464-597833d56519_SESS_a98f038e-a19a-47ad-af09-a22810e9d19c_BOSC_300a55b7-e679-4993-b375-e0a3fe68f61d_MODEL','14_w3_o1_mandibule_scan_file_1.ply','6d5eff2a-0237-4ef2-9b70-904ad7378b7c','{\"displayTitle\":\"Mandibule 1.14.3.1.1\",\"modelMatrix\":\"0.828488,0.539417,-0.150454,0,-0.560007,0.798028,-0.222586,0,-6.37414e-9,0.268665,0.963234,0,-19.0906,-14.4868,-15.1692,1\",\"title\":\"Mandible PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-04-14 15:27:57.000','2024-10-31 14:02:32.426','2024-10-31 10:02:32.426'),('5d800334-a28a-499e-9ad8-6fae153904b2',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_7d40798f-7207-4c33-aa42-10afc814de77/scan_a0b85a0a-ef77-4f7c-b376-d6e388afe9f0/10_w1_o1_mandibule_screenshot_5d800334-a28a-499e-9ad8-6fae153904b2_0.png','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_BOSC_a0b85a0a-ef77-4f7c-b376-d6e388afe9f0_SCREENS','10_w1_o1_mandibule_screenshot_5d800334-a28a-499e-9ad8-6fae153904b2_0.png','5d800334-a28a-499e-9ad8-6fae153904b2','{\"displayTitle\":\"Screenshot 1.10.1.1.1 Mandible 1\",\"scanFileId\":\"c07ab4b3-ce6f-4eeb-859d-40b3c4631562\",\"scanFileType\":\"PLY\",\"scanPosition\":\"0.905663,-0.0275841,0.4231,0,-0.358092,-0.584087,0.728431,0,0.227034,-0.811222,-0.538864,0,0,0,0,1\",\"title\":\"Mandible 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 14:53:52.000','2024-10-31 14:02:32.291','2024-10-31 10:02:32.291'),('5d8fe096-165a-4a91-ae19-6cbe10470e9c',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_955946be-5764-4c34-9e84-61682f4fdf78/occlusion_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d/scan_722ff437-cef4-4d6b-861e-b52566d89c0d/33_w2_o1_mordu_anterieur_snapshot_0.png','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_FRSC_722ff437-cef4-4d6b-861e-b52566d89c0d_SNAPS','33_w2_o1_mordu_anterieur_snapshot_0.png','5d8fe096-165a-4a91-ae19-6cbe10470e9c','{\"displayTitle\":\"Anterior bite 1.33.2.1.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-01 15:28:42.000','2024-10-31 14:02:31.807','2024-10-31 10:02:31.807'),('5db64fac-8b70-48e7-9fdb-bf8db2a315d6',664,'','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_4fa51169-865e-4214-93fb-b93ba08fd9d3_SESS_a2816a91-70d4-492e-af69-b69e3c134704_TOSC_a6f3b498-07ce-489a-805c-c6bc2ac7d0d9_SNAPS','','5db64fac-8b70-48e7-9fdb-bf8db2a315d6','{\"displayTitle\":\"Maxilla 1.7.5.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,'2022-03-14 14:42:22.000','2021-05-03 20:18:48.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.280'),('5e5384eb-0822-41cf-9105-f8761f20244b',664,'/var/.data/2022/664/635617fc-289b-470c-a4d4-678d7b5f275a/session_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6/occlusion_94dc9a16-b72c-4f6a-a520-ba83c28954c3/scan_0760cff5-4209-42a6-8b7f-d0a749485c14/45_w1_o1_maxillaire_scan_file_0.zip','PATIENT_635617fc-289b-470c-a4d4-678d7b5f275a_ACT_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6_SESS_94dc9a16-b72c-4f6a-a520-ba83c28954c3_TOSC_0760cff5-4209-42a6-8b7f-d0a749485c14_MODEL','45_w1_o1_maxillaire_scan_file_0.zip','5e5384eb-0822-41cf-9105-f8761f20244b','{\"displayTitle\":\"Maxilla 1.45.1.1.1\",\"modelMatrix\":\"-0.414563,0.707587,-0.572239,0,-0.91002,-0.322344,0.260686,0,5.47539e-09,0.62882,0.777551,0,15.6758,-19.6026,-15.6215,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-07 16:26:02.000','2024-10-31 14:02:33.291','2024-10-31 10:02:33.291'),('5ea87deb-c530-4c0d-9e39-e94f351d1354',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_669f6bca-452c-4b2e-a49e-aa822628ed5f/24_w1_o1_maxillaire_scan_file_0.ply','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_TOSC_669f6bca-452c-4b2e-a49e-aa822628ed5f_MODEL','24_w1_o1_maxillaire_scan_file_0.ply','5ea87deb-c530-4c0d-9e39-e94f351d1354','{\"displayTitle\":\"Maxilla 1.24.1.1.1\",\"modelMatrix\":\"-0.999944,-0.00980338,0.00389464,0,0.0105487,-0.929296,0.369186,0,-2.71848e-10,0.369207,0.929347,0,18.3073,1.2474,-25.4183,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-13 21:08:22.000','2024-10-31 14:02:28.653','2024-10-31 10:02:28.653'),('5f456e24-d7a0-4914-86d8-b3fd9c64f460',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_3ce0c78e-551a-4871-80c4-435836bf1dc5/32_w1_o1_mandibule_snapshot_1.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_BOSC_3ce0c78e-551a-4871-80c4-435836bf1dc5_SNAPS','32_w1_o1_mandibule_snapshot_1.png','838a7ccd-cc6e-4939-812b-73553d4877f6','{\"displayTitle\":\"Mandible 1.32.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-03-23 16:36:02.000','2024-10-31 14:02:32.863','2024-10-31 10:02:32.863'),('5f587583-02ae-40f7-97af-d3cf1fd26edb',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_20f1e04b-48d2-4b9a-b29b-2a62332288fb/24_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_FRSC_20f1e04b-48d2-4b9a-b29b-2a62332288fb_SNAPS','24_w1_o1_mordu_anterieur_snapshot_0.png','5f587583-02ae-40f7-97af-d3cf1fd26edb','{\"displayTitle\":\"Mordu anterieur 1.24.1.1.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-13 21:30:59.000','2024-10-31 14:02:28.610','2024-10-31 10:02:28.610'),('5f9a60ab-9466-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/5f9a60ab-9466-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_MODEL','5f9a60ab-9466-11ee-8fd8-58a023cda0dc.zip','87a0d07a-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1\",\"modelMatrix\":\"0.843881,0.502692,-0.187524,0,-0.53653,0.790659,-0.294947,0,3.33011e-09,0.349512,0.936932,0,-21.678,-3.20968,-22.8257,1\",\"scanBodies\":[]}','ZIP',11,'SYNCED',0,NULL,'2023-12-06 13:36:30.659','2023-12-06 19:12:08.104','2023-12-11 10:12:18.653'),('5fd9a4c4-c58e-41b8-893c-31ce5772a9da',664,'/var/.data/2021/664/e648cc66-9340-456c-a379-50836d1b8a5b/session_f09c328f-1a8b-4f63-8998-2f9b57cd3c76/occlusion_2c19cd55-a36e-4dc7-8954-ea8a8eeacd16/scan_19fe3d64-fac4-4182-90d9-fb19f29bc385/16_w1_o1_mandibule_scan_file_0.ply','PATIENT_e648cc66-9340-456c-a379-50836d1b8a5b_ACT_f09c328f-1a8b-4f63-8998-2f9b57cd3c76_SESS_2c19cd55-a36e-4dc7-8954-ea8a8eeacd16_BOSC_19fe3d64-fac4-4182-90d9-fb19f29bc385_MODEL','16_w1_o1_mandibule_scan_file_0.ply','5fd9a4c4-c58e-41b8-893c-31ce5772a9da','{\"displayTitle\":\"Mandibule 1.16.1.1.1\",\"modelMatrix\":\"0.740946,0.588635,-0.323276,0,-0.671564,0.649449,-0.356675,0,1.42333e-9,0.481377,0.876513,0,-28.689,-7.41031,-17.9005,1\",\"title\":\"Mandible PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-01-18 17:51:04.000','2024-10-31 14:02:26.230','2024-10-31 10:02:26.230'),('5fed9792-e66c-44cb-bf74-89f2ea0ffd0a',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_4b1e4a8e-c35a-4205-bb29-2132e2649b4a/27_w1_o1_maxillaire_scan_file_0.zip','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_TOSC_4b1e4a8e-c35a-4205-bb29-2132e2649b4a_MODEL','27_w1_o1_maxillaire_scan_file_0.zip','5fed9792-e66c-44cb-bf74-89f2ea0ffd0a','{\"displayTitle\":\"Maxillaire 1.27.1.1.4\",\"modelMatrix\":\"-0.74814,0.652116,-0.122601,0,-0.663541,-0.735259,0.138233,0,2.91436e-9,0.184768,0.982782,0,14.5365,-31.3492,-22.1246,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-04 18:48:17.000','2024-10-31 14:02:28.511','2024-10-31 10:02:28.511'),('6017b07e-9997-4cd7-9d25-35063c26e897',664,'/var/.data/2021/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_119ba34e-97cf-4c1f-bed9-20fa56366355/occlusion_585f84a0-017e-4b5a-9465-7947c2ada0b3/scan_21c82eed-acf4-4093-986f-a306c3e0c043/18_w3_o1_maxillaire_snapshot_1.png','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_119ba34e-97cf-4c1f-bed9-20fa56366355_SESS_585f84a0-017e-4b5a-9465-7947c2ada0b3_TOSC_21c82eed-acf4-4093-986f-a306c3e0c043_SNAPS','18_w3_o1_maxillaire_snapshot_1.png','c4c91852-4807-43b3-8a79-23452bff9563','{\"displayTitle\":\"Maxillaire 1.18.3.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-10-27 19:58:51.000','2024-10-31 14:02:25.934','2024-10-31 10:02:25.934'),('607ef93e-cc9b-4019-ab49-d0f0e598ea16',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_406263f6-a620-460e-a1e0-2d50ff84809c/32_w1_o1_maxillaire_screenshot_607ef93e-cc9b-4019-ab49-d0f0e598ea16_0.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_TOSC_406263f6-a620-460e-a1e0-2d50ff84809c_SCREENS','32_w1_o1_maxillaire_screenshot_607ef93e-cc9b-4019-ab49-d0f0e598ea16_0.png','607ef93e-cc9b-4019-ab49-d0f0e598ea16','{\"displayTitle\":\"Screenshot 1.32.1.1.1 Maxilla 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxilla 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:07:05.000','2024-10-31 14:02:32.818','2024-10-31 10:02:32.818'),('6103a761-4255-42c2-a7dd-e05a49a38969',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/order_ce9127f7-b01e-4e28-b330-8f397f2a043e/33_w1_couronne_sur_implant_prost_file_6103a761-4255-42c2-a7dd-e05a49a38969_0.pdf','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_PROST_ce9127f7-b01e-4e28-b330-8f397f2a043e_FORM','33_w1_couronne_sur_implant_prost_file_6103a761-4255-42c2-a7dd-e05a49a38969_0.pdf','6103a761-4255-42c2-a7dd-e05a49a38969','{\"displayTitle\":\"ORDER 1.33.1.1 IMPLANT CROWN\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-04-14 15:12:56.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.257'),('6184838a-83fc-4590-8e86-06602269b835',664,'/var/.data/2022/664/e33159c9-a713-4a37-ba98-9ec2e2e213e7/session_b63ca765-4d68-4cf4-9707-4ad3a19f3236/occlusion_ae7f89c9-26ec-4cee-b377-d5145e6c6aae/scan_02523859-58d9-4417-a657-9de246f248ae/50_w1_o1_maxillaire_scan_file_0.zip','PATIENT_e33159c9-a713-4a37-ba98-9ec2e2e213e7_ACT_b63ca765-4d68-4cf4-9707-4ad3a19f3236_SESS_ae7f89c9-26ec-4cee-b377-d5145e6c6aae_TOSC_02523859-58d9-4417-a657-9de246f248ae_MODEL','50_w1_o1_maxillaire_scan_file_0.zip','6184838a-83fc-4590-8e86-06602269b835','{\"displayTitle\":\"Maxilla 1.50.1.1.3\",\"modelMatrix\":\"0.51838,0.825922,-0.221663,0,-0.85515,0.500662,-0.134369,0,1.6645e-08,0.259209,0.965821,0,-24.5216,-15.2815,-18.4446,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-14 18:12:08.000','2024-10-31 14:02:36.158','2024-10-31 10:02:36.158'),('61fa2c39-4c85-4ea9-b705-312c82b6b8cf',664,'/var/.data/2022/664/cede029c-15bc-44c2-9c9c-fac7f8983524/session_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29/occlusion_4d46a627-5949-4b2a-b4d6-c391f159485b/scan_3558dd42-4c4f-44fb-9e18-6c3609025ffc/46_w1_o1_maxillaire_snapshot_0.png','PATIENT_cede029c-15bc-44c2-9c9c-fac7f8983524_ACT_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29_SESS_4d46a627-5949-4b2a-b4d6-c391f159485b_TOSC_3558dd42-4c4f-44fb-9e18-6c3609025ffc_SNAPS','46_w1_o1_maxillaire_snapshot_0.png','61fa2c39-4c85-4ea9-b705-312c82b6b8cf','{\"displayTitle\":\"Maxilla 1.46.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-12 20:27:04.000','2024-10-31 14:02:35.112','2024-10-31 10:02:35.112'),('6265f500-2b38-4e2a-af4e-2b889b8cd5f6',664,'','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_2477bdb7-4cc4-460c-abf7-139095bc04f8_SESS_f3c53557-6667-45e0-9d95-e4f4366d4d71_TOSC_82ecab0e-29eb-4e22-957f-3c065a082b56_SNAPS','7_w9_o1_maxillaire_snapshot_0.png','6265f500-2b38-4e2a-af4e-2b889b8cd5f6','{\"displayTitle\":\"Maxilla 1.7.9.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:06:36.000','2022-03-30 12:56:06.000','2024-10-31 14:02:29.013','2024-10-31 10:02:29.013'),('62bf9730-f940-4f6c-a6cc-097860ffdb9d',664,'/var/.data/2021/664/366ffa87-059a-436a-9125-8827b3a2da1a/session_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9/occlusion_a59f40f9-2208-4d6a-b286-f64533d92e3c/scan_c17d800a-58c0-4658-b29b-d8ee0cbd16bb/15_w1_o1_mordu_anterieur_scan_file_0.ply','PATIENT_366ffa87-059a-436a-9125-8827b3a2da1a_ACT_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9_SESS_a59f40f9-2208-4d6a-b286-f64533d92e3c_FRSC_c17d800a-58c0-4658-b29b-d8ee0cbd16bb_MODEL','15_w1_o1_mordu_anterieur_scan_file_0.ply','62bf9730-f940-4f6c-a6cc-097860ffdb9d','{\"displayTitle\":\"Mordu anterieur 1.15.1.1.1\",\"modelMatrix\":\"0.996744,0.0720922,0.0587105,0,-0.045079,0.99239,-0.094337,0,-0.0701313,0.102581,0.993913,0,-2.2834,-2.95306,-21.4527,1\",\"title\":\"Anterior bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-01-18 21:39:02.000','2024-10-31 14:02:25.857','2024-10-31 10:02:25.857'),('62f54f6a-ef8d-42ba-8d34-1edc178619aa',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/order_52de723f-4bdd-4b2d-87a6-fb648e680fbb/41_w1_couronne_sur_implant_prost_file_62f54f6a-ef8d-42ba-8d34-1edc178619aa_0.pdf','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_PROST_52de723f-4bdd-4b2d-87a6-fb648e680fbb_FORM','41_w1_couronne_sur_implant_prost_file_62f54f6a-ef8d-42ba-8d34-1edc178619aa_0.pdf','62f54f6a-ef8d-42ba-8d34-1edc178619aa','{\"displayTitle\":\"ORDER 1.41.1.4 Karen Lindsey: IMPLANT CROWN#6\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'CREATED',0,NULL,'2022-10-19 20:03:56.000','2023-05-17 17:16:39.559',NULL),('646bc5fd-fb97-4373-bb66-aa1a4b456f59',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_b5dae369-a773-4095-aa54-7c8b75c939d8/occlusion_a12bd271-974e-4fcf-8893-d88105690bce/scan_e1f9f752-dd61-4e2b-82d8-016edf9173cf/7_w3_o1_maxillaire_scan_file_3.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_b5dae369-a773-4095-aa54-7c8b75c939d8_SESS_a12bd271-974e-4fcf-8893-d88105690bce_TOSC_e1f9f752-dd61-4e2b-82d8-016edf9173cf_MODEL','7_w3_o1_maxillaire_scan_file_3.ply','b89bdf45-07f7-4aef-b272-f9b581b06b02','{\"displayTitle\":\"Maxilla 1.7.3.1.1\",\"modelMatrix\":\"0.353491,0.735052,-0.57857,0,-0.935438,0.277767,-0.218635,0,2.08057e-8,0.618502,0.785783,0,4.33116,-47.3843,-20.4717,1\",\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":10,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":3,\"title\":\"Maxilla PLY\"}','PLY',3,'SYNCED',0,NULL,'2021-04-28 17:11:46.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.276'),('64b8d5bc-8386-44be-ac0b-8657f8a52953',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_db740293-ae2a-40ae-9142-4d94ed66bcd5/occlusion_1256ab02-5172-4a92-a17d-f2fc402290ac/scan_b6033058-40f5-4202-bc4b-bfe024d70e70/7_w6_o1_maxillaire_snapshot_1.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_db740293-ae2a-40ae-9142-4d94ed66bcd5_SESS_1256ab02-5172-4a92-a17d-f2fc402290ac_TOSC_b6033058-40f5-4202-bc4b-bfe024d70e70_SNAPS','7_w6_o1_maxillaire_snapshot_1.png','d31fff53-e769-4756-bc68-5aeea0d528b5','{\"displayTitle\":\"Maxilla 1.7.6.1.4\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-05-05 16:27:02.000','2024-10-31 14:02:26.365','2024-10-31 10:02:26.365'),('64d43c5c-3568-4131-b63f-56fd0f1c6e22',664,'','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_TOSC_4881f615-e5ee-4e32-a293-eb41e56db31d_MODEL','','64d43c5c-3568-4131-b63f-56fd0f1c6e22','{\"displayTitle\":\"Maxilla 1.21.1.1.3\",\"modelMatrix\":\"0.941469,0.291679,-0.168997,0,-0.3371,0.814613,-0.471983,0,1.10302e-8,0.501327,0.865258,0,-17.5846,-42.4379,-12.0436,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'CREATED',0,'2021-04-28 18:43:15.000','2021-04-28 18:42:58.000','2023-05-17 17:16:39.559',NULL),('65c962f0-734f-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/computedocclusion_5f6427a6-734f-11ee-b011-58a023cda0dc/65c962f0-734f-11ee-b011-58a023cda0dc.zip','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_OCC_5f6427a6-734f-11ee-b011-58a023cda0dc_TOPLY','65c962f0-734f-11ee-b011-58a023cda0dc.zip','65c962f0-734f-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Occlusion 1.7.10.1.1 Maxilla\",\"modelMatrix\":\"-0.274572,0.896288,-0.348249,0,-0.961566,-0.255932,0.0994415,0,1.67999e-09,0.362168,0.932113,0,22.9321,-18.3261,-15.2245,1\",\"occlusionMatrix\":\"-0.993656,0.105737,0.0382992,0,-0.0931629,-0.964704,0.246307,0,0.0629912,0.241176,0.968435,0,21.352,11.5491,-21.6451,1\",\"occlusionType\":5,\"referenceScanId\":\"55e90c19-734b-11ee-b011-58a023cda0dc\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-10-25 11:59:40.000','2023-10-30 13:28:06.509','2023-10-30 09:28:06.509'),('65e55379-ecc4-474a-8247-2d78e5bad08b',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_36d05387-51e6-4286-a074-7c7894c0622b/occlusion_0ec93b21-a91f-4695-a966-e072a8fb68e3/scan_5212b119-1f64-4de6-82e2-b5b72ee0e22b/7_w7_o1_maxillaire_snapshot_2.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_36d05387-51e6-4286-a074-7c7894c0622b_SESS_0ec93b21-a91f-4695-a966-e072a8fb68e3_TOSC_5212b119-1f64-4de6-82e2-b5b72ee0e22b_SNAPS','7_w7_o1_maxillaire_snapshot_2.png','6e75df3d-e558-4cc6-8263-62b0654e0206','{\"displayTitle\":\"Maxilla 1.7.7.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2021-05-05 17:04:39.000','2024-10-31 14:02:26.639','2024-10-31 10:02:26.639'),('65f84d65-734f-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/computedocclusion_5f6427a6-734f-11ee-b011-58a023cda0dc/65f84d65-734f-11ee-b011-58a023cda0dc.zip','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_OCC_5f6427a6-734f-11ee-b011-58a023cda0dc_BOPLY','65f84d65-734f-11ee-b011-58a023cda0dc.zip','65f84d65-734f-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Occlusion 1.7.10.1.1 Mandible\",\"modelMatrix\":\"-0.298068,0.938491,-0.174326,0,-0.954545,-0.293055,0.0544354,0,2.04117e-09,0.182627,0.983182,0,-11.5041,-37.3149,-18.2456,1\",\"occlusionMatrix\":\"-0.938845,0.21398,0.269808,0,0.162427,0.966045,-0.200955,0,-0.303646,-0.144839,-0.941714,0,32.9592,17.4427,6.85532,1\",\"occlusionType\":5,\"referenceScanId\":\"f3804f47-734c-11ee-b011-58a023cda0dc\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-10-25 11:59:43.000','2023-10-30 13:28:06.524','2023-10-30 09:28:06.524'),('668d19f2-734f-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/computedocclusion_5f6427a6-734f-11ee-b011-58a023cda0dc/668d19f2-734f-11ee-b011-58a023cda0dc.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_OCC_5f6427a6-734f-11ee-b011-58a023cda0dc_SNAPO','668d19f2-734f-11ee-b011-58a023cda0dc.png','668d19f2-734f-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Occlusion 1.7.10.1.1 Snapshot\",\"occlusionType\":5}','PNG',0,'SYNCED',0,NULL,'2023-10-25 11:59:44.000','2023-10-30 13:28:06.540','2023-10-30 09:28:06.540'),('669d8672-cb26-496c-9001-2d39cb057249',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_4fa51169-865e-4214-93fb-b93ba08fd9d3/occlusion_a2816a91-70d4-492e-af69-b69e3c134704/scan_7f9b3767-26d0-40f2-b0dd-07da9d57ad85/7_w5_o1_maxillaire_scan_file_0.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_4fa51169-865e-4214-93fb-b93ba08fd9d3_SESS_a2816a91-70d4-492e-af69-b69e3c134704_TOSC_7f9b3767-26d0-40f2-b0dd-07da9d57ad85_MODEL','7_w5_o1_maxillaire_scan_file_0.ply','669d8672-cb26-496c-9001-2d39cb057249','{\"displayTitle\":\"Maxilla 1.7.5.1.2\",\"modelMatrix\":\"0.875887,-0.0683008,-0.477658,0,-0.482516,-0.123983,-0.867068,0,-7.24755e-10,0.989931,-0.141551,0,-9.5807,-50.4331,13.5897,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-05-03 20:38:24.000','2024-10-31 14:02:26.431','2024-10-31 10:02:26.431'),('66c14e8c-5b99-4217-b257-477985f8a5ab',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_62fd085a-7b18-4cdf-aa97-db92a842f34f/32_w1_o1_mordu_posterieur_droit_screenshot_66c14e8c-5b99-4217-b257-477985f8a5ab_0.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_RISC_62fd085a-7b18-4cdf-aa97-db92a842f34f_SCREENS','32_w1_o1_mordu_posterieur_droit_screenshot_66c14e8c-5b99-4217-b257-477985f8a5ab_0.png','66c14e8c-5b99-4217-b257-477985f8a5ab','{\"displayTitle\":\"Screenshot 1.32.1.1.1 Posterior right bite 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Posterior right bite 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:07:36.000','2024-10-31 14:02:32.917','2024-10-31 10:02:32.917'),('66fd1060-c3ed-464a-9c7e-950a0d2ba8f4',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_4fa51169-865e-4214-93fb-b93ba08fd9d3/occlusion_a2816a91-70d4-492e-af69-b69e3c134704/scan_7f9b3767-26d0-40f2-b0dd-07da9d57ad85/7_w5_o1_maxillaire_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_4fa51169-865e-4214-93fb-b93ba08fd9d3_SESS_a2816a91-70d4-492e-af69-b69e3c134704_TOSC_7f9b3767-26d0-40f2-b0dd-07da9d57ad85_SNAPS','7_w5_o1_maxillaire_snapshot_0.png','66fd1060-c3ed-464a-9c7e-950a0d2ba8f4','{\"displayTitle\":\"Maxilla 1.7.5.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-05-03 20:38:24.000','2024-10-31 14:02:26.454','2024-10-31 10:02:26.454'),('670e4cd5-deb9-4439-bb01-01da02cc1a1f',664,'/var/.data/2021/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_119ba34e-97cf-4c1f-bed9-20fa56366355/occlusion_585f84a0-017e-4b5a-9465-7947c2ada0b3/scan_21c82eed-acf4-4093-986f-a306c3e0c043/18_w3_o1_maxillaire_scan_file_1.zip','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_119ba34e-97cf-4c1f-bed9-20fa56366355_SESS_585f84a0-017e-4b5a-9465-7947c2ada0b3_TOSC_21c82eed-acf4-4093-986f-a306c3e0c043_MODEL','18_w3_o1_maxillaire_scan_file_1.zip','923d8e02-07de-4a6f-b0d0-df13d765b4c1','{\"displayTitle\":\"Maxillaire 1.18.3.1.2\",\"modelMatrix\":\"-0.87619,0.190631,-0.442663,0,-0.481965,-0.346557,0.804741,0,-4.75171e-9,0.918454,0.395527,0,25.4375,-2.30648,-5.54849,1\",\"title\":\"Maxilla ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2021-10-27 19:58:54.000','2024-10-31 14:02:25.951','2024-10-31 10:02:25.951'),('67975c64-090d-427e-b49e-b2887c0f4e98',664,'','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_BOSC_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20_LIFI','37_w2_o1_mandibule_ml_0_0.xyz','67975c64-090d-427e-b49e-b2887c0f4e98','{\"displayTitle\":\"Margin line Mandible 1.37.2.1.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2023-05-22 09:06:38.000','2022-11-02 14:29:57.000','2024-10-31 14:02:35.730','2024-10-31 10:02:35.730'),('67b3f8a8-178c-4668-90fa-b3ad09dd67ff',664,'/var/.data/2022/664/7eac18e5-5ed2-4ed9-8b3e-eba1c562d708/session_c49716f1-987e-4111-9ab9-4541a0378bb7/occlusion_9a395a3e-4872-409e-922b-4bb58053d8a5/scan_b6b465bc-cccb-49a9-ba82-6a6e82cd4324/30_w1_o1_mordu_posterieur_gauche_screenshot_67b3f8a8-178c-4668-90fa-b3ad09dd67ff_0.png','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_LESC_b6b465bc-cccb-49a9-ba82-6a6e82cd4324_SCREENS','30_w1_o1_mordu_posterieur_gauche_screenshot_67b3f8a8-178c-4668-90fa-b3ad09dd67ff_0.png','67b3f8a8-178c-4668-90fa-b3ad09dd67ff','{\"displayTitle\":\"Screenshot 1.30.1.1.1 Posterior left bite 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Posterior left bite 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:10:07.000','2024-10-31 14:02:33.071','2024-10-31 10:02:33.071'),('6887579a-3781-49f4-a96e-de18760adf09',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_6630e34a-9b19-4727-9ef0-e1c95c341549/scan_428484bf-df10-43b1-a7ed-6f2f0ac47336/44_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_6630e34a-9b19-4727-9ef0-e1c95c341549_LESC_428484bf-df10-43b1-a7ed-6f2f0ac47336_MODEL','44_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','6887579a-3781-49f4-a96e-de18760adf09','{\"displayTitle\":\"Posterior left bite 1.44.1.1.1\",\"modelMatrix\":\"-0.989527,-0.138095,0.0458312,0,0.14074,-0.98477,0.102761,0,0.0321141,0.10567,0.993653,0,18.9608,-0.722091,-18.187,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-07 15:16:14.000','2024-10-31 14:02:33.272','2024-10-31 10:02:33.272'),('69340322-ace1-4247-abd4-90fd70f47a5c',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_3ce0c78e-551a-4871-80c4-435836bf1dc5/32_w1_o1_mandibule_screenshot_69340322-ace1-4247-abd4-90fd70f47a5c_0.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_BOSC_3ce0c78e-551a-4871-80c4-435836bf1dc5_SCREENS','32_w1_o1_mandibule_screenshot_69340322-ace1-4247-abd4-90fd70f47a5c_0.png','69340322-ace1-4247-abd4-90fd70f47a5c','{\"displayTitle\":\"Screenshot 1.32.1.1.1 Mandible 3\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Mandible 3\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:07:32.000','2024-10-31 14:02:32.871','2024-10-31 10:02:32.871'),('69546cbc-375a-4296-85e4-51c63cf5e93b',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_b5dae369-a773-4095-aa54-7c8b75c939d8/occlusion_a12bd271-974e-4fcf-8893-d88105690bce/scan_e1f9f752-dd61-4e2b-82d8-016edf9173cf/7_w3_o1_maxillaire_snapshot_1.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_b5dae369-a773-4095-aa54-7c8b75c939d8_SESS_a12bd271-974e-4fcf-8893-d88105690bce_TOSC_e1f9f752-dd61-4e2b-82d8-016edf9173cf_SNAPS','7_w3_o1_maxillaire_snapshot_1.png','c6011a67-944d-4d49-a5fc-254bd45f74dd','{\"displayTitle\":\"Maxillaire 1.7.3.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-04-28 17:09:03.000','2024-10-31 14:02:26.541','2024-10-31 10:02:26.541'),('69731f43-c0fd-48a8-8047-733b892d60b8',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20/37_w2_o1_mandibule_mlmeta_0_4.bin','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_BOSC_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20_LIFIM','37_w2_o1_mandibule_mlmeta_0_4.bin','ed062015-5ce9-4d64-a982-e1d9ccfc2c5f','{\"displayTitle\":\"Margin line Mandible 1.37.2.1.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',4,'SYNCED',0,NULL,'2022-11-02 19:35:04.000','2024-10-31 14:02:35.744','2024-10-31 10:02:35.744'),('6adbd107-a4ca-46d3-8650-9b52e9259a8f',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_92704e83-dce3-4695-baad-1df750f09cd7/37_w2_o2_mandibule_mlmeta_0_2.bin','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_LIFIM','37_w2_o2_mandibule_mlmeta_0_2.bin','130024ea-36bf-439a-980c-e464701bd4fb','{\"displayTitle\":\"Margin line Mandible 1.37.2.2.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',2,'SYNCED',0,NULL,'2022-11-09 17:05:37.000','2024-10-31 14:02:36.097','2024-10-31 10:02:36.097'),('6b191299-9fed-4391-9cc7-258eddfaf7df',664,'/var/.data/2021/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_5b122c87-c24b-4f13-9df8-3025089e3bc1/occlusion_aa05c648-fa52-43e7-ae5a-2d1a00059796/scan_d19c7af8-1f07-4857-86c3-e29963c1f9c9/18_w2_o1_maxillaire_snapshot_0.png','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_5b122c87-c24b-4f13-9df8-3025089e3bc1_SESS_aa05c648-fa52-43e7-ae5a-2d1a00059796_TOSC_d19c7af8-1f07-4857-86c3-e29963c1f9c9_SNAPS','18_w2_o1_maxillaire_snapshot_0.png','6b191299-9fed-4391-9cc7-258eddfaf7df','{\"displayTitle\":\"Maxillaire 1.18.2.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-03 18:05:40.000','2024-10-31 14:02:25.904','2024-10-31 10:02:25.904'),('6ba3b93c-7fe0-487d-85f2-f5ecce29c698',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_ec92e295-bf7c-4746-b7d5-8b1307a8e6ac/21_w1_o1_mordu_posterieur_droit_scan_file_1.ply','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_RISC_ec92e295-bf7c-4746-b7d5-8b1307a8e6ac_MODEL','21_w1_o1_mordu_posterieur_droit_scan_file_1.ply','f6f7c4d2-5903-4304-a422-d9bb1e118dc3','{\"displayTitle\":\"Mordu posterieur droit 1.21.1.1.1\",\"modelMatrix\":\"0.999196,0.0376281,0.00166023,0,-0.0395367,0.985834,0.166662,0,0.00763938,-0.1635,0.986021,0,-17.4462,11.8313,-15.3273,1\",\"title\":\"Posterior right bite PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-04-28 18:56:21.000','2024-10-31 14:02:26.052','2024-10-31 10:02:26.052'),('6d5eff2a-0237-4ef2-9b70-904ad7378b7c',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_96711d60-288c-439f-b464-597833d56519/occlusion_a98f038e-a19a-47ad-af09-a22810e9d19c/scan_300a55b7-e679-4993-b375-e0a3fe68f61d/14_w3_o1_mandibule_scan_file_0.ply','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_96711d60-288c-439f-b464-597833d56519_SESS_a98f038e-a19a-47ad-af09-a22810e9d19c_BOSC_300a55b7-e679-4993-b375-e0a3fe68f61d_MODEL','14_w3_o1_mandibule_scan_file_0.ply','6d5eff2a-0237-4ef2-9b70-904ad7378b7c','{\"displayTitle\":\"Mandible 1.14.3.1.1\",\"modelMatrix\":\"0.784583,0.595627,-0.172214,0,-0.620024,0.753712,-0.217921,0,-7.24995e-9,0.277754,0.960652,0,-18.1506,-15.8246,-14.7932,1\",\"title\":\"Mandible PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-14 15:25:15.000','2024-10-31 14:02:32.413','2024-10-31 10:02:32.413'),('6d9a82f6-9467-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/6d9a82f6-9467-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_MODEL','6d9a82f6-9467-11ee-8fd8-58a023cda0dc.zip','87a0d07a-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1\",\"modelMatrix\":\"0.438417,0.85391,-0.280407,0,-0.898772,0.416533,-0.136781,0,1.62365e-09,0.311989,0.950086,0,-20.5073,-13.9552,-19.119,1\",\"scanBodies\":[]}','ZIP',12,'SYNCED',0,NULL,'2023-12-11 10:12:23.000','2024-10-31 14:02:37.377','2024-10-31 10:02:37.377'),('6d9a913f-9467-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/6d9a913f-9467-11ee-8fd8-58a023cda0dc.png','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_SNAPS','6d9a913f-9467-11ee-8fd8-58a023cda0dc.png','87a0e23e-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-12-11 10:12:24.000','2024-10-31 14:02:37.400','2024-10-31 10:02:37.400'),('6de59b7c-2c5e-4755-8fd6-c921b746bc1b',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_120f9fe3-b23d-49c7-89ab-f1becc102f6c/scan_b08eb59b-89c3-4239-8926-d8eb829e4257/33_w1_o1_mandibule_mlmeta_0_0.bin','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_120f9fe3-b23d-49c7-89ab-f1becc102f6c_BOSC_b08eb59b-89c3-4239-8926-d8eb829e4257_LIFIM','33_w1_o1_mandibule_mlmeta_0_0.bin','6de59b7c-2c5e-4755-8fd6-c921b746bc1b','{\"displayTitle\":\"Margin line Mandible 1.33.1.1.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2022-04-14 15:18:16.000','2024-10-31 14:02:29.225','2024-10-31 10:02:29.225'),('6e6f5ec1-9749-41d4-9cf9-d9f1b5307d64',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_406263f6-a620-460e-a1e0-2d50ff84809c/32_w1_o1_maxillaire_screenshot_6e6f5ec1-9749-41d4-9cf9-d9f1b5307d64_0.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_TOSC_406263f6-a620-460e-a1e0-2d50ff84809c_SCREENS','32_w1_o1_maxillaire_screenshot_6e6f5ec1-9749-41d4-9cf9-d9f1b5307d64_0.png','6e6f5ec1-9749-41d4-9cf9-d9f1b5307d64','{\"displayTitle\":\"Screenshot 1.32.1.1.1 Maxilla 2\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxilla 2\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:07:18.000','2024-10-31 14:02:32.830','2024-10-31 10:02:32.830'),('6e75df3d-e558-4cc6-8263-62b0654e0206',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_36d05387-51e6-4286-a074-7c7894c0622b/occlusion_0ec93b21-a91f-4695-a966-e072a8fb68e3/scan_5212b119-1f64-4de6-82e2-b5b72ee0e22b/7_w7_o1_maxillaire_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_36d05387-51e6-4286-a074-7c7894c0622b_SESS_0ec93b21-a91f-4695-a966-e072a8fb68e3_TOSC_5212b119-1f64-4de6-82e2-b5b72ee0e22b_SNAPS','7_w7_o1_maxillaire_snapshot_0.png','6e75df3d-e558-4cc6-8263-62b0654e0206','{\"displayTitle\":\"Maxilla 1.7.7.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-05-05 16:51:54.000','2024-10-31 14:02:26.623','2024-10-31 10:02:26.623'),('6f55e6c6-3655-4578-b29e-986640c890b1',664,'','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_775311e4-a561-40c7-a2ce-76a0b1550be8_TOSC_a7098a82-daaf-4ad2-a4b6-803796e5351b_SNAPS','','6f55e6c6-3655-4578-b29e-986640c890b1','{\"displayTitle\":\"Maxilla 1.41.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'CREATED',0,'2022-07-28 15:30:03.000','2022-07-28 15:06:24.000','2023-05-17 17:16:39.559',NULL),('6fe89eae-9acf-496c-87c2-5d7d789669bd',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_51374b44-d221-416c-8eb3-cf931ed89632/occlusion_8b5d08e1-2513-416b-87f9-350cab840a3d/scan_3e328cc1-9830-466d-a33e-fbe74a2dbdae/37_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_51374b44-d221-416c-8eb3-cf931ed89632_SESS_8b5d08e1-2513-416b-87f9-350cab840a3d_LESC_3e328cc1-9830-466d-a33e-fbe74a2dbdae_MODEL','37_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','6fe89eae-9acf-496c-87c2-5d7d789669bd','{\"displayTitle\":\"Posterior left bite 1.37.1.1.1\",\"modelMatrix\":\"-0.952764,-0.010161,0.303817,0,0.0362753,-0.995403,0.0847077,0,0.301546,0.0953077,0.948962,0,3.14521,-2.5014,-19.4829,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-22 15:48:08.000','2024-10-31 14:02:29.797','2024-10-31 10:02:29.797'),('704684d5-4d3c-4d55-8ead-1380b7706142',664,'','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_TOSC_ded778b4-0eef-4984-8f57-77502f727676_SNAPS','41_w1_o3_maxillaire_snapshot_3.png','2b56c6fd-ec90-43d4-9a05-5032faa796d7','{\"displayTitle\":\"Maxilla 1.41.1.3.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',3,'SYNCED',0,'2023-05-22 09:06:45.000','2022-08-03 10:05:43.000','2024-10-31 14:02:31.964','2024-10-31 10:02:31.964'),('705ce590-288e-42b0-a165-5223556f4995',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_36d05387-51e6-4286-a074-7c7894c0622b/occlusion_0ec93b21-a91f-4695-a966-e072a8fb68e3/scan_5212b119-1f64-4de6-82e2-b5b72ee0e22b/7_w7_o1_maxillaire_scan_file_2.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_36d05387-51e6-4286-a074-7c7894c0622b_SESS_0ec93b21-a91f-4695-a966-e072a8fb68e3_TOSC_5212b119-1f64-4de6-82e2-b5b72ee0e22b_MODEL','7_w7_o1_maxillaire_scan_file_2.ply','7eedc56a-9ad1-4a49-b277-341ffab589ce','{\"displayTitle\":\"Maxilla 1.7.7.1.1\",\"modelMatrix\":\"-0.299039,0.0071607,0.954214,0,0.954241,0.00224401,0.29903,0,1.22819e-10,0.999972,-0.00750408,0,8.02291,-51.0215,6.0556,1\",\"title\":\"Maxilla PLY\"}','PLY',2,'SYNCED',0,NULL,'2021-05-05 17:04:39.000','2024-10-31 14:02:26.663','2024-10-31 10:02:26.663'),('70a1ffe1-533c-49da-881c-10044b0e5fa8',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_21bbefd5-8dc0-4e41-91d8-718463ad469c/scan_a003a669-7caa-4b04-a7fb-b5164b2bfcd3/41_w1_o3_mordu_posterieur_droit_snapshot_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_RISC_a003a669-7caa-4b04-a7fb-b5164b2bfcd3_SNAPS','41_w1_o3_mordu_posterieur_droit_snapshot_0.png','70a1ffe1-533c-49da-881c-10044b0e5fa8','{\"displayTitle\":\"Posterior right bite 1.41.1.3.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-03 16:15:02.000','2024-10-31 14:02:32.116','2024-10-31 10:02:32.116'),('70d2409c-e30f-487b-9df8-7257b6ffa89c',664,'/var/.data/2022/664/48a38618-e853-4bf0-aa6b-4c83fb8b6f13/session_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d/occlusion_540d878b-7415-4498-8c6c-01875eec35f8/scan_e145920a-617c-4eab-b810-0a863371eb36/38_w1_o1_mandibule_scan_file_1.zip','PATIENT_48a38618-e853-4bf0-aa6b-4c83fb8b6f13_ACT_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d_SESS_540d878b-7415-4498-8c6c-01875eec35f8_BOSC_e145920a-617c-4eab-b810-0a863371eb36_MODEL','38_w1_o1_mandibule_scan_file_1.zip','fbd69925-e519-4ae3-aced-20afc89720dd','{\"displayTitle\":\"Mandible 1.38.1.1.2\",\"modelMatrix\":\"0.76721,0.62731,-0.133687,0,-0.641397,0.750359,-0.159911,0,-1.45004e-09,0.208432,0.978037,0,-10.4861,-21.634,-17.1237,1\",\"title\":\"Mandible ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-06-22 16:56:23.000','2024-10-31 14:02:29.887','2024-10-31 10:02:29.887'),('73e3f675-fef8-44e6-bc33-f21678a2af71',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/order_854d2595-c6e3-4d27-8fbd-55e7fc6c19e4/35_w1_amovible_prost_file_73e3f675-fef8-44e6-bc33-f21678a2af71_1.pdf','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_PROST_854d2595-c6e3-4d27-8fbd-55e7fc6c19e4_FORM','35_w1_amovible_prost_file_73e3f675-fef8-44e6-bc33-f21678a2af71_1.pdf','74d73d8b-010c-4098-86e4-3b850bd977a4','{\"displayTitle\":\"ORDER 1.35.1.1 Sindy Pined: REMOVABLE\",\"title\":\"Amovible PDF\"}','PDF',1,'SYNCED',0,NULL,'2022-10-03 22:06:26.000','2023-05-17 17:16:39.559','2023-05-22 09:06:46.338'),('74cbcc03-20d0-488e-89d0-9f502483117a',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_48ff9245-20c5-4364-a092-18eafb8024d3/scan_13a263f2-8a0a-409b-a3c1-f2ddb5f6a466/10_w1_o2_mordu_posterieur_droit_scan_file_0.ply','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_48ff9245-20c5-4364-a092-18eafb8024d3_RISC_13a263f2-8a0a-409b-a3c1-f2ddb5f6a466_MODEL','10_w1_o2_mordu_posterieur_droit_scan_file_0.ply','74cbcc03-20d0-488e-89d0-9f502483117a','{\"displayTitle\":\"Mordu posterieur droit 1.10.1.2.1\",\"modelMatrix\":\"0.968367,0.185187,0.118852,0,-0.204632,0.982401,-0.00774985,0,-0.146698,-0.0373472,0.993577,0,-0.414346,-6.12417,-17.2765,1\",\"title\":\"Posterior right bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-09-16 19:08:14.000','2024-10-31 14:02:25.660','2024-10-31 10:02:25.660'),('74d73d8b-010c-4098-86e4-3b850bd977a4',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/order_854d2595-c6e3-4d27-8fbd-55e7fc6c19e4/35_w1_amovible_prost_file_74d73d8b-010c-4098-86e4-3b850bd977a4_0.pdf','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_PROST_854d2595-c6e3-4d27-8fbd-55e7fc6c19e4_FORM','35_w1_amovible_prost_file_74d73d8b-010c-4098-86e4-3b850bd977a4_0.pdf','74d73d8b-010c-4098-86e4-3b850bd977a4','{\"displayTitle\":\"ORDER 1.35.1.1 Sindy Pined: REMOVABLE\",\"title\":\"Amovible PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-10-03 22:06:21.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.285'),('74fa4d25-e0b6-40e6-8813-5e824074f25b',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_fecdd55c-c22a-4e46-835e-a5780e62f261/27_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_LESC_fecdd55c-c22a-4e46-835e-a5780e62f261_SNAPS','27_w1_o1_mordu_posterieur_gauche_snapshot_0.png','74fa4d25-e0b6-40e6-8813-5e824074f25b','{\"displayTitle\":\"Mordu posterieur gauche 1.27.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-04 19:07:17.000','2024-10-31 14:02:26.875','2024-10-31 10:02:26.875'),('7723ac3c-0369-4af2-85e7-bc0325ec0c97',664,'/var/.data/2021/664/eddc3fb0-fe28-4640-9139-29e088374f38/session_b6c36b1b-7784-4541-99a4-cc8d71760e48/occlusion_627f8883-666a-43cc-a9a1-6e48437d191f/scan_c10fc832-071d-4249-8d26-88c7891b3ef7/6_w1_o1_mandibule_scan_file_0.ply','PATIENT_eddc3fb0-fe28-4640-9139-29e088374f38_ACT_b6c36b1b-7784-4541-99a4-cc8d71760e48_SESS_627f8883-666a-43cc-a9a1-6e48437d191f_BOSC_c10fc832-071d-4249-8d26-88c7891b3ef7_MODEL','6_w1_o1_mandibule_scan_file_0.ply','7723ac3c-0369-4af2-85e7-bc0325ec0c97','{\"displayTitle\":\"Mandibule 1.6.1.1.2\",\"modelMatrix\":\"-0.916914,0.313323,-0.247178,0,-0.399084,-0.719874,0.567903,0,9.51851e-9,0.619363,0.785105,0,18.4131,-43.6986,-17.2533,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-18 19:49:00.000','2024-10-31 14:02:25.776','2024-10-31 10:02:25.776'),('779f3035-6a8d-41b5-8c8d-7ea284d28390',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_5500928e-446a-45d8-af99-faf7375b1d49/21_w1_o1_mandibule_snapshot_0.png','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_BOSC_5500928e-446a-45d8-af99-faf7375b1d49_SNAPS','21_w1_o1_mandibule_snapshot_0.png','779f3035-6a8d-41b5-8c8d-7ea284d28390','{\"displayTitle\":\"Mandible SNAPSHOT\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-28 18:14:12.000','2024-10-31 14:02:26.099','2024-10-31 10:02:26.099'),('77bf1215-677a-4878-bef9-8a318da9a518',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_26288707-da63-4165-bfdb-8a6c299bcb2b/scan_c06a5cff-eff6-47da-bc1a-c815235abec3/33_w1_o2_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_26288707-da63-4165-bfdb-8a6c299bcb2b_LESC_c06a5cff-eff6-47da-bc1a-c815235abec3_MODEL','33_w1_o2_mordu_posterieur_gauche_scan_file_0.zip','77bf1215-677a-4878-bef9-8a318da9a518','{\"displayTitle\":\"Posterior left bite 1.33.1.2.1\",\"modelMatrix\":\"-0.831854,0.128165,0.535589,0,-0.0722499,-0.987388,0.140519,0,0.55054,0.094893,0.832758,0,8.03242,-4.96681,-31.9532,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-04-11 17:26:40.000','2024-10-31 14:02:29.170','2024-10-31 10:02:29.170'),('77c38694-17b8-404d-ba83-1b6a0859814a',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_9f22f8f4-8b92-4811-8c6a-7b858b99e056/37_w2_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_LESC_9f22f8f4-8b92-4811-8c6a-7b858b99e056_SNAPS','37_w2_o1_mordu_posterieur_gauche_snapshot_0.png','77c38694-17b8-404d-ba83-1b6a0859814a','{\"displayTitle\":\"Posterior left bite 1.37.2.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-10-19 19:30:05.000','2024-10-31 14:02:35.418','2024-10-31 10:02:35.418'),('77c6f7c4-1f2a-4d74-a31c-6f1c54373267',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/order_1813dac1-af6a-4e4c-8f60-2564d6ebab92/49_w1_couronne_sur_implant_prost_file_77c6f7c4-1f2a-4d74-a31c-6f1c54373267_0.pdf','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_PROST_1813dac1-af6a-4e4c-8f60-2564d6ebab92_FORM','49_w1_couronne_sur_implant_prost_file_77c6f7c4-1f2a-4d74-a31c-6f1c54373267_0.pdf','77c6f7c4-1f2a-4d74-a31c-6f1c54373267','{\"displayTitle\":\"ORDER 1.49.1.3 Carol Hicks (IMPLANT CROWN)\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'CREATED',0,'2022-11-22 18:42:48.000','2022-11-18 20:22:12.000','2023-05-17 17:16:39.559',NULL),('78387199-9464-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_e2bb3a77-9462-11ee-8fd8-58a023cda0dc/78387199-9464-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_TOSC_e2bb3a77-9462-11ee-8fd8-58a023cda0dc_MODEL','78387199-9464-11ee-8fd8-58a023cda0dc.zip','78387199-9464-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.55.1.1.1\",\"modelMatrix\":\"-0.378939,0.877053,-0.295267,0,-0.925422,-0.359133,0.120905,0,6.43796e-09,0.319062,0.947734,0,24.3468,-31.6342,-16.7514,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-12-11 10:12:27.000','2024-10-31 14:02:37.445','2024-10-31 10:02:37.445'),('78388176-9464-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_e2bb3a77-9462-11ee-8fd8-58a023cda0dc/78388176-9464-11ee-8fd8-58a023cda0dc.png','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_TOSC_e2bb3a77-9462-11ee-8fd8-58a023cda0dc_SNAPS','78388176-9464-11ee-8fd8-58a023cda0dc.png','78388176-9464-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.55.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-12-11 10:12:28.000','2024-10-31 14:02:37.454','2024-10-31 10:02:37.454'),('7973cb9c-cd34-4796-881a-57ad49049b13',664,'','PATIENT_59179996-dc1e-4b4c-b9fd-92c78aa1dde0_ACT_df905f94-03ea-4868-82d7-960568f5cab7_SESS_88c76352-cde4-4fcb-a264-c6cd5cb1e44f_TOSC_51d672de-5db0-4925-8908-13042e3aacea_SNAPS','','d8094a5c-fedb-4670-86ce-564c40fef227','{\"displayTitle\":\"Maxilla 1.40.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',1,'CREATED',0,'2022-07-18 16:51:00.000','2022-07-18 16:47:33.000','2023-05-17 17:16:39.559',NULL),('79f9fd91-9051-41dd-a9bb-68c6a0549dc4',664,'','PATIENT_17cc8b8c-6280-4e69-ad1e-731bdd9819e0_ACT_f9cb9561-eacc-4b43-976b-dfa67a953a80_SESS_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910_FRSC_95b374af-2b93-47f7-86f5-f5e1ba6360b6_MODEL','19_w1_o1_mordu_anterieur_scan_file_0.ply','79f9fd91-9051-41dd-a9bb-68c6a0549dc4','{\"displayTitle\":\"Anterior bite 1.19.1.1.1\",\"modelMatrix\":\"0.9949,-0.00885014,-0.10205,0,-0.00202219,0.997587,-0.0718763,0,0.100925,0.0690101,0.992183,0,5.65831,0.116234,-14.7209,1\",\"title\":\"Anterior bite PLY\"}','PLY',0,'SYNCED',0,'2023-05-22 09:06:51.000','2021-04-09 13:52:41.000','2024-10-31 14:02:25.478','2024-10-31 10:02:25.478'),('7a1fe436-356c-4301-bcb4-d66dbeff4a68',664,'','PATIENT_17cc8b8c-6280-4e69-ad1e-731bdd9819e0_ACT_f9cb9561-eacc-4b43-976b-dfa67a953a80_SESS_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910_LESC_210ee6b9-1960-43ea-a220-cfa20b762017_MODEL','19_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','7a1fe436-356c-4301-bcb4-d66dbeff4a68','{\"displayTitle\":\"Posterior left bite 1.19.1.1.1\",\"modelMatrix\":\"-0.980456,0.0864385,0.18122,0,-0.068206,-0.991547,0.109045,0,0.184601,0.0967904,0.977392,0,0.384854,-1.09278,-8.49633,1\",\"title\":\"Posterior left bite PLY\"}','PLY',0,'SYNCED',0,'2023-05-22 09:06:51.000','2021-04-09 13:49:59.000','2024-10-31 14:02:25.445','2024-10-31 10:02:25.445'),('7aa1b303-4eea-4bf0-85e6-2e29f68d0606',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/order_8515ad34-77a4-41f6-a53a-5be823e2f13d/41_w1_couronne_prost_file_7aa1b303-4eea-4bf0-85e6-2e29f68d0606_0.pdf','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_PROST_8515ad34-77a4-41f6-a53a-5be823e2f13d_FORM','41_w1_couronne_prost_file_7aa1b303-4eea-4bf0-85e6-2e29f68d0606_0.pdf','7aa1b303-4eea-4bf0-85e6-2e29f68d0606','{\"displayTitle\":\"ORDER 1.41.1.1 CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-07-28 16:03:54.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.798'),('7abc6b39-6114-4da3-93f8-c62c489036d0',664,'','PATIENT_11ec40e4-4579-4185-9fcf-4e1aac06f554_ACT_8f44bea9-b7e9-45c8-a098-f3b18f9be730_SESS_7348646e-cf7a-460b-aba9-d56ad656689e_TOSC_d3d5ecdb-7933-478d-8f71-7bc13b2a4a05_MODEL','','f40bab24-99ba-4240-a790-2cb8e6b01f50','{\"displayTitle\":\"Maxilla 1.25.1.1.2\",\"modelMatrix\":\"0.472664,0.869304,-0.144568,0,-0.881243,0.46626,-0.0775408,0,-2.06962e-9,0.164051,0.986452,0,-22.5465,-11.4851,-19.0711,1\",\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":10,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":4,\"title\":\"Maxilla PLY\"}','PLY',3,'SYNCED',0,'2022-03-14 14:42:22.000','2021-09-14 17:59:18.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.286'),('7abd657b-8d1b-4fdd-bfb7-40094e5b23e8',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_26288707-da63-4165-bfdb-8a6c299bcb2b/scan_73765dbb-1926-4aed-8b7f-3202e1e68aa2/33_w1_o2_mandibule_snapshot_1.png','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_26288707-da63-4165-bfdb-8a6c299bcb2b_BOSC_73765dbb-1926-4aed-8b7f-3202e1e68aa2_SNAPS','33_w1_o2_mandibule_snapshot_1.png','2142e79a-5c20-4b84-ae6f-30da94d6f22f','{\"displayTitle\":\"Mandible 1.33.1.2.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-04-11 17:24:44.000','2024-10-31 14:02:29.146','2024-10-31 10:02:29.146'),('7b10fba4-5aee-4832-9158-2978a6c17e5d',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/order_660769ad-1b3a-4e07-ba2e-3a8721ccaf28/44_w1_couronne_sur_implant_prost_file_7b10fba4-5aee-4832-9158-2978a6c17e5d_0.pdf','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_PROST_660769ad-1b3a-4e07-ba2e-3a8721ccaf28_FORM','44_w1_couronne_sur_implant_prost_file_7b10fba4-5aee-4832-9158-2978a6c17e5d_0.pdf','7b10fba4-5aee-4832-9158-2978a6c17e5d','{\"displayTitle\":\"ORDER 1.44.1.2 IMPLANT CROWN Taylor-Jolly\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'CREATED',0,'2022-09-21 19:31:12.000','2022-09-21 19:31:00.000','2023-05-17 17:16:39.559',NULL),('7bfd4193-5301-4dc1-b4e1-7ff5390e8e5a',664,'/var/.data/2023/664/b5cbee44-0703-46c2-986a-7a416eb4206c/session_399a5604-f330-487f-8e32-3a7a90ae6715/occlusion_75f786da-2db1-4447-9a94-0df475a4082d/scan_b6a47aff-51d9-4bb1-bb0d-20fd5a5bc0e0/52_w1_o1_maxillaire_snapshot_0.png','PATIENT_b5cbee44-0703-46c2-986a-7a416eb4206c_ACT_399a5604-f330-487f-8e32-3a7a90ae6715_SESS_75f786da-2db1-4447-9a94-0df475a4082d_TOSC_b6a47aff-51d9-4bb1-bb0d-20fd5a5bc0e0_SNAPS','52_w1_o1_maxillaire_snapshot_0.png','7bfd4193-5301-4dc1-b4e1-7ff5390e8e5a','{\"displayTitle\":\"Maxilla 1.52.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2023-02-20 15:59:17.000','2024-10-31 14:02:36.261','2024-10-31 10:02:36.261'),('7c6afa34-7099-4eec-899b-517fb3c69b93',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/occlusion_cacc103c-8b88-4be5-a787-b6b92341e9eb/scan_ec42315e-bad9-44b4-bfd3-e86342727df2/34_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_SESS_cacc103c-8b88-4be5-a787-b6b92341e9eb_LESC_ec42315e-bad9-44b4-bfd3-e86342727df2_SNAPS','34_w1_o1_mordu_posterieur_gauche_snapshot_0.png','7c6afa34-7099-4eec-899b-517fb3c69b93','{\"displayTitle\":\"Posterior left bite 1.34.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-05-25 18:01:06.000','2024-10-31 14:02:29.304','2024-10-31 10:02:29.304'),('7cf3fa91-829b-4784-9c7b-fa07d892af02',664,'/var/.data/2022/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_00cdb0d1-c7e4-41bc-93a4-7c29a6f1cf58/occlusion_324dac1a-95fa-44d5-b054-88f048931106/scan_c69cb914-4302-4945-ad80-085dba8ff126/29_w1_o1_maxillaire_scan_file_0.zip','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_00cdb0d1-c7e4-41bc-93a4-7c29a6f1cf58_SESS_324dac1a-95fa-44d5-b054-88f048931106_TOSC_c69cb914-4302-4945-ad80-085dba8ff126_MODEL','29_w1_o1_maxillaire_scan_file_0.zip','7cf3fa91-829b-4784-9c7b-fa07d892af02','{\"displayTitle\":\"Maxilla 1.29.1.1.3\",\"modelMatrix\":\"0.538308,0.670357,-0.510731,0,-0.842749,0.428192,-0.326231,0,-3.32793e-09,0.60603,0.795442,0,-29.7322,-26.9141,-6.79591,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-14 16:23:59.000','2024-10-31 14:02:28.744','2024-10-31 10:02:28.744'),('7d32f47d-b7fa-4bab-b279-a835c925268d',664,'','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_BOSC_5478f37b-d39e-46d1-a026-906c02d9c928_MODEL','30_w1_o1_mandibule_scan_file_3.zip','4baca937-885c-4f87-88b2-c1c5ac9e24e5','{\"displayTitle\":\"Mandible 1.30.1.1.1\",\"modelMatrix\":\"-0.931313,-0.362058,0.0396135,0,0.364219,-0.925789,0.101292,0,4.11911e-11,0.108763,0.994068,0,9.74339,2.06983,-20.1633,1\",\"title\":\"Mandible ZIP\"}','ZIP',3,'SYNCED',0,'2023-05-22 09:09:20.000','2022-03-21 10:29:53.000','2024-10-31 14:02:28.785','2024-10-31 10:02:28.785'),('7d55f75c-c015-4a0a-917b-7d996003b4c5',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/occlusion_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e/scan_51eb1879-2b2e-4194-9e9b-9ff1e67fe43c/49_w1_o1_mordu_posterieur_droit_snapshot_1.png','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_RISC_51eb1879-2b2e-4194-9e9b-9ff1e67fe43c_SNAPS','49_w1_o1_mordu_posterieur_droit_snapshot_1.png','81089ccc-9c06-4a8f-a371-9d11e00cce3e','{\"displayTitle\":\"Posterior right bite 1.49.1.1.2\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-10-31 17:24:57.000','2024-10-31 14:02:35.578','2024-10-31 10:02:35.578'),('7daf99fd-27e4-4724-8ff7-e3ce87982137',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_48ff9245-20c5-4364-a092-18eafb8024d3/scan_39c9ba47-6b25-4333-a5cf-b8988930cdd8/10_w1_o2_maxillaire_snapshot_0.png','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_48ff9245-20c5-4364-a092-18eafb8024d3_TOSC_39c9ba47-6b25-4333-a5cf-b8988930cdd8_SNAPS','10_w1_o2_maxillaire_snapshot_0.png','7daf99fd-27e4-4724-8ff7-e3ce87982137','{\"displayTitle\":\"Maxillaire 1.10.1.2.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-09-16 18:56:06.000','2024-10-31 14:02:25.678','2024-10-31 10:02:25.678'),('7dd9b5ba-734e-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/scan_f3804f47-734c-11ee-b011-58a023cda0dc/7dd9b5ba-734e-11ee-b011-58a023cda0dc.zip','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_BOSC_f3804f47-734c-11ee-b011-58a023cda0dc_MODEL','7dd9b5ba-734e-11ee-b011-58a023cda0dc.zip','85b94756-734d-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Mandible 1.7.10.1.1\",\"modelMatrix\":\"-0.298068,0.938491,-0.174326,0,-0.954545,-0.293055,0.0544354,0,2.04117e-09,0.182627,0.983182,0,-11.5041,-37.3149,-18.2456,1\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2023-10-25 12:00:15.000','2023-10-30 13:28:06.575','2023-10-30 09:28:06.575'),('7dd9c4e0-734e-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/scan_f3804f47-734c-11ee-b011-58a023cda0dc/7dd9c4e0-734e-11ee-b011-58a023cda0dc.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_BOSC_f3804f47-734c-11ee-b011-58a023cda0dc_SNAPS','7dd9c4e0-734e-11ee-b011-58a023cda0dc.png','85b95611-734d-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Mandible 1.7.10.1.1 Snapshot\"}','PNG',2,'SYNCED',0,NULL,'2023-10-25 12:00:16.000','2023-10-30 13:28:06.623','2023-10-30 09:28:06.623'),('7e467afe-ef06-407f-8b25-d56d48c50f7e',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_ef2b4fcf-f21c-418d-942a-c99ea96efbdb/occlusion_7d36e059-dbc3-46b0-931a-bdf8fdc805c6/scan_f99691b6-3bf9-4760-8115-1d1a52fc98ae/7_w2_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_ef2b4fcf-f21c-418d-942a-c99ea96efbdb_SESS_7d36e059-dbc3-46b0-931a-bdf8fdc805c6_RISC_f99691b6-3bf9-4760-8115-1d1a52fc98ae_MODEL','7_w2_o1_mordu_posterieur_droit_scan_file_0.ply','7e467afe-ef06-407f-8b25-d56d48c50f7e','{\"displayTitle\":\"Mordu posterieur droit 1.7.2.1.1\",\"modelMatrix\":\"0.88088,-0.100254,0.462752,0,0.185075,0.964745,-0.179058,0,-0.435975,0.243989,0.868257,0,4.72924,-0.607928,-19.1597,1\",\"title\":\"Posterior right bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-21 16:26:15.000','2024-10-31 14:02:26.266','2024-10-31 10:02:26.266'),('7e92b49e-bc5f-4233-9657-58c0df873f81',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_21bbefd5-8dc0-4e41-91d8-718463ad469c/scan_00462b4b-7b16-4a6c-aaef-5da516ac1f81/41_w1_o3_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_LESC_00462b4b-7b16-4a6c-aaef-5da516ac1f81_MODEL','41_w1_o3_mordu_posterieur_gauche_scan_file_0.zip','7e92b49e-bc5f-4233-9657-58c0df873f81','{\"displayTitle\":\"Posterior left bite 1.41.1.3.1\",\"modelMatrix\":\"-0.994164,0.0306294,0.100346,0,-0.0264848,-0.995931,0.088045,0,0.104699,0.0848901,0.991051,0,13.383,-5.74274,-17.9003,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-03 16:16:06.000','2024-10-31 14:02:32.016','2024-10-31 10:02:32.016'),('7ea07429-5447-4d83-a220-b0cf75c4f7ca',664,'/var/.data/2022/664/7eac18e5-5ed2-4ed9-8b3e-eba1c562d708/session_c49716f1-987e-4111-9ab9-4541a0378bb7/order_54410525-60fc-4d0d-9655-9ea6638a6043/30_w1_couronne_sur_implant_prost_file_7ea07429-5447-4d83-a220-b0cf75c4f7ca_0.pdf','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_PROST_54410525-60fc-4d0d-9655-9ea6638a6043_FORM','30_w1_couronne_sur_implant_prost_file_7ea07429-5447-4d83-a220-b0cf75c4f7ca_0.pdf','7ea07429-5447-4d83-a220-b0cf75c4f7ca','{\"displayTitle\":\"ORDER 1.30.1.2 IMPLANT CROWN\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-03-28 16:57:59.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.795'),('7edf01f1-08fe-4394-8c4b-b1bc1d7eb24d',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_36d05387-51e6-4286-a074-7c7894c0622b/occlusion_0ec93b21-a91f-4695-a966-e072a8fb68e3/scan_5212b119-1f64-4de6-82e2-b5b72ee0e22b/7_w7_o1_maxillaire_snapshot_3.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_36d05387-51e6-4286-a074-7c7894c0622b_SESS_0ec93b21-a91f-4695-a966-e072a8fb68e3_TOSC_5212b119-1f64-4de6-82e2-b5b72ee0e22b_SNAPS','7_w7_o1_maxillaire_snapshot_3.png','6e75df3d-e558-4cc6-8263-62b0654e0206','{\"displayTitle\":\"Maxillaire 1.7.7.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',3,'SYNCED',0,NULL,'2021-05-05 17:45:09.000','2024-10-31 14:02:26.678','2024-10-31 10:02:26.678'),('7eedc56a-9ad1-4a49-b277-341ffab589ce',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_36d05387-51e6-4286-a074-7c7894c0622b/occlusion_0ec93b21-a91f-4695-a966-e072a8fb68e3/scan_5212b119-1f64-4de6-82e2-b5b72ee0e22b/7_w7_o1_maxillaire_scan_file_0.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_36d05387-51e6-4286-a074-7c7894c0622b_SESS_0ec93b21-a91f-4695-a966-e072a8fb68e3_TOSC_5212b119-1f64-4de6-82e2-b5b72ee0e22b_MODEL','7_w7_o1_maxillaire_scan_file_0.ply','7eedc56a-9ad1-4a49-b277-341ffab589ce','{\"displayTitle\":\"Maxilla 1.7.7.1.1\",\"modelMatrix\":\"-0.687397,-0.0674008,0.723148,0,0.726282,-0.0637921,0.68443,0,-5.68181e-9,0.995685,0.0928025,0,9.84386,-51.093,7.62201,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-05-05 16:51:54.000','2024-10-31 14:02:26.578','2024-10-31 10:02:26.578'),('7fde521a-04b1-4299-9ed5-c7cacaef524b',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_26288707-da63-4165-bfdb-8a6c299bcb2b/scan_73765dbb-1926-4aed-8b7f-3202e1e68aa2/33_w1_o2_mandibule_scan_file_1.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_26288707-da63-4165-bfdb-8a6c299bcb2b_BOSC_73765dbb-1926-4aed-8b7f-3202e1e68aa2_MODEL','33_w1_o2_mandibule_scan_file_1.zip','240221f6-6e8b-47b5-a556-7958b41a92cf','{\"displayTitle\":\"Mandible 1.33.1.2.1\",\"modelMatrix\":\"0.993645,0.109282,-0.0269731,0,-0.112562,0.964694,-0.238107,0,1.32145e-10,0.23963,0.970864,0,-18.3193,-5.56791,-19.978,1\",\"title\":\"Mandible ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-04-11 17:23:17.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.776'),('8079e323-06a0-4f3d-aceb-723f10a814a8',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_48ff9245-20c5-4364-a092-18eafb8024d3/scan_39c9ba47-6b25-4333-a5cf-b8988930cdd8/10_w1_o2_maxillaire_scan_file_0.ply','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_48ff9245-20c5-4364-a092-18eafb8024d3_TOSC_39c9ba47-6b25-4333-a5cf-b8988930cdd8_MODEL','10_w1_o2_maxillaire_scan_file_0.ply','8079e323-06a0-4f3d-aceb-723f10a814a8','{\"displayTitle\":\"Maxillaire 1.10.1.2.1\",\"modelMatrix\":\"-0.96883,-0.243631,0.0448564,0,0.247726,-0.952815,0.175428,0,-4.82146e-10,0.181072,0.98347,0,13.2241,2.81941,-20.5768,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-09-16 18:56:06.000','2024-10-31 14:02:25.687','2024-10-31 10:02:25.687'),('808d182d-221e-4a9d-ab72-1bcc5b6ec075',664,'','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_BOSC_5478f37b-d39e-46d1-a026-906c02d9c928_SNAPS','30_w1_o1_mandibule_snapshot_3.png','991b6bf3-db84-4e38-b3ca-2e1d37a170c0','{\"displayTitle\":\"Mandible 1.30.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',3,'SYNCED',0,'2023-05-22 09:07:43.000','2022-03-21 10:32:00.000','2024-10-31 14:02:28.797','2024-10-31 10:02:28.797'),('81089ccc-9c06-4a8f-a371-9d11e00cce3e',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/occlusion_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e/scan_51eb1879-2b2e-4194-9e9b-9ff1e67fe43c/49_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_RISC_51eb1879-2b2e-4194-9e9b-9ff1e67fe43c_SNAPS','49_w1_o1_mordu_posterieur_droit_snapshot_0.png','81089ccc-9c06-4a8f-a371-9d11e00cce3e','{\"displayTitle\":\"Posterior right bite 1.49.1.1.2\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-10-31 17:23:15.000','2024-10-31 14:02:35.569','2024-10-31 10:02:35.569'),('82334e6c-351a-420d-b00b-1f8b84c0a9ba',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_96711d60-288c-439f-b464-597833d56519/occlusion_a98f038e-a19a-47ad-af09-a22810e9d19c/scan_86e16909-3b39-4591-8c03-0e4eba17f0ff/14_w3_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_96711d60-288c-439f-b464-597833d56519_SESS_a98f038e-a19a-47ad-af09-a22810e9d19c_RISC_86e16909-3b39-4591-8c03-0e4eba17f0ff_MODEL','14_w3_o1_mordu_posterieur_droit_scan_file_0.ply','82334e6c-351a-420d-b00b-1f8b84c0a9ba','{\"displayTitle\":\"Mordu posterieur droit 1.14.3.1.1\",\"modelMatrix\":\"0.970234,-0.0672147,0.236049,0,0.0516866,0.997823,0.0203938,0,-0.236947,-0.00246599,0.971529,0,-7.85511,3.99016,-22.5635,1\",\"title\":\"Posterior right bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-14 15:35:24.000','2024-10-31 14:02:32.522','2024-10-31 10:02:32.522'),('82645c6b-3b05-4920-acad-9d001cacb5ea',664,'','PATIENT_635617fc-289b-470c-a4d4-678d7b5f275a_ACT_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6_PROST_23a16fe0-ed03-4415-a9e6-882ce7bc94f3_FORM','','82645c6b-3b05-4920-acad-9d001cacb5ea','{\"displayTitle\":\"ORDER 1.45.1.4 TEST envoi Commande\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,'2022-11-22 18:47:19.000','2022-11-21 16:46:12.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.774'),('82a6efdf-566e-4983-8345-bb07a5434fce',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368/32_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_LESC_8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368_MODEL','32_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','82a6efdf-566e-4983-8345-bb07a5434fce','{\"displayTitle\":\"Posterior left bite 1.32.1.1.1\",\"modelMatrix\":\"-0.959312,0.126881,0.264382,0,-0.151258,-0.972992,-0.156214,0,0.239345,-0.193979,0.951685,0,19.0982,1.16566,-25.8795,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-23 16:39:42.000','2024-10-31 14:02:32.959','2024-10-31 10:02:32.959'),('82c71f9b-5bca-11ee-9658-58a023cda0dc',664,'/var/.data/2023/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_eecd8fd5-572c-11ee-a378-58a023cda0dc/order_79d31a7b-5bca-11ee-9658-58a023cda0dc/82c71f9b-5bca-11ee-9658-58a023cda0dc.pdf','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_eecd8fd5-572c-11ee-a378-58a023cda0dc_PROST_79d31a7b-5bca-11ee-9658-58a023cda0dc_FORM','82c71f9b-5bca-11ee-9658-58a023cda0dc.pdf','82c71f9b-5bca-11ee-9658-58a023cda0dc','{\"displayTitle\":\"Order 1.32.2.2 Temp Mandibular Hybrid\",\"title\":\"Temp Mandibular Hybrid\"}','PDF',0,'SYNCED',0,NULL,'2023-09-25 13:39:44.000','2023-09-25 17:39:47.350','2023-09-25 13:39:47.350'),('838a7ccd-cc6e-4939-812b-73553d4877f6',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_3ce0c78e-551a-4871-80c4-435836bf1dc5/32_w1_o1_mandibule_snapshot_0.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_BOSC_3ce0c78e-551a-4871-80c4-435836bf1dc5_SNAPS','32_w1_o1_mandibule_snapshot_0.png','838a7ccd-cc6e-4939-812b-73553d4877f6','{\"displayTitle\":\"Mandible 1.32.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-23 16:33:04.000','2024-10-31 14:02:32.857','2024-10-31 10:02:32.857'),('84d6771f-ac6b-4fea-aae5-db3f0a2b9e7b',664,'','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_TOSC_ded778b4-0eef-4984-8f57-77502f727676_SNAPS','41_w1_o3_maxillaire_snapshot_2.png','2b56c6fd-ec90-43d4-9a05-5032faa796d7','{\"displayTitle\":\"Maxilla 1.41.1.3.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',2,'SYNCED',0,'2023-05-22 09:06:44.000','2022-08-03 09:58:46.000','2024-10-31 14:02:31.973','2024-10-31 10:02:31.973'),('8532f29a-bbac-4db3-af25-e87cb75618fc',664,'/var/.data/2022/664/ebb7ec01-03db-43d2-bf9a-bc250f69d307/session_e530f0de-323f-4c29-bb17-b5bfe0da3afd/order_f472220d-d6e7-42a3-bcaf-a8834487cfd4/5_w1_couronne_prost_file_8532f29a-bbac-4db3-af25-e87cb75618fc_0.pdf','PATIENT_ebb7ec01-03db-43d2-bf9a-bc250f69d307_ACT_e530f0de-323f-4c29-bb17-b5bfe0da3afd_PROST_f472220d-d6e7-42a3-bcaf-a8834487cfd4_FORM','5_w1_couronne_prost_file_8532f29a-bbac-4db3-af25-e87cb75618fc_0.pdf','8532f29a-bbac-4db3-af25-e87cb75618fc','{\"displayTitle\":\"ORDER 1.5.1.1 CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-11-02 16:11:39.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.774'),('85680def-9eea-4c98-8023-f74aed715f89',664,'','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_TOSC_6d53d83a-50bf-4b07-a6c4-377e6be410b9_SCREENS','49_w1_o1_maxillaire_screenshot_85680def-9eea-4c98-8023-f74aed715f89_0.png','85680def-9eea-4c98-8023-f74aed715f89','{\"displayTitle\":\"Screenshot 1.49.1.1.2 Maxilla 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxilla 1\"}','PNG',0,'SYNCED',0,'2023-05-22 09:07:44.000','2022-11-22 14:01:34.000','2024-10-31 14:02:36.250','2024-10-31 10:02:36.250'),('8595bdc6-5982-4e78-9884-facbcc949d9b',664,'/var/.data/2022/664/685697a1-0d50-4a06-8b3e-729cf9750f38/session_e1d214d2-2b62-484c-8ede-86b3f84573d3/occlusion_8cd0c724-d3d0-4821-a88b-42b03ae4eb07/scan_e0fe2abf-8a0e-43f6-a437-3901a1d00a73/48_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_685697a1-0d50-4a06-8b3e-729cf9750f38_ACT_e1d214d2-2b62-484c-8ede-86b3f84573d3_SESS_8cd0c724-d3d0-4821-a88b-42b03ae4eb07_LESC_e0fe2abf-8a0e-43f6-a437-3901a1d00a73_MODEL','48_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','8595bdc6-5982-4e78-9884-facbcc949d9b','{\"displayTitle\":\"Posterior left bite 1.48.1.1.1\",\"modelMatrix\":\"-0.990755,-0.0590163,0.123063,0,0.0529293,-0.994465,0.095524,0,0.126348,0.089678,0.987919,0,10.128,-2.1269,-18.5796,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-10-17 17:05:26.000','2024-10-31 14:02:35.287','2024-10-31 10:02:35.287'),('85b94756-734d-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/scan_f3804f47-734c-11ee-b011-58a023cda0dc/85b94756-734d-11ee-b011-58a023cda0dc.zip','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_BOSC_f3804f47-734c-11ee-b011-58a023cda0dc_MODEL','85b94756-734d-11ee-b011-58a023cda0dc.zip','85b94756-734d-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Mandible 1.7.10.1.1\",\"modelMatrix\":\"-0.767939,0.631426,-0.107568,0,-0.640523,-0.757032,0.128966,0,-5.31908e-09,0.167938,0.985797,0,4.97059,-35.353,-17.5942,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-10-25 12:00:09.000','2023-10-30 13:28:06.558','2023-10-30 09:28:06.558'),('85b95611-734d-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/scan_f3804f47-734c-11ee-b011-58a023cda0dc/85b95611-734d-11ee-b011-58a023cda0dc.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_BOSC_f3804f47-734c-11ee-b011-58a023cda0dc_SNAPS','85b95611-734d-11ee-b011-58a023cda0dc.png','85b95611-734d-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Mandible 1.7.10.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-10-25 12:00:15.000','2023-10-30 13:28:06.592','2023-10-30 09:28:06.592'),('860b8bfc-91cf-4879-9b67-96ce35dffe8b',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_96711d60-288c-439f-b464-597833d56519/occlusion_a98f038e-a19a-47ad-af09-a22810e9d19c/scan_300a55b7-e679-4993-b375-e0a3fe68f61d/14_w3_o1_mandibule_snapshot_1.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_96711d60-288c-439f-b464-597833d56519_SESS_a98f038e-a19a-47ad-af09-a22810e9d19c_BOSC_300a55b7-e679-4993-b375-e0a3fe68f61d_SNAPS','14_w3_o1_mandibule_snapshot_1.png','43625627-0f37-4d61-80ec-3a5cfe5409a4','{\"displayTitle\":\"Mandibule 1.14.3.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-04-14 15:27:57.000','2024-10-31 14:02:32.442','2024-10-31 10:02:32.442'),('86e03f08-85e3-45ff-ae56-4ff568776d2a',664,'/var/.data/2022/664/e33159c9-a713-4a37-ba98-9ec2e2e213e7/session_b63ca765-4d68-4cf4-9707-4ad3a19f3236/occlusion_ae7f89c9-26ec-4cee-b377-d5145e6c6aae/scan_5a4c21bb-56d0-45ea-b8ee-4931713ef609/50_w1_o1_mandibule_snapshot_0.png','PATIENT_e33159c9-a713-4a37-ba98-9ec2e2e213e7_ACT_b63ca765-4d68-4cf4-9707-4ad3a19f3236_SESS_ae7f89c9-26ec-4cee-b377-d5145e6c6aae_BOSC_5a4c21bb-56d0-45ea-b8ee-4931713ef609_SNAPS','50_w1_o1_mandibule_snapshot_0.png','86e03f08-85e3-45ff-ae56-4ff568776d2a','{\"displayTitle\":\"Mandible 1.50.1.1.2\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-14 18:17:31.000','2024-10-31 14:02:36.179','2024-10-31 10:02:36.179'),('8713dea0-3fef-4030-a61f-3076f107ca1f',664,'/var/.data/2022/664/e4dda259-b05b-4f33-92ac-ee4067d7dfa2/session_610634a3-6f25-4ce3-9363-ad383ec68df4/order_331e8399-8fa1-408a-b55e-1adf0a2ef6c0/4_w2_couronne_prost_file_8713dea0-3fef-4030-a61f-3076f107ca1f_1.pdf','PATIENT_e4dda259-b05b-4f33-92ac-ee4067d7dfa2_ACT_610634a3-6f25-4ce3-9363-ad383ec68df4_PROST_331e8399-8fa1-408a-b55e-1adf0a2ef6c0_FORM','4_w2_couronne_prost_file_8713dea0-3fef-4030-a61f-3076f107ca1f_1.pdf','4fe9c7bf-a124-42a0-a4cb-40c29d457a64','{\"displayTitle\":\"ORDER 1.4.2.1 Noumbissi V. CROWN\",\"title\":\"Couronne PDF\"}','PDF',1,'SYNCED',0,NULL,'2022-11-02 16:16:31.000','2023-05-17 17:16:39.559','2023-05-22 09:07:45.859'),('87299f65-8cc1-44b8-897a-a0da5547ddec',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_fecdd55c-c22a-4e46-835e-a5780e62f261/27_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_LESC_fecdd55c-c22a-4e46-835e-a5780e62f261_MODEL','27_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','87299f65-8cc1-44b8-897a-a0da5547ddec','{\"displayTitle\":\"Mordu posterieur gauche 1.27.1.1.1\",\"modelMatrix\":\"-0.948202,0.050059,0.312662,0,-0.0116634,-0.992802,0.117539,0,0.317461,0.108822,0.942566,0,7.66209,-4.74972,-21.9166,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-04 19:07:18.000','2024-10-31 14:02:26.884','2024-10-31 10:02:26.884'),('873690c9-a6e0-4e29-a021-59cb35ba85b2',664,'','PATIENT_48a38618-e853-4bf0-aa6b-4c83fb8b6f13_ACT_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d_SESS_540d878b-7415-4498-8c6c-01875eec35f8_BOSC_d8bbea0f-8405-4d13-8995-46a51be77eb1_SNAPS','38_w1_o1_mandibule_snapshot_0.png','873690c9-a6e0-4e29-a021-59cb35ba85b2','{\"displayTitle\":\"Mandible 1.38.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:07:46.000','2022-06-22 10:43:53.000','2024-10-31 14:02:29.850','2024-10-31 10:02:29.850'),('87a0d07a-9465-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/87a0d07a-9465-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_MODEL','87a0d07a-9465-11ee-8fd8-58a023cda0dc.zip','87a0d07a-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1\",\"modelMatrix\":\"0.843881,0.502692,-0.187524,0,-0.53653,0.790659,-0.294947,0,3.33011e-09,0.349512,0.936932,0,-21.678,-3.20968,-22.8257,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-12-11 10:11:54.000','2024-10-31 14:02:37.365','2024-10-31 10:02:37.365'),('87a0e23e-9465-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/87a0e23e-9465-11ee-8fd8-58a023cda0dc.png','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_SNAPS','87a0e23e-9465-11ee-8fd8-58a023cda0dc.png','87a0e23e-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-12-11 10:12:24.000','2024-10-31 14:02:37.389','2024-10-31 10:02:37.389'),('87bdb983-5bc6-11ee-9658-58a023cda0dc',664,'/var/.data/2023/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_eecd8fd5-572c-11ee-a378-58a023cda0dc/occlusion_eed0dd8b-572c-11ee-a378-58a023cda0dc/computedocclusion_82606157-5bc6-11ee-9658-58a023cda0dc/87bdb983-5bc6-11ee-9658-58a023cda0dc.zip','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_eecd8fd5-572c-11ee-a378-58a023cda0dc_SESS_eed0dd8b-572c-11ee-a378-58a023cda0dc_OCC_82606157-5bc6-11ee-9658-58a023cda0dc_TOPLY','87bdb983-5bc6-11ee-9658-58a023cda0dc.zip','87bdb983-5bc6-11ee-9658-58a023cda0dc','{\"displayTitle\":\"Occlusion 1.32.2.1.1 Maxilla\",\"modelMatrix\":\"-0.376861,0.875379,-0.3028,0,-0.92627,-0.356155,0.123197,0,1.41587e-09,0.326903,0.945058,0,1.55662,-45.5601,-10.687,1\",\"occlusionMatrix\":\"-0.959977,0.00879306,-0.27994,0,-0.117422,-0.920059,0.373769,0,-0.254274,0.391681,0.884268,0,38.3861,-23.5636,-4.82881,1\",\"occlusionType\":5,\"referenceScanId\":\"ab0cf7a4-5bc3-11ee-9658-58a023cda0dc\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-09-25 13:11:17.000','2023-09-25 17:39:47.360','2023-09-25 13:39:47.360'),('87dfac30-53df-454b-9f86-51b25ace7056',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20/37_w2_o1_mandibule_ml_0_3.xyz','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_BOSC_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20_LIFI','37_w2_o1_mandibule_ml_0_3.xyz','f7956a29-1664-4e5a-9aad-2a53021be43e','{\"displayTitle\":\"Margin line Mandible 1.37.2.1.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',3,'SYNCED',0,NULL,'2022-11-02 19:34:40.000','2024-10-31 14:02:35.756','2024-10-31 10:02:35.756'),('87e4fb11-5bc6-11ee-9658-58a023cda0dc',664,'/var/.data/2023/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_eecd8fd5-572c-11ee-a378-58a023cda0dc/occlusion_eed0dd8b-572c-11ee-a378-58a023cda0dc/computedocclusion_82606157-5bc6-11ee-9658-58a023cda0dc/87e4fb11-5bc6-11ee-9658-58a023cda0dc.zip','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_eecd8fd5-572c-11ee-a378-58a023cda0dc_SESS_eed0dd8b-572c-11ee-a378-58a023cda0dc_OCC_82606157-5bc6-11ee-9658-58a023cda0dc_BOPLY','87e4fb11-5bc6-11ee-9658-58a023cda0dc.zip','87e4fb11-5bc6-11ee-9658-58a023cda0dc','{\"displayTitle\":\"Occlusion 1.32.2.1.1 Mandible\",\"modelMatrix\":\"0.522449,0.829084,-0.199167,0,-0.85267,0.507997,-0.122034,0,1.54057e-09,0.23358,0.972338,0,-29.0051,-15.3788,-14.9329,1\",\"occlusionMatrix\":\"-0.809375,-0.585369,0.0476474,0,-0.580935,0.786035,-0.211351,0,0.0862641,-0.198742,-0.976251,0,11.015,34.7038,9.3427,1\",\"occlusionType\":5,\"referenceScanId\":\"cd138f1a-5bc2-11ee-9658-58a023cda0dc\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-09-25 13:11:19.000','2023-09-25 17:39:47.372','2023-09-25 13:39:47.372'),('87f24399-95c3-49ca-8a79-2a2ed392857a',664,'','PATIENT_d971e033-4a5c-4bd9-aab3-6238778f9eee_ACT_6fc7c9c9-3191-4169-b15f-edf43fc51336_PROST_9ab7328d-44e3-46af-b634-75d45259e276_FORM','','87f24399-95c3-49ca-8a79-2a2ed392857a','{\"displayTitle\":\"ORDER 1.47.1.1 IMPLANT CROWN (Test)\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'SYNCED',0,'2022-09-21 18:21:47.000','2022-09-21 18:16:45.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.775'),('8831acae-6108-4d6d-a57e-1329a85fae48',664,'/var/.data/2021/664/e648cc66-9340-456c-a379-50836d1b8a5b/session_f09c328f-1a8b-4f63-8998-2f9b57cd3c76/occlusion_2c19cd55-a36e-4dc7-8954-ea8a8eeacd16/scan_d4321e90-28f8-42a0-bde1-b9ddcf321fa8/16_w1_o1_maxillaire_snapshot_0.png','PATIENT_e648cc66-9340-456c-a379-50836d1b8a5b_ACT_f09c328f-1a8b-4f63-8998-2f9b57cd3c76_SESS_2c19cd55-a36e-4dc7-8954-ea8a8eeacd16_TOSC_d4321e90-28f8-42a0-bde1-b9ddcf321fa8_SNAPS','16_w1_o1_maxillaire_snapshot_0.png','8831acae-6108-4d6d-a57e-1329a85fae48','{\"displayTitle\":\"Maxillaire 1.16.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-01-18 17:42:50.000','2024-10-31 14:02:26.219','2024-10-31 10:02:26.219'),('88698a51-5bc6-11ee-9658-58a023cda0dc',664,'/var/.data/2023/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_eecd8fd5-572c-11ee-a378-58a023cda0dc/occlusion_eed0dd8b-572c-11ee-a378-58a023cda0dc/computedocclusion_82606157-5bc6-11ee-9658-58a023cda0dc/88698a51-5bc6-11ee-9658-58a023cda0dc.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_eecd8fd5-572c-11ee-a378-58a023cda0dc_SESS_eed0dd8b-572c-11ee-a378-58a023cda0dc_OCC_82606157-5bc6-11ee-9658-58a023cda0dc_SNAPO','88698a51-5bc6-11ee-9658-58a023cda0dc.png','88698a51-5bc6-11ee-9658-58a023cda0dc','{\"displayTitle\":\"Occlusion 1.32.2.1.1 Snapshot\",\"occlusionType\":5}','PNG',0,'SYNCED',0,NULL,'2023-09-25 13:11:19.000','2023-09-25 17:39:47.387','2023-09-25 13:39:47.387'),('88bf532a-ff55-4ecc-bb8b-e42f109c256d',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/occlusion_e930782a-e2db-43e8-9ff1-9feb64e20e4e/scan_a8bc827c-e0a5-47f0-9a65-02d941ee82ab/35_w1_o1_mandibule_snapshot_0.png','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_BOSC_a8bc827c-e0a5-47f0-9a65-02d941ee82ab_SNAPS','35_w1_o1_mandibule_snapshot_0.png','88bf532a-ff55-4ecc-bb8b-e42f109c256d','{\"displayTitle\":\"Mandible 1.35.1.1.3\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-06 20:31:57.000','2024-10-31 14:02:29.499','2024-10-31 10:02:29.499'),('88e87b40-aa1a-40b2-844d-04660a2545e3',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_bfe6249f-88b3-4a27-8f4c-5494e863352f/order_c155f94e-e0aa-488a-af25-8ada7a6a5b8a/10_w2_couronne_prost_file_0.ply','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_bfe6249f-88b3-4a27-8f4c-5494e863352f_SESS_fcabdff7-f4aa-41a0-8d3a-67e664f1d43e_BOSC_7ba42cbf-4905-4681-956c-45d3f7e37b6f_MODEL','10_w2_couronne_prost_file_0.ply','88e87b40-aa1a-40b2-844d-04660a2545e3','{\"displayTitle\":\"Mandible 1.10.2.1.1\",\"modelMatrix\":\"0.87699,0.439756,-0.193654,0,-0.480508,0.802614,-0.353445,0,1.03459e-10,0.40302,0.915191,0,-12.7456,-13.363,-15.4725,1\",\"title\":\"Mandible PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-11-30 02:22:13.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.775'),('896b62a5-2257-4335-b9f8-a711ad38d5c8',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_21bbefd5-8dc0-4e41-91d8-718463ad469c/scan_bdc0c035-5e2c-49c1-9980-ecffc5862af4/41_w1_o3_maxillaire_screenshot_896b62a5-2257-4335-b9f8-a711ad38d5c8_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_TOSC_bdc0c035-5e2c-49c1-9980-ecffc5862af4_SCREENS','41_w1_o3_maxillaire_screenshot_896b62a5-2257-4335-b9f8-a711ad38d5c8_0.png','896b62a5-2257-4335-b9f8-a711ad38d5c8','{\"displayTitle\":\"Screenshot 1.41.1.3.4 Maxilla 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxilla 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-03 17:32:45.000','2024-10-31 14:02:32.052','2024-10-31 10:02:32.052'),('8a9085db-de52-4842-bf76-b2b32984ecc0',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_26288707-da63-4165-bfdb-8a6c299bcb2b/scan_73765dbb-1926-4aed-8b7f-3202e1e68aa2/33_w1_o2_mandibule_scan_file_2.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_26288707-da63-4165-bfdb-8a6c299bcb2b_BOSC_73765dbb-1926-4aed-8b7f-3202e1e68aa2_MODEL','33_w1_o2_mandibule_scan_file_2.zip','240221f6-6e8b-47b5-a556-7958b41a92cf','{\"displayTitle\":\"Mandible 1.33.1.2.1\",\"modelMatrix\":\"0.959013,-0.277006,0.0596818,0,0.283363,0.9375,-0.201987,0,3.74238e-10,0.21062,0.977568,0,-16.9376,2.47337,-21.8083,1\",\"title\":\"Mandible ZIP\"}','ZIP',2,'SYNCED',0,NULL,'2022-04-11 17:24:45.000','2024-10-31 14:02:29.157','2024-10-31 10:02:29.157'),('8aa77d37-a70d-4b94-b8ee-9b4ccbea2b38',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_96711d60-288c-439f-b464-597833d56519/occlusion_a98f038e-a19a-47ad-af09-a22810e9d19c/scan_790f3bda-297c-41ad-812c-c6f5b135e445/14_w3_o1_maxillaire_snapshot_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_96711d60-288c-439f-b464-597833d56519_SESS_a98f038e-a19a-47ad-af09-a22810e9d19c_TOSC_790f3bda-297c-41ad-812c-c6f5b135e445_SNAPS','14_w3_o1_maxillaire_snapshot_0.png','8aa77d37-a70d-4b94-b8ee-9b4ccbea2b38','{\"displayTitle\":\"Maxilla 1.14.3.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-14 15:32:13.000','2024-10-31 14:02:32.469','2024-10-31 10:02:32.469'),('8b5f6027-7920-42aa-97ca-e16af1854e7e',664,'/var/.data/2021/664/f4f78058-cf3c-4c86-a252-bc92bd2d36b0/session_49b3ccf6-630c-48b2-8480-8a005298959e/occlusion_eee3d6a4-c7be-49a9-9278-7bd1d7e7f773/scan_4d1480f1-6a51-4555-bec5-61f967de64cd/13_w1_o1_maxillaire_screenshot_8b5f6027-7920-42aa-97ca-e16af1854e7e_0.png','PATIENT_f4f78058-cf3c-4c86-a252-bc92bd2d36b0_ACT_49b3ccf6-630c-48b2-8480-8a005298959e_SESS_eee3d6a4-c7be-49a9-9278-7bd1d7e7f773_TOSC_4d1480f1-6a51-4555-bec5-61f967de64cd_SCREENS','13_w1_o1_maxillaire_screenshot_8b5f6027-7920-42aa-97ca-e16af1854e7e_0.png','8b5f6027-7920-42aa-97ca-e16af1854e7e','{\"displayTitle\":\"Screenshot 1.13.1.1.1 Maxilla 2\",\"scanFileId\":\"0cc0a4e2-b944-4f97-b8fd-4141a51c8b36\",\"scanFileType\":\"PLY\",\"scanPosition\":\"-0.287828,0.0878545,0.953644,0,0.951795,0.136487,0.274696,0,-0.106027,0.986739,-0.122904,0,0,0,0,1\",\"title\":\"Maxilla 2\"}','PNG',0,'SYNCED',0,NULL,'2020-09-02 15:26:31.000','2024-10-31 14:02:25.597','2024-10-31 10:02:25.597'),('8bda8472-2262-4cee-90a4-66ef69187724',664,'/var/.data/2022/664/635617fc-289b-470c-a4d4-678d7b5f275a/session_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6/order_0b106085-a874-4785-83a0-f28eb5473492/45_w1_couronne_sur_implant_prost_file_8bda8472-2262-4cee-90a4-66ef69187724_1.pdf','PATIENT_635617fc-289b-470c-a4d4-678d7b5f275a_ACT_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6_PROST_0b106085-a874-4785-83a0-f28eb5473492_FORM','45_w1_couronne_sur_implant_prost_file_8bda8472-2262-4cee-90a4-66ef69187724_1.pdf','eccada04-8cc9-4fbe-8496-9337e8b83637','{\"displayTitle\":\"ORDER 1.45.1.1 IMPLANT CROWN Andrew Gilboy\",\"title\":\"Couronne sur Implant PDF\"}','PDF',1,'SYNCED',0,NULL,'2022-09-07 19:36:04.000','2023-05-17 17:16:39.559','2023-05-22 09:07:50.140'),('8c40eb8c-73ca-4e35-8386-312248838a85',664,'/var/.data/2022/664/685697a1-0d50-4a06-8b3e-729cf9750f38/session_e1d214d2-2b62-484c-8ede-86b3f84573d3/occlusion_8cd0c724-d3d0-4821-a88b-42b03ae4eb07/scan_6557ff06-b759-4b3c-8de6-1c83a9b00d23/48_w1_o1_maxillaire_scan_file_0.zip','PATIENT_685697a1-0d50-4a06-8b3e-729cf9750f38_ACT_e1d214d2-2b62-484c-8ede-86b3f84573d3_SESS_8cd0c724-d3d0-4821-a88b-42b03ae4eb07_TOSC_6557ff06-b759-4b3c-8de6-1c83a9b00d23_MODEL','48_w1_o1_maxillaire_scan_file_0.zip','8c40eb8c-73ca-4e35-8386-312248838a85','{\"displayTitle\":\"Maxilla 1.48.1.1.3\",\"modelMatrix\":\"0.583884,0.620439,-0.523579,0,-0.811837,0.446228,-0.376565,0,-2.80852e-09,0.644931,0.764241,0,-22.0839,-25.618,-13.438,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-10-17 17:02:54.000','2024-10-31 14:02:35.257','2024-10-31 10:02:35.257'),('8c6401d6-a141-46ea-b3db-852a74d9cde7',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/order_f515018f-7aed-4466-a056-f2b9bf180db3/37_w2_couronne_prost_file_8c6401d6-a141-46ea-b3db-852a74d9cde7_0.pdf','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_PROST_f515018f-7aed-4466-a056-f2b9bf180db3_FORM','37_w2_couronne_prost_file_8c6401d6-a141-46ea-b3db-852a74d9cde7_0.pdf','8c6401d6-a141-46ea-b3db-852a74d9cde7','{\"displayTitle\":\"ORDER 1.37.2.1 Elizabeth Baxter CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-11-02 16:36:44.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.268'),('8ce4ae13-659c-4b1b-859a-61a6bce748d7',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_21bbefd5-8dc0-4e41-91d8-718463ad469c/scan_a003a669-7caa-4b04-a7fb-b5164b2bfcd3/41_w1_o3_mordu_posterieur_droit_scan_file_0.zip','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_RISC_a003a669-7caa-4b04-a7fb-b5164b2bfcd3_MODEL','41_w1_o3_mordu_posterieur_droit_scan_file_0.zip','8ce4ae13-659c-4b1b-859a-61a6bce748d7','{\"displayTitle\":\"Posterior right bite 1.41.1.3.1\",\"modelMatrix\":\"0.935237,0.0671801,0.346617,0,-0.0235461,0.98881,-0.147367,0,-0.353321,0.133421,0.926359,0,1.97589,-3.94666,-19.8994,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-03 16:15:02.000','2024-10-31 14:02:32.127','2024-10-31 10:02:32.127'),('8d571ae5-301b-423d-bed4-3e10601d3626',664,'','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_RISC_a614060b-f808-4f83-92d9-bfd877c99148_SNAPS','33_w2_o1_mordu_posterieur_droit_snapshot_0.png','8d571ae5-301b-423d-bed4-3e10601d3626','{\"displayTitle\":\"Posterior right bite 1.33.2.1.2\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:07:51.000','2022-08-01 09:25:26.000','2024-10-31 14:02:31.836','2024-10-31 10:02:31.836'),('8d7e965c-c4e0-4db2-a19b-7f924810555e',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_ec92e295-bf7c-4746-b7d5-8b1307a8e6ac/21_w1_o1_mordu_posterieur_droit_snapshot_1.png','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_RISC_ec92e295-bf7c-4746-b7d5-8b1307a8e6ac_SNAPS','21_w1_o1_mordu_posterieur_droit_snapshot_1.png','a047d137-c079-471d-9883-363f45da4686','{\"displayTitle\":\"Posterior right bite 1.21.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-04-28 18:56:21.000','2024-10-31 14:02:26.068','2024-10-31 10:02:26.068'),('8dc7dd50-07ac-40d3-8676-114e6716857c',664,'/var/.data/2022/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_705960fa-3ed4-4013-9cde-20022721d122/occlusion_9f4fa7cb-81a3-460e-b189-ba76eb8cee15/scan_c8efe876-0a08-4332-bd36-6b59cc8f2eb8/7_w8_o1_mandibule_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_705960fa-3ed4-4013-9cde-20022721d122_SESS_9f4fa7cb-81a3-460e-b189-ba76eb8cee15_BOSC_c8efe876-0a08-4332-bd36-6b59cc8f2eb8_SNAPS','7_w8_o1_mandibule_snapshot_0.png','8dc7dd50-07ac-40d3-8676-114e6716857c','{\"displayTitle\":\"Mandible 1.7.8.1.2\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-30 16:56:01.000','2024-10-31 14:02:28.906','2024-10-31 10:02:28.906'),('8e1e3bd6-5308-4cb8-9602-06c4ddd3cb6e',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_669f6bca-452c-4b2e-a49e-aa822628ed5f/24_w1_o1_maxillaire_scan_file_1.ply','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_TOSC_669f6bca-452c-4b2e-a49e-aa822628ed5f_MODEL','24_w1_o1_maxillaire_scan_file_1.ply','5ea87deb-c530-4c0d-9e39-e94f351d1354','{\"displayTitle\":\"Maxilla 1.24.1.1.1\",\"modelMatrix\":\"-0.999944,-0.00980338,0.00389464,0,0.0105487,-0.929296,0.369186,0,-2.71848e-10,0.369207,0.929347,0,18.3073,1.2474,-25.4183,1\",\"title\":\"Maxilla PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-09-13 21:09:46.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.790'),('8e7ff8d7-eb67-4db2-84d7-7cf93584054d',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_21bbefd5-8dc0-4e41-91d8-718463ad469c/scan_bdc0c035-5e2c-49c1-9980-ecffc5862af4/41_w1_o3_maxillaire_snapshot_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_TOSC_bdc0c035-5e2c-49c1-9980-ecffc5862af4_SNAPS','41_w1_o3_maxillaire_snapshot_0.png','8e7ff8d7-eb67-4db2-84d7-7cf93584054d','{\"displayTitle\":\"Maxilla 1.41.1.3.4\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-03 16:11:16.000','2024-10-31 14:02:32.059','2024-10-31 10:02:32.059'),('8e8c2efb-24ab-42d7-a4b2-e573d68ec234',664,'/var/.data/2022/664/097506b2-3385-4e2b-a196-b427b2eb51b8/session_0a5a2b81-09c6-4fe0-874c-4b845c0229bc/occlusion_e78fa40a-0a61-4104-adb2-0cfd70d69414/scan_f40ef765-344e-4e93-b47e-d26b4b6db487/31_w1_o1_maxillaire_snapshot_0.png','PATIENT_097506b2-3385-4e2b-a196-b427b2eb51b8_ACT_0a5a2b81-09c6-4fe0-874c-4b845c0229bc_SESS_e78fa40a-0a61-4104-adb2-0cfd70d69414_TOSC_f40ef765-344e-4e93-b47e-d26b4b6db487_SNAPS','31_w1_o1_maxillaire_snapshot_0.png','8e8c2efb-24ab-42d7-a4b2-e573d68ec234','{\"displayTitle\":\"Maxilla 1.31.1.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-23 14:32:55.000','2024-10-31 14:02:28.840','2024-10-31 10:02:28.840'),('8f2ac274-c407-43a2-9887-6c9cc61f72a2',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_7d87c990-cfc0-487a-bd48-674f0ba32da1/27_w1_o1_mandibule_snapshot_0.png','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_BOSC_7d87c990-cfc0-487a-bd48-674f0ba32da1_SNAPS','27_w1_o1_mandibule_snapshot_0.png','8f2ac274-c407-43a2-9887-6c9cc61f72a2','{\"displayTitle\":\"Mandible 1.27.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-04 18:57:33.000','2024-10-31 14:02:26.849','2024-10-31 10:02:26.849'),('8fc85d95-e52c-40f1-91d6-38e3efcede21',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_102e062c-07cd-49ca-b2d8-4050c1eb56ee/27_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_RISC_102e062c-07cd-49ca-b2d8-4050c1eb56ee_SNAPS','27_w1_o1_mordu_posterieur_droit_snapshot_0.png','8fc85d95-e52c-40f1-91d6-38e3efcede21','{\"displayTitle\":\"Posterior right bite 1.27.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-04 19:06:05.000','2024-10-31 14:02:28.580','2024-10-31 10:02:28.580'),('906dd2e7-6bf5-4203-89bf-9fe369c52a5a',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_120f9fe3-b23d-49c7-89ab-f1becc102f6c/scan_b08eb59b-89c3-4239-8926-d8eb829e4257/33_w1_o1_mandibule_ml_2_0.xyz','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_120f9fe3-b23d-49c7-89ab-f1becc102f6c_BOSC_b08eb59b-89c3-4239-8926-d8eb829e4257_LIFI','33_w1_o1_mandibule_ml_2_0.xyz','906dd2e7-6bf5-4203-89bf-9fe369c52a5a','{\"displayTitle\":\"Margin line Mandible 1.33.1.1.1 Margin line 2\",\"name\":\"Margin line 2\",\"title\":\"Mandible LIFI\",\"toothNumber\":2,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2022-04-14 15:19:53.000','2024-10-31 14:02:29.233','2024-10-31 10:02:29.233'),('9122eeb5-6c35-11ee-bc7f-58a023cda0dc',664,'/var/.data/2023/664/bbc77872-6c30-11ee-bc7f-58a023cda0dc/session_0a963705-6c31-11ee-bc7f-58a023cda0dc/occlusion_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc/scan_041ad44a-6c35-11ee-bc7f-58a023cda0dc/9122eeb5-6c35-11ee-bc7f-58a023cda0dc.zip','PATIENT_bbc77872-6c30-11ee-bc7f-58a023cda0dc_ACT_0a963705-6c31-11ee-bc7f-58a023cda0dc_SESS_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc_BOSC_041ad44a-6c35-11ee-bc7f-58a023cda0dc_MODEL','9122eeb5-6c35-11ee-bc7f-58a023cda0dc.zip','9122eeb5-6c35-11ee-bc7f-58a023cda0dc','{\"displayTitle\":\"Mandible 1.53.1.1.2\",\"modelMatrix\":\"0.53002,0.749056,-0.397484,0,-0.847985,0.468186,-0.248441,0,1.42556e-08,0.468739,0.883337,0,-25.188,-21.2022,-16.5919,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-10-16 13:05:12.000','2023-10-16 17:12:49.284','2023-10-16 13:12:49.284'),('9122ff07-6c35-11ee-bc7f-58a023cda0dc',664,'/var/.data/2023/664/bbc77872-6c30-11ee-bc7f-58a023cda0dc/session_0a963705-6c31-11ee-bc7f-58a023cda0dc/occlusion_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc/scan_041ad44a-6c35-11ee-bc7f-58a023cda0dc/9122ff07-6c35-11ee-bc7f-58a023cda0dc.png','PATIENT_bbc77872-6c30-11ee-bc7f-58a023cda0dc_ACT_0a963705-6c31-11ee-bc7f-58a023cda0dc_SESS_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc_BOSC_041ad44a-6c35-11ee-bc7f-58a023cda0dc_SNAPS','9122ff07-6c35-11ee-bc7f-58a023cda0dc.png','9122ff07-6c35-11ee-bc7f-58a023cda0dc','{\"displayTitle\":\"Mandible 1.53.1.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-10-16 13:05:16.000','2023-10-16 17:12:49.310','2023-10-16 13:12:49.310'),('91e10183-53a1-4f42-bf1f-d69b3d883102',664,'/var/.data/2022/664/48a38618-e853-4bf0-aa6b-4c83fb8b6f13/session_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d/occlusion_540d878b-7415-4498-8c6c-01875eec35f8/scan_e145920a-617c-4eab-b810-0a863371eb36/38_w1_o1_mandibule_snapshot_1.png','PATIENT_48a38618-e853-4bf0-aa6b-4c83fb8b6f13_ACT_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d_SESS_540d878b-7415-4498-8c6c-01875eec35f8_BOSC_e145920a-617c-4eab-b810-0a863371eb36_SNAPS','38_w1_o1_mandibule_snapshot_1.png','d6c21fa2-43a3-46ad-8b9a-3f2b83d486d1','{\"displayTitle\":\"Mandible 1.38.1.1.2\",\"title\":\"Mandible SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-06-22 16:56:22.000','2024-10-31 14:02:29.906','2024-10-31 10:02:29.906'),('91e3e40c-b1ea-42dd-ae35-8df274c2b234',664,'/var/.data/2022/664/cede029c-15bc-44c2-9c9c-fac7f8983524/session_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29/occlusion_4d46a627-5949-4b2a-b4d6-c391f159485b/scan_fe5df0bd-7cd7-42f8-ba75-4278d329b237/46_w1_o1_mandibule_scan_file_0.zip','PATIENT_cede029c-15bc-44c2-9c9c-fac7f8983524_ACT_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29_SESS_4d46a627-5949-4b2a-b4d6-c391f159485b_BOSC_fe5df0bd-7cd7-42f8-ba75-4278d329b237_MODEL','46_w1_o1_mandibule_scan_file_0.zip','91e3e40c-b1ea-42dd-ae35-8df274c2b234','{\"displayTitle\":\"Mandible 1.46.1.1.1\",\"modelMatrix\":\"0.896446,0.423906,-0.129182,0,-0.443152,0.857513,-0.26132,0,-3.3412e-09,0.291506,0.956569,0,-18.9713,-12.7618,-18.5049,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-12 20:32:10.000','2024-10-31 14:02:35.139','2024-10-31 10:02:35.139'),('91eb27f3-2931-48bd-a8af-b828ef131e01',664,'','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_705960fa-3ed4-4013-9cde-20022721d122_SESS_9f4fa7cb-81a3-460e-b189-ba76eb8cee15_BOSC_a58436fa-a729-4ed0-9312-1037d7bc8f6e_MODEL','7_w8_o1_mandibule_scan_file_0.zip','91eb27f3-2931-48bd-a8af-b828ef131e01','{\"displayTitle\":\"Mandible 1.7.8.1.1\",\"modelMatrix\":\"0.717351,0.693048,-0.0713539,0,-0.696712,0.713579,-0.0734678,0,1.90471e-10,0.102415,0.994742,0,-18.9482,2.15747,-17.4117,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:07:54.000','2022-03-30 10:49:31.000','2024-10-31 14:02:28.882','2024-10-31 10:02:28.882'),('923d8e02-07de-4a6f-b0d0-df13d765b4c1',664,'/var/.data/2021/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_119ba34e-97cf-4c1f-bed9-20fa56366355/occlusion_585f84a0-017e-4b5a-9465-7947c2ada0b3/scan_21c82eed-acf4-4093-986f-a306c3e0c043/18_w3_o1_maxillaire_scan_file_0.zip','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_119ba34e-97cf-4c1f-bed9-20fa56366355_SESS_585f84a0-017e-4b5a-9465-7947c2ada0b3_TOSC_21c82eed-acf4-4093-986f-a306c3e0c043_MODEL','18_w3_o1_maxillaire_scan_file_0.zip','923d8e02-07de-4a6f-b0d0-df13d765b4c1','{\"displayTitle\":\"Maxilla 1.18.3.1.2\",\"modelMatrix\":\"-0.8656,0.210741,-0.454231,0,-0.500737,-0.364297,0.785207,0,8.57747e-10,0.907125,0.420861,0,25.0727,-2.23834,-5.24079,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-27 19:55:46.000','2024-10-31 14:02:25.943','2024-10-31 10:02:25.943'),('924eb01d-c7f1-4784-ab3d-bffa8647cc5a',664,'/var/.data/2022/664/7eac18e5-5ed2-4ed9-8b3e-eba1c562d708/session_c49716f1-987e-4111-9ab9-4541a0378bb7/occlusion_9a395a3e-4872-409e-922b-4bb58053d8a5/scan_b6b465bc-cccb-49a9-ba82-6a6e82cd4324/30_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_LESC_b6b465bc-cccb-49a9-ba82-6a6e82cd4324_MODEL','30_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','924eb01d-c7f1-4784-ab3d-bffa8647cc5a','{\"displayTitle\":\"Posterior left bite 1.30.1.1.1\",\"modelMatrix\":\"-0.980941,0.0548474,0.189679,0,-0.0593858,-0.996007,-0.0520025,0,0.18518,-0.0712969,0.9805,0,12.2471,4.17028,-20.61,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-21 15:39:30.000','2024-10-31 14:02:33.080','2024-10-31 10:02:33.080'),('92a8aaff-0105-4be1-8e93-7c174c4ed35f',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_c90ddf83-1e94-4d7c-a61f-3f7bed3aad41/occlusion_5dac735e-358c-49a1-aa52-0180d8d8ff7e/scan_7ce9b1b8-7c7b-4655-bd0d-90f37ced345e/27_w2_o1_maxillaire_snapshot_0.png','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_c90ddf83-1e94-4d7c-a61f-3f7bed3aad41_SESS_5dac735e-358c-49a1-aa52-0180d8d8ff7e_TOSC_7ce9b1b8-7c7b-4655-bd0d-90f37ced345e_SNAPS','27_w2_o1_maxillaire_snapshot_0.png','92a8aaff-0105-4be1-8e93-7c174c4ed35f','{\"displayTitle\":\"Maxilla 1.27.2.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-20 18:17:04.000','2024-10-31 14:02:26.781','2024-10-31 10:02:26.781'),('92bd4757-0c86-4e51-ab79-39f0a6427d18',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_a72c11a4-05dc-4421-b252-fbfcecd2559e/order_7bb41f92-9801-4a80-9db6-907964cacece/14_w1_couronne_sur_implant_prost_file_0.pdf','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_a72c11a4-05dc-4421-b252-fbfcecd2559e_PROST_7bb41f92-9801-4a80-9db6-907964cacece_FORM','14_w1_couronne_sur_implant_prost_file_0.pdf','92bd4757-0c86-4e51-ab79-39f0a6427d18','{\"displayTitle\":\"IMPLANT CROWN 1.14.1.1 IMPLANT CROWN\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-09-09 15:58:04.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.778'),('92fc9e76-e486-464f-bc7a-6f09ea6899e8',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_d3696b3d-0728-4822-b89d-631e2ab774a4/occlusion_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6/scan_c550cbc7-71cb-4513-8c8b-7c725f1e0129/14_w2_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_d3696b3d-0728-4822-b89d-631e2ab774a4_SESS_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6_RISC_c550cbc7-71cb-4513-8c8b-7c725f1e0129_MODEL','14_w2_o1_mordu_posterieur_droit_scan_file_0.ply','92fc9e76-e486-464f-bc7a-6f09ea6899e8','{\"displayTitle\":\"Posterior right bite 1.14.2.1.1\",\"modelMatrix\":\"0.901284,-0.170415,0.395582,0,0.153332,0.985383,0.0412607,0,-0.405382,0.014966,0.917642,0,-7.28379,-0.822851,-22.0767,1\",\"title\":\"Posterior right bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-11-30 02:14:43.000','2024-10-31 14:02:25.550','2024-10-31 10:02:25.550'),('930bda4e-7342-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/46c4cd1e-7338-11ee-b011-58a023cda0dc/session_ecbd4537-7341-11ee-b011-58a023cda0dc/occlusion_ecbe814b-7341-11ee-b011-58a023cda0dc/scan_59402aaf-7342-11ee-b011-58a023cda0dc/930bda4e-7342-11ee-b011-58a023cda0dc.zip','PATIENT_46c4cd1e-7338-11ee-b011-58a023cda0dc_ACT_ecbd4537-7341-11ee-b011-58a023cda0dc_SESS_ecbe814b-7341-11ee-b011-58a023cda0dc_BOSC_59402aaf-7342-11ee-b011-58a023cda0dc_MODEL','930bda4e-7342-11ee-b011-58a023cda0dc.zip','930bda4e-7342-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Mandible 1.54.1.1.1\",\"modelMatrix\":\"0.222778,0.897321,-0.381032,0,-0.974869,0.205057,-0.087074,0,7.79179e-09,0.390855,0.920452,0,-14.8978,-15.6229,-15.8926,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-10-25 11:27:41.000','2023-10-30 13:47:02.699','2023-10-30 09:47:02.699'),('930be898-7342-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/46c4cd1e-7338-11ee-b011-58a023cda0dc/session_ecbd4537-7341-11ee-b011-58a023cda0dc/occlusion_ecbe814b-7341-11ee-b011-58a023cda0dc/scan_59402aaf-7342-11ee-b011-58a023cda0dc/930be898-7342-11ee-b011-58a023cda0dc.png','PATIENT_46c4cd1e-7338-11ee-b011-58a023cda0dc_ACT_ecbd4537-7341-11ee-b011-58a023cda0dc_SESS_ecbe814b-7341-11ee-b011-58a023cda0dc_BOSC_59402aaf-7342-11ee-b011-58a023cda0dc_SNAPS','930be898-7342-11ee-b011-58a023cda0dc.png','930be898-7342-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Mandible 1.54.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-10-25 11:27:47.000','2023-10-30 13:47:02.731','2023-10-30 09:47:02.731'),('93745579-3a16-4eae-8e26-3f1db1a2ff74',664,'','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_RISC_ed845142-2dca-48e8-8ec9-cc1f6a86f8cb_MODEL','49_w1_o1_mordu_posterieur_droit_scan_file_0.zip','93745579-3a16-4eae-8e26-3f1db1a2ff74','{\"displayTitle\":\"Posterior right bite 1.49.1.1.1\",\"modelMatrix\":\"0.995833,-0.0719416,0.0556548,0,0.0739865,0.997156,-0.0218763,0,-0.0533288,0.0227076,0.998215,0,-3.28679,4.18907,-19.8029,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:07:55.000','2022-10-31 12:17:03.000','2024-10-31 14:02:35.554','2024-10-31 10:02:35.554'),('93860282-92b8-481f-9798-793726627785',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/occlusion_d7b86e87-0261-4bc1-8529-76e0bdd29195/scan_d43bd9e0-44ee-49ed-aa89-8bcd9837b34a/18_w4_o1_mordu_anterieur_scan_file_2.zip','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_FRSC_d43bd9e0-44ee-49ed-aa89-8bcd9837b34a_MODEL','18_w4_o1_mordu_anterieur_scan_file_2.zip','2271f9bf-12c8-4420-b9f4-ce7ac01d3567','{\"displayTitle\":\"Anterior bite 1.18.4.1.1\",\"modelMatrix\":\"0.916712,0.0219898,0.382594,0,0.0140873,0.996337,-0.0964529,0,-0.399707,0.0833748,0.919111,0,-5.67125,-3.37112,-31.5025,1\",\"title\":\"Anterior bite ZIP\"}','ZIP',2,'SYNCED',0,NULL,'2022-08-24 16:45:00.000','2023-05-22 13:09:23.121','2023-05-22 09:09:23.121'),('939fcf5e-168c-450a-94f3-7fab10eeaf36',664,'/var/.data/2022/664/097506b2-3385-4e2b-a196-b427b2eb51b8/session_0a5a2b81-09c6-4fe0-874c-4b845c0229bc/occlusion_e78fa40a-0a61-4104-adb2-0cfd70d69414/scan_f40ef765-344e-4e93-b47e-d26b4b6db487/31_w1_o1_maxillaire_scan_file_0.zip','PATIENT_097506b2-3385-4e2b-a196-b427b2eb51b8_ACT_0a5a2b81-09c6-4fe0-874c-4b845c0229bc_SESS_e78fa40a-0a61-4104-adb2-0cfd70d69414_TOSC_f40ef765-344e-4e93-b47e-d26b4b6db487_MODEL','31_w1_o1_maxillaire_scan_file_0.zip','939fcf5e-168c-450a-94f3-7fab10eeaf36','{\"displayTitle\":\"Maxilla 1.31.1.1.2\",\"modelMatrix\":\"-0.092176,0.923616,-0.372072,0,-0.995743,-0.0854992,0.0344427,0,-1.6519e-09,0.373663,0.927565,0,-20.8361,-36.7473,-10.3108,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-23 14:32:56.000','2024-10-31 14:02:28.849','2024-10-31 10:02:28.849'),('93e1d6ba-56ac-4322-aa8d-68802281f1de',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_775311e4-a561-40c7-a2ce-76a0b1550be8/scan_8ce97d97-ffb5-461c-928d-ea25e722645a/41_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_775311e4-a561-40c7-a2ce-76a0b1550be8_LESC_8ce97d97-ffb5-461c-928d-ea25e722645a_SNAPS','41_w1_o1_mordu_posterieur_gauche_snapshot_0.png','93e1d6ba-56ac-4322-aa8d-68802281f1de','{\"displayTitle\":\"Posterior left bite 1.41.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-07-28 15:36:48.000','2024-10-31 14:02:32.207','2024-10-31 10:02:32.207'),('940e449c-2145-4c2d-a126-51d8d7e8e92c',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_db740293-ae2a-40ae-9142-4d94ed66bcd5/occlusion_1256ab02-5172-4a92-a17d-f2fc402290ac/scan_b6033058-40f5-4202-bc4b-bfe024d70e70/7_w6_o1_maxillaire_snapshot_2.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_db740293-ae2a-40ae-9142-4d94ed66bcd5_SESS_1256ab02-5172-4a92-a17d-f2fc402290ac_TOSC_b6033058-40f5-4202-bc4b-bfe024d70e70_SNAPS','7_w6_o1_maxillaire_snapshot_2.png','d31fff53-e769-4756-bc68-5aeea0d528b5','{\"displayTitle\":\"Maxilla 1.7.6.1.4\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2021-05-05 16:34:13.000','2024-10-31 14:02:26.379','2024-10-31 10:02:26.379'),('946f18a4-6540-11ef-b382-58a023cda0dc',664,'/var/.data/2024/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_721d0cdd-6536-11ef-b382-58a023cda0dc/occlusion_721e3ad7-6536-11ef-b382-58a023cda0dc/scan_60bb883b-6540-11ef-b382-58a023cda0dc/946f18a4-6540-11ef-b382-58a023cda0dc.zip','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_721d0cdd-6536-11ef-b382-58a023cda0dc_SESS_721e3ad7-6536-11ef-b382-58a023cda0dc_RISC_60bb883b-6540-11ef-b382-58a023cda0dc_MODEL','946f18a4-6540-11ef-b382-58a023cda0dc.zip','946f18a4-6540-11ef-b382-58a023cda0dc','{\"displayTitle\":\"Right bite 1.35.2.1.1\",\"modelMatrix\":\"0.964965,0.0385632,0.26096,0,-0.0649813,0.99286,0.106685,0,-0.254212,-0.113137,0.959466,0,-9.11169,0.746551,-22.7329,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-08-28 09:25:50.000','2024-08-28 13:38:47.137','2024-08-28 09:38:47.137'),('946f2cbd-6540-11ef-b382-58a023cda0dc',664,'/var/.data/2024/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_721d0cdd-6536-11ef-b382-58a023cda0dc/occlusion_721e3ad7-6536-11ef-b382-58a023cda0dc/scan_60bb883b-6540-11ef-b382-58a023cda0dc/946f2cbd-6540-11ef-b382-58a023cda0dc.png','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_721d0cdd-6536-11ef-b382-58a023cda0dc_SESS_721e3ad7-6536-11ef-b382-58a023cda0dc_RISC_60bb883b-6540-11ef-b382-58a023cda0dc_SNAPS','946f2cbd-6540-11ef-b382-58a023cda0dc.png','946f2cbd-6540-11ef-b382-58a023cda0dc','{\"displayTitle\":\"Right bite 1.35.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-08-28 09:25:51.000','2024-08-28 13:38:47.152','2024-08-28 09:38:47.152'),('951e6aca-ea1e-430b-99f1-11ca3d7e0cd0',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_36d05387-51e6-4286-a074-7c7894c0622b/occlusion_0ec93b21-a91f-4695-a966-e072a8fb68e3/scan_5212b119-1f64-4de6-82e2-b5b72ee0e22b/7_w7_o1_maxillaire_snapshot_1.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_36d05387-51e6-4286-a074-7c7894c0622b_SESS_0ec93b21-a91f-4695-a966-e072a8fb68e3_TOSC_5212b119-1f64-4de6-82e2-b5b72ee0e22b_SNAPS','7_w7_o1_maxillaire_snapshot_1.png','6e75df3d-e558-4cc6-8263-62b0654e0206','{\"displayTitle\":\"Maxilla 1.7.7.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-05-05 16:57:47.000','2024-10-31 14:02:26.699','2024-10-31 10:02:26.699'),('961b1c26-009d-415b-b3e0-e5f95a643091',664,'/var/.data/2021/664/366ffa87-059a-436a-9125-8827b3a2da1a/session_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9/occlusion_a59f40f9-2208-4d6a-b286-f64533d92e3c/scan_1d1515dc-8da4-4b0c-83dc-d1599e5f76cf/15_w1_o1_mandibule_scan_file_0.ply','PATIENT_366ffa87-059a-436a-9125-8827b3a2da1a_ACT_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9_SESS_a59f40f9-2208-4d6a-b286-f64533d92e3c_BOSC_1d1515dc-8da4-4b0c-83dc-d1599e5f76cf_MODEL','15_w1_o1_mandibule_scan_file_0.ply','961b1c26-009d-415b-b3e0-e5f95a643091','{\"displayTitle\":\"Mandible 1.15.1.1.1\",\"modelMatrix\":\"0.807748,0.576759,-0.122033,0,-0.589528,0.790253,-0.167205,0,-6.65091e-9,0.207001,0.978341,0,-28.9231,3.26854,-15.1678,1\",\"title\":\"Mandible PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-01-18 21:35:58.000','2024-10-31 14:02:25.837','2024-10-31 10:02:25.837'),('965138c3-5a1e-4951-83ee-9b341d1f7858',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_d3696b3d-0728-4822-b89d-631e2ab774a4/occlusion_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6/scan_ec2d4010-6686-4b96-af72-0ece2b145c0d/14_w2_o1_maxillaire_scan_file_0.ply','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_d3696b3d-0728-4822-b89d-631e2ab774a4_SESS_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6_TOSC_ec2d4010-6686-4b96-af72-0ece2b145c0d_MODEL','14_w2_o1_maxillaire_scan_file_0.ply','965138c3-5a1e-4951-83ee-9b341d1f7858','{\"displayTitle\":\"Maxilla 1.14.2.1.1\",\"modelMatrix\":\"-0.52442,0.771292,-0.360682,0,-0.85146,-0.475044,0.222147,0,1.06884e-8,0.423605,0.905847,0,9.11931,-26.446,-10.9214,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-11-30 02:14:43.000','2024-10-31 14:02:32.568','2024-10-31 10:02:32.568'),('977f03ab-6177-11eb-94ee-226cec7cb58a',664,'/var/.data/2021/664/discussion_74df8c86-9348-43cd-bbaa-383903f28a54/977f03ab-6177-11eb-94ee-226cec7cb58a.png','PATIENT_366ffa87-059a-436a-9125-8827b3a2da1a_ACT_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9_SESS_a59f40f9-2208-4d6a-b286-f64533d92e3c_BOSC_1d1515dc-8da4-4b0c-83dc-d1599e5f76cf_SNAPS','977f03ab-6177-11eb-94ee-226cec7cb58a.png','977f03ab-6177-11eb-94ee-226cec7cb58a','{\"displayTitle\":\"Mandible 1.15.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-01-18 21:35:58.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.779'),('97823a3d-6177-11eb-94ee-226cec7cb58a',664,'/var/.data/2021/664/discussion_74df8c86-9348-43cd-bbaa-383903f28a54/97823a3d-6177-11eb-94ee-226cec7cb58a.png','PATIENT_366ffa87-059a-436a-9125-8827b3a2da1a_ACT_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9_SESS_a59f40f9-2208-4d6a-b286-f64533d92e3c_FRSC_c17d800a-58c0-4658-b29b-d8ee0cbd16bb_SNAPS','97823a3d-6177-11eb-94ee-226cec7cb58a.png','97823a3d-6177-11eb-94ee-226cec7cb58a','{\"displayTitle\":\"Anterior bite 1.15.1.1.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-01-18 21:39:02.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.779'),('97845a20-6177-11eb-94ee-226cec7cb58a',664,'/var/.data/2021/664/discussion_74df8c86-9348-43cd-bbaa-383903f28a54/97845a20-6177-11eb-94ee-226cec7cb58a.ply','PATIENT_366ffa87-059a-436a-9125-8827b3a2da1a_ACT_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9_SESS_a59f40f9-2208-4d6a-b286-f64533d92e3c_FRSC_c17d800a-58c0-4658-b29b-d8ee0cbd16bb_MODEL','97845a20-6177-11eb-94ee-226cec7cb58a.ply','97845a20-6177-11eb-94ee-226cec7cb58a','{\"displayTitle\":\"Anterior bite 1.15.1.1.1\",\"modelMatrix\":\"0.996744,0.0720922,0.0587105,0,-0.045079,0.99239,-0.094337,0,-0.0701313,0.102581,0.993913,0,-2.2834,-2.95306,-21.4527,1\",\"title\":\"Anterior bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-01-18 21:39:02.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.779'),('97875176-6177-11eb-94ee-226cec7cb58a',664,'/var/.data/2021/664/discussion_74df8c86-9348-43cd-bbaa-383903f28a54/97875176-6177-11eb-94ee-226cec7cb58a.ply','PATIENT_366ffa87-059a-436a-9125-8827b3a2da1a_ACT_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9_SESS_a59f40f9-2208-4d6a-b286-f64533d92e3c_BOSC_1d1515dc-8da4-4b0c-83dc-d1599e5f76cf_MODEL','97875176-6177-11eb-94ee-226cec7cb58a.ply','97875176-6177-11eb-94ee-226cec7cb58a','{\"displayTitle\":\"Mandible 1.15.1.1.1\",\"modelMatrix\":\"0.807748,0.576759,-0.122033,0,-0.589528,0.790253,-0.167205,0,-6.65091e-9,0.207001,0.978341,0,-28.9231,3.26854,-15.1678,1\",\"title\":\"Mandible PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-01-18 21:35:58.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.779'),('9788a356-6177-11eb-94ee-226cec7cb58a',664,'/var/.data/2021/664/discussion_74df8c86-9348-43cd-bbaa-383903f28a54/9788a356-6177-11eb-94ee-226cec7cb58a.ply','PATIENT_366ffa87-059a-436a-9125-8827b3a2da1a_ACT_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9_SESS_a59f40f9-2208-4d6a-b286-f64533d92e3c_TOSC_056c711b-f9d5-4a04-93e2-9015a27c4b1b_MODEL','9788a356-6177-11eb-94ee-226cec7cb58a.ply','9788a356-6177-11eb-94ee-226cec7cb58a','{\"displayTitle\":\"Maxilla 1.15.1.1.1\",\"modelMatrix\":\"-0.810909,0.373673,-0.450328,0,-0.585173,-0.517821,0.624047,0,2.10308e-8,0.769565,0.638568,0,15.7201,0.723143,-17.6513,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-01-18 21:27:55.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.780'),('9789d53a-6177-11eb-94ee-226cec7cb58a',664,'/var/.data/2021/664/discussion_74df8c86-9348-43cd-bbaa-383903f28a54/9789d53a-6177-11eb-94ee-226cec7cb58a.pdf','PATIENT_366ffa87-059a-436a-9125-8827b3a2da1a_ACT_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9_PROST_ce221fe3-3073-4ef0-aa97-eb8dc1eefb70_FORM','9789d53a-6177-11eb-94ee-226cec7cb58a.pdf','9789d53a-6177-11eb-94ee-226cec7cb58a','{\"displayTitle\":\"GUIDE 1.15.1.1 GUIDE\",\"title\":\"Guide PDF\"}','PDF',0,'SYNCED',0,NULL,'2021-01-28 15:46:20.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.780'),('978b0da3-6177-11eb-94ee-226cec7cb58a',664,'/var/.data/2021/664/discussion_74df8c86-9348-43cd-bbaa-383903f28a54/978b0da3-6177-11eb-94ee-226cec7cb58a.png','PATIENT_366ffa87-059a-436a-9125-8827b3a2da1a_ACT_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9_SESS_a59f40f9-2208-4d6a-b286-f64533d92e3c_TOSC_056c711b-f9d5-4a04-93e2-9015a27c4b1b_SNAPS','978b0da3-6177-11eb-94ee-226cec7cb58a.png','978b0da3-6177-11eb-94ee-226cec7cb58a','{\"displayTitle\":\"Maxilla 1.15.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-01-18 21:27:55.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.780'),('97fc9012-a54b-49d1-94c9-f89634ee71b9',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/occlusion_d7b86e87-0261-4bc1-8529-76e0bdd29195/scan_6d0c8022-e8b8-4ffa-8b31-ee9c8a811bb3/18_w4_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_LESC_6d0c8022-e8b8-4ffa-8b31-ee9c8a811bb3_MODEL','18_w4_o1_mordu_posterieur_gauche_scan_file_0.zip','97fc9012-a54b-49d1-94c9-f89634ee71b9','{\"displayTitle\":\"Posterior left bite 1.18.4.1.1\",\"modelMatrix\":\"-0.9892,-0.072221,0.129087,0,0.0975331,-0.975135,0.199377,0,0.109427,0.209515,0.971385,0,14.4263,-3.07322,-19.3189,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-24 16:37:47.000','2023-05-22 13:09:23.136','2023-05-22 09:09:23.136'),('98005729-251e-46d8-9ac3-e9878a47b441',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_a72c11a4-05dc-4421-b252-fbfcecd2559e/occlusion_bf823edb-92ee-4ee9-acd3-507d49bad781/scan_fdcb8fba-f16b-457a-8027-7f34eeace00b/14_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_a72c11a4-05dc-4421-b252-fbfcecd2559e_SESS_bf823edb-92ee-4ee9-acd3-507d49bad781_RISC_fdcb8fba-f16b-457a-8027-7f34eeace00b_MODEL','14_w1_o1_mordu_posterieur_droit_scan_file_0.ply','98005729-251e-46d8-9ac3-e9878a47b441','{\"displayTitle\":\"Posterior right bite 1.14.1.1.1\",\"modelMatrix\":\"0.901284,-0.170415,0.395582,0,0.153332,0.985383,0.0412607,0,-0.405382,0.014966,0.917642,0,-7.28379,-0.822851,-22.0767,1\",\"title\":\"Posterior right bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-09-09 15:50:19.000','2024-10-31 14:02:32.788','2024-10-31 10:02:32.788'),('9893fa50-f84e-4275-9dbd-698be7666922',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/order_73b64ad8-c002-4b00-8cb0-479d3d5e1a46/33_w1_couronne_sur_implant_prost_file_9893fa50-f84e-4275-9dbd-698be7666922_0.pdf','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_PROST_73b64ad8-c002-4b00-8cb0-479d3d5e1a46_FORM','33_w1_couronne_sur_implant_prost_file_9893fa50-f84e-4275-9dbd-698be7666922_0.pdf','9893fa50-f84e-4275-9dbd-698be7666922','{\"displayTitle\":\"ORDER 1.33.1.2 IMPLANT CROWN\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-04-14 15:15:15.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.798'),('991b6bf3-db84-4e38-b3ca-2e1d37a170c0',664,'','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_BOSC_5478f37b-d39e-46d1-a026-906c02d9c928_SNAPS','30_w1_o1_mandibule_snapshot_0.png','991b6bf3-db84-4e38-b3ca-2e1d37a170c0','{\"displayTitle\":\"Mandible 1.30.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:07:42.000','2022-03-21 10:21:06.000','2024-10-31 14:02:28.756','2024-10-31 10:02:28.756'),('99602643-4adf-4f72-936c-b7c9e84e9ca5',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_406263f6-a620-460e-a1e0-2d50ff84809c/32_w1_o1_maxillaire_scan_file_0.zip','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_TOSC_406263f6-a620-460e-a1e0-2d50ff84809c_MODEL','32_w1_o1_maxillaire_scan_file_0.zip','99602643-4adf-4f72-936c-b7c9e84e9ca5','{\"displayTitle\":\"Maxilla 1.32.1.1.1\",\"modelMatrix\":\"-0.519992,0.763137,-0.383706,0,-0.854171,-0.464573,0.233588,0,7.86125e-09,0.449215,0.893424,0,33.3007,-19.7302,-11.91,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-23 16:23:25.000','2024-10-31 14:02:32.844','2024-10-31 10:02:32.844'),('9963e44b-40c3-4e29-8123-4685327fc471',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/occlusion_e930782a-e2db-43e8-9ff1-9feb64e20e4e/scan_1642c8fb-5963-4064-9b58-acef4374ce2b/35_w1_o1_maxillaire_scan_file_0.zip','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_TOSC_1642c8fb-5963-4064-9b58-acef4374ce2b_MODEL','35_w1_o1_maxillaire_scan_file_0.zip','9963e44b-40c3-4e29-8123-4685327fc471','{\"displayTitle\":\"Maxilla 1.35.1.1.1\",\"modelMatrix\":\"-0.903683,0.239348,-0.355062,0,-0.428202,-0.505123,0.749329,0,-6.18581e-10,0.829194,0.55896,0,-3.54985,-30.5546,-9.84991,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-06 19:58:22.000','2024-10-31 14:02:29.517','2024-10-31 10:02:29.517'),('99be3996-9839-11ee-86e7-58a023cda0dc',664,'/var/.data/2023/664/b4c6341b-9837-11ee-86e7-58a023cda0dc/session_bf1582a4-9837-11ee-86e7-58a023cda0dc/occlusion_bf16aee0-9837-11ee-86e7-58a023cda0dc/scan_34ec8b9f-9839-11ee-86e7-58a023cda0dc/99be3996-9839-11ee-86e7-58a023cda0dc.zip','PATIENT_b4c6341b-9837-11ee-86e7-58a023cda0dc_ACT_bf1582a4-9837-11ee-86e7-58a023cda0dc_SESS_bf16aee0-9837-11ee-86e7-58a023cda0dc_FRSC_34ec8b9f-9839-11ee-86e7-58a023cda0dc_MODEL','99be3996-9839-11ee-86e7-58a023cda0dc.zip','99be3996-9839-11ee-86e7-58a023cda0dc','{\"displayTitle\":\"Anterior bite 1.56.1.1.1\",\"modelMatrix\":\"0.645091,-0.0437401,0.758532,0,-0.00487586,0.99641,0.093218,0,-0.764557,-0.077728,0.645021,0,5.59887,3.75362,-33.3278,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-12-11 10:40:47.000','2023-12-11 16:39:42.060','2023-12-11 11:39:42.060'),('99be4912-9839-11ee-86e7-58a023cda0dc',664,'/var/.data/2023/664/b4c6341b-9837-11ee-86e7-58a023cda0dc/session_bf1582a4-9837-11ee-86e7-58a023cda0dc/occlusion_bf16aee0-9837-11ee-86e7-58a023cda0dc/scan_34ec8b9f-9839-11ee-86e7-58a023cda0dc/99be4912-9839-11ee-86e7-58a023cda0dc.png','PATIENT_b4c6341b-9837-11ee-86e7-58a023cda0dc_ACT_bf1582a4-9837-11ee-86e7-58a023cda0dc_SESS_bf16aee0-9837-11ee-86e7-58a023cda0dc_FRSC_34ec8b9f-9839-11ee-86e7-58a023cda0dc_SNAPS','99be4912-9839-11ee-86e7-58a023cda0dc.png','99be4912-9839-11ee-86e7-58a023cda0dc','{\"displayTitle\":\"Anterior bite 1.56.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-12-11 10:40:47.000','2023-12-11 16:39:42.075','2023-12-11 11:39:42.075'),('99db3193-ff76-4f3f-a7c2-aa110e6a5695',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/order_249e488c-5a44-41ef-8fc3-630cd1be0fb7/37_w2_couronne_prost_file_99db3193-ff76-4f3f-a7c2-aa110e6a5695_0.pdf','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_PROST_249e488c-5a44-41ef-8fc3-630cd1be0fb7_FORM','37_w2_couronne_prost_file_99db3193-ff76-4f3f-a7c2-aa110e6a5695_0.pdf','99db3193-ff76-4f3f-a7c2-aa110e6a5695','{\"displayTitle\":\"ORDER 1.37.2.4 Elisabeth Baxter CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-11-02 19:37:32.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.780'),('9a09f6da-9465-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/9a09f6da-9465-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_MODEL','9a09f6da-9465-11ee-8fd8-58a023cda0dc.zip','87a0d07a-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1\",\"modelMatrix\":\"0.843881,0.502692,-0.187524,0,-0.53653,0.790659,-0.294947,0,3.33011e-09,0.349512,0.936932,0,-21.678,-3.20968,-22.8257,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2023-12-06 13:30:59.201','2023-12-06 19:12:08.100','2023-12-11 10:11:55.002'),('9adb67c5-8660-4e2c-b600-8f49fc13648e',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_b5dae369-a773-4095-aa54-7c8b75c939d8/occlusion_a12bd271-974e-4fcf-8893-d88105690bce/scan_e1f9f752-dd61-4e2b-82d8-016edf9173cf/7_w3_o1_maxillaire_scan_file_2.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_b5dae369-a773-4095-aa54-7c8b75c939d8_SESS_a12bd271-974e-4fcf-8893-d88105690bce_TOSC_e1f9f752-dd61-4e2b-82d8-016edf9173cf_MODEL','7_w3_o1_maxillaire_scan_file_2.ply','b89bdf45-07f7-4aef-b272-f9b581b06b02','{\"displayTitle\":\"Maxilla 1.7.3.1.1\",\"modelMatrix\":\"0.353491,0.735052,-0.57857,0,-0.935438,0.277767,-0.218635,0,2.08057e-8,0.618502,0.785783,0,4.33116,-47.3843,-20.4717,1\",\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":10,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1,\"title\":\"Maxilla PLY\"}','PLY',2,'SYNCED',0,NULL,'2021-04-28 17:11:30.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.275'),('9b387987-e8a0-44b3-a6d7-f5768d6c1991',664,'/var/.data/2022/664/cede029c-15bc-44c2-9c9c-fac7f8983524/session_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29/occlusion_4d46a627-5949-4b2a-b4d6-c391f159485b/scan_3558dd42-4c4f-44fb-9e18-6c3609025ffc/46_w1_o1_maxillaire_scan_file_0.zip','PATIENT_cede029c-15bc-44c2-9c9c-fac7f8983524_ACT_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29_SESS_4d46a627-5949-4b2a-b4d6-c391f159485b_TOSC_3558dd42-4c4f-44fb-9e18-6c3609025ffc_MODEL','46_w1_o1_maxillaire_scan_file_0.zip','9b387987-e8a0-44b3-a6d7-f5768d6c1991','{\"displayTitle\":\"Maxilla 1.46.1.1.1\",\"modelMatrix\":\"-0.191523,0.970643,-0.145504,0,-0.981488,-0.189407,0.0283931,0,2.27486e-09,0.148249,0.98895,0,0.344832,-20.2377,-17.3734,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-12 20:27:04.000','2024-10-31 14:02:35.123','2024-10-31 10:02:35.123'),('9bad6bed-66cd-4aaf-9b18-74f56381c4d1',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/order_6a27a984-b0e8-4a31-b556-c4234f6cefec/10_w1_couronne_prost_file_0.pdf','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_PROST_6a27a984-b0e8-4a31-b556-c4234f6cefec_FORM','10_w1_couronne_prost_file_0.pdf','9bad6bed-66cd-4aaf-9b18-74f56381c4d1','{\"displayTitle\":\"CROWN 1.10.1.1 CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-07-01 18:18:10.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.780'),('9bde3553-f30d-4a50-b405-a030db17fb37',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_a72c11a4-05dc-4421-b252-fbfcecd2559e/occlusion_bf823edb-92ee-4ee9-acd3-507d49bad781/scan_fdcb8fba-f16b-457a-8027-7f34eeace00b/14_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_a72c11a4-05dc-4421-b252-fbfcecd2559e_SESS_bf823edb-92ee-4ee9-acd3-507d49bad781_RISC_fdcb8fba-f16b-457a-8027-7f34eeace00b_SNAPS','14_w1_o1_mordu_posterieur_droit_snapshot_0.png','9bde3553-f30d-4a50-b405-a030db17fb37','{\"displayTitle\":\"Posterior right bite 1.14.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-09-09 15:50:19.000','2024-10-31 14:02:32.798','2024-10-31 10:02:32.798'),('9cbbd3d6-f30f-484e-9ba6-85cea84fda1e',664,'','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_BOSC_a0b85a0a-ef77-4f7c-b376-d6e388afe9f0_LIFIM','10_w1_o1_mandibule_mlmeta_0_0.bin','9cbbd3d6-f30f-484e-9ba6-85cea84fda1e','{\"displayTitle\":\"Margin line Mandible 1.10.1.1.1 No name 0\",\"name\":\"No name 0\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":0}','BIN',0,'SYNCED',0,'2023-05-22 09:08:03.000','2020-07-03 10:42:02.000','2024-10-31 14:02:32.299','2024-10-31 10:02:32.299'),('9d285fcb-90ae-48a7-bd6b-143c3ee7c5f8',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_ef2b4fcf-f21c-418d-942a-c99ea96efbdb/occlusion_7d36e059-dbc3-46b0-931a-bdf8fdc805c6/scan_821a2ca1-0234-413b-a35b-4cc6703ca75b/7_w2_o1_maxillaire_scan_file_0.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_ef2b4fcf-f21c-418d-942a-c99ea96efbdb_SESS_7d36e059-dbc3-46b0-931a-bdf8fdc805c6_TOSC_821a2ca1-0234-413b-a35b-4cc6703ca75b_MODEL','7_w2_o1_maxillaire_scan_file_0.ply','9d285fcb-90ae-48a7-bd6b-143c3ee7c5f8','{\"displayTitle\":\"Maxilla 1.7.2.1.3\",\"modelMatrix\":\"-0.99695,0.000275289,-0.0780376,0,-0.0780381,-0.00351686,0.996944,0,2.96423e-11,0.999994,0.00352762,0,7.52577,-29.7935,-0.481815,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-21 15:36:52.000','2024-10-31 14:02:26.293','2024-10-31 10:02:26.293'),('9d3a01d8-ce52-45d5-97b5-184961992b2b',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_669f6bca-452c-4b2e-a49e-aa822628ed5f/24_w1_o1_maxillaire_snapshot_1.png','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_TOSC_669f6bca-452c-4b2e-a49e-aa822628ed5f_SNAPS','24_w1_o1_maxillaire_snapshot_1.png','e6214fe7-dce5-49bb-85f8-3bb098d8c560','{\"displayTitle\":\"Maxilla 1.24.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-09-13 21:19:13.000','2024-10-31 14:02:28.671','2024-10-31 10:02:28.671'),('9dc0f236-1455-4d5a-8b25-404e95fc9a37',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/order_2a260279-f2f6-4f7c-8756-e8a27606b0b3/10_w1_couronne_prost_file_0.pdf','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_PROST_2a260279-f2f6-4f7c-8756-e8a27606b0b3_FORM','10_w1_couronne_prost_file_0.pdf','9dc0f236-1455-4d5a-8b25-404e95fc9a37','{\"displayTitle\":\"CROWN 1.10.1.3 CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-09-17 03:54:34.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.781'),('9dcba4d5-3b87-469b-931c-d1f2c5b0cc99',664,'/var/.data/2021/664/d71657f7-b9e8-45b9-865f-1c4c55c62017/session_ce26f180-fc4c-444b-bdda-56104c53d7a2/occlusion_a03e7e47-63b0-4489-88e8-a77bb9aed5cd/scan_b0b45de7-f1c4-4f46-9c23-2126c2326f9b/23_w1_o1_maxillaire_snapshot_0.png','PATIENT_d71657f7-b9e8-45b9-865f-1c4c55c62017_ACT_ce26f180-fc4c-444b-bdda-56104c53d7a2_SESS_a03e7e47-63b0-4489-88e8-a77bb9aed5cd_TOSC_b0b45de7-f1c4-4f46-9c23-2126c2326f9b_SNAPS','23_w1_o1_maxillaire_snapshot_0.png','9dcba4d5-3b87-469b-931c-d1f2c5b0cc99','{\"displayTitle\":\"Maxilla 1.23.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-06-21 18:50:32.000','2024-10-31 14:02:25.877','2024-10-31 10:02:25.877'),('9e3589e8-4fb4-4877-a58c-cbb16190d186',664,'/var/.data/2022/664/635617fc-289b-470c-a4d4-678d7b5f275a/session_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6/occlusion_94dc9a16-b72c-4f6a-a520-ba83c28954c3/scan_5f528d31-6a1a-48e7-8ece-1a998befa669/45_w1_o1_mandibule_snapshot_0.png','PATIENT_635617fc-289b-470c-a4d4-678d7b5f275a_ACT_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6_SESS_94dc9a16-b72c-4f6a-a520-ba83c28954c3_BOSC_5f528d31-6a1a-48e7-8ece-1a998befa669_SNAPS','45_w1_o1_mandibule_snapshot_0.png','9e3589e8-4fb4-4877-a58c-cbb16190d186','{\"displayTitle\":\"Mandible 1.45.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-07 16:36:50.000','2024-10-31 14:02:33.337','2024-10-31 10:02:33.337'),('9e5a1940-5bc3-11ee-9658-58a023cda0dc',664,'/var/.data/2023/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_eecd8fd5-572c-11ee-a378-58a023cda0dc/occlusion_eed0dd8b-572c-11ee-a378-58a023cda0dc/scan_cd138f1a-5bc2-11ee-9658-58a023cda0dc/9e5a1940-5bc3-11ee-9658-58a023cda0dc.zip','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_eecd8fd5-572c-11ee-a378-58a023cda0dc_SESS_eed0dd8b-572c-11ee-a378-58a023cda0dc_BOSC_cd138f1a-5bc2-11ee-9658-58a023cda0dc_MODEL','9e5a1940-5bc3-11ee-9658-58a023cda0dc.zip','9e5a1940-5bc3-11ee-9658-58a023cda0dc','{\"displayTitle\":\"Mandible 1.32.2.1.1\",\"modelMatrix\":\"0.522449,0.829084,-0.199167,0,-0.85267,0.507997,-0.122034,0,1.54057e-09,0.23358,0.972338,0,-29.0051,-15.3788,-14.9329,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-09-25 12:50:27.000','2023-09-25 17:39:47.404','2023-09-25 13:39:47.404'),('9e5a4f15-5bc3-11ee-9658-58a023cda0dc',664,'/var/.data/2023/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_eecd8fd5-572c-11ee-a378-58a023cda0dc/occlusion_eed0dd8b-572c-11ee-a378-58a023cda0dc/scan_cd138f1a-5bc2-11ee-9658-58a023cda0dc/9e5a4f15-5bc3-11ee-9658-58a023cda0dc.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_eecd8fd5-572c-11ee-a378-58a023cda0dc_SESS_eed0dd8b-572c-11ee-a378-58a023cda0dc_BOSC_cd138f1a-5bc2-11ee-9658-58a023cda0dc_SNAPS','9e5a4f15-5bc3-11ee-9658-58a023cda0dc.png','9e5a4f15-5bc3-11ee-9658-58a023cda0dc','{\"displayTitle\":\"Mandible 1.32.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-09-25 12:50:27.000','2023-09-25 17:39:47.419','2023-09-25 13:39:47.419'),('9e6ac4cc-cd14-4cd9-813c-a58767782690',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_a4752db3-12a3-432e-825c-694c37118d39/37_w2_o2_mordu_posterieur_droit_scan_file_3.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_RISC_a4752db3-12a3-432e-825c-694c37118d39_MODEL','37_w2_o2_mordu_posterieur_droit_scan_file_3.zip','2785f1a8-12cb-4579-bcdc-70a1c7c2ce88','{\"displayTitle\":\"Posterior right bite 1.37.2.2.1\",\"modelMatrix\":\"0.986233,0.00219236,0.166027,0,0.00135225,0.996697,0.084701,0,-0.16626,-0.0830626,0.982482,0,-3.37698,1.50781,-20.9805,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',3,'SYNCED',0,NULL,'2022-11-09 16:16:06.000','2024-10-31 14:02:35.910','2024-10-31 10:02:35.910'),('9e6e9cb1-fa39-11ed-8f6c-58a023cda0dc',664,'/var/.data/2023/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc/occlusion_cf61271a-fa37-11ed-8f6c-58a023cda0dc/scan_0a8db60a-fa38-11ed-8f6c-58a023cda0dc/9e6e9cb1-fa39-11ed-8f6c-58a023cda0dc.zip','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc_SESS_cf61271a-fa37-11ed-8f6c-58a023cda0dc_TOSC_0a8db60a-fa38-11ed-8f6c-58a023cda0dc_MODEL','9e6e9cb1-fa39-11ed-8f6c-58a023cda0dc.zip','479d4813-fa39-11ed-8f6c-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.29.6.1.1\",\"modelMatrix\":\"0.0417759,0.939638,-0.33961,0,-0.999127,0.0392885,-0.0141999,0,-5.29535e-10,0.339907,0.940459,0,20.3588,-26.7464,-13.12,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2023-05-24 09:48:14.000','2024-10-31 14:02:36.321','2024-10-31 10:02:36.321'),('9e6eac90-fa39-11ed-8f6c-58a023cda0dc',664,'/var/.data/2023/664/dfe1127e-d366-48f3-8672-183d37f8181f/session_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc/occlusion_cf61271a-fa37-11ed-8f6c-58a023cda0dc/scan_0a8db60a-fa38-11ed-8f6c-58a023cda0dc/9e6eac90-fa39-11ed-8f6c-58a023cda0dc.png','PATIENT_dfe1127e-d366-48f3-8672-183d37f8181f_ACT_cf5ebf08-fa37-11ed-8f6c-58a023cda0dc_SESS_cf61271a-fa37-11ed-8f6c-58a023cda0dc_TOSC_0a8db60a-fa38-11ed-8f6c-58a023cda0dc_SNAPS','9e6eac90-fa39-11ed-8f6c-58a023cda0dc.png','479d57d2-fa39-11ed-8f6c-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.29.6.1.1 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-05-24 09:48:15.000','2024-10-31 14:02:36.331','2024-10-31 10:02:36.331'),('9ea10de3-7b53-4d02-b15e-bca6ff87a015',664,'/var/.data/2022/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_a72c11a4-05dc-4421-b252-fbfcecd2559e/occlusion_bf823edb-92ee-4ee9-acd3-507d49bad781/scan_088e0b86-45b9-4da8-a5e2-291e2939c699/14_w1_o1_maxillaire_screenshot_9ea10de3-7b53-4d02-b15e-bca6ff87a015_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_a72c11a4-05dc-4421-b252-fbfcecd2559e_SESS_bf823edb-92ee-4ee9-acd3-507d49bad781_TOSC_088e0b86-45b9-4da8-a5e2-291e2939c699_SCREENS','14_w1_o1_maxillaire_screenshot_9ea10de3-7b53-4d02-b15e-bca6ff87a015_0.png','9ea10de3-7b53-4d02-b15e-bca6ff87a015','{\"displayTitle\":\"Screenshot 1.14.1.1.1 Maxilla 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxilla 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:02:27.000','2024-10-31 14:02:32.686','2024-10-31 10:02:32.686'),('9ee19de6-bb46-4887-a757-0060adbe2d61',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/computedocclusion_54918a1f-bcc4-48fe-8e2c-4c14434e1683/24_w1_o1_mandibule_occlusion_occ_file_0.ply','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_OCC_54918a1f-bcc4-48fe-8e2c-4c14434e1683_BOPLY','24_w1_o1_mandibule_occlusion_occ_file_0.ply','9ee19de6-bb46-4887-a757-0060adbe2d61','{\"displayTitle\":\"Occlusion Mandible 1.24.1.1.1\",\"modelMatrix\":\"0.709605,0.694519,-0.118762,0,-0.704599,0.699453,-0.119605,0,7.60211e-10,0.168552,0.985693,0,-24.6846,-1.63389,-21.046,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Occlusion Mandible 1.24.1.1.1\",\"occlusionMatrix\":\"0.509458,0.857801,-0.0681108,0,-0.857457,0.499406,-0.124008,0,-0.0723587,0.121579,0.989945,0,-23.6953,-5.57806,-17.1545,1\"}','PLY',0,'SYNCED',0,NULL,'2021-09-13 21:31:31.000','2024-10-31 14:02:38.483','2024-10-31 10:02:38.483'),('9f1de81e-3ef2-49aa-8c29-97260ce2b9d4',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_4b1e4a8e-c35a-4205-bb29-2132e2649b4a/27_w1_o1_maxillaire_screenshot_9f1de81e-3ef2-49aa-8c29-97260ce2b9d4_0.png','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_TOSC_4b1e4a8e-c35a-4205-bb29-2132e2649b4a_SCREENS','27_w1_o1_maxillaire_screenshot_9f1de81e-3ef2-49aa-8c29-97260ce2b9d4_0.png','9f1de81e-3ef2-49aa-8c29-97260ce2b9d4','{\"displayTitle\":\"Screenshot 1.27.1.1.4 Maxilla 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxilla 1\"}','PNG',0,'SYNCED',0,NULL,'2021-10-05 03:11:34.000','2024-10-31 14:02:28.524','2024-10-31 10:02:28.524'),('9f39de7e-1b6c-4b52-9fe3-5dac8b5e6bd6',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_d3696b3d-0728-4822-b89d-631e2ab774a4/occlusion_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6/scan_ec2d4010-6686-4b96-af72-0ece2b145c0d/14_w2_o1_maxillaire_snapshot_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_d3696b3d-0728-4822-b89d-631e2ab774a4_SESS_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6_TOSC_ec2d4010-6686-4b96-af72-0ece2b145c0d_SNAPS','14_w2_o1_maxillaire_snapshot_0.png','9f39de7e-1b6c-4b52-9fe3-5dac8b5e6bd6','{\"displayTitle\":\"Maxilla 1.14.2.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-11-30 02:14:43.000','2024-10-31 14:02:32.580','2024-10-31 10:02:32.580'),('9fa26aa6-6c36-11ee-bc7f-58a023cda0dc',664,'/var/.data/2023/664/bbc77872-6c30-11ee-bc7f-58a023cda0dc/session_0a963705-6c31-11ee-bc7f-58a023cda0dc/occlusion_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc/scan_608d8495-6c36-11ee-bc7f-58a023cda0dc/9fa26aa6-6c36-11ee-bc7f-58a023cda0dc.zip','PATIENT_bbc77872-6c30-11ee-bc7f-58a023cda0dc_ACT_0a963705-6c31-11ee-bc7f-58a023cda0dc_SESS_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc_LESC_608d8495-6c36-11ee-bc7f-58a023cda0dc_MODEL','9fa26aa6-6c36-11ee-bc7f-58a023cda0dc.zip','9fa26aa6-6c36-11ee-bc7f-58a023cda0dc','{\"displayTitle\":\"Left bite 1.53.1.1.1\",\"modelMatrix\":\"-0.791745,0.0265309,0.607778,0,0.0417739,-0.99077,0.119664,0,0.60974,0.134395,0.785049,0,7.06233,-4.55202,-30.495,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-10-16 13:05:22.000','2023-10-16 17:12:49.361','2023-10-16 13:12:49.361'),('9fa279c1-6c36-11ee-bc7f-58a023cda0dc',664,'/var/.data/2023/664/bbc77872-6c30-11ee-bc7f-58a023cda0dc/session_0a963705-6c31-11ee-bc7f-58a023cda0dc/occlusion_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc/scan_608d8495-6c36-11ee-bc7f-58a023cda0dc/9fa279c1-6c36-11ee-bc7f-58a023cda0dc.png','PATIENT_bbc77872-6c30-11ee-bc7f-58a023cda0dc_ACT_0a963705-6c31-11ee-bc7f-58a023cda0dc_SESS_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc_LESC_608d8495-6c36-11ee-bc7f-58a023cda0dc_SNAPS','9fa279c1-6c36-11ee-bc7f-58a023cda0dc.png','9fa279c1-6c36-11ee-bc7f-58a023cda0dc','{\"displayTitle\":\"Left bite 1.53.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-10-16 13:05:22.000','2023-10-16 17:12:49.377','2023-10-16 13:12:49.377'),('9fb4ae97-7342-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/46c4cd1e-7338-11ee-b011-58a023cda0dc/session_ecbd4537-7341-11ee-b011-58a023cda0dc/occlusion_ecbe814b-7341-11ee-b011-58a023cda0dc/scan_59402aaf-7342-11ee-b011-58a023cda0dc/9fb4ae97-7342-11ee-b011-58a023cda0dc.zip','PATIENT_46c4cd1e-7338-11ee-b011-58a023cda0dc_ACT_ecbd4537-7341-11ee-b011-58a023cda0dc_SESS_ecbe814b-7341-11ee-b011-58a023cda0dc_BOSC_59402aaf-7342-11ee-b011-58a023cda0dc_MODEL','9fb4ae97-7342-11ee-b011-58a023cda0dc.zip','930bda4e-7342-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Mandible 1.54.1.1.1\",\"modelMatrix\":\"0.222778,0.897321,-0.381032,0,-0.974869,0.205057,-0.087074,0,7.79179e-09,0.390855,0.920452,0,-14.8978,-15.6229,-15.8926,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2023-10-25 10:27:27.951','2023-10-25 15:27:29.905','2023-10-25 11:27:41.391'),('9fb66d32-9465-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/9fb66d32-9465-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_MODEL','9fb66d32-9465-11ee-8fd8-58a023cda0dc.zip','87a0d07a-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1\",\"modelMatrix\":\"0.843881,0.502692,-0.187524,0,-0.53653,0.790659,-0.294947,0,3.33011e-09,0.349512,0.936932,0,-21.678,-3.20968,-22.8257,1\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2023-12-06 13:31:08.720','2023-12-06 19:12:08.101','2023-12-11 10:11:57.144'),('a0431f00-fbfc-473e-b777-378011e30bbd',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_bfe6249f-88b3-4a27-8f4c-5494e863352f/order_c155f94e-e0aa-488a-af25-8ada7a6a5b8a/10_w2_couronne_prost_file_0.png','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_bfe6249f-88b3-4a27-8f4c-5494e863352f_SESS_fcabdff7-f4aa-41a0-8d3a-67e664f1d43e_RISC_11607af9-1606-48a7-8ad1-cabbd6bc16b5_SNAPS','10_w2_couronne_prost_file_0.png','a0431f00-fbfc-473e-b777-378011e30bbd','{\"displayTitle\":\"Posterior right bite 1.10.2.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-11-30 02:22:13.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.783'),('a047d137-c079-471d-9883-363f45da4686',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_ec92e295-bf7c-4746-b7d5-8b1307a8e6ac/21_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_RISC_ec92e295-bf7c-4746-b7d5-8b1307a8e6ac_SNAPS','21_w1_o1_mordu_posterieur_droit_snapshot_0.png','a047d137-c079-471d-9883-363f45da4686','{\"displayTitle\":\"Posterior right bite SNAPSHOT\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-28 18:55:01.000','2024-10-31 14:02:26.061','2024-10-31 10:02:26.061'),('a0dfdb3c-ddc2-421a-989f-e27c4e0c1866',664,'/var/.data/2022/664/7eac18e5-5ed2-4ed9-8b3e-eba1c562d708/session_c49716f1-987e-4111-9ab9-4541a0378bb7/occlusion_9a395a3e-4872-409e-922b-4bb58053d8a5/scan_b6b465bc-cccb-49a9-ba82-6a6e82cd4324/30_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_LESC_b6b465bc-cccb-49a9-ba82-6a6e82cd4324_SNAPS','30_w1_o1_mordu_posterieur_gauche_snapshot_0.png','a0dfdb3c-ddc2-421a-989f-e27c4e0c1866','{\"displayTitle\":\"Posterior left bite 1.30.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-21 15:39:30.000','2024-10-31 14:02:33.088','2024-10-31 10:02:33.088'),('a116495f-1bcf-4022-af0c-f807a25b1c9c',664,'/var/.data/2022/664/36e86f3f-4468-4cf2-9505-462288cae8b1/session_cc413c24-b371-4a75-9cfe-451a8d54e32e/order_68450b97-4193-42f4-a818-4bca3fb50cca/36_w1_gouttiere_prost_file_a116495f-1bcf-4022-af0c-f807a25b1c9c_0.pdf','PATIENT_36e86f3f-4468-4cf2-9505-462288cae8b1_ACT_cc413c24-b371-4a75-9cfe-451a8d54e32e_PROST_68450b97-4193-42f4-a818-4bca3fb50cca_FORM','36_w1_gouttiere_prost_file_a116495f-1bcf-4022-af0c-f807a25b1c9c_0.pdf','a116495f-1bcf-4022-af0c-f807a25b1c9c','{\"displayTitle\":\"ORDER 1.36.1.1 TRAY\",\"title\":\"Gouttiere PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-06-20 19:39:28.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.795'),('a1374e2d-ea55-4998-bb8b-c8ada23cd291',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_79842b46-a1df-43a9-812e-4322f1c79203/21_w1_o1_mordu_anterieur_scan_file_1.ply','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_FRSC_79842b46-a1df-43a9-812e-4322f1c79203_MODEL','21_w1_o1_mordu_anterieur_scan_file_1.ply','2fc8e7d5-c298-4652-9fba-2ae22795cca4','{\"displayTitle\":\"Anterior bite 1.21.1.1.1\",\"modelMatrix\":\"0.740263,0.0940548,0.666359,0,0.0138145,0.98712,-0.132848,0,-0.672205,0.132755,0.734277,0,5.18183,-8.21963,-28.5193,1\",\"title\":\"Anterior bite PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-04-28 19:02:47.000','2024-10-31 14:02:26.032','2024-10-31 10:02:26.032'),('a1591c1d-cdd9-4272-8ead-fd819fb859d2',664,'/var/.data/2022/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_d3696b3d-0728-4822-b89d-631e2ab774a4/occlusion_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6/scan_1fad60ca-f3ea-48a3-b845-fcd52ee435b5/14_w2_o1_mandibule_screenshot_a1591c1d-cdd9-4272-8ead-fd819fb859d2_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_d3696b3d-0728-4822-b89d-631e2ab774a4_SESS_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6_BOSC_1fad60ca-f3ea-48a3-b845-fcd52ee435b5_SCREENS','14_w2_o1_mandibule_screenshot_a1591c1d-cdd9-4272-8ead-fd819fb859d2_0.png','a1591c1d-cdd9-4272-8ead-fd819fb859d2','{\"displayTitle\":\"Screenshot 1.14.2.1.1 Mandible 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Mandible 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 14:57:58.000','2024-10-31 14:02:32.752','2024-10-31 10:02:32.752'),('a2099383-c46f-4a74-835e-82ef97668988',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/occlusion_d7b86e87-0261-4bc1-8529-76e0bdd29195/scan_09b06474-154e-4302-9e89-9d9e6fcb8cfa/18_w4_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_RISC_09b06474-154e-4302-9e89-9d9e6fcb8cfa_SNAPS','18_w4_o1_mordu_posterieur_droit_snapshot_0.png','a2099383-c46f-4a74-835e-82ef97668988','{\"displayTitle\":\"Posterior right bite 1.18.4.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-24 16:33:57.000','2024-10-31 14:02:33.114','2024-10-31 10:02:33.114'),('a2779544-f7de-49f8-8de9-40d9bb4b9a53',664,'/var/.data/2022/664/cede029c-15bc-44c2-9c9c-fac7f8983524/session_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29/order_0226bc43-b62b-4f3e-8246-e4fb73ae4a28/46_w1_couronne_prost_file_a2779544-f7de-49f8-8de9-40d9bb4b9a53_0.pdf','PATIENT_cede029c-15bc-44c2-9c9c-fac7f8983524_ACT_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29_PROST_0226bc43-b62b-4f3e-8246-e4fb73ae4a28_FORM','46_w1_couronne_prost_file_a2779544-f7de-49f8-8de9-40d9bb4b9a53_0.pdf','a2779544-f7de-49f8-8de9-40d9bb4b9a53','{\"displayTitle\":\"ORDER 1.46.1.1 CROWNS CARROLL GIBBS\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-09-12 20:46:06.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.783'),('a28b2972-9b02-456d-9a8f-2bc4ce7c5568',664,'/var/.data/2022/664/d971e033-4a5c-4bd9-aab3-6238778f9eee/session_6fc7c9c9-3191-4169-b15f-edf43fc51336/occlusion_18d990cb-0161-4a7a-b1ce-1c139a73a700/scan_5ffd123b-12b9-4fc7-9b8a-16b74a28e7b2/47_w1_o1_maxillaire_snapshot_0.png','PATIENT_d971e033-4a5c-4bd9-aab3-6238778f9eee_ACT_6fc7c9c9-3191-4169-b15f-edf43fc51336_SESS_18d990cb-0161-4a7a-b1ce-1c139a73a700_TOSC_5ffd123b-12b9-4fc7-9b8a-16b74a28e7b2_SNAPS','47_w1_o1_maxillaire_snapshot_0.png','a28b2972-9b02-456d-9a8f-2bc4ce7c5568','{\"displayTitle\":\"Maxilla 1.47.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-14 17:55:29.000','2024-10-31 14:02:35.189','2024-10-31 10:02:35.189'),('a2a9d676-d8c3-48c5-856c-6aa836b962fa',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_4b1e4a8e-c35a-4205-bb29-2132e2649b4a/27_w1_o1_maxillaire_snapshot_0.png','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_TOSC_4b1e4a8e-c35a-4205-bb29-2132e2649b4a_SNAPS','27_w1_o1_maxillaire_snapshot_0.png','a2a9d676-d8c3-48c5-856c-6aa836b962fa','{\"displayTitle\":\"Maxilla 1.27.1.1.4\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-04 18:48:15.000','2024-10-31 14:02:28.532','2024-10-31 10:02:28.532'),('a37bae2b-66fb-49c6-8ba9-6a1388881e81',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_93be3b1e-bcd5-443a-a7e3-4f5452c470a6/24_w1_o1_mandibule_scan_file_0.ply','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_BOSC_93be3b1e-bcd5-443a-a7e3-4f5452c470a6_MODEL','24_w1_o1_mandibule_scan_file_0.ply','a37bae2b-66fb-49c6-8ba9-6a1388881e81','{\"displayTitle\":\"Mandible 1.24.1.1.1\",\"modelMatrix\":\"0.709605,0.694519,-0.118762,0,-0.704599,0.699453,-0.119605,0,7.60211e-10,0.168552,0.985693,0,-24.6846,-1.63389,-21.046,1\",\"title\":\"Mandible PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-13 21:24:07.000','2024-10-31 14:02:28.707','2024-10-31 10:02:28.707'),('a3e7e135-bb5d-480a-ad23-66fef52084cd',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20/37_w2_o1_mandibule_snapshot_0.png','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_BOSC_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20_SNAPS','37_w2_o1_mandibule_snapshot_0.png','a3e7e135-bb5d-480a-ad23-66fef52084cd','{\"displayTitle\":\"Mandible 1.37.2.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-10-19 19:30:04.000','2024-10-31 14:02:35.766','2024-10-31 10:02:35.766'),('a4dcb2d6-d779-443d-9e2d-0845bb353b4e',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_bfe6249f-88b3-4a27-8f4c-5494e863352f/order_c155f94e-e0aa-488a-af25-8ada7a6a5b8a/10_w2_couronne_prost_file_0.pdf','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_bfe6249f-88b3-4a27-8f4c-5494e863352f_PROST_c155f94e-e0aa-488a-af25-8ada7a6a5b8a_FORM','10_w2_couronne_prost_file_0.pdf','a4dcb2d6-d779-443d-9e2d-0845bb353b4e','{\"displayTitle\":\"CROWN 1.10.2.1 CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-11-30 21:21:06.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.784'),('a4fd2b33-3d5e-4e47-96d4-f1c6e8db2f68',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_6630e34a-9b19-4727-9ef0-e1c95c341549/scan_428484bf-df10-43b1-a7ed-6f2f0ac47336/44_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_6630e34a-9b19-4727-9ef0-e1c95c341549_LESC_428484bf-df10-43b1-a7ed-6f2f0ac47336_SNAPS','44_w1_o1_mordu_posterieur_gauche_snapshot_0.png','a4fd2b33-3d5e-4e47-96d4-f1c6e8db2f68','{\"displayTitle\":\"Posterior left bite 1.44.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-07 15:16:13.000','2024-10-31 14:02:33.280','2024-10-31 10:02:33.280'),('a540af64-2782-40e1-98e6-71a1da04b4e8',664,'/var/.data/2022/664/635617fc-289b-470c-a4d4-678d7b5f275a/session_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6/occlusion_94dc9a16-b72c-4f6a-a520-ba83c28954c3/scan_0760cff5-4209-42a6-8b7f-d0a749485c14/45_w1_o1_maxillaire_scan_file_1.zip','PATIENT_635617fc-289b-470c-a4d4-678d7b5f275a_ACT_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6_SESS_94dc9a16-b72c-4f6a-a520-ba83c28954c3_TOSC_0760cff5-4209-42a6-8b7f-d0a749485c14_MODEL','45_w1_o1_maxillaire_scan_file_1.zip','5e5384eb-0822-41cf-9105-f8761f20244b','{\"displayTitle\":\"Maxilla 1.45.1.1.1\",\"modelMatrix\":\"-0.483384,0.659823,-0.575302,0,-0.875408,-0.364342,0.317671,0,-1.42192e-08,0.657182,0.753732,0,15.4669,-19.2569,-15.9154,1\",\"title\":\"Maxilla ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-09-07 16:30:14.000','2024-10-31 14:02:33.300','2024-10-31 10:02:33.300'),('a596e547-dd1e-4bf9-9e36-fa59cfb5a615',664,'','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_TOSC_ded778b4-0eef-4984-8f57-77502f727676_MODEL','41_w1_o3_maxillaire_scan_file_3.zip','ad632823-c0d2-40d5-86fc-095a10d5a99c','{\"displayTitle\":\"Maxilla 1.41.1.3.2\",\"modelMatrix\":\"-0.887641,-0.457437,0.0533369,0,0.460536,-0.881668,0.102802,0,3.28529e-09,0.115815,0.993271,0,8.96511,1.37654,-22.8526,1\",\"title\":\"Maxilla ZIP\"}','ZIP',3,'SYNCED',0,'2023-05-22 09:08:14.000','2022-08-03 10:05:45.000','2024-10-31 14:02:31.984','2024-10-31 10:02:31.984'),('a5d050d7-c6c8-47b6-a5c2-168e8fdbf905',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_21bbefd5-8dc0-4e41-91d8-718463ad469c/scan_316dc371-d779-45ec-913c-3647da5917c2/41_w1_o3_mordu_anterieur_snapshot_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_FRSC_316dc371-d779-45ec-913c-3647da5917c2_SNAPS','41_w1_o3_mordu_anterieur_snapshot_0.png','a5d050d7-c6c8-47b6-a5c2-168e8fdbf905','{\"displayTitle\":\"Anterior bite 1.41.1.3.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-03 16:17:26.000','2024-10-31 14:02:32.034','2024-10-31 10:02:32.034'),('a641686c-5e48-4a10-8fc1-f41b2aff94bf',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_a4752db3-12a3-432e-825c-694c37118d39/37_w2_o2_mordu_posterieur_droit_scan_file_1.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_RISC_a4752db3-12a3-432e-825c-694c37118d39_MODEL','37_w2_o2_mordu_posterieur_droit_scan_file_1.zip','2785f1a8-12cb-4579-bcdc-70a1c7c2ce88','{\"displayTitle\":\"Posterior right bite 1.37.2.2.1\",\"modelMatrix\":\"0.977639,-0.0235285,0.206884,0,0.0114101,0.995375,0.104086,0,-0.210136,-0.0937862,0.972843,0,-3.58507,1.36932,-21.7424,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-11-09 16:12:21.000','2024-10-31 14:02:35.921','2024-10-31 10:02:35.921'),('a685a8d2-db8d-41c7-9651-468bdf6230ed',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/occlusion_e930782a-e2db-43e8-9ff1-9feb64e20e4e/scan_3b924f2a-18f4-4ed4-8e4e-efb6a1b36439/35_w1_o1_mordu_anterieur_scan_file_1.zip','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_FRSC_3b924f2a-18f4-4ed4-8e4e-efb6a1b36439_MODEL','35_w1_o1_mordu_anterieur_scan_file_1.zip','52059c48-e3a3-4bd6-8fcc-9746f5a7da5b','{\"displayTitle\":\"Anterior bite 1.35.1.1.1\",\"modelMatrix\":\"0.925443,3.73816e-05,0.386362,0,-0.031371,0.983381,0.140685,0,-0.379894,-0.189332,0.912235,0,-4.35126,4.74953,-23.7796,1\",\"title\":\"Anterior bite ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-06-06 20:43:59.000','2024-10-31 14:02:29.657','2024-10-31 10:02:29.657'),('a6baa130-835b-4cb1-a503-815388979d65',664,'','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_LESC_e64276ae-1a8c-45bd-adaa-f04086ada9e7_SNAPS','33_w2_o1_mordu_posterieur_gauche_snapshot_0.png','a6baa130-835b-4cb1-a503-815388979d65','{\"displayTitle\":\"Posterior left bite 1.33.2.1.2\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:08:15.000','2022-08-01 09:27:12.000','2024-10-31 14:02:31.824','2024-10-31 10:02:31.824'),('a6bd9cda-9465-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/a6bd9cda-9465-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_MODEL','a6bd9cda-9465-11ee-8fd8-58a023cda0dc.zip','87a0d07a-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1\",\"modelMatrix\":\"0.843881,0.502692,-0.187524,0,-0.53653,0.790659,-0.294947,0,3.33011e-09,0.349512,0.936932,0,-21.678,-3.20968,-22.8257,1\",\"scanBodies\":[]}','ZIP',3,'SYNCED',0,NULL,'2023-12-06 13:31:20.511','2023-12-06 19:12:08.101','2023-12-11 10:11:59.377'),('a702f29e-9295-44bb-9e5b-6a0182ffe02e',664,'/var/.data/2022/664/e33159c9-a713-4a37-ba98-9ec2e2e213e7/session_b63ca765-4d68-4cf4-9707-4ad3a19f3236/occlusion_ae7f89c9-26ec-4cee-b377-d5145e6c6aae/scan_ad99e632-5042-4e93-87eb-5f1d24eaf0df/50_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_e33159c9-a713-4a37-ba98-9ec2e2e213e7_ACT_b63ca765-4d68-4cf4-9707-4ad3a19f3236_SESS_ae7f89c9-26ec-4cee-b377-d5145e6c6aae_LESC_ad99e632-5042-4e93-87eb-5f1d24eaf0df_SNAPS','50_w1_o1_mordu_posterieur_gauche_snapshot_0.png','a702f29e-9295-44bb-9e5b-6a0182ffe02e','{\"displayTitle\":\"Posterior left bite 1.50.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-14 18:22:52.000','2024-10-31 14:02:36.218','2024-10-31 10:02:36.218'),('a73b3e6e-5016-4490-af65-3401d7f328c4',664,'','PATIENT_cede029c-15bc-44c2-9c9c-fac7f8983524_ACT_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29_SESS_4d46a627-5949-4b2a-b4d6-c391f159485b_RISC_c56436ec-184d-44cc-9d63-5d6b28b7aebe_MODEL','46_w1_o1_mordu_posterieur_droit_scan_file_0.zip','a73b3e6e-5016-4490-af65-3401d7f328c4','{\"displayTitle\":\"Posterior right bite 1.46.1.1.1\",\"modelMatrix\":\"0.923422,0.0620044,0.379157,0,-0.061069,0.997515,0.00918602,0,-0.379017,-0.0347949,0.925287,0,-8.59038,-4.92551,-27.8418,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:08:16.000','2022-09-12 14:35:16.000','2024-10-31 14:02:35.149','2024-10-31 10:02:35.149'),('a767ce19-6c12-462f-a9b9-da173ef005af',664,'','PATIENT_48a38618-e853-4bf0-aa6b-4c83fb8b6f13_ACT_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d_SESS_540d878b-7415-4498-8c6c-01875eec35f8_BOSC_d8bbea0f-8405-4d13-8995-46a51be77eb1_MODEL','38_w1_o1_mandibule_scan_file_0.zip','a767ce19-6c12-462f-a9b9-da173ef005af','{\"displayTitle\":\"Mandible 1.38.1.1.1\",\"modelMatrix\":\"0.846299,0.518429,-0.122515,0,-0.532709,0.823613,-0.194636,0,9.71947e-09,0.229985,0.973194,0,-18.4781,-18.9499,-18.8994,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:08:16.000','2022-06-22 10:43:53.000','2024-10-31 14:02:29.860','2024-10-31 10:02:29.860'),('a77a332b-8797-48b4-bfe8-83dea8c5628b',664,'','PATIENT_685697a1-0d50-4a06-8b3e-729cf9750f38_ACT_e1d214d2-2b62-484c-8ede-86b3f84573d3_SESS_8cd0c724-d3d0-4821-a88b-42b03ae4eb07_RISC_18f2b293-9073-44fe-91a3-d166f9249cbc_SNAPS','48_w1_o1_mordu_posterieur_droit_snapshot_0.png','a77a332b-8797-48b4-bfe8-83dea8c5628b','{\"displayTitle\":\"Posterior right bite 1.48.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:08:16.000','2022-10-17 11:04:18.000','2024-10-31 14:02:35.333','2024-10-31 10:02:35.333'),('a7a3c050-c3db-4379-bc91-d2bd0affd589',664,'/var/.data/2021/664/e4dda259-b05b-4f33-92ac-ee4067d7dfa2/session_610634a3-6f25-4ce3-9363-ad383ec68df4/occlusion_ea664326-1e10-4280-80b6-f3d23573a862/scan_9ec52cac-03f7-4247-88fd-59b11e688f36/4_w2_o2_maxillaire_scan_file_0.ply','PATIENT_e4dda259-b05b-4f33-92ac-ee4067d7dfa2_ACT_610634a3-6f25-4ce3-9363-ad383ec68df4_SESS_ea664326-1e10-4280-80b6-f3d23573a862_TOSC_9ec52cac-03f7-4247-88fd-59b11e688f36_MODEL','4_w2_o2_maxillaire_scan_file_0.ply','a7a3c050-c3db-4379-bc91-d2bd0affd589','{\"displayTitle\":\"Maxilla 1.4.2.2.1\",\"modelMatrix\":\"-0.652006,0.717238,-0.24588,0,-0.758214,-0.616771,0.211438,0,1.94941e-8,0.324289,0.945958,0,3.32172,-39.5746,-15.1889,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-18 18:55:27.000','2024-10-31 14:02:25.621','2024-10-31 10:02:25.621'),('a7c09592-0cd2-4e6d-bd98-0f39f03ab349',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_c90ddf83-1e94-4d7c-a61f-3f7bed3aad41/occlusion_5dac735e-358c-49a1-aa52-0180d8d8ff7e/scan_7ce9b1b8-7c7b-4655-bd0d-90f37ced345e/27_w2_o1_maxillaire_snapshot_1.png','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_c90ddf83-1e94-4d7c-a61f-3f7bed3aad41_SESS_5dac735e-358c-49a1-aa52-0180d8d8ff7e_TOSC_7ce9b1b8-7c7b-4655-bd0d-90f37ced345e_SNAPS','27_w2_o1_maxillaire_snapshot_1.png','92a8aaff-0105-4be1-8e93-7c174c4ed35f','{\"displayTitle\":\"Maxilla 1.27.2.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-10-20 18:22:55.000','2024-10-31 14:02:26.795','2024-10-31 10:02:26.795'),('a85cc64a-e5ae-46bc-a689-1e1c3eedfa28',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/occlusion_d7b86e87-0261-4bc1-8529-76e0bdd29195/scan_d43bd9e0-44ee-49ed-aa89-8bcd9837b34a/18_w4_o1_mordu_anterieur_snapshot_1.png','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_FRSC_d43bd9e0-44ee-49ed-aa89-8bcd9837b34a_SNAPS','18_w4_o1_mordu_anterieur_snapshot_1.png','0b8f8838-0705-45dd-9f7f-647814f9be33','{\"displayTitle\":\"Anterior bite 1.18.4.1.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-08-24 16:45:00.000','2024-10-31 14:02:33.147','2024-10-31 10:02:33.147'),('a86cf3f5-c1d7-45f7-998a-3a630b114693',664,'','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_PROST_e5931e17-9060-4f04-9eac-a9ebae07c42d_FORM','','a86cf3f5-c1d7-45f7-998a-3a630b114693','{\"displayTitle\":\"ORDER 1.34.1.1 GUIDE\",\"title\":\"Guide PDF\"}','PDF',0,'SYNCED',0,'2022-05-26 22:11:06.000','2022-05-25 19:48:21.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.787'),('a894dedf-edb8-479e-a4e0-38594ffe81f2',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_bfe6249f-88b3-4a27-8f4c-5494e863352f/occlusion_fcabdff7-f4aa-41a0-8d3a-67e664f1d43e/scan_88f800e1-3e01-4d9c-984c-9f939ebee222/10_w2_o1_maxillaire_snapshot_0.png','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_bfe6249f-88b3-4a27-8f4c-5494e863352f_SESS_fcabdff7-f4aa-41a0-8d3a-67e664f1d43e_TOSC_88f800e1-3e01-4d9c-984c-9f939ebee222_SNAPS','10_w2_o1_maxillaire_snapshot_0.png','a894dedf-edb8-479e-a4e0-38594ffe81f2','{\"displayTitle\":\"Maxilla 1.10.2.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-11-30 02:22:13.000','2024-10-31 14:02:25.650','2024-10-31 10:02:25.650'),('a8a6a645-3d3c-4deb-985b-aa5de9ebf41a',664,'/var/.data/2021/664/366ffa87-059a-436a-9125-8827b3a2da1a/session_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9/occlusion_a59f40f9-2208-4d6a-b286-f64533d92e3c/scan_056c711b-f9d5-4a04-93e2-9015a27c4b1b/15_w1_o1_maxillaire_scan_file_0.ply','PATIENT_366ffa87-059a-436a-9125-8827b3a2da1a_ACT_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9_SESS_a59f40f9-2208-4d6a-b286-f64533d92e3c_TOSC_056c711b-f9d5-4a04-93e2-9015a27c4b1b_MODEL','15_w1_o1_maxillaire_scan_file_0.ply','a8a6a645-3d3c-4deb-985b-aa5de9ebf41a','{\"displayTitle\":\"Maxilla 1.15.1.1.1\",\"modelMatrix\":\"-0.810909,0.373673,-0.450328,0,-0.585173,-0.517821,0.624047,0,2.10308e-8,0.769565,0.638568,0,15.7201,0.723143,-17.6513,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-01-18 21:27:55.000','2024-10-31 14:02:25.800','2024-10-31 10:02:25.800'),('aa4e5c15-e939-46a6-a75e-c5b67cdbad7b',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_955946be-5764-4c34-9e84-61682f4fdf78/order_fafb038b-651a-4236-89fc-fe854cd20c83/33_w2_couronne_prost_file_aa4e5c15-e939-46a6-a75e-c5b67cdbad7b_0.pdf','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_PROST_fafb038b-651a-4236-89fc-fe854cd20c83_FORM','33_w2_couronne_prost_file_aa4e5c15-e939-46a6-a75e-c5b67cdbad7b_0.pdf','aa4e5c15-e939-46a6-a75e-c5b67cdbad7b','{\"displayTitle\":\"ORDER 1.33.2.1 CROWN Solange Montue\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-08-01 16:55:34.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.787'),('aa6f8d0d-76df-4627-adec-a79670c64f0a',664,'/var/.data/2022/664/7eac18e5-5ed2-4ed9-8b3e-eba1c562d708/session_c49716f1-987e-4111-9ab9-4541a0378bb7/occlusion_9a395a3e-4872-409e-922b-4bb58053d8a5/scan_d7e952db-9527-4a27-a3cb-76863aa4d0de/30_w1_o1_mandibule_scan_file_1.zip','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_BOSC_d7e952db-9527-4a27-a3cb-76863aa4d0de_MODEL','30_w1_o1_mandibule_scan_file_1.zip','2fdfa670-821a-41f5-b716-5a88cf4da71a','{\"displayTitle\":\"Mandible 1.30.1.1.3\",\"modelMatrix\":\"0.613505,0.786934,-0.0659286,0,-0.789691,0.611363,-0.0512194,0,-8.69124e-10,0.0834865,0.996509,0,-11.4623,-15.3451,-21.1959,1\",\"title\":\"Mandible ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-03-21 15:37:06.000','2024-10-31 14:02:33.031','2024-10-31 10:02:33.031'),('aa94138d-320f-44a7-9b36-953713b8552e',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_ede3aa5c-bbba-4cf2-8caa-b2d5f671b311/scan_b974cde0-1037-4254-9cd8-9fcd14968091/44_w1_o2_maxillaire_snapshot_0.png','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_ede3aa5c-bbba-4cf2-8caa-b2d5f671b311_TOSC_b974cde0-1037-4254-9cd8-9fcd14968091_SNAPS','44_w1_o2_maxillaire_snapshot_0.png','aa94138d-320f-44a7-9b36-953713b8552e','{\"displayTitle\":\"Maxilla 1.44.1.2.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-21 19:25:38.000','2024-10-31 14:02:35.240','2024-10-31 10:02:35.240'),('aab75805-6a59-439e-9a97-285b5e4be308',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_5500928e-446a-45d8-af99-faf7375b1d49/21_w1_o1_mandibule_scan_file_2.ply','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_BOSC_5500928e-446a-45d8-af99-faf7375b1d49_MODEL','21_w1_o1_mandibule_scan_file_2.ply','d9832be3-80d4-48f3-a493-2302821853bf','{\"displayTitle\":\"Mandible 1.21.1.1.1\",\"modelMatrix\":\"-0.608099,0.749276,-0.2623,0,-0.793862,-0.573946,0.200922,0,2.74099e-9,0.33041,0.943838,0,7.50226,-41.2613,-14.0276,1\",\"title\":\"Mandible PLY\"}','PLY',2,'SYNCED',0,NULL,'2021-04-28 18:21:59.000','2024-10-31 14:02:26.091','2024-10-31 10:02:26.091'),('aafe80ec-b241-47c3-98cb-9c43a7207ae2',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_21bbefd5-8dc0-4e41-91d8-718463ad469c/scan_bdc0c035-5e2c-49c1-9980-ecffc5862af4/41_w1_o3_maxillaire_scan_file_0.zip','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_TOSC_bdc0c035-5e2c-49c1-9980-ecffc5862af4_MODEL','41_w1_o3_maxillaire_scan_file_0.zip','aafe80ec-b241-47c3-98cb-9c43a7207ae2','{\"displayTitle\":\"Maxilla 1.41.1.3.4\",\"modelMatrix\":\"-0.453583,0.770745,-0.447453,0,-0.891214,-0.39227,0.227731,0,-1.9464e-09,0.502072,0.864826,0,13.3693,-18.541,-17.9899,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-03 16:11:16.000','2024-10-31 14:02:32.066','2024-10-31 10:02:32.066'),('ab3eb0ec-fe6a-446c-aeb2-a6ebd6c1e601',664,'/var/.data/2021/664/e648cc66-9340-456c-a379-50836d1b8a5b/session_f09c328f-1a8b-4f63-8998-2f9b57cd3c76/occlusion_2c19cd55-a36e-4dc7-8954-ea8a8eeacd16/scan_27ffc744-9a52-49aa-a247-2801d6cd8ff9/16_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_e648cc66-9340-456c-a379-50836d1b8a5b_ACT_f09c328f-1a8b-4f63-8998-2f9b57cd3c76_SESS_2c19cd55-a36e-4dc7-8954-ea8a8eeacd16_FRSC_27ffc744-9a52-49aa-a247-2801d6cd8ff9_SNAPS','16_w1_o1_mordu_anterieur_snapshot_0.png','ab3eb0ec-fe6a-446c-aeb2-a6ebd6c1e601','{\"displayTitle\":\"Anterior bite 1.16.1.1.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-01-18 18:00:57.000','2024-10-31 14:02:26.185','2024-10-31 10:02:26.185'),('aba5479c-35a0-4c7f-a0c1-dbde75e26606',664,'/var/.data/2021/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_5b122c87-c24b-4f13-9df8-3025089e3bc1/occlusion_aa05c648-fa52-43e7-ae5a-2d1a00059796/scan_d19c7af8-1f07-4857-86c3-e29963c1f9c9/18_w2_o1_maxillaire_scan_file_0.ply','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_5b122c87-c24b-4f13-9df8-3025089e3bc1_SESS_aa05c648-fa52-43e7-ae5a-2d1a00059796_TOSC_d19c7af8-1f07-4857-86c3-e29963c1f9c9_MODEL','18_w2_o1_maxillaire_scan_file_0.ply','aba5479c-35a0-4c7f-a0c1-dbde75e26606','{\"displayTitle\":\"Maxilla 1.18.2.1.1\",\"modelMatrix\":\"-0.639769,0.754668,-0.145503,0,-0.768567,-0.6282,0.121119,0,6.63851e-9,0.189317,0.981916,0,36.7471,-11.8294,-19.5573,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-03 18:05:40.000','2024-10-31 14:02:25.913','2024-10-31 10:02:25.913'),('abdd65b1-8e6c-4a9a-84db-e8a1b6437124',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_92704e83-dce3-4695-baad-1df750f09cd7/37_w2_o2_mandibule_scan_file_3.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_MODEL','37_w2_o2_mandibule_scan_file_3.zip','cb794354-96b6-463a-a735-215a2367d35f','{\"displayTitle\":\"Mandible 1.37.2.2.1\",\"modelMatrix\":\"0.368789,0.835264,-0.407835,0,-0.929513,0.331395,-0.161811,0,3.28489e-09,0.438762,0.898603,0,-8.38632,-17.7836,-17.5937,1\",\"title\":\"Mandible ZIP\"}','ZIP',3,'SYNCED',0,NULL,'2022-11-09 16:02:36.000','2024-10-31 14:02:36.107','2024-10-31 10:02:36.107'),('abe3d489-e27c-4ef9-bba3-b62ed55c8c9b',664,'/var/.data/2022/664/48a38618-e853-4bf0-aa6b-4c83fb8b6f13/session_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d/occlusion_540d878b-7415-4498-8c6c-01875eec35f8/scan_33332418-f712-49fd-833e-f2b6ad37b61e/38_w1_o1_maxillaire_snapshot_0.png','PATIENT_48a38618-e853-4bf0-aa6b-4c83fb8b6f13_ACT_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d_SESS_540d878b-7415-4498-8c6c-01875eec35f8_TOSC_33332418-f712-49fd-833e-f2b6ad37b61e_SNAPS','38_w1_o1_maxillaire_snapshot_0.png','abe3d489-e27c-4ef9-bba3-b62ed55c8c9b','{\"displayTitle\":\"Maxilla 1.38.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-22 16:39:39.000','2024-10-31 14:02:29.813','2024-10-31 10:02:29.813'),('abee95d7-6c35-11ee-bc7f-58a023cda0dc',664,'/var/.data/2023/664/bbc77872-6c30-11ee-bc7f-58a023cda0dc/session_0a963705-6c31-11ee-bc7f-58a023cda0dc/occlusion_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc/scan_041ad44a-6c35-11ee-bc7f-58a023cda0dc/abee95d7-6c35-11ee-bc7f-58a023cda0dc.zip','PATIENT_bbc77872-6c30-11ee-bc7f-58a023cda0dc_ACT_0a963705-6c31-11ee-bc7f-58a023cda0dc_SESS_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc_BOSC_041ad44a-6c35-11ee-bc7f-58a023cda0dc_MODEL','abee95d7-6c35-11ee-bc7f-58a023cda0dc.zip','9122eeb5-6c35-11ee-bc7f-58a023cda0dc','{\"displayTitle\":\"Mandible 1.53.1.1.2\",\"modelMatrix\":\"0.53002,0.749056,-0.397484,0,-0.847985,0.468186,-0.248441,0,1.42556e-08,0.468739,0.883337,0,-25.188,-21.2022,-16.5919,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2023-10-16 11:07:06.867','2023-10-16 17:05:08.828','2023-10-16 13:05:12.343'),('ac5024cd-d172-486c-95a3-221f86ab12eb',664,'','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_TOSC_6f9af98c-1ab4-4600-b23b-57aa4c4d1e85_MODEL','','ac5024cd-d172-486c-95a3-221f86ab12eb','{\"displayTitle\":\"Maxilla 1.21.1.1.2\",\"modelMatrix\":\"0.950182,0.270862,-0.15423,0,-0.311694,0.825708,-0.470162,0,-4.93753e-9,0.494813,0.869,0,-18.0487,-41.5855,-12.5365,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'CREATED',0,'2021-04-28 18:43:25.000','2021-04-28 18:39:18.000','2023-05-17 17:16:39.559',NULL),('ac8e82cb-46bf-4b75-8996-3ccefa879974',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_92704e83-dce3-4695-baad-1df750f09cd7/37_w2_o2_mandibule_snapshot_0.png','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_SNAPS','37_w2_o2_mandibule_snapshot_0.png','ac8e82cb-46bf-4b75-8996-3ccefa879974','{\"displayTitle\":\"Mandible 1.37.2.2.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-09 15:55:23.000','2024-10-31 14:02:35.993','2024-10-31 10:02:35.993'),('ac9ef930-04c7-4cfc-b9df-0b64725e1bed',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_7c9d6daa-c5b6-47ec-b65a-ee99948da8ea/27_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_FRSC_7c9d6daa-c5b6-47ec-b65a-ee99948da8ea_SNAPS','27_w1_o1_mordu_anterieur_snapshot_0.png','ac9ef930-04c7-4cfc-b9df-0b64725e1bed','{\"displayTitle\":\"Anterior bite 1.27.1.1.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-04 19:09:45.000','2024-10-31 14:02:28.543','2024-10-31 10:02:28.543'),('acb9bb4d-983c-11ee-86e7-58a023cda0dc',664,'/var/.data/2023/664/b4c6341b-9837-11ee-86e7-58a023cda0dc/session_bf1582a4-9837-11ee-86e7-58a023cda0dc/order_06d57180-983c-11ee-86e7-58a023cda0dc/acb9bb4d-983c-11ee-86e7-58a023cda0dc.pdf','PATIENT_b4c6341b-9837-11ee-86e7-58a023cda0dc_ACT_bf1582a4-9837-11ee-86e7-58a023cda0dc_PROST_06d57180-983c-11ee-86e7-58a023cda0dc_FORM','acb9bb4d-983c-11ee-86e7-58a023cda0dc.pdf','acb9bb4d-983c-11ee-86e7-58a023cda0dc','{\"displayTitle\":\"Order 1.56.1.1 Surgical Guide #7 and #8\",\"title\":\"Surgical Guide #7 and #8\"}','PDF',0,'CREATED',0,NULL,'2023-12-11 10:48:05.837','2023-12-11 15:48:06.172',NULL),('acdd2be8-41d4-4309-8d50-7389512f9d6d',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/occlusion_cacc103c-8b88-4be5-a787-b6b92341e9eb/scan_bb241051-9343-4a9a-9282-a960e0748f3e/34_w1_o1_maxillaire_snapshot_0.png','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_SESS_cacc103c-8b88-4be5-a787-b6b92341e9eb_TOSC_bb241051-9343-4a9a-9282-a960e0748f3e_SNAPS','34_w1_o1_maxillaire_snapshot_0.png','acdd2be8-41d4-4309-8d50-7389512f9d6d','{\"displayTitle\":\"Maxilla 1.34.1.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-05-25 18:24:14.000','2024-10-31 14:02:29.346','2024-10-31 10:02:29.346'),('ad556326-2de3-4a75-8afb-a05dac39719f',664,'','PATIENT_685697a1-0d50-4a06-8b3e-729cf9750f38_ACT_e1d214d2-2b62-484c-8ede-86b3f84573d3_SESS_8cd0c724-d3d0-4821-a88b-42b03ae4eb07_RISC_18f2b293-9073-44fe-91a3-d166f9249cbc_MODEL','48_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ad556326-2de3-4a75-8afb-a05dac39719f','{\"displayTitle\":\"Posterior right bite 1.48.1.1.1\",\"modelMatrix\":\"0.994838,-0.0853319,0.0566547,0,0.0902448,0.990968,-0.0967073,0,-0.0464294,0.103471,0.993703,0,1.67531,-2.37106,-19.8915,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:08:25.000','2022-10-17 11:04:18.000','2024-10-31 14:02:35.344','2024-10-31 10:02:35.344'),('ad632823-c0d2-40d5-86fc-095a10d5a99c',664,'','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_TOSC_ded778b4-0eef-4984-8f57-77502f727676_MODEL','41_w1_o3_maxillaire_scan_file_0.zip','ad632823-c0d2-40d5-86fc-095a10d5a99c','{\"displayTitle\":\"Maxilla 1.41.1.3.2\",\"modelMatrix\":\"-0.996769,0.080001,-0.00722893,0,-0.080327,-0.992724,0.0897029,0,2.83785e-10,0.0899937,0.995942,0,11.262,-7.0632,-21.8985,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:08:13.000','2022-08-03 09:53:25.000','2024-10-31 14:02:31.936','2024-10-31 10:02:31.936'),('ad7e808e-aadc-4d5b-b4af-172295eb3c6d',664,'/var/.data/2022/664/635617fc-289b-470c-a4d4-678d7b5f275a/session_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6/occlusion_94dc9a16-b72c-4f6a-a520-ba83c28954c3/scan_0760cff5-4209-42a6-8b7f-d0a749485c14/45_w1_o1_maxillaire_snapshot_0.png','PATIENT_635617fc-289b-470c-a4d4-678d7b5f275a_ACT_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6_SESS_94dc9a16-b72c-4f6a-a520-ba83c28954c3_TOSC_0760cff5-4209-42a6-8b7f-d0a749485c14_SNAPS','45_w1_o1_maxillaire_snapshot_0.png','ad7e808e-aadc-4d5b-b4af-172295eb3c6d','{\"displayTitle\":\"Maxilla 1.45.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-07 16:26:01.000','2024-10-31 14:02:33.309','2024-10-31 10:02:33.309'),('ad938206-5bc4-11ee-9658-58a023cda0dc',664,'/var/.data/2023/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_eecd8fd5-572c-11ee-a378-58a023cda0dc/occlusion_eed0dd8b-572c-11ee-a378-58a023cda0dc/scan_ab0cf7a4-5bc3-11ee-9658-58a023cda0dc/ad938206-5bc4-11ee-9658-58a023cda0dc.zip','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_eecd8fd5-572c-11ee-a378-58a023cda0dc_SESS_eed0dd8b-572c-11ee-a378-58a023cda0dc_TOSC_ab0cf7a4-5bc3-11ee-9658-58a023cda0dc_MODEL','ad938206-5bc4-11ee-9658-58a023cda0dc.zip','ad938206-5bc4-11ee-9658-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.32.2.1.1\",\"modelMatrix\":\"-0.376861,0.875379,-0.3028,0,-0.92627,-0.356155,0.123197,0,1.41587e-09,0.326903,0.945058,0,1.55662,-45.5601,-10.687,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-09-25 12:58:04.000','2023-09-25 17:39:47.433','2023-09-25 13:39:47.433'),('ad9391da-5bc4-11ee-9658-58a023cda0dc',664,'/var/.data/2023/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_eecd8fd5-572c-11ee-a378-58a023cda0dc/occlusion_eed0dd8b-572c-11ee-a378-58a023cda0dc/scan_ab0cf7a4-5bc3-11ee-9658-58a023cda0dc/ad9391da-5bc4-11ee-9658-58a023cda0dc.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_eecd8fd5-572c-11ee-a378-58a023cda0dc_SESS_eed0dd8b-572c-11ee-a378-58a023cda0dc_TOSC_ab0cf7a4-5bc3-11ee-9658-58a023cda0dc_SNAPS','ad9391da-5bc4-11ee-9658-58a023cda0dc.png','ad9391da-5bc4-11ee-9658-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.32.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-09-25 12:58:05.000','2023-09-25 17:39:47.449','2023-09-25 13:39:47.449'),('adca65c3-c068-425e-9917-53959630736b',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_d3696b3d-0728-4822-b89d-631e2ab774a4/occlusion_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6/scan_c550cbc7-71cb-4513-8c8b-7c725f1e0129/14_w2_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_d3696b3d-0728-4822-b89d-631e2ab774a4_SESS_0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6_RISC_c550cbc7-71cb-4513-8c8b-7c725f1e0129_SNAPS','14_w2_o1_mordu_posterieur_droit_snapshot_0.png','adca65c3-c068-425e-9917-53959630736b','{\"displayTitle\":\"Posterior right bite 1.14.2.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-11-30 02:14:43.000','2024-10-31 14:02:25.558','2024-10-31 10:02:25.558'),('ae255d52-c5a9-4e24-bb3e-6abc7d04c0e9',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_a72c11a4-05dc-4421-b252-fbfcecd2559e/occlusion_bf823edb-92ee-4ee9-acd3-507d49bad781/scan_98f6c3db-f007-4f0d-a724-a372751a6d75/14_w1_o1_mandibule_snapshot_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_a72c11a4-05dc-4421-b252-fbfcecd2559e_SESS_bf823edb-92ee-4ee9-acd3-507d49bad781_BOSC_98f6c3db-f007-4f0d-a724-a372751a6d75_SNAPS','14_w1_o1_mandibule_snapshot_0.png','ae255d52-c5a9-4e24-bb3e-6abc7d04c0e9','{\"displayTitle\":\"Mandible 1.14.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-09-09 15:47:12.000','2024-10-31 14:02:32.606','2024-10-31 10:02:32.606'),('ae2cbcbb-219f-4df2-a6c6-07327535a3c1',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_669f6bca-452c-4b2e-a49e-aa822628ed5f/24_w1_o1_maxillaire_scan_file_3.ply','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_TOSC_669f6bca-452c-4b2e-a49e-aa822628ed5f_MODEL','24_w1_o1_maxillaire_scan_file_3.ply','5ea87deb-c530-4c0d-9e39-e94f351d1354','{\"displayTitle\":\"Maxilla 1.24.1.1.1\",\"modelMatrix\":\"-0.999944,-0.00980338,0.00389464,0,0.0105487,-0.929296,0.369186,0,-2.71848e-10,0.369207,0.929347,0,18.3073,1.2474,-25.4183,1\",\"title\":\"Maxilla PLY\"}','PLY',3,'SYNCED',0,NULL,'2021-09-13 21:10:59.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.790'),('af0d9193-9465-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/af0d9193-9465-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_MODEL','af0d9193-9465-11ee-8fd8-58a023cda0dc.zip','87a0d07a-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1\",\"modelMatrix\":\"0.843881,0.502692,-0.187524,0,-0.53653,0.790659,-0.294947,0,3.33011e-09,0.349512,0.936932,0,-21.678,-3.20968,-22.8257,1\",\"scanBodies\":[]}','ZIP',4,'SYNCED',0,NULL,'2023-12-06 13:31:34.457','2023-12-06 19:12:08.101','2023-12-11 10:12:01.887'),('af1a4b3f-83d9-45e8-9fb8-748962f1978e',664,'/var/.data/2022/664/9bcfd1e2-10fc-4838-92c0-84057ad52bfe/session_21c82035-4359-4880-96f0-c80e94ed36f8/occlusion_b9c2b952-8d0a-4eac-ad77-2acda79cff8c/scan_4597ad8c-2f54-4ecd-827f-911125d72cc9/43_w1_o1_maxillaire_scan_file_0.zip','PATIENT_9bcfd1e2-10fc-4838-92c0-84057ad52bfe_ACT_21c82035-4359-4880-96f0-c80e94ed36f8_SESS_b9c2b952-8d0a-4eac-ad77-2acda79cff8c_TOSC_4597ad8c-2f54-4ecd-827f-911125d72cc9_MODEL','43_w1_o1_maxillaire_scan_file_0.zip','af1a4b3f-83d9-45e8-9fb8-748962f1978e','{\"displayTitle\":\"Maxilla 1.43.1.1.3\",\"modelMatrix\":\"-0.414113,-0.907372,0.0720157,0,0.910225,-0.412815,0.032764,0,1.23902e-09,0.0791185,0.996865,0,17.9909,13.3085,-21.4454,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-17 18:39:33.000','2024-10-31 14:02:32.226','2024-10-31 10:02:32.226'),('af351e93-da3e-41df-8372-3b3bacbcfcaf',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/occlusion_e930782a-e2db-43e8-9ff1-9feb64e20e4e/scan_3b924f2a-18f4-4ed4-8e4e-efb6a1b36439/35_w1_o1_mordu_anterieur_snapshot_1.png','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_FRSC_3b924f2a-18f4-4ed4-8e4e-efb6a1b36439_SNAPS','35_w1_o1_mordu_anterieur_snapshot_1.png','5842bacb-24f3-4473-8d2f-ca5548e651cf','{\"displayTitle\":\"Anterior bite 1.35.1.1.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-06-06 20:43:58.000','2024-10-31 14:02:29.671','2024-10-31 10:02:29.671'),('b048a2a4-c12e-4372-a64b-a9331ce964a1',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/occlusion_e930782a-e2db-43e8-9ff1-9feb64e20e4e/scan_ae3d82e4-16e2-4a7c-984e-ec74c0b263f0/35_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_LESC_ae3d82e4-16e2-4a7c-984e-ec74c0b263f0_MODEL','35_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','b048a2a4-c12e-4372-a64b-a9331ce964a1','{\"displayTitle\":\"Posterior left bite 1.35.1.1.1\",\"modelMatrix\":\"-0.980879,0.120467,0.154441,0,-0.13355,-0.985572,-0.100164,0,0.141612,-0.118939,0.982912,0,4.27867,5.91048,-17.8748,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-06 20:39:16.000','2024-10-31 14:02:29.601','2024-10-31 10:02:29.601'),('b04d457f-7b21-4521-bc90-01e2be5974b3',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_955946be-5764-4c34-9e84-61682f4fdf78/order_f4b76bbe-1f7d-4a48-9b89-a3a8b350b719/33_w2_couronne_sur_implant_prost_file_b04d457f-7b21-4521-bc90-01e2be5974b3_0.pdf','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_PROST_f4b76bbe-1f7d-4a48-9b89-a3a8b350b719_FORM','33_w2_couronne_sur_implant_prost_file_b04d457f-7b21-4521-bc90-01e2be5974b3_0.pdf','b04d457f-7b21-4521-bc90-01e2be5974b3','{\"displayTitle\":\"ORDER 1.33.2.2 IMPLANT CROWN\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'CREATED',0,NULL,'2022-08-22 15:34:43.000','2023-05-17 17:16:39.559',NULL),('b055178c-4263-48b5-b3f5-7d43da512f2f',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_955946be-5764-4c34-9e84-61682f4fdf78/occlusion_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d/scan_5de08e77-210d-48b5-8004-9c536bb8530e/33_w2_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_RISC_5de08e77-210d-48b5-8004-9c536bb8530e_SNAPS','33_w2_o1_mordu_posterieur_droit_snapshot_0.png','b055178c-4263-48b5-b3f5-7d43da512f2f','{\"displayTitle\":\"Posterior right bite 1.33.2.1.4\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-01 15:35:40.000','2024-10-31 14:02:31.878','2024-10-31 10:02:31.878'),('b0882173-80ca-4a75-94a1-981cb196d854',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_669f6bca-452c-4b2e-a49e-aa822628ed5f/24_w1_o1_maxillaire_scan_file_7.ply','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_TOSC_669f6bca-452c-4b2e-a49e-aa822628ed5f_MODEL','24_w1_o1_maxillaire_scan_file_7.ply','5ea87deb-c530-4c0d-9e39-e94f351d1354','{\"displayTitle\":\"Maxilla 1.24.1.1.1\",\"modelMatrix\":\"-0.658753,0.723297,-0.207089,0,-0.752359,-0.633306,0.181324,0,1.82945e-8,0.275253,0.961372,0,24.6353,-13.6739,-19.7993,1\",\"title\":\"Maxilla PLY\"}','PLY',7,'SYNCED',0,NULL,'2021-09-13 21:19:13.000','2024-10-31 14:02:28.684','2024-10-31 10:02:28.684'),('b1748d9e-4e52-44c2-93da-a30fa0938311',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/occlusion_d7b86e87-0261-4bc1-8529-76e0bdd29195/scan_f23ef241-b3d2-40c3-8f2d-1f815adfca52/18_w4_o1_maxillaire_snapshot_0.png','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_TOSC_f23ef241-b3d2-40c3-8f2d-1f815adfca52_SNAPS','18_w4_o1_maxillaire_snapshot_0.png','b1748d9e-4e52-44c2-93da-a30fa0938311','{\"displayTitle\":\"Maxilla 1.18.4.1.4\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-24 17:12:19.000','2024-10-31 14:02:33.185','2024-10-31 10:02:33.185'),('b22b5006-4b81-4653-ad5b-9f9f5eeebf0c',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_3ce0c78e-551a-4871-80c4-435836bf1dc5/32_w1_o1_mandibule_screenshot_b22b5006-4b81-4653-ad5b-9f9f5eeebf0c_0.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_BOSC_3ce0c78e-551a-4871-80c4-435836bf1dc5_SCREENS','32_w1_o1_mandibule_screenshot_b22b5006-4b81-4653-ad5b-9f9f5eeebf0c_0.png','b22b5006-4b81-4653-ad5b-9f9f5eeebf0c','{\"displayTitle\":\"Screenshot 1.32.1.1.1 Mandible 2\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Mandible 2\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:07:28.000','2024-10-31 14:02:32.879','2024-10-31 10:02:32.879'),('b2375a76-5251-44e7-ad97-616cdc631d01',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_51374b44-d221-416c-8eb3-cf931ed89632/occlusion_8b5d08e1-2513-416b-87f9-350cab840a3d/scan_640e0a5a-3880-4e38-add1-3466fa8599c0/37_w1_o1_maxillaire_scan_file_0.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_51374b44-d221-416c-8eb3-cf931ed89632_SESS_8b5d08e1-2513-416b-87f9-350cab840a3d_TOSC_640e0a5a-3880-4e38-add1-3466fa8599c0_MODEL','37_w1_o1_maxillaire_scan_file_0.zip','b2375a76-5251-44e7-ad97-616cdc631d01','{\"displayTitle\":\"Maxilla 1.37.1.1.1\",\"modelMatrix\":\"-0.269797,0.865903,-0.421214,0,-0.962917,-0.242615,0.118019,0,4.00652e-09,0.437436,0.89925,0,11.5719,-28.9186,-12.6981,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-22 15:46:50.000','2024-10-31 14:02:29.758','2024-10-31 10:02:29.758'),('b2797bfd-383a-4f9c-938a-60fe8de8146a',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/occlusion_cacc103c-8b88-4be5-a787-b6b92341e9eb/scan_ec42315e-bad9-44b4-bfd3-e86342727df2/34_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_SESS_cacc103c-8b88-4be5-a787-b6b92341e9eb_LESC_ec42315e-bad9-44b4-bfd3-e86342727df2_MODEL','34_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','b2797bfd-383a-4f9c-938a-60fe8de8146a','{\"displayTitle\":\"Posterior left bite 1.34.1.1.1\",\"modelMatrix\":\"-0.989428,0.0643595,0.131432,0,-0.0562417,-0.996719,0.0572568,0,0.133683,0.0490975,0.989671,0,2.1679,2.308,-18.4904,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-05-25 18:01:07.000','2024-10-31 14:02:29.313','2024-10-31 10:02:29.313'),('b321a7d1-22a8-4651-b766-bb5efbe38c99',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_db740293-ae2a-40ae-9142-4d94ed66bcd5/occlusion_1256ab02-5172-4a92-a17d-f2fc402290ac/scan_b6033058-40f5-4202-bc4b-bfe024d70e70/7_w6_o1_maxillaire_scan_file_2.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_db740293-ae2a-40ae-9142-4d94ed66bcd5_SESS_1256ab02-5172-4a92-a17d-f2fc402290ac_TOSC_b6033058-40f5-4202-bc4b-bfe024d70e70_MODEL','7_w6_o1_maxillaire_scan_file_2.ply','579610fb-1842-4dc6-8b36-ab5b5f876866','{\"displayTitle\":\"Maxilla 1.7.6.1.4\",\"modelMatrix\":\"-0.951656,0.134633,-0.276087,0,-0.307165,-0.41712,0.855372,0,1.88976e-9,0.898824,0.438309,0,8.67007,-39.5948,-6.73222,1\",\"title\":\"Maxilla PLY\"}','PLY',2,'SYNCED',0,NULL,'2021-05-05 16:34:13.000','2024-10-31 14:02:26.397','2024-10-31 10:02:26.397'),('b3577bd1-3f71-45cf-ab36-326a88d9a238',664,'/var/.data/2021/664/e4dda259-b05b-4f33-92ac-ee4067d7dfa2/session_610634a3-6f25-4ce3-9363-ad383ec68df4/occlusion_ea664326-1e10-4280-80b6-f3d23573a862/scan_9ec52cac-03f7-4247-88fd-59b11e688f36/4_w2_o2_maxillaire_snapshot_0.png','PATIENT_e4dda259-b05b-4f33-92ac-ee4067d7dfa2_ACT_610634a3-6f25-4ce3-9363-ad383ec68df4_SESS_ea664326-1e10-4280-80b6-f3d23573a862_TOSC_9ec52cac-03f7-4247-88fd-59b11e688f36_SNAPS','4_w2_o2_maxillaire_snapshot_0.png','b3577bd1-3f71-45cf-ab36-326a88d9a238','{\"displayTitle\":\"Maxilla 1.4.2.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-18 18:55:27.000','2024-10-31 14:02:25.629','2024-10-31 10:02:25.629'),('b3abd969-6b20-48f6-9d4d-0fb8e4e2a650',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_21bbefd5-8dc0-4e41-91d8-718463ad469c/scan_44749597-6cc6-493d-a2aa-76486e3c8416/41_w1_o3_mandibule_scan_file_0.zip','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_BOSC_44749597-6cc6-493d-a2aa-76486e3c8416_MODEL','41_w1_o3_mandibule_scan_file_0.zip','b3abd969-6b20-48f6-9d4d-0fb8e4e2a650','{\"displayTitle\":\"Mandible 1.41.1.3.1\",\"modelMatrix\":\"0.834559,0.435552,-0.337351,0,-0.550919,0.659796,-0.511036,0,-2.46592e-08,0.612343,0.790592,0,-16.6638,-11.4055,-18.0446,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-03 16:02:31.000','2024-10-31 14:02:32.087','2024-10-31 10:02:32.087'),('b3af0773-7d7b-41fe-9d8f-18f328cbc05c',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_120f9fe3-b23d-49c7-89ab-f1becc102f6c/scan_b08eb59b-89c3-4239-8926-d8eb829e4257/33_w1_o1_mandibule_mlmeta_1_0.bin','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_120f9fe3-b23d-49c7-89ab-f1becc102f6c_BOSC_b08eb59b-89c3-4239-8926-d8eb829e4257_LIFIM','33_w1_o1_mandibule_mlmeta_1_0.bin','b3af0773-7d7b-41fe-9d8f-18f328cbc05c','{\"displayTitle\":\"Margin line Mandible 1.33.1.1.1 Margin line 1\",\"name\":\"Margin line 1\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":1,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2022-04-14 15:18:48.000','2024-10-31 14:02:29.244','2024-10-31 10:02:29.244'),('b3e4aa09-a4e4-454f-9f21-2abb5e89e530',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/occlusion_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e/scan_51eb1879-2b2e-4194-9e9b-9ff1e67fe43c/49_w1_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_RISC_51eb1879-2b2e-4194-9e9b-9ff1e67fe43c_MODEL','49_w1_o1_mordu_posterieur_droit_scan_file_0.zip','b3e4aa09-a4e4-454f-9f21-2abb5e89e530','{\"displayTitle\":\"Posterior right bite 1.49.1.1.2\",\"modelMatrix\":\"0.945694,-0.162083,0.280879,0,0.142064,0.985708,0.0920357,0,-0.292373,-0.0459469,0.955321,0,-1.59336,2.97002,-22.3008,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-10-31 17:23:15.000','2024-10-31 14:02:35.596','2024-10-31 10:02:35.596'),('b3ec6691-f3e0-41f5-ae89-5336966f4cac',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_3ce0c78e-551a-4871-80c4-435836bf1dc5/32_w1_o1_mandibule_scan_file_1.zip','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_BOSC_3ce0c78e-551a-4871-80c4-435836bf1dc5_MODEL','32_w1_o1_mandibule_scan_file_1.zip','bd0f2665-9713-4244-9406-40e7630407de','{\"displayTitle\":\"Mandible 1.32.1.1.1\",\"modelMatrix\":\"0.481783,0.858325,-0.176531,0,-0.876291,0.471906,-0.0970563,0,3.00032e-09,0.201452,0.979498,0,7.19262,-41.6892,-15.095,1\",\"title\":\"Mandible ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-03-23 16:36:03.000','2024-10-31 14:02:32.896','2024-10-31 10:02:32.896'),('b3fbb783-8b86-4822-9640-974c7986b610',664,'','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_db740293-ae2a-40ae-9142-4d94ed66bcd5_SESS_1256ab02-5172-4a92-a17d-f2fc402290ac_TOSC_93f13113-c282-4369-a96a-9a2f2f6383b2_SNAPS','','b3fbb783-8b86-4822-9640-974c7986b610','{\"displayTitle\":\"Maxilla 1.7.6.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,'2022-03-14 14:42:23.000','2021-05-05 15:57:43.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.792'),('b48b199f-561e-4239-8141-bbd54b8a7a80',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_9f22f8f4-8b92-4811-8c6a-7b858b99e056/37_w2_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_LESC_9f22f8f4-8b92-4811-8c6a-7b858b99e056_MODEL','37_w2_o1_mordu_posterieur_gauche_scan_file_0.zip','b48b199f-561e-4239-8141-bbd54b8a7a80','{\"displayTitle\":\"Posterior left bite 1.37.2.1.1\",\"modelMatrix\":\"-0.952764,-0.010161,0.303817,0,0.0362753,-0.995403,0.0847077,0,0.301546,0.0953077,0.948962,0,3.14521,-2.5014,-19.4829,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-10-19 19:30:05.000','2024-10-31 14:02:35.432','2024-10-31 10:02:35.432'),('b4beeaca-9172-4b30-9b6f-a0e4bd048140',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_d3696b3d-0728-4822-b89d-631e2ab774a4/order_c7646a09-199d-41ff-9840-93f97fe9d1cb/14_w2_couronne_prost_file_0.pdf','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_d3696b3d-0728-4822-b89d-631e2ab774a4_PROST_c7646a09-199d-41ff-9840-93f97fe9d1cb_FORM','14_w2_couronne_prost_file_0.pdf','b4beeaca-9172-4b30-9b6f-a0e4bd048140','{\"displayTitle\":\"CROWN 1.14.2.1 CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-11-30 02:20:25.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.792'),('b4eec334-5aa2-493f-8b80-4404dc464a71',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/occlusion_cacc103c-8b88-4be5-a787-b6b92341e9eb/scan_bb241051-9343-4a9a-9282-a960e0748f3e/34_w1_o1_maxillaire_snapshot_2.png','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_SESS_cacc103c-8b88-4be5-a787-b6b92341e9eb_TOSC_bb241051-9343-4a9a-9282-a960e0748f3e_SNAPS','34_w1_o1_maxillaire_snapshot_2.png','acdd2be8-41d4-4309-8d50-7389512f9d6d','{\"displayTitle\":\"Maxilla 1.34.1.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2022-05-25 18:31:47.000','2024-10-31 14:02:29.397','2024-10-31 10:02:29.397'),('b5c25896-3d52-4eca-b060-52a2c1dfad88',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_ef2b4fcf-f21c-418d-942a-c99ea96efbdb/occlusion_7d36e059-dbc3-46b0-931a-bdf8fdc805c6/scan_f99691b6-3bf9-4760-8115-1d1a52fc98ae/7_w2_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_ef2b4fcf-f21c-418d-942a-c99ea96efbdb_SESS_7d36e059-dbc3-46b0-931a-bdf8fdc805c6_RISC_f99691b6-3bf9-4760-8115-1d1a52fc98ae_SNAPS','7_w2_o1_mordu_posterieur_droit_snapshot_0.png','b5c25896-3d52-4eca-b060-52a2c1dfad88','{\"displayTitle\":\"Posterior right bite 1.7.2.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-21 16:26:15.000','2024-10-31 14:02:26.275','2024-10-31 10:02:26.275'),('b5f6a1ce-86fb-467c-aa18-d4e1f5594aac',664,'/var/.data/2022/664/cede029c-15bc-44c2-9c9c-fac7f8983524/session_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29/occlusion_4d46a627-5949-4b2a-b4d6-c391f159485b/scan_2c6eb2a3-6697-4912-9947-5c2b5f942eb8/46_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_cede029c-15bc-44c2-9c9c-fac7f8983524_ACT_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29_SESS_4d46a627-5949-4b2a-b4d6-c391f159485b_RISC_2c6eb2a3-6697-4912-9947-5c2b5f942eb8_SNAPS','46_w1_o1_mordu_posterieur_droit_snapshot_0.png','b5f6a1ce-86fb-467c-aa18-d4e1f5594aac','{\"displayTitle\":\"Posterior right bite 1.46.1.1.2\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-12 20:38:04.000','2024-10-31 14:02:35.170','2024-10-31 10:02:35.170'),('b67e5e75-e3bc-4168-9f8a-023260cf853b',664,'/var/.data/2022/664/36e86f3f-4468-4cf2-9505-462288cae8b1/session_cc413c24-b371-4a75-9cfe-451a8d54e32e/occlusion_7af02eaf-c13f-4389-b2dd-b2cbdfb137e6/scan_bbd16c8e-e7dc-4578-8027-d6b5d16e2cce/36_w1_o1_maxillaire_snapshot_0.png','PATIENT_36e86f3f-4468-4cf2-9505-462288cae8b1_ACT_cc413c24-b371-4a75-9cfe-451a8d54e32e_SESS_7af02eaf-c13f-4389-b2dd-b2cbdfb137e6_TOSC_bbd16c8e-e7dc-4578-8027-d6b5d16e2cce_SNAPS','36_w1_o1_maxillaire_snapshot_0.png','b67e5e75-e3bc-4168-9f8a-023260cf853b','{\"displayTitle\":\"Maxilla 1.36.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-20 19:29:57.000','2024-10-31 14:02:29.684','2024-10-31 10:02:29.684'),('b6a3f85e-1545-44d4-88f7-8cb28ae3949d',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_7c9d6daa-c5b6-47ec-b65a-ee99948da8ea/27_w1_o1_mordu_anterieur_scan_file_0.zip','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_FRSC_7c9d6daa-c5b6-47ec-b65a-ee99948da8ea_MODEL','27_w1_o1_mordu_anterieur_scan_file_0.zip','b6a3f85e-1545-44d4-88f7-8cb28ae3949d','{\"displayTitle\":\"Anterior bite 1.27.1.1.1\",\"modelMatrix\":\"0.931652,-0.323896,-0.202984,0,0.361667,0.82117,0.584418,0,-0.0396367,-0.493314,0.79982,0,-10.3066,7.06521,-23.3248,1\",\"title\":\"Anterior bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-04 19:09:46.000','2024-10-31 14:02:28.552','2024-10-31 10:02:28.552'),('b7f4db52-3cfb-4afd-9675-3e73291b6516',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/occlusion_d7b86e87-0261-4bc1-8529-76e0bdd29195/scan_d43bd9e0-44ee-49ed-aa89-8bcd9837b34a/18_w4_o1_mordu_anterieur_scan_file_1.zip','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_FRSC_d43bd9e0-44ee-49ed-aa89-8bcd9837b34a_MODEL','18_w4_o1_mordu_anterieur_scan_file_1.zip','2271f9bf-12c8-4420-b9f4-ce7ac01d3567','{\"displayTitle\":\"Anterior bite 1.18.4.1.1\",\"modelMatrix\":\"0.874136,0.00998988,0.464941,0,0.0416732,0.995058,-0.0970287,0,-0.484496,0.0989366,0.880352,0,-2.91285,-3.60774,-32.1458,1\",\"title\":\"Anterior bite ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-08-24 16:42:45.000','2024-10-31 14:02:33.156','2024-10-31 10:02:33.156'),('b8827dde-757a-4031-9b65-359cf60ffcdf',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_ef2b4fcf-f21c-418d-942a-c99ea96efbdb/occlusion_7d36e059-dbc3-46b0-931a-bdf8fdc805c6/scan_d2853a7d-9edf-4ac8-aeaa-d186ea3a6553/7_w2_o1_mordu_anterieur_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_ef2b4fcf-f21c-418d-942a-c99ea96efbdb_SESS_7d36e059-dbc3-46b0-931a-bdf8fdc805c6_FRSC_d2853a7d-9edf-4ac8-aeaa-d186ea3a6553_SNAPS','7_w2_o1_mordu_anterieur_snapshot_0.png','b8827dde-757a-4031-9b65-359cf60ffcdf','{\"displayTitle\":\"Anterior bite 1.7.2.1.1\",\"title\":\"Anterior bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-21 16:32:10.000','2024-10-31 14:02:26.322','2024-10-31 10:02:26.322'),('b89bdf45-07f7-4aef-b272-f9b581b06b02',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_b5dae369-a773-4095-aa54-7c8b75c939d8/occlusion_a12bd271-974e-4fcf-8893-d88105690bce/scan_e1f9f752-dd61-4e2b-82d8-016edf9173cf/7_w3_o1_maxillaire_scan_file_0.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_b5dae369-a773-4095-aa54-7c8b75c939d8_SESS_a12bd271-974e-4fcf-8893-d88105690bce_TOSC_e1f9f752-dd61-4e2b-82d8-016edf9173cf_MODEL','7_w3_o1_maxillaire_scan_file_0.ply','b89bdf45-07f7-4aef-b272-f9b581b06b02','{\"displayTitle\":\"Maxilla 1.7.3.1.1\",\"modelMatrix\":\"0.483749,0.662097,-0.572376,0,-0.875207,0.365958,-0.316367,0,-2.52086e-9,0.65399,0.756503,0,3.8566,-51.5061,-15.795,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-28 17:03:00.000','2024-10-31 14:02:26.495','2024-10-31 10:02:26.495'),('b90a2d0a-724a-4666-b16f-164f094d366d',664,'/var/.data/2021/664/f4f78058-cf3c-4c86-a252-bc92bd2d36b0/session_49b3ccf6-630c-48b2-8480-8a005298959e/occlusion_eee3d6a4-c7be-49a9-9278-7bd1d7e7f773/scan_4d1480f1-6a51-4555-bec5-61f967de64cd/13_w1_o1_maxillaire_screenshot_b90a2d0a-724a-4666-b16f-164f094d366d_0.png','PATIENT_f4f78058-cf3c-4c86-a252-bc92bd2d36b0_ACT_49b3ccf6-630c-48b2-8480-8a005298959e_SESS_eee3d6a4-c7be-49a9-9278-7bd1d7e7f773_TOSC_4d1480f1-6a51-4555-bec5-61f967de64cd_SCREENS','13_w1_o1_maxillaire_screenshot_b90a2d0a-724a-4666-b16f-164f094d366d_0.png','b90a2d0a-724a-4666-b16f-164f094d366d','{\"displayTitle\":\"Screenshot 1.13.1.1.1 Maxilla 1\",\"scanFileId\":\"0cc0a4e2-b944-4f97-b8fd-4141a51c8b36\",\"scanFileType\":\"PLY\",\"scanPosition\":\"-0.9468,-0.0136106,0.321534,0,0.312152,0.204231,0.92782,0,-0.0782954,0.978828,-0.189118,0,0,0,0,1\",\"title\":\"Maxilla 1\"}','PNG',0,'SYNCED',0,NULL,'2020-09-02 15:30:18.000','2024-10-31 14:02:25.604','2024-10-31 10:02:25.604'),('b975305f-5425-46f9-8470-1c628b260f46',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_70b1bf4b-a08d-4b96-9200-6648114f1bcd/37_w2_o1_maxillaire_snapshot_0.png','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_TOSC_70b1bf4b-a08d-4b96-9200-6648114f1bcd_SNAPS','37_w2_o1_maxillaire_snapshot_0.png','b975305f-5425-46f9-8470-1c628b260f46','{\"displayTitle\":\"Maxilla 1.37.2.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-10-19 19:30:04.000','2024-10-31 14:02:35.402','2024-10-31 10:02:35.402'),('b9908633-8c54-4317-8939-f934991e5174',664,'','PATIENT_cede029c-15bc-44c2-9c9c-fac7f8983524_ACT_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29_SESS_4d46a627-5949-4b2a-b4d6-c391f159485b_RISC_c56436ec-184d-44cc-9d63-5d6b28b7aebe_SNAPS','46_w1_o1_mordu_posterieur_droit_snapshot_0.png','b9908633-8c54-4317-8939-f934991e5174','{\"displayTitle\":\"Posterior right bite 1.46.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:08:37.000','2022-09-12 14:35:15.000','2024-10-31 14:02:35.159','2024-10-31 10:02:35.159'),('ba2e753b-8816-4982-874e-0a6179134184',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_893e772a-611c-44f9-82ac-d63e0a0499b2/21_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_RISC_893e772a-611c-44f9-82ac-d63e0a0499b2_MODEL','21_w1_o1_mordu_posterieur_droit_scan_file_0.ply','ba2e753b-8816-4982-874e-0a6179134184','{\"displayTitle\":\"Posterior right bite 1.21.1.1.1\",\"modelMatrix\":\"0.997112,0.0664825,0.0368927,0,-0.0680706,0.99609,0.0588314,0,-0.0336827,-0.0582468,0.997591,0,-17.8387,7.27129,-17.1747,1\",\"title\":\"Posterior right bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-28 18:54:11.000','2024-10-31 14:02:26.123','2024-10-31 10:02:26.123'),('bab90ee4-be72-463a-9fcc-241e88b8af7c',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/occlusion_d7b86e87-0261-4bc1-8529-76e0bdd29195/scan_f23ef241-b3d2-40c3-8f2d-1f815adfca52/18_w4_o1_maxillaire_scan_file_0.zip','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_TOSC_f23ef241-b3d2-40c3-8f2d-1f815adfca52_MODEL','18_w4_o1_maxillaire_scan_file_0.zip','bab90ee4-be72-463a-9fcc-241e88b8af7c','{\"displayTitle\":\"Maxilla 1.18.4.1.4\",\"modelMatrix\":\"0.290549,0.343451,-0.893097,0,-0.95686,0.104288,-0.271188,0,-2.94809e-10,0.933362,0.358935,0,-5.66434,-41.3012,5.24441,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-24 17:12:19.000','2023-05-22 13:09:23.151','2023-05-22 09:09:23.151'),('bb246139-446d-41bd-af89-0c4dcc147372',664,'/var/.data/2022/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_705960fa-3ed4-4013-9cde-20022721d122/occlusion_9f4fa7cb-81a3-460e-b189-ba76eb8cee15/scan_c25edbb6-50b0-4c96-8756-63dca8532242/7_w8_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_705960fa-3ed4-4013-9cde-20022721d122_SESS_9f4fa7cb-81a3-460e-b189-ba76eb8cee15_RISC_c25edbb6-50b0-4c96-8756-63dca8532242_MODEL','7_w8_o1_mordu_posterieur_droit_scan_file_0.zip','bb246139-446d-41bd-af89-0c4dcc147372','{\"displayTitle\":\"Posterior right bite 1.7.8.1.1\",\"modelMatrix\":\"0.999661,0.00635155,0.0342119,0,-0.00795615,0.997729,0.0697566,0,-0.0259687,-0.0671123,0.997012,0,-19.5987,-0.855542,-19.6816,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-30 17:15:54.000','2024-10-31 14:02:28.975','2024-10-31 10:02:28.975'),('bb25c8c5-6854-4fe0-be65-94e273c0d922',664,'/var/.data/2022/664/7eac18e5-5ed2-4ed9-8b3e-eba1c562d708/session_c49716f1-987e-4111-9ab9-4541a0378bb7/occlusion_9a395a3e-4872-409e-922b-4bb58053d8a5/scan_ec557b87-5cb1-4e74-9d71-d45c543b3847/30_w1_o1_maxillaire_scan_file_0.zip','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_TOSC_ec557b87-5cb1-4e74-9d71-d45c543b3847_MODEL','30_w1_o1_maxillaire_scan_file_0.zip','bb25c8c5-6854-4fe0-be65-94e273c0d922','{\"displayTitle\":\"Maxilla 1.30.1.1.1\",\"modelMatrix\":\"-0.84821,0.515699,-0.120808,0,-0.52966,-0.825852,0.193465,0,-1.15779e-08,0.228086,0.973641,0,19.7475,-10.7211,-20.0437,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-21 15:09:01.000','2024-10-31 14:02:33.003','2024-10-31 10:02:33.003'),('bb969c94-5b26-4ac7-b0c1-9e5784e6d4f0',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_120f9fe3-b23d-49c7-89ab-f1becc102f6c/scan_a6440940-a668-4e8f-be35-82ce928f701e/33_w1_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_120f9fe3-b23d-49c7-89ab-f1becc102f6c_RISC_a6440940-a668-4e8f-be35-82ce928f701e_MODEL','33_w1_o1_mordu_posterieur_droit_scan_file_0.zip','bb969c94-5b26-4ac7-b0c1-9e5784e6d4f0','{\"displayTitle\":\"Posterior right bite 1.33.1.1.1\",\"modelMatrix\":\"0.947262,-0.0863459,0.306184,0,0.0243918,0.970499,0.23708,0,-0.319839,-0.225594,0.921989,0,-10.6202,7.93981,-23.2787,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-04-11 17:11:42.000','2024-10-31 14:02:29.084','2024-10-31 10:02:29.084'),('bbd7b267-49ae-4e37-bed9-4d177880c06e',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_62fd085a-7b18-4cdf-aa97-db92a842f34f/32_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_RISC_62fd085a-7b18-4cdf-aa97-db92a842f34f_SNAPS','32_w1_o1_mordu_posterieur_droit_snapshot_0.png','bbd7b267-49ae-4e37-bed9-4d177880c06e','{\"displayTitle\":\"Posterior right bite 1.32.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-23 16:37:51.000','2024-10-31 14:02:32.925','2024-10-31 10:02:32.925'),('bc2d83ba-f199-4e59-bccb-362f0d7ec120',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_a4752db3-12a3-432e-825c-694c37118d39/37_w2_o2_mordu_posterieur_droit_snapshot_1.png','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_RISC_a4752db3-12a3-432e-825c-694c37118d39_SNAPS','37_w2_o2_mordu_posterieur_droit_snapshot_1.png','2f08ce27-2392-4c74-9c68-ed3fd9058690','{\"displayTitle\":\"Posterior right bite 1.37.2.2.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-11-09 16:12:21.000','2024-10-31 14:02:35.930','2024-10-31 10:02:35.930'),('bca84273-9838-11ee-86e7-58a023cda0dc',664,'/var/.data/2023/664/b4c6341b-9837-11ee-86e7-58a023cda0dc/session_bf1582a4-9837-11ee-86e7-58a023cda0dc/occlusion_bf16aee0-9837-11ee-86e7-58a023cda0dc/scan_30fee8be-9838-11ee-86e7-58a023cda0dc/bca84273-9838-11ee-86e7-58a023cda0dc.zip','PATIENT_b4c6341b-9837-11ee-86e7-58a023cda0dc_ACT_bf1582a4-9837-11ee-86e7-58a023cda0dc_SESS_bf16aee0-9837-11ee-86e7-58a023cda0dc_TOSC_30fee8be-9838-11ee-86e7-58a023cda0dc_MODEL','bca84273-9838-11ee-86e7-58a023cda0dc.zip','bca84273-9838-11ee-86e7-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.56.1.1.1\",\"modelMatrix\":\"-0.226175,0.953756,-0.197974,0,-0.974087,-0.221455,0.045968,0,-1.54472e-09,0.203241,0.979129,0,14.2978,-26.3965,-18.7867,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-12-11 10:40:44.000','2023-12-11 16:39:42.089','2023-12-11 11:39:42.089'),('bca8530d-9838-11ee-86e7-58a023cda0dc',664,'/var/.data/2023/664/b4c6341b-9837-11ee-86e7-58a023cda0dc/session_bf1582a4-9837-11ee-86e7-58a023cda0dc/occlusion_bf16aee0-9837-11ee-86e7-58a023cda0dc/scan_30fee8be-9838-11ee-86e7-58a023cda0dc/bca8530d-9838-11ee-86e7-58a023cda0dc.png','PATIENT_b4c6341b-9837-11ee-86e7-58a023cda0dc_ACT_bf1582a4-9837-11ee-86e7-58a023cda0dc_SESS_bf16aee0-9837-11ee-86e7-58a023cda0dc_TOSC_30fee8be-9838-11ee-86e7-58a023cda0dc_SNAPS','bca8530d-9838-11ee-86e7-58a023cda0dc.png','bca8530d-9838-11ee-86e7-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.56.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-12-11 10:40:44.000','2023-12-11 16:39:42.104','2023-12-11 11:39:42.104'),('bcca7cb5-9465-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/bcca7cb5-9465-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_MODEL','bcca7cb5-9465-11ee-8fd8-58a023cda0dc.zip','87a0d07a-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1\",\"modelMatrix\":\"0.843881,0.502692,-0.187524,0,-0.53653,0.790659,-0.294947,0,3.33011e-09,0.349512,0.936932,0,-21.678,-3.20968,-22.8257,1\",\"scanBodies\":[]}','ZIP',5,'SYNCED',0,NULL,'2023-12-06 13:31:57.505','2023-12-06 19:12:08.102','2023-12-11 10:12:04.117'),('bd0f2665-9713-4244-9406-40e7630407de',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_3ce0c78e-551a-4871-80c4-435836bf1dc5/32_w1_o1_mandibule_scan_file_0.zip','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_BOSC_3ce0c78e-551a-4871-80c4-435836bf1dc5_MODEL','32_w1_o1_mandibule_scan_file_0.zip','bd0f2665-9713-4244-9406-40e7630407de','{\"displayTitle\":\"Mandible 1.32.1.1.1\",\"modelMatrix\":\"0.66241,0.724634,-0.190048,0,-0.749141,0.64074,-0.168045,0,-2.63436e-09,0.253687,0.967286,0,-1.04727,-44.5512,-12.3129,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-23 16:33:05.000','2024-10-31 14:02:32.888','2024-10-31 10:02:32.888'),('bd2c5911-7e30-497f-836b-cd9620a24680',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_ef2b4fcf-f21c-418d-942a-c99ea96efbdb/occlusion_7d36e059-dbc3-46b0-931a-bdf8fdc805c6/scan_a6208834-50bc-4a6d-9646-4220f7dbfeeb/7_w2_o1_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_ef2b4fcf-f21c-418d-942a-c99ea96efbdb_SESS_7d36e059-dbc3-46b0-931a-bdf8fdc805c6_LESC_a6208834-50bc-4a6d-9646-4220f7dbfeeb_MODEL','7_w2_o1_mordu_posterieur_gauche_scan_file_0.ply','bd2c5911-7e30-497f-836b-cd9620a24680','{\"displayTitle\":\"Posterior left bite 1.7.2.1.1\",\"modelMatrix\":\"-0.939156,-0.20197,0.285375,0,0.232722,-0.960601,0.143126,0,0.253124,0.191952,0.947776,0,11.3057,-6.9755,-19.4527,1\",\"title\":\"Posterior left bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-21 16:29:16.000','2024-10-31 14:02:26.303','2024-10-31 10:02:26.303'),('bdaae778-b76a-455c-8a8c-c99af2ac7229',664,'','PATIENT_59179996-dc1e-4b4c-b9fd-92c78aa1dde0_ACT_df905f94-03ea-4868-82d7-960568f5cab7_SESS_88c76352-cde4-4fcb-a264-c6cd5cb1e44f_TOSC_51d672de-5db0-4925-8908-13042e3aacea_MODEL','','cd6dafb5-01b1-4b6c-955d-9c6344bc8edc','{\"displayTitle\":\"Maxilla 1.40.1.1.1\",\"modelMatrix\":\"0.619197,-0.783004,0.0591585,0,0.785236,0.617437,-0.0466494,0,8.25004e-10,0.0753385,0.997158,0,6.15947,13.0236,-22.1023,1\",\"title\":\"Maxilla ZIP\"}','ZIP',1,'CREATED',0,'2022-07-18 16:51:00.000','2022-07-18 16:47:34.000','2023-05-17 17:16:39.559',NULL),('be00d1bd-c78e-4b52-8426-ae28db017a78',664,'','PATIENT_d971e033-4a5c-4bd9-aab3-6238778f9eee_ACT_6fc7c9c9-3191-4169-b15f-edf43fc51336_PROST_2f5b2737-e56b-4716-8b81-b8f39386743d_FORM','','be00d1bd-c78e-4b52-8426-ae28db017a78','{\"displayTitle\":\"ORDER 1.47.1.2 CROWN (TEST)\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,'2022-09-21 18:22:57.000','2022-09-21 18:21:02.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.794'),('be10bb9a-6014-4271-a65f-d5a456b36cdd',664,'','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_RISC_6bf6cdd3-0c99-40b6-9e2b-5eaf7077f35f_MODEL','33_w2_o1_mordu_posterieur_droit_scan_file_0.zip','be10bb9a-6014-4271-a65f-d5a456b36cdd','{\"displayTitle\":\"Posterior right bite 1.33.2.1.1\",\"modelMatrix\":\"0.980801,-0.1772,0.088138,0,0.167753,0.982935,0.0627405,0,-0.0995423,-0.0496542,0.994138,0,-12.5972,2.87033,-21.3867,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:08:39.000','2022-08-01 09:23:55.000','2024-10-31 14:02:31.788','2024-10-31 10:02:31.788'),('beb295f0-eb2c-47ac-9f65-fc24660f5548',664,'','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_TOSC_ded778b4-0eef-4984-8f57-77502f727676_MODEL','41_w1_o3_maxillaire_scan_file_1.zip','ad632823-c0d2-40d5-86fc-095a10d5a99c','{\"displayTitle\":\"Maxilla 1.41.1.3.2\",\"modelMatrix\":\"-0.998378,-0.0563299,0.00822162,0,0.0569267,-0.987911,0.14419,0,4.09065e-11,0.144425,0.989516,0,10.1235,-4.24046,-21.6107,1\",\"title\":\"Maxilla ZIP\"}','ZIP',1,'SYNCED',0,'2023-05-22 09:08:14.000','2022-08-03 09:56:03.000','2024-10-31 14:02:31.993','2024-10-31 10:02:31.993'),('bedd27a8-e576-4dc7-ad8b-6e29faaac9ff',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_5500928e-446a-45d8-af99-faf7375b1d49/21_w1_o1_mandibule_snapshot_2.png','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_BOSC_5500928e-446a-45d8-af99-faf7375b1d49_SNAPS','21_w1_o1_mandibule_snapshot_2.png','779f3035-6a8d-41b5-8c8d-7ea284d28390','{\"displayTitle\":\"Mandible 1.21.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2021-04-28 18:21:59.000','2024-10-31 14:02:26.113','2024-10-31 10:02:26.113'),('bf778da7-bcd4-47d5-8c14-ef8ea32c4781',664,'/var/.data/2022/664/36e86f3f-4468-4cf2-9505-462288cae8b1/session_cc413c24-b371-4a75-9cfe-451a8d54e32e/order_68450b97-4193-42f4-a818-4bca3fb50cca/36_w1_gouttiere_prost_file_bf778da7-bcd4-47d5-8c14-ef8ea32c4781_1.pdf','PATIENT_36e86f3f-4468-4cf2-9505-462288cae8b1_ACT_cc413c24-b371-4a75-9cfe-451a8d54e32e_PROST_68450b97-4193-42f4-a818-4bca3fb50cca_FORM','36_w1_gouttiere_prost_file_bf778da7-bcd4-47d5-8c14-ef8ea32c4781_1.pdf','a116495f-1bcf-4022-af0c-f807a25b1c9c','{\"displayTitle\":\"ORDER 1.36.1.1 TRAY\",\"title\":\"Gouttiere PDF\"}','PDF',1,'SYNCED',0,NULL,'2022-06-22 15:23:42.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.795'),('bfe83fc6-99db-4c9b-8220-a9a7631cf7e7',664,'/var/.data/2021/664/17cc8b8c-6280-4e69-ad1e-731bdd9819e0/session_f9cb9561-eacc-4b43-976b-dfa67a953a80/occlusion_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910/scan_b8399067-4ae2-4f64-a407-d8870e0e66ec/19_w1_o1_maxillaire_scan_file_0.ply','PATIENT_17cc8b8c-6280-4e69-ad1e-731bdd9819e0_ACT_f9cb9561-eacc-4b43-976b-dfa67a953a80_SESS_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910_TOSC_b8399067-4ae2-4f64-a407-d8870e0e66ec_MODEL','19_w1_o1_maxillaire_scan_file_0.ply','bfe83fc6-99db-4c9b-8220-a9a7631cf7e7','{\"displayTitle\":\"Maxilla 1.19.1.1.1\",\"modelMatrix\":\"0.0427975,0.983139,-0.177782,0,-0.999084,0.0421144,-0.00761559,0,9.81588e-11,0.177945,0.98404,0,-11.9552,-25.5986,-15.9656,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-09 19:34:55.000','2024-10-31 14:02:25.735','2024-10-31 10:02:25.735'),('c0142452-f781-449f-8eb3-faf1fbef6774',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_669f6bca-452c-4b2e-a49e-aa822628ed5f/24_w1_o1_maxillaire_scan_file_4.ply','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_TOSC_669f6bca-452c-4b2e-a49e-aa822628ed5f_MODEL','24_w1_o1_maxillaire_scan_file_4.ply','5ea87deb-c530-4c0d-9e39-e94f351d1354','{\"displayTitle\":\"Maxilla 1.24.1.1.1\",\"modelMatrix\":\"-0.999944,-0.00980338,0.00389464,0,0.0105487,-0.929296,0.369186,0,-2.71848e-10,0.369207,0.929347,0,18.3073,1.2474,-25.4183,1\",\"title\":\"Maxilla PLY\"}','PLY',4,'SYNCED',0,NULL,'2021-09-13 21:11:31.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.790'),('c07ab4b3-ce6f-4eeb-859d-40b3c4631562',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_7d40798f-7207-4c33-aa42-10afc814de77/scan_a0b85a0a-ef77-4f7c-b376-d6e388afe9f0/10_w1_o1_mandibule_scan_file_0.ply','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_BOSC_a0b85a0a-ef77-4f7c-b376-d6e388afe9f0_MODEL','10_w1_o1_mandibule_scan_file_0.ply','c07ab4b3-ce6f-4eeb-859d-40b3c4631562','{\"displayTitle\":\"Mandible 1.10.1.1.1\",\"modelMatrix\":\"0.80002,-0.575788,0.168628,0,0.599973,0.767772,-0.224853,0,-5.48436e-9,0.281059,0.959691,0,-13.3889,6.88757,-23.4513,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-06-29 20:07:52.000','2024-10-31 14:02:32.308','2024-10-31 10:02:32.308'),('c07ee7aa-9467-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_837d6f6c-9467-11ee-8fd8-58a023cda0dc/c07ee7aa-9467-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_LESC_837d6f6c-9467-11ee-8fd8-58a023cda0dc_MODEL','c07ee7aa-9467-11ee-8fd8-58a023cda0dc.zip','c07ee7aa-9467-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Left bite 1.55.1.1.1\",\"modelMatrix\":\"-0.993248,-0.0438069,0.109597,0,0.045957,-0.996488,0.0674377,0,0.10665,0.0715672,0.991686,0,16.047,-0.174009,-18.8654,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-12-11 10:12:30.000','2024-10-31 14:02:37.332','2024-10-31 10:02:37.332'),('c07ef7b2-9467-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_837d6f6c-9467-11ee-8fd8-58a023cda0dc/c07ef7b2-9467-11ee-8fd8-58a023cda0dc.png','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_LESC_837d6f6c-9467-11ee-8fd8-58a023cda0dc_SNAPS','c07ef7b2-9467-11ee-8fd8-58a023cda0dc.png','c07ef7b2-9467-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Left bite 1.55.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-12-11 10:12:30.000','2024-10-31 14:02:37.339','2024-10-31 10:02:37.339'),('c0de44a6-6316-4997-9cb5-d1b77defc44c',664,'/var/.data/2022/664/7eac18e5-5ed2-4ed9-8b3e-eba1c562d708/session_c49716f1-987e-4111-9ab9-4541a0378bb7/order_54410525-60fc-4d0d-9655-9ea6638a6043/30_w1_couronne_sur_implant_prost_file_c0de44a6-6316-4997-9cb5-d1b77defc44c_1.pdf','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_PROST_54410525-60fc-4d0d-9655-9ea6638a6043_FORM','30_w1_couronne_sur_implant_prost_file_c0de44a6-6316-4997-9cb5-d1b77defc44c_1.pdf','7ea07429-5447-4d83-a220-b0cf75c4f7ca','{\"displayTitle\":\"ORDER 1.30.1.2 IMPLANT CROWN\",\"title\":\"Couronne sur Implant PDF\"}','PDF',1,'SYNCED',0,NULL,'2022-04-01 15:51:34.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.795'),('c12d2c0a-871d-48e9-b3de-bc4c3e6cdc17',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/order_c94feabc-c456-485b-b538-c3a58bce9798/18_w4_couronne_sur_implant_prost_file_c12d2c0a-871d-48e9-b3de-bc4c3e6cdc17_0.pdf','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_PROST_c94feabc-c456-485b-b538-c3a58bce9798_FORM','18_w4_couronne_sur_implant_prost_file_c12d2c0a-871d-48e9-b3de-bc4c3e6cdc17_0.pdf','c12d2c0a-871d-48e9-b3de-bc4c3e6cdc17','{\"displayTitle\":\"ORDER 1.18.4.2 IMPLANT CROWN BIYOUNG ANDRE\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-09-07 19:49:45.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.262'),('c166afdc-5215-400f-8a3a-0002542312db',664,'/var/.data/2022/664/e33159c9-a713-4a37-ba98-9ec2e2e213e7/session_b63ca765-4d68-4cf4-9707-4ad3a19f3236/occlusion_ae7f89c9-26ec-4cee-b377-d5145e6c6aae/scan_ad99e632-5042-4e93-87eb-5f1d24eaf0df/50_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_e33159c9-a713-4a37-ba98-9ec2e2e213e7_ACT_b63ca765-4d68-4cf4-9707-4ad3a19f3236_SESS_ae7f89c9-26ec-4cee-b377-d5145e6c6aae_LESC_ad99e632-5042-4e93-87eb-5f1d24eaf0df_MODEL','50_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','c166afdc-5215-400f-8a3a-0002542312db','{\"displayTitle\":\"Posterior left bite 1.50.1.1.1\",\"modelMatrix\":\"-0.976836,-0.0431368,0.209234,0,0.0525802,-0.994912,0.0835193,0,0.207628,0.0915257,0.9743,0,17.4731,-1.93237,-24.7084,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-14 18:22:53.000','2024-10-31 14:02:36.226','2024-10-31 10:02:36.226'),('c16a858c-f3d1-46c0-9789-5b60741a4656',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_51374b44-d221-416c-8eb3-cf931ed89632/occlusion_8b5d08e1-2513-416b-87f9-350cab840a3d/scan_7eb7b491-f49d-4ad2-941c-473aec4b39cd/37_w1_o1_mandibule_scan_file_0.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_51374b44-d221-416c-8eb3-cf931ed89632_SESS_8b5d08e1-2513-416b-87f9-350cab840a3d_BOSC_7eb7b491-f49d-4ad2-941c-473aec4b39cd_MODEL','37_w1_o1_mandibule_scan_file_0.zip','c16a858c-f3d1-46c0-9789-5b60741a4656','{\"displayTitle\":\"Mandible 1.37.1.1.1\",\"modelMatrix\":\"0.750504,0.630495,-0.198043,0,-0.660867,0.716012,-0.224904,0,-9.30686e-09,0.299671,0.954043,0,-3.29435,-10.7037,-18.4857,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-22 15:42:04.000','2024-10-31 14:02:29.715','2024-10-31 10:02:29.715'),('c21da88f-3f6d-4a2f-9651-4074d522cb15',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/order_ea343662-ea36-42db-b63d-dd61bc999ce0/32_w1_bridge_sur_implant_prost_file_c21da88f-3f6d-4a2f-9651-4074d522cb15_1.pdf','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_PROST_ea343662-ea36-42db-b63d-dd61bc999ce0_FORM','32_w1_bridge_sur_implant_prost_file_c21da88f-3f6d-4a2f-9651-4074d522cb15_1.pdf','4e0207c3-761b-40df-9a9e-ec615454ca8d','{\"displayTitle\":\"ORDER 1.32.1.1 IMPLANT BRIDGE\",\"title\":\"Bridge sur Implant PDF\"}','PDF',1,'SYNCED',0,NULL,'2022-03-24 16:46:14.000','2023-05-17 17:16:39.559','2023-05-22 09:08:45.837'),('c2409855-6e21-47ba-ac07-1ce2895179b8',664,'/var/.data/2022/664/d971e033-4a5c-4bd9-aab3-6238778f9eee/session_6fc7c9c9-3191-4169-b15f-edf43fc51336/occlusion_18d990cb-0161-4a7a-b1ce-1c139a73a700/scan_5ffd123b-12b9-4fc7-9b8a-16b74a28e7b2/47_w1_o1_maxillaire_scan_file_0.zip','PATIENT_d971e033-4a5c-4bd9-aab3-6238778f9eee_ACT_6fc7c9c9-3191-4169-b15f-edf43fc51336_SESS_18d990cb-0161-4a7a-b1ce-1c139a73a700_TOSC_5ffd123b-12b9-4fc7-9b8a-16b74a28e7b2_MODEL','47_w1_o1_maxillaire_scan_file_0.zip','c2409855-6e21-47ba-ac07-1ce2895179b8','{\"displayTitle\":\"Maxilla 1.47.1.1.1\",\"modelMatrix\":\"0.909105,0.414136,-0.0449351,0,-0.416567,0.9038,-0.0980651,0,2.73453e-10,0.10787,0.994165,0,-10.4946,-10.0325,-19.7716,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-14 17:55:29.000','2024-10-31 14:02:35.195','2024-10-31 10:02:35.195'),('c35a163d-8056-4e6b-ac08-f90f304d871f',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/occlusion_cacc103c-8b88-4be5-a787-b6b92341e9eb/scan_bb241051-9343-4a9a-9282-a960e0748f3e/34_w1_o1_maxillaire_scan_file_1.zip','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_SESS_cacc103c-8b88-4be5-a787-b6b92341e9eb_TOSC_bb241051-9343-4a9a-9282-a960e0748f3e_MODEL','34_w1_o1_maxillaire_scan_file_1.zip','43ec56d4-c1b3-4a5d-a33a-61909d689853','{\"displayTitle\":\"Maxilla 1.34.1.1.2\",\"modelMatrix\":\"-0.954743,0.294349,-0.042709,0,-0.297431,-0.944849,0.137094,0,1.14559e-09,0.143593,0.989637,0,-7.7532,-5.90957,-20.991,1\",\"title\":\"Maxilla ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-05-25 18:29:07.000','2024-10-31 14:02:29.413','2024-10-31 10:02:29.413'),('c37cdd93-5bc2-11ee-9658-58a023cda0dc',664,'/var/.data/2023/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_eecd8fd5-572c-11ee-a378-58a023cda0dc/occlusion_eed0dd8b-572c-11ee-a378-58a023cda0dc/scan_57e592a9-5bc2-11ee-9658-58a023cda0dc/c37cdd93-5bc2-11ee-9658-58a023cda0dc.zip','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_eecd8fd5-572c-11ee-a378-58a023cda0dc_SESS_eed0dd8b-572c-11ee-a378-58a023cda0dc_RISC_57e592a9-5bc2-11ee-9658-58a023cda0dc_MODEL','c37cdd93-5bc2-11ee-9658-58a023cda0dc.zip','c37cdd93-5bc2-11ee-9658-58a023cda0dc','{\"displayTitle\":\"Right bite 1.32.2.1.1\",\"modelMatrix\":\"0.977372,-0.0516678,0.199153,0,0.0297092,0.99397,0.100998,0,-0.209536,-0.0968088,0.974782,0,-12.6257,2.62396,-24.8128,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-09-25 12:44:18.000','2023-09-25 17:39:47.464','2023-09-25 13:39:47.464'),('c37cebbc-5bc2-11ee-9658-58a023cda0dc',664,'/var/.data/2023/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_eecd8fd5-572c-11ee-a378-58a023cda0dc/occlusion_eed0dd8b-572c-11ee-a378-58a023cda0dc/scan_57e592a9-5bc2-11ee-9658-58a023cda0dc/c37cebbc-5bc2-11ee-9658-58a023cda0dc.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_eecd8fd5-572c-11ee-a378-58a023cda0dc_SESS_eed0dd8b-572c-11ee-a378-58a023cda0dc_RISC_57e592a9-5bc2-11ee-9658-58a023cda0dc_SNAPS','c37cebbc-5bc2-11ee-9658-58a023cda0dc.png','c37cebbc-5bc2-11ee-9658-58a023cda0dc','{\"displayTitle\":\"Right bite 1.32.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-09-25 12:44:19.000','2023-09-25 17:39:47.475','2023-09-25 13:39:47.475'),('c3a0080d-af3f-4577-9532-87d15d4dc941',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/occlusion_e930782a-e2db-43e8-9ff1-9feb64e20e4e/scan_ae3d82e4-16e2-4a7c-984e-ec74c0b263f0/35_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_LESC_ae3d82e4-16e2-4a7c-984e-ec74c0b263f0_SNAPS','35_w1_o1_mordu_posterieur_gauche_snapshot_0.png','c3a0080d-af3f-4577-9532-87d15d4dc941','{\"displayTitle\":\"Posterior left bite 1.35.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-06 20:39:16.000','2024-10-31 14:02:29.613','2024-10-31 10:02:29.613'),('c3ba59bf-d6c1-4148-b9f2-a2a974828687',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20/37_w2_o1_mandibule_scan_file_0.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_BOSC_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20_MODEL','37_w2_o1_mandibule_scan_file_0.zip','c3ba59bf-d6c1-4148-b9f2-a2a974828687','{\"displayTitle\":\"Mandible 1.37.2.1.1\",\"modelMatrix\":\"0.750504,0.630495,-0.198043,0,-0.660867,0.716012,-0.224904,0,-9.30686e-09,0.299671,0.954043,0,-3.29435,-10.7037,-18.4857,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-10-19 19:30:04.000','2024-10-31 14:02:35.781','2024-10-31 10:02:35.781'),('c41ccbf2-b091-456a-af02-352476c4d367',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_955946be-5764-4c34-9e84-61682f4fdf78/occlusion_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d/scan_5de08e77-210d-48b5-8004-9c536bb8530e/33_w2_o1_mordu_posterieur_droit_scan_file_1.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_RISC_5de08e77-210d-48b5-8004-9c536bb8530e_MODEL','33_w2_o1_mordu_posterieur_droit_scan_file_1.zip','4157ac2e-557f-47f8-9c6c-3a50905de7ee','{\"displayTitle\":\"Posterior right bite 1.33.2.1.4\",\"modelMatrix\":\"0.953013,-0.286795,-0.0476122,0,0.298989,0.957868,-0.0307833,0,0.0508644,0.021764,0.998416,0,-17.7645,3.86431,-18.1842,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-08-01 15:50:53.000','2024-10-31 14:02:31.903','2024-10-31 10:02:31.903'),('c452aac6-05e7-48c3-aef6-2cb3a21d6dc4',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_ede3aa5c-bbba-4cf2-8caa-b2d5f671b311/scan_b974cde0-1037-4254-9cd8-9fcd14968091/44_w1_o2_maxillaire_scan_file_0.zip','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_ede3aa5c-bbba-4cf2-8caa-b2d5f671b311_TOSC_b974cde0-1037-4254-9cd8-9fcd14968091_MODEL','44_w1_o2_maxillaire_scan_file_0.zip','c452aac6-05e7-48c3-aef6-2cb3a21d6dc4','{\"displayTitle\":\"Maxilla 1.44.1.2.1\",\"modelMatrix\":\"0.67542,0.733978,-0.0712996,0,-0.737433,0.672256,-0.0653038,0,-3.60036e-09,0.0966862,0.995315,0,-5.22217,-17.8852,-20.4243,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-21 19:25:38.000','2024-10-31 14:02:35.247','2024-10-31 10:02:35.247'),('c4c91852-4807-43b3-8a79-23452bff9563',664,'/var/.data/2021/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_119ba34e-97cf-4c1f-bed9-20fa56366355/occlusion_585f84a0-017e-4b5a-9465-7947c2ada0b3/scan_21c82eed-acf4-4093-986f-a306c3e0c043/18_w3_o1_maxillaire_snapshot_0.png','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_119ba34e-97cf-4c1f-bed9-20fa56366355_SESS_585f84a0-017e-4b5a-9465-7947c2ada0b3_TOSC_21c82eed-acf4-4093-986f-a306c3e0c043_SNAPS','18_w3_o1_maxillaire_snapshot_0.png','c4c91852-4807-43b3-8a79-23452bff9563','{\"displayTitle\":\"Maxilla 1.18.3.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-27 19:55:44.000','2024-10-31 14:02:25.926','2024-10-31 10:02:25.926'),('c4cdf10c-734c-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/scan_55e90c19-734b-11ee-b011-58a023cda0dc/c4cdf10c-734c-11ee-b011-58a023cda0dc.zip','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_TOSC_55e90c19-734b-11ee-b011-58a023cda0dc_MODEL','c4cdf10c-734c-11ee-b011-58a023cda0dc.zip','c4cdf10c-734c-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.7.10.1.1\",\"modelMatrix\":\"-0.274572,0.896288,-0.348249,0,-0.961566,-0.255932,0.0994415,0,1.67999e-09,0.362168,0.932113,0,22.9321,-18.3261,-15.2245,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-10-25 11:59:51.000','2023-10-30 13:28:06.640','2023-10-30 09:28:06.640'),('c4ce0fdf-734c-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/scan_55e90c19-734b-11ee-b011-58a023cda0dc/c4ce0fdf-734c-11ee-b011-58a023cda0dc.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_TOSC_55e90c19-734b-11ee-b011-58a023cda0dc_SNAPS','c4ce0fdf-734c-11ee-b011-58a023cda0dc.png','c4ce0fdf-734c-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.7.10.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-10-25 11:59:52.000','2023-10-30 13:28:06.655','2023-10-30 09:28:06.655'),('c56d60f8-e5cb-4ec1-ad90-46938c46564b',664,'/var/.data/2022/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_96711d60-288c-439f-b464-597833d56519/occlusion_a98f038e-a19a-47ad-af09-a22810e9d19c/scan_790f3bda-297c-41ad-812c-c6f5b135e445/14_w3_o1_maxillaire_screenshot_c56d60f8-e5cb-4ec1-ad90-46938c46564b_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_96711d60-288c-439f-b464-597833d56519_SESS_a98f038e-a19a-47ad-af09-a22810e9d19c_TOSC_790f3bda-297c-41ad-812c-c6f5b135e445_SCREENS','14_w3_o1_maxillaire_screenshot_c56d60f8-e5cb-4ec1-ad90-46938c46564b_0.png','c56d60f8-e5cb-4ec1-ad90-46938c46564b','{\"displayTitle\":\"Screenshot 1.14.3.1.1 Maxilla 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxilla 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 14:56:35.000','2024-10-31 14:02:32.487','2024-10-31 10:02:32.487'),('c56d738a-5e39-4863-b12c-3a1317e95aaa',664,'','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_RISC_a614060b-f808-4f83-92d9-bfd877c99148_MODEL','33_w2_o1_mordu_posterieur_droit_scan_file_0.zip','c56d738a-5e39-4863-b12c-3a1317e95aaa','{\"displayTitle\":\"Posterior right bite 1.33.2.1.2\",\"modelMatrix\":\"0.99979,0.0184508,-0.00961478,0,-0.0191172,0.992964,-0.116704,0,0.00734533,0.116974,0.99312,0,-9.76559,-7.07807,-18.9275,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:08:48.000','2022-08-01 09:25:26.000','2024-10-31 14:02:31.844','2024-10-31 10:02:31.844'),('c6011a67-944d-4d49-a5fc-254bd45f74dd',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_b5dae369-a773-4095-aa54-7c8b75c939d8/occlusion_a12bd271-974e-4fcf-8893-d88105690bce/scan_e1f9f752-dd61-4e2b-82d8-016edf9173cf/7_w3_o1_maxillaire_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_b5dae369-a773-4095-aa54-7c8b75c939d8_SESS_a12bd271-974e-4fcf-8893-d88105690bce_TOSC_e1f9f752-dd61-4e2b-82d8-016edf9173cf_SNAPS','7_w3_o1_maxillaire_snapshot_0.png','c6011a67-944d-4d49-a5fc-254bd45f74dd','{\"displayTitle\":\"Maxilla 1.7.3.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-28 17:03:00.000','2024-10-31 14:02:26.524','2024-10-31 10:02:26.524'),('c62e7cb0-9118-4703-aafd-965a6c2bf6cc',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_c90ddf83-1e94-4d7c-a61f-3f7bed3aad41/occlusion_5dac735e-358c-49a1-aa52-0180d8d8ff7e/scan_7ce9b1b8-7c7b-4655-bd0d-90f37ced345e/27_w2_o1_maxillaire_scan_file_3.zip','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_c90ddf83-1e94-4d7c-a61f-3f7bed3aad41_SESS_5dac735e-358c-49a1-aa52-0180d8d8ff7e_TOSC_7ce9b1b8-7c7b-4655-bd0d-90f37ced345e_MODEL','27_w2_o1_maxillaire_scan_file_3.zip','4ee64a77-ca4c-444b-9d9f-1eaea738c404','{\"displayTitle\":\"Maxilla 1.27.2.1.1\",\"modelMatrix\":\"0.0101886,0.973994,-0.226346,0,-0.999948,0.00992414,-0.00230627,0,1.73723e-10,0.226358,0.974044,0,17.4779,-27.9775,-16.5392,1\",\"title\":\"Maxilla ZIP\"}','ZIP',3,'SYNCED',0,NULL,'2021-10-20 18:22:57.000','2024-10-31 14:02:26.806','2024-10-31 10:02:26.806'),('c6306a6c-7342-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/46c4cd1e-7338-11ee-b011-58a023cda0dc/session_ecbd4537-7341-11ee-b011-58a023cda0dc/occlusion_ecbe814b-7341-11ee-b011-58a023cda0dc/scan_59402aaf-7342-11ee-b011-58a023cda0dc/c6306a6c-7342-11ee-b011-58a023cda0dc.zip','PATIENT_46c4cd1e-7338-11ee-b011-58a023cda0dc_ACT_ecbd4537-7341-11ee-b011-58a023cda0dc_SESS_ecbe814b-7341-11ee-b011-58a023cda0dc_BOSC_59402aaf-7342-11ee-b011-58a023cda0dc_MODEL','c6306a6c-7342-11ee-b011-58a023cda0dc.zip','930bda4e-7342-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Mandible 1.54.1.1.1\",\"modelMatrix\":\"0.32589,0.911629,-0.250455,0,-0.945408,0.314247,-0.0863342,0,1.77255e-09,0.264918,0.964271,0,-15.9966,-11.556,-18.2553,1\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2023-10-25 11:27:47.000','2023-10-30 13:47:02.714','2023-10-30 09:47:02.714'),('c6307916-7342-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/46c4cd1e-7338-11ee-b011-58a023cda0dc/session_ecbd4537-7341-11ee-b011-58a023cda0dc/occlusion_ecbe814b-7341-11ee-b011-58a023cda0dc/scan_59402aaf-7342-11ee-b011-58a023cda0dc/c6307916-7342-11ee-b011-58a023cda0dc.png','PATIENT_46c4cd1e-7338-11ee-b011-58a023cda0dc_ACT_ecbd4537-7341-11ee-b011-58a023cda0dc_SESS_ecbe814b-7341-11ee-b011-58a023cda0dc_BOSC_59402aaf-7342-11ee-b011-58a023cda0dc_SNAPS','c6307916-7342-11ee-b011-58a023cda0dc.png','930be898-7342-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Mandible 1.54.1.1.1 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-10-25 11:27:49.000','2023-10-30 13:47:02.744','2023-10-30 09:47:02.744'),('c64e5e13-5ca1-465d-9908-ec7f2c19e6c1',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/occlusion_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e/scan_513ec45a-0f78-4206-8819-a95a65dd628e/49_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_LESC_513ec45a-0f78-4206-8819-a95a65dd628e_SNAPS','49_w1_o1_mordu_posterieur_gauche_snapshot_0.png','c64e5e13-5ca1-465d-9908-ec7f2c19e6c1','{\"displayTitle\":\"Posterior left bite 1.49.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-10-31 17:18:35.000','2024-10-31 14:02:35.486','2024-10-31 10:02:35.486'),('c66e3ede-9465-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/c66e3ede-9465-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_MODEL','c66e3ede-9465-11ee-8fd8-58a023cda0dc.zip','87a0d07a-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1\",\"modelMatrix\":\"0.843881,0.502692,-0.187524,0,-0.53653,0.790659,-0.294947,0,3.33011e-09,0.349512,0.936932,0,-21.678,-3.20968,-22.8257,1\",\"scanBodies\":[]}','ZIP',6,'SYNCED',0,NULL,'2023-12-06 13:32:13.678','2023-12-06 19:12:08.102','2023-12-11 10:12:06.315'),('c6890662-f4e5-4556-85ae-1a5367397a93',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_96711d60-288c-439f-b464-597833d56519/order_5197160e-6765-4f00-a914-1b83136e95ff/14_w3_couronne_prost_file_0.pdf','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_96711d60-288c-439f-b464-597833d56519_PROST_5197160e-6765-4f00-a914-1b83136e95ff_FORM','14_w3_couronne_prost_file_0.pdf','c6890662-f4e5-4556-85ae-1a5367397a93','{\"displayTitle\":\"CROWN 1.14.3.1 CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2021-04-14 16:11:44.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.798'),('c6b08692-13ab-4ffb-aa45-20461c28c3b0',664,'/var/.data/2022/664/685697a1-0d50-4a06-8b3e-729cf9750f38/session_e1d214d2-2b62-484c-8ede-86b3f84573d3/occlusion_8cd0c724-d3d0-4821-a88b-42b03ae4eb07/scan_b3dee852-769a-40d5-9c59-f651659a9d74/48_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_685697a1-0d50-4a06-8b3e-729cf9750f38_ACT_e1d214d2-2b62-484c-8ede-86b3f84573d3_SESS_8cd0c724-d3d0-4821-a88b-42b03ae4eb07_RISC_b3dee852-769a-40d5-9c59-f651659a9d74_SNAPS','48_w1_o1_mordu_posterieur_droit_snapshot_0.png','c6b08692-13ab-4ffb-aa45-20461c28c3b0','{\"displayTitle\":\"Posterior right bite 1.48.1.1.2\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-10-17 17:13:58.000','2024-10-31 14:02:35.354','2024-10-31 10:02:35.354'),('c6c988d8-32fa-4c6f-bbce-54db4f46c38b',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/order_8515ad34-77a4-41f6-a53a-5be823e2f13d/41_w1_couronne_prost_file_c6c988d8-32fa-4c6f-bbce-54db4f46c38b_1.pdf','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_PROST_8515ad34-77a4-41f6-a53a-5be823e2f13d_FORM','41_w1_couronne_prost_file_c6c988d8-32fa-4c6f-bbce-54db4f46c38b_1.pdf','7aa1b303-4eea-4bf0-85e6-2e29f68d0606','{\"displayTitle\":\"ORDER 1.41.1.1 CROWN\",\"title\":\"Couronne PDF\"}','PDF',1,'SYNCED',0,NULL,'2022-07-28 16:03:57.000','2023-05-17 17:16:39.559','2023-05-22 09:08:51.554'),('c728d7a1-0c1f-4906-a50b-630fec35bf21',664,'','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_TOSC_ded778b4-0eef-4984-8f57-77502f727676_SNAPS','41_w1_o3_maxillaire_snapshot_1.png','2b56c6fd-ec90-43d4-9a05-5032faa796d7','{\"displayTitle\":\"Maxilla 1.41.1.3.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',1,'SYNCED',0,'2023-05-22 09:06:44.000','2022-08-03 09:56:02.000','2024-10-31 14:02:32.004','2024-10-31 10:02:32.004'),('c79bcc05-9134-4911-9d18-30ba07308e7c',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/order_73b64ad8-c002-4b00-8cb0-479d3d5e1a46/33_w1_couronne_sur_implant_prost_file_c79bcc05-9134-4911-9d18-30ba07308e7c_1.pdf','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_PROST_73b64ad8-c002-4b00-8cb0-479d3d5e1a46_FORM','33_w1_couronne_sur_implant_prost_file_c79bcc05-9134-4911-9d18-30ba07308e7c_1.pdf','9893fa50-f84e-4275-9dbd-698be7666922','{\"displayTitle\":\"ORDER 1.33.1.2 IMPLANT CROWN\",\"title\":\"Couronne sur Implant PDF\"}','PDF',1,'SYNCED',0,NULL,'2022-04-14 15:15:19.000','2023-05-17 17:16:39.559','2023-05-22 09:08:52.271'),('c838fee6-1af3-43e4-b1b7-b722af25e22d',664,'/var/.data/2021/664/366ffa87-059a-436a-9125-8827b3a2da1a/session_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9/order_ce221fe3-3073-4ef0-aa97-eb8dc1eefb70/15_w1_guide_prost_file_0.pdf','PATIENT_366ffa87-059a-436a-9125-8827b3a2da1a_ACT_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9_PROST_ce221fe3-3073-4ef0-aa97-eb8dc1eefb70_FORM','15_w1_guide_prost_file_0.pdf','c838fee6-1af3-43e4-b1b7-b722af25e22d','{\"displayTitle\":\"GUIDE 1.15.1.1 GUIDE\",\"title\":\"Guide PDF\"}','PDF',0,'SYNCED',0,NULL,'2021-01-28 15:46:20.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.798'),('c87746da-76e6-42d0-aa1a-53cd19375318',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_21bbefd5-8dc0-4e41-91d8-718463ad469c/scan_316dc371-d779-45ec-913c-3647da5917c2/41_w1_o3_mordu_anterieur_scan_file_0.zip','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_FRSC_316dc371-d779-45ec-913c-3647da5917c2_MODEL','41_w1_o3_mordu_anterieur_scan_file_0.zip','c87746da-76e6-42d0-aa1a-53cd19375318','{\"displayTitle\":\"Anterior bite 1.41.1.3.1\",\"modelMatrix\":\"0.788499,-0.156349,0.585066,0,0.000874103,0.960002,0.291962,0,-0.615419,-0.233564,0.756717,0,4.4077,11.5286,-26.6119,1\",\"title\":\"Anterior bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-03 16:17:26.000','2024-10-31 14:02:32.043','2024-10-31 10:02:32.043'),('c945387d-c4d4-46ef-9e61-4c5f67a4eb30',664,'','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_705960fa-3ed4-4013-9cde-20022721d122_SESS_9f4fa7cb-81a3-460e-b189-ba76eb8cee15_TOSC_abe20329-4dfe-4eda-815d-06af022b814e_MODEL','7_w8_o1_maxillaire_scan_file_0.zip','c945387d-c4d4-46ef-9e61-4c5f67a4eb30','{\"displayTitle\":\"Maxilla 1.7.8.1.1\",\"modelMatrix\":\"0.496949,0.805686,-0.322353,0,-0.86778,0.46139,-0.184601,0,1.30663e-09,0.371469,0.928446,0,-24.314,-23.7835,-11.5253,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:08:53.000','2022-03-30 11:02:19.000','2024-10-31 14:02:28.933','2024-10-31 10:02:28.933'),('c9b5fd6b-936f-473b-820c-1d017ed47794',664,'/var/.data/2022/664/635617fc-289b-470c-a4d4-678d7b5f275a/session_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6/occlusion_94dc9a16-b72c-4f6a-a520-ba83c28954c3/scan_0760cff5-4209-42a6-8b7f-d0a749485c14/45_w1_o1_maxillaire_snapshot_1.png','PATIENT_635617fc-289b-470c-a4d4-678d7b5f275a_ACT_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6_SESS_94dc9a16-b72c-4f6a-a520-ba83c28954c3_TOSC_0760cff5-4209-42a6-8b7f-d0a749485c14_SNAPS','45_w1_o1_maxillaire_snapshot_1.png','ad7e808e-aadc-4d5b-b4af-172295eb3c6d','{\"displayTitle\":\"Maxilla 1.45.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-09-07 16:30:13.000','2024-10-31 14:02:33.317','2024-10-31 10:02:33.317'),('c9ddac1c-6c23-47b0-b0b5-f88af955cb2a',664,'','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_BOSC_5478f37b-d39e-46d1-a026-906c02d9c928_MODEL','30_w1_o1_mandibule_scan_file_2.zip','4baca937-885c-4f87-88b2-c1c5ac9e24e5','{\"displayTitle\":\"Mandible 1.30.1.1.1\",\"modelMatrix\":\"0.620001,0.77906,-0.0930822,0,-0.784601,0.615622,-0.0735547,0,-3.13584e-10,0.118636,0.992938,0,-5.08668,-9.69654,-18.7005,1\",\"title\":\"Mandible ZIP\"}','ZIP',2,'SYNCED',0,'2023-05-22 09:09:20.000','2022-03-21 10:27:50.000','2024-10-31 14:02:28.807','2024-10-31 10:02:28.807'),('ca02c680-734e-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/scan_8561d2e9-734e-11ee-b011-58a023cda0dc/ca02c680-734e-11ee-b011-58a023cda0dc.zip','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_LESC_8561d2e9-734e-11ee-b011-58a023cda0dc_MODEL','ca02c680-734e-11ee-b011-58a023cda0dc.zip','ca02c680-734e-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Left bite 1.7.10.1.1\",\"modelMatrix\":\"-0.990318,-0.0469461,0.12713,0,0.0668496,-0.99297,0.101868,0,0.121848,0.108856,0.986642,0,5.59922,-4.04179,-18.3143,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-10-25 11:59:58.000','2023-10-30 13:28:06.672','2023-10-30 09:28:06.672'),('ca02d758-734e-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/scan_8561d2e9-734e-11ee-b011-58a023cda0dc/ca02d758-734e-11ee-b011-58a023cda0dc.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_LESC_8561d2e9-734e-11ee-b011-58a023cda0dc_SNAPS','ca02d758-734e-11ee-b011-58a023cda0dc.png','ca02d758-734e-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Left bite 1.7.10.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-10-25 11:59:59.000','2023-10-30 13:28:06.687','2023-10-30 09:28:06.687'),('ca096ce2-28fc-48e7-ac12-8bc56ab4e9d5',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_3ce0c78e-551a-4871-80c4-435836bf1dc5/32_w1_o1_mandibule_screenshot_ca096ce2-28fc-48e7-ac12-8bc56ab4e9d5_0.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_BOSC_3ce0c78e-551a-4871-80c4-435836bf1dc5_SCREENS','32_w1_o1_mandibule_screenshot_ca096ce2-28fc-48e7-ac12-8bc56ab4e9d5_0.png','ca096ce2-28fc-48e7-ac12-8bc56ab4e9d5','{\"displayTitle\":\"Screenshot 1.32.1.1.1 Mandible 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Mandible 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:07:24.000','2024-10-31 14:02:32.905','2024-10-31 10:02:32.905'),('cb02b0b7-9fd2-47f3-a4d9-9b064252bc24',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_92704e83-dce3-4695-baad-1df750f09cd7/37_w2_o2_mandibule_mlmeta_0_1.bin','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_LIFIM','37_w2_o2_mandibule_mlmeta_0_1.bin','130024ea-36bf-439a-980c-e464701bd4fb','{\"displayTitle\":\"Margin line Mandible 1.37.2.2.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2022-11-09 17:04:53.000','2024-10-31 14:02:36.117','2024-10-31 10:02:36.117'),('cb1b65f0-2177-44a8-94e5-dd318f6e2f98',664,'','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_BOSC_a0b85a0a-ef77-4f7c-b376-d6e388afe9f0_LIFIM','10_w1_o1_mandibule_mlmeta_1_0.bin','cb1b65f0-2177-44a8-94e5-dd318f6e2f98','{\"displayTitle\":\"Margin line Mandible 1.10.1.1.1 No name 1\",\"name\":\"No name 1\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":1}','BIN',0,'SYNCED',0,'2023-05-22 09:08:54.000','2020-07-03 10:42:10.000','2024-10-31 14:02:32.319','2024-10-31 10:02:32.319'),('cb6e4826-4b7c-4db6-9cd0-94212f7b6703',664,'/var/.data/2022/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_96711d60-288c-439f-b464-597833d56519/occlusion_a98f038e-a19a-47ad-af09-a22810e9d19c/scan_86e16909-3b39-4591-8c03-0e4eba17f0ff/14_w3_o1_mordu_posterieur_droit_screenshot_cb6e4826-4b7c-4db6-9cd0-94212f7b6703_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_96711d60-288c-439f-b464-597833d56519_SESS_a98f038e-a19a-47ad-af09-a22810e9d19c_RISC_86e16909-3b39-4591-8c03-0e4eba17f0ff_SCREENS','14_w3_o1_mordu_posterieur_droit_screenshot_cb6e4826-4b7c-4db6-9cd0-94212f7b6703_0.png','cb6e4826-4b7c-4db6-9cd0-94212f7b6703','{\"displayTitle\":\"Screenshot 1.14.3.1.1 Posterior right bite 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Posterior right bite 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 14:56:54.000','2024-10-31 14:02:32.536','2024-10-31 10:02:32.536'),('cb769c4e-772a-11ee-867e-58a023cda0dc',664,'/var/.data/2023/664/46c4cd1e-7338-11ee-b011-58a023cda0dc/session_ecbd4537-7341-11ee-b011-58a023cda0dc/order_0ec89083-772a-11ee-867e-58a023cda0dc/cb769c4e-772a-11ee-867e-58a023cda0dc.pdf','PATIENT_46c4cd1e-7338-11ee-b011-58a023cda0dc_ACT_ecbd4537-7341-11ee-b011-58a023cda0dc_PROST_0ec89083-772a-11ee-867e-58a023cda0dc_FORM','cb769c4e-772a-11ee-867e-58a023cda0dc.pdf','cb769c4e-772a-11ee-867e-58a023cda0dc','{\"displayTitle\":\"Order 1.54.1.1 implant crown\",\"title\":\"implant crown\"}','PDF',0,'SYNCED',0,NULL,'2023-10-30 09:46:59.000','2023-10-30 13:47:02.759','2023-10-30 09:47:02.759'),('cb794354-96b6-463a-a735-215a2367d35f',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_92704e83-dce3-4695-baad-1df750f09cd7/37_w2_o2_mandibule_scan_file_0.zip','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_MODEL','37_w2_o2_mandibule_scan_file_0.zip','cb794354-96b6-463a-a735-215a2367d35f','{\"displayTitle\":\"Mandible 1.37.2.2.1\",\"modelMatrix\":\"0.841802,0.477097,-0.252482,0,-0.539786,0.744038,-0.393749,0,-9.45422e-09,0.467745,0.883863,0,-11.1222,-12.9995,-20.7717,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-09 15:55:23.000','2024-10-31 14:02:36.012','2024-10-31 10:02:36.012'),('cb94779c-19a4-4878-a144-6b913d80c161',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_416dd268-693a-4466-8380-8829fc1b5e3d/24_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_RISC_416dd268-693a-4466-8380-8829fc1b5e3d_SNAPS','24_w1_o1_mordu_posterieur_droit_snapshot_0.png','cb94779c-19a4-4878-a144-6b913d80c161','{\"displayTitle\":\"Posterior right bite 1.24.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-13 21:27:32.000','2024-10-31 14:02:28.639','2024-10-31 10:02:28.639'),('cba0f817-6c67-4486-a5a5-2e40973bf3af',664,'/var/.data/2021/664/366ffa87-059a-436a-9125-8827b3a2da1a/session_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9/occlusion_a59f40f9-2208-4d6a-b286-f64533d92e3c/scan_056c711b-f9d5-4a04-93e2-9015a27c4b1b/15_w1_o1_maxillaire_snapshot_0.png','PATIENT_366ffa87-059a-436a-9125-8827b3a2da1a_ACT_c6b2dd58-ecd5-402a-9167-ae99aef2b1c9_SESS_a59f40f9-2208-4d6a-b286-f64533d92e3c_TOSC_056c711b-f9d5-4a04-93e2-9015a27c4b1b_SNAPS','15_w1_o1_maxillaire_snapshot_0.png','cba0f817-6c67-4486-a5a5-2e40973bf3af','{\"displayTitle\":\"Maxilla 1.15.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-01-18 21:27:55.000','2024-10-31 14:02:25.812','2024-10-31 10:02:25.812'),('cba5993b-d655-4256-a986-c921c6159435',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368/32_w1_o1_mordu_posterieur_gauche_snapshot_1.png','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_LESC_8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368_SNAPS','32_w1_o1_mordu_posterieur_gauche_snapshot_1.png','038a356c-cfd5-42a7-b2bc-6d94ebccde52','{\"displayTitle\":\"Posterior left bite 1.32.1.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-03-23 16:42:17.000','2024-10-31 14:02:32.986','2024-10-31 10:02:32.986'),('cc11802a-1512-4adc-a5b0-52572343c7b1',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/occlusion_e930782a-e2db-43e8-9ff1-9feb64e20e4e/scan_1642c8fb-5963-4064-9b58-acef4374ce2b/35_w1_o1_maxillaire_snapshot_0.png','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_TOSC_1642c8fb-5963-4064-9b58-acef4374ce2b_SNAPS','35_w1_o1_maxillaire_snapshot_0.png','cc11802a-1512-4adc-a5b0-52572343c7b1','{\"displayTitle\":\"Maxilla 1.35.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-06 19:58:20.000','2024-10-31 14:02:29.528','2024-10-31 10:02:29.528'),('cc17514d-dd52-4b75-b524-fe6d1ad21101',664,'/var/.data/2021/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_a72c11a4-05dc-4421-b252-fbfcecd2559e/occlusion_bf823edb-92ee-4ee9-acd3-507d49bad781/scan_088e0b86-45b9-4da8-a5e2-291e2939c699/14_w1_o1_maxillaire_snapshot_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_a72c11a4-05dc-4421-b252-fbfcecd2559e_SESS_bf823edb-92ee-4ee9-acd3-507d49bad781_TOSC_088e0b86-45b9-4da8-a5e2-291e2939c699_SNAPS','14_w1_o1_maxillaire_snapshot_0.png','cc17514d-dd52-4b75-b524-fe6d1ad21101','{\"displayTitle\":\"Maxilla 1.14.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-09-09 15:30:55.000','2024-10-31 14:02:32.698','2024-10-31 10:02:32.698'),('cc27a307-0265-442d-8bc3-6ac3b71acd67',664,'/var/.data/2022/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_a72c11a4-05dc-4421-b252-fbfcecd2559e/occlusion_bf823edb-92ee-4ee9-acd3-507d49bad781/scan_98f6c3db-f007-4f0d-a724-a372751a6d75/14_w1_o1_mandibule_screenshot_cc27a307-0265-442d-8bc3-6ac3b71acd67_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_a72c11a4-05dc-4421-b252-fbfcecd2559e_SESS_bf823edb-92ee-4ee9-acd3-507d49bad781_BOSC_98f6c3db-f007-4f0d-a724-a372751a6d75_SCREENS','14_w1_o1_mandibule_screenshot_cc27a307-0265-442d-8bc3-6ac3b71acd67_0.png','cc27a307-0265-442d-8bc3-6ac3b71acd67','{\"displayTitle\":\"Screenshot 1.14.1.1.1 Mandible 2\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Mandible 2\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:02:17.000','2024-10-31 14:02:32.621','2024-10-31 10:02:32.621'),('cc466fbd-fba9-4bc1-949e-c9242dc1dd4f',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_26288707-da63-4165-bfdb-8a6c299bcb2b/scan_c06a5cff-eff6-47da-bc1a-c815235abec3/33_w1_o2_mordu_posterieur_gauche_snapshot_0.png','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_26288707-da63-4165-bfdb-8a6c299bcb2b_LESC_c06a5cff-eff6-47da-bc1a-c815235abec3_SNAPS','33_w1_o2_mordu_posterieur_gauche_snapshot_0.png','cc466fbd-fba9-4bc1-949e-c9242dc1dd4f','{\"displayTitle\":\"Posterior left bite 1.33.1.2.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-04-11 17:26:39.000','2024-10-31 14:02:29.178','2024-10-31 10:02:29.178'),('cc91b497-351a-4c6c-b7da-ea25dc95fd0a',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_4fa51169-865e-4214-93fb-b93ba08fd9d3/occlusion_a2816a91-70d4-492e-af69-b69e3c134704/scan_7f9b3767-26d0-40f2-b0dd-07da9d57ad85/7_w5_o1_maxillaire_snapshot_1.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_4fa51169-865e-4214-93fb-b93ba08fd9d3_SESS_a2816a91-70d4-492e-af69-b69e3c134704_TOSC_7f9b3767-26d0-40f2-b0dd-07da9d57ad85_SNAPS','7_w5_o1_maxillaire_snapshot_1.png','66fd1060-c3ed-464a-9c7e-950a0d2ba8f4','{\"displayTitle\":\"Maxilla 1.7.5.1.2\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-05-03 20:49:25.000','2024-10-31 14:02:26.468','2024-10-31 10:02:26.468'),('ccbcf45f-51df-46cb-aa4d-44d48924646f',664,'','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_BOSC_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20_LIFIM','37_w2_o1_mandibule_mlmeta_0_0.bin','ccbcf45f-51df-46cb-aa4d-44d48924646f','{\"displayTitle\":\"Margin line Mandible 1.37.2.1.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2023-05-22 09:08:57.000','2022-11-02 14:29:57.000','2024-10-31 14:02:35.804','2024-10-31 10:02:35.804'),('ccfc256c-f67b-43e6-859d-78f6db34fd4b',664,'/var/.data/2022/664/4b4f3002-bba6-481f-a9fb-41ab2fedd61c/session_d592e356-eafe-46a1-8e61-9a886a79e1de/occlusion_d7b86e87-0261-4bc1-8529-76e0bdd29195/scan_09b06474-154e-4302-9e89-9d9e6fcb8cfa/18_w4_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_4b4f3002-bba6-481f-a9fb-41ab2fedd61c_ACT_d592e356-eafe-46a1-8e61-9a886a79e1de_SESS_d7b86e87-0261-4bc1-8529-76e0bdd29195_RISC_09b06474-154e-4302-9e89-9d9e6fcb8cfa_MODEL','18_w4_o1_mordu_posterieur_droit_scan_file_0.zip','ccfc256c-f67b-43e6-859d-78f6db34fd4b','{\"displayTitle\":\"Posterior right bite 1.18.4.1.1\",\"modelMatrix\":\"0.962961,-0.0209692,0.267261,0,0.0178684,0.99915,-0.0316466,0,-0.269348,0.0376387,0.963108,0,-14.2979,-2.30406,-25.4881,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-24 16:33:58.000','2023-05-22 13:09:23.167','2023-05-22 09:09:23.167'),('cd6dafb5-01b1-4b6c-955d-9c6344bc8edc',664,'','PATIENT_59179996-dc1e-4b4c-b9fd-92c78aa1dde0_ACT_df905f94-03ea-4868-82d7-960568f5cab7_SESS_88c76352-cde4-4fcb-a264-c6cd5cb1e44f_TOSC_51d672de-5db0-4925-8908-13042e3aacea_MODEL','','cd6dafb5-01b1-4b6c-955d-9c6344bc8edc','{\"displayTitle\":\"Maxilla 1.40.1.1.1\",\"modelMatrix\":\"0.806859,-0.589968,0.0302755,0,0.590744,0.805799,-0.0413513,0,1.95571e-09,0.0512497,0.998686,0,1.80618,15.2222,-21.61,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'CREATED',0,'2022-07-18 16:51:00.000','2022-07-18 16:44:33.000','2023-05-17 17:16:39.559',NULL),('cdf831d0-b5ce-4895-a210-3c3dd2b164ec',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_ef2b4fcf-f21c-418d-942a-c99ea96efbdb/occlusion_7d36e059-dbc3-46b0-931a-bdf8fdc805c6/scan_a6208834-50bc-4a6d-9646-4220f7dbfeeb/7_w2_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_ef2b4fcf-f21c-418d-942a-c99ea96efbdb_SESS_7d36e059-dbc3-46b0-931a-bdf8fdc805c6_LESC_a6208834-50bc-4a6d-9646-4220f7dbfeeb_SNAPS','7_w2_o1_mordu_posterieur_gauche_snapshot_0.png','cdf831d0-b5ce-4895-a210-3c3dd2b164ec','{\"displayTitle\":\"Posterior left bite 1.7.2.1.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-21 16:29:16.000','2024-10-31 14:02:26.313','2024-10-31 10:02:26.313'),('ce3b2d45-df06-466e-8d53-72fb4fe941b8',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/occlusion_cacc103c-8b88-4be5-a787-b6b92341e9eb/scan_bb241051-9343-4a9a-9282-a960e0748f3e/34_w1_o1_maxillaire_scan_file_2.zip','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_SESS_cacc103c-8b88-4be5-a787-b6b92341e9eb_TOSC_bb241051-9343-4a9a-9282-a960e0748f3e_MODEL','34_w1_o1_maxillaire_scan_file_2.zip','43ec56d4-c1b3-4a5d-a33a-61909d689853','{\"displayTitle\":\"Maxilla 1.34.1.1.2\",\"modelMatrix\":\"-0.88574,0.460372,-0.0593499,0,-0.464182,-0.87847,0.11325,0,-2.95308e-09,0.127859,0.991792,0,-8.3138,-4.32972,-21.3507,1\",\"title\":\"Maxilla ZIP\"}','ZIP',2,'SYNCED',0,NULL,'2022-05-25 18:31:48.000','2024-10-31 14:02:29.430','2024-10-31 10:02:29.430'),('ceac08e6-6c36-11ee-bc7f-58a023cda0dc',664,'/var/.data/2023/664/bbc77872-6c30-11ee-bc7f-58a023cda0dc/session_0a963705-6c31-11ee-bc7f-58a023cda0dc/occlusion_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc/scan_a1d7f6b9-6c36-11ee-bc7f-58a023cda0dc/ceac08e6-6c36-11ee-bc7f-58a023cda0dc.zip','PATIENT_bbc77872-6c30-11ee-bc7f-58a023cda0dc_ACT_0a963705-6c31-11ee-bc7f-58a023cda0dc_SESS_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc_RISC_a1d7f6b9-6c36-11ee-bc7f-58a023cda0dc_MODEL','ceac08e6-6c36-11ee-bc7f-58a023cda0dc.zip','ceac08e6-6c36-11ee-bc7f-58a023cda0dc','{\"displayTitle\":\"Right bite 1.53.1.1.1\",\"modelMatrix\":\"0.829833,0.0673172,0.551642,0,-0.0528322,0.996779,-0.0756957,0,-0.556055,0.0502381,0.830646,0,-7.41753,-2.13601,-32.5654,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-10-16 13:05:24.000','2023-10-16 17:12:49.393','2023-10-16 13:12:49.393'),('ceac18ef-6c36-11ee-bc7f-58a023cda0dc',664,'/var/.data/2023/664/bbc77872-6c30-11ee-bc7f-58a023cda0dc/session_0a963705-6c31-11ee-bc7f-58a023cda0dc/occlusion_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc/scan_a1d7f6b9-6c36-11ee-bc7f-58a023cda0dc/ceac18ef-6c36-11ee-bc7f-58a023cda0dc.png','PATIENT_bbc77872-6c30-11ee-bc7f-58a023cda0dc_ACT_0a963705-6c31-11ee-bc7f-58a023cda0dc_SESS_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc_RISC_a1d7f6b9-6c36-11ee-bc7f-58a023cda0dc_SNAPS','ceac18ef-6c36-11ee-bc7f-58a023cda0dc.png','ceac18ef-6c36-11ee-bc7f-58a023cda0dc','{\"displayTitle\":\"Right bite 1.53.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-10-16 13:05:25.000','2023-10-16 17:12:49.408','2023-10-16 13:12:49.408'),('cf55af4f-6f13-40b8-8ac4-8ef9f3d0c140',664,'/var/.data/2022/664/635617fc-289b-470c-a4d4-678d7b5f275a/session_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6/occlusion_94dc9a16-b72c-4f6a-a520-ba83c28954c3/scan_6f12cbab-9aee-4057-bc58-bb6f63974204/45_w1_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_635617fc-289b-470c-a4d4-678d7b5f275a_ACT_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6_SESS_94dc9a16-b72c-4f6a-a520-ba83c28954c3_RISC_6f12cbab-9aee-4057-bc58-bb6f63974204_MODEL','45_w1_o1_mordu_posterieur_droit_scan_file_0.zip','cf55af4f-6f13-40b8-8ac4-8ef9f3d0c140','{\"displayTitle\":\"Posterior right bite 1.45.1.1.1\",\"modelMatrix\":\"0.953143,0.142628,0.265282,0,-0.114278,0.983485,-0.142411,0,-0.28022,0.111781,0.953607,0,-8.04951,-9.51969,-21.6615,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-07 16:39:43.000','2024-10-31 14:02:35.097','2024-10-31 10:02:35.097'),('cfd3ae4f-746d-45ea-8e9c-5628349609fd',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_20f1e04b-48d2-4b9a-b29b-2a62332288fb/24_w1_o1_mordu_anterieur_scan_file_0.ply','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_FRSC_20f1e04b-48d2-4b9a-b29b-2a62332288fb_MODEL','24_w1_o1_mordu_anterieur_scan_file_0.ply','cfd3ae4f-746d-45ea-8e9c-5628349609fd','{\"displayTitle\":\"Anterior bite 1.24.1.1.1\",\"modelMatrix\":\"0.987167,0.140381,0.0443227,0,-0.151269,0.935758,0.378594,0,0.121151,-0.331126,0.931456,0,-5.18119,1.8991,-24.5026,1\",\"title\":\"Anterior bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-13 21:30:59.000','2024-10-31 14:02:28.619','2024-10-31 10:02:28.619'),('d009bbe4-4f33-47fd-99e6-d180ee49e211',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_db740293-ae2a-40ae-9142-4d94ed66bcd5/occlusion_1256ab02-5172-4a92-a17d-f2fc402290ac/scan_b6033058-40f5-4202-bc4b-bfe024d70e70/7_w6_o1_maxillaire_scan_file_1.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_db740293-ae2a-40ae-9142-4d94ed66bcd5_SESS_1256ab02-5172-4a92-a17d-f2fc402290ac_TOSC_b6033058-40f5-4202-bc4b-bfe024d70e70_MODEL','7_w6_o1_maxillaire_scan_file_1.ply','579610fb-1842-4dc6-8b36-ab5b5f876866','{\"displayTitle\":\"Maxilla 1.7.6.1.4\",\"modelMatrix\":\"-0.962114,0.115536,-0.246957,0,-0.272647,-0.407703,0.87146,0,-6.18516e-9,0.905776,0.423757,0,8.73707,-40.6454,-6.68016,1\",\"title\":\"Maxilla PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-05-05 16:27:02.000','2024-10-31 14:02:26.409','2024-10-31 10:02:26.409'),('d0bcb772-695a-4912-a5a9-77dd0eb49a1a',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/occlusion_e930782a-e2db-43e8-9ff1-9feb64e20e4e/scan_1642c8fb-5963-4064-9b58-acef4374ce2b/35_w1_o1_maxillaire_scan_file_1.zip','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_TOSC_1642c8fb-5963-4064-9b58-acef4374ce2b_MODEL','35_w1_o1_maxillaire_scan_file_1.zip','9963e44b-40c3-4e29-8123-4685327fc471','{\"displayTitle\":\"Maxilla 1.35.1.1.1\",\"modelMatrix\":\"-0.911189,0.226333,-0.344249,0,-0.411988,-0.500578,0.761372,0,-3.35172e-09,0.835581,0.549367,0,-3.38048,-30.5757,-9.58027,1\",\"title\":\"Maxilla ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-06-06 20:35:20.000','2024-10-31 14:02:29.542','2024-10-31 10:02:29.542'),('d14252ac-1de7-4afa-a650-24dd6f3844fd',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/order_d219a550-45e6-4d34-9392-643202050e04/49_w1_couronne_sur_implant_prost_file_d14252ac-1de7-4afa-a650-24dd6f3844fd_0.pdf','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_PROST_d219a550-45e6-4d34-9392-643202050e04_FORM','49_w1_couronne_sur_implant_prost_file_d14252ac-1de7-4afa-a650-24dd6f3844fd_0.pdf','d14252ac-1de7-4afa-a650-24dd6f3844fd','{\"displayTitle\":\"ORDER 1.49.1.4 IMPLANT CROWN (Carol Hicks)\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'CREATED',0,NULL,'2022-11-18 20:33:40.000','2023-05-17 17:16:39.559',NULL),('d172973d-e407-4b2d-a3d4-a9faaa303da6',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_48ff9245-20c5-4364-a092-18eafb8024d3/scan_13a263f2-8a0a-409b-a3c1-f2ddb5f6a466/10_w1_o2_mordu_posterieur_droit_snapshot_0.png','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_48ff9245-20c5-4364-a092-18eafb8024d3_RISC_13a263f2-8a0a-409b-a3c1-f2ddb5f6a466_SNAPS','10_w1_o2_mordu_posterieur_droit_snapshot_0.png','d172973d-e407-4b2d-a3d4-a9faaa303da6','{\"displayTitle\":\"Posterior right bite 1.10.1.2.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-09-16 19:08:14.000','2024-10-31 14:02:25.668','2024-10-31 10:02:25.668'),('d1a427ba-93d4-43ec-8aa4-63fffdae261c',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_b25ea321-53b4-414b-b4c4-e5adcac56ba8/occlusion_13883510-ca59-4fdd-8bbd-216ef177542a/scan_7d87c990-cfc0-487a-bd48-674f0ba32da1/27_w1_o1_mandibule_scan_file_2.zip','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_b25ea321-53b4-414b-b4c4-e5adcac56ba8_SESS_13883510-ca59-4fdd-8bbd-216ef177542a_BOSC_7d87c990-cfc0-487a-bd48-674f0ba32da1_MODEL','27_w1_o1_mandibule_scan_file_2.zip','3119c4df-3760-4f4f-9247-8c1f5f4d8d43','{\"displayTitle\":\"Mandible 1.27.1.1.1\",\"modelMatrix\":\"0.898543,0.410622,-0.154952,0,-0.438885,0.840678,-0.317237,0,1.20127e-8,0.353057,0.935602,0,-26.9978,-1.85321,-17.654,1\",\"title\":\"Mandible ZIP\"}','ZIP',2,'SYNCED',0,NULL,'2021-10-04 19:00:49.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.263'),('d1d17c7c-fe5f-4080-bd9f-c15fd4390666',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_ef2b4fcf-f21c-418d-942a-c99ea96efbdb/occlusion_7d36e059-dbc3-46b0-931a-bdf8fdc805c6/scan_d2853a7d-9edf-4ac8-aeaa-d186ea3a6553/7_w2_o1_mordu_anterieur_scan_file_0.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_ef2b4fcf-f21c-418d-942a-c99ea96efbdb_SESS_7d36e059-dbc3-46b0-931a-bdf8fdc805c6_FRSC_d2853a7d-9edf-4ac8-aeaa-d186ea3a6553_MODEL','7_w2_o1_mordu_anterieur_scan_file_0.ply','d1d17c7c-fe5f-4080-bd9f-c15fd4390666','{\"displayTitle\":\"Anterior bite 1.7.2.1.1\",\"modelMatrix\":\"0.722101,-0.0846395,0.684524,0,-0.10051,0.965264,0.231036,0,-0.684544,-0.24752,0.691442,0,2.18285,7.93528,-25.6119,1\",\"title\":\"Anterior bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-21 16:32:10.000','2024-10-31 14:02:26.330','2024-10-31 10:02:26.330'),('d1d93eeb-e9b4-4246-b371-97194de11bf1',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_344acade-9e53-43df-a580-c61498c3b57a/occlusion_6861b877-a2a9-413b-a002-89eb317aa99f/scan_96e07cef-c402-4c22-8ab7-f63fa9dd08a0/7_w4_o1_maxillaire_scan_file_0.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_344acade-9e53-43df-a580-c61498c3b57a_SESS_6861b877-a2a9-413b-a002-89eb317aa99f_TOSC_96e07cef-c402-4c22-8ab7-f63fa9dd08a0_MODEL','7_w4_o1_maxillaire_scan_file_0.ply','d1d93eeb-e9b4-4246-b371-97194de11bf1','{\"displayTitle\":\"Maxilla 1.7.4.1.1\",\"modelMatrix\":\"0.763733,-0.526375,0.373688,0,0.645533,0.622756,-0.442111,0,-5.7768e-9,0.578882,0.815411,0,-11.6611,-44.7504,-39.0283,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-05-03 19:42:37.000','2024-10-31 14:02:26.717','2024-10-31 10:02:26.717'),('d209ac69-fa89-4893-8e85-fde8f654efc3',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/occlusion_cacc103c-8b88-4be5-a787-b6b92341e9eb/scan_912aed9d-90da-48c3-b2d2-60c29e2eb2a2/34_w1_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_SESS_cacc103c-8b88-4be5-a787-b6b92341e9eb_RISC_912aed9d-90da-48c3-b2d2-60c29e2eb2a2_MODEL','34_w1_o1_mordu_posterieur_droit_scan_file_0.zip','d209ac69-fa89-4893-8e85-fde8f654efc3','{\"displayTitle\":\"Posterior right bite 1.34.1.1.1\",\"modelMatrix\":\"0.99602,0.0933387,0.0125382,0,-0.0889556,0.992875,0.0779811,0,-0.00795829,-0.0743883,0.996889,0,-3.77226,3.49496,-16.5685,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-05-25 17:59:41.000','2024-10-31 14:02:29.291','2024-10-31 10:02:29.291'),('d25c751c-c80f-4b38-a10e-8bd824d9720c',664,'','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_4fa51169-865e-4214-93fb-b93ba08fd9d3_SESS_a2816a91-70d4-492e-af69-b69e3c134704_TOSC_a6f3b498-07ce-489a-805c-c6bc2ac7d0d9_MODEL','','d25c751c-c80f-4b38-a10e-8bd824d9720c','{\"displayTitle\":\"Maxilla 1.7.5.1.1\",\"modelMatrix\":\"0.941549,-0.143967,0.304563,0,0.336876,0.402379,-0.851238,0,1.12988e-8,0.904082,0.427358,0,2.58975,-43.6313,-9.68834,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'CREATED',0,'2021-05-03 20:20:02.000','2021-05-03 20:18:48.000','2023-05-17 17:16:39.559',NULL),('d2f8de35-8642-4645-8e3b-6fc1e801fc7f',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_6f4cc2d8-2239-4982-a8b0-33dc6be535ae/21_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_LESC_6f4cc2d8-2239-4982-a8b0-33dc6be535ae_MODEL','21_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','d2f8de35-8642-4645-8e3b-6fc1e801fc7f','{\"displayTitle\":\"Posterior left bite 1.21.1.1.1\",\"modelMatrix\":\"-0.956826,0.17963,0.227404,0,-0.166481,-0.982009,0.0934685,0,0.238336,0.0588245,0.969326,0,15.8483,-5.35175,-22.4164,1\",\"title\":\"Posterior left bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-28 18:58:51.000','2024-10-31 14:02:25.992','2024-10-31 10:02:25.992'),('d2fe3cb8-fcf4-445e-af4a-b2a448199d6b',664,'/var/.data/2022/664/b2146fed-f67d-47a9-b610-c63d840d0a2d/session_a72c11a4-05dc-4421-b252-fbfcecd2559e/occlusion_bf823edb-92ee-4ee9-acd3-507d49bad781/scan_98f6c3db-f007-4f0d-a724-a372751a6d75/14_w1_o1_mandibule_screenshot_d2fe3cb8-fcf4-445e-af4a-b2a448199d6b_0.png','PATIENT_b2146fed-f67d-47a9-b610-c63d840d0a2d_ACT_a72c11a4-05dc-4421-b252-fbfcecd2559e_SESS_bf823edb-92ee-4ee9-acd3-507d49bad781_BOSC_98f6c3db-f007-4f0d-a724-a372751a6d75_SCREENS','14_w1_o1_mandibule_screenshot_d2fe3cb8-fcf4-445e-af4a-b2a448199d6b_0.png','d2fe3cb8-fcf4-445e-af4a-b2a448199d6b','{\"displayTitle\":\"Screenshot 1.14.1.1.1 Mandible 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Mandible 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:02:23.000','2024-10-31 14:02:32.633','2024-10-31 10:02:32.633'),('d31fff53-e769-4756-bc68-5aeea0d528b5',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_db740293-ae2a-40ae-9142-4d94ed66bcd5/occlusion_1256ab02-5172-4a92-a17d-f2fc402290ac/scan_b6033058-40f5-4202-bc4b-bfe024d70e70/7_w6_o1_maxillaire_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_db740293-ae2a-40ae-9142-4d94ed66bcd5_SESS_1256ab02-5172-4a92-a17d-f2fc402290ac_TOSC_b6033058-40f5-4202-bc4b-bfe024d70e70_SNAPS','7_w6_o1_maxillaire_snapshot_0.png','d31fff53-e769-4756-bc68-5aeea0d528b5','{\"displayTitle\":\"Maxilla 1.7.6.1.4\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-05-05 16:23:13.000','2024-10-31 14:02:26.353','2024-10-31 10:02:26.353'),('d3a6ed76-d8dc-47e6-ae66-239731164381',664,'/var/.data/2022/664/48a38618-e853-4bf0-aa6b-4c83fb8b6f13/session_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d/occlusion_540d878b-7415-4498-8c6c-01875eec35f8/scan_33332418-f712-49fd-833e-f2b6ad37b61e/38_w1_o1_maxillaire_scan_file_0.zip','PATIENT_48a38618-e853-4bf0-aa6b-4c83fb8b6f13_ACT_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d_SESS_540d878b-7415-4498-8c6c-01875eec35f8_TOSC_33332418-f712-49fd-833e-f2b6ad37b61e_MODEL','38_w1_o1_maxillaire_scan_file_0.zip','d3a6ed76-d8dc-47e6-ae66-239731164381','{\"displayTitle\":\"Maxilla 1.38.1.1.1\",\"modelMatrix\":\"0.761349,0.624566,-0.173967,0,-0.648342,0.733429,-0.20429,0,-4.16357e-09,0.268326,0.963328,0,-9.51946,-13.7642,-22.5341,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-22 16:39:40.000','2024-10-31 14:02:29.820','2024-10-31 10:02:29.820'),('d3c2fb35-0aff-4775-8c47-8085c2bb4a6c',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_7d40798f-7207-4c33-aa42-10afc814de77/scan_a0b85a0a-ef77-4f7c-b376-d6e388afe9f0/10_w1_o1_mandibule_snapshot_0.png','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_BOSC_a0b85a0a-ef77-4f7c-b376-d6e388afe9f0_SNAPS','10_w1_o1_mandibule_snapshot_0.png','d3c2fb35-0aff-4775-8c47-8085c2bb4a6c','{\"displayTitle\":\"Mandible 1.10.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-06-29 20:07:52.000','2024-10-31 14:02:32.327','2024-10-31 10:02:32.327'),('d40bfa65-9465-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_87132a5c-9464-11ee-8fd8-58a023cda0dc/d40bfa65-9465-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_BOSC_87132a5c-9464-11ee-8fd8-58a023cda0dc_MODEL','d40bfa65-9465-11ee-8fd8-58a023cda0dc.zip','87a0d07a-9465-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Mandible 1.55.1.1.1\",\"modelMatrix\":\"0.843881,0.502692,-0.187524,0,-0.53653,0.790659,-0.294947,0,3.33011e-09,0.349512,0.936932,0,-21.678,-3.20968,-22.8257,1\",\"scanBodies\":[]}','ZIP',7,'SYNCED',0,NULL,'2023-12-06 13:32:36.522','2023-12-06 19:12:08.102','2023-12-11 10:12:08.822'),('d44f76c2-8604-4bbd-a847-285c5b0d09fc',664,'','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_BOSC_5478f37b-d39e-46d1-a026-906c02d9c928_SNAPS','30_w1_o1_mandibule_snapshot_2.png','991b6bf3-db84-4e38-b3ca-2e1d37a170c0','{\"displayTitle\":\"Mandible 1.30.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',2,'SYNCED',0,'2023-05-22 09:07:43.000','2022-03-21 10:29:52.000','2024-10-31 14:02:28.817','2024-10-31 10:02:28.817'),('d46395de-c663-445e-93b7-6b0eef50a5d7',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_ede3aa5c-bbba-4cf2-8caa-b2d5f671b311/scan_760aa563-6e6f-4ae3-98cc-e3d5350a517e/44_w1_o2_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_ede3aa5c-bbba-4cf2-8caa-b2d5f671b311_LESC_760aa563-6e6f-4ae3-98cc-e3d5350a517e_MODEL','44_w1_o2_mordu_posterieur_gauche_scan_file_0.zip','d46395de-c663-445e-93b7-6b0eef50a5d7','{\"displayTitle\":\"Posterior left bite 1.44.1.2.1\",\"modelMatrix\":\"-0.989527,-0.138095,0.0458312,0,0.14074,-0.98477,0.102761,0,0.0321141,0.10567,0.993653,0,18.9608,-0.722091,-18.187,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-21 19:25:38.000','2024-10-31 14:02:35.212','2024-10-31 10:02:35.212'),('d69f7757-7418-40a0-93ba-f0daeab65592',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/order_a91f29b5-c999-4d0b-90cf-4ff0df6707c8/37_w2_couronne_prost_file_d69f7757-7418-40a0-93ba-f0daeab65592_0.pdf','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_PROST_a91f29b5-c999-4d0b-90cf-4ff0df6707c8_FORM','37_w2_couronne_prost_file_d69f7757-7418-40a0-93ba-f0daeab65592_0.pdf','d69f7757-7418-40a0-93ba-f0daeab65592','{\"displayTitle\":\"ORDER 1.37.2.5 Elisabeth Baxter REDO CROWN\",\"title\":\"Couronne PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-11-09 17:12:15.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.259'),('d6c21fa2-43a3-46ad-8b9a-3f2b83d486d1',664,'/var/.data/2022/664/48a38618-e853-4bf0-aa6b-4c83fb8b6f13/session_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d/occlusion_540d878b-7415-4498-8c6c-01875eec35f8/scan_e145920a-617c-4eab-b810-0a863371eb36/38_w1_o1_mandibule_snapshot_0.png','PATIENT_48a38618-e853-4bf0-aa6b-4c83fb8b6f13_ACT_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d_SESS_540d878b-7415-4498-8c6c-01875eec35f8_BOSC_e145920a-617c-4eab-b810-0a863371eb36_SNAPS','38_w1_o1_mandibule_snapshot_0.png','d6c21fa2-43a3-46ad-8b9a-3f2b83d486d1','{\"displayTitle\":\"Mandible 1.38.1.1.2\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-22 16:54:43.000','2024-10-31 14:02:29.896','2024-10-31 10:02:29.896'),('d6f1fabc-2a26-4d5f-b438-4ce706655a1b',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_344acade-9e53-43df-a580-c61498c3b57a/occlusion_6861b877-a2a9-413b-a002-89eb317aa99f/scan_96e07cef-c402-4c22-8ab7-f63fa9dd08a0/7_w4_o1_maxillaire_snapshot_1.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_344acade-9e53-43df-a580-c61498c3b57a_SESS_6861b877-a2a9-413b-a002-89eb317aa99f_TOSC_96e07cef-c402-4c22-8ab7-f63fa9dd08a0_SNAPS','7_w4_o1_maxillaire_snapshot_1.png','ee22bb74-025f-4764-bf3c-e444fd75bfa5','{\"displayTitle\":\"Maxilla 1.7.4.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-05-03 19:53:30.000','2024-10-31 14:02:26.738','2024-10-31 10:02:26.738'),('d7259e03-f436-4b58-aeb9-cea3bf0a1d04',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_775311e4-a561-40c7-a2ce-76a0b1550be8/scan_449b7a19-bb82-4d6f-82b8-8bec06fa85d9/41_w1_o1_mandibule_snapshot_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_775311e4-a561-40c7-a2ce-76a0b1550be8_BOSC_449b7a19-bb82-4d6f-82b8-8bec06fa85d9_SNAPS','41_w1_o1_mandibule_snapshot_0.png','d7259e03-f436-4b58-aeb9-cea3bf0a1d04','{\"displayTitle\":\"Mandible 1.41.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-07-28 15:08:57.000','2024-10-31 14:02:32.180','2024-10-31 10:02:32.180'),('d73ed817-72ee-4c83-a18a-a4b11b0b8c1a',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_a4752db3-12a3-432e-825c-694c37118d39/37_w2_o2_mordu_posterieur_droit_snapshot_3.png','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_RISC_a4752db3-12a3-432e-825c-694c37118d39_SNAPS','37_w2_o2_mordu_posterieur_droit_snapshot_3.png','2f08ce27-2392-4c74-9c68-ed3fd9058690','{\"displayTitle\":\"Posterior right bite 1.37.2.2.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',3,'SYNCED',0,NULL,'2022-11-09 16:16:05.000','2024-10-31 14:02:35.941','2024-10-31 10:02:35.941'),('d7403a86-69a8-47be-841c-0ef6b1c68e12',664,'/var/.data/2021/664/eddc3fb0-fe28-4640-9139-29e088374f38/session_b6c36b1b-7784-4541-99a4-cc8d71760e48/occlusion_627f8883-666a-43cc-a9a1-6e48437d191f/scan_c10fc832-071d-4249-8d26-88c7891b3ef7/6_w1_o1_mandibule_snapshot_0.png','PATIENT_eddc3fb0-fe28-4640-9139-29e088374f38_ACT_b6c36b1b-7784-4541-99a4-cc8d71760e48_SESS_627f8883-666a-43cc-a9a1-6e48437d191f_BOSC_c10fc832-071d-4249-8d26-88c7891b3ef7_SNAPS','6_w1_o1_mandibule_snapshot_0.png','d7403a86-69a8-47be-841c-0ef6b1c68e12','{\"displayTitle\":\"Mandible 1.6.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-18 19:49:00.000','2024-10-31 14:02:25.788','2024-10-31 10:02:25.788'),('d7d428c8-6542-11ef-b382-58a023cda0dc',664,'/var/.data/2024/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_b75ed43d-6542-11ef-b382-58a023cda0dc/order_b765206e-6542-11ef-b382-58a023cda0dc/d7d428c8-6542-11ef-b382-58a023cda0dc.pdf','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_b75ed43d-6542-11ef-b382-58a023cda0dc_PROST_b765206e-6542-11ef-b382-58a023cda0dc_FORM','d7d428c8-6542-11ef-b382-58a023cda0dc.pdf','d7d428c8-6542-11ef-b382-58a023cda0dc','{\"displayTitle\":\"Order 1.35.3.1 Ant Maxillary Surg Guide\",\"title\":\"Ant Maxillary Surg Guide\"}','PDF',0,'SYNCED',0,NULL,'2024-08-28 09:38:43.502','2024-08-28 13:38:44.127','2024-08-28 09:38:44.396'),('d8094a5c-fedb-4670-86ce-564c40fef227',664,'','PATIENT_59179996-dc1e-4b4c-b9fd-92c78aa1dde0_ACT_df905f94-03ea-4868-82d7-960568f5cab7_SESS_88c76352-cde4-4fcb-a264-c6cd5cb1e44f_TOSC_51d672de-5db0-4925-8908-13042e3aacea_SNAPS','','d8094a5c-fedb-4670-86ce-564c40fef227','{\"displayTitle\":\"Maxilla 1.40.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'CREATED',0,'2022-07-18 16:51:00.000','2022-07-18 16:44:32.000','2023-05-17 17:16:39.559',NULL),('d81a9394-1d76-4e0d-bbe3-266fa262538c',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_7d40798f-7207-4c33-aa42-10afc814de77/scan_e7c95c67-ccda-41e6-a581-e41824f1239b/10_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_RISC_e7c95c67-ccda-41e6-a581-e41824f1239b_MODEL','10_w1_o1_mordu_posterieur_droit_scan_file_0.ply','d81a9394-1d76-4e0d-bbe3-266fa262538c','{\"displayTitle\":\"Posterior right bite 1.10.1.1.1\",\"modelMatrix\":\"0.948794,-0.178241,0.27499,0,0.198495,0.969689,-0.104422,0,-0.246458,0.168467,0.955832,0,-11.3913,-3.79018,-20.3737,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-06-29 20:13:49.000','2024-10-31 14:02:32.267','2024-10-31 10:02:32.267'),('d8f7c98c-8b39-4c9f-b7dd-93788bb51484',664,'','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_TOSC_4352d5ab-e3b9-4f1f-9fb2-e12036db1127_MODEL','49_w1_o1_maxillaire_scan_file_0.zip','d8f7c98c-8b39-4c9f-b7dd-93788bb51484','{\"displayTitle\":\"Maxilla 1.49.1.1.1\",\"modelMatrix\":\"-0.961896,0.268544,-0.0513858,0,-0.273416,-0.944755,0.180779,0,2.01791e-09,0.18794,0.98218,0,19.7719,-11.2081,-25.7569,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:09:05.000','2022-10-31 12:10:50.000','2024-10-31 14:02:35.639','2024-10-31 10:02:35.639'),('d9832be3-80d4-48f3-a493-2302821853bf',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_5500928e-446a-45d8-af99-faf7375b1d49/21_w1_o1_mandibule_scan_file_0.ply','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_BOSC_5500928e-446a-45d8-af99-faf7375b1d49_MODEL','21_w1_o1_mandibule_scan_file_0.ply','d9832be3-80d4-48f3-a493-2302821853bf','{\"displayTitle\":\"Mandible PLY\",\"modelMatrix\":\"-0.54756,0.785042,-0.289634,0,-0.836766,-0.513713,0.189529,0,1.0101e-8,0.346134,0.938185,0,4.94306,-40.8842,-12.9014,1\",\"title\":\"Mandible PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-28 18:14:12.000','2024-10-31 14:02:26.082','2024-10-31 10:02:26.082'),('d99c267d-7e3c-47a7-bcd3-9e758b7142bc',664,'/var/.data/2022/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_705960fa-3ed4-4013-9cde-20022721d122/occlusion_9f4fa7cb-81a3-460e-b189-ba76eb8cee15/scan_c8efe876-0a08-4332-bd36-6b59cc8f2eb8/7_w8_o1_mandibule_scan_file_0.zip','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_705960fa-3ed4-4013-9cde-20022721d122_SESS_9f4fa7cb-81a3-460e-b189-ba76eb8cee15_BOSC_c8efe876-0a08-4332-bd36-6b59cc8f2eb8_MODEL','7_w8_o1_mandibule_scan_file_0.zip','d99c267d-7e3c-47a7-bcd3-9e758b7142bc','{\"displayTitle\":\"Mandible 1.7.8.1.2\",\"modelMatrix\":\"0.131459,0.923647,-0.359993,0,-0.991322,0.122485,-0.0477385,0,2.99261e-10,0.363144,0.931733,0,-13.2686,-19.3042,-16.8022,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-30 16:56:02.000','2024-10-31 14:02:28.915','2024-10-31 10:02:28.915'),('d9aff01a-a913-4712-87f6-e63740863dd6',664,'/var/.data/2022/664/7eac18e5-5ed2-4ed9-8b3e-eba1c562d708/session_c49716f1-987e-4111-9ab9-4541a0378bb7/occlusion_9a395a3e-4872-409e-922b-4bb58053d8a5/scan_d7e952db-9527-4a27-a3cb-76863aa4d0de/30_w1_o1_mandibule_snapshot_0.png','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_BOSC_d7e952db-9527-4a27-a3cb-76863aa4d0de_SNAPS','30_w1_o1_mandibule_snapshot_0.png','d9aff01a-a913-4712-87f6-e63740863dd6','{\"displayTitle\":\"Mandible 1.30.1.1.3\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-21 15:35:35.000','2024-10-31 14:02:33.041','2024-10-31 10:02:33.041'),('d9da262b-a026-4f41-a285-552ed1c7e69b',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20/37_w2_o1_mandibule_mlmeta_0_3.bin','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_BOSC_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20_LIFIM','37_w2_o1_mandibule_mlmeta_0_3.bin','ed062015-5ce9-4d64-a982-e1d9ccfc2c5f','{\"displayTitle\":\"Margin line Mandible 1.37.2.1.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',3,'SYNCED',0,NULL,'2022-11-02 19:34:40.000','2024-10-31 14:02:35.817','2024-10-31 10:02:35.817'),('da333d07-80cd-4439-adfd-9aaf2686eb08',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_ede3aa5c-bbba-4cf2-8caa-b2d5f671b311/scan_b241654a-9ea1-48f7-8414-4891fdcbd880/44_w1_o2_mandibule_snapshot_0.png','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_ede3aa5c-bbba-4cf2-8caa-b2d5f671b311_BOSC_b241654a-9ea1-48f7-8414-4891fdcbd880_SNAPS','44_w1_o2_mandibule_snapshot_0.png','da333d07-80cd-4439-adfd-9aaf2686eb08','{\"displayTitle\":\"Mandible 1.44.1.2.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-21 19:25:38.000','2024-10-31 14:02:35.231','2024-10-31 10:02:35.231'),('da74b15a-5579-4b37-a283-e3cc9c0d0d26',664,'','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_db740293-ae2a-40ae-9142-4d94ed66bcd5_SESS_1256ab02-5172-4a92-a17d-f2fc402290ac_TOSC_c9d5be37-9f50-45c6-8384-f43f10073bb8_MODEL','','da74b15a-5579-4b37-a283-e3cc9c0d0d26','{\"displayTitle\":\"Maxilla 1.7.6.1.1\",\"modelMatrix\":\"0.710871,0.393469,0.582962,0,0.703322,-0.397692,-0.589219,0,7.55165e-9,0.828869,-0.559443,0,-8.07646,-34.6994,44.508,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'CREATED',0,'2021-05-05 15:56:40.000','2021-05-05 15:56:32.000','2023-05-17 17:16:39.559',NULL),('db9ebd1c-278a-4c11-a3bc-d8c36f9b811c',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_36d05387-51e6-4286-a074-7c7894c0622b/occlusion_0ec93b21-a91f-4695-a966-e072a8fb68e3/scan_5212b119-1f64-4de6-82e2-b5b72ee0e22b/7_w7_o1_maxillaire_scan_file_3.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_36d05387-51e6-4286-a074-7c7894c0622b_SESS_0ec93b21-a91f-4695-a966-e072a8fb68e3_TOSC_5212b119-1f64-4de6-82e2-b5b72ee0e22b_MODEL','7_w7_o1_maxillaire_scan_file_3.ply','7eedc56a-9ad1-4a49-b277-341ffab589ce','{\"displayTitle\":\"Maxilla 1.7.7.1.1\",\"modelMatrix\":\"-0.325962,-0.015658,0.945253,0,0.945383,-0.00539877,0.325917,0,1.81389e-10,0.999863,0.0165626,0,7.70919,-51.4044,5.0148,1\",\"title\":\"Maxilla PLY\"}','PLY',3,'SYNCED',0,NULL,'2021-05-05 17:45:09.000','2023-05-17 17:16:39.559','2023-05-22 09:05:18.274'),('dc509fe6-76b9-4554-9199-4c7014501ff8',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20/37_w2_o1_mandibule_mlmeta_0_2.bin','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_BOSC_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20_LIFIM','37_w2_o1_mandibule_mlmeta_0_2.bin','ed062015-5ce9-4d64-a982-e1d9ccfc2c5f','{\"displayTitle\":\"Margin line Mandible 1.37.2.1.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',2,'SYNCED',0,NULL,'2022-11-02 19:33:51.000','2024-10-31 14:02:35.829','2024-10-31 10:02:35.829'),('dd4c117a-c03b-4b5e-b723-0ffae29a0f46',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_893e772a-611c-44f9-82ac-d63e0a0499b2/21_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_RISC_893e772a-611c-44f9-82ac-d63e0a0499b2_SNAPS','21_w1_o1_mordu_posterieur_droit_snapshot_0.png','dd4c117a-c03b-4b5e-b723-0ffae29a0f46','{\"displayTitle\":\"Posterior right bite 1.21.1.1.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-28 18:54:11.000','2024-10-31 14:02:26.132','2024-10-31 10:02:26.132'),('ddb24d42-0269-4237-8622-4bac2c10e67c',664,'/var/.data/2022/664/7eac18e5-5ed2-4ed9-8b3e-eba1c562d708/session_c49716f1-987e-4111-9ab9-4541a0378bb7/occlusion_9a395a3e-4872-409e-922b-4bb58053d8a5/scan_ec557b87-5cb1-4e74-9d71-d45c543b3847/30_w1_o1_maxillaire_snapshot_0.png','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_TOSC_ec557b87-5cb1-4e74-9d71-d45c543b3847_SNAPS','30_w1_o1_maxillaire_snapshot_0.png','ddb24d42-0269-4237-8622-4bac2c10e67c','{\"displayTitle\":\"Maxilla 1.30.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-21 15:09:01.000','2024-10-31 14:02:33.011','2024-10-31 10:02:33.011'),('dee039ba-4cc5-4fa5-ad6e-6642ba1fe187',664,'/var/.data/2021/664/872e90e0-190f-43c9-ac34-11936953fc74/session_c90ddf83-1e94-4d7c-a61f-3f7bed3aad41/occlusion_5dac735e-358c-49a1-aa52-0180d8d8ff7e/scan_7ce9b1b8-7c7b-4655-bd0d-90f37ced345e/27_w2_o1_maxillaire_scan_file_1.zip','PATIENT_872e90e0-190f-43c9-ac34-11936953fc74_ACT_c90ddf83-1e94-4d7c-a61f-3f7bed3aad41_SESS_5dac735e-358c-49a1-aa52-0180d8d8ff7e_TOSC_7ce9b1b8-7c7b-4655-bd0d-90f37ced345e_MODEL','27_w2_o1_maxillaire_scan_file_1.zip','4ee64a77-ca4c-444b-9d9f-1eaea738c404','{\"displayTitle\":\"Maxilla 1.27.2.1.1\",\"modelMatrix\":\"0.0402542,0.982076,-0.184136,0,-0.999189,0.0395647,-0.00741826,0,1.47114e-10,0.184286,0.982873,0,17.5111,-27.163,-17.4832,1\",\"title\":\"Maxilla ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2021-10-20 18:18:52.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.797'),('dee489cd-6acd-4bad-9ed8-f0990f83d6cc',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20/37_w2_o1_mandibule_ml_0_1.xyz','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_BOSC_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20_LIFI','37_w2_o1_mandibule_ml_0_1.xyz','f7956a29-1664-4e5a-9aad-2a53021be43e','{\"displayTitle\":\"Margin line Mandible 1.37.2.1.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2022-11-02 19:33:13.000','2024-10-31 14:02:35.837','2024-10-31 10:02:35.837'),('df24fb2c-781d-4e64-bdb6-e7de14400db3',664,'/var/.data/2022/664/99b65fa1-1638-4d2a-8836-8f2697b96143/session_6834852b-fe98-4445-9c5d-2b6bf3991183/occlusion_cacc103c-8b88-4be5-a787-b6b92341e9eb/scan_ef34ef6f-c00c-49e4-85b3-2c0aed9adcc0/34_w1_o1_mandibule_snapshot_0.png','PATIENT_99b65fa1-1638-4d2a-8836-8f2697b96143_ACT_6834852b-fe98-4445-9c5d-2b6bf3991183_SESS_cacc103c-8b88-4be5-a787-b6b92341e9eb_BOSC_ef34ef6f-c00c-49e4-85b3-2c0aed9adcc0_SNAPS','34_w1_o1_mandibule_snapshot_0.png','df24fb2c-781d-4e64-bdb6-e7de14400db3','{\"displayTitle\":\"Mandible 1.34.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-05-25 17:55:04.000','2024-10-31 14:02:29.274','2024-10-31 10:02:29.274'),('df32e9cc-0861-4ad7-ad2a-718737b05992',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_955946be-5764-4c34-9e84-61682f4fdf78/occlusion_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d/scan_84918ef7-2b0c-4acf-a14e-df7fcaff4812/33_w2_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_LESC_84918ef7-2b0c-4acf-a14e-df7fcaff4812_MODEL','33_w2_o1_mordu_posterieur_gauche_scan_file_0.zip','df32e9cc-0861-4ad7-ad2a-718737b05992','{\"displayTitle\":\"Posterior left bite 1.33.2.1.3\",\"modelMatrix\":\"-0.963894,-0.165255,0.209673,0,0.116363,-0.964897,-0.22566,0,0.239524,-0.204446,0.951444,0,4.76367,11.3891,-17.5338,1\",\"title\":\"Posterior left bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-01 15:37:20.000','2024-10-31 14:02:31.867','2024-10-31 10:02:31.867'),('df39cda5-e2d4-4006-bfb9-174151c06cd7',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_5500928e-446a-45d8-af99-faf7375b1d49/21_w1_o1_mandibule_snapshot_1.png','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_BOSC_5500928e-446a-45d8-af99-faf7375b1d49_SNAPS','21_w1_o1_mandibule_snapshot_1.png','779f3035-6a8d-41b5-8c8d-7ea284d28390','{\"displayTitle\":\"Mandible 1.21.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-04-28 18:18:17.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.795'),('e017d672-6540-11ef-b382-58a023cda0dc',664,'/var/.data/2024/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_721d0cdd-6536-11ef-b382-58a023cda0dc/occlusion_721e3ad7-6536-11ef-b382-58a023cda0dc/scan_9af0dbc6-6540-11ef-b382-58a023cda0dc/e017d672-6540-11ef-b382-58a023cda0dc.zip','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_721d0cdd-6536-11ef-b382-58a023cda0dc_SESS_721e3ad7-6536-11ef-b382-58a023cda0dc_LESC_9af0dbc6-6540-11ef-b382-58a023cda0dc_MODEL','e017d672-6540-11ef-b382-58a023cda0dc.zip','e017d672-6540-11ef-b382-58a023cda0dc','{\"displayTitle\":\"Left bite 1.35.2.1.1\",\"modelMatrix\":\"-0.989923,0.012375,0.141509,0,-0.0141212,-0.999772,-0.0165343,0,0.140902,-0.0174471,0.989799,0,6.61412,4.40478,-20.0965,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-08-28 09:25:53.000','2024-08-28 13:38:47.170','2024-08-28 09:38:47.170'),('e0190e85-6540-11ef-b382-58a023cda0dc',664,'/var/.data/2024/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_721d0cdd-6536-11ef-b382-58a023cda0dc/occlusion_721e3ad7-6536-11ef-b382-58a023cda0dc/scan_9af0dbc6-6540-11ef-b382-58a023cda0dc/e0190e85-6540-11ef-b382-58a023cda0dc.png','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_721d0cdd-6536-11ef-b382-58a023cda0dc_SESS_721e3ad7-6536-11ef-b382-58a023cda0dc_LESC_9af0dbc6-6540-11ef-b382-58a023cda0dc_SNAPS','e0190e85-6540-11ef-b382-58a023cda0dc.png','e0190e85-6540-11ef-b382-58a023cda0dc','{\"displayTitle\":\"Left bite 1.35.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-08-28 09:25:53.000','2024-08-28 13:38:47.185','2024-08-28 09:38:47.185'),('e073c91e-f9e6-469e-b0f4-f2842226eb6a',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_120f9fe3-b23d-49c7-89ab-f1becc102f6c/scan_a6440940-a668-4e8f-be35-82ce928f701e/33_w1_o1_mordu_posterieur_droit_scan_file_1.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_120f9fe3-b23d-49c7-89ab-f1becc102f6c_RISC_a6440940-a668-4e8f-be35-82ce928f701e_MODEL','33_w1_o1_mordu_posterieur_droit_scan_file_1.zip','bb969c94-5b26-4ac7-b0c1-9e5784e6d4f0','{\"displayTitle\":\"Posterior right bite 1.33.1.1.1\",\"modelMatrix\":\"0.958856,-0.0600892,0.276641,0,0.0162127,0.976514,0.206755,0,-0.283964,-0.207855,0.938522,0,-9.05657,7.62217,-21.8299,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-04-11 17:13:43.000','2024-10-31 14:02:29.095','2024-10-31 10:02:29.095'),('e090cb88-5e7f-4023-af0f-0b9e21863d24',664,'/var/.data/2022/664/635617fc-289b-470c-a4d4-678d7b5f275a/session_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6/order_fe4e3868-3697-40bc-ae0f-9780656aa9e1/45_w1_couronne_sur_implant_prost_file_e090cb88-5e7f-4023-af0f-0b9e21863d24_0.pdf','PATIENT_635617fc-289b-470c-a4d4-678d7b5f275a_ACT_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6_PROST_fe4e3868-3697-40bc-ae0f-9780656aa9e1_FORM','45_w1_couronne_sur_implant_prost_file_e090cb88-5e7f-4023-af0f-0b9e21863d24_0.pdf','e090cb88-5e7f-4023-af0f-0b9e21863d24','{\"displayTitle\":\"ORDER 1.45.1.3 IMPLANT CROWN (Andrew Gilboy)\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'CREATED',0,NULL,'2022-11-18 21:09:16.000','2023-05-17 17:16:39.559',NULL),('e0fc0b6f-d43e-46fd-8b64-3e6b7edb4a91',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/occlusion_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e/scan_51eb1879-2b2e-4194-9e9b-9ff1e67fe43c/49_w1_o1_mordu_posterieur_droit_scan_file_1.zip','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_SESS_ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e_RISC_51eb1879-2b2e-4194-9e9b-9ff1e67fe43c_MODEL','49_w1_o1_mordu_posterieur_droit_scan_file_1.zip','b3e4aa09-a4e4-454f-9f21-2abb5e89e530','{\"displayTitle\":\"Posterior right bite 1.49.1.1.2\",\"modelMatrix\":\"0.924761,-0.145564,0.351025,0,0.14577,0.988876,0.0256236,0,-0.351526,0.0307651,0.936021,0,3.87248,0.905777,-20.1764,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-10-31 17:24:57.000','2024-10-31 14:02:35.610','2024-10-31 10:02:35.610'),('e2055423-121e-44b1-ba24-257ea8653e14',664,'/var/.data/2021/664/f4f78058-cf3c-4c86-a252-bc92bd2d36b0/session_49b3ccf6-630c-48b2-8480-8a005298959e/occlusion_eee3d6a4-c7be-49a9-9278-7bd1d7e7f773/scan_4d1480f1-6a51-4555-bec5-61f967de64cd/13_w1_o1_maxillaire_screenshot_e2055423-121e-44b1-ba24-257ea8653e14_0.png','PATIENT_f4f78058-cf3c-4c86-a252-bc92bd2d36b0_ACT_49b3ccf6-630c-48b2-8480-8a005298959e_SESS_eee3d6a4-c7be-49a9-9278-7bd1d7e7f773_TOSC_4d1480f1-6a51-4555-bec5-61f967de64cd_SCREENS','13_w1_o1_maxillaire_screenshot_e2055423-121e-44b1-ba24-257ea8653e14_0.png','e2055423-121e-44b1-ba24-257ea8653e14','{\"displayTitle\":\"Screenshot 1.13.1.1.1 Maxilla 4\",\"scanFileId\":\"0cc0a4e2-b944-4f97-b8fd-4141a51c8b36\",\"scanFileType\":\"PLY\",\"scanPosition\":\"-0.904453,0.424487,-0.0421382,0,0.426203,0.903364,-0.0478036,0,0.0177742,-0.0611955,-0.997968,0,0,0,0,1\",\"title\":\"Maxilla 4\"}','PNG',0,'SYNCED',0,NULL,'2020-09-02 15:27:20.000','2024-10-31 14:02:25.611','2024-10-31 10:02:25.611'),('e237cc6f-1a56-4185-8656-d1fe784dc0ef',664,'/var/.data/2022/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_705960fa-3ed4-4013-9cde-20022721d122/occlusion_9f4fa7cb-81a3-460e-b189-ba76eb8cee15/scan_3afaae5b-fc7f-46be-b019-7206b27b05a8/7_w8_o1_maxillaire_scan_file_0.zip','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_705960fa-3ed4-4013-9cde-20022721d122_SESS_9f4fa7cb-81a3-460e-b189-ba76eb8cee15_TOSC_3afaae5b-fc7f-46be-b019-7206b27b05a8_MODEL','7_w8_o1_maxillaire_scan_file_0.zip','e237cc6f-1a56-4185-8656-d1fe784dc0ef','{\"displayTitle\":\"Maxilla 1.7.8.1.2\",\"modelMatrix\":\"0.618104,0.701761,-0.354229,0,-0.786096,0.551792,-0.278529,0,5.59737e-09,0.450618,0.892717,0,-25.3438,-11.095,-15.5936,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-30 17:13:12.000','2024-10-31 14:02:28.955','2024-10-31 10:02:28.955'),('e31b565c-6205-4cad-ac46-f9268d3838c0',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_21bbefd5-8dc0-4e41-91d8-718463ad469c/scan_00462b4b-7b16-4a6c-aaef-5da516ac1f81/41_w1_o3_mordu_posterieur_gauche_snapshot_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_LESC_00462b4b-7b16-4a6c-aaef-5da516ac1f81_SNAPS','41_w1_o3_mordu_posterieur_gauche_snapshot_0.png','e31b565c-6205-4cad-ac46-f9268d3838c0','{\"displayTitle\":\"Posterior left bite 1.41.1.3.1\",\"title\":\"Posterior left bite SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-03 16:16:06.000','2024-10-31 14:02:32.024','2024-10-31 10:02:32.024'),('e3d42984-7a05-4090-9332-6501d4802cda',664,'','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_TOSC_7d660b43-6b91-4c1b-b004-a0aa4d714d00_MODEL','41_w1_o3_maxillaire_scan_file_0.zip','e3d42984-7a05-4090-9332-6501d4802cda','{\"displayTitle\":\"Maxilla 1.41.1.3.1\",\"modelMatrix\":\"0.166219,0.852951,-0.494819,0,-0.986089,0.143777,-0.0834085,0,1.99942e-09,0.5018,0.864984,0,-9.95937,-9.89371,-18.6498,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,'2023-05-22 09:09:09.000','2022-08-03 09:49:49.000','2024-10-31 14:02:31.915','2024-10-31 10:02:31.915'),('e5aef4d2-31a2-46d6-baad-9f8289109763',664,'/var/.data/2022/664/cede029c-15bc-44c2-9c9c-fac7f8983524/session_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29/occlusion_4d46a627-5949-4b2a-b4d6-c391f159485b/scan_2c6eb2a3-6697-4912-9947-5c2b5f942eb8/46_w1_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_cede029c-15bc-44c2-9c9c-fac7f8983524_ACT_d84b9ba5-9fa3-46d3-afd2-cfddd498ec29_SESS_4d46a627-5949-4b2a-b4d6-c391f159485b_RISC_2c6eb2a3-6697-4912-9947-5c2b5f942eb8_MODEL','46_w1_o1_mordu_posterieur_droit_scan_file_0.zip','e5aef4d2-31a2-46d6-baad-9f8289109763','{\"displayTitle\":\"Posterior right bite 1.46.1.1.2\",\"modelMatrix\":\"0.905808,0.070527,0.418778,0,-0.0388718,0.996066,-0.0691994,0,-0.421906,0.0546398,0.905504,0,-5.92293,-2.2516,-23.222,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-12 20:38:05.000','2024-10-31 14:02:35.178','2024-10-31 10:02:35.178'),('e5b40fb0-6c32-11ee-bc7f-58a023cda0dc',664,'/var/.data/2023/664/bbc77872-6c30-11ee-bc7f-58a023cda0dc/session_0a963705-6c31-11ee-bc7f-58a023cda0dc/occlusion_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc/scan_2b878881-6c32-11ee-bc7f-58a023cda0dc/e5b40fb0-6c32-11ee-bc7f-58a023cda0dc.zip','PATIENT_bbc77872-6c30-11ee-bc7f-58a023cda0dc_ACT_0a963705-6c31-11ee-bc7f-58a023cda0dc_SESS_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc_BOSC_2b878881-6c32-11ee-bc7f-58a023cda0dc_MODEL','e5b40fb0-6c32-11ee-bc7f-58a023cda0dc.zip','e5b40fb0-6c32-11ee-bc7f-58a023cda0dc','{\"displayTitle\":\"Mandible 1.53.1.1.1\",\"modelMatrix\":\"0.541191,0.731969,-0.413925,0,-0.8409,0.471084,-0.266396,0,-4.05761e-09,0.49224,0.870459,0,-17.8233,-10.9155,-17.7958,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-10-16 10:55:21.980','2023-10-16 10:47:15.301','2023-10-16 17:05:08.900',NULL),('e5b41f42-6c32-11ee-bc7f-58a023cda0dc',664,'/var/.data/2023/664/bbc77872-6c30-11ee-bc7f-58a023cda0dc/session_0a963705-6c31-11ee-bc7f-58a023cda0dc/occlusion_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc/scan_2b878881-6c32-11ee-bc7f-58a023cda0dc/e5b41f42-6c32-11ee-bc7f-58a023cda0dc.png','PATIENT_bbc77872-6c30-11ee-bc7f-58a023cda0dc_ACT_0a963705-6c31-11ee-bc7f-58a023cda0dc_SESS_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc_BOSC_2b878881-6c32-11ee-bc7f-58a023cda0dc_SNAPS','e5b41f42-6c32-11ee-bc7f-58a023cda0dc.png','e5b41f42-6c32-11ee-bc7f-58a023cda0dc','{\"displayTitle\":\"Mandible 1.53.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,'2023-10-16 10:55:21.980','2023-10-16 10:47:15.301','2023-10-16 17:05:08.901',NULL),('e6214fe7-dce5-49bb-85f8-3bb098d8c560',664,'/var/.data/2021/664/9af78b83-8d91-4dc6-9499-3b8f6672cee3/session_a02a4d9f-ff1d-46db-95e8-7c2405b0b014/occlusion_4aaf107a-b8db-4d45-befa-36e801ebc654/scan_669f6bca-452c-4b2e-a49e-aa822628ed5f/24_w1_o1_maxillaire_snapshot_0.png','PATIENT_9af78b83-8d91-4dc6-9499-3b8f6672cee3_ACT_a02a4d9f-ff1d-46db-95e8-7c2405b0b014_SESS_4aaf107a-b8db-4d45-befa-36e801ebc654_TOSC_669f6bca-452c-4b2e-a49e-aa822628ed5f_SNAPS','24_w1_o1_maxillaire_snapshot_0.png','e6214fe7-dce5-49bb-85f8-3bb098d8c560','{\"displayTitle\":\"Maxilla 1.24.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-13 21:08:22.000','2024-10-31 14:02:28.661','2024-10-31 10:02:28.661'),('e719c521-9b47-43b0-bae0-5d5b40b4609e',664,'/var/.data/2021/664/e648cc66-9340-456c-a379-50836d1b8a5b/session_f09c328f-1a8b-4f63-8998-2f9b57cd3c76/occlusion_2c19cd55-a36e-4dc7-8954-ea8a8eeacd16/scan_19fe3d64-fac4-4182-90d9-fb19f29bc385/16_w1_o1_mandibule_snapshot_0.png','PATIENT_e648cc66-9340-456c-a379-50836d1b8a5b_ACT_f09c328f-1a8b-4f63-8998-2f9b57cd3c76_SESS_2c19cd55-a36e-4dc7-8954-ea8a8eeacd16_BOSC_19fe3d64-fac4-4182-90d9-fb19f29bc385_SNAPS','16_w1_o1_mandibule_snapshot_0.png','e719c521-9b47-43b0-bae0-5d5b40b4609e','{\"displayTitle\":\"Mandible 1.16.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-01-18 17:51:04.000','2024-10-31 14:02:26.238','2024-10-31 10:02:26.238'),('e8000207-77e1-46d0-b4c6-869f040c0dc2',664,'/var/.data/2022/664/e33159c9-a713-4a37-ba98-9ec2e2e213e7/session_b63ca765-4d68-4cf4-9707-4ad3a19f3236/occlusion_ae7f89c9-26ec-4cee-b377-d5145e6c6aae/scan_5a4c21bb-56d0-45ea-b8ee-4931713ef609/50_w1_o1_mandibule_scan_file_0.zip','PATIENT_e33159c9-a713-4a37-ba98-9ec2e2e213e7_ACT_b63ca765-4d68-4cf4-9707-4ad3a19f3236_SESS_ae7f89c9-26ec-4cee-b377-d5145e6c6aae_BOSC_5a4c21bb-56d0-45ea-b8ee-4931713ef609_MODEL','50_w1_o1_mandibule_scan_file_0.zip','e8000207-77e1-46d0-b4c6-869f040c0dc2','{\"displayTitle\":\"Mandible 1.50.1.1.2\",\"modelMatrix\":\"0.961918,-0.0298929,0.2717,0,0.273339,0.105197,-0.956148,0,4.81734e-10,0.994002,0.109362,0,-8.67511,-35.6,-7.63936,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-14 18:17:32.000','2024-10-31 14:02:36.188','2024-10-31 10:02:36.188'),('e9a1cf3e-9639-4ec7-8417-34a46ed30e75',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_21bbefd5-8dc0-4e41-91d8-718463ad469c/scan_44749597-6cc6-493d-a2aa-76486e3c8416/41_w1_o3_mandibule_screenshot_e9a1cf3e-9639-4ec7-8417-34a46ed30e75_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_BOSC_44749597-6cc6-493d-a2aa-76486e3c8416_SCREENS','41_w1_o3_mandibule_screenshot_e9a1cf3e-9639-4ec7-8417-34a46ed30e75_0.png','e9a1cf3e-9639-4ec7-8417-34a46ed30e75','{\"displayTitle\":\"Screenshot 1.41.1.3.1 Mandible 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Mandible 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-03 17:32:41.000','2024-10-31 14:02:32.094','2024-10-31 10:02:32.094'),('eb3d7b07-28dd-4076-a69c-80c7abd0be51',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_955946be-5764-4c34-9e84-61682f4fdf78/occlusion_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d/scan_714348f7-0720-4a1c-bebb-c0807d687feb/33_w2_o1_mandibule_scan_file_0.zip','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_955946be-5764-4c34-9e84-61682f4fdf78_SESS_e98b0c01-9e79-49e0-9ab8-0d6f432bf80d_BOSC_714348f7-0720-4a1c-bebb-c0807d687feb_MODEL','33_w2_o1_mandibule_scan_file_0.zip','eb3d7b07-28dd-4076-a69c-80c7abd0be51','{\"displayTitle\":\"Mandible 1.33.2.1.1\",\"modelMatrix\":\"-0.996602,0.0614524,-0.0548381,0,-0.0823627,-0.743584,0.66355,0,-4.00203e-10,0.665812,0.746119,0,0.367396,-10.9441,-7.07595,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-01 15:22:15.000','2024-10-31 14:02:31.768','2024-10-31 10:02:31.768'),('eb7fffbc-7300-4a05-9936-5be07105c130',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_b5dae369-a773-4095-aa54-7c8b75c939d8/occlusion_a12bd271-974e-4fcf-8893-d88105690bce/scan_e1f9f752-dd61-4e2b-82d8-016edf9173cf/7_w3_o1_maxillaire_scan_file_1.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_b5dae369-a773-4095-aa54-7c8b75c939d8_SESS_a12bd271-974e-4fcf-8893-d88105690bce_TOSC_e1f9f752-dd61-4e2b-82d8-016edf9173cf_MODEL','7_w3_o1_maxillaire_scan_file_1.ply','b89bdf45-07f7-4aef-b272-f9b581b06b02','{\"displayTitle\":\"Maxilla 1.7.3.1.1\",\"modelMatrix\":\"0.353491,0.735052,-0.57857,0,-0.935438,0.277767,-0.218635,0,2.08057e-8,0.618502,0.785783,0,4.33116,-47.3843,-20.4717,1\",\"title\":\"Maxilla PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-04-28 17:09:03.000','2024-10-31 14:02:26.556','2024-10-31 10:02:26.556'),('ebdd28e5-bb98-48d1-a168-c4187cf083fd',664,'/var/.data/2023/664/b5cbee44-0703-46c2-986a-7a416eb4206c/session_399a5604-f330-487f-8e32-3a7a90ae6715/occlusion_75f786da-2db1-4447-9a94-0df475a4082d/scan_b6a47aff-51d9-4bb1-bb0d-20fd5a5bc0e0/52_w1_o1_maxillaire_scan_file_0.zip','PATIENT_b5cbee44-0703-46c2-986a-7a416eb4206c_ACT_399a5604-f330-487f-8e32-3a7a90ae6715_SESS_75f786da-2db1-4447-9a94-0df475a4082d_TOSC_b6a47aff-51d9-4bb1-bb0d-20fd5a5bc0e0_MODEL','52_w1_o1_maxillaire_scan_file_0.zip','ebdd28e5-bb98-48d1-a168-c4187cf083fd','{\"displayTitle\":\"Maxilla 1.52.1.1.1\",\"modelMatrix\":\"-0.0161025,0.99447,-0.103783,0,-0.99987,-0.0160155,0.00167138,0,-5.42875e-11,0.103797,0.994599,0,-13.3855,-16.0083,-19.2026,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2023-02-20 15:59:17.000','2024-10-31 14:02:36.267','2024-10-31 10:02:36.267'),('eccada04-8cc9-4fbe-8496-9337e8b83637',664,'/var/.data/2022/664/635617fc-289b-470c-a4d4-678d7b5f275a/session_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6/order_0b106085-a874-4785-83a0-f28eb5473492/45_w1_couronne_sur_implant_prost_file_eccada04-8cc9-4fbe-8496-9337e8b83637_0.pdf','PATIENT_635617fc-289b-470c-a4d4-678d7b5f275a_ACT_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6_PROST_0b106085-a874-4785-83a0-f28eb5473492_FORM','45_w1_couronne_sur_implant_prost_file_eccada04-8cc9-4fbe-8496-9337e8b83637_0.pdf','eccada04-8cc9-4fbe-8496-9337e8b83637','{\"displayTitle\":\"ORDER 1.45.1.1 IMPLANT CROWN Andrew Gilboy\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-09-07 19:36:01.000','2023-05-17 17:16:39.559','2023-05-22 09:07:40.776'),('ed062015-5ce9-4d64-a982-e1d9ccfc2c5f',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20/37_w2_o1_mandibule_mlmeta_0_0.bin','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_BOSC_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20_LIFIM','37_w2_o1_mandibule_mlmeta_0_0.bin','ed062015-5ce9-4d64-a982-e1d9ccfc2c5f','{\"displayTitle\":\"Margin line Mandible 1.37.2.1.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2022-11-02 19:31:37.000','2024-10-31 14:02:35.655','2024-10-31 10:02:35.655'),('ed3c4fbc-8ac2-4eda-8185-3ec2b181178b',664,'','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_BOSC_a0b85a0a-ef77-4f7c-b376-d6e388afe9f0_LIFI','10_w1_o1_mandibule_ml_1_0.xyz','ed3c4fbc-8ac2-4eda-8185-3ec2b181178b','{\"displayTitle\":\"Margin line Mandible 1.10.1.1.1 No name 1\",\"name\":\"No name 1\",\"title\":\"Mandible LIFI\",\"toothNumber\":1}','XYZ',0,'SYNCED',0,'2023-05-22 09:09:12.000','2020-07-03 10:42:10.000','2024-10-31 14:02:32.335','2024-10-31 10:02:32.335'),('ede805a2-c67d-404b-ba10-2922d208f4b7',664,'','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_BOSC_92704e83-dce3-4695-baad-1df750f09cd7_LIFIM','37_w2_o2_mandibule_mlmeta_0_0.bin','ede805a2-c67d-404b-ba10-2922d208f4b7','{\"displayTitle\":\"Margin line Mandible 1.37.2.2.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2023-05-22 09:09:12.000','2022-11-09 10:58:49.000','2024-10-31 14:02:36.127','2024-10-31 10:02:36.127'),('ee22bb74-025f-4764-bf3c-e444fd75bfa5',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_344acade-9e53-43df-a580-c61498c3b57a/occlusion_6861b877-a2a9-413b-a002-89eb317aa99f/scan_96e07cef-c402-4c22-8ab7-f63fa9dd08a0/7_w4_o1_maxillaire_snapshot_0.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_344acade-9e53-43df-a580-c61498c3b57a_SESS_6861b877-a2a9-413b-a002-89eb317aa99f_TOSC_96e07cef-c402-4c22-8ab7-f63fa9dd08a0_SNAPS','7_w4_o1_maxillaire_snapshot_0.png','ee22bb74-025f-4764-bf3c-e444fd75bfa5','{\"displayTitle\":\"Maxilla 1.7.4.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-05-03 19:42:37.000','2024-10-31 14:02:26.726','2024-10-31 10:02:26.726'),('ee41e937-5440-4e00-b31c-adb4cc45edf8',664,'/var/.data/2022/664/ffbcef25-a535-4bb2-8b85-6107c1aaa2ed/session_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f/occlusion_0f4d3a0e-7431-47c6-b459-92fae651b233/scan_62fd085a-7b18-4cdf-aa97-db92a842f34f/32_w1_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_ffbcef25-a535-4bb2-8b85-6107c1aaa2ed_ACT_2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f_SESS_0f4d3a0e-7431-47c6-b459-92fae651b233_RISC_62fd085a-7b18-4cdf-aa97-db92a842f34f_MODEL','32_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ee41e937-5440-4e00-b31c-adb4cc45edf8','{\"displayTitle\":\"Posterior right bite 1.32.1.1.1\",\"modelMatrix\":\"0.947376,-0.0192394,0.316521,0,0.00381465,0.998587,0.0507734,0,-0.320118,-0.0496142,0.947234,0,-2.25343,-4.71901,-20.5132,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-23 16:37:51.000','2024-10-31 14:02:32.936','2024-10-31 10:02:32.936'),('ee724439-7aa0-434a-97b2-80e2b9080408',664,'/var/.data/2022/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_48975557-21ce-4d21-a4b8-334c890ddd9a/occlusion_e930782a-e2db-43e8-9ff1-9feb64e20e4e/scan_1642c8fb-5963-4064-9b58-acef4374ce2b/35_w1_o1_maxillaire_snapshot_1.png','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_48975557-21ce-4d21-a4b8-334c890ddd9a_SESS_e930782a-e2db-43e8-9ff1-9feb64e20e4e_TOSC_1642c8fb-5963-4064-9b58-acef4374ce2b_SNAPS','35_w1_o1_maxillaire_snapshot_1.png','cc11802a-1512-4adc-a5b0-52572343c7b1','{\"displayTitle\":\"Maxilla 1.35.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-06-06 20:35:18.000','2024-10-31 14:02:29.556','2024-10-31 10:02:29.556'),('ef6d4b7f-c6eb-4040-924f-8b7304ee7248',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_48ff9245-20c5-4364-a092-18eafb8024d3/scan_663b4cd8-e704-4cb6-ab8f-80ec41ed1370/10_w1_o2_mandibule_snapshot_0.png','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_48ff9245-20c5-4364-a092-18eafb8024d3_BOSC_663b4cd8-e704-4cb6-ab8f-80ec41ed1370_SNAPS','10_w1_o2_mandibule_snapshot_0.png','ef6d4b7f-c6eb-4040-924f-8b7304ee7248','{\"displayTitle\":\"Mandible 1.10.1.2.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-09-16 19:04:13.000','2024-10-31 14:02:25.702','2024-10-31 10:02:25.702'),('f06bc9ca-26d6-4759-bf98-4c270f5b51aa',664,'/var/.data/2022/664/635617fc-289b-470c-a4d4-678d7b5f275a/session_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6/order_8585764e-6028-48b5-bf39-ddba86be173e/45_w1_couronne_sur_implant_prost_file_f06bc9ca-26d6-4759-bf98-4c270f5b51aa_0.pdf','PATIENT_635617fc-289b-470c-a4d4-678d7b5f275a_ACT_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6_PROST_8585764e-6028-48b5-bf39-ddba86be173e_FORM','45_w1_couronne_sur_implant_prost_file_f06bc9ca-26d6-4759-bf98-4c270f5b51aa_0.pdf','f06bc9ca-26d6-4759-bf98-4c270f5b51aa','{\"displayTitle\":\"ORDER 1.45.1.2 IMPLANT CROWN (Andrew Gilboy)\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'CREATED',0,NULL,'2022-11-18 20:55:20.000','2023-05-17 17:16:39.559',NULL),('f1ae49ff-c5b8-49e1-a81f-fc865ff00c7d',664,'/var/.data/2022/664/685697a1-0d50-4a06-8b3e-729cf9750f38/session_e1d214d2-2b62-484c-8ede-86b3f84573d3/occlusion_8cd0c724-d3d0-4821-a88b-42b03ae4eb07/scan_6557ff06-b759-4b3c-8de6-1c83a9b00d23/48_w1_o1_maxillaire_snapshot_0.png','PATIENT_685697a1-0d50-4a06-8b3e-729cf9750f38_ACT_e1d214d2-2b62-484c-8ede-86b3f84573d3_SESS_8cd0c724-d3d0-4821-a88b-42b03ae4eb07_TOSC_6557ff06-b759-4b3c-8de6-1c83a9b00d23_SNAPS','48_w1_o1_maxillaire_snapshot_0.png','f1ae49ff-c5b8-49e1-a81f-fc865ff00c7d','{\"displayTitle\":\"Maxilla 1.48.1.1.3\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-10-17 17:02:53.000','2024-10-31 14:02:35.266','2024-10-31 10:02:35.266'),('f1be6500-2ee2-4256-aeb3-ae8bbdf150f7',664,'/var/.data/2022/664/7eac18e5-5ed2-4ed9-8b3e-eba1c562d708/session_c49716f1-987e-4111-9ab9-4541a0378bb7/occlusion_9a395a3e-4872-409e-922b-4bb58053d8a5/scan_d7e952db-9527-4a27-a3cb-76863aa4d0de/30_w1_o1_mandibule_snapshot_1.png','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_BOSC_d7e952db-9527-4a27-a3cb-76863aa4d0de_SNAPS','30_w1_o1_mandibule_snapshot_1.png','d9aff01a-a913-4712-87f6-e63740863dd6','{\"displayTitle\":\"Mandible 1.30.1.1.3\",\"title\":\"Mandible SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-03-21 15:37:05.000','2024-10-31 14:02:33.052','2024-10-31 10:02:33.052'),('f1cef6f1-79e5-4710-af52-8d44a265687b',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_1d15e305-f110-4004-a35a-cf5ca5fa2600/scan_a4752db3-12a3-432e-825c-694c37118d39/37_w2_o2_mordu_posterieur_droit_snapshot_2.png','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_1d15e305-f110-4004-a35a-cf5ca5fa2600_RISC_a4752db3-12a3-432e-825c-694c37118d39_SNAPS','37_w2_o2_mordu_posterieur_droit_snapshot_2.png','2f08ce27-2392-4c74-9c68-ed3fd9058690','{\"displayTitle\":\"Posterior right bite 1.37.2.2.1\",\"title\":\"Posterior right bite SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2022-11-09 16:13:45.000','2024-10-31 14:02:35.951','2024-10-31 10:02:35.951'),('f2bae466-8ebb-418d-b84f-8b538101773f',664,'/var/.data/2022/664/2716836a-c818-4c38-90b6-b63ccb3a95ab/session_551dd857-1278-4318-8547-662cc20c3741/occlusion_120f9fe3-b23d-49c7-89ab-f1becc102f6c/scan_b08eb59b-89c3-4239-8926-d8eb829e4257/33_w1_o1_mandibule_mlmeta_2_0.bin','PATIENT_2716836a-c818-4c38-90b6-b63ccb3a95ab_ACT_551dd857-1278-4318-8547-662cc20c3741_SESS_120f9fe3-b23d-49c7-89ab-f1becc102f6c_BOSC_b08eb59b-89c3-4239-8926-d8eb829e4257_LIFIM','33_w1_o1_mandibule_mlmeta_2_0.bin','f2bae466-8ebb-418d-b84f-8b538101773f','{\"displayTitle\":\"Margin line Mandible 1.33.1.1.1 Margin line 2\",\"name\":\"Margin line 2\",\"title\":\"Mandible LIFI_META\",\"toothNumber\":2,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2022-04-14 15:19:53.000','2024-10-31 14:02:29.252','2024-10-31 10:02:29.252'),('f3481f20-4e0b-418c-b386-0e6204e1c415',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_51374b44-d221-416c-8eb3-cf931ed89632/occlusion_8b5d08e1-2513-416b-87f9-350cab840a3d/scan_7eb7b491-f49d-4ad2-941c-473aec4b39cd/37_w1_o1_mandibule_snapshot_0.png','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_51374b44-d221-416c-8eb3-cf931ed89632_SESS_8b5d08e1-2513-416b-87f9-350cab840a3d_BOSC_7eb7b491-f49d-4ad2-941c-473aec4b39cd_SNAPS','37_w1_o1_mandibule_snapshot_0.png','f3481f20-4e0b-418c-b386-0e6204e1c415','{\"displayTitle\":\"Mandible 1.37.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-22 15:42:03.000','2024-10-31 14:02:29.730','2024-10-31 10:02:29.730'),('f3679988-653e-11ef-b382-58a023cda0dc',664,'/var/.data/2024/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_721d0cdd-6536-11ef-b382-58a023cda0dc/occlusion_721e3ad7-6536-11ef-b382-58a023cda0dc/scan_4e055e11-653e-11ef-b382-58a023cda0dc/f3679988-653e-11ef-b382-58a023cda0dc.zip','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_721d0cdd-6536-11ef-b382-58a023cda0dc_SESS_721e3ad7-6536-11ef-b382-58a023cda0dc_TOSC_4e055e11-653e-11ef-b382-58a023cda0dc_MODEL','f3679988-653e-11ef-b382-58a023cda0dc.zip','f3679988-653e-11ef-b382-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.35.2.1.1\",\"modelMatrix\":\"-0.547028,0.776372,-0.31306,0,-0.837114,-0.507335,0.204575,0,2.16865e-08,0.373975,0.927439,0,26.7228,-9.17892,-18.1732,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-08-28 09:25:43.000','2024-08-28 13:38:47.062','2024-08-28 09:38:47.062'),('f367a9fe-653e-11ef-b382-58a023cda0dc',664,'/var/.data/2024/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_721d0cdd-6536-11ef-b382-58a023cda0dc/occlusion_721e3ad7-6536-11ef-b382-58a023cda0dc/scan_4e055e11-653e-11ef-b382-58a023cda0dc/f367a9fe-653e-11ef-b382-58a023cda0dc.png','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_721d0cdd-6536-11ef-b382-58a023cda0dc_SESS_721e3ad7-6536-11ef-b382-58a023cda0dc_TOSC_4e055e11-653e-11ef-b382-58a023cda0dc_SNAPS','f367a9fe-653e-11ef-b382-58a023cda0dc.png','f367a9fe-653e-11ef-b382-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.35.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-08-28 09:25:47.000','2024-08-28 13:38:47.087','2024-08-28 09:38:47.087'),('f3e47673-2830-433d-8d15-a959b8b38ccc',664,'/var/.data/2021/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_344acade-9e53-43df-a580-c61498c3b57a/occlusion_6861b877-a2a9-413b-a002-89eb317aa99f/scan_96e07cef-c402-4c22-8ab7-f63fa9dd08a0/7_w4_o1_maxillaire_scan_file_1.ply','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_344acade-9e53-43df-a580-c61498c3b57a_SESS_6861b877-a2a9-413b-a002-89eb317aa99f_TOSC_96e07cef-c402-4c22-8ab7-f63fa9dd08a0_MODEL','7_w4_o1_maxillaire_scan_file_1.ply','d1d93eeb-e9b4-4246-b371-97194de11bf1','{\"displayTitle\":\"Maxilla 1.7.4.1.1\",\"modelMatrix\":\"0.819186,-0.491839,0.295005,0,0.573527,0.702509,-0.421364,0,1.37156e-8,0.514369,0.857569,0,-12.3129,-39.3986,-41.9181,1\",\"title\":\"Maxilla PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-05-03 19:53:30.000','2024-10-31 14:02:26.754','2024-10-31 10:02:26.754'),('f40bab24-99ba-4240-a790-2cb8e6b01f50',664,'','PATIENT_11ec40e4-4579-4185-9fcf-4e1aac06f554_ACT_8f44bea9-b7e9-45c8-a098-f3b18f9be730_SESS_7348646e-cf7a-460b-aba9-d56ad656689e_TOSC_d3d5ecdb-7933-478d-8f71-7bc13b2a4a05_MODEL','25_w1_o1_maxillaire_scan_file_0.ply','f40bab24-99ba-4240-a790-2cb8e6b01f50','{\"displayTitle\":\"Maxilla 1.25.1.1.2\",\"modelMatrix\":\"0.472664,0.869304,-0.144568,0,-0.881243,0.46626,-0.0775408,0,-2.06962e-9,0.164051,0.986452,0,-22.5465,-11.4851,-19.0711,1\",\"title\":\"Maxilla PLY\"}','PLY',0,'SYNCED',0,'2023-05-22 09:06:51.000','2021-09-14 11:55:41.000','2024-10-31 14:02:25.508','2024-10-31 10:02:25.508'),('f55defb1-5a2c-4b14-91f1-64f2163f04ad',664,'/var/.data/2022/664/fa67c8c9-4aad-41b8-83e6-2add079bf950/session_c83bd076-29da-4e22-aae9-8e83dce14029/occlusion_6630e34a-9b19-4727-9ef0-e1c95c341549/scan_81f83061-69fa-4da2-b528-42ee27f15e7a/44_w1_o1_mandibule_snapshot_0.png','PATIENT_fa67c8c9-4aad-41b8-83e6-2add079bf950_ACT_c83bd076-29da-4e22-aae9-8e83dce14029_SESS_6630e34a-9b19-4727-9ef0-e1c95c341549_BOSC_81f83061-69fa-4da2-b528-42ee27f15e7a_SNAPS','44_w1_o1_mandibule_snapshot_0.png','f55defb1-5a2c-4b14-91f1-64f2163f04ad','{\"displayTitle\":\"Mandible 1.44.1.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-07 15:10:20.000','2024-10-31 14:02:33.247','2024-10-31 10:02:33.247'),('f5ad24f9-4391-4c12-a74f-59a61808c613',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_775311e4-a561-40c7-a2ce-76a0b1550be8/scan_627e4388-24f1-4c92-816e-89cfce055284/41_w1_o1_maxillaire_screenshot_f5ad24f9-4391-4c12-a74f-59a61808c613_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_775311e4-a561-40c7-a2ce-76a0b1550be8_TOSC_627e4388-24f1-4c92-816e-89cfce055284_SCREENS','41_w1_o1_maxillaire_screenshot_f5ad24f9-4391-4c12-a74f-59a61808c613_0.png','f5ad24f9-4391-4c12-a74f-59a61808c613','{\"displayTitle\":\"Screenshot 1.41.1.1.2 Maxilla 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxilla 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-03 17:29:20.000','2024-10-31 14:02:32.151','2024-10-31 10:02:32.151'),('f5e47ce0-3489-42bc-8418-f6acf5dd3825',664,'/var/.data/2022/664/7eac18e5-5ed2-4ed9-8b3e-eba1c562d708/session_c49716f1-987e-4111-9ab9-4541a0378bb7/occlusion_9a395a3e-4872-409e-922b-4bb58053d8a5/scan_d7e952db-9527-4a27-a3cb-76863aa4d0de/30_w1_o1_mandibule_screenshot_f5e47ce0-3489-42bc-8418-f6acf5dd3825_0.png','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_BOSC_d7e952db-9527-4a27-a3cb-76863aa4d0de_SCREENS','30_w1_o1_mandibule_screenshot_f5e47ce0-3489-42bc-8418-f6acf5dd3825_0.png','f5e47ce0-3489-42bc-8418-f6acf5dd3825','{\"displayTitle\":\"Screenshot 1.30.1.1.3 Mandible 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Mandible 1\"}','PNG',0,'SYNCED',0,NULL,'2022-08-22 15:10:02.000','2024-10-31 14:02:33.060','2024-10-31 10:02:33.060'),('f674002c-98f4-11ee-ae49-58a023cda0dc',664,'/var/.data/2023/664/b4c6341b-9837-11ee-86e7-58a023cda0dc/session_e343b867-98f4-11ee-ae49-58a023cda0dc/order_e34746f8-98f4-11ee-ae49-58a023cda0dc/f674002c-98f4-11ee-ae49-58a023cda0dc.pdf','PATIENT_b4c6341b-9837-11ee-86e7-58a023cda0dc_ACT_e343b867-98f4-11ee-ae49-58a023cda0dc_PROST_e34746f8-98f4-11ee-ae49-58a023cda0dc_FORM','f674002c-98f4-11ee-ae49-58a023cda0dc.pdf','f674002c-98f4-11ee-ae49-58a023cda0dc','{\"displayTitle\":\"Order 1.56.5.1 Maxillary Surgical Guide-Duplicate Order\",\"title\":\"Maxillary Surgical Guide-Duplicate Order\"}','PDF',0,'SYNCED',0,NULL,'2023-12-12 08:47:18.000','2023-12-12 13:47:19.866','2023-12-12 08:47:19.866'),('f6888801-734d-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/scan_f3804f47-734c-11ee-b011-58a023cda0dc/f6888801-734d-11ee-b011-58a023cda0dc.zip','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_BOSC_f3804f47-734c-11ee-b011-58a023cda0dc_MODEL','f6888801-734d-11ee-b011-58a023cda0dc.zip','85b94756-734d-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Mandible 1.7.10.1.1\",\"modelMatrix\":\"-0.305997,0.926602,-0.218572,0,-0.952032,-0.297824,0.0702522,0,-1.81799e-09,0.229585,0.973289,0,-10.9338,-37.3094,-16.3757,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2023-10-25 11:48:38.088','2023-10-25 15:59:30.494','2023-10-25 12:00:09.468'),('f6889746-734d-11ee-b011-58a023cda0dc',664,'/var/.data/2023/664/73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9/session_07e45d8d-734b-11ee-b011-58a023cda0dc/occlusion_07e5f91d-734b-11ee-b011-58a023cda0dc/scan_f3804f47-734c-11ee-b011-58a023cda0dc/f6889746-734d-11ee-b011-58a023cda0dc.png','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_07e45d8d-734b-11ee-b011-58a023cda0dc_SESS_07e5f91d-734b-11ee-b011-58a023cda0dc_BOSC_f3804f47-734c-11ee-b011-58a023cda0dc_SNAPS','f6889746-734d-11ee-b011-58a023cda0dc.png','85b95611-734d-11ee-b011-58a023cda0dc','{\"displayTitle\":\"Mandible 1.7.10.1.1 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-10-25 11:48:38.088','2023-10-25 15:59:30.495','2023-10-25 12:00:15.596'),('f6e0525e-a065-4d5a-98b2-1a444413c722',664,'/var/.data/2022/664/685697a1-0d50-4a06-8b3e-729cf9750f38/session_e1d214d2-2b62-484c-8ede-86b3f84573d3/occlusion_8cd0c724-d3d0-4821-a88b-42b03ae4eb07/scan_b3dee852-769a-40d5-9c59-f651659a9d74/48_w1_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_685697a1-0d50-4a06-8b3e-729cf9750f38_ACT_e1d214d2-2b62-484c-8ede-86b3f84573d3_SESS_8cd0c724-d3d0-4821-a88b-42b03ae4eb07_RISC_b3dee852-769a-40d5-9c59-f651659a9d74_MODEL','48_w1_o1_mordu_posterieur_droit_scan_file_0.zip','f6e0525e-a065-4d5a-98b2-1a444413c722','{\"displayTitle\":\"Posterior right bite 1.48.1.1.2\",\"modelMatrix\":\"0.967277,-0.236294,0.0850485,0,0.228335,0.969083,0.0943311,0,-0.110791,-0.071028,0.99192,0,-12.0722,2.11951,-19.8858,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-10-17 17:13:59.000','2024-10-31 14:02:35.365','2024-10-31 10:02:35.365'),('f6f7c4d2-5903-4304-a422-d9bb1e118dc3',664,'/var/.data/2021/664/ac1cc354-e34f-4afd-b66f-dadc541bcd93/session_765f3df2-2bc5-4851-8d74-c8af7e48c919/occlusion_8d9c33a0-de56-424c-93dc-582bac72d320/scan_ec92e295-bf7c-4746-b7d5-8b1307a8e6ac/21_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_ac1cc354-e34f-4afd-b66f-dadc541bcd93_ACT_765f3df2-2bc5-4851-8d74-c8af7e48c919_SESS_8d9c33a0-de56-424c-93dc-582bac72d320_RISC_ec92e295-bf7c-4746-b7d5-8b1307a8e6ac_MODEL','21_w1_o1_mordu_posterieur_droit_scan_file_0.ply','f6f7c4d2-5903-4304-a422-d9bb1e118dc3','{\"displayTitle\":\"Posterior right bite PLY\",\"modelMatrix\":\"0.998962,0.0342756,-0.0147565,0,-0.0380458,0.982045,0.190983,0,0.0266378,-0.185742,0.981503,0,-17.2554,11.9409,-14.7765,1\",\"title\":\"Posterior right bite PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-04-28 18:55:01.000','2024-10-31 14:02:26.044','2024-10-31 10:02:26.044'),('f7956a29-1664-4e5a-9aad-2a53021be43e',664,'/var/.data/2022/664/6d99007d-a6df-43ae-87db-c160f6e66c0d/session_04e0da18-656d-4d28-ad6d-e20cdfe5e2df/occlusion_f8861160-453a-4b8d-be85-cc6e323c9bd7/scan_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20/37_w2_o1_mandibule_ml_0_0.xyz','PATIENT_6d99007d-a6df-43ae-87db-c160f6e66c0d_ACT_04e0da18-656d-4d28-ad6d-e20cdfe5e2df_SESS_f8861160-453a-4b8d-be85-cc6e323c9bd7_BOSC_3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20_LIFI','37_w2_o1_mandibule_ml_0_0.xyz','f7956a29-1664-4e5a-9aad-2a53021be43e','{\"displayTitle\":\"Margin line Mandible 1.37.2.1.1 Margin line 0\",\"name\":\"Margin line 0\",\"title\":\"Mandible LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2022-11-02 19:31:37.000','2024-10-31 14:02:35.688','2024-10-31 10:02:35.688'),('f7b69658-7329-44b7-94d8-6d69422ec7fd',664,'/var/.data/2021/664/ebb7ec01-03db-43d2-bf9a-bc250f69d307/session_e530f0de-323f-4c29-bb17-b5bfe0da3afd/occlusion_1f19aa7f-35eb-4878-b743-abbe8cf73f08/scan_f7ca22c1-70d3-4f9e-8ccd-3187aea91801/5_w1_o1_maxillaire_snapshot_0.png','PATIENT_ebb7ec01-03db-43d2-bf9a-bc250f69d307_ACT_e530f0de-323f-4c29-bb17-b5bfe0da3afd_SESS_1f19aa7f-35eb-4878-b743-abbe8cf73f08_TOSC_f7ca22c1-70d3-4f9e-8ccd-3187aea91801_SNAPS','5_w1_o1_maxillaire_snapshot_0.png','f7b69658-7329-44b7-94d8-6d69422ec7fd','{\"displayTitle\":\"Maxilla 1.5.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-18 19:22:04.000','2024-10-31 14:02:25.895','2024-10-31 10:02:25.895'),('f815490e-f81e-42e5-a1f8-60b9fd7b4f23',664,'','PATIENT_73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9_ACT_705960fa-3ed4-4013-9cde-20022721d122_SESS_9f4fa7cb-81a3-460e-b189-ba76eb8cee15_BOSC_a58436fa-a729-4ed0-9312-1037d7bc8f6e_SNAPS','7_w8_o1_mandibule_snapshot_0.png','f815490e-f81e-42e5-a1f8-60b9fd7b4f23','{\"displayTitle\":\"Mandible 1.7.8.1.1\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:09:18.000','2022-03-30 10:49:30.000','2024-10-31 14:02:28.897','2024-10-31 10:02:28.897'),('f81ac2c3-1a0f-4064-a1eb-844d818e111c',664,'/var/.data/2021/664/f67a1372-95d6-445a-856a-13c1610ee937/session_babd9189-73c6-4ebf-95c9-fc1de28820bf/occlusion_7d40798f-7207-4c33-aa42-10afc814de77/scan_c5b26299-5fb8-4823-8b1a-c620bba14794/10_w1_o1_maxillaire_snapshot_0.png','PATIENT_f67a1372-95d6-445a-856a-13c1610ee937_ACT_babd9189-73c6-4ebf-95c9-fc1de28820bf_SESS_7d40798f-7207-4c33-aa42-10afc814de77_TOSC_c5b26299-5fb8-4823-8b1a-c620bba14794_SNAPS','10_w1_o1_maxillaire_snapshot_0.png','f81ac2c3-1a0f-4064-a1eb-844d818e111c','{\"displayTitle\":\"Maxilla 1.10.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-06-29 19:55:41.000','2024-10-31 14:02:32.371','2024-10-31 10:02:32.371'),('f8441bd9-d349-4766-abce-8df915b76b37',664,'/var/.data/2022/664/1a7a13ce-3a47-487b-8f16-db331e2672da/session_06c2562e-49fa-4926-ab49-41fe223d844d/occlusion_775311e4-a561-40c7-a2ce-76a0b1550be8/scan_ffb4d4c8-4774-4512-bb36-ac65c37d00a5/41_w1_o1_mandibule_snapshot_0.png','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_775311e4-a561-40c7-a2ce-76a0b1550be8_BOSC_ffb4d4c8-4774-4512-bb36-ac65c37d00a5_SNAPS','41_w1_o1_mandibule_snapshot_0.png','f8441bd9-d349-4766-abce-8df915b76b37','{\"displayTitle\":\"Mandible 1.41.1.1.2\",\"title\":\"Mandible SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-01 14:34:57.000','2024-10-31 14:02:31.731','2024-10-31 10:02:31.731'),('f8736908-df16-4fae-af3c-e8baa5f0f69d',664,'/var/.data/2021/664/17cc8b8c-6280-4e69-ad1e-731bdd9819e0/session_f9cb9561-eacc-4b43-976b-dfa67a953a80/occlusion_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910/scan_b8399067-4ae2-4f64-a407-d8870e0e66ec/19_w1_o1_maxillaire_snapshot_0.png','PATIENT_17cc8b8c-6280-4e69-ad1e-731bdd9819e0_ACT_f9cb9561-eacc-4b43-976b-dfa67a953a80_SESS_aa5b4efd-a5ce-428d-b35f-dd2bc2c28910_TOSC_b8399067-4ae2-4f64-a407-d8870e0e66ec_SNAPS','19_w1_o1_maxillaire_snapshot_0.png','f8736908-df16-4fae-af3c-e8baa5f0f69d','{\"displayTitle\":\"Maxilla 1.19.1.1.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-04-09 19:34:55.000','2024-10-31 14:02:25.744','2024-10-31 10:02:25.744'),('f927cde7-cbe9-4c1b-ba83-38aaf41336af',664,'','PATIENT_7eac18e5-5ed2-4ed9-8b3e-eba1c562d708_ACT_c49716f1-987e-4111-9ab9-4541a0378bb7_SESS_9a395a3e-4872-409e-922b-4bb58053d8a5_BOSC_5478f37b-d39e-46d1-a026-906c02d9c928_MODEL','30_w1_o1_mandibule_scan_file_4.zip','4baca937-885c-4f87-88b2-c1c5ac9e24e5','{\"displayTitle\":\"Mandible 1.30.1.1.1\",\"modelMatrix\":\"-0.865653,-0.4976,0.055126,0,0.500644,-0.86039,0.0953173,0,1.60392e-09,0.11011,0.993919,0,6.92949,3.13395,-20.7317,1\",\"title\":\"Mandible ZIP\"}','ZIP',4,'SYNCED',0,'2023-05-22 09:09:20.000','2022-03-21 10:32:00.000','2024-10-31 14:02:28.829','2024-10-31 10:02:28.829'),('f97c6eef-a142-496a-ae7e-c91c3f7c2cc6',664,'/var/.data/2022/664/e33159c9-a713-4a37-ba98-9ec2e2e213e7/session_b63ca765-4d68-4cf4-9707-4ad3a19f3236/occlusion_ae7f89c9-26ec-4cee-b377-d5145e6c6aae/scan_02523859-58d9-4417-a657-9de246f248ae/50_w1_o1_maxillaire_snapshot_0.png','PATIENT_e33159c9-a713-4a37-ba98-9ec2e2e213e7_ACT_b63ca765-4d68-4cf4-9707-4ad3a19f3236_SESS_ae7f89c9-26ec-4cee-b377-d5145e6c6aae_TOSC_02523859-58d9-4417-a657-9de246f248ae_SNAPS','50_w1_o1_maxillaire_snapshot_0.png','f97c6eef-a142-496a-ae7e-c91c3f7c2cc6','{\"displayTitle\":\"Maxilla 1.50.1.1.3\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-14 18:12:07.000','2024-10-31 14:02:36.166','2024-10-31 10:02:36.166'),('f9815921-9467-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_c2dbac17-9467-11ee-8fd8-58a023cda0dc/f9815921-9467-11ee-8fd8-58a023cda0dc.zip','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_RISC_c2dbac17-9467-11ee-8fd8-58a023cda0dc_MODEL','f9815921-9467-11ee-8fd8-58a023cda0dc.zip','f9815921-9467-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Right bite 1.55.1.1.1\",\"modelMatrix\":\"0.994831,-0.106158,-0.00235162,0,0.101641,0.993894,0.0307059,0,-0.00126393,-0.0304353,0.999526,0,-11.3608,3.34522,-18.3257,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-12-11 10:12:32.000','2024-10-31 14:02:37.417','2024-10-31 10:02:37.417'),('f981687a-9467-11ee-8fd8-58a023cda0dc',664,'/var/.data/2023/664/ae72aa8e-9461-11ee-8fd8-58a023cda0dc/session_d4b83bce-9462-11ee-8fd8-58a023cda0dc/occlusion_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc/scan_c2dbac17-9467-11ee-8fd8-58a023cda0dc/f981687a-9467-11ee-8fd8-58a023cda0dc.png','PATIENT_ae72aa8e-9461-11ee-8fd8-58a023cda0dc_ACT_d4b83bce-9462-11ee-8fd8-58a023cda0dc_SESS_d4b9a9b2-9462-11ee-8fd8-58a023cda0dc_RISC_c2dbac17-9467-11ee-8fd8-58a023cda0dc_SNAPS','f981687a-9467-11ee-8fd8-58a023cda0dc.png','f981687a-9467-11ee-8fd8-58a023cda0dc','{\"displayTitle\":\"Right bite 1.55.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-12-11 10:12:32.000','2024-10-31 14:02:37.427','2024-10-31 10:02:37.427'),('f9de7f19-6e65-4dee-aecb-417188d3c5c0',664,'','PATIENT_1a7a13ce-3a47-487b-8f16-db331e2672da_ACT_06c2562e-49fa-4926-ab49-41fe223d844d_SESS_21bbefd5-8dc0-4e41-91d8-718463ad469c_TOSC_7d660b43-6b91-4c1b-b004-a0aa4d714d00_SNAPS','41_w1_o3_maxillaire_snapshot_0.png','f9de7f19-6e65-4dee-aecb-417188d3c5c0','{\"displayTitle\":\"Maxilla 1.41.1.3.1\",\"title\":\"Maxilla SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-05-22 09:09:20.000','2022-08-03 09:49:49.000','2024-10-31 14:02:31.924','2024-10-31 10:02:31.924'),('fa2571a4-653f-11ef-b382-58a023cda0dc',664,'/var/.data/2024/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_721d0cdd-6536-11ef-b382-58a023cda0dc/occlusion_721e3ad7-6536-11ef-b382-58a023cda0dc/scan_4b6e42bc-653f-11ef-b382-58a023cda0dc/fa2571a4-653f-11ef-b382-58a023cda0dc.zip','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_721d0cdd-6536-11ef-b382-58a023cda0dc_SESS_721e3ad7-6536-11ef-b382-58a023cda0dc_BOSC_4b6e42bc-653f-11ef-b382-58a023cda0dc_MODEL','fa2571a4-653f-11ef-b382-58a023cda0dc.zip','fa2571a4-653f-11ef-b382-58a023cda0dc','{\"displayTitle\":\"Mandible 1.35.2.1.1\",\"modelMatrix\":\"0.616404,0.723862,-0.309953,0,-0.78743,0.566642,-0.242632,0,1.52927e-09,0.393626,0.919271,0,-29.0787,-14.3801,-18.1703,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-08-28 09:25:38.000','2024-08-28 13:38:47.202','2024-08-28 09:38:47.202'),('fa258235-653f-11ef-b382-58a023cda0dc',664,'/var/.data/2024/664/509319d0-6cf3-4073-92e1-ff9307be4376/session_721d0cdd-6536-11ef-b382-58a023cda0dc/occlusion_721e3ad7-6536-11ef-b382-58a023cda0dc/scan_4b6e42bc-653f-11ef-b382-58a023cda0dc/fa258235-653f-11ef-b382-58a023cda0dc.png','PATIENT_509319d0-6cf3-4073-92e1-ff9307be4376_ACT_721d0cdd-6536-11ef-b382-58a023cda0dc_SESS_721e3ad7-6536-11ef-b382-58a023cda0dc_BOSC_4b6e42bc-653f-11ef-b382-58a023cda0dc_SNAPS','fa258235-653f-11ef-b382-58a023cda0dc.png','fa258235-653f-11ef-b382-58a023cda0dc','{\"displayTitle\":\"Mandible 1.35.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-08-28 09:25:38.000','2024-08-28 13:38:47.216','2024-08-28 09:38:47.216'),('fb88a068-9ecf-4df8-a63d-72081fd4e147',664,'/var/.data/2022/664/eb3fb44e-7c5f-4ae3-a907-fdcec841501c/session_fc32fcc1-f66c-42d5-93d9-1379911add0c/order_1e218460-1625-4cb2-b347-dcad66378660/49_w1_couronne_sur_implant_prost_file_fb88a068-9ecf-4df8-a63d-72081fd4e147_0.pdf','PATIENT_eb3fb44e-7c5f-4ae3-a907-fdcec841501c_ACT_fc32fcc1-f66c-42d5-93d9-1379911add0c_PROST_1e218460-1625-4cb2-b347-dcad66378660_FORM','49_w1_couronne_sur_implant_prost_file_fb88a068-9ecf-4df8-a63d-72081fd4e147_0.pdf','fb88a068-9ecf-4df8-a63d-72081fd4e147','{\"displayTitle\":\"ORDER 1.49.1.5 IMPLANT CROWN (Carol Hicks)\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'CREATED',0,NULL,'2022-11-22 18:46:43.000','2023-05-17 17:16:39.559',NULL),('fbd69925-e519-4ae3-aced-20afc89720dd',664,'/var/.data/2022/664/48a38618-e853-4bf0-aa6b-4c83fb8b6f13/session_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d/occlusion_540d878b-7415-4498-8c6c-01875eec35f8/scan_e145920a-617c-4eab-b810-0a863371eb36/38_w1_o1_mandibule_scan_file_0.zip','PATIENT_48a38618-e853-4bf0-aa6b-4c83fb8b6f13_ACT_c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d_SESS_540d878b-7415-4498-8c6c-01875eec35f8_BOSC_e145920a-617c-4eab-b810-0a863371eb36_MODEL','38_w1_o1_mandibule_scan_file_0.zip','fbd69925-e519-4ae3-aced-20afc89720dd','{\"displayTitle\":\"Mandible 1.38.1.1.2\",\"modelMatrix\":\"-0.192851,0.968845,-0.155396,0,-0.981228,-0.190417,0.0305416,0,-1.56216e-09,0.158369,0.98738,0,10.548,-21.7412,-18.0586,1\",\"title\":\"Mandible ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-22 16:54:43.000','2024-10-31 14:02:29.874','2024-10-31 10:02:29.874'),('fbef9cf1-1cb4-49e9-88af-626767272b04',664,'/var/.data/2022/664/635617fc-289b-470c-a4d4-678d7b5f275a/session_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6/order_b3fd7ab4-7c7c-487a-96e9-21275b318b80/45_w1_couronne_sur_implant_prost_file_fbef9cf1-1cb4-49e9-88af-626767272b04_0.pdf','PATIENT_635617fc-289b-470c-a4d4-678d7b5f275a_ACT_bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6_PROST_b3fd7ab4-7c7c-487a-96e9-21275b318b80_FORM','45_w1_couronne_sur_implant_prost_file_fbef9cf1-1cb4-49e9-88af-626767272b04_0.pdf','fbef9cf1-1cb4-49e9-88af-626767272b04','{\"displayTitle\":\"ORDER 1.45.1.5 IMPLANT CROWN (Gilboy Andrew)\",\"title\":\"Couronne sur Implant PDF\"}','PDF',0,'CREATED',0,NULL,'2022-11-22 18:50:04.000','2023-05-17 17:16:39.559',NULL),('fc458668-4919-430f-9240-de8f220a4dea',664,'/var/.data/2022/664/e33159c9-a713-4a37-ba98-9ec2e2e213e7/session_b63ca765-4d68-4cf4-9707-4ad3a19f3236/occlusion_ae7f89c9-26ec-4cee-b377-d5145e6c6aae/scan_f7d86e35-41e6-4047-8f44-4a7b73bc2680/50_w1_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_e33159c9-a713-4a37-ba98-9ec2e2e213e7_ACT_b63ca765-4d68-4cf4-9707-4ad3a19f3236_SESS_ae7f89c9-26ec-4cee-b377-d5145e6c6aae_RISC_f7d86e35-41e6-4047-8f44-4a7b73bc2680_MODEL','50_w1_o1_mordu_posterieur_droit_scan_file_0.zip','fc458668-4919-430f-9240-de8f220a4dea','{\"displayTitle\":\"Posterior right bite 1.50.1.1.1\",\"modelMatrix\":\"0.964751,0.0910911,0.243825,0,-0.109533,0.993326,0.0456654,0,-0.239324,-0.0708703,0.968746,0,-6.9048,2.41539,-22.0133,1\",\"title\":\"Posterior right bite ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-14 18:20:21.000','2024-10-31 14:02:36.207','2024-10-31 10:02:36.207'),('fcb6f107-6c34-11ee-bc7f-58a023cda0dc',664,'/var/.data/2023/664/bbc77872-6c30-11ee-bc7f-58a023cda0dc/session_0a963705-6c31-11ee-bc7f-58a023cda0dc/occlusion_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc/scan_17461a17-6c34-11ee-bc7f-58a023cda0dc/fcb6f107-6c34-11ee-bc7f-58a023cda0dc.zip','PATIENT_bbc77872-6c30-11ee-bc7f-58a023cda0dc_ACT_0a963705-6c31-11ee-bc7f-58a023cda0dc_SESS_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc_TOSC_17461a17-6c34-11ee-bc7f-58a023cda0dc_MODEL','fcb6f107-6c34-11ee-bc7f-58a023cda0dc.zip','fcb6f107-6c34-11ee-bc7f-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.53.1.1.1\",\"modelMatrix\":\"-0.497515,0.82439,-0.269925,0,-0.867455,-0.472816,0.154811,0,-6.36672e-09,0.311168,0.950355,0,18.0961,-18.6347,-16.4115,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-10-16 13:05:19.000','2023-10-16 17:12:49.422','2023-10-16 13:12:49.422'),('fcb700b3-6c34-11ee-bc7f-58a023cda0dc',664,'/var/.data/2023/664/bbc77872-6c30-11ee-bc7f-58a023cda0dc/session_0a963705-6c31-11ee-bc7f-58a023cda0dc/occlusion_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc/scan_17461a17-6c34-11ee-bc7f-58a023cda0dc/fcb700b3-6c34-11ee-bc7f-58a023cda0dc.png','PATIENT_bbc77872-6c30-11ee-bc7f-58a023cda0dc_ACT_0a963705-6c31-11ee-bc7f-58a023cda0dc_SESS_0a97fa8b-6c31-11ee-bc7f-58a023cda0dc_TOSC_17461a17-6c34-11ee-bc7f-58a023cda0dc_SNAPS','fcb700b3-6c34-11ee-bc7f-58a023cda0dc.png','fcb700b3-6c34-11ee-bc7f-58a023cda0dc','{\"displayTitle\":\"Maxilla 1.53.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-10-16 13:05:20.000','2023-10-16 17:12:49.436','2023-10-16 13:12:49.436'),('fdc7cf45-27ee-493e-893d-702f5a989b40',664,'/var/.data/2022/664/36e86f3f-4468-4cf2-9505-462288cae8b1/session_cc413c24-b371-4a75-9cfe-451a8d54e32e/occlusion_7af02eaf-c13f-4389-b2dd-b2cbdfb137e6/scan_bbd16c8e-e7dc-4578-8027-d6b5d16e2cce/36_w1_o1_maxillaire_scan_file_0.zip','PATIENT_36e86f3f-4468-4cf2-9505-462288cae8b1_ACT_cc413c24-b371-4a75-9cfe-451a8d54e32e_SESS_7af02eaf-c13f-4389-b2dd-b2cbdfb137e6_TOSC_bbd16c8e-e7dc-4578-8027-d6b5d16e2cce_MODEL','36_w1_o1_maxillaire_scan_file_0.zip','fdc7cf45-27ee-493e-893d-702f5a989b40','{\"displayTitle\":\"Maxilla 1.36.1.1.1\",\"modelMatrix\":\"-0.774516,-0.0319467,-0.631747,0,-0.632554,0.0391164,0.773528,0,-2.29843e-10,0.998724,-0.0505043,0,-3.936,-36.8712,-2.23661,1\",\"title\":\"Maxilla ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-20 19:29:58.000','2024-10-31 14:02:29.701','2024-10-31 10:02:29.701');
/*!40000 ALTER TABLE `File` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `MessageStatus` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `contactId` varchar(36) NOT NULL,
  `status` enum('UNDELIVERED','DELIVERED','TRANSMITTED') NOT NULL DEFAULT 'UNDELIVERED',
  `bcc` tinyint(1) NOT NULL DEFAULT '0',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`sentMessageId`,`contactId`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `MessageStatus_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_3` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
INSERT INTO `MessageStatus` VALUES (664,'02eb4a7d-724b-45a4-b765-f2b70e2d92f4','a9f86ae2-32af-4481-85e9-dfb308b189d9','TRANSMITTED',0,'2022-11-02 20:14:28.000'),(664,'0899ea9b-9c55-4426-b781-2c58435f34d4','a9f86ae2-32af-4481-85e9-dfb308b189d9','TRANSMITTED',0,'2022-11-19 02:59:04.000'),(664,'0e34b99d-b761-42f5-8ea8-376d97ca8739','b268deab-1616-4c93-8eb0-0d9d60d5a2cf','TRANSMITTED',0,'2022-08-02 01:55:14.000'),(664,'17b49d95-96c1-44f3-a13f-7fbc2a688cac','27738253-c98b-484b-bef6-ccf9ca5966b5','TRANSMITTED',0,'2020-09-16 16:17:32.000'),(664,'1bb37b3b-87fe-4c38-9db3-ca8953b26747','a9f86ae2-32af-4481-85e9-dfb308b189d9','TRANSMITTED',0,'2022-11-09 23:34:15.000'),(664,'1cab555c-33d9-4ee5-a027-8587b9275bdf','e54862ac-483f-4776-967b-4f90b849a4a5','TRANSMITTED',0,'2022-06-20 23:48:21.000'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','6da705c7-2e8e-476b-af63-a98ce37120b7','TRANSMITTED',0,'2023-12-06 18:01:29.735'),(664,'2813a60f-59c5-472a-899c-cd2844c9f1b4','e54862ac-483f-4776-967b-4f90b849a4a5','TRANSMITTED',0,'2022-05-27 02:27:06.000'),(664,'2b5a9f4b-c501-489a-9405-cdb62d0bbc00','c4e61cbc-8053-4d5b-8aef-9a5def3229ea','TRANSMITTED',0,'2022-09-08 04:58:43.000'),(664,'30c4fa4c-6546-11ef-b382-58a023cda0dc','e54862ac-483f-4776-967b-4f90b849a4a5','DELIVERED',0,'2024-08-28 14:02:41.554'),(664,'312b8a43-767d-48c0-a3a7-92183f4e598d','b268deab-1616-4c93-8eb0-0d9d60d5a2cf','TRANSMITTED',0,'2022-08-02 01:55:17.000'),(664,'31ac96c0-ec22-40c1-8e5e-2d287834aa73','b268deab-1616-4c93-8eb0-0d9d60d5a2cf','TRANSMITTED',0,'2022-10-19 23:36:11.000'),(664,'3870c963-98f5-11ee-ae49-58a023cda0dc','6da705c7-2e8e-476b-af63-a98ce37120b7','TRANSMITTED',0,'2024-08-28 12:07:33.352'),(664,'38f9f5c6-6c47-11ee-bc7f-58a023cda0dc','6da705c7-2e8e-476b-af63-a98ce37120b7','TRANSMITTED',0,'2023-10-16 17:14:21.963'),(664,'3f66d9ef-6546-11ef-b382-58a023cda0dc','e54862ac-483f-4776-967b-4f90b849a4a5','DELIVERED',0,'2024-08-28 14:03:06.346'),(664,'4020e0da-3c61-4de8-8773-080aa456c009','b268deab-1616-4c93-8eb0-0d9d60d5a2cf','TRANSMITTED',0,'2022-06-24 01:53:17.000'),(664,'40662f0a-569d-4339-8052-9982814995b7','ec4237a8-5baf-46b4-9e49-ab1b68950d8a','TRANSMITTED',0,'2022-11-02 23:06:40.000'),(664,'4492229d-1dd5-424d-b44a-d512d766a927','a9f86ae2-32af-4481-85e9-dfb308b189d9','TRANSMITTED',0,'2022-11-19 02:59:04.000'),(664,'45f23b8d-97e8-4dba-adfd-67a6227ae338','a9f86ae2-32af-4481-85e9-dfb308b189d9','TRANSMITTED',0,'2022-11-03 00:51:22.000'),(664,'4650a221-de48-447d-a404-38136acdf9c5','c4e61cbc-8053-4d5b-8aef-9a5def3229ea','TRANSMITTED',0,'2022-10-24 23:05:32.000'),(664,'4a905926-f342-4536-be48-297fcd6ce94c','e54862ac-483f-4776-967b-4f90b849a4a5','TRANSMITTED',0,'2022-08-31 02:46:28.000'),(664,'4ce6c6c0-20c5-47b3-84da-269ded4b6b00','584dad71-0252-4c8a-a9b4-bc17eae4eb58','DELIVERED',0,'2022-03-24 20:48:33.000'),(664,'4eb79126-8d42-40c3-9283-dadd0f184492','b268deab-1616-4c93-8eb0-0d9d60d5a2cf','TRANSMITTED',0,'2022-06-24 01:53:18.000'),(664,'5cf539fe-0495-4bf9-95f2-fef22c4769c9','b2600e32-7030-4e6b-a270-8b2cbccee7b7','DELIVERED',0,'2022-11-21 21:46:15.000'),(664,'63ce1a1c-7317-47c6-9579-0d6584f9be19','c4e61cbc-8053-4d5b-8aef-9a5def3229ea','TRANSMITTED',0,'2022-10-24 23:05:32.000'),(664,'657a3e0b-c8c5-43eb-84b4-c6e4f07c2427','584dad71-0252-4c8a-a9b4-bc17eae4eb58','DELIVERED',0,'2021-04-14 20:11:47.000'),(664,'6585cd89-469b-4e98-a0e8-0b2539e808ea','a9f86ae2-32af-4481-85e9-dfb308b189d9','TRANSMITTED',0,'2022-11-19 01:36:00.000'),(664,'67bda280-82bd-4a27-9cb8-454b63cbe107','b268deab-1616-4c93-8eb0-0d9d60d5a2cf','TRANSMITTED',0,'2022-08-02 01:55:14.000'),(664,'6d86b11b-2a80-48db-afbb-8406b6a30275','a9f86ae2-32af-4481-85e9-dfb308b189d9','TRANSMITTED',0,'2022-11-18 22:32:35.000'),(664,'6ee9d5af-5943-4d28-85c9-7f6db88ee358','c4e61cbc-8053-4d5b-8aef-9a5def3229ea','TRANSMITTED',0,'2022-04-22 03:11:20.000'),(664,'7c330c2d-c6cb-4727-bb49-9863b9e315e8','b268deab-1616-4c93-8eb0-0d9d60d5a2cf','TRANSMITTED',0,'2022-08-02 01:55:14.000'),(664,'7c5bc381-bd68-4e38-b749-2453e0838c73','ec4237a8-5baf-46b4-9e49-ab1b68950d8a','TRANSMITTED',0,'2022-11-02 21:40:21.000'),(664,'7edb7a75-511b-4c11-a684-0b3dc33dff96','27738253-c98b-484b-bef6-ccf9ca5966b5','TRANSMITTED',0,'2020-09-17 15:48:40.000'),(664,'7edd9ae1-a3ee-449f-abd5-87c016cbd64d','ec4237a8-5baf-46b4-9e49-ab1b68950d8a','TRANSMITTED',0,'2022-11-02 21:40:21.000'),(664,'808c50bc-1526-4678-a59f-f5ed0fb0352d','c4e61cbc-8053-4d5b-8aef-9a5def3229ea','TRANSMITTED',0,'2022-04-22 03:11:19.000'),(664,'81e8d9b6-71da-46dc-aea0-8a0e3350ff29','ec4237a8-5baf-46b4-9e49-ab1b68950d8a','TRANSMITTED',0,'2022-11-02 21:40:21.000'),(664,'82a515f9-6e05-412a-a8de-d3bac6d8791d','a9f86ae2-32af-4481-85e9-dfb308b189d9','TRANSMITTED',0,'2022-11-03 00:51:22.000'),(664,'832a3fdc-5bca-11ee-9658-58a023cda0dc','6da705c7-2e8e-476b-af63-a98ce37120b7','TRANSMITTED',0,'2023-10-16 17:14:14.285'),(664,'83f80607-1e2a-4c52-8600-be57c613744d','e54862ac-483f-4776-967b-4f90b849a4a5','TRANSMITTED',0,'2022-10-04 02:14:52.000'),(664,'8bf6f487-0fe1-4e58-81a8-e0f389a1a6a6','b268deab-1616-4c93-8eb0-0d9d60d5a2cf','TRANSMITTED',0,'2022-10-19 23:36:11.000'),(664,'8c9743cb-aa45-49b1-94cf-ecdc5ab4c384','a9f86ae2-32af-4481-85e9-dfb308b189d9','TRANSMITTED',0,'2022-11-02 20:16:37.000'),(664,'962895e0-52b2-4548-911c-d43951f6ad1a','e54862ac-483f-4776-967b-4f90b849a4a5','TRANSMITTED',0,'2022-11-23 00:50:50.000'),(664,'97babd5a-8b08-46c4-a562-84b349435266','c4e61cbc-8053-4d5b-8aef-9a5def3229ea','TRANSMITTED',0,'2022-04-22 03:11:19.000'),(664,'9857bf66-d888-4b85-8071-a4955cae2cdd','b268deab-1616-4c93-8eb0-0d9d60d5a2cf','TRANSMITTED',0,'2022-10-19 23:36:11.000'),(664,'a7c0ad33-6145-4914-9d5a-84e96e8b04a6','27738253-c98b-484b-bef6-ccf9ca5966b5','TRANSMITTED',0,'2020-09-16 16:17:32.000'),(664,'acf0cf3b-983c-11ee-86e7-58a023cda0dc','6da705c7-2e8e-476b-af63-a98ce37120b7','UNDELIVERED',0,'2023-12-11 15:48:06.199'),(664,'b2c8e030-2014-4690-bf36-3dcf8990abce','c4e61cbc-8053-4d5b-8aef-9a5def3229ea','TRANSMITTED',0,'2022-06-13 20:12:44.000'),(664,'b5692f4b-5fb5-423e-b503-87a537848fe8','e54862ac-483f-4776-967b-4f90b849a4a5','TRANSMITTED',0,'2022-11-23 00:50:50.000'),(664,'b921798c-b802-4d4f-89ee-371935deaf2a','c4e61cbc-8053-4d5b-8aef-9a5def3229ea','TRANSMITTED',0,'2022-04-22 03:11:19.000'),(664,'bcb19fdd-3ffa-47dc-a16e-ccd0f0f7bbae','b268deab-1616-4c93-8eb0-0d9d60d5a2cf','TRANSMITTED',0,'2022-08-05 01:17:45.000'),(664,'c0040108-f1d7-4bd9-b7f9-8a11656ae8fb','c4e61cbc-8053-4d5b-8aef-9a5def3229ea','TRANSMITTED',0,'2022-04-22 03:11:19.000'),(664,'c11221e7-edf7-4b28-b643-d363622ca661','584dad71-0252-4c8a-a9b4-bc17eae4eb58','TRANSMITTED',0,'2020-12-02 05:54:22.000'),(664,'cbcd0e02-772a-11ee-867e-58a023cda0dc','6da705c7-2e8e-476b-af63-a98ce37120b7','TRANSMITTED',0,'2023-12-06 18:01:29.757'),(664,'cdbd58cd-5db4-438b-b6c4-101b491c3235','1e3e6e1b-ec29-44ee-a407-1526d6e66955','TRANSMITTED',0,'2021-01-28 20:46:24.000'),(664,'d1df0f81-8279-49cb-bf1f-2248541a91e6','584dad71-0252-4c8a-a9b4-bc17eae4eb58','TRANSMITTED',0,'2020-12-02 05:54:22.000'),(664,'d74c9e6c-3411-4116-b2f7-f53ff93b7da3','b268deab-1616-4c93-8eb0-0d9d60d5a2cf','TRANSMITTED',0,'2022-10-19 23:36:11.000'),(664,'d8121021-7350-4948-8bdf-0fe8b2d6283b','a9f86ae2-32af-4481-85e9-dfb308b189d9','TRANSMITTED',0,'2022-11-19 01:22:30.000'),(664,'d83f68fb-6542-11ef-b382-58a023cda0dc','e54862ac-483f-4776-967b-4f90b849a4a5','TRANSMITTED',0,'2024-08-28 13:54:19.723'),(664,'d94c95de-4549-4e9d-af56-88e29787156d','584dad71-0252-4c8a-a9b4-bc17eae4eb58','TRANSMITTED',0,'2020-11-10 22:07:59.000'),(664,'da70408b-02a2-4dd2-955a-605ac5ea5057','b268deab-1616-4c93-8eb0-0d9d60d5a2cf','TRANSMITTED',0,'2022-10-19 23:36:11.000'),(664,'df83dd1e-b7e5-4215-9c46-8b8efef2401a','c4e61cbc-8053-4d5b-8aef-9a5def3229ea','TRANSMITTED',0,'2022-04-22 03:11:19.000'),(664,'e005f004-282d-4a2b-bd95-3e2e81eb2587','b268deab-1616-4c93-8eb0-0d9d60d5a2cf','TRANSMITTED',0,'2022-10-19 23:36:11.000'),(664,'e0cbd6cd-9843-11ee-86e7-58a023cda0dc','6da705c7-2e8e-476b-af63-a98ce37120b7','TRANSMITTED',0,'2023-12-11 16:46:57.870'),(664,'e7f35c33-b6ad-4aae-a7fb-14ae122ffc7a','ec4237a8-5baf-46b4-9e49-ab1b68950d8a','TRANSMITTED',0,'2022-09-21 22:21:16.000'),(664,'ea962fbd-a937-42fa-b118-9e91d226dec6','b268deab-1616-4c93-8eb0-0d9d60d5a2cf','TRANSMITTED',0,'2022-08-05 01:17:45.000'),(664,'f6d080bb-98f4-11ee-ae49-58a023cda0dc','6da705c7-2e8e-476b-af63-a98ce37120b7','TRANSMITTED',0,'2024-08-28 12:07:33.419'),(664,'faa1ab9d-5847-4cad-927c-b67accbae0be','27738253-c98b-484b-bef6-ccf9ca5966b5','TRANSMITTED',0,'2020-09-16 16:17:32.000'),(664,'fe2603b3-a459-4fb3-8c9f-8188f434db39','1fb6381c-3eb3-4354-b9f4-2560f4cf10a3','DELIVERED',0,'2020-11-04 02:13:53.000'),(664,'feaba3ab-2602-4dce-a209-46c76044a173','584dad71-0252-4c8a-a9b4-bc17eae4eb58','TRANSMITTED',0,'2020-12-02 05:54:22.000');
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Occlusion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sessionId` varchar(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'UNKNOWN',
  `displayId` mediumint unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `topScanId` varchar(36) DEFAULT NULL,
  `bottomScanId` varchar(36) DEFAULT NULL,
  `anteriorBiteScanId` varchar(36) DEFAULT NULL,
  `rightBiteScanId` varchar(36) DEFAULT NULL,
  `leftBiteScanId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  KEY `topScanId` (`topScanId`),
  KEY `bottomScanId` (`bottomScanId`),
  KEY `anteriorBiteScanId` (`anteriorBiteScanId`),
  KEY `rightBiteScanId` (`rightBiteScanId`),
  KEY `leftBiteScanId` (`leftBiteScanId`),
  CONSTRAINT `Occlusion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_3` FOREIGN KEY (`topScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_4` FOREIGN KEY (`bottomScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_5` FOREIGN KEY (`anteriorBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_6` FOREIGN KEY (`rightBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_7` FOREIGN KEY (`leftBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
INSERT INTO `Occlusion` VALUES ('54918a1f-bcc4-48fe-8e2c-4c14434e1683',664,'4aaf107a-b8db-4d45-befa-36e801ebc654','HEMI_ARCADE_POSTERIEUR_DROIT',1,0,'','669f6bca-452c-4b2e-a49e-aa822628ed5f','93be3b1e-bcd5-443a-a7e3-4f5452c470a6','20f1e04b-48d2-4b9a-b29b-2a62332288fb','416dd268-693a-4466-8380-8829fc1b5e3d','a283652c-095c-41a2-b62b-1cba87286c35','2021-09-13 15:31:59.000',NULL,'2021-09-13 15:31:31.000','2024-10-31 14:02:38.494','2024-10-31 10:02:38.494'),('5f6427a6-734f-11ee-b011-58a023cda0dc',664,'07e5f91d-734b-11ee-b011-58a023cda0dc','ARCADE_COMPLETE',1,0,'',NULL,NULL,NULL,NULL,NULL,'2023-10-25 11:58:43.000',NULL,'2023-10-25 11:59:30.000','2024-10-31 14:02:38.547','2024-10-31 10:02:38.547'),('82606157-5bc6-11ee-9658-58a023cda0dc',664,'eed0dd8b-572c-11ee-a378-58a023cda0dc','ARCADE_COMPLETE',1,0,'','ab0cf7a4-5bc3-11ee-9658-58a023cda0dc','cd138f1a-5bc2-11ee-9658-58a023cda0dc',NULL,'57e592a9-5bc2-11ee-9658-58a023cda0dc','ddf6985f-5bc1-11ee-9658-58a023cda0dc','2023-09-25 13:11:04.000',NULL,'2023-09-25 13:11:14.000','2024-10-31 14:02:38.533','2024-10-31 10:02:38.533'),('ee755fae-01ab-42b6-ab24-3f69c35031db',664,'8d9c33a0-de56-424c-93dc-582bac72d320','HEMI_ARCADE_POSTERIEUR_DROIT',1,0,'','eff3d296-ab91-4054-b8d3-6c78732ae1c8','5500928e-446a-45d8-af99-faf7375b1d49','79842b46-a1df-43a9-812e-4322f1c79203','ec92e295-bf7c-4746-b7d5-8b1307a8e6ac','6f4cc2d8-2239-4982-a8b0-33dc6be535ae','2021-04-28 19:03:49.000',NULL,'2021-04-28 19:03:49.000','2024-10-31 14:02:38.514','2024-10-31 10:02:38.514');
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `OcclusionFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `occlusionId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('RESULT','MANDIBLE','MAXILLARY','MANDIBLE_SB','MAXILLARY_SB','MANDIBLE_PRE','MAXILLARY_PRE','LIFI','LIFIMETA','SNAPSHOT','SCREENSHOT') DEFAULT 'RESULT',
  PRIMARY KEY (`occlusionId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `OcclusionFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_2` FOREIGN KEY (`occlusionId`) REFERENCES `Occlusion` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
INSERT INTO `OcclusionFile` VALUES (664,'54918a1f-bcc4-48fe-8e2c-4c14434e1683','340f95df-931e-4973-aae5-2272d3824fd5','SNAPSHOT'),(664,'54918a1f-bcc4-48fe-8e2c-4c14434e1683','51194a9a-7c48-4bc3-a1fe-6faf2241f59e','MAXILLARY'),(664,'54918a1f-bcc4-48fe-8e2c-4c14434e1683','9ee19de6-bb46-4887-a757-0060adbe2d61','MANDIBLE'),(664,'5f6427a6-734f-11ee-b011-58a023cda0dc','65c962f0-734f-11ee-b011-58a023cda0dc','MAXILLARY'),(664,'5f6427a6-734f-11ee-b011-58a023cda0dc','65f84d65-734f-11ee-b011-58a023cda0dc','MANDIBLE'),(664,'5f6427a6-734f-11ee-b011-58a023cda0dc','668d19f2-734f-11ee-b011-58a023cda0dc','SNAPSHOT'),(664,'82606157-5bc6-11ee-9658-58a023cda0dc','87bdb983-5bc6-11ee-9658-58a023cda0dc','MAXILLARY'),(664,'82606157-5bc6-11ee-9658-58a023cda0dc','87e4fb11-5bc6-11ee-9658-58a023cda0dc','MANDIBLE'),(664,'82606157-5bc6-11ee-9658-58a023cda0dc','88698a51-5bc6-11ee-9658-58a023cda0dc','SNAPSHOT');
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Office` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text,
  `country` varchar(75) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `Office_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
INSERT INTO `Office` VALUES ('07a4901a-a73e-414b-bafe-ff42d883049b',3,'542138759','Condor','','Labège','31670','137 rue Garance','France',NULL,'2019-07-01 14:13:31.000','2019-07-01 12:13:31.000','2019-07-01 14:13:31.000'),('09bb3702-3f43-4ce5-ad8a-908c06769338',1101,'','','','','','','',NULL,'2022-11-02 15:44:42.000','2022-11-02 19:44:42.000','2022-11-02 15:44:42.000'),('12faf4c9-95d6-4c4f-b641-481c29111d9a',7,'0664864059','DENTAL CUB','','MERIGNAC','33700','10 av jean mazaryck,','France',NULL,'2019-07-09 11:35:13.000','2019-07-09 15:35:13.000','2019-07-09 11:35:13.000'),('154a4de3-195d-4db2-808b-eb7fdde93786',1102,'8138035662','Ameri-Dent Dental Lab','','TAMPA','33635','13529 Prestige Pl Suite 112','United States of America',NULL,'2022-11-02 16:08:49.000','2022-11-02 20:08:49.000','2022-11-02 16:08:49.000'),('179ab10a-4b77-4b31-a7c1-386f7e9d1cef',224,'0660850205','Cabinet (default)','','LABEGE','','RUE GARANCE','France',NULL,'2019-09-09 15:36:36.000','2019-09-09 13:36:36.000','2019-09-09 15:36:36.000'),('1968410e-356a-468d-9571-2a80bed10822',33,'','Cabinet (default)','','','','','',NULL,'2019-07-15 14:34:40.000','2019-07-15 12:34:40.000','2019-07-15 14:34:40.000'),('1bfbf5f0-617e-4681-9665-42e6063278dc',918,'0142502324','Cabinet (default)','','Paris','','','France',NULL,'2021-04-29 16:03:23.000','2021-04-29 14:05:22.000','2021-04-29 16:05:22.000'),('1d4a2a5f-e540-458c-9db2-a070d38387b7',377,'437578841','cabinet dentaire place guichard','','LYON','69003','51 rue moncey','France',NULL,'2018-03-07 14:03:02.000','2019-10-28 14:10:33.000','2019-10-28 15:10:33.000'),('1e36ad84-f72d-44ff-b676-50865038fb48',1033,'17039999586','Pink Dental ','www.pinkdentalusa.com','Dulles','20166','21525 Ridgetop Circle Suite 280','United States',NULL,'2022-03-24 13:23:22.000','2022-03-24 17:23:22.000','2022-03-24 13:23:22.000'),('220bc91c-a04c-441c-b739-e3808bebfed1',788,'813-810-8042','Cabinet (default)','','Tampa','','','United States',NULL,'2020-11-03 21:14:48.000','2020-11-04 02:18:32.000','2020-11-03 21:18:32.000'),('27f156ab-dc42-4425-ae10-2443070d284b',177,'660474450','BIOTECH','','LEGANES','28916','AVDA. JUAN CARAMUEL,1','España',NULL,'2019-08-26 11:09:47.000','2019-08-26 09:09:47.000','2019-08-26 11:09:47.000'),('2c822df5-84aa-43f3-9549-f6136016045e',840,'','Cabinet (default)','','','','','',NULL,'2021-01-22 16:28:38.000','2021-01-22 15:28:38.000','2021-01-22 16:28:38.000'),('3816feb6-c195-4320-998b-a62b9ecf900f',1166,'1-800-931-1554','','','Las Vegas','','','United States of America',NULL,'2023-09-25 13:19:51.000','2023-09-25 17:23:17.575','2023-09-25 13:23:17.575'),('3af72df3-9568-4dde-97f7-96eb90a6cd8c',1210,'9802370504','Fitzgerald Dental Studio','','Matthews','28105','1135 Four Lakes Dr Suite I','France',NULL,'2024-08-29 10:14:27.000','2024-08-29 14:14:28.103','2024-08-29 10:14:28.103'),('3d7661f6-e77c-493d-9c2d-45d83cac165e',355,'+390521221362','GIANLUCA DALLATANA','www.uniontech.it','Parma','43122','Rocco Bormioli, 5/A','Italia',NULL,'2019-10-23 12:56:54.000','2019-10-23 10:56:54.000','2019-10-23 12:56:54.000'),('41ba57f5-3de1-4a9c-b28c-4a17c7f8885f',681,'0627204198','Cabinet (default)','','Chamalières ','','','France',NULL,'2020-05-29 09:10:29.000','2020-06-02 20:16:29.000','2020-06-02 22:16:29.000'),('4305cd87-b752-48f5-8ec6-7a8f908df121',1050,'14103812928','Uni Dental','','COLUMBIA','21045-5274','7120 MINSTREL WAY STE 105','France',NULL,'2022-05-25 20:11:37.000','2022-05-26 00:11:37.000','2022-05-25 20:11:37.000'),('4778c062-a392-4a7a-9245-e0c304734aa7',850,'0450943901','BOURDELLE','','BOEGE','74420','52 RUE DU BOURNO','France',NULL,'2021-02-01 14:49:44.000','2021-02-01 13:49:44.000','2021-02-01 14:49:44.000'),('5212d490-e583-4634-b55a-d6698ab60fcf',838,'','Cabinet (default)','','','','','',NULL,'2021-01-22 14:37:07.000','2021-01-22 13:37:07.000','2021-01-22 14:37:07.000'),('544e3fb2-5e62-472f-b606-7185054c1396',9,'0149698526','Laboratoire LDA','www.laboratoirelda.com','Villiers Sur Marne','94350','1 rue de la fraternité','France',NULL,'2019-07-02 11:36:03.000','2019-07-02 15:36:03.000','2019-07-02 11:36:03.000'),('57d938bf-ab8f-4d46-b023-177d0f9591ea',916,'','Cabinet (default)','','','','','',NULL,'2021-04-28 14:05:53.000','2021-04-28 12:05:53.000','2021-04-28 14:05:53.000'),('59496d67-82f7-4828-86cd-392d0852da35',664,'3015880768','Miles of Smiles Implant Dentistry','','Silver Spring','20910','801 Wayne Avenue, Suite G200','United States of America',NULL,'2022-05-26 20:50:06.000','2022-05-27 00:50:07.000','2022-05-26 20:50:07.000'),('5d22dd41-4a03-4813-a2a3-86598c1101c0',172,'0559830648','SELARL du Dr Franck LE BOURHIS','','LAROIN','64110','4 Chemin Couralis','France',NULL,'2019-01-21 17:43:09.000','2019-08-19 15:44:04.000','2019-08-19 17:44:04.000'),('5e42d964-fa5c-4aac-b7ee-0cf0d98d7666',339,'0659598581','Cabinet (default)','','Paris','','','France',NULL,'2019-10-11 20:04:31.000','2019-10-15 08:41:09.000','2019-10-15 10:41:09.000'),('60100516-06c3-4737-a33b-8fba3b71bd66',155,'0241437031','LEMOUEL SAS','www.laboratoire-lemouel.fr','ECOUFLANT','49000','22 BOULEVARD DE L INDUSTRIE, ZI ECOUFLANT','France',NULL,'2019-08-27 14:26:48.000','2019-08-27 12:26:48.000','2019-08-27 14:26:48.000'),('68192cc7-8699-495c-8d44-1ae80d13c010',1211,'','','','','','','',NULL,'2024-08-29 10:02:00.000','2024-08-29 14:02:02.049','2024-08-29 10:02:02.049'),('6fc12d0b-3ff2-4acc-bdf3-e20c109a2c69',805,'000000000','Scan4all','','Labege','31670','137 rue Garance','France',NULL,'2020-12-09 11:04:46.000','2020-12-09 10:04:46.000','2020-12-09 11:04:46.000'),('7d3085b7-1dc0-4333-bb5f-211bbb00164c',1057,'','','','','','','',NULL,'2022-06-22 20:39:43.000','2022-06-23 00:39:43.000','2022-06-22 20:39:43.000'),('815ec911-85dc-4864-8384-e8d9dd0bac41',1032,'3015756227','Cabinet (default)','','Gaithersburg','20877','6 park ave','France',NULL,'2024-08-14 18:34:02.000','2024-08-28 12:07:31.194','2024-08-28 08:07:31.194'),('8bec8459-74ba-4d84-ae6b-56395383af10',1051,'800-476-2771','Drake Dental Lab','https://drakelab.com/','Charlotte','28227','8510 Crown Cresent Court','United States of America',NULL,'2022-05-26 20:41:13.000','2022-05-27 00:41:13.000','2022-05-26 20:41:13.000'),('8c4a7314-8b79-4f22-aeba-b48e799bb261',317,'0382254814','Cabinet (default)','','LONGWY','','','France',NULL,'2019-10-07 14:44:35.000','2019-12-09 10:58:34.000','2019-12-09 11:58:34.000'),('8dcd144c-a1e8-4ee1-86e3-68eeb19b8d6a',652,'','Cabinet (default)','','','','','',NULL,'2020-03-12 14:49:16.000','2020-03-12 13:49:16.000','2020-03-12 14:49:16.000'),('a1984274-1ad9-41d4-b536-d4407f8fca00',6,'0491776127','Cabinet (default)','','Marseille','','','France',NULL,'2019-07-02 11:05:21.000','2019-07-07 10:24:25.000','2019-07-07 06:24:25.000'),('a631c201-cdb6-4682-bfab-0b15792820f5',917,'','Cabinet (default)','','','','','',NULL,'2021-04-28 14:53:31.000','2021-04-28 12:53:31.000','2021-04-28 14:53:31.000'),('a67878c9-0724-4c0b-b082-d252b2a443a0',375,'142357044','Selarl Cabinet du Dr BOKOBZA','','Epinay sur Seine','93800','95, Avenue de la Marne','France',NULL,'2018-01-26 09:24:01.000','2019-10-28 12:23:57.000','2019-10-28 13:23:57.000'),('ab878dee-893e-44b6-a4a6-134b2edfc522',1056,'516 326-6812','','','Bellerose ','','','United States of America',NULL,'2022-06-22 17:28:57.000','2022-06-22 23:30:30.000','2022-06-22 19:30:30.000'),('ac14fa6c-ded0-4127-8d99-c18fee62921e',59,'0475490647','Cabinet (default)','','LE TEIL','','','France',NULL,'2019-07-17 14:12:08.000','2019-09-05 15:19:00.000','2019-09-05 17:19:00.000'),('b3b0ca74-a736-4743-a3f4-d7e5476a707a',941,'','Cabinet (default)','','','','','',NULL,'2021-06-07 14:52:03.000','2021-06-07 12:52:03.000','2021-06-07 14:52:03.000'),('b9db0008-e73d-4e5a-ac76-2c93df3250ae',689,'04 79 26 15 66','Cabinet (default)','','CHAMBERY','73000','1 Place de la Libération','France',NULL,'2020-11-03 08:32:27.000','2020-11-03 13:32:27.000','2020-11-03 08:32:27.000'),('bf407538-bec8-49af-b04a-68926a6b1a6e',1,'123322332','Labege','','Labege','31670','Labege','France',NULL,'2019-06-28 18:00:23.000','2019-06-28 16:00:23.000','2019-06-28 18:00:23.000'),('c54ab53e-cc43-42dd-a0f6-824b6dc657ad',8,'0664143389','LABEL DENT','','MERIGNAC','','10 AV JAN MASARYK','France',NULL,'2019-07-22 16:59:15.000','2019-07-22 20:59:15.000','2019-07-22 16:59:15.000'),('cf138ba8-c868-44ca-a131-a102a85c2992',787,'9045512099','Cabinet (default)','','Jacksonville','','','United States',NULL,'2020-11-03 15:01:23.000','2020-11-03 22:32:09.000','2020-11-03 17:32:09.000'),('da7eeae6-df32-400f-ae71-6f40ab17da2a',421,'0142502324','Cabinet (default)','','PARIS','75017','109 rue Lemercier','France',NULL,'2021-05-03 11:17:11.000','2021-05-03 09:17:11.000','2021-05-03 11:17:11.000'),('dbdc6c75-bf45-4e27-8a4b-89ff2d15213a',899,'3388397462','LABORATORIO ODONTOTECNICO CIRO GHIDELLI S.N.C.','','CASERTA','81100','VIA E.TAZZOLI','Italia',NULL,'2021-04-03 11:51:29.000','2021-04-03 09:51:29.000','2021-04-03 11:51:29.000'),('dc905db3-c0a3-44b2-a0f3-f3c08fdd6bb7',193,'0663713747','Cabinet (default)','','VIRIAT ','','','France',NULL,'2019-09-02 18:53:02.000','2019-09-05 19:11:53.000','2019-09-05 21:11:53.000'),('e563f7db-c71c-416d-a74d-2b979f6eade2',5,'0388334408','LABORATOIRE DENTAL BIOTECH','https://laboratoire-labeldent.fr/','WOLFISHEIM','67202','5 impasse Joffre','France',NULL,'2021-04-21 14:26:48.000','2021-04-21 18:26:48.000','2021-04-21 14:26:48.000'),('eef5f794-8bf3-4eae-8903-b87f4f171f1e',568,'0102030405','Cabinet (default)','','Tlse','','','France',NULL,'2020-02-04 15:19:02.000','2020-02-04 14:19:54.000','2020-02-04 15:19:54.000'),('f42c5519-fed3-4edd-81bb-22977bba879e',28,'0437289392','Cabinet (default)','','lyon','','','France',NULL,'2019-07-15 10:57:02.000','2019-07-18 12:19:16.000','2019-07-18 14:19:16.000'),('f841d3b8-276b-4ad1-859c-ba7e25ffe059',2,'056139839','Scan4all','','LABEGE','31670','137 rue garance','France',NULL,'2023-07-06 08:01:13.000','2023-09-19 20:34:38.767','2023-09-19 16:34:38.767');
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `uuid` varchar(36) NOT NULL,
  `firstname` varchar(64) NOT NULL,
  `lastname` varchar(64) NOT NULL,
  `email` varchar(255) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('00000001-0000-0000-0000-000000000001','labege','SI','si@condorscan.pro','2022-04-01 13:43:35.000',NULL),('00000002-0000-0000-0000-000000000001','WOW','SCAN4ALL','production@wow-scan.pro','2023-09-19 20:34:38.748','2024-10-31 10:02:38.995'),('00000002-0000-0000-0000-000000000002','soso','soso','veronique.querbes@scan4all.fr','2022-04-01 13:43:35.000',NULL),('00000003-0000-0000-0000-000000000001','c2w','prod-test','thomas.besson@condorscan.pro','2022-04-01 13:43:35.000',NULL),('00000005-0000-0000-0000-000000000001','Dental Biotech Strasbourg','Laboratoire','cfao@dentalbiotech.fr','2022-03-31 23:40:19.000','2024-08-29 10:22:31.527'),('00000006-0000-0000-0000-000000000001','Gilles','Philip','laboratoirephilip@yahoo.fr','2022-03-31 23:40:19.000',NULL),('00000007-0000-0000-0000-000000000001','DENTAL CUB','LABORATOIRE','cfao@dentalcub.fr','2022-03-31 23:40:19.000',NULL),('00000008-0000-0000-0000-000000000001','LABEL DENT','LABORATOIRE','label.dent@orange.fr','2022-03-31 23:40:19.000',NULL),('00000009-0000-0000-0000-000000000001','Laboratoire','LDA','cfao@laboratoirelda.com','2022-03-31 23:40:19.000',NULL),('00000028-0000-0000-0000-000000000001','clovis coulon','Laboratoire cdv','cdvscan@gmail.com','2022-04-01 13:43:35.000',NULL),('00000033-0000-0000-0000-000000000001','','','info@webert.fr','2022-04-01 13:43:35.000',NULL),('00000059-0000-0000-0000-000000000001','RIEUX  ','LABORATOIRE','laboratoire-rieux@orange.fr','2022-04-01 13:43:35.000',NULL),('00000155-0000-0000-0000-000000000001','LEMOUEL','LABORATOIRE','lemouel@aol.com','2022-04-01 13:43:35.000',NULL),('00000172-0000-0000-0000-000000000001','Franck','Dr LE BOURHIS','francklebourhis@gmail.com','2022-04-01 13:43:35.000',NULL),('00000177-0000-0000-0000-000000000001','OLIVA','VERONICA','v.oliva@biotech-dental.com','2022-04-01 13:43:35.000',NULL),('00000193-0000-0000-0000-000000000001','ADT Prothèses Dentaires','Laboratoire ','taponard.sebastien@yahoo.fr','2022-04-01 13:43:35.000',NULL),('00000224-0000-0000-0000-000000000001','Muriel','LIMONDIN','muriel.limondin@condorscan.pro','2022-04-01 13:43:35.000',NULL),('00000317-0000-0000-0000-000000000001','Herblot Moreau','Laboratoire','contact@ldhm.fr','2022-04-01 13:43:35.000',NULL),('00000339-0000-0000-0000-000000000001','Léopold','Lanne','prod@3dcelo.com','2022-04-01 13:43:35.000',NULL),('00000355-0000-0000-0000-000000000001','GIANLUCA','DALLATANA','gianluca@uniontech.it','2022-04-01 13:43:35.000',NULL),('00000375-0000-0000-0000-000000000001','LAURENT','BOKOBZA','docboko@orange.fr','2022-04-01 13:43:35.000',NULL),('00000377-0000-0000-0000-000000000001','place guichard','cabinet','cabinetdentaireplaceguichard@gmail.com','2022-04-01 13:43:35.000',NULL),('00000421-0000-0000-0000-000000000001','Webert','Laboratoire','numerique@webert.fr','2022-04-01 13:43:35.000',NULL),('00000568-0000-0000-0000-000000000001','SAV','labosav','admin@wow-scan.pro','2022-04-01 13:43:35.000',NULL),('00000652-0000-0000-0000-000000000001','','','cabinetdentaireguichard@orange.fr','2022-04-01 13:43:35.000',NULL),('00000664-0000-0000-0000-000000000001','Sammy','Noumbissi','drsammy@milesofsmilesdental.net','2022-03-31 23:40:19.000',NULL),('00000681-0000-0000-0000-000000000001','Dental lab’s','Laboratoire ','mils5@hotmail.fr','2022-04-01 13:43:35.000',NULL),('00000689-0000-0000-0000-000000000001','BY AXE ORTHO','SMILERS LAB','axe-ortho@outlook.fr','2022-03-31 23:40:19.000','2024-08-28 10:04:51.486'),('00000787-0000-0000-0000-000000000001','Dynamic Dental Solutions','Laboratory','scans@dynamicdentalsolutions.com','2022-03-31 23:40:19.000',NULL),('00000788-0000-0000-0000-000000000001','Bayshore Dental Studio','Laboratory','scan@bayshoredentalstudio.com','2022-03-31 23:40:19.000',NULL),('00000805-0000-0000-0000-000000000001','Demo','dr','jonathan.nave@scan4all.fr','2022-04-01 13:43:35.000',NULL),('00000838-0000-0000-0000-000000000001','','','denatllabs@gmail.com','2022-04-01 13:43:35.000',NULL),('00000840-0000-0000-0000-000000000001','','','dealm46@hotmail.fr','2022-04-01 13:43:35.000',NULL),('00000850-0000-0000-0000-000000000001','FLORENCE','BOURDELLE','drbourdelle@yahoo.com','2022-04-01 13:43:35.000',NULL),('00000899-0000-0000-0000-000000000001','CIRO','GHIDELLI','digitalcamcaserta@gmail.com','2022-04-01 13:43:35.000',NULL),('00000916-0000-0000-0000-000000000001','','','alexandre.wetting@scan4all.fr','2022-04-01 13:43:35.000',NULL),('00000917-0000-0000-0000-000000000001','','','jonathan.nave@secure4all.eu','2022-04-01 13:43:35.000',NULL),('00000918-0000-0000-0000-000000000001','Webert','Laboratoire','evan_gaillon@yahoo.fr','2022-04-01 13:43:35.000',NULL),('00000941-0000-0000-0000-000000000001','','','awetting@yahoo.fr','2022-04-01 13:43:35.000',NULL),('00001032-0000-0000-0000-000000000001','Sun','Hong','ezpassdentallab@gmail.com','2022-09-21 22:13:41.000','2024-10-31 10:02:39.011'),('00001033-0000-0000-0000-000000000001','Iva','Taylor','info@pinkdentalusa.com','2022-03-31 23:40:19.000','2023-09-25 13:26:58.058'),('18cf331b-daa8-4c9e-94a4-37bb8c1d2d63','Porcelain Studio','Finesse ','toothmaker2258@gmail.com','2022-06-22 23:30:30.000','2023-09-25 13:33:13.408'),('2181cf33-b54f-4edd-a9c6-435d7178d7cc','Aida','Ashuri','aida.eskandarian@gmail.com','2022-05-26 00:05:28.000',NULL),('2993788b-d1a5-4ed2-bcd4-f90bc239d8d5','','','info@amri-dent.com','2022-11-02 19:44:42.000',NULL),('3ae7142e-bb51-4c7c-b830-af6c73039fbb','Joy','Harrington','doctor@milesofsmilesdental.net','2024-08-28 15:20:19.537','2024-08-28 11:20:57.794'),('7e12bf9b-1c0a-496d-8b85-301e33d96ea4','Jong','Park','uni2809@hotmail.com','2022-05-25 23:54:28.000',NULL),('7f200f46-486f-455b-a1c1-759f2929c461','Fitzgerald Dental Studio','Laboratory','fitzgeralddentalstudio@gmail.com','2024-08-29 14:12:16.107','2024-10-31 10:02:39.040'),('97b5b6c4-5260-4622-b762-a66c3d2fdcba','Drake Dental','Lab','cadcam@drakelab.com','2022-05-27 01:33:25.000',NULL),('a08cac88-1bb6-49d8-82f2-619b248c1fbe','','','ezpassdental@gmail.com','2022-06-23 00:39:43.000',NULL),('b77a640f-652c-4db6-964e-0f97aa4644ba','Digital Dental Fusion','Laboratory','jay@digitaldentalfusion.com','2023-09-25 17:23:17.537','2024-10-31 10:02:38.972'),('e8d11ae6-599b-4565-895a-7c08638a03f5','Ameri-Dent','Lab','info@ameri-dent.com','2022-11-02 20:08:15.000',NULL),('ec8d4c21-52a1-4fa4-afea-880dff94cc9e','','','sammynoumbissi@gmail.com','2024-08-29 14:02:02.034','2024-10-31 10:02:39.027');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `uuid` varchar(36) NOT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('00000001-0000-0000-0000-000000000001','123322332','','','2022-04-01 13:43:35.000',NULL),('00000002-0000-0000-0000-000000000001','056139839','','','2023-09-19 20:34:38.749','2024-10-31 10:02:38.995'),('00000002-0000-0000-0000-000000000002','000','','','2022-04-01 13:43:35.000',NULL),('00000003-0000-0000-0000-000000000001','542138759','','','2022-04-01 13:43:35.000',NULL),('00000005-0000-0000-0000-000000000001','0388334408','','','2022-03-31 23:40:19.000','2024-08-29 10:22:31.527'),('00000006-0000-0000-0000-000000000001','0491776127','','','2022-03-31 23:40:19.000',NULL),('00000007-0000-0000-0000-000000000001','0664864059','','','2022-03-31 23:40:19.000',NULL),('00000008-0000-0000-0000-000000000001','0664143389','','','2022-03-31 23:40:19.000',NULL),('00000009-0000-0000-0000-000000000001','0149698526','','','2022-03-31 23:40:19.000',NULL),('00000028-0000-0000-0000-000000000001','0437289392','','','2022-04-01 13:43:35.000',NULL),('00000033-0000-0000-0000-000000000001','','','','2022-04-01 13:43:35.000',NULL),('00000059-0000-0000-0000-000000000001','0475490647','','','2022-04-01 13:43:35.000',NULL),('00000155-0000-0000-0000-000000000001','0241437031','','','2022-04-01 13:43:35.000',NULL),('00000172-0000-0000-0000-000000000001','0559830648','','','2022-04-01 13:43:35.000',NULL),('00000177-0000-0000-0000-000000000001','660474450','','','2022-04-01 13:43:35.000',NULL),('00000193-0000-0000-0000-000000000001','0663713747','','','2022-04-01 13:43:35.000',NULL),('00000224-0000-0000-0000-000000000001','0660850205','','','2022-04-01 13:43:35.000',NULL),('00000317-0000-0000-0000-000000000001','0382254814','','','2022-04-01 13:43:35.000',NULL),('00000339-0000-0000-0000-000000000001','0659598581','','','2022-04-01 13:43:35.000',NULL),('00000355-0000-0000-0000-000000000001','+390521221362','','','2022-04-01 13:43:35.000',NULL),('00000375-0000-0000-0000-000000000001','0142357044','','','2022-04-01 13:43:35.000',NULL),('00000377-0000-0000-0000-000000000001','0437578841','','','2022-04-01 13:43:35.000',NULL),('00000421-0000-0000-0000-000000000001','0142502324','','','2022-04-01 13:43:35.000',NULL),('00000568-0000-0000-0000-000000000001','0102030405','','','2022-04-01 13:43:35.000',NULL),('00000652-0000-0000-0000-000000000001','','','','2022-04-01 13:43:35.000',NULL),('00000664-0000-0000-0000-000000000001','3015880768','','','2022-03-31 23:40:19.000',NULL),('00000681-0000-0000-0000-000000000001','0627204198','','','2022-04-01 13:43:35.000',NULL),('00000689-0000-0000-0000-000000000001','04 79 26 15 66','','','2022-03-31 23:40:19.000','2024-08-28 10:04:51.486'),('00000787-0000-0000-0000-000000000001','9045512099','','','2022-03-31 23:40:19.000',NULL),('00000788-0000-0000-0000-000000000001','877-954-6243','','','2022-03-31 23:40:19.000',NULL),('00000805-0000-0000-0000-000000000001','000000000','','','2022-04-01 13:43:35.000',NULL),('00000838-0000-0000-0000-000000000001','','','','2022-04-01 13:43:35.000',NULL),('00000840-0000-0000-0000-000000000001','','','','2022-04-01 13:43:35.000',NULL),('00000850-0000-0000-0000-000000000001','0450943901','','','2022-04-01 13:43:35.000',NULL),('00000899-0000-0000-0000-000000000001','3388397462','','','2022-04-01 13:43:35.000',NULL),('00000916-0000-0000-0000-000000000001','','','','2022-04-01 13:43:35.000',NULL),('00000917-0000-0000-0000-000000000001','','','','2022-04-01 13:43:35.000',NULL),('00000918-0000-0000-0000-000000000001','0142502324','','','2022-04-01 13:43:35.000',NULL),('00000941-0000-0000-0000-000000000001','','','','2022-04-01 13:43:35.000',NULL),('00001032-0000-0000-0000-000000000001','3015756227','','','2022-09-21 22:13:41.000','2024-10-31 10:02:39.011'),('00001033-0000-0000-0000-000000000001','17039999586','','','2022-03-31 23:40:19.000','2023-09-25 13:26:58.058'),('0420bb00-2da6-4d3d-8b04-d1823c3b4d18','8138035662','','','2022-11-02 20:04:06.000',NULL),('1fe433e6-d926-4f66-98ae-2a7f1404ac1f','301588768','','','2024-08-28 15:20:19.538','2024-08-28 11:20:57.794'),('34dbcc6e-4ea9-407a-ab49-4c0b11ed9034','4437918020','','','2022-05-26 00:05:28.000',NULL),('3abe505e-3a83-4b46-be98-680f1e161aa6','516 326-6812','','','2022-06-22 23:30:30.000','2023-09-25 13:33:13.408'),('3af238a0-54c9-4a7e-bcaa-c79ee3b19274','800-476-2771','','','2022-05-27 00:40:14.000',NULL),('68ecf41a-6f78-456f-a1d2-c569c7ca5716','','','','2024-08-29 14:02:02.035','2024-10-31 10:02:39.027'),('697245be-74f7-4829-83ef-fa0ddb51d4db','','','','2022-06-23 00:39:43.000',NULL),('89bd7886-b6fc-45a9-84a4-fb907adfff0a','1-800-931-1554','','','2023-09-25 17:23:17.539','2024-10-31 10:02:38.972'),('b1b8308e-335a-4f13-afd7-d257a41bde60','9802370504','','','2024-08-29 14:12:16.109','2024-10-31 10:02:39.040'),('c1bd0a17-b798-4cca-b80f-6861b3c4a782','14103812928','','','2022-05-25 23:54:28.000',NULL),('cd8ca73e-88c3-46d1-951d-cd558aa8b9fd','','','','2022-11-02 19:44:42.000',NULL);
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `uuid` varchar(36) NOT NULL,
  `id` mediumint unsigned NOT NULL,
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `configId` mediumint unsigned DEFAULT NULL,
  `syncInfoId` mediumint unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `comments` text,
  `type` enum('UNDEFINED','PROTHESIST','DENTIST','DEMO','OTHER') NOT NULL DEFAULT 'UNDEFINED',
  `limitedContactId` varchar(36) DEFAULT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT '1',
  `statusGalaxy` tinyint(1) DEFAULT '0',
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  UNIQUE KEY `credentialsId` (`credentialsId`),
  KEY `syncInfoId` (`syncInfoId`,`id`),
  KEY `configId` (`configId`,`id`),
  CONSTRAINT `Professional_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_2` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_3` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_4` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_5` FOREIGN KEY (`syncInfoId`, `id`) REFERENCES `SyncInfo` (`id`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_6` FOREIGN KEY (`configId`, `id`) REFERENCES `Config` (`id`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES ('11644397-36f2-491f-aabf-b61c5414e0a5',1,NULL,'00000001-0000-0000-0000-000000000001','00000001-0000-0000-0000-000000000001','00000001-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2022-02-01 19:06:30.000','2022-04-01 13:43:36.000','2022-02-02 15:55:31.000'),('bf19c334-c71b-4e23-9ce0-73ddec5fe103',2,'00000002-0000-0000-0000-000000000001','00000002-0000-0000-0000-000000000001','00000002-0000-0000-0000-000000000001','00000002-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2023-07-20 09:08:27.000','2024-10-31 14:02:38.995','2024-10-31 10:02:38.995'),('7655b09e-027b-49c5-9b6c-832c6e41cee8',3,NULL,'00000003-0000-0000-0000-000000000001','00000003-0000-0000-0000-000000000001','00000003-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2022-02-03 14:21:51.000','2022-04-01 13:43:36.000','2022-02-03 14:21:52.000'),('35997e6a-79be-404d-8b2c-46fa78f0f219',5,NULL,'00000005-0000-0000-0000-000000000001','00000005-0000-0000-0000-000000000001','00000005-0000-0000-0000-000000000001',1,1,'','','OTHER',NULL,1,0,NULL,'2020-02-21 15:56:57.000','2024-08-29 14:22:31.508','2024-08-29 10:22:31.527'),('372fe703-e954-4df2-a079-51315f137deb',6,NULL,'00000006-0000-0000-0000-000000000001','00000006-0000-0000-0000-000000000001','00000006-0000-0000-0000-000000000001',1,1,'','','OTHER',NULL,1,0,NULL,'2019-07-02 11:05:21.000','2022-03-31 23:40:19.000','2022-03-31 19:40:19.000'),('14d1a5e5-e2aa-42ab-9b88-6ff9da357d9b',7,NULL,'00000007-0000-0000-0000-000000000001','00000007-0000-0000-0000-000000000001','00000007-0000-0000-0000-000000000001',1,1,'','','OTHER',NULL,1,0,NULL,'2019-07-22 17:07:13.000','2022-03-31 23:40:19.000','2022-03-31 19:40:19.000'),('48539f38-473c-4be5-b635-3fb0fd42b27e',8,NULL,'00000008-0000-0000-0000-000000000001','00000008-0000-0000-0000-000000000001','00000008-0000-0000-0000-000000000001',1,1,'','','OTHER',NULL,1,0,NULL,'2019-07-22 19:36:25.000','2022-03-31 23:40:19.000','2022-03-31 19:40:19.000'),('1dab4f0e-ae37-4417-a649-d2a1322d368a',9,NULL,'00000009-0000-0000-0000-000000000001','00000009-0000-0000-0000-000000000001','00000009-0000-0000-0000-000000000001',1,1,'','','OTHER',NULL,1,0,NULL,'2019-07-11 10:05:09.000','2022-03-31 23:40:19.000','2022-03-31 19:40:19.000'),('b7646046-2641-4ccc-bdc4-f6d0a3752e88',28,NULL,'00000028-0000-0000-0000-000000000001','00000028-0000-0000-0000-000000000001','00000028-0000-0000-0000-000000000001',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2019-07-15 10:57:02.000','2022-04-01 13:43:36.000','2021-07-19 20:03:48.000'),('ee68ea43-b4c3-4606-bc91-26457c3a7696',33,NULL,'00000033-0000-0000-0000-000000000001','00000033-0000-0000-0000-000000000001','00000033-0000-0000-0000-000000000001',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2019-07-15 14:34:40.000','2022-04-01 13:43:36.000','2021-04-28 15:19:46.000'),('023166d9-f822-4bb1-96cb-6fa7d892bf0b',59,NULL,'00000059-0000-0000-0000-000000000001','00000059-0000-0000-0000-000000000001','00000059-0000-0000-0000-000000000001',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2019-07-17 14:12:08.000','2022-04-01 13:43:36.000','2020-06-01 19:47:46.000'),('1bf8fcdd-496d-4839-ba78-f2b29eda6b93',155,NULL,'00000155-0000-0000-0000-000000000001','00000155-0000-0000-0000-000000000001','00000155-0000-0000-0000-000000000001',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2019-08-27 14:27:01.000','2022-04-01 13:43:36.000','2020-07-01 10:29:24.000'),('36701f7c-94a7-4ef6-a635-25b6dc5e0f86',172,NULL,'00000172-0000-0000-0000-000000000001','00000172-0000-0000-0000-000000000001','00000172-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2022-02-02 18:42:14.000','2022-04-01 13:43:36.000','2022-02-02 18:54:18.000'),('99a046a4-f05a-4eab-995e-4f0fda8261e2',177,NULL,'00000177-0000-0000-0000-000000000001','00000177-0000-0000-0000-000000000001','00000177-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2021-01-12 18:18:25.000','2022-04-01 13:43:36.000','2021-11-12 14:01:55.000'),('eba81f34-ad3a-4498-b307-4af657800052',193,NULL,'00000193-0000-0000-0000-000000000001','00000193-0000-0000-0000-000000000001','00000193-0000-0000-0000-000000000001',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2019-09-02 18:53:02.000','2022-04-01 13:43:36.000','2020-06-01 19:47:46.000'),('765081bc-b5ad-428e-bfa7-7edfee9d51a1',224,NULL,'00000224-0000-0000-0000-000000000001','00000224-0000-0000-0000-000000000001','00000224-0000-0000-0000-000000000001',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2019-09-09 15:29:44.000','2022-04-01 13:43:36.000','2020-06-01 19:47:46.000'),('5fceb3e9-78c3-4c50-b1e1-6c0da17eb225',317,NULL,'00000317-0000-0000-0000-000000000001','00000317-0000-0000-0000-000000000001','00000317-0000-0000-0000-000000000001',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2020-02-20 11:00:43.000','2022-04-01 13:43:36.000','2020-06-15 15:54:53.000'),('4d0904f5-35be-427c-8aa8-ded12c7970cb',339,NULL,'00000339-0000-0000-0000-000000000001','00000339-0000-0000-0000-000000000001','00000339-0000-0000-0000-000000000001',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2019-10-11 20:04:31.000','2022-04-01 13:43:36.000','2020-06-01 19:47:46.000'),('e8b64997-f348-44d2-82fc-581fc0df922d',355,NULL,'00000355-0000-0000-0000-000000000001','00000355-0000-0000-0000-000000000001','00000355-0000-0000-0000-000000000001',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2019-10-23 12:56:25.000','2022-04-01 13:43:36.000','2020-07-10 10:30:44.000'),('4143cd0b-67ef-4dd8-baf4-06622a105550',375,NULL,'00000375-0000-0000-0000-000000000001','00000375-0000-0000-0000-000000000001','00000375-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2022-02-11 14:14:19.000','2022-04-01 13:43:36.000','2022-02-11 14:19:00.000'),('9a8d2a6d-1088-45a9-8beb-31c22d464bc7',377,NULL,'00000377-0000-0000-0000-000000000001','00000377-0000-0000-0000-000000000001','00000377-0000-0000-0000-000000000001',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2020-03-03 11:05:55.000','2022-04-01 13:43:36.000','2020-06-01 19:47:46.000'),('7d471c64-3d84-43de-8868-70ea1e0ccec3',421,NULL,'00000421-0000-0000-0000-000000000001','00000421-0000-0000-0000-000000000001','00000421-0000-0000-0000-000000000001',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2021-05-03 11:17:22.000','2022-04-01 13:43:36.000','2021-05-03 12:01:37.000'),('808ee592-c31d-4f88-91ea-1ee291bfd399',568,NULL,'00000568-0000-0000-0000-000000000001','00000568-0000-0000-0000-000000000001','00000568-0000-0000-0000-000000000001',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2020-02-04 15:19:02.000','2022-04-01 13:43:36.000','2020-06-01 19:47:46.000'),('6c360fb9-b9ee-4b93-8401-ed12ceecc15c',652,NULL,'00000652-0000-0000-0000-000000000001','00000652-0000-0000-0000-000000000001','00000652-0000-0000-0000-000000000001',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2020-03-12 14:49:16.000','2022-04-01 13:43:36.000','2020-06-01 19:47:46.000'),('f01a2b76-66cc-4161-908b-fc9d31389d9c',664,'00000664-0000-0000-0000-000000000001','00000664-0000-0000-0000-000000000001','00000664-0000-0000-0000-000000000001','00000664-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2023-02-28 22:36:06.000','2023-03-01 03:36:16.000','2023-02-28 22:36:16.000'),('9ad57f69-9244-4c24-a8c6-c01070203722',681,NULL,'00000681-0000-0000-0000-000000000001','00000681-0000-0000-0000-000000000001','00000681-0000-0000-0000-000000000001',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2020-05-29 09:10:28.000','2022-04-01 13:43:36.000','2021-01-22 14:02:32.000'),('464a0019-6c2e-403e-b0a5-f1b453741d76',689,NULL,'00000689-0000-0000-0000-000000000001','00000689-0000-0000-0000-000000000001','00000689-0000-0000-0000-000000000001',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2020-11-03 08:29:54.000','2024-08-28 14:04:51.465','2024-08-28 10:04:51.486'),('d7579f98-d01b-4f85-92a9-064990b3ff4c',787,NULL,'00000787-0000-0000-0000-000000000001','00000787-0000-0000-0000-000000000001','00000787-0000-0000-0000-000000000001',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2020-11-03 17:33:44.000','2022-03-31 23:40:19.000','2022-03-31 19:40:19.000'),('f1151d92-df94-4ee0-82f0-35591650207e',788,NULL,'00000788-0000-0000-0000-000000000001','00000788-0000-0000-0000-000000000001','00000788-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2020-12-01 17:40:18.000','2022-03-31 23:40:19.000','2022-03-31 19:40:19.000'),('55bdf9b4-bec6-4509-9668-d40f4626751c',805,NULL,'00000805-0000-0000-0000-000000000001','00000805-0000-0000-0000-000000000001','00000805-0000-0000-0000-000000000001',1,1,'','','DEMO','02095f64-af38-442a-b557-b604cfb57242',0,0,NULL,'2020-12-09 11:12:20.000','2022-04-01 13:43:36.000','2021-04-28 14:39:58.000'),('8444f74b-f40e-46ef-acd4-b76564241dbf',838,NULL,'00000838-0000-0000-0000-000000000001','00000838-0000-0000-0000-000000000001','00000838-0000-0000-0000-000000000001',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2021-01-22 14:37:07.000','2022-04-01 13:43:36.000','2021-01-22 14:37:08.000'),('1a59dba2-9f1b-4bb3-85e2-d968d953a0c0',840,NULL,'00000840-0000-0000-0000-000000000001','00000840-0000-0000-0000-000000000001','00000840-0000-0000-0000-000000000001',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2021-01-22 16:28:38.000','2022-04-01 13:43:36.000','2021-01-22 16:28:39.000'),('5c0aa172-fd66-4ac8-8745-1a60912c6cae',850,NULL,'00000850-0000-0000-0000-000000000001','00000850-0000-0000-0000-000000000001','00000850-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2022-02-28 11:40:56.000','2022-04-01 13:43:36.000','2022-02-28 13:59:48.000'),('f5c65add-f981-447c-9d92-ded78e2c702b',899,NULL,'00000899-0000-0000-0000-000000000001','00000899-0000-0000-0000-000000000001','00000899-0000-0000-0000-000000000001',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2022-02-25 18:07:22.000','2022-04-01 13:43:36.000','2022-02-25 20:16:38.000'),('9c30070b-103c-4956-8991-5573d2eda9e4',916,NULL,'00000916-0000-0000-0000-000000000001','00000916-0000-0000-0000-000000000001','00000916-0000-0000-0000-000000000001',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2021-04-28 14:05:53.000','2022-04-01 13:43:36.000','2021-04-28 14:05:53.000'),('b7ac955b-37e2-4eb6-a8d5-c2ce45f937e0',917,NULL,'00000917-0000-0000-0000-000000000001','00000917-0000-0000-0000-000000000001','00000917-0000-0000-0000-000000000001',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2021-04-28 14:53:31.000','2022-04-01 13:43:36.000','2021-04-28 14:53:31.000'),('72135d4e-320c-4081-a88b-7c3e918a487a',918,NULL,'00000918-0000-0000-0000-000000000001','00000918-0000-0000-0000-000000000001','00000918-0000-0000-0000-000000000001',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2021-04-29 16:03:23.000','2022-04-01 13:43:36.000','2021-04-30 12:00:26.000'),('a415b291-bd46-4c16-8864-95f0b7346d20',941,NULL,'00000941-0000-0000-0000-000000000001','00000941-0000-0000-0000-000000000001','00000941-0000-0000-0000-000000000001',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2021-06-07 14:52:03.000','2022-04-01 13:43:36.000','2021-06-07 14:52:04.000'),('1ddb6602-5f4c-4664-8dcf-8a6f47bf2fbb',1032,'c2d5ca27-c8e5-496b-ae45-347bdf6ffb5b','00001032-0000-0000-0000-000000000001','00001032-0000-0000-0000-000000000001','00001032-0000-0000-0000-000000000001',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2022-03-21 10:58:37.000','2024-10-31 14:02:39.011','2024-10-31 10:02:39.011'),('9a0d502e-b229-4c35-90f1-6f4be580e1af',1033,NULL,'00001033-0000-0000-0000-000000000001','00001033-0000-0000-0000-000000000001','00001033-0000-0000-0000-000000000001',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2022-03-24 13:22:50.000','2023-09-25 17:26:58.043','2023-09-25 13:26:58.058'),('8407e73a-e001-49e4-8265-2305a99ca572',1050,NULL,'7e12bf9b-1c0a-496d-8b85-301e33d96ea4','c1bd0a17-b798-4cca-b80f-6861b3c4a782','4f878a64-f50a-4014-b427-31c8244e096d',1,1,'','','DENTIST',NULL,1,0,NULL,'2022-05-25 19:45:56.000','2022-05-26 00:11:37.000','2022-05-25 20:11:37.000'),('019f9754-cdd2-4eec-945a-6d0df3cb0b12',1051,NULL,'97b5b6c4-5260-4622-b762-a66c3d2fdcba','3af238a0-54c9-4a7e-bcaa-c79ee3b19274','d8e8f33a-8624-43a8-9846-67724036be4e',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2022-05-26 21:33:25.000','2022-05-27 01:33:25.000','2022-05-26 21:33:25.000'),('bd095bd1-f33f-4988-9b04-2e8c4469a0a1',1056,NULL,'18cf331b-daa8-4c9e-94a4-37bb8c1d2d63','3abe505e-3a83-4b46-be98-680f1e161aa6','cd6b8123-ac5f-47cb-8dfd-035610ced7e1',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2022-06-22 17:28:57.000','2023-09-25 17:33:13.387','2023-09-25 13:33:13.408'),('1f31fb99-24ed-4638-9c21-cdd48db75e9e',1057,NULL,'a08cac88-1bb6-49d8-82f2-619b248c1fbe','697245be-74f7-4829-83ef-fa0ddb51d4db','e1bedf90-0f9c-481a-af97-1f418d6350d1',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2022-06-22 20:39:43.000','2022-09-21 22:08:54.000','2022-09-21 18:08:54.000'),('bc5a222f-153d-4027-b58f-cf51a6da6a49',1101,NULL,'2993788b-d1a5-4ed2-bcd4-f90bc239d8d5','cd8ca73e-88c3-46d1-951d-cd558aa8b9fd','f8a74fd1-a596-4b92-823a-ccfa8f1b1922',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2022-11-02 15:44:42.000','2022-11-02 19:44:44.000','2022-11-02 15:44:44.000'),('7b3269f3-3788-4d81-8f4d-327c3962f966',1102,NULL,'e8d11ae6-599b-4565-895a-7c08638a03f5','0420bb00-2da6-4d3d-8b04-d1823c3b4d18','18d48506-dfa1-46eb-b70d-83da71547ade',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2022-11-02 16:08:15.000','2022-11-02 20:08:49.000','2022-11-02 16:08:49.000'),('70d88b68-bc74-4ee1-ab93-ac3c9ac97f42',1166,'9ebe80bc-e77e-4adc-85bb-9aaed3d6ff06','b77a640f-652c-4db6-964e-0f97aa4644ba','89bd7886-b6fc-45a9-84a4-fb907adfff0a','34083901-2d3f-4d24-a689-cb451104f44b',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2023-09-25 13:19:50.000','2024-10-31 14:02:38.972','2024-10-31 10:02:38.972'),('5179e7d8-dfe3-41a4-98ed-cadc30c3b755',1210,'fe2709bd-d5d3-4b96-a246-ccae9e8d8aeb','7f200f46-486f-455b-a1c1-759f2929c461','b1b8308e-335a-4f13-afd7-d257a41bde60','6d37a68e-32f5-4902-aa27-37b25557a9a1',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2024-08-28 09:58:48.000','2024-10-31 14:02:39.040','2024-10-31 10:02:39.040'),('85931be1-dddc-4630-8bdf-f600eaab9aeb',1211,NULL,'ec8d4c21-52a1-4fa4-afea-880dff94cc9e','68ecf41a-6f78-456f-a1d2-c569c7ca5716','a04e717a-c195-47a4-b784-92d7430c35df',1,1,'','','UNDEFINED',NULL,1,0,NULL,'2024-08-29 10:02:00.000','2024-10-31 14:02:39.027','2024-10-31 10:02:39.027');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalEnvInfos`
--

DROP TABLE IF EXISTS `ProfessionalEnvInfos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalEnvInfos` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `accessCode` varchar(45) DEFAULT NULL,
  `status` enum('CREATED','CONFIRMED','BLOCKED') NOT NULL DEFAULT 'CREATED',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`ownerId`),
  CONSTRAINT `ProfessionalEnvInfos_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalEnvInfos`
--

LOCK TABLES `ProfessionalEnvInfos` WRITE;
/*!40000 ALTER TABLE `ProfessionalEnvInfos` DISABLE KEYS */;
INSERT INTO `ProfessionalEnvInfos` VALUES (1,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(2,NULL,'CONFIRMED','2022-04-01 13:43:36.000','2022-04-01 09:43:36.000'),(3,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(5,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(6,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(7,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(8,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(9,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(28,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(33,'9e78c77f','CREATED','2022-04-01 13:43:36.000',NULL),(59,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(155,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(172,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(177,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(193,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(224,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(317,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(339,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(355,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(375,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(377,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(421,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(568,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(652,'2d03a8b3','CREATED','2022-04-01 13:43:36.000',NULL),(664,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(681,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(689,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(787,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(788,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(805,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(838,'0a05c99f','CREATED','2022-04-01 13:43:36.000',NULL),(840,'91196e2d','CREATED','2022-04-01 13:43:36.000',NULL),(850,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(899,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(916,'0a1720e5','CREATED','2022-04-01 13:43:36.000',NULL),(917,'b83216c0','CREATED','2022-04-01 13:43:36.000',NULL),(918,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(941,'3f807fd2','CREATED','2022-04-01 13:43:36.000',NULL),(1032,NULL,'CONFIRMED','2022-09-21 16:13:44.000','2022-09-21 12:13:44.000'),(1033,NULL,'CONFIRMED','2022-04-01 13:43:36.000',NULL),(1050,NULL,'CONFIRMED','2022-05-25 17:54:28.000',NULL),(1051,NULL,'CONFIRMED','2022-05-26 18:31:54.000',NULL),(1056,NULL,'CONFIRMED','2022-06-22 17:30:41.000',NULL),(1057,'e73d0490','CREATED','2022-06-22 18:39:46.000',NULL),(1101,'26a7b9c9','CREATED','2022-11-02 14:44:43.000',NULL),(1102,NULL,'CONFIRMED','2022-11-02 15:04:07.000',NULL),(1166,'a0367bad','CREATED','2023-09-25 17:19:51.529','2023-09-25 13:19:51.529'),(1210,'63e026e1','CREATED','2024-08-28 13:58:49.201','2024-08-28 09:58:49.201'),(1211,'f26f2755','CREATED','2024-08-29 14:02:02.042','2024-08-29 10:02:02.042');
/*!40000 ALTER TABLE `ProfessionalEnvInfos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalPatient` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`ownerId`,`patientId`),
  KEY `patientId` (`patientId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `ProfessionalPatient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `wow_patient`.`Patient` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
INSERT INTO `ProfessionalPatient` VALUES (2,'0cc4ef86-2202-4a20-b6c2-a4a99611d672','f841d3b8-276b-4ad1-859c-ba7e25ffe059',0,0,'NONE'),(2,'3444c8f6-a93a-4fcf-85dd-517adb35a1ea','f841d3b8-276b-4ad1-859c-ba7e25ffe059',0,0,'NONE'),(664,'097506b2-3385-4e2b-a196-b427b2eb51b8','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'10c66c7c-9e2a-4201-bc3f-ee405f9ea2a2','59496d67-82f7-4828-86cd-392d0852da35',0,0,'BABY'),(664,'11ec40e4-4579-4185-9fcf-4e1aac06f554','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'17cc8b8c-6280-4e69-ad1e-731bdd9819e0','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'1a7a13ce-3a47-487b-8f16-db331e2672da','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT'),(664,'1a8d2cad-438d-45eb-a3d8-ff1f536e5592','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'2217798a-4832-4e0d-9259-f8a836365b51','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'2716836a-c818-4c38-90b6-b63ccb3a95ab','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT'),(664,'366ffa87-059a-436a-9125-8827b3a2da1a','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'36b92bb3-4eed-4383-bbf3-4b91cb0af09b','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'36e86f3f-4468-4cf2-9505-462288cae8b1','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'46c4cd1e-7338-11ee-b011-58a023cda0dc','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT'),(664,'48a38618-e853-4bf0-aa6b-4c83fb8b6f13','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'4b4f3002-bba6-481f-a9fb-41ab2fedd61c','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'509319d0-6cf3-4073-92e1-ff9307be4376','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT'),(664,'59179996-dc1e-4b4c-b9fd-92c78aa1dde0','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'635617fc-289b-470c-a4d4-678d7b5f275a','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'685697a1-0d50-4a06-8b3e-729cf9750f38','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'6d99007d-a6df-43ae-87db-c160f6e66c0d','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT'),(664,'73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'7eac18e5-5ed2-4ed9-8b3e-eba1c562d708','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'872e90e0-190f-43c9-ac34-11936953fc74','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'965d3fb4-1cb6-4c76-b1b8-f02df7997006','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'99b65fa1-1638-4d2a-8836-8f2697b96143','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'9af78b83-8d91-4dc6-9499-3b8f6672cee3','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'9bcfd1e2-10fc-4838-92c0-84057ad52bfe','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'a4179770-0834-4466-a722-b14a0da36c73','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'ab75613c-fecb-442a-bd6a-5b39f4846ade','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT'),(664,'ac1cc354-e34f-4afd-b66f-dadc541bcd93','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'ae72aa8e-9461-11ee-8fd8-58a023cda0dc','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT'),(664,'aea25e6c-977f-11ef-8187-58a023cda0dc','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'b2146fed-f67d-47a9-b610-c63d840d0a2d','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'b4c6341b-9837-11ee-86e7-58a023cda0dc','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT'),(664,'b5cbee44-0703-46c2-986a-7a416eb4206c','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT'),(664,'bbc77872-6c30-11ee-bc7f-58a023cda0dc','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT'),(664,'bd9e7343-96c5-11ef-8234-58a023cda0dc','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT'),(664,'cede029c-15bc-44c2-9c9c-fac7f8983524','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'d71657f7-b9e8-45b9-865f-1c4c55c62017','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'d971e033-4a5c-4bd9-aab3-6238778f9eee','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'d9869338-8fcc-11ef-b6be-58a023cda0dc','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'dfe1127e-d366-48f3-8672-183d37f8181f','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT'),(664,'e33159c9-a713-4a37-ba98-9ec2e2e213e7','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT'),(664,'e4dda259-b05b-4f33-92ac-ee4067d7dfa2','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'e648cc66-9340-456c-a379-50836d1b8a5b','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'eb3fb44e-7c5f-4ae3-a907-fdcec841501c','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT'),(664,'ebb7ec01-03db-43d2-bf9a-bc250f69d307','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'ec5bbece-7f40-46cd-b5cd-bc74205bf2f0','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'eddc3fb0-fe28-4640-9139-29e088374f38','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'f4f78058-cf3c-4c86-a252-bc92bd2d36b0','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'f67a1372-95d6-445a-856a-13c1610ee937','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'f9a5624b-304e-40b4-8a76-72a05c95332f','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'fa67c8c9-4aad-41b8-83e6-2add079bf950','59496d67-82f7-4828-86cd-392d0852da35',0,0,'NONE'),(664,'ffbcef25-a535-4bb2-8b85-6107c1aaa2ed','59496d67-82f7-4828-86cd-392d0852da35',0,0,'ADULT');
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `status` enum('NOT_SENT','SENT','DATE_VALIDATED','DATE_EDITED','VALIDATED','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `unread` tinyint(1) DEFAULT '0',
  `currentDeliveryDate` datetime(3) DEFAULT NULL,
  `previousDeliveryDate` datetime(3) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `displayId` mediumint unsigned DEFAULT NULL,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `ProstheticOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
INSERT INTO `ProstheticOrder` VALUES ('0226bc43-b62b-4f3e-8246-e4fb73ae4a28',664,'d84b9ba5-9fa3-46d3-afd2-cfddd498ec29','ORDER','SENT',0,'2022-10-05 18:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-12 20:41:45.000',NULL,'2022-09-14 15:47:21.000','2022-09-14 19:47:21.000','2022-09-14 15:47:21.000'),('06d57180-983c-11ee-86e7-58a023cda0dc',664,'bf1582a4-9837-11ee-86e7-58a023cda0dc','Order n° 1.56.1.1','NOT_SENT',1,'2023-12-29 00:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-12-11 10:43:27.517',NULL,'2023-12-11 10:48:06.171','2023-12-11 15:48:06.171',NULL),('0b106085-a874-4785-83a0-f28eb5473492',664,'bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6','ORDER','SENT',0,'2022-09-21 12:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-07 16:52:14.000',NULL,'2022-09-07 19:36:04.000','2022-09-07 23:36:03.000','2022-09-07 19:36:03.000'),('0ec89083-772a-11ee-867e-58a023cda0dc',664,'ecbd4537-7341-11ee-b011-58a023cda0dc','Order n° 1.54.1.1','SENT',0,'2023-11-15 00:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-30 09:41:41.000',NULL,'2023-10-30 09:46:58.000','2023-10-30 13:47:02.786','2023-10-30 09:47:02.786'),('133bf366-2526-4d75-9242-6e7caee5aa64',664,'d592e356-eafe-46a1-8e61-9a886a79e1de','ORDER','DATE_VALIDATED',0,'2022-08-25 06:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-24 19:54:47.000',NULL,'2023-05-25 18:07:10.000','2023-06-14 15:05:05.629','2023-06-14 11:05:05.629'),('16e355a3-b14e-430a-923b-9a23341e2aa3',664,'fc32fcc1-f66c-42d5-93d9-1379911add0c','ORDER','NOT_SENT',0,'2022-11-29 18:00:00.000',NULL,1,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-16 21:16:33.000','2022-11-22 18:42:35.000','2022-11-18 20:11:57.000','2023-05-17 17:16:39.651',NULL),('1813dac1-af6a-4e4c-8f60-2564d6ebab92',664,'fc32fcc1-f66c-42d5-93d9-1379911add0c','ORDER','NOT_SENT',0,'2022-11-28 18:00:00.000',NULL,1,3,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-18 20:17:12.000','2022-11-22 18:42:48.000','2022-11-18 20:22:26.000','2023-05-17 17:16:39.651',NULL),('1ab03a36-f8a5-11ed-807f-58a023cda0dc',664,'1aab3e57-f8a5-11ed-807f-58a023cda0dc','Order n° 1.29.3.1','NOT_SENT',1,NULL,NULL,1,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-05-22 09:32:31.940','2023-05-22 09:33:25.114','2023-05-22 09:33:25.114','2023-05-22 13:33:25.115',NULL),('1e218460-1625-4cb2-b347-dcad66378660',664,'fc32fcc1-f66c-42d5-93d9-1379911add0c','ORDER','NOT_SENT',0,'2022-12-07 18:00:00.000',NULL,0,5,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-22 18:43:15.000',NULL,'2022-11-22 20:01:26.000','2023-05-17 17:16:39.641',NULL),('223975e3-130e-4b67-8ab4-69e9e3adbfc8',664,'49b3ccf6-630c-48b2-8480-8a005298959e','CROWN','DATE_VALIDATED',0,'2020-11-04 00:00:01.000',NULL,0,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-11-03 22:39:41.000',NULL,'2020-11-03 22:53:24.000','2022-03-14 13:58:27.000','2022-03-14 14:58:27.000'),('23a16fe0-ed03-4415-a9e6-882ce7bc94f3',664,'bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6','ORDER','SENT',0,'2022-11-22 06:00:00.000',NULL,0,4,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-21 16:45:23.000','2022-11-22 18:47:20.000','2022-11-22 18:35:46.000','2022-11-22 23:47:20.000','2022-11-22 18:47:20.000'),('249e488c-5a44-41ef-8fc3-630cd1be0fb7',664,'04e0da18-656d-4d28-ad6d-e20cdfe5e2df','ORDER','SENT',0,'2022-11-07 18:00:00.000',NULL,0,4,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-02 19:35:57.000',NULL,'2022-11-09 17:08:16.000','2022-11-09 22:08:17.000','2022-11-09 17:08:17.000'),('2a260279-f2f6-4f7c-8756-e8a27606b0b3',664,'babd9189-73c6-4ebf-95c9-fc1de28820bf','CROWN','DATE_VALIDATED',0,'2020-09-17 00:00:01.000',NULL,0,4,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-09-17 03:51:09.000',NULL,'2020-09-17 12:22:20.000','2022-03-14 13:58:35.000','2022-03-14 14:58:35.000'),('2f5b2737-e56b-4716-8b81-b8f39386743d',664,'6fc7c9c9-3191-4169-b15f-edf43fc51336','ORDER','SENT',0,'2022-10-07 18:00:00.000',NULL,0,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-21 18:19:34.000','2022-09-21 18:22:58.000','2022-09-21 18:22:53.000','2022-09-21 22:22:58.000','2022-09-21 18:22:58.000'),('331e8399-8fa1-408a-b55e-1adf0a2ef6c0',664,'610634a3-6f25-4ce3-9363-ad383ec68df4','ORDER','SENT',0,'2022-11-24 12:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-02 16:14:24.000',NULL,'2022-11-02 16:16:31.000','2022-11-02 20:16:30.000','2022-11-02 16:16:30.000'),('3422edcd-9843-11ee-86e7-58a023cda0dc',664,'341df9b2-9843-11ee-86e7-58a023cda0dc','Order n° 1.56.4.1','NOT_SENT',1,NULL,NULL,1,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-12-11 11:34:49.999','2023-12-11 11:38:49.006','2023-12-11 11:38:49.006','2023-12-11 16:38:49.007',NULL),('3e0ffdd1-983d-11ee-86e7-58a023cda0dc',664,'3e0b2a44-983d-11ee-86e7-58a023cda0dc','Order n° 1.56.2.1','NOT_SENT',1,NULL,NULL,1,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-12-11 10:52:09.672','2023-12-11 10:53:00.899','2023-12-11 10:53:00.900','2023-12-11 15:53:00.900',NULL),('4542bde6-572d-11ee-a378-58a023cda0dc',664,'453ec882-572d-11ee-a378-58a023cda0dc','Order n° 1.32.3.1','NOT_SENT',1,NULL,NULL,1,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-09-19 16:44:04.221','2023-09-19 16:45:16.252','2023-09-19 16:45:16.252','2023-09-19 20:45:16.253',NULL),('5197160e-6765-4f00-a914-1b83136e95ff',664,'96711d60-288c-439f-b464-597833d56519','CROWN','SENT',0,'2021-04-15 06:00:01.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-14 16:08:34.000',NULL,'2021-04-14 16:11:44.000','2022-03-14 13:58:23.000','2022-03-14 14:58:23.000'),('52b35b9a-f8a5-11ed-807f-58a023cda0dc',664,'52ae5c92-f8a5-11ed-807f-58a023cda0dc','Order n° 1.29.4.1','NOT_SENT',1,NULL,NULL,1,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-05-22 09:34:05.913','2023-05-22 09:35:56.917','2023-05-22 09:35:56.918','2023-05-22 13:35:56.918',NULL),('52de723f-4bdd-4b2d-87a6-fb648e680fbb',664,'06c2562e-49fa-4926-ab49-41fe223d844d','ORDER','NOT_SENT',0,'2022-11-07 18:00:00.000',NULL,0,4,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-19 19:58:01.000',NULL,'2022-10-24 19:03:31.000','2023-05-17 17:16:39.641',NULL),('54410525-60fc-4d0d-9655-9ea6638a6043',664,'c49716f1-987e-4111-9ab9-4541a0378bb7','ORDER','DATE_VALIDATED',0,'2022-03-29 00:00:00.000',NULL,0,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-28 16:56:15.000',NULL,'2022-04-01 15:51:35.000','2022-04-01 19:51:37.000','2022-04-01 15:51:37.000'),('548a8b15-a19f-42cb-80ef-399c4e3a51ee',664,'babd9189-73c6-4ebf-95c9-fc1de28820bf','CROWN','SENT',0,'2020-11-30 00:00:01.000',NULL,0,3,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-09-17 03:46:56.000',NULL,'2020-11-30 02:24:32.000','2022-03-14 13:58:34.000','2022-03-14 14:58:34.000'),('64b9506d-1475-4965-b3d3-054a5a076a37',664,'c83bd076-29da-4e22-aae9-8e83dce14029','ORDER','NOT_SENT',0,'2022-09-21 18:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-07 15:55:52.000',NULL,'2022-09-14 15:16:35.000','2023-05-17 17:16:39.641',NULL),('660769ad-1b3a-4e07-ba2e-3a8721ccaf28',664,'c83bd076-29da-4e22-aae9-8e83dce14029','ORDER','NOT_SENT',0,'2022-10-05 18:00:00.000',NULL,1,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-21 19:27:32.000','2022-09-21 19:31:12.000','2022-09-21 19:31:12.000','2023-05-17 17:16:39.651',NULL),('68450b97-4193-42f4-a818-4bca3fb50cca',664,'cc413c24-b371-4a75-9cfe-451a8d54e32e','ORDER','DATE_EDITED',0,'2022-06-28 00:00:00.000','2022-06-21 00:00:00.000',0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-20 19:37:12.000',NULL,'2022-06-22 15:23:43.000','2022-06-22 19:23:43.000','2022-06-22 15:23:43.000'),('6a27a984-b0e8-4a31-b556-c4234f6cefec',664,'babd9189-73c6-4ebf-95c9-fc1de28820bf','CROWN','SENT',0,'2020-07-02 00:00:01.000',NULL,0,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-07-01 18:12:33.000',NULL,'2020-07-01 18:18:10.000','2022-03-14 13:58:34.000','2022-03-14 14:58:34.000'),('719d069f-1c89-4cc2-a04d-982bb719d80a',664,'c83bd076-29da-4e22-aae9-8e83dce14029','ORDER','NOT_SENT',0,'2022-10-10 18:00:00.000',NULL,0,3,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-21 19:31:23.000',NULL,'2022-09-21 20:05:44.000','2023-05-17 17:16:39.641',NULL),('73b64ad8-c002-4b00-8cb0-479d3d5e1a46',664,'551dd857-1278-4318-8547-662cc20c3741','ORDER','DATE_VALIDATED',0,'2022-04-15 00:00:00.000',NULL,0,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-04-14 15:13:36.000',NULL,'2022-04-21 22:42:05.000','2022-04-22 02:42:05.000','2022-04-21 22:42:05.000'),('75cfb105-378d-478e-a639-12e9b18c1d8a',664,'06c2562e-49fa-4926-ab49-41fe223d844d','ORDER','NOT_SENT',0,'2022-10-19 19:45:02.000',NULL,1,3,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-19 19:45:02.000','2022-10-19 19:55:15.000','2022-10-19 19:45:02.000','2023-05-17 17:16:39.651',NULL),('79d31a7b-5bca-11ee-9658-58a023cda0dc',664,'eecd8fd5-572c-11ee-a378-58a023cda0dc','Order n° 1.32.2.2','DATE_VALIDATED',0,'2023-10-11 00:00:00.000',NULL,0,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-09-25 13:39:28.000',NULL,'2023-09-25 13:43:41.000','2023-10-16 14:29:52.488','2023-10-16 10:29:52.488'),('7bb41f92-9801-4a80-9db6-907964cacece',664,'a72c11a4-05dc-4421-b252-fbfcecd2559e','IMPLANT CROWN','SENT',0,'2020-09-10 00:00:01.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-09-09 15:51:56.000',NULL,'2020-09-09 15:58:04.000','2022-03-14 13:43:02.000','2022-03-14 14:43:02.000'),('8515ad34-77a4-41f6-a53a-5be823e2f13d',664,'06c2562e-49fa-4926-ab49-41fe223d844d','ORDER','SENT',0,'2022-07-29 00:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-07-28 16:02:38.000',NULL,'2022-07-28 16:03:57.000','2022-07-28 20:03:56.000','2022-07-28 16:03:56.000'),('854d2595-c6e3-4d27-8fbd-55e7fc6c19e4',664,'48975557-21ce-4d21-a4b8-334c890ddd9a','ORDER','DATE_VALIDATED',0,'2022-10-17 12:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-03 21:53:04.000',NULL,'2022-10-03 22:20:37.000','2022-10-04 02:20:37.000','2022-10-03 22:20:37.000'),('8585764e-6028-48b5-bf39-ddba86be173e',664,'bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6','ORDER','NOT_SENT',0,'2022-11-28 18:00:00.000',NULL,0,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-18 20:50:38.000',NULL,'2022-11-18 20:55:34.000','2023-05-17 17:16:39.641',NULL),('8e326dc6-f8a4-11ed-807f-58a023cda0dc',664,'8e2d2b96-f8a4-11ed-807f-58a023cda0dc','Order n° 1.29.2.1','NOT_SENT',1,NULL,NULL,1,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-05-22 09:28:36.234','2023-05-22 09:30:07.468','2023-05-22 09:30:07.469','2023-05-22 13:30:07.469',NULL),('98f23fdc-6e7d-411a-a2b5-b74bf1ad5f3c',664,'c9a2f9e9-8ddc-4a55-a029-cf9e1d96a67d','ORDER','SENT',0,'2022-06-23 06:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-22 20:43:24.000',NULL,'2022-07-11 16:24:09.000','2022-07-28 20:01:47.000','2022-07-28 16:01:47.000'),('9ab7328d-44e3-46af-b634-75d45259e276',664,'6fc7c9c9-3191-4169-b15f-edf43fc51336','ORDER','SENT',0,'2022-10-07 18:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-21 18:15:33.000',NULL,'2022-09-21 18:21:46.000','2022-09-21 22:21:47.000','2022-09-21 18:21:47.000'),('a0ba4ef3-7727-11ee-867e-58a023cda0dc',664,'07e45d8d-734b-11ee-b011-58a023cda0dc','Order n° 1.7.10.1','SENT',0,'2023-11-08 00:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-30 09:24:17.000',NULL,'2023-10-30 09:28:04.000','2023-10-30 13:28:06.714','2023-10-30 09:28:06.714'),('a158bf26-f8a5-11ed-807f-58a023cda0dc',664,'a1538422-f8a5-11ed-807f-58a023cda0dc','Order n° 1.29.5.1','NOT_SENT',1,NULL,NULL,1,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-05-22 09:36:17.859',NULL,'2023-05-22 09:36:17.862','2023-05-22 13:36:17.863',NULL),('a5b0637e-96ef-11ef-8234-58a023cda0dc',664,'a5ab0033-96ef-11ef-8234-58a023cda0dc','Order n° 1.58.1.1','NOT_SENT',1,NULL,NULL,1,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2024-10-30 14:49:09.292','2024-10-31 08:15:05.333','2024-10-31 08:15:05.334','2024-10-31 12:15:05.335',NULL),('a70ea958-6c46-11ee-bc7f-58a023cda0dc',664,'0a963705-6c31-11ee-bc7f-58a023cda0dc','Order n° 1.53.1.1','SENT',0,'2023-10-30 00:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-16 13:08:40.000',NULL,'2023-10-16 13:12:44.000','2023-10-16 17:12:49.462','2023-10-16 13:12:49.462'),('a91f29b5-c999-4d0b-90cf-4ff0df6707c8',664,'04e0da18-656d-4d28-ad6d-e20cdfe5e2df','ORDER','DATE_VALIDATED',0,'2022-11-21 12:00:00.000',NULL,0,5,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-09 17:08:35.000',NULL,'2022-11-14 17:08:08.000','2022-11-14 22:08:09.000','2022-11-14 17:08:09.000'),('a9d67f35-6b75-41ae-8fc0-04ebed5dcbc6',664,'c49716f1-987e-4111-9ab9-4541a0378bb7','ORDER','SENT',0,'2022-03-25 05:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-21 15:44:00.000',NULL,'2022-03-28 16:16:51.000','2022-03-28 20:16:52.000','2022-03-28 16:16:52.000'),('b3fd7ab4-7c7c-487a-96e9-21275b318b80',664,'bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6','ORDER','NOT_SENT',0,'2022-12-07 18:00:00.000',NULL,0,5,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-22 18:48:16.000',NULL,'2022-11-22 20:00:09.000','2023-05-17 17:16:39.641',NULL),('b765206e-6542-11ef-b382-58a023cda0dc',664,'b75ed43d-6542-11ef-b382-58a023cda0dc','Order n° 1.35.3.1','SENT',0,'2024-09-09 00:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2024-08-28 09:37:49.000',NULL,'2024-08-28 09:38:44.000','2024-08-28 13:38:47.246','2024-08-28 09:38:47.246'),('bd06bb45-1ca4-4e1a-bd3b-f5da30b77316',664,'06c2562e-49fa-4926-ab49-41fe223d844d','ORDER','SENT',0,'2022-08-18 18:00:00.000',NULL,0,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-03 16:28:03.000',NULL,'2022-10-12 15:21:30.000','2022-10-12 19:21:31.000','2022-10-12 15:21:31.000'),('bf6a5903-e77c-47d1-aa54-6dbca17c1938',664,'51374b44-d221-416c-8eb3-cf931ed89632','ORDER','SENT',0,'2022-06-23 06:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-22 15:54:41.000',NULL,'2022-07-13 14:36:37.000','2022-07-28 20:01:46.000','2022-07-28 16:01:46.000'),('c155f94e-e0aa-488a-af25-8ada7a6a5b8a',664,'bfe6249f-88b3-4a27-8f4c-5494e863352f','CROWN','DATE_VALIDATED',0,'2020-12-01 00:00:01.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-11-30 02:22:30.000',NULL,'2020-12-01 00:28:08.000','2022-03-14 13:58:31.000','2022-03-14 14:58:31.000'),('c379ba7c-4e26-473d-a1bd-f12853d9c1a4',664,'6834852b-fe98-4445-9c5d-2b6bf3991183','ORDER','SENT',0,'2022-05-27 00:00:00.000',NULL,0,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-05-26 21:49:58.000',NULL,'2022-05-26 22:09:09.000','2022-05-27 02:09:07.000','2022-05-26 22:09:07.000'),('c7646a09-199d-41ff-9840-93f97fe9d1cb',664,'d3696b3d-0728-4822-b89d-631e2ab774a4','CROWN','DATE_VALIDATED',0,'2020-11-30 00:00:01.000',NULL,0,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-11-30 02:18:15.000',NULL,'2020-12-01 00:24:24.000','2022-03-14 13:42:59.000','2022-03-14 14:42:59.000'),('c8a9ae43-f4da-4f8b-b98a-5d4804c238bc',664,'fc32fcc1-f66c-42d5-93d9-1379911add0c','ORDER','NOT_SENT',0,'2022-11-22 18:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-31 17:39:06.000',NULL,'2022-11-02 15:33:08.000','2023-05-17 17:16:39.641',NULL),('c94feabc-c456-485b-b538-c3a58bce9798',664,'d592e356-eafe-46a1-8e61-9a886a79e1de','ORDER','DATE_VALIDATED',0,'2022-09-28 12:00:00.000',NULL,0,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-07 19:47:18.000',NULL,'2022-09-12 18:33:13.000','2022-09-12 22:33:16.000','2022-09-12 18:33:16.000'),('ce221fe3-3073-4ef0-aa97-eb8dc1eefb70',664,'c6b2dd58-ecd5-402a-9167-ae99aef2b1c9','GUIDE','DATE_VALIDATED',0,'2021-01-29 00:00:01.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-01-28 15:39:21.000',NULL,'2021-01-28 15:48:26.000','2022-03-14 18:58:45.000','2022-03-14 14:58:45.000'),('ce9127f7-b01e-4e28-b330-8f397f2a043e',664,'551dd857-1278-4318-8547-662cc20c3741','ORDER','DATE_VALIDATED',0,'2022-04-15 00:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-04-14 15:10:09.000',NULL,'2022-04-27 16:32:29.000','2022-04-27 20:32:30.000','2022-04-27 16:32:30.000'),('cf62526a-fa37-11ed-8f6c-58a023cda0dc',664,'cf5ebf08-fa37-11ed-8f6c-58a023cda0dc','Order n° 1.29.6.1','NOT_SENT',1,NULL,NULL,1,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-05-24 09:35:12.782',NULL,'2023-05-24 09:35:12.783','2023-05-24 13:35:12.783',NULL),('d219a550-45e6-4d34-9392-643202050e04',664,'fc32fcc1-f66c-42d5-93d9-1379911add0c','ORDER','NOT_SENT',0,'2022-11-28 18:00:00.000',NULL,0,4,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-18 20:28:14.000',NULL,'2022-11-18 20:46:06.000','2023-05-17 17:16:39.641',NULL),('d23524b1-d35b-4946-a69e-a2e7ff1d121e',664,'a72c11a4-05dc-4421-b252-fbfcecd2559e','CROWN','DATE_VALIDATED',0,'2020-09-16 00:00:01.000',NULL,0,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-09-09 17:34:58.000',NULL,'2020-09-17 12:22:35.000','2022-03-14 13:43:01.000','2022-03-14 14:43:01.000'),('e2c9a4f6-7174-4966-b244-648673c0bd6f',664,'04e0da18-656d-4d28-ad6d-e20cdfe5e2df','ORDER','SENT',0,'2022-11-07 12:00:00.000',NULL,0,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-02 18:55:42.000','2022-11-02 19:23:42.000','2022-11-02 18:56:52.000','2022-11-02 23:23:42.000','2022-11-02 19:23:42.000'),('e34746f8-98f4-11ee-ae49-58a023cda0dc',664,'e343b867-98f4-11ee-ae49-58a023cda0dc','Order n° 1.56.5.1','DATE_VALIDATED',0,'2023-12-29 00:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-12-12 08:46:44.000',NULL,'2023-12-12 11:16:00.000','2024-08-28 12:07:32.613','2024-08-28 08:07:32.613'),('e5931e17-9060-4f04-9eac-a9ebae07c42d',664,'6834852b-fe98-4445-9c5d-2b6bf3991183','ORDER','SENT',0,'2022-05-26 06:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-05-25 19:30:39.000','2022-05-26 22:11:06.000','2022-05-25 19:48:42.000','2022-05-27 02:11:06.000','2022-05-26 22:11:06.000'),('e811fdc8-4e79-4f7c-83bb-0fb3afe35b50',664,'04e0da18-656d-4d28-ad6d-e20cdfe5e2df','ORDER','SENT',1,'2022-11-07 18:00:00.000',NULL,0,3,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-02 19:23:58.000',NULL,'2022-11-02 19:26:23.000','2022-11-02 23:26:25.000','2022-11-02 19:26:25.000'),('ea343662-ea36-42db-b63d-dd61bc999ce0',664,'2c0cd853-bd71-4c57-b3ee-9a18dcdf1d8f','ORDER','DATE_VALIDATED',0,'2022-03-25 00:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-24 16:42:26.000',NULL,'2022-04-21 23:19:12.000','2022-04-22 03:19:12.000','2022-04-21 23:19:12.000'),('edc95e90-9842-11ee-86e7-58a023cda0dc',664,'edc54ca0-9842-11ee-86e7-58a023cda0dc','Order n° 1.56.3.1','NOT_SENT',1,NULL,NULL,1,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-12-11 11:32:51.972','2023-12-11 11:33:48.238','2023-12-11 11:33:48.238','2023-12-11 16:33:48.239',NULL),('eed2f9c6-572c-11ee-a378-58a023cda0dc',664,'eecd8fd5-572c-11ee-a378-58a023cda0dc','Order n° 1.32.2.1','NOT_SENT',1,NULL,NULL,1,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-09-19 16:41:39.204','2023-09-19 16:42:31.287','2023-09-19 16:42:31.288','2023-09-19 20:42:31.289',NULL),('f472220d-d6e7-42a3-bcaf-a8834487cfd4',664,'e530f0de-323f-4c29-bb17-b5bfe0da3afd','ORDER','SENT',1,'2022-11-03 05:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-02 16:09:39.000',NULL,'2022-11-02 16:11:40.000','2022-11-02 20:11:42.000','2022-11-02 16:11:42.000'),('f4b76bbe-1f7d-4a48-9b89-a3a8b350b719',664,'955946be-5764-4c34-9e84-61682f4fdf78','ORDER','NOT_SENT',0,'2022-09-05 18:00:00.000',NULL,0,2,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-22 15:28:27.000',NULL,'2022-09-21 17:54:46.000','2023-05-17 17:16:39.641',NULL),('f515018f-7aed-4466-a056-f2b9bf180db3',664,'04e0da18-656d-4d28-ad6d-e20cdfe5e2df','ORDER','SENT',0,'2022-11-07 12:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-19 19:32:44.000',NULL,'2022-11-02 16:36:47.000','2022-11-02 20:36:46.000','2022-11-02 16:36:46.000'),('fafb038b-651a-4236-89fc-fe854cd20c83',664,'955946be-5764-4c34-9e84-61682f4fdf78','ORDER','SENT',0,'2022-08-16 18:00:00.000',NULL,0,1,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-01 16:48:53.000',NULL,'2022-08-01 17:00:49.000','2022-08-01 21:00:50.000','2022-08-01 17:00:50.000'),('fe4e3868-3697-40bc-ae0f-9780656aa9e1',664,'bedb7118-06cc-4f3a-ad71-4ce86dd0b0b6','ORDER','NOT_SENT',0,'2022-11-28 18:00:00.000',NULL,0,3,'f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-18 21:06:45.000',NULL,'2022-11-21 15:07:01.000','2023-05-17 17:16:39.641',NULL);
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ProstheticOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
INSERT INTO `ProstheticOrderFile` VALUES (664,'0226bc43-b62b-4f3e-8246-e4fb73ae4a28','91e3e40c-b1ea-42dd-ae35-8df274c2b234','SCAN'),(664,'0226bc43-b62b-4f3e-8246-e4fb73ae4a28','9b387987-e8a0-44b3-a6d7-f5768d6c1991','SCAN'),(664,'0226bc43-b62b-4f3e-8246-e4fb73ae4a28','a2779544-f7de-49f8-8de9-40d9bb4b9a53','FORM'),(664,'0226bc43-b62b-4f3e-8246-e4fb73ae4a28','e5aef4d2-31a2-46d6-baad-9f8289109763','SCAN'),(664,'06d57180-983c-11ee-86e7-58a023cda0dc','2b226dbb-9839-11ee-86e7-58a023cda0dc','SCAN'),(664,'06d57180-983c-11ee-86e7-58a023cda0dc','2b227cd2-9839-11ee-86e7-58a023cda0dc','SCAN'),(664,'06d57180-983c-11ee-86e7-58a023cda0dc','99be3996-9839-11ee-86e7-58a023cda0dc','SCAN'),(664,'06d57180-983c-11ee-86e7-58a023cda0dc','99be4912-9839-11ee-86e7-58a023cda0dc','SCAN'),(664,'06d57180-983c-11ee-86e7-58a023cda0dc','acb9bb4d-983c-11ee-86e7-58a023cda0dc','FORM'),(664,'06d57180-983c-11ee-86e7-58a023cda0dc','bca84273-9838-11ee-86e7-58a023cda0dc','SCAN'),(664,'06d57180-983c-11ee-86e7-58a023cda0dc','bca8530d-9838-11ee-86e7-58a023cda0dc','SCAN'),(664,'0b106085-a874-4785-83a0-f28eb5473492','055bb022-85cd-4a55-9a46-10afca2d621d','SCAN'),(664,'0b106085-a874-4785-83a0-f28eb5473492','8bda8472-2262-4cee-90a4-66ef69187724','FORM'),(664,'0b106085-a874-4785-83a0-f28eb5473492','a540af64-2782-40e1-98e6-71a1da04b4e8','SCAN'),(664,'0b106085-a874-4785-83a0-f28eb5473492','cf55af4f-6f13-40b8-8ac4-8ef9f3d0c140','SCAN'),(664,'0b106085-a874-4785-83a0-f28eb5473492','eccada04-8cc9-4fbe-8496-9337e8b83637','FORM'),(664,'0ec89083-772a-11ee-867e-58a023cda0dc','17e8834e-7343-11ee-b011-58a023cda0dc','SCAN'),(664,'0ec89083-772a-11ee-867e-58a023cda0dc','17e89282-7343-11ee-b011-58a023cda0dc','SCAN'),(664,'0ec89083-772a-11ee-867e-58a023cda0dc','55567078-7342-11ee-b011-58a023cda0dc','SCAN'),(664,'0ec89083-772a-11ee-867e-58a023cda0dc','55567fa8-7342-11ee-b011-58a023cda0dc','SCAN'),(664,'0ec89083-772a-11ee-867e-58a023cda0dc','c6306a6c-7342-11ee-b011-58a023cda0dc','SCAN'),(664,'0ec89083-772a-11ee-867e-58a023cda0dc','c6307916-7342-11ee-b011-58a023cda0dc','SCAN'),(664,'0ec89083-772a-11ee-867e-58a023cda0dc','cb769c4e-772a-11ee-867e-58a023cda0dc','FORM'),(664,'133bf366-2526-4d75-9242-6e7caee5aa64','04d5729b-24fa-4bd7-aae0-731968a61592','SCAN'),(664,'133bf366-2526-4d75-9242-6e7caee5aa64','358f428e-90db-4934-b2f1-3ca9caee9125','FORM'),(664,'133bf366-2526-4d75-9242-6e7caee5aa64','93860282-92b8-481f-9798-793726627785','SCAN'),(664,'133bf366-2526-4d75-9242-6e7caee5aa64','97fc9012-a54b-49d1-94c9-f89634ee71b9','SCAN'),(664,'133bf366-2526-4d75-9242-6e7caee5aa64','bab90ee4-be72-463a-9fcc-241e88b8af7c','SCAN'),(664,'133bf366-2526-4d75-9242-6e7caee5aa64','ccfc256c-f67b-43e6-859d-78f6db34fd4b','SCAN'),(664,'16e355a3-b14e-430a-923b-9a23341e2aa3','05a673f7-2845-4bda-810e-138d2f78652c','SCAN'),(664,'16e355a3-b14e-430a-923b-9a23341e2aa3','1327ec84-5062-4d24-bc87-76829fa164d9','SCAN'),(664,'16e355a3-b14e-430a-923b-9a23341e2aa3','228b24fc-bc5e-4533-a442-ce3fb1eda0c7','FORM'),(664,'16e355a3-b14e-430a-923b-9a23341e2aa3','29aded90-0cc8-4df4-bbd6-05692b125871','SCAN'),(664,'16e355a3-b14e-430a-923b-9a23341e2aa3','4c4dcb51-ef14-4ae6-9a4b-40d745bebdf7','SCAN'),(664,'16e355a3-b14e-430a-923b-9a23341e2aa3','e0fc0b6f-d43e-46fd-8b64-3e6b7edb4a91','SCAN'),(664,'1813dac1-af6a-4e4c-8f60-2564d6ebab92','05a673f7-2845-4bda-810e-138d2f78652c','SCAN'),(664,'1813dac1-af6a-4e4c-8f60-2564d6ebab92','1327ec84-5062-4d24-bc87-76829fa164d9','SCAN'),(664,'1813dac1-af6a-4e4c-8f60-2564d6ebab92','29aded90-0cc8-4df4-bbd6-05692b125871','SCAN'),(664,'1813dac1-af6a-4e4c-8f60-2564d6ebab92','4c4dcb51-ef14-4ae6-9a4b-40d745bebdf7','SCAN'),(664,'1813dac1-af6a-4e4c-8f60-2564d6ebab92','77c6f7c4-1f2a-4d74-a31c-6f1c54373267','FORM'),(664,'1813dac1-af6a-4e4c-8f60-2564d6ebab92','e0fc0b6f-d43e-46fd-8b64-3e6b7edb4a91','SCAN'),(664,'1e218460-1625-4cb2-b347-dcad66378660','05a673f7-2845-4bda-810e-138d2f78652c','SCAN'),(664,'1e218460-1625-4cb2-b347-dcad66378660','1327ec84-5062-4d24-bc87-76829fa164d9','SCAN'),(664,'1e218460-1625-4cb2-b347-dcad66378660','29aded90-0cc8-4df4-bbd6-05692b125871','SCAN'),(664,'1e218460-1625-4cb2-b347-dcad66378660','4c4dcb51-ef14-4ae6-9a4b-40d745bebdf7','SCAN'),(664,'1e218460-1625-4cb2-b347-dcad66378660','e0fc0b6f-d43e-46fd-8b64-3e6b7edb4a91','SCAN'),(664,'1e218460-1625-4cb2-b347-dcad66378660','fb88a068-9ecf-4df8-a63d-72081fd4e147','FORM'),(664,'223975e3-130e-4b67-8ab4-69e9e3adbfc8','00af650a-5d5c-42b6-af45-b746624924b3','FORM'),(664,'223975e3-130e-4b67-8ab4-69e9e3adbfc8','0cc0a4e2-b944-4f97-b8fd-4141a51c8b36','SCAN'),(664,'223975e3-130e-4b67-8ab4-69e9e3adbfc8','296f7328-8d99-48be-b336-a9bd0eb50498','SCAN'),(664,'23a16fe0-ed03-4415-a9e6-882ce7bc94f3','055bb022-85cd-4a55-9a46-10afca2d621d','SCAN'),(664,'23a16fe0-ed03-4415-a9e6-882ce7bc94f3','82645c6b-3b05-4920-acad-9d001cacb5ea','FORM'),(664,'23a16fe0-ed03-4415-a9e6-882ce7bc94f3','a540af64-2782-40e1-98e6-71a1da04b4e8','SCAN'),(664,'23a16fe0-ed03-4415-a9e6-882ce7bc94f3','cf55af4f-6f13-40b8-8ac4-8ef9f3d0c140','SCAN'),(664,'249e488c-5a44-41ef-8fc3-630cd1be0fb7','231fd3a6-6aa1-481c-84e8-fb456bdbae59','SCAN'),(664,'249e488c-5a44-41ef-8fc3-630cd1be0fb7','42637d2d-50b1-4ef7-a0ae-40aef183b97e','SCAN'),(664,'249e488c-5a44-41ef-8fc3-630cd1be0fb7','99db3193-ff76-4f3f-a7c2-aa110e6a5695','FORM'),(664,'249e488c-5a44-41ef-8fc3-630cd1be0fb7','b48b199f-561e-4239-8141-bbd54b8a7a80','SCAN'),(664,'249e488c-5a44-41ef-8fc3-630cd1be0fb7','c3ba59bf-d6c1-4148-b9f2-a2a974828687','SCAN'),(664,'2a260279-f2f6-4f7c-8756-e8a27606b0b3','262fff38-dd7b-4940-ac0a-a2a7e1645e65','SCAN'),(664,'2a260279-f2f6-4f7c-8756-e8a27606b0b3','74cbcc03-20d0-488e-89d0-9f502483117a','SCAN'),(664,'2a260279-f2f6-4f7c-8756-e8a27606b0b3','7daf99fd-27e4-4724-8ff7-e3ce87982137','SCAN'),(664,'2a260279-f2f6-4f7c-8756-e8a27606b0b3','8079e323-06a0-4f3d-aceb-723f10a814a8','SCAN'),(664,'2a260279-f2f6-4f7c-8756-e8a27606b0b3','9dc0f236-1455-4d5a-8b25-404e95fc9a37','FORM'),(664,'2a260279-f2f6-4f7c-8756-e8a27606b0b3','d172973d-e407-4b2d-a3d4-a9faaa303da6','SCAN'),(664,'2a260279-f2f6-4f7c-8756-e8a27606b0b3','ef6d4b7f-c6eb-4040-924f-8b7304ee7248','SCAN'),(664,'2f5b2737-e56b-4716-8b81-b8f39386743d','be00d1bd-c78e-4b52-8426-ae28db017a78','FORM'),(664,'2f5b2737-e56b-4716-8b81-b8f39386743d','c2409855-6e21-47ba-ac07-1ce2895179b8','SCAN'),(664,'331e8399-8fa1-408a-b55e-1adf0a2ef6c0','4fe9c7bf-a124-42a0-a4cb-40c29d457a64','FORM'),(664,'331e8399-8fa1-408a-b55e-1adf0a2ef6c0','8713dea0-3fef-4030-a61f-3076f107ca1f','FORM'),(664,'331e8399-8fa1-408a-b55e-1adf0a2ef6c0','a7a3c050-c3db-4379-bc91-d2bd0affd589','SCAN'),(664,'5197160e-6765-4f00-a914-1b83136e95ff','01d9850c-07c1-4bce-bfc7-a103199fd817','SCAN'),(664,'5197160e-6765-4f00-a914-1b83136e95ff','55b4752c-9281-4cf2-8a88-4ddbfa881539','SCAN'),(664,'5197160e-6765-4f00-a914-1b83136e95ff','5d5f4518-2d25-4373-8c05-e40c2e52e93d','SCAN'),(664,'5197160e-6765-4f00-a914-1b83136e95ff','82334e6c-351a-420d-b00b-1f8b84c0a9ba','SCAN'),(664,'5197160e-6765-4f00-a914-1b83136e95ff','860b8bfc-91cf-4879-9b67-96ce35dffe8b','SCAN'),(664,'5197160e-6765-4f00-a914-1b83136e95ff','8aa77d37-a70d-4b94-b8ee-9b4ccbea2b38','SCAN'),(664,'5197160e-6765-4f00-a914-1b83136e95ff','c6890662-f4e5-4556-85ae-1a5367397a93','FORM'),(664,'52de723f-4bdd-4b2d-87a6-fb648e680fbb','3f56431a-39e2-4537-933e-99ea66b80566','SCAN'),(664,'52de723f-4bdd-4b2d-87a6-fb648e680fbb','62f54f6a-ef8d-42ba-8d34-1edc178619aa','FORM'),(664,'52de723f-4bdd-4b2d-87a6-fb648e680fbb','7e92b49e-bc5f-4233-9657-58c0df873f81','SCAN'),(664,'52de723f-4bdd-4b2d-87a6-fb648e680fbb','896b62a5-2257-4335-b9f8-a711ad38d5c8','SCAN'),(664,'52de723f-4bdd-4b2d-87a6-fb648e680fbb','8ce4ae13-659c-4b1b-859a-61a6bce748d7','SCAN'),(664,'52de723f-4bdd-4b2d-87a6-fb648e680fbb','aafe80ec-b241-47c3-98cb-9c43a7207ae2','SCAN'),(664,'52de723f-4bdd-4b2d-87a6-fb648e680fbb','b3abd969-6b20-48f6-9d4d-0fb8e4e2a650','SCAN'),(664,'52de723f-4bdd-4b2d-87a6-fb648e680fbb','c87746da-76e6-42d0-aa1a-53cd19375318','SCAN'),(664,'52de723f-4bdd-4b2d-87a6-fb648e680fbb','e9a1cf3e-9639-4ec7-8417-34a46ed30e75','SCAN'),(664,'54410525-60fc-4d0d-9655-9ea6638a6043','7ea07429-5447-4d83-a220-b0cf75c4f7ca','FORM'),(664,'54410525-60fc-4d0d-9655-9ea6638a6043','924eb01d-c7f1-4784-ab3d-bffa8647cc5a','SCAN'),(664,'54410525-60fc-4d0d-9655-9ea6638a6043','aa6f8d0d-76df-4627-adec-a79670c64f0a','SCAN'),(664,'54410525-60fc-4d0d-9655-9ea6638a6043','bb25c8c5-6854-4fe0-be65-94e273c0d922','SCAN'),(664,'54410525-60fc-4d0d-9655-9ea6638a6043','c0de44a6-6316-4997-9cb5-d1b77defc44c','FORM'),(664,'548a8b15-a19f-42cb-80ef-399c4e3a51ee','0e193ac6-c011-45df-8829-5c9742aad5b4','FORM'),(664,'548a8b15-a19f-42cb-80ef-399c4e3a51ee','262fff38-dd7b-4940-ac0a-a2a7e1645e65','SCAN'),(664,'548a8b15-a19f-42cb-80ef-399c4e3a51ee','74cbcc03-20d0-488e-89d0-9f502483117a','SCAN'),(664,'548a8b15-a19f-42cb-80ef-399c4e3a51ee','7daf99fd-27e4-4724-8ff7-e3ce87982137','SCAN'),(664,'548a8b15-a19f-42cb-80ef-399c4e3a51ee','8079e323-06a0-4f3d-aceb-723f10a814a8','SCAN'),(664,'548a8b15-a19f-42cb-80ef-399c4e3a51ee','d172973d-e407-4b2d-a3d4-a9faaa303da6','SCAN'),(664,'548a8b15-a19f-42cb-80ef-399c4e3a51ee','ef6d4b7f-c6eb-4040-924f-8b7304ee7248','SCAN'),(664,'64b9506d-1475-4965-b3d3-054a5a076a37','041aa495-530d-4b35-9123-837a50cb5169','FORM'),(664,'64b9506d-1475-4965-b3d3-054a5a076a37','248f95a0-ad8d-40f1-bf9e-68ceaee0d7ba','SCAN'),(664,'64b9506d-1475-4965-b3d3-054a5a076a37','2e76bc0f-07df-4175-add2-e13f7adb84e5','SCAN'),(664,'64b9506d-1475-4965-b3d3-054a5a076a37','6887579a-3781-49f4-a96e-de18760adf09','SCAN'),(664,'660769ad-1b3a-4e07-ba2e-3a8721ccaf28','06bf9050-09ab-4cd9-82f1-c218c9a25dee','SCAN'),(664,'660769ad-1b3a-4e07-ba2e-3a8721ccaf28','7b10fba4-5aee-4832-9158-2978a6c17e5d','FORM'),(664,'660769ad-1b3a-4e07-ba2e-3a8721ccaf28','c452aac6-05e7-48c3-aef6-2cb3a21d6dc4','SCAN'),(664,'660769ad-1b3a-4e07-ba2e-3a8721ccaf28','d46395de-c663-445e-93b7-6b0eef50a5d7','SCAN'),(664,'68450b97-4193-42f4-a818-4bca3fb50cca','a116495f-1bcf-4022-af0c-f807a25b1c9c','FORM'),(664,'68450b97-4193-42f4-a818-4bca3fb50cca','bf778da7-bcd4-47d5-8c14-ef8ea32c4781','FORM'),(664,'68450b97-4193-42f4-a818-4bca3fb50cca','fdc7cf45-27ee-493e-893d-702f5a989b40','SCAN'),(664,'6a27a984-b0e8-4a31-b556-c4234f6cefec','26383578-97b4-469c-83c8-1399e6fdf5c9','SCAN'),(664,'6a27a984-b0e8-4a31-b556-c4234f6cefec','46f0433f-a2b0-4717-9b73-038d45591362','SCAN'),(664,'6a27a984-b0e8-4a31-b556-c4234f6cefec','9bad6bed-66cd-4aaf-9b18-74f56381c4d1','FORM'),(664,'6a27a984-b0e8-4a31-b556-c4234f6cefec','c07ab4b3-ce6f-4eeb-859d-40b3c4631562','SCAN'),(664,'6a27a984-b0e8-4a31-b556-c4234f6cefec','d3c2fb35-0aff-4775-8c47-8085c2bb4a6c','SCAN'),(664,'6a27a984-b0e8-4a31-b556-c4234f6cefec','d81a9394-1d76-4e0d-bbe3-266fa262538c','SCAN'),(664,'6a27a984-b0e8-4a31-b556-c4234f6cefec','f81ac2c3-1a0f-4064-a1eb-844d818e111c','SCAN'),(664,'719d069f-1c89-4cc2-a04d-982bb719d80a','06bf9050-09ab-4cd9-82f1-c218c9a25dee','SCAN'),(664,'719d069f-1c89-4cc2-a04d-982bb719d80a','248f95a0-ad8d-40f1-bf9e-68ceaee0d7ba','SCAN'),(664,'719d069f-1c89-4cc2-a04d-982bb719d80a','2e76bc0f-07df-4175-add2-e13f7adb84e5','SCAN'),(664,'719d069f-1c89-4cc2-a04d-982bb719d80a','3a824a4d-1071-47df-83b6-85274c6103ec','FORM'),(664,'719d069f-1c89-4cc2-a04d-982bb719d80a','6887579a-3781-49f4-a96e-de18760adf09','SCAN'),(664,'719d069f-1c89-4cc2-a04d-982bb719d80a','c452aac6-05e7-48c3-aef6-2cb3a21d6dc4','SCAN'),(664,'719d069f-1c89-4cc2-a04d-982bb719d80a','d46395de-c663-445e-93b7-6b0eef50a5d7','SCAN'),(664,'73b64ad8-c002-4b00-8cb0-479d3d5e1a46','09e45aca-9e2d-422a-8ede-017b9008e6fa','SCAN'),(664,'73b64ad8-c002-4b00-8cb0-479d3d5e1a46','77bf1215-677a-4878-bef9-8a318da9a518','SCAN'),(664,'73b64ad8-c002-4b00-8cb0-479d3d5e1a46','8a9085db-de52-4842-bf76-b2b32984ecc0','SCAN'),(664,'73b64ad8-c002-4b00-8cb0-479d3d5e1a46','9893fa50-f84e-4275-9dbd-698be7666922','FORM'),(664,'73b64ad8-c002-4b00-8cb0-479d3d5e1a46','c79bcc05-9134-4911-9d18-30ba07308e7c','FORM'),(664,'79d31a7b-5bca-11ee-9658-58a023cda0dc','53edd693-5bc2-11ee-9658-58a023cda0dc','SCAN'),(664,'79d31a7b-5bca-11ee-9658-58a023cda0dc','53ede708-5bc2-11ee-9658-58a023cda0dc','SCAN'),(664,'79d31a7b-5bca-11ee-9658-58a023cda0dc','82c71f9b-5bca-11ee-9658-58a023cda0dc','FORM'),(664,'79d31a7b-5bca-11ee-9658-58a023cda0dc','87bdb983-5bc6-11ee-9658-58a023cda0dc','SCAN'),(664,'79d31a7b-5bca-11ee-9658-58a023cda0dc','87e4fb11-5bc6-11ee-9658-58a023cda0dc','SCAN'),(664,'79d31a7b-5bca-11ee-9658-58a023cda0dc','88698a51-5bc6-11ee-9658-58a023cda0dc','SCAN'),(664,'79d31a7b-5bca-11ee-9658-58a023cda0dc','9e5a1940-5bc3-11ee-9658-58a023cda0dc','SCAN'),(664,'79d31a7b-5bca-11ee-9658-58a023cda0dc','9e5a4f15-5bc3-11ee-9658-58a023cda0dc','SCAN'),(664,'79d31a7b-5bca-11ee-9658-58a023cda0dc','ad938206-5bc4-11ee-9658-58a023cda0dc','SCAN'),(664,'79d31a7b-5bca-11ee-9658-58a023cda0dc','ad9391da-5bc4-11ee-9658-58a023cda0dc','SCAN'),(664,'79d31a7b-5bca-11ee-9658-58a023cda0dc','c37cdd93-5bc2-11ee-9658-58a023cda0dc','SCAN'),(664,'79d31a7b-5bca-11ee-9658-58a023cda0dc','c37cebbc-5bc2-11ee-9658-58a023cda0dc','SCAN'),(664,'7bb41f92-9801-4a80-9db6-907964cacece','92bd4757-0c86-4e51-ab79-39f0a6427d18','FORM'),(664,'8515ad34-77a4-41f6-a53a-5be823e2f13d','23d0f00e-28e6-4e95-acb1-832d1d3440c2','SCAN'),(664,'8515ad34-77a4-41f6-a53a-5be823e2f13d','4227ee27-5a61-436a-ae69-cd486657a34d','SCAN'),(664,'8515ad34-77a4-41f6-a53a-5be823e2f13d','5b12fd9e-03c6-4145-8366-7a8646402a7c','SCAN'),(664,'8515ad34-77a4-41f6-a53a-5be823e2f13d','7aa1b303-4eea-4bf0-85e6-2e29f68d0606','FORM'),(664,'8515ad34-77a4-41f6-a53a-5be823e2f13d','c6c988d8-32fa-4c6f-bbce-54db4f46c38b','FORM'),(664,'854d2595-c6e3-4d27-8fbd-55e7fc6c19e4','73e3f675-fef8-44e6-bc33-f21678a2af71','FORM'),(664,'854d2595-c6e3-4d27-8fbd-55e7fc6c19e4','74d73d8b-010c-4098-86e4-3b850bd977a4','FORM'),(664,'854d2595-c6e3-4d27-8fbd-55e7fc6c19e4','a685a8d2-db8d-41c7-9651-468bdf6230ed','SCAN'),(664,'854d2595-c6e3-4d27-8fbd-55e7fc6c19e4','d0bcb772-695a-4912-a5a9-77dd0eb49a1a','SCAN'),(664,'8585764e-6028-48b5-bf39-ddba86be173e','055bb022-85cd-4a55-9a46-10afca2d621d','SCAN'),(664,'8585764e-6028-48b5-bf39-ddba86be173e','a540af64-2782-40e1-98e6-71a1da04b4e8','SCAN'),(664,'8585764e-6028-48b5-bf39-ddba86be173e','cf55af4f-6f13-40b8-8ac4-8ef9f3d0c140','SCAN'),(664,'8585764e-6028-48b5-bf39-ddba86be173e','f06bc9ca-26d6-4759-bf98-4c270f5b51aa','FORM'),(664,'98f23fdc-6e7d-411a-a2b5-b74bf1ad5f3c','188b2bd0-af23-438c-b1c2-d75a6ce28b1c','FORM'),(664,'98f23fdc-6e7d-411a-a2b5-b74bf1ad5f3c','1e09f189-8cf5-4779-8b20-93354ae9b869','SCAN'),(664,'98f23fdc-6e7d-411a-a2b5-b74bf1ad5f3c','70d2409c-e30f-487b-9df8-7257b6ffa89c','SCAN'),(664,'98f23fdc-6e7d-411a-a2b5-b74bf1ad5f3c','d3a6ed76-d8dc-47e6-ae66-239731164381','SCAN'),(664,'9ab7328d-44e3-46af-b634-75d45259e276','87f24399-95c3-49ca-8a79-2a2ed392857a','FORM'),(664,'9ab7328d-44e3-46af-b634-75d45259e276','c2409855-6e21-47ba-ac07-1ce2895179b8','SCAN'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','0724c208-734f-11ee-b011-58a023cda0dc','SCAN'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','0724d1c1-734f-11ee-b011-58a023cda0dc','SCAN'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','273de692-7728-11ee-867e-58a023cda0dc','FORM'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','40d7a1b0-734f-11ee-b011-58a023cda0dc','SCAN'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','40d7b163-734f-11ee-b011-58a023cda0dc','SCAN'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','65c962f0-734f-11ee-b011-58a023cda0dc','SCAN'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','65f84d65-734f-11ee-b011-58a023cda0dc','SCAN'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','668d19f2-734f-11ee-b011-58a023cda0dc','SCAN'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','7dd9b5ba-734e-11ee-b011-58a023cda0dc','SCAN'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','7dd9c4e0-734e-11ee-b011-58a023cda0dc','SCAN'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','c4cdf10c-734c-11ee-b011-58a023cda0dc','SCAN'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','c4ce0fdf-734c-11ee-b011-58a023cda0dc','SCAN'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','ca02c680-734e-11ee-b011-58a023cda0dc','SCAN'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','ca02d758-734e-11ee-b011-58a023cda0dc','SCAN'),(664,'a70ea958-6c46-11ee-bc7f-58a023cda0dc','19eba3d6-6c36-11ee-bc7f-58a023cda0dc','SCAN'),(664,'a70ea958-6c46-11ee-bc7f-58a023cda0dc','19ec321c-6c36-11ee-bc7f-58a023cda0dc','SCAN'),(664,'a70ea958-6c46-11ee-bc7f-58a023cda0dc','389a8857-6c47-11ee-bc7f-58a023cda0dc','FORM'),(664,'a70ea958-6c46-11ee-bc7f-58a023cda0dc','9fa26aa6-6c36-11ee-bc7f-58a023cda0dc','SCAN'),(664,'a70ea958-6c46-11ee-bc7f-58a023cda0dc','9fa279c1-6c36-11ee-bc7f-58a023cda0dc','SCAN'),(664,'a70ea958-6c46-11ee-bc7f-58a023cda0dc','ceac08e6-6c36-11ee-bc7f-58a023cda0dc','SCAN'),(664,'a70ea958-6c46-11ee-bc7f-58a023cda0dc','ceac18ef-6c36-11ee-bc7f-58a023cda0dc','SCAN'),(664,'a70ea958-6c46-11ee-bc7f-58a023cda0dc','fcb6f107-6c34-11ee-bc7f-58a023cda0dc','SCAN'),(664,'a70ea958-6c46-11ee-bc7f-58a023cda0dc','fcb700b3-6c34-11ee-bc7f-58a023cda0dc','SCAN'),(664,'a91f29b5-c999-4d0b-90cf-4ff0df6707c8','1665ba5c-8084-4a22-84ab-72ef74043c9c','FORM'),(664,'a91f29b5-c999-4d0b-90cf-4ff0df6707c8','2b6df65f-bc4e-4e8b-bfb9-2335bd73430a','SCAN'),(664,'a91f29b5-c999-4d0b-90cf-4ff0df6707c8','3ec22db4-d2af-489a-b0fa-4d4e8a20600e','SCAN'),(664,'a91f29b5-c999-4d0b-90cf-4ff0df6707c8','9e6ac4cc-cd14-4cd9-813c-a58767782690','SCAN'),(664,'a91f29b5-c999-4d0b-90cf-4ff0df6707c8','abdd65b1-8e6c-4a9a-84db-e8a1b6437124','SCAN'),(664,'a91f29b5-c999-4d0b-90cf-4ff0df6707c8','d69f7757-7418-40a0-93ba-f0daeab65592','FORM'),(664,'a9d67f35-6b75-41ae-8fc0-04ebed5dcbc6','4569d449-c0a3-4229-9f9d-9d173955cbd7','FORM'),(664,'a9d67f35-6b75-41ae-8fc0-04ebed5dcbc6','924eb01d-c7f1-4784-ab3d-bffa8647cc5a','SCAN'),(664,'a9d67f35-6b75-41ae-8fc0-04ebed5dcbc6','aa6f8d0d-76df-4627-adec-a79670c64f0a','SCAN'),(664,'a9d67f35-6b75-41ae-8fc0-04ebed5dcbc6','bb25c8c5-6854-4fe0-be65-94e273c0d922','SCAN'),(664,'b3fd7ab4-7c7c-487a-96e9-21275b318b80','055bb022-85cd-4a55-9a46-10afca2d621d','SCAN'),(664,'b3fd7ab4-7c7c-487a-96e9-21275b318b80','a540af64-2782-40e1-98e6-71a1da04b4e8','SCAN'),(664,'b3fd7ab4-7c7c-487a-96e9-21275b318b80','cf55af4f-6f13-40b8-8ac4-8ef9f3d0c140','SCAN'),(664,'b3fd7ab4-7c7c-487a-96e9-21275b318b80','fbef9cf1-1cb4-49e9-88af-626767272b04','FORM'),(664,'b765206e-6542-11ef-b382-58a023cda0dc','4494a5b9-653f-11ef-b382-58a023cda0dc','SCAN'),(664,'b765206e-6542-11ef-b382-58a023cda0dc','4494b511-653f-11ef-b382-58a023cda0dc','SCAN'),(664,'b765206e-6542-11ef-b382-58a023cda0dc','5d0397fc-6540-11ef-b382-58a023cda0dc','SCAN'),(664,'b765206e-6542-11ef-b382-58a023cda0dc','5d03a767-6540-11ef-b382-58a023cda0dc','SCAN'),(664,'b765206e-6542-11ef-b382-58a023cda0dc','946f18a4-6540-11ef-b382-58a023cda0dc','SCAN'),(664,'b765206e-6542-11ef-b382-58a023cda0dc','946f2cbd-6540-11ef-b382-58a023cda0dc','SCAN'),(664,'b765206e-6542-11ef-b382-58a023cda0dc','d7d428c8-6542-11ef-b382-58a023cda0dc','FORM'),(664,'b765206e-6542-11ef-b382-58a023cda0dc','e017d672-6540-11ef-b382-58a023cda0dc','SCAN'),(664,'b765206e-6542-11ef-b382-58a023cda0dc','e0190e85-6540-11ef-b382-58a023cda0dc','SCAN'),(664,'b765206e-6542-11ef-b382-58a023cda0dc','fa2571a4-653f-11ef-b382-58a023cda0dc','SCAN'),(664,'b765206e-6542-11ef-b382-58a023cda0dc','fa258235-653f-11ef-b382-58a023cda0dc','SCAN'),(664,'bd06bb45-1ca4-4e1a-bd3b-f5da30b77316','088dc1b3-7eb5-464b-a7c2-b50922838a77','FORM'),(664,'bd06bb45-1ca4-4e1a-bd3b-f5da30b77316','7e92b49e-bc5f-4233-9657-58c0df873f81','SCAN'),(664,'bd06bb45-1ca4-4e1a-bd3b-f5da30b77316','8ce4ae13-659c-4b1b-859a-61a6bce748d7','SCAN'),(664,'bd06bb45-1ca4-4e1a-bd3b-f5da30b77316','aafe80ec-b241-47c3-98cb-9c43a7207ae2','SCAN'),(664,'bd06bb45-1ca4-4e1a-bd3b-f5da30b77316','b3abd969-6b20-48f6-9d4d-0fb8e4e2a650','SCAN'),(664,'bd06bb45-1ca4-4e1a-bd3b-f5da30b77316','c87746da-76e6-42d0-aa1a-53cd19375318','SCAN'),(664,'bf6a5903-e77c-47d1-aa54-6dbca17c1938','36e74d3e-7662-45a5-8241-34501ec906e8','FORM'),(664,'bf6a5903-e77c-47d1-aa54-6dbca17c1938','6fe89eae-9acf-496c-87c2-5d7d789669bd','SCAN'),(664,'bf6a5903-e77c-47d1-aa54-6dbca17c1938','b2375a76-5251-44e7-ad97-616cdc631d01','SCAN'),(664,'bf6a5903-e77c-47d1-aa54-6dbca17c1938','c16a858c-f3d1-46c0-9789-5b60741a4656','SCAN'),(664,'c155f94e-e0aa-488a-af25-8ada7a6a5b8a','06297eae-a625-4573-b1a0-fad402d6d398','SCAN'),(664,'c155f94e-e0aa-488a-af25-8ada7a6a5b8a','16b6b32b-ed98-4875-8f41-54c3aeed9650','SCAN'),(664,'c155f94e-e0aa-488a-af25-8ada7a6a5b8a','3559e869-8afd-4b40-9374-d2361cf0914a','SCAN'),(664,'c155f94e-e0aa-488a-af25-8ada7a6a5b8a','88e87b40-aa1a-40b2-844d-04660a2545e3','SCAN'),(664,'c155f94e-e0aa-488a-af25-8ada7a6a5b8a','a0431f00-fbfc-473e-b777-378011e30bbd','SCAN'),(664,'c155f94e-e0aa-488a-af25-8ada7a6a5b8a','a4dcb2d6-d779-443d-9e2d-0845bb353b4e','FORM'),(664,'c155f94e-e0aa-488a-af25-8ada7a6a5b8a','a894dedf-edb8-479e-a4e0-38594ffe81f2','SCAN'),(664,'c379ba7c-4e26-473d-a1bd-f12853d9c1a4','30b6ba97-0b5b-4537-b214-3f4ade617b76','FORM'),(664,'c379ba7c-4e26-473d-a1bd-f12853d9c1a4','325ce817-e744-4cd6-a84a-20a3e7c0e51f','SCAN'),(664,'c379ba7c-4e26-473d-a1bd-f12853d9c1a4','3491d21a-ba4e-4c00-ac22-f8de5caf6202','FORM'),(664,'c379ba7c-4e26-473d-a1bd-f12853d9c1a4','5c40acb9-f5bf-4d61-88d0-9d2dd66c3554','SCAN'),(664,'c379ba7c-4e26-473d-a1bd-f12853d9c1a4','b2797bfd-383a-4f9c-938a-60fe8de8146a','SCAN'),(664,'c379ba7c-4e26-473d-a1bd-f12853d9c1a4','ce3b2d45-df06-466e-8d53-72fb4fe941b8','SCAN'),(664,'c379ba7c-4e26-473d-a1bd-f12853d9c1a4','d209ac69-fa89-4893-8e85-fde8f654efc3','SCAN'),(664,'c7646a09-199d-41ff-9840-93f97fe9d1cb','22722603-2c83-4ed0-858c-6d2be0ae48a9','SCAN'),(664,'c7646a09-199d-41ff-9840-93f97fe9d1cb','4a4a6589-8149-4485-ab1f-6603d976f58e','SCAN'),(664,'c7646a09-199d-41ff-9840-93f97fe9d1cb','92fc9e76-e486-464f-bc7a-6f09ea6899e8','SCAN'),(664,'c7646a09-199d-41ff-9840-93f97fe9d1cb','965138c3-5a1e-4951-83ee-9b341d1f7858','SCAN'),(664,'c7646a09-199d-41ff-9840-93f97fe9d1cb','9f39de7e-1b6c-4b52-9fe3-5dac8b5e6bd6','SCAN'),(664,'c7646a09-199d-41ff-9840-93f97fe9d1cb','adca65c3-c068-425e-9917-53959630736b','SCAN'),(664,'c7646a09-199d-41ff-9840-93f97fe9d1cb','b4beeaca-9172-4b30-9b6f-a0e4bd048140','FORM'),(664,'c8a9ae43-f4da-4f8b-b98a-5d4804c238bc','05a673f7-2845-4bda-810e-138d2f78652c','SCAN'),(664,'c8a9ae43-f4da-4f8b-b98a-5d4804c238bc','1327ec84-5062-4d24-bc87-76829fa164d9','SCAN'),(664,'c8a9ae43-f4da-4f8b-b98a-5d4804c238bc','29aded90-0cc8-4df4-bbd6-05692b125871','SCAN'),(664,'c8a9ae43-f4da-4f8b-b98a-5d4804c238bc','4a86d6f8-fbf5-4b40-89c8-3f159e5e0879','FORM'),(664,'c8a9ae43-f4da-4f8b-b98a-5d4804c238bc','4c4dcb51-ef14-4ae6-9a4b-40d745bebdf7','SCAN'),(664,'c8a9ae43-f4da-4f8b-b98a-5d4804c238bc','e0fc0b6f-d43e-46fd-8b64-3e6b7edb4a91','SCAN'),(664,'c94feabc-c456-485b-b538-c3a58bce9798','04d5729b-24fa-4bd7-aae0-731968a61592','SCAN'),(664,'c94feabc-c456-485b-b538-c3a58bce9798','1d1d42ef-8d24-471c-8afb-6c0256487d0c','FORM'),(664,'c94feabc-c456-485b-b538-c3a58bce9798','93860282-92b8-481f-9798-793726627785','SCAN'),(664,'c94feabc-c456-485b-b538-c3a58bce9798','97fc9012-a54b-49d1-94c9-f89634ee71b9','SCAN'),(664,'c94feabc-c456-485b-b538-c3a58bce9798','bab90ee4-be72-463a-9fcc-241e88b8af7c','SCAN'),(664,'c94feabc-c456-485b-b538-c3a58bce9798','c12d2c0a-871d-48e9-b3de-bc4c3e6cdc17','FORM'),(664,'c94feabc-c456-485b-b538-c3a58bce9798','ccfc256c-f67b-43e6-859d-78f6db34fd4b','SCAN'),(664,'ce221fe3-3073-4ef0-aa97-eb8dc1eefb70','04156d5e-49b6-4518-b4b7-1f709a431367','SCAN'),(664,'ce221fe3-3073-4ef0-aa97-eb8dc1eefb70','0e146d0f-278a-4e47-9f58-7f65720624e5','SCAN'),(664,'ce221fe3-3073-4ef0-aa97-eb8dc1eefb70','62bf9730-f940-4f6c-a6cc-097860ffdb9d','SCAN'),(664,'ce221fe3-3073-4ef0-aa97-eb8dc1eefb70','961b1c26-009d-415b-b3e0-e5f95a643091','SCAN'),(664,'ce221fe3-3073-4ef0-aa97-eb8dc1eefb70','a8a6a645-3d3c-4deb-985b-aa5de9ebf41a','SCAN'),(664,'ce221fe3-3073-4ef0-aa97-eb8dc1eefb70','c838fee6-1af3-43e4-b1b7-b722af25e22d','FORM'),(664,'ce221fe3-3073-4ef0-aa97-eb8dc1eefb70','cba0f817-6c67-4486-a5a5-2e40973bf3af','SCAN'),(664,'ce9127f7-b01e-4e28-b330-8f397f2a043e','09e45aca-9e2d-422a-8ede-017b9008e6fa','SCAN'),(664,'ce9127f7-b01e-4e28-b330-8f397f2a043e','0bf7054d-6a4b-48e8-babb-234a4571adab','FORM'),(664,'ce9127f7-b01e-4e28-b330-8f397f2a043e','6103a761-4255-42c2-a7dd-e05a49a38969','FORM'),(664,'ce9127f7-b01e-4e28-b330-8f397f2a043e','77bf1215-677a-4878-bef9-8a318da9a518','SCAN'),(664,'ce9127f7-b01e-4e28-b330-8f397f2a043e','8a9085db-de52-4842-bf76-b2b32984ecc0','SCAN'),(664,'d219a550-45e6-4d34-9392-643202050e04','05a673f7-2845-4bda-810e-138d2f78652c','SCAN'),(664,'d219a550-45e6-4d34-9392-643202050e04','1327ec84-5062-4d24-bc87-76829fa164d9','SCAN'),(664,'d219a550-45e6-4d34-9392-643202050e04','29aded90-0cc8-4df4-bbd6-05692b125871','SCAN'),(664,'d219a550-45e6-4d34-9392-643202050e04','d14252ac-1de7-4afa-a650-24dd6f3844fd','FORM'),(664,'d219a550-45e6-4d34-9392-643202050e04','e0fc0b6f-d43e-46fd-8b64-3e6b7edb4a91','SCAN'),(664,'d23524b1-d35b-4946-a69e-a2e7ff1d121e','1574fe39-cb97-4341-97dd-0d8a2c9caaee','FORM'),(664,'d23524b1-d35b-4946-a69e-a2e7ff1d121e','3dce93ee-7ed1-4bc5-85ff-1fe06ad1d1ab','SCAN'),(664,'d23524b1-d35b-4946-a69e-a2e7ff1d121e','5895fa2b-1f6a-44ac-8137-84d879d48bff','SCAN'),(664,'d23524b1-d35b-4946-a69e-a2e7ff1d121e','98005729-251e-46d8-9ac3-e9878a47b441','SCAN'),(664,'d23524b1-d35b-4946-a69e-a2e7ff1d121e','9bde3553-f30d-4a50-b405-a030db17fb37','SCAN'),(664,'d23524b1-d35b-4946-a69e-a2e7ff1d121e','ae255d52-c5a9-4e24-bb3e-6abc7d04c0e9','SCAN'),(664,'d23524b1-d35b-4946-a69e-a2e7ff1d121e','cc17514d-dd52-4b75-b524-fe6d1ad21101','SCAN'),(664,'e2c9a4f6-7174-4966-b244-648673c0bd6f','17ff75c9-f72d-423c-a5b9-633100c3b8e5','FORM'),(664,'e2c9a4f6-7174-4966-b244-648673c0bd6f','231fd3a6-6aa1-481c-84e8-fb456bdbae59','SCAN'),(664,'e2c9a4f6-7174-4966-b244-648673c0bd6f','46f88ef2-6c3e-4840-af4b-0cc2847372fa','FORM'),(664,'e2c9a4f6-7174-4966-b244-648673c0bd6f','b48b199f-561e-4239-8141-bbd54b8a7a80','SCAN'),(664,'e2c9a4f6-7174-4966-b244-648673c0bd6f','c3ba59bf-d6c1-4148-b9f2-a2a974828687','SCAN'),(664,'e34746f8-98f4-11ee-ae49-58a023cda0dc','2b226dbb-9839-11ee-86e7-58a023cda0dc','SCAN'),(664,'e34746f8-98f4-11ee-ae49-58a023cda0dc','2b227cd2-9839-11ee-86e7-58a023cda0dc','SCAN'),(664,'e34746f8-98f4-11ee-ae49-58a023cda0dc','99be3996-9839-11ee-86e7-58a023cda0dc','SCAN'),(664,'e34746f8-98f4-11ee-ae49-58a023cda0dc','99be4912-9839-11ee-86e7-58a023cda0dc','SCAN'),(664,'e34746f8-98f4-11ee-ae49-58a023cda0dc','bca84273-9838-11ee-86e7-58a023cda0dc','SCAN'),(664,'e34746f8-98f4-11ee-ae49-58a023cda0dc','bca8530d-9838-11ee-86e7-58a023cda0dc','SCAN'),(664,'e34746f8-98f4-11ee-ae49-58a023cda0dc','f674002c-98f4-11ee-ae49-58a023cda0dc','FORM'),(664,'e5931e17-9060-4f04-9eac-a9ebae07c42d','325ce817-e744-4cd6-a84a-20a3e7c0e51f','SCAN'),(664,'e5931e17-9060-4f04-9eac-a9ebae07c42d','4dbdd202-f89f-4e3b-b032-0f2780465410','FORM'),(664,'e5931e17-9060-4f04-9eac-a9ebae07c42d','5c40acb9-f5bf-4d61-88d0-9d2dd66c3554','SCAN'),(664,'e5931e17-9060-4f04-9eac-a9ebae07c42d','a86cf3f5-c1d7-45f7-998a-3a630b114693','FORM'),(664,'e5931e17-9060-4f04-9eac-a9ebae07c42d','b2797bfd-383a-4f9c-938a-60fe8de8146a','SCAN'),(664,'e5931e17-9060-4f04-9eac-a9ebae07c42d','ce3b2d45-df06-466e-8d53-72fb4fe941b8','SCAN'),(664,'e5931e17-9060-4f04-9eac-a9ebae07c42d','d209ac69-fa89-4893-8e85-fde8f654efc3','SCAN'),(664,'e811fdc8-4e79-4f7c-83bb-0fb3afe35b50','231fd3a6-6aa1-481c-84e8-fb456bdbae59','SCAN'),(664,'e811fdc8-4e79-4f7c-83bb-0fb3afe35b50','50ba84da-fbb3-4a82-ad28-44193c241742','FORM'),(664,'e811fdc8-4e79-4f7c-83bb-0fb3afe35b50','b48b199f-561e-4239-8141-bbd54b8a7a80','SCAN'),(664,'e811fdc8-4e79-4f7c-83bb-0fb3afe35b50','c3ba59bf-d6c1-4148-b9f2-a2a974828687','SCAN'),(664,'ea343662-ea36-42db-b63d-dd61bc999ce0','219a577b-6c2c-440a-ae7a-4bc501aa7a43','SCAN'),(664,'ea343662-ea36-42db-b63d-dd61bc999ce0','4e0207c3-761b-40df-9a9e-ec615454ca8d','FORM'),(664,'ea343662-ea36-42db-b63d-dd61bc999ce0','99602643-4adf-4f72-936c-b7c9e84e9ca5','SCAN'),(664,'ea343662-ea36-42db-b63d-dd61bc999ce0','b3ec6691-f3e0-41f5-ae89-5336966f4cac','SCAN'),(664,'ea343662-ea36-42db-b63d-dd61bc999ce0','c21da88f-3f6d-4a2f-9651-4074d522cb15','FORM'),(664,'ea343662-ea36-42db-b63d-dd61bc999ce0','ee41e937-5440-4e00-b31c-adb4cc45edf8','SCAN'),(664,'f472220d-d6e7-42a3-bcaf-a8834487cfd4','4d04c526-a65f-4df6-8b9e-6fd50db8c7f5','SCAN'),(664,'f472220d-d6e7-42a3-bcaf-a8834487cfd4','8532f29a-bbac-4db3-af25-e87cb75618fc','FORM'),(664,'f4b76bbe-1f7d-4a48-9b89-a3a8b350b719','0b848954-7152-4e87-b60c-76f5ac669614','SCAN'),(664,'f4b76bbe-1f7d-4a48-9b89-a3a8b350b719','4d2adaf7-8bfc-4e39-9074-1b71491a3303','SCAN'),(664,'f4b76bbe-1f7d-4a48-9b89-a3a8b350b719','b04d457f-7b21-4521-bc90-01e2be5974b3','FORM'),(664,'f4b76bbe-1f7d-4a48-9b89-a3a8b350b719','c41ccbf2-b091-456a-af02-352476c4d367','SCAN'),(664,'f4b76bbe-1f7d-4a48-9b89-a3a8b350b719','df32e9cc-0861-4ad7-ad2a-718737b05992','SCAN'),(664,'f4b76bbe-1f7d-4a48-9b89-a3a8b350b719','eb3d7b07-28dd-4076-a69c-80c7abd0be51','SCAN'),(664,'f515018f-7aed-4466-a056-f2b9bf180db3','231fd3a6-6aa1-481c-84e8-fb456bdbae59','SCAN'),(664,'f515018f-7aed-4466-a056-f2b9bf180db3','32ef6002-3a1f-472f-ab27-d59782d15aad','FORM'),(664,'f515018f-7aed-4466-a056-f2b9bf180db3','8c6401d6-a141-46ea-b3db-852a74d9cde7','FORM'),(664,'f515018f-7aed-4466-a056-f2b9bf180db3','b48b199f-561e-4239-8141-bbd54b8a7a80','SCAN'),(664,'f515018f-7aed-4466-a056-f2b9bf180db3','c3ba59bf-d6c1-4148-b9f2-a2a974828687','SCAN'),(664,'fafb038b-651a-4236-89fc-fe854cd20c83','0b848954-7152-4e87-b60c-76f5ac669614','SCAN'),(664,'fafb038b-651a-4236-89fc-fe854cd20c83','4d2adaf7-8bfc-4e39-9074-1b71491a3303','SCAN'),(664,'fafb038b-651a-4236-89fc-fe854cd20c83','aa4e5c15-e939-46a6-a75e-c5b67cdbad7b','FORM'),(664,'fafb038b-651a-4236-89fc-fe854cd20c83','c41ccbf2-b091-456a-af02-352476c4d367','SCAN'),(664,'fafb038b-651a-4236-89fc-fe854cd20c83','df32e9cc-0861-4ad7-ad2a-718737b05992','SCAN'),(664,'fafb038b-651a-4236-89fc-fe854cd20c83','eb3d7b07-28dd-4076-a69c-80c7abd0be51','SCAN'),(664,'fe4e3868-3697-40bc-ae0f-9780656aa9e1','055bb022-85cd-4a55-9a46-10afca2d621d','SCAN'),(664,'fe4e3868-3697-40bc-ae0f-9780656aa9e1','a540af64-2782-40e1-98e6-71a1da04b4e8','SCAN'),(664,'fe4e3868-3697-40bc-ae0f-9780656aa9e1','cf55af4f-6f13-40b8-8ac4-8ef9f3d0c140','SCAN'),(664,'fe4e3868-3697-40bc-ae0f-9780656aa9e1','e090cb88-5e7f-4023-af0f-0b9e21863d24','FORM');
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) NOT NULL,
  PRIMARY KEY (`orderId`,`recipientId`),
  KEY `ownerId` (`ownerId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `ProstheticOrderRecipient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
INSERT INTO `ProstheticOrderRecipient` VALUES (664,'0226bc43-b62b-4f3e-8246-e4fb73ae4a28','b268deab-1616-4c93-8eb0-0d9d60d5a2cf'),(664,'06d57180-983c-11ee-86e7-58a023cda0dc','6da705c7-2e8e-476b-af63-a98ce37120b7'),(664,'0b106085-a874-4785-83a0-f28eb5473492','b268deab-1616-4c93-8eb0-0d9d60d5a2cf'),(664,'0ec89083-772a-11ee-867e-58a023cda0dc','6da705c7-2e8e-476b-af63-a98ce37120b7'),(664,'133bf366-2526-4d75-9242-6e7caee5aa64','c4e61cbc-8053-4d5b-8aef-9a5def3229ea'),(664,'1e218460-1625-4cb2-b347-dcad66378660','e54862ac-483f-4776-967b-4f90b849a4a5'),(664,'223975e3-130e-4b67-8ab4-69e9e3adbfc8','584dad71-0252-4c8a-a9b4-bc17eae4eb58'),(664,'23a16fe0-ed03-4415-a9e6-882ce7bc94f3','b2600e32-7030-4e6b-a270-8b2cbccee7b7'),(664,'249e488c-5a44-41ef-8fc3-630cd1be0fb7','a9f86ae2-32af-4481-85e9-dfb308b189d9'),(664,'2a260279-f2f6-4f7c-8756-e8a27606b0b3','27738253-c98b-484b-bef6-ccf9ca5966b5'),(664,'2f5b2737-e56b-4716-8b81-b8f39386743d','ec4237a8-5baf-46b4-9e49-ab1b68950d8a'),(664,'331e8399-8fa1-408a-b55e-1adf0a2ef6c0','a9f86ae2-32af-4481-85e9-dfb308b189d9'),(664,'5197160e-6765-4f00-a914-1b83136e95ff','584dad71-0252-4c8a-a9b4-bc17eae4eb58'),(664,'52de723f-4bdd-4b2d-87a6-fb648e680fbb','c4e61cbc-8053-4d5b-8aef-9a5def3229ea'),(664,'54410525-60fc-4d0d-9655-9ea6638a6043','c4e61cbc-8053-4d5b-8aef-9a5def3229ea'),(664,'548a8b15-a19f-42cb-80ef-399c4e3a51ee','584dad71-0252-4c8a-a9b4-bc17eae4eb58'),(664,'64b9506d-1475-4965-b3d3-054a5a076a37','b268deab-1616-4c93-8eb0-0d9d60d5a2cf'),(664,'68450b97-4193-42f4-a818-4bca3fb50cca','e54862ac-483f-4776-967b-4f90b849a4a5'),(664,'6a27a984-b0e8-4a31-b556-c4234f6cefec','27738253-c98b-484b-bef6-ccf9ca5966b5'),(664,'719d069f-1c89-4cc2-a04d-982bb719d80a','b268deab-1616-4c93-8eb0-0d9d60d5a2cf'),(664,'73b64ad8-c002-4b00-8cb0-479d3d5e1a46','c4e61cbc-8053-4d5b-8aef-9a5def3229ea'),(664,'79d31a7b-5bca-11ee-9658-58a023cda0dc','6da705c7-2e8e-476b-af63-a98ce37120b7'),(664,'7bb41f92-9801-4a80-9db6-907964cacece','27738253-c98b-484b-bef6-ccf9ca5966b5'),(664,'8515ad34-77a4-41f6-a53a-5be823e2f13d','b268deab-1616-4c93-8eb0-0d9d60d5a2cf'),(664,'854d2595-c6e3-4d27-8fbd-55e7fc6c19e4','e54862ac-483f-4776-967b-4f90b849a4a5'),(664,'8585764e-6028-48b5-bf39-ddba86be173e','a9f86ae2-32af-4481-85e9-dfb308b189d9'),(664,'98f23fdc-6e7d-411a-a2b5-b74bf1ad5f3c','b268deab-1616-4c93-8eb0-0d9d60d5a2cf'),(664,'9ab7328d-44e3-46af-b634-75d45259e276','ec4237a8-5baf-46b4-9e49-ab1b68950d8a'),(664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','6da705c7-2e8e-476b-af63-a98ce37120b7'),(664,'a70ea958-6c46-11ee-bc7f-58a023cda0dc','6da705c7-2e8e-476b-af63-a98ce37120b7'),(664,'a91f29b5-c999-4d0b-90cf-4ff0df6707c8','a9f86ae2-32af-4481-85e9-dfb308b189d9'),(664,'a9d67f35-6b75-41ae-8fc0-04ebed5dcbc6','584dad71-0252-4c8a-a9b4-bc17eae4eb58'),(664,'b3fd7ab4-7c7c-487a-96e9-21275b318b80','e54862ac-483f-4776-967b-4f90b849a4a5'),(664,'b765206e-6542-11ef-b382-58a023cda0dc','e54862ac-483f-4776-967b-4f90b849a4a5'),(664,'bd06bb45-1ca4-4e1a-bd3b-f5da30b77316','b268deab-1616-4c93-8eb0-0d9d60d5a2cf'),(664,'bf6a5903-e77c-47d1-aa54-6dbca17c1938','b268deab-1616-4c93-8eb0-0d9d60d5a2cf'),(664,'c155f94e-e0aa-488a-af25-8ada7a6a5b8a','584dad71-0252-4c8a-a9b4-bc17eae4eb58'),(664,'c379ba7c-4e26-473d-a1bd-f12853d9c1a4','e54862ac-483f-4776-967b-4f90b849a4a5'),(664,'c7646a09-199d-41ff-9840-93f97fe9d1cb','584dad71-0252-4c8a-a9b4-bc17eae4eb58'),(664,'c8a9ae43-f4da-4f8b-b98a-5d4804c238bc','ec4237a8-5baf-46b4-9e49-ab1b68950d8a'),(664,'c94feabc-c456-485b-b538-c3a58bce9798','c4e61cbc-8053-4d5b-8aef-9a5def3229ea'),(664,'ce221fe3-3073-4ef0-aa97-eb8dc1eefb70','1e3e6e1b-ec29-44ee-a407-1526d6e66955'),(664,'ce9127f7-b01e-4e28-b330-8f397f2a043e','c4e61cbc-8053-4d5b-8aef-9a5def3229ea'),(664,'d219a550-45e6-4d34-9392-643202050e04','a9f86ae2-32af-4481-85e9-dfb308b189d9'),(664,'d23524b1-d35b-4946-a69e-a2e7ff1d121e','27738253-c98b-484b-bef6-ccf9ca5966b5'),(664,'e34746f8-98f4-11ee-ae49-58a023cda0dc','6da705c7-2e8e-476b-af63-a98ce37120b7'),(664,'e5931e17-9060-4f04-9eac-a9ebae07c42d','c4e61cbc-8053-4d5b-8aef-9a5def3229ea'),(664,'e811fdc8-4e79-4f7c-83bb-0fb3afe35b50','a9f86ae2-32af-4481-85e9-dfb308b189d9'),(664,'ea343662-ea36-42db-b63d-dd61bc999ce0','c4e61cbc-8053-4d5b-8aef-9a5def3229ea'),(664,'f472220d-d6e7-42a3-bcaf-a8834487cfd4','a9f86ae2-32af-4481-85e9-dfb308b189d9'),(664,'f4b76bbe-1f7d-4a48-9b89-a3a8b350b719','b268deab-1616-4c93-8eb0-0d9d60d5a2cf'),(664,'f515018f-7aed-4466-a056-f2b9bf180db3','ec4237a8-5baf-46b4-9e49-ab1b68950d8a'),(664,'fafb038b-651a-4236-89fc-fe854cd20c83','b268deab-1616-4c93-8eb0-0d9d60d5a2cf'),(664,'fe4e3868-3697-40bc-ae0f-9780656aa9e1','a9f86ae2-32af-4481-85e9-dfb308b189d9');
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticSheet` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `pdfFileId` (`pdfFileId`),
  CONSTRAINT `ProstheticSheet_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_3` FOREIGN KEY (`pdfFileId`) REFERENCES `File` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
INSERT INTO `ProstheticSheet` VALUES ('01a6e785-35e5-4627-be4d-4fe82dbd2698',664,'b3fd7ab4-7c7c-487a-96e9-21275b318b80','{\"v1\": {\"type\": 1, \"comment\": \"Patient Name Andrew Gilboy\\nPlease Fabricate screw-retained full contour zirconia crown for implant # 3.\\nImplant system Neodent Zi\\nZiBase Part # 135.256 \\nPlease call Dr.\\\\Noumbissi 240-417-4237 with any questions.\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN (Gilboy Andrew)\", \"subElements\": [{\"comment\": \"Patient Name Andrew Gilboy\\nPlease Fabricate screw-retained full contour zirconia crown for implant # 3.\\nImplant system Neodent Zi\\nZiBase Part # 135.256 \\nPlease call Dr.\\\\Noumbissi 240-417-4237 with any questions.\", \"refImplant\": \"Neodent Zi Ceramic Implant\", \"selectedTeeth\": [16], \"prostheticMaterial\": 6, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"B3\"}], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"B3\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 1, \"comment\": \"Patient Name Andrew Gilboy\\nPlease Fabricate screw-retained full contour zirconia crown for implant # 3.\\nImplant system Neodent Zi\\nZiBase Part # 135.256 \\nPlease call Dr.\\\\Noumbissi 240-417-4237 with any questions.\", \"subType\": 0, \"language\": \"en_US\", \"refImplant\": \"Neodent Zi Ceramic Implant\", \"sheetTitle\": \"IMPLANT CROWN (Gilboy Andrew)\", \"refScanBody\": \"\", \"specificTint\": \"B3\", \"brandScanBody\": \"\", \"selectedTeeth\": [16], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','fbef9cf1-1cb4-49e9-88af-626767272b04','2022-11-22 18:48:21.000',NULL,'2022-11-22 18:48:21.000','2023-05-17 17:16:40.652',NULL),('06d5cb5a-983c-11ee-86e7-58a023cda0dc',664,'06d57180-983c-11ee-86e7-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"Patient Name; Scott, Alina\\nThis is a request for fabrication of implant placement surgical guide for #7 and #8. \\nImplant System to be used is SDS 2.0 two piece ceramic implant.\\nCBCT will be sent to you via email using wetranfer.com originating from drsammy@milesofsmilesdental.net\\nThank you\\nDr. Noumbissi\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            12,\n            11\n        ],\n        \"sheetTitle\": \"Surgical Guide #7 and #8\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n','acb9bb4d-983c-11ee-86e7-58a023cda0dc','2023-12-11 10:41:13.338',NULL,'2023-12-11 10:48:05.838','2023-12-11 15:48:06.173',NULL),('08a55ee1-a70a-4c69-80ce-18bde6ba9c78',664,'1813dac1-af6a-4e4c-8f60-2564d6ebab92','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"Carol Hicks (IMPLANT CROWN)\", \"subElements\": [{\"comment\": \"Please fabricate screw retain crown on implant. The implant system is Neodent Zirconia .\\nYou will need to use either Zi base or Zi base C abutment.\\nZi base part #:135.256 from Neodent/Straumann. Please Call Dr Noumbissi on his mobile at 240-417-4237 before starting work.\\nPlease call the office at (301)588-0768 if you have any further questions.\", \"refImplant\": \"Neodent Zi Ceramic Implant\", \"selectedTeeth\": [], \"prostheticMaterial\": 6, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"B1\"}], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"B1\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 0, \"language\": \"en_US\", \"refImplant\": \"Neodent Zi Ceramic Implant\", \"sheetTitle\": \"Carol Hicks (IMPLANT CROWN)\", \"refScanBody\": \"\", \"specificTint\": \"B1\", \"brandScanBody\": \"\", \"selectedTeeth\": [], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','77c6f7c4-1f2a-4d74-a31c-6f1c54373267','2022-11-18 20:17:20.000','2022-11-22 18:42:48.000','2022-11-18 20:17:20.000','2023-05-17 17:16:40.652',NULL),('0c17b139-386c-4b6a-9a50-8a79867ee672',664,'bf6a5903-e77c-47d1-aa54-6dbca17c1938','{\"v1\": {\"type\": 0, \"comment\": \"Please fabricate crown #30/31 full contour zirconia\", \"subType\": 1, \"language\": \"en_GB\", \"sheetTitle\": \"CROWN\", \"selectedTeeth\": [46], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"A\", \"prostheticMaterial\": 2, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"Please fabricate crown #30/31 full contour zirconia\", \"subType\": 0, \"language\": \"en_GB\", \"sheetTitle\": \"CROWN\", \"specificTint\": \"A2\", \"selectedTeeth\": [46], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 1}}','36e74d3e-7662-45a5-8241-34501ec906e8','2022-06-22 15:54:55.000',NULL,'2022-06-22 20:40:59.000','2023-05-17 17:16:40.652','2022-06-22 20:40:59.000'),('0ec8b7d5-772a-11ee-867e-58a023cda0dc',664,'0ec89083-772a-11ee-867e-58a023cda0dc','{\n    \"v2\": {\n        \"brandScanBody\": \"Other\",\n        \"comment\": \"Please fabricate cementable crown on implant #8\\n1. The contact with #9 should be normal\\n2. Make #8 the exact size and shape to match #9 as it is \\n3. there will be a gap between #7 and #8 but this is intentional since the orthodontist is going to move # 7 mesially to contact #8; after ortho we will rescan and order a permanent crown.\\n4. Please send a digital wax-up for review before you produce the temporary crown.\\nThank you\\nDr. Noumbissi\\n\",\n        \"language\": \"en_US\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 14,\n        \"refImplant\": \"Swiss Dental Solutions One-piece \",\n        \"refScanBody\": \"Not Applicable\",\n        \"selectedTeeth\": [\n            11\n        ],\n        \"sheetTitle\": \"implant crown\",\n        \"specificTint\": \"A2\",\n        \"subType\": 1,\n        \"type\": 1,\n        \"usePrePreparation\": false\n    }\n}\n','cb769c4e-772a-11ee-867e-58a023cda0dc','2023-10-30 09:28:57.000',NULL,'2023-10-30 09:47:00.000','2023-10-30 13:47:02.794','2023-10-30 09:47:02.786'),('1ab08725-f8a5-11ed-807f-58a023cda0dc',664,'1ab03a36-f8a5-11ed-807f-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"nhhlkhl\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Other\",\n        \"type\": 12,\n        \"usePrePreparation\": true\n    }\n}\n',NULL,'2023-05-22 09:32:10.599','2023-05-22 09:33:25.114','2023-05-22 09:32:31.942','2023-05-22 13:33:25.116',NULL),('223975e3-130e-4b67-8ab4-69e9e3adbfc8',664,'223975e3-130e-4b67-8ab4-69e9e3adbfc8','{\"v1\": {\"type\": 0, \"comment\": \"Test test\", \"subType\": 2, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"selectedTeeth\": [11, 26], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 0, \"prostheticContactPoint\": 2}, \"v2\": {\"type\": 0, \"comment\": \"Test test\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"specificTint\": \"A2\", \"selectedTeeth\": [11, 26], \"usePrePreparation\": false, \"prostheticMaterial\": 0, \"prostheticContactPoint\": 0}}','00af650a-5d5c-42b6-af45-b746624924b3','2020-11-03 22:39:41.000',NULL,'2020-11-03 22:53:24.000','2023-05-17 17:16:40.652','2022-03-14 14:58:30.000'),('2a260279-f2f6-4f7c-8756-e8a27606b0b3',664,'2a260279-f2f6-4f7c-8756-e8a27606b0b3','{\"v1\": {\"type\": 0, \"comment\": \"Crown on Natural tooth Number 31\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"selectedTeeth\": [47], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 6, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"Crown on Natural tooth Number 31\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"specificTint\": \"A2\", \"selectedTeeth\": [47], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','9dc0f236-1455-4d5a-8b25-404e95fc9a37','2020-09-17 03:51:09.000',NULL,'2020-09-17 12:22:20.000','2023-05-17 17:16:40.652','2022-03-14 14:58:42.000'),('2b37fcf7-9abb-4bbc-bd50-709f46051c29',664,'75cfb105-378d-478e-a639-12e9b18c1d8a','{\"v1\": {\"type\": 0, \"comment\": \"This Crown is Ceramic Implant from Neodent .The name of the system is Neodent Zi.\\nPlease advise if you need us to send the abutment.\\nIf you have any questions please Call either the office at (301)588-0768 or Dr.Noumbissi at (240)417-4237.\\n\\nThank you \", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"Lindsey Karen CROWN\", \"selectedTeeth\": [14], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 6, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"This Crown is Ceramic Implant from Neodent .The name of the system is Neodent Zi.\\nPlease advise if you need us to send the abutment.\\nIf you have any questions please Call either the office at (301)588-0768 or Dr.Noumbissi at (240)417-4237.\\n\\nThank you \", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"Lindsey Karen CROWN\", \"specificTint\": \"A2\", \"selectedTeeth\": [14], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}',NULL,'2022-10-19 19:45:11.000','2022-10-19 19:55:15.000','2022-10-19 19:45:11.000','2023-05-17 17:16:40.652',NULL),('2e3072ac-23f1-4211-9c50-dd10ccf1953a',664,'660769ad-1b3a-4e07-ba2e-3a8721ccaf28','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN Taylor-Jolly\", \"subElements\": [{\"comment\": \"Please fabricate screw-retained crown on ceramic implant #14.\\nImplant Diameter is 4.3mm\\nThank you\", \"refImplant\": \"Neodent Zi Implant \", \"selectedTeeth\": [26], \"prostheticMaterial\": 2, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"A1\"}], \"prostheticStep\": 0, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 0}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 2, \"language\": \"en_US\", \"refImplant\": \"Neodent Zi Implant \", \"sheetTitle\": \"IMPLANT CROWN Taylor-Jolly\", \"refScanBody\": \"\", \"specificTint\": \"\", \"brandScanBody\": \"\", \"selectedTeeth\": [26], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 1}}','7b10fba4-5aee-4832-9158-2978a6c17e5d','2022-09-21 19:27:37.000','2022-09-21 19:31:12.000','2022-09-21 19:27:37.000','2023-05-17 17:16:40.652',NULL),('34230a15-9843-11ee-86e7-58a023cda0dc',664,'3422edcd-9843-11ee-86e7-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"Patient Name; Scott, Alina\\nThis is a request for fabrication of implant placement surgical guide for #7 and #8. \\nImplant System to be used is SDS 2.0 two piece ceramic implant.\\nCBCT will be sent to you via email using wetranfer.com originating from drsammy@milesofsmilesdental.net\\nThank you\\nDr. Noumbissi\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            12,\n            11\n        ],\n        \"sheetTitle\": \"Surgical Guide #7 and #8\",\n        \"type\": 12,\n        \"usePrePreparation\": true\n    }\n}\n',NULL,'2023-12-11 11:34:02.334','2023-12-11 11:38:49.006','2023-12-11 11:34:50.000','2023-12-11 16:38:49.008',NULL),('357d75ea-5fe1-49e2-ab0a-f82852b2dab3',664,'e811fdc8-4e79-4f7c-83bb-0fb3afe35b50','{\"v1\": {\"type\": 0, \"comment\": \"Please fabricate cementable crown for implant #30\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"Elisabeth Baxter CROWN\", \"selectedTeeth\": [46], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 6, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"Please fabricate cementable crown for implant #30\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"Elisabeth Baxter CROWN\", \"specificTint\": \"A2\", \"selectedTeeth\": [46], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','50ba84da-fbb3-4a82-ad28-44193c241742','2022-11-02 19:24:06.000',NULL,'2022-11-02 19:26:27.000','2023-05-17 17:16:40.652','2022-11-02 19:26:27.000'),('3861ad04-b22a-4052-8293-fdd29fe3c900',664,'854d2595-c6e3-4d27-8fbd-55e7fc6c19e4','{\"v1\": {\"type\": 7, \"comment\": \"Patient Name: PINEDA SINDY\\nPlease fabricate essix appliance to replsce teeth #7,8,9,10, Shade Dr.Noumbissi with any questions at 301-588-0768 or 240-417-4237 (M)\\nthsnk You\\n\", \"crochet\": 0, \"subType\": 5, \"language\": \"en_US\", \"sheetTitle\": \"Sindy Pined: REMOVABLE\", \"selectedTeeth\": [12, 11, 21, 22], \"chassisMaterial\": 0, \"removableArcade\": 1, \"generalTintElement\": \"\", \"prostheticMaterial\": 7, \"amovibleProstheticStep\": 5}, \"v2\": {\"type\": 7, \"comment\": \"Patient Name: PINEDA SINDY\\nPlease fabricate essix appliance to replsce teeth #7,8,9,10, Shade Dr.Noumbissi with any questions at 301-588-0768 or 240-417-4237 (M)\\nthsnk You\\n\", \"language\": \"en_US\", \"sheetTitle\": \"Sindy Pined: REMOVABLE\", \"specificTint\": \"\", \"selectedTeeth\": [12, 11, 21, 22], \"usePrePreparation\": false, \"prostheticMaterial\": 7, \"prostheticContactPoint\": 1}}','73e3f675-fef8-44e6-bc33-f21678a2af71','2022-10-03 21:53:22.000',NULL,'2022-10-03 21:53:22.000','2023-05-17 17:16:40.652',NULL),('3d16f716-87f1-43c2-b8a6-a5e0ed674944',664,'f515018f-7aed-4466-a056-f2b9bf180db3','{\"v1\": {\"type\": 0, \"comment\": \"Patient Name; Elisabeth Baxter\\n\\nPlease fabricate Full contour cementable zirconia crown for #30\\n\\nThank you\\n\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"Elizabeth Baxter CROWN\", \"selectedTeeth\": [46], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 6, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"Patient Name; Elisabeth Baxter\\n\\nPlease fabricate Full contour cementable zirconia crown for #30\\n\\nThank you\\n\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"Elizabeth Baxter CROWN\", \"specificTint\": \"A2\", \"selectedTeeth\": [46], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','32ef6002-3a1f-472f-ab27-d59782d15aad','2022-10-19 19:32:49.000',NULL,'2022-10-19 19:32:49.000','2023-05-17 17:16:40.652',NULL),('3e1045ee-983d-11ee-86e7-58a023cda0dc',664,'3e0ffdd1-983d-11ee-86e7-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"Patient Name; Scott, Alina\\nThis is a request for fabrication of implant placement surgical guide for #7 and #8. \\nImplant System to be used is SDS 2.0 two piece ceramic implant.\\nCBCT will be sent to you via email using wetranfer.com originating from drsammy@milesofsmilesdental.net\\nThank you\\nDr. Noumbissi\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            12,\n            11\n        ],\n        \"sheetTitle\": \"Surgical Guide #7 and #8\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-12-11 10:51:27.192','2023-12-11 10:53:00.899','2023-12-11 10:52:09.674','2023-12-11 15:53:00.902',NULL),('44ce23f9-94af-49c7-a55f-a7460fed453b',664,'fe4e3868-3697-40bc-ae0f-9780656aa9e1','{\"v1\": {\"type\": 1, \"comment\": \"Patient Name Andrew Gilboy\\nPlease Fabricate screw-retained full contour zirconia crown for implant # 3.\\nImplant system Neodent Zi\\nZiBase Part # 135.256 \\nPlease call Dr.\\\\Noumbissi 240-417-4237 with any questions.\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN (Andrew Gilboy)\", \"subElements\": [{\"comment\": \"Patient Name Andrew Gilboy\\nPlease Fabricate screw-retained full contour zirconia crown for implant # 3.\\nImplant system Neodent Zi\\nZiBase Part # 135.256 \\nPlease call Dr.\\\\Noumbissi 240-417-4237 with any questions.\", \"refImplant\": \"Neodent Zi\", \"selectedTeeth\": [16], \"prostheticMaterial\": 6, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"B3\"}], \"prostheticStep\": 6, \"prostheticModel\": 3, \"generalTintElement\": \"B3\", \"generalTintSupport\": \"B3\", \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 1, \"comment\": \"Patient Name Andrew Gilboy\\nPlease Fabricate screw-retained full contour zirconia crown for implant # 3.\\nImplant system Neodent Zi\\nZiBase Part # 135.256 \\nPlease call Dr.\\\\Noumbissi 240-417-4237 with any questions.\", \"subType\": 0, \"language\": \"en_US\", \"refImplant\": \"Neodent Zi\", \"sheetTitle\": \"IMPLANT CROWN (Andrew Gilboy)\", \"refScanBody\": \"\", \"specificTint\": \"B3\", \"brandScanBody\": \"\", \"selectedTeeth\": [16], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','e090cb88-5e7f-4023-af0f-0b9e21863d24','2022-11-18 21:06:52.000',NULL,'2022-11-18 21:06:52.000','2023-05-17 17:16:40.652',NULL),('450a1474-d10a-4801-aaae-fa08e6f8fc34',664,'f472220d-d6e7-42a3-bcaf-a8834487cfd4','{\"v1\": {\"type\": 0, \"comment\": \"Please fabricate Ceramic crowns\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"selectedTeeth\": [14, 16, 26], \"prostheticStep\": 6, \"prostheticModel\": 3, \"generalTintElement\": \"B2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 2, \"prostheticContactPoint\": 4}, \"v2\": {\"type\": 0, \"comment\": \"Please fabricate Ceramic crowns\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"specificTint\": \"B2\", \"selectedTeeth\": [14, 16, 26], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 2}}','8532f29a-bbac-4db3-af25-e87cb75618fc','2022-11-02 16:09:53.000',NULL,'2022-11-02 16:11:43.000','2023-05-17 17:16:40.652','2022-11-02 16:11:43.000'),('4542ccad-572d-11ee-a378-58a023cda0dc',664,'4542bde6-572d-11ee-a378-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"Fabricate with PEEK\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Temporary Mandibular FD\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-09-19 16:43:06.877','2023-09-19 16:45:16.251','2023-09-19 16:44:04.221','2023-09-19 20:45:16.254',NULL),('5197160e-6765-4f00-a914-1b83136e95ff',664,'5197160e-6765-4f00-a914-1b83136e95ff','{\"v1\": {\"type\": 0, \"comment\": \"Please fabricate full contour Zirconia crown for #30\\nThank you\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"selectedTeeth\": [46], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"B2\", \"generalTintSupport\": \"B\", \"prostheticMaterial\": 2, \"prostheticContactPoint\": 2}, \"v2\": {\"type\": 0, \"comment\": \"Please fabricate full contour Zirconia crown for #30\\nThank you\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"specificTint\": \"B2\", \"selectedTeeth\": [46], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 0}}','c6890662-f4e5-4556-85ae-1a5367397a93','2021-04-14 16:08:34.000',NULL,'2021-04-14 16:11:44.000','2023-05-17 17:16:40.652','2022-03-14 14:58:24.000'),('52b3b358-f8a5-11ed-807f-58a023cda0dc',664,'52b35b9a-f8a5-11ed-807f-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"kjugujhmf\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28,\n            38,\n            37,\n            36,\n            35,\n            34,\n            33,\n            32,\n            31,\n            41,\n            42,\n            43,\n            44,\n            45,\n            46,\n            47,\n            48\n        ],\n        \"sheetTitle\": \"Other\",\n        \"type\": 12,\n        \"usePrePreparation\": true\n    }\n}\n',NULL,'2023-05-22 09:33:53.125','2023-05-22 09:35:56.917','2023-05-22 09:34:05.915','2023-05-22 13:35:56.920',NULL),('548a8b15-a19f-42cb-80ef-399c4e3a51ee',664,'548a8b15-a19f-42cb-80ef-399c4e3a51ee','{\"v1\": {\"type\": 0, \"comment\": \"Crown on natural tooth number 31\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"selectedTeeth\": [47], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 6, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"Crown on natural tooth number 31\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"specificTint\": \"A2\", \"selectedTeeth\": [47], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','0e193ac6-c011-45df-8829-5c9742aad5b4','2020-09-17 03:46:56.000',NULL,'2020-11-30 02:24:32.000','2023-05-17 17:16:40.652','2022-03-14 14:58:39.000'),('588cde88-edb0-4618-beef-fbff29e3ab5f',664,'16e355a3-b14e-430a-923b-9a23341e2aa3','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 7, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN ANT CROWN(Carol,Burroughts)\", \"subElements\": [{\"comment\": \"Please fabricate screw retain crown on implant. The implant system is Neodent Zirconia .\\nYou will need to use either Zi base or Zi base C abutment.\\nZi base part #:135.256 from Neodent/Straumann. Please Call Dr Noumbissi on his mobile at 240-417-4237 before starting work.\\nPlease call the office at (301)588-0768 if you have any further questions.\", \"refImplant\": \"Neodent Zi\", \"selectedTeeth\": [25], \"prostheticMaterial\": 2, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"B1\"}], \"prostheticStep\": 0, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 0}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 2, \"language\": \"en_US\", \"refImplant\": \"Neodent Zi\", \"sheetTitle\": \"IMPLANT CROWN ANT CROWN(Carol,Burroughts)\", \"refScanBody\": \"\", \"specificTint\": \"\", \"brandScanBody\": \"\", \"selectedTeeth\": [25], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 1}}','228b24fc-bc5e-4533-a442-ce3fb1eda0c7','2022-11-16 21:16:38.000','2022-11-22 18:42:35.000','2022-11-16 21:16:38.000','2023-05-17 17:16:40.652',NULL),('5e1b4be5-dae9-4824-a246-e3e647f589cc',664,'9ab7328d-44e3-46af-b634-75d45259e276','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN (Test)\", \"subElements\": [{\"comment\": \"Test\", \"refImplant\": \"Zimmer\", \"selectedTeeth\": [21, 11], \"prostheticMaterial\": 2, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"\"}], \"prostheticStep\": 0, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 0}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 0, \"language\": \"en_US\", \"refImplant\": \"Zimmer\", \"sheetTitle\": \"IMPLANT CROWN (Test)\", \"refScanBody\": \"\", \"specificTint\": \"\", \"brandScanBody\": \"\", \"selectedTeeth\": [21, 11], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 1}}','87f24399-95c3-49ca-8a79-2a2ed392857a','2022-09-21 18:15:37.000',NULL,'2022-09-21 18:21:48.000','2023-05-17 17:16:40.652','2022-09-21 18:21:48.000'),('624adcfc-527c-4719-90fb-247f0b4fcd54',664,'f4b76bbe-1f7d-4a48-9b89-a3a8b350b719','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 2, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN\", \"subElements\": [{\"comment\": \"Patient Name is Montue, Solange\\n\\nPlease fabricate full contour cementable ziconia crowns on implants #4 and #28\\n\\nShade A2\\n\\nThank You\", \"refImplant\": \"Coho ZiBone\", \"selectedTeeth\": [15, 44], \"prostheticMaterial\": 6, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"A2\"}], \"prostheticStep\": 0, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 0}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 1, \"language\": \"en_US\", \"refImplant\": \"Coho ZiBone\", \"sheetTitle\": \"IMPLANT CROWN\", \"refScanBody\": \"\", \"specificTint\": \"\", \"brandScanBody\": \"\", \"selectedTeeth\": [15, 44], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','b04d457f-7b21-4521-bc90-01e2be5974b3','2022-08-22 15:28:32.000',NULL,'2022-08-22 15:28:32.000','2023-05-17 17:16:40.652',NULL),('63a404f1-410d-4678-b4e1-07de911fa9c6',664,'0226bc43-b62b-4f3e-8246-e4fb73ae4a28','{\"v1\": {\"type\": 0, \"comment\": \"Patient Name Carroll Gibbs\\nPlease fabricate full contour zirconia crown onteeth #27 and #28.\\nThank you\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"CROWNS CARROLL GIBBS\", \"selectedTeeth\": [43, 44], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"B1\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 6, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"Patient Name Carroll Gibbs\\nPlease fabricate full contour zirconia crown onteeth #27 and #28.\\nThank you\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"CROWNS CARROLL GIBBS\", \"specificTint\": \"B1\", \"selectedTeeth\": [43, 44], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','a2779544-f7de-49f8-8de9-40d9bb4b9a53','2022-09-12 20:41:52.000',NULL,'2022-09-12 20:46:12.000','2023-05-17 17:16:40.652','2022-09-12 20:46:12.000'),('683d9939-76fb-4ba8-a842-16334d84390b',664,'e2c9a4f6-7174-4966-b244-648673c0bd6f','{\"v1\": {\"type\": 0, \"comment\": \"\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"Elisabeth BaxterCROWN\", \"selectedTeeth\": [46], \"prostheticStep\": 0, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 6, \"prostheticContactPoint\": 0}, \"v2\": {\"type\": 0, \"comment\": \"\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"Elisabeth BaxterCROWN\", \"specificTint\": \"\", \"selectedTeeth\": [46], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','17ff75c9-f72d-423c-a5b9-633100c3b8e5','2022-11-02 18:55:46.000','2022-11-02 19:23:41.000','2022-11-02 18:55:46.000','2023-05-17 17:16:40.652',NULL),('6886ad9c-9c98-4cce-94de-7e659f386993',664,'e5931e17-9060-4f04-9eac-a9ebae07c42d','{\"v1\": {\"type\": 9, \"comment\": \"Please faabricate the following :\\n1- Essix Appliance to Replace tooth #9.Shade:A2\\n2- Surgical Guide for Implant  Placement #9 .Using Straumman Guided System.\\n\\nPlease call Dr.Noumbissi upon receipt of this case. \\n\\nThank you\", \"subType\": 4, \"language\": \"en_GB\", \"sheetTitle\": \"GUIDE\"}, \"v2\": {\"type\": 9, \"comment\": \"Please faabricate the following :\\n1- Essix Appliance to Replace tooth #9.Shade:A2\\n2- Surgical Guide for Implant  Placement #9 .Using Straumman Guided System.\\n\\nPlease call Dr.Noumbissi upon receipt of this case. \\n\\nThank you\", \"subType\": 4, \"language\": \"en_GB\", \"sheetTitle\": \"GUIDE\", \"usePrePreparation\": false}}','a86cf3f5-c1d7-45f7-998a-3a630b114693','2022-05-25 19:36:27.000','2022-05-26 22:11:09.000','2022-05-25 19:48:27.000','2023-05-17 17:16:40.652','2022-05-26 22:11:09.000'),('69562fb7-ee6b-496d-88d5-5ee32900792d',664,'68450b97-4193-42f4-a818-4bca3fb50cca','{\"v1\": {\"type\": 10, \"comment\": \"Essix Appliance for tooth #9. Shade A1\\nPlease return with Printed Model\", \"subType\": 2, \"language\": \"en_GB\", \"sheetTitle\": \"TRAY\"}, \"v2\": {\"type\": 10, \"comment\": \"Essix Appliance for tooth #9. Shade A1\\nPlease return with Printed Model\", \"subType\": 2, \"language\": \"en_GB\", \"sheetTitle\": \"TRAY\", \"usePrePreparation\": false}}','bf778da7-bcd4-47d5-8c14-ef8ea32c4781','2022-06-20 19:37:30.000',NULL,'2022-06-20 19:39:32.000','2023-05-17 17:16:40.652','2022-06-22 15:23:45.000'),('6a27a984-b0e8-4a31-b556-c4234f6cefec',664,'6a27a984-b0e8-4a31-b556-c4234f6cefec','{\"v1\": {\"type\": 0, \"comment\": \"Please find attached files scanned using Waow IOS \\nthsnk you\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"selectedTeeth\": [26], \"prostheticStep\": 6, \"prostheticModel\": 3, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 2, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"Please find attached files scanned using Waow IOS \\nthsnk you\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"specificTint\": \"A2\", \"selectedTeeth\": [26], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 1}}','9bad6bed-66cd-4aaf-9b18-74f56381c4d1','2020-07-01 18:12:33.000',NULL,'2020-07-01 18:18:10.000','2023-05-17 17:16:40.652','2022-03-14 14:58:40.000'),('6ea1afcf-360c-4d62-b8ca-846ed9ae3f94',664,'0b106085-a874-4785-83a0-f28eb5473492','{\"v1\": {\"type\": 1, \"comment\": \"Implant system is Neodent Zi ceramic implant Diameter 3.75mm\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN Andrew Gilboy\", \"subElements\": [{\"comment\": \"please send us a Crown for delivery on 21st September .\\nThank you\", \"refImplant\": \"Implant Crn #3\", \"selectedTeeth\": [16], \"prostheticMaterial\": 2, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"B3\"}], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 1, \"comment\": \"Implant system is Neodent Zi ceramic implant Diameter 3.75mm\", \"subType\": 0, \"language\": \"en_US\", \"refImplant\": \"Implant Crn #3\", \"sheetTitle\": \"IMPLANT CROWN Andrew Gilboy\", \"refScanBody\": \"\", \"specificTint\": \"\", \"brandScanBody\": \"\", \"selectedTeeth\": [16], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 1}}','8bda8472-2262-4cee-90a4-66ef69187724','2022-09-07 16:52:21.000',NULL,'2022-09-07 16:52:21.000','2023-05-17 17:16:40.652',NULL),('6f9ff1b2-e60b-48ec-a0d6-a1c9ec70f1bb',664,'c8a9ae43-f4da-4f8b-b98a-5d4804c238bc','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 7, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN(Carol,Burroughts)\", \"subElements\": [{\"comment\": \"Patient Name :Carol,Burroughts\\n\\nPlease fabricate screw retain crown on implant. The implant system is Neodent Zirconia .\\nYou will need to use either Zi base or Zi base C abutment.\\nZi base part #:135.256 from Neodent/Straumann\\nPlease call the office at (301)588-0768 if you have any further questions.\\n\\n\\n\", \"refImplant\": \"Neodent Zi\", \"selectedTeeth\": [25], \"prostheticMaterial\": 2, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"B1\"}], \"prostheticStep\": 0, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 0}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 2, \"language\": \"en_US\", \"refImplant\": \"Neodent Zi\", \"sheetTitle\": \"IMPLANT CROWN(Carol,Burroughts)\", \"refScanBody\": \"\", \"specificTint\": \"\", \"brandScanBody\": \"\", \"selectedTeeth\": [25], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 1}}','4a86d6f8-fbf5-4b40-89c8-3f159e5e0879','2022-10-31 17:39:12.000',NULL,'2022-10-31 17:39:12.000','2023-05-17 17:16:40.652',NULL),('79d343ac-5bca-11ee-9658-58a023cda0dc',664,'79d31a7b-5bca-11ee-9658-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"Please call after receipt of data so we can discuss.\\nDr. Noumbissi\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            38,\n            37,\n            36,\n            35,\n            34,\n            33,\n            32,\n            31,\n            41,\n            42,\n            43,\n            44,\n            45,\n            46,\n            47,\n            48\n        ],\n        \"sheetTitle\": \"Temp Mandibular Hybrid\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n','82c71f9b-5bca-11ee-9658-58a023cda0dc','2023-09-25 13:38:34.000',NULL,'2023-09-25 13:39:45.000','2023-09-25 17:39:47.489','2023-10-16 10:29:52.488'),('79d4a63f-31cb-4c94-a5ab-068a0ed1f0c1',664,'a91f29b5-c999-4d0b-90cf-4ff0df6707c8','{\"v1\": {\"type\": 0, \"comment\": \"Please fabricate cemmentable full contour zirconia cown for tooth #30\\nThank you\\nDr. Noumbissi\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"Elisabeth Baxter REDO CROWN\", \"selectedTeeth\": [46], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 6, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"Please fabricate cemmentable full contour zirconia cown for tooth #30\\nThank you\\nDr. Noumbissi\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"Elisabeth Baxter REDO CROWN\", \"specificTint\": \"A2\", \"selectedTeeth\": [46], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','1665ba5c-8084-4a22-84ab-72ef74043c9c','2022-11-09 17:08:42.000',NULL,'2022-11-09 17:12:19.000','2023-05-17 17:16:40.652','2022-11-14 17:08:11.000'),('7bb41f92-9801-4a80-9db6-907964cacece',664,'7bb41f92-9801-4a80-9db6-907964cacece','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 2, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN\", \"subElements\": [{\"comment\": \"Full contour cementable Zircoia crown\", \"refImplant\": \"Zibone Ceramic Implant\", \"selectedTeeth\": [46], \"prostheticMaterial\": 2, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"A2\"}], \"prostheticStep\": 0, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 1, \"language\": \"en_US\", \"refImplant\": \"Zibone Ceramic Implant\", \"sheetTitle\": \"IMPLANT CROWN\", \"refScanBody\": \"\", \"specificTint\": \"A2\", \"brandScanBody\": \"\", \"selectedTeeth\": [46], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 1}}','92bd4757-0c86-4e51-ab79-39f0a6427d18','2020-09-09 15:51:56.000',NULL,'2020-09-09 15:58:04.000','2023-05-17 17:16:40.652','2022-03-14 14:58:21.000'),('86681712-c2ab-4a55-a365-048755d33d4c',664,'64b9506d-1475-4965-b3d3-054a5a076a37','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN Taylor-Jolley\", \"subElements\": [{\"comment\": \"Please fabricate screw-retained crown on ceramic implant #14.\\nImplant Diameter is 4.3mm\\nThank you\", \"refImplant\": \"Neodent Zi Ceramic Implant\", \"selectedTeeth\": [26], \"prostheticMaterial\": 2, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"A1\"}], \"prostheticStep\": 0, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 0}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 0, \"language\": \"en_US\", \"refImplant\": \"Neodent Zi Ceramic Implant\", \"sheetTitle\": \"IMPLANT CROWN Taylor-Jolley\", \"refScanBody\": \"\", \"specificTint\": \"\", \"brandScanBody\": \"\", \"selectedTeeth\": [26], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 1}}','041aa495-530d-4b35-9123-837a50cb5169','2022-09-07 15:56:03.000',NULL,'2022-09-07 15:56:03.000','2023-05-17 17:16:40.652',NULL),('8b8e878e-5ff9-491b-8153-cf0899b04e65',664,'d219a550-45e6-4d34-9392-643202050e04','{\"v1\": {\"type\": 1, \"comment\": \"Please fabricate screw retain crown on implant. The implant system is Neodent Zirconia .\\nYou will need to use either Zi base or Zi base C abutment.\\nZi base part #:135.256 from Neodent/Straumann. Please Call Dr Noumbissi on his mobile at 240-417-4237 before starting work.\\nPlease call the office at (301)588-0768 if you have any further questions.\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN (Carol Hicks)\", \"subElements\": [{\"comment\": \"Please fabricate screw retain crown on implant. The implant system is Neodent Zirconia .\\nYou will need to use either Zi base or Zi base C abutment.\\nZi base part #:135.256 from Neodent/Straumann. Please Call Dr Noumbissi on his mobile at 240-417-4237 before starting work.\\nPlease call the office at (301)588-0768 if you have any further questions.\", \"refImplant\": \"Neodent Zi\", \"selectedTeeth\": [25], \"prostheticMaterial\": 6, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"B1\"}], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"B1\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 1, \"comment\": \"Please fabricate screw retain crown on implant. The implant system is Neodent Zirconia .\\nYou will need to use either Zi base or Zi base C abutment.\\nZi base part #:135.256 from Neodent/Straumann. Please Call Dr Noumbissi on his mobile at 240-417-4237 before starting work.\\nPlease call the office at (301)588-0768 if you have any further questions.\", \"subType\": 0, \"language\": \"en_US\", \"refImplant\": \"Neodent Zi\", \"sheetTitle\": \"IMPLANT CROWN (Carol Hicks)\", \"refScanBody\": \"\", \"specificTint\": \"B1\", \"brandScanBody\": \"\", \"selectedTeeth\": [25], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','d14252ac-1de7-4afa-a650-24dd6f3844fd','2022-11-18 20:28:23.000',NULL,'2022-11-18 20:28:23.000','2023-05-17 17:16:40.652',NULL),('8e32ba27-f8a4-11ed-807f-58a023cda0dc',664,'8e326dc6-f8a4-11ed-807f-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Other\",\n        \"type\": 12,\n        \"usePrePreparation\": true\n    }\n}\n',NULL,'2023-05-22 09:27:38.134','2023-05-22 09:30:07.468','2023-05-22 09:28:36.237','2023-05-22 13:30:07.471',NULL),('9ab1d651-09c3-4b32-bd66-6641ab9adc23',664,'54410525-60fc-4d0d-9655-9ea6638a6043','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 2, \"language\": \"en_GB\", \"sheetTitle\": \"IMPLANT CROWN\", \"subElements\": [{\"comment\": \"Please fabricate full contour cementable zirconia crown on Implant. Please return for delivery and cementsation. Shade A2\", \"refImplant\": \"Coho Zibone Ceramic\", \"selectedTeeth\": [47], \"prostheticMaterial\": 6, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"A2\"}], \"prostheticStep\": 0, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 0}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 1, \"language\": \"en_GB\", \"refImplant\": \"Coho Zibone Ceramic\", \"sheetTitle\": \"IMPLANT CROWN\", \"refScanBody\": \"\", \"specificTint\": \"\", \"brandScanBody\": \"\", \"selectedTeeth\": [47], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','c0de44a6-6316-4997-9cb5-d1b77defc44c','2022-03-28 16:56:18.000',NULL,'2022-03-28 16:58:05.000','2023-05-17 17:16:40.652','2022-04-01 15:51:38.000'),('9d7d152a-987f-4b52-958a-94a2649256f4',664,'2f5b2737-e56b-4716-8b81-b8f39386743d','{\"v1\": {\"type\": 0, \"comment\": \"TEST\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"CROWN (TEST)\", \"selectedTeeth\": [11, 21], \"prostheticStep\": 4, \"prostheticModel\": 3, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 2, \"prostheticContactPoint\": 2}, \"v2\": {\"type\": 0, \"comment\": \"TEST\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"CROWN (TEST)\", \"specificTint\": \"\", \"selectedTeeth\": [11, 21], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 0}}','be00d1bd-c78e-4b52-8426-ae28db017a78','2022-09-21 18:19:41.000','2022-09-21 18:22:58.000','2022-09-21 18:21:06.000','2023-05-17 17:16:40.652','2022-09-21 18:22:58.000'),('9df98eac-84ce-4d47-a54c-2b7e5cc0a61c',664,'a9d67f35-6b75-41ae-8fc0-04ebed5dcbc6','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 0, \"language\": \"fr_FR\", \"sheetTitle\": \"IMPLANT CROWN\", \"subElements\": [{\"comment\": \"Please Fabricate full contour cementable Zirconia crown for implant 31\", \"refImplant\": \"ZIbone One Piece\", \"selectedTeeth\": [47], \"prostheticMaterial\": 2, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"A2\"}], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 2, \"language\": \"fr_FR\", \"refImplant\": \"ZIbone One Piece\", \"sheetTitle\": \"IMPLANT CROWN\", \"refScanBody\": \"\", \"specificTint\": \"\", \"brandScanBody\": \"\", \"selectedTeeth\": [47], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 1}}','4569d449-c0a3-4229-9f9d-9d173955cbd7','2022-03-21 15:44:16.000',NULL,'2022-03-24 16:48:35.000','2023-05-17 17:16:40.652','2022-03-24 16:48:35.000'),('a0bab17c-7727-11ee-867e-58a023cda0dc',664,'a0ba4ef3-7727-11ee-867e-58a023cda0dc','{\n    \"v2\": {\n        \"brandScanBody\": \"Other\",\n        \"comment\": \"Please fabricate cementble full contour zirconia crowns for teeth #18,19,20,30 and #31\\n\",\n        \"language\": \"en_US\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 6,\n        \"refImplant\": \"Coho Zibone One pIece zirconia\",\n        \"refScanBody\": \"Not applicable\",\n        \"selectedTeeth\": [\n            37,\n            36,\n            35,\n            46,\n            47\n        ],\n        \"sheetTitle\": \"implant crown\",\n        \"specificTint\": \"A2\",\n        \"subType\": 1,\n        \"type\": 1,\n        \"usePrePreparation\": false\n    }\n}\n','273de692-7728-11ee-867e-58a023cda0dc','2023-10-30 09:18:28.000',NULL,'2023-10-30 09:28:05.000','2023-10-30 13:28:06.729','2023-10-30 09:28:06.714'),('a159148a-f8a5-11ed-807f-58a023cda0dc',664,'a158bf26-f8a5-11ed-807f-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"jbhk\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28,\n            38,\n            37,\n            36,\n            35,\n            34,\n            33,\n            32,\n            31,\n            41,\n            42,\n            43,\n            44,\n            45,\n            46,\n            47,\n            48\n        ],\n        \"sheetTitle\": \"Other\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-05-22 09:36:06.749',NULL,'2023-05-22 09:36:17.861','2023-05-22 13:36:17.864',NULL),('a5b0bf19-96ef-11ef-8234-58a023cda0dc',664,'a5b0637e-96ef-11ef-8234-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"Please make digital diagnostic wax up for teeth 7 and 10. Please call Dr. Noumbissi at 240-417-4237 before starting work.\\nThank you\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            12,\n            11,\n            21,\n            22\n        ],\n        \"sheetTitle\": \"Diagnostic Wax up\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2024-10-30 14:43:14.714','2024-10-31 08:15:05.333','2024-10-30 14:49:09.295','2024-10-31 12:15:05.336',NULL),('a70ebfcb-6c46-11ee-bc7f-58a023cda0dc',664,'a70ea958-6c46-11ee-bc7f-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"Please fabricate surfical guide for implants Maxilla Nad Mandible.\\nSystem used is SDS ceramic implant. Need guide for first two drills.\\nPlease call Dr. Noumbissi before you start work.\\nThank you\\nps. CBCT data to be sent separately via email from drsammy@milesofsmilesdental.net to Mr. Daniel Cho\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            24,\n            25,\n            26,\n            27,\n            36,\n            35\n        ],\n        \"sheetTitle\": \"Max and Mandible Surgical Guide\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n','389a8857-6c47-11ee-bc7f-58a023cda0dc','2023-10-16 13:05:54.000',NULL,'2023-10-16 13:12:47.000','2023-10-16 17:12:49.472','2023-10-16 13:12:49.462'),('a7fc807d-055a-40d0-b056-3199e0b53e33',664,'ea343662-ea36-42db-b63d-dd61bc999ce0','{\"v1\": {\"type\": 5, \"comment\": \"\", \"language\": \"en_GB\", \"sheetTitle\": \"IMPLANT BRIDGE\", \"subElements\": [{\"comment\": \"Please allow me to confirm shade when I return to the office tomorrow\", \"refImplant\": \"Straumann Pure Implants\", \"ponticSubType\": 0, \"selectedTeeth\": [46, 43, 41, 36, 33], \"dentalBridgeType\": 4, \"prostheticMaterial\": 6, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"A2\"}], \"prostheticStep\": 0, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 0}, \"v2\": {\"type\": 5, \"comment\": \"\", \"subType\": 2, \"language\": \"en_GB\", \"refImplant\": \"Straumann Pure Implants\", \"sheetTitle\": \"IMPLANT BRIDGE\", \"refScanBody\": \"\", \"specificTint\": \"\", \"brandScanBody\": \"\", \"selectedTeeth\": [46, 43, 41, 36, 33], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','c21da88f-3f6d-4a2f-9651-4074d522cb15','2022-03-24 16:42:36.000',NULL,'2022-03-24 16:42:36.000','2023-05-17 17:16:40.652',NULL),('aead653e-e6ea-4fe4-89d4-8d8a33cd086f',664,'bd06bb45-1ca4-4e1a-bd3b-f5da30b77316','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN Karen Lindsay\", \"subElements\": [{\"comment\": \"This Crown is Ceramic Implant from Neodent .The name of the system is Neodent Zi.\\nPlease advise if you need us to send the abutment.\\nIf you have any questions please Call either the office at (301)588-0768 or Dr.Noumbissi at (240)417-4237.\\n\\nThank you \\n\", \"refImplant\": \"Neodent Zi\", \"selectedTeeth\": [23], \"prostheticMaterial\": 6, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"A2\"}], \"prostheticStep\": 0, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 0}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 0, \"language\": \"en_US\", \"refImplant\": \"Neodent Zi\", \"sheetTitle\": \"IMPLANT CROWN Karen Lindsay\", \"refScanBody\": \"\", \"specificTint\": \"\", \"brandScanBody\": \"\", \"selectedTeeth\": [23], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','088dc1b3-7eb5-464b-a7c2-b50922838a77','2022-08-03 16:28:11.000',NULL,'2022-08-03 16:33:11.000','2023-05-17 17:16:40.652','2022-08-03 16:33:11.000'),('b5171ee2-b939-4109-a87b-70989726243c',664,'e5931e17-9060-4f04-9eac-a9ebae07c42d','{\"v1\": {\"type\": 12, \"comment\": \"Please faabricate the following :\\n1- Essix Appliance to Replace tooth #9.Shade:A2\\n2- Surgical Guide for Implant  Placement #9 .Using Straumman Guided System.\\n\\nPlease call Dr.Noumbissi upon receipt of this case. \\n\\nThank you\", \"language\": \"en_GB\", \"sheetTitle\": \"OTHER PROSTHETIC SHEET\"}, \"v2\": {\"type\": 12, \"comment\": \"Please faabricate the following :\\n1- Essix Appliance to Replace tooth #9.Shade:A2\\n2- Surgical Guide for Implant  Placement #9 .Using Straumman Guided System.\\n\\nPlease call Dr.Noumbissi upon receipt of this case. \\n\\nThank you\", \"language\": \"en_GB\", \"sheetTitle\": \"OTHER PROSTHETIC SHEET\", \"usePrePreparation\": false}}','4dbdd202-f89f-4e3b-b032-0f2780465410','2022-05-25 19:30:59.000','2022-05-26 22:11:07.000','2022-05-25 19:30:59.000','2023-05-17 17:16:40.652','2022-05-26 22:11:07.000'),('b765688d-6542-11ef-b382-58a023cda0dc',664,'b765206e-6542-11ef-b382-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"Positions 8,9 and 10\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            11,\n            21,\n            22\n        ],\n        \"sheetTitle\": \"Ant Maxillary Surg Guide\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n','d7d428c8-6542-11ef-b382-58a023cda0dc','2024-08-28 09:36:53.000',NULL,'2024-08-28 09:38:45.000','2024-08-28 13:38:47.257','2024-08-28 09:38:47.246'),('b7a1e186-adf7-4fa1-aa28-87760d0ee57f',664,'98f23fdc-6e7d-411a-a2b5-b74bf1ad5f3c','{\"v1\": {\"type\": 0, \"comment\": \"Please fabricate full contour zirconia crown at #14.\\nPatient Name: Charlotte Sadel\\nThank you\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"selectedTeeth\": [26], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"C2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 6, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"Please fabricate full contour zirconia crown at #14.\\nPatient Name: Charlotte Sadel\\nThank you\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"specificTint\": \"C2\", \"selectedTeeth\": [26], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','188b2bd0-af23-438c-b1c2-d75a6ce28b1c','2022-06-22 20:43:31.000',NULL,'2022-06-22 20:45:40.000','2023-05-17 17:16:40.652','2022-06-22 20:45:40.000'),('bb86fab4-0ccf-4f94-abed-fa94e9bee696',664,'52de723f-4bdd-4b2d-87a6-fb648e680fbb','{\"v1\": {\"type\": 1, \"comment\": \"This Crown is Ceramic Implant from Neodent .The name of the system is Neodent Zi.\\nPlease advise if you need us to send the abutment.\\nIf you have any questions please Call either the office at (301)588-0768 or Dr.Noumbissi at (240)417-4237.\\n\\nThank you \", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"Karen Lindsey: IMPLANT CROWN#6\", \"subElements\": [{\"comment\": \"This Crown is Ceramic Implant from Neodent .The name of the system is Neodent Zi.\\nPlease advise if you need us to send the abutment.\\nIf you have any questions please Call either the office at (301)588-0768 or Dr.Noumbissi at (240)417-4237.\\n\\nThank you \", \"refImplant\": \"Neodent Zi\", \"selectedTeeth\": [14], \"prostheticMaterial\": 10, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"A2\"}], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 1, \"comment\": \"This Crown is Ceramic Implant from Neodent .The name of the system is Neodent Zi.\\nPlease advise if you need us to send the abutment.\\nIf you have any questions please Call either the office at (301)588-0768 or Dr.Noumbissi at (240)417-4237.\\n\\nThank you \", \"subType\": 0, \"language\": \"en_US\", \"refImplant\": \"Neodent Zi\", \"sheetTitle\": \"Karen Lindsey: IMPLANT CROWN#6\", \"refScanBody\": \"\", \"specificTint\": \"A2\", \"brandScanBody\": \"\", \"selectedTeeth\": [14], \"usePrePreparation\": false, \"prostheticMaterial\": 10, \"prostheticContactPoint\": 1}}','62f54f6a-ef8d-42ba-8d34-1edc178619aa','2022-10-19 19:58:09.000',NULL,'2022-10-19 19:58:09.000','2023-05-17 17:16:40.652',NULL),('bcd103d4-b852-4379-ba16-0e734bc0d494',664,'fafb038b-651a-4236-89fc-fe854cd20c83','{\"v1\": {\"type\": 0, \"comment\": \"Please fabricate full contour zirconia cementable crowns for implants # 4 and #30\\nPatient Name:Solange Montue\\nShade C4\\nThank you\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"CROWN Solange Montue\", \"selectedTeeth\": [15, 45], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"C4\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 2, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"Please fabricate full contour zirconia cementable crowns for implants # 4 and #30\\nPatient Name:Solange Montue\\nShade C4\\nThank you\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"CROWN Solange Montue\", \"specificTint\": \"C4\", \"selectedTeeth\": [15, 45], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 1}}','aa4e5c15-e939-46a6-a75e-c5b67cdbad7b','2022-08-01 16:48:57.000',NULL,'2022-08-01 16:55:38.000','2023-05-17 17:16:40.652','2022-08-01 16:55:38.000'),('c155f94e-e0aa-488a-af25-8ada7a6a5b8a',664,'c155f94e-e0aa-488a-af25-8ada7a6a5b8a','{\"v1\": {\"type\": 0, \"comment\": \"Please Fabricate Crown on tooth #31\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"selectedTeeth\": [47], \"prostheticStep\": 6, \"prostheticModel\": 3, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 6, \"prostheticContactPoint\": 0}, \"v2\": {\"type\": 0, \"comment\": \"Please Fabricate Crown on tooth #31\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"specificTint\": \"A2\", \"selectedTeeth\": [47], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','a4dcb2d6-d779-443d-9e2d-0845bb353b4e','2020-11-30 02:22:30.000',NULL,'2020-12-01 00:28:08.000','2023-05-17 17:16:40.652','2022-03-14 14:58:34.000'),('c73815e5-005b-4222-a416-d82de83bae44',664,'c94feabc-c456-485b-b538-c3a58bce9798','{\"v1\": {\"type\": 1, \"comment\": \"Please confirm receipt of this order\\nThank you\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN BIYOUNG ANDRE\", \"subElements\": [{\"comment\": \"ello Eric, this is a redo. I thnk you have the\\nmandibular jaw scan in your system. I redid all\\nthe impressions anyway but as I said in the text\\nthe IOS does not pick up the zirconia\\nabutments well. So I also did a conventional\\nimpression of the maxilla only. I am sending\\nyou by mail the following: 1. the crowns you\\nproduced before (8 and 9). The shade and\\ncharactization were perfect. 2. analogs X 2 3.\\nNew impressions Maxilla 4. New zirconia\\nabutments + screws X 2\", \"refImplant\": \"ZERAMEX XT\", \"selectedTeeth\": [], \"prostheticMaterial\": 2, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"C3\"}], \"prostheticStep\": 5, \"prostheticModel\": 0, \"generalTintElement\": \"C3\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 1, \"comment\": \"Please confirm receipt of this order\\nThank you\", \"subType\": 0, \"language\": \"en_US\", \"refImplant\": \"ZERAMEX XT\", \"sheetTitle\": \"IMPLANT CROWN BIYOUNG ANDRE\", \"refScanBody\": \"\", \"specificTint\": \"C3\", \"brandScanBody\": \"\", \"selectedTeeth\": [], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 1}}','1d1d42ef-8d24-471c-8afb-6c0256487d0c','2022-09-07 19:47:23.000',NULL,'2022-09-07 19:49:51.000','2023-05-17 17:16:40.652','2022-09-12 18:33:17.000'),('c7646a09-199d-41ff-9840-93f97fe9d1cb',664,'c7646a09-199d-41ff-9840-93f97fe9d1cb','{\"v1\": {\"type\": 0, \"comment\": \"Full Contour Zirconia Crown #30\\nThank you\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"selectedTeeth\": [46], \"prostheticStep\": 6, \"prostheticModel\": 3, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 6, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"Full Contour Zirconia Crown #30\\nThank you\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"specificTint\": \"A2\", \"selectedTeeth\": [46], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','b4beeaca-9172-4b30-9b6f-a0e4bd048140','2020-11-30 02:18:15.000',NULL,'2020-12-01 00:24:24.000','2023-05-17 17:16:40.652','2022-03-14 14:58:20.000'),('c95df3d8-e608-4dc3-956c-27b44dc82de2',664,'719d069f-1c89-4cc2-a04d-982bb719d80a','{\"v1\": {\"type\": 1, \"comment\": \"Please fabricate screw-retained crown on ceramic implant #14.\\nImplant Diameter is 4.3mm\\nThank you\", \"subType\": 7, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN[Taylor-jolley]\", \"subElements\": [{\"comment\": \"Please fabricate screw-retained crown on ceramic implant #14.\\nImplant Diameter is 4.3mm\\nThank you\", \"refImplant\": \"Neodent zi Ceramic Implant\", \"selectedTeeth\": [26], \"prostheticMaterial\": 2, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"A1\"}], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A1\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 1, \"comment\": \"Please fabricate screw-retained crown on ceramic implant #14.\\nImplant Diameter is 4.3mm\\nThank you\", \"subType\": 2, \"language\": \"en_US\", \"refImplant\": \"Neodent zi Ceramic Implant\", \"sheetTitle\": \"IMPLANT CROWN[Taylor-jolley]\", \"refScanBody\": \"\", \"specificTint\": \"A1\", \"brandScanBody\": \"\", \"selectedTeeth\": [26], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 1}}','3a824a4d-1071-47df-83b6-85274c6103ec','2022-09-21 19:31:28.000',NULL,'2022-09-21 19:31:28.000','2023-05-17 17:16:40.652',NULL),('ce221fe3-3073-4ef0-aa97-eb8dc1eefb70',664,'ce221fe3-3073-4ef0-aa97-eb8dc1eefb70','{\"v1\": {\"type\": 9, \"comment\": \"\", \"subType\": 2, \"language\": \"en_US\", \"sheetTitle\": \"GUIDE\"}, \"v2\": {\"type\": 9, \"comment\": \"\", \"subType\": 2, \"language\": \"en_US\", \"sheetTitle\": \"GUIDE\", \"usePrePreparation\": false}}','c838fee6-1af3-43e4-b1b7-b722af25e22d','2021-01-28 15:39:21.000',NULL,'2021-01-28 15:48:26.000','2023-05-17 17:16:40.652','2022-03-14 14:58:55.000'),('cf62626f-fa37-11ed-8f6c-58a023cda0dc',664,'cf62526a-fa37-11ed-8f6c-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"Maxilla and Mandible for Fabrication of Surgical Guides and temp prosthetics.\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28,\n            38,\n            37,\n            36,\n            35,\n            34,\n            33,\n            32,\n            31,\n            41,\n            42,\n            43,\n            44,\n            45,\n            46,\n            47,\n            48\n        ],\n        \"sheetTitle\": \"Other\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-05-24 09:34:09.878',NULL,'2023-05-24 09:35:12.783','2023-05-24 13:35:12.783',NULL),('d23524b1-d35b-4946-a69e-a2e7ff1d121e',664,'d23524b1-d35b-4946-a69e-a2e7ff1d121e','{\"v1\": {\"type\": 0, \"comment\": \"Full contour zirconia crown\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"selectedTeeth\": [46], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 2, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"Full contour zirconia crown\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"specificTint\": \"A2\", \"selectedTeeth\": [46], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 1}}','1574fe39-cb97-4341-97dd-0d8a2c9caaee','2020-09-09 17:34:58.000',NULL,'2020-09-17 12:22:35.000','2023-05-17 17:16:40.652','2022-03-14 14:58:21.000'),('d4300c5a-25eb-4983-a768-fbfcd54b6efc',664,'1e218460-1625-4cb2-b347-dcad66378660','{\"v1\": {\"type\": 1, \"comment\": \"Please fabricate screw retain crown on implant. The implant system is Neodent Zirconia .\\nYou will need to use either Zi base or Zi base C abutment.\\nZi base part #:135.256 from Neodent/Straumann. Please Call Dr Noumbissi on his mobile at 240-417-4237 before starting work.\\nPlease call the office at (301)588-0768 if you have any further questions.\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN (Carol Hicks)\", \"subElements\": [{\"comment\": \"Please fabricate screw retain crown on implant. The implant system is Neodent Zirconia .\\nYou will need to use either Zi base or Zi base C abutment.\\nZi base part #:135.256 from Neodent/Straumann. Please Call Dr Noumbissi on his mobile at 240-417-4237 before starting work.\\nPlease call the office at (301)588-0768 if you have any further questions.\", \"refImplant\": \"Neodent Zi Ceramic Implant\", \"selectedTeeth\": [], \"prostheticMaterial\": 6, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"B1\"}], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 1, \"comment\": \"Please fabricate screw retain crown on implant. The implant system is Neodent Zirconia .\\nYou will need to use either Zi base or Zi base C abutment.\\nZi base part #:135.256 from Neodent/Straumann. Please Call Dr Noumbissi on his mobile at 240-417-4237 before starting work.\\nPlease call the office at (301)588-0768 if you have any further questions.\", \"subType\": 0, \"language\": \"en_US\", \"refImplant\": \"Neodent Zi Ceramic Implant\", \"sheetTitle\": \"IMPLANT CROWN (Carol Hicks)\", \"refScanBody\": \"\", \"specificTint\": \"\", \"brandScanBody\": \"\", \"selectedTeeth\": [], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','fb88a068-9ecf-4df8-a63d-72081fd4e147','2022-11-22 18:43:19.000',NULL,'2022-11-22 18:43:19.000','2023-05-17 17:16:40.652',NULL),('e1061278-8bb2-43dc-851e-c878241d4bd1',664,'331e8399-8fa1-408a-b55e-1adf0a2ef6c0','{\"v1\": {\"type\": 0, \"comment\": \"Testing Number 2\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"Noumbissi V. CROWN\", \"selectedTeeth\": [47, 37, 33], \"prostheticStep\": 6, \"prostheticModel\": 3, \"generalTintElement\": \"B2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 2, \"prostheticContactPoint\": 4}, \"v2\": {\"type\": 0, \"comment\": \"Testing Number 2\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"Noumbissi V. CROWN\", \"specificTint\": \"B2\", \"selectedTeeth\": [47, 37, 33], \"usePrePreparation\": false, \"prostheticMaterial\": 2, \"prostheticContactPoint\": 2}}','8713dea0-3fef-4030-a61f-3076f107ca1f','2022-11-02 16:14:29.000',NULL,'2022-11-02 16:14:29.000','2023-05-17 17:16:40.652',NULL),('e12d3fa7-0986-4541-93b4-b44c4ff557d8',664,'73b64ad8-c002-4b00-8cb0-479d3d5e1a46','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 2, \"language\": \"en_GB\", \"sheetTitle\": \"IMPLANT CROWN\", \"subElements\": [{\"comment\": \"Please fabricate cementable full contour zirconia crown\", \"refImplant\": \"Z systems\", \"selectedTeeth\": [45], \"prostheticMaterial\": 6, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"A2\"}], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 1, \"language\": \"en_GB\", \"refImplant\": \"Z systems\", \"sheetTitle\": \"IMPLANT CROWN\", \"refScanBody\": \"\", \"specificTint\": \"A2\", \"brandScanBody\": \"\", \"selectedTeeth\": [45], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','c79bcc05-9134-4911-9d18-30ba07308e7c','2022-04-14 15:13:42.000',NULL,'2022-04-14 15:13:42.000','2023-05-17 17:16:40.652',NULL),('e347568e-98f4-11ee-ae49-58a023cda0dc',664,'e34746f8-98f4-11ee-ae49-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            12,\n            11\n        ],\n        \"sheetTitle\": \"Maxillary Surgical Guide-Duplicate Order\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n','f674002c-98f4-11ee-ae49-58a023cda0dc','2023-12-12 08:45:48.000',NULL,'2023-12-12 08:47:19.000','2023-12-12 13:47:21.947','2024-08-28 08:07:32.613'),('e7b764ca-57e3-4b43-9d58-eccca9c4b79c',664,'249e488c-5a44-41ef-8fc3-630cd1be0fb7','{\"v1\": {\"type\": 0, \"comment\": \"# 30 MARGIN TRACED FOR YOUR CONVENIENCE\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"Elisabeth Baxter CROWN\", \"selectedTeeth\": [46], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 6, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"# 30 MARGIN TRACED FOR YOUR CONVENIENCE\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"Elisabeth Baxter CROWN\", \"specificTint\": \"A2\", \"selectedTeeth\": [46], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','99db3193-ff76-4f3f-a7c2-aa110e6a5695','2022-11-02 19:36:01.000',NULL,'2022-11-02 19:37:36.000','2023-05-17 17:16:40.652','2022-11-02 19:37:36.000'),('ea5cb9ed-4d5a-458b-be0d-39c564774951',664,'133bf366-2526-4d75-9242-6e7caee5aa64','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 7, \"language\": \"en_US\", \"sheetTitle\": \"Biyoung Andre IMPLANT CROWN\", \"subElements\": [{\"comment\": \"Hello Eric, this is a redo. I thnk you have the mandibular jaw scan in your system. I redid all the impressions anyway but as I said in the text the IOS does not pick up the zirconia abutments well. So I also did a conventional impression of the maxilla only.\\nI am sending you by mail the following:\\n1. the crowns you produced before (8 and 9). The shade and charactization were perfect.\\n2. analogs X 2\\n3. New impressions Maxilla\\n4. New zirconia abutments + screws X 2\", \"refImplant\": \"Zeramex XT\", \"selectedTeeth\": [11, 21], \"prostheticMaterial\": 10, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"C3\"}, {\"comment\": \"\", \"refImplant\": \"\", \"selectedTeeth\": [], \"prostheticMaterial\": 0, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"\"}, {\"comment\": \"\", \"refImplant\": \"\", \"selectedTeeth\": [], \"prostheticMaterial\": 0, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"\"}, {\"comment\": \"\", \"refImplant\": \"\", \"selectedTeeth\": [], \"prostheticMaterial\": 0, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"\"}], \"prostheticStep\": 6, \"prostheticModel\": 1, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 2, \"language\": \"en_US\", \"refImplant\": \"Zeramex XT\", \"sheetTitle\": \"Biyoung Andre IMPLANT CROWN\", \"refScanBody\": \"\", \"specificTint\": \"\", \"brandScanBody\": \"\", \"selectedTeeth\": [11, 21], \"usePrePreparation\": false, \"prostheticMaterial\": 10, \"prostheticContactPoint\": 1}}','358f428e-90db-4934-b2f1-3ca9caee9125','2022-08-24 19:54:53.000',NULL,'2023-05-22 09:09:26.000','2023-06-14 15:05:05.631','2023-06-14 11:05:05.629'),('edc9737e-9842-11ee-86e7-58a023cda0dc',664,'edc95e90-9842-11ee-86e7-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"Patient Name; Scott, Alina\\nThis is a request for fabrication of implant placement surgical guide for #7 and #8. \\nImplant System to be used is SDS 2.0 two piece ceramic implant.\\nCBCT will be sent to you via email using wetranfer.com originating from drsammy@milesofsmilesdental.net\\nThank you\\nDr. Noumbissi\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            12,\n            11\n        ],\n        \"sheetTitle\": \"Surgical Guide #7 and #8\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-12-11 11:32:17.735','2023-12-11 11:33:48.238','2023-12-11 11:32:51.973','2023-12-11 16:33:48.240',NULL),('eed34ed4-572c-11ee-a378-58a023cda0dc',664,'eed2f9c6-572c-11ee-a378-58a023cda0dc','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"en_US\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Other\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-09-19 16:41:21.789','2023-09-19 16:42:31.287','2023-09-19 16:41:39.207','2023-09-19 20:42:31.291',NULL),('f2d39450-d146-4be8-80b2-1bf8f436dbae',664,'8585764e-6028-48b5-bf39-ddba86be173e','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"IMPLANT CROWN (Andrew Gilboy)\", \"subElements\": [{\"comment\": \"Patient Name Andrew Gilboy\\nPlease Fabricate screw-retained full contour zirconia crown for implant # 3.\\nImplant system Neodent Zi\\nZiBase Part # 135.256 \\nPlease call Dr.\\\\Noumbissi 240-417-4237 with any questions.\\n\", \"refImplant\": \"Neodent Zi Ceramic Implants\", \"selectedTeeth\": [16], \"prostheticMaterial\": 6, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"B3\"}], \"prostheticStep\": 0, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 0}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 0, \"language\": \"en_US\", \"refImplant\": \"Neodent Zi Ceramic Implants\", \"sheetTitle\": \"IMPLANT CROWN (Andrew Gilboy)\", \"refScanBody\": \"\", \"specificTint\": \"\", \"brandScanBody\": \"\", \"selectedTeeth\": [16], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','f06bc9ca-26d6-4759-bf98-4c270f5b51aa','2022-11-18 20:50:43.000',NULL,'2022-11-18 20:50:43.000','2023-05-17 17:16:40.652',NULL),('f970e8c8-ac70-446e-bff6-a2e0a0d28eed',664,'c379ba7c-4e26-473d-a1bd-f12853d9c1a4','{\"v1\": {\"type\": 10, \"comment\": \"Please print essix appliance for replacement of tooth #9. \\nThank you\\nDr. Sammy Noumbissi\", \"subType\": 7, \"language\": \"en_GB\", \"sheetTitle\": \"TRAY\"}, \"v2\": {\"type\": 10, \"comment\": \"Please print essix appliance for replacement of tooth #9. \\nThank you\\nDr. Sammy Noumbissi\", \"subType\": 6, \"language\": \"en_GB\", \"sheetTitle\": \"TRAY\", \"usePrePreparation\": false}}','3491d21a-ba4e-4c00-ac22-f8de5caf6202','2022-05-26 21:50:14.000',NULL,'2022-05-26 21:50:14.000','2023-05-17 17:16:40.652',NULL),('fb3a7a69-1327-42e2-9d5f-86bdf9f08d8e',664,'ce9127f7-b01e-4e28-b330-8f397f2a043e','{\"v1\": {\"type\": 1, \"comment\": \"\", \"subType\": 2, \"language\": \"en_GB\", \"sheetTitle\": \"IMPLANT CROWN\", \"subElements\": [{\"comment\": \"Please fabricate full contour zirconia cementable crown on implant 19\", \"refImplant\": \"Z Systems\", \"selectedTeeth\": [36], \"prostheticMaterial\": 6, \"specificTintSupport\": \"\", \"specificTintSubElement\": \"A2\"}], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 1, \"comment\": \"\", \"subType\": 1, \"language\": \"en_GB\", \"refImplant\": \"Z Systems\", \"sheetTitle\": \"IMPLANT CROWN\", \"refScanBody\": \"\", \"specificTint\": \"A2\", \"brandScanBody\": \"\", \"selectedTeeth\": [36], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','0bf7054d-6a4b-48e8-babb-234a4571adab','2022-04-14 15:10:14.000',NULL,'2022-04-14 15:13:00.000','2023-05-17 17:16:40.652','2022-04-27 16:32:33.000'),('ff8241f8-4317-462b-a267-5c9946e53702',664,'23a16fe0-ed03-4415-a9e6-882ce7bc94f3','{\"v1\": {\"type\": 0, \"comment\": \"\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"TEST envoi Commande\", \"selectedTeeth\": [16], \"prostheticStep\": 2, \"prostheticModel\": 0, \"generalTintElement\": \"\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 1, \"prostheticContactPoint\": 1}, \"v2\": {\"type\": 0, \"comment\": \"\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"TEST envoi Commande\", \"specificTint\": \"\", \"selectedTeeth\": [16], \"usePrePreparation\": false, \"prostheticMaterial\": 1, \"prostheticContactPoint\": 1}}','82645c6b-3b05-4920-acad-9d001cacb5ea','2022-11-21 16:45:26.000','2022-11-22 18:47:21.000','2022-11-21 16:46:19.000','2023-05-17 17:16:40.652','2022-11-22 18:47:21.000'),('ffb01513-4f2b-45e2-a63c-c3dc18a692aa',664,'8515ad34-77a4-41f6-a53a-5be823e2f13d','{\"v1\": {\"type\": 0, \"comment\": \"\", \"subType\": 1, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"selectedTeeth\": [24], \"prostheticStep\": 6, \"prostheticModel\": 0, \"generalTintElement\": \"A2\", \"generalTintSupport\": \"\", \"prostheticMaterial\": 6, \"prostheticContactPoint\": 3}, \"v2\": {\"type\": 0, \"comment\": \"\", \"subType\": 0, \"language\": \"en_US\", \"sheetTitle\": \"CROWN\", \"specificTint\": \"A2\", \"selectedTeeth\": [24], \"usePrePreparation\": false, \"prostheticMaterial\": 6, \"prostheticContactPoint\": 1}}','c6c988d8-32fa-4c6f-bbce-54db4f46c38b','2022-07-28 16:02:55.000',NULL,'2022-07-28 16:02:55.000','2023-05-17 17:16:40.652',NULL);
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `receivedMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`receivedMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ReceivedAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_2` FOREIGN KEY (`receivedMessageId`) REFERENCES `ReceivedMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
INSERT INTO `ReceivedAttachment` VALUES (664,'977c269d-6177-11eb-94ee-226cec7cb58a','977f03ab-6177-11eb-94ee-226cec7cb58a'),(664,'977c269d-6177-11eb-94ee-226cec7cb58a','97823a3d-6177-11eb-94ee-226cec7cb58a'),(664,'977c269d-6177-11eb-94ee-226cec7cb58a','97845a20-6177-11eb-94ee-226cec7cb58a'),(664,'977c269d-6177-11eb-94ee-226cec7cb58a','97875176-6177-11eb-94ee-226cec7cb58a'),(664,'977c269d-6177-11eb-94ee-226cec7cb58a','9788a356-6177-11eb-94ee-226cec7cb58a'),(664,'977c269d-6177-11eb-94ee-226cec7cb58a','9789d53a-6177-11eb-94ee-226cec7cb58a'),(664,'977c269d-6177-11eb-94ee-226cec7cb58a','978b0da3-6177-11eb-94ee-226cec7cb58a');
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT '0',
  `messageSubject` varchar(45) NOT NULL,
  `body` text,
  `fromId` mediumint unsigned NOT NULL,
  `originMessageId` varchar(36) DEFAULT NULL,
  `discussionId` varchar(36) NOT NULL,
  `readStatus` enum('READ','UNREAD') DEFAULT 'UNREAD',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `fromId` (`fromId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `ReceivedMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_2` FOREIGN KEY (`fromId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_3` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
INSERT INTO `ReceivedMessage` VALUES ('1bc61c7b-6545-11ef-ad7e-0050569a5229',664,1,'Answered in the web client','What\'s the patients name for this case please?\n',1051,'d4669b2b-3ede-412c-b099-08ffe5a56c7c','5a3ba252-0d94-4fae-b6e1-d4756a110f83','READ','2024-08-28 09:54:56.000',NULL,'2024-08-28 09:54:56.000','2024-08-28 14:02:18.079','2024-08-28 10:02:18.088'),('6f262f69-dd35-11ec-a752-9ec33d03e6dd',664,1,'Answered in the web client','Also we log our cases in with the patients name can we get that as well, and we should have it back in your office by June 6th if that due date will work for you. ',1051,NULL,'5a3ba252-0d94-4fae-b6e1-d4756a110f83','READ','2022-05-26 22:50:10.000',NULL,'2022-06-22 17:23:38.000','2022-06-22 21:23:40.000','2022-06-22 17:23:40.000'),('877e2f79-f0c3-11ec-a752-9ec33d03e6dd',664,1,'Answered in the web client','The case we just received does not have a patient name on it. Can we have the patients name please. \n',1051,NULL,'5a3ba252-0d94-4fae-b6e1-d4756a110f83','READ','2022-06-20 20:05:12.000',NULL,'2022-06-22 17:23:38.000','2022-06-22 21:23:39.000','2022-06-22 17:23:39.000'),('977c269d-6177-11eb-94ee-226cec7cb58a',664,1,'#','Order n° 1.15.1.1',664,NULL,'74df8c86-9348-43cd-bbaa-383903f28a54','READ','2021-01-28 15:46:21.000',NULL,'2021-01-28 15:46:20.000','2021-01-28 14:46:25.000','2021-01-28 15:46:25.000'),('a7680a73-dd32-11ec-a752-9ec33d03e6dd',664,1,'Answered in the web client','Do you have a shade?',1051,NULL,'5a3ba252-0d94-4fae-b6e1-d4756a110f83','READ','2022-05-26 22:30:16.000',NULL,'2022-06-22 17:23:38.000','2022-06-22 21:23:39.000','2022-06-22 17:23:39.000'),('d1d07e14-6545-11ef-ad7e-0050569a5229',664,1,'Answered in the web client','What\'s the patients name for this case. Thank you',1051,'1a32395f-b415-4a76-b056-4a1a8e91e32c','5a3ba252-0d94-4fae-b6e1-d4756a110f83','READ','2024-08-28 10:00:01.000',NULL,'2024-08-28 10:00:01.000','2024-08-28 14:02:18.071','2024-08-28 10:02:18.078');
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Scan` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL,
  `sessionId` varchar(36) NOT NULL,
  `type` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') NOT NULL,
  `label` enum('PRE_PREPARATION','SCAN','SCANBODY') NOT NULL DEFAULT 'SCAN',
  `validated` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('IN_PROGRESS','NONE') NOT NULL DEFAULT 'IN_PROGRESS',
  `displayId` mediumint unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  CONSTRAINT `Scan_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Scan_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
INSERT INTO `Scan` VALUES ('002f309b-3121-4441-b8a1-a959e2a6ed47',664,'ae7f89c9-26ec-4cee-b377-d5145e6c6aae','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-14 17:35:21.000',NULL,'2022-11-14 17:35:21.000','2022-11-14 23:05:14.000','2022-11-14 18:05:14.000'),('00462b4b-7b16-4a6c-aaef-5da516ac1f81',664,'21bbefd5-8dc0-4e41-91d8-718463ad469c','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-03 16:15:08.000',NULL,'2022-08-03 16:16:06.000','2022-08-03 20:16:09.000','2022-08-03 16:16:09.000'),('02523859-58d9-4417-a657-9de246f248ae',664,'ae7f89c9-26ec-4cee-b377-d5145e6c6aae','MAXILLAIRE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-14 18:06:38.000',NULL,'2022-11-14 18:12:08.000','2022-11-14 23:12:15.000','2022-11-14 18:12:15.000'),('030b7203-1aba-47e9-abe6-fdddeccc9c17',664,'ea664326-1e10-4280-80b6-f3d23573a862','MAXILLAIRE','SCAN',1,'IN_PROGRESS',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-07-07 21:12:44.000',NULL,'2020-07-07 21:12:44.000','2022-03-14 18:58:28.000','2022-03-14 14:58:28.000'),('041ad44a-6c35-11ee-bc7f-58a023cda0dc',664,'0a97fa8b-6c31-11ee-bc7f-58a023cda0dc','MANDIBULE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-16 11:02:25.000',NULL,'2023-10-16 13:05:08.000','2024-10-31 14:02:36.483','2024-10-31 10:02:36.483'),('056c711b-f9d5-4a04-93e2-9015a27c4b1b',664,'a59f40f9-2208-4d6a-b286-f64533d92e3c','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-01-18 21:08:43.000',NULL,'2021-01-18 21:27:56.000','2022-03-14 18:58:44.000','2022-03-14 14:58:44.000'),('0760cff5-4209-42a6-8b7f-d0a749485c14',664,'94dc9a16-b72c-4f6a-a520-ba83c28954c3','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-07 16:09:03.000',NULL,'2022-09-07 16:30:14.000','2022-09-07 20:30:20.000','2022-09-07 16:30:20.000'),('086f70fa-7847-4242-83f9-c70e10b8d13f',664,'324dac1a-95fa-44d5-b054-88f048931106','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-14 15:38:39.000','2022-03-14 15:40:03.000','2022-03-14 15:38:39.000','2022-03-14 14:40:03.000',NULL),('088e0b86-45b9-4da8-a5e2-291e2939c699',664,'bf823edb-92ee-4ee9-acd3-507d49bad781','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-09-09 15:30:56.000',NULL,'2022-08-22 15:00:38.000','2022-08-22 19:00:39.000','2022-08-22 15:00:39.000'),('09b06474-154e-4302-9e89-9d9e6fcb8cfa',664,'d7b86e87-0261-4bc1-8529-76e0bdd29195','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-24 16:32:21.000',NULL,'2022-08-24 16:33:58.000','2022-08-24 20:34:02.000','2022-08-24 16:34:02.000'),('0a1eb92c-734f-11ee-b011-58a023cda0dc',664,'07e5f91d-734b-11ee-b011-58a023cda0dc','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-25 11:56:20.000',NULL,'2023-10-25 11:59:30.000','2024-10-31 14:02:36.568','2024-10-31 10:02:36.568'),('0a8db60a-fa38-11ed-8f6c-58a023cda0dc',664,'cf61271a-fa37-11ed-8f6c-58a023cda0dc','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-05-24 09:36:52.000',NULL,'2023-05-24 09:52:05.000','2024-10-31 14:02:36.340','2024-10-31 10:02:36.340'),('0f570c2a-6540-11ef-b382-58a023cda0dc',664,'721e3ad7-6536-11ef-b382-58a023cda0dc','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2024-08-28 09:18:48.000',NULL,'2024-08-28 09:25:31.000','2024-10-31 14:02:37.510','2024-10-31 10:02:37.510'),('101a958b-c6e0-45d2-be43-01921415b27e',664,'8cd0c724-d3d0-4821-a88b-42b03ae4eb07','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-17 16:49:25.000',NULL,'2022-10-17 17:11:52.000','2022-10-17 21:12:02.000','2022-10-17 17:12:02.000'),('102e062c-07cd-49ca-b2d8-4050c1eb56ee',664,'13883510-ca59-4fdd-8bbd-216ef177542a','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-10-04 19:04:13.000',NULL,'2021-10-04 19:06:05.000','2022-03-14 18:59:11.000','2022-03-14 14:59:11.000'),('13a263f2-8a0a-409b-a3c1-f2ddb5f6a466',664,'48ff9245-20c5-4364-a092-18eafb8024d3','MORDU_POSTERIEUR_DROIT','SCAN',1,'IN_PROGRESS',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-09-16 19:08:14.000',NULL,'2020-09-16 19:08:14.000','2022-03-14 18:58:33.000','2022-03-14 14:58:33.000'),('1642c8fb-5963-4064-9b58-acef4374ce2b',664,'e930782a-e2db-43e8-9ff1-9feb64e20e4e','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-06 19:45:40.000',NULL,'2022-06-06 20:35:20.000','2022-06-07 00:35:24.000','2022-06-06 20:35:24.000'),('16467f55-9ff8-4ac0-9da0-934c7528037e',664,'7348646e-cf7a-460b-aba9-d56ad656689e','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-09-14 17:47:47.000','2021-09-14 17:47:58.000','2021-09-14 17:47:47.000','2021-09-14 21:47:58.000',NULL),('166050e3-a143-4229-91c1-836574a02325',664,'b9c2b952-8d0a-4eac-ad77-2acda79cff8c','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-17 18:20:06.000','2022-08-17 18:25:07.000','2022-08-17 18:20:06.000','2022-08-17 22:25:07.000',NULL),('1668eb37-0316-442c-84b1-a56de5604444',664,'21bbefd5-8dc0-4e41-91d8-718463ad469c','MANDIBULE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-03 17:24:24.000','2022-08-03 17:24:27.000','2022-08-03 17:24:24.000','2022-08-03 21:24:27.000',NULL),('17461a17-6c34-11ee-bc7f-58a023cda0dc',664,'0a97fa8b-6c31-11ee-bc7f-58a023cda0dc','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-16 10:55:47.000',NULL,'2023-10-16 13:05:08.000','2024-10-31 14:02:36.494','2024-10-31 10:02:36.494'),('1812f52e-13c3-4bf4-a82d-693c5a2e1186',664,'1d15e305-f110-4004-a35a-cf5ca5fa2600','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-09 15:44:59.000','2022-11-09 15:45:58.000','2022-11-09 15:44:59.000','2022-11-09 20:45:58.000',NULL),('18f2b293-9073-44fe-91a3-d166f9249cbc',664,'8cd0c724-d3d0-4821-a88b-42b03ae4eb07','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-17 17:03:07.000','2022-10-17 17:12:11.000','2022-10-17 17:04:18.000','2022-10-17 21:12:11.000','2022-10-17 17:12:11.000'),('19fe3d64-fac4-4182-90d9-fb19f29bc385',664,'2c19cd55-a36e-4dc7-8954-ea8a8eeacd16','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-01-18 17:43:25.000',NULL,'2021-01-18 17:51:05.000','2022-03-14 18:58:57.000','2022-03-14 14:58:57.000'),('1c8acfc2-fa3b-11ed-8f6c-58a023cda0dc',664,'cf61271a-fa37-11ed-8f6c-58a023cda0dc','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-05-24 09:58:50.000','2023-05-24 10:01:24.000','2023-05-24 10:00:18.000','2024-10-31 14:02:36.394','2024-10-31 10:02:36.394'),('1d1515dc-8da4-4b0c-83dc-d1599e5f76cf',664,'a59f40f9-2208-4d6a-b286-f64533d92e3c','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-01-18 21:28:15.000',NULL,'2021-01-18 21:35:59.000','2022-03-14 18:58:44.000','2022-03-14 14:58:44.000'),('1d68ce03-d68e-49cb-9d0b-9b1f51edadbb',664,'ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-31 17:11:49.000',NULL,'2022-10-31 17:15:20.000','2022-10-31 21:15:24.000','2022-10-31 17:15:24.000'),('1fad60ca-f3ea-48a3-b845-fcd52ee435b5',664,'0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-11-30 02:14:43.000',NULL,'2022-08-22 15:01:01.000','2022-08-22 19:01:03.000','2022-08-22 15:01:03.000'),('20f1e04b-48d2-4b9a-b29b-2a62332288fb',664,'4aaf107a-b8db-4d45-befa-36e801ebc654','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-09-13 21:29:20.000',NULL,'2021-09-13 21:30:59.000','2022-03-14 18:59:13.000','2022-03-14 14:59:13.000'),('210ee6b9-1960-43ea-a220-cfa20b762017',664,'aa5b4efd-a5ce-428d-b35f-dd2bc2c28910','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-09 13:47:16.000','2022-03-14 09:42:19.000','2021-04-09 13:49:59.000','2024-10-31 14:02:25.454','2024-10-31 10:02:25.454'),('21c82eed-acf4-4093-986f-a306c3e0c043',664,'585f84a0-017e-4b5a-9465-7947c2ada0b3','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-10-27 19:48:04.000',NULL,'2021-10-27 19:58:54.000','2022-03-14 18:58:50.000','2022-03-14 14:58:50.000'),('24f0faea-733f-4381-9032-e077896c8124',664,'324dac1a-95fa-44d5-b054-88f048931106','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-14 15:22:40.000','2022-03-14 15:34:11.000','2022-03-14 15:22:40.000','2022-03-14 14:34:11.000',NULL),('27b06da2-6761-4a82-809a-ed75c96448eb',664,'e930782a-e2db-43e8-9ff1-9feb64e20e4e','MANDIBULE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-06 20:10:53.000','2022-06-06 20:20:37.000','2022-06-06 20:10:53.000','2022-06-07 00:20:37.000',NULL),('27ffc744-9a52-49aa-a247-2801d6cd8ff9',664,'2c19cd55-a36e-4dc7-8954-ea8a8eeacd16','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-01-18 17:55:25.000',NULL,'2021-01-18 18:00:58.000','2022-03-14 18:58:56.000','2022-03-14 14:58:56.000'),('2b878881-6c32-11ee-bc7f-58a023cda0dc',664,'0a97fa8b-6c31-11ee-bc7f-58a023cda0dc','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-16 10:42:02.953','2023-10-16 10:55:21.980','2023-10-16 13:05:08.900','2023-10-16 17:05:08.900',NULL),('2c6eb2a3-6697-4912-9947-5c2b5f942eb8',664,'4d46a627-5949-4b2a-b4d6-c391f159485b','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-12 20:36:10.000',NULL,'2022-09-12 20:38:05.000','2022-09-13 00:38:14.000','2022-09-12 20:38:14.000'),('300a55b7-e679-4993-b375-e0a3fe68f61d',664,'a98f038e-a19a-47ad-af09-a22810e9d19c','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-14 15:19:43.000',NULL,'2022-08-22 14:56:18.000','2022-08-22 18:56:20.000','2022-08-22 14:56:20.000'),('30be6697-331a-4e7d-8bba-b11fc9ec90b9',664,'aa5b4efd-a5ce-428d-b35f-dd2bc2c28910','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-09 19:44:17.000',NULL,'2021-04-09 19:47:07.000','2022-03-14 18:58:37.000','2022-03-14 14:58:37.000'),('30fee8be-9838-11ee-86e7-58a023cda0dc',664,'bf16aee0-9837-11ee-86e7-58a023cda0dc','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-12-11 10:16:00.000',NULL,'2023-12-11 10:40:41.000','2024-10-31 14:02:37.476','2024-10-31 10:02:37.476'),('316dc371-d779-45ec-913c-3647da5917c2',664,'21bbefd5-8dc0-4e41-91d8-718463ad469c','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-03 16:16:15.000',NULL,'2022-08-03 16:17:26.000','2022-08-03 20:17:30.000','2022-08-03 16:17:30.000'),('3241a487-3527-47d6-93c9-bad3ce6f6d24',664,'ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-31 17:18:57.000',NULL,'2022-10-31 17:18:57.000','2022-10-31 21:19:02.000','2022-10-31 17:19:02.000'),('32cd6a11-1a4c-4c67-b343-7b942dfd1e29',664,'324dac1a-95fa-44d5-b054-88f048931106','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-14 15:34:16.000','2022-03-14 15:38:32.000','2022-03-14 15:34:16.000','2022-03-14 14:38:32.000',NULL),('32d1a7b1-a16c-4d8f-9429-3f4f4d8c31db',664,'8cd0c724-d3d0-4821-a88b-42b03ae4eb07','MANDIBULE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-17 17:08:49.000','2022-10-17 17:08:59.000','2022-10-17 17:08:49.000','2022-10-17 21:08:59.000',NULL),('33332418-f712-49fd-833e-f2b6ad37b61e',664,'540d878b-7415-4498-8c6c-01875eec35f8','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-22 16:34:42.000',NULL,'2022-06-22 16:39:40.000','2022-06-22 20:39:46.000','2022-06-22 16:39:46.000'),('3492aefd-f931-40f6-ba3c-189739df6566',664,'e98b0c01-9e79-49e0-9ab8-0d6f432bf80d','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-01 15:24:15.000','2022-08-01 15:24:19.000','2022-08-01 15:24:15.000','2022-08-01 19:24:19.000',NULL),('34ec8b9f-9839-11ee-86e7-58a023cda0dc',664,'bf16aee0-9837-11ee-86e7-58a023cda0dc','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-12-11 10:23:16.000',NULL,'2023-12-11 10:40:41.000','2024-10-31 14:02:37.487','2024-10-31 10:02:37.487'),('3558dd42-4c4f-44fb-9e18-6c3609025ffc',664,'4d46a627-5949-4b2a-b4d6-c391f159485b','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-12 20:24:12.000',NULL,'2022-09-12 20:27:04.000','2022-09-13 00:27:08.000','2022-09-12 20:27:08.000'),('36fb3556-a0a4-48d9-b025-c100c3f31b8a',664,'9a395a3e-4872-409e-922b-4bb58053d8a5','MANDIBULE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-21 15:32:34.000','2022-03-21 15:32:37.000','2022-03-21 15:32:34.000','2022-03-21 19:32:37.000',NULL),('39c9ba47-6b25-4333-a5cf-b8988930cdd8',664,'48ff9245-20c5-4364-a092-18eafb8024d3','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-09-16 18:56:07.000',NULL,'2020-09-16 18:56:07.000','2022-03-14 18:58:33.000','2022-03-14 14:58:33.000'),('3afaae5b-fc7f-46be-b019-7206b27b05a8',664,'9f4fa7cb-81a3-460e-b189-ba76eb8cee15','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-30 17:03:17.000',NULL,'2022-03-30 17:13:12.000','2022-03-30 21:13:29.000','2022-03-30 17:13:29.000'),('3b924f2a-18f4-4ed4-8e4e-efb6a1b36439',664,'e930782a-e2db-43e8-9ff1-9feb64e20e4e','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-06 20:39:21.000',NULL,'2022-06-06 20:43:59.000','2022-06-07 00:44:03.000','2022-06-06 20:44:03.000'),('3ce0c78e-551a-4871-80c4-435836bf1dc5',664,'0f4d3a0e-7431-47c6-b459-92fae651b233','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-23 16:23:37.000',NULL,'2022-08-22 15:06:08.000','2022-08-22 19:06:09.000','2022-08-22 15:06:09.000'),('3d2db1ee-26fa-4508-8e14-b81d51746da7',664,'e7db4581-4a3d-448a-8e08-c12a27fa6201','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-06-11 22:36:14.000',NULL,'2020-06-11 22:36:14.000','2022-03-14 18:58:54.000','2022-03-14 14:58:54.000'),('3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20',664,'f8861160-453a-4b8d-be85-cc6e323c9bd7','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-19 19:30:04.000',NULL,'2022-11-02 19:35:04.000','2022-11-02 23:35:06.000','2022-11-02 19:35:06.000'),('3e328cc1-9830-466d-a33e-fbe74a2dbdae',664,'8b5d08e1-2513-416b-87f9-350cab840a3d','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-22 15:46:56.000',NULL,'2022-06-22 15:48:08.000','2022-06-22 19:48:12.000','2022-06-22 15:48:12.000'),('3eaba63c-ff17-453d-ab22-bc8e747a4ce5',664,'e930782a-e2db-43e8-9ff1-9feb64e20e4e','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-06 19:58:40.000','2022-06-06 20:09:51.000','2022-06-06 20:09:33.000','2022-06-07 00:09:51.000','2022-06-06 20:09:51.000'),('3ef1c403-4f23-4240-9474-8d8f45c283b5',664,'aa5b4efd-a5ce-428d-b35f-dd2bc2c28910','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-09 19:36:59.000',NULL,'2021-04-09 19:43:27.000','2022-03-14 18:58:36.000','2022-03-14 14:58:36.000'),('406263f6-a620-460e-a1e0-2d50ff84809c',664,'0f4d3a0e-7431-47c6-b459-92fae651b233','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-23 16:18:36.000',NULL,'2022-08-22 15:05:28.000','2022-08-22 19:05:34.000','2022-08-22 15:05:34.000'),('40fd847e-fa3a-11ed-8f6c-58a023cda0dc',664,'cf61271a-fa37-11ed-8f6c-58a023cda0dc','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-05-24 09:52:42.000',NULL,'2023-05-24 09:58:23.000','2024-10-31 14:02:36.371','2024-10-31 10:02:36.371'),('416dd268-693a-4466-8380-8829fc1b5e3d',664,'4aaf107a-b8db-4d45-befa-36e801ebc654','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-09-13 21:24:34.000',NULL,'2021-09-13 21:27:32.000','2022-03-14 18:59:13.000','2022-03-14 14:59:13.000'),('428484bf-df10-43b1-a7ed-6f2f0ac47336',664,'6630e34a-9b19-4727-9ef0-e1c95c341549','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-07 15:13:39.000',NULL,'2022-09-07 15:16:14.000','2022-09-07 19:16:18.000','2022-09-07 15:16:18.000'),('4352d5ab-e3b9-4f1f-9fb2-e12036db1127',664,'ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-31 16:59:53.000','2022-10-31 17:26:48.000','2022-10-31 17:10:50.000','2022-10-31 21:26:48.000','2022-10-31 17:26:48.000'),('44749597-6cc6-493d-a2aa-76486e3c8416',664,'21bbefd5-8dc0-4e41-91d8-718463ad469c','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-03 15:58:58.000',NULL,'2022-08-03 17:24:38.000','2022-08-03 21:24:40.000','2022-08-03 17:24:40.000'),('449b7a19-bb82-4d6f-82b8-8bec06fa85d9',664,'775311e4-a561-40c7-a2ce-76a0b1550be8','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-07-28 15:06:38.000',NULL,'2022-08-03 17:26:57.000','2022-08-03 21:26:58.000','2022-08-03 17:26:58.000'),('44c7d5ff-a37c-4426-9398-70aa77f41b00',664,'e78fa40a-0a61-4104-adb2-0cfd70d69414','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-23 14:37:37.000','2022-03-23 14:38:43.000','2022-03-23 14:37:37.000','2022-03-23 18:38:43.000',NULL),('456ba968-983a-4ece-9df6-11392894a534',664,'1d15e305-f110-4004-a35a-cf5ca5fa2600','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-09 16:03:36.000',NULL,'2022-11-09 16:08:18.000','2022-11-09 21:08:23.000','2022-11-09 16:08:23.000'),('4597ad8c-2f54-4ecd-827f-911125d72cc9',664,'b9c2b952-8d0a-4eac-ad77-2acda79cff8c','MAXILLAIRE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-17 18:28:36.000',NULL,'2022-08-17 18:39:33.000','2022-08-17 22:39:39.000','2022-08-17 18:39:39.000'),('4881f615-e5ee-4e32-a293-eb41e56db31d',664,'8d9c33a0-de56-424c-93dc-582bac72d320','MAXILLAIRE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-28 18:39:29.000','2021-04-28 18:43:15.000','2021-04-28 18:42:59.000','2021-04-28 22:43:15.000',NULL),('4b1e4a8e-c35a-4205-bb29-2132e2649b4a',664,'13883510-ca59-4fdd-8bbd-216ef177542a','MAXILLAIRE','SCAN',1,'NONE',4,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-10-04 18:39:40.000',NULL,'2021-10-05 03:11:34.000','2022-03-14 18:59:10.000','2022-03-14 14:59:10.000'),('4b6e42bc-653f-11ef-b382-58a023cda0dc',664,'721e3ad7-6536-11ef-b382-58a023cda0dc','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2024-08-28 09:13:19.000',NULL,'2024-08-28 09:25:31.000','2024-10-31 14:02:37.520','2024-10-31 10:02:37.520'),('4bfeec89-723b-47a0-90b4-0b3cbf540d5d',664,'e930782a-e2db-43e8-9ff1-9feb64e20e4e','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-06 20:36:27.000',NULL,'2022-06-06 20:37:34.000','2022-06-07 00:37:38.000','2022-06-06 20:37:38.000'),('4d1480f1-6a51-4555-bec5-61f967de64cd',664,'eee3d6a4-c7be-49a9-9278-7bd1d7e7f773','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-09-02 15:27:20.000',NULL,'2020-09-02 15:27:20.000','2022-03-14 18:58:26.000','2022-03-14 14:58:26.000'),('4d704f05-9581-4e41-841e-c0731fc61e23',664,'d0806a0e-930a-42be-84bd-2f32d9e80838','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-06-21 17:56:52.000','2021-06-21 18:02:17.000','2021-06-21 17:56:52.000','2021-06-21 22:02:17.000',NULL),('4e055e11-653e-11ef-b382-58a023cda0dc',664,'721e3ad7-6536-11ef-b382-58a023cda0dc','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2024-08-28 09:06:14.000',NULL,'2024-08-28 09:25:31.000','2024-10-31 14:02:37.532','2024-10-31 10:02:37.532'),('4fee66f9-724e-4496-aae8-922ee35cabf6',664,'324dac1a-95fa-44d5-b054-88f048931106','MANDIBULE','SCAN',1,'NONE',4,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-14 15:46:38.000',NULL,'2022-03-14 16:02:28.000','2022-03-14 20:02:42.000','2022-03-14 16:02:42.000'),('513ec45a-0f78-4206-8819-a95a65dd628e',664,'ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-31 17:17:11.000',NULL,'2022-10-31 17:18:35.000','2022-10-31 21:18:44.000','2022-10-31 17:18:44.000'),('51d672de-5db0-4925-8908-13042e3aacea',664,'88c76352-cde4-4fcb-a264-c6cd5cb1e44f','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-07-18 16:38:24.000','2022-07-18 16:51:00.000','2022-07-18 16:47:34.000','2022-07-18 20:51:00.000',NULL),('51eb1879-2b2e-4194-9e9b-9ff1e67fe43c',664,'ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-31 17:22:02.000',NULL,'2022-10-31 17:24:57.000','2022-10-31 21:25:00.000','2022-10-31 17:25:00.000'),('52087ed5-9a59-458b-ac89-795ef90ceb26',664,'d7b86e87-0261-4bc1-8529-76e0bdd29195','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-24 16:21:43.000','2022-08-24 16:28:02.000','2022-08-24 16:21:43.000','2022-08-24 20:28:02.000',NULL),('5212b119-1f64-4de6-82e2-b5b72ee0e22b',664,'0ec93b21-a91f-4695-a966-e072a8fb68e3','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-05-05 16:36:06.000',NULL,'2021-05-05 17:45:52.000','2022-03-14 18:59:04.000','2022-03-14 14:59:04.000'),('53c00a64-96c5-4a0a-9c62-b3bd5bad8d0f',664,'7348646e-cf7a-460b-aba9-d56ad656689e','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-09-14 17:48:02.000','2021-09-14 17:48:15.000','2021-09-14 17:48:02.000','2021-09-14 21:48:15.000',NULL),('5478f37b-d39e-46d1-a026-906c02d9c928',664,'9a395a3e-4872-409e-922b-4bb58053d8a5','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-21 15:10:57.000','2022-03-21 15:32:32.000','2022-03-21 15:32:00.000','2022-03-21 19:32:32.000','2022-03-21 15:32:32.000'),('548140fc-6af1-40d1-8b3b-df746f7dc807',664,'21bbefd5-8dc0-4e41-91d8-718463ad469c','MAXILLAIRE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-03 16:02:36.000','2022-08-03 16:02:42.000','2022-08-03 16:02:36.000','2022-08-03 20:02:42.000',NULL),('5500928e-446a-45d8-af99-faf7375b1d49',664,'8d9c33a0-de56-424c-93dc-582bac72d320','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-28 18:05:04.000',NULL,'2021-04-28 18:22:01.000','2022-03-14 18:58:53.000','2022-03-14 14:58:53.000'),('5590f7d2-7fe1-46e4-94d8-f22429ffe326',664,'0f4d3a0e-7431-47c6-b459-92fae651b233','MORDU_ANTERIEUR','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-23 16:49:21.000',NULL,'2022-03-23 16:49:21.000','2022-03-23 21:07:48.000','2022-03-23 17:07:48.000'),('55e90c19-734b-11ee-b011-58a023cda0dc',664,'07e5f91d-734b-11ee-b011-58a023cda0dc','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-25 11:29:49.000',NULL,'2023-10-25 11:59:30.000','2024-10-31 14:02:37.281','2024-10-31 10:02:37.281'),('57e592a9-5bc2-11ee-9658-58a023cda0dc',664,'eed0dd8b-572c-11ee-a378-58a023cda0dc','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-09-25 12:41:15.000',NULL,'2023-09-25 12:44:16.000','2024-10-31 14:02:36.445','2024-10-31 10:02:36.445'),('59402aaf-7342-11ee-b011-58a023cda0dc',664,'ecbe814b-7341-11ee-b011-58a023cda0dc','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-25 10:25:29.000',NULL,'2023-10-25 11:27:29.000','2024-10-31 14:02:36.533','2024-10-31 10:02:36.533'),('5a4c21bb-56d0-45ea-b8ee-4931713ef609',664,'ae7f89c9-26ec-4cee-b377-d5145e6c6aae','MANDIBULE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-14 18:12:14.000',NULL,'2022-11-14 18:17:32.000','2022-11-14 23:17:37.000','2022-11-14 18:17:37.000'),('5d0e6d2d-490c-4381-a794-dd7121de4a60',664,'6630e34a-9b19-4727-9ef0-e1c95c341549','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-07 14:56:19.000',NULL,'2022-09-07 15:04:16.000','2022-09-07 19:04:22.000','2022-09-07 15:04:22.000'),('5de08e77-210d-48b5-8004-9c536bb8530e',664,'e98b0c01-9e79-49e0-9ab8-0d6f432bf80d','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',4,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-01 15:33:30.000',NULL,'2022-08-01 15:50:53.000','2022-08-01 19:53:39.000','2022-08-01 15:53:39.000'),('5f528d31-6a1a-48e7-8ece-1a998befa669',664,'94dc9a16-b72c-4f6a-a520-ba83c28954c3','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-07 16:30:41.000',NULL,'2022-09-07 16:36:51.000','2022-09-07 20:36:56.000','2022-09-07 16:36:56.000'),('5ffd123b-12b9-4fc7-9b8a-16b74a28e7b2',664,'18d990cb-0161-4a7a-b1ce-1c139a73a700','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-14 17:49:47.000',NULL,'2022-09-14 17:55:29.000','2022-09-14 21:55:33.000','2022-09-14 17:55:33.000'),('608d8495-6c36-11ee-bc7f-58a023cda0dc',664,'0a97fa8b-6c31-11ee-bc7f-58a023cda0dc','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-16 11:12:09.000',NULL,'2023-10-16 13:05:08.000','2024-10-31 14:02:36.506','2024-10-31 10:02:36.506'),('60bb883b-6540-11ef-b382-58a023cda0dc',664,'721e3ad7-6536-11ef-b382-58a023cda0dc','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2024-08-28 09:21:04.000',NULL,'2024-08-28 09:25:31.000','2024-10-31 14:02:37.543','2024-10-31 10:02:37.543'),('627e4388-24f1-4c92-816e-89cfce055284',664,'775311e4-a561-40c7-a2ce-76a0b1550be8','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-07-28 15:31:52.000',NULL,'2022-08-03 17:26:40.000','2022-08-03 21:26:41.000','2022-08-03 17:26:41.000'),('62fd085a-7b18-4cdf-aa97-db92a842f34f',664,'0f4d3a0e-7431-47c6-b459-92fae651b233','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-23 16:36:18.000',NULL,'2022-08-22 15:06:21.000','2022-08-22 19:06:22.000','2022-08-22 15:06:22.000'),('640e0a5a-3880-4e38-add1-3466fa8599c0',664,'8b5d08e1-2513-416b-87f9-350cab840a3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-22 15:42:12.000',NULL,'2022-06-22 15:46:50.000','2022-06-22 19:46:54.000','2022-06-22 15:46:54.000'),('6557ff06-b759-4b3c-8de6-1c83a9b00d23',664,'8cd0c724-d3d0-4821-a88b-42b03ae4eb07','MAXILLAIRE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-17 16:57:34.000',NULL,'2022-10-17 17:02:54.000','2022-10-17 21:02:59.000','2022-10-17 17:02:59.000'),('663b4cd8-e704-4cb6-ab8f-80ec41ed1370',664,'48ff9245-20c5-4364-a092-18eafb8024d3','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-09-16 19:04:14.000',NULL,'2020-09-16 19:04:14.000','2022-03-14 18:58:33.000','2022-03-14 14:58:33.000'),('669f6bca-452c-4b2e-a49e-aa822628ed5f',664,'4aaf107a-b8db-4d45-befa-36e801ebc654','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-09-13 21:02:13.000',NULL,'2021-09-13 21:19:15.000','2022-03-14 18:59:13.000','2022-03-14 14:59:13.000'),('6b9a0ce1-8ace-48c3-a9b9-efd9bd604d7f',664,'d7b86e87-0261-4bc1-8529-76e0bdd29195','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-24 16:28:05.000',NULL,'2022-08-24 16:32:04.000','2022-08-24 20:32:10.000','2022-08-24 16:32:10.000'),('6bf6cdd3-0c99-40b6-9e2b-5eaf7077f35f',664,'e98b0c01-9e79-49e0-9ab8-0d6f432bf80d','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-01 15:22:34.000','2022-08-01 15:24:38.000','2022-08-01 15:23:55.000','2022-08-01 19:24:38.000','2022-08-01 15:24:38.000'),('6d0c8022-e8b8-4ffa-8b31-ee9c8a811bb3',664,'d7b86e87-0261-4bc1-8529-76e0bdd29195','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-24 16:36:02.000',NULL,'2022-08-24 16:37:47.000','2022-08-24 20:37:51.000','2022-08-24 16:37:51.000'),('6d53d83a-50bf-4b07-a6c4-377e6be410b9',664,'ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-31 17:26:52.000',NULL,'2022-11-22 20:01:41.000','2022-11-23 01:01:43.000','2022-11-22 20:01:43.000'),('6f12cbab-9aee-4057-bc58-bb6f63974204',664,'94dc9a16-b72c-4f6a-a520-ba83c28954c3','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-07 16:37:25.000',NULL,'2022-09-07 16:39:43.000','2022-09-07 20:39:48.000','2022-09-07 16:39:48.000'),('6f4cc2d8-2239-4982-a8b0-33dc6be535ae',664,'8d9c33a0-de56-424c-93dc-582bac72d320','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-28 18:56:46.000',NULL,'2021-04-28 18:58:51.000','2022-03-14 18:58:52.000','2022-03-14 14:58:52.000'),('6f9af98c-1ab4-4600-b23b-57aa4c4d1e85',664,'8d9c33a0-de56-424c-93dc-582bac72d320','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-28 18:25:18.000','2021-04-28 18:43:25.000','2021-04-28 18:39:20.000','2021-04-28 22:43:25.000',NULL),('70b1bf4b-a08d-4b96-9200-6648114f1bcd',664,'f8861160-453a-4b8d-be85-cc6e323c9bd7','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-19 19:30:04.000',NULL,'2022-10-19 19:30:04.000','2022-10-19 23:30:22.000','2022-10-19 19:30:22.000'),('714348f7-0720-4a1c-bebb-c0807d687feb',664,'e98b0c01-9e79-49e0-9ab8-0d6f432bf80d','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-01 15:15:47.000',NULL,'2022-08-01 15:22:15.000','2022-08-01 19:22:19.000','2022-08-01 15:22:19.000'),('71efc8fb-f188-420c-8716-a37bd62f0561',664,'0f4d3a0e-7431-47c6-b459-92fae651b233','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-23 16:42:31.000',NULL,'2022-03-23 16:42:31.000','2022-03-23 20:48:27.000','2022-03-23 16:48:27.000'),('722ff437-cef4-4d6b-861e-b52566d89c0d',664,'e98b0c01-9e79-49e0-9ab8-0d6f432bf80d','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-01 15:27:17.000',NULL,'2022-08-01 15:28:42.000','2022-08-01 19:28:46.000','2022-08-01 15:28:46.000'),('73765dbb-1926-4aed-8b7f-3202e1e68aa2',664,'26288707-da63-4165-bfdb-8a6c299bcb2b','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-04-11 17:18:15.000',NULL,'2022-04-11 17:24:45.000','2022-04-11 21:24:54.000','2022-04-11 17:24:54.000'),('749e1ebe-54d9-4185-85ac-3c28e2760fa2',664,'324dac1a-95fa-44d5-b054-88f048931106','MANDIBULE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-14 15:40:05.000','2022-03-14 15:43:13.000','2022-03-14 15:40:05.000','2022-03-14 14:43:13.000',NULL),('7553b46a-ede9-4c31-a05e-14571e344801',664,'d0806a0e-930a-42be-84bd-2f32d9e80838','MAXILLAIRE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-06-21 18:07:03.000','2021-06-21 18:16:27.000','2021-06-21 18:07:03.000','2021-06-21 22:16:27.000',NULL),('760aa563-6e6f-4ae3-98cc-e3d5350a517e',664,'ede3aa5c-bbba-4cf2-8caa-b2d5f671b311','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-21 19:25:38.000',NULL,'2022-09-21 19:25:38.000','2022-09-21 23:25:49.000','2022-09-21 19:25:49.000'),('790f3bda-297c-41ad-812c-c6f5b135e445',664,'a98f038e-a19a-47ad-af09-a22810e9d19c','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-14 15:28:03.000',NULL,'2022-08-22 14:56:35.000','2022-08-22 18:56:36.000','2022-08-22 14:56:36.000'),('79842b46-a1df-43a9-812e-4322f1c79203',664,'8d9c33a0-de56-424c-93dc-582bac72d320','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-28 18:58:57.000',NULL,'2021-04-28 19:02:47.000','2022-03-14 18:58:52.000','2022-03-14 14:58:52.000'),('7a644c38-fa3b-11ed-8f6c-58a023cda0dc',664,'cf61271a-fa37-11ed-8f6c-58a023cda0dc','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-05-24 10:01:28.000',NULL,'2023-05-24 10:06:39.000','2024-10-31 14:02:36.423','2024-10-31 10:02:36.423'),('7bbce4b0-91f9-47fe-9ce5-53e0f491b245',664,'7d36e059-dbc3-46b0-931a-bdf8fdc805c6','MANDIBULE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-21 10:03:09.000','2022-03-14 09:42:20.000','2021-04-21 10:15:00.000','2024-10-31 14:02:25.538','2024-10-31 10:02:25.538'),('7c9d6daa-c5b6-47ec-b65a-ee99948da8ea',664,'13883510-ca59-4fdd-8bbd-216ef177542a','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-10-04 19:07:41.000',NULL,'2021-10-04 19:09:46.000','2022-03-14 18:59:10.000','2022-03-14 14:59:10.000'),('7ce9b1b8-7c7b-4655-bd0d-90f37ced345e',664,'5dac735e-358c-49a1-aa52-0180d8d8ff7e','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-10-20 18:10:50.000',NULL,'2021-10-20 18:22:57.000','2022-03-14 18:59:07.000','2022-03-14 14:59:07.000'),('7d660b43-6b91-4c1b-b004-a0aa4d714d00',664,'21bbefd5-8dc0-4e41-91d8-718463ad469c','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-03 15:29:14.000','2022-08-03 15:49:57.000','2022-08-03 15:49:49.000','2022-08-03 19:49:57.000','2022-08-03 15:49:57.000'),('7d87c990-cfc0-487a-bd48-674f0ba32da1',664,'13883510-ca59-4fdd-8bbd-216ef177542a','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-10-04 18:49:14.000',NULL,'2021-10-04 19:04:06.000','2022-03-14 18:59:09.000','2022-03-14 14:59:09.000'),('7eb7b491-f49d-4ad2-941c-473aec4b39cd',664,'8b5d08e1-2513-416b-87f9-350cab840a3d','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-22 15:36:43.000',NULL,'2022-06-22 15:42:04.000','2022-06-22 19:42:08.000','2022-06-22 15:42:08.000'),('7eed9265-48be-43c4-aae3-9513b781421c',664,'d0806a0e-930a-42be-84bd-2f32d9e80838','MAXILLAIRE','SCAN',1,'NONE',4,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-06-21 18:16:30.000',NULL,'2021-06-21 18:16:30.000','2022-03-14 18:58:39.000','2022-03-14 14:58:39.000'),('7f9b3767-26d0-40f2-b0dd-07da9d57ad85',664,'a2816a91-70d4-492e-af69-b69e3c134704','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-05-03 20:20:18.000',NULL,'2021-05-03 20:49:27.000','2022-03-14 18:59:02.000','2022-03-14 14:59:02.000'),('7ffdb9e2-6078-4155-9aea-df5ff7d574f8',664,'ae7f89c9-26ec-4cee-b377-d5145e6c6aae','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-14 17:20:27.000','2022-11-14 17:33:21.000','2022-11-14 17:20:27.000','2022-11-14 22:33:21.000',NULL),('81f83061-69fa-4da2-b528-42ee27f15e7a',664,'6630e34a-9b19-4727-9ef0-e1c95c341549','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-07 15:04:21.000',NULL,'2022-09-07 15:13:02.000','2022-09-07 19:13:07.000','2022-09-07 15:13:07.000'),('821a2ca1-0234-413b-a35b-4cc6703ca75b',664,'7d36e059-dbc3-46b0-931a-bdf8fdc805c6','MAXILLAIRE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-21 15:21:35.000',NULL,'2021-04-21 15:36:54.000','2022-03-14 18:58:59.000','2022-03-14 14:58:59.000'),('82ccc541-d923-4b1a-a666-11b4929d815c',664,'a7f67fa5-a5f7-45a9-bcd5-f578fcdcccd1','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-09-27 14:36:38.000',NULL,'2021-09-27 14:36:38.000','2022-03-14 18:58:41.000','2022-03-14 14:58:41.000'),('82ecab0e-29eb-4e22-957f-3c065a082b56',664,'f3c53557-6667-45e0-9d95-e4f4366d4d71','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-30 18:44:40.000','2022-03-30 18:56:23.000','2022-03-30 18:56:07.000','2022-03-30 22:56:23.000','2022-03-30 18:56:23.000'),('837d6f6c-9467-11ee-8fd8-58a023cda0dc',664,'d4b9a9b2-9462-11ee-8fd8-58a023cda0dc','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-12-06 13:44:40.000',NULL,'2023-12-06 14:12:07.000','2024-10-31 14:02:37.348','2024-10-31 10:02:37.348'),('84918ef7-2b0c-4acf-a14e-df7fcaff4812',664,'e98b0c01-9e79-49e0-9ab8-0d6f432bf80d','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-01 15:36:31.000',NULL,'2022-08-01 15:37:20.000','2022-08-01 19:53:38.000','2022-08-01 15:53:38.000'),('8561d2e9-734e-11ee-b011-58a023cda0dc',664,'07e5f91d-734b-11ee-b011-58a023cda0dc','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-25 11:52:37.000',NULL,'2023-10-25 11:59:30.000','2024-10-31 14:02:37.296','2024-10-31 10:02:37.296'),('86e16909-3b39-4591-8c03-0e4eba17f0ff',664,'a98f038e-a19a-47ad-af09-a22810e9d19c','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-14 15:32:30.000',NULL,'2022-08-22 14:56:54.000','2022-08-22 18:56:57.000','2022-08-22 14:56:57.000'),('87132a5c-9464-11ee-8fd8-58a023cda0dc',664,'d4b9a9b2-9462-11ee-8fd8-58a023cda0dc','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-12-06 13:23:17.000',NULL,'2023-12-06 14:12:08.000','2024-10-31 14:02:37.408','2024-10-31 10:02:37.408'),('874c0c20-f92b-4f51-bfbf-beda7bc236fe',664,'8cd0c724-d3d0-4821-a88b-42b03ae4eb07','MANDIBULE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-17 17:06:44.000','2022-10-17 17:06:49.000','2022-10-17 17:06:44.000','2022-10-17 21:06:49.000',NULL),('88f800e1-3e01-4d9c-984c-9f939ebee222',664,'fcabdff7-f4aa-41a0-8d3a-67e664f1d43e','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-11-30 02:22:13.000',NULL,'2020-11-30 02:22:13.000','2022-03-14 18:58:30.000','2022-03-14 14:58:30.000'),('893e772a-611c-44f9-82ac-d63e0a0499b2',664,'8d9c33a0-de56-424c-93dc-582bac72d320','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-28 18:53:10.000',NULL,'2021-04-28 18:54:11.000','2022-03-14 18:58:53.000','2022-03-14 14:58:53.000'),('89f0b9b8-97a1-49c1-afcc-d6521d0ab59f',664,'e98b0c01-9e79-49e0-9ab8-0d6f432bf80d','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-01 15:32:47.000','2022-08-01 15:32:49.000','2022-08-01 15:32:47.000','2022-08-01 19:32:49.000',NULL),('8ce97d97-ffb5-461c-928d-ea25e722645a',664,'775311e4-a561-40c7-a2ce-76a0b1550be8','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-07-28 15:34:49.000',NULL,'2022-08-03 17:27:34.000','2022-08-03 21:27:36.000','2022-08-03 17:27:36.000'),('8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368',664,'0f4d3a0e-7431-47c6-b459-92fae651b233','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-23 16:38:00.000',NULL,'2022-08-22 15:06:34.000','2022-08-22 19:06:35.000','2022-08-22 15:06:35.000'),('90489237-0457-4c92-88a6-63cb5a0074e9',664,'324dac1a-95fa-44d5-b054-88f048931106','MANDIBULE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-14 15:43:14.000','2022-03-14 15:43:21.000','2022-03-14 15:43:14.000','2022-03-14 14:43:21.000',NULL),('912aed9d-90da-48c3-b2d2-60c29e2eb2a2',664,'cacc103c-8b88-4be5-a787-b6b92341e9eb','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-05-25 17:57:59.000',NULL,'2022-05-25 17:59:41.000','2022-05-25 22:01:07.000','2022-05-25 18:01:07.000'),('92704e83-dce3-4695-baad-1df750f09cd7',664,'1d15e305-f110-4004-a35a-cf5ca5fa2600','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-09 15:46:01.000',NULL,'2022-11-09 17:07:29.000','2022-11-09 22:07:31.000','2022-11-09 17:07:31.000'),('93be3b1e-bcd5-443a-a7e3-4f5452c470a6',664,'4aaf107a-b8db-4d45-befa-36e801ebc654','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-09-13 21:19:53.000',NULL,'2021-09-13 21:24:08.000','2022-03-14 18:59:13.000','2022-03-14 14:59:13.000'),('93f13113-c282-4369-a96a-9a2f2f6383b2',664,'1256ab02-5172-4a92-a17d-f2fc402290ac','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-05-05 15:56:42.000','2021-05-05 15:57:47.000','2021-05-05 15:57:43.000','2021-05-05 19:57:47.000',NULL),('95b374af-2b93-47f7-86f5-f5e1ba6360b6',664,'aa5b4efd-a5ce-428d-b35f-dd2bc2c28910','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-09 13:50:51.000','2022-03-14 09:42:19.000','2021-04-09 13:52:41.000','2024-10-31 14:02:25.487','2024-10-31 10:02:25.487'),('962c1c5b-f5e5-4c64-9396-b2b298e42f54',664,'26288707-da63-4165-bfdb-8a6c299bcb2b','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-04-11 17:14:55.000',NULL,'2022-04-11 17:18:12.000','2022-04-11 21:21:36.000','2022-04-11 17:21:36.000'),('96e07cef-c402-4c22-8ab7-f63fa9dd08a0',664,'6861b877-a2a9-413b-a002-89eb317aa99f','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-05-03 19:03:39.000',NULL,'2021-05-03 19:53:34.000','2022-03-14 18:59:05.000','2022-03-14 14:59:05.000'),('97459af6-e1c3-415a-a29f-faf01aad9d80',664,'f3c53557-6667-45e0-9d95-e4f4366d4d71','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-30 18:44:28.000','2022-03-30 18:44:32.000','2022-03-30 18:44:28.000','2022-03-30 22:44:32.000',NULL),('98f6c3db-f007-4f0d-a724-a372751a6d75',664,'bf823edb-92ee-4ee9-acd3-507d49bad781','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-09-09 15:47:13.000',NULL,'2022-08-22 15:00:21.000','2022-08-22 19:00:22.000','2022-08-22 15:00:22.000'),('9af0dbc6-6540-11ef-b382-58a023cda0dc',664,'721e3ad7-6536-11ef-b382-58a023cda0dc','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2024-08-28 09:22:42.000',NULL,'2024-08-28 09:25:31.000','2024-10-31 14:02:37.554','2024-10-31 10:02:37.554'),('9d8b2873-a7e1-420c-b2e4-b5e2beb77f7c',664,'585f84a0-017e-4b5a-9465-7947c2ada0b3','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-10-27 19:46:24.000',NULL,'2021-10-27 19:46:24.000','2022-03-14 18:58:50.000','2022-03-14 14:58:50.000'),('9e8d12d6-c39b-4c36-84d0-73f3f668b9b2',664,'7d36e059-dbc3-46b0-931a-bdf8fdc805c6','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-21 15:20:49.000','2021-04-21 15:21:20.000','2021-04-21 15:20:49.000','2021-04-21 19:21:20.000',NULL),('9ec52cac-03f7-4247-88fd-59b11e688f36',664,'ea664326-1e10-4280-80b6-f3d23573a862','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-04-18 18:55:29.000',NULL,'2020-04-18 18:55:29.000','2022-03-14 18:58:28.000','2022-03-14 14:58:28.000'),('9f22f8f4-8b92-4811-8c6a-7b858b99e056',664,'f8861160-453a-4b8d-be85-cc6e323c9bd7','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-19 19:30:05.000',NULL,'2022-10-19 19:30:05.000','2022-10-19 23:30:28.000','2022-10-19 19:30:28.000'),('a003a669-7caa-4b04-a7fb-b5164b2bfcd3',664,'21bbefd5-8dc0-4e41-91d8-718463ad469c','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-03 16:13:21.000',NULL,'2022-08-03 17:25:18.000','2022-08-03 21:25:19.000','2022-08-03 17:25:19.000'),('a0b85a0a-ef77-4f7c-b376-d6e388afe9f0',664,'7d40798f-7207-4c33-aa42-10afc814de77','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-07-03 16:42:25.000',NULL,'2022-08-22 14:50:54.000','2022-08-22 18:51:00.000','2022-08-22 14:51:00.000'),('a1d7f6b9-6c36-11ee-bc7f-58a023cda0dc',664,'0a97fa8b-6c31-11ee-bc7f-58a023cda0dc','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-16 11:13:59.000',NULL,'2023-10-16 13:05:08.000','2024-10-31 14:02:36.518','2024-10-31 10:02:36.518'),('a283652c-095c-41a2-b62b-1cba87286c35',664,'4aaf107a-b8db-4d45-befa-36e801ebc654','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-09-13 21:27:44.000',NULL,'2021-09-13 21:29:13.000','2022-03-14 18:59:12.000','2022-03-14 14:59:12.000'),('a374af86-2871-4bc6-aa2b-1b89086d3313',664,'d0806a0e-930a-42be-84bd-2f32d9e80838','MAXILLAIRE','SCAN',1,'NONE',5,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-06-21 18:24:24.000',NULL,'2021-06-21 18:24:24.000','2022-03-14 18:58:38.000','2022-03-14 14:58:38.000'),('a4752db3-12a3-432e-825c-694c37118d39',664,'1d15e305-f110-4004-a35a-cf5ca5fa2600','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-09 16:08:24.000',NULL,'2022-11-09 16:16:06.000','2022-11-09 21:16:09.000','2022-11-09 16:16:09.000'),('a4dc6ae3-adc9-4674-b447-e17561e2f397',664,'8cd0c724-d3d0-4821-a88b-42b03ae4eb07','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-17 16:43:25.000','2022-10-17 16:49:14.000','2022-10-17 16:43:25.000','2022-10-17 20:49:14.000',NULL),('a58436fa-a729-4ed0-9312-1037d7bc8f6e',664,'9f4fa7cb-81a3-460e-b189-ba76eb8cee15','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-30 16:42:14.000','2022-03-30 16:49:47.000','2022-03-30 16:49:31.000','2022-03-30 20:49:47.000','2022-03-30 16:49:47.000'),('a614060b-f808-4f83-92d9-bfd877c99148',664,'e98b0c01-9e79-49e0-9ab8-0d6f432bf80d','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-01 15:24:40.000','2022-08-01 15:33:03.000','2022-08-01 15:25:26.000','2022-08-01 19:33:03.000','2022-08-01 15:33:03.000'),('a6208834-50bc-4a6d-9646-4220f7dbfeeb',664,'7d36e059-dbc3-46b0-931a-bdf8fdc805c6','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-21 16:26:37.000',NULL,'2021-04-21 16:29:16.000','2022-03-14 18:58:59.000','2022-03-14 14:58:59.000'),('a6440940-a668-4e8f-be35-82ce928f701e',664,'120f9fe3-b23d-49c7-89ab-f1becc102f6c','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-04-11 17:09:22.000',NULL,'2022-04-11 17:13:43.000','2022-04-11 21:14:06.000','2022-04-11 17:14:06.000'),('a6f3b498-07ce-489a-805c-c6bc2ac7d0d9',664,'a2816a91-70d4-492e-af69-b69e3c134704','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-05-03 20:00:20.000','2021-05-03 20:20:02.000','2021-05-03 20:18:50.000','2021-05-04 00:20:02.000',NULL),('a7098a82-daaf-4ad2-a4b6-803796e5351b',664,'775311e4-a561-40c7-a2ce-76a0b1550be8','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-07-28 14:59:55.000','2022-07-28 15:30:03.000','2022-07-28 15:06:25.000','2022-07-28 19:30:03.000',NULL),('a8bc827c-e0a5-47f0-9a65-02d941ee82ab',664,'e930782a-e2db-43e8-9ff1-9feb64e20e4e','MANDIBULE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-06 20:20:41.000',NULL,'2022-06-06 20:31:57.000','2022-06-07 00:32:03.000','2022-06-06 20:32:03.000'),('ab0cf7a4-5bc3-11ee-9658-58a023cda0dc',664,'eed0dd8b-572c-11ee-a378-58a023cda0dc','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-09-25 12:50:44.000',NULL,'2023-09-25 12:57:59.000','2024-10-31 14:02:36.468','2024-10-31 10:02:36.468'),('abe20329-4dfe-4eda-815d-06af022b814e',664,'9f4fa7cb-81a3-460e-b189-ba76eb8cee15','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-30 16:56:08.000','2022-03-30 17:02:56.000','2022-03-30 17:02:19.000','2022-03-30 21:02:56.000','2022-03-30 17:02:56.000'),('abe712db-ef5c-4b31-86ea-c51697f1242e',664,'e78fa40a-0a61-4104-adb2-0cfd70d69414','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-23 14:33:33.000',NULL,'2022-03-23 14:37:02.000','2022-03-23 18:37:17.000','2022-03-23 14:37:17.000'),('ac16a8c2-fbd8-4869-bf7c-e91bea9fa98c',664,'7d36e059-dbc3-46b0-931a-bdf8fdc805c6','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-21 15:02:02.000','2021-04-21 15:20:42.000','2021-04-21 15:02:02.000','2021-04-21 19:20:42.000',NULL),('ad99e632-5042-4e93-87eb-5f1d24eaf0df',664,'ae7f89c9-26ec-4cee-b377-d5145e6c6aae','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-14 18:20:27.000',NULL,'2022-11-14 18:22:53.000','2022-11-14 23:22:57.000','2022-11-14 18:22:57.000'),('ae3d82e4-16e2-4a7c-984e-ec74c0b263f0',664,'e930782a-e2db-43e8-9ff1-9feb64e20e4e','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-06 20:38:08.000',NULL,'2022-06-06 20:39:16.000','2022-06-07 00:39:20.000','2022-06-06 20:39:20.000'),('b06cfd07-efaa-4040-b45e-93a144000fa3',664,'13883510-ca59-4fdd-8bbd-216ef177542a','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-10-04 18:15:05.000','2021-10-04 18:18:32.000','2021-10-04 18:15:05.000','2021-10-04 22:18:32.000',NULL),('b08eb59b-89c3-4239-8926-d8eb829e4257',664,'120f9fe3-b23d-49c7-89ab-f1becc102f6c','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-04-11 17:03:34.000',NULL,'2022-04-14 15:19:53.000','2022-04-14 19:19:54.000','2022-04-14 15:19:54.000'),('b0b45de7-f1c4-4f46-9c23-2126c2326f9b',664,'a03e7e47-63b0-4489-88e8-a77bb9aed5cd','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-06-21 18:42:27.000',NULL,'2021-06-21 18:50:33.000','2022-03-14 18:58:46.000','2022-03-14 14:58:46.000'),('b1421e3f-63ee-4787-8b03-c065863774b0',664,'f3c53557-6667-45e0-9d95-e4f4366d4d71','MAXILLAIRE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-30 18:56:39.000',NULL,'2022-03-30 19:04:33.000','2022-03-30 23:04:41.000','2022-03-30 19:04:41.000'),('b241654a-9ea1-48f7-8414-4891fdcbd880',664,'ede3aa5c-bbba-4cf2-8caa-b2d5f671b311','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-21 19:25:38.000',NULL,'2022-09-21 19:25:38.000','2022-09-21 23:25:49.000','2022-09-21 19:25:49.000'),('b3dee852-769a-40d5-9c59-f651659a9d74',664,'8cd0c724-d3d0-4821-a88b-42b03ae4eb07','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-17 17:12:32.000',NULL,'2022-10-17 17:13:59.000','2022-10-17 21:14:08.000','2022-10-17 17:14:08.000'),('b6033058-40f5-4202-bc4b-bfe024d70e70',664,'1256ab02-5172-4a92-a17d-f2fc402290ac','MAXILLAIRE','SCAN',1,'NONE',4,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-05-05 16:13:13.000',NULL,'2021-05-05 16:34:15.000','2022-03-14 18:59:00.000','2022-03-14 14:59:00.000'),('b6a47aff-51d9-4bb1-bb0d-20fd5a5bc0e0',664,'75f786da-2db1-4447-9a94-0df475a4082d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-02-20 15:28:15.000',NULL,'2023-02-20 15:59:17.000','2023-02-20 20:59:23.000','2023-02-20 15:59:23.000'),('b6b465bc-cccb-49a9-ba82-6a6e82cd4324',664,'9a395a3e-4872-409e-922b-4bb58053d8a5','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-21 15:37:14.000',NULL,'2022-08-22 15:09:22.000','2022-08-22 19:09:24.000','2022-08-22 15:09:24.000'),('b73483a0-d57c-487e-911d-3e231dc9e2de',664,'7d36e059-dbc3-46b0-931a-bdf8fdc805c6','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-21 15:38:00.000','2021-04-21 16:03:00.000','2021-04-21 15:38:00.000','2021-04-21 20:03:00.000',NULL),('b8399067-4ae2-4f64-a407-d8870e0e66ec',664,'aa5b4efd-a5ce-428d-b35f-dd2bc2c28910','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-09 19:22:22.000',NULL,'2021-04-09 19:34:56.000','2022-03-14 18:58:36.000','2022-03-14 14:58:36.000'),('b974cde0-1037-4254-9cd8-9fcd14968091',664,'ede3aa5c-bbba-4cf2-8caa-b2d5f671b311','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-21 19:25:38.000',NULL,'2022-09-21 19:25:38.000','2022-09-21 23:25:49.000','2022-09-21 19:25:49.000'),('bb241051-9343-4a9a-9282-a960e0748f3e',664,'cacc103c-8b88-4be5-a787-b6b92341e9eb','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-05-25 18:15:53.000',NULL,'2022-05-25 18:31:48.000','2022-05-25 22:31:58.000','2022-05-25 18:31:58.000'),('bbd16c8e-e7dc-4578-8027-d6b5d16e2cce',664,'7af02eaf-c13f-4389-b2dd-b2cbdfb137e6','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-20 19:22:17.000',NULL,'2022-06-20 19:29:58.000','2022-06-20 23:30:03.000','2022-06-20 19:30:03.000'),('bdc0c035-5e2c-49c1-9980-ecffc5862af4',664,'21bbefd5-8dc0-4e41-91d8-718463ad469c','MAXILLAIRE','SCAN',1,'NONE',4,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-03 16:06:52.000',NULL,'2022-08-03 17:24:05.000','2022-08-03 21:24:06.000','2022-08-03 17:24:06.000'),('bf2f2d20-77c1-4aff-a005-144b4bf2c7f3',664,'e98b0c01-9e79-49e0-9ab8-0d6f432bf80d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-01 15:04:48.000',NULL,'2022-08-01 15:15:18.000','2022-08-01 19:15:22.000','2022-08-01 15:15:22.000'),('c06a5cff-eff6-47da-bc1a-c815235abec3',664,'26288707-da63-4165-bfdb-8a6c299bcb2b','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-04-11 17:25:01.000',NULL,'2022-04-11 17:26:40.000','2022-04-11 21:26:53.000','2022-04-11 17:26:53.000'),('c10fc832-071d-4249-8d26-88c7891b3ef7',664,'627f8883-666a-43cc-a9a1-6e48437d191f','MANDIBULE','SCAN',1,'IN_PROGRESS',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-04-18 19:49:03.000',NULL,'2020-04-18 19:49:03.000','2022-03-14 18:58:42.000','2022-03-14 14:58:42.000'),('c17d800a-58c0-4658-b29b-d8ee0cbd16bb',664,'a59f40f9-2208-4d6a-b286-f64533d92e3c','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-01-18 21:37:50.000',NULL,'2021-01-18 21:39:02.000','2022-03-14 18:58:44.000','2022-03-14 14:58:44.000'),('c25edbb6-50b0-4c96-8756-63dca8532242',664,'9f4fa7cb-81a3-460e-b189-ba76eb8cee15','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-30 17:13:55.000',NULL,'2022-03-30 17:15:54.000','2022-03-30 21:18:22.000','2022-03-30 17:18:22.000'),('c2dbac17-9467-11ee-8fd8-58a023cda0dc',664,'d4b9a9b2-9462-11ee-8fd8-58a023cda0dc','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-12-06 13:46:26.000',NULL,'2023-12-06 14:12:08.000','2024-10-31 14:02:37.434','2024-10-31 10:02:37.434'),('c3b55ffe-4305-4af0-829c-88fb2866ef2a',664,'120f9fe3-b23d-49c7-89ab-f1becc102f6c','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-04-11 16:48:40.000',NULL,'2022-04-11 17:03:19.000','2022-04-11 21:03:34.000','2022-04-11 17:03:34.000'),('c550cbc7-71cb-4513-8c8b-7c725f1e0129',664,'0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-11-30 02:14:43.000',NULL,'2020-11-30 02:14:43.000','2022-03-14 18:42:58.000','2022-03-14 14:42:58.000'),('c56436ec-184d-44cc-9d63-5d6b28b7aebe',664,'4d46a627-5949-4b2a-b4d6-c391f159485b','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-12 20:32:52.000','2022-09-12 20:35:50.000','2022-09-12 20:35:16.000','2022-09-13 00:35:50.000','2022-09-12 20:35:50.000'),('c5b26299-5fb8-4823-8b1a-c620bba14794',664,'7d40798f-7207-4c33-aa42-10afc814de77','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-06-29 19:55:41.000',NULL,'2022-08-22 14:51:32.000','2022-08-22 18:51:34.000','2022-08-22 14:51:34.000'),('c69698a5-2e7e-4714-8c18-60b069e2d221',664,'8d9c33a0-de56-424c-93dc-582bac72d320','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-28 18:04:26.000','2021-04-28 18:05:01.000','2021-04-28 18:04:26.000','2021-04-28 22:05:01.000',NULL),('c69cb914-4302-4945-ad80-085dba8ff126',664,'324dac1a-95fa-44d5-b054-88f048931106','MAXILLAIRE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-14 16:17:18.000',NULL,'2022-03-14 16:23:59.000','2022-03-14 20:24:14.000','2022-03-14 16:24:14.000'),('c865ffd7-f2b1-43ae-a10a-26300e29d86e',664,'9f4fa7cb-81a3-460e-b189-ba76eb8cee15','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-30 17:16:03.000',NULL,'2022-03-30 17:18:21.000','2022-03-30 21:18:30.000','2022-03-30 17:18:30.000'),('c8efe876-0a08-4332-bd36-6b59cc8f2eb8',664,'9f4fa7cb-81a3-460e-b189-ba76eb8cee15','MANDIBULE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-30 16:49:52.000',NULL,'2022-03-30 16:56:02.000','2022-03-30 21:02:20.000','2022-03-30 17:02:20.000'),('c99c9d0a-c35b-4807-b2a9-496902d65503',664,'ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-31 17:19:48.000','2022-10-31 17:21:14.000','2022-10-31 17:19:48.000','2022-10-31 21:21:14.000',NULL),('c9a0bb36-9838-11ee-86e7-58a023cda0dc',664,'bf16aee0-9837-11ee-86e7-58a023cda0dc','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-12-11 10:20:16.000',NULL,'2023-12-11 10:40:41.000','2024-10-31 14:02:37.498','2024-10-31 10:02:37.498'),('c9d5be37-9f50-45c6-8384-f43f10073bb8',664,'1256ab02-5172-4a92-a17d-f2fc402290ac','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-05-05 15:46:48.000','2021-05-05 15:56:40.000','2021-05-05 15:56:33.000','2021-05-05 19:56:40.000',NULL),('cc0c8ac4-7342-11ee-b011-58a023cda0dc',664,'ecbe814b-7341-11ee-b011-58a023cda0dc','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-25 10:28:42.000',NULL,'2023-10-25 11:27:29.000','2024-10-31 14:02:36.545','2024-10-31 10:02:36.545'),('cd138f1a-5bc2-11ee-9658-58a023cda0dc',664,'eed0dd8b-572c-11ee-a378-58a023cda0dc','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-09-25 12:44:31.000',NULL,'2023-09-25 12:50:24.000','2024-10-31 14:02:36.457','2024-10-31 10:02:36.457'),('cd1443ce-734e-11ee-b011-58a023cda0dc',664,'07e5f91d-734b-11ee-b011-58a023cda0dc','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-25 11:54:38.000',NULL,'2023-10-25 11:59:30.000','2024-10-31 14:02:37.306','2024-10-31 10:02:37.306'),('d19c7af8-1f07-4857-86c3-e29963c1f9c9',664,'aa05c648-fa52-43e7-ae5a-2d1a00059796','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-02-03 17:54:54.000',NULL,'2021-02-03 18:05:41.000','2022-03-14 18:58:49.000','2022-03-14 14:58:49.000'),('d1e0dfb3-dfae-44c1-bc78-262071ed615d',664,'d7b86e87-0261-4bc1-8529-76e0bdd29195','MAXILLAIRE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-24 16:53:49.000','2022-08-24 17:06:09.000','2022-08-24 16:53:49.000','2022-08-24 21:06:09.000',NULL),('d2853a7d-9edf-4ac8-aeaa-d186ea3a6553',664,'7d36e059-dbc3-46b0-931a-bdf8fdc805c6','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-21 16:29:35.000',NULL,'2021-04-21 16:32:10.000','2022-03-14 18:58:59.000','2022-03-14 14:58:59.000'),('d2f412b1-d898-4258-b15c-ad3be926be61',664,'0f4d3a0e-7431-47c6-b459-92fae651b233','MORDU_ANTERIEUR','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-23 16:49:08.000','2022-03-23 16:49:10.000','2022-03-23 16:49:08.000','2022-03-23 20:49:10.000',NULL),('d3d5ecdb-7933-478d-8f71-7bc13b2a4a05',664,'7348646e-cf7a-460b-aba9-d56ad656689e','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-09-14 11:48:23.000','2022-03-14 09:42:19.000','2021-09-14 11:55:42.000','2024-10-31 14:02:25.514','2024-10-31 10:02:25.514'),('d430aee6-4975-49d0-b4c3-b096e99e797e',664,'cacc103c-8b88-4be5-a787-b6b92341e9eb','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-05-25 18:01:13.000',NULL,'2022-05-25 18:02:50.000','2022-05-25 22:02:55.000','2022-05-25 18:02:55.000'),('d4321e90-28f8-42a0-bde1-b9ddcf321fa8',664,'2c19cd55-a36e-4dc7-8954-ea8a8eeacd16','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-01-18 17:20:05.000',NULL,'2021-01-21 18:30:41.000','2022-03-14 18:58:56.000','2022-03-14 14:58:56.000'),('d43bd9e0-44ee-49ed-aa89-8bcd9837b34a',664,'d7b86e87-0261-4bc1-8529-76e0bdd29195','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-24 16:39:34.000',NULL,'2022-08-24 16:45:00.000','2022-08-24 20:45:04.000','2022-08-24 16:45:04.000'),('d43d2f74-b865-479d-9d28-720cf11a8968',664,'13883510-ca59-4fdd-8bbd-216ef177542a','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-10-04 18:12:34.000',NULL,'2021-10-04 18:12:34.000','2022-03-14 18:59:11.000','2022-03-14 14:59:11.000'),('d5c1d30b-d8a4-4e8f-aae4-1e8dd2cb3dcb',664,'ae7f89c9-26ec-4cee-b377-d5145e6c6aae','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-14 17:09:36.000','2022-11-14 17:34:15.000','2022-11-14 17:17:38.000','2022-11-14 22:34:15.000','2022-11-14 17:34:15.000'),('d68295a5-6905-4f30-bc58-3732946b2594',664,'540d878b-7415-4498-8c6c-01875eec35f8','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-22 16:44:36.000',NULL,'2022-06-22 16:46:04.000','2022-06-22 20:46:07.000','2022-06-22 16:46:07.000'),('d7e952db-9527-4a27-a3cb-76863aa4d0de',664,'9a395a3e-4872-409e-922b-4bb58053d8a5','MANDIBULE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-21 15:32:42.000',NULL,'2022-08-22 15:08:59.000','2022-08-22 19:09:00.000','2022-08-22 15:09:00.000'),('d8bbea0f-8405-4d13-8995-46a51be77eb1',664,'540d878b-7415-4498-8c6c-01875eec35f8','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-22 16:40:40.000','2022-06-22 16:50:27.000','2022-06-22 16:43:53.000','2022-06-22 20:50:27.000','2022-06-22 16:50:27.000'),('d94301ea-1f19-432a-a87d-bacbf222ca15',664,'7d36e059-dbc3-46b0-931a-bdf8fdc805c6','MANDIBULE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-21 16:15:38.000',NULL,'2021-04-21 16:23:45.000','2022-03-14 18:58:58.000','2022-03-14 14:58:58.000'),('ddf6985f-5bc1-11ee-9658-58a023cda0dc',664,'eed0dd8b-572c-11ee-a378-58a023cda0dc','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-09-25 12:37:50.000',NULL,'2023-09-25 12:41:09.000','2024-10-31 14:02:36.433','2024-10-31 10:02:36.433'),('ded5bf87-2d2f-4e7b-9412-2ebc20e81246',664,'cacc103c-8b88-4be5-a787-b6b92341e9eb','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-05-25 15:19:39.000',NULL,'2022-05-25 15:19:39.000','2022-05-25 21:44:28.000','2022-05-25 17:44:28.000'),('ded778b4-0eef-4984-8f57-77502f727676',664,'21bbefd5-8dc0-4e41-91d8-718463ad469c','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-03 15:50:05.000','2022-08-03 16:06:40.000','2022-08-03 16:05:45.000','2022-08-03 20:06:40.000','2022-08-03 16:06:40.000'),('e0fe2abf-8a0e-43f6-a437-3901a1d00a73',664,'8cd0c724-d3d0-4821-a88b-42b03ae4eb07','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-17 17:04:23.000',NULL,'2022-10-17 17:05:26.000','2022-10-17 21:05:40.000','2022-10-17 17:05:40.000'),('e145920a-617c-4eab-b810-0a863371eb36',664,'540d878b-7415-4498-8c6c-01875eec35f8','MANDIBULE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-06-22 16:51:18.000',NULL,'2022-06-22 16:56:23.000','2022-06-22 20:56:26.000','2022-06-22 16:56:26.000'),('e1f9f752-dd61-4e2b-82d8-016edf9173cf',664,'a12bd271-974e-4fcf-8893-d88105690bce','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-28 16:55:55.000',NULL,'2021-04-28 17:12:17.000','2022-03-14 18:59:02.000','2022-03-14 14:59:02.000'),('e2bb3a77-9462-11ee-8fd8-58a023cda0dc',664,'d4b9a9b2-9462-11ee-8fd8-58a023cda0dc','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-12-06 13:11:32.000',NULL,'2023-12-06 14:12:08.000','2024-10-31 14:02:37.463','2024-10-31 10:02:37.463'),('e330a0d0-9251-48dc-b797-93306c58025a',664,'e78fa40a-0a61-4104-adb2-0cfd70d69414','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-23 14:00:12.000','2022-03-23 14:13:42.000','2022-03-23 14:00:12.000','2022-03-23 18:13:42.000',NULL),('e64276ae-1a8c-45bd-adaa-f04086ada9e7',664,'e98b0c01-9e79-49e0-9ab8-0d6f432bf80d','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-01 15:25:46.000','2022-08-01 15:32:45.000','2022-08-01 15:27:12.000','2022-08-01 19:32:45.000','2022-08-01 15:32:45.000'),('e7c95c67-ccda-41e6-a581-e41824f1239b',664,'7d40798f-7207-4c33-aa42-10afc814de77','MORDU_POSTERIEUR_DROIT','SCAN',1,'IN_PROGRESS',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-07-03 16:43:33.000',NULL,'2022-08-22 14:50:24.000','2022-08-22 18:50:27.000','2022-08-22 14:50:27.000'),('e7e2772e-44c2-4784-a6ad-d32f7f25572d',664,'a2816a91-70d4-492e-af69-b69e3c134704','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-05-03 20:51:39.000','2021-05-03 21:04:47.000','2021-05-03 20:51:39.000','2021-05-04 01:04:47.000',NULL),('e9d28438-fc8d-418d-a806-97e97ad7a3c0',664,'13883510-ca59-4fdd-8bbd-216ef177542a','MAXILLAIRE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-10-04 18:18:35.000','2021-10-04 18:39:33.000','2021-10-04 18:18:35.000','2021-10-04 22:39:33.000',NULL),('ec2d4010-6686-4b96-af72-0ece2b145c0d',664,'0bc33ddd-4b68-4d70-b44e-f8a4f2ad9ea6','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-11-30 02:14:43.000',NULL,'2022-08-22 14:57:26.000','2022-08-22 18:57:29.000','2022-08-22 14:57:29.000'),('ec42315e-bad9-44b4-bfd3-e86342727df2',664,'cacc103c-8b88-4be5-a787-b6b92341e9eb','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-05-25 17:59:45.000',NULL,'2022-05-25 18:01:07.000','2022-05-25 22:01:10.000','2022-05-25 18:01:10.000'),('ec557b87-5cb1-4e74-9d71-d45c543b3847',664,'9a395a3e-4872-409e-922b-4bb58053d8a5','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-21 15:03:22.000',NULL,'2022-08-22 15:08:37.000','2022-08-22 19:08:38.000','2022-08-22 15:08:38.000'),('ec70dd1f-5648-4918-9bce-b3384aeae579',664,'d7b86e87-0261-4bc1-8529-76e0bdd29195','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-24 16:47:42.000','2022-08-24 16:53:45.000','2022-08-24 16:52:47.000','2022-08-24 20:53:45.000','2022-08-24 16:53:45.000'),('ec92e295-bf7c-4746-b7d5-8b1307a8e6ac',664,'8d9c33a0-de56-424c-93dc-582bac72d320','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-28 18:54:14.000',NULL,'2021-04-28 18:56:21.000','2022-03-14 18:58:52.000','2022-03-14 14:58:52.000'),('ecc7eed2-a208-481f-96f9-cf1170a7c65e',664,'d0806a0e-930a-42be-84bd-2f32d9e80838','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-06-21 18:02:19.000','2021-06-21 18:06:48.000','2021-06-21 18:02:19.000','2021-06-21 22:06:48.000',NULL),('ed2e9eef-7d26-4fe4-95e3-86525e036935',664,'8cd0c724-d3d0-4821-a88b-42b03ae4eb07','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-17 16:49:19.000','2022-10-17 16:49:23.000','2022-10-17 16:49:19.000','2022-10-17 20:49:23.000',NULL),('ed845142-2dca-48e8-8ec9-cc1f6a86f8cb',664,'ac54a8f4-14f1-4e2d-8dcb-34ef57bfc13e','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-10-31 17:15:57.000','2022-10-31 17:21:56.000','2022-10-31 17:17:03.000','2022-10-31 21:21:56.000','2022-10-31 17:21:56.000'),('ee9462c8-7341-11ee-b011-58a023cda0dc',664,'ecbe814b-7341-11ee-b011-58a023cda0dc','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-25 10:22:30.000',NULL,'2023-10-25 11:27:30.000','2024-10-31 14:02:36.556','2024-10-31 10:02:36.556'),('ef34ef6f-c00c-49e4-85b3-2c0aed9adcc0',664,'cacc103c-8b88-4be5-a787-b6b92341e9eb','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-05-25 17:45:09.000',NULL,'2022-05-25 17:55:06.000','2022-05-25 21:55:10.000','2022-05-25 17:55:10.000'),('eff3d296-ab91-4054-b8d3-6c78732ae1c8',664,'8d9c33a0-de56-424c-93dc-582bac72d320','MAXILLAIRE','SCAN',1,'NONE',4,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-28 18:43:28.000',NULL,'2021-04-28 18:51:57.000','2022-03-14 18:58:51.000','2022-03-14 14:58:51.000'),('f0f641b9-1642-4e74-912a-b9b018080051',664,'b9c2b952-8d0a-4eac-ad77-2acda79cff8c','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-17 18:25:09.000',NULL,'2022-08-17 18:25:09.000','2022-08-17 22:28:24.000','2022-08-17 18:28:24.000'),('f23ef241-b3d2-40c3-8f2d-1f815adfca52',664,'d7b86e87-0261-4bc1-8529-76e0bdd29195','MAXILLAIRE','SCAN',1,'NONE',4,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-24 17:06:25.000',NULL,'2022-08-24 17:12:19.000','2022-08-24 21:12:23.000','2022-08-24 17:12:23.000'),('f302aa8d-2622-46fc-8bda-0ab3117eb53b',664,'1256ab02-5172-4a92-a17d-f2fc402290ac','MAXILLAIRE','SCAN',1,'NONE',3,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-05-05 15:57:48.000','2021-05-05 16:13:11.000','2021-05-05 15:57:48.000','2021-05-05 20:13:11.000',NULL),('f3804f47-734c-11ee-b011-58a023cda0dc',664,'07e5f91d-734b-11ee-b011-58a023cda0dc','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2023-10-25 11:41:23.000',NULL,'2023-10-25 11:59:30.000','2024-10-31 14:02:37.322','2024-10-31 10:02:37.322'),('f40ef765-344e-4e93-b47e-d26b4b6db487',664,'e78fa40a-0a61-4104-adb2-0cfd70d69414','MAXILLAIRE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-03-23 14:13:53.000',NULL,'2022-03-23 14:32:56.000','2022-03-23 18:33:15.000','2022-03-23 14:33:15.000'),('f7ca22c1-70d3-4f9e-8ccd-3187aea91801',664,'1f19aa7f-35eb-4878-b743-abbe8cf73f08','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-04-18 19:22:07.000',NULL,'2020-04-18 19:22:07.000','2022-03-14 18:58:48.000','2022-03-14 14:58:48.000'),('f7d86e35-41e6-4047-8f44-4a7b73bc2680',664,'ae7f89c9-26ec-4cee-b377-d5145e6c6aae','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-11-14 18:17:51.000',NULL,'2022-11-14 18:20:21.000','2022-11-14 23:20:25.000','2022-11-14 18:20:25.000'),('f892ac47-3d8b-454c-bb8d-03b934505f9a',664,'120f9fe3-b23d-49c7-89ab-f1becc102f6c','MAXILLAIRE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-04-11 16:39:52.000','2022-04-11 16:48:38.000','2022-04-11 16:39:52.000','2022-04-11 20:48:38.000',NULL),('f99691b6-3bf9-4760-8115-1d1a52fc98ae',664,'7d36e059-dbc3-46b0-931a-bdf8fdc805c6','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-04-21 16:24:31.000',NULL,'2021-04-21 16:26:16.000','2022-03-14 18:58:58.000','2022-03-14 14:58:58.000'),('fdcb8fba-f16b-457a-8027-7f34eeace00b',664,'bf823edb-92ee-4ee9-acd3-507d49bad781','MORDU_POSTERIEUR_DROIT','SCAN',1,'IN_PROGRESS',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2020-09-09 15:50:20.000',NULL,'2022-08-22 15:01:56.000','2022-08-22 19:01:58.000','2022-08-22 15:01:58.000'),('fe5df0bd-7cd7-42f8-ba75-4278d329b237',664,'4d46a627-5949-4b2a-b4d6-c391f159485b','MANDIBULE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-09-12 20:27:25.000',NULL,'2022-09-12 20:32:10.000','2022-09-13 00:32:15.000','2022-09-12 20:32:15.000'),('fecdd55c-c22a-4e46-835e-a5780e62f261',664,'13883510-ca59-4fdd-8bbd-216ef177542a','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2021-10-04 19:06:10.000',NULL,'2021-10-04 19:07:18.000','2022-03-14 18:59:09.000','2022-03-14 14:59:09.000'),('ffb4d4c8-4774-4512-bb36-ac65c37d00a5',664,'775311e4-a561-40c7-a2ce-76a0b1550be8','MANDIBULE','SCAN',1,'NONE',2,0,'','f01a2b76-66cc-4161-908b-fc9d31389d9c','f01a2b76-66cc-4161-908b-fc9d31389d9c','2022-08-01 14:34:57.000',NULL,'2022-08-01 14:34:57.000','2022-08-01 18:35:03.000','2022-08-01 14:35:03.000');
/*!40000 ALTER TABLE `Scan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ScanFile`
--

DROP TABLE IF EXISTS `ScanFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ScanFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `scanId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('MODEL','SNAPSHOT','SCREENSHOT','LIFI','LIFIMETA') NOT NULL,
  PRIMARY KEY (`scanId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ScanFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_2` FOREIGN KEY (`scanId`) REFERENCES `Scan` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ScanFile`
--

LOCK TABLES `ScanFile` WRITE;
/*!40000 ALTER TABLE `ScanFile` DISABLE KEYS */;
INSERT INTO `ScanFile` VALUES (664,'00462b4b-7b16-4a6c-aaef-5da516ac1f81','7e92b49e-bc5f-4233-9657-58c0df873f81','MODEL'),(664,'00462b4b-7b16-4a6c-aaef-5da516ac1f81','e31b565c-6205-4cad-ac46-f9268d3838c0','SNAPSHOT'),(664,'02523859-58d9-4417-a657-9de246f248ae','6184838a-83fc-4590-8e86-06602269b835','MODEL'),(664,'02523859-58d9-4417-a657-9de246f248ae','f97c6eef-a142-496a-ae7e-c91c3f7c2cc6','SNAPSHOT'),(664,'041ad44a-6c35-11ee-bc7f-58a023cda0dc','19eba3d6-6c36-11ee-bc7f-58a023cda0dc','MODEL'),(664,'041ad44a-6c35-11ee-bc7f-58a023cda0dc','19ec321c-6c36-11ee-bc7f-58a023cda0dc','SNAPSHOT'),(664,'041ad44a-6c35-11ee-bc7f-58a023cda0dc','9122eeb5-6c35-11ee-bc7f-58a023cda0dc','MODEL'),(664,'041ad44a-6c35-11ee-bc7f-58a023cda0dc','9122ff07-6c35-11ee-bc7f-58a023cda0dc','SNAPSHOT'),(664,'041ad44a-6c35-11ee-bc7f-58a023cda0dc','abee95d7-6c35-11ee-bc7f-58a023cda0dc','MODEL'),(664,'056c711b-f9d5-4a04-93e2-9015a27c4b1b','a8a6a645-3d3c-4deb-985b-aa5de9ebf41a','MODEL'),(664,'056c711b-f9d5-4a04-93e2-9015a27c4b1b','cba0f817-6c67-4486-a5a5-2e40973bf3af','SNAPSHOT'),(664,'0760cff5-4209-42a6-8b7f-d0a749485c14','5e5384eb-0822-41cf-9105-f8761f20244b','MODEL'),(664,'0760cff5-4209-42a6-8b7f-d0a749485c14','a540af64-2782-40e1-98e6-71a1da04b4e8','MODEL'),(664,'0760cff5-4209-42a6-8b7f-d0a749485c14','ad7e808e-aadc-4d5b-b4af-172295eb3c6d','SNAPSHOT'),(664,'0760cff5-4209-42a6-8b7f-d0a749485c14','c9b5fd6b-936f-473b-820c-1d017ed47794','SNAPSHOT'),(664,'088e0b86-45b9-4da8-a5e2-291e2939c699','2aea6708-c584-4dd6-9f2b-3d381bae0dc7','SCREENSHOT'),(664,'088e0b86-45b9-4da8-a5e2-291e2939c699','5895fa2b-1f6a-44ac-8137-84d879d48bff','MODEL'),(664,'088e0b86-45b9-4da8-a5e2-291e2939c699','9ea10de3-7b53-4d02-b15e-bca6ff87a015','SCREENSHOT'),(664,'088e0b86-45b9-4da8-a5e2-291e2939c699','cc17514d-dd52-4b75-b524-fe6d1ad21101','SNAPSHOT'),(664,'09b06474-154e-4302-9e89-9d9e6fcb8cfa','a2099383-c46f-4a74-835e-82ef97668988','SNAPSHOT'),(664,'09b06474-154e-4302-9e89-9d9e6fcb8cfa','ccfc256c-f67b-43e6-859d-78f6db34fd4b','MODEL'),(664,'0a1eb92c-734f-11ee-b011-58a023cda0dc','40d7a1b0-734f-11ee-b011-58a023cda0dc','MODEL'),(664,'0a1eb92c-734f-11ee-b011-58a023cda0dc','40d7b163-734f-11ee-b011-58a023cda0dc','SNAPSHOT'),(664,'0a8db60a-fa38-11ed-8f6c-58a023cda0dc','29d0bfad-fa3a-11ed-8f6c-58a023cda0dc','MODEL'),(664,'0a8db60a-fa38-11ed-8f6c-58a023cda0dc','29d0ce9e-fa3a-11ed-8f6c-58a023cda0dc','SNAPSHOT'),(664,'0a8db60a-fa38-11ed-8f6c-58a023cda0dc','479d4813-fa39-11ed-8f6c-58a023cda0dc','MODEL'),(664,'0a8db60a-fa38-11ed-8f6c-58a023cda0dc','479d57d2-fa39-11ed-8f6c-58a023cda0dc','SNAPSHOT'),(664,'0a8db60a-fa38-11ed-8f6c-58a023cda0dc','9e6e9cb1-fa39-11ed-8f6c-58a023cda0dc','MODEL'),(664,'0a8db60a-fa38-11ed-8f6c-58a023cda0dc','9e6eac90-fa39-11ed-8f6c-58a023cda0dc','SNAPSHOT'),(664,'0f570c2a-6540-11ef-b382-58a023cda0dc','5d0397fc-6540-11ef-b382-58a023cda0dc','MODEL'),(664,'0f570c2a-6540-11ef-b382-58a023cda0dc','5d03a767-6540-11ef-b382-58a023cda0dc','SNAPSHOT'),(664,'101a958b-c6e0-45d2-be43-01921415b27e','1338119f-9ce3-4264-ad6d-a8bbebdb19e6','MODEL'),(664,'101a958b-c6e0-45d2-be43-01921415b27e','1ca966ee-f717-4668-9ce5-c95a9a20eaff','MODEL'),(664,'101a958b-c6e0-45d2-be43-01921415b27e','2f25d63d-8f7a-450f-88d0-b04235143181','SNAPSHOT'),(664,'101a958b-c6e0-45d2-be43-01921415b27e','5b36e531-e913-4694-bd29-6c238ddae336','SNAPSHOT'),(664,'102e062c-07cd-49ca-b2d8-4050c1eb56ee','46f8ac26-642f-40b5-a4f3-fbed00c6cc75','MODEL'),(664,'102e062c-07cd-49ca-b2d8-4050c1eb56ee','8fc85d95-e52c-40f1-91d6-38e3efcede21','SNAPSHOT'),(664,'13a263f2-8a0a-409b-a3c1-f2ddb5f6a466','74cbcc03-20d0-488e-89d0-9f502483117a','MODEL'),(664,'13a263f2-8a0a-409b-a3c1-f2ddb5f6a466','d172973d-e407-4b2d-a3d4-a9faaa303da6','SNAPSHOT'),(664,'1642c8fb-5963-4064-9b58-acef4374ce2b','9963e44b-40c3-4e29-8123-4685327fc471','MODEL'),(664,'1642c8fb-5963-4064-9b58-acef4374ce2b','cc11802a-1512-4adc-a5b0-52572343c7b1','SNAPSHOT'),(664,'1642c8fb-5963-4064-9b58-acef4374ce2b','d0bcb772-695a-4912-a5a9-77dd0eb49a1a','MODEL'),(664,'1642c8fb-5963-4064-9b58-acef4374ce2b','ee724439-7aa0-434a-97b2-80e2b9080408','SNAPSHOT'),(664,'17461a17-6c34-11ee-bc7f-58a023cda0dc','fcb6f107-6c34-11ee-bc7f-58a023cda0dc','MODEL'),(664,'17461a17-6c34-11ee-bc7f-58a023cda0dc','fcb700b3-6c34-11ee-bc7f-58a023cda0dc','SNAPSHOT'),(664,'18f2b293-9073-44fe-91a3-d166f9249cbc','a77a332b-8797-48b4-bfe8-83dea8c5628b','SNAPSHOT'),(664,'18f2b293-9073-44fe-91a3-d166f9249cbc','ad556326-2de3-4a75-8afb-a05dac39719f','MODEL'),(664,'19fe3d64-fac4-4182-90d9-fb19f29bc385','5fd9a4c4-c58e-41b8-893c-31ce5772a9da','MODEL'),(664,'19fe3d64-fac4-4182-90d9-fb19f29bc385','e719c521-9b47-43b0-bae0-5d5b40b4609e','SNAPSHOT'),(664,'1c8acfc2-fa3b-11ed-8f6c-58a023cda0dc','50cb8a2b-fa3b-11ed-8f6c-58a023cda0dc','MODEL'),(664,'1c8acfc2-fa3b-11ed-8f6c-58a023cda0dc','50cb99a8-fa3b-11ed-8f6c-58a023cda0dc','SNAPSHOT'),(664,'1d1515dc-8da4-4b0c-83dc-d1599e5f76cf','04156d5e-49b6-4518-b4b7-1f709a431367','SNAPSHOT'),(664,'1d1515dc-8da4-4b0c-83dc-d1599e5f76cf','961b1c26-009d-415b-b3e0-e5f95a643091','MODEL'),(664,'1d68ce03-d68e-49cb-9d0b-9b1f51edadbb','29aded90-0cc8-4df4-bbd6-05692b125871','MODEL'),(664,'1d68ce03-d68e-49cb-9d0b-9b1f51edadbb','2c6d1dc9-5356-4ee2-944f-ea885f0b032b','SNAPSHOT'),(664,'1fad60ca-f3ea-48a3-b845-fcd52ee435b5','09c6909f-b484-4ce8-866d-734aef82c225','SCREENSHOT'),(664,'1fad60ca-f3ea-48a3-b845-fcd52ee435b5','22722603-2c83-4ed0-858c-6d2be0ae48a9','SNAPSHOT'),(664,'1fad60ca-f3ea-48a3-b845-fcd52ee435b5','4a4a6589-8149-4485-ab1f-6603d976f58e','MODEL'),(664,'1fad60ca-f3ea-48a3-b845-fcd52ee435b5','a1591c1d-cdd9-4272-8ead-fd819fb859d2','SCREENSHOT'),(664,'20f1e04b-48d2-4b9a-b29b-2a62332288fb','5f587583-02ae-40f7-97af-d3cf1fd26edb','SNAPSHOT'),(664,'20f1e04b-48d2-4b9a-b29b-2a62332288fb','cfd3ae4f-746d-45ea-8e9c-5628349609fd','MODEL'),(664,'210ee6b9-1960-43ea-a220-cfa20b762017','0ed482bd-7b1d-4b10-a2ee-e745bb925cc5','SNAPSHOT'),(664,'210ee6b9-1960-43ea-a220-cfa20b762017','7a1fe436-356c-4301-bcb4-d66dbeff4a68','MODEL'),(664,'21c82eed-acf4-4093-986f-a306c3e0c043','6017b07e-9997-4cd7-9d25-35063c26e897','SNAPSHOT'),(664,'21c82eed-acf4-4093-986f-a306c3e0c043','670e4cd5-deb9-4439-bb01-01da02cc1a1f','MODEL'),(664,'21c82eed-acf4-4093-986f-a306c3e0c043','923d8e02-07de-4a6f-b0d0-df13d765b4c1','MODEL'),(664,'21c82eed-acf4-4093-986f-a306c3e0c043','c4c91852-4807-43b3-8a79-23452bff9563','SNAPSHOT'),(664,'27ffc744-9a52-49aa-a247-2801d6cd8ff9','0a4f0eb8-9b72-4c8c-a19e-7bc735b02be1','MODEL'),(664,'27ffc744-9a52-49aa-a247-2801d6cd8ff9','ab3eb0ec-fe6a-446c-aeb2-a6ebd6c1e601','SNAPSHOT'),(664,'2b878881-6c32-11ee-bc7f-58a023cda0dc','e5b40fb0-6c32-11ee-bc7f-58a023cda0dc','MODEL'),(664,'2b878881-6c32-11ee-bc7f-58a023cda0dc','e5b41f42-6c32-11ee-bc7f-58a023cda0dc','SNAPSHOT'),(664,'2c6eb2a3-6697-4912-9947-5c2b5f942eb8','b5f6a1ce-86fb-467c-aa18-d4e1f5594aac','SNAPSHOT'),(664,'2c6eb2a3-6697-4912-9947-5c2b5f942eb8','e5aef4d2-31a2-46d6-baad-9f8289109763','MODEL'),(664,'300a55b7-e679-4993-b375-e0a3fe68f61d','36bd52fc-3960-496c-aef2-4b689b6c0fd3','SCREENSHOT'),(664,'300a55b7-e679-4993-b375-e0a3fe68f61d','43625627-0f37-4d61-80ec-3a5cfe5409a4','SNAPSHOT'),(664,'300a55b7-e679-4993-b375-e0a3fe68f61d','5d5f4518-2d25-4373-8c05-e40c2e52e93d','MODEL'),(664,'300a55b7-e679-4993-b375-e0a3fe68f61d','6d5eff2a-0237-4ef2-9b70-904ad7378b7c','MODEL'),(664,'300a55b7-e679-4993-b375-e0a3fe68f61d','860b8bfc-91cf-4879-9b67-96ce35dffe8b','SNAPSHOT'),(664,'30be6697-331a-4e7d-8bba-b11fc9ec90b9','18cada8e-d04a-4eb7-8754-1c78819104c6','MODEL'),(664,'30be6697-331a-4e7d-8bba-b11fc9ec90b9','526c1caf-5adb-42e3-917d-6ce859cd016f','SNAPSHOT'),(664,'30fee8be-9838-11ee-86e7-58a023cda0dc','bca84273-9838-11ee-86e7-58a023cda0dc','MODEL'),(664,'30fee8be-9838-11ee-86e7-58a023cda0dc','bca8530d-9838-11ee-86e7-58a023cda0dc','SNAPSHOT'),(664,'316dc371-d779-45ec-913c-3647da5917c2','a5d050d7-c6c8-47b6-a5c2-168e8fdbf905','SNAPSHOT'),(664,'316dc371-d779-45ec-913c-3647da5917c2','c87746da-76e6-42d0-aa1a-53cd19375318','MODEL'),(664,'3241a487-3527-47d6-93c9-bad3ce6f6d24','05a673f7-2845-4bda-810e-138d2f78652c','MODEL'),(664,'3241a487-3527-47d6-93c9-bad3ce6f6d24','0f760deb-e643-4ca8-9cba-0f4c1b4da06b','SNAPSHOT'),(664,'33332418-f712-49fd-833e-f2b6ad37b61e','abe3d489-e27c-4ef9-bba3-b62ed55c8c9b','SNAPSHOT'),(664,'33332418-f712-49fd-833e-f2b6ad37b61e','d3a6ed76-d8dc-47e6-ae66-239731164381','MODEL'),(664,'34ec8b9f-9839-11ee-86e7-58a023cda0dc','99be3996-9839-11ee-86e7-58a023cda0dc','MODEL'),(664,'34ec8b9f-9839-11ee-86e7-58a023cda0dc','99be4912-9839-11ee-86e7-58a023cda0dc','SNAPSHOT'),(664,'3558dd42-4c4f-44fb-9e18-6c3609025ffc','61fa2c39-4c85-4ea9-b705-312c82b6b8cf','SNAPSHOT'),(664,'3558dd42-4c4f-44fb-9e18-6c3609025ffc','9b387987-e8a0-44b3-a6d7-f5768d6c1991','MODEL'),(664,'39c9ba47-6b25-4333-a5cf-b8988930cdd8','7daf99fd-27e4-4724-8ff7-e3ce87982137','SNAPSHOT'),(664,'39c9ba47-6b25-4333-a5cf-b8988930cdd8','8079e323-06a0-4f3d-aceb-723f10a814a8','MODEL'),(664,'3afaae5b-fc7f-46be-b019-7206b27b05a8','40789477-ac02-407a-977c-e67e93de93e8','SNAPSHOT'),(664,'3afaae5b-fc7f-46be-b019-7206b27b05a8','e237cc6f-1a56-4185-8656-d1fe784dc0ef','MODEL'),(664,'3b924f2a-18f4-4ed4-8e4e-efb6a1b36439','52059c48-e3a3-4bd6-8fcc-9746f5a7da5b','MODEL'),(664,'3b924f2a-18f4-4ed4-8e4e-efb6a1b36439','5842bacb-24f3-4473-8d2f-ca5548e651cf','SNAPSHOT'),(664,'3b924f2a-18f4-4ed4-8e4e-efb6a1b36439','a685a8d2-db8d-41c7-9651-468bdf6230ed','MODEL'),(664,'3b924f2a-18f4-4ed4-8e4e-efb6a1b36439','af351e93-da3e-41df-8372-3b3bacbcfcaf','SNAPSHOT'),(664,'3ce0c78e-551a-4871-80c4-435836bf1dc5','5f456e24-d7a0-4914-86d8-b3fd9c64f460','SNAPSHOT'),(664,'3ce0c78e-551a-4871-80c4-435836bf1dc5','69340322-ace1-4247-abd4-90fd70f47a5c','SCREENSHOT'),(664,'3ce0c78e-551a-4871-80c4-435836bf1dc5','838a7ccd-cc6e-4939-812b-73553d4877f6','SNAPSHOT'),(664,'3ce0c78e-551a-4871-80c4-435836bf1dc5','b22b5006-4b81-4653-ad5b-9f9f5eeebf0c','SCREENSHOT'),(664,'3ce0c78e-551a-4871-80c4-435836bf1dc5','b3ec6691-f3e0-41f5-ae89-5336966f4cac','MODEL'),(664,'3ce0c78e-551a-4871-80c4-435836bf1dc5','bd0f2665-9713-4244-9406-40e7630407de','MODEL'),(664,'3ce0c78e-551a-4871-80c4-435836bf1dc5','ca096ce2-28fc-48e7-ac12-8bc56ab4e9d5','SCREENSHOT'),(664,'3d2db1ee-26fa-4508-8e14-b81d51746da7','18f54255-3e96-4924-b5d7-59e7498363b8','MODEL'),(664,'3d2db1ee-26fa-4508-8e14-b81d51746da7','19447343-7012-4518-98de-fd28c421573a','SNAPSHOT'),(664,'3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20','2f53f156-ebc8-4731-8fd4-a827d477aba1','LIFIMETA'),(664,'3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20','42637d2d-50b1-4ef7-a0ae-40aef183b97e','LIFI'),(664,'3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20','4a198bf7-bf34-454b-b570-7cf6168b7a8f','LIFI'),(664,'3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20','67975c64-090d-427e-b49e-b2887c0f4e98','LIFI'),(664,'3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20','69731f43-c0fd-48a8-8047-733b892d60b8','LIFIMETA'),(664,'3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20','87dfac30-53df-454b-9f86-51b25ace7056','LIFI'),(664,'3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20','a3e7e135-bb5d-480a-ad23-66fef52084cd','SNAPSHOT'),(664,'3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20','c3ba59bf-d6c1-4148-b9f2-a2a974828687','MODEL'),(664,'3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20','ccbcf45f-51df-46cb-aa4d-44d48924646f','LIFIMETA'),(664,'3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20','d9da262b-a026-4f41-a285-552ed1c7e69b','LIFIMETA'),(664,'3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20','dc509fe6-76b9-4554-9199-4c7014501ff8','LIFIMETA'),(664,'3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20','dee489cd-6acd-4bad-9ed8-f0990f83d6cc','LIFI'),(664,'3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20','ed062015-5ce9-4d64-a982-e1d9ccfc2c5f','LIFIMETA'),(664,'3d6a3ddb-dcbc-4ca2-8c4d-79eb57174b20','f7956a29-1664-4e5a-9aad-2a53021be43e','LIFI'),(664,'3e328cc1-9830-466d-a33e-fbe74a2dbdae','1b1a8a57-1029-46b5-a7be-4571a989667f','SNAPSHOT'),(664,'3e328cc1-9830-466d-a33e-fbe74a2dbdae','6fe89eae-9acf-496c-87c2-5d7d789669bd','MODEL'),(664,'3eaba63c-ff17-453d-ab22-bc8e747a4ce5','05a2d88e-2c85-462a-907f-7184b78eb8f5','SNAPSHOT'),(664,'3eaba63c-ff17-453d-ab22-bc8e747a4ce5','39d577ce-6560-4cdf-8d00-711c2b1598e9','MODEL'),(664,'3ef1c403-4f23-4240-9474-8d8f45c283b5','052b521c-e4e5-43db-a857-367b074e72d3','SNAPSHOT'),(664,'3ef1c403-4f23-4240-9474-8d8f45c283b5','470c8a58-eeb8-459d-a26d-c4967dbea19f','MODEL'),(664,'406263f6-a620-460e-a1e0-2d50ff84809c','14d352f5-8d3b-486a-91ed-aa2fa3f126fd','SNAPSHOT'),(664,'406263f6-a620-460e-a1e0-2d50ff84809c','607ef93e-cc9b-4019-ab49-d0f0e598ea16','SCREENSHOT'),(664,'406263f6-a620-460e-a1e0-2d50ff84809c','6e6f5ec1-9749-41d4-9cf9-d9f1b5307d64','SCREENSHOT'),(664,'406263f6-a620-460e-a1e0-2d50ff84809c','99602643-4adf-4f72-936c-b7c9e84e9ca5','MODEL'),(664,'40fd847e-fa3a-11ed-8f6c-58a023cda0dc','0b7d3aba-fa3b-11ed-8f6c-58a023cda0dc','MODEL'),(664,'40fd847e-fa3a-11ed-8f6c-58a023cda0dc','0b7d4a0a-fa3b-11ed-8f6c-58a023cda0dc','SNAPSHOT'),(664,'416dd268-693a-4466-8380-8829fc1b5e3d','3de35365-8be7-4c5d-9d56-903f8e272986','MODEL'),(664,'416dd268-693a-4466-8380-8829fc1b5e3d','cb94779c-19a4-4878-a144-6b913d80c161','SNAPSHOT'),(664,'428484bf-df10-43b1-a7ed-6f2f0ac47336','6887579a-3781-49f4-a96e-de18760adf09','MODEL'),(664,'428484bf-df10-43b1-a7ed-6f2f0ac47336','a4fd2b33-3d5e-4e47-96d4-f1c6e8db2f68','SNAPSHOT'),(664,'4352d5ab-e3b9-4f1f-9fb2-e12036db1127','3a3b5737-833e-4b06-b2f1-93127aa3e05a','SNAPSHOT'),(664,'4352d5ab-e3b9-4f1f-9fb2-e12036db1127','d8f7c98c-8b39-4c9f-b7dd-93788bb51484','MODEL'),(664,'44749597-6cc6-493d-a2aa-76486e3c8416','1b9fcd61-76d3-43bc-9436-552fe11a8a71','SNAPSHOT'),(664,'44749597-6cc6-493d-a2aa-76486e3c8416','b3abd969-6b20-48f6-9d4d-0fb8e4e2a650','MODEL'),(664,'44749597-6cc6-493d-a2aa-76486e3c8416','e9a1cf3e-9639-4ec7-8417-34a46ed30e75','SCREENSHOT'),(664,'449b7a19-bb82-4d6f-82b8-8bec06fa85d9','1468c4b0-ae65-4fd5-aa19-3097eda12337','SCREENSHOT'),(664,'449b7a19-bb82-4d6f-82b8-8bec06fa85d9','23d0f00e-28e6-4e95-acb1-832d1d3440c2','MODEL'),(664,'449b7a19-bb82-4d6f-82b8-8bec06fa85d9','d7259e03-f436-4b58-aeb9-cea3bf0a1d04','SNAPSHOT'),(664,'456ba968-983a-4ece-9df6-11392894a534','2b6df65f-bc4e-4e8b-bfb9-2335bd73430a','MODEL'),(664,'456ba968-983a-4ece-9df6-11392894a534','4d8982bd-2be0-44d1-b3dc-a68b3d43dca9','SNAPSHOT'),(664,'4597ad8c-2f54-4ecd-827f-911125d72cc9','212de007-9a7d-46d7-88bb-dfd2fc9e1422','SNAPSHOT'),(664,'4597ad8c-2f54-4ecd-827f-911125d72cc9','af1a4b3f-83d9-45e8-9fb8-748962f1978e','MODEL'),(664,'4881f615-e5ee-4e32-a293-eb41e56db31d','45b66c38-3ad4-4b46-8ea7-d6d06c845a8f','SNAPSHOT'),(664,'4881f615-e5ee-4e32-a293-eb41e56db31d','64d43c5c-3568-4131-b63f-56fd0f1c6e22','MODEL'),(664,'4b1e4a8e-c35a-4205-bb29-2132e2649b4a','5fed9792-e66c-44cb-bf74-89f2ea0ffd0a','MODEL'),(664,'4b1e4a8e-c35a-4205-bb29-2132e2649b4a','9f1de81e-3ef2-49aa-8c29-97260ce2b9d4','SCREENSHOT'),(664,'4b1e4a8e-c35a-4205-bb29-2132e2649b4a','a2a9d676-d8c3-48c5-856c-6aa836b962fa','SNAPSHOT'),(664,'4b6e42bc-653f-11ef-b382-58a023cda0dc','fa2571a4-653f-11ef-b382-58a023cda0dc','MODEL'),(664,'4b6e42bc-653f-11ef-b382-58a023cda0dc','fa258235-653f-11ef-b382-58a023cda0dc','SNAPSHOT'),(664,'4bfeec89-723b-47a0-90b4-0b3cbf540d5d','2c38f262-932a-474f-83b0-317031fdf33e','MODEL'),(664,'4bfeec89-723b-47a0-90b4-0b3cbf540d5d','46704090-e6d2-4d18-a318-987d159b07c5','SNAPSHOT'),(664,'4d1480f1-6a51-4555-bec5-61f967de64cd','0cc0a4e2-b944-4f97-b8fd-4141a51c8b36','MODEL'),(664,'4d1480f1-6a51-4555-bec5-61f967de64cd','296f7328-8d99-48be-b336-a9bd0eb50498','SNAPSHOT'),(664,'4d1480f1-6a51-4555-bec5-61f967de64cd','3469c9f1-5269-4a05-bd73-33c7c9000367','SCREENSHOT'),(664,'4d1480f1-6a51-4555-bec5-61f967de64cd','8b5f6027-7920-42aa-97ca-e16af1854e7e','SCREENSHOT'),(664,'4d1480f1-6a51-4555-bec5-61f967de64cd','b90a2d0a-724a-4666-b16f-164f094d366d','SCREENSHOT'),(664,'4d1480f1-6a51-4555-bec5-61f967de64cd','e2055423-121e-44b1-ba24-257ea8653e14','SCREENSHOT'),(664,'4e055e11-653e-11ef-b382-58a023cda0dc','4494a5b9-653f-11ef-b382-58a023cda0dc','MODEL'),(664,'4e055e11-653e-11ef-b382-58a023cda0dc','4494b511-653f-11ef-b382-58a023cda0dc','SNAPSHOT'),(664,'4e055e11-653e-11ef-b382-58a023cda0dc','f3679988-653e-11ef-b382-58a023cda0dc','MODEL'),(664,'4e055e11-653e-11ef-b382-58a023cda0dc','f367a9fe-653e-11ef-b382-58a023cda0dc','SNAPSHOT'),(664,'4fee66f9-724e-4496-aae8-922ee35cabf6','076521ec-f003-4853-aec3-594a997cc51b','SNAPSHOT'),(664,'4fee66f9-724e-4496-aae8-922ee35cabf6','19fc4871-95bf-400b-a326-3494a92d5dba','MODEL'),(664,'513ec45a-0f78-4206-8819-a95a65dd628e','4c4dcb51-ef14-4ae6-9a4b-40d745bebdf7','MODEL'),(664,'513ec45a-0f78-4206-8819-a95a65dd628e','c64e5e13-5ca1-465d-9908-ec7f2c19e6c1','SNAPSHOT'),(664,'51d672de-5db0-4925-8908-13042e3aacea','7973cb9c-cd34-4796-881a-57ad49049b13','SNAPSHOT'),(664,'51d672de-5db0-4925-8908-13042e3aacea','bdaae778-b76a-455c-8a8c-c99af2ac7229','MODEL'),(664,'51d672de-5db0-4925-8908-13042e3aacea','cd6dafb5-01b1-4b6c-955d-9c6344bc8edc','MODEL'),(664,'51d672de-5db0-4925-8908-13042e3aacea','d8094a5c-fedb-4670-86ce-564c40fef227','SNAPSHOT'),(664,'51eb1879-2b2e-4194-9e9b-9ff1e67fe43c','7d55f75c-c015-4a0a-917b-7d996003b4c5','SNAPSHOT'),(664,'51eb1879-2b2e-4194-9e9b-9ff1e67fe43c','81089ccc-9c06-4a8f-a371-9d11e00cce3e','SNAPSHOT'),(664,'51eb1879-2b2e-4194-9e9b-9ff1e67fe43c','b3e4aa09-a4e4-454f-9f21-2abb5e89e530','MODEL'),(664,'51eb1879-2b2e-4194-9e9b-9ff1e67fe43c','e0fc0b6f-d43e-46fd-8b64-3e6b7edb4a91','MODEL'),(664,'5212b119-1f64-4de6-82e2-b5b72ee0e22b','17229463-b96c-43ca-849e-59667acaa1a9','MODEL'),(664,'5212b119-1f64-4de6-82e2-b5b72ee0e22b','3aa4aa7f-c1bf-46f5-b1b8-d05d04f54992','MODEL'),(664,'5212b119-1f64-4de6-82e2-b5b72ee0e22b','427a4b23-481e-474e-af46-1b8e8deafb7d','MODEL'),(664,'5212b119-1f64-4de6-82e2-b5b72ee0e22b','65e55379-ecc4-474a-8247-2d78e5bad08b','SNAPSHOT'),(664,'5212b119-1f64-4de6-82e2-b5b72ee0e22b','6e75df3d-e558-4cc6-8263-62b0654e0206','SNAPSHOT'),(664,'5212b119-1f64-4de6-82e2-b5b72ee0e22b','705ce590-288e-42b0-a165-5223556f4995','MODEL'),(664,'5212b119-1f64-4de6-82e2-b5b72ee0e22b','7edf01f1-08fe-4394-8c4b-b1bc1d7eb24d','SNAPSHOT'),(664,'5212b119-1f64-4de6-82e2-b5b72ee0e22b','7eedc56a-9ad1-4a49-b277-341ffab589ce','MODEL'),(664,'5212b119-1f64-4de6-82e2-b5b72ee0e22b','951e6aca-ea1e-430b-99f1-11ca3d7e0cd0','SNAPSHOT'),(664,'5212b119-1f64-4de6-82e2-b5b72ee0e22b','db9ebd1c-278a-4c11-a3bc-d8c36f9b811c','MODEL'),(664,'5478f37b-d39e-46d1-a026-906c02d9c928','07527793-5c05-4fbc-92d9-298ccb3489d3','MODEL'),(664,'5478f37b-d39e-46d1-a026-906c02d9c928','392b7c86-cde1-4f5b-aebb-127d69a35de3','SNAPSHOT'),(664,'5478f37b-d39e-46d1-a026-906c02d9c928','4baca937-885c-4f87-88b2-c1c5ac9e24e5','MODEL'),(664,'5478f37b-d39e-46d1-a026-906c02d9c928','7d32f47d-b7fa-4bab-b279-a835c925268d','MODEL'),(664,'5478f37b-d39e-46d1-a026-906c02d9c928','808d182d-221e-4a9d-ab72-1bcc5b6ec075','SNAPSHOT'),(664,'5478f37b-d39e-46d1-a026-906c02d9c928','991b6bf3-db84-4e38-b3ca-2e1d37a170c0','SNAPSHOT'),(664,'5478f37b-d39e-46d1-a026-906c02d9c928','c9ddac1c-6c23-47b0-b0b5-f88af955cb2a','MODEL'),(664,'5478f37b-d39e-46d1-a026-906c02d9c928','d44f76c2-8604-4bbd-a847-285c5b0d09fc','SNAPSHOT'),(664,'5478f37b-d39e-46d1-a026-906c02d9c928','f927cde7-cbe9-4c1b-ba83-38aaf41336af','MODEL'),(664,'5500928e-446a-45d8-af99-faf7375b1d49','043bef2f-4ab7-477e-8b7f-ea391cad0ec7','MODEL'),(664,'5500928e-446a-45d8-af99-faf7375b1d49','779f3035-6a8d-41b5-8c8d-7ea284d28390','SNAPSHOT'),(664,'5500928e-446a-45d8-af99-faf7375b1d49','aab75805-6a59-439e-9a97-285b5e4be308','MODEL'),(664,'5500928e-446a-45d8-af99-faf7375b1d49','bedd27a8-e576-4dc7-ad8b-6e29faaac9ff','SNAPSHOT'),(664,'5500928e-446a-45d8-af99-faf7375b1d49','d9832be3-80d4-48f3-a493-2302821853bf','MODEL'),(664,'5500928e-446a-45d8-af99-faf7375b1d49','df39cda5-e2d4-4006-bfb9-174151c06cd7','SNAPSHOT'),(664,'55e90c19-734b-11ee-b011-58a023cda0dc','c4cdf10c-734c-11ee-b011-58a023cda0dc','MODEL'),(664,'55e90c19-734b-11ee-b011-58a023cda0dc','c4ce0fdf-734c-11ee-b011-58a023cda0dc','SNAPSHOT'),(664,'57e592a9-5bc2-11ee-9658-58a023cda0dc','c37cdd93-5bc2-11ee-9658-58a023cda0dc','MODEL'),(664,'57e592a9-5bc2-11ee-9658-58a023cda0dc','c37cebbc-5bc2-11ee-9658-58a023cda0dc','SNAPSHOT'),(664,'59402aaf-7342-11ee-b011-58a023cda0dc','930bda4e-7342-11ee-b011-58a023cda0dc','MODEL'),(664,'59402aaf-7342-11ee-b011-58a023cda0dc','930be898-7342-11ee-b011-58a023cda0dc','SNAPSHOT'),(664,'59402aaf-7342-11ee-b011-58a023cda0dc','9fb4ae97-7342-11ee-b011-58a023cda0dc','MODEL'),(664,'59402aaf-7342-11ee-b011-58a023cda0dc','c6306a6c-7342-11ee-b011-58a023cda0dc','MODEL'),(664,'59402aaf-7342-11ee-b011-58a023cda0dc','c6307916-7342-11ee-b011-58a023cda0dc','SNAPSHOT'),(664,'5a4c21bb-56d0-45ea-b8ee-4931713ef609','86e03f08-85e3-45ff-ae56-4ff568776d2a','SNAPSHOT'),(664,'5a4c21bb-56d0-45ea-b8ee-4931713ef609','e8000207-77e1-46d0-b4c6-869f040c0dc2','MODEL'),(664,'5d0e6d2d-490c-4381-a794-dd7121de4a60','0522def8-f55f-4a8d-8758-a81209e06ef3','MODEL'),(664,'5d0e6d2d-490c-4381-a794-dd7121de4a60','248f95a0-ad8d-40f1-bf9e-68ceaee0d7ba','MODEL'),(664,'5d0e6d2d-490c-4381-a794-dd7121de4a60','2642f6d1-6c3f-4add-9a49-f8de19a8acfd','SNAPSHOT'),(664,'5d0e6d2d-490c-4381-a794-dd7121de4a60','4ad4e90c-75f1-4e2d-b3b2-e8b08e1524ab','SNAPSHOT'),(664,'5de08e77-210d-48b5-8004-9c536bb8530e','4157ac2e-557f-47f8-9c6c-3a50905de7ee','MODEL'),(664,'5de08e77-210d-48b5-8004-9c536bb8530e','5bcef502-db73-4612-9311-f192c76e91fa','SNAPSHOT'),(664,'5de08e77-210d-48b5-8004-9c536bb8530e','b055178c-4263-48b5-b3f5-7d43da512f2f','SNAPSHOT'),(664,'5de08e77-210d-48b5-8004-9c536bb8530e','c41ccbf2-b091-456a-af02-352476c4d367','MODEL'),(664,'5f528d31-6a1a-48e7-8ece-1a998befa669','055bb022-85cd-4a55-9a46-10afca2d621d','MODEL'),(664,'5f528d31-6a1a-48e7-8ece-1a998befa669','9e3589e8-4fb4-4877-a58c-cbb16190d186','SNAPSHOT'),(664,'5ffd123b-12b9-4fc7-9b8a-16b74a28e7b2','a28b2972-9b02-456d-9a8f-2bc4ce7c5568','SNAPSHOT'),(664,'5ffd123b-12b9-4fc7-9b8a-16b74a28e7b2','c2409855-6e21-47ba-ac07-1ce2895179b8','MODEL'),(664,'608d8495-6c36-11ee-bc7f-58a023cda0dc','9fa26aa6-6c36-11ee-bc7f-58a023cda0dc','MODEL'),(664,'608d8495-6c36-11ee-bc7f-58a023cda0dc','9fa279c1-6c36-11ee-bc7f-58a023cda0dc','SNAPSHOT'),(664,'60bb883b-6540-11ef-b382-58a023cda0dc','946f18a4-6540-11ef-b382-58a023cda0dc','MODEL'),(664,'60bb883b-6540-11ef-b382-58a023cda0dc','946f2cbd-6540-11ef-b382-58a023cda0dc','SNAPSHOT'),(664,'627e4388-24f1-4c92-816e-89cfce055284','12a9e53c-f4b6-42ea-9478-c84407313e24','SNAPSHOT'),(664,'627e4388-24f1-4c92-816e-89cfce055284','4227ee27-5a61-436a-ae69-cd486657a34d','MODEL'),(664,'627e4388-24f1-4c92-816e-89cfce055284','f5ad24f9-4391-4c12-a74f-59a61808c613','SCREENSHOT'),(664,'62fd085a-7b18-4cdf-aa97-db92a842f34f','66c14e8c-5b99-4217-b257-477985f8a5ab','SCREENSHOT'),(664,'62fd085a-7b18-4cdf-aa97-db92a842f34f','bbd7b267-49ae-4e37-bed9-4d177880c06e','SNAPSHOT'),(664,'62fd085a-7b18-4cdf-aa97-db92a842f34f','ee41e937-5440-4e00-b31c-adb4cc45edf8','MODEL'),(664,'640e0a5a-3880-4e38-add1-3466fa8599c0','301b54e6-6f67-4e02-896f-5223d7ef0280','SNAPSHOT'),(664,'640e0a5a-3880-4e38-add1-3466fa8599c0','b2375a76-5251-44e7-ad97-616cdc631d01','MODEL'),(664,'6557ff06-b759-4b3c-8de6-1c83a9b00d23','8c40eb8c-73ca-4e35-8386-312248838a85','MODEL'),(664,'6557ff06-b759-4b3c-8de6-1c83a9b00d23','f1ae49ff-c5b8-49e1-a81f-fc865ff00c7d','SNAPSHOT'),(664,'663b4cd8-e704-4cb6-ab8f-80ec41ed1370','262fff38-dd7b-4940-ac0a-a2a7e1645e65','MODEL'),(664,'663b4cd8-e704-4cb6-ab8f-80ec41ed1370','ef6d4b7f-c6eb-4040-924f-8b7304ee7248','SNAPSHOT'),(664,'669f6bca-452c-4b2e-a49e-aa822628ed5f','164f6864-87e7-433f-b775-f53c972ba906','MODEL'),(664,'669f6bca-452c-4b2e-a49e-aa822628ed5f','35183ff8-24e8-4f14-866b-db5b1bfbacb1','MODEL'),(664,'669f6bca-452c-4b2e-a49e-aa822628ed5f','54d26704-a1f5-457f-afc0-a8a096ef5c15','MODEL'),(664,'669f6bca-452c-4b2e-a49e-aa822628ed5f','5ea87deb-c530-4c0d-9e39-e94f351d1354','MODEL'),(664,'669f6bca-452c-4b2e-a49e-aa822628ed5f','8e1e3bd6-5308-4cb8-9602-06c4ddd3cb6e','MODEL'),(664,'669f6bca-452c-4b2e-a49e-aa822628ed5f','9d3a01d8-ce52-45d5-97b5-184961992b2b','SNAPSHOT'),(664,'669f6bca-452c-4b2e-a49e-aa822628ed5f','ae2cbcbb-219f-4df2-a6c6-07327535a3c1','MODEL'),(664,'669f6bca-452c-4b2e-a49e-aa822628ed5f','b0882173-80ca-4a75-94a1-981cb196d854','MODEL'),(664,'669f6bca-452c-4b2e-a49e-aa822628ed5f','c0142452-f781-449f-8eb3-faf1fbef6774','MODEL'),(664,'669f6bca-452c-4b2e-a49e-aa822628ed5f','e6214fe7-dce5-49bb-85f8-3bb098d8c560','SNAPSHOT'),(664,'6b9a0ce1-8ace-48c3-a9b9-efd9bd604d7f','04d5729b-24fa-4bd7-aae0-731968a61592','MODEL'),(664,'6b9a0ce1-8ace-48c3-a9b9-efd9bd604d7f','3c0b0988-7ac2-4e3d-ad84-4841bbd18966','SNAPSHOT'),(664,'6bf6cdd3-0c99-40b6-9e2b-5eaf7077f35f','049cbd64-e3ba-47ab-83cd-365a9e5b2ae5','SNAPSHOT'),(664,'6bf6cdd3-0c99-40b6-9e2b-5eaf7077f35f','be10bb9a-6014-4271-a65f-d5a456b36cdd','MODEL'),(664,'6d0c8022-e8b8-4ffa-8b31-ee9c8a811bb3','15343a6d-e281-4739-bed5-c0bfe5f8f6c7','SNAPSHOT'),(664,'6d0c8022-e8b8-4ffa-8b31-ee9c8a811bb3','97fc9012-a54b-49d1-94c9-f89634ee71b9','MODEL'),(664,'6d53d83a-50bf-4b07-a6c4-377e6be410b9','1327ec84-5062-4d24-bc87-76829fa164d9','MODEL'),(664,'6d53d83a-50bf-4b07-a6c4-377e6be410b9','20936b0c-07dc-4bae-83c4-55c68539ae5c','SNAPSHOT'),(664,'6d53d83a-50bf-4b07-a6c4-377e6be410b9','85680def-9eea-4c98-8023-f74aed715f89','SCREENSHOT'),(664,'6f12cbab-9aee-4057-bc58-bb6f63974204','185a70e3-8267-474e-aa32-a05eb5784fc8','SNAPSHOT'),(664,'6f12cbab-9aee-4057-bc58-bb6f63974204','cf55af4f-6f13-40b8-8ac4-8ef9f3d0c140','MODEL'),(664,'6f4cc2d8-2239-4982-a8b0-33dc6be535ae','556b1fdf-a302-4a96-b59d-60ce08e64532','SNAPSHOT'),(664,'6f4cc2d8-2239-4982-a8b0-33dc6be535ae','d2f8de35-8642-4645-8e3b-6fc1e801fc7f','MODEL'),(664,'6f9af98c-1ab4-4600-b23b-57aa4c4d1e85','4e214ec5-202e-4dee-b925-5f6ed1074108','SNAPSHOT'),(664,'6f9af98c-1ab4-4600-b23b-57aa4c4d1e85','ac5024cd-d172-486c-95a3-221f86ab12eb','MODEL'),(664,'70b1bf4b-a08d-4b96-9200-6648114f1bcd','231fd3a6-6aa1-481c-84e8-fb456bdbae59','MODEL'),(664,'70b1bf4b-a08d-4b96-9200-6648114f1bcd','b975305f-5425-46f9-8470-1c628b260f46','SNAPSHOT'),(664,'714348f7-0720-4a1c-bebb-c0807d687feb','1d98fd52-591a-40fc-8de1-36a02f534a6f','SNAPSHOT'),(664,'714348f7-0720-4a1c-bebb-c0807d687feb','eb3d7b07-28dd-4076-a69c-80c7abd0be51','MODEL'),(664,'722ff437-cef4-4d6b-861e-b52566d89c0d','0b848954-7152-4e87-b60c-76f5ac669614','MODEL'),(664,'722ff437-cef4-4d6b-861e-b52566d89c0d','5d8fe096-165a-4a91-ae19-6cbe10470e9c','SNAPSHOT'),(664,'73765dbb-1926-4aed-8b7f-3202e1e68aa2','2142e79a-5c20-4b84-ae6f-30da94d6f22f','SNAPSHOT'),(664,'73765dbb-1926-4aed-8b7f-3202e1e68aa2','240221f6-6e8b-47b5-a556-7958b41a92cf','MODEL'),(664,'73765dbb-1926-4aed-8b7f-3202e1e68aa2','7abd657b-8d1b-4fdd-bfb7-40094e5b23e8','SNAPSHOT'),(664,'73765dbb-1926-4aed-8b7f-3202e1e68aa2','7fde521a-04b1-4299-9ed5-c7cacaef524b','MODEL'),(664,'73765dbb-1926-4aed-8b7f-3202e1e68aa2','8a9085db-de52-4842-bf76-b2b32984ecc0','MODEL'),(664,'760aa563-6e6f-4ae3-98cc-e3d5350a517e','52853284-be7b-44e5-aeae-65e139601fcd','SNAPSHOT'),(664,'760aa563-6e6f-4ae3-98cc-e3d5350a517e','d46395de-c663-445e-93b7-6b0eef50a5d7','MODEL'),(664,'790f3bda-297c-41ad-812c-c6f5b135e445','55b4752c-9281-4cf2-8a88-4ddbfa881539','MODEL'),(664,'790f3bda-297c-41ad-812c-c6f5b135e445','8aa77d37-a70d-4b94-b8ee-9b4ccbea2b38','SNAPSHOT'),(664,'790f3bda-297c-41ad-812c-c6f5b135e445','c56d60f8-e5cb-4ec1-ad90-46938c46564b','SCREENSHOT'),(664,'79842b46-a1df-43a9-812e-4322f1c79203','251d4d60-3227-4d38-a340-1f2d10787aa5','SNAPSHOT'),(664,'79842b46-a1df-43a9-812e-4322f1c79203','2fc8e7d5-c298-4652-9fba-2ae22795cca4','MODEL'),(664,'79842b46-a1df-43a9-812e-4322f1c79203','4638f023-e672-4b5e-a3af-423e20a747d7','SNAPSHOT'),(664,'79842b46-a1df-43a9-812e-4322f1c79203','a1374e2d-ea55-4998-bb8b-c8ada23cd291','MODEL'),(664,'7a644c38-fa3b-11ed-8f6c-58a023cda0dc','33910ab4-fa3c-11ed-8f6c-58a023cda0dc','MODEL'),(664,'7a644c38-fa3b-11ed-8f6c-58a023cda0dc','33911b4a-fa3c-11ed-8f6c-58a023cda0dc','SNAPSHOT'),(664,'7bbce4b0-91f9-47fe-9ce5-53e0f491b245','0c7afa56-2ad1-49d6-9a62-5f142ca9dffc','MODEL'),(664,'7bbce4b0-91f9-47fe-9ce5-53e0f491b245','2e0798f7-31e5-46e0-a250-585c59e3ae58','SNAPSHOT'),(664,'7c9d6daa-c5b6-47ec-b65a-ee99948da8ea','ac9ef930-04c7-4cfc-b9df-0b64725e1bed','SNAPSHOT'),(664,'7c9d6daa-c5b6-47ec-b65a-ee99948da8ea','b6a3f85e-1545-44d4-88f7-8cb28ae3949d','MODEL'),(664,'7ce9b1b8-7c7b-4655-bd0d-90f37ced345e','1533f780-2e51-421e-b17a-c49b5947d8ca','MODEL'),(664,'7ce9b1b8-7c7b-4655-bd0d-90f37ced345e','4ee64a77-ca4c-444b-9d9f-1eaea738c404','MODEL'),(664,'7ce9b1b8-7c7b-4655-bd0d-90f37ced345e','92a8aaff-0105-4be1-8e93-7c174c4ed35f','SNAPSHOT'),(664,'7ce9b1b8-7c7b-4655-bd0d-90f37ced345e','a7c09592-0cd2-4e6d-bd98-0f39f03ab349','SNAPSHOT'),(664,'7ce9b1b8-7c7b-4655-bd0d-90f37ced345e','c62e7cb0-9118-4703-aafd-965a6c2bf6cc','MODEL'),(664,'7ce9b1b8-7c7b-4655-bd0d-90f37ced345e','dee039ba-4cc5-4fa5-ad6e-6642ba1fe187','MODEL'),(664,'7d660b43-6b91-4c1b-b004-a0aa4d714d00','e3d42984-7a05-4090-9332-6501d4802cda','MODEL'),(664,'7d660b43-6b91-4c1b-b004-a0aa4d714d00','f9de7f19-6e65-4dee-aecb-417188d3c5c0','SNAPSHOT'),(664,'7d87c990-cfc0-487a-bd48-674f0ba32da1','2017979f-f521-45d1-992d-e51f8b190f71','MODEL'),(664,'7d87c990-cfc0-487a-bd48-674f0ba32da1','228f68b7-dfd6-4b5a-814c-5c7b969e2de7','MODEL'),(664,'7d87c990-cfc0-487a-bd48-674f0ba32da1','27bf3ac0-658b-4660-968f-78499f29209f','MODEL'),(664,'7d87c990-cfc0-487a-bd48-674f0ba32da1','3119c4df-3760-4f4f-9247-8c1f5f4d8d43','MODEL'),(664,'7d87c990-cfc0-487a-bd48-674f0ba32da1','45a4307e-2197-4709-a4d8-2d47ed12d94b','SNAPSHOT'),(664,'7d87c990-cfc0-487a-bd48-674f0ba32da1','4aa1e72a-2214-4782-9601-a9c4431cf5ed','MODEL'),(664,'7d87c990-cfc0-487a-bd48-674f0ba32da1','4ead05fa-43f6-4510-b941-4c90069dbe32','SNAPSHOT'),(664,'7d87c990-cfc0-487a-bd48-674f0ba32da1','8f2ac274-c407-43a2-9887-6c9cc61f72a2','SNAPSHOT'),(664,'7d87c990-cfc0-487a-bd48-674f0ba32da1','d1a427ba-93d4-43ec-8aa4-63fffdae261c','MODEL'),(664,'7eb7b491-f49d-4ad2-941c-473aec4b39cd','c16a858c-f3d1-46c0-9789-5b60741a4656','MODEL'),(664,'7eb7b491-f49d-4ad2-941c-473aec4b39cd','f3481f20-4e0b-418c-b386-0e6204e1c415','SNAPSHOT'),(664,'7f9b3767-26d0-40f2-b0dd-07da9d57ad85','34e187aa-8459-44c6-afd6-5adfe7d4325a','MODEL'),(664,'7f9b3767-26d0-40f2-b0dd-07da9d57ad85','669d8672-cb26-496c-9001-2d39cb057249','MODEL'),(664,'7f9b3767-26d0-40f2-b0dd-07da9d57ad85','66fd1060-c3ed-464a-9c7e-950a0d2ba8f4','SNAPSHOT'),(664,'7f9b3767-26d0-40f2-b0dd-07da9d57ad85','cc91b497-351a-4c6c-b7da-ea25dc95fd0a','SNAPSHOT'),(664,'81f83061-69fa-4da2-b528-42ee27f15e7a','2e76bc0f-07df-4175-add2-e13f7adb84e5','MODEL'),(664,'81f83061-69fa-4da2-b528-42ee27f15e7a','422c8790-59bb-44d4-8423-88d7c4e220d7','SNAPSHOT'),(664,'81f83061-69fa-4da2-b528-42ee27f15e7a','45493782-7cde-419b-baf2-f676f41925fa','MODEL'),(664,'81f83061-69fa-4da2-b528-42ee27f15e7a','f55defb1-5a2c-4b14-91f1-64f2163f04ad','SNAPSHOT'),(664,'821a2ca1-0234-413b-a35b-4cc6703ca75b','41d41ad2-2fb1-471e-a6e0-38c61a0afcb9','SNAPSHOT'),(664,'821a2ca1-0234-413b-a35b-4cc6703ca75b','9d285fcb-90ae-48a7-bd6b-143c3ee7c5f8','MODEL'),(664,'82ecab0e-29eb-4e22-957f-3c065a082b56','55075a59-6d21-4912-89a2-984a7c646584','MODEL'),(664,'82ecab0e-29eb-4e22-957f-3c065a082b56','6265f500-2b38-4e2a-af4e-2b889b8cd5f6','SNAPSHOT'),(664,'837d6f6c-9467-11ee-8fd8-58a023cda0dc','c07ee7aa-9467-11ee-8fd8-58a023cda0dc','MODEL'),(664,'837d6f6c-9467-11ee-8fd8-58a023cda0dc','c07ef7b2-9467-11ee-8fd8-58a023cda0dc','SNAPSHOT'),(664,'84918ef7-2b0c-4acf-a14e-df7fcaff4812','55150fc7-4024-45fc-9b2f-f474826b2d4d','SNAPSHOT'),(664,'84918ef7-2b0c-4acf-a14e-df7fcaff4812','df32e9cc-0861-4ad7-ad2a-718737b05992','MODEL'),(664,'8561d2e9-734e-11ee-b011-58a023cda0dc','ca02c680-734e-11ee-b011-58a023cda0dc','MODEL'),(664,'8561d2e9-734e-11ee-b011-58a023cda0dc','ca02d758-734e-11ee-b011-58a023cda0dc','SNAPSHOT'),(664,'86e16909-3b39-4591-8c03-0e4eba17f0ff','01d9850c-07c1-4bce-bfc7-a103199fd817','SNAPSHOT'),(664,'86e16909-3b39-4591-8c03-0e4eba17f0ff','82334e6c-351a-420d-b00b-1f8b84c0a9ba','MODEL'),(664,'86e16909-3b39-4591-8c03-0e4eba17f0ff','cb6e4826-4b7c-4db6-9cd0-94212f7b6703','SCREENSHOT'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','1f5ccddd-9466-11ee-8fd8-58a023cda0dc','MODEL'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','45015dfe-9466-11ee-8fd8-58a023cda0dc','MODEL'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','54152a5f-9466-11ee-8fd8-58a023cda0dc','MODEL'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','5f9a60ab-9466-11ee-8fd8-58a023cda0dc','MODEL'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','6d9a82f6-9467-11ee-8fd8-58a023cda0dc','MODEL'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','6d9a913f-9467-11ee-8fd8-58a023cda0dc','SNAPSHOT'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','87a0d07a-9465-11ee-8fd8-58a023cda0dc','MODEL'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','87a0e23e-9465-11ee-8fd8-58a023cda0dc','SNAPSHOT'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','9a09f6da-9465-11ee-8fd8-58a023cda0dc','MODEL'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','9fb66d32-9465-11ee-8fd8-58a023cda0dc','MODEL'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','a6bd9cda-9465-11ee-8fd8-58a023cda0dc','MODEL'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','af0d9193-9465-11ee-8fd8-58a023cda0dc','MODEL'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','bcca7cb5-9465-11ee-8fd8-58a023cda0dc','MODEL'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','c66e3ede-9465-11ee-8fd8-58a023cda0dc','MODEL'),(664,'87132a5c-9464-11ee-8fd8-58a023cda0dc','d40bfa65-9465-11ee-8fd8-58a023cda0dc','MODEL'),(664,'88f800e1-3e01-4d9c-984c-9f939ebee222','3559e869-8afd-4b40-9374-d2361cf0914a','MODEL'),(664,'88f800e1-3e01-4d9c-984c-9f939ebee222','a894dedf-edb8-479e-a4e0-38594ffe81f2','SNAPSHOT'),(664,'893e772a-611c-44f9-82ac-d63e0a0499b2','ba2e753b-8816-4982-874e-0a6179134184','MODEL'),(664,'893e772a-611c-44f9-82ac-d63e0a0499b2','dd4c117a-c03b-4b5e-b723-0ffae29a0f46','SNAPSHOT'),(664,'8ce97d97-ffb5-461c-928d-ea25e722645a','3c359e74-b03a-4f21-a836-212e19d89fc2','SCREENSHOT'),(664,'8ce97d97-ffb5-461c-928d-ea25e722645a','5b12fd9e-03c6-4145-8366-7a8646402a7c','MODEL'),(664,'8ce97d97-ffb5-461c-928d-ea25e722645a','93e1d6ba-56ac-4322-aa8d-68802281f1de','SNAPSHOT'),(664,'8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368','038a356c-cfd5-42a7-b2bc-6d94ebccde52','SNAPSHOT'),(664,'8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368','219a577b-6c2c-440a-ae7a-4bc501aa7a43','MODEL'),(664,'8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368','3c9f280c-637f-4072-9bcd-c356e72cae38','SCREENSHOT'),(664,'8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368','82a6efdf-566e-4983-8345-bb07a5434fce','MODEL'),(664,'8da0a0e0-3ec7-4ad8-aa6b-06d4c2ac8368','cba5993b-d655-4256-a986-c921c6159435','SNAPSHOT'),(664,'912aed9d-90da-48c3-b2d2-60c29e2eb2a2','5c07f751-3020-45a0-bf20-21a6ed8a6aea','SNAPSHOT'),(664,'912aed9d-90da-48c3-b2d2-60c29e2eb2a2','d209ac69-fa89-4893-8e85-fde8f654efc3','MODEL'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','0411f5bf-323b-47db-be56-fdf58a7dcaaa','LIFI'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','0447f95a-1a07-4b73-a2bf-c052637691d7','LIFI'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','0967d80d-992e-4d4b-ae94-bd981fca4791','LIFI'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','0f3468b4-f1b8-411d-b79b-fb3966cbd43e','SNAPSHOT'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','0f7e3ea7-65fd-4870-9e54-f9ef2a24d8bf','MODEL'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','130024ea-36bf-439a-980c-e464701bd4fb','LIFIMETA'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','24d8debb-2e9c-4604-a943-eb78950b16e5','LIFIMETA'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','2d01fc23-e076-4307-82e2-551c85841427','MODEL'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','3ec22db4-d2af-489a-b0fa-4d4e8a20600e','LIFI'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','4f5c94d6-48d0-45b2-b5f1-40b18baf386e','LIFI'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','54f8089a-b17b-4de2-bfb5-8cdee0a85eb7','LIFI'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','58ee5bee-0fd9-4bba-89cb-cf99f01eb438','LIFIMETA'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','6adbd107-a4ca-46d3-8650-9b52e9259a8f','LIFIMETA'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','abdd65b1-8e6c-4a9a-84db-e8a1b6437124','MODEL'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','ac8e82cb-46bf-4b75-8996-3ccefa879974','SNAPSHOT'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','cb02b0b7-9fd2-47f3-a4d9-9b064252bc24','LIFIMETA'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','cb794354-96b6-463a-a735-215a2367d35f','MODEL'),(664,'92704e83-dce3-4695-baad-1df750f09cd7','ede805a2-c67d-404b-ba10-2922d208f4b7','LIFIMETA'),(664,'93be3b1e-bcd5-443a-a7e3-4f5452c470a6','3f1757fe-c85b-4daf-9505-622b6fa8df3f','SNAPSHOT'),(664,'93be3b1e-bcd5-443a-a7e3-4f5452c470a6','a37bae2b-66fb-49c6-8ba9-6a1388881e81','MODEL'),(664,'93f13113-c282-4369-a96a-9a2f2f6383b2','380de904-4892-40a0-b5af-04afb8b8c94e','MODEL'),(664,'93f13113-c282-4369-a96a-9a2f2f6383b2','b3fbb783-8b86-4822-9640-974c7986b610','SNAPSHOT'),(664,'95b374af-2b93-47f7-86f5-f5e1ba6360b6','49dd01c4-2e28-427b-85aa-ab8d7c4aa0e6','SNAPSHOT'),(664,'95b374af-2b93-47f7-86f5-f5e1ba6360b6','79f9fd91-9051-41dd-a9bb-68c6a0549dc4','MODEL'),(664,'962c1c5b-f5e5-4c64-9396-b2b298e42f54','0552024a-43bc-40ca-ad79-d59a1e19891d','SNAPSHOT'),(664,'962c1c5b-f5e5-4c64-9396-b2b298e42f54','09e45aca-9e2d-422a-8ede-017b9008e6fa','MODEL'),(664,'96e07cef-c402-4c22-8ab7-f63fa9dd08a0','d1d93eeb-e9b4-4246-b371-97194de11bf1','MODEL'),(664,'96e07cef-c402-4c22-8ab7-f63fa9dd08a0','d6f1fabc-2a26-4d5f-b438-4ce706655a1b','SNAPSHOT'),(664,'96e07cef-c402-4c22-8ab7-f63fa9dd08a0','ee22bb74-025f-4764-bf3c-e444fd75bfa5','SNAPSHOT'),(664,'96e07cef-c402-4c22-8ab7-f63fa9dd08a0','f3e47673-2830-433d-8d15-a959b8b38ccc','MODEL'),(664,'98f6c3db-f007-4f0d-a724-a372751a6d75','3dce93ee-7ed1-4bc5-85ff-1fe06ad1d1ab','MODEL'),(664,'98f6c3db-f007-4f0d-a724-a372751a6d75','ae255d52-c5a9-4e24-bb3e-6abc7d04c0e9','SNAPSHOT'),(664,'98f6c3db-f007-4f0d-a724-a372751a6d75','cc27a307-0265-442d-8bc3-6ac3b71acd67','SCREENSHOT'),(664,'98f6c3db-f007-4f0d-a724-a372751a6d75','d2fe3cb8-fcf4-445e-af4a-b2a448199d6b','SCREENSHOT'),(664,'9af0dbc6-6540-11ef-b382-58a023cda0dc','e017d672-6540-11ef-b382-58a023cda0dc','MODEL'),(664,'9af0dbc6-6540-11ef-b382-58a023cda0dc','e0190e85-6540-11ef-b382-58a023cda0dc','SNAPSHOT'),(664,'9ec52cac-03f7-4247-88fd-59b11e688f36','a7a3c050-c3db-4379-bc91-d2bd0affd589','MODEL'),(664,'9ec52cac-03f7-4247-88fd-59b11e688f36','b3577bd1-3f71-45cf-ab36-326a88d9a238','SNAPSHOT'),(664,'9f22f8f4-8b92-4811-8c6a-7b858b99e056','77c38694-17b8-404d-ba83-1b6a0859814a','SNAPSHOT'),(664,'9f22f8f4-8b92-4811-8c6a-7b858b99e056','b48b199f-561e-4239-8141-bbd54b8a7a80','MODEL'),(664,'a003a669-7caa-4b04-a7fb-b5164b2bfcd3','3f56431a-39e2-4537-933e-99ea66b80566','SCREENSHOT'),(664,'a003a669-7caa-4b04-a7fb-b5164b2bfcd3','70a1ffe1-533c-49da-881c-10044b0e5fa8','SNAPSHOT'),(664,'a003a669-7caa-4b04-a7fb-b5164b2bfcd3','8ce4ae13-659c-4b1b-859a-61a6bce748d7','MODEL'),(664,'a0b85a0a-ef77-4f7c-b376-d6e388afe9f0','38348fb1-51bb-4620-9df5-b9b65e2d1779','SCREENSHOT'),(664,'a0b85a0a-ef77-4f7c-b376-d6e388afe9f0','5d800334-a28a-499e-9ad8-6fae153904b2','SCREENSHOT'),(664,'a0b85a0a-ef77-4f7c-b376-d6e388afe9f0','c07ab4b3-ce6f-4eeb-859d-40b3c4631562','MODEL'),(664,'a0b85a0a-ef77-4f7c-b376-d6e388afe9f0','d3c2fb35-0aff-4775-8c47-8085c2bb4a6c','SNAPSHOT'),(664,'a1d7f6b9-6c36-11ee-bc7f-58a023cda0dc','ceac08e6-6c36-11ee-bc7f-58a023cda0dc','MODEL'),(664,'a1d7f6b9-6c36-11ee-bc7f-58a023cda0dc','ceac18ef-6c36-11ee-bc7f-58a023cda0dc','SNAPSHOT'),(664,'a283652c-095c-41a2-b62b-1cba87286c35','04ae92b2-2a37-49d3-be24-6db207bc06c7','MODEL'),(664,'a283652c-095c-41a2-b62b-1cba87286c35','4a594b34-2546-4f10-938b-a533e451d2c4','SNAPSHOT'),(664,'a4752db3-12a3-432e-825c-694c37118d39','2785f1a8-12cb-4579-bcdc-70a1c7c2ce88','MODEL'),(664,'a4752db3-12a3-432e-825c-694c37118d39','2f08ce27-2392-4c74-9c68-ed3fd9058690','SNAPSHOT'),(664,'a4752db3-12a3-432e-825c-694c37118d39','360dc54f-88e0-4619-a751-4f91d1879e32','MODEL'),(664,'a4752db3-12a3-432e-825c-694c37118d39','9e6ac4cc-cd14-4cd9-813c-a58767782690','MODEL'),(664,'a4752db3-12a3-432e-825c-694c37118d39','a641686c-5e48-4a10-8fc1-f41b2aff94bf','MODEL'),(664,'a4752db3-12a3-432e-825c-694c37118d39','bc2d83ba-f199-4e59-bccb-362f0d7ec120','SNAPSHOT'),(664,'a4752db3-12a3-432e-825c-694c37118d39','d73ed817-72ee-4c83-a18a-a4b11b0b8c1a','SNAPSHOT'),(664,'a4752db3-12a3-432e-825c-694c37118d39','f1cef6f1-79e5-4710-af52-8d44a265687b','SNAPSHOT'),(664,'a58436fa-a729-4ed0-9312-1037d7bc8f6e','91eb27f3-2931-48bd-a8af-b828ef131e01','MODEL'),(664,'a58436fa-a729-4ed0-9312-1037d7bc8f6e','f815490e-f81e-42e5-a1f8-60b9fd7b4f23','SNAPSHOT'),(664,'a614060b-f808-4f83-92d9-bfd877c99148','8d571ae5-301b-423d-bed4-3e10601d3626','SNAPSHOT'),(664,'a614060b-f808-4f83-92d9-bfd877c99148','c56d738a-5e39-4863-b12c-3a1317e95aaa','MODEL'),(664,'a6208834-50bc-4a6d-9646-4220f7dbfeeb','bd2c5911-7e30-497f-836b-cd9620a24680','MODEL'),(664,'a6208834-50bc-4a6d-9646-4220f7dbfeeb','cdf831d0-b5ce-4895-a210-3c3dd2b164ec','SNAPSHOT'),(664,'a6440940-a668-4e8f-be35-82ce928f701e','1f5190dd-0c64-4ab2-9707-5e552da58bd7','SNAPSHOT'),(664,'a6440940-a668-4e8f-be35-82ce928f701e','4c449c81-cd1f-492e-b12f-03afe35bc557','SNAPSHOT'),(664,'a6440940-a668-4e8f-be35-82ce928f701e','bb969c94-5b26-4ac7-b0c1-9e5784e6d4f0','MODEL'),(664,'a6440940-a668-4e8f-be35-82ce928f701e','e073c91e-f9e6-469e-b0f4-f2842226eb6a','MODEL'),(664,'a6f3b498-07ce-489a-805c-c6bc2ac7d0d9','5db64fac-8b70-48e7-9fdb-bf8db2a315d6','SNAPSHOT'),(664,'a6f3b498-07ce-489a-805c-c6bc2ac7d0d9','d25c751c-c80f-4b38-a10e-8bd824d9720c','MODEL'),(664,'a7098a82-daaf-4ad2-a4b6-803796e5351b','1e42d75c-0ebd-4920-8a72-fbe3b1044908','MODEL'),(664,'a7098a82-daaf-4ad2-a4b6-803796e5351b','6f55e6c6-3655-4578-b29e-986640c890b1','SNAPSHOT'),(664,'a8bc827c-e0a5-47f0-9a65-02d941ee82ab','2638acc5-b813-46b6-9bd3-30e06d514d23','MODEL'),(664,'a8bc827c-e0a5-47f0-9a65-02d941ee82ab','88bf532a-ff55-4ecc-bb8b-e42f109c256d','SNAPSHOT'),(664,'ab0cf7a4-5bc3-11ee-9658-58a023cda0dc','ad938206-5bc4-11ee-9658-58a023cda0dc','MODEL'),(664,'ab0cf7a4-5bc3-11ee-9658-58a023cda0dc','ad9391da-5bc4-11ee-9658-58a023cda0dc','SNAPSHOT'),(664,'abe20329-4dfe-4eda-815d-06af022b814e','2b033f08-583a-4833-952b-bcb21bc30255','SNAPSHOT'),(664,'abe20329-4dfe-4eda-815d-06af022b814e','c945387d-c4d4-46ef-9e61-4c5f67a4eb30','MODEL'),(664,'abe712db-ef5c-4b31-86ea-c51697f1242e','0b75b5b3-6359-43a9-93d0-98e60dab0ddf','MODEL'),(664,'abe712db-ef5c-4b31-86ea-c51697f1242e','3694c1ac-b60e-4b16-baf5-38e9c7ed4c4e','SNAPSHOT'),(664,'ad99e632-5042-4e93-87eb-5f1d24eaf0df','a702f29e-9295-44bb-9e5b-6a0182ffe02e','SNAPSHOT'),(664,'ad99e632-5042-4e93-87eb-5f1d24eaf0df','c166afdc-5215-400f-8a3a-0002542312db','MODEL'),(664,'ae3d82e4-16e2-4a7c-984e-ec74c0b263f0','b048a2a4-c12e-4372-a64b-a9331ce964a1','MODEL'),(664,'ae3d82e4-16e2-4a7c-984e-ec74c0b263f0','c3a0080d-af3f-4577-9532-87d15d4dc941','SNAPSHOT'),(664,'b08eb59b-89c3-4239-8926-d8eb829e4257','0d4b8851-03cd-409c-8c1b-88b798f2148e','MODEL'),(664,'b08eb59b-89c3-4239-8926-d8eb829e4257','1306dfc3-6859-4db6-a328-8cbcb42e86f8','SNAPSHOT'),(664,'b08eb59b-89c3-4239-8926-d8eb829e4257','2881b5b1-e7a7-423b-9992-84d47ae87934','LIFI'),(664,'b08eb59b-89c3-4239-8926-d8eb829e4257','4f6b02df-1818-4f99-ae96-306c6d94e169','LIFI'),(664,'b08eb59b-89c3-4239-8926-d8eb829e4257','6de59b7c-2c5e-4755-8fd6-c921b746bc1b','LIFIMETA'),(664,'b08eb59b-89c3-4239-8926-d8eb829e4257','906dd2e7-6bf5-4203-89bf-9fe369c52a5a','LIFI'),(664,'b08eb59b-89c3-4239-8926-d8eb829e4257','b3af0773-7d7b-41fe-9d8f-18f328cbc05c','LIFIMETA'),(664,'b08eb59b-89c3-4239-8926-d8eb829e4257','f2bae466-8ebb-418d-b84f-8b538101773f','LIFIMETA'),(664,'b0b45de7-f1c4-4f46-9c23-2126c2326f9b','13097ab6-1a4d-4f75-985a-8e44b2c82e0b','MODEL'),(664,'b0b45de7-f1c4-4f46-9c23-2126c2326f9b','9dcba4d5-3b87-469b-931c-d1f2c5b0cc99','SNAPSHOT'),(664,'b1421e3f-63ee-4787-8b03-c065863774b0','271baab4-a13d-4f91-aa4e-ab7bad6b3816','MODEL'),(664,'b1421e3f-63ee-4787-8b03-c065863774b0','4d497b9c-1f90-4dc5-8a0b-ca47b80a1492','SNAPSHOT'),(664,'b241654a-9ea1-48f7-8414-4891fdcbd880','06bf9050-09ab-4cd9-82f1-c218c9a25dee','MODEL'),(664,'b241654a-9ea1-48f7-8414-4891fdcbd880','da333d07-80cd-4439-adfd-9aaf2686eb08','SNAPSHOT'),(664,'b3dee852-769a-40d5-9c59-f651659a9d74','c6b08692-13ab-4ffb-aa45-20461c28c3b0','SNAPSHOT'),(664,'b3dee852-769a-40d5-9c59-f651659a9d74','f6e0525e-a065-4d5a-98b2-1a444413c722','MODEL'),(664,'b6033058-40f5-4202-bc4b-bfe024d70e70','579610fb-1842-4dc6-8b36-ab5b5f876866','MODEL'),(664,'b6033058-40f5-4202-bc4b-bfe024d70e70','64b8d5bc-8386-44be-ac0b-8657f8a52953','SNAPSHOT'),(664,'b6033058-40f5-4202-bc4b-bfe024d70e70','940e449c-2145-4c2d-a126-51d8d7e8e92c','SNAPSHOT'),(664,'b6033058-40f5-4202-bc4b-bfe024d70e70','b321a7d1-22a8-4651-b766-bb5efbe38c99','MODEL'),(664,'b6033058-40f5-4202-bc4b-bfe024d70e70','d009bbe4-4f33-47fd-99e6-d180ee49e211','MODEL'),(664,'b6033058-40f5-4202-bc4b-bfe024d70e70','d31fff53-e769-4756-bc68-5aeea0d528b5','SNAPSHOT'),(664,'b6a47aff-51d9-4bb1-bb0d-20fd5a5bc0e0','7bfd4193-5301-4dc1-b4e1-7ff5390e8e5a','SNAPSHOT'),(664,'b6a47aff-51d9-4bb1-bb0d-20fd5a5bc0e0','ebdd28e5-bb98-48d1-a168-c4187cf083fd','MODEL'),(664,'b6b465bc-cccb-49a9-ba82-6a6e82cd4324','67b3f8a8-178c-4668-90fa-b3ad09dd67ff','SCREENSHOT'),(664,'b6b465bc-cccb-49a9-ba82-6a6e82cd4324','924eb01d-c7f1-4784-ab3d-bffa8647cc5a','MODEL'),(664,'b6b465bc-cccb-49a9-ba82-6a6e82cd4324','a0dfdb3c-ddc2-421a-989f-e27c4e0c1866','SNAPSHOT'),(664,'b8399067-4ae2-4f64-a407-d8870e0e66ec','bfe83fc6-99db-4c9b-8220-a9a7631cf7e7','MODEL'),(664,'b8399067-4ae2-4f64-a407-d8870e0e66ec','f8736908-df16-4fae-af3c-e8baa5f0f69d','SNAPSHOT'),(664,'b974cde0-1037-4254-9cd8-9fcd14968091','aa94138d-320f-44a7-9b36-953713b8552e','SNAPSHOT'),(664,'b974cde0-1037-4254-9cd8-9fcd14968091','c452aac6-05e7-48c3-aef6-2cb3a21d6dc4','MODEL'),(664,'bb241051-9343-4a9a-9282-a960e0748f3e','2777cbb2-ec32-407b-92c0-925bdb65bdfa','SNAPSHOT'),(664,'bb241051-9343-4a9a-9282-a960e0748f3e','43ec56d4-c1b3-4a5d-a33a-61909d689853','MODEL'),(664,'bb241051-9343-4a9a-9282-a960e0748f3e','acdd2be8-41d4-4309-8d50-7389512f9d6d','SNAPSHOT'),(664,'bb241051-9343-4a9a-9282-a960e0748f3e','b4eec334-5aa2-493f-8b80-4404dc464a71','SNAPSHOT'),(664,'bb241051-9343-4a9a-9282-a960e0748f3e','c35a163d-8056-4e6b-ac08-f90f304d871f','MODEL'),(664,'bb241051-9343-4a9a-9282-a960e0748f3e','ce3b2d45-df06-466e-8d53-72fb4fe941b8','MODEL'),(664,'bbd16c8e-e7dc-4578-8027-d6b5d16e2cce','b67e5e75-e3bc-4168-9f8a-023260cf853b','SNAPSHOT'),(664,'bbd16c8e-e7dc-4578-8027-d6b5d16e2cce','fdc7cf45-27ee-493e-893d-702f5a989b40','MODEL'),(664,'bdc0c035-5e2c-49c1-9980-ecffc5862af4','896b62a5-2257-4335-b9f8-a711ad38d5c8','SCREENSHOT'),(664,'bdc0c035-5e2c-49c1-9980-ecffc5862af4','8e7ff8d7-eb67-4db2-84d7-7cf93584054d','SNAPSHOT'),(664,'bdc0c035-5e2c-49c1-9980-ecffc5862af4','aafe80ec-b241-47c3-98cb-9c43a7207ae2','MODEL'),(664,'bf2f2d20-77c1-4aff-a005-144b4bf2c7f3','10d50154-eaad-4c7c-bcc0-5edad9315cc7','SNAPSHOT'),(664,'bf2f2d20-77c1-4aff-a005-144b4bf2c7f3','4d2adaf7-8bfc-4e39-9074-1b71491a3303','MODEL'),(664,'c06a5cff-eff6-47da-bc1a-c815235abec3','77bf1215-677a-4878-bef9-8a318da9a518','MODEL'),(664,'c06a5cff-eff6-47da-bc1a-c815235abec3','cc466fbd-fba9-4bc1-949e-c9242dc1dd4f','SNAPSHOT'),(664,'c10fc832-071d-4249-8d26-88c7891b3ef7','7723ac3c-0369-4af2-85e7-bc0325ec0c97','MODEL'),(664,'c10fc832-071d-4249-8d26-88c7891b3ef7','d7403a86-69a8-47be-841c-0ef6b1c68e12','SNAPSHOT'),(664,'c17d800a-58c0-4658-b29b-d8ee0cbd16bb','0e146d0f-278a-4e47-9f58-7f65720624e5','SNAPSHOT'),(664,'c17d800a-58c0-4658-b29b-d8ee0cbd16bb','62bf9730-f940-4f6c-a6cc-097860ffdb9d','MODEL'),(664,'c25edbb6-50b0-4c96-8756-63dca8532242','1d9c8ed2-a1f5-4432-9956-4822381e8a4b','SNAPSHOT'),(664,'c25edbb6-50b0-4c96-8756-63dca8532242','bb246139-446d-41bd-af89-0c4dcc147372','MODEL'),(664,'c2dbac17-9467-11ee-8fd8-58a023cda0dc','f9815921-9467-11ee-8fd8-58a023cda0dc','MODEL'),(664,'c2dbac17-9467-11ee-8fd8-58a023cda0dc','f981687a-9467-11ee-8fd8-58a023cda0dc','SNAPSHOT'),(664,'c3b55ffe-4305-4af0-829c-88fb2866ef2a','1d036ddb-23c4-41ee-b7b1-3df941a91192','MODEL'),(664,'c3b55ffe-4305-4af0-829c-88fb2866ef2a','3431dfbb-a66f-4773-8770-8b2e0ab220b8','SNAPSHOT'),(664,'c550cbc7-71cb-4513-8c8b-7c725f1e0129','92fc9e76-e486-464f-bc7a-6f09ea6899e8','MODEL'),(664,'c550cbc7-71cb-4513-8c8b-7c725f1e0129','adca65c3-c068-425e-9917-53959630736b','SNAPSHOT'),(664,'c56436ec-184d-44cc-9d63-5d6b28b7aebe','a73b3e6e-5016-4490-af65-3401d7f328c4','MODEL'),(664,'c56436ec-184d-44cc-9d63-5d6b28b7aebe','b9908633-8c54-4317-8939-f934991e5174','SNAPSHOT'),(664,'c5b26299-5fb8-4823-8b1a-c620bba14794','17c8eb02-aa8e-47df-a126-46a753bf415e','SCREENSHOT'),(664,'c5b26299-5fb8-4823-8b1a-c620bba14794','26383578-97b4-469c-83c8-1399e6fdf5c9','MODEL'),(664,'c5b26299-5fb8-4823-8b1a-c620bba14794','f81ac2c3-1a0f-4064-a1eb-844d818e111c','SNAPSHOT'),(664,'c69cb914-4302-4945-ad80-085dba8ff126','0fda9c0b-19a1-4c9a-bed0-77729ac8643e','SNAPSHOT'),(664,'c69cb914-4302-4945-ad80-085dba8ff126','7cf3fa91-829b-4784-9c7b-fa07d892af02','MODEL'),(664,'c865ffd7-f2b1-43ae-a10a-26300e29d86e','4819eee1-2c73-4adc-b276-9c62c992e121','MODEL'),(664,'c865ffd7-f2b1-43ae-a10a-26300e29d86e','549c1ac9-11ed-4258-8ed5-7586d8615985','SNAPSHOT'),(664,'c8efe876-0a08-4332-bd36-6b59cc8f2eb8','8dc7dd50-07ac-40d3-8676-114e6716857c','SNAPSHOT'),(664,'c8efe876-0a08-4332-bd36-6b59cc8f2eb8','d99c267d-7e3c-47a7-bcd3-9e758b7142bc','MODEL'),(664,'c9a0bb36-9838-11ee-86e7-58a023cda0dc','2b226dbb-9839-11ee-86e7-58a023cda0dc','MODEL'),(664,'c9a0bb36-9838-11ee-86e7-58a023cda0dc','2b227cd2-9839-11ee-86e7-58a023cda0dc','SNAPSHOT'),(664,'c9d5be37-9f50-45c6-8384-f43f10073bb8','1373889b-19cd-40f6-8f23-37b7f95bcb0e','SNAPSHOT'),(664,'c9d5be37-9f50-45c6-8384-f43f10073bb8','da74b15a-5579-4b37-a283-e3cc9c0d0d26','MODEL'),(664,'cc0c8ac4-7342-11ee-b011-58a023cda0dc','17e8834e-7343-11ee-b011-58a023cda0dc','MODEL'),(664,'cc0c8ac4-7342-11ee-b011-58a023cda0dc','17e89282-7343-11ee-b011-58a023cda0dc','SNAPSHOT'),(664,'cd138f1a-5bc2-11ee-9658-58a023cda0dc','9e5a1940-5bc3-11ee-9658-58a023cda0dc','MODEL'),(664,'cd138f1a-5bc2-11ee-9658-58a023cda0dc','9e5a4f15-5bc3-11ee-9658-58a023cda0dc','SNAPSHOT'),(664,'cd1443ce-734e-11ee-b011-58a023cda0dc','0724c208-734f-11ee-b011-58a023cda0dc','MODEL'),(664,'cd1443ce-734e-11ee-b011-58a023cda0dc','0724d1c1-734f-11ee-b011-58a023cda0dc','SNAPSHOT'),(664,'d19c7af8-1f07-4857-86c3-e29963c1f9c9','6b191299-9fed-4391-9cc7-258eddfaf7df','SNAPSHOT'),(664,'d19c7af8-1f07-4857-86c3-e29963c1f9c9','aba5479c-35a0-4c7f-a0c1-dbde75e26606','MODEL'),(664,'d2853a7d-9edf-4ac8-aeaa-d186ea3a6553','b8827dde-757a-4031-9b65-359cf60ffcdf','SNAPSHOT'),(664,'d2853a7d-9edf-4ac8-aeaa-d186ea3a6553','d1d17c7c-fe5f-4080-bd9f-c15fd4390666','MODEL'),(664,'d3d5ecdb-7933-478d-8f71-7bc13b2a4a05','079f92c4-4b00-409c-80e0-a0e0d55c599f','MODEL'),(664,'d3d5ecdb-7933-478d-8f71-7bc13b2a4a05','1c213c23-3396-431a-93b8-19834923ceac','SNAPSHOT'),(664,'d3d5ecdb-7933-478d-8f71-7bc13b2a4a05','48a56426-32f0-4b76-97af-cbfbecc8ec01','MODEL'),(664,'d3d5ecdb-7933-478d-8f71-7bc13b2a4a05','7abc6b39-6114-4da3-93f8-c62c489036d0','MODEL'),(664,'d3d5ecdb-7933-478d-8f71-7bc13b2a4a05','f40bab24-99ba-4240-a790-2cb8e6b01f50','MODEL'),(664,'d430aee6-4975-49d0-b4c3-b096e99e797e','1eb51e86-e26b-4152-910f-ae2c5f7866a1','SNAPSHOT'),(664,'d430aee6-4975-49d0-b4c3-b096e99e797e','325ce817-e744-4cd6-a84a-20a3e7c0e51f','MODEL'),(664,'d4321e90-28f8-42a0-bde1-b9ddcf321fa8','340a8526-0d08-4aa0-87ba-a804902b4809','MODEL'),(664,'d4321e90-28f8-42a0-bde1-b9ddcf321fa8','8831acae-6108-4d6d-a57e-1329a85fae48','SNAPSHOT'),(664,'d43bd9e0-44ee-49ed-aa89-8bcd9837b34a','0b8f8838-0705-45dd-9f7f-647814f9be33','SNAPSHOT'),(664,'d43bd9e0-44ee-49ed-aa89-8bcd9837b34a','2271f9bf-12c8-4420-b9f4-ce7ac01d3567','MODEL'),(664,'d43bd9e0-44ee-49ed-aa89-8bcd9837b34a','93860282-92b8-481f-9798-793726627785','MODEL'),(664,'d43bd9e0-44ee-49ed-aa89-8bcd9837b34a','a85cc64a-e5ae-46bc-a689-1e1c3eedfa28','SNAPSHOT'),(664,'d43bd9e0-44ee-49ed-aa89-8bcd9837b34a','b7f4db52-3cfb-4afd-9675-3e73291b6516','MODEL'),(664,'d5c1d30b-d8a4-4e8f-aae4-1e8dd2cb3dcb','045d5354-704b-45ba-bcdb-c155f28931f0','MODEL'),(664,'d5c1d30b-d8a4-4e8f-aae4-1e8dd2cb3dcb','1a2dc7bc-4e9d-498a-a92c-47648f21638e','SNAPSHOT'),(664,'d68295a5-6905-4f30-bc58-3732946b2594','1e09f189-8cf5-4779-8b20-93354ae9b869','MODEL'),(664,'d68295a5-6905-4f30-bc58-3732946b2594','24899f86-5dcc-4bdc-b6e0-afcf01d853e6','SNAPSHOT'),(664,'d7e952db-9527-4a27-a3cb-76863aa4d0de','2fdfa670-821a-41f5-b716-5a88cf4da71a','MODEL'),(664,'d7e952db-9527-4a27-a3cb-76863aa4d0de','aa6f8d0d-76df-4627-adec-a79670c64f0a','MODEL'),(664,'d7e952db-9527-4a27-a3cb-76863aa4d0de','d9aff01a-a913-4712-87f6-e63740863dd6','SNAPSHOT'),(664,'d7e952db-9527-4a27-a3cb-76863aa4d0de','f1be6500-2ee2-4256-aeb3-ae8bbdf150f7','SNAPSHOT'),(664,'d7e952db-9527-4a27-a3cb-76863aa4d0de','f5e47ce0-3489-42bc-8418-f6acf5dd3825','SCREENSHOT'),(664,'d8bbea0f-8405-4d13-8995-46a51be77eb1','873690c9-a6e0-4e29-a021-59cb35ba85b2','SNAPSHOT'),(664,'d8bbea0f-8405-4d13-8995-46a51be77eb1','a767ce19-6c12-462f-a9b9-da173ef005af','MODEL'),(664,'d94301ea-1f19-432a-a87d-bacbf222ca15','1513be81-d643-4691-8d62-03dba8adbfe0','MODEL'),(664,'d94301ea-1f19-432a-a87d-bacbf222ca15','27d4cc77-014f-4f8c-afb9-e5d972cfdc6d','SNAPSHOT'),(664,'ddf6985f-5bc1-11ee-9658-58a023cda0dc','53edd693-5bc2-11ee-9658-58a023cda0dc','MODEL'),(664,'ddf6985f-5bc1-11ee-9658-58a023cda0dc','53ede708-5bc2-11ee-9658-58a023cda0dc','SNAPSHOT'),(664,'ded778b4-0eef-4984-8f57-77502f727676','2b56c6fd-ec90-43d4-9a05-5032faa796d7','SNAPSHOT'),(664,'ded778b4-0eef-4984-8f57-77502f727676','48fd4959-6ba3-4711-9f3d-495f885551aa','MODEL'),(664,'ded778b4-0eef-4984-8f57-77502f727676','704684d5-4d3c-4d55-8ead-1380b7706142','SNAPSHOT'),(664,'ded778b4-0eef-4984-8f57-77502f727676','84d6771f-ac6b-4fea-aae5-db3f0a2b9e7b','SNAPSHOT'),(664,'ded778b4-0eef-4984-8f57-77502f727676','a596e547-dd1e-4bf9-9e36-fa59cfb5a615','MODEL'),(664,'ded778b4-0eef-4984-8f57-77502f727676','ad632823-c0d2-40d5-86fc-095a10d5a99c','MODEL'),(664,'ded778b4-0eef-4984-8f57-77502f727676','beb295f0-eb2c-47ac-9f65-fc24660f5548','MODEL'),(664,'ded778b4-0eef-4984-8f57-77502f727676','c728d7a1-0c1f-4906-a50b-630fec35bf21','SNAPSHOT'),(664,'e0fe2abf-8a0e-43f6-a437-3901a1d00a73','2ac78cb1-7fe6-4891-913c-92a2ec801fb0','SNAPSHOT'),(664,'e0fe2abf-8a0e-43f6-a437-3901a1d00a73','8595bdc6-5982-4e78-9884-facbcc949d9b','MODEL'),(664,'e145920a-617c-4eab-b810-0a863371eb36','70d2409c-e30f-487b-9df8-7257b6ffa89c','MODEL'),(664,'e145920a-617c-4eab-b810-0a863371eb36','91e10183-53a1-4f42-bf1f-d69b3d883102','SNAPSHOT'),(664,'e145920a-617c-4eab-b810-0a863371eb36','d6c21fa2-43a3-46ad-8b9a-3f2b83d486d1','SNAPSHOT'),(664,'e145920a-617c-4eab-b810-0a863371eb36','fbd69925-e519-4ae3-aced-20afc89720dd','MODEL'),(664,'e1f9f752-dd61-4e2b-82d8-016edf9173cf','48ce4b66-3e22-46f7-a16f-15d6b1e400d2','MODEL'),(664,'e1f9f752-dd61-4e2b-82d8-016edf9173cf','646bc5fd-fb97-4373-bb66-aa1a4b456f59','MODEL'),(664,'e1f9f752-dd61-4e2b-82d8-016edf9173cf','69546cbc-375a-4296-85e4-51c63cf5e93b','SNAPSHOT'),(664,'e1f9f752-dd61-4e2b-82d8-016edf9173cf','9adb67c5-8660-4e2c-b600-8f49fc13648e','MODEL'),(664,'e1f9f752-dd61-4e2b-82d8-016edf9173cf','b89bdf45-07f7-4aef-b272-f9b581b06b02','MODEL'),(664,'e1f9f752-dd61-4e2b-82d8-016edf9173cf','c6011a67-944d-4d49-a5fc-254bd45f74dd','SNAPSHOT'),(664,'e1f9f752-dd61-4e2b-82d8-016edf9173cf','eb7fffbc-7300-4a05-9936-5be07105c130','MODEL'),(664,'e2bb3a77-9462-11ee-8fd8-58a023cda0dc','78387199-9464-11ee-8fd8-58a023cda0dc','MODEL'),(664,'e2bb3a77-9462-11ee-8fd8-58a023cda0dc','78388176-9464-11ee-8fd8-58a023cda0dc','SNAPSHOT'),(664,'e64276ae-1a8c-45bd-adaa-f04086ada9e7','00687073-f108-4c8e-9cf4-e9202923866e','MODEL'),(664,'e64276ae-1a8c-45bd-adaa-f04086ada9e7','a6baa130-835b-4cb1-a503-815388979d65','SNAPSHOT'),(664,'e7c95c67-ccda-41e6-a581-e41824f1239b','300cfa5b-0b9c-4107-97d1-6abc2c9bc707','SCREENSHOT'),(664,'e7c95c67-ccda-41e6-a581-e41824f1239b','46f0433f-a2b0-4717-9b73-038d45591362','SNAPSHOT'),(664,'e7c95c67-ccda-41e6-a581-e41824f1239b','4b9a00b9-9475-4a79-b3e4-27abb98450fb','SCREENSHOT'),(664,'e7c95c67-ccda-41e6-a581-e41824f1239b','d81a9394-1d76-4e0d-bbe3-266fa262538c','MODEL'),(664,'ec2d4010-6686-4b96-af72-0ece2b145c0d','19cb4f51-a238-48cd-87f4-4a467eff9b55','SCREENSHOT'),(664,'ec2d4010-6686-4b96-af72-0ece2b145c0d','965138c3-5a1e-4951-83ee-9b341d1f7858','MODEL'),(664,'ec2d4010-6686-4b96-af72-0ece2b145c0d','9f39de7e-1b6c-4b52-9fe3-5dac8b5e6bd6','SNAPSHOT'),(664,'ec42315e-bad9-44b4-bfd3-e86342727df2','7c6afa34-7099-4eec-899b-517fb3c69b93','SNAPSHOT'),(664,'ec42315e-bad9-44b4-bfd3-e86342727df2','b2797bfd-383a-4f9c-938a-60fe8de8146a','MODEL'),(664,'ec557b87-5cb1-4e74-9d71-d45c543b3847','53261a1f-1472-46ca-86b2-d31b93df25ea','SCREENSHOT'),(664,'ec557b87-5cb1-4e74-9d71-d45c543b3847','bb25c8c5-6854-4fe0-be65-94e273c0d922','MODEL'),(664,'ec557b87-5cb1-4e74-9d71-d45c543b3847','ddb24d42-0269-4237-8622-4bac2c10e67c','SNAPSHOT'),(664,'ec70dd1f-5648-4918-9bce-b3384aeae579','36b6730b-4fd0-4262-8f5b-94b47eed92ad','MODEL'),(664,'ec70dd1f-5648-4918-9bce-b3384aeae579','49565264-afb5-47cf-84f8-2cf6b2e3db70','SNAPSHOT'),(664,'ec92e295-bf7c-4746-b7d5-8b1307a8e6ac','6ba3b93c-7fe0-487d-85f2-f5ecce29c698','MODEL'),(664,'ec92e295-bf7c-4746-b7d5-8b1307a8e6ac','8d7e965c-c4e0-4db2-a19b-7f924810555e','SNAPSHOT'),(664,'ec92e295-bf7c-4746-b7d5-8b1307a8e6ac','a047d137-c079-471d-9883-363f45da4686','SNAPSHOT'),(664,'ec92e295-bf7c-4746-b7d5-8b1307a8e6ac','f6f7c4d2-5903-4304-a422-d9bb1e118dc3','MODEL'),(664,'ed845142-2dca-48e8-8ec9-cc1f6a86f8cb','3af7d53f-e4c1-438d-b798-279238f381cd','SNAPSHOT'),(664,'ed845142-2dca-48e8-8ec9-cc1f6a86f8cb','93745579-3a16-4eae-8e26-3f1db1a2ff74','MODEL'),(664,'ee9462c8-7341-11ee-b011-58a023cda0dc','55567078-7342-11ee-b011-58a023cda0dc','MODEL'),(664,'ee9462c8-7341-11ee-b011-58a023cda0dc','55567fa8-7342-11ee-b011-58a023cda0dc','SNAPSHOT'),(664,'ef34ef6f-c00c-49e4-85b3-2c0aed9adcc0','5c40acb9-f5bf-4d61-88d0-9d2dd66c3554','MODEL'),(664,'ef34ef6f-c00c-49e4-85b3-2c0aed9adcc0','df24fb2c-781d-4e64-bdb6-e7de14400db3','SNAPSHOT'),(664,'eff3d296-ab91-4054-b8d3-6c78732ae1c8','25cf2022-f971-4fc1-8f62-e12d40279ada','SNAPSHOT'),(664,'eff3d296-ab91-4054-b8d3-6c78732ae1c8','3dea442a-9d7f-44ce-9213-342d4c17e409','MODEL'),(664,'f23ef241-b3d2-40c3-8f2d-1f815adfca52','b1748d9e-4e52-44c2-93da-a30fa0938311','SNAPSHOT'),(664,'f23ef241-b3d2-40c3-8f2d-1f815adfca52','bab90ee4-be72-463a-9fcc-241e88b8af7c','MODEL'),(664,'f3804f47-734c-11ee-b011-58a023cda0dc','7dd9b5ba-734e-11ee-b011-58a023cda0dc','MODEL'),(664,'f3804f47-734c-11ee-b011-58a023cda0dc','7dd9c4e0-734e-11ee-b011-58a023cda0dc','SNAPSHOT'),(664,'f3804f47-734c-11ee-b011-58a023cda0dc','85b94756-734d-11ee-b011-58a023cda0dc','MODEL'),(664,'f3804f47-734c-11ee-b011-58a023cda0dc','85b95611-734d-11ee-b011-58a023cda0dc','SNAPSHOT'),(664,'f3804f47-734c-11ee-b011-58a023cda0dc','f6888801-734d-11ee-b011-58a023cda0dc','MODEL'),(664,'f3804f47-734c-11ee-b011-58a023cda0dc','f6889746-734d-11ee-b011-58a023cda0dc','SNAPSHOT'),(664,'f40ef765-344e-4e93-b47e-d26b4b6db487','8e8c2efb-24ab-42d7-a4b2-e573d68ec234','SNAPSHOT'),(664,'f40ef765-344e-4e93-b47e-d26b4b6db487','939fcf5e-168c-450a-94f3-7fab10eeaf36','MODEL'),(664,'f7ca22c1-70d3-4f9e-8ccd-3187aea91801','4d04c526-a65f-4df6-8b9e-6fd50db8c7f5','MODEL'),(664,'f7ca22c1-70d3-4f9e-8ccd-3187aea91801','f7b69658-7329-44b7-94d8-6d69422ec7fd','SNAPSHOT'),(664,'f7d86e35-41e6-4047-8f44-4a7b73bc2680','4dd23da3-755d-4711-b5ae-c9d7d5b10fbb','SNAPSHOT'),(664,'f7d86e35-41e6-4047-8f44-4a7b73bc2680','fc458668-4919-430f-9240-de8f220a4dea','MODEL'),(664,'f99691b6-3bf9-4760-8115-1d1a52fc98ae','7e467afe-ef06-407f-8b25-d56d48c50f7e','MODEL'),(664,'f99691b6-3bf9-4760-8115-1d1a52fc98ae','b5c25896-3d52-4eca-b060-52a2c1dfad88','SNAPSHOT'),(664,'fdcb8fba-f16b-457a-8027-7f34eeace00b','3755b11e-0012-4854-85fa-011648f75dbb','SCREENSHOT'),(664,'fdcb8fba-f16b-457a-8027-7f34eeace00b','98005729-251e-46d8-9ac3-e9878a47b441','MODEL'),(664,'fdcb8fba-f16b-457a-8027-7f34eeace00b','9bde3553-f30d-4a50-b405-a030db17fb37','SNAPSHOT'),(664,'fe5df0bd-7cd7-42f8-ba75-4278d329b237','2262f65a-71dd-48bd-b8b8-698a6187dccc','SNAPSHOT'),(664,'fe5df0bd-7cd7-42f8-ba75-4278d329b237','91e3e40c-b1ea-42dd-ae35-8df274c2b234','MODEL'),(664,'fecdd55c-c22a-4e46-835e-a5780e62f261','74fa4d25-e0b6-40e6-8813-5e824074f25b','SNAPSHOT'),(664,'fecdd55c-c22a-4e46-835e-a5780e62f261','87299f65-8cc1-44b8-897a-a0da5547ddec','MODEL'),(664,'ffb4d4c8-4774-4512-bb36-ac65c37d00a5','48b32ef4-709e-463d-b524-33aba97c9150','MODEL'),(664,'ffb4d4c8-4774-4512-bb36-ac65c37d00a5','f8441bd9-d349-4766-abce-8df915b76b37','SNAPSHOT');
/*!40000 ALTER TABLE `ScanFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentAttachment`
--

DROP TABLE IF EXISTS `SentAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentAttachment` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`sentMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SentAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentAttachment`
--

LOCK TABLES `SentAttachment` WRITE;
/*!40000 ALTER TABLE `SentAttachment` DISABLE KEYS */;
INSERT INTO `SentAttachment` VALUES (664,'02eb4a7d-724b-45a4-b765-f2b70e2d92f4','4d04c526-a65f-4df6-8b9e-6fd50db8c7f5'),(664,'02eb4a7d-724b-45a4-b765-f2b70e2d92f4','8532f29a-bbac-4db3-af25-e87cb75618fc'),(664,'02eb4a7d-724b-45a4-b765-f2b70e2d92f4','f7b69658-7329-44b7-94d8-6d69422ec7fd'),(664,'0899ea9b-9c55-4426-b781-2c58435f34d4','055bb022-85cd-4a55-9a46-10afca2d621d'),(664,'0899ea9b-9c55-4426-b781-2c58435f34d4','185a70e3-8267-474e-aa32-a05eb5784fc8'),(664,'0899ea9b-9c55-4426-b781-2c58435f34d4','9e3589e8-4fb4-4877-a58c-cbb16190d186'),(664,'0899ea9b-9c55-4426-b781-2c58435f34d4','a540af64-2782-40e1-98e6-71a1da04b4e8'),(664,'0899ea9b-9c55-4426-b781-2c58435f34d4','c9b5fd6b-936f-473b-820c-1d017ed47794'),(664,'0899ea9b-9c55-4426-b781-2c58435f34d4','cf55af4f-6f13-40b8-8ac4-8ef9f3d0c140'),(664,'0e34b99d-b761-42f5-8ea8-376d97ca8739','12a9e53c-f4b6-42ea-9478-c84407313e24'),(664,'0e34b99d-b761-42f5-8ea8-376d97ca8739','23d0f00e-28e6-4e95-acb1-832d1d3440c2'),(664,'0e34b99d-b761-42f5-8ea8-376d97ca8739','4227ee27-5a61-436a-ae69-cd486657a34d'),(664,'0e34b99d-b761-42f5-8ea8-376d97ca8739','5b12fd9e-03c6-4145-8366-7a8646402a7c'),(664,'0e34b99d-b761-42f5-8ea8-376d97ca8739','7aa1b303-4eea-4bf0-85e6-2e29f68d0606'),(664,'0e34b99d-b761-42f5-8ea8-376d97ca8739','93e1d6ba-56ac-4322-aa8d-68802281f1de'),(664,'0e34b99d-b761-42f5-8ea8-376d97ca8739','d7259e03-f436-4b58-aeb9-cea3bf0a1d04'),(664,'17b49d95-96c1-44f3-a13f-7fbc2a688cac','26383578-97b4-469c-83c8-1399e6fdf5c9'),(664,'17b49d95-96c1-44f3-a13f-7fbc2a688cac','46f0433f-a2b0-4717-9b73-038d45591362'),(664,'17b49d95-96c1-44f3-a13f-7fbc2a688cac','9bad6bed-66cd-4aaf-9b18-74f56381c4d1'),(664,'17b49d95-96c1-44f3-a13f-7fbc2a688cac','c07ab4b3-ce6f-4eeb-859d-40b3c4631562'),(664,'17b49d95-96c1-44f3-a13f-7fbc2a688cac','d3c2fb35-0aff-4775-8c47-8085c2bb4a6c'),(664,'17b49d95-96c1-44f3-a13f-7fbc2a688cac','d81a9394-1d76-4e0d-bbe3-266fa262538c'),(664,'17b49d95-96c1-44f3-a13f-7fbc2a688cac','f81ac2c3-1a0f-4064-a1eb-844d818e111c'),(664,'1bb37b3b-87fe-4c38-9db3-ca8953b26747','0f3468b4-f1b8-411d-b79b-fb3966cbd43e'),(664,'1bb37b3b-87fe-4c38-9db3-ca8953b26747','2b6df65f-bc4e-4e8b-bfb9-2335bd73430a'),(664,'1bb37b3b-87fe-4c38-9db3-ca8953b26747','3ec22db4-d2af-489a-b0fa-4d4e8a20600e'),(664,'1bb37b3b-87fe-4c38-9db3-ca8953b26747','4d8982bd-2be0-44d1-b3dc-a68b3d43dca9'),(664,'1bb37b3b-87fe-4c38-9db3-ca8953b26747','58ee5bee-0fd9-4bba-89cb-cf99f01eb438'),(664,'1bb37b3b-87fe-4c38-9db3-ca8953b26747','9e6ac4cc-cd14-4cd9-813c-a58767782690'),(664,'1bb37b3b-87fe-4c38-9db3-ca8953b26747','abdd65b1-8e6c-4a9a-84db-e8a1b6437124'),(664,'1bb37b3b-87fe-4c38-9db3-ca8953b26747','d69f7757-7418-40a0-93ba-f0daeab65592'),(664,'1bb37b3b-87fe-4c38-9db3-ca8953b26747','d73ed817-72ee-4c83-a18a-a4b11b0b8c1a'),(664,'1cab555c-33d9-4ee5-a027-8587b9275bdf','a116495f-1bcf-4022-af0c-f807a25b1c9c'),(664,'1cab555c-33d9-4ee5-a027-8587b9275bdf','b67e5e75-e3bc-4168-9f8a-023260cf853b'),(664,'1cab555c-33d9-4ee5-a027-8587b9275bdf','fdc7cf45-27ee-493e-893d-702f5a989b40'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','0724c208-734f-11ee-b011-58a023cda0dc'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','0724d1c1-734f-11ee-b011-58a023cda0dc'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','273de692-7728-11ee-867e-58a023cda0dc'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','40d7a1b0-734f-11ee-b011-58a023cda0dc'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','40d7b163-734f-11ee-b011-58a023cda0dc'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','65c962f0-734f-11ee-b011-58a023cda0dc'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','65f84d65-734f-11ee-b011-58a023cda0dc'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','668d19f2-734f-11ee-b011-58a023cda0dc'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','7dd9b5ba-734e-11ee-b011-58a023cda0dc'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','7dd9c4e0-734e-11ee-b011-58a023cda0dc'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','c4cdf10c-734c-11ee-b011-58a023cda0dc'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','c4ce0fdf-734c-11ee-b011-58a023cda0dc'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','ca02c680-734e-11ee-b011-58a023cda0dc'),(664,'279b0e1d-7728-11ee-867e-58a023cda0dc','ca02d758-734e-11ee-b011-58a023cda0dc'),(664,'2813a60f-59c5-472a-899c-cd2844c9f1b4','1eb51e86-e26b-4152-910f-ae2c5f7866a1'),(664,'2813a60f-59c5-472a-899c-cd2844c9f1b4','30b6ba97-0b5b-4537-b214-3f4ade617b76'),(664,'2813a60f-59c5-472a-899c-cd2844c9f1b4','325ce817-e744-4cd6-a84a-20a3e7c0e51f'),(664,'2813a60f-59c5-472a-899c-cd2844c9f1b4','5c07f751-3020-45a0-bf20-21a6ed8a6aea'),(664,'2813a60f-59c5-472a-899c-cd2844c9f1b4','5c40acb9-f5bf-4d61-88d0-9d2dd66c3554'),(664,'2813a60f-59c5-472a-899c-cd2844c9f1b4','7c6afa34-7099-4eec-899b-517fb3c69b93'),(664,'2813a60f-59c5-472a-899c-cd2844c9f1b4','b2797bfd-383a-4f9c-938a-60fe8de8146a'),(664,'2813a60f-59c5-472a-899c-cd2844c9f1b4','b4eec334-5aa2-493f-8b80-4404dc464a71'),(664,'2813a60f-59c5-472a-899c-cd2844c9f1b4','ce3b2d45-df06-466e-8d53-72fb4fe941b8'),(664,'2813a60f-59c5-472a-899c-cd2844c9f1b4','d209ac69-fa89-4893-8e85-fde8f654efc3'),(664,'2813a60f-59c5-472a-899c-cd2844c9f1b4','df24fb2c-781d-4e64-bdb6-e7de14400db3'),(664,'2b5a9f4b-c501-489a-9405-cdb62d0bbc00','04d5729b-24fa-4bd7-aae0-731968a61592'),(664,'2b5a9f4b-c501-489a-9405-cdb62d0bbc00','15343a6d-e281-4739-bed5-c0bfe5f8f6c7'),(664,'2b5a9f4b-c501-489a-9405-cdb62d0bbc00','3c0b0988-7ac2-4e3d-ad84-4841bbd18966'),(664,'2b5a9f4b-c501-489a-9405-cdb62d0bbc00','93860282-92b8-481f-9798-793726627785'),(664,'2b5a9f4b-c501-489a-9405-cdb62d0bbc00','97fc9012-a54b-49d1-94c9-f89634ee71b9'),(664,'2b5a9f4b-c501-489a-9405-cdb62d0bbc00','a2099383-c46f-4a74-835e-82ef97668988'),(664,'2b5a9f4b-c501-489a-9405-cdb62d0bbc00','a85cc64a-e5ae-46bc-a689-1e1c3eedfa28'),(664,'2b5a9f4b-c501-489a-9405-cdb62d0bbc00','b1748d9e-4e52-44c2-93da-a30fa0938311'),(664,'2b5a9f4b-c501-489a-9405-cdb62d0bbc00','bab90ee4-be72-463a-9fcc-241e88b8af7c'),(664,'2b5a9f4b-c501-489a-9405-cdb62d0bbc00','c12d2c0a-871d-48e9-b3de-bc4c3e6cdc17'),(664,'2b5a9f4b-c501-489a-9405-cdb62d0bbc00','ccfc256c-f67b-43e6-859d-78f6db34fd4b'),(664,'312b8a43-767d-48c0-a3a7-92183f4e598d','0b848954-7152-4e87-b60c-76f5ac669614'),(664,'312b8a43-767d-48c0-a3a7-92183f4e598d','10d50154-eaad-4c7c-bcc0-5edad9315cc7'),(664,'312b8a43-767d-48c0-a3a7-92183f4e598d','1d98fd52-591a-40fc-8de1-36a02f534a6f'),(664,'312b8a43-767d-48c0-a3a7-92183f4e598d','4d2adaf7-8bfc-4e39-9074-1b71491a3303'),(664,'312b8a43-767d-48c0-a3a7-92183f4e598d','55150fc7-4024-45fc-9b2f-f474826b2d4d'),(664,'312b8a43-767d-48c0-a3a7-92183f4e598d','5bcef502-db73-4612-9311-f192c76e91fa'),(664,'312b8a43-767d-48c0-a3a7-92183f4e598d','5d8fe096-165a-4a91-ae19-6cbe10470e9c'),(664,'312b8a43-767d-48c0-a3a7-92183f4e598d','aa4e5c15-e939-46a6-a75e-c5b67cdbad7b'),(664,'312b8a43-767d-48c0-a3a7-92183f4e598d','c41ccbf2-b091-456a-af02-352476c4d367'),(664,'312b8a43-767d-48c0-a3a7-92183f4e598d','df32e9cc-0861-4ad7-ad2a-718737b05992'),(664,'312b8a43-767d-48c0-a3a7-92183f4e598d','eb3d7b07-28dd-4076-a69c-80c7abd0be51'),(664,'31ac96c0-ec22-40c1-8e5e-2d287834aa73','06bf9050-09ab-4cd9-82f1-c218c9a25dee'),(664,'31ac96c0-ec22-40c1-8e5e-2d287834aa73','248f95a0-ad8d-40f1-bf9e-68ceaee0d7ba'),(664,'31ac96c0-ec22-40c1-8e5e-2d287834aa73','2642f6d1-6c3f-4add-9a49-f8de19a8acfd'),(664,'31ac96c0-ec22-40c1-8e5e-2d287834aa73','2e76bc0f-07df-4175-add2-e13f7adb84e5'),(664,'31ac96c0-ec22-40c1-8e5e-2d287834aa73','422c8790-59bb-44d4-8423-88d7c4e220d7'),(664,'31ac96c0-ec22-40c1-8e5e-2d287834aa73','52853284-be7b-44e5-aeae-65e139601fcd'),(664,'31ac96c0-ec22-40c1-8e5e-2d287834aa73','6887579a-3781-49f4-a96e-de18760adf09'),(664,'31ac96c0-ec22-40c1-8e5e-2d287834aa73','a4fd2b33-3d5e-4e47-96d4-f1c6e8db2f68'),(664,'31ac96c0-ec22-40c1-8e5e-2d287834aa73','aa94138d-320f-44a7-9b36-953713b8552e'),(664,'31ac96c0-ec22-40c1-8e5e-2d287834aa73','c452aac6-05e7-48c3-aef6-2cb3a21d6dc4'),(664,'31ac96c0-ec22-40c1-8e5e-2d287834aa73','d46395de-c663-445e-93b7-6b0eef50a5d7'),(664,'31ac96c0-ec22-40c1-8e5e-2d287834aa73','da333d07-80cd-4439-adfd-9aaf2686eb08'),(664,'38f9f5c6-6c47-11ee-bc7f-58a023cda0dc','19eba3d6-6c36-11ee-bc7f-58a023cda0dc'),(664,'38f9f5c6-6c47-11ee-bc7f-58a023cda0dc','19ec321c-6c36-11ee-bc7f-58a023cda0dc'),(664,'38f9f5c6-6c47-11ee-bc7f-58a023cda0dc','389a8857-6c47-11ee-bc7f-58a023cda0dc'),(664,'38f9f5c6-6c47-11ee-bc7f-58a023cda0dc','9fa26aa6-6c36-11ee-bc7f-58a023cda0dc'),(664,'38f9f5c6-6c47-11ee-bc7f-58a023cda0dc','9fa279c1-6c36-11ee-bc7f-58a023cda0dc'),(664,'38f9f5c6-6c47-11ee-bc7f-58a023cda0dc','ceac08e6-6c36-11ee-bc7f-58a023cda0dc'),(664,'38f9f5c6-6c47-11ee-bc7f-58a023cda0dc','ceac18ef-6c36-11ee-bc7f-58a023cda0dc'),(664,'38f9f5c6-6c47-11ee-bc7f-58a023cda0dc','fcb6f107-6c34-11ee-bc7f-58a023cda0dc'),(664,'38f9f5c6-6c47-11ee-bc7f-58a023cda0dc','fcb700b3-6c34-11ee-bc7f-58a023cda0dc'),(664,'4020e0da-3c61-4de8-8773-080aa456c009','188b2bd0-af23-438c-b1c2-d75a6ce28b1c'),(664,'4020e0da-3c61-4de8-8773-080aa456c009','1e09f189-8cf5-4779-8b20-93354ae9b869'),(664,'4020e0da-3c61-4de8-8773-080aa456c009','24899f86-5dcc-4bdc-b6e0-afcf01d853e6'),(664,'4020e0da-3c61-4de8-8773-080aa456c009','70d2409c-e30f-487b-9df8-7257b6ffa89c'),(664,'4020e0da-3c61-4de8-8773-080aa456c009','91e10183-53a1-4f42-bf1f-d69b3d883102'),(664,'4020e0da-3c61-4de8-8773-080aa456c009','abe3d489-e27c-4ef9-bba3-b62ed55c8c9b'),(664,'4020e0da-3c61-4de8-8773-080aa456c009','d3a6ed76-d8dc-47e6-ae66-239731164381'),(664,'40662f0a-569d-4339-8052-9982814995b7','231fd3a6-6aa1-481c-84e8-fb456bdbae59'),(664,'40662f0a-569d-4339-8052-9982814995b7','46f88ef2-6c3e-4840-af4b-0cc2847372fa'),(664,'40662f0a-569d-4339-8052-9982814995b7','77c38694-17b8-404d-ba83-1b6a0859814a'),(664,'40662f0a-569d-4339-8052-9982814995b7','a3e7e135-bb5d-480a-ad23-66fef52084cd'),(664,'40662f0a-569d-4339-8052-9982814995b7','b48b199f-561e-4239-8141-bbd54b8a7a80'),(664,'40662f0a-569d-4339-8052-9982814995b7','b975305f-5425-46f9-8470-1c628b260f46'),(664,'40662f0a-569d-4339-8052-9982814995b7','c3ba59bf-d6c1-4148-b9f2-a2a974828687'),(664,'4492229d-1dd5-424d-b44a-d512d766a927','055bb022-85cd-4a55-9a46-10afca2d621d'),(664,'4492229d-1dd5-424d-b44a-d512d766a927','185a70e3-8267-474e-aa32-a05eb5784fc8'),(664,'4492229d-1dd5-424d-b44a-d512d766a927','9e3589e8-4fb4-4877-a58c-cbb16190d186'),(664,'4492229d-1dd5-424d-b44a-d512d766a927','a540af64-2782-40e1-98e6-71a1da04b4e8'),(664,'4492229d-1dd5-424d-b44a-d512d766a927','c9b5fd6b-936f-473b-820c-1d017ed47794'),(664,'4492229d-1dd5-424d-b44a-d512d766a927','cf55af4f-6f13-40b8-8ac4-8ef9f3d0c140'),(664,'45f23b8d-97e8-4dba-adfd-67a6227ae338','231fd3a6-6aa1-481c-84e8-fb456bdbae59'),(664,'45f23b8d-97e8-4dba-adfd-67a6227ae338','50ba84da-fbb3-4a82-ad28-44193c241742'),(664,'45f23b8d-97e8-4dba-adfd-67a6227ae338','77c38694-17b8-404d-ba83-1b6a0859814a'),(664,'45f23b8d-97e8-4dba-adfd-67a6227ae338','a3e7e135-bb5d-480a-ad23-66fef52084cd'),(664,'45f23b8d-97e8-4dba-adfd-67a6227ae338','b48b199f-561e-4239-8141-bbd54b8a7a80'),(664,'45f23b8d-97e8-4dba-adfd-67a6227ae338','b975305f-5425-46f9-8470-1c628b260f46'),(664,'45f23b8d-97e8-4dba-adfd-67a6227ae338','c3ba59bf-d6c1-4148-b9f2-a2a974828687'),(664,'4650a221-de48-447d-a404-38136acdf9c5','1b9fcd61-76d3-43bc-9436-552fe11a8a71'),(664,'4650a221-de48-447d-a404-38136acdf9c5','3f56431a-39e2-4537-933e-99ea66b80566'),(664,'4650a221-de48-447d-a404-38136acdf9c5','70a1ffe1-533c-49da-881c-10044b0e5fa8'),(664,'4650a221-de48-447d-a404-38136acdf9c5','7e92b49e-bc5f-4233-9657-58c0df873f81'),(664,'4650a221-de48-447d-a404-38136acdf9c5','896b62a5-2257-4335-b9f8-a711ad38d5c8'),(664,'4650a221-de48-447d-a404-38136acdf9c5','8ce4ae13-659c-4b1b-859a-61a6bce748d7'),(664,'4650a221-de48-447d-a404-38136acdf9c5','8e7ff8d7-eb67-4db2-84d7-7cf93584054d'),(664,'4650a221-de48-447d-a404-38136acdf9c5','a5d050d7-c6c8-47b6-a5c2-168e8fdbf905'),(664,'4650a221-de48-447d-a404-38136acdf9c5','aafe80ec-b241-47c3-98cb-9c43a7207ae2'),(664,'4650a221-de48-447d-a404-38136acdf9c5','b3abd969-6b20-48f6-9d4d-0fb8e4e2a650'),(664,'4650a221-de48-447d-a404-38136acdf9c5','c87746da-76e6-42d0-aa1a-53cd19375318'),(664,'4650a221-de48-447d-a404-38136acdf9c5','e31b565c-6205-4cad-ac46-f9268d3838c0'),(664,'4650a221-de48-447d-a404-38136acdf9c5','e9a1cf3e-9639-4ec7-8417-34a46ed30e75'),(664,'4ce6c6c0-20c5-47b3-84da-269ded4b6b00','4569d449-c0a3-4229-9f9d-9d173955cbd7'),(664,'4ce6c6c0-20c5-47b3-84da-269ded4b6b00','924eb01d-c7f1-4784-ab3d-bffa8647cc5a'),(664,'4ce6c6c0-20c5-47b3-84da-269ded4b6b00','a0dfdb3c-ddc2-421a-989f-e27c4e0c1866'),(664,'4ce6c6c0-20c5-47b3-84da-269ded4b6b00','aa6f8