-- MySQL dump 10.13  Distrib 8.0.30, for Linux (x86_64)
--
-- Host: localhost    Database: wow_patient
-- ------------------------------------------------------
-- Server version	8.0.30-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `uuid` varchar(36) NOT NULL,
  `line0` varchar(255) DEFAULT NULL,
  `line1` varchar(255) DEFAULT NULL,
  `line2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(255) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('018d7ddb-aa8a-413e-b823-363969b35fa2','','','',NULL,'Boston MA','','','','2021-01-18 20:23:27.000',NULL),('04368fb3-0a49-4800-ab22-95f322089034','','','',NULL,'','','','','2022-03-23 20:14:51.000','2024-10-31 10:02:21.704'),('06471c51-eac6-4ad3-9a53-ba44be0a02f4','','','',NULL,'','','','','2022-07-28 20:01:34.000',NULL),('06496373-1bde-45eb-a25e-706d37625fe2','','','',NULL,'','','','','2021-10-04 22:11:23.000',NULL),('0873f082-32c7-4fa8-9372-e981f5e52fbc','','','',NULL,'','','','','2022-09-07 18:41:12.000',NULL),('14e46232-0511-4327-b9df-b9e5a285ab41','','','',NULL,'','','','','2022-06-22 19:24:03.000',NULL),('1626454e-751c-4eaa-a552-f73d45b369dc','','','',NULL,'Silver Spring','','20910','','2020-11-24 02:30:27.000',NULL),('195dc712-039c-41ff-a906-ae51d726ea0a','','','',NULL,'','','','','2022-09-12 23:45:43.000',NULL),('1bdf4165-5d94-494d-aa5e-9e48d4b39c36','','','',NULL,'','','','','2021-06-21 21:55:32.000',NULL),('1cc93fdb-3a33-4655-be4b-b5ce49391bb6','','','',NULL,'','','','','2022-11-14 22:09:21.000',NULL),('1fa5f19c-f25f-41b0-83ad-8cf2dfce4202','','','',NULL,'','','','','2022-10-17 20:43:12.000',NULL),('210eb4f8-785c-4393-90ed-5b6431de3509','','','',NULL,'','','','','2020-11-30 07:31:10.000',NULL),('23b77ead-d00a-4600-95d8-f77b1bd15eac','','','',NULL,'','','','','2022-03-21 18:35:23.000',NULL),('29cf8430-bed1-4965-a66d-e5c558e290b7','','','',NULL,'','','','','2022-06-06 23:11:15.000','2024-08-28 08:08:35.563'),('29e7bda0-897b-4c7d-9d93-22e029bc6ec4','','','',NULL,'','','','','2021-10-04 22:11:23.000',NULL),('2ad02ffc-fc2b-4974-991a-7f38e865bb31','','','',NULL,'','','','','2021-09-28 21:02:52.000',NULL),('2f38dd06-9f97-4536-8c13-bf6d62af4b4e','','','',NULL,'','','','','2020-11-24 02:30:27.000',NULL),('32cf7f4f-40b1-4794-a6ef-97710dca2106','','','',NULL,'','','','','2021-06-21 22:41:15.000',NULL),('34a0d931-b5bf-4fb1-9e15-72bd69e26ee6','','','',NULL,'','','','','2021-05-03 23:00:28.000',NULL),('34b100da-85f3-4c35-b868-49bce85423e1','','','',NULL,'','','','','2021-04-10 01:51:41.000',NULL),('3d1bd1fd-837f-4fad-ac35-080abb38c3a6','','','',NULL,'','','20852','','2021-02-03 22:19:43.000',NULL),('3df1f1b6-6b2e-4400-a846-acaac4ae2942','','','',NULL,'','','','','2022-05-25 19:17:19.000',NULL),('42fdb23c-93f9-44e8-bb33-fbb4837637ac','','','',NULL,'','','','','2022-03-14 14:03:39.000','2023-05-22 09:12:38.054'),('469c0078-3c93-4512-8f16-93128dd4c482','','','',NULL,'','','','','2020-11-24 02:30:27.000',NULL),('46c4f21b-7338-11ee-b011-58a023cda0dc','4409 Ridgecrest Drive','','','','Suitland','','20746','','2024-10-31 14:02:21.732','2024-10-31 10:02:21.734'),('46c516b2-7338-11ee-b011-58a023cda0dc','','','','','','','','','2024-10-31 14:02:21.733','2024-10-31 10:02:21.734'),('49cd7d6e-bc04-4a21-85a5-de2cb211c9a4','10209 Sutherland Rd','','',NULL,'Silver Spring','','20901','','2021-04-10 01:51:41.000',NULL),('4bfbf60f-7631-4231-bca1-59013cf58aa0','','','',NULL,'','','','','2022-05-25 19:17:19.000',NULL),('4ff9b400-496d-4900-a275-584db6427a34','','','',NULL,'','','','','2022-11-16 22:49:06.000',NULL),('52de1ec1-8f0a-4fe3-8cf5-153f1ad5f2fc','','','',NULL,'','','','','2020-11-24 02:30:27.000',NULL),('56ae1983-b1f6-4d33-b6c1-7c52d36e3967','','','',NULL,'','','','','2021-05-03 23:00:28.000',NULL),('57fdd8c4-e194-4b38-ad9c-bfb0044df932','','','',NULL,'','','','','2022-06-22 20:34:17.000',NULL),('58bf00e1-4869-4307-8654-6686d947f35a','','','',NULL,'','','','','2020-11-24 02:30:27.000',NULL),('62ae0e54-4fbe-404c-9ea3-ba7d793b7862','','','',NULL,'North Bethesda','','','','2021-02-03 22:20:06.000',NULL),('67e848bc-7259-484d-8ac1-cebbaa6a1c71','','','',NULL,'','','','','2022-09-07 20:08:43.000',NULL),('68d89e1e-8e5f-4528-a115-83eef3475f8c','','','',NULL,'','','','','2021-04-09 23:20:15.000',NULL),('6befcc43-cce2-4e7d-bfdf-716c738958d9','','','',NULL,'','','','','2020-11-24 02:30:27.000',NULL),('6c5cea64-c5e1-4f7d-938f-08541b1b27cf','','','',NULL,'','','','','2020-11-23 20:30:27.000',NULL),('727d8198-00b7-46b9-80a4-b86cbca8c9e9','','','',NULL,'','','','','2022-11-16 22:49:06.000',NULL),('75edfe96-a6fe-4e12-b19a-c419098be201','','','',NULL,'','','','','2021-01-18 22:13:46.000',NULL),('766c30ba-c693-41ce-b107-d713951180fd','','','',NULL,'','','','','2022-02-28 12:59:36.000',NULL),('7778a3e6-2b07-4ccd-b18f-c69aeae8d2bf','','','',NULL,'','','','','2022-09-07 20:08:43.000',NULL),('7fc13f6a-b22d-431c-9e0f-2485d416b2a5','','','',NULL,'','','','','2022-06-06 23:11:15.000','2024-08-28 08:08:35.563'),('8089657d-da9d-4ca7-a027-8fed2d748261','','','',NULL,'','','','','2022-07-18 20:33:34.000',NULL),('85c6d6ee-2b0c-4476-a32a-057b8c62e895','','','',NULL,'','','','','2022-08-03 19:28:42.000',NULL),('867111fa-5599-4f3d-a599-80ce3aadc485','9339 S. Whitt Drive','','',NULL,'Manassas','','20111','','2021-01-18 22:14:24.000',NULL),('8b4f8db2-044e-47a3-8513-cbe0f7fabca9','','','',NULL,'Washington Burrough','','','','2021-09-14 00:48:45.000',NULL),('8be64c2e-21ee-4eec-9608-94b32adfafbe','','','',NULL,'','','','','2020-11-30 07:31:08.000',NULL),('8d9e361e-2dab-4b75-b7ed-c75066689fe5','','','',NULL,'','','','','2022-06-22 19:24:03.000',NULL),('8db4b977-d278-40aa-af45-264d5cec8d3e','','','',NULL,'','','','','2022-07-28 20:01:39.000',NULL),('8f1ac8df-10f1-490e-96f0-bd3224c94a94','','','',NULL,'','','','','2022-06-20 23:21:45.000',NULL),('9113090b-69b9-4ec0-be0b-3dbcb5270023','','','',NULL,'','','','','2022-03-23 20:14:51.000','2024-10-31 10:02:21.704'),('9136761f-5088-43bc-a11a-1e05d25c5941','','','',NULL,'','','','','2022-09-12 23:45:43.000',NULL),('97495b31-1f47-4873-a286-a36b0476badd','','','',NULL,'','','','','2022-03-14 14:03:39.000','2023-05-22 09:12:38.054'),('9777266b-12cd-4263-a908-faaf7d739902','','','',NULL,'','','','','2022-07-18 20:33:34.000',NULL),('9b0e9a13-a67e-4a2b-a47c-0bf3f1b13991','','','',NULL,'','','','','2021-01-18 20:21:46.000',NULL),('9b5ae500-d013-4da2-8398-fb4be512b2d9','','','',NULL,'','','','','2022-04-11 20:00:40.000',NULL),('9b859e3c-9e28-4473-8386-b7069d1af9c4','','','',NULL,'','','','','2021-09-14 00:48:00.000',NULL),('a197fe34-311d-4d3f-9fd4-c2cf33594a50','','','',NULL,'','','','','2022-10-31 20:39:14.000',NULL),('a687eb67-464f-44fe-a0c0-715a3004ca47','','','',NULL,'','','','','2022-08-17 22:03:33.000',NULL),('a938f7e1-4735-448c-9a33-766c7407fc92','','','',NULL,'','','','','2021-06-21 22:41:15.000',NULL),('ae72d535-9461-11ee-8fd8-58a023cda0dc','','','','','','','','','2023-12-06 18:02:55.486','2023-12-06 13:10:21.156'),('ae72f6c4-9461-11ee-8fd8-58a023cda0dc','','','','','','','','','2023-12-06 18:02:55.490','2023-12-06 13:10:21.156'),('aea27288-977f-11ef-8187-58a023cda0dc','','','','','','','','','2024-10-31 12:00:11.834',NULL),('aea28446-977f-11ef-8187-58a023cda0dc','','','','','','','','','2024-10-31 12:00:11.837',NULL),('b078d0f8-5e0e-4fda-bc8c-118b448476a1','','','',NULL,'','','','','2020-11-24 02:30:27.000',NULL),('b0cfb433-47f8-47ba-896e-54f8db142bf7','','','',NULL,'','','','','2023-02-20 20:27:24.000',NULL),('b144a4b8-0109-46c5-b916-0a6e77e3a37c','','','',NULL,'Upper Marlboro','','20072','','2020-11-24 02:30:27.000',NULL),('b3a23384-62c3-48b1-8cd0-95e9c806b530','','','',NULL,'','','','','2022-11-14 22:09:21.000',NULL),('b3b4ee5a-533a-4cff-adde-df6587ba685d','','','',NULL,'','','','','2022-09-14 21:49:36.000',NULL),('b4c651f7-9837-11ee-86e7-58a023cda0dc','','','','','','','','','2024-10-31 14:02:21.751','2024-10-31 10:02:21.753'),('b4c66e55-9837-11ee-86e7-58a023cda0dc','','','','','','','','','2024-10-31 14:02:21.752','2024-10-31 10:02:21.753'),('b5e6c67e-c596-4c05-bd43-a5a85f651b74','','','',NULL,'','','','','2022-04-11 20:00:40.000',NULL),('b897fdd9-ce49-4a80-b039-72094dbc5ff9','','','',NULL,'','','','','2022-10-31 20:39:14.000',NULL),('ba89d306-9bda-4526-bc4d-38a2fa6609e5','','','',NULL,'','','','','2022-06-22 20:34:17.000',NULL),('bbc79f13-6c30-11ee-bc7f-58a023cda0dc','','','','','','','','','2024-10-31 14:02:21.717','2024-10-31 10:02:21.718'),('bbc7b56a-6c30-11ee-bc7f-58a023cda0dc','','','','','','','','','2023-10-16 14:31:45.980','2024-10-31 10:02:21.718'),('bd9e8d83-96c5-11ef-8234-58a023cda0dc','','','','','','','','','2024-10-30 13:49:10.605','2024-10-30 09:49:21.350'),('bd9ea7de-96c5-11ef-8234-58a023cda0dc','','','','','','','','','2024-10-30 13:49:10.608','2024-10-30 09:49:21.350'),('bf406a84-0675-4452-9997-132af2cabf84','','','',NULL,'','','','','2020-11-24 02:30:27.000',NULL),('c01c1c75-5825-46d8-bf85-eb19241375f3','','','',NULL,'','','','','2021-09-14 21:44:29.000',NULL),('c1247e71-d228-4b57-8e01-0dbe4a75c38b','','','',NULL,'','','','','2022-07-28 20:01:39.000',NULL),('c264e23d-e22a-4762-9ed2-05f187afb37d','','','',NULL,'','','','','2020-11-24 02:30:27.000',NULL),('c9c6013a-8a5a-42b0-a46b-e5dce825ece2','','','',NULL,'','','','','2022-07-28 20:01:34.000',NULL),('ccba2298-5db2-4385-a1ef-39d943b55911','','','',NULL,'','','','','2022-08-03 19:28:42.000',NULL),('d578e7a5-c45b-48f4-b559-370147ebc982','','','',NULL,'','','','','2021-06-21 21:55:32.000',NULL),('d68c62c4-5dcb-4b59-b0c2-e272c4672d82','','','',NULL,'','','','','2022-02-28 12:59:36.000',NULL),('d986aaae-8fcc-11ef-b6be-58a023cda0dc','','','','','','','','','2024-10-31 14:02:21.768','2024-10-31 10:02:21.770'),('d986b497-8fcc-11ef-b6be-58a023cda0dc','','','','','','','','','2024-10-31 14:02:21.769','2024-10-31 10:02:21.770'),('dbe96fdd-8df1-45b2-9910-307397f9ab58','','','',NULL,'','','','','2022-06-20 23:21:45.000',NULL),('dda2168a-88a1-42ee-b0ba-ad2622c83f0a','','','',NULL,'','','','','2022-03-14 13:58:57.000',NULL),('df7dbae3-7332-4d62-baac-6d1b4522384a','','','',NULL,'','','','','2020-11-30 07:31:08.000',NULL),('e3317c44-d2d0-40e2-b53f-b36417226b31','','','',NULL,'','','','','2023-02-20 20:27:24.000',NULL),('e5ea0d04-9f6f-4cb3-b13e-e94f79cf8fdf','','','',NULL,'','','','','2022-09-14 21:49:36.000',NULL),('e65c8473-85ba-4a2a-9cfb-73bd45782738','','','',NULL,'','','','','2021-09-14 21:44:29.000',NULL),('e83a6fa1-5f28-4248-92c4-a27ff516e6eb','','','',NULL,'','','','','2022-03-23 17:57:43.000',NULL),('ed129929-fe7d-40ae-b52d-96a97caaf5f1','','','',NULL,'','','','','2022-08-17 22:03:33.000',NULL),('ee5e0cf4-b944-4080-9cae-495c2c73ee0d','','','',NULL,'','','','','2022-03-23 17:57:43.000',NULL),('efedd2d8-663e-4153-8d12-e17602c6573f','','','',NULL,'','','','','2022-03-21 18:35:23.000',NULL),('f1ccce5e-17de-4d08-b206-ed4769cb4905','','','',NULL,'','','','','2022-09-07 18:41:12.000',NULL),('f2e58ed2-0284-4956-b22e-4001adc89bee','','','',NULL,'','','','','2020-11-24 02:30:27.000',NULL),('f403ef07-98c4-44e0-a257-0cfc5c76ef7a','8001 Maden Road\nUnit 204','','',NULL,'Greenbelt','','20770','','2020-11-24 02:30:27.000',NULL),('f41a88dd-d163-424b-b817-d6c90cdf9196','','','',NULL,'','','','','2020-11-30 07:31:08.000',NULL),('f69daa85-c684-4a54-9fad-2aad44abf2d7','','','',NULL,'','','','','2022-03-14 13:58:57.000',NULL),('f91b6184-6fcf-4e99-9331-4fac063a76a3','','','',NULL,'','','','','2021-09-28 21:02:52.000',NULL),('fbdb0a58-53b2-4df7-bc08-f7b742048a67','','','',NULL,'Ellicott City','','2103','','2020-11-24 02:30:27.000',NULL),('fc784e68-3960-4af6-8344-7611ef433b87','','','',NULL,'','','','','2020-11-23 20:30:27.000',NULL),('fd2e3c07-f7fe-4341-b8bb-1ca921d781ec','','','',NULL,'','','','','2020-11-30 07:31:08.000',NULL),('fe1f7c67-19d4-4b1a-84fa-5e473faf2012','','','',NULL,'','','','','2022-10-17 20:43:12.000',NULL),('ffb50b71-c761-4e8b-ae0e-eee96fb111f6','','','',NULL,'','','','','2021-04-09 23:20:15.000',NULL);
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `EmergencyContact`
--

DROP TABLE IF EXISTS `EmergencyContact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `EmergencyContact` (
  `uuid` varchar(36) NOT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  CONSTRAINT `EmergencyContact_ibfk_1` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `EmergencyContact_ibfk_2` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `EmergencyContact_ibfk_3` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `EmergencyContact`
--

LOCK TABLES `EmergencyContact` WRITE;
/*!40000 ALTER TABLE `EmergencyContact` DISABLE KEYS */;
INSERT INTO `EmergencyContact` VALUES ('029beb3d-0351-47d4-a608-821f8a9d2455','c20d7fb4-af1a-4065-b403-be968cbdebf7','ea55bd84-b82c-4e24-9bb9-b027122daa7c','b3a23384-62c3-48b1-8cd0-95e9c806b530','2022-11-14 22:09:21.000',NULL),('02e650fb-95f3-41d8-b23e-c3fb7ba5af8c','dd44877d-fc3e-40b3-8656-bd24780f6bad','396413f4-a9b0-4d1d-8953-db92304da2a3','ccba2298-5db2-4385-a1ef-39d943b55911','2022-08-03 19:28:42.000',NULL),('0bd96953-c3c6-4fbd-980a-ccdc7821a2d4','94629651-fdf5-4670-85c1-a0b73fcfd2ff','31c4041b-d930-4909-bc9b-9a8a03af5e5c','fc784e68-3960-4af6-8344-7611ef433b87','2020-11-23 20:30:27.000',NULL),('11c801b5-4307-47c6-84a2-4c28d55514b1','8f2e6b79-2bff-4916-bf5d-0a6230b6dbde','f575db82-713c-451c-8ef7-ebc5429472bd','8d9e361e-2dab-4b75-b7ed-c75066689fe5','2022-06-22 19:24:03.000',NULL),('1244aeb6-4c9f-4183-94a4-1790e6e20a17','247f62e8-844b-4a47-a1af-337bd111103d','8346eaac-6c03-483c-a6d9-4bbe43d21c64','f91b6184-6fcf-4e99-9331-4fac063a76a3','2021-09-28 21:02:52.000',NULL),('1421d04f-e479-4417-8cc1-37384c9c02af','dbefae4c-c5ae-437a-a1b4-4911b2cc885a','b2686e03-88ae-45d1-bebe-4cc41e8729b7','a687eb67-464f-44fe-a0c0-715a3004ca47','2022-08-17 22:03:33.000',NULL),('1a265160-d43d-41f0-9a33-2073b96e8710','9a0cdfd8-0546-4cd4-b00e-3ec961f9b09b','4c352aac-85f3-4eb9-8401-bd2f333e6dd6','df7dbae3-7332-4d62-baac-6d1b4522384a','2020-11-24 02:30:27.000',NULL),('1c00b42a-478d-4726-b088-187e59771666','1293ad42-ca3f-4ba8-b478-dec9ed31aef7','67d10708-c4da-4b54-9d6f-e64080db6219','b078d0f8-5e0e-4fda-bc8c-118b448476a1','2020-11-24 02:30:27.000',NULL),('231c88b8-c542-4d5d-929c-3f3db02755a3','735f3029-cc4d-4fbc-8e8c-4c2877f3fb05','f3d694c8-f041-4218-91e6-81c0cc060e51','97495b31-1f47-4873-a286-a36b0476badd','2023-05-22 13:12:31.592','2023-05-22 09:12:38.054'),('2a1cb95f-7b5b-4867-90aa-7dfdef768aa1','56d159ad-da33-4b05-b008-424f7b2746a5','3694cd4f-fa0f-47f5-91ee-72c590ba6232','1fa5f19c-f25f-41b0-83ad-8cf2dfce4202','2022-10-17 20:43:12.000',NULL),('2d6b40c5-1910-43fc-abad-e99f255f3a48','5ed9c45f-f285-44f9-82e2-e7cad1590748','b63a1867-674b-47bb-beab-18629e7aace7','210eb4f8-785c-4393-90ed-5b6431de3509','2020-11-24 02:30:27.000',NULL),('31825b5a-ba33-4778-9402-19c6b8d0d38a','57227a54-23de-4957-b102-a62bdfced80c','818f38d6-2f94-4cb7-843d-5089aa76b3a8','7fc13f6a-b22d-431c-9e0f-2485d416b2a5','2024-08-28 12:08:35.539','2024-08-28 08:08:35.563'),('31e5fc49-573e-41bf-af9f-3cdbe7908a6e','ff8f74c4-427c-40a5-83aa-3c5256303b6e','5d2622d9-2ecb-4655-99d5-5ceb265f355a','6befcc43-cce2-4e7d-bfdf-716c738958d9','2020-11-24 02:30:27.000',NULL),('3440d676-a2c0-4aa9-80fd-9896721634e3','bb8ae5bf-6630-43ea-a404-0b07d8c0fbb4','5b45784f-2835-4ca7-834e-702923859661','34b100da-85f3-4c35-b868-49bce85423e1','2021-04-10 01:51:41.000',NULL),('34b95f36-d676-4c12-888a-ef2c923e5b33','da559747-65f0-4c69-9a17-fba35d3bfcf7','76e2133c-e831-4a17-9855-321d32c85c5c','c9c6013a-8a5a-42b0-a46b-e5dce825ece2','2022-07-28 20:01:34.000',NULL),('36afa9db-9f13-44f6-b481-890a69cf408c','51b4aeff-8b06-472f-a8e1-956f7951f13f','c8da98b4-3c24-488b-8fbc-476c469b66e9','d578e7a5-c45b-48f4-b559-370147ebc982','2021-06-21 21:55:32.000',NULL),('457a09f7-6db5-4a90-8eae-7921997f9a83','7544dde9-215d-4a74-8d6b-71757623f9d4','d9b98438-a9fc-429a-9366-6460c00965d5','469c0078-3c93-4512-8f16-93128dd4c482','2020-11-24 02:30:27.000',NULL),('46c50046-7338-11ee-b011-58a023cda0dc','46c50a3d-7338-11ee-b011-58a023cda0dc','46c51046-7338-11ee-b011-58a023cda0dc','46c516b2-7338-11ee-b011-58a023cda0dc','2024-10-31 14:02:21.733','2024-10-31 10:02:21.734'),('4c9bc35d-5f46-457d-9577-f406e6e95375','1e63c8d1-f1ab-4765-95ec-90cb6d017920','cc9dc84d-3563-4817-ba9d-34b8086cc547','dda2168a-88a1-42ee-b0ba-ad2622c83f0a','2022-03-14 13:58:57.000',NULL),('4d66a5cb-072c-43eb-8ce7-666100e82f69','ec73d078-510f-4c35-bf7e-e50e2cd94ea9','47a5d6be-81d1-4a10-93ed-aa19795afdeb','d68c62c4-5dcb-4b59-b0c2-e272c4672d82','2022-02-28 12:59:36.000',NULL),('4e0462c0-497a-40d6-b4e4-1891fe6b8bef','b2a4588e-f6c8-4d2a-b508-74ef38a5d5d3','2f5d052f-af23-491f-aef2-a08c7447d936','f2e58ed2-0284-4956-b22e-4001adc89bee','2020-11-24 02:30:27.000',NULL),('5321f2d8-ff34-4ba6-a468-c211245b3681','3a414daa-6a8b-4f26-8c64-7dd9475fd299','765be30c-baf5-4b1d-a093-db941efd2c30','62ae0e54-4fbe-404c-9ea3-ba7d793b7862','2021-02-03 22:19:00.000',NULL),('55344909-ab31-4f4e-bb0b-82081011bcaf','ef22a6a1-3819-4f39-949f-0ea8b334b264','5ca0d104-e868-4f00-bb60-b52dedfcbb2a','b897fdd9-ce49-4a80-b039-72094dbc5ff9','2022-10-31 20:39:14.000',NULL),('5e2288dd-8680-4751-ba11-b0a7add59532','5289ea1e-3956-4c11-97cc-261e6d209700','c1e16914-6511-42df-8bec-3431107f78fd','dbe96fdd-8df1-45b2-9910-307397f9ab58','2022-06-20 23:21:45.000',NULL),('601bec78-e475-4969-be40-953feeae4207','1b2c0b89-679f-451c-8014-e832ed498ede','eed7a006-cb96-445a-8173-85594ba48cc1','7778a3e6-2b07-4ccd-b18f-c69aeae8d2bf','2022-09-07 20:08:43.000',NULL),('74f1a4b8-d055-4ca0-8c06-e231608e5f22','174792ad-24ca-4246-af26-ab37936d2f8c','cccc8f4b-0bc2-4c4f-87f6-eb58bb80ea24','0873f082-32c7-4fa8-9372-e981f5e52fbc','2022-09-07 18:41:12.000',NULL),('79d87f3d-0e8e-40b8-8837-a2744bb623b6','83936706-ace3-452a-9c97-15f2b0951973','661b7462-36e5-4ede-a8a9-985c5941aff9','29e7bda0-897b-4c7d-9d93-22e029bc6ec4','2021-10-04 22:11:23.000',NULL),('7a19f42d-98c5-4c04-966e-aa2fe179bb7d','2240a054-49c0-494f-900a-6c3ed006fdfc','a94088fe-ea2c-42d9-8daf-55253d4f3542','57fdd8c4-e194-4b38-ad9c-bfb0044df932','2022-06-22 20:34:17.000',NULL),('7ac12a2d-46bf-4772-871c-edac267ebf1f','bed14763-b776-4e8c-a45e-1f67f500e901','7dba382b-45b4-4029-9a31-488e74ee34a9','a938f7e1-4735-448c-9a33-766c7407fc92','2021-06-21 22:41:15.000',NULL),('7f7c2d40-c598-47a7-b254-4691c495a556','e8bf5f04-8965-4555-a14d-7947b95a9e1a','e13a9a2e-0619-4a5f-aec5-21991438d62c','8089657d-da9d-4ca7-a027-8fed2d748261','2022-07-18 20:33:34.000',NULL),('86566a08-d0d6-4cd0-adf6-acd8d3c0de96','44d019c8-813f-4920-9795-a23a68d929e1','110f5fb7-7d7c-4b0a-80df-3fb5ce7e26c6','75edfe96-a6fe-4e12-b19a-c419098be201','2021-01-18 22:13:40.000',NULL),('873011ac-aa79-484a-bc57-8ad757bbceac','90f85ecf-9648-4ef8-8baf-4254e198f8ba','05232a32-cd6c-4060-af62-12a92d2b91a0','34a0d931-b5bf-4fb1-9e15-72bd69e26ee6','2021-05-03 23:00:28.000',NULL),('8d052bf4-bcd3-494d-9b03-3435b16fe6fa','a9f1a61d-e95a-4f97-9cec-f0d6a5022271','2e7bc3da-92b0-4294-bc09-984d90c7cc56','b5e6c67e-c596-4c05-bd43-a5a85f651b74','2022-04-11 20:00:40.000',NULL),('9075921a-74e6-446f-8a1c-df8d8235e482','ebce4b1b-735f-4e96-ab86-3e7c15bcc149','79a43f61-b086-49ff-ba69-6ce7c7e33bbe','9b0e9a13-a67e-4a2b-a47c-0bf3f1b13991','2021-01-18 20:21:21.000',NULL),('9b2edb0f-5e2c-4d52-b346-b3f032d5aded','7b9c5cbb-5d7a-40e5-a6cf-808ba407fa56','968509ca-1a4f-4209-a809-f5230a29443c','f41a88dd-d163-424b-b817-d6c90cdf9196','2020-11-24 02:30:27.000',NULL),('9f8c0283-4225-43e5-80cc-043fced0cdd9','64ab8cf0-9928-42b0-addd-c4e31282c0fb','821a1207-38ba-47bb-b1c9-0a507bf5c12e','c01c1c75-5825-46d8-bf85-eb19241375f3','2021-09-14 21:44:29.000',NULL),('a25db60d-1e47-430b-b5a4-4eb3ab0782af','d2e39f6c-9803-40de-8785-b75960bb0f84','ba8e2902-70d0-4b52-9a53-896789ad20e8','8db4b977-d278-40aa-af45-264d5cec8d3e','2022-07-28 20:01:39.000',NULL),('ae72df04-9461-11ee-8fd8-58a023cda0dc','ae72e4d9-9461-11ee-8fd8-58a023cda0dc','ae72ea14-9461-11ee-8fd8-58a023cda0dc','ae72f6c4-9461-11ee-8fd8-58a023cda0dc','2023-12-06 18:02:55.491','2023-12-06 13:10:21.156'),('aea2768d-977f-11ef-8187-58a023cda0dc','aea27a62-977f-11ef-8187-58a023cda0dc','aea27ef2-977f-11ef-8187-58a023cda0dc','aea28446-977f-11ef-8187-58a023cda0dc','2024-10-31 12:00:11.838',NULL),('b1d2d79c-f18c-42f4-9bf0-1c6302ac5be2','794c8467-4d4d-4b9f-a3d2-ac62362c315f','16482c80-46c2-42db-b8ed-cb7a7f1e93ae','ffb50b71-c761-4e8b-ae0e-eee96fb111f6','2021-04-09 23:20:15.000',NULL),('b2331267-681e-41ce-8ae0-dcde614beb66','17f98140-5dd9-46ac-91a4-d7af6f8ae4d1','85c06696-f347-41e3-9c5e-cd2481c1ac78','58bf00e1-4869-4307-8654-6686d947f35a','2020-11-24 02:30:27.000',NULL),('b4c65baa-9837-11ee-86e7-58a023cda0dc','b4c6648e-9837-11ee-86e7-58a023cda0dc','b4c669ea-9837-11ee-86e7-58a023cda0dc','b4c66e55-9837-11ee-86e7-58a023cda0dc','2024-10-31 14:02:21.752','2024-10-31 10:02:21.753'),('bbc7a583-6c30-11ee-bc7f-58a023cda0dc','bbc7ab18-6c30-11ee-bc7f-58a023cda0dc','bbc7b043-6c30-11ee-bc7f-58a023cda0dc','bbc7b56a-6c30-11ee-bc7f-58a023cda0dc','2024-10-31 14:02:21.717','2024-10-31 10:02:21.718'),('bd1da209-d422-4f1d-bd9d-cf6e3db15166','e117fe58-3331-4a28-b8b4-1197e0ff435c','a91e1b07-36e2-4c10-88eb-3dfdde65324c','b3b4ee5a-533a-4cff-adde-df6587ba685d','2022-09-14 21:49:36.000',NULL),('bd9e9617-96c5-11ef-8234-58a023cda0dc','bd9e9e69-96c5-11ef-8234-58a023cda0dc','bd9ea34c-96c5-11ef-8234-58a023cda0dc','bd9ea7de-96c5-11ef-8234-58a023cda0dc','2024-10-30 13:49:10.610','2024-10-30 09:49:21.350'),('c4e13c4b-df4f-41b6-82c2-e06c3244a213','791c87cf-bb3a-4fee-955a-d7e38422b5c3','41ccb456-23bc-4e7f-b84e-47239f618f97','9136761f-5088-43bc-a11a-1e05d25c5941','2022-09-12 23:45:43.000',NULL),('c7b9e1d8-35e7-4e0a-8ef5-c729e51bea1c','a38dbe4d-799c-4e58-b56d-b789ff958b1e','3e8f7698-a8a2-4a71-a1b0-ed2158eb1841','9113090b-69b9-4ec0-be0b-3dbcb5270023','2024-10-31 14:02:21.703','2024-10-31 10:02:21.704'),('c7c05633-ca4f-4749-83db-c604140a933e','279c8cf1-33ec-4fec-8004-cce1f70597e2','2433b3c4-6f05-46ac-a06d-bfbad512cca1','23b77ead-d00a-4600-95d8-f77b1bd15eac','2022-03-21 18:35:23.000',NULL),('c9794517-8c51-4a79-b4ed-0f65ce3f09f2','121d3b61-1014-46ad-8c42-0b1f52da493a','50daf4c9-c0dd-40a8-962a-8d98abed8791','ee5e0cf4-b944-4080-9cae-495c2c73ee0d','2022-03-23 17:57:43.000',NULL),('cd2efa58-3f0a-4282-8fa6-8b3eb31a3481','24f75dc7-8759-497c-a3f2-b39780f17bcc','9a4087a0-50a8-4092-93c0-0b3f6bca94ec','727d8198-00b7-46b9-80a4-b86cbca8c9e9','2022-11-16 22:49:06.000',NULL),('d23b47e0-134c-40ab-9556-ee0ce92a3dad','52a1d1bd-775c-4876-a2cf-ab12d48e5679','e16399c2-e013-4027-95cb-78eecb666cad','4bfbf60f-7631-4231-bca1-59013cf58aa0','2022-05-25 19:17:19.000',NULL),('d68f2f9f-4cb7-4002-8db0-9c30b5eee295','f5e04015-ebde-4bcd-8f76-ff744ebf6755','3ed73c88-0f52-4762-a85c-029f8e3834c8','e3317c44-d2d0-40e2-b53f-b36417226b31','2023-02-20 20:27:24.000',NULL),('d986ad8e-8fcc-11ef-b6be-58a023cda0dc','d986aff0-8fcc-11ef-b6be-58a023cda0dc','d986b245-8fcc-11ef-b6be-58a023cda0dc','d986b497-8fcc-11ef-b6be-58a023cda0dc','2024-10-31 14:02:21.769','2024-10-31 10:02:21.770'),('ecff512e-4f20-4952-a91c-717ffe7d0f3d','bc80a812-7f76-46d2-be47-955208bdb166','8396d7f3-0a3d-418b-bd91-eba052344744','9b859e3c-9e28-4473-8386-b7069d1af9c4','2021-09-14 00:48:00.000',NULL),('f8ae6051-bf51-4f68-bbc4-3eb43bc8b8b3','68b5a331-bb21-41ba-a241-5b90d638008b','51d58f8b-0462-41c3-8a07-9f9e6d138843','8be64c2e-21ee-4eec-9608-94b32adfafbe','2020-11-24 02:30:27.000',NULL);
/*!40000 ALTER TABLE `EmergencyContact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Patient`
--

DROP TABLE IF EXISTS `Patient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Patient` (
  `uuid` varchar(36) NOT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `emergencyContactId` varchar(36) NOT NULL,
  `practitionerId` varchar(36) NOT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `globalId` mediumint unsigned DEFAULT NULL,
  `socialSecurity` varchar(255) DEFAULT NULL,
  `allergies` varchar(255) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `privateComments` text,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  UNIQUE KEY `emergencyContactId` (`emergencyContactId`),
  UNIQUE KEY `practitionerId` (`practitionerId`),
  CONSTRAINT `Patient_ibfk_1` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Patient_ibfk_2` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Patient_ibfk_3` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Patient_ibfk_4` FOREIGN KEY (`emergencyContactId`) REFERENCES `EmergencyContact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Patient_ibfk_5` FOREIGN KEY (`practitionerId`) REFERENCES `Practitioner` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Patient`
--

LOCK TABLES `Patient` WRITE;
/*!40000 ALTER TABLE `Patient` DISABLE KEYS */;
INSERT INTO `Patient` VALUES ('097506b2-3385-4e2b-a196-b427b2eb51b8','8f5c387a-bb47-4992-8c7e-7867167113a6','7c4aa2b7-d6e9-4fe3-b7fc-cf6e3fed51d3','e83a6fa1-5f28-4248-92c4-a27ff516e6eb','c9794517-8c51-4a79-b4ed-0f65ce3f09f2','8d1c0763-4183-4fad-bde3-6f05541a9898',31,1,NULL,'',0,'','',NULL,'2022-03-23 13:57:43.000','2022-03-23 17:57:43.000','2022-03-23 13:57:43.000'),('0cc4ef86-2202-4a20-b6c2-a4a99611d672','7b77bfab-73a5-4a95-9597-3996f48be294','6fe30baf-5f1c-49bb-ad63-7683b209ab3d','6c5cea64-c5e1-4f7d-938f-08541b1b27cf','0bd96953-c3c6-4fbd-980a-ccdc7821a2d4','393271e3-3355-4993-b7c4-5c3fcbc07b0b',2,88,NULL,'',0,'','',NULL,'2020-06-26 15:32:20.000','2020-11-23 20:30:26.000','2020-11-23 21:30:26.000'),('10c66c7c-9e2a-4201-bc3f-ee405f9ea2a2','a095d63b-f0ee-46ce-88a1-847644dbf5c7','6757fc30-4ff4-46dc-84ac-7a3786e91c07','2ad02ffc-fc2b-4974-991a-7f38e865bb31','1244aeb6-4c9f-4183-94a4-1790e6e20a17','8eae6895-d19b-4c80-8634-abac98ef283d',26,1,NULL,'',0,'','',NULL,'2022-06-27 22:10:02.000','2022-06-28 02:10:04.000','2022-06-27 22:10:04.000'),('11ec40e4-4579-4185-9fcf-4e1aac06f554','6a8411e0-9931-4be8-94bf-890dfc599012','b9bf4d38-5ade-4fac-b315-cdc958fa706c','e65c8473-85ba-4a2a-9cfb-73bd45782738','9f8c0283-4225-43e5-80cc-043fced0cdd9','81745b13-1ee0-47c8-839d-8ca5d9a71972',25,1,NULL,'',0,'','',NULL,'2021-09-14 17:44:29.000','2022-03-14 13:58:23.000','2022-03-14 14:58:23.000'),('17cc8b8c-6280-4e69-ad1e-731bdd9819e0','e16f807c-eb86-4768-b572-9ed82c178ef0','eae3a5d7-517b-4306-9fcc-390f3299281a','49cd7d6e-bc04-4a21-85a5-de2cb211c9a4','3440d676-a2c0-4aa9-80fd-9896721634e3','198697b3-1760-4fb4-a991-f09b12d04844',19,1,NULL,'',0,'','',NULL,'2021-04-09 21:51:41.000','2022-03-14 13:58:35.000','2022-03-14 14:58:35.000'),('1a7a13ce-3a47-487b-8f16-db331e2672da','67512a23-7e5c-417e-abbf-61017e54f7a6','fae1c714-ed03-4d45-a413-aa37b2903e02','06471c51-eac6-4ad3-9a53-ba44be0a02f4','34b95f36-d676-4c12-888a-ef2c923e5b33','d0c6447c-4f35-4fca-bb5c-43a1e267aea1',41,1,NULL,'',0,'','',NULL,'2022-11-07 14:03:37.000','2022-11-07 19:03:39.000','2022-11-07 14:03:39.000'),('1a8d2cad-438d-45eb-a3d8-ff1f536e5592','05cf1a79-4c8e-4168-a242-5bcc4398c76f','8a06b311-3aa7-4ac6-ad7b-934224b8b689','1bdf4165-5d94-494d-aa5e-9e48d4b39c36','36afa9db-9f13-44f6-b481-890a69cf408c','a02fd72d-aa54-4d61-b749-30b796c8c194',22,1,NULL,'',0,'','',NULL,'2021-06-21 17:55:32.000','2022-03-14 13:58:38.000','2022-03-14 14:58:38.000'),('2217798a-4832-4e0d-9259-f8a836365b51','5851d563-6c8c-401c-8d59-1355a409c828','cf597493-bff1-44e4-bd83-520ad63f86ec','1626454e-751c-4eaa-a552-f73d45b369dc','9b2edb0f-5e2c-4d52-b346-b3f032d5aded','15009d08-be9a-4eda-aadc-45ad0c18386d',9,1,NULL,'',0,'','',NULL,'2020-06-11 21:44:07.000','2022-03-14 13:58:53.000','2022-03-14 14:58:53.000'),('2716836a-c818-4c38-90b6-b63ccb3a95ab','8c46a376-6af5-46fa-9b94-0508d93011a4','7a2e565f-3ca5-4693-a24e-7c857eb7c63a','9b5ae500-d013-4da2-8398-fb4be512b2d9','8d052bf4-bcd3-494d-9b03-3435b16fe6fa','f9ff02dd-d19b-4b3a-9c17-e26ffd578cc4',33,1,NULL,'',0,'','',NULL,'2022-09-21 17:54:06.000','2022-09-21 21:54:08.000','2022-09-21 17:54:08.000'),('3444c8f6-a93a-4fcf-85dd-517adb35a1ea','5de72b3e-e191-4746-a623-48383765cb72','80021482-eb3c-40df-a453-e83a76397c25','766c30ba-c693-41ce-b107-d713951180fd','4d66a5cb-072c-43eb-8ce7-666100e82f69','9a561c5c-c56d-4a4d-aae5-f4efeb0fec5d',1,451,NULL,'',0,'','',NULL,'2022-02-28 13:59:36.000','2022-02-28 12:59:37.000','2022-02-28 13:59:37.000'),('366ffa87-059a-436a-9125-8827b3a2da1a','b7e609a7-5978-469e-b437-b78e4a5e5615','02e741bd-f58a-447c-bb0e-36f754ba15af','018d7ddb-aa8a-413e-b823-363969b35fa2','9075921a-74e6-446f-8a1c-df8d8235e482','e1c97d39-5a53-4563-bc01-7bcdd5131e62',15,1,NULL,'',0,'','',NULL,'2022-08-22 15:13:04.000','2022-08-22 19:13:04.000','2022-08-22 15:13:04.000'),('36b92bb3-4eed-4383-bbf3-4b91cb0af09b','1a280ec2-5b27-4770-b05c-0cbb21ecde53','1b28a878-1f29-4380-93a1-a003fd8ffea0','68d89e1e-8e5f-4528-a115-83eef3475f8c','b1d2d79c-f18c-42f4-9bf0-1c6302ac5be2','5f260f41-7ee1-4ab3-9776-a7bfd4ee1228',20,1,NULL,'',0,'','','2021-04-09 19:20:23.000','2021-04-09 19:20:15.000','2021-04-09 23:20:23.000',NULL),('36e86f3f-4468-4cf2-9505-462288cae8b1','f0b6fd46-3b0e-4fd4-9e79-d00930fed227','b4e756dd-41ee-45d2-8f64-fbcdefcd15e0','8f1ac8df-10f1-490e-96f0-bd3224c94a94','5e2288dd-8680-4751-ba11-b0a7add59532','ac73365c-97ee-4f05-8307-3df67120c7e0',36,1,NULL,'',0,'','',NULL,'2022-06-20 19:21:45.000','2022-06-20 23:21:45.000','2022-06-20 19:21:45.000'),('46c4cd1e-7338-11ee-b011-58a023cda0dc','46c4dac7-7338-11ee-b011-58a023cda0dc','46c4e66b-7338-11ee-b011-58a023cda0dc','46c4f21b-7338-11ee-b011-58a023cda0dc','46c50046-7338-11ee-b011-58a023cda0dc','46c51f94-7338-11ee-b011-58a023cda0dc',54,1,'','',0,'','',NULL,'2023-10-25 09:13:24.000','2024-10-31 14:02:21.734','2024-10-31 10:02:21.734'),('48a38618-e853-4bf0-aa6b-4c83fb8b6f13','3daf8e39-032d-4f97-aea5-99abb530b563','407e88e1-805e-4423-b5ea-88c4b40e126a','ba89d306-9bda-4526-bc4d-38a2fa6609e5','7a19f42d-98c5-4c04-966e-aa2fe179bb7d','1f00a1fe-f7be-46cb-b884-db64424bcbcf',38,1,NULL,'',0,'','',NULL,'2022-07-18 16:27:29.000','2022-07-28 20:01:46.000','2022-07-28 16:01:46.000'),('4b4f3002-bba6-481f-a9fb-41ab2fedd61c','98ac2274-85ba-4dfb-a5d0-430c7c896f35','7c444a35-df5c-47ff-b813-308ab8754cb3','3d1bd1fd-837f-4fad-ac35-080abb38c3a6','5321f2d8-ff34-4ba6-a468-c211245b3681','5100a2fc-8b26-4959-9434-1cb051951092',18,1,NULL,'No Allergies',0,'','',NULL,'2022-09-14 15:15:33.000','2022-09-14 19:15:34.000','2022-09-14 15:15:34.000'),('509319d0-6cf3-4073-92e1-ff9307be4376','3f04883b-13b1-46a3-af43-6c36af3d7c8a','a268e813-b69a-4cc3-9ecd-82b9cff256e5','29cf8430-bed1-4965-a66d-e5c558e290b7','31825b5a-ba33-4778-9402-19c6b8d0d38a','6b57fc5c-a3fd-4eec-b28a-d67be81d7e9a',35,1,'','',0,'','',NULL,'2024-08-28 08:08:35.537','2024-08-28 12:08:35.543','2024-08-28 08:08:35.563'),('59179996-dc1e-4b4c-b9fd-92c78aa1dde0','25a46a80-eadb-4417-a78a-f9fdacf36d9d','9e55c892-bd90-4e8f-aa5b-e73fd36b39bb','c1247e71-d228-4b57-8e01-0dbe4a75c38b','a25db60d-1e47-430b-b5a4-4eb3ab0782af','0a80f3a5-5819-4aea-8c10-f162f351f2d0',40,1,NULL,'',0,'','',NULL,'2022-07-28 16:01:39.000','2022-07-28 20:01:39.000','2022-07-28 16:01:39.000'),('635617fc-289b-470c-a4d4-678d7b5f275a','9a5fef08-066f-4a21-8032-92d414d7a913','92f3d146-7a6b-4cf7-b0eb-bd8fc6b97b68','67e848bc-7259-484d-8ac1-cebbaa6a1c71','601bec78-e475-4969-be40-953feeae4207','b2860354-f3b1-4fae-9607-908602502204',45,1,NULL,'',0,'','',NULL,'2022-11-28 16:21:39.000','2022-11-28 21:21:40.000','2022-11-28 16:21:40.000'),('685697a1-0d50-4a06-8b3e-729cf9750f38','cf9f13b3-8b2e-472c-8912-e00c038a5b00','a6efe370-e9d6-43eb-8e9a-b859958fa190','fe1f7c67-19d4-4b1a-84fa-5e473faf2012','2a1cb95f-7b5b-4867-90aa-7dfdef768aa1','23ab6b60-40be-4cf9-8aff-6f332c702d5e',48,1,NULL,'',0,'','',NULL,'2022-10-17 16:43:12.000','2022-10-17 20:43:12.000','2022-10-17 16:43:12.000'),('6d99007d-a6df-43ae-87db-c160f6e66c0d','8a97ceea-3b76-4185-b866-f01e65dbe9d5','05b174d9-8f7a-4c31-8bec-7d5e0aba411a','14e46232-0511-4327-b9df-b9e5a285ab41','11c801b5-4307-47c6-84a2-4c28d55514b1','0a648dc2-53f7-4e55-a98a-3a5691cf284a',37,1,NULL,'',0,'','',NULL,'2022-11-09 15:43:23.000','2022-11-09 20:43:24.000','2022-11-09 15:43:24.000'),('73e48eee-3de1-4cd5-8d6d-8def1bc0b6c9','6cb1a854-0cce-4344-a3c1-276c6bcd1143','c135e3d3-e5f1-43ac-a18b-ceebbc2602ea','b144a4b8-0109-46c5-b916-0a6e77e3a37c','2d6b40c5-1910-43fc-abad-e99f255f3a48','083f0c90-7d43-418e-ac2e-750b6a792f71',7,1,NULL,'',0,'','',NULL,'2022-04-01 16:07:24.000','2022-04-01 20:07:26.000','2022-04-01 16:07:26.000'),('7eac18e5-5ed2-4ed9-8b3e-eba1c562d708','ed079f9d-0399-44f8-bf54-524953dee56d','18152b3f-6a0c-44da-90f1-b37c8fcd64f5','efedd2d8-663e-4153-8d12-e17602c6573f','c7c05633-ca4f-4749-83db-c604140a933e','25ff2c24-6110-4d5f-8c89-fc9a760b8f88',30,1,NULL,'',0,'','',NULL,'2022-08-22 15:07:59.000','2022-08-22 19:08:00.000','2022-08-22 15:08:00.000'),('872e90e0-190f-43c9-ac34-11936953fc74','434e034d-bf4e-4fc4-91ff-2d8c54c437c0','875b0613-536e-4a5e-a62e-2fa2e552db66','06496373-1bde-45eb-a25e-706d37625fe2','79d87f3d-0e8e-40b8-8837-a2744bb623b6','9ef02a5d-b34e-45d2-b319-c0bc0f116d64',27,1,NULL,'',0,'','',NULL,'2022-04-27 16:32:38.000','2022-04-27 20:32:39.000','2022-04-27 16:32:39.000'),('965d3fb4-1cb6-4c76-b1b8-f02df7997006','b200e49f-bf50-4ed2-9993-f4d34bd8fee7','730ced28-861b-4c56-ad88-fd60fc94382d','f69daa85-c684-4a54-9fad-2aad44abf2d7','4c9bc35d-5f46-457d-9577-f406e6e95375','d581c290-95f9-4626-91cb-bb428bd3f8e9',28,1,NULL,'',0,'','','2022-03-14 14:59:10.000','2022-03-14 14:58:57.000','2022-03-14 13:59:10.000','2022-03-14 14:59:10.000'),('99b65fa1-1638-4d2a-8836-8f2697b96143','9e3e5b10-28dd-4376-bc94-c681f377b30c','42c10f74-54a7-4fe4-9d74-7448af7f0d4e','3df1f1b6-6b2e-4400-a846-acaac4ae2942','d23b47e0-134c-40ab-9556-ee0ce92a3dad','5c8b8140-2bb3-47f7-a1e2-d8c5e93ef815',34,1,NULL,'',0,'','',NULL,'2022-06-13 16:10:52.000','2022-06-13 20:10:53.000','2022-06-13 16:10:53.000'),('9af78b83-8d91-4dc6-9499-3b8f6672cee3','1c435e4a-f5aa-4109-84a7-7fd96dafe277','bf70ae32-cf0f-423d-8f3c-685f054f80f2','8b4f8db2-044e-47a3-8513-cbe0f7fabca9','ecff512e-4f20-4952-a91c-717ffe7d0f3d','3b131682-ac74-499c-9c18-9220543940e2',24,1,NULL,'',0,'','',NULL,'2022-08-22 15:12:12.000','2022-08-22 19:12:13.000','2022-08-22 15:12:13.000'),('9bcfd1e2-10fc-4838-92c0-84057ad52bfe','1ea7f515-6425-47a4-bb7d-afb2f9de8d50','870ecbe7-4292-4476-a221-2d22026cffb9','ed129929-fe7d-40ae-b52d-96a97caaf5f1','1421d04f-e479-4417-8cc1-37384c9c02af','e3812e8e-3bcf-4cce-b34d-cf8230c8950f',43,1,NULL,'',0,'','',NULL,'2022-08-17 18:28:23.000','2022-08-17 22:28:24.000','2022-08-17 18:28:24.000'),('a4179770-0834-4466-a722-b14a0da36c73','7198ded4-4c53-4df3-b101-b18137a83229','ae1b4b10-2ae9-4cee-baf6-8f1b9b8ca652','85c6d6ee-2b0c-4476-a32a-057b8c62e895','02e650fb-95f3-41d8-b23e-c3fb7ba5af8c','e18636cd-7ac9-4000-9b18-e77573048199',42,1,NULL,'',0,'','','2022-08-03 15:28:45.000','2022-08-03 15:28:42.000','2022-08-03 19:28:45.000',NULL),('ab75613c-fecb-442a-bd6a-5b39f4846ade','812da3ed-861f-4f57-a0ec-c172eedb6dea','eedfe53a-d997-4f79-aa35-81db918f9884','4ff9b400-496d-4900-a275-584db6427a34','cd2efa58-3f0a-4282-8fa6-8b3eb31a3481','653772e1-d99a-4a98-b439-f864fbe97d4a',51,1,NULL,'',0,'','',NULL,'2022-11-16 17:49:06.000','2022-11-16 22:49:06.000','2022-11-16 17:49:06.000'),('ac1cc354-e34f-4afd-b66f-dadc541bcd93','8eabfb21-0b7f-498f-be5d-d45d8af4afba','7f9709a8-b721-4318-9a3e-bd9bfbd434dd','56ae1983-b1f6-4d33-b6c1-7c52d36e3967','873011ac-aa79-484a-bc57-8ad757bbceac','b594886d-a8fc-41c6-a2d8-895467550fba',21,1,NULL,'',0,'','',NULL,'2021-05-03 19:00:28.000','2022-03-14 13:58:50.000','2022-03-14 14:58:50.000'),('ae72aa8e-9461-11ee-8fd8-58a023cda0dc','ae72ba5b-9461-11ee-8fd8-58a023cda0dc','ae72c7ad-9461-11ee-8fd8-58a023cda0dc','ae72d535-9461-11ee-8fd8-58a023cda0dc','ae72df04-9461-11ee-8fd8-58a023cda0dc','ae73069f-9461-11ee-8fd8-58a023cda0dc',55,1,'','',0,'','',NULL,'2023-12-06 13:10:21.136','2023-12-06 18:10:21.138','2023-12-06 13:10:21.156'),('aea25e6c-977f-11ef-8187-58a023cda0dc','aea2665e-977f-11ef-8187-58a023cda0dc','aea26e31-977f-11ef-8187-58a023cda0dc','aea27288-977f-11ef-8187-58a023cda0dc','aea2768d-977f-11ef-8187-58a023cda0dc','aea28a3e-977f-11ef-8187-58a023cda0dc',59,1,'','',1,'','',NULL,'2024-10-31 08:00:11.832','2024-10-31 12:00:11.841',NULL),('b2146fed-f67d-47a9-b610-c63d840d0a2d','e000ebdc-f149-468b-a5e4-7f476446cd84','033ab1af-3262-42f5-a4bb-dea8533fd140','f403ef07-98c4-44e0-a257-0cfc5c76ef7a','b2331267-681e-41ce-8ae0-dcde614beb66','72c2452b-6332-4939-857d-fb27c830a378',14,1,NULL,'Sulfa Allergy/Bactrim',0,'','',NULL,'2022-08-22 15:01:36.000','2022-08-22 19:01:36.000','2022-08-22 15:01:36.000'),('b4c6341b-9837-11ee-86e7-58a023cda0dc','b4c63f31-9837-11ee-86e7-58a023cda0dc','b4c648a2-9837-11ee-86e7-58a023cda0dc','b4c651f7-9837-11ee-86e7-58a023cda0dc','b4c65baa-9837-11ee-86e7-58a023cda0dc','b4c675d9-9837-11ee-86e7-58a023cda0dc',56,1,'','',0,'','',NULL,'2023-12-11 10:12:38.000','2024-10-31 14:02:21.753','2024-10-31 10:02:21.753'),('b5cbee44-0703-46c2-986a-7a416eb4206c','fc5fce6c-4363-4b7f-b7bf-628ddd32d6e2','d51706a3-2522-4575-bf4b-abb27b7cf511','b0cfb433-47f8-47ba-896e-54f8db142bf7','d68f2f9f-4cb7-4002-8db0-9c30b5eee295','202b4368-ff42-4fac-a251-9e2e62d6d46b',52,1,NULL,'',0,'','',NULL,'2023-02-28 22:28:39.000','2023-03-01 03:28:40.000','2023-02-28 22:28:40.000'),('bbc77872-6c30-11ee-bc7f-58a023cda0dc','bbc78636-6c30-11ee-bc7f-58a023cda0dc','bbc79349-6c30-11ee-bc7f-58a023cda0dc','bbc79f13-6c30-11ee-bc7f-58a023cda0dc','bbc7a583-6c30-11ee-bc7f-58a023cda0dc','bbc7c00a-6c30-11ee-bc7f-58a023cda0dc',53,1,'','',0,'','',NULL,'2023-10-16 10:31:46.000','2024-10-31 14:02:21.718','2024-10-31 10:02:21.718'),('bd9e7343-96c5-11ef-8234-58a023cda0dc','bd9e7f02-96c5-11ef-8234-58a023cda0dc','bd9e87ad-96c5-11ef-8234-58a023cda0dc','bd9e8d83-96c5-11ef-8234-58a023cda0dc','bd9e9617-96c5-11ef-8234-58a023cda0dc','bd9eaef1-96c5-11ef-8234-58a023cda0dc',58,1,'','',0,'','',NULL,'2024-10-30 09:49:21.327','2024-10-30 13:49:21.329','2024-10-30 09:49:21.350'),('cede029c-15bc-44c2-9c9c-fac7f8983524','a0190e7c-5198-4754-9e93-692fcb615e9e','aa923b43-ca04-48ad-a409-2c0fff006894','195dc712-039c-41ff-a906-ae51d726ea0a','c4e13c4b-df4f-41b6-82c2-e06c3244a213','59439f2b-06c7-48d0-8546-ee348741ed7e',46,1,NULL,'',0,'','',NULL,'2022-09-21 18:00:41.000','2022-09-21 22:00:42.000','2022-09-21 18:00:42.000'),('d71657f7-b9e8-45b9-865f-1c4c55c62017','724f3b59-49b8-4dec-a724-e7b573348bef','2e06f459-8f38-4279-adc7-e8624e1dbb5a','32cf7f4f-40b1-4794-a6ef-97710dca2106','7ac12a2d-46bf-4772-871c-edac267ebf1f','0c2d939d-c60c-4cff-99fc-bc0f1aa33ca2',23,1,NULL,'',0,'','',NULL,'2021-06-21 18:41:16.000','2022-03-14 13:58:45.000','2022-03-14 14:58:45.000'),('d971e033-4a5c-4bd9-aab3-6238778f9eee','8ea7b8c0-0b03-4992-9ab4-214d5fdc8128','f1cc669f-682a-4af8-8369-8339f181e2e6','e5ea0d04-9f6f-4cb3-b13e-e94f79cf8fdf','bd1da209-d422-4f1d-bd9d-cf6e3db15166','3a3e46d1-4a48-4f62-bdce-70f3e4c6777b',47,1,NULL,'',0,'','',NULL,'2022-09-21 18:15:27.000','2022-09-21 22:15:28.000','2022-09-21 18:15:28.000'),('d9869338-8fcc-11ef-b6be-58a023cda0dc','d9869c7f-8fcc-11ef-b6be-58a023cda0dc','d986a3a0-8fcc-11ef-b6be-58a023cda0dc','d986aaae-8fcc-11ef-b6be-58a023cda0dc','d986ad8e-8fcc-11ef-b6be-58a023cda0dc','d986ba13-8fcc-11ef-b6be-58a023cda0dc',57,1,'','',0,'','',NULL,'2024-10-21 12:52:26.000','2024-10-31 14:02:21.770','2024-10-31 10:02:21.770'),('dfe1127e-d366-48f3-8672-183d37f8181f','a92e42af-a8b8-440b-b4e3-86577aef9d80','98adc4a7-48a1-44be-8495-11cd88e91634','42fdb23c-93f9-44e8-bb33-fbb4837637ac','231c88b8-c542-4d5d-929c-3f3db02755a3','b26007f5-85e7-45a1-8f2f-247f653e04c9',29,1,'','',0,'','',NULL,'2023-05-22 09:12:38.032','2023-05-22 13:12:38.034','2023-05-22 09:12:38.054'),('e33159c9-a713-4a37-ba98-9ec2e2e213e7','628e7d2a-a2ca-4142-b5d2-1623314c721a','fe7db8c2-cca5-4a3d-8b9e-5ead3d2c4f9c','1cc93fdb-3a33-4655-be4b-b5ce49391bb6','029beb3d-0351-47d4-a608-821f8a9d2455','bd08986b-c104-4cf7-b6ad-1c186dd0b6b8',50,1,NULL,'',0,'','',NULL,'2022-11-14 18:05:01.000','2022-11-14 23:05:03.000','2022-11-14 18:05:03.000'),('e4dda259-b05b-4f33-92ac-ee4067d7dfa2','1d74f17b-b0cf-4647-9fb3-2b57506b291b','c86a31d7-9ce6-4496-8d4d-b070a3616547','bf406a84-0675-4452-9997-132af2cabf84','457a09f7-6db5-4a90-8eae-7921997f9a83','c88dd0c7-a38f-4ed4-86be-a24c2fceb390',4,1,NULL,'',0,'','',NULL,'2022-11-02 16:14:13.000','2022-11-02 20:14:14.000','2022-11-02 16:14:14.000'),('e648cc66-9340-456c-a379-50836d1b8a5b','8c78ea90-5e11-4dc7-b353-4053e81ad213','4558d3cf-58f3-4ed3-b333-78006fd11e0d','867111fa-5599-4f3d-a599-80ce3aadc485','86566a08-d0d6-4cd0-adf6-acd8d3c0de96','bf6738bd-0382-4efa-b28b-d9fbe4783faf',16,1,NULL,'Metals, Lyrica, Neurontin, Nystatin, Zinc, Copper, Cadmium, Bismuth, Lithium, Mercury',0,'','',NULL,'2022-06-27 22:13:16.000','2022-06-28 02:13:17.000','2022-06-27 22:13:17.000'),('eb3fb44e-7c5f-4ae3-a907-fdcec841501c','f9404420-22de-4d34-8247-81236b955bfc','78f45227-7d09-4475-b253-9d0200ad5c0b','a197fe34-311d-4d3f-9fd4-c2cf33594a50','55344909-ab31-4f4e-bb0b-82081011bcaf','50e8cb26-fa6a-4265-96ff-e03c8cc674dd',49,1,NULL,'',0,'','',NULL,'2022-11-28 16:21:29.000','2022-11-28 21:21:32.000','2022-11-28 16:21:32.000'),('ebb7ec01-03db-43d2-bf9a-bc250f69d307','faff3f13-a935-4fb1-8bba-315d85c1bde3','e380c427-c49d-4b94-a437-88480f7123c2','52de1ec1-8f0a-4fe3-8cf5-153f1ad5f2fc','1c00b42a-478d-4726-b088-187e59771666','72cfec76-0495-41c2-9591-a2bf05a71a13',5,1,NULL,'',0,'','',NULL,'2022-11-02 16:09:22.000','2022-11-02 20:09:23.000','2022-11-02 16:09:23.000'),('ec5bbece-7f40-46cd-b5cd-bc74205bf2f0','c03bb0cd-0556-430a-9147-525c04e4c2d3','d5c1291e-40cf-464e-b1dd-09a5452b6462','fd2e3c07-f7fe-4341-b8bb-1ca921d781ec','1a265160-d43d-41f0-9a33-2073b96e8710','1efb5890-bb19-4565-9403-960df1579ea7',2,1,NULL,'',0,'','','2022-03-14 14:59:02.000','2020-04-09 01:35:55.000','2022-03-14 13:59:02.000','2022-03-14 14:59:02.000'),('eddc3fb0-fe28-4640-9139-29e088374f38','68a240da-7739-49c4-9be3-1abe7ba3e156','59adb963-0393-495c-9d5b-626327357ce4','2f38dd06-9f97-4536-8c13-bf6d62af4b4e','31e5fc49-573e-41bf-af9f-3cdbe7908a6e','0953b421-eb2e-4531-8eb6-a07623eeec0b',6,1,NULL,'',0,'','',NULL,'2020-04-29 20:27:16.000','2022-03-14 13:58:41.000','2022-03-14 14:58:41.000'),('f4f78058-cf3c-4c86-a252-bc92bd2d36b0','93895880-1d9b-4a9a-87c7-2e43549a44dd','5641a3bc-b9ce-45a7-bd46-29b336654f9d','c264e23d-e22a-4762-9ed2-05f187afb37d','4e0462c0-497a-40d6-b4e4-1891fe6b8bef','5f02d1de-8f1e-4ad9-aff1-6fd558e0486c',13,1,NULL,'',0,'','',NULL,'2020-09-02 15:12:30.000','2022-03-14 13:58:25.000','2022-03-14 14:58:25.000'),('f67a1372-95d6-445a-856a-13c1610ee937','3f03751b-f0cb-4f7b-80ff-196a2f762c77','acac5575-4a69-444b-96dc-d288004b9ea7','fbdb0a58-53b2-4df7-bc08-f7b742048a67','f8ae6051-bf51-4f68-bbc4-3eb43bc8b8b3','f4613a5a-3d3a-4d55-a117-c2a35da6e70f',10,1,NULL,'',0,'','',NULL,'2022-08-22 14:53:09.000','2022-08-22 18:53:09.000','2022-08-22 14:53:09.000'),('f9a5624b-304e-40b4-8a76-72a05c95332f','5d075438-e69b-416c-9c72-fa8f6dfe6b84','05526a81-ebd4-496a-bafb-70143cb3af82','9777266b-12cd-4263-a908-faaf7d739902','7f7c2d40-c598-47a7-b254-4691c495a556','d1b190fd-db17-44da-b86c-67ceb2f5cc0a',39,1,NULL,'',0,'','','2022-07-18 16:33:39.000','2022-07-18 16:33:34.000','2022-07-18 20:33:39.000',NULL),('fa67c8c9-4aad-41b8-83e6-2add079bf950','a0ff14d0-6e5f-423d-b087-d274f506b2e2','d20c376e-5166-435e-b3a0-4d9121761757','f1ccce5e-17de-4d08-b206-ed4769cb4905','74f1a4b8-d055-4ca0-8c06-e231608e5f22','d3c8fed1-2c85-47e7-b864-27c4efad6561',44,1,NULL,'',0,'','',NULL,'2022-09-21 20:06:52.000','2022-09-22 00:06:53.000','2022-09-21 20:06:53.000'),('ffbcef25-a535-4bb2-8b85-6107c1aaa2ed','b4281089-bf37-4658-8655-e4f15a975891','054de982-7c5b-4c2e-a3bf-f1a6831ffab8','04368fb3-0a49-4800-ab22-95f322089034','c7b9e1d8-35e7-4e0a-8ef5-c729e51bea1c','03c3e46f-9e6b-4ac6-b6c3-a7d92a20e75a',32,1,'','',0,'','',NULL,'2022-03-23 11:14:51.000','2024-10-31 14:02:21.704','2024-10-31 10:02:21.704');
/*!40000 ALTER TABLE `Patient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `uuid` varchar(36) NOT NULL,
  `firstname` varchar(64) NOT NULL,
  `lastname` varchar(64) NOT NULL,
  `birthdate` datetime(3) DEFAULT NULL,
  `sex` enum('M','F') DEFAULT 'M',
  `email` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('05cf1a79-4c8e-4168-a242-5bcc4398c76f','Stephanie','Chambers','1958-12-09 00:00:00.000','F','','2021-06-21 21:55:32.000',NULL),('121d3b61-1014-46ad-8c42-0b1f52da493a','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('1293ad42-ca3f-4ba8-b478-dec9ed31aef7','Sammy','Noumbissi',NULL,'M','','2023-05-17 17:16:38.241',NULL),('174792ad-24ca-4246-af26-ab37936d2f8c','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('17f98140-5dd9-46ac-91a4-d7af6f8ae4d1','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('1a280ec2-5b27-4770-b05c-0cbb21ecde53','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('1b2c0b89-679f-451c-8014-e832ed498ede','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('1c435e4a-f5aa-4109-84a7-7fd96dafe277','Christopher','Scena','1971-09-11 00:00:00.000','M','','2022-08-22 19:12:12.000',NULL),('1d74f17b-b0cf-4647-9fb3-2b57506b291b','One','Model','1940-04-03 00:00:00.000','F','','2022-11-02 20:14:13.000',NULL),('1e63c8d1-f1ab-4765-95ec-90cb6d017920','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('1ea7f515-6425-47a4-bb7d-afb2f9de8d50','Tonya','Sanders','1952-10-22 00:00:00.000','F','','2022-08-17 22:28:23.000',NULL),('2240a054-49c0-494f-900a-6c3ed006fdfc','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('247f62e8-844b-4a47-a1af-337bd111103d','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('24f75dc7-8759-497c-a3f2-b39780f17bcc','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('25a46a80-eadb-4417-a78a-f9fdacf36d9d','Test','Test','1976-02-20 00:00:00.000','M','','2022-07-28 20:01:39.000',NULL),('279c8cf1-33ec-4fec-8004-cce1f70597e2','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('3a414daa-6a8b-4f26-8c64-7dd9475fd299','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('3daf8e39-032d-4f97-aea5-99abb530b563','Charlotte','Sadel','1956-04-19 00:00:00.000','F','','2022-07-18 20:27:30.000',NULL),('3f03751b-f0cb-4f7b-80ff-196a2f762c77','Nelly','Rochon','1969-03-01 00:00:00.000','F','','2022-08-22 18:53:09.000',NULL),('3f04883b-13b1-46a3-af43-6c36af3d7c8a','Sindy','Pineda','1994-01-23 00:00:00.000','F','','2022-10-04 01:52:23.000','2024-08-28 08:08:35.563'),('434e034d-bf4e-4fc4-91ff-2d8c54c437c0','Caroline','Oliveira','1994-07-30 00:00:00.000','F','','2022-04-27 20:32:38.000',NULL),('44d019c8-813f-4920-9795-a23a68d929e1','Matt','Bell',NULL,'M','','2023-05-17 17:16:38.241',NULL),('46c4dac7-7338-11ee-b011-58a023cda0dc','Yolanda','Dooley','1963-09-16 00:00:00.000','F','','2024-10-31 14:02:21.731','2024-10-31 10:02:21.734'),('46c50a3d-7338-11ee-b011-58a023cda0dc','','',NULL,'M','','2024-10-31 14:02:21.733','2024-10-31 10:02:21.734'),('51b4aeff-8b06-472f-a8e1-956f7951f13f','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('5289ea1e-3956-4c11-97cc-261e6d209700','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('52a1d1bd-775c-4876-a2cf-ab12d48e5679','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('56d159ad-da33-4b05-b008-424f7b2746a5','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('57227a54-23de-4957-b102-a62bdfced80c','','',NULL,'M','','2023-05-17 17:16:38.241','2024-08-28 08:08:35.563'),('5851d563-6c8c-401c-8d59-1355a409c828','Chantal','Nomen','1998-09-04 00:00:00.000','F','','2020-11-30 07:31:08.000',NULL),('5d075438-e69b-416c-9c72-fa8f6dfe6b84','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('5de72b3e-e191-4746-a623-48383765cb72','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('5ed9c45f-f285-44f9-82e2-e7cad1590748','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('628e7d2a-a2ca-4142-b5d2-1623314c721a','Bruno','Njiensi','1975-12-29 00:00:00.000','M','','2022-11-14 23:05:02.000',NULL),('64ab8cf0-9928-42b0-addd-c4e31282c0fb','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('67512a23-7e5c-417e-abbf-61017e54f7a6','Karen','Lindsay','1955-10-10 00:00:00.000','F','','2022-11-07 19:03:38.000',NULL),('68a240da-7739-49c4-9be3-1abe7ba3e156','Three','MODEL','1943-02-14 00:00:00.000','F','','2020-11-30 07:31:09.000',NULL),('68b5a331-bb21-41ba-a241-5b90d638008b','Rochon','Ken ',NULL,'M','','2023-05-17 17:16:38.241',NULL),('6a8411e0-9931-4be8-94bf-890dfc599012','County','Montgomery','1971-09-14 00:00:00.000','F','','2021-09-14 21:44:29.000',NULL),('6cb1a854-0cce-4344-a3c1-276c6bcd1143','Adenrele','Onadeko','1974-03-13 00:00:00.000','M','','2022-04-01 20:07:24.000',NULL),('7198ded4-4c53-4df3-b101-b18137a83229','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('724f3b59-49b8-4dec-a724-e7b573348bef','Erica','Durocher','1981-01-13 00:00:00.000','F','','2021-06-21 22:41:16.000',NULL),('735f3029-cc4d-4fbc-8e8c-4c2877f3fb05','','',NULL,'M','','2023-05-17 17:16:38.241','2023-05-22 09:12:38.054'),('7544dde9-215d-4a74-8d6b-71757623f9d4','Sammy','Noumbissi',NULL,'M','','2023-05-17 17:16:38.241',NULL),('791c87cf-bb3a-4fee-955a-d7e38422b5c3','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('794c8467-4d4d-4b9f-a3d2-ac62362c315f','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('7b77bfab-73a5-4a95-9597-3996f48be294','k','h','1999-09-09 00:00:00.000','M','','2020-11-23 20:30:27.000',NULL),('7b9c5cbb-5d7a-40e5-a6cf-808ba407fa56','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('812da3ed-861f-4f57-a0ec-c172eedb6dea','Marie','Hammonds','1950-10-19 00:00:00.000','F','','2022-11-16 22:49:06.000',NULL),('83936706-ace3-452a-9c97-15f2b0951973','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('8a97ceea-3b76-4185-b866-f01e65dbe9d5','Elisabeth','Baxter','1955-10-12 00:00:00.000','F','','2022-11-09 20:43:23.000',NULL),('8c46a376-6af5-46fa-9b94-0508d93011a4','Solange','Montue','1966-08-10 00:00:00.000','F','','2022-09-21 21:54:07.000',NULL),('8c78ea90-5e11-4dc7-b353-4053e81ad213','Darcy','Bell','1971-04-14 00:00:00.000','F','','2022-06-28 02:13:16.000',NULL),('8ea7b8c0-0b03-4992-9ab4-214d5fdc8128','Test','Assistant','2022-09-11 00:00:00.000','F','','2022-09-21 22:15:27.000',NULL),('8eabfb21-0b7f-498f-be5d-d45d8af4afba','Ivonne','moyonoubissi','1968-12-28 00:00:00.000','F','','2021-05-03 23:00:28.000',NULL),('8f2e6b79-2bff-4916-bf5d-0a6230b6dbde','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('8f5c387a-bb47-4992-8c7e-7867167113a6','Wednesday','Dummy','1973-10-31 00:00:00.000','M','','2022-03-23 17:57:43.000',NULL),('90f85ecf-9648-4ef8-8baf-4254e198f8ba','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('93895880-1d9b-4a9a-87c7-2e43549a44dd','New','Model ','2020-09-01 00:00:00.000','M','','2020-11-30 07:31:06.000',NULL),('94629651-fdf5-4670-85c1-a0b73fcfd2ff','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('98ac2274-85ba-4dfb-a5d0-430c7c896f35','Andre','Biyong','1970-10-15 00:00:00.000','M','','2022-09-14 19:15:33.000',NULL),('9a0cdfd8-0546-4cd4-b00e-3ec961f9b09b','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('9a5fef08-066f-4a21-8032-92d414d7a913','Andrew','Gilboy','1945-04-09 00:00:00.000','M','','2022-11-28 21:21:40.000',NULL),('9e3e5b10-28dd-4376-bc94-c681f377b30c','Carol','Mangan','1946-05-05 00:00:00.000','F','','2022-06-13 20:10:52.000',NULL),('a0190e7c-5198-4754-9e93-692fcb615e9e','Carroll','Gibbs','1949-06-03 00:00:00.000','M','','2022-09-21 22:00:42.000',NULL),('a095d63b-f0ee-46ce-88a1-847644dbf5c7','Petula','Alleyne','1968-04-25 00:00:00.000','F','','2022-06-28 02:10:02.000',NULL),('a0ff14d0-6e5f-423d-b087-d274f506b2e2','Delrose','Taylor-Jolly','1946-10-18 00:00:00.000','F','','2022-09-22 00:06:52.000',NULL),('a38dbe4d-799c-4e58-b56d-b789ff958b1e','','',NULL,'M','','2023-05-17 17:16:38.241','2024-10-31 10:02:21.704'),('a92e42af-a8b8-440b-b4e3-86577aef9d80','Patricia','Coleman','1950-05-25 00:00:00.000','F','','2022-06-28 02:11:38.000','2023-05-22 09:12:38.054'),('a9f1a61d-e95a-4f97-9cec-f0d6a5022271','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('ae72ba5b-9461-11ee-8fd8-58a023cda0dc','Brenda','Mc Cabe','1960-05-08 00:00:00.000','F','','2023-12-06 18:02:55.461','2023-12-06 13:10:21.156'),('ae72e4d9-9461-11ee-8fd8-58a023cda0dc','','',NULL,'M','','2023-12-06 18:02:55.488','2023-12-06 13:10:21.156'),('aea2665e-977f-11ef-8187-58a023cda0dc','','',NULL,'M','','2024-10-31 12:00:11.832',NULL),('aea27a62-977f-11ef-8187-58a023cda0dc','','',NULL,'M','','2024-10-31 12:00:11.835',NULL),('b200e49f-bf50-4ed2-9993-f4d34bd8fee7','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('b2a4588e-f6c8-4d2a-b508-74ef38a5d5d3','Noumbissi','Sammy',NULL,'M','','2023-05-17 17:16:38.241',NULL),('b4281089-bf37-4658-8655-e4f15a975891','Jeff','Anthony','1949-04-07 00:00:00.000','M','','2024-10-31 14:02:21.702','2024-10-31 10:02:21.704'),('b4c63f31-9837-11ee-86e7-58a023cda0dc','Alina','Scott','1976-07-20 00:00:00.000','F','','2024-10-31 14:02:21.750','2024-10-31 10:02:21.753'),('b4c6648e-9837-11ee-86e7-58a023cda0dc','','',NULL,'M','','2024-10-31 14:02:21.751','2024-10-31 10:02:21.753'),('b7e609a7-5978-469e-b437-b78e4a5e5615','Infinity','Thomas-Waheed','1996-05-14 00:00:00.000','F','','2022-08-22 19:13:04.000',NULL),('bb8ae5bf-6630-43ea-a404-0b07d8c0fbb4','Richard','Celotto',NULL,'M','','2023-05-17 17:16:38.241',NULL),('bbc78636-6c30-11ee-bc7f-58a023cda0dc','Bonnie','Smith','1951-07-01 00:00:00.000','F','','2024-10-31 14:02:21.716','2024-10-31 10:02:21.718'),('bbc7ab18-6c30-11ee-bc7f-58a023cda0dc','','',NULL,'M','','2023-10-16 14:31:45.978','2024-10-31 10:02:21.718'),('bc80a812-7f76-46d2-be47-955208bdb166','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('bd9e7f02-96c5-11ef-8234-58a023cda0dc','Karena','Grigsby','1992-05-16 00:00:00.000','F','','2024-10-30 13:49:10.581','2024-10-30 09:49:21.350'),('bd9e9e69-96c5-11ef-8234-58a023cda0dc','','',NULL,'M','','2024-10-30 13:49:10.607','2024-10-30 09:49:21.350'),('bed14763-b776-4e8c-a45e-1f67f500e901','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('c03bb0cd-0556-430a-9147-525c04e4c2d3','Yannick','Noumbissi','2008-02-14 00:00:00.000','M','','2020-11-30 07:31:08.000',NULL),('c20d7fb4-af1a-4065-b403-be968cbdebf7','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('cf9f13b3-8b2e-472c-8912-e00c038a5b00','Leone','Walker','1985-07-12 00:00:00.000','F','','2022-10-17 20:43:12.000',NULL),('d2e39f6c-9803-40de-8785-b75960bb0f84','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('d9869c7f-8fcc-11ef-b6be-58a023cda0dc','Donna','Johnson','1962-03-13 00:00:00.000','F','','2024-10-31 14:02:21.767','2024-10-31 10:02:21.770'),('d986aff0-8fcc-11ef-b6be-58a023cda0dc','','',NULL,'M','','2024-10-31 14:02:21.768','2024-10-31 10:02:21.770'),('da559747-65f0-4c69-9a17-fba35d3bfcf7','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('dbefae4c-c5ae-437a-a1b4-4911b2cc885a','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('dd44877d-fc3e-40b3-8656-bd24780f6bad','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('e000ebdc-f149-468b-a5e4-7f476446cd84','Rita','LaPrince','1976-08-25 00:00:00.000','F','','2022-08-22 19:01:36.000',NULL),('e117fe58-3331-4a28-b8b4-1197e0ff435c','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('e16f807c-eb86-4768-b572-9ed82c178ef0','Katherine','Celotto','1952-05-27 00:00:00.000','F','','2021-04-10 01:51:41.000',NULL),('e8bf5f04-8965-4555-a14d-7947b95a9e1a','NO_FIRSTNAME','NO_LASTNAME',NULL,'M','','2023-05-17 17:16:38.241',NULL),('ebce4b1b-735f-4e96-ab86-3e7c15bcc149','Nicole','Waheed',NULL,'M','','2023-05-17 17:16:38.241',NULL),('ec73d078-510f-4c35-bf7e-e50e2cd94ea9','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('ed079f9d-0399-44f8-bf54-524953dee56d','Marian','Johnson','1944-04-03 00:00:00.000','M','','2022-08-22 19:07:59.000',NULL),('ef22a6a1-3819-4f39-949f-0ea8b334b264','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('f0b6fd46-3b0e-4fd4-9e79-d00930fed227','Gary','Scotland','1968-09-19 00:00:00.000','M','','2022-06-20 23:21:45.000',NULL),('f5e04015-ebde-4bcd-8f76-ff744ebf6755','','',NULL,'M','','2023-05-17 17:16:38.241',NULL),('f9404420-22de-4d34-8247-81236b955bfc','Carol','Burroughs','1959-10-28 00:00:00.000','F','','2022-11-28 21:21:30.000',NULL),('faff3f13-a935-4fb1-8bba-315d85c1bde3','Two','MODEL ','1941-02-11 00:00:00.000','M','','2023-05-17 17:16:38.241',NULL),('fc5fce6c-4363-4b7f-b7bf-628ddd32d6e2','Lynn','Noble','1964-09-12 00:00:00.000','F','','2023-03-01 03:28:39.000',NULL),('ff8f74c4-427c-40a5-83aa-3c5256303b6e','Sammy','Noumbissi',NULL,'M','','2023-05-17 17:16:38.241',NULL);
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `uuid` varchar(36) NOT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('02e741bd-f58a-447c-bb0e-36f754ba15af','7164789004','','','2021-01-18 20:22:04.000',NULL),('033ab1af-3262-42f5-a4bb-dea8533fd140','2022075327','','','2020-11-24 02:30:27.000',NULL),('03cb3092-df4c-4bc7-ad4b-2ccdaa70647c','','','','2021-04-09 23:20:15.000',NULL),('05232a32-cd6c-4060-af62-12a92d2b91a0','','','','2021-05-03 23:00:28.000',NULL),('054de982-7c5b-4c2e-a3bf-f1a6831ffab8','','','','2022-03-23 20:14:51.000','2024-10-31 10:02:21.704'),('05526a81-ebd4-496a-bafb-70143cb3af82','','','','2022-07-18 20:33:34.000',NULL),('05b174d9-8f7a-4c31-8bec-7d5e0aba411a','','','','2022-06-22 19:24:03.000',NULL),('0665c5c5-da18-4f50-99e0-cc5e2aa5017b','','','','2022-10-17 20:43:12.000',NULL),('110f5fb7-7d7c-4b0a-80df-3fb5ce7e26c6','','','','2021-01-18 22:13:40.000',NULL),('16482c80-46c2-42db-b8ed-cb7a7f1e93ae','','','','2021-04-09 23:20:15.000',NULL),('17232bc8-ac2e-4014-88b2-6927bad52bca','','','','2022-09-12 23:45:43.000',NULL),('18152b3f-6a0c-44da-90f1-b37c8fcd64f5','','','','2022-03-21 18:35:23.000',NULL),('1b28a878-1f29-4380-93a1-a003fd8ffea0','','','','2021-04-09 23:20:15.000',NULL),('1c3cdb6b-2840-4aab-894a-d187f827f7ea','','','','2022-09-14 21:49:36.000',NULL),('2433b3c4-6f05-46ac-a06d-bfbad512cca1','','','','2022-03-21 18:35:23.000',NULL),('2e06f459-8f38-4279-adc7-e8624e1dbb5a','','','','2021-06-21 22:41:15.000',NULL),('2e7bc3da-92b0-4294-bc09-984d90c7cc56','','','','2022-04-11 20:00:40.000',NULL),('2edc791b-9060-49af-874a-d70693b06db4','','','','2022-10-31 20:39:14.000',NULL),('2f5d052f-af23-491f-aef2-a08c7447d936','','','','2020-11-24 02:30:27.000',NULL),('315fd84c-912f-4213-981a-1f4fb98193fd','','','','2022-07-28 20:01:34.000',NULL),('31c4041b-d930-4909-bc9b-9a8a03af5e5c','','','','2020-11-23 20:30:27.000',NULL),('35af927f-6fe0-4f56-a6f5-07fd6cf54563','','','','2022-03-21 18:35:23.000',NULL),('3694cd4f-fa0f-47f5-91ee-72c590ba6232','','','','2022-10-17 20:43:12.000',NULL),('37614f4d-8830-4f1e-9619-4377b5d0f99a','','','','2023-02-20 20:27:24.000',NULL),('396413f4-a9b0-4d1d-8953-db92304da2a3','','','','2022-08-03 19:28:42.000',NULL),('3aaa54f6-80a1-48a0-bb62-9a66060ec464','','','','2022-06-22 20:34:17.000',NULL),('3c6fe3c0-79bf-46ad-9f70-34ff2fbda2f9','','','','2020-11-24 02:30:27.000',NULL),('3c934d9f-efb6-486b-ae60-e15b963d56f7','','','','2022-06-06 23:11:15.000','2024-08-28 08:08:35.563'),('3e8f7698-a8a2-4a71-a1b0-ed2158eb1841','','','','2022-03-23 20:14:51.000','2024-10-31 10:02:21.704'),('3ed73c88-0f52-4762-a85c-029f8e3834c8','','','','2023-02-20 20:27:24.000',NULL),('407e88e1-805e-4423-b5ea-88c4b40e126a','','','','2022-06-22 20:34:17.000',NULL),('411dfb3c-161b-4ee7-8c9d-fba592857718','','','','2021-10-04 22:11:23.000',NULL),('41ccb456-23bc-4e7f-b84e-47239f618f97','','','','2022-09-12 23:45:43.000',NULL),('42c10f74-54a7-4fe4-9d74-7448af7f0d4e','','','','2022-05-25 19:17:19.000',NULL),('4558d3cf-58f3-4ed3-b333-78006fd11e0d','7039306347','','','2021-01-18 22:13:51.000',NULL),('46c4e66b-7338-11ee-b011-58a023cda0dc','3016932573','','','2024-10-31 14:02:21.732','2024-10-31 10:02:21.734'),('46c51046-7338-11ee-b011-58a023cda0dc','','','','2024-10-31 14:02:21.733','2024-10-31 10:02:21.734'),('46c52442-7338-11ee-b011-58a023cda0dc','','','','2024-10-31 14:02:21.734','2024-10-31 10:02:21.734'),('47746942-5f9f-4fa9-9ff1-38ba2a06d854','','','','2022-05-25 19:17:19.000',NULL),('47a5d6be-81d1-4a10-93ed-aa19795afdeb','','','','2022-02-28 12:59:36.000',NULL),('4ad62edd-4661-451e-9199-ebc4a846fd12','','','','2022-03-14 13:58:57.000',NULL),('4c352aac-85f3-4eb9-8401-bd2f333e6dd6','','','','2020-11-24 02:30:27.000',NULL),('4c87db90-10e1-4b90-bfec-e55d6d28cf9c','','','','2020-11-24 02:30:27.000',NULL),('4cfbff1d-edab-40f9-97a4-391af675f9e6','','','','2020-11-24 02:30:27.000',NULL),('50daf4c9-c0dd-40a8-962a-8d98abed8791','','','','2022-03-23 17:57:43.000',NULL),('51d58f8b-0462-41c3-8a07-9f9e6d138843','','','','2020-11-24 02:30:27.000',NULL),('53ad1348-4db1-4270-b100-45053dd26c00','','','','2020-11-24 02:30:27.000',NULL),('53bc6667-c3bb-4f17-a2e9-b4055b1c6bb9','','','','2021-05-03 23:00:28.000',NULL),('5641a3bc-b9ce-45a7-bd46-29b336654f9d','','','','2020-11-24 02:30:27.000',NULL),('565df856-d2f2-4b38-9aef-7ca6c96fb9ee','3015880768','','','2022-03-14 14:04:06.000','2023-05-22 09:12:38.054'),('59adb963-0393-495c-9d5b-626327357ce4','','','','2020-11-24 02:30:27.000',NULL),('5a60ed9d-1f64-40b4-b9f8-49f4f26923c8','','','','2021-09-14 00:48:00.000',NULL),('5b45784f-2835-4ca7-834e-702923859661','','','','2021-04-10 01:51:41.000',NULL),('5c6e8152-210a-44a9-b56c-57018a2211c8','','','','2022-04-11 20:00:40.000',NULL),('5ca0d104-e868-4f00-bb60-b52dedfcbb2a','','','','2022-10-31 20:39:14.000',NULL),('5d2374a3-5eca-4297-abfe-50d01feea95f','','','','2021-09-28 21:02:52.000',NULL),('5d2622d9-2ecb-4655-99d5-5ceb265f355a','','','','2020-11-24 02:30:27.000',NULL),('5f50175b-9738-4776-a8e0-e4ba4e2264f0','','','','2022-11-16 22:49:06.000',NULL),('661b7462-36e5-4ede-a8a9-985c5941aff9','','','','2021-10-04 22:11:23.000',NULL),('6757fc30-4ff4-46dc-84ac-7a3786e91c07','','','','2021-09-28 21:02:52.000',NULL),('67791c87-1130-45d1-ae1d-1b1d0806136e','','','','2021-04-10 01:51:41.000',NULL),('67d10708-c4da-4b54-9d6f-e64080db6219','','','','2020-11-24 02:30:27.000',NULL),('6fe2ba39-6001-491d-b1b5-fcdbca8a7d1b','','','','2021-02-03 22:19:00.000',NULL),('6fe30baf-5f1c-49bb-ad63-7683b209ab3d','','','','2020-11-23 20:30:27.000',NULL),('70286368-2d26-43da-82f7-f46a6b8a9afb','','','','2022-02-28 12:59:36.000',NULL),('730ced28-861b-4c56-ad88-fd60fc94382d','','','','2022-03-14 13:58:57.000',NULL),('7461cf03-99f2-4a08-a55d-2387cf5a6edc','','','','2022-07-28 20:01:39.000',NULL),('758f72c5-725f-41e9-9f2b-e9c7413505ef','','','','2020-11-24 02:30:27.000',NULL),('765be30c-baf5-4b1d-a093-db941efd2c30','','','','2021-02-03 22:19:00.000',NULL),('76e2133c-e831-4a17-9855-321d32c85c5c','','','','2022-07-28 20:01:34.000',NULL),('78f45227-7d09-4475-b253-9d0200ad5c0b','','','','2022-10-31 20:39:14.000',NULL),('79a43f61-b086-49ff-ba69-6ce7c7e33bbe','7164789004','','','2021-01-18 20:23:06.000',NULL),('7a2e565f-3ca5-4693-a24e-7c857eb7c63a','2405514225','','','2022-04-11 20:00:54.000',NULL),('7c444a35-df5c-47ff-b813-308ab8754cb3','3012195192','','','2021-02-03 22:19:24.000',NULL),('7c4aa2b7-d6e9-4fe3-b7fc-cf6e3fed51d3','','','','2022-03-23 17:57:43.000',NULL),('7dba382b-45b4-4029-9a31-488e74ee34a9','','','','2021-06-21 22:41:15.000',NULL),('7f9709a8-b721-4318-9a3e-bd9bfbd434dd','2405810311','','','2021-05-03 23:00:28.000',NULL),('80021482-eb3c-40df-a453-e83a76397c25','','','','2022-02-28 12:59:36.000',NULL),('818f38d6-2f94-4cb7-843d-5089aa76b3a8','','','','2022-06-06 23:11:15.000','2024-08-28 08:08:35.563'),('821a1207-38ba-47bb-b1c9-0a507bf5c12e','','','','2021-09-14 21:44:29.000',NULL),('8346eaac-6c03-483c-a6d9-4bbe43d21c64','','','','2021-09-28 21:02:52.000',NULL),('8396d7f3-0a3d-418b-bd91-eba052344744','','','','2021-09-14 00:48:00.000',NULL),('85c06696-f347-41e3-9c5e-cd2481c1ac78','','','','2020-11-24 02:30:27.000',NULL),('870ecbe7-4292-4476-a221-2d22026cffb9','','','','2022-08-17 22:03:33.000',NULL),('875b0613-536e-4a5e-a62e-2fa2e552db66','','','','2021-10-04 22:11:23.000',NULL),('8a06b311-3aa7-4ac6-ad7b-934224b8b689','','','','2021-06-21 21:55:32.000',NULL),('8c769e37-7dbc-4074-8472-58a42e8fcf97','','','','2020-11-24 02:30:27.000',NULL),('92f3d146-7a6b-4cf7-b0eb-bd8fc6b97b68','','','','2022-09-07 20:08:43.000',NULL),('942c8ac9-f491-4b47-b15a-d68834d01184','','','','2020-11-24 02:30:27.000',NULL),('968509ca-1a4f-4209-a809-f5230a29443c','','','','2020-11-24 02:30:27.000',NULL),('96ba700c-a20d-4e52-b92b-3c70d0d85046','','','','2022-08-03 19:28:42.000',NULL),('98adc4a7-48a1-44be-8495-11cd88e91634','','','','2022-03-14 14:03:39.000','2023-05-22 09:12:38.054'),('9a4087a0-50a8-4092-93c0-0b3f6bca94ec','','','','2022-11-16 22:49:06.000',NULL),('9d35ba20-9abf-41dd-8cf5-43525db113a7','','','','2021-09-14 21:44:29.000',NULL),('9e55c892-bd90-4e8f-aa5b-e73fd36b39bb','','','','2022-07-28 20:01:39.000',NULL),('9ec502eb-b903-422b-9e7c-1be6dd8e71eb','','','','2020-11-24 02:30:27.000',NULL),('a268e813-b69a-4cc3-9ecd-82b9cff256e5','','','','2022-06-06 23:11:15.000','2024-08-28 08:08:35.563'),('a6efe370-e9d6-43eb-8e9a-b859958fa190','','','','2022-10-17 20:43:12.000',NULL),('a91e1b07-36e2-4c10-88eb-3dfdde65324c','','','','2022-09-14 21:49:36.000',NULL),('a94088fe-ea2c-42d9-8daf-55253d4f3542','','','','2022-06-22 20:34:17.000',NULL),('aa923b43-ca04-48ad-a409-2c0fff006894','','','','2022-09-12 23:45:43.000',NULL),('acac5575-4a69-444b-96dc-d288004b9ea7','2404521769','','','2020-11-24 02:30:27.000',NULL),('ae1b4b10-2ae9-4cee-baf6-8f1b9b8ca652','','','','2022-08-03 19:28:42.000',NULL),('ae72c7ad-9461-11ee-8fd8-58a023cda0dc','','','','2023-12-06 18:02:55.471','2023-12-06 13:10:21.156'),('ae72ea14-9461-11ee-8fd8-58a023cda0dc','','','','2023-12-06 18:02:55.489','2023-12-06 13:10:21.156'),('ae7310c3-9461-11ee-8fd8-58a023cda0dc','','','','2023-12-06 18:02:55.494','2023-12-06 13:10:21.156'),('aea26e31-977f-11ef-8187-58a023cda0dc','','','','2024-10-31 12:00:11.833',NULL),('aea27ef2-977f-11ef-8187-58a023cda0dc','','','','2024-10-31 12:00:11.836',NULL),('aea28e6d-977f-11ef-8187-58a023cda0dc','','','','2024-10-31 12:00:11.839',NULL),('b2686e03-88ae-45d1-bebe-4cc41e8729b7','','','','2022-08-17 22:03:33.000',NULL),('b4c648a2-9837-11ee-86e7-58a023cda0dc','','','','2024-10-31 14:02:21.750','2024-10-31 10:02:21.753'),('b4c669ea-9837-11ee-86e7-58a023cda0dc','','','','2024-10-31 14:02:21.752','2024-10-31 10:02:21.753'),('b4c67ad9-9837-11ee-86e7-58a023cda0dc','','','','2024-10-31 14:02:21.753','2024-10-31 10:02:21.753'),('b4e756dd-41ee-45d2-8f64-fbcdefcd15e0','','','','2022-06-20 23:21:45.000',NULL),('b63a1867-674b-47bb-beab-18629e7aace7','','','','2020-11-24 02:30:27.000',NULL),('b66587f5-a3cb-4ce2-a7b5-7be918b12002','','','','2022-09-07 18:41:12.000',NULL),('b9bf4d38-5ade-4fac-b315-cdc958fa706c','','','','2021-09-14 21:44:29.000',NULL),('ba8e2902-70d0-4b52-9a53-896789ad20e8','','','','2022-07-28 20:01:39.000',NULL),('bbc79349-6c30-11ee-bc7f-58a023cda0dc','8047419610','','','2024-10-31 14:02:21.717','2024-10-31 10:02:21.718'),('bbc7b043-6c30-11ee-bc7f-58a023cda0dc','','','','2023-10-16 14:31:45.979','2024-10-31 10:02:21.718'),('bbc7c618-6c30-11ee-bc7f-58a023cda0dc','','','','2023-10-16 14:31:45.982','2024-10-31 10:02:21.718'),('bd19cc51-f4ff-42dc-8e83-9be50a390d32','','','','2021-06-21 22:41:15.000',NULL),('bd5cbfac-7b62-420e-8266-a3490dea620f','','','','2022-03-23 20:14:51.000','2024-10-31 10:02:21.704'),('bd9e87ad-96c5-11ef-8234-58a023cda0dc','','','','2024-10-30 13:49:10.591','2024-10-30 09:49:21.350'),('bd9ea34c-96c5-11ef-8234-58a023cda0dc','','','','2024-10-30 13:49:10.608','2024-10-30 09:49:21.350'),('bd9eb387-96c5-11ef-8234-58a023cda0dc','','','','2024-10-30 13:49:10.612','2024-10-30 09:49:21.350'),('be723606-baa2-4a98-96e6-f8d24a003974','','','','2022-07-18 20:33:34.000',NULL),('bf70ae32-cf0f-423d-8f3c-685f054f80f2','9179402622','','','2021-09-14 00:48:15.000',NULL),('bffa9e6b-004f-4064-be6c-f0770e74489c','','','','2020-11-23 20:30:27.000',NULL),('c135e3d3-e5f1-43ac-a18b-ceebbc2602ea','2403553510','','','2020-11-24 02:30:27.000',NULL),('c1e16914-6511-42df-8bec-3431107f78fd','','','','2022-06-20 23:21:45.000',NULL),('c451c52c-5b75-4c7e-ba39-d976fe4f330b','','','','2021-01-18 22:13:40.000',NULL),('c86a31d7-9ce6-4496-8d4d-b070a3616547','','','','2020-11-24 02:30:27.000',NULL),('c8da98b4-3c24-488b-8fbc-476c469b66e9','','','','2021-06-21 21:55:32.000',NULL),('cc9dc84d-3563-4817-ba9d-34b8086cc547','','','','2022-03-14 13:58:57.000',NULL),('cccc8f4b-0bc2-4c4f-87f6-eb58bb80ea24','','','','2022-09-07 18:41:12.000',NULL),('cf597493-bff1-44e4-bd83-520ad63f86ec','','','','2020-11-24 02:30:27.000',NULL),('d177ab52-b885-4fc3-8ee4-22c6b83edf71','','','','2021-01-18 20:21:21.000',NULL),('d18452b9-5fef-49a6-97d8-91e0b8d953cb','','','','2020-11-24 02:30:27.000',NULL),('d20c376e-5166-435e-b3a0-4d9121761757','','','','2022-09-07 18:41:12.000',NULL),('d51706a3-2522-4575-bf4b-abb27b7cf511','','','','2023-02-20 20:27:24.000',NULL),('d5383893-3141-4d4e-a6a1-a41dcee94c74','','','','2022-11-14 22:09:21.000',NULL),('d5c1291e-40cf-464e-b1dd-09a5452b6462','','','','2020-11-24 02:30:27.000',NULL),('d986a3a0-8fcc-11ef-b6be-58a023cda0dc','','','','2024-10-31 14:02:21.767','2024-10-31 10:02:21.770'),('d986b245-8fcc-11ef-b6be-58a023cda0dc','','','','2024-10-31 14:02:21.768','2024-10-31 10:02:21.770'),('d986bc3f-8fcc-11ef-b6be-58a023cda0dc','','','','2024-10-31 14:02:21.769','2024-10-31 10:02:21.770'),('d9b98438-a9fc-429a-9366-6460c00965d5','','','','2020-11-24 02:30:27.000',NULL),('dc1262b2-a01b-47a4-8671-cf0eeb98bb16','','','','2022-06-22 19:24:03.000',NULL),('e13a9a2e-0619-4a5f-aec5-21991438d62c','','','','2022-07-18 20:33:34.000',NULL),('e16399c2-e013-4027-95cb-78eecb666cad','','','','2022-05-25 19:17:19.000',NULL),('e1741670-0cfe-43c2-9c5e-5df9b34bf38e','','','','2021-06-21 21:55:32.000',NULL),('e21ac466-825f-4a91-aafa-affe6323f27e','','','','2022-09-07 20:08:43.000',NULL),('e380c427-c49d-4b94-a437-88480f7123c2','','','','2020-11-24 02:30:27.000',NULL),('ea55bd84-b82c-4e24-9bb9-b027122daa7c','','','','2022-11-14 22:09:21.000',NULL),('eae3a5d7-517b-4306-9fcc-390f3299281a','3016335090','','','2021-04-10 01:51:41.000',NULL),('ec0cc4b4-a59a-400b-9c1a-a4d1569faa44','','','','2022-06-20 23:21:45.000',NULL),('eed7a006-cb96-445a-8173-85594ba48cc1','','','','2022-09-07 20:08:43.000',NULL),('eedfe53a-d997-4f79-aa35-81db918f9884','','','','2022-11-16 22:49:06.000',NULL),('f1cc669f-682a-4af8-8369-8339f181e2e6','','','','2022-09-14 21:49:36.000',NULL),('f23a0a13-5b3f-4372-8c81-9ad5b5a22b12','','','','2022-08-17 22:03:33.000',NULL),('f3d694c8-f041-4218-91e6-81c0cc060e51','','','','2022-03-14 14:03:39.000','2023-05-22 09:12:38.054'),('f575db82-713c-451c-8ef7-ebc5429472bd','','','','2022-06-22 19:24:03.000',NULL),('fae1c714-ed03-4d45-a413-aa37b2903e02','','','','2022-07-28 20:01:34.000',NULL),('fe7db8c2-cca5-4a3d-8b9e-5ead3d2c4f9c','','','','2022-11-14 22:09:21.000',NULL),('ffe9346c-437f-4371-bd85-9366682d0451','','','','2022-03-23 17:57:43.000',NULL);
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Practitioner`
--

DROP TABLE IF EXISTS `Practitioner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Practitioner` (
  `uuid` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `phoneInfoId` varchar(36) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  CONSTRAINT `Practitioner_ibfk_1` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Practitioner`
--

LOCK TABLES `Practitioner` WRITE;
/*!40000 ALTER TABLE `Practitioner` DISABLE KEYS */;
INSERT INTO `Practitioner` VALUES ('03c3e46f-9e6b-4ac6-b6c3-a7d92a20e75a','','bd5cbfac-7b62-420e-8266-a3490dea620f','2024-10-31 14:02:21.703','2024-10-31 10:02:21.704'),('083f0c90-7d43-418e-ac2e-750b6a792f71','','3c6fe3c0-79bf-46ad-9f70-34ff2fbda2f9','2020-11-24 02:30:28.000',NULL),('0953b421-eb2e-4531-8eb6-a07623eeec0b','','53ad1348-4db1-4270-b100-45053dd26c00','2020-11-24 02:30:28.000',NULL),('0a648dc2-53f7-4e55-a98a-3a5691cf284a','','dc1262b2-a01b-47a4-8671-cf0eeb98bb16','2022-06-22 19:24:03.000',NULL),('0a80f3a5-5819-4aea-8c10-f162f351f2d0','','7461cf03-99f2-4a08-a55d-2387cf5a6edc','2022-07-28 20:01:39.000',NULL),('0c2d939d-c60c-4cff-99fc-bc0f1aa33ca2','','bd19cc51-f4ff-42dc-8e83-9be50a390d32','2021-06-21 22:41:15.000',NULL),('15009d08-be9a-4eda-aadc-45ad0c18386d','','4cfbff1d-edab-40f9-97a4-391af675f9e6','2020-11-24 02:30:28.000',NULL),('198697b3-1760-4fb4-a991-f09b12d04844','','67791c87-1130-45d1-ae1d-1b1d0806136e','2021-04-10 01:51:41.000',NULL),('1efb5890-bb19-4565-9403-960df1579ea7','','d18452b9-5fef-49a6-97d8-91e0b8d953cb','2020-11-24 02:30:28.000',NULL),('1f00a1fe-f7be-46cb-b884-db64424bcbcf','','3aaa54f6-80a1-48a0-bb62-9a66060ec464','2022-06-22 20:34:17.000',NULL),('202b4368-ff42-4fac-a251-9e2e62d6d46b','','37614f4d-8830-4f1e-9619-4377b5d0f99a','2023-02-20 20:27:24.000',NULL),('23ab6b60-40be-4cf9-8aff-6f332c702d5e','','0665c5c5-da18-4f50-99e0-cc5e2aa5017b','2022-10-17 20:43:12.000',NULL),('25ff2c24-6110-4d5f-8c89-fc9a760b8f88','Noumbissi','35af927f-6fe0-4f56-a6f5-07fd6cf54563','2022-03-21 18:35:33.000',NULL),('393271e3-3355-4993-b7c4-5c3fcbc07b0b','','bffa9e6b-004f-4064-be6c-f0770e74489c','2020-11-23 20:30:28.000',NULL),('3a3e46d1-4a48-4f62-bdce-70f3e4c6777b','','1c3cdb6b-2840-4aab-894a-d187f827f7ea','2022-09-14 21:49:36.000',NULL),('3b131682-ac74-499c-9c18-9220543940e2','','5a60ed9d-1f64-40b4-b9f8-49f4f26923c8','2021-09-14 00:48:00.000',NULL),('46c51f94-7338-11ee-b011-58a023cda0dc','','46c52442-7338-11ee-b011-58a023cda0dc','2024-10-31 14:02:21.734','2024-10-31 10:02:21.734'),('50e8cb26-fa6a-4265-96ff-e03c8cc674dd','','2edc791b-9060-49af-874a-d70693b06db4','2022-10-31 20:39:14.000',NULL),('5100a2fc-8b26-4959-9434-1cb051951092','','6fe2ba39-6001-491d-b1b5-fcdbca8a7d1b','2021-02-03 22:19:00.000',NULL),('59439f2b-06c7-48d0-8546-ee348741ed7e','','17232bc8-ac2e-4014-88b2-6927bad52bca','2022-09-12 23:45:43.000',NULL),('5c8b8140-2bb3-47f7-a1e2-d8c5e93ef815','','47746942-5f9f-4fa9-9ff1-38ba2a06d854','2022-05-25 19:17:19.000',NULL),('5f02d1de-8f1e-4ad9-aff1-6fd558e0486c','','8c769e37-7dbc-4074-8472-58a42e8fcf97','2020-11-24 02:30:28.000',NULL),('5f260f41-7ee1-4ab3-9776-a7bfd4ee1228','','03cb3092-df4c-4bc7-ad4b-2ccdaa70647c','2021-04-09 23:20:15.000',NULL),('653772e1-d99a-4a98-b439-f864fbe97d4a','','5f50175b-9738-4776-a8e0-e4ba4e2264f0','2022-11-16 22:49:06.000',NULL),('6b57fc5c-a3fd-4eec-b28a-d67be81d7e9a','','3c934d9f-efb6-486b-ae60-e15b963d56f7','2024-08-28 12:08:35.541','2024-08-28 08:08:35.563'),('72c2452b-6332-4939-857d-fb27c830a378','','942c8ac9-f491-4b47-b15a-d68834d01184','2020-11-24 02:30:28.000',NULL),('72cfec76-0495-41c2-9591-a2bf05a71a13','','4c87db90-10e1-4b90-bfec-e55d6d28cf9c','2020-11-24 02:30:28.000',NULL),('81745b13-1ee0-47c8-839d-8ca5d9a71972','','9d35ba20-9abf-41dd-8cf5-43525db113a7','2021-09-14 21:44:29.000',NULL),('8d1c0763-4183-4fad-bde3-6f05541a9898','','ffe9346c-437f-4371-bd85-9366682d0451','2022-03-23 17:57:43.000',NULL),('8eae6895-d19b-4c80-8634-abac98ef283d','','5d2374a3-5eca-4297-abfe-50d01feea95f','2021-09-28 21:02:52.000',NULL),('9a561c5c-c56d-4a4d-aae5-f4efeb0fec5d','','70286368-2d26-43da-82f7-f46a6b8a9afb','2022-02-28 12:59:36.000',NULL),('9ef02a5d-b34e-45d2-b319-c0bc0f116d64','','411dfb3c-161b-4ee7-8c9d-fba592857718','2021-10-04 22:11:23.000',NULL),('a02fd72d-aa54-4d61-b749-30b796c8c194','','e1741670-0cfe-43c2-9c5e-5df9b34bf38e','2021-06-21 21:55:32.000',NULL),('ac73365c-97ee-4f05-8307-3df67120c7e0','','ec0cc4b4-a59a-400b-9c1a-a4d1569faa44','2022-06-20 23:21:45.000',NULL),('ae73069f-9461-11ee-8fd8-58a023cda0dc','','ae7310c3-9461-11ee-8fd8-58a023cda0dc','2023-12-06 18:02:55.496','2023-12-06 13:10:21.156'),('aea28a3e-977f-11ef-8187-58a023cda0dc','','aea28e6d-977f-11ef-8187-58a023cda0dc','2024-10-31 12:00:11.840',NULL),('b26007f5-85e7-45a1-8f2f-247f653e04c9','Noumbissi','565df856-d2f2-4b38-9aef-7ca6c96fb9ee','2023-05-22 13:12:31.593','2023-05-22 09:12:38.054'),('b2860354-f3b1-4fae-9607-908602502204','','e21ac466-825f-4a91-aafa-affe6323f27e','2022-09-07 20:08:43.000',NULL),('b4c675d9-9837-11ee-86e7-58a023cda0dc','','b4c67ad9-9837-11ee-86e7-58a023cda0dc','2024-10-31 14:02:21.753','2024-10-31 10:02:21.753'),('b594886d-a8fc-41c6-a2d8-895467550fba','','53bc6667-c3bb-4f17-a2e9-b4055b1c6bb9','2021-05-03 23:00:28.000',NULL),('bbc7c00a-6c30-11ee-bc7f-58a023cda0dc','','bbc7c618-6c30-11ee-bc7f-58a023cda0dc','2024-10-31 14:02:21.718','2024-10-31 10:02:21.718'),('bd08986b-c104-4cf7-b6ad-1c186dd0b6b8','','d5383893-3141-4d4e-a6a1-a41dcee94c74','2022-11-14 22:09:21.000',NULL),('bd9eaef1-96c5-11ef-8234-58a023cda0dc','','bd9eb387-96c5-11ef-8234-58a023cda0dc','2024-10-30 13:49:10.613','2024-10-30 09:49:21.350'),('bf6738bd-0382-4efa-b28b-d9fbe4783faf','','c451c52c-5b75-4c7e-ba39-d976fe4f330b','2021-01-18 22:13:40.000',NULL),('c88dd0c7-a38f-4ed4-86be-a24c2fceb390','','9ec502eb-b903-422b-9e7c-1be6dd8e71eb','2020-11-24 02:30:28.000',NULL),('d0c6447c-4f35-4fca-bb5c-43a1e267aea1','','315fd84c-912f-4213-981a-1f4fb98193fd','2022-07-28 20:01:34.000',NULL),('d1b190fd-db17-44da-b86c-67ceb2f5cc0a','','be723606-baa2-4a98-96e6-f8d24a003974','2022-07-18 20:33:34.000',NULL),('d3c8fed1-2c85-47e7-b864-27c4efad6561','','b66587f5-a3cb-4ce2-a7b5-7be918b12002','2022-09-07 18:41:12.000',NULL),('d581c290-95f9-4626-91cb-bb428bd3f8e9','','4ad62edd-4661-451e-9199-ebc4a846fd12','2022-03-14 13:58:57.000',NULL),('d986ba13-8fcc-11ef-b6be-58a023cda0dc','','d986bc3f-8fcc-11ef-b6be-58a023cda0dc','2024-10-31 14:02:21.770','2024-10-31 10:02:21.770'),('e18636cd-7ac9-4000-9b18-e77573048199','','96ba700c-a20d-4e52-b92b-3c70d0d85046','2022-08-03 19:28:42.000',NULL),('e1c97d39-5a53-4563-bc01-7bcdd5131e62','','d177ab52-b885-4fc3-8ee4-22c6b83edf71','2021-01-18 20:21:21.000',NULL),('e3812e8e-3bcf-4cce-b34d-cf8230c8950f','','f23a0a13-5b3f-4372-8c81-9ad5b5a22b12','2022-08-17 22:03:33.000',NULL),('f4613a5a-3d3a-4d55-a117-c2a35da6e70f','','758f72c5-725f-41e9-9f2b-e9c7413505ef','2020-11-24 02:30:28.000',NULL),('f9ff02dd-d19b-4b3a-9c17-e26ffd578cc4','','5c6e8152-210a-44a9-b56c-57018a2211c8','2022-04-11 20:00:40.000',NULL);
/*!40000 ALTER TABLE `Practitioner` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `versionMajor` int NOT NULL,
  `versionMinor` int NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_wow_patient_1.0_create_wow_patient_from_condor');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'wow_patient'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-10-31 10:33:49
