-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: wow_application
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `workflow` enum('FREE','WORKFLOW_1','WORKFLOW_2','WORKFLOW_3') NOT NULL DEFAULT 'FREE',
  `comments` text,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastAccessed` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `patientId` (`patientId`),
  CONSTRAINT `Act_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Act_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `wow_patient`.`Patient` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES ('35aa76b0-4728-11ee-9ed6-a86daa000811',196,'2b399d66-4728-11ee-9ed6-a86daa000811','Acte Couronne',1,'FREE','',0,'2023-08-30 13:27:31.969',NULL,'2023-08-30 13:37:36.208','2023-08-30 13:27:31.971','2023-08-30 11:37:36.209','2023-08-30 13:37:59.192'),('3fe9ba1b-472c-11ee-9ed6-a86daa000811',196,'2b399d66-4728-11ee-9ed6-a86daa000811','direct scan',4,'FREE','',0,'2023-08-30 13:56:27.147',NULL,'2023-08-30 14:20:56.959','2023-08-30 14:03:20.911','2023-08-30 12:20:56.960','2023-08-30 14:20:56.963'),('61ce0aa4-472b-11ee-9ed6-a86daa000811',196,'2b399d66-4728-11ee-9ed6-a86daa000811','Acte Onlay',3,'FREE','',0,'2023-08-30 13:50:14.512',NULL,'2023-08-30 14:20:44.607','2023-08-30 13:50:14.514','2023-08-30 12:20:44.607','2023-08-30 14:20:44.610'),('68303344-472d-11ee-9ed6-a86daa000811',196,'2b399d66-4728-11ee-9ed6-a86daa000811','Acte Couronne sur implant',5,'FREE','',0,'2023-08-30 14:04:44.215',NULL,'2023-08-30 14:21:12.424','2023-08-30 14:04:44.218','2023-08-30 12:21:12.425','2023-08-30 14:21:12.430'),('989c88f2-472a-11ee-9ed6-a86daa000811',196,'2b399d66-4728-11ee-9ed6-a86daa000811','Acte Couronne',2,'FREE','',0,'2023-08-30 13:44:36.965',NULL,'2023-08-30 13:47:23.549','2023-08-30 13:44:36.966','2023-08-30 11:47:23.550','2023-08-30 13:47:38.517'),('f2691117-472f-11ee-9ed6-a86daa000811',196,'2b399d66-4728-11ee-9ed6-a86daa000811','Acte Couronne sur implant',6,'WORKFLOW_3','',0,'2023-08-30 14:22:55.107',NULL,'2023-08-30 14:28:28.596','2023-08-30 14:22:55.109','2023-08-30 12:28:28.597','2023-08-30 14:28:57.473');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `uuid` varchar(36) NOT NULL,
  `line0` varchar(255) DEFAULT NULL,
  `line1` varchar(255) DEFAULT NULL,
  `line2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(255) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('37e905b8-eafe-4d79-93b0-71ce73096a6e','labege','','','','labege','','11110','France','2023-08-30 11:24:32.525','2023-08-30 13:24:33.092'),('6524681a-2b40-4860-9a83-d78658f9e377','','','','','labege','','','','2023-08-30 11:31:50.133','2023-08-30 13:32:05.791');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `credentialsId` (`credentialsId`),
  KEY `personInfoId` (`personInfoId`),
  KEY `phoneInfoId` (`phoneInfoId`),
  KEY `addressInfoId` (`addressInfoId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Assistant_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_2` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_3` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_4` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_5` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_6` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_CIRCLE_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `CircleOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CircleOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `CircleOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `CircleOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Config` (
  `id` mediumint unsigned NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `fullRetrieve` tinyint(1) DEFAULT '0',
  `syncEnabled` tinyint(1) DEFAULT '1',
  `showOcclusionScan` tinyint(1) DEFAULT '1',
  `showOpenStlWarning` tinyint(1) DEFAULT '1',
  `showMarginLinesWarning` tinyint(1) DEFAULT '1',
  `showDeleteConfirmation` tinyint(1) DEFAULT '1',
  `showSyncInfo` tinyint(1) DEFAULT '1',
  `downloadAtFullRetrieve` tinyint(1) DEFAULT '1',
  `lagSound` tinyint(1) DEFAULT '0',
  `lostSound` tinyint(1) DEFAULT '0',
  `emailNotifications` tinyint(1) DEFAULT '1',
  `logout` mediumint DEFAULT '10',
  `language` varchar(2) DEFAULT NULL,
  `diagnosticMode` tinyint(1) DEFAULT '0',
  `repairMode` tinyint(1) DEFAULT '0',
  `flipMaxillaryH` tinyint(1) DEFAULT '0',
  `flipMaxillaryV` tinyint(1) DEFAULT '0',
  `flipMandibleH` tinyint(1) DEFAULT '0',
  `flipMandibleV` tinyint(1) DEFAULT '0',
  `showFlipPopupMaxillary` tinyint(1) DEFAULT '1',
  `showFlipPopupMandible` tinyint(1) DEFAULT '1',
  `enableUserSharing` tinyint(1) DEFAULT '0',
  `lostTrackingRectangle` tinyint(1) DEFAULT '1',
  `showAllPatients` tinyint(1) DEFAULT '0',
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,196,0,1,1,1,1,1,1,1,0,0,1,10,'FR',0,0,0,0,0,0,1,1,0,1,1,'2023-08-30 13:24:30.000','2023-08-30 13:26:48.098','2023-08-30 11:26:48.095'),(1,197,0,1,1,1,1,1,1,1,0,0,1,10,'FR',0,0,0,0,0,0,1,1,0,1,0,'2023-08-30 13:28:35.000','2023-08-30 13:32:05.791','2023-08-30 11:28:36.446');
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Contact` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `professionalId` mediumint unsigned NOT NULL COMMENT 'Le professionnel contact',
  `officeId` varchar(36) DEFAULT NULL,
  `status` enum('INVITATIONSENT','INVITATIONRECEIVED','ACCEPTED','REJECTED') NOT NULL DEFAULT 'INVITATIONSENT',
  `comments` text,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `uniqueContactPro` (`ownerId`,`professionalId`),
  KEY `professionalId` (`professionalId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Contact_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_2` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES ('27ff53b3-e59f-422d-97d1-d9d4246c950b',196,197,NULL,'ACCEPTED','',NULL,'2023-08-30 13:32:04.000','2023-08-30 11:32:05.791','2023-08-30 13:32:05.791'),('3e77eb41-f4b6-43bc-b9b1-7d86cf12c5ca',196,196,NULL,'ACCEPTED','',NULL,'2023-08-30 13:24:31.000','2023-08-30 11:24:33.092','2023-08-30 13:24:33.092');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ContactNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `contactId` varchar(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('RECEIVED','RECEIVED_TO_ACCEPTED','RECEIVED_TO_REJECTED','SENT_TO_ACCEPTED','SENT_TO_REJECTED','ACTIVATION_TIMEOUT') NOT NULL DEFAULT 'RECEIVED',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `ContactNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ContactNotification_ibfk_2` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
INSERT INTO `ContactNotification` VALUES ('cf7974ae-8846-4151-a97f-51ae18292854',196,'27ff53b3-e59f-422d-97d1-d9d4246c950b','léger client','SENT_TO_ACCEPTED',1,'2023-08-30 13:32:04.000',NULL,'2023-08-30 11:32:07.179','2023-08-30 13:32:07.179');
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Credentials` (
  `uuid` varchar(36) NOT NULL,
  `login` varchar(255) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES ('53a5f2ba-3eaf-4bc8-b922-c2319948ddd4','sabine-vip','b0e3df5eccd7d2844837d97c6baad27a09945a8bdcc3c2afd2a4f73578446111','2023-08-30 11:24:32.524','2023-08-30 13:24:33.092'),('5bd8a1ae-8cbd-4514-ac23-408b42c55e97','client leger',NULL,'2023-08-30 11:31:50.126','2023-08-30 13:32:05.791');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Discussion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `selfImplied` tinyint(1) NOT NULL DEFAULT '0',
  `officeId` varchar(36) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`,`ownerId`),
  KEY `ownerId` (`ownerId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Discussion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Discussion_ibfk_2` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
INSERT INTO `Discussion` VALUES ('ecca179e-4728-11ee-9ed6-a86daa000811',196,0,NULL,NULL,'2023-08-30 13:32:39.200','2023-08-30 12:20:10.414','2023-08-30 14:20:10.414'),('ecca179e-4728-11ee-9ed6-a86daa000811',197,0,NULL,NULL,'2023-08-30 13:32:39.200','2023-08-30 11:32:39.200',NULL);
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `File`
--

DROP TABLE IF EXISTS `File`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `File` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `path` text,
  `tag` text,
  `originalName` text NOT NULL,
  `originalId` varchar(36) NOT NULL,
  `metadata` text,
  `type` enum('BIN','JSON','PDF','PLY','STL','PNG','XYZ','ZIP') NOT NULL,
  `version` mediumint unsigned DEFAULT '0',
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT 'CREATED',
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `version` (`originalId`,`version`),
  CONSTRAINT `File_ibfk_1` FOREIGN KEY (`originalId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `File`
--

LOCK TABLES `File` WRITE;
/*!40000 ALTER TABLE `File` DISABLE KEYS */;
INSERT INTO `File` VALUES ('03c3ab4a-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/scan_eafd17f1-472c-11ee-9ed6-a86daa000811/03c3ab4a-472d-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_LESC_eafd17f1-472c-11ee-9ed6-a86daa000811_MODEL','03c3ab4a-472d-11ee-9ed6-a86daa000811.zip','03c3ab4a-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mordu gauche 1.1.4.1.1\",\"modelMatrix\":\"-0.999237,-0.0153408,0.0352326,0,0.0201003,-0.988329,0.151195,0,0.0334956,0.151561,0.987876,0,11.4622,-8.12971,-16.0413,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:03:36.000','2023-08-30 12:03:56.521','2023-08-30 14:03:56.521'),('03c3c1ca-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/scan_eafd17f1-472c-11ee-9ed6-a86daa000811/03c3c1ca-472d-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_LESC_eafd17f1-472c-11ee-9ed6-a86daa000811_SNAPS','03c3c1ca-472d-11ee-9ed6-a86daa000811.png','03c3c1ca-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mordu gauche 1.1.4.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:03:37.000','2023-08-30 12:03:56.525','2023-08-30 14:03:56.525'),('03ed27f7-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_a5772713-472e-11ee-9ed6-a86daa000811/03ed27f7-472f-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_a5772713-472e-11ee-9ed6-a86daa000811_MODEL','03ed27f7-472f-11ee-9ed6-a86daa000811.zip','a577454a-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule scanbody 1.1.5.1.3\",\"modelMatrix\":\"0.938254,-0.336666,0.0795923,0,0.345946,0.913085,-0.215865,0,-1.45188e-09,0.230071,0.973174,0,-18.1829,5.52246,-25.4427,1\",\"scanBodies\":[{\"position\":\"12.9666,6,0,0,-3.66681,0,6,0,28.453,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":47}]}','ZIP',2,'SYNCED',0,NULL,'2023-08-30 14:16:18.000','2023-08-30 12:20:09.766','2023-08-30 14:20:09.766'),('03ed6203-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_a5772713-472e-11ee-9ed6-a86daa000811/03ed6203-472f-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_a5772713-472e-11ee-9ed6-a86daa000811_SNAPS','03ed6203-472f-11ee-9ed6-a86daa000811.png','a57e163c-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule scanbody 1.1.5.1.3 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-08-30 14:16:19.000','2023-08-30 12:20:09.773','2023-08-30 14:20:09.773'),('04bb69aa-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/occlusion_989d6f5f-472a-11ee-9ed6-a86daa000811/scan_f30f1fe1-472a-11ee-9ed6-a86daa000811/04bb69aa-472b-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_SESS_989d6f5f-472a-11ee-9ed6-a86daa000811_LESC_f30f1fe1-472a-11ee-9ed6-a86daa000811_MODEL','04bb69aa-472b-11ee-9ed6-a86daa000811.zip','04bb69aa-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mordu gauche 1.1.2.1.1\",\"modelMatrix\":\"-0.999631,-0.0262633,0.00456255,0,0.0263469,-0.995471,-0.0914342,0,0.00664423,-0.0913673,0.995801,0,2.18117,3.68486,-20.4244,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:47:41.000','2023-08-30 11:49:13.660','2023-08-30 13:49:13.660'),('04bb8166-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/occlusion_989d6f5f-472a-11ee-9ed6-a86daa000811/scan_f30f1fe1-472a-11ee-9ed6-a86daa000811/04bb8166-472b-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_SESS_989d6f5f-472a-11ee-9ed6-a86daa000811_LESC_f30f1fe1-472a-11ee-9ed6-a86daa000811_SNAPS','04bb8166-472b-11ee-9ed6-a86daa000811.png','04bb8166-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mordu gauche 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 13:47:41.000','2023-08-30 11:49:13.664','2023-08-30 13:49:13.664'),('17557d10-4730-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_f2691117-472f-11ee-9ed6-a86daa000811/occlusion_f26a478b-472f-11ee-9ed6-a86daa000811/scan_f59e3d8b-472f-11ee-9ed6-a86daa000811/17557d10-4730-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_f2691117-472f-11ee-9ed6-a86daa000811_SESS_f26a478b-472f-11ee-9ed6-a86daa000811_TOSC_f59e3d8b-472f-11ee-9ed6-a86daa000811_MODEL','17557d10-4730-11ee-9ed6-a86daa000811.zip','17557d10-4730-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire pre-scan 1.1.6.1.1\",\"modelMatrix\":\"-0.362778,0.922441,-0.132267,0,-0.931876,-0.359105,0.0514915,0,-5.31421e-09,0.141937,0.989876,0,7.30718,-19.4023,-15.2171,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:23:57.054','2023-08-30 12:23:57.340','2023-08-30 14:23:59.264'),('175594cd-4730-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_f2691117-472f-11ee-9ed6-a86daa000811/occlusion_f26a478b-472f-11ee-9ed6-a86daa000811/scan_f59e3d8b-472f-11ee-9ed6-a86daa000811/175594cd-4730-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_f2691117-472f-11ee-9ed6-a86daa000811_SESS_f26a478b-472f-11ee-9ed6-a86daa000811_TOSC_f59e3d8b-472f-11ee-9ed6-a86daa000811_SNAPS','175594cd-4730-11ee-9ed6-a86daa000811.png','175594cd-4730-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire pre-scan 1.1.6.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:23:57.055','2023-08-30 12:23:57.340','2023-08-30 14:24:01.620'),('1b208ef0-472c-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_61ce0aa4-472b-11ee-9ed6-a86daa000811/occlusion_61cf451e-472b-11ee-9ed6-a86daa000811/computedocclusion_f29eb608-472b-11ee-9ed6-a86daa000811/1b208ef0-472c-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_61ce0aa4-472b-11ee-9ed6-a86daa000811_SESS_61cf451e-472b-11ee-9ed6-a86daa000811_OCC_f29eb608-472b-11ee-9ed6-a86daa000811_TOPLY','1b208ef0-472c-11ee-9ed6-a86daa000811.zip','1b208ef0-472c-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Maxillaire\",\"modelMatrix\":\"0.984036,0.173141,-0.0411727,0,-0.177969,0.95734,-0.227654,0,-1.92446e-09,0.231347,0.972871,0,-11.2721,-8.20667,-22.2497,1\",\"occlusionMatrix\":\"0.979405,-0.05208,0.193783,0,-0.186103,0.135866,0.973231,0,-0.0783194,-0.989359,0.123569,0,-5.10812,18.4014,-0.267878,1\",\"occlusionType\":1,\"referenceScanId\":\"633e5fa3-472b-11ee-9ed6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:55:27.000','2023-08-30 11:55:46.219','2023-08-30 13:55:46.219'),('1b3fc2ee-472c-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_61ce0aa4-472b-11ee-9ed6-a86daa000811/occlusion_61cf451e-472b-11ee-9ed6-a86daa000811/computedocclusion_f29eb608-472b-11ee-9ed6-a86daa000811/1b3fc2ee-472c-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_61ce0aa4-472b-11ee-9ed6-a86daa000811_SESS_61cf451e-472b-11ee-9ed6-a86daa000811_OCC_f29eb608-472b-11ee-9ed6-a86daa000811_LIFIO','1b3fc2ee-472c-11ee-9ed6-a86daa000811.xyz','1b3fc2ee-472c-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"633e5fa3-472b-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 13:55:27.000','2023-08-30 11:55:46.223','2023-08-30 13:55:46.223'),('1b3fca0b-472c-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_61ce0aa4-472b-11ee-9ed6-a86daa000811/occlusion_61cf451e-472b-11ee-9ed6-a86daa000811/computedocclusion_f29eb608-472b-11ee-9ed6-a86daa000811/1b3fca0b-472c-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_61ce0aa4-472b-11ee-9ed6-a86daa000811_SESS_61cf451e-472b-11ee-9ed6-a86daa000811_OCC_f29eb608-472b-11ee-9ed6-a86daa000811_LIFIMO','1b3fca0b-472c-11ee-9ed6-a86daa000811.bin','1b3fca0b-472c-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"633e5fa3-472b-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 13:55:27.000','2023-08-30 11:55:46.227','2023-08-30 13:55:46.227'),('1b407bfd-472c-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_61ce0aa4-472b-11ee-9ed6-a86daa000811/occlusion_61cf451e-472b-11ee-9ed6-a86daa000811/computedocclusion_f29eb608-472b-11ee-9ed6-a86daa000811/1b407bfd-472c-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_61ce0aa4-472b-11ee-9ed6-a86daa000811_SESS_61cf451e-472b-11ee-9ed6-a86daa000811_OCC_f29eb608-472b-11ee-9ed6-a86daa000811_BOPLY','1b407bfd-472c-11ee-9ed6-a86daa000811.zip','1b407bfd-472c-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Mandibule\",\"modelMatrix\":\"-0.9381,0.343986,-0.0405152,0,-0.346364,-0.93166,0.109732,0,-4.65733e-09,0.116973,0.993135,0,19.5276,-4.72911,-18.5891,1\",\"occlusionMatrix\":\"0.976681,-0.0951092,0.191033,0,0.2105,0.251513,-0.945008,0,0.0427097,0.96318,0.265512,0,-22.8313,-15.045,-1.71296,1\",\"occlusionType\":1,\"referenceScanId\":\"9c3fb326-472b-11ee-9ed6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:55:28.000','2023-08-30 11:55:46.230','2023-08-30 13:55:46.230'),('1b988075-472c-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_61ce0aa4-472b-11ee-9ed6-a86daa000811/occlusion_61cf451e-472b-11ee-9ed6-a86daa000811/computedocclusion_f29eb608-472b-11ee-9ed6-a86daa000811/1b988075-472c-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_61ce0aa4-472b-11ee-9ed6-a86daa000811_SESS_61cf451e-472b-11ee-9ed6-a86daa000811_OCC_f29eb608-472b-11ee-9ed6-a86daa000811_SNAPO','1b988075-472c-11ee-9ed6-a86daa000811.png','1b988075-472c-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Snapshot\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2023-08-30 13:55:28.000','2023-08-30 11:55:46.234','2023-08-30 13:55:46.234'),('23b8a3d6-4730-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_f2691117-472f-11ee-9ed6-a86daa000811/occlusion_f26a478b-472f-11ee-9ed6-a86daa000811/scan_23b881d0-4730-11ee-9ed6-a86daa000811/23b8a3d6-4730-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_f2691117-472f-11ee-9ed6-a86daa000811_SESS_f26a478b-472f-11ee-9ed6-a86daa000811_TOSC_23b881d0-4730-11ee-9ed6-a86daa000811_MODEL','23b8a3d6-4730-11ee-9ed6-a86daa000811.zip','23b8a3d6-4730-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.6.1.2\",\"modelMatrix\":\"-0.362778,0.922441,-0.132267,0,-0.931876,-0.359105,0.0514915,0,-5.31421e-09,0.141937,0.989876,0,7.30718,-19.4023,-15.2171,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:24:17.836','2023-08-30 12:25:08.357','2023-08-30 14:25:09.765'),('23be5cc5-4730-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_f2691117-472f-11ee-9ed6-a86daa000811/occlusion_f26a478b-472f-11ee-9ed6-a86daa000811/scan_23b881d0-4730-11ee-9ed6-a86daa000811/23be5cc5-4730-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_f2691117-472f-11ee-9ed6-a86daa000811_SESS_f26a478b-472f-11ee-9ed6-a86daa000811_TOSC_23b881d0-4730-11ee-9ed6-a86daa000811_SNAPS','23be5cc5-4730-11ee-9ed6-a86daa000811.png','23be5cc5-4730-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.6.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:24:17.874','2023-08-30 12:25:08.358','2023-08-30 14:25:15.346'),('2458f8d4-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/computedocclusion_0712c345-472d-11ee-9ed6-a86daa000811/2458f8d4-472d-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_OCC_0712c345-472d-11ee-9ed6-a86daa000811_TOPLY','2458f8d4-472d-11ee-9ed6-a86daa000811.zip','2458f8d4-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.4.1.1 Maxillaire\",\"modelMatrix\":\"0.954262,0.286579,-0.0851877,0,-0.298972,0.914705,-0.271902,0,1.11896e-08,0.284935,0.958547,0,-19.5243,-8.36947,-15.6125,1\",\"occlusionMatrix\":\"-0.959421,-0.0521755,-0.278136,0,0.270273,-0.449211,-0.851136,0,-0.0806034,-0.891917,0.445219,0,21.9131,12.9179,-1.584,1\",\"occlusionType\":2,\"referenceScanId\":\"416b51d9-472c-11ee-9ed6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:03:23.000','2023-08-30 12:03:56.529','2023-08-30 14:03:56.529'),('247438da-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/computedocclusion_0712c345-472d-11ee-9ed6-a86daa000811/247438da-472d-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_OCC_0712c345-472d-11ee-9ed6-a86daa000811_LIFIO','247438da-472d-11ee-9ed6-a86daa000811.xyz','247438da-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.4.1.1 Ligne de finition Maxillaire manuelle\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"416b51d9-472c-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"manuelle\",\"toothNumber\":1001,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 14:03:23.000','2023-08-30 12:03:56.532','2023-08-30 14:03:56.532'),('24744030-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/computedocclusion_0712c345-472d-11ee-9ed6-a86daa000811/24744030-472d-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_OCC_0712c345-472d-11ee-9ed6-a86daa000811_LIFIMO','24744030-472d-11ee-9ed6-a86daa000811.bin','24744030-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.4.1.1 Ligne de finition métadonnées Maxillaire manuelle\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"416b51d9-472c-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"manuelle\",\"toothNumber\":1001,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 14:03:24.000','2023-08-30 12:03:56.536','2023-08-30 14:03:56.536'),('2474870f-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/computedocclusion_0712c345-472d-11ee-9ed6-a86daa000811/2474870f-472d-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_OCC_0712c345-472d-11ee-9ed6-a86daa000811_LIFIO','2474870f-472d-11ee-9ed6-a86daa000811.xyz','2474870f-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.4.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"416b51d9-472c-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 14:03:24.000','2023-08-30 12:03:56.539','2023-08-30 14:03:56.539'),('24748db4-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/computedocclusion_0712c345-472d-11ee-9ed6-a86daa000811/24748db4-472d-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_OCC_0712c345-472d-11ee-9ed6-a86daa000811_LIFIMO','24748db4-472d-11ee-9ed6-a86daa000811.bin','24748db4-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.4.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"416b51d9-472c-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 14:03:24.000','2023-08-30 12:03:56.542','2023-08-30 14:03:56.542'),('2474f22b-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/computedocclusion_0712c345-472d-11ee-9ed6-a86daa000811/2474f22b-472d-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_OCC_0712c345-472d-11ee-9ed6-a86daa000811_BOPLY','2474f22b-472d-11ee-9ed6-a86daa000811.zip','2474f22b-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.4.1.1 Mandibule\",\"modelMatrix\":\"-0.282978,0.958216,-0.041777,0,-0.959126,-0.28271,0.0123258,0,7.68068e-10,0.0435574,0.999051,0,3.13092,-14.5292,-19.4721,1\",\"occlusionMatrix\":\"-0.998853,0.0125354,-0.0476241,0,0.00114081,0.969055,0.246662,0,0.0484814,0.246577,-0.967949,0,11.7153,-3.10107,17.953,1\",\"occlusionType\":2,\"referenceScanId\":\"78ac12f2-472c-11ee-9ed6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:03:25.000','2023-08-30 12:03:56.546','2023-08-30 14:03:56.546'),('24cb639a-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/computedocclusion_0712c345-472d-11ee-9ed6-a86daa000811/24cb639a-472d-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_OCC_0712c345-472d-11ee-9ed6-a86daa000811_SNAPO','24cb639a-472d-11ee-9ed6-a86daa000811.png','24cb639a-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.4.1.1 Snapshot\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:03:25.000','2023-08-30 12:03:56.550','2023-08-30 14:03:56.550'),('259989c9-472c-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_61ce0aa4-472b-11ee-9ed6-a86daa000811/order_61d0939c-472b-11ee-9ed6-a86daa000811/259989c9-472c-11ee-9ed6-a86daa000811.pdf','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_61ce0aa4-472b-11ee-9ed6-a86daa000811_PROST_61d0939c-472b-11ee-9ed6-a86daa000811_FORM','259989c9-472c-11ee-9ed6-a86daa000811.pdf','259989c9-472c-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Commande 1.1.3.1 Onlay\",\"title\":\"Onlay\"}','PDF',0,'SYNCED',0,NULL,'2023-08-30 13:55:44.000','2023-08-30 11:55:46.238','2023-08-30 13:55:46.238'),('27b52885-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/scan_78ac12f2-472c-11ee-9ed6-a86daa000811/27b52885-472d-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_BOSC_78ac12f2-472c-11ee-9ed6-a86daa000811_LIFI','27b52885-472d-11ee-9ed6-a86daa000811.xyz','27b52885-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.4.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 14:03:32.000','2023-08-30 12:03:56.554','2023-08-30 14:03:56.554'),('27b52f37-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/scan_78ac12f2-472c-11ee-9ed6-a86daa000811/27b52f37-472d-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_BOSC_78ac12f2-472c-11ee-9ed6-a86daa000811_LIFIM','27b52f37-472d-11ee-9ed6-a86daa000811.bin','27b52f37-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.4.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 14:03:32.000','2023-08-30 12:03:56.557','2023-08-30 14:03:56.557'),('27b77ffa-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/computedocclusion_0712c345-472d-11ee-9ed6-a86daa000811/27b77ffa-472d-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_OCC_0712c345-472d-11ee-9ed6-a86daa000811_LIFIO','27b77ffa-472d-11ee-9ed6-a86daa000811.xyz','27b77ffa-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.4.1.1 Ligne de finition Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"78ac12f2-472c-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 14:03:26.000','2023-08-30 12:03:56.561','2023-08-30 14:03:56.561'),('27b78410-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/computedocclusion_0712c345-472d-11ee-9ed6-a86daa000811/27b78410-472d-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_OCC_0712c345-472d-11ee-9ed6-a86daa000811_LIFIMO','27b78410-472d-11ee-9ed6-a86daa000811.bin','27b78410-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.4.1.1 Ligne de finition métadonnées Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"78ac12f2-472c-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 14:03:26.000','2023-08-30 12:03:56.564','2023-08-30 14:03:56.564'),('28c7a5b4-4730-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_f2691117-472f-11ee-9ed6-a86daa000811/occlusion_f26a478b-472f-11ee-9ed6-a86daa000811/scan_23b881d0-4730-11ee-9ed6-a86daa000811/28c7a5b4-4730-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_f2691117-472f-11ee-9ed6-a86daa000811_SESS_f26a478b-472f-11ee-9ed6-a86daa000811_TOSC_23b881d0-4730-11ee-9ed6-a86daa000811_MODEL','28c7a5b4-4730-11ee-9ed6-a86daa000811.zip','23b8a3d6-4730-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.6.1.2\",\"modelMatrix\":\"-0.362778,0.922441,-0.132267,0,-0.931876,-0.359105,0.0514915,0,-5.31421e-09,0.141937,0.989876,0,7.30718,-19.4023,-15.2171,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2023-08-30 14:24:26.323','2023-08-30 12:25:08.357','2023-08-30 14:25:11.782'),('2c135c02-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/scan_78ac12f2-472c-11ee-9ed6-a86daa000811/2c135c02-472d-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_BOSC_78ac12f2-472c-11ee-9ed6-a86daa000811_LIFI','2c135c02-472d-11ee-9ed6-a86daa000811.xyz','2c135c02-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.4.1.1 Ligne de finition 1\",\"title\":\"1\",\"toothNumber\":1,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 14:03:32.000','2023-08-30 12:03:56.568','2023-08-30 14:03:56.568'),('2c136090-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/scan_78ac12f2-472c-11ee-9ed6-a86daa000811/2c136090-472d-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_BOSC_78ac12f2-472c-11ee-9ed6-a86daa000811_LIFIM','2c136090-472d-11ee-9ed6-a86daa000811.bin','2c136090-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.4.1.1 Ligne de finition métadonnées 1\",\"title\":\"1\",\"toothNumber\":1,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 14:03:33.000','2023-08-30 12:03:56.572','2023-08-30 14:03:56.572'),('2c161d27-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/computedocclusion_0712c345-472d-11ee-9ed6-a86daa000811/2c161d27-472d-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_OCC_0712c345-472d-11ee-9ed6-a86daa000811_LIFIO','2c161d27-472d-11ee-9ed6-a86daa000811.xyz','2c161d27-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.4.1.1 Ligne de finition Mandibule 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"78ac12f2-472c-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 14:03:27.000','2023-08-30 12:03:56.575','2023-08-30 14:03:56.575'),('2c16211c-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/computedocclusion_0712c345-472d-11ee-9ed6-a86daa000811/2c16211c-472d-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_OCC_0712c345-472d-11ee-9ed6-a86daa000811_LIFIMO','2c16211c-472d-11ee-9ed6-a86daa000811.bin','2c16211c-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.4.1.1 Ligne de finition métadonnées Mandibule 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"78ac12f2-472c-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 14:03:28.000','2023-08-30 12:03:56.579','2023-08-30 14:03:56.579'),('3143d3da-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_121e4546-472f-11ee-9ed6-a86daa000811/3143d3da-472f-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_LESC_121e4546-472f-11ee-9ed6-a86daa000811_MODEL','3143d3da-472f-11ee-9ed6-a86daa000811.zip','3143d3da-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mordu gauche 1.1.5.1.1\",\"modelMatrix\":\"-0.998115,0.0143762,-0.0599737,0,-0.0239405,-0.981973,0.187451,0,-0.0565217,0.188482,0.980441,0,-1.77608,-2.79888,-24.1408,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:17:36.000','2023-08-30 12:20:09.777','2023-08-30 14:20:09.777'),('3143fbb5-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_121e4546-472f-11ee-9ed6-a86daa000811/3143fbb5-472f-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_LESC_121e4546-472f-11ee-9ed6-a86daa000811_SNAPS','3143fbb5-472f-11ee-9ed6-a86daa000811.png','3143fbb5-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mordu gauche 1.1.5.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:17:37.000','2023-08-30 12:20:09.781','2023-08-30 14:20:09.781'),('31e2e594-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/occlusion_989d6f5f-472a-11ee-9ed6-a86daa000811/computedocclusion_2ec21872-472b-11ee-9ed6-a86daa000811/31e2e594-472b-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_SESS_989d6f5f-472a-11ee-9ed6-a86daa000811_OCC_2ec21872-472b-11ee-9ed6-a86daa000811_TOPLY','31e2e594-472b-11ee-9ed6-a86daa000811.zip','31e2e594-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Maxillaire\",\"modelMatrix\":\"0.943336,0.328267,-0.048553,0,-0.331838,0.933184,-0.138025,0,1.571e-09,0.146315,0.989238,0,-17.8129,-5.36634,-22.0972,1\",\"occlusionMatrix\":\"-0.983371,-0.154349,-0.0957134,0,0.107805,-0.0719563,-0.991565,0,0.14616,-0.985396,0.0873988,0,11.9606,21.1312,-3.99931,1\",\"occlusionType\":2,\"referenceScanId\":\"99da97a8-472a-11ee-9ed6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:48:56.000','2023-08-30 11:49:13.669','2023-08-30 13:49:13.669'),('3201d58a-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/occlusion_989d6f5f-472a-11ee-9ed6-a86daa000811/computedocclusion_2ec21872-472b-11ee-9ed6-a86daa000811/3201d58a-472b-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_SESS_989d6f5f-472a-11ee-9ed6-a86daa000811_OCC_2ec21872-472b-11ee-9ed6-a86daa000811_LIFIO','3201d58a-472b-11ee-9ed6-a86daa000811.xyz','3201d58a-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"99da97a8-472a-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 13:48:57.000','2023-08-30 11:49:13.673','2023-08-30 13:49:13.673'),('3201db96-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/occlusion_989d6f5f-472a-11ee-9ed6-a86daa000811/computedocclusion_2ec21872-472b-11ee-9ed6-a86daa000811/3201db96-472b-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_SESS_989d6f5f-472a-11ee-9ed6-a86daa000811_OCC_2ec21872-472b-11ee-9ed6-a86daa000811_LIFIMO','3201db96-472b-11ee-9ed6-a86daa000811.bin','3201db96-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"99da97a8-472a-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 13:48:58.000','2023-08-30 11:49:13.678','2023-08-30 13:49:13.678'),('320220f7-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/occlusion_989d6f5f-472a-11ee-9ed6-a86daa000811/computedocclusion_2ec21872-472b-11ee-9ed6-a86daa000811/320220f7-472b-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_SESS_989d6f5f-472a-11ee-9ed6-a86daa000811_OCC_2ec21872-472b-11ee-9ed6-a86daa000811_BOPLY','320220f7-472b-11ee-9ed6-a86daa000811.zip','320220f7-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Mandibule\",\"modelMatrix\":\"0.832175,-0.543364,0.110633,0,0.554513,0.815444,-0.16603,0,1.41265e-08,0.199514,0.979895,0,-11.0719,-2.65842,-24.1911,1\",\"occlusionMatrix\":\"-0.995627,-0.0765681,0.0536418,0,0.0281195,0.301949,0.952912,0,-0.0891587,0.950246,-0.298474,0,15.4024,-18.7513,2.30191,1\",\"occlusionType\":2,\"referenceScanId\":\"d2d43a54-472a-11ee-9ed6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:48:59.000','2023-08-30 11:49:13.684','2023-08-30 13:49:13.684'),('325421e6-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/occlusion_989d6f5f-472a-11ee-9ed6-a86daa000811/computedocclusion_2ec21872-472b-11ee-9ed6-a86daa000811/325421e6-472b-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_SESS_989d6f5f-472a-11ee-9ed6-a86daa000811_OCC_2ec21872-472b-11ee-9ed6-a86daa000811_SNAPO','325421e6-472b-11ee-9ed6-a86daa000811.png','325421e6-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Snapshot\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2023-08-30 13:48:59.000','2023-08-30 11:49:13.689','2023-08-30 13:49:13.689'),('3b508740-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/order_989dfa08-472a-11ee-9ed6-a86daa000811/3b508740-472b-11ee-9ed6-a86daa000811.pdf','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_PROST_989dfa08-472a-11ee-9ed6-a86daa000811_FORM','3b508740-472b-11ee-9ed6-a86daa000811.pdf','3b508740-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Commande 1.1.2.1 Couronne\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2023-08-30 13:49:11.000','2023-08-30 11:49:13.695','2023-08-30 13:49:13.695'),('4087e47a-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_de1dfc40-472d-11ee-9ed6-a86daa000811/4087e47a-472e-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_de1dfc40-472d-11ee-9ed6-a86daa000811_MODEL','4087e47a-472e-11ee-9ed6-a86daa000811.zip','de1e1f37-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire scanbody 1.1.5.1.3\",\"modelMatrix\":\"0.944026,0.320194,-0.0793096,0,-0.32987,0.916336,-0.226969,0,3.75193e-11,0.240427,0.970667,0,-17.6703,-7.1465,-15.6783,1\",\"scanBodies\":[{\"position\":\"11.0281,6,0,0,-3.60355,0,6,0,19.5548,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":17}]}','ZIP',2,'SYNCED',0,NULL,'2023-08-30 14:10:52.000','2023-08-30 12:20:09.787','2023-08-30 14:20:09.787'),('408808e2-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_de1dfc40-472d-11ee-9ed6-a86daa000811/408808e2-472e-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_de1dfc40-472d-11ee-9ed6-a86daa000811_SNAPS','408808e2-472e-11ee-9ed6-a86daa000811.png','de23efba-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire scanbody 1.1.5.1.3 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-08-30 14:10:53.000','2023-08-30 12:20:09.793','2023-08-30 14:20:09.793'),('4198bac7-4730-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_f2691117-472f-11ee-9ed6-a86daa000811/occlusion_f26a478b-472f-11ee-9ed6-a86daa000811/scan_23b881d0-4730-11ee-9ed6-a86daa000811/4198bac7-4730-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_f2691117-472f-11ee-9ed6-a86daa000811_SESS_f26a478b-472f-11ee-9ed6-a86daa000811_TOSC_23b881d0-4730-11ee-9ed6-a86daa000811_MODEL','4198bac7-4730-11ee-9ed6-a86daa000811.zip','23b8a3d6-4730-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.6.1.2\",\"modelMatrix\":\"-0.127993,0.983668,-0.126552,0,-0.991775,-0.126947,0.0163322,0,-8.02781e-10,0.127602,0.991826,0,2.67613,-21.4799,-15.175,1\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2023-08-30 14:25:07.959','2023-08-30 12:25:08.358','2023-08-30 14:25:14.538'),('4198dca9-4730-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_f2691117-472f-11ee-9ed6-a86daa000811/occlusion_f26a478b-472f-11ee-9ed6-a86daa000811/scan_23b881d0-4730-11ee-9ed6-a86daa000811/4198dca9-4730-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_f2691117-472f-11ee-9ed6-a86daa000811_SESS_f26a478b-472f-11ee-9ed6-a86daa000811_TOSC_23b881d0-4730-11ee-9ed6-a86daa000811_SNAPS','4198dca9-4730-11ee-9ed6-a86daa000811.png','23be5cc5-4730-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.6.1.2 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-08-30 14:25:07.960','2023-08-30 12:25:08.358','2023-08-30 14:25:16.743'),('4623cf65-4730-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_f2691117-472f-11ee-9ed6-a86daa000811/occlusion_f26a478b-472f-11ee-9ed6-a86daa000811/scan_4623ab82-4730-11ee-9ed6-a86daa000811/4623cf65-4730-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_f2691117-472f-11ee-9ed6-a86daa000811_SESS_f26a478b-472f-11ee-9ed6-a86daa000811_TOSC_4623ab82-4730-11ee-9ed6-a86daa000811_MODEL','4623cf65-4730-11ee-9ed6-a86daa000811.zip','4623cf65-4730-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.6.1.3\",\"modelMatrix\":\"-0.127993,0.983668,-0.126552,0,-0.991775,-0.126947,0.0163322,0,-8.02781e-10,0.127602,0.991826,0,2.67613,-21.4799,-15.175,1\",\"scanBodies\":[{\"position\":\"8.80507,6,0,0,-0.138409,0,6,0,20.428,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":17}]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:25:15.581','2023-08-30 12:27:50.260','2023-08-30 14:27:51.973'),('46295c31-4730-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_f2691117-472f-11ee-9ed6-a86daa000811/occlusion_f26a478b-472f-11ee-9ed6-a86daa000811/scan_4623ab82-4730-11ee-9ed6-a86daa000811/46295c31-4730-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_f2691117-472f-11ee-9ed6-a86daa000811_SESS_f26a478b-472f-11ee-9ed6-a86daa000811_TOSC_4623ab82-4730-11ee-9ed6-a86daa000811_SNAPS','46295c31-4730-11ee-9ed6-a86daa000811.png','46295c31-4730-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.6.1.3 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:25:15.618','2023-08-30 12:27:50.264','2023-08-30 14:27:57.554'),('49878637-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/order_3bd790d4-472d-11ee-9ed6-a86daa000811/49878637-472d-11ee-9ed6-a86daa000811.pdf','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_PROST_3bd790d4-472d-11ee-9ed6-a86daa000811_FORM','49878637-472d-11ee-9ed6-a86daa000811.pdf','49878637-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Commande 1.1.4.1 Inlay\",\"title\":\"Inlay\"}','PDF',0,'SYNCED',0,NULL,'2023-08-30 14:03:54.000','2023-08-30 12:03:56.582','2023-08-30 14:03:56.582'),('4b5700d1-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/order_989dfa08-472a-11ee-9ed6-a86daa000811/4b5700d1-472b-11ee-9ed6-a86daa000811.pdf','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_PROST_989dfa08-472a-11ee-9ed6-a86daa000811_FORM','4b5700d1-472b-11ee-9ed6-a86daa000811.pdf','3b508740-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Commande 1.1.2.1 Couronne\",\"title\":\"Couronne\"}','PDF',1,'SYNCED',0,NULL,'2023-08-30 13:49:38.000','2023-08-30 11:49:39.049','2023-08-30 13:49:39.049'),('592df62e-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/592df62e-472f-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_TOPLY','592df62e-472f-11ee-9ed6-a86daa000811.zip','592df62e-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Maxillaire\",\"modelMatrix\":\"0.992223,-0.120328,0.0318491,0,0.124471,0.959192,-0.253885,0,-2.61808e-09,0.255875,0.96671,0,-18.0987,0.614501,-17.7608,1\",\"occlusionMatrix\":\"-0.963908,-0.117024,-0.238402,0,-0.258621,0.203873,0.944289,0,-0.0633427,0.971985,-0.22691,0,17.9123,-7.4814,10.1992,1\",\"occlusionType\":2,\"referenceScanId\":\"69d717f9-472d-11ee-9ed6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:18:40.000','2023-08-30 12:20:09.797','2023-08-30 14:20:09.797'),('59485f47-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/59485f47-472f-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_LIFIO','59485f47-472f-11ee-9ed6-a86daa000811.xyz','59485f47-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"69d717f9-472d-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 14:18:41.000','2023-08-30 12:20:09.800','2023-08-30 14:20:09.800'),('59486661-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/59486661-472f-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_LIFIMO','59486661-472f-11ee-9ed6-a86daa000811.bin','59486661-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"69d717f9-472d-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 14:18:41.000','2023-08-30 12:20:09.804','2023-08-30 14:20:09.804'),('5948aad0-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/5948aad0-472f-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_BOPLY','5948aad0-472f-11ee-9ed6-a86daa000811.zip','5948aad0-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Mandibule\",\"modelMatrix\":\"0.925939,-0.371123,0.0700297,0,0.377672,0.909882,-0.171692,0,9.95958e-10,0.185425,0.982658,0,-18.4261,7.69244,-25.3101,1\",\"occlusionMatrix\":\"-0.930974,-0.163214,-0.325829,0,0.361993,-0.300421,-0.882604,0,0.0475566,-0.939747,0.338893,0,17.978,24.3835,0.0242329,1\",\"occlusionType\":2,\"referenceScanId\":\"475fb1a4-472e-11ee-9ed6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:18:43.000','2023-08-30 12:20:09.807','2023-08-30 14:20:09.807'),('59636a0c-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/59636a0c-472f-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_LIFIO','59636a0c-472f-11ee-9ed6-a86daa000811.xyz','59636a0c-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Ligne de finition Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"475fb1a4-472e-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 14:18:43.000','2023-08-30 12:20:09.810','2023-08-30 14:20:09.810'),('59637078-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/59637078-472f-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_LIFIMO','59637078-472f-11ee-9ed6-a86daa000811.bin','59637078-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Ligne de finition métadonnées Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"475fb1a4-472e-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 14:18:43.000','2023-08-30 12:20:09.813','2023-08-30 14:20:09.813'),('599fc312-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/599fc312-472f-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_SNAPO','599fc312-472f-11ee-9ed6-a86daa000811.png','599fc312-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Snapshot\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:18:44.000','2023-08-30 12:20:09.817','2023-08-30 14:20:09.817'),('5db2bca1-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/scan_17422636-4729-11ee-9ed6-a86daa000811/5db2bca1-4729-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_TOSC_17422636-4729-11ee-9ed6-a86daa000811_MODEL','5db2bca1-4729-11ee-9ed6-a86daa000811.zip','5db2bca1-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"0.843117,0.520441,-0.135261,0,-0.53773,0.816008,-0.212077,0,-7.53654e-09,0.25154,0.967847,0,-18.9484,-14.764,-16.1295,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:35:52.000','2023-08-30 11:39:19.491','2023-08-30 13:39:19.491'),('5db2e560-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/scan_17422636-4729-11ee-9ed6-a86daa000811/5db2e560-4729-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_TOSC_17422636-4729-11ee-9ed6-a86daa000811_SNAPS','5db2e560-4729-11ee-9ed6-a86daa000811.png','5db2e560-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 13:35:53.000','2023-08-30 11:39:19.494','2023-08-30 13:39:19.494'),('5fbb145c-472c-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/scan_416b51d9-472c-11ee-9ed6-a86daa000811/5fbb145c-472c-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_TOSC_416b51d9-472c-11ee-9ed6-a86daa000811_MODEL','5fbb145c-472c-11ee-9ed6-a86daa000811.zip','5fbb145c-472c-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.4.1.1\",\"modelMatrix\":\"0.954262,0.286579,-0.0851877,0,-0.298972,0.914705,-0.271902,0,1.11896e-08,0.284935,0.958547,0,-19.5243,-8.36947,-15.6125,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:03:30.000','2023-08-30 12:03:56.586','2023-08-30 14:03:56.586'),('5fbb2bf0-472c-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/scan_416b51d9-472c-11ee-9ed6-a86daa000811/5fbb2bf0-472c-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_TOSC_416b51d9-472c-11ee-9ed6-a86daa000811_SNAPS','5fbb2bf0-472c-11ee-9ed6-a86daa000811.png','5fbb2bf0-472c-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.4.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:03:31.000','2023-08-30 12:03:56.589','2023-08-30 14:03:56.589'),('60d87a10-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/scan_17422636-4729-11ee-9ed6-a86daa000811/60d87a10-4729-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_TOSC_17422636-4729-11ee-9ed6-a86daa000811_LIFI','60d87a10-4729-11ee-9ed6-a86daa000811.xyz','60d87a10-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 13:35:55.000','2023-08-30 11:39:19.498','2023-08-30 13:39:19.498'),('60d87eeb-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/scan_17422636-4729-11ee-9ed6-a86daa000811/60d87eeb-4729-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_TOSC_17422636-4729-11ee-9ed6-a86daa000811_LIFIM','60d87eeb-4729-11ee-9ed6-a86daa000811.bin','60d87eeb-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 13:35:56.000','2023-08-30 11:39:19.501','2023-08-30 13:39:19.501'),('692d6a54-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/692d6a54-472f-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_BOPRE','692d6a54-472f-11ee-9ed6-a86daa000811.zip','692d6a54-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Mandibule pre-scan\",\"modelMatrix\":\"0.978453,-0.199869,0.0517872,0,0.206469,0.947175,-0.245419,0,-1.6786e-09,0.250823,0.968033,0,-20.6725,2.68964,-24.7995,1\",\"occlusionMatrix\":\"-0.930613,-0.163289,-0.326826,0,0.362482,-0.290923,-0.885582,0,0.050915,-0.942716,0.330049,0,17.862,24.4137,0.260355,1\",\"occlusionType\":2,\"referenceScanId\":\"79950e43-472e-11ee-9ed6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:19:08.000','2023-08-30 12:20:09.821','2023-08-30 14:20:09.821'),('6949bbb1-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/6949bbb1-472f-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_LIFIO','6949bbb1-472f-11ee-9ed6-a86daa000811.xyz','6949bbb1-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Ligne de finition Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"79950e43-472e-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 14:19:08.000','2023-08-30 12:20:09.824','2023-08-30 14:20:09.824'),('6949c28f-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/6949c28f-472f-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_LIFIMO','6949c28f-472f-11ee-9ed6-a86daa000811.bin','6949c28f-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Ligne de finition métadonnées Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"79950e43-472e-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 14:19:09.000','2023-08-30 12:20:09.828','2023-08-30 14:20:09.828'),('6b79736c-472c-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/scan_416b51d9-472c-11ee-9ed6-a86daa000811/6b79736c-472c-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_TOSC_416b51d9-472c-11ee-9ed6-a86daa000811_LIFI','6b79736c-472c-11ee-9ed6-a86daa000811.xyz','6b79736c-472c-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.4.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 13:57:40.000','2023-08-30 12:03:56.593','2023-08-30 14:03:56.593'),('6b797ba3-472c-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/scan_416b51d9-472c-11ee-9ed6-a86daa000811/6b797ba3-472c-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_TOSC_416b51d9-472c-11ee-9ed6-a86daa000811_LIFIM','6b797ba3-472c-11ee-9ed6-a86daa000811.bin','6b797ba3-472c-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.4.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 13:57:40.000','2023-08-30 12:03:56.597','2023-08-30 14:03:56.597'),('6bf64fc9-4730-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_f2691117-472f-11ee-9ed6-a86daa000811/occlusion_f26a478b-472f-11ee-9ed6-a86daa000811/scan_4623ab82-4730-11ee-9ed6-a86daa000811/6bf64fc9-4730-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_f2691117-472f-11ee-9ed6-a86daa000811_SESS_f26a478b-472f-11ee-9ed6-a86daa000811_TOSC_4623ab82-4730-11ee-9ed6-a86daa000811_MODEL','6bf64fc9-4730-11ee-9ed6-a86daa000811.zip','4623cf65-4730-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire scanbody 1.1.6.1.3\",\"modelMatrix\":\"-0.127993,0.983668,-0.126552,0,-0.991775,-0.126947,0.0163322,0,-8.02781e-10,0.127602,0.991826,0,2.67613,-21.4799,-15.175,1\",\"scanBodies\":[{\"position\":\"8.80507,6,0,0,-0.138409,0,6,0,20.428,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":17}]}','ZIP',1,'SYNCED',0,NULL,'2023-08-30 14:26:19.037','2023-08-30 12:27:50.263','2023-08-30 14:27:53.516'),('6d229cf2-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/6d229cf2-472f-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_BOSB','6d229cf2-472f-11ee-9ed6-a86daa000811.zip','6d229cf2-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Mandibule scanbody\",\"modelMatrix\":\"0.938254,-0.336666,0.0795923,0,0.345946,0.913085,-0.215865,0,-1.45188e-09,0.230071,0.973174,0,-18.1829,5.52246,-25.4427,1\",\"occlusionMatrix\":\"-0.930759,-0.162628,-0.326742,0,0.362537,-0.297941,-0.883223,0,0.0476757,-0.940639,0.336396,0,18.0182,24.3809,0.122819,1\",\"occlusionType\":2,\"referenceScanId\":\"a5772713-472e-11ee-9ed6-a86daa000811\",\"scanBodies\":[{\"position\":\"12.9666,6,0,0,-3.66681,0,6,0,28.453,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":47}]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:19:14.000','2023-08-30 12:20:09.831','2023-08-30 14:20:09.831'),('6eac3a0a-472c-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/scan_416b51d9-472c-11ee-9ed6-a86daa000811/6eac3a0a-472c-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_TOSC_416b51d9-472c-11ee-9ed6-a86daa000811_LIFI','6eac3a0a-472c-11ee-9ed6-a86daa000811.xyz','6eac3a0a-472c-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.4.1.1 Ligne de finition manuelle\",\"title\":\"manuelle\",\"toothNumber\":1,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 13:57:45.000','2023-08-30 12:03:56.601','2023-08-30 14:03:56.601'),('6eac3de7-472c-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/scan_416b51d9-472c-11ee-9ed6-a86daa000811/6eac3de7-472c-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_TOSC_416b51d9-472c-11ee-9ed6-a86daa000811_LIFIM','6eac3de7-472c-11ee-9ed6-a86daa000811.bin','6eac3de7-472c-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.4.1.1 Ligne de finition métadonnées manuelle\",\"title\":\"manuelle\",\"toothNumber\":1,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 13:57:45.000','2023-08-30 12:03:56.605','2023-08-30 14:03:56.605'),('6f2ca6a1-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_475fb1a4-472e-11ee-9ed6-a86daa000811/6f2ca6a1-472e-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_475fb1a4-472e-11ee-9ed6-a86daa000811_MODEL','6f2ca6a1-472e-11ee-9ed6-a86daa000811.zip','6f2ca6a1-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.1\",\"modelMatrix\":\"0.925939,-0.371123,0.0700297,0,0.377672,0.909882,-0.171692,0,9.95958e-10,0.185425,0.982658,0,-18.4261,7.69244,-25.3101,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:12:25.000','2023-08-30 12:20:09.835','2023-08-30 14:20:09.835'),('6f2ccdcb-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_475fb1a4-472e-11ee-9ed6-a86daa000811/6f2ccdcb-472e-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_475fb1a4-472e-11ee-9ed6-a86daa000811_SNAPS','6f2ccdcb-472e-11ee-9ed6-a86daa000811.png','6f2ccdcb-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:12:26.000','2023-08-30 12:20:09.838','2023-08-30 14:20:09.838'),('72fd1bac-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_475fb1a4-472e-11ee-9ed6-a86daa000811/72fd1bac-472e-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_475fb1a4-472e-11ee-9ed6-a86daa000811_LIFI','72fd1bac-472e-11ee-9ed6-a86daa000811.xyz','72fd1bac-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 14:12:28.000','2023-08-30 12:20:09.841','2023-08-30 14:20:09.841'),('72fd20d6-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_475fb1a4-472e-11ee-9ed6-a86daa000811/72fd20d6-472e-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_475fb1a4-472e-11ee-9ed6-a86daa000811_LIFIM','72fd20d6-472e-11ee-9ed6-a86daa000811.bin','72fd20d6-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 14:12:28.000','2023-08-30 12:20:09.844','2023-08-30 14:20:09.844'),('75050c84-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_475fb1a4-472e-11ee-9ed6-a86daa000811/75050c84-472e-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_475fb1a4-472e-11ee-9ed6-a86daa000811_SCREENS','75050c84-472e-11ee-9ed6-a86daa000811.png','75050c84-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:12:29.000','2023-08-30 12:20:09.847','2023-08-30 14:20:09.847'),('7518967b-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/7518967b-472f-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_TOPRE','7518967b-472f-11ee-9ed6-a86daa000811.zip','7518967b-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Maxillaire pre-scan\",\"modelMatrix\":\"0.918025,0.383148,-0.102119,0,-0.396523,0.887059,-0.236424,0,1.03241e-09,0.257535,0.966269,0,-18.3884,-9.04183,-15.2287,1\",\"occlusionMatrix\":\"-0.962977,-0.12184,-0.239758,0,-0.26111,0.204691,0.94343,0,-0.0673133,0.971218,-0.229059,0,17.898,-7.24693,10.2334,1\",\"occlusionType\":2,\"referenceScanId\":\"b04fc180-472d-11ee-9ed6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:19:26.000','2023-08-30 12:20:09.850','2023-08-30 14:20:09.850'),('752f790c-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/752f790c-472f-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_LIFIO','752f790c-472f-11ee-9ed6-a86daa000811.xyz','752f790c-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"b04fc180-472d-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 14:19:27.000','2023-08-30 12:20:09.853','2023-08-30 14:20:09.853'),('752f81ce-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/752f81ce-472f-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_LIFIMO','752f81ce-472f-11ee-9ed6-a86daa000811.bin','752f81ce-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"b04fc180-472d-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 14:19:27.000','2023-08-30 12:20:09.856','2023-08-30 14:20:09.856'),('799535ec-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_79950e43-472e-11ee-9ed6-a86daa000811/799535ec-472e-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_79950e43-472e-11ee-9ed6-a86daa000811_MODEL','799535ec-472e-11ee-9ed6-a86daa000811.zip','799535ec-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.2\",\"modelMatrix\":\"0.925939,-0.371123,0.0700297,0,0.377672,0.909882,-0.171692,0,9.95958e-10,0.185425,0.982658,0,-18.4261,7.69244,-25.3101,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:12:30.000','2023-08-30 12:20:09.878','2023-08-30 14:20:09.878'),('799c6bd2-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_79950e43-472e-11ee-9ed6-a86daa000811/799c6bd2-472e-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_79950e43-472e-11ee-9ed6-a86daa000811_SNAPS','799c6bd2-472e-11ee-9ed6-a86daa000811.png','799c6bd2-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:12:30.000','2023-08-30 12:20:09.886','2023-08-30 14:20:09.886'),('799c7b69-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_79950e43-472e-11ee-9ed6-a86daa000811/799c7b69-472e-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_79950e43-472e-11ee-9ed6-a86daa000811_LIFI','799c7b69-472e-11ee-9ed6-a86daa000811.xyz','799c7b69-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.2 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2023-08-30 14:12:38.580','2023-08-30 14:12:22.943','2023-08-30 12:12:38.580','2023-08-30 14:13:26.826'),('799c865f-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_79950e43-472e-11ee-9ed6-a86daa000811/799c865f-472e-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_79950e43-472e-11ee-9ed6-a86daa000811_LIFIM','799c865f-472e-11ee-9ed6-a86daa000811.bin','799c865f-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.2 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2023-08-30 14:12:38.580','2023-08-30 14:12:22.943','2023-08-30 12:12:38.581','2023-08-30 14:13:26.826'),('7afad9a7-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/computedocclusion_341335b3-472f-11ee-9ed6-a86daa000811/7afad9a7-472f-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_OCC_341335b3-472f-11ee-9ed6-a86daa000811_TOSB','7afad9a7-472f-11ee-9ed6-a86daa000811.zip','7afad9a7-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Maxillaire scanbody\",\"modelMatrix\":\"0.944026,0.320194,-0.0793096,0,-0.32987,0.916336,-0.226969,0,3.75193e-11,0.240427,0.970667,0,-17.6703,-7.1465,-15.6783,1\",\"occlusionMatrix\":\"-0.960303,-0.141724,-0.239557,0,-0.26487,0.196793,0.944061,0,-0.088098,0.970117,-0.22665,0,18.2113,-6.93616,10.2055,1\",\"occlusionType\":2,\"referenceScanId\":\"de1dfc40-472d-11ee-9ed6-a86daa000811\",\"scanBodies\":[{\"position\":\"11.0281,6,0,0,-3.60355,0,6,0,19.5548,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":17}]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:19:38.000','2023-08-30 12:20:09.859','2023-08-30 14:20:09.859'),('805c9473-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_79950e43-472e-11ee-9ed6-a86daa000811/805c9473-472e-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_79950e43-472e-11ee-9ed6-a86daa000811_MODEL','805c9473-472e-11ee-9ed6-a86daa000811.zip','799535ec-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.2\",\"modelMatrix\":\"0.925939,-0.371123,0.0700297,0,0.377672,0.909882,-0.171692,0,9.95958e-10,0.185425,0.982658,0,-18.4261,7.69244,-25.3101,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2023-08-30 14:12:34.268','2023-08-30 12:12:34.335','2023-08-30 14:12:34.347'),('82922060-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/scan_634e5f54-4729-11ee-9ed6-a86daa000811/82922060-4729-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_BOSC_634e5f54-4729-11ee-9ed6-a86daa000811_MODEL','82922060-4729-11ee-9ed6-a86daa000811.zip','82922060-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.1.1.1\",\"modelMatrix\":\"0.819964,0.567379,-0.0757612,0,-0.572415,0.812751,-0.108525,0,3.76289e-10,0.132354,0.991203,0,-14.285,-14.0309,-15.3544,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:36:54.000','2023-08-30 11:39:19.504','2023-08-30 13:39:19.504'),('829236d7-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/scan_634e5f54-4729-11ee-9ed6-a86daa000811/829236d7-4729-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_BOSC_634e5f54-4729-11ee-9ed6-a86daa000811_SNAPS','829236d7-4729-11ee-9ed6-a86daa000811.png','829236d7-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 13:36:54.000','2023-08-30 11:39:19.507','2023-08-30 13:39:19.507'),('88c6076b-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/scan_634e5f54-4729-11ee-9ed6-a86daa000811/88c6076b-4729-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_BOSC_634e5f54-4729-11ee-9ed6-a86daa000811_LIFI','88c6076b-4729-11ee-9ed6-a86daa000811.xyz','88c6076b-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 13:37:01.000','2023-08-30 11:39:19.510','2023-08-30 13:39:19.510'),('88c617fa-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/scan_634e5f54-4729-11ee-9ed6-a86daa000811/88c617fa-4729-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_BOSC_634e5f54-4729-11ee-9ed6-a86daa000811_LIFIM','88c617fa-4729-11ee-9ed6-a86daa000811.bin','88c617fa-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 13:37:02.000','2023-08-30 11:39:19.513','2023-08-30 13:39:19.513'),('8a8756dc-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/scan_634e5f54-4729-11ee-9ed6-a86daa000811/8a8756dc-4729-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_BOSC_634e5f54-4729-11ee-9ed6-a86daa000811_SCREENS','8a8756dc-4729-11ee-9ed6-a86daa000811.png','8a8756dc-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 13:37:04.000','2023-08-30 11:39:19.516','2023-08-30 13:39:19.516'),('8d004c4c-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/order_6832b9c0-472d-11ee-9ed6-a86daa000811/8d004c4c-472f-11ee-9ed6-a86daa000811.pdf','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_PROST_6832b9c0-472d-11ee-9ed6-a86daa000811_FORM','8d004c4c-472f-11ee-9ed6-a86daa000811.pdf','8d004c4c-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Commande 1.1.5.1 Couronne sur implant\",\"title\":\"Couronne sur implant\"}','PDF',0,'SYNCED',0,NULL,'2023-08-30 14:20:07.000','2023-08-30 12:20:09.862','2023-08-30 14:20:09.862'),('8d6c0c7f-472f-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/order_6832b9c0-472d-11ee-9ed6-a86daa000811/8d6c0c7f-472f-11ee-9ed6-a86daa000811.pdf','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_PROST_6832b9c0-472d-11ee-9ed6-a86daa000811_FORM','8d6c0c7f-472f-11ee-9ed6-a86daa000811.pdf','8d6c0c7f-472f-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Commande 1.1.5.1 Couronne sur implant\",\"title\":\"Couronne sur implant\"}','PDF',0,'SYNCED',0,NULL,'2023-08-30 14:20:07.000','2023-08-30 12:20:09.866','2023-08-30 14:20:09.866'),('8f206867-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_61ce0aa4-472b-11ee-9ed6-a86daa000811/occlusion_61cf451e-472b-11ee-9ed6-a86daa000811/scan_633e5fa3-472b-11ee-9ed6-a86daa000811/8f206867-472b-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_61ce0aa4-472b-11ee-9ed6-a86daa000811_SESS_61cf451e-472b-11ee-9ed6-a86daa000811_TOSC_633e5fa3-472b-11ee-9ed6-a86daa000811_MODEL','8f206867-472b-11ee-9ed6-a86daa000811.zip','8f206867-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.3.1.1\",\"modelMatrix\":\"0.984036,0.173141,-0.0411727,0,-0.177969,0.95734,-0.227654,0,-1.92446e-09,0.231347,0.972871,0,-11.2721,-8.20667,-22.2497,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:51:33.000','2023-08-30 11:55:46.242','2023-08-30 13:55:46.242'),('8f2080cc-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_61ce0aa4-472b-11ee-9ed6-a86daa000811/occlusion_61cf451e-472b-11ee-9ed6-a86daa000811/scan_633e5fa3-472b-11ee-9ed6-a86daa000811/8f2080cc-472b-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_61ce0aa4-472b-11ee-9ed6-a86daa000811_SESS_61cf451e-472b-11ee-9ed6-a86daa000811_TOSC_633e5fa3-472b-11ee-9ed6-a86daa000811_SNAPS','8f2080cc-472b-11ee-9ed6-a86daa000811.png','8f2080cc-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 13:51:33.000','2023-08-30 11:55:46.247','2023-08-30 13:55:46.247'),('8f294605-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_69d717f9-472d-11ee-9ed6-a86daa000811/8f294605-472d-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_69d717f9-472d-11ee-9ed6-a86daa000811_MODEL','8f294605-472d-11ee-9ed6-a86daa000811.zip','8f294605-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.1\",\"modelMatrix\":\"0.992223,-0.120328,0.0318491,0,0.124471,0.959192,-0.253885,0,-2.61808e-09,0.255875,0.96671,0,-18.0987,0.614501,-17.7608,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:05:53.000','2023-08-30 12:20:09.870','2023-08-30 14:20:09.870'),('8f295e9f-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_69d717f9-472d-11ee-9ed6-a86daa000811/8f295e9f-472d-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_69d717f9-472d-11ee-9ed6-a86daa000811_SNAPS','8f295e9f-472d-11ee-9ed6-a86daa000811.png','8f295e9f-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:05:53.000','2023-08-30 12:20:09.874','2023-08-30 14:20:09.874'),('97d284cf-472c-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/scan_78ac12f2-472c-11ee-9ed6-a86daa000811/97d284cf-472c-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_BOSC_78ac12f2-472c-11ee-9ed6-a86daa000811_MODEL','97d284cf-472c-11ee-9ed6-a86daa000811.zip','97d284cf-472c-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.4.1.1\",\"modelMatrix\":\"-0.282978,0.958216,-0.041777,0,-0.959126,-0.28271,0.0123258,0,7.68068e-10,0.0435574,0.999051,0,3.13092,-14.5292,-19.4721,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:03:33.000','2023-08-30 12:03:56.608','2023-08-30 14:03:56.608'),('97d29ba4-472c-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_3fe9ba1b-472c-11ee-9ed6-a86daa000811/occlusion_3fea1de6-472c-11ee-9ed6-a86daa000811/scan_78ac12f2-472c-11ee-9ed6-a86daa000811/97d29ba4-472c-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_3fe9ba1b-472c-11ee-9ed6-a86daa000811_SESS_3fea1de6-472c-11ee-9ed6-a86daa000811_BOSC_78ac12f2-472c-11ee-9ed6-a86daa000811_SNAPS','97d29ba4-472c-11ee-9ed6-a86daa000811.png','97d29ba4-472c-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.4.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:03:34.000','2023-08-30 12:03:56.611','2023-08-30 14:03:56.611'),('9a8afba7-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_61ce0aa4-472b-11ee-9ed6-a86daa000811/occlusion_61cf451e-472b-11ee-9ed6-a86daa000811/scan_633e5fa3-472b-11ee-9ed6-a86daa000811/9a8afba7-472b-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_61ce0aa4-472b-11ee-9ed6-a86daa000811_SESS_61cf451e-472b-11ee-9ed6-a86daa000811_TOSC_633e5fa3-472b-11ee-9ed6-a86daa000811_LIFI','9a8afba7-472b-11ee-9ed6-a86daa000811.xyz','9a8afba7-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.3.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 13:51:50.000','2023-08-30 11:55:46.252','2023-08-30 13:55:46.252'),('9a8b009c-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_61ce0aa4-472b-11ee-9ed6-a86daa000811/occlusion_61cf451e-472b-11ee-9ed6-a86daa000811/scan_633e5fa3-472b-11ee-9ed6-a86daa000811/9a8b009c-472b-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_61ce0aa4-472b-11ee-9ed6-a86daa000811_SESS_61cf451e-472b-11ee-9ed6-a86daa000811_TOSC_633e5fa3-472b-11ee-9ed6-a86daa000811_LIFIM','9a8b009c-472b-11ee-9ed6-a86daa000811.bin','9a8b009c-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.3.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 13:51:51.000','2023-08-30 11:55:46.258','2023-08-30 13:55:46.258'),('9f67da47-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_79950e43-472e-11ee-9ed6-a86daa000811/9f67da47-472e-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_79950e43-472e-11ee-9ed6-a86daa000811_MODEL','9f67da47-472e-11ee-9ed6-a86daa000811.zip','799535ec-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.2\",\"modelMatrix\":\"0.978453,-0.199869,0.0517872,0,0.206469,0.947175,-0.245419,0,-1.6786e-09,0.250823,0.968033,0,-20.6725,2.68964,-24.7995,1\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2023-08-30 14:13:30.000','2023-08-30 12:20:09.882','2023-08-30 14:20:09.882'),('9f67fba8-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_79950e43-472e-11ee-9ed6-a86daa000811/9f67fba8-472e-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_79950e43-472e-11ee-9ed6-a86daa000811_SNAPS','9f67fba8-472e-11ee-9ed6-a86daa000811.png','799c6bd2-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.2 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-08-30 14:13:31.000','2023-08-30 12:20:09.889','2023-08-30 14:20:09.889'),('a1eeb013-4730-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_f2691117-472f-11ee-9ed6-a86daa000811/occlusion_f26a478b-472f-11ee-9ed6-a86daa000811/scan_4623ab82-4730-11ee-9ed6-a86daa000811/a1eeb013-4730-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_f2691117-472f-11ee-9ed6-a86daa000811_SESS_f26a478b-472f-11ee-9ed6-a86daa000811_TOSC_4623ab82-4730-11ee-9ed6-a86daa000811_MODEL','a1eeb013-4730-11ee-9ed6-a86daa000811.zip','4623cf65-4730-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire scanbody 1.1.6.1.3\",\"modelMatrix\":\"-0.143196,0.988515,-0.0483011,0,-0.989694,-0.143025,0.00698853,0,-3.25457e-10,0.0488041,0.998808,0,2.81256,-18.7488,-16.743,1\",\"scanBodies\":[{\"position\":\"8.80507,6,0,0,-0.138409,0,6,0,20.428,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":17}]}','ZIP',2,'SYNCED',0,NULL,'2023-08-30 14:27:49.584','2023-08-30 12:27:50.263','2023-08-30 14:27:55.505'),('a1eed0d0-4730-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_f2691117-472f-11ee-9ed6-a86daa000811/occlusion_f26a478b-472f-11ee-9ed6-a86daa000811/scan_4623ab82-4730-11ee-9ed6-a86daa000811/a1eed0d0-4730-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_f2691117-472f-11ee-9ed6-a86daa000811_SESS_f26a478b-472f-11ee-9ed6-a86daa000811_TOSC_4623ab82-4730-11ee-9ed6-a86daa000811_SNAPS','a1eed0d0-4730-11ee-9ed6-a86daa000811.png','46295c31-4730-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire scanbody 1.1.6.1.3 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-08-30 14:27:49.584','2023-08-30 12:27:50.264','2023-08-30 14:27:57.718'),('a371ae07-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_79950e43-472e-11ee-9ed6-a86daa000811/a371ae07-472e-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_79950e43-472e-11ee-9ed6-a86daa000811_LIFI','a371ae07-472e-11ee-9ed6-a86daa000811.xyz','a371ae07-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.2 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 14:13:33.126','2023-08-30 12:13:33.131','2023-08-30 14:13:33.138'),('a371b40d-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_79950e43-472e-11ee-9ed6-a86daa000811/a371b40d-472e-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_79950e43-472e-11ee-9ed6-a86daa000811_LIFIM','a371b40d-472e-11ee-9ed6-a86daa000811.bin','a371b40d-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.2 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 14:13:34.000','2023-08-30 12:20:09.893','2023-08-30 14:20:09.893'),('a577454a-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_a5772713-472e-11ee-9ed6-a86daa000811/a577454a-472e-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_a5772713-472e-11ee-9ed6-a86daa000811_MODEL','a577454a-472e-11ee-9ed6-a86daa000811.zip','a577454a-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.3\",\"modelMatrix\":\"0.978453,-0.199869,0.0517872,0,0.206469,0.947175,-0.245419,0,-1.6786e-09,0.250823,0.968033,0,-20.6725,2.68964,-24.7995,1\",\"scanBodies\":[{\"position\":\"12.9666,6,0,0,-3.66681,0,6,0,28.453,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":47}]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:13:36.000','2023-08-30 12:20:09.762','2023-08-30 14:20:09.762'),('a57e163c-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_a5772713-472e-11ee-9ed6-a86daa000811/a57e163c-472e-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_a5772713-472e-11ee-9ed6-a86daa000811_SNAPS','a57e163c-472e-11ee-9ed6-a86daa000811.png','a57e163c-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.3 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:13:41.000','2023-08-30 12:20:09.769','2023-08-30 14:20:09.769'),('a57e274f-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_a5772713-472e-11ee-9ed6-a86daa000811/a57e274f-472e-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_a5772713-472e-11ee-9ed6-a86daa000811_LIFI','a57e274f-472e-11ee-9ed6-a86daa000811.xyz','a57e274f-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.3 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2023-08-30 14:14:45.636','2023-08-30 14:13:36.564','2023-08-30 12:14:45.637','2023-08-30 14:16:15.744'),('a57e33b5-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_a5772713-472e-11ee-9ed6-a86daa000811/a57e33b5-472e-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_a5772713-472e-11ee-9ed6-a86daa000811_LIFIM','a57e33b5-472e-11ee-9ed6-a86daa000811.bin','a57e33b5-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.3 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2023-08-30 14:14:45.636','2023-08-30 14:13:36.564','2023-08-30 12:14:45.638','2023-08-30 14:16:15.744'),('ab635311-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/scan_8d8049e9-4729-11ee-9ed6-a86daa000811/ab635311-4729-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_LESC_8d8049e9-4729-11ee-9ed6-a86daa000811_MODEL','ab635311-4729-11ee-9ed6-a86daa000811.zip','ab635311-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mordu gauche 1.1.1.1.1\",\"modelMatrix\":\"-0.99976,0.001071,0.0212417,0,0.00284616,-0.980538,0.196389,0,0.0217211,0.196328,0.980296,0,7.76229,-11.5685,-18.9144,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:38:04.000','2023-08-30 11:39:19.520','2023-08-30 13:39:19.520'),('ab63684c-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/scan_8d8049e9-4729-11ee-9ed6-a86daa000811/ab63684c-4729-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_LESC_8d8049e9-4729-11ee-9ed6-a86daa000811_SNAPS','ab63684c-4729-11ee-9ed6-a86daa000811.png','ab63684c-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mordu gauche 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 13:38:05.000','2023-08-30 11:39:19.523','2023-08-30 13:39:19.523'),('aec5de2b-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_69d717f9-472d-11ee-9ed6-a86daa000811/aec5de2b-472d-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_69d717f9-472d-11ee-9ed6-a86daa000811_LIFI','aec5de2b-472d-11ee-9ed6-a86daa000811.xyz','aec5de2b-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 14:06:43.000','2023-08-30 12:20:09.896','2023-08-30 14:20:09.896'),('aec5e1df-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_69d717f9-472d-11ee-9ed6-a86daa000811/aec5e1df-472d-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_69d717f9-472d-11ee-9ed6-a86daa000811_LIFIM','aec5e1df-472d-11ee-9ed6-a86daa000811.bin','aec5e1df-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 14:06:43.000','2023-08-30 12:20:09.899','2023-08-30 14:20:09.899'),('b04fe5ac-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_b04fc180-472d-11ee-9ed6-a86daa000811/b04fe5ac-472d-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_b04fc180-472d-11ee-9ed6-a86daa000811_MODEL','b04fe5ac-472d-11ee-9ed6-a86daa000811.zip','b04fe5ac-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.2\",\"modelMatrix\":\"0.992223,-0.120328,0.0318491,0,0.124471,0.959192,-0.253885,0,-2.61808e-09,0.255875,0.96671,0,-18.0987,0.614501,-17.7608,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:06:45.219','2023-08-30 12:06:46.016','2023-08-30 14:06:46.024'),('b0558353-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_b04fc180-472d-11ee-9ed6-a86daa000811/b0558353-472d-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_b04fc180-472d-11ee-9ed6-a86daa000811_SNAPS','b0558353-472d-11ee-9ed6-a86daa000811.png','b0558353-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:06:47.000','2023-08-30 12:20:09.908','2023-08-30 14:20:09.908'),('b0559281-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_b04fc180-472d-11ee-9ed6-a86daa000811/b0559281-472d-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_b04fc180-472d-11ee-9ed6-a86daa000811_LIFI','b0559281-472d-11ee-9ed6-a86daa000811.xyz','b0559281-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.2 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2023-08-30 14:06:54.361','2023-08-30 14:06:45.256','2023-08-30 12:06:54.362','2023-08-30 14:07:43.929'),('b0559ee3-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_b04fc180-472d-11ee-9ed6-a86daa000811/b0559ee3-472d-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_b04fc180-472d-11ee-9ed6-a86daa000811_LIFIM','b0559ee3-472d-11ee-9ed6-a86daa000811.bin','b0559ee3-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.2 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2023-08-30 14:06:54.361','2023-08-30 14:06:45.256','2023-08-30 12:06:54.362','2023-08-30 14:07:43.929'),('b41f786e-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_61ce0aa4-472b-11ee-9ed6-a86daa000811/occlusion_61cf451e-472b-11ee-9ed6-a86daa000811/scan_9c3fb326-472b-11ee-9ed6-a86daa000811/b41f786e-472b-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_61ce0aa4-472b-11ee-9ed6-a86daa000811_SESS_61cf451e-472b-11ee-9ed6-a86daa000811_BOSC_9c3fb326-472b-11ee-9ed6-a86daa000811_MODEL','b41f786e-472b-11ee-9ed6-a86daa000811.zip','b41f786e-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.3.1.1\",\"modelMatrix\":\"-0.9381,0.343986,-0.0405152,0,-0.346364,-0.93166,0.109732,0,-4.65733e-09,0.116973,0.993135,0,19.5276,-4.72911,-18.5891,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:52:36.000','2023-08-30 11:55:46.267','2023-08-30 13:55:46.267'),('b41f8ee1-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_61ce0aa4-472b-11ee-9ed6-a86daa000811/occlusion_61cf451e-472b-11ee-9ed6-a86daa000811/scan_9c3fb326-472b-11ee-9ed6-a86daa000811/b41f8ee1-472b-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_61ce0aa4-472b-11ee-9ed6-a86daa000811_SESS_61cf451e-472b-11ee-9ed6-a86daa000811_BOSC_9c3fb326-472b-11ee-9ed6-a86daa000811_SNAPS','b41f8ee1-472b-11ee-9ed6-a86daa000811.png','b41f8ee1-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 13:52:36.000','2023-08-30 11:55:46.278','2023-08-30 13:55:46.278'),('b4a95ee0-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_b04fc180-472d-11ee-9ed6-a86daa000811/b4a95ee0-472d-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_b04fc180-472d-11ee-9ed6-a86daa000811_MODEL','b4a95ee0-472d-11ee-9ed6-a86daa000811.zip','b04fe5ac-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.2\",\"modelMatrix\":\"0.992223,-0.120328,0.0318491,0,0.124471,0.959192,-0.253885,0,-2.61808e-09,0.255875,0.96671,0,-18.0987,0.614501,-17.7608,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2023-08-30 14:06:52.516','2023-08-30 12:06:52.588','2023-08-30 14:06:52.603'),('c6d260dd-472a-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/occlusion_989d6f5f-472a-11ee-9ed6-a86daa000811/scan_99da97a8-472a-11ee-9ed6-a86daa000811/c6d260dd-472a-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_SESS_989d6f5f-472a-11ee-9ed6-a86daa000811_TOSC_99da97a8-472a-11ee-9ed6-a86daa000811_MODEL','c6d260dd-472a-11ee-9ed6-a86daa000811.zip','c6d260dd-472a-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.1\",\"modelMatrix\":\"0.943336,0.328267,-0.048553,0,-0.331838,0.933184,-0.138025,0,1.571e-09,0.146315,0.989238,0,-17.8129,-5.36634,-22.0972,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:45:57.000','2023-08-30 11:49:13.700','2023-08-30 13:49:13.700'),('c6d27881-472a-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/occlusion_989d6f5f-472a-11ee-9ed6-a86daa000811/scan_99da97a8-472a-11ee-9ed6-a86daa000811/c6d27881-472a-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_SESS_989d6f5f-472a-11ee-9ed6-a86daa000811_TOSC_99da97a8-472a-11ee-9ed6-a86daa000811_SNAPS','c6d27881-472a-11ee-9ed6-a86daa000811.png','c6d27881-472a-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 13:45:57.000','2023-08-30 11:49:13.705','2023-08-30 13:49:13.705'),('ca3e67f9-4730-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_f2691117-472f-11ee-9ed6-a86daa000811/occlusion_f26a478b-472f-11ee-9ed6-a86daa000811/scan_ae4b5181-4730-11ee-9ed6-a86daa000811/ca3e67f9-4730-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_f2691117-472f-11ee-9ed6-a86daa000811_SESS_f26a478b-472f-11ee-9ed6-a86daa000811_BOSC_ae4b5181-4730-11ee-9ed6-a86daa000811_MODEL','ca3e67f9-4730-11ee-9ed6-a86daa000811.zip','ca3e67f9-4730-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule pre-scan 1.1.6.1.1\",\"modelMatrix\":\"0.981076,-0.192305,0.0225482,0,0.193622,0.974401,-0.114251,0,2.66754e-10,0.116455,0.993196,0,-18.1125,4.23559,-17.1279,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:28:57.215','2023-08-30 12:28:57.469','2023-08-30 14:28:59.363'),('ca3e8070-4730-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_f2691117-472f-11ee-9ed6-a86daa000811/occlusion_f26a478b-472f-11ee-9ed6-a86daa000811/scan_ae4b5181-4730-11ee-9ed6-a86daa000811/ca3e8070-4730-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_f2691117-472f-11ee-9ed6-a86daa000811_SESS_f26a478b-472f-11ee-9ed6-a86daa000811_BOSC_ae4b5181-4730-11ee-9ed6-a86daa000811_SNAPS','ca3e8070-4730-11ee-9ed6-a86daa000811.png','ca3e8070-4730-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule pre-scan 1.1.6.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:28:57.216','2023-08-30 12:28:57.470','2023-08-30 14:29:01.727'),('cc6d19b0-472e-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_a5772713-472e-11ee-9ed6-a86daa000811/cc6d19b0-472e-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_BOSC_a5772713-472e-11ee-9ed6-a86daa000811_MODEL','cc6d19b0-472e-11ee-9ed6-a86daa000811.zip','a577454a-472e-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule scanbody 1.1.5.1.3\",\"modelMatrix\":\"0.978453,-0.199869,0.0517872,0,0.206469,0.947175,-0.245419,0,-1.6786e-09,0.250823,0.968033,0,-20.6725,2.68964,-24.7995,1\",\"scanBodies\":[{\"position\":\"12.9666,6,0,0,-3.66681,0,6,0,28.453,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":47}]}','ZIP',1,'SYNCED',0,NULL,'2023-08-30 14:14:41.883','2023-08-30 12:14:41.944','2023-08-30 14:14:42.248'),('cd73cb1b-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/computedocclusion_ca3f0e84-4729-11ee-9ed6-a86daa000811/cd73cb1b-4729-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_OCC_ca3f0e84-4729-11ee-9ed6-a86daa000811_TOPLY','cd73cb1b-4729-11ee-9ed6-a86daa000811.zip','cd73cb1b-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Maxillaire\",\"modelMatrix\":\"0.843117,0.520441,-0.135261,0,-0.53773,0.816008,-0.212077,0,-7.53654e-09,0.25154,0.967847,0,-18.9484,-14.764,-16.1295,1\",\"occlusionMatrix\":\"-0.983126,0.167783,-0.072598,0,0.0392723,-0.190245,-0.980907,0,-0.17867,-0.967293,0.180417,0,20.5015,12.8642,1.83297,1\",\"occlusionType\":2,\"referenceScanId\":\"17422636-4729-11ee-9ed6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:38:59.000','2023-08-30 11:39:19.526','2023-08-30 13:39:19.526'),('cd958524-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/computedocclusion_ca3f0e84-4729-11ee-9ed6-a86daa000811/cd958524-4729-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_OCC_ca3f0e84-4729-11ee-9ed6-a86daa000811_LIFIO','cd958524-4729-11ee-9ed6-a86daa000811.xyz','cd958524-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"17422636-4729-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 13:39:00.000','2023-08-30 11:39:19.530','2023-08-30 13:39:19.530'),('cd958907-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/computedocclusion_ca3f0e84-4729-11ee-9ed6-a86daa000811/cd958907-4729-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_OCC_ca3f0e84-4729-11ee-9ed6-a86daa000811_LIFIMO','cd958907-4729-11ee-9ed6-a86daa000811.bin','cd958907-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"17422636-4729-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 13:39:01.000','2023-08-30 11:39:19.534','2023-08-30 13:39:19.534'),('cd95da08-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/computedocclusion_ca3f0e84-4729-11ee-9ed6-a86daa000811/cd95da08-4729-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_OCC_ca3f0e84-4729-11ee-9ed6-a86daa000811_BOPLY','cd95da08-4729-11ee-9ed6-a86daa000811.zip','cd95da08-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Mandibule\",\"modelMatrix\":\"0.819964,0.567379,-0.0757612,0,-0.572415,0.812751,-0.108525,0,3.76289e-10,0.132354,0.991203,0,-14.285,-14.0309,-15.3544,1\",\"occlusionMatrix\":\"-0.99757,0.0179703,0.066693,0,0.068922,0.409527,0.909714,0,-0.0108498,0.912124,-0.409854,0,16.7282,-11.1083,7.03667,1\",\"occlusionType\":2,\"referenceScanId\":\"634e5f54-4729-11ee-9ed6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:39:02.000','2023-08-30 11:39:19.537','2023-08-30 13:39:19.537'),('cdb0666a-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/computedocclusion_ca3f0e84-4729-11ee-9ed6-a86daa000811/cdb0666a-4729-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_OCC_ca3f0e84-4729-11ee-9ed6-a86daa000811_LIFIO','cdb0666a-4729-11ee-9ed6-a86daa000811.xyz','cdb0666a-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Ligne de finition Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"634e5f54-4729-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 13:39:02.000','2023-08-30 11:39:19.542','2023-08-30 13:39:19.542'),('cdb06c83-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/computedocclusion_ca3f0e84-4729-11ee-9ed6-a86daa000811/cdb06c83-4729-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_OCC_ca3f0e84-4729-11ee-9ed6-a86daa000811_LIFIMO','cdb06c83-4729-11ee-9ed6-a86daa000811.bin','cdb06c83-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Ligne de finition métadonnées Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"634e5f54-4729-11ee-9ed6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 13:39:03.000','2023-08-30 11:39:19.545','2023-08-30 13:39:19.545'),('cdef9140-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/occlusion_35abe11d-4728-11ee-9ed6-a86daa000811/computedocclusion_ca3f0e84-4729-11ee-9ed6-a86daa000811/cdef9140-4729-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_SESS_35abe11d-4728-11ee-9ed6-a86daa000811_OCC_ca3f0e84-4729-11ee-9ed6-a86daa000811_SNAPO','cdef9140-4729-11ee-9ed6-a86daa000811.png','cdef9140-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Snapshot\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2023-08-30 13:39:03.000','2023-08-30 11:39:19.550','2023-08-30 13:39:19.550'),('d09577b9-472a-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/occlusion_989d6f5f-472a-11ee-9ed6-a86daa000811/scan_99da97a8-472a-11ee-9ed6-a86daa000811/d09577b9-472a-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_SESS_989d6f5f-472a-11ee-9ed6-a86daa000811_TOSC_99da97a8-472a-11ee-9ed6-a86daa000811_LIFI','d09577b9-472a-11ee-9ed6-a86daa000811.xyz','d09577b9-472a-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 13:46:11.000','2023-08-30 11:49:13.711','2023-08-30 13:49:13.711'),('d0957e62-472a-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/occlusion_989d6f5f-472a-11ee-9ed6-a86daa000811/scan_99da97a8-472a-11ee-9ed6-a86daa000811/d0957e62-472a-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_SESS_989d6f5f-472a-11ee-9ed6-a86daa000811_TOSC_99da97a8-472a-11ee-9ed6-a86daa000811_LIFIM','d0957e62-472a-11ee-9ed6-a86daa000811.bin','d0957e62-472a-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 13:46:11.000','2023-08-30 11:49:13.716','2023-08-30 13:49:13.716'),('d307c24c-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_b04fc180-472d-11ee-9ed6-a86daa000811/d307c24c-472d-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_b04fc180-472d-11ee-9ed6-a86daa000811_MODEL','d307c24c-472d-11ee-9ed6-a86daa000811.zip','b04fe5ac-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.2\",\"modelMatrix\":\"0.918025,0.383148,-0.102119,0,-0.396523,0.887059,-0.236424,0,1.03241e-09,0.257535,0.966269,0,-18.3884,-9.04183,-15.2287,1\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2023-08-30 14:07:48.000','2023-08-30 12:20:09.905','2023-08-30 14:20:09.905'),('d307d730-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_b04fc180-472d-11ee-9ed6-a86daa000811/d307d730-472d-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_b04fc180-472d-11ee-9ed6-a86daa000811_SNAPS','d307d730-472d-11ee-9ed6-a86daa000811.png','b0558353-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.2 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-08-30 14:07:49.000','2023-08-30 12:20:09.911','2023-08-30 14:20:09.911'),('d96cdd79-4729-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_35aa76b0-4728-11ee-9ed6-a86daa000811/order_35ad590e-4728-11ee-9ed6-a86daa000811/d96cdd79-4729-11ee-9ed6-a86daa000811.pdf','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_35aa76b0-4728-11ee-9ed6-a86daa000811_PROST_35ad590e-4728-11ee-9ed6-a86daa000811_FORM','d96cdd79-4729-11ee-9ed6-a86daa000811.pdf','d96cdd79-4729-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Commande 1.1.1.1 Couronne\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2023-08-30 13:39:17.000','2023-08-30 11:39:19.554','2023-08-30 13:39:19.554'),('dc89b09c-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_b04fc180-472d-11ee-9ed6-a86daa000811/dc89b09c-472d-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_b04fc180-472d-11ee-9ed6-a86daa000811_LIFI','dc89b09c-472d-11ee-9ed6-a86daa000811.xyz','dc89b09c-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.2 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 14:07:59.417','2023-08-30 12:07:59.420','2023-08-30 14:07:59.427'),('dc89b419-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_b04fc180-472d-11ee-9ed6-a86daa000811/dc89b419-472d-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_b04fc180-472d-11ee-9ed6-a86daa000811_LIFIM','dc89b419-472d-11ee-9ed6-a86daa000811.bin','dc89b419-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.2 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 14:08:00.000','2023-08-30 12:20:09.914','2023-08-30 14:20:09.914'),('de1e1f37-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_de1dfc40-472d-11ee-9ed6-a86daa000811/de1e1f37-472d-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_de1dfc40-472d-11ee-9ed6-a86daa000811_MODEL','de1e1f37-472d-11ee-9ed6-a86daa000811.zip','de1e1f37-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.3\",\"modelMatrix\":\"0.918025,0.383148,-0.102119,0,-0.396523,0.887059,-0.236424,0,1.03241e-09,0.257535,0.966269,0,-18.3884,-9.04183,-15.2287,1\",\"scanBodies\":[{\"position\":\"11.0281,6,0,0,-3.60355,0,6,0,19.5548,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":17}]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 14:08:02.068','2023-08-30 12:08:55.510','2023-08-30 14:08:55.513'),('de23efba-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_de1dfc40-472d-11ee-9ed6-a86daa000811/de23efba-472d-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_de1dfc40-472d-11ee-9ed6-a86daa000811_SNAPS','de23efba-472d-11ee-9ed6-a86daa000811.png','de23efba-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.3 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 14:08:06.000','2023-08-30 12:20:09.790','2023-08-30 14:20:09.790'),('de240121-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_de1dfc40-472d-11ee-9ed6-a86daa000811/de240121-472d-11ee-9ed6-a86daa000811.xyz','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_de1dfc40-472d-11ee-9ed6-a86daa000811_LIFI','de240121-472d-11ee-9ed6-a86daa000811.xyz','de240121-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.3 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2023-08-30 14:08:57.587','2023-08-30 14:08:02.106','2023-08-30 12:08:57.588','2023-08-30 14:10:47.943'),('de240e94-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_de1dfc40-472d-11ee-9ed6-a86daa000811/de240e94-472d-11ee-9ed6-a86daa000811.bin','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_de1dfc40-472d-11ee-9ed6-a86daa000811_LIFIM','de240e94-472d-11ee-9ed6-a86daa000811.bin','de240e94-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.3 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2023-08-30 14:08:57.587','2023-08-30 14:08:02.106','2023-08-30 12:08:57.588','2023-08-30 14:10:47.943'),('e464cfca-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_61ce0aa4-472b-11ee-9ed6-a86daa000811/occlusion_61cf451e-472b-11ee-9ed6-a86daa000811/scan_c99dc3d7-472b-11ee-9ed6-a86daa000811/e464cfca-472b-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_61ce0aa4-472b-11ee-9ed6-a86daa000811_SESS_61cf451e-472b-11ee-9ed6-a86daa000811_RISC_c99dc3d7-472b-11ee-9ed6-a86daa000811_MODEL','e464cfca-472b-11ee-9ed6-a86daa000811.zip','e464cfca-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mordu droit 1.1.3.1.1\",\"modelMatrix\":\"0.998147,-0.0413563,0.0425262,0,0.0458912,0.995876,-0.0791122,0,-0.0399863,0.0807534,0.995959,0,8.30248,-9.24559,-15.2899,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:53:58.000','2023-08-30 11:55:46.288','2023-08-30 13:55:46.288'),('e464e87f-472b-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_61ce0aa4-472b-11ee-9ed6-a86daa000811/occlusion_61cf451e-472b-11ee-9ed6-a86daa000811/scan_c99dc3d7-472b-11ee-9ed6-a86daa000811/e464e87f-472b-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_61ce0aa4-472b-11ee-9ed6-a86daa000811_SESS_61cf451e-472b-11ee-9ed6-a86daa000811_RISC_c99dc3d7-472b-11ee-9ed6-a86daa000811_SNAPS','e464e87f-472b-11ee-9ed6-a86daa000811.png','e464e87f-472b-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mordu droit 1.1.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 13:53:58.000','2023-08-30 11:55:46.299','2023-08-30 13:55:46.299'),('ee561429-472a-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/occlusion_989d6f5f-472a-11ee-9ed6-a86daa000811/scan_d2d43a54-472a-11ee-9ed6-a86daa000811/ee561429-472a-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_SESS_989d6f5f-472a-11ee-9ed6-a86daa000811_BOSC_d2d43a54-472a-11ee-9ed6-a86daa000811_MODEL','ee561429-472a-11ee-9ed6-a86daa000811.zip','ee561429-472a-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.1\",\"modelMatrix\":\"0.832175,-0.543364,0.110633,0,0.554513,0.815444,-0.16603,0,1.41265e-08,0.199514,0.979895,0,-11.0719,-2.65842,-24.1911,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 13:47:05.000','2023-08-30 11:49:13.722','2023-08-30 13:49:13.722'),('ee562b75-472a-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_989c88f2-472a-11ee-9ed6-a86daa000811/occlusion_989d6f5f-472a-11ee-9ed6-a86daa000811/scan_d2d43a54-472a-11ee-9ed6-a86daa000811/ee562b75-472a-11ee-9ed6-a86daa000811.png','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_989c88f2-472a-11ee-9ed6-a86daa000811_SESS_989d6f5f-472a-11ee-9ed6-a86daa000811_BOSC_d2d43a54-472a-11ee-9ed6-a86daa000811_SNAPS','ee562b75-472a-11ee-9ed6-a86daa000811.png','ee562b75-472a-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 13:47:06.000','2023-08-30 11:49:13.727','2023-08-30 13:49:13.727'),('fdf042fb-472d-11ee-9ed6-a86daa000811',196,'/var/.data/2023/196/2b399d66-4728-11ee-9ed6-a86daa000811/session_68303344-472d-11ee-9ed6-a86daa000811/occlusion_68317146-472d-11ee-9ed6-a86daa000811/scan_de1dfc40-472d-11ee-9ed6-a86daa000811/fdf042fb-472d-11ee-9ed6-a86daa000811.zip','PATIENT_2b399d66-4728-11ee-9ed6-a86daa000811_ACT_68303344-472d-11ee-9ed6-a86daa000811_SESS_68317146-472d-11ee-9ed6-a86daa000811_TOSC_de1dfc40-472d-11ee-9ed6-a86daa000811_MODEL','fdf042fb-472d-11ee-9ed6-a86daa000811.zip','de1e1f37-472d-11ee-9ed6-a86daa000811','{\"displayTitle\":\"Maxillaire scanbody 1.1.5.1.3\",\"modelMatrix\":\"0.918025,0.383148,-0.102119,0,-0.396523,0.887059,-0.236424,0,1.03241e-09,0.257535,0.966269,0,-18.3884,-9.04183,-15.2287,1\",\"scanBodies\":[{\"position\":\"11.0281,6,0,0,-3.60355,0,6,0,19.5548,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":17}]}','ZIP',1,'SYNCED',0,NULL,'2023-08-30 14:08:55.454','2023-08-30 12:08:55.510','2023-08-30 14:08:55.966');
/*!40000 ALTER TABLE `File` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `MessageStatus` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `contactId` varchar(36) NOT NULL,
  `status` enum('UNDELIVERED','DELIVERED','TRANSMITTED') NOT NULL DEFAULT 'UNDELIVERED',
  `bcc` tinyint(1) NOT NULL DEFAULT '0',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`sentMessageId`,`contactId`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `MessageStatus_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_3` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
INSERT INTO `MessageStatus` VALUES (196,'0b67d55d-472a-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b','TRANSMITTED',0,'2023-08-30 11:45:58.089'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b','TRANSMITTED',0,'2023-08-30 11:55:47.222'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b','TRANSMITTED',0,'2023-08-30 11:54:08.911'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b','DELIVERED',0,'2023-08-30 12:03:56.799'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b','DELIVERED',0,'2023-08-30 12:20:13.054'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b','TRANSMITTED',0,'2023-08-30 11:45:58.219'),(196,'ecca814d-4728-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b','TRANSMITTED',0,'2023-08-30 11:45:58.243');
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Occlusion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sessionId` varchar(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'UNKNOWN',
  `displayId` mediumint unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `topScanId` varchar(36) DEFAULT NULL,
  `bottomScanId` varchar(36) DEFAULT NULL,
  `anteriorBiteScanId` varchar(36) DEFAULT NULL,
  `rightBiteScanId` varchar(36) DEFAULT NULL,
  `leftBiteScanId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  KEY `topScanId` (`topScanId`),
  KEY `bottomScanId` (`bottomScanId`),
  KEY `anteriorBiteScanId` (`anteriorBiteScanId`),
  KEY `rightBiteScanId` (`rightBiteScanId`),
  KEY `leftBiteScanId` (`leftBiteScanId`),
  CONSTRAINT `Occlusion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_3` FOREIGN KEY (`topScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_4` FOREIGN KEY (`bottomScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_5` FOREIGN KEY (`anteriorBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_6` FOREIGN KEY (`rightBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_7` FOREIGN KEY (`leftBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
INSERT INTO `Occlusion` VALUES ('0712c345-472d-11ee-9ed6-a86daa000811',196,'3fea1de6-472c-11ee-9ed6-a86daa000811','HEMI_ARCADE_POSTERIEUR_GAUCHE',1,0,'','416b51d9-472c-11ee-9ed6-a86daa000811','78ac12f2-472c-11ee-9ed6-a86daa000811',NULL,NULL,'eafd17f1-472c-11ee-9ed6-a86daa000811','2023-08-30 14:02:01.283',NULL,'2023-08-30 14:03:21.006','2023-08-30 12:03:21.007','2023-08-30 14:03:21.016'),('2ec21872-472b-11ee-9ed6-a86daa000811',196,'989d6f5f-472a-11ee-9ed6-a86daa000811','HEMI_ARCADE_POSTERIEUR_GAUCHE',1,0,'','99da97a8-472a-11ee-9ed6-a86daa000811','d2d43a54-472a-11ee-9ed6-a86daa000811',NULL,NULL,'f30f1fe1-472a-11ee-9ed6-a86daa000811','2023-08-30 13:48:48.870',NULL,'2023-08-30 13:48:54.861','2023-08-30 11:48:54.862','2023-08-30 13:48:54.868'),('341335b3-472f-11ee-9ed6-a86daa000811',196,'68317146-472d-11ee-9ed6-a86daa000811','HEMI_ARCADE_POSTERIEUR_GAUCHE',1,0,'','69d717f9-472d-11ee-9ed6-a86daa000811','475fb1a4-472e-11ee-9ed6-a86daa000811',NULL,NULL,'121e4546-472f-11ee-9ed6-a86daa000811','2023-08-30 14:17:35.777',NULL,'2023-08-30 14:19:34.890','2023-08-30 12:19:34.891','2023-08-30 14:19:34.899'),('ca3f0e84-4729-11ee-9ed6-a86daa000811',196,'35abe11d-4728-11ee-9ed6-a86daa000811','HEMI_ARCADE_POSTERIEUR_GAUCHE',1,0,'','17422636-4729-11ee-9ed6-a86daa000811','634e5f54-4729-11ee-9ed6-a86daa000811',NULL,NULL,'8d8049e9-4729-11ee-9ed6-a86daa000811','2023-08-30 13:38:50.742',NULL,'2023-08-30 13:38:56.935','2023-08-30 11:38:56.935','2023-08-30 13:38:56.942'),('f29eb608-472b-11ee-9ed6-a86daa000811',196,'61cf451e-472b-11ee-9ed6-a86daa000811','HEMI_ARCADE_POSTERIEUR_DROIT',1,0,'','633e5fa3-472b-11ee-9ed6-a86daa000811','9c3fb326-472b-11ee-9ed6-a86daa000811',NULL,'c99dc3d7-472b-11ee-9ed6-a86daa000811',NULL,'2023-08-30 13:54:17.471',NULL,'2023-08-30 13:55:26.219','2023-08-30 11:55:26.219','2023-08-30 13:55:26.226');
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `OcclusionFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `occlusionId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('RESULT','MANDIBLE','MAXILLARY','MANDIBLE_SB','MAXILLARY_SB','MANDIBLE_PRE','MAXILLARY_PRE','LIFI','LIFIMETA','SNAPSHOT','SCREENSHOT') DEFAULT 'RESULT',
  PRIMARY KEY (`occlusionId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `OcclusionFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_2` FOREIGN KEY (`occlusionId`) REFERENCES `Occlusion` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
INSERT INTO `OcclusionFile` VALUES (196,'0712c345-472d-11ee-9ed6-a86daa000811','2458f8d4-472d-11ee-9ed6-a86daa000811','MAXILLARY'),(196,'0712c345-472d-11ee-9ed6-a86daa000811','247438da-472d-11ee-9ed6-a86daa000811','LIFI'),(196,'0712c345-472d-11ee-9ed6-a86daa000811','24744030-472d-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'0712c345-472d-11ee-9ed6-a86daa000811','2474870f-472d-11ee-9ed6-a86daa000811','LIFI'),(196,'0712c345-472d-11ee-9ed6-a86daa000811','24748db4-472d-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'0712c345-472d-11ee-9ed6-a86daa000811','2474f22b-472d-11ee-9ed6-a86daa000811','MANDIBLE'),(196,'0712c345-472d-11ee-9ed6-a86daa000811','24cb639a-472d-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'0712c345-472d-11ee-9ed6-a86daa000811','27b77ffa-472d-11ee-9ed6-a86daa000811','LIFI'),(196,'0712c345-472d-11ee-9ed6-a86daa000811','27b78410-472d-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'0712c345-472d-11ee-9ed6-a86daa000811','2c161d27-472d-11ee-9ed6-a86daa000811','LIFI'),(196,'0712c345-472d-11ee-9ed6-a86daa000811','2c16211c-472d-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'2ec21872-472b-11ee-9ed6-a86daa000811','31e2e594-472b-11ee-9ed6-a86daa000811','MAXILLARY'),(196,'2ec21872-472b-11ee-9ed6-a86daa000811','3201d58a-472b-11ee-9ed6-a86daa000811','LIFI'),(196,'2ec21872-472b-11ee-9ed6-a86daa000811','3201db96-472b-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'2ec21872-472b-11ee-9ed6-a86daa000811','320220f7-472b-11ee-9ed6-a86daa000811','MANDIBLE'),(196,'2ec21872-472b-11ee-9ed6-a86daa000811','325421e6-472b-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','592df62e-472f-11ee-9ed6-a86daa000811','MAXILLARY'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','59485f47-472f-11ee-9ed6-a86daa000811','LIFI'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','59486661-472f-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','5948aad0-472f-11ee-9ed6-a86daa000811','MANDIBLE'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','59636a0c-472f-11ee-9ed6-a86daa000811','LIFI'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','59637078-472f-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','599fc312-472f-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','692d6a54-472f-11ee-9ed6-a86daa000811','MANDIBLE_PRE'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','6949bbb1-472f-11ee-9ed6-a86daa000811','LIFI'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','6949c28f-472f-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','6d229cf2-472f-11ee-9ed6-a86daa000811','MANDIBLE_SB'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','7518967b-472f-11ee-9ed6-a86daa000811','MAXILLARY_PRE'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','752f790c-472f-11ee-9ed6-a86daa000811','LIFI'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','752f81ce-472f-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'341335b3-472f-11ee-9ed6-a86daa000811','7afad9a7-472f-11ee-9ed6-a86daa000811','MAXILLARY_SB'),(196,'ca3f0e84-4729-11ee-9ed6-a86daa000811','cd73cb1b-4729-11ee-9ed6-a86daa000811','MAXILLARY'),(196,'ca3f0e84-4729-11ee-9ed6-a86daa000811','cd958524-4729-11ee-9ed6-a86daa000811','LIFI'),(196,'ca3f0e84-4729-11ee-9ed6-a86daa000811','cd958907-4729-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'ca3f0e84-4729-11ee-9ed6-a86daa000811','cd95da08-4729-11ee-9ed6-a86daa000811','MANDIBLE'),(196,'ca3f0e84-4729-11ee-9ed6-a86daa000811','cdb0666a-4729-11ee-9ed6-a86daa000811','LIFI'),(196,'ca3f0e84-4729-11ee-9ed6-a86daa000811','cdb06c83-4729-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'ca3f0e84-4729-11ee-9ed6-a86daa000811','cdef9140-4729-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'f29eb608-472b-11ee-9ed6-a86daa000811','1b208ef0-472c-11ee-9ed6-a86daa000811','MAXILLARY'),(196,'f29eb608-472b-11ee-9ed6-a86daa000811','1b3fc2ee-472c-11ee-9ed6-a86daa000811','LIFI'),(196,'f29eb608-472b-11ee-9ed6-a86daa000811','1b3fca0b-472c-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'f29eb608-472b-11ee-9ed6-a86daa000811','1b407bfd-472c-11ee-9ed6-a86daa000811','MANDIBLE'),(196,'f29eb608-472b-11ee-9ed6-a86daa000811','1b988075-472c-11ee-9ed6-a86daa000811','SNAPSHOT');
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Office` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text,
  `country` varchar(75) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `Office_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
INSERT INTO `Office` VALUES ('58c32ca7-a8b1-457a-a8f9-c2c687158dc2',196,'12345678','sab vip','','labege','11110','labege','France',NULL,'2023-08-30 13:24:30.000','2023-08-30 11:24:32.532','2023-08-30 13:24:32.532'),('d63361bb-6176-4b34-9d85-d67b0fb78372',197,'123123','','','labege','','','France',NULL,'2023-08-30 13:28:35.000','2023-08-30 11:31:50.156','2023-08-30 13:31:50.156');
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `uuid` varchar(36) NOT NULL,
  `firstname` varchar(64) NOT NULL,
  `lastname` varchar(64) NOT NULL,
  `email` varchar(255) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('d4932345-593d-4b0e-a26b-2ce26d4a828b','léger','client ','gamajesa@hotmail.fr','2023-08-30 11:31:50.128','2023-08-30 13:32:05.791'),('f631f403-5fdc-429e-b136-cc7e8e30bd33','sabine','kupcic','sabine.caserta@scan4all.fr','2023-08-30 11:24:32.524','2023-08-30 13:24:33.092');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `uuid` varchar(36) NOT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('1b5d180d-354f-42ee-9226-2f533affc72c','123123','','','2023-08-30 11:31:50.131','2023-08-30 13:32:05.791'),('57ac5f7c-6ca9-4b46-b417-f89f20d2f64f','12345678','','','2023-08-30 11:24:32.525','2023-08-30 13:24:33.092');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `uuid` varchar(36) NOT NULL,
  `id` mediumint unsigned NOT NULL,
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `configId` mediumint unsigned DEFAULT NULL,
  `syncInfoId` mediumint unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `comments` text,
  `type` enum('UNDEFINED','PROTHESIST','DENTIST','DEMO','OTHER') NOT NULL DEFAULT 'UNDEFINED',
  `limitedContactId` varchar(36) DEFAULT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT '1',
  `statusGalaxy` tinyint(1) DEFAULT '0',
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  UNIQUE KEY `credentialsId` (`credentialsId`),
  KEY `syncInfoId` (`syncInfoId`,`id`),
  KEY `configId` (`configId`,`id`),
  CONSTRAINT `Professional_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_2` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_3` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_4` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_5` FOREIGN KEY (`syncInfoId`, `id`) REFERENCES `SyncInfo` (`id`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_6` FOREIGN KEY (`configId`, `id`) REFERENCES `Config` (`id`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES ('d8a1bd40-6ede-4d49-905a-5c80de9b9d23',196,'53a5f2ba-3eaf-4bc8-b922-c2319948ddd4','f631f403-5fdc-429e-b136-cc7e8e30bd33','57ac5f7c-6ca9-4b46-b417-f89f20d2f64f','37e905b8-eafe-4d79-93b0-71ce73096a6e',1,1,'','','DENTIST',NULL,1,0,NULL,'2023-08-30 13:24:29.000','2023-08-30 11:24:33.074','2023-08-30 13:24:33.092'),('3de28c4f-c2ff-404f-b6e8-51d4b70e21de',197,'5bd8a1ae-8cbd-4514-ac23-408b42c55e97','d4932345-593d-4b0e-a26b-2ce26d4a828b','1b5d180d-354f-42ee-9226-2f533affc72c','6524681a-2b40-4860-9a83-d78658f9e377',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2023-08-30 13:28:34.000','2023-08-30 11:32:05.785','2023-08-30 13:32:05.791');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalEnvInfos`
--

DROP TABLE IF EXISTS `ProfessionalEnvInfos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalEnvInfos` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `accessCode` varchar(45) DEFAULT NULL,
  `status` enum('CREATED','CONFIRMED','BLOCKED') NOT NULL DEFAULT 'CREATED',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`ownerId`),
  CONSTRAINT `ProfessionalEnvInfos_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalEnvInfos`
--

LOCK TABLES `ProfessionalEnvInfos` WRITE;
/*!40000 ALTER TABLE `ProfessionalEnvInfos` DISABLE KEYS */;
INSERT INTO `ProfessionalEnvInfos` VALUES (196,'','CONFIRMED','2023-08-30 11:24:32.531','2023-08-30 13:24:32.531'),(197,'853bb0ef','CREATED','2023-08-30 11:28:36.450','2023-08-30 13:28:36.450');
/*!40000 ALTER TABLE `ProfessionalEnvInfos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalPatient` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`ownerId`,`patientId`),
  KEY `patientId` (`patientId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `ProfessionalPatient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `wow_patient`.`Patient` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
INSERT INTO `ProfessionalPatient` VALUES (196,'2b399d66-4728-11ee-9ed6-a86daa000811','58c32ca7-a8b1-457a-a8f9-c2c687158dc2',0,0,'NONE');
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `status` enum('NOT_SENT','SENT','DATE_VALIDATED','DATE_EDITED','VALIDATED','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `unread` tinyint(1) DEFAULT '0',
  `currentDeliveryDate` datetime(3) DEFAULT NULL,
  `previousDeliveryDate` datetime(3) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `displayId` mediumint unsigned DEFAULT NULL,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `ProstheticOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
INSERT INTO `ProstheticOrder` VALUES ('35ad590e-4728-11ee-9ed6-a86daa000811',196,'35aa76b0-4728-11ee-9ed6-a86daa000811','Commande n° 1.1.1.1','DATE_VALIDATED',0,'2023-09-03 00:00:00.000',NULL,0,1,'d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 13:27:31.000',NULL,'2023-08-30 13:39:37.000','2023-08-30 11:39:38.088','2023-08-30 13:39:38.088'),('3bd790d4-472d-11ee-9ed6-a86daa000811',196,'3fe9ba1b-472c-11ee-9ed6-a86daa000811','Commande n° 1.1.4.1','CANCELLED',0,'2023-09-03 00:00:00.000',NULL,0,1,'d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:03:29.000',NULL,'2023-08-30 14:21:06.000','2023-08-30 12:21:07.804','2023-08-30 14:21:07.804'),('61d0939c-472b-11ee-9ed6-a86daa000811',196,'61ce0aa4-472b-11ee-9ed6-a86daa000811','Commande n° 1.1.3.1','DATE_VALIDATED',0,'2023-09-03 00:00:00.000',NULL,0,1,'d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 13:50:14.000',NULL,'2023-08-30 13:56:07.000','2023-08-30 11:56:08.244','2023-08-30 13:56:08.244'),('6832b9c0-472d-11ee-9ed6-a86daa000811',196,'68303344-472d-11ee-9ed6-a86daa000811','Commande n° 1.1.5.1','DATE_VALIDATED',0,'2023-09-03 00:00:00.000',NULL,0,1,'d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:04:44.000',NULL,'2023-08-30 14:21:20.000','2023-08-30 12:21:21.549','2023-08-30 14:21:21.549'),('989dfa08-472a-11ee-9ed6-a86daa000811',196,'989c88f2-472a-11ee-9ed6-a86daa000811','Commande n° 1.1.2.1','VALIDATED',0,'2023-09-01 00:00:00.000','2023-09-03 00:00:00.000',0,1,'d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 13:44:36.000',NULL,'2023-08-30 13:49:37.000','2023-08-30 11:49:39.064','2023-08-30 13:49:39.064'),('f26b8ea7-472f-11ee-9ed6-a86daa000811',196,'f2691117-472f-11ee-9ed6-a86daa000811','Commande n° 1.1.6.1','NOT_SENT',1,NULL,NULL,1,1,'d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:22:55.123',NULL,'2023-08-30 14:22:55.127','2023-08-30 12:22:55.128',NULL);
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ProstheticOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
INSERT INTO `ProstheticOrderFile` VALUES (196,'35ad590e-4728-11ee-9ed6-a86daa000811','5db2bca1-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','5db2e560-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','60d87a10-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','60d87eeb-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','82922060-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','829236d7-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','88c6076b-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','88c617fa-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','8a8756dc-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','ab635311-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','ab63684c-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','cd73cb1b-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','cd958524-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','cd958907-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','cd95da08-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','cdb0666a-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','cdb06c83-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','cdef9140-4729-11ee-9ed6-a86daa000811','SCAN'),(196,'35ad590e-4728-11ee-9ed6-a86daa000811','d96cdd79-4729-11ee-9ed6-a86daa000811','FORM'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','03c3ab4a-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','03c3c1ca-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','2458f8d4-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','247438da-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','24744030-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','2474870f-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','24748db4-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','2474f22b-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','24cb639a-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','27b52885-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','27b52f37-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','27b77ffa-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','27b78410-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','2c135c02-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','2c136090-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','2c161d27-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','2c16211c-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','49878637-472d-11ee-9ed6-a86daa000811','FORM'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','5fbb145c-472c-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','5fbb2bf0-472c-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','6b79736c-472c-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','6b797ba3-472c-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','6eac3a0a-472c-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','6eac3de7-472c-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','97d284cf-472c-11ee-9ed6-a86daa000811','SCAN'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','97d29ba4-472c-11ee-9ed6-a86daa000811','SCAN'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','1b208ef0-472c-11ee-9ed6-a86daa000811','SCAN'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','1b3fc2ee-472c-11ee-9ed6-a86daa000811','SCAN'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','1b3fca0b-472c-11ee-9ed6-a86daa000811','SCAN'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','1b407bfd-472c-11ee-9ed6-a86daa000811','SCAN'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','1b988075-472c-11ee-9ed6-a86daa000811','SCAN'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','259989c9-472c-11ee-9ed6-a86daa000811','FORM'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','8f206867-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','8f2080cc-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','9a8afba7-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','9a8b009c-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','b41f786e-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','b41f8ee1-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','e464cfca-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','e464e87f-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','03ed27f7-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','03ed6203-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','3143d3da-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','3143fbb5-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','4087e47a-472e-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','408808e2-472e-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','592df62e-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','59485f47-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','59486661-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','5948aad0-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','59636a0c-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','59637078-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','599fc312-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','692d6a54-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','6949bbb1-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','6949c28f-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','6d229cf2-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','6f2ca6a1-472e-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','6f2ccdcb-472e-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','72fd1bac-472e-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','72fd20d6-472e-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','75050c84-472e-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','7518967b-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','752f790c-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','752f81ce-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','7afad9a7-472f-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','8d004c4c-472f-11ee-9ed6-a86daa000811','FORM'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','8d6c0c7f-472f-11ee-9ed6-a86daa000811','FORM'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','8f294605-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','8f295e9f-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','9f67da47-472e-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','9f67fba8-472e-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','a371ae07-472e-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','a371b40d-472e-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','aec5de2b-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','aec5e1df-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','d307c24c-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','d307d730-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','dc89b09c-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','dc89b419-472d-11ee-9ed6-a86daa000811','SCAN'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','04bb69aa-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','04bb8166-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','31e2e594-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','3201d58a-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','3201db96-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','320220f7-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','325421e6-472b-11ee-9ed6-a86daa000811','SCAN'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','3b508740-472b-11ee-9ed6-a86daa000811','FORM'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','4b5700d1-472b-11ee-9ed6-a86daa000811','FORM'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','c6d260dd-472a-11ee-9ed6-a86daa000811','SCAN'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','c6d27881-472a-11ee-9ed6-a86daa000811','SCAN'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','d09577b9-472a-11ee-9ed6-a86daa000811','SCAN'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','d0957e62-472a-11ee-9ed6-a86daa000811','SCAN'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','ee561429-472a-11ee-9ed6-a86daa000811','SCAN'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','ee562b75-472a-11ee-9ed6-a86daa000811','SCAN');
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) NOT NULL,
  PRIMARY KEY (`orderId`,`recipientId`),
  KEY `ownerId` (`ownerId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `ProstheticOrderRecipient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
INSERT INTO `ProstheticOrderRecipient` VALUES (196,'35ad590e-4728-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b'),(196,'3bd790d4-472d-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b'),(196,'61d0939c-472b-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b'),(196,'6832b9c0-472d-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b'),(196,'989dfa08-472a-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b');
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticSheet` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `pdfFileId` (`pdfFileId`),
  CONSTRAINT `ProstheticSheet_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_3` FOREIGN KEY (`pdfFileId`) REFERENCES `File` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
INSERT INTO `ProstheticSheet` VALUES ('35ada692-4728-11ee-9ed6-a86daa000811',196,'35ad590e-4728-11ee-9ed6-a86daa000811','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            17\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false\n    }\n}\n','d96cdd79-4729-11ee-9ed6-a86daa000811','2023-08-30 13:27:25.000',NULL,'2023-08-30 13:39:19.000','2023-08-30 11:39:19.566','2023-08-30 13:39:38.088'),('3bd7ad0f-472d-11ee-9ed6-a86daa000811',196,'3bd790d4-472d-11ee-9ed6-a86daa000811','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Inlay\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 2,\n        \"usePrePreparation\": false\n    }\n}\n','49878637-472d-11ee-9ed6-a86daa000811','2023-08-30 14:03:28.000',NULL,'2023-08-30 14:03:56.000','2023-08-30 12:21:07.834','2023-08-30 14:21:07.804'),('61d107f7-472b-11ee-9ed6-a86daa000811',196,'61d0939c-472b-11ee-9ed6-a86daa000811','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Onlay\",\n        \"specificTint\": \"\",\n        \"subType\": 1,\n        \"type\": 2,\n        \"usePrePreparation\": false\n    }\n}\n','259989c9-472c-11ee-9ed6-a86daa000811','2023-08-30 13:50:10.000',NULL,'2023-08-30 13:55:44.000','2023-08-30 11:55:46.331','2023-08-30 13:56:08.244'),('683337bf-472d-11ee-9ed6-a86daa000811',196,'6832b9c0-472d-11ee-9ed6-a86daa000811','{\n    \"v2\": {\n        \"brandScanBody\": \"Biotech Dental\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"KECESCANP\",\n        \"selectedTeeth\": [\n            17,\n            47\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false\n    }\n}\n','8d004c4c-472f-11ee-9ed6-a86daa000811','2023-08-30 14:04:18.000',NULL,'2023-08-30 14:20:09.000','2023-08-30 12:20:09.927','2023-08-30 14:21:21.549'),('683350eb-472d-11ee-9ed6-a86daa000811',196,'6832b9c0-472d-11ee-9ed6-a86daa000811','{\n    \"v2\": {\n        \"brandScanBody\": \"Biotech Dental\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"KECESCANP\",\n        \"selectedTeeth\": [\n            36\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false\n    }\n}\n','8d6c0c7f-472f-11ee-9ed6-a86daa000811','2023-08-30 14:04:32.000',NULL,'2023-08-30 14:20:09.000','2023-08-30 12:21:21.557','2023-08-30 14:21:21.549'),('989e1602-472a-11ee-9ed6-a86daa000811',196,'989dfa08-472a-11ee-9ed6-a86daa000811','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            17\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false\n    }\n}\n','4b5700d1-472b-11ee-9ed6-a86daa000811','2023-08-30 13:44:33.000',NULL,'2023-08-30 13:49:13.000','2023-08-30 11:49:37.414','2023-08-30 13:49:38.718'),('f26bf130-472f-11ee-9ed6-a86daa000811',196,'f26b8ea7-472f-11ee-9ed6-a86daa000811','{\n    \"v2\": {\n        \"brandScanBody\": \"Biotech Dental\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"KECESCANP\",\n        \"selectedTeeth\": [\n            17\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": true\n    }\n}\n',NULL,'2023-08-30 14:21:51.567',NULL,'2023-08-30 14:22:55.126','2023-08-30 12:22:55.129',NULL),('f26c0fe2-472f-11ee-9ed6-a86daa000811',196,'f26b8ea7-472f-11ee-9ed6-a86daa000811','{\n    \"v2\": {\n        \"brandScanBody\": \"Biotech Dental\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"KECESCANP\",\n        \"selectedTeeth\": [\n            47\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": true\n    }\n}\n',NULL,'2023-08-30 14:22:13.382',NULL,'2023-08-30 14:22:55.127','2023-08-30 12:22:55.130',NULL);
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `receivedMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`receivedMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ReceivedAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_2` FOREIGN KEY (`receivedMessageId`) REFERENCES `ReceivedMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT '0',
  `messageSubject` varchar(45) NOT NULL,
  `body` text,
  `fromId` mediumint unsigned NOT NULL,
  `originMessageId` varchar(36) DEFAULT NULL,
  `discussionId` varchar(36) NOT NULL,
  `readStatus` enum('READ','UNREAD') DEFAULT 'UNREAD',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `fromId` (`fromId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `ReceivedMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_2` FOREIGN KEY (`fromId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_3` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Scan` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL,
  `sessionId` varchar(36) NOT NULL,
  `type` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') NOT NULL,
  `label` enum('PRE_PREPARATION','SCAN','SCANBODY') NOT NULL DEFAULT 'SCAN',
  `validated` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('IN_PROGRESS','NONE') NOT NULL DEFAULT 'IN_PROGRESS',
  `displayId` mediumint unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  CONSTRAINT `Scan_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Scan_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
INSERT INTO `Scan` VALUES ('121e4546-472f-11ee-9ed6-a86daa000811',196,'68317146-472d-11ee-9ed6-a86daa000811','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:16:38.807',NULL,'2023-08-30 14:17:31.332','2023-08-30 12:17:31.332','2023-08-30 14:17:31.336'),('17422636-4729-11ee-9ed6-a86daa000811',196,'35abe11d-4728-11ee-9ed6-a86daa000811','MAXILLAIRE','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 13:33:50.450',NULL,'2023-08-30 13:35:53.912','2023-08-30 11:35:48.989','2023-08-30 13:35:48.994'),('23b881d0-4730-11ee-9ed6-a86daa000811',196,'f26a478b-472f-11ee-9ed6-a86daa000811','MAXILLAIRE','SCAN',1,'NONE',2,0,'{\"referenceScanId\":\"f59e3d8b-472f-11ee-9ed6-a86daa000811\"}','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:24:17.836',NULL,'2023-08-30 14:25:08.356','2023-08-30 12:25:08.357','2023-08-30 14:25:08.362'),('416b51d9-472c-11ee-9ed6-a86daa000811',196,'3fea1de6-472c-11ee-9ed6-a86daa000811','MAXILLAIRE','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 13:56:29.675',NULL,'2023-08-30 14:03:21.064','2023-08-30 12:03:21.064','2023-08-30 14:03:21.071'),('4623ab82-4730-11ee-9ed6-a86daa000811',196,'f26a478b-472f-11ee-9ed6-a86daa000811','MAXILLAIRE','SCANBODY',1,'NONE',3,0,'{\"referenceScanId\":\"23b881d0-4730-11ee-9ed6-a86daa000811\"}','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:25:15.580',NULL,'2023-08-30 14:27:50.259','2023-08-30 12:27:50.259','2023-08-30 14:27:50.268'),('475fb1a4-472e-11ee-9ed6-a86daa000811',196,'68317146-472d-11ee-9ed6-a86daa000811','MANDIBULE','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:10:58.658',NULL,'2023-08-30 14:12:15.307','2023-08-30 12:12:15.307','2023-08-30 14:12:15.313'),('633e5fa3-472b-11ee-9ed6-a86daa000811',196,'61cf451e-472b-11ee-9ed6-a86daa000811','MAXILLAIRE','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 13:50:16.926',NULL,'2023-08-30 13:51:49.706','2023-08-30 11:51:49.707','2023-08-30 13:51:49.712'),('634e5f54-4729-11ee-9ed6-a86daa000811',196,'35abe11d-4728-11ee-9ed6-a86daa000811','MANDIBULE','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 13:35:58.037',NULL,'2023-08-30 13:37:03.902','2023-08-30 11:37:03.903','2023-08-30 13:37:03.907'),('69d717f9-472d-11ee-9ed6-a86daa000811',196,'68317146-472d-11ee-9ed6-a86daa000811','MAXILLAIRE','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:04:46.987',NULL,'2023-08-30 14:06:42.638','2023-08-30 12:06:42.639','2023-08-30 14:06:42.643'),('78ac12f2-472c-11ee-9ed6-a86daa000811',196,'3fea1de6-472c-11ee-9ed6-a86daa000811','MANDIBULE','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 13:58:02.374',NULL,'2023-08-30 14:03:21.112','2023-08-30 12:03:21.113','2023-08-30 14:03:21.120'),('79950e43-472e-11ee-9ed6-a86daa000811',196,'68317146-472d-11ee-9ed6-a86daa000811','MANDIBULE','SCAN',1,'NONE',2,0,'{\"referenceScanId\":\"475fb1a4-472e-11ee-9ed6-a86daa000811\"}','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:12:22.894',NULL,'2023-08-30 14:13:33.129','2023-08-30 12:13:33.130','2023-08-30 14:13:33.136'),('8d8049e9-4729-11ee-9ed6-a86daa000811',196,'35abe11d-4728-11ee-9ed6-a86daa000811','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 13:37:08.829',NULL,'2023-08-30 13:37:59.188','2023-08-30 11:37:59.188','2023-08-30 13:37:59.193'),('99da97a8-472a-11ee-9ed6-a86daa000811',196,'989d6f5f-472a-11ee-9ed6-a86daa000811','MAXILLAIRE','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 13:44:39.050',NULL,'2023-08-30 13:46:10.874','2023-08-30 11:46:10.874','2023-08-30 13:46:10.879'),('9c3fb326-472b-11ee-9ed6-a86daa000811',196,'61cf451e-472b-11ee-9ed6-a86daa000811','MANDIBULE','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 13:51:52.565',NULL,'2023-08-30 13:52:32.868','2023-08-30 11:52:32.869','2023-08-30 13:52:32.875'),('a5772713-472e-11ee-9ed6-a86daa000811',196,'68317146-472d-11ee-9ed6-a86daa000811','MANDIBULE','SCANBODY',1,'NONE',3,0,'{\"referenceScanId\":\"79950e43-472e-11ee-9ed6-a86daa000811\"}','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:13:36.518',NULL,'2023-08-30 14:16:15.739','2023-08-30 12:16:15.739','2023-08-30 14:16:15.750'),('ae4b5181-4730-11ee-9ed6-a86daa000811',196,'f26a478b-472f-11ee-9ed6-a86daa000811','MANDIBULE','PRE_PREPARATION',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:28:10.323',NULL,'2023-08-30 14:28:57.468','2023-08-30 12:28:57.469','2023-08-30 14:28:57.474'),('b04fc180-472d-11ee-9ed6-a86daa000811',196,'68317146-472d-11ee-9ed6-a86daa000811','MAXILLAIRE','SCAN',1,'NONE',2,0,'{\"referenceScanId\":\"69d717f9-472d-11ee-9ed6-a86daa000811\"}','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:06:45.218',NULL,'2023-08-30 14:07:59.419','2023-08-30 12:07:59.419','2023-08-30 14:07:59.426'),('c99dc3d7-472b-11ee-9ed6-a86daa000811',196,'61cf451e-472b-11ee-9ed6-a86daa000811','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 13:53:08.679',NULL,'2023-08-30 13:53:53.806','2023-08-30 11:53:53.806','2023-08-30 13:53:53.811'),('d2d43a54-472a-11ee-9ed6-a86daa000811',196,'989d6f5f-472a-11ee-9ed6-a86daa000811','MANDIBULE','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 13:46:14.638',NULL,'2023-08-30 13:47:01.020','2023-08-30 11:47:01.020','2023-08-30 13:47:01.025'),('de1dfc40-472d-11ee-9ed6-a86daa000811',196,'68317146-472d-11ee-9ed6-a86daa000811','MAXILLAIRE','SCANBODY',1,'NONE',3,0,'{\"referenceScanId\":\"b04fc180-472d-11ee-9ed6-a86daa000811\"}','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:08:02.067',NULL,'2023-08-30 14:10:47.940','2023-08-30 12:10:47.940','2023-08-30 14:10:47.948'),('eafd17f1-472c-11ee-9ed6-a86daa000811',196,'3fea1de6-472c-11ee-9ed6-a86daa000811','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:01:14.165',NULL,'2023-08-30 14:03:21.160','2023-08-30 12:03:21.160','2023-08-30 14:03:21.166'),('f30f1fe1-472a-11ee-9ed6-a86daa000811',196,'989d6f5f-472a-11ee-9ed6-a86daa000811','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 13:47:08.712',NULL,'2023-08-30 13:47:38.513','2023-08-30 11:47:38.513','2023-08-30 13:47:38.517'),('f59e3d8b-472f-11ee-9ed6-a86daa000811',196,'f26a478b-472f-11ee-9ed6-a86daa000811','MAXILLAIRE','PRE_PREPARATION',1,'NONE',1,0,'','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','d8a1bd40-6ede-4d49-905a-5c80de9b9d23','2023-08-30 14:23:00.488',NULL,'2023-08-30 14:23:57.339','2023-08-30 12:23:57.339','2023-08-30 14:23:57.344');
/*!40000 ALTER TABLE `Scan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ScanFile`
--

DROP TABLE IF EXISTS `ScanFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ScanFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `scanId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('MODEL','SNAPSHOT','SCREENSHOT','LIFI','LIFIMETA') NOT NULL,
  PRIMARY KEY (`scanId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ScanFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_2` FOREIGN KEY (`scanId`) REFERENCES `Scan` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ScanFile`
--

LOCK TABLES `ScanFile` WRITE;
/*!40000 ALTER TABLE `ScanFile` DISABLE KEYS */;
INSERT INTO `ScanFile` VALUES (196,'121e4546-472f-11ee-9ed6-a86daa000811','3143d3da-472f-11ee-9ed6-a86daa000811','MODEL'),(196,'121e4546-472f-11ee-9ed6-a86daa000811','3143fbb5-472f-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'17422636-4729-11ee-9ed6-a86daa000811','5db2bca1-4729-11ee-9ed6-a86daa000811','MODEL'),(196,'17422636-4729-11ee-9ed6-a86daa000811','5db2e560-4729-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'17422636-4729-11ee-9ed6-a86daa000811','60d87a10-4729-11ee-9ed6-a86daa000811','LIFI'),(196,'17422636-4729-11ee-9ed6-a86daa000811','60d87eeb-4729-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'23b881d0-4730-11ee-9ed6-a86daa000811','4198bac7-4730-11ee-9ed6-a86daa000811','MODEL'),(196,'23b881d0-4730-11ee-9ed6-a86daa000811','4198dca9-4730-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'416b51d9-472c-11ee-9ed6-a86daa000811','5fbb145c-472c-11ee-9ed6-a86daa000811','MODEL'),(196,'416b51d9-472c-11ee-9ed6-a86daa000811','5fbb2bf0-472c-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'416b51d9-472c-11ee-9ed6-a86daa000811','6b79736c-472c-11ee-9ed6-a86daa000811','LIFI'),(196,'416b51d9-472c-11ee-9ed6-a86daa000811','6b797ba3-472c-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'416b51d9-472c-11ee-9ed6-a86daa000811','6eac3a0a-472c-11ee-9ed6-a86daa000811','LIFI'),(196,'416b51d9-472c-11ee-9ed6-a86daa000811','6eac3de7-472c-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'4623ab82-4730-11ee-9ed6-a86daa000811','a1eeb013-4730-11ee-9ed6-a86daa000811','MODEL'),(196,'4623ab82-4730-11ee-9ed6-a86daa000811','a1eed0d0-4730-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'475fb1a4-472e-11ee-9ed6-a86daa000811','6f2ca6a1-472e-11ee-9ed6-a86daa000811','MODEL'),(196,'475fb1a4-472e-11ee-9ed6-a86daa000811','6f2ccdcb-472e-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'475fb1a4-472e-11ee-9ed6-a86daa000811','72fd1bac-472e-11ee-9ed6-a86daa000811','LIFI'),(196,'475fb1a4-472e-11ee-9ed6-a86daa000811','72fd20d6-472e-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'475fb1a4-472e-11ee-9ed6-a86daa000811','75050c84-472e-11ee-9ed6-a86daa000811','SCREENSHOT'),(196,'633e5fa3-472b-11ee-9ed6-a86daa000811','8f206867-472b-11ee-9ed6-a86daa000811','MODEL'),(196,'633e5fa3-472b-11ee-9ed6-a86daa000811','8f2080cc-472b-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'633e5fa3-472b-11ee-9ed6-a86daa000811','9a8afba7-472b-11ee-9ed6-a86daa000811','LIFI'),(196,'633e5fa3-472b-11ee-9ed6-a86daa000811','9a8b009c-472b-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'634e5f54-4729-11ee-9ed6-a86daa000811','82922060-4729-11ee-9ed6-a86daa000811','MODEL'),(196,'634e5f54-4729-11ee-9ed6-a86daa000811','829236d7-4729-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'634e5f54-4729-11ee-9ed6-a86daa000811','88c6076b-4729-11ee-9ed6-a86daa000811','LIFI'),(196,'634e5f54-4729-11ee-9ed6-a86daa000811','88c617fa-4729-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'634e5f54-4729-11ee-9ed6-a86daa000811','8a8756dc-4729-11ee-9ed6-a86daa000811','SCREENSHOT'),(196,'69d717f9-472d-11ee-9ed6-a86daa000811','8f294605-472d-11ee-9ed6-a86daa000811','MODEL'),(196,'69d717f9-472d-11ee-9ed6-a86daa000811','8f295e9f-472d-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'69d717f9-472d-11ee-9ed6-a86daa000811','aec5de2b-472d-11ee-9ed6-a86daa000811','LIFI'),(196,'69d717f9-472d-11ee-9ed6-a86daa000811','aec5e1df-472d-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'78ac12f2-472c-11ee-9ed6-a86daa000811','27b52885-472d-11ee-9ed6-a86daa000811','LIFI'),(196,'78ac12f2-472c-11ee-9ed6-a86daa000811','27b52f37-472d-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'78ac12f2-472c-11ee-9ed6-a86daa000811','2c135c02-472d-11ee-9ed6-a86daa000811','LIFI'),(196,'78ac12f2-472c-11ee-9ed6-a86daa000811','2c136090-472d-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'78ac12f2-472c-11ee-9ed6-a86daa000811','97d284cf-472c-11ee-9ed6-a86daa000811','MODEL'),(196,'78ac12f2-472c-11ee-9ed6-a86daa000811','97d29ba4-472c-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'79950e43-472e-11ee-9ed6-a86daa000811','799535ec-472e-11ee-9ed6-a86daa000811','MODEL'),(196,'79950e43-472e-11ee-9ed6-a86daa000811','799c6bd2-472e-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'79950e43-472e-11ee-9ed6-a86daa000811','799c7b69-472e-11ee-9ed6-a86daa000811','LIFI'),(196,'79950e43-472e-11ee-9ed6-a86daa000811','799c865f-472e-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'79950e43-472e-11ee-9ed6-a86daa000811','805c9473-472e-11ee-9ed6-a86daa000811','MODEL'),(196,'79950e43-472e-11ee-9ed6-a86daa000811','9f67da47-472e-11ee-9ed6-a86daa000811','MODEL'),(196,'79950e43-472e-11ee-9ed6-a86daa000811','9f67fba8-472e-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'79950e43-472e-11ee-9ed6-a86daa000811','a371ae07-472e-11ee-9ed6-a86daa000811','LIFI'),(196,'79950e43-472e-11ee-9ed6-a86daa000811','a371b40d-472e-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'8d8049e9-4729-11ee-9ed6-a86daa000811','ab635311-4729-11ee-9ed6-a86daa000811','MODEL'),(196,'8d8049e9-4729-11ee-9ed6-a86daa000811','ab63684c-4729-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'99da97a8-472a-11ee-9ed6-a86daa000811','c6d260dd-472a-11ee-9ed6-a86daa000811','MODEL'),(196,'99da97a8-472a-11ee-9ed6-a86daa000811','c6d27881-472a-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'99da97a8-472a-11ee-9ed6-a86daa000811','d09577b9-472a-11ee-9ed6-a86daa000811','LIFI'),(196,'99da97a8-472a-11ee-9ed6-a86daa000811','d0957e62-472a-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'9c3fb326-472b-11ee-9ed6-a86daa000811','b41f786e-472b-11ee-9ed6-a86daa000811','MODEL'),(196,'9c3fb326-472b-11ee-9ed6-a86daa000811','b41f8ee1-472b-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'a5772713-472e-11ee-9ed6-a86daa000811','03ed27f7-472f-11ee-9ed6-a86daa000811','MODEL'),(196,'a5772713-472e-11ee-9ed6-a86daa000811','03ed6203-472f-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'a5772713-472e-11ee-9ed6-a86daa000811','a577454a-472e-11ee-9ed6-a86daa000811','MODEL'),(196,'a5772713-472e-11ee-9ed6-a86daa000811','a57e163c-472e-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'a5772713-472e-11ee-9ed6-a86daa000811','a57e274f-472e-11ee-9ed6-a86daa000811','LIFI'),(196,'a5772713-472e-11ee-9ed6-a86daa000811','a57e33b5-472e-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'a5772713-472e-11ee-9ed6-a86daa000811','cc6d19b0-472e-11ee-9ed6-a86daa000811','MODEL'),(196,'ae4b5181-4730-11ee-9ed6-a86daa000811','ca3e67f9-4730-11ee-9ed6-a86daa000811','MODEL'),(196,'ae4b5181-4730-11ee-9ed6-a86daa000811','ca3e8070-4730-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'b04fc180-472d-11ee-9ed6-a86daa000811','b04fe5ac-472d-11ee-9ed6-a86daa000811','MODEL'),(196,'b04fc180-472d-11ee-9ed6-a86daa000811','b0558353-472d-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'b04fc180-472d-11ee-9ed6-a86daa000811','b0559281-472d-11ee-9ed6-a86daa000811','LIFI'),(196,'b04fc180-472d-11ee-9ed6-a86daa000811','b0559ee3-472d-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'b04fc180-472d-11ee-9ed6-a86daa000811','b4a95ee0-472d-11ee-9ed6-a86daa000811','MODEL'),(196,'b04fc180-472d-11ee-9ed6-a86daa000811','d307c24c-472d-11ee-9ed6-a86daa000811','MODEL'),(196,'b04fc180-472d-11ee-9ed6-a86daa000811','d307d730-472d-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'b04fc180-472d-11ee-9ed6-a86daa000811','dc89b09c-472d-11ee-9ed6-a86daa000811','LIFI'),(196,'b04fc180-472d-11ee-9ed6-a86daa000811','dc89b419-472d-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'c99dc3d7-472b-11ee-9ed6-a86daa000811','e464cfca-472b-11ee-9ed6-a86daa000811','MODEL'),(196,'c99dc3d7-472b-11ee-9ed6-a86daa000811','e464e87f-472b-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'d2d43a54-472a-11ee-9ed6-a86daa000811','ee561429-472a-11ee-9ed6-a86daa000811','MODEL'),(196,'d2d43a54-472a-11ee-9ed6-a86daa000811','ee562b75-472a-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'de1dfc40-472d-11ee-9ed6-a86daa000811','4087e47a-472e-11ee-9ed6-a86daa000811','MODEL'),(196,'de1dfc40-472d-11ee-9ed6-a86daa000811','408808e2-472e-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'de1dfc40-472d-11ee-9ed6-a86daa000811','de1e1f37-472d-11ee-9ed6-a86daa000811','MODEL'),(196,'de1dfc40-472d-11ee-9ed6-a86daa000811','de23efba-472d-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'de1dfc40-472d-11ee-9ed6-a86daa000811','de240121-472d-11ee-9ed6-a86daa000811','LIFI'),(196,'de1dfc40-472d-11ee-9ed6-a86daa000811','de240e94-472d-11ee-9ed6-a86daa000811','LIFIMETA'),(196,'de1dfc40-472d-11ee-9ed6-a86daa000811','fdf042fb-472d-11ee-9ed6-a86daa000811','MODEL'),(196,'eafd17f1-472c-11ee-9ed6-a86daa000811','03c3ab4a-472d-11ee-9ed6-a86daa000811','MODEL'),(196,'eafd17f1-472c-11ee-9ed6-a86daa000811','03c3c1ca-472d-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'f30f1fe1-472a-11ee-9ed6-a86daa000811','04bb69aa-472b-11ee-9ed6-a86daa000811','MODEL'),(196,'f30f1fe1-472a-11ee-9ed6-a86daa000811','04bb8166-472b-11ee-9ed6-a86daa000811','SNAPSHOT'),(196,'f59e3d8b-472f-11ee-9ed6-a86daa000811','17557d10-4730-11ee-9ed6-a86daa000811','MODEL'),(196,'f59e3d8b-472f-11ee-9ed6-a86daa000811','175594cd-4730-11ee-9ed6-a86daa000811','SNAPSHOT');
/*!40000 ALTER TABLE `ScanFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentAttachment`
--

DROP TABLE IF EXISTS `SentAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentAttachment` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`sentMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SentAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentAttachment`
--

LOCK TABLES `SentAttachment` WRITE;
/*!40000 ALTER TABLE `SentAttachment` DISABLE KEYS */;
INSERT INTO `SentAttachment` VALUES (196,'0b67d55d-472a-11ee-9ed6-a86daa000811','8a8756dc-4729-11ee-9ed6-a86daa000811'),(196,'0b67d55d-472a-11ee-9ed6-a86daa000811','cd73cb1b-4729-11ee-9ed6-a86daa000811'),(196,'0b67d55d-472a-11ee-9ed6-a86daa000811','cd958524-4729-11ee-9ed6-a86daa000811'),(196,'0b67d55d-472a-11ee-9ed6-a86daa000811','cd958907-4729-11ee-9ed6-a86daa000811'),(196,'0b67d55d-472a-11ee-9ed6-a86daa000811','cd95da08-4729-11ee-9ed6-a86daa000811'),(196,'0b67d55d-472a-11ee-9ed6-a86daa000811','cdb0666a-4729-11ee-9ed6-a86daa000811'),(196,'0b67d55d-472a-11ee-9ed6-a86daa000811','cdb06c83-4729-11ee-9ed6-a86daa000811'),(196,'0b67d55d-472a-11ee-9ed6-a86daa000811','cdef9140-4729-11ee-9ed6-a86daa000811'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','1b208ef0-472c-11ee-9ed6-a86daa000811'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','1b3fc2ee-472c-11ee-9ed6-a86daa000811'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','1b3fca0b-472c-11ee-9ed6-a86daa000811'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','1b407bfd-472c-11ee-9ed6-a86daa000811'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','1b988075-472c-11ee-9ed6-a86daa000811'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','259989c9-472c-11ee-9ed6-a86daa000811'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','8f206867-472b-11ee-9ed6-a86daa000811'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','8f2080cc-472b-11ee-9ed6-a86daa000811'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','9a8afba7-472b-11ee-9ed6-a86daa000811'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','9a8b009c-472b-11ee-9ed6-a86daa000811'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','b41f786e-472b-11ee-9ed6-a86daa000811'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','b41f8ee1-472b-11ee-9ed6-a86daa000811'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','e464cfca-472b-11ee-9ed6-a86daa000811'),(196,'25fa8f1b-472c-11ee-9ed6-a86daa000811','e464e87f-472b-11ee-9ed6-a86daa000811'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','04bb69aa-472b-11ee-9ed6-a86daa000811'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','04bb8166-472b-11ee-9ed6-a86daa000811'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','31e2e594-472b-11ee-9ed6-a86daa000811'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','3201d58a-472b-11ee-9ed6-a86daa000811'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','3201db96-472b-11ee-9ed6-a86daa000811'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','320220f7-472b-11ee-9ed6-a86daa000811'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','325421e6-472b-11ee-9ed6-a86daa000811'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','3b508740-472b-11ee-9ed6-a86daa000811'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','c6d260dd-472a-11ee-9ed6-a86daa000811'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','c6d27881-472a-11ee-9ed6-a86daa000811'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','d09577b9-472a-11ee-9ed6-a86daa000811'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','d0957e62-472a-11ee-9ed6-a86daa000811'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','ee561429-472a-11ee-9ed6-a86daa000811'),(196,'3bb156aa-472b-11ee-9ed6-a86daa000811','ee562b75-472a-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','03c3ab4a-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','03c3c1ca-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','2458f8d4-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','247438da-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','24744030-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','2474870f-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','24748db4-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','2474f22b-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','24cb639a-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','27b52885-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','27b52f37-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','27b77ffa-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','27b78410-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','2c135c02-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','2c136090-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','2c161d27-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','2c16211c-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','49878637-472d-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','5fbb145c-472c-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','5fbb2bf0-472c-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','6b79736c-472c-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','6b797ba3-472c-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','6eac3a0a-472c-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','6eac3de7-472c-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','97d284cf-472c-11ee-9ed6-a86daa000811'),(196,'49ee16f2-472d-11ee-9ed6-a86daa000811','97d29ba4-472c-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','03ed27f7-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','03ed6203-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','3143d3da-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','3143fbb5-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','4087e47a-472e-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','408808e2-472e-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','592df62e-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','59485f47-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','59486661-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','5948aad0-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','59636a0c-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','59637078-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','599fc312-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','692d6a54-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','6949bbb1-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','6949c28f-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','6d229cf2-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','6f2ca6a1-472e-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','6f2ccdcb-472e-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','72fd1bac-472e-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','72fd20d6-472e-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','75050c84-472e-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','7518967b-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','752f790c-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','752f81ce-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','7afad9a7-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','8d004c4c-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','8d6c0c7f-472f-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','8f294605-472d-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','8f295e9f-472d-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','9f67da47-472e-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','9f67fba8-472e-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','a371ae07-472e-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','a371b40d-472e-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','aec5de2b-472d-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','aec5e1df-472d-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','d307c24c-472d-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','d307d730-472d-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','dc89b09c-472d-11ee-9ed6-a86daa000811'),(196,'8dd5fa60-472f-11ee-9ed6-a86daa000811','dc89b419-472d-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','5db2bca1-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','5db2e560-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','60d87a10-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','60d87eeb-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','82922060-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','829236d7-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','88c6076b-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','88c617fa-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','8a8756dc-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','ab635311-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','ab63684c-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','cd73cb1b-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','cd958524-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','cd958907-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','cd95da08-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','cdb0666a-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','cdb06c83-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','cdef9140-4729-11ee-9ed6-a86daa000811'),(196,'d9cf4781-4729-11ee-9ed6-a86daa000811','d96cdd79-4729-11ee-9ed6-a86daa000811');
/*!40000 ALTER TABLE `SentAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentMessage`
--

DROP TABLE IF EXISTS `SentMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `discussionId` varchar(36) NOT NULL,
  `subject` varchar(45) NOT NULL,
  `body` text,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `SentMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SentMessage_ibfk_2` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentMessage`
--

LOCK TABLES `SentMessage` WRITE;
/*!40000 ALTER TABLE `SentMessage` DISABLE KEYS */;
INSERT INTO `SentMessage` VALUES ('0b67d55d-472a-11ee-9ed6-a86daa000811',196,'ecca179e-4728-11ee-9ed6-a86daa000811','#','avec fichiers','2023-08-30 13:40:40.000',NULL,'2023-08-30 13:40:40.000','2023-08-30 11:45:58.088','2023-08-30 13:45:58.088'),('25fa8f1b-472c-11ee-9ed6-a86daa000811',196,'ecca179e-4728-11ee-9ed6-a86daa000811','#','Commande n° 1.1.3.1','2023-08-30 13:55:45.000',NULL,'2023-08-30 13:55:45.000','2023-08-30 11:55:47.221','2023-08-30 13:55:47.221'),('3bb156aa-472b-11ee-9ed6-a86daa000811',196,'ecca179e-4728-11ee-9ed6-a86daa000811','#','Commande n° 1.1.2.1','2023-08-30 13:49:14.000',NULL,'2023-08-30 13:49:14.000','2023-08-30 11:54:08.911','2023-08-30 13:54:08.911'),('49ee16f2-472d-11ee-9ed6-a86daa000811',196,'ecca179e-4728-11ee-9ed6-a86daa000811','#','Commande n° 1.1.4.1','2023-08-30 14:03:56.000',NULL,'2023-08-30 14:03:56.000','2023-08-30 12:03:57.497','2023-08-30 14:03:57.497'),('8dd5fa60-472f-11ee-9ed6-a86daa000811',196,'ecca179e-4728-11ee-9ed6-a86daa000811','#','Commande n° 1.1.5.1','2023-08-30 14:20:10.000',NULL,'2023-08-30 14:20:10.000','2023-08-30 12:20:14.221','2023-08-30 14:20:14.221'),('d9cf4781-4729-11ee-9ed6-a86daa000811',196,'ecca179e-4728-11ee-9ed6-a86daa000811','#','Commande n° 1.1.1.1','2023-08-30 13:39:19.000',NULL,'2023-08-30 13:39:19.000','2023-08-30 11:45:58.218','2023-08-30 13:45:58.218'),('ecca814d-4728-11ee-9ed6-a86daa000811',196,'ecca179e-4728-11ee-9ed6-a86daa000811','#','test sans fichier','2023-08-30 13:32:39.000',NULL,'2023-08-30 13:32:39.000','2023-08-30 11:45:58.243','2023-08-30 13:45:58.243');
/*!40000 ALTER TABLE `SentMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentOrderNotification`
--

DROP TABLE IF EXISTS `SentOrderNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentOrderNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) DEFAULT NULL,
  `rescueData` text,
  `deliveryDate` datetime(3) DEFAULT NULL,
  `event` enum('EDITED','VALIDATED','CANCELLED') NOT NULL DEFAULT 'EDITED',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `SentOrderNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SentOrderNotification_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SentOrderNotification_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentOrderNotification`
--

LOCK TABLES `SentOrderNotification` WRITE;
/*!40000 ALTER TABLE `SentOrderNotification` DISABLE KEYS */;
INSERT INTO `SentOrderNotification` VALUES ('2119f423-f0a1-4126-bfbc-142e3542bdaf',196,'35ad590e-4728-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b','{\"recipientDisplayName\":\"l\\u00e9ger client\",\"patientDisplayID\":\"1.1\",\"orderTitle\":\"Commande n\\u00b0 1.1.1.1\"}','2023-09-03 00:00:00.000','VALIDATED',1,'2023-08-30 13:39:37.000',NULL,'2023-08-30 11:39:39.670','2023-08-30 13:39:39.670'),('40f166cb-375c-4138-beed-0f7309a6d7a2',196,'61d0939c-472b-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b','{\"recipientDisplayName\":\"l\\u00e9ger client\",\"patientDisplayID\":\"1.1\",\"orderTitle\":\"Commande n\\u00b0 1.1.3.1\"}','2023-09-03 00:00:00.000','VALIDATED',1,'2023-08-30 13:56:07.000',NULL,'2023-08-30 11:56:09.104','2023-08-30 13:56:09.104'),('7c729a85-40da-452b-87e3-e51923d6e9fd',196,'6832b9c0-472d-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b','{\"recipientDisplayName\":\"l\\u00e9ger client\",\"patientDisplayID\":\"1.1\",\"orderTitle\":\"Commande n\\u00b0 1.1.5.1\"}','2023-09-03 00:00:00.000','VALIDATED',1,'2023-08-30 14:21:20.000',NULL,'2023-08-30 12:21:22.496','2023-08-30 14:21:22.496'),('829da81f-fbf8-44f6-ab1d-d5d2504a31b7',196,'3bd790d4-472d-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b','{\"recipientDisplayName\":\"l\\u00e9ger client\",\"patientDisplayID\":\"1.1\",\"orderTitle\":\"Commande n\\u00b0 1.1.4.1\"}','2023-09-03 00:00:00.000','CANCELLED',1,'2023-08-30 14:21:06.000',NULL,'2023-08-30 12:21:06.455','2023-08-30 14:21:06.455'),('906706a8-31ec-48f3-be83-746c539b3afe',196,'989dfa08-472a-11ee-9ed6-a86daa000811','27ff53b3-e59f-422d-97d1-d9d4246c950b','{\"recipientDisplayName\":\"l\\u00e9ger client\",\"patientDisplayID\":\"1.1\",\"orderTitle\":\"Commande n\\u00b0 1.1.2.1\"}','2023-09-01 00:00:00.000','EDITED',1,'2023-08-30 13:49:27.000',NULL,'2023-08-30 11:49:28.758','2023-08-30 13:49:28.758');
/*!40000 ALTER TABLE `SentOrderNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Session`
--

DROP TABLE IF EXISTS `Session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Session` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL,
  `actId` varchar(36) NOT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `Session_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Session_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Session`
--

LOCK TABLES `Session` WRITE;
/*!40000 ALTER TABLE `Session` DISABLE KEYS */;
INSERT INTO `Session` VALUES ('35abe11d-4728-11ee-9ed6-a86daa000811',196,'35aa76b0-4728-11ee-9ed6-a86daa000811',1,0,'','2023-08-30 13:27:31.978',NULL,'2023-08-30 13:27:31.981','2023-08-30 11:27:31.981','2023-08-30 13:27:31.987'),('3fea1de6-472c-11ee-9ed6-a86daa000811',196,'3fe9ba1b-472c-11ee-9ed6-a86daa000811',1,0,'','2023-08-30 13:56:27.150',NULL,'2023-08-30 13:56:27.151','2023-08-30 12:03:20.920','2023-08-30 14:03:21.166'),('61cf451e-472b-11ee-9ed6-a86daa000811',196,'61ce0aa4-472b-11ee-9ed6-a86daa000811',1,0,'','2023-08-30 13:50:14.520',NULL,'2023-08-30 13:50:14.523','2023-08-30 11:50:14.522','2023-08-30 13:50:14.528'),('68317146-472d-11ee-9ed6-a86daa000811',196,'68303344-472d-11ee-9ed6-a86daa000811',1,0,'','2023-08-30 14:04:44.223',NULL,'2023-08-30 14:04:44.226','2023-08-30 12:04:44.226','2023-08-30 14:04:44.231'),('989d6f5f-472a-11ee-9ed6-a86daa000811',196,'989c88f2-472a-11ee-9ed6-a86daa000811',1,0,'','2023-08-30 13:44:36.971',NULL,'2023-08-30 13:44:36.972','2023-08-30 11:44:36.972','2023-08-30 13:44:36.975'),('f26a478b-472f-11ee-9ed6-a86daa000811',196,'f2691117-472f-11ee-9ed6-a86daa000811',1,0,'','2023-08-30 14:22:55.115',NULL,'2023-08-30 14:22:55.118','2023-08-30 12:22:55.117','2023-08-30 14:22:55.123');
/*!40000 ALTER TABLE `Session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrder`
--

DROP TABLE IF EXISTS `SmilersOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_SMILERS_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `SmilersOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrder`
--

LOCK TABLES `SmilersOrder` WRITE;
/*!40000 ALTER TABLE `SmilersOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrderFile`
--

DROP TABLE IF EXISTS `SmilersOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrderFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SmilersOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `SmilersOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrderFile`
--

LOCK TABLES `SmilersOrderFile` WRITE;
/*!40000 ALTER TABLE `SmilersOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SyncInfo`
--

DROP TABLE IF EXISTS `SyncInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SyncInfo` (
  `id` mediumint unsigned NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientsLastRetrieved` datetime(3) DEFAULT NULL,
  `actsLastRetrieved` datetime(3) DEFAULT NULL,
  `sessionsLastRetrieved` datetime(3) DEFAULT NULL,
  `scansLastRetrieved` datetime(3) DEFAULT NULL,
  `ordersLastRetrieved` datetime(3) DEFAULT NULL,
  `assistantsLastRetrieved` datetime(3) DEFAULT NULL,
  `contactsLastRetrieved` datetime(3) DEFAULT NULL,
  `discussionsLastRetrieved` datetime(3) DEFAULT NULL,
  `messagesLastRetrieved` datetime(3) DEFAULT NULL,
  `notificationsLastRetrieved` datetime(3) DEFAULT NULL,
  `occlusionsLastRetrieved` datetime(3) DEFAULT NULL,
  `circleordersLastRetrieved` datetime(3) DEFAULT NULL,
  `smilersordersLastRetrieved` datetime(3) DEFAULT NULL,
  `prostheticSheetsLastRetrieved` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SyncInfo`
--

LOCK TABLES `SyncInfo` WRITE;
/*!40000 ALTER TABLE `SyncInfo` DISABLE KEYS */;
INSERT INTO `SyncInfo` VALUES (1,196,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-08-30 11:24:32.525'),(1,197,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-08-30 11:28:36.446');
/*!40000 ALTER TABLE `SyncInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SystemNotification`
--

DROP TABLE IF EXISTS `SystemNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SystemNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `event` enum('NO_CONNECTION_FOR_X_DAYS') NOT NULL DEFAULT 'NO_CONNECTION_FOR_X_DAYS',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `SystemNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SystemNotification`
--

LOCK TABLES `SystemNotification` WRITE;
/*!40000 ALTER TABLE `SystemNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SystemNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Token`
--

DROP TABLE IF EXISTS `Token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Token` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `token` char(200) NOT NULL,
  `context` char(40) DEFAULT NULL,
  `device` char(255) DEFAULT NULL,
  `created` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `token` (`token`),
  KEY `credentialsId` (`credentialsId`),
  CONSTRAINT `Token_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Token`
--

LOCK TABLES `Token` WRITE;
/*!40000 ALTER TABLE `Token` DISABLE KEYS */;
INSERT INTO `Token` VALUES ('13b4ab42-4729-11ee-9ed6-a86daa000811',196,'53a5f2ba-3eaf-4bc8-b922-c2319948ddd4','9dc061985b64ff642b44d1de152b21f82c15c995','software','CondorScan','2023-08-30 13:33:44.490','2023-08-30 11:33:44.490'),('18d8f7a4-4728-11ee-9ed6-a86daa000811',196,'53a5f2ba-3eaf-4bc8-b922-c2319948ddd4','6ddee9f193daa646c79f8faf0907303847f12b6f','software','CondorScan','2023-08-30 13:26:43.620','2023-08-30 11:26:43.620'),('ca65aa14-4727-11ee-ab4d-a86daa000811',196,'53a5f2ba-3eaf-4bc8-b922-c2319948ddd4','065bca83d1a961387a00999968957b69ea1a7d90','software','CondorScan','2023-08-30 13:24:32.001','2023-08-30 11:24:32.532');
/*!40000 ALTER TABLE `Token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `versionMajor` int NOT NULL,
  `versionMinor` int NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_wow_application_1.0_create_wow_application'),(2,1,1,'v1.1','migration_wow_application_1.1_occlusion_pap'),(3,1,2,'v1.2','migration_wow_application_1.2_occlusion_pre_preparation'),(4,1,3,'v1.3','migration_wow_application_1.3_occlusion_rework'),(5,1,4,'v1.4','migration_wow_application_1.4_scan_label'),(6,1,5,'v1.5','migration_wow_application_1.5_order_delivery'),(7,1,6,'v1.6','migration_wow_application_1.6_sheet_json'),(8,1,7,'v1.7','migration_wow_application_1.7_config_patient_list');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'wow_application'
--
/*!50003 DROP FUNCTION IF EXISTS `fileMetadataToLabel` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `fileMetadataToLabel`(metadata TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF metadata LIKE '%scanBodies%' THEN RETURN 'SCANBODY'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewOcclusionFileType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewOcclusionFileType`(oldType TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF oldType = 'OCCLUSION_RESULT' THEN RETURN 'RESULT'; END IF;

    IF oldType = 'MANDIBULE_PLY' THEN RETURN 'MANDIBLE'; END IF;

    IF oldType = 'MAXILLAIRE_PLY' THEN RETURN 'MAXILLARY'; END IF;

    IF oldType = 'MANDIBULE_MATRIX' THEN RETURN 'MANDIBLE_MATRIX'; END IF;

    IF oldType = 'MAXILLAIRE_MATRIX' THEN RETURN 'MAXILLARY_MATRIX'; END IF;

    IF oldType = 'LIFIMETA' THEN RETURN 'LIFIMETA'; END IF;

    IF oldType = 'LIFI' THEN RETURN 'LIFI'; END IF;

    IF oldType = 'SNAPSHOT' THEN RETURN 'SNAPSHOT'; END IF;

    IF oldType = 'SCREENSHOT' THEN RETURN 'SCREENSHOT'; END IF;

    
    IF oldType = 'LEFT_BITE' THEN RETURN 'RESULT'; END IF;
    IF oldType = 'RIGHT_BITE' THEN RETURN 'RESULT'; END IF;
    IF oldType = 'ANTERIOR_BITE' THEN RETURN 'RESULT'; END IF;

    RETURN oldType;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticContactPoint` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticContactPoint`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '2' THEN RETURN 0; END IF;
    IF old = '3' THEN RETURN 1; END IF;
    IF old = '4' THEN RETURN 2; END IF;
    RETURN 1;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticCrownOrBridgeSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticCrownOrBridgeSubType`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    IF old = '3' THEN RETURN 2; END IF;
    RETURN 0;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticGouttiereSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticGouttiereSubType`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 1; END IF;
    IF old = '2' THEN RETURN 2; END IF;
    IF old = '3' THEN RETURN 3; END IF;
    IF old = '4' THEN RETURN 0; END IF;
    IF old = '5' THEN RETURN 4; END IF;
    IF old = '6' THEN RETURN 5; END IF;
    IF old = '7' THEN RETURN 6; END IF;
    RETURN 0;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticImplantCrownSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticImplantCrownSubType`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    IF old = '3' THEN RETURN 0; END IF;
    IF old = '4' THEN RETURN 1; END IF;
    RETURN 2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticInlayOnlaySubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticInlayOnlaySubType`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    RETURN 2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `scanMetadataToLabel` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `scanMetadataToLabel`(metadata TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF metadata LIKE '%"isPrePreparation":true%' THEN RETURN 'PRE_PREPARATION'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-08-30 14:34:15
